/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

/// ResponsesHostGroupV1 : A host group which targets a set of devices either through a dynamic assignment rule or a static set of hosts

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ResponsesHostGroupV1 {
    /// The assignment rule of a group
    #[serde(rename = "assignment_rule", skip_serializing_if = "Option::is_none")]
    pub assignment_rule: Option<String>,
    /// The email of the user which created the policy
    #[serde(rename = "created_by")]
    pub created_by: String,
    /// The time at which the policy was created
    #[serde(rename = "created_timestamp")]
    pub created_timestamp: String,
    /// An additional description of the group or the devices it targets
    #[serde(rename = "description")]
    pub description: String,
    /// The method by which this host group is managed
    #[serde(rename = "group_type", skip_serializing_if = "Option::is_none")]
    pub group_type: Option<GroupType>,
    /// The identifier of this host group
    #[serde(rename = "id")]
    pub id: String,
    /// The email of the user which last modified the policy
    #[serde(rename = "modified_by")]
    pub modified_by: String,
    /// The time at which the policy was last modified
    #[serde(rename = "modified_timestamp")]
    pub modified_timestamp: String,
    /// The name of the group
    #[serde(rename = "name")]
    pub name: String,
}

impl ResponsesHostGroupV1 {
    /// A host group which targets a set of devices either through a dynamic assignment rule or a static set of hosts
    pub fn new(created_by: String, created_timestamp: String, description: String, id: String, modified_by: String, modified_timestamp: String, name: String) -> ResponsesHostGroupV1 {
        ResponsesHostGroupV1 {
            assignment_rule: None,
            created_by,
            created_timestamp,
            description,
            group_type: None,
            id,
            modified_by,
            modified_timestamp,
            name,
        }
    }
}

/// The method by which this host group is managed
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum GroupType {
    #[serde(rename = "static")]
    _Static,
    #[serde(rename = "dynamic")]
    Dynamic,
}

impl Default for GroupType {
    fn default() -> GroupType {
        Self::_Static
    }
}
