/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsesDeviceControlPolicyClassSettingsV1 {
    /// Policy action
    #[serde(rename = "action")]
    pub action: Action,
    /// Exceptions to the rules of this policy setting
    #[serde(rename = "exceptions")]
    pub exceptions: Vec<crate::models::ResponsesDeviceControlPolicyExceptionV1>,
    /// USB Class id
    #[serde(rename = "id")]
    pub id: String,
}

impl ResponsesDeviceControlPolicyClassSettingsV1 {
    pub fn new(action: Action, exceptions: Vec<crate::models::ResponsesDeviceControlPolicyExceptionV1>, id: String) -> ResponsesDeviceControlPolicyClassSettingsV1 {
        ResponsesDeviceControlPolicyClassSettingsV1 { action, exceptions, id }
    }
}

/// Policy action
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Action {
    #[serde(rename = "FULL_ACCESS")]
    FULLACCESS,
    #[serde(rename = "FULL_BLOCK")]
    FULLBLOCK,
    #[serde(rename = "READ_ONLY")]
    READONLY,
}

impl Default for Action {
    fn default() -> Action {
        Self::FULLACCESS
    }
}
