/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct RequestsIoaExclusionCreateReqV1 {
    #[serde(rename = "cl_regex")]
    pub cl_regex: String,
    #[serde(rename = "comment", skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    #[serde(rename = "description")]
    pub description: String,
    #[serde(rename = "detection_json")]
    pub detection_json: String,
    #[serde(rename = "groups")]
    pub groups: Vec<String>,
    #[serde(rename = "ifn_regex")]
    pub ifn_regex: String,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "pattern_id")]
    pub pattern_id: String,
    #[serde(rename = "pattern_name")]
    pub pattern_name: String,
}

impl RequestsIoaExclusionCreateReqV1 {
    pub fn new(cl_regex: String, description: String, detection_json: String, groups: Vec<String>, ifn_regex: String, name: String, pattern_id: String, pattern_name: String) -> RequestsIoaExclusionCreateReqV1 {
        RequestsIoaExclusionCreateReqV1 {
            cl_regex,
            comment: None,
            description,
            detection_json,
            groups,
            ifn_regex,
            name,
            pattern_id,
            pattern_name,
        }
    }
}
