/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct QuarantineQuarantinedFile {
    #[serde(rename = "aid", skip_serializing_if = "Option::is_none")]
    pub aid: Option<String>,
    #[serde(rename = "cid", skip_serializing_if = "Option::is_none")]
    pub cid: Option<String>,
    #[serde(rename = "date_created", skip_serializing_if = "Option::is_none")]
    pub date_created: Option<String>,
    #[serde(rename = "date_updated", skip_serializing_if = "Option::is_none")]
    pub date_updated: Option<String>,
    #[serde(rename = "detect_ids", skip_serializing_if = "Option::is_none")]
    pub detect_ids: Option<Vec<String>>,
    #[serde(rename = "extracted", skip_serializing_if = "Option::is_none")]
    pub extracted: Option<bool>,
    #[serde(rename = "hostname", skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "paths", skip_serializing_if = "Option::is_none")]
    pub paths: Option<Vec<crate::models::QuarantineQuarantinedFilePath>>,
    #[serde(rename = "primary_module", skip_serializing_if = "Option::is_none")]
    pub primary_module: Option<bool>,
    #[serde(rename = "sandbox_report_id", skip_serializing_if = "Option::is_none")]
    pub sandbox_report_id: Option<String>,
    #[serde(rename = "sandbox_report_state", skip_serializing_if = "Option::is_none")]
    pub sandbox_report_state: Option<String>,
    #[serde(rename = "sha256", skip_serializing_if = "Option::is_none")]
    pub sha256: Option<String>,
    #[serde(rename = "state", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "username", skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
}

impl QuarantineQuarantinedFile {
    pub fn new() -> QuarantineQuarantinedFile {
        QuarantineQuarantinedFile {
            aid: None,
            cid: None,
            date_created: None,
            date_updated: None,
            detect_ids: None,
            extracted: None,
            hostname: None,
            id: None,
            paths: None,
            primary_module: None,
            sandbox_report_id: None,
            sandbox_report_state: None,
            sha256: None,
            state: None,
            username: None,
        }
    }
}
