/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ModelsAwsAccountRequestV1 {
    /// The 12 digit AWS account which is hosting the S3 bucket containing cloudtrail logs for this account. If this field is set, it takes precedence of the settings level field.
    #[serde(rename = "cloudtrail_bucket_owner_id", skip_serializing_if = "Option::is_none")]
    pub cloudtrail_bucket_owner_id: Option<String>,
    /// Region where the S3 bucket containing cloudtrail logs resides.
    #[serde(rename = "cloudtrail_bucket_region", skip_serializing_if = "Option::is_none")]
    pub cloudtrail_bucket_region: Option<String>,
    /// ID assigned for use with cross account IAM role access.
    #[serde(rename = "external_id", skip_serializing_if = "Option::is_none")]
    pub external_id: Option<String>,
    /// The full arn of the IAM role created in this account to control access.
    #[serde(rename = "iam_role_arn", skip_serializing_if = "Option::is_none")]
    pub iam_role_arn: Option<String>,
    /// 12 digit AWS provided unique identifier for the account.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Rate limiting setting to control the maximum number of requests that can be made within the rate_limit_time threshold.
    #[serde(rename = "rate_limit_reqs", skip_serializing_if = "Option::is_none")]
    pub rate_limit_reqs: Option<i32>,
    /// Rate limiting setting to control the number of seconds for which rate_limit_reqs applies.
    #[serde(rename = "rate_limit_time", skip_serializing_if = "Option::is_none")]
    pub rate_limit_time: Option<i64>,
}

impl ModelsAwsAccountRequestV1 {
    pub fn new() -> ModelsAwsAccountRequestV1 {
        ModelsAwsAccountRequestV1 {
            cloudtrail_bucket_owner_id: None,
            cloudtrail_bucket_region: None,
            external_id: None,
            iam_role_arn: None,
            id: None,
            rate_limit_reqs: None,
            rate_limit_time: None,
        }
    }
}
