/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct MalqueryFuzzySearchMetaInfo {
    #[serde(rename = "pagination", skip_serializing_if = "Option::is_none")]
    pub pagination: Option<Box<crate::models::MsaPaging>>,
    #[serde(rename = "powered_by", skip_serializing_if = "Option::is_none")]
    pub powered_by: Option<String>,
    /// Elapsed time since the request started in seconds
    #[serde(rename = "query_time", skip_serializing_if = "Option::is_none")]
    pub query_time: Option<f64>,
    /// Request ID returned after creating a hunt or exact search
    #[serde(rename = "reqid", skip_serializing_if = "Option::is_none")]
    pub reqid: Option<String>,
    #[serde(rename = "stats", skip_serializing_if = "Option::is_none")]
    pub stats: Option<Box<crate::models::MalqueryStats>>,
    /// Request status. Possible values: inprogress, failed, done
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "trace_id")]
    pub trace_id: String,
    #[serde(rename = "writes", skip_serializing_if = "Option::is_none")]
    pub writes: Option<Box<crate::models::MsaResources>>,
}

impl MalqueryFuzzySearchMetaInfo {
    pub fn new(trace_id: String) -> MalqueryFuzzySearchMetaInfo {
        MalqueryFuzzySearchMetaInfo {
            pagination: None,
            powered_by: None,
            query_time: None,
            reqid: None,
            stats: None,
            status: None,
            trace_id,
            writes: None,
        }
    }
}
