/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct MalqueryExternalHuntOptions {
    /// Limit results to files of certain types such as EMAIL, PCAP, PDF, PE32. Full list can be found in the documentation
    #[serde(rename = "filter_filetypes", skip_serializing_if = "Option::is_none")]
    pub filter_filetypes: Option<Vec<String>>,
    /// Specify a subset of metadata fields to return in the results. Possible values: sha256, md5, type, size, first_seen, label, family
    #[serde(rename = "filter_meta", skip_serializing_if = "Option::is_none")]
    pub filter_meta: Option<Vec<String>>,
    /// Maximum number of results to be returned
    #[serde(rename = "limit", skip_serializing_if = "Option::is_none")]
    pub limit: Option<i32>,
    /// Limit results to files first seen before this date. The format is YYYY/MM/DD
    #[serde(rename = "max_date", skip_serializing_if = "Option::is_none")]
    pub max_date: Option<String>,
    /// Maximum file size. The value can be specified either in bytes or in multiples of KB/MB/GB. Examples: 128000, 1.3 KB, 8mb
    #[serde(rename = "max_size", skip_serializing_if = "Option::is_none")]
    pub max_size: Option<String>,
    /// Limit results to files first seen after this date. The format is YYYY/MM/DD
    #[serde(rename = "min_date", skip_serializing_if = "Option::is_none")]
    pub min_date: Option<String>,
    /// Minimum file size. The value can be specified either in bytes or in multiples of KB/MB/GB. Examples: 128000, 1.3 KB, 8mb
    #[serde(rename = "min_size", skip_serializing_if = "Option::is_none")]
    pub min_size: Option<String>,
}

impl MalqueryExternalHuntOptions {
    pub fn new() -> MalqueryExternalHuntOptions {
        MalqueryExternalHuntOptions {
            filter_filetypes: None,
            filter_meta: None,
            limit: None,
            max_date: None,
            max_size: None,
            min_date: None,
            min_size: None,
        }
    }
}
