/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct K8sregAwsAccountResp {
    #[serde(rename = "account_id")]
    pub account_id: String,
    #[serde(rename = "aws_permissions_status")]
    pub aws_permissions_status: Vec<crate::models::K8sregAwsAccountPermissionsStatus>,
    #[serde(rename = "cid")]
    pub cid: String,
    #[serde(rename = "cloudformation_url", skip_serializing_if = "Option::is_none")]
    pub cloudformation_url: Option<String>,
    #[serde(rename = "created_at")]
    pub created_at: String,
    #[serde(rename = "from_cspm")]
    pub from_cspm: bool,
    #[serde(rename = "iam_role_arn")]
    pub iam_role_arn: String,
    #[serde(rename = "is_master")]
    pub is_master: bool,
    #[serde(rename = "organization_id", skip_serializing_if = "Option::is_none")]
    pub organization_id: Option<String>,
    #[serde(rename = "region", skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "status")]
    pub status: String,
    #[serde(rename = "updated_at")]
    pub updated_at: String,
}

impl K8sregAwsAccountResp {
    pub fn new(account_id: String, aws_permissions_status: Vec<crate::models::K8sregAwsAccountPermissionsStatus>, cid: String, created_at: String, from_cspm: bool, iam_role_arn: String, is_master: bool, status: String, updated_at: String) -> K8sregAwsAccountResp {
        K8sregAwsAccountResp {
            account_id,
            aws_permissions_status,
            cid,
            cloudformation_url: None,
            created_at,
            from_cspm,
            iam_role_arn,
            is_master,
            organization_id: None,
            region: None,
            status,
            updated_at,
        }
    }
}
