/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FwmgrFirewallRuleV1 {
    #[serde(rename = "action")]
    pub action: String,
    #[serde(rename = "address_family")]
    pub address_family: String,
    #[serde(rename = "created_by")]
    pub created_by: String,
    #[serde(rename = "created_on")]
    pub created_on: String,
    #[serde(rename = "customer_id", skip_serializing_if = "Option::is_none")]
    pub customer_id: Option<String>,
    #[serde(rename = "deleted")]
    pub deleted: bool,
    #[serde(rename = "description")]
    pub description: String,
    #[serde(rename = "direction")]
    pub direction: String,
    #[serde(rename = "enabled")]
    pub enabled: bool,
    #[serde(rename = "family")]
    pub family: String,
    #[serde(rename = "fields")]
    pub fields: Vec<crate::models::FwmgrFirewallFieldValue>,
    #[serde(rename = "icmp")]
    pub icmp: Box<crate::models::FwmgrFirewallIcmp>,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "local_address")]
    pub local_address: Vec<crate::models::FwmgrFirewallAddressRange>,
    #[serde(rename = "local_port")]
    pub local_port: Vec<crate::models::FwmgrFirewallPortRange>,
    #[serde(rename = "modified_by", skip_serializing_if = "Option::is_none")]
    pub modified_by: Option<String>,
    #[serde(rename = "modified_on", skip_serializing_if = "Option::is_none")]
    pub modified_on: Option<String>,
    #[serde(rename = "monitor")]
    pub monitor: Box<crate::models::FwmgrFirewallMonitoring>,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "platform_ids")]
    pub platform_ids: Vec<String>,
    #[serde(rename = "protocol")]
    pub protocol: String,
    #[serde(rename = "remote_address")]
    pub remote_address: Vec<crate::models::FwmgrFirewallAddressRange>,
    #[serde(rename = "remote_port")]
    pub remote_port: Vec<crate::models::FwmgrFirewallPortRange>,
    #[serde(rename = "rule_group")]
    pub rule_group: Box<crate::models::FwmgrFirewallRuleGroupSummaryV1>,
    #[serde(rename = "version")]
    pub version: i64,
}

impl FwmgrFirewallRuleV1 {
    pub fn new(
        action: String,
        address_family: String,
        created_by: String,
        created_on: String,
        deleted: bool,
        description: String,
        direction: String,
        enabled: bool,
        family: String,
        fields: Vec<crate::models::FwmgrFirewallFieldValue>,
        icmp: crate::models::FwmgrFirewallIcmp,
        id: String,
        local_address: Vec<crate::models::FwmgrFirewallAddressRange>,
        local_port: Vec<crate::models::FwmgrFirewallPortRange>,
        monitor: crate::models::FwmgrFirewallMonitoring,
        name: String,
        platform_ids: Vec<String>,
        protocol: String,
        remote_address: Vec<crate::models::FwmgrFirewallAddressRange>,
        remote_port: Vec<crate::models::FwmgrFirewallPortRange>,
        rule_group: crate::models::FwmgrFirewallRuleGroupSummaryV1,
        version: i64,
    ) -> FwmgrFirewallRuleV1 {
        FwmgrFirewallRuleV1 {
            action,
            address_family,
            created_by,
            created_on,
            customer_id: None,
            deleted,
            description,
            direction,
            enabled,
            family,
            fields,
            icmp: Box::new(icmp),
            id,
            local_address,
            local_port,
            modified_by: None,
            modified_on: None,
            monitor: Box::new(monitor),
            name,
            platform_ids,
            protocol,
            remote_address,
            remote_port,
            rule_group: Box::new(rule_group),
            version,
        }
    }
}
