/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FwmgrApiRuleCreateRequestV1 {
    #[serde(rename = "action")]
    pub action: String,
    #[serde(rename = "address_family")]
    pub address_family: String,
    #[serde(rename = "description")]
    pub description: String,
    #[serde(rename = "direction")]
    pub direction: String,
    #[serde(rename = "enabled")]
    pub enabled: bool,
    #[serde(rename = "fields")]
    pub fields: Vec<crate::models::FwmgrApiWorkaroundUiFieldValue>,
    #[serde(rename = "icmp")]
    pub icmp: Box<crate::models::FwmgrDomainIcmp>,
    #[serde(rename = "local_address")]
    pub local_address: Vec<crate::models::FwmgrDomainAddressRange>,
    #[serde(rename = "local_port")]
    pub local_port: Vec<crate::models::FwmgrDomainPortRange>,
    #[serde(rename = "log")]
    pub log: bool,
    #[serde(rename = "monitor")]
    pub monitor: Box<crate::models::FwmgrDomainMonitoring>,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "platform_ids")]
    pub platform_ids: Vec<String>,
    #[serde(rename = "protocol")]
    pub protocol: String,
    #[serde(rename = "remote_address")]
    pub remote_address: Vec<crate::models::FwmgrDomainAddressRange>,
    #[serde(rename = "remote_port")]
    pub remote_port: Vec<crate::models::FwmgrDomainPortRange>,
    #[serde(rename = "temp_id")]
    pub temp_id: String,
}

impl FwmgrApiRuleCreateRequestV1 {
    pub fn new(
        action: String,
        address_family: String,
        description: String,
        direction: String,
        enabled: bool,
        fields: Vec<crate::models::FwmgrApiWorkaroundUiFieldValue>,
        icmp: crate::models::FwmgrDomainIcmp,
        local_address: Vec<crate::models::FwmgrDomainAddressRange>,
        local_port: Vec<crate::models::FwmgrDomainPortRange>,
        log: bool,
        monitor: crate::models::FwmgrDomainMonitoring,
        name: String,
        platform_ids: Vec<String>,
        protocol: String,
        remote_address: Vec<crate::models::FwmgrDomainAddressRange>,
        remote_port: Vec<crate::models::FwmgrDomainPortRange>,
        temp_id: String,
    ) -> FwmgrApiRuleCreateRequestV1 {
        FwmgrApiRuleCreateRequestV1 {
            action,
            address_family,
            description,
            direction,
            enabled,
            fields,
            icmp: Box::new(icmp),
            local_address,
            local_port,
            log,
            monitor: Box::new(monitor),
            name,
            platform_ids,
            protocol,
            remote_address,
            remote_port,
            temp_id,
        }
    }
}
