/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FalconxSandboxSummaryReportV1 {
    #[serde(rename = "classification_tags", skip_serializing_if = "Option::is_none")]
    pub classification_tags: Option<Vec<String>>,
    #[serde(rename = "environment_description", skip_serializing_if = "Option::is_none")]
    pub environment_description: Option<String>,
    #[serde(rename = "environment_id", skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<i32>,
    #[serde(rename = "error_message", skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "error_origin", skip_serializing_if = "Option::is_none")]
    pub error_origin: Option<String>,
    #[serde(rename = "error_type", skip_serializing_if = "Option::is_none")]
    pub error_type: Option<String>,
    #[serde(rename = "file_type", skip_serializing_if = "Option::is_none")]
    pub file_type: Option<String>,
    #[serde(rename = "incidents", skip_serializing_if = "Option::is_none")]
    pub incidents: Option<Vec<crate::models::FalconxIncident>>,
    #[serde(rename = "sample_flags", skip_serializing_if = "Option::is_none")]
    pub sample_flags: Option<Vec<String>>,
    #[serde(rename = "sha256", skip_serializing_if = "Option::is_none")]
    pub sha256: Option<String>,
    #[serde(rename = "submission_type", skip_serializing_if = "Option::is_none")]
    pub submission_type: Option<String>,
    #[serde(rename = "submit_name", skip_serializing_if = "Option::is_none")]
    pub submit_name: Option<String>,
    #[serde(rename = "submit_url", skip_serializing_if = "Option::is_none")]
    pub submit_url: Option<String>,
    #[serde(rename = "threat_score", skip_serializing_if = "Option::is_none")]
    pub threat_score: Option<i32>,
    #[serde(rename = "verdict", skip_serializing_if = "Option::is_none")]
    pub verdict: Option<String>,
}

impl FalconxSandboxSummaryReportV1 {
    pub fn new() -> FalconxSandboxSummaryReportV1 {
        FalconxSandboxSummaryReportV1 {
            classification_tags: None,
            environment_description: None,
            environment_id: None,
            error_message: None,
            error_origin: None,
            error_type: None,
            file_type: None,
            incidents: None,
            sample_flags: None,
            sha256: None,
            submission_type: None,
            submit_name: None,
            submit_url: None,
            threat_score: None,
            verdict: None,
        }
    }
}
