/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FalconxSandboxParametersV1 {
    #[serde(rename = "action_script", skip_serializing_if = "Option::is_none")]
    pub action_script: Option<String>,
    #[serde(rename = "command_line", skip_serializing_if = "Option::is_none")]
    pub command_line: Option<String>,
    #[serde(rename = "document_password", skip_serializing_if = "Option::is_none")]
    pub document_password: Option<String>,
    #[serde(rename = "enable_tor", skip_serializing_if = "Option::is_none")]
    pub enable_tor: Option<bool>,
    #[serde(rename = "environment_id", skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<i32>,
    #[serde(rename = "network_settings", skip_serializing_if = "Option::is_none")]
    pub network_settings: Option<String>,
    #[serde(rename = "sha256", skip_serializing_if = "Option::is_none")]
    pub sha256: Option<String>,
    #[serde(rename = "submit_name", skip_serializing_if = "Option::is_none")]
    pub submit_name: Option<String>,
    #[serde(rename = "system_date", skip_serializing_if = "Option::is_none")]
    pub system_date: Option<String>,
    #[serde(rename = "system_time", skip_serializing_if = "Option::is_none")]
    pub system_time: Option<String>,
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

impl FalconxSandboxParametersV1 {
    pub fn new() -> FalconxSandboxParametersV1 {
        FalconxSandboxParametersV1 {
            action_script: None,
            command_line: None,
            document_password: None,
            enable_tor: None,
            environment_id: None,
            network_settings: None,
            sha256: None,
            submit_name: None,
            system_date: None,
            system_time: None,
            url: None,
        }
    }
}
