/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FalconxHttpRequest {
    #[serde(rename = "header", skip_serializing_if = "Option::is_none")]
    pub header: Option<String>,
    #[serde(rename = "host", skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[serde(rename = "host_ip", skip_serializing_if = "Option::is_none")]
    pub host_ip: Option<String>,
    #[serde(rename = "host_port", skip_serializing_if = "Option::is_none")]
    pub host_port: Option<i32>,
    #[serde(rename = "method", skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[serde(rename = "response_code", skip_serializing_if = "Option::is_none")]
    pub response_code: Option<i32>,
    #[serde(rename = "response_phrase", skip_serializing_if = "Option::is_none")]
    pub response_phrase: Option<String>,
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

impl FalconxHttpRequest {
    pub fn new() -> FalconxHttpRequest {
        FalconxHttpRequest {
            header: None,
            host: None,
            host_ip: None,
            host_port: None,
            method: None,
            response_code: None,
            response_phrase: None,
            url: None,
        }
    }
}
