/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ExternalChange {
    #[serde(rename = "action_timestamp")]
    pub action_timestamp: String,
    /// Possible values: UNKNOWN, CREATE, WRITE, DELETE, SET, RENAME.
    #[serde(rename = "action_type")]
    pub action_type: String,
    #[serde(rename = "aid")]
    pub aid: String,
    #[serde(rename = "cid")]
    pub cid: String,
    #[serde(rename = "command_line")]
    pub command_line: String,
    #[serde(rename = "diff", skip_serializing_if = "Option::is_none")]
    pub diff: Option<Box<crate::models::ExternalDiff>>,
    #[serde(rename = "entity_path")]
    pub entity_path: String,
    #[serde(rename = "entity_path_new", skip_serializing_if = "Option::is_none")]
    pub entity_path_new: Option<String>,
    /// Possible values: UNKNOWN, FILE, DIR, REGKEY,  REGVAL.
    #[serde(rename = "entity_type")]
    pub entity_type: String,
    #[serde(rename = "host", skip_serializing_if = "Option::is_none")]
    pub host: Option<Box<crate::models::ExternalHost>>,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "ingestion_timestamp")]
    pub ingestion_timestamp: String,
    #[serde(rename = "is_suppressed")]
    pub is_suppressed: bool,
    #[serde(rename = "platform_name")]
    pub platform_name: String,
    #[serde(rename = "policy", skip_serializing_if = "Option::is_none")]
    pub policy: Option<Box<crate::models::ExternalPolicy>>,
    #[serde(rename = "process_id")]
    pub process_id: String,
    #[serde(rename = "process_image_file_name")]
    pub process_image_file_name: String,
    /// Possible values: UNKNOWN, LOW, MEDIUM, HIGH, CRITICAL
    #[serde(rename = "severity")]
    pub severity: String,
    #[serde(rename = "user_id")]
    pub user_id: String,
    #[serde(rename = "user_name")]
    pub user_name: String,
}

impl ExternalChange {
    pub fn new(
        action_timestamp: String,
        action_type: String,
        aid: String,
        cid: String,
        command_line: String,
        entity_path: String,
        entity_type: String,
        id: String,
        ingestion_timestamp: String,
        is_suppressed: bool,
        platform_name: String,
        process_id: String,
        process_image_file_name: String,
        severity: String,
        user_id: String,
        user_name: String,
    ) -> ExternalChange {
        ExternalChange {
            action_timestamp,
            action_type,
            aid,
            cid,
            command_line,
            diff: None,
            entity_path,
            entity_path_new: None,
            entity_type,
            host: None,
            id,
            ingestion_timestamp,
            is_suppressed,
            platform_name,
            policy: None,
            process_id,
            process_image_file_name,
            severity,
            user_id,
            user_name,
        }
    }
}
