/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainSignalProperties {
    #[serde(rename = "aid")]
    pub aid: String,
    #[serde(rename = "assessment")]
    pub assessment: Box<crate::models::DomainAssessment>,
    #[serde(rename = "assessment_items")]
    pub assessment_items: Box<crate::models::DomainAssessmentItems>,
    #[serde(rename = "cid")]
    pub cid: String,
    #[serde(rename = "event_platform")]
    pub event_platform: String,
    #[serde(rename = "modified_time")]
    pub modified_time: String,
    #[serde(rename = "product_type_desc")]
    pub product_type_desc: String,
    #[serde(rename = "sensor_file_status")]
    pub sensor_file_status: String,
    #[serde(rename = "system_serial_number")]
    pub system_serial_number: String,
}

impl DomainSignalProperties {
    pub fn new(
        aid: String,
        assessment: crate::models::DomainAssessment,
        assessment_items: crate::models::DomainAssessmentItems,
        cid: String,
        event_platform: String,
        modified_time: String,
        product_type_desc: String,
        sensor_file_status: String,
        system_serial_number: String,
    ) -> DomainSignalProperties {
        DomainSignalProperties {
            aid,
            assessment: Box::new(assessment),
            assessment_items: Box::new(assessment_items),
            cid,
            event_platform,
            modified_time,
            product_type_desc,
            sensor_file_status,
            system_serial_number,
        }
    }
}
