/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainResultMetadata {
    #[serde(rename = "execution_delay")]
    pub execution_delay: i64,
    #[serde(rename = "execution_duration")]
    pub execution_duration: i64,
    #[serde(rename = "execution_finish")]
    pub execution_finish: String,
    #[serde(rename = "execution_start")]
    pub execution_start: String,
    #[serde(rename = "queue_duration")]
    pub queue_duration: i64,
    #[serde(rename = "queue_start")]
    pub queue_start: String,
    #[serde(rename = "report_file_name")]
    pub report_file_name: String,
    #[serde(rename = "report_finish")]
    pub report_finish: String,
    #[serde(rename = "result_count")]
    pub result_count: i32,
    #[serde(rename = "result_id")]
    pub result_id: String,
    #[serde(rename = "search_window_end")]
    pub search_window_end: String,
    #[serde(rename = "search_window_start")]
    pub search_window_start: String,
}

impl DomainResultMetadata {
    pub fn new(
        execution_delay: i64,
        execution_duration: i64,
        execution_finish: String,
        execution_start: String,
        queue_duration: i64,
        queue_start: String,
        report_file_name: String,
        report_finish: String,
        result_count: i32,
        result_id: String,
        search_window_end: String,
        search_window_start: String,
    ) -> DomainResultMetadata {
        DomainResultMetadata {
            execution_delay,
            execution_duration,
            execution_finish,
            execution_start,
            queue_duration,
            queue_start,
            report_file_name,
            report_finish,
            result_count,
            result_id,
            search_window_end,
            search_window_start,
        }
    }
}
