/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainPolicyInfo {
    #[serde(rename = "CreatedAt")]
    pub created_at: String,
    #[serde(rename = "DeletedAt")]
    pub deleted_at: String,
    #[serde(rename = "ID")]
    pub ID: i32,
    #[serde(rename = "UpdatedAt")]
    pub updated_at: String,
    #[serde(rename = "alert_logic", skip_serializing_if = "Option::is_none")]
    pub alert_logic: Option<String>,
    #[serde(rename = "api_command", skip_serializing_if = "Option::is_none")]
    pub api_command: Option<String>,
    #[serde(rename = "cli_command", skip_serializing_if = "Option::is_none")]
    pub cli_command: Option<String>,
    #[serde(rename = "cloud_document", skip_serializing_if = "Option::is_none")]
    pub cloud_document: Option<String>,
    #[serde(rename = "cloud_platform", skip_serializing_if = "Option::is_none")]
    pub cloud_platform: Option<i32>,
    #[serde(rename = "cloud_platform_type", skip_serializing_if = "Option::is_none")]
    pub cloud_platform_type: Option<String>,
    #[serde(rename = "cloud_service", skip_serializing_if = "Option::is_none")]
    pub cloud_service: Option<i32>,
    #[serde(rename = "cloud_service_friendly", skip_serializing_if = "Option::is_none")]
    pub cloud_service_friendly: Option<String>,
    #[serde(rename = "cloud_service_subtype", skip_serializing_if = "Option::is_none")]
    pub cloud_service_subtype: Option<String>,
    #[serde(rename = "cloud_service_type", skip_serializing_if = "Option::is_none")]
    pub cloud_service_type: Option<String>,
    #[serde(rename = "default_severity", skip_serializing_if = "Option::is_none")]
    pub default_severity: Option<String>,
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "event_type", skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[serde(rename = "mitre_attack_cloud_matrix", skip_serializing_if = "Option::is_none")]
    pub mitre_attack_cloud_matrix: Option<String>,
    #[serde(rename = "mitre_attack_cloud_subtype", skip_serializing_if = "Option::is_none")]
    pub mitre_attack_cloud_subtype: Option<String>,
    #[serde(rename = "policy_fail_query", skip_serializing_if = "Option::is_none")]
    pub policy_fail_query: Option<String>,
    #[serde(rename = "policy_pass_query", skip_serializing_if = "Option::is_none")]
    pub policy_pass_query: Option<String>,
    #[serde(rename = "policy_remediation", skip_serializing_if = "Option::is_none")]
    pub policy_remediation: Option<String>,
    #[serde(rename = "policy_severity", skip_serializing_if = "Option::is_none")]
    pub policy_severity: Option<i32>,
    #[serde(rename = "policy_statement", skip_serializing_if = "Option::is_none")]
    pub policy_statement: Option<String>,
}

impl DomainPolicyInfo {
    pub fn new(created_at: String, deleted_at: String, ID: i32, updated_at: String) -> DomainPolicyInfo {
        DomainPolicyInfo {
            created_at,
            deleted_at,
            ID,
            updated_at,
            alert_logic: None,
            api_command: None,
            cli_command: None,
            cloud_document: None,
            cloud_platform: None,
            cloud_platform_type: None,
            cloud_service: None,
            cloud_service_friendly: None,
            cloud_service_subtype: None,
            cloud_service_type: None,
            default_severity: None,
            description: None,
            event_type: None,
            mitre_attack_cloud_matrix: None,
            mitre_attack_cloud_subtype: None,
            policy_fail_query: None,
            policy_pass_query: None,
            policy_remediation: None,
            policy_severity: None,
            policy_statement: None,
        }
    }
}
