/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainNewsDocument {
    #[serde(rename = "active", skip_serializing_if = "Option::is_none")]
    pub active: Option<bool>,
    #[serde(rename = "actors")]
    pub actors: Vec<crate::models::DomainSimpleActor>,
    #[serde(rename = "attachments", skip_serializing_if = "Option::is_none")]
    pub attachments: Option<Vec<crate::models::DomainFile>>,
    #[serde(rename = "created_date")]
    pub created_date: i64,
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "entitlements", skip_serializing_if = "Option::is_none")]
    pub entitlements: Option<Vec<crate::models::DomainEntity>>,
    #[serde(rename = "id")]
    pub id: i64,
    #[serde(rename = "image", skip_serializing_if = "Option::is_none")]
    pub image: Option<Box<crate::models::DomainImage>>,
    #[serde(rename = "last_modified_date")]
    pub last_modified_date: i64,
    #[serde(rename = "motivations")]
    pub motivations: Vec<crate::models::DomainEntity>,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "notify_users", skip_serializing_if = "Option::is_none")]
    pub notify_users: Option<bool>,
    #[serde(rename = "rich_text_description", skip_serializing_if = "Option::is_none")]
    pub rich_text_description: Option<String>,
    #[serde(rename = "short_description", skip_serializing_if = "Option::is_none")]
    pub short_description: Option<String>,
    #[serde(rename = "slug")]
    pub slug: String,
    #[serde(rename = "sub_type", skip_serializing_if = "Option::is_none")]
    pub sub_type: Option<Box<crate::models::DomainEntity>>,
    #[serde(rename = "tags")]
    pub tags: Vec<crate::models::DomainEntity>,
    #[serde(rename = "target_countries")]
    pub target_countries: Vec<crate::models::DomainEntity>,
    #[serde(rename = "target_industries")]
    pub target_industries: Vec<crate::models::DomainEntity>,
    #[serde(rename = "thumbnail")]
    pub thumbnail: Box<crate::models::DomainImage>,
    #[serde(rename = "topic", skip_serializing_if = "Option::is_none")]
    pub topic: Option<Box<crate::models::DomainEntity>>,
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<Box<crate::models::DomainEntity>>,
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

impl DomainNewsDocument {
    pub fn new(
        actors: Vec<crate::models::DomainSimpleActor>,
        created_date: i64,
        id: i64,
        last_modified_date: i64,
        motivations: Vec<crate::models::DomainEntity>,
        name: String,
        slug: String,
        tags: Vec<crate::models::DomainEntity>,
        target_countries: Vec<crate::models::DomainEntity>,
        target_industries: Vec<crate::models::DomainEntity>,
        thumbnail: crate::models::DomainImage,
    ) -> DomainNewsDocument {
        DomainNewsDocument {
            active: None,
            actors,
            attachments: None,
            created_date,
            description: None,
            entitlements: None,
            id,
            image: None,
            last_modified_date,
            motivations,
            name,
            notify_users: None,
            rich_text_description: None,
            short_description: None,
            slug,
            sub_type: None,
            tags,
            target_countries,
            target_industries,
            thumbnail: Box::new(thumbnail),
            topic: None,
            _type: None,
            url: None,
        }
    }
}
