/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainIoaEventAggregate {
    #[serde(rename = "cid_severity", skip_serializing_if = "Option::is_none")]
    pub cid_severity: Option<i32>,
    #[serde(rename = "confidence", skip_serializing_if = "Option::is_none")]
    pub confidence: Option<i32>,
    #[serde(rename = "count", skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "events", skip_serializing_if = "Option::is_none")]
    pub events: Option<Vec<String>>,
    #[serde(rename = "first_timestamp", skip_serializing_if = "Option::is_none")]
    pub first_timestamp: Option<String>,
    #[serde(rename = "join_keys", skip_serializing_if = "Option::is_none")]
    pub join_keys: Option<Vec<String>>,
    #[serde(rename = "last_timestamp", skip_serializing_if = "Option::is_none")]
    pub last_timestamp: Option<String>,
    #[serde(rename = "score", skip_serializing_if = "Option::is_none")]
    pub score: Option<i32>,
    #[serde(rename = "threatintel", skip_serializing_if = "Option::is_none")]
    pub threatintel: Option<Box<crate::models::DetectionAggregateThreatIntel>>,
    #[serde(rename = "timestamps", skip_serializing_if = "Option::is_none")]
    pub timestamps: Option<Vec<String>>,
}

impl DomainIoaEventAggregate {
    pub fn new() -> DomainIoaEventAggregate {
        DomainIoaEventAggregate {
            cid_severity: None,
            confidence: None,
            count: None,
            events: None,
            first_timestamp: None,
            join_keys: None,
            last_timestamp: None,
            score: None,
            threatintel: None,
            timestamps: None,
        }
    }
}
