/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainFileV2 {
    #[serde(rename = "cloud_request_id")]
    pub cloud_request_id: String,
    #[serde(rename = "complete")]
    pub complete: bool,
    #[serde(rename = "created_at")]
    pub created_at: String,
    #[serde(rename = "deleted_at")]
    pub deleted_at: String,
    #[serde(rename = "error_message")]
    pub error_message: String,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "progress")]
    pub progress: f32,
    #[serde(rename = "session_id")]
    pub session_id: String,
    #[serde(rename = "sha256")]
    pub sha256: String,
    #[serde(rename = "size")]
    pub size: i32,
    #[serde(rename = "stage")]
    pub stage: String,
    #[serde(rename = "status")]
    pub status: String,
    #[serde(rename = "updated_at")]
    pub updated_at: String,
}

impl DomainFileV2 {
    pub fn new(cloud_request_id: String, complete: bool, created_at: String, deleted_at: String, error_message: String, id: String, name: String, progress: f32, session_id: String, sha256: String, size: i32, stage: String, status: String, updated_at: String) -> DomainFileV2 {
        DomainFileV2 {
            cloud_request_id,
            complete,
            created_at,
            deleted_at,
            error_message,
            id,
            name,
            progress,
            session_id,
            sha256,
            size,
            stage,
            status,
            updated_at,
        }
    }
}
