/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

/// DomainDiscoverApiNetworkInterface : The local IPv4 address or addresses of the network interface associated with the asset over time.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainDiscoverApiNetworkInterface {
    /// The name or alias of the network interface associated with the asset.
    #[serde(rename = "interface_alias", skip_serializing_if = "Option::is_none")]
    pub interface_alias: Option<String>,
    /// The description of the network interface associated with the asset.
    #[serde(rename = "interface_description", skip_serializing_if = "Option::is_none")]
    pub interface_description: Option<String>,
    /// The local IPv4 address or addresses of the network interface associated with the asset over time
    #[serde(rename = "local_ip", skip_serializing_if = "Option::is_none")]
    pub local_ip: Option<String>,
    /// The MAC address of the network interface associated with the asset.
    #[serde(rename = "mac_address", skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    /// The prefix or prefixes of the network over time, made of the first two bytes of the IP address.
    #[serde(rename = "network_prefix", skip_serializing_if = "Option::is_none")]
    pub network_prefix: Option<String>,
}

impl DomainDiscoverApiNetworkInterface {
    /// The local IPv4 address or addresses of the network interface associated with the asset over time.
    pub fn new() -> DomainDiscoverApiNetworkInterface {
        DomainDiscoverApiNetworkInterface {
            interface_alias: None,
            interface_description: None,
            local_ip: None,
            mac_address: None,
            network_prefix: None,
        }
    }
}
