/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

/// DomainDiscoverApiLogin : Represents information about a successful or a failed login.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainDiscoverApiLogin {
    /// The ID of the account that made the login.
    #[serde(rename = "account_id", skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// The name of the account that made the login (Domain\\Username or Hostname\\Username).
    #[serde(rename = "account_name", skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    /// The type of the account that made the login.
    #[serde(rename = "account_type", skip_serializing_if = "Option::is_none")]
    pub account_type: Option<String>,
    /// Whether the account that made the login has administrator privileges (Yes, No, or Unknown).
    #[serde(rename = "admin_privileges", skip_serializing_if = "Option::is_none")]
    pub admin_privileges: Option<String>,
    /// A login represents an aggregation of login attempts made in a window of time (1-hour window for logins in the past day, or 24-hour window for logins older than a day).
    #[serde(rename = "aggregation_time_interval", skip_serializing_if = "Option::is_none")]
    pub aggregation_time_interval: Option<String>,
    /// The agent ID of the Falcon sensor installed on the asset where the login took place.
    #[serde(rename = "aid", skip_serializing_if = "Option::is_none")]
    pub aid: Option<String>,
    /// The customer ID where login took place.
    #[serde(rename = "cid", skip_serializing_if = "Option::is_none")]
    pub cid: Option<String>,
    /// The description of the reason why the login failed, if login_status=\"Failed\".<ul><li>There are currently no login servers available to service the login request.</li><li>User login with misspelled or bad user account</li><li>User login with misspelled or bad password</li><li>This is either due to a bad username or authentication information</li><li>Unknown user name or bad password.</li><li>User login outside authorized hours</li><li>User login from unauthorized workstation</li><li>User login with expired password</li><li>User login to account disabled by administrator</li><li>Indicates the Sam Server was in the wrong state to perform the desired operation.</li><li>Clocks between DC and other computer too far out of sync</li><li>The user has not been granted the requested login type (aka login right) at this machine</li><li>The login request failed because the trust relationship between the primary domain and the trusted domain failed.</li><li>An attempt was made to login, but the Netlogon service was not started.</li><li>User login with expired account</li><li>User is required to change password at next login</li><li>Evidently a bug in Windows and not a risk</li><li>User login with account locked</li><li>Failure Reason: An Error occurred during Login</li><li>Login Failure: The machine you are logging in to is protected by an authentication firewall. The specified account is not allowed to authenticate to the machine.</li><li>Status OK.</li><li>Invalid password entered</li></ul>
    #[serde(rename = "failure_description", skip_serializing_if = "Option::is_none")]
    pub failure_description: Option<String>,
    /// The name of the city where the asset is located where the login took place.
    #[serde(rename = "host_city", skip_serializing_if = "Option::is_none")]
    pub host_city: Option<String>,
    /// The name of the country where the asset is located on which the login took place.
    #[serde(rename = "host_country", skip_serializing_if = "Option::is_none")]
    pub host_country: Option<String>,
    /// The unique ID of the asset where the login took place.
    #[serde(rename = "host_id", skip_serializing_if = "Option::is_none")]
    pub host_id: Option<String>,
    /// The hostname of the host where the login took place.
    #[serde(rename = "hostname", skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    /// The unique ID of the login.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Whether the failed login is considered suspicious based on criteria including login failures and locations (true or false).
    #[serde(rename = "is_suspicious", skip_serializing_if = "Option::is_none")]
    pub is_suspicious: Option<bool>,
    /// The external IP address of the asset where the login took place.
    #[serde(rename = "local_ip", skip_serializing_if = "Option::is_none")]
    pub local_ip: Option<String>,
    /// The domain of the asset where the login took place.
    #[serde(rename = "login_domain", skip_serializing_if = "Option::is_none")]
    pub login_domain: Option<String>,
    /// Number of times a login attempt happened in the specified aggregation time interval for this login (1-hour window for logins in the past day, or 24-hour window for logins older than a day).
    #[serde(rename = "login_event_count", skip_serializing_if = "Option::is_none")]
    pub login_event_count: Option<i64>,
    /// The status of the login (Successful or Failed).
    #[serde(rename = "login_status", skip_serializing_if = "Option::is_none")]
    pub login_status: Option<String>,
    /// The date and time of the most recent attempt in the login.
    #[serde(rename = "login_timestamp", skip_serializing_if = "Option::is_none")]
    pub login_timestamp: Option<String>,
    /// The type of the login.  For successful logins: <ul><li>Interactive</li><li>Service</li><li>Terminal server</li><li>Cached credentials</li><li>Auditing</li></ul> For failed logins: <ul><li>Interactive</li><li>Network</li><li>Batch</li><li>Service</li><li>Unlock</li><li>Network cleartext</li><li>New credentials</li><li>Terminal server</li><li>Cached credentials</li><li>Auditing</li></ul>
    #[serde(rename = "login_type", skip_serializing_if = "Option::is_none")]
    pub login_type: Option<String>,
    /// The remote IP address where the login was initiated.
    #[serde(rename = "remote_ip", skip_serializing_if = "Option::is_none")]
    pub remote_ip: Option<String>,
    /// The security identifier of the account on a Windows asset that made the login.
    #[serde(rename = "user_sid", skip_serializing_if = "Option::is_none")]
    pub user_sid: Option<String>,
    /// The username of the account that made the login.
    #[serde(rename = "username", skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
}

impl DomainDiscoverApiLogin {
    /// Represents information about a successful or a failed login.
    pub fn new() -> DomainDiscoverApiLogin {
        DomainDiscoverApiLogin {
            account_id: None,
            account_name: None,
            account_type: None,
            admin_privileges: None,
            aggregation_time_interval: None,
            aid: None,
            cid: None,
            failure_description: None,
            host_city: None,
            host_country: None,
            host_id: None,
            hostname: None,
            id: None,
            is_suspicious: None,
            local_ip: None,
            login_domain: None,
            login_event_count: None,
            login_status: None,
            login_timestamp: None,
            login_type: None,
            remote_ip: None,
            user_sid: None,
            username: None,
        }
    }
}
