/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

/// DomainDiscoverApiAccount : Represents information about an account.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainDiscoverApiAccount {
    /// The account's name (Domain\\Username or Hostname\\Username).
    #[serde(rename = "account_name", skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    /// The type of the account (Local or Domain).
    #[serde(rename = "account_type", skip_serializing_if = "Option::is_none")]
    pub account_type: Option<String>,
    /// Whether the account has administrator privileges (Yes, No, or Unknown).
    #[serde(rename = "admin_privileges", skip_serializing_if = "Option::is_none")]
    pub admin_privileges: Option<String>,
    /// The account's customer ID.
    #[serde(rename = "cid")]
    pub cid: String,
    /// The first time the account was seen successfully logging in to your environment.
    #[serde(rename = "first_seen_timestamp", skip_serializing_if = "Option::is_none")]
    pub first_seen_timestamp: Option<String>,
    /// The unique ID of the account.
    #[serde(rename = "id")]
    pub id: String,
    /// The hostname of the asset on which the account last made a failed login.
    #[serde(rename = "last_failed_login_hostname", skip_serializing_if = "Option::is_none")]
    pub last_failed_login_hostname: Option<String>,
    /// The date and time of the account's most recent failed login.
    #[serde(rename = "last_failed_login_timestamp", skip_serializing_if = "Option::is_none")]
    pub last_failed_login_timestamp: Option<String>,
    /// The type of the account's most recent failed login. <ul><li>Interactive</li><li>Network</li><li>Batch</li><li>Service</li><li>Unlock</li><li>Network cleartext</li><li>New credentials</li><li>Terminal server</li><li>Cached credentials</li><li>Auditing</li></ul>
    #[serde(rename = "last_failed_login_type", skip_serializing_if = "Option::is_none")]
    pub last_failed_login_type: Option<String>,
    /// The name of the city where the asset is located on which the account last successfully logged in.
    #[serde(rename = "last_successful_login_host_city", skip_serializing_if = "Option::is_none")]
    pub last_successful_login_host_city: Option<String>,
    /// The name of the country where the asset is located on which the account last successfully logged in.
    #[serde(rename = "last_successful_login_host_country", skip_serializing_if = "Option::is_none")]
    pub last_successful_login_host_country: Option<String>,
    /// The hostname of the asset on which the account last successfully logged in.
    #[serde(rename = "last_successful_login_hostname", skip_serializing_if = "Option::is_none")]
    pub last_successful_login_hostname: Option<String>,
    /// The remote IP address of the asset on which the account last successfully logged in.
    #[serde(rename = "last_successful_login_remote_ip", skip_serializing_if = "Option::is_none")]
    pub last_successful_login_remote_ip: Option<String>,
    /// The date and time of the account's most recent successful login.
    #[serde(rename = "last_successful_login_timestamp", skip_serializing_if = "Option::is_none")]
    pub last_successful_login_timestamp: Option<String>,
    /// The type of the account's most recent successful login. <ul><li>Interactive</li><li>Service</li><li>Terminal server</li><li>Cached credentials</li><li>Auditing</li></ul>
    #[serde(rename = "last_successful_login_type", skip_serializing_if = "Option::is_none")]
    pub last_successful_login_type: Option<String>,
    /// The domain of the asset the account successfully logged in to.
    #[serde(rename = "login_domain", skip_serializing_if = "Option::is_none")]
    pub login_domain: Option<String>,
    /// The most recent date and time the account's password was changed.
    #[serde(rename = "password_last_set_timestamp", skip_serializing_if = "Option::is_none")]
    pub password_last_set_timestamp: Option<String>,
    /// The account's security identifier on Windows assets.
    #[serde(rename = "user_sid", skip_serializing_if = "Option::is_none")]
    pub user_sid: Option<String>,
    /// The account's username.
    #[serde(rename = "username", skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
}

impl DomainDiscoverApiAccount {
    /// Represents information about an account.
    pub fn new(cid: String, id: String) -> DomainDiscoverApiAccount {
        DomainDiscoverApiAccount {
            account_name: None,
            account_type: None,
            admin_privileges: None,
            cid,
            first_seen_timestamp: None,
            id,
            last_failed_login_hostname: None,
            last_failed_login_timestamp: None,
            last_failed_login_type: None,
            last_successful_login_host_city: None,
            last_successful_login_host_country: None,
            last_successful_login_hostname: None,
            last_successful_login_remote_ip: None,
            last_successful_login_timestamp: None,
            last_successful_login_type: None,
            login_domain: None,
            password_last_set_timestamp: None,
            user_sid: None,
            username: None,
        }
    }
}
