/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainBreachedItemV1 {
    /// The domain associated with the breached account.
    #[serde(rename = "domain")]
    pub domain: String,
    /// The email of the breached account.
    #[serde(rename = "email")]
    pub email: String,
    /// The original hashing algorithm applied to the breached password. Possible values: 'plain', 'unknown', 'base64', 'md5', 'sha1', 'bcrypt', etc. The value 'plain' means that the password was originally found as plaintext.
    #[serde(rename = "hash_type")]
    pub hash_type: String,
    /// The username of the breached account.
    #[serde(rename = "login_id")]
    pub login_id: String,
    /// The name of the person associated with the breached account.
    #[serde(rename = "name")]
    pub name: String,
    /// The breached password. Passwords are returned as salted hashes, generated using the SHA256 algorithm and the CID as the salt.
    #[serde(rename = "password")]
    pub password: String,
    /// The phone number of the person associated with the breached account.
    #[serde(rename = "phone")]
    pub phone: String,
}

impl DomainBreachedItemV1 {
    pub fn new(domain: String, email: String, hash_type: String, login_id: String, name: String, password: String, phone: String) -> DomainBreachedItemV1 {
        DomainBreachedItemV1 {
            domain,
            email,
            hash_type,
            login_id,
            name,
            password,
            phone,
        }
    }
}
