/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainApiVulnerabilityHostFacetV2 {
    #[serde(rename = "groups", skip_serializing_if = "Option::is_none")]
    pub groups: Option<Vec<crate::models::DomainApiHostGroup>>,
    #[serde(rename = "host_last_seen_timestamp", skip_serializing_if = "Option::is_none")]
    pub host_last_seen_timestamp: Option<String>,
    #[serde(rename = "hostname")]
    pub hostname: String,
    #[serde(rename = "local_ip")]
    pub local_ip: String,
    #[serde(rename = "machine_domain")]
    pub machine_domain: String,
    #[serde(rename = "os_version")]
    pub os_version: String,
    #[serde(rename = "ou")]
    pub ou: String,
    #[serde(rename = "platform", skip_serializing_if = "Option::is_none")]
    pub platform: Option<String>,
    #[serde(rename = "site_name")]
    pub site_name: String,
    #[serde(rename = "system_manufacturer")]
    pub system_manufacturer: String,
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
}

impl DomainApiVulnerabilityHostFacetV2 {
    pub fn new(hostname: String, local_ip: String, machine_domain: String, os_version: String, ou: String, site_name: String, system_manufacturer: String) -> DomainApiVulnerabilityHostFacetV2 {
        DomainApiVulnerabilityHostFacetV2 {
            groups: None,
            host_last_seen_timestamp: None,
            hostname,
            local_ip,
            machine_domain,
            os_version,
            ou,
            platform: None,
            site_name,
            system_manufacturer,
            tags: None,
        }
    }
}
