/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DomainApiVulnerabilityCveDetailsFacetV2 {
    #[serde(rename = "base_score", skip_serializing_if = "Option::is_none")]
    pub base_score: Option<f64>,
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "exploit_status", skip_serializing_if = "Option::is_none")]
    pub exploit_status: Option<i32>,
    #[serde(rename = "exploitability_score", skip_serializing_if = "Option::is_none")]
    pub exploitability_score: Option<f64>,
    #[serde(rename = "exprt_rating", skip_serializing_if = "Option::is_none")]
    pub exprt_rating: Option<String>,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "impact_score", skip_serializing_if = "Option::is_none")]
    pub impact_score: Option<f64>,
    #[serde(rename = "published_date", skip_serializing_if = "Option::is_none")]
    pub published_date: Option<String>,
    #[serde(rename = "references", skip_serializing_if = "Option::is_none")]
    pub references: Option<Vec<String>>,
    #[serde(rename = "severity", skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    #[serde(rename = "vector", skip_serializing_if = "Option::is_none")]
    pub vector: Option<String>,
    #[serde(rename = "vendor_advisory", skip_serializing_if = "Option::is_none")]
    pub vendor_advisory: Option<Vec<String>>,
}

impl DomainApiVulnerabilityCveDetailsFacetV2 {
    pub fn new(id: String) -> DomainApiVulnerabilityCveDetailsFacetV2 {
        DomainApiVulnerabilityCveDetailsFacetV2 {
            base_score: None,
            description: None,
            exploit_status: None,
            exploitability_score: None,
            exprt_rating: None,
            id,
            impact_score: None,
            published_date: None,
            references: None,
            severity: None,
            vector: None,
            vendor_advisory: None,
        }
    }
}
