/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DeviceDevice {
    #[serde(rename = "agent_load_flags", skip_serializing_if = "Option::is_none")]
    pub agent_load_flags: Option<String>,
    #[serde(rename = "agent_local_time", skip_serializing_if = "Option::is_none")]
    pub agent_local_time: Option<String>,
    #[serde(rename = "agent_version", skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "bios_manufacturer", skip_serializing_if = "Option::is_none")]
    pub bios_manufacturer: Option<String>,
    #[serde(rename = "bios_version", skip_serializing_if = "Option::is_none")]
    pub bios_version: Option<String>,
    #[serde(rename = "build_number", skip_serializing_if = "Option::is_none")]
    pub build_number: Option<String>,
    #[serde(rename = "cid")]
    pub cid: String,
    #[serde(rename = "config_id_base", skip_serializing_if = "Option::is_none")]
    pub config_id_base: Option<String>,
    #[serde(rename = "config_id_build", skip_serializing_if = "Option::is_none")]
    pub config_id_build: Option<String>,
    #[serde(rename = "config_id_platform", skip_serializing_if = "Option::is_none")]
    pub config_id_platform: Option<String>,
    #[serde(rename = "cpu_signature", skip_serializing_if = "Option::is_none")]
    pub cpu_signature: Option<String>,
    #[serde(rename = "detection_suppression_status", skip_serializing_if = "Option::is_none")]
    pub detection_suppression_status: Option<String>,
    #[serde(rename = "device_id")]
    pub device_id: String,
    #[serde(rename = "device_policies", skip_serializing_if = "Option::is_none")]
    pub device_policies: Option<Box<crate::models::DeviceMappedDevicePolicies>>,
    #[serde(rename = "email", skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(rename = "external_ip", skip_serializing_if = "Option::is_none")]
    pub external_ip: Option<String>,
    #[serde(rename = "first_login_timestamp", skip_serializing_if = "Option::is_none")]
    pub first_login_timestamp: Option<String>,
    #[serde(rename = "first_login_user", skip_serializing_if = "Option::is_none")]
    pub first_login_user: Option<String>,
    #[serde(rename = "first_seen", skip_serializing_if = "Option::is_none")]
    pub first_seen: Option<String>,
    #[serde(rename = "group_hash", skip_serializing_if = "Option::is_none")]
    pub group_hash: Option<String>,
    #[serde(rename = "groups", skip_serializing_if = "Option::is_none")]
    pub groups: Option<Vec<String>>,
    #[serde(rename = "host_hidden_status", skip_serializing_if = "Option::is_none")]
    pub host_hidden_status: Option<String>,
    #[serde(rename = "hostname", skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    #[serde(rename = "instance_id", skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[serde(rename = "last_login_timestamp", skip_serializing_if = "Option::is_none")]
    pub last_login_timestamp: Option<String>,
    #[serde(rename = "last_login_user", skip_serializing_if = "Option::is_none")]
    pub last_login_user: Option<String>,
    #[serde(rename = "last_seen", skip_serializing_if = "Option::is_none")]
    pub last_seen: Option<String>,
    #[serde(rename = "local_ip", skip_serializing_if = "Option::is_none")]
    pub local_ip: Option<String>,
    #[serde(rename = "mac_address", skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[serde(rename = "machine_domain", skip_serializing_if = "Option::is_none")]
    pub machine_domain: Option<String>,
    #[serde(rename = "major_version", skip_serializing_if = "Option::is_none")]
    pub major_version: Option<String>,
    #[serde(rename = "managed_apps", skip_serializing_if = "Option::is_none")]
    pub managed_apps: Option<Box<crate::models::DeviceManagedApps>>,
    #[serde(rename = "meta", skip_serializing_if = "Option::is_none")]
    pub meta: Option<Box<crate::models::DeviceDeviceMeta>>,
    #[serde(rename = "minor_version", skip_serializing_if = "Option::is_none")]
    pub minor_version: Option<String>,
    #[serde(rename = "modified_timestamp", skip_serializing_if = "Option::is_none")]
    pub modified_timestamp: Option<String>,
    #[serde(rename = "notes", skip_serializing_if = "Option::is_none")]
    pub notes: Option<Vec<String>>,
    #[serde(rename = "os_build", skip_serializing_if = "Option::is_none")]
    pub os_build: Option<String>,
    #[serde(rename = "os_version", skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[serde(rename = "ou", skip_serializing_if = "Option::is_none")]
    pub ou: Option<Vec<String>>,
    #[serde(rename = "platform_id", skip_serializing_if = "Option::is_none")]
    pub platform_id: Option<String>,
    #[serde(rename = "platform_name", skip_serializing_if = "Option::is_none")]
    pub platform_name: Option<String>,
    #[serde(rename = "pod_annotations", skip_serializing_if = "Option::is_none")]
    pub pod_annotations: Option<Vec<String>>,
    #[serde(rename = "pod_host_ip4", skip_serializing_if = "Option::is_none")]
    pub pod_host_ip4: Option<String>,
    #[serde(rename = "pod_host_ip6", skip_serializing_if = "Option::is_none")]
    pub pod_host_ip6: Option<String>,
    #[serde(rename = "pod_hostname", skip_serializing_if = "Option::is_none")]
    pub pod_hostname: Option<String>,
    #[serde(rename = "pod_id", skip_serializing_if = "Option::is_none")]
    pub pod_id: Option<String>,
    #[serde(rename = "pod_ip4", skip_serializing_if = "Option::is_none")]
    pub pod_ip4: Option<String>,
    #[serde(rename = "pod_ip6", skip_serializing_if = "Option::is_none")]
    pub pod_ip6: Option<String>,
    #[serde(rename = "pod_labels", skip_serializing_if = "Option::is_none")]
    pub pod_labels: Option<Vec<String>>,
    #[serde(rename = "pod_name", skip_serializing_if = "Option::is_none")]
    pub pod_name: Option<String>,
    #[serde(rename = "pod_namespace", skip_serializing_if = "Option::is_none")]
    pub pod_namespace: Option<String>,
    #[serde(rename = "pod_service_account_name", skip_serializing_if = "Option::is_none")]
    pub pod_service_account_name: Option<String>,
    #[serde(rename = "pointer_size", skip_serializing_if = "Option::is_none")]
    pub pointer_size: Option<String>,
    #[serde(rename = "policies", skip_serializing_if = "Option::is_none")]
    pub policies: Option<Vec<crate::models::DeviceDevicePolicy>>,
    #[serde(rename = "product_type", skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    #[serde(rename = "product_type_desc", skip_serializing_if = "Option::is_none")]
    pub product_type_desc: Option<String>,
    #[serde(rename = "provision_status", skip_serializing_if = "Option::is_none")]
    pub provision_status: Option<String>,
    #[serde(rename = "reduced_functionality_mode", skip_serializing_if = "Option::is_none")]
    pub reduced_functionality_mode: Option<String>,
    #[serde(rename = "release_group", skip_serializing_if = "Option::is_none")]
    pub release_group: Option<String>,
    #[serde(rename = "serial_number", skip_serializing_if = "Option::is_none")]
    pub serial_number: Option<String>,
    #[serde(rename = "service_pack_major", skip_serializing_if = "Option::is_none")]
    pub service_pack_major: Option<String>,
    #[serde(rename = "service_pack_minor", skip_serializing_if = "Option::is_none")]
    pub service_pack_minor: Option<String>,
    #[serde(rename = "service_provider", skip_serializing_if = "Option::is_none")]
    pub service_provider: Option<String>,
    #[serde(rename = "service_provider_account_id", skip_serializing_if = "Option::is_none")]
    pub service_provider_account_id: Option<String>,
    #[serde(rename = "site_name", skip_serializing_if = "Option::is_none")]
    pub site_name: Option<String>,
    #[serde(rename = "slow_changing_modified_timestamp", skip_serializing_if = "Option::is_none")]
    pub slow_changing_modified_timestamp: Option<String>,
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "system_manufacturer", skip_serializing_if = "Option::is_none")]
    pub system_manufacturer: Option<String>,
    #[serde(rename = "system_product_name", skip_serializing_if = "Option::is_none")]
    pub system_product_name: Option<String>,
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    #[serde(rename = "zone_group", skip_serializing_if = "Option::is_none")]
    pub zone_group: Option<String>,
}

impl DeviceDevice {
    pub fn new(cid: String, device_id: String) -> DeviceDevice {
        DeviceDevice {
            agent_load_flags: None,
            agent_local_time: None,
            agent_version: None,
            bios_manufacturer: None,
            bios_version: None,
            build_number: None,
            cid,
            config_id_base: None,
            config_id_build: None,
            config_id_platform: None,
            cpu_signature: None,
            detection_suppression_status: None,
            device_id,
            device_policies: None,
            email: None,
            external_ip: None,
            first_login_timestamp: None,
            first_login_user: None,
            first_seen: None,
            group_hash: None,
            groups: None,
            host_hidden_status: None,
            hostname: None,
            instance_id: None,
            last_login_timestamp: None,
            last_login_user: None,
            last_seen: None,
            local_ip: None,
            mac_address: None,
            machine_domain: None,
            major_version: None,
            managed_apps: None,
            meta: None,
            minor_version: None,
            modified_timestamp: None,
            notes: None,
            os_build: None,
            os_version: None,
            ou: None,
            platform_id: None,
            platform_name: None,
            pod_annotations: None,
            pod_host_ip4: None,
            pod_host_ip6: None,
            pod_hostname: None,
            pod_id: None,
            pod_ip4: None,
            pod_ip6: None,
            pod_labels: None,
            pod_name: None,
            pod_namespace: None,
            pod_service_account_name: None,
            pointer_size: None,
            policies: None,
            product_type: None,
            product_type_desc: None,
            provision_status: None,
            reduced_functionality_mode: None,
            release_group: None,
            serial_number: None,
            service_pack_major: None,
            service_pack_minor: None,
            service_provider: None,
            service_provider_account_id: None,
            site_name: None,
            slow_changing_modified_timestamp: None,
            status: None,
            system_manufacturer: None,
            system_product_name: None,
            tags: None,
            zone_group: None,
        }
    }
}
