/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ApiScheduledReportV1 {
    #[serde(rename = "can_write")]
    pub can_write: bool,
    #[serde(rename = "created_on")]
    pub created_on: String,
    #[serde(rename = "customer_id")]
    pub customer_id: String,
    #[serde(rename = "description")]
    pub description: String,
    #[serde(rename = "expiration_on", skip_serializing_if = "Option::is_none")]
    pub expiration_on: Option<String>,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "last_execution", skip_serializing_if = "Option::is_none")]
    pub last_execution: Option<Box<crate::models::DomainReportExecutionSummary>>,
    #[serde(rename = "last_updated_on")]
    pub last_updated_on: String,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "next_execution_on", skip_serializing_if = "Option::is_none")]
    pub next_execution_on: Option<String>,
    #[serde(rename = "notifications")]
    pub notifications: Vec<crate::models::DomainNotifications>,
    #[serde(rename = "report_params")]
    pub report_params: Box<crate::models::DomainReportParams>,
    #[serde(rename = "schedule")]
    pub schedule: Box<crate::models::DomainSchedule>,
    #[serde(rename = "shared_with")]
    pub shared_with: Vec<String>,
    #[serde(rename = "start_on", skip_serializing_if = "Option::is_none")]
    pub start_on: Option<String>,
    #[serde(rename = "status")]
    pub status: String,
    #[serde(rename = "stop_on", skip_serializing_if = "Option::is_none")]
    pub stop_on: Option<String>,
    #[serde(rename = "tracking", skip_serializing_if = "Option::is_none")]
    pub tracking: Option<String>,
    #[serde(rename = "trigger_reference")]
    pub trigger_reference: String,
    #[serde(rename = "type")]
    pub _type: String,
    #[serde(rename = "user_id")]
    pub user_id: String,
    #[serde(rename = "user_uuid")]
    pub user_uuid: String,
}

impl ApiScheduledReportV1 {
    pub fn new(
        can_write: bool,
        created_on: String,
        customer_id: String,
        description: String,
        id: String,
        last_updated_on: String,
        name: String,
        notifications: Vec<crate::models::DomainNotifications>,
        report_params: crate::models::DomainReportParams,
        schedule: crate::models::DomainSchedule,
        shared_with: Vec<String>,
        status: String,
        trigger_reference: String,
        _type: String,
        user_id: String,
        user_uuid: String,
    ) -> ApiScheduledReportV1 {
        ApiScheduledReportV1 {
            can_write,
            created_on,
            customer_id,
            description,
            expiration_on: None,
            id,
            last_execution: None,
            last_updated_on,
            name,
            next_execution_on: None,
            notifications,
            report_params: Box::new(report_params),
            schedule: Box::new(schedule),
            shared_with,
            start_on: None,
            status,
            stop_on: None,
            tracking: None,
            trigger_reference,
            _type,
            user_id,
            user_uuid,
        }
    }
}
