# Sound Effects

At least a dozen sound effects can play concurrently. The exact number is probably dependent on the particular hardware you have available on your local machine. Sound effects are played in a "fire and forget" manner, and will each play in a separate channel (if available) and terminate once reaching the end of the audio source.

### Play

The `play_sfx` method plays a sound effect. The first parameter should be a `SfxPreset` enum variant or a music file path relative to `assets/audio`. All sound effects from the asset pack have variants present in the `SfxPreset` enum for convenience.

The second parameter is the volume, which should be a value between `0.0` (silent) and `1.0` full volume.

```rust,ignored
// using a preset
engine_state.audio_manager.play_sfx(SfxPreset::Jingle1, 1.0);

// using a filepath relative to `assets/audio`
engine_state.audio_manager.play_sfx("sfx/jingle1.ogg", 1.0);
```

There is no way to interact with sound effects to monitor status or stop them early.
