use rusty_engine::prelude::*;

struct GameState {
    music_index: usize,
}

rusty_engine::init!(GameState);

fn main() {
    let mut game = Game::new();
    let msg = game.add_text(
        "msg",
        "Press any key to advance to the next music selection.\n\nIf you are not running with \"--release\", it may take several seconds for each song to load!",
    );
    msg.translation.y = -200.0;

    game.add_logic(logic);
    game.run(GameState { music_index: 0 });
}

fn logic(engine_state: &mut EngineState, game_state: &mut GameState) -> bool {
    let mut should_play_new_song = false;
    // Play a new song because a key was pressed
    for ev in engine_state.keyboard_events.drain(..) {
        if ev.state != ElementState::Pressed {
            continue;
        }
        game_state.music_index = (game_state.music_index + 1) % MusicPreset::variant_iter().count();
        should_play_new_song = true;
        break;
    }

    if should_play_new_song || !engine_state.audio_manager.music_playing() {
        // Actually play the new song
        let music_preset = MusicPreset::variant_iter()
            .nth(game_state.music_index)
            .unwrap();
        engine_state.audio_manager.play_music(music_preset, 1.0);
        // And make text saying what song we're playing
        let note1 = engine_state.add_text("note1", format!("Looping: {:?}", music_preset));
        note1.font_size = 75.0;
    }
    true
}
