use std::io::Read;
use std::time::Duration;
use std::str;
use rusty_slip::slip::SlipDecoder;

fn main() {

    let mut port = serialport::new("COM4", 115_200)
        .timeout(Duration::from_secs(60 * 5))
        .open().expect("Failed to open port");

    println!("Serial port opened..");

    // read ABCDEF + END from serial
    let mut serial_buf: Vec<u8> = vec![0; 7];
    port.read_exact(&mut serial_buf).expect("Failed to read data");
    println!("Raw serial input: {:?}", serial_buf);


    let mut decoder = SlipDecoder::new();
    decoder.decode(&serial_buf);
    println!("Decoded packets available?: {:?}", decoder.are_decoded_packets_available());
    let packets = decoder.get_packets();

    println!("Packets: {:?}", packets);

    for p in packets {
        println!("{}", str::from_utf8(&*p).unwrap());
    }

}

