# Rusty-paper-wallet

[![crates.io](https://img.shields.io/crates/v/rusty-paper-wallet.svg)](https://crates.io/crates/rusty-paper-wallet)

Generates descriptor-based bitcoin paper wallet offline.

## Important

Older rusty-paper-wallet version 0.9.0 example wallet contains a bug, for details read here https://bitcoindevkit.org/blog/miniscript-vulnerability/

## Install and Run

You need rust installed (MSRV 1.46).

```
cargo install rusty-paper-wallet
```

Go offline...

## Decide the spending descriptor

### Simple 1-of-1

```
DESC="wpkh(Alice)"
```

### At least 3 satisfied condition between Alice, Bob, Carol or older than 2 blocks

```
DESC="wsh(thresh(3,pk(Alice),s:pk(Bob),s:pk(Carol),sdv:older(2)))"
```

## Launch

```
$ rusty-paper-wallet $DESC
```

Or, in alternative, from the github repository...

```
$ git clone https://github.com/RCasatta/rusty-paper-wallet
$ cd rusty-paper-wallet
$ cargo run -- $DESC
```

The output is:
```
data:text/html;base64,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
```

Copy and paste all the output in the address bar of a browser (incognito mode may help in leaving nothing in the browser history).
By using a data url no data is written to the disk, improving privacy.

The result is:

![paper-wallet](rusty-paper-wallet-example.png)

## Printing

Print the page from the browser.

Cut the dotted line, fold the private key over the black area, then fold a second time, plastify the paper.

NOTE: Once folded the black area should ideally cover in front and in the back the secret part (QR code and text) so that it's not visible in backlight.

## Descriptor

Note the parameter must be a valid descriptor,
if you have a miniscript policy such as `thresh(3,pk(Alice),pk(Bob),pk(Carol),older(2))` and you want a descriptor
you can use the online [BDK Playground Policy Compiler](https://bitcoindevkit.org/bdk-cli/playground/) or the [BDK CLI Tool](https://github.com/bitcoindevkit/bdk-cli).

