<!---
SPDX-FileCopyrightText: 2020 Robin Krahl <robin.krahl@ireas.org>
SPDX-License-Identifier: MIT
-->

# rusty-man

```
$ rusty-man rusty-man | head -5
rusty-man                       Module rusty-man                       rusty-man

DESCRIPTION
      rusty-man is a command-line viewer for documentation generated by
      `rustdoc`.
```

<img alt="A screenshot of rusty-man displaying the std::result documentation with the tui viewer"
     src="https://git.sr.ht/~ireas/rusty-man/blob/master/rusty-man.jpg"/>

## Example Usage

Before running rusty-man, make sure that you generated the documentation with
`cargo doc`:
```
$ cd rusty-man && cargo doc
```

Then you can open the documentation for an item:
```
$ rusty-man kuchiki::NodeRef
```

You don’t have to specificy the full item name:
```
$ rusty-man NodeRef
```

If the documentation is not placed in `./target/doc` or the Rust installation
directory, you have to manually set the source path using the `-s`/`--source`
option:
```
$ rusty-man --source my/other/crate/target/doc io::Error
```

If there are multiple matches for the keyword, rusty-man will show you a list
of all matching items:
```
$ rusty-man --source my/other/crate/target/doc u8
Found mulitple matches for u8 – select one of:

[ 0 ] core::u8: The 8-bit unsigned integer type.
[ 1 ] std::u8: The 8-bit unsigned integer type.

> 1
```

For more usage information, run `rusty-man --help`.

## Viewers

rusty-man has three viewers (select one with the `--viewer` option) that
determine the output format:
- `plain` prints the documentation to the standard output without formatting.
  This is the default for non-interactive use.
- `rich` prints the documentation to the standard output with formatting and
  optional syntax highlighting.  This is the default for interactive use.
- `tui` is an interactive terminal interface.  You can read the documentation
  and follow links.

## Installation

To install rusty-man from source, clone this repository and use cargo to build
the project, or use `cargo install`.  See the [`INSTALL.md`][] file for more
information.  rusty-man is also available as a package for these distributions:
- Arch Linux: [`rusty-man`][pkg-aur] in the Arch User Repository

rusty-man is developed for Unix-like systems.  It should run on other platforms
too, but with some limitations:  The `rich` and `tui` viewers uses ANSI escape
codes, which are not supported on older Windows versions.  If you have trouble
running rusty-man on your platform or if you want to help porting rusty-man to
other platforms, please let me know.

## Integrations

### vim

You can set rusty-man as the keyword program with `set keywordprg=rusty-man`
and then use `K` to open the documentation for the item under the cursor.  If
you want to apply this setting for all Rust files, add it to the
`ftplugin/rust.vim` file in your vim runtime directory (e. g. `~/.vim`).

## Contributing

Contributions to this project are very welcome!  You can contribute by writing
code or documentation or by testing.  See the [`CONTRIBUTING.md`][] file for
more information.

If you are looking for a good starting point, have a look at the [issues with
the label “good first issue”][issues] in rusty-man’s issue tracker.

## Minimum Supported Rust Version

This crate supports Rust 1.45.0 or later.

## Contact

For bug reports, patches, feature requests or other messages, please send a
mail to the mailing list [~ireas/rusty-man-dev@lists.sr.ht][] ([public
archive][]) or [contact me directly][].  You can also use the rusty-man [issue
tracker][] for bug reports or features requests.

## License

This project is licensed under the [MIT License][].  For license information
for the data used by the test suite, see the [`.reuse/dep5`][] file.

`rusty-man` complies with [version 3.0 of the REUSE specification][reuse].

[`crossterm`]: https://lib.rs/crossterm
[`INSTALL.md`]: https://git.sr.ht/~ireas/rusty-man/tree/refs/heads/master/INSTALL.md
[`CONTRIBUTING.md`]: https://git.sr.ht/~ireas/rusty-man/tree/refs/heads/master/CONTRIBUTING.md
[issues]: https://todo.sr.ht/~ireas/rusty-man?search=label:%22good%20first%20issue%22%20status%3Aopen
[~ireas/rusty-man-dev@lists.sr.ht]: mailto:~ireas/rusty-man-dev@lists.sr.ht
[contact me directly]: mailto:robin.krahl@ireas.org
[public archive]: https://lists.sr.ht/~ireas/rusty-man-dev
[issue tracker]: https://todo.sr.ht/~ireas/rusty-man
[MIT license]: https://opensource.org/licenses/MIT
[`.reuse/dep5`]: https://git.sr.ht/~ireas/rusty-man/tree/refs/heads/master/.reuse/dep5
[reuse]: https://reuse.software/practices/3.0/

[pkg-aur]: https://aur.archlinux.org/packages/rusty-man/
