# Rusty logger !

This is a personal project i decided to make in order
to have a logger that meets my own needs.

It has basic functionality like outputing errors,
warnings and informations but also timers and it is
fairly modular. It is still under development and
more is to come.

# Usage

```rust
use rusty_logger::logger::Logger;

let mut logger = Logger::new("New logger", std::io::stdout());

logger.info("Hello world !");
```

# Objectives

## Modularity

I tried to build this logger in a modular way. For
example, the output of the logger is a stream given
by the end user. This means that you can output to
`stdout` or `stderr` but also to a file. You can also
change colors or options as you please.

## Simplicity

I want this logger to be simple and easy to use.
In an ideal world, you would just add it to your
project and use it without having to read the docs.

# Warning

Compatibility with older versions in **NOT** a
priority. It is highly likely that I realise there
are some big design flaws and I change things.

# TODO

- read config from file (JSON or TOML)
- add modules (a way to add your own information to the logger)