pub struct Class {
	pub id: u8,
	pub name: &'static str,
	pub subclasses: &'static [Subclass],
}

pub struct Subclass {
	pub id: u8,
	pub name: &'static str,
}

pub struct Vendor {
	pub id: u16,
	pub name: &'static str,
	pub devices: &'static [Device],
}

pub struct Device {
	pub id: u16,
	pub name: &'static str,
}

pub static CLASSES: &[Class] = &[
	Class {
		id: 0x00,
		name: "Unclassified device",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "Non-VGA unclassified device",
			},
			Subclass {
				id: 0x01,
				name: "VGA compatible unclassified device",
			},
		],
	},
	Class {
		id: 0x01,
		name: "Mass storage controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "SCSI storage controller",
			},
			Subclass {
				id: 0x01,
				name: "IDE interface",
			},
			Subclass {
				id: 0x02,
				name: "Floppy disk controller",
			},
			Subclass {
				id: 0x03,
				name: "IPI bus controller",
			},
			Subclass {
				id: 0x04,
				name: "RAID bus controller",
			},
			Subclass {
				id: 0x05,
				name: "ATA controller",
			},
			Subclass {
				id: 0x06,
				name: "SATA controller",
			},
			Subclass {
				id: 0x07,
				name: "Serial Attached SCSI controller",
			},
			Subclass {
				id: 0x08,
				name: "Non-Volatile memory controller",
			},
			Subclass {
				id: 0x80,
				name: "Mass storage controller",
			},
		],
	},
	Class {
		id: 0x02,
		name: "Network controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "Ethernet controller",
			},
			Subclass {
				id: 0x01,
				name: "Token ring network controller",
			},
			Subclass {
				id: 0x02,
				name: "FDDI network controller",
			},
			Subclass {
				id: 0x03,
				name: "ATM network controller",
			},
			Subclass {
				id: 0x04,
				name: "ISDN controller",
			},
			Subclass {
				id: 0x05,
				name: "WorldFip controller",
			},
			Subclass {
				id: 0x06,
				name: "PICMG controller",
			},
			Subclass {
				id: 0x07,
				name: "Infiniband controller",
			},
			Subclass {
				id: 0x08,
				name: "Fabric controller",
			},
			Subclass {
				id: 0x80,
				name: "Network controller",
			},
		],
	},
	Class {
		id: 0x03,
		name: "Display controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "VGA compatible controller",
			},
			Subclass {
				id: 0x01,
				name: "XGA compatible controller",
			},
			Subclass {
				id: 0x02,
				name: "3D controller",
			},
			Subclass {
				id: 0x80,
				name: "Display controller",
			},
		],
	},
	Class {
		id: 0x04,
		name: "Multimedia controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "Multimedia video controller",
			},
			Subclass {
				id: 0x01,
				name: "Multimedia audio controller",
			},
			Subclass {
				id: 0x02,
				name: "Computer telephony device",
			},
			Subclass {
				id: 0x03,
				name: "Audio device",
			},
			Subclass {
				id: 0x80,
				name: "Multimedia controller",
			},
		],
	},
	Class {
		id: 0x05,
		name: "Memory controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "RAM memory",
			},
			Subclass {
				id: 0x01,
				name: "FLASH memory",
			},
			Subclass {
				id: 0x80,
				name: "Memory controller",
			},
		],
	},
	Class {
		id: 0x06,
		name: "Bridge",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "Host bridge",
			},
			Subclass {
				id: 0x01,
				name: "ISA bridge",
			},
			Subclass {
				id: 0x02,
				name: "EISA bridge",
			},
			Subclass {
				id: 0x03,
				name: "MicroChannel bridge",
			},
			Subclass {
				id: 0x04,
				name: "PCI bridge",
			},
			Subclass {
				id: 0x05,
				name: "PCMCIA bridge",
			},
			Subclass {
				id: 0x06,
				name: "NuBus bridge",
			},
			Subclass {
				id: 0x07,
				name: "CardBus bridge",
			},
			Subclass {
				id: 0x08,
				name: "RACEway bridge",
			},
			Subclass {
				id: 0x09,
				name: "Semi-transparent PCI-to-PCI bridge",
			},
			Subclass {
				id: 0x0A,
				name: "InfiniBand to PCI host bridge",
			},
			Subclass {
				id: 0x80,
				name: "Bridge",
			},
		],
	},
	Class {
		id: 0x07,
		name: "Communication controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "Serial controller",
			},
			Subclass {
				id: 0x01,
				name: "Parallel controller",
			},
			Subclass {
				id: 0x02,
				name: "Multiport serial controller",
			},
			Subclass {
				id: 0x03,
				name: "Modem",
			},
			Subclass {
				id: 0x04,
				name: "GPIB controller",
			},
			Subclass {
				id: 0x05,
				name: "Smard Card controller",
			},
			Subclass {
				id: 0x80,
				name: "Communication controller",
			},
		],
	},
	Class {
		id: 0x08,
		name: "Generic system peripheral",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "PIC",
			},
			Subclass {
				id: 0x01,
				name: "DMA controller",
			},
			Subclass {
				id: 0x02,
				name: "Timer",
			},
			Subclass {
				id: 0x03,
				name: "RTC",
			},
			Subclass {
				id: 0x04,
				name: "PCI Hot-plug controller",
			},
			Subclass {
				id: 0x05,
				name: "SD Host controller",
			},
			Subclass {
				id: 0x06,
				name: "IOMMU",
			},
			Subclass {
				id: 0x80,
				name: "System peripheral",
			},
		],
	},
	Class {
		id: 0x09,
		name: "Input device controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "Keyboard controller",
			},
			Subclass {
				id: 0x01,
				name: "Digitizer Pen",
			},
			Subclass {
				id: 0x02,
				name: "Mouse controller",
			},
			Subclass {
				id: 0x03,
				name: "Scanner controller",
			},
			Subclass {
				id: 0x04,
				name: "Gameport controller",
			},
			Subclass {
				id: 0x80,
				name: "Input device controller",
			},
		],
	},
	Class {
		id: 0x0A,
		name: "Docking station",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "Generic Docking Station",
			},
			Subclass {
				id: 0x80,
				name: "Docking Station",
			},
		],
	},
	Class {
		id: 0x0B,
		name: "Processor",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "386",
			},
			Subclass {
				id: 0x01,
				name: "486",
			},
			Subclass {
				id: 0x02,
				name: "Pentium",
			},
			Subclass {
				id: 0x10,
				name: "Alpha",
			},
			Subclass {
				id: 0x20,
				name: "Power PC",
			},
			Subclass {
				id: 0x30,
				name: "MIPS",
			},
			Subclass {
				id: 0x40,
				name: "Co-processor",
			},
		],
	},
	Class {
		id: 0x0C,
		name: "Serial bus controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "FireWire (IEEE 1394)",
			},
			Subclass {
				id: 0x01,
				name: "ACCESS Bus",
			},
			Subclass {
				id: 0x02,
				name: "SSA",
			},
			Subclass {
				id: 0x03,
				name: "USB controller",
			},
			Subclass {
				id: 0x04,
				name: "Fibre Channel",
			},
			Subclass {
				id: 0x05,
				name: "SMBus",
			},
			Subclass {
				id: 0x06,
				name: "InfiniBand",
			},
			Subclass {
				id: 0x07,
				name: "IPMI SMIC interface",
			},
			Subclass {
				id: 0x08,
				name: "SERCOS interface",
			},
			Subclass {
				id: 0x09,
				name: "CANBUS",
			},
		],
	},
	Class {
		id: 0x0D,
		name: "Wireless controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "IRDA controller",
			},
			Subclass {
				id: 0x01,
				name: "Consumer IR controller",
			},
			Subclass {
				id: 0x10,
				name: "RF controller",
			},
			Subclass {
				id: 0x11,
				name: "Bluetooth",
			},
			Subclass {
				id: 0x12,
				name: "Broadband",
			},
			Subclass {
				id: 0x20,
				name: "802.1a controller",
			},
			Subclass {
				id: 0x21,
				name: "802.1b controller",
			},
			Subclass {
				id: 0x80,
				name: "Wireless controller",
			},
		],
	},
	Class {
		id: 0x0E,
		name: "Intelligent controller",
		subclasses: &[Subclass {
			id: 0x00,
			name: "I2O",
		}],
	},
	Class {
		id: 0x0F,
		name: "Satellite communications controller",
		subclasses: &[
			Subclass {
				id: 0x01,
				name: "Satellite TV controller",
			},
			Subclass {
				id: 0x02,
				name: "Satellite audio communication controller",
			},
			Subclass {
				id: 0x03,
				name: "Satellite voice communication controller",
			},
			Subclass {
				id: 0x04,
				name: "Satellite data communication controller",
			},
		],
	},
	Class {
		id: 0x10,
		name: "Encryption controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "Network and computing encryption device",
			},
			Subclass {
				id: 0x10,
				name: "Entertainment encryption device",
			},
			Subclass {
				id: 0x80,
				name: "Encryption controller",
			},
		],
	},
	Class {
		id: 0x11,
		name: "Signal processing controller",
		subclasses: &[
			Subclass {
				id: 0x00,
				name: "DPIO module",
			},
			Subclass {
				id: 0x01,
				name: "Performance counters",
			},
			Subclass {
				id: 0x10,
				name: "Communication synchronizer",
			},
			Subclass {
				id: 0x20,
				name: "Signal processing management",
			},
			Subclass {
				id: 0x80,
				name: "Signal processing controller",
			},
		],
	},
	Class {
		id: 0x12,
		name: "Processing accelerators",
		subclasses: &[Subclass {
			id: 0x00,
			name: "Processing accelerators",
		}],
	},
	Class {
		id: 0x13,
		name: "Non-Essential Instrumentation",
		subclasses: &[],
	},
	Class {
		id: 0x40,
		name: "Coprocessor",
		subclasses: &[],
	},
	Class {
		id: 0xFF,
		name: "Unassigned class",
		subclasses: &[],
	},
];

pub static VENDORS: &[Vendor] = &[
	Vendor { id: 0x0001, name: "SafeNet (wrong ID)", devices: &[
	] },
	Vendor { id: 0x0010, name: "Allied Telesis, Inc (Wrong ID)", devices: &[
		Device { id: 0x8139, name: "AT-2500TX V3 Ethernet" },
	] },
	Vendor { id: 0x001C, name: "PEAK-System Technik GmbH", devices: &[
		Device { id: 0x0001, name: "PCAN-PCI CAN-Bus controller" },
	] },
	Vendor { id: 0x003D, name: "Lockheed Martin-Marietta Corp", devices: &[
	] },
	Vendor { id: 0x0059, name: "Tiger Jet Network Inc. (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x0070, name: "Hauppauge computer works Inc.", devices: &[
		Device { id: 0x7801, name: "WinTV HVR-1800 MCE" },
	] },
	Vendor { id: 0x0071, name: "Nebula Electronics Ltd.", devices: &[
	] },
	Vendor { id: 0x0095, name: "Silicon Image, Inc. (Wrong ID)", devices: &[
		Device { id: 0x0680, name: "Ultra ATA/133 IDE RAID CONTROLLER CARD" },
	] },
	Vendor { id: 0x00A7, name: "Teles AG (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x0100, name: "Thales e-Security", devices: &[
	] },
	Vendor { id: 0x0123, name: "General Dynamics", devices: &[
	] },
	Vendor { id: 0x018A, name: "LevelOne", devices: &[
		Device { id: 0x0106, name: "FPC-0106TX misprogrammed [RTL81xx]" },
	] },
	Vendor { id: 0x021B, name: "Compaq Computer Corporation", devices: &[
		Device { id: 0x8139, name: "HNE-300 (RealTek RTL8139c) [iPaq Networking]" },
	] },
	Vendor { id: 0x0270, name: "Hauppauge computer works Inc. (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x0291, name: "Davicom Semiconductor, Inc. (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x02AC, name: "SpeedStream", devices: &[
		Device { id: 0x1012, name: "1012 PCMCIA 10/100 Ethernet Card [RTL81xx]" },
	] },
	Vendor { id: 0x02E0, name: "XFX Pine Group Inc. (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x0303, name: "Hewlett-Packard Company (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x0308, name: "ZyXEL Communications Corporation (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x0315, name: "SK-Electronics Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x0357, name: "TTTech Computertechnik AG (Wrong ID)", devices: &[
		Device { id: 0x000A, name: "TTP-Monitoring Card V2.0" },
	] },
	Vendor { id: 0x0432, name: "SCM Microsystems, Inc.", devices: &[
		Device { id: 0x0001, name: "Pluto2 DVB-T Receiver for PCMCIA [EasyWatch MobilSet]" },
	] },
	Vendor { id: 0x0675, name: "Dynalink", devices: &[
		Device { id: 0x1700, name: "IS64PH ISDN Adapter" },
		Device { id: 0x1702, name: "IS64PH ISDN Adapter" },
		Device { id: 0x1703, name: "ISDN Adapter (PCI Bus, DV, W)" },
		Device { id: 0x1704, name: "ISDN Adapter (PCI Bus, D, C)" },
	] },
	Vendor { id: 0x0721, name: "Sapphire, Inc.", devices: &[
	] },
	Vendor { id: 0x0777, name: "Ubiquiti Networks, Inc.", devices: &[
	] },
	Vendor { id: 0x0795, name: "Wired Inc.", devices: &[
		Device { id: 0x6663, name: "Butane II (MPEG2 encoder board)" },
		Device { id: 0x6666, name: "MediaPress (MPEG2 encoder board)" },
	] },
	Vendor { id: 0x07D1, name: "D-Link System Inc", devices: &[
	] },
	Vendor { id: 0x0925, name: "VIA Technologies, Inc. (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x0A89, name: "BREA Technologies Inc", devices: &[
	] },
	Vendor { id: 0x0B0B, name: "Rhino Equipment Corp.", devices: &[
		Device { id: 0x0105, name: "R1T1" },
		Device { id: 0x0205, name: "R4FXO" },
		Device { id: 0x0206, name: "RCB4FXO 4-channel FXO analog telephony card" },
		Device { id: 0x0305, name: "R4T1" },
		Device { id: 0x0405, name: "R8FXX" },
		Device { id: 0x0406, name: "RCB8FXX 8-channel modular analog telephony card" },
		Device { id: 0x0505, name: "R24FXX" },
		Device { id: 0x0506, name: "RCB24FXS 24-Channel FXS analog telephony card" },
		Device { id: 0x0605, name: "R2T1" },
		Device { id: 0x0705, name: "R24FXS" },
		Device { id: 0x0706, name: "RCB24FXO 24-Channel FXO analog telephony card" },
		Device { id: 0x0905, name: "R1T3 Single T3 Digital Telephony Card" },
		Device { id: 0x0906, name: "RCB24FXX 24-channel modular analog telephony card" },
		Device { id: 0x0A06, name: "RCB672FXX 672-channel modular analog telephony card" },
	] },
	Vendor { id: 0x0E11, name: "Compaq Computer Corporation", devices: &[
		Device { id: 0x0001, name: "PCI to EISA Bridge" },
		Device { id: 0x0002, name: "PCI to ISA Bridge" },
		Device { id: 0x0046, name: "Smart Array 64xx" },
		Device { id: 0x0049, name: "NC7132 Gigabit Upgrade Module" },
		Device { id: 0x004A, name: "NC6136 Gigabit Server Adapter" },
		Device { id: 0x005A, name: "Remote Insight II board - Lights-Out" },
		Device { id: 0x007C, name: "NC7770 1000BaseTX" },
		Device { id: 0x007D, name: "NC6770 1000BaseTX" },
		Device { id: 0x0085, name: "NC7780 1000BaseTX" },
		Device { id: 0x00B1, name: "Remote Insight II board - PCI device" },
		Device { id: 0x00BB, name: "NC7760" },
		Device { id: 0x00CA, name: "NC7771" },
		Device { id: 0x00CB, name: "NC7781" },
		Device { id: 0x00CF, name: "NC7772" },
		Device { id: 0x00D0, name: "NC7782" },
		Device { id: 0x00D1, name: "NC7783" },
		Device { id: 0x00E3, name: "NC7761" },
		Device { id: 0x0508, name: "Netelligent 4/16 Token Ring" },
		Device { id: 0x1000, name: "Triflex/Pentium Bridge, Model 1000" },
		Device { id: 0x2000, name: "Triflex/Pentium Bridge, Model 2000" },
		Device { id: 0x3032, name: "QVision 1280/p" },
		Device { id: 0x3033, name: "QVision 1280/p" },
		Device { id: 0x3034, name: "QVision 1280/p" },
		Device { id: 0x4000, name: "4000 [Triflex]" },
		Device { id: 0x4040, name: "Integrated Array" },
		Device { id: 0x4048, name: "Compaq Raid LC2" },
		Device { id: 0x4050, name: "Smart Array 4200" },
		Device { id: 0x4051, name: "Smart Array 4250ES" },
		Device { id: 0x4058, name: "Smart Array 431" },
		Device { id: 0x4070, name: "Smart Array 5300" },
		Device { id: 0x4080, name: "Smart Array 5i" },
		Device { id: 0x4082, name: "Smart Array 532" },
		Device { id: 0x4083, name: "Smart Array 5312" },
		Device { id: 0x4091, name: "Smart Array 6i" },
		Device { id: 0x409A, name: "Smart Array 641" },
		Device { id: 0x409B, name: "Smart Array 642" },
		Device { id: 0x409C, name: "Smart Array 6400" },
		Device { id: 0x409D, name: "Smart Array 6400 EM" },
		Device { id: 0x6010, name: "HotPlug PCI Bridge 6010" },
		Device { id: 0x7020, name: "USB Controller" },
		Device { id: 0xA0EC, name: "Fibre Channel Host Controller" },
		Device { id: 0xA0F0, name: "Advanced System Management Controller" },
		Device { id: 0xA0F3, name: "Triflex PCI to ISA Bridge" },
		Device { id: 0xA0F7, name: "PCI Hotplug Controller" },
		Device { id: 0xA0F8, name: "ZFMicro Chipset USB" },
		Device { id: 0xA0FC, name: "FibreChannel HBA Tachyon" },
		Device { id: 0xAE10, name: "Smart-2/P RAID Controller" },
		Device { id: 0xAE29, name: "MIS-L" },
		Device { id: 0xAE2A, name: "MPC" },
		Device { id: 0xAE2B, name: "MIS-E" },
		Device { id: 0xAE31, name: "System Management Controller" },
		Device { id: 0xAE32, name: "Netelligent 10/100 TX PCI UTP" },
		Device { id: 0xAE33, name: "Triflex Dual EIDE Controller" },
		Device { id: 0xAE34, name: "Netelligent 10 T PCI UTP" },
		Device { id: 0xAE35, name: "Integrated NetFlex-3/P" },
		Device { id: 0xAE40, name: "Netelligent Dual 10/100 TX PCI UTP" },
		Device { id: 0xAE43, name: "Netelligent Integrated 10/100 TX UTP" },
		Device { id: 0xAE69, name: "CETUS-L" },
		Device { id: 0xAE6C, name: "Northstar" },
		Device { id: 0xAE6D, name: "NorthStar CPU to PCI Bridge" },
		Device { id: 0xB011, name: "Netelligent 10/100 TX Embedded UTP" },
		Device { id: 0xB012, name: "Netelligent 10 T/2 PCI UTP/Coax" },
		Device { id: 0xB01E, name: "NC3120 Fast Ethernet NIC" },
		Device { id: 0xB01F, name: "NC3122 Fast Ethernet NIC" },
		Device { id: 0xB02F, name: "NC1120 Ethernet NIC" },
		Device { id: 0xB030, name: "Netelligent 10/100 TX UTP" },
		Device { id: 0xB04A, name: "10/100 TX PCI Intel WOL UTP Controller" },
		Device { id: 0xB060, name: "Smart Array 5300 Controller" },
		Device { id: 0xB0C6, name: "NC3161 Fast Ethernet NIC" },
		Device { id: 0xB0C7, name: "NC3160 Fast Ethernet NIC" },
		Device { id: 0xB0D7, name: "NC3121 Fast Ethernet NIC" },
		Device { id: 0xB0DD, name: "NC3131 Fast Ethernet NIC" },
		Device { id: 0xB0DE, name: "NC3132 Fast Ethernet Module" },
		Device { id: 0xB0DF, name: "NC6132 Gigabit Module" },
		Device { id: 0xB0E0, name: "NC6133 Gigabit Module" },
		Device { id: 0xB0E1, name: "NC3133 Fast Ethernet Module" },
		Device { id: 0xB123, name: "NC6134 Gigabit NIC" },
		Device { id: 0xB134, name: "NC3163 Fast Ethernet NIC" },
		Device { id: 0xB13C, name: "NC3162 Fast Ethernet NIC" },
		Device { id: 0xB144, name: "NC3123 Fast Ethernet NIC" },
		Device { id: 0xB163, name: "NC3134 Fast Ethernet NIC" },
		Device { id: 0xB164, name: "NC3165 Fast Ethernet Upgrade Module" },
		Device { id: 0xB178, name: "Smart Array 5i/532" },
		Device { id: 0xB1A4, name: "NC7131 Gigabit Server Adapter" },
		Device { id: 0xB200, name: "Memory Hot-Plug Controller" },
		Device { id: 0xB203, name: "Integrated Lights Out Controller" },
		Device { id: 0xB204, name: "Integrated Lights Out  Processor" },
		Device { id: 0xC000, name: "Remote Insight Lights-Out Edition" },
		Device { id: 0xF130, name: "NetFlex-3/P ThunderLAN 1.0" },
		Device { id: 0xF150, name: "NetFlex-3/P ThunderLAN 2.3" },
	] },
	Vendor { id: 0x0E55, name: "HaSoTec GmbH", devices: &[
	] },
	Vendor { id: 0x0EAC, name: "SHF Communication Technologies AG", devices: &[
		Device { id: 0x0008, name: "Ethernet Powerlink Managing Node 01" },
	] },
	Vendor { id: 0x0F62, name: "Acrox Technologies Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1000, name: "LSI Logic / Symbios Logic", devices: &[
		Device { id: 0x0001, name: "53c810" },
		Device { id: 0x0002, name: "53c820" },
		Device { id: 0x0003, name: "53c825" },
		Device { id: 0x0004, name: "53c815" },
		Device { id: 0x0005, name: "53c810AP" },
		Device { id: 0x0006, name: "53c860" },
		Device { id: 0x000A, name: "53c1510" },
		Device { id: 0x000B, name: "53C896/897" },
		Device { id: 0x000C, name: "53c895" },
		Device { id: 0x000D, name: "53c885" },
		Device { id: 0x000F, name: "53c875" },
		Device { id: 0x0010, name: "53C1510" },
		Device { id: 0x0012, name: "53c895a" },
		Device { id: 0x0013, name: "53c875a" },
		Device { id: 0x0014, name: "MegaRAID Tri-Mode SAS3516" },
		Device { id: 0x0015, name: "MegaRAID Tri-Mode SAS3416" },
		Device { id: 0x0016, name: "MegaRAID Tri-Mode SAS3508" },
		Device { id: 0x0017, name: "MegaRAID Tri-Mode SAS3408" },
		Device { id: 0x001B, name: "MegaRAID Tri-Mode SAS3504" },
		Device { id: 0x001C, name: "MegaRAID Tri-Mode SAS3404" },
		Device { id: 0x0020, name: "53c1010 Ultra3 SCSI Adapter" },
		Device { id: 0x0021, name: "53c1010 66MHz  Ultra3 SCSI Adapter" },
		Device { id: 0x002F, name: "MegaRAID SAS 2208 IOV [Thunderbolt]" },
		Device { id: 0x0030, name: "53c1030 PCI-X Fusion-MPT Dual Ultra320 SCSI" },
		Device { id: 0x0031, name: "53c1030ZC PCI-X Fusion-MPT Dual Ultra320 SCSI" },
		Device { id: 0x0032, name: "53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI" },
		Device { id: 0x0033, name: "1030ZC_53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI" },
		Device { id: 0x0040, name: "53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI" },
		Device { id: 0x0041, name: "53C1035ZC PCI-X Fusion-MPT Dual Ultra320 SCSI" },
		Device { id: 0x0050, name: "SAS1064 PCI-X Fusion-MPT SAS" },
		Device { id: 0x0052, name: "MegaRAID SAS-3 3216/3224 [Cutlass]" },
		Device { id: 0x0053, name: "MegaRAID SAS-3 3216/3224 [Cutlass]" },
		Device { id: 0x0054, name: "SAS1068 PCI-X Fusion-MPT SAS" },
		Device { id: 0x0055, name: "SAS1068 PCI-X Fusion-MPT SAS" },
		Device { id: 0x0056, name: "SAS1064ET PCI-Express Fusion-MPT SAS" },
		Device { id: 0x0057, name: "M1064E MegaRAID SAS" },
		Device { id: 0x0058, name: "SAS1068E PCI-Express Fusion-MPT SAS" },
		Device { id: 0x0059, name: "MegaRAID SAS 8208ELP/8208ELP" },
		Device { id: 0x005A, name: "SAS1066E PCI-Express Fusion-MPT SAS" },
		Device { id: 0x005B, name: "MegaRAID SAS 2208 [Thunderbolt]" },
		Device { id: 0x005C, name: "SAS1064A PCI-X Fusion-MPT SAS" },
		Device { id: 0x005D, name: "MegaRAID SAS-3 3108 [Invader]" },
		Device { id: 0x005E, name: "SAS1066 PCI-X Fusion-MPT SAS" },
		Device { id: 0x005F, name: "MegaRAID SAS-3 3008 [Fury]" },
		Device { id: 0x0060, name: "MegaRAID SAS 1078" },
		Device { id: 0x0062, name: "SAS1078 PCI-Express Fusion-MPT SAS" },
		Device { id: 0x0064, name: "SAS2116 PCI-Express Fusion-MPT SAS-2 [Meteor]" },
		Device { id: 0x0065, name: "SAS2116 PCI-Express Fusion-MPT SAS-2 [Meteor]" },
		Device { id: 0x006E, name: "SAS2308 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x0070, name: "SAS2004 PCI-Express Fusion-MPT SAS-2 [Spitfire]" },
		Device { id: 0x0071, name: "MR SAS HBA 2004" },
		Device { id: 0x0072, name: "SAS2008 PCI-Express Fusion-MPT SAS-2 [Falcon]" },
		Device { id: 0x0073, name: "MegaRAID SAS 2008 [Falcon]" },
		Device { id: 0x0074, name: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]" },
		Device { id: 0x0076, name: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]" },
		Device { id: 0x0077, name: "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator]" },
		Device { id: 0x0079, name: "MegaRAID SAS 2108 [Liberator]" },
		Device { id: 0x007C, name: "MegaRAID SAS 1078DE" },
		Device { id: 0x007E, name: "SSS6200 PCI-Express Flash SSD" },
		Device { id: 0x0080, name: "SAS2208 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x0081, name: "SAS2208 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x0082, name: "SAS2208 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x0083, name: "SAS2208 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x0084, name: "SAS2208 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x0085, name: "SAS2208 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x0086, name: "SAS2308 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x0087, name: "SAS2308 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x008F, name: "53c875J" },
		Device { id: 0x0090, name: "SAS3108 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x0091, name: "SAS3108 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x0094, name: "SAS3108 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x0095, name: "SAS3108 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x0096, name: "SAS3004 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x0097, name: "SAS3008 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00AB, name: "SAS3516 Fusion-MPT Tri-Mode RAID On Chip (ROC)" },
		Device { id: 0x00AC, name: "SAS3416 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)" },
		Device { id: 0x00AE, name: "SAS3508 Fusion-MPT Tri-Mode RAID On Chip (ROC)" },
		Device { id: 0x00AF, name: "SAS3408 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)" },
		Device { id: 0x00BE, name: "SAS3504 Fusion-MPT Tri-Mode RAID On Chip (ROC)" },
		Device { id: 0x00BF, name: "SAS3404 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)" },
		Device { id: 0x00C0, name: "SAS3324 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C1, name: "SAS3324 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C2, name: "SAS3324 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C3, name: "SAS3324 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C4, name: "SAS3224 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C5, name: "SAS3316 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C6, name: "SAS3316 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C7, name: "SAS3316 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C8, name: "SAS3316 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00C9, name: "SAS3216 PCI-Express Fusion-MPT SAS-3" },
		Device { id: 0x00CE, name: "MegaRAID SAS-3 3316 [Intruder]" },
		Device { id: 0x00CF, name: "MegaRAID SAS-3 3324 [Intruder]" },
		Device { id: 0x00D0, name: "SAS3716 Fusion-MPT Tri-Mode RAID Controller Chip (ROC)" },
		Device { id: 0x00D1, name: "SAS3616 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)" },
		Device { id: 0x00D3, name: "MegaRAID Tri-Mode SAS3716W" },
		Device { id: 0x02B0, name: "Virtual Endpoint on PCIe Switch" },
		Device { id: 0x0407, name: "MegaRAID" },
		Device { id: 0x0408, name: "MegaRAID" },
		Device { id: 0x0409, name: "MegaRAID" },
		Device { id: 0x0411, name: "MegaRAID SAS 1068" },
		Device { id: 0x0413, name: "MegaRAID SAS 1068 [Verde ZCR]" },
		Device { id: 0x0621, name: "FC909 Fibre Channel Adapter" },
		Device { id: 0x0622, name: "FC929 Fibre Channel Adapter" },
		Device { id: 0x0623, name: "FC929 LAN" },
		Device { id: 0x0624, name: "FC919 Fibre Channel Adapter" },
		Device { id: 0x0625, name: "FC919 LAN" },
		Device { id: 0x0626, name: "FC929X Fibre Channel Adapter" },
		Device { id: 0x0627, name: "FC929X LAN" },
		Device { id: 0x0628, name: "FC919X Fibre Channel Adapter" },
		Device { id: 0x0629, name: "FC919X LAN" },
		Device { id: 0x0640, name: "FC949X Fibre Channel Adapter" },
		Device { id: 0x0642, name: "FC939X Fibre Channel Adapter" },
		Device { id: 0x0646, name: "FC949ES Fibre Channel Adapter" },
		Device { id: 0x0701, name: "83C885 NT50 DigitalScape Fast Ethernet" },
		Device { id: 0x0702, name: "Yellowfin G-NIC gigabit ethernet" },
		Device { id: 0x0804, name: "SA2010" },
		Device { id: 0x0805, name: "SA2010ZC" },
		Device { id: 0x0806, name: "SA2020" },
		Device { id: 0x0807, name: "SA2020ZC" },
		Device { id: 0x0901, name: "61C102" },
		Device { id: 0x1000, name: "63C815" },
		Device { id: 0x1960, name: "MegaRAID" },
		Device { id: 0x3050, name: "SAS2008 PCI-Express Fusion-MPT SAS-2" },
		Device { id: 0x6001, name: "DX1 Multiformat Broadcast HD/SD Encoder/Decoder" },
	] },
	Vendor { id: 0x1001, name: "Kolter Electronic", devices: &[
		Device { id: 0x0010, name: "PCI 1616 Measurement card with 32 digital I/O lines" },
		Device { id: 0x0011, name: "OPTO-PCI Opto-Isolated digital I/O board" },
		Device { id: 0x0012, name: "PCI-AD/DA Analogue I/O board" },
		Device { id: 0x0013, name: "PCI-OPTO-RELAIS Digital I/O board with relay outputs" },
		Device { id: 0x0014, name: "PCI-Counter/Timer Counter Timer board" },
		Device { id: 0x0015, name: "PCI-DAC416 Analogue output board" },
		Device { id: 0x0016, name: "PCI-MFB Analogue I/O board" },
		Device { id: 0x0017, name: "PROTO-3 PCI Prototyping board" },
		Device { id: 0x9100, name: "INI-9100/9100W SCSI Host" },
	] },
	Vendor { id: 0x1002, name: "Advanced Micro Devices, Inc. [AMD/ATI]", devices: &[
		Device { id: 0x1304, name: "Kaveri" },
		Device { id: 0x1305, name: "Kaveri" },
		Device { id: 0x1306, name: "Kaveri" },
		Device { id: 0x1307, name: "Kaveri" },
		Device { id: 0x1308, name: "Kaveri HDMI/DP Audio Controller" },
		Device { id: 0x1309, name: "Kaveri [Radeon R6/R7 Graphics]" },
		Device { id: 0x130A, name: "Kaveri [Radeon R6 Graphics]" },
		Device { id: 0x130B, name: "Kaveri [Radeon R4 Graphics]" },
		Device { id: 0x130C, name: "Kaveri [Radeon R7 Graphics]" },
		Device { id: 0x130D, name: "Kaveri [Radeon R6 Graphics]" },
		Device { id: 0x130E, name: "Kaveri [Radeon R5 Graphics]" },
		Device { id: 0x130F, name: "Kaveri [Radeon R7 Graphics]" },
		Device { id: 0x1310, name: "Kaveri" },
		Device { id: 0x1311, name: "Kaveri" },
		Device { id: 0x1312, name: "Kaveri" },
		Device { id: 0x1313, name: "Kaveri [Radeon R7 Graphics]" },
		Device { id: 0x1314, name: "Wrestler HDMI Audio" },
		Device { id: 0x1315, name: "Kaveri [Radeon R5 Graphics]" },
		Device { id: 0x1316, name: "Kaveri [Radeon R5 Graphics]" },
		Device { id: 0x1317, name: "Kaveri" },
		Device { id: 0x1318, name: "Kaveri [Radeon R5 Graphics]" },
		Device { id: 0x131B, name: "Kaveri [Radeon R4 Graphics]" },
		Device { id: 0x131C, name: "Kaveri [Radeon R7 Graphics]" },
		Device { id: 0x131D, name: "Kaveri [Radeon R6 Graphics]" },
		Device { id: 0x15DD, name: "Radeon Vega 8 Mobile" },
		Device { id: 0x1714, name: "BeaverCreek HDMI Audio [Radeon HD 6500D and 6400G-6600G series]" },
		Device { id: 0x3150, name: "RV380/M24 [Mobility Radeon X600]" },
		Device { id: 0x3151, name: "RV380 GL [FireMV 2400]" },
		Device { id: 0x3152, name: "RV370/M22 [Mobility Radeon X300]" },
		Device { id: 0x3154, name: "RV380/M24 GL [Mobility FireGL V3200]" },
		Device { id: 0x3155, name: "RV380 GL [FireMV 2400]" },
		Device { id: 0x3171, name: "RV380 GL [FireMV 2400] (Secondary)" },
		Device { id: 0x3E50, name: "RV380 [Radeon X600]" },
		Device { id: 0x3E54, name: "RV380 GL [FireGL V3200]" },
		Device { id: 0x3E70, name: "RV380 [Radeon X600] (Secondary)" },
		Device { id: 0x4136, name: "RS100 [Mobility IGP 320M]" },
		Device { id: 0x4137, name: "RS200 [Radeon IGP 340]" },
		Device { id: 0x4144, name: "R300 [Radeon 9500]" },
		Device { id: 0x4146, name: "R300 [Radeon 9700 PRO]" },
		Device { id: 0x4147, name: "R300 GL [FireGL Z1]" },
		Device { id: 0x4148, name: "R350 [Radeon 9800/9800 SE]" },
		Device { id: 0x4150, name: "RV350 [Radeon 9550/9600/X1050 Series]" },
		Device { id: 0x4151, name: "RV350 [Radeon 9600 Series]" },
		Device { id: 0x4152, name: "RV360 [Radeon 9600/X1050 Series]" },
		Device { id: 0x4153, name: "RV350 [Radeon 9550]" },
		Device { id: 0x4154, name: "RV350 GL [FireGL T2]" },
		Device { id: 0x4155, name: "RV350 [Radeon 9600]" },
		Device { id: 0x4157, name: "RV350 GL [FireGL T2]" },
		Device { id: 0x4158, name: "68800AX [Graphics Ultra Pro PCI]" },
		Device { id: 0x4164, name: "R300 [Radeon 9500 PRO] (Secondary)" },
		Device { id: 0x4165, name: "R300 [Radeon 9700 PRO] (Secondary)" },
		Device { id: 0x4166, name: "R300 [Radeon 9700 PRO] (Secondary)" },
		Device { id: 0x4168, name: "RV350 [Radeon 9800 SE] (Secondary)" },
		Device { id: 0x4170, name: "RV350 [Radeon 9550/9600/X1050 Series] (Secondary)" },
		Device { id: 0x4171, name: "RV350 [Radeon 9600] (Secondary)" },
		Device { id: 0x4172, name: "RV350 [Radeon 9600/X1050 Series] (Secondary)" },
		Device { id: 0x4173, name: "RV350 [Radeon 9550] (Secondary)" },
		Device { id: 0x4242, name: "R200 [All-In-Wonder Radeon 8500 DV]" },
		Device { id: 0x4243, name: "R200 PCI Bridge [All-in-Wonder Radeon 8500DV]" },
		Device { id: 0x4336, name: "RS100 [Radeon IGP 320M]" },
		Device { id: 0x4337, name: "RS200M [Radeon IGP 330M/340M/345M/350M]" },
		Device { id: 0x4341, name: "IXP150 AC'97 Audio Controller" },
		Device { id: 0x4342, name: "IXP200 3COM 3C920B Ethernet Controller" },
		Device { id: 0x4345, name: "EHCI USB Controller" },
		Device { id: 0x4347, name: "OHCI USB Controller #1" },
		Device { id: 0x4348, name: "OHCI USB Controller #2" },
		Device { id: 0x4349, name: "Dual Channel Bus Master PCI IDE Controller" },
		Device { id: 0x434D, name: "IXP AC'97 Modem" },
		Device { id: 0x4353, name: "SMBus" },
		Device { id: 0x4354, name: "215CT [Mach64 CT PCI]" },
		Device { id: 0x4358, name: "210888CX [Mach64 CX]" },
		Device { id: 0x4361, name: "IXP SB300 AC'97 Audio Controller" },
		Device { id: 0x4363, name: "SMBus" },
		Device { id: 0x436E, name: "436E Serial ATA Controller" },
		Device { id: 0x4370, name: "IXP SB400 AC'97 Audio Controller" },
		Device { id: 0x4371, name: "IXP SB4x0 PCI-PCI Bridge" },
		Device { id: 0x4372, name: "IXP SB4x0 SMBus Controller" },
		Device { id: 0x4373, name: "IXP SB4x0 USB2 Host Controller" },
		Device { id: 0x4374, name: "IXP SB4x0 USB Host Controller" },
		Device { id: 0x4375, name: "IXP SB4x0 USB Host Controller" },
		Device { id: 0x4376, name: "IXP SB4x0 IDE Controller" },
		Device { id: 0x4377, name: "IXP SB4x0 PCI-ISA Bridge" },
		Device { id: 0x4378, name: "IXP SB400 AC'97 Modem Controller" },
		Device { id: 0x4379, name: "IXP SB4x0 Serial ATA Controller" },
		Device { id: 0x437A, name: "IXP SB400 Serial ATA Controller" },
		Device { id: 0x437B, name: "IXP SB4x0 High Definition Audio Controller" },
		Device { id: 0x4380, name: "SB600 Non-Raid-5 SATA" },
		Device { id: 0x4381, name: "SB600 SATA Controller (RAID 5 mode)" },
		Device { id: 0x4382, name: "SB600 AC97 Audio" },
		Device { id: 0x4383, name: "SBx00 Azalia (Intel HDA)" },
		Device { id: 0x4384, name: "SBx00 PCI to PCI Bridge" },
		Device { id: 0x4385, name: "SBx00 SMBus Controller" },
		Device { id: 0x4386, name: "SB600 USB Controller (EHCI)" },
		Device { id: 0x4387, name: "SB600 USB (OHCI0)" },
		Device { id: 0x4388, name: "SB600 USB (OHCI1)" },
		Device { id: 0x4389, name: "SB600 USB (OHCI2)" },
		Device { id: 0x438A, name: "SB600 USB (OHCI3)" },
		Device { id: 0x438B, name: "SB600 USB (OHCI4)" },
		Device { id: 0x438C, name: "SB600 IDE" },
		Device { id: 0x438D, name: "SB600 PCI to LPC Bridge" },
		Device { id: 0x438E, name: "SB600 AC97 Modem" },
		Device { id: 0x4390, name: "SB7x0/SB8x0/SB9x0 SATA Controller [IDE mode]" },
		Device { id: 0x4391, name: "SB7x0/SB8x0/SB9x0 SATA Controller [AHCI mode]" },
		Device { id: 0x4392, name: "SB7x0/SB8x0/SB9x0 SATA Controller [Non-RAID5 mode]" },
		Device { id: 0x4393, name: "SB7x0/SB8x0/SB9x0 SATA Controller [RAID5 mode]" },
		Device { id: 0x4394, name: "SB7x0/SB8x0/SB9x0 SATA Controller [AHCI mode]" },
		Device { id: 0x4395, name: "SB8x0/SB9x0 SATA Controller [Storage mode]" },
		Device { id: 0x4396, name: "SB7x0/SB8x0/SB9x0 USB EHCI Controller" },
		Device { id: 0x4397, name: "SB7x0/SB8x0/SB9x0 USB OHCI0 Controller" },
		Device { id: 0x4398, name: "SB7x0 USB OHCI1 Controller" },
		Device { id: 0x4399, name: "SB7x0/SB8x0/SB9x0 USB OHCI2 Controller" },
		Device { id: 0x439C, name: "SB7x0/SB8x0/SB9x0 IDE Controller" },
		Device { id: 0x439D, name: "SB7x0/SB8x0/SB9x0 LPC host controller" },
		Device { id: 0x43A0, name: "SB700/SB800/SB900 PCI to PCI bridge (PCIE port 0)" },
		Device { id: 0x43A1, name: "SB700/SB800/SB900 PCI to PCI bridge (PCIE port 1)" },
		Device { id: 0x43A2, name: "SB900 PCI to PCI bridge (PCIE port 2)" },
		Device { id: 0x43A3, name: "SB900 PCI to PCI bridge (PCIE port 3)" },
		Device { id: 0x4437, name: "RS250 [Mobility Radeon 7000 IGP]" },
		Device { id: 0x4554, name: "210888ET [Mach64 ET]" },
		Device { id: 0x4654, name: "Mach64 VT" },
		Device { id: 0x4742, name: "3D Rage PRO AGP 2X" },
		Device { id: 0x4744, name: "3D Rage PRO AGP 1X" },
		Device { id: 0x4749, name: "3D Rage PRO PCI" },
		Device { id: 0x474D, name: "Rage XL AGP 2X" },
		Device { id: 0x474E, name: "Rage XC AGP" },
		Device { id: 0x474F, name: "Rage XL" },
		Device { id: 0x4750, name: "3D Rage Pro PCI" },
		Device { id: 0x4752, name: "Rage XL PCI" },
		Device { id: 0x4753, name: "Rage XC" },
		Device { id: 0x4754, name: "3D Rage II/II+ PCI [Mach64 GT]" },
		Device { id: 0x4755, name: "Mach64 GTB [3D Rage II+ DVD]" },
		Device { id: 0x4756, name: "3D Rage IIC PCI [Mach64 GT IIC]" },
		Device { id: 0x4757, name: "3D Rage IIC AGP" },
		Device { id: 0x4758, name: "210888GX [Mach64 GX PCI]" },
		Device { id: 0x4759, name: "3D Rage IIC PCI" },
		Device { id: 0x475A, name: "3D Rage IIC AGP" },
		Device { id: 0x4966, name: "RV250 [Radeon 9000 Series]" },
		Device { id: 0x496E, name: "RV250 [Radeon 9000] (Secondary)" },
		Device { id: 0x4A49, name: "R420 [Radeon X800 PRO/GTO AGP]" },
		Device { id: 0x4A4A, name: "R420 [Radeon X800 GT AGP]" },
		Device { id: 0x4A4B, name: "R420 [Radeon X800 AGP Series]" },
		Device { id: 0x4A4D, name: "R420 GL [FireGL X3-256]" },
		Device { id: 0x4A4E, name: "RV420/M18 [Mobility Radeon 9800]" },
		Device { id: 0x4A4F, name: "R420 [Radeon X850 AGP]" },
		Device { id: 0x4A50, name: "R420 [Radeon X800 XT Platinum Edition AGP]" },
		Device { id: 0x4A54, name: "R420 [Radeon X800 VE AGP]" },
		Device { id: 0x4A69, name: "R420 [Radeon X800 PRO/GTO] (Secondary)" },
		Device { id: 0x4A6A, name: "R420 [Radeon X800] (Secondary)" },
		Device { id: 0x4A6B, name: "R420 [Radeon X800 XT AGP] (Secondary)" },
		Device { id: 0x4A70, name: "R420 [Radeon X800 XT Platinum Edition AGP] (Secondary)" },
		Device { id: 0x4A74, name: "R420 [Radeon X800 VE] (Secondary)" },
		Device { id: 0x4B49, name: "R481 [Radeon X850 XT AGP]" },
		Device { id: 0x4B4B, name: "R481 [Radeon X850 PRO AGP]" },
		Device { id: 0x4B4C, name: "R481 [Radeon X850 XT Platinum Edition AGP]" },
		Device { id: 0x4B69, name: "R481 [Radeon X850 XT AGP] (Secondary)" },
		Device { id: 0x4B6B, name: "R481 [Radeon X850 PRO AGP] (Secondary)" },
		Device { id: 0x4B6C, name: "R481 [Radeon X850 XT Platinum Edition AGP] (Secondary)" },
		Device { id: 0x4C42, name: "3D Rage LT PRO AGP 2X" },
		Device { id: 0x4C46, name: "Rage Mobility 128 AGP 2X/Mobility M3" },
		Device { id: 0x4C47, name: "3D Rage IIC PCI / Mobility Radeon 7500/7500C" },
		Device { id: 0x4C49, name: "3D Rage LT PRO PCI" },
		Device { id: 0x4C4D, name: "Rage Mobility AGP 2x Series" },
		Device { id: 0x4C50, name: "3D Rage LT PRO PCI" },
		Device { id: 0x4C52, name: "Rage Mobility-M1 PCI" },
		Device { id: 0x4C54, name: "264LT [Mach64 LT]" },
		Device { id: 0x4C57, name: "RV200/M7 [Mobility Radeon 7500]" },
		Device { id: 0x4C58, name: "RV200/M7 GL [Mobility FireGL 7800]" },
		Device { id: 0x4C59, name: "RV100/M6 [Rage/Radeon Mobility Series]" },
		Device { id: 0x4C66, name: "RV250/M9 GL [Mobility FireGL 9000/Radeon 9000]" },
		Device { id: 0x4C6E, name: "RV250/M9 [Mobility Radeon 9000] (Secondary)" },
		Device { id: 0x4D46, name: "Rage Mobility 128 AGP 4X/Mobility M4" },
		Device { id: 0x4D52, name: "Theater 550 PRO PCI [ATI TV Wonder 550]" },
		Device { id: 0x4D53, name: "Theater 550 PRO PCIe" },
		Device { id: 0x4E44, name: "R300 [Radeon 9700/9700 PRO]" },
		Device { id: 0x4E45, name: "R300 [Radeon 9500 PRO/9700]" },
		Device { id: 0x4E46, name: "R300 [Radeon 9600 TX]" },
		Device { id: 0x4E47, name: "R300 GL [FireGL X1]" },
		Device { id: 0x4E48, name: "R350 [Radeon 9800 Series]" },
		Device { id: 0x4E49, name: "R350 [Radeon 9800]" },
		Device { id: 0x4E4A, name: "R360 [Radeon 9800 XXL/XT]" },
		Device { id: 0x4E4B, name: "R350 GL [FireGL X2 AGP Pro]" },
		Device { id: 0x4E50, name: "RV350/M10 / RV360/M11 [Mobility Radeon 9600 (PRO) / 9700]" },
		Device { id: 0x4E51, name: "RV350 [Radeon 9550/9600/X1050 Series]" },
		Device { id: 0x4E52, name: "RV350/M10 [Mobility Radeon 9500/9700 SE]" },
		Device { id: 0x4E54, name: "RV350/M10 GL [Mobility FireGL T2]" },
		Device { id: 0x4E56, name: "RV360/M12 [Mobility Radeon 9550]" },
		Device { id: 0x4E64, name: "R300 [Radeon 9700 PRO] (Secondary)" },
		Device { id: 0x4E65, name: "R300 [Radeon 9500 PRO] (Secondary)" },
		Device { id: 0x4E66, name: "RV350 [Radeon 9600] (Secondary)" },
		Device { id: 0x4E67, name: "R300 GL [FireGL X1] (Secondary)" },
		Device { id: 0x4E68, name: "R350 [Radeon 9800 PRO] (Secondary)" },
		Device { id: 0x4E69, name: "R350 [Radeon 9800] (Secondary)" },
		Device { id: 0x4E6A, name: "RV350 [Radeon 9800 XT] (Secondary)" },
		Device { id: 0x4E71, name: "RV350/M10 [Mobility Radeon 9600] (Secondary)" },
		Device { id: 0x4F72, name: "RV250 [Radeon 9000 Series]" },
		Device { id: 0x4F73, name: "RV250 [Radeon 9000 Series] (Secondary)" },
		Device { id: 0x5044, name: "All-In-Wonder 128 PCI" },
		Device { id: 0x5046, name: "Rage 128 PRO AGP 4x TMDS" },
		Device { id: 0x5050, name: "Rage128 [Xpert 128 PCI]" },
		Device { id: 0x5052, name: "Rage 128 PRO AGP 4X TMDS" },
		Device { id: 0x5144, name: "R100 [Radeon 7200 / All-In-Wonder Radeon]" },
		Device { id: 0x5148, name: "R200 GL [FireGL 8800]" },
		Device { id: 0x514C, name: "R200 [Radeon 8500/8500 LE]" },
		Device { id: 0x514D, name: "R200 [Radeon 9100]" },
		Device { id: 0x5157, name: "RV200 [Radeon 7500/7500 LE]" },
		Device { id: 0x5159, name: "RV100 [Radeon 7000 / Radeon VE]" },
		Device { id: 0x515E, name: "ES1000" },
		Device { id: 0x5245, name: "Rage 128 GL PCI" },
		Device { id: 0x5246, name: "Rage Fury/Xpert 128/Xpert 2000 AGP 2x" },
		Device { id: 0x524B, name: "Rage 128 VR PCI" },
		Device { id: 0x524C, name: "Rage 128 VR AGP" },
		Device { id: 0x5346, name: "Rage 128 SF/4x AGP 2x" },
		Device { id: 0x534D, name: "Rage 128 4X AGP 4x" },
		Device { id: 0x5354, name: "Mach 64 VT" },
		Device { id: 0x5446, name: "Rage 128 PRO Ultra AGP 4x" },
		Device { id: 0x5452, name: "Rage 128 PRO Ultra4XL VR-R AGP" },
		Device { id: 0x5460, name: "RV370/M22 [Mobility Radeon X300]" },
		Device { id: 0x5461, name: "RV370/M22 [Mobility Radeon X300]" },
		Device { id: 0x5462, name: "RV380/M24C [Mobility Radeon X600 SE]" },
		Device { id: 0x5464, name: "RV370/M22 GL [Mobility FireGL V3100]" },
		Device { id: 0x5549, name: "R423 [Radeon X800 GTO]" },
		Device { id: 0x554A, name: "R423 [Radeon X800 XT Platinum Edition]" },
		Device { id: 0x554B, name: "R423 [Radeon X800 GT/SE]" },
		Device { id: 0x554D, name: "R430 [Radeon X800 XL]" },
		Device { id: 0x554E, name: "R430 [All-In-Wonder X800 GT]" },
		Device { id: 0x554F, name: "R430 [Radeon X800]" },
		Device { id: 0x5550, name: "R423 GL [FireGL V7100]" },
		Device { id: 0x5551, name: "R423 GL [FireGL V5100]" },
		Device { id: 0x5569, name: "R423 [Radeon X800 PRO] (Secondary)" },
		Device { id: 0x556B, name: "R423 [Radeon X800 GT] (Secondary)" },
		Device { id: 0x556D, name: "R430 [Radeon X800 XL] (Secondary)" },
		Device { id: 0x556F, name: "R430 [Radeon X800] (Secondary)" },
		Device { id: 0x5571, name: "R423 GL [FireGL V5100] (Secondary)" },
		Device { id: 0x564B, name: "RV410/M26 GL [Mobility FireGL V5000]" },
		Device { id: 0x564F, name: "RV410/M26 [Mobility Radeon X700 XL]" },
		Device { id: 0x5652, name: "RV410/M26 [Mobility Radeon X700]" },
		Device { id: 0x5653, name: "RV410/M26 [Mobility Radeon X700]" },
		Device { id: 0x5654, name: "264VT [Mach64 VT]" },
		Device { id: 0x5655, name: "264VT3 [Mach64 VT3]" },
		Device { id: 0x5656, name: "264VT4 [Mach64 VT4]" },
		Device { id: 0x5657, name: "RV410 [Radeon X550 XTX / X700]" },
		Device { id: 0x5830, name: "RS300 Host Bridge" },
		Device { id: 0x5831, name: "RS300 Host Bridge" },
		Device { id: 0x5832, name: "RS300 Host Bridge" },
		Device { id: 0x5833, name: "RS300 Host Bridge" },
		Device { id: 0x5834, name: "RS300 [Radeon 9100 IGP]" },
		Device { id: 0x5835, name: "RS300M [Mobility Radeon 9100 IGP]" },
		Device { id: 0x5838, name: "RS300 AGP Bridge" },
		Device { id: 0x5854, name: "RS480 [Radeon Xpress 200 Series] (Secondary)" },
		Device { id: 0x5874, name: "RS480 [Radeon Xpress 1150] (Secondary)" },
		Device { id: 0x5940, name: "RV280 [Radeon 9200 PRO] (Secondary)" },
		Device { id: 0x5941, name: "RV280 [Radeon 9200] (Secondary)" },
		Device { id: 0x5944, name: "RV280 [Radeon 9200 SE PCI]" },
		Device { id: 0x5950, name: "RS480/RS482/RS485 Host Bridge" },
		Device { id: 0x5951, name: "RX480/RX482 Host Bridge" },
		Device { id: 0x5952, name: "RD580 Host Bridge" },
		Device { id: 0x5954, name: "RS480 [Radeon Xpress 200 Series]" },
		Device { id: 0x5955, name: "RS480M [Mobility Radeon Xpress 200]" },
		Device { id: 0x5956, name: "RD790 Host Bridge" },
		Device { id: 0x5957, name: "RX780/RX790 Host Bridge" },
		Device { id: 0x5958, name: "RD780 Host Bridge" },
		Device { id: 0x5960, name: "RV280 [Radeon 9200 PRO]" },
		Device { id: 0x5961, name: "RV280 [Radeon 9200]" },
		Device { id: 0x5962, name: "RV280 [Radeon 9200]" },
		Device { id: 0x5964, name: "RV280 [Radeon 9200 SE]" },
		Device { id: 0x5965, name: "RV280 GL [FireMV 2200 PCI]" },
		Device { id: 0x5974, name: "RS482/RS485 [Radeon Xpress 1100/1150]" },
		Device { id: 0x5975, name: "RS482M [Mobility Radeon Xpress 200]" },
		Device { id: 0x5978, name: "RX780/RD790 PCI to PCI bridge (external gfx0 port A)" },
		Device { id: 0x5979, name: "RD790 PCI to PCI bridge (external gfx0 port B)" },
		Device { id: 0x597A, name: "RD790 PCI to PCI bridge (PCI express gpp port A)" },
		Device { id: 0x597B, name: "RX780/RD790 PCI to PCI bridge (PCI express gpp port B)" },
		Device { id: 0x597C, name: "RD790 PCI to PCI bridge (PCI express gpp port C)" },
		Device { id: 0x597D, name: "RX780/RD790 PCI to PCI bridge (PCI express gpp port D)" },
		Device { id: 0x597E, name: "RD790 PCI to PCI bridge (PCI express gpp port E)" },
		Device { id: 0x597F, name: "RD790 PCI to PCI bridge (PCI express gpp port F)" },
		Device { id: 0x5980, name: "RD790 PCI to PCI bridge (external gfx1 port A)" },
		Device { id: 0x5981, name: "RD790 PCI to PCI bridge (external gfx1 port B)" },
		Device { id: 0x5982, name: "RD790 PCI to PCI bridge (NB-SB link)" },
		Device { id: 0x5A10, name: "RD890 Northbridge only dual slot (2x16) PCI-e GFX Hydra part" },
		Device { id: 0x5A11, name: "RD890 Northbridge only single slot PCI-e GFX Hydra part" },
		Device { id: 0x5A12, name: "RD890 Northbridge only dual slot (2x8) PCI-e GFX Hydra part" },
		Device { id: 0x5A13, name: "RD890S/SR5650 Host Bridge" },
		Device { id: 0x5A14, name: "RD9x0/RX980 Host Bridge" },
		Device { id: 0x5A15, name: "RD890 PCI to PCI bridge (PCI express gpp port A)" },
		Device { id: 0x5A16, name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GFX port 0)" },
		Device { id: 0x5A17, name: "RD890/RD9x0 PCI to PCI bridge (PCI Express GFX port 1)" },
		Device { id: 0x5A18, name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 0)" },
		Device { id: 0x5A19, name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 1)" },
		Device { id: 0x5A1A, name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 2)" },
		Device { id: 0x5A1B, name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 3)" },
		Device { id: 0x5A1C, name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 4)" },
		Device { id: 0x5A1D, name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 5)" },
		Device { id: 0x5A1E, name: "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP2 Port 0)" },
		Device { id: 0x5A1F, name: "RD890/RD990 PCI to PCI bridge (PCI Express GFX2 port 0)" },
		Device { id: 0x5A20, name: "RD890/RD990 PCI to PCI bridge (PCI Express GFX2 port 1)" },
		Device { id: 0x5A23, name: "RD890S/RD990 I/O Memory Management Unit (IOMMU)" },
		Device { id: 0x5A31, name: "RC410 Host Bridge" },
		Device { id: 0x5A33, name: "RS400 Host Bridge" },
		Device { id: 0x5A34, name: "RS4xx PCI Express Port [ext gfx]" },
		Device { id: 0x5A36, name: "RC4xx/RS4xx PCI Express Port 1" },
		Device { id: 0x5A37, name: "RC4xx/RS4xx PCI Express Port 2" },
		Device { id: 0x5A38, name: "RC4xx/RS4xx PCI Express Port 3" },
		Device { id: 0x5A39, name: "RC4xx/RS4xx PCI Express Port 4" },
		Device { id: 0x5A3F, name: "RC4xx/RS4xx PCI Bridge [int gfx]" },
		Device { id: 0x5A41, name: "RS400 [Radeon Xpress 200]" },
		Device { id: 0x5A42, name: "RS400M [Radeon Xpress 200M]" },
		Device { id: 0x5A61, name: "RC410 [Radeon Xpress 200/1100]" },
		Device { id: 0x5A62, name: "RC410M [Mobility Radeon Xpress 200M]" },
		Device { id: 0x5B60, name: "RV370 [Radeon X300]" },
		Device { id: 0x5B62, name: "RV370 [Radeon X600/X600 SE]" },
		Device { id: 0x5B63, name: "RV370 [Radeon X300/X550/X1050 Series]" },
		Device { id: 0x5B64, name: "RV370 GL [FireGL V3100]" },
		Device { id: 0x5B65, name: "RV370 GL [FireMV 2200]" },
		Device { id: 0x5B66, name: "RV370X" },
		Device { id: 0x5B70, name: "RV370 [Radeon X300 SE]" },
		Device { id: 0x5B72, name: "RV380 [Radeon X300/X550/X1050 Series] (Secondary)" },
		Device { id: 0x5B73, name: "RV370 [Radeon X300/X550/X1050 Series] (Secondary)" },
		Device { id: 0x5B74, name: "RV370 GL [FireGL V3100] (Secondary)" },
		Device { id: 0x5B75, name: "RV370 GL [FireMV 2200] (Secondary)" },
		Device { id: 0x5C61, name: "RV280/M9+ [Mobility Radeon 9200 AGP]" },
		Device { id: 0x5C63, name: "RV280/M9+ [Mobility Radeon 9200 AGP]" },
		Device { id: 0x5D44, name: "RV280 [Radeon 9200 SE] (Secondary)" },
		Device { id: 0x5D45, name: "RV280 GL [FireMV 2200 PCI] (Secondary)" },
		Device { id: 0x5D48, name: "R423/M28 [Mobility Radeon X800 XT]" },
		Device { id: 0x5D49, name: "R423/M28 GL [Mobility FireGL V5100]" },
		Device { id: 0x5D4A, name: "R423/M28 [Mobility Radeon X800]" },
		Device { id: 0x5D4D, name: "R480 [Radeon X850 XT Platinum Edition]" },
		Device { id: 0x5D4E, name: "R480 [Radeon X850 SE]" },
		Device { id: 0x5D4F, name: "R480 [Radeon X800 GTO]" },
		Device { id: 0x5D50, name: "R480 GL [FireGL V7200]" },
		Device { id: 0x5D52, name: "R480 [Radeon X850 XT]" },
		Device { id: 0x5D57, name: "R423 [Radeon X800 XT]" },
		Device { id: 0x5D6D, name: "R480 [Radeon X850 XT Platinum Edition] (Secondary)" },
		Device { id: 0x5D6F, name: "R480 [Radeon X800 GTO] (Secondary)" },
		Device { id: 0x5D72, name: "R480 [Radeon X850 XT] (Secondary)" },
		Device { id: 0x5D77, name: "R423 [Radeon X800 XT] (Secondary)" },
		Device { id: 0x5E48, name: "RV410 GL [FireGL V5000]" },
		Device { id: 0x5E49, name: "RV410 [Radeon X700 Series]" },
		Device { id: 0x5E4A, name: "RV410 [Radeon X700 XT]" },
		Device { id: 0x5E4B, name: "RV410 [Radeon X700 PRO]" },
		Device { id: 0x5E4C, name: "RV410 [Radeon X700 SE]" },
		Device { id: 0x5E4D, name: "RV410 [Radeon X700]" },
		Device { id: 0x5E4F, name: "RV410 [Radeon X700]" },
		Device { id: 0x5E6B, name: "RV410 [Radeon X700 PRO] (Secondary)" },
		Device { id: 0x5E6D, name: "RV410 [Radeon X700] (Secondary)" },
		Device { id: 0x5F57, name: "R423 [Radeon X800 XT]" },
		Device { id: 0x6600, name: "Mars [Radeon HD 8670A/8670M/8750M]" },
		Device { id: 0x6601, name: "Mars [Radeon HD 8730M]" },
		Device { id: 0x6602, name: "Mars" },
		Device { id: 0x6603, name: "Mars" },
		Device { id: 0x6604, name: "Opal XT [Radeon R7 M265]" },
		Device { id: 0x6605, name: "Opal PRO [Radeon R7 M260]" },
		Device { id: 0x6606, name: "Mars XTX [Radeon HD 8790M]" },
		Device { id: 0x6607, name: "Mars LE [Radeon HD 8530M / R5 M240]" },
		Device { id: 0x6608, name: "Oland GL [FirePro W2100]" },
		Device { id: 0x6610, name: "Oland XT [Radeon HD 8670 / R7 250/350]" },
		Device { id: 0x6611, name: "Oland [Radeon HD 8570 / R7 240/340 OEM]" },
		Device { id: 0x6613, name: "Oland PRO [Radeon R7 240/340]" },
		Device { id: 0x6620, name: "Mars" },
		Device { id: 0x6621, name: "Mars PRO" },
		Device { id: 0x6623, name: "Mars" },
		Device { id: 0x6631, name: "Oland" },
		Device { id: 0x6640, name: "Saturn XT [FirePro M6100]" },
		Device { id: 0x6641, name: "Saturn PRO [Radeon HD 8930M]" },
		Device { id: 0x6646, name: "Bonaire XT [Radeon R9 M280X]" },
		Device { id: 0x6647, name: "Bonaire PRO [Radeon R9 M270X]" },
		Device { id: 0x6649, name: "Bonaire [FirePro W5100]" },
		Device { id: 0x6650, name: "Bonaire" },
		Device { id: 0x6651, name: "Bonaire" },
		Device { id: 0x6658, name: "Bonaire XTX [Radeon R7 260X/360]" },
		Device { id: 0x665C, name: "Bonaire XT [Radeon HD 7790/8770 / R7 360 / R9 260/360 OEM]" },
		Device { id: 0x665D, name: "Bonaire [Radeon R7 200 Series]" },
		Device { id: 0x665F, name: "Tobago PRO [Radeon R7 360 / R9 360 OEM]" },
		Device { id: 0x6660, name: "Sun XT [Radeon HD 8670A/8670M/8690M / R5 M330 / M430 / R7 M520]" },
		Device { id: 0x6663, name: "Sun PRO [Radeon HD 8570A/8570M]" },
		Device { id: 0x6664, name: "Jet XT [Radeon R5 M240]" },
		Device { id: 0x6665, name: "Jet PRO [Radeon R5 M230]" },
		Device { id: 0x6667, name: "Jet ULT [Radeon R5 M230]" },
		Device { id: 0x666F, name: "Sun LE [Radeon HD 8550M / R5 M230]" },
		Device { id: 0x6704, name: "Cayman PRO GL [FirePro V7900]" },
		Device { id: 0x6707, name: "Cayman LE GL [FirePro V5900]" },
		Device { id: 0x6718, name: "Cayman XT [Radeon HD 6970]" },
		Device { id: 0x6719, name: "Cayman PRO [Radeon HD 6950]" },
		Device { id: 0x671C, name: "Antilles [Radeon HD 6990]" },
		Device { id: 0x671D, name: "Antilles [Radeon HD 6990]" },
		Device { id: 0x671F, name: "Cayman CE [Radeon HD 6930]" },
		Device { id: 0x6720, name: "Blackcomb [Radeon HD 6970M/6990M]" },
		Device { id: 0x6738, name: "Barts XT [Radeon HD 6870]" },
		Device { id: 0x6739, name: "Barts PRO [Radeon HD 6850]" },
		Device { id: 0x673E, name: "Barts LE [Radeon HD 6790]" },
		Device { id: 0x6740, name: "Whistler [Radeon HD 6730M/6770M/7690M XT]" },
		Device { id: 0x6741, name: "Whistler [Radeon HD 6630M/6650M/6750M/7670M/7690M]" },
		Device { id: 0x6742, name: "Whistler LE [Radeon HD 6610M/7610M]" },
		Device { id: 0x6743, name: "Whistler [Radeon E6760]" },
		Device { id: 0x6749, name: "Turks GL [FirePro V4900]" },
		Device { id: 0x674A, name: "Turks GL [FirePro V3900]" },
		Device { id: 0x6750, name: "Onega [Radeon HD 6650A/7650A]" },
		Device { id: 0x6751, name: "Turks [Radeon HD 7650A/7670A]" },
		Device { id: 0x6758, name: "Turks XT [Radeon HD 6670/7670]" },
		Device { id: 0x6759, name: "Turks PRO [Radeon HD 6570/7570/8550]" },
		Device { id: 0x675B, name: "Turks [Radeon HD 7600 Series]" },
		Device { id: 0x675D, name: "Turks PRO [Radeon HD 7570]" },
		Device { id: 0x675F, name: "Turks LE [Radeon HD 5570/6510/7510/8510]" },
		Device { id: 0x6760, name: "Seymour [Radeon HD 6400M/7400M Series]" },
		Device { id: 0x6761, name: "Seymour LP [Radeon HD 6430M]" },
		Device { id: 0x6763, name: "Seymour [Radeon E6460]" },
		Device { id: 0x6764, name: "Seymour [Radeon HD 6400M Series]" },
		Device { id: 0x6765, name: "Seymour [Radeon HD 6400M Series]" },
		Device { id: 0x6766, name: "Caicos" },
		Device { id: 0x6767, name: "Caicos" },
		Device { id: 0x6768, name: "Caicos" },
		Device { id: 0x6770, name: "Caicos [Radeon HD 6450A/7450A]" },
		Device { id: 0x6771, name: "Caicos XTX [Radeon HD 8490 / R5 235X OEM]" },
		Device { id: 0x6772, name: "Caicos [Radeon HD 7450A]" },
		Device { id: 0x6778, name: "Caicos XT [Radeon HD 7470/8470 / R5 235/310 OEM]" },
		Device { id: 0x6779, name: "Caicos [Radeon HD 6450/7450/8450 / R5 230 OEM]" },
		Device { id: 0x677B, name: "Caicos PRO [Radeon HD 7450]" },
		Device { id: 0x6780, name: "Tahiti XT GL [FirePro W9000]" },
		Device { id: 0x6784, name: "Tahiti [FirePro Series Graphics Adapter]" },
		Device { id: 0x6788, name: "Tahiti [FirePro Series Graphics Adapter]" },
		Device { id: 0x678A, name: "Tahiti PRO GL [FirePro Series]" },
		Device { id: 0x6798, name: "Tahiti XT [Radeon HD 7970/8970 OEM / R9 280X]" },
		Device { id: 0x679A, name: "Tahiti PRO [Radeon HD 7950/8950 OEM / R9 280]" },
		Device { id: 0x679B, name: "Malta [Radeon HD 7990/8990 OEM]" },
		Device { id: 0x679E, name: "Tahiti LE [Radeon HD 7870 XT]" },
		Device { id: 0x679F, name: "Tahiti" },
		Device { id: 0x67A0, name: "Hawaii XT GL [FirePro W9100]" },
		Device { id: 0x67A1, name: "Hawaii PRO GL [FirePro W8100]" },
		Device { id: 0x67A2, name: "Hawaii GL" },
		Device { id: 0x67A8, name: "Hawaii" },
		Device { id: 0x67A9, name: "Hawaii" },
		Device { id: 0x67AA, name: "Hawaii" },
		Device { id: 0x67B0, name: "Hawaii XT / Grenada XT [Radeon R9 290X/390X]" },
		Device { id: 0x67B1, name: "Hawaii PRO [Radeon R9 290/390]" },
		Device { id: 0x67B9, name: "Vesuvius [Radeon R9 295X2]" },
		Device { id: 0x67BE, name: "Hawaii LE" },
		Device { id: 0x67C0, name: "Ellesmere [Radeon Pro WX 7100]" },
		Device { id: 0x67C4, name: "Ellesmere [Radeon Pro WX 7100]" },
		Device { id: 0x67C7, name: "Ellesmere [Radeon Pro WX 5100]" },
		Device { id: 0x67CA, name: "Ellesmere [Polaris10]" },
		Device { id: 0x67CC, name: "Ellesmere [Polaris10]" },
		Device { id: 0x67CF, name: "Ellesmere [Polaris10]" },
		Device { id: 0x67DF, name: "Ellesmere [Radeon RX 470/480/570/580]" },
		Device { id: 0x67E0, name: "Baffin [Polaris11]" },
		Device { id: 0x67E1, name: "Baffin [Polaris11]" },
		Device { id: 0x67E3, name: "Baffin [Radeon Pro WX 4100]" },
		Device { id: 0x67E8, name: "Baffin [Polaris11]" },
		Device { id: 0x67E9, name: "Baffin [Polaris11]" },
		Device { id: 0x67EB, name: "Baffin [Polaris11]" },
		Device { id: 0x67EF, name: "Baffin [Radeon RX 460/560D / Pro 450/455/460/560]" },
		Device { id: 0x67FF, name: "Baffin [Radeon RX 560]" },
		Device { id: 0x6800, name: "Wimbledon XT [Radeon HD 7970M]" },
		Device { id: 0x6801, name: "Neptune XT [Radeon HD 8970M]" },
		Device { id: 0x6802, name: "Wimbledon" },
		Device { id: 0x6806, name: "Neptune" },
		Device { id: 0x6808, name: "Pitcairn XT GL [FirePro W7000]" },
		Device { id: 0x6809, name: "Pitcairn LE GL [FirePro W5000]" },
		Device { id: 0x6810, name: "Curacao XT / Trinidad XT [Radeon R7 370 / R9 270X/370X]" },
		Device { id: 0x6811, name: "Curacao PRO [Radeon R7 370 / R9 270/370 OEM]" },
		Device { id: 0x6816, name: "Pitcairn" },
		Device { id: 0x6817, name: "Pitcairn" },
		Device { id: 0x6818, name: "Pitcairn XT [Radeon HD 7870 GHz Edition]" },
		Device { id: 0x6819, name: "Pitcairn PRO [Radeon HD 7850 / R7 265 / R9 270 1024SP]" },
		Device { id: 0x6820, name: "Venus XTX [Radeon HD 8890M / R9 M275X/M375X]" },
		Device { id: 0x6821, name: "Venus XT [Radeon HD 8870M / R9 M270X/M370X]" },
		Device { id: 0x6822, name: "Venus PRO [Radeon E8860]" },
		Device { id: 0x6823, name: "Venus PRO [Radeon HD 8850M / R9 M265X]" },
		Device { id: 0x6825, name: "Heathrow XT [Radeon HD 7870M]" },
		Device { id: 0x6826, name: "Chelsea LP [Radeon HD 7700M Series]" },
		Device { id: 0x6827, name: "Heathrow PRO [Radeon HD 7850M/8850M]" },
		Device { id: 0x6828, name: "Cape Verde PRO [FirePro W600]" },
		Device { id: 0x6829, name: "Cape Verde" },
		Device { id: 0x682A, name: "Venus PRO" },
		Device { id: 0x682B, name: "Venus LE / Tropo PRO-L [Radeon HD 8830M / R7 M465X]" },
		Device { id: 0x682C, name: "Cape Verde GL [FirePro W4100]" },
		Device { id: 0x682D, name: "Chelsea XT GL [FirePro M4000]" },
		Device { id: 0x682F, name: "Chelsea LP [Radeon HD 7730M]" },
		Device { id: 0x6830, name: "Cape Verde [Radeon HD 7800M Series]" },
		Device { id: 0x6831, name: "Cape Verde [AMD Radeon HD 7700M Series]" },
		Device { id: 0x6835, name: "Cape Verde PRX [Radeon R9 255 OEM]" },
		Device { id: 0x6837, name: "Cape Verde LE [Radeon HD 7730/8730]" },
		Device { id: 0x683D, name: "Cape Verde XT [Radeon HD 7770/8760 / R7 250X]" },
		Device { id: 0x683F, name: "Cape Verde PRO [Radeon HD 7750/8740 / R7 250E]" },
		Device { id: 0x6840, name: "Thames [Radeon HD 7500M/7600M Series]" },
		Device { id: 0x6841, name: "Thames [Radeon HD 7550M/7570M/7650M]" },
		Device { id: 0x6842, name: "Thames LE [Radeon HD 7000M Series]" },
		Device { id: 0x6843, name: "Thames [Radeon HD 7670M]" },
		Device { id: 0x6861, name: "Vega 10 XT [Radeon PRO WX 9100]" },
		Device { id: 0x6863, name: "Vega 10 XTX [Radeon Vega Frontier Edition]" },
		Device { id: 0x687F, name: "Vega 10 XT [Radeon RX Vega 64]" },
		Device { id: 0x6888, name: "Cypress XT [FirePro V8800]" },
		Device { id: 0x6889, name: "Cypress PRO [FirePro V7800]" },
		Device { id: 0x688A, name: "Cypress XT [FirePro V9800]" },
		Device { id: 0x688C, name: "Cypress XT GL [FireStream 9370]" },
		Device { id: 0x688D, name: "Cypress PRO GL [FireStream 9350]" },
		Device { id: 0x6898, name: "Cypress XT [Radeon HD 5870]" },
		Device { id: 0x6899, name: "Cypress PRO [Radeon HD 5850]" },
		Device { id: 0x689B, name: "Cypress PRO [Radeon HD 6800 Series]" },
		Device { id: 0x689C, name: "Hemlock [Radeon HD 5970]" },
		Device { id: 0x689D, name: "Hemlock [Radeon HD 5970]" },
		Device { id: 0x689E, name: "Cypress LE [Radeon HD 5830]" },
		Device { id: 0x68A0, name: "Broadway XT [Mobility Radeon HD 5870]" },
		Device { id: 0x68A1, name: "Broadway PRO [Mobility Radeon HD 5850]" },
		Device { id: 0x68A8, name: "Granville [Radeon HD 6850M/6870M]" },
		Device { id: 0x68A9, name: "Juniper XT [FirePro V5800]" },
		Device { id: 0x68B8, name: "Juniper XT [Radeon HD 5770]" },
		Device { id: 0x68B9, name: "Juniper LE [Radeon HD 5670 640SP Edition]" },
		Device { id: 0x68BA, name: "Juniper XT [Radeon HD 6770]" },
		Device { id: 0x68BE, name: "Juniper PRO [Radeon HD 5750]" },
		Device { id: 0x68BF, name: "Juniper PRO [Radeon HD 6750]" },
		Device { id: 0x68C0, name: "Madison [Mobility Radeon HD 5730 / 6570M]" },
		Device { id: 0x68C1, name: "Madison [Mobility Radeon HD 5650/5750 / 6530M/6550M]" },
		Device { id: 0x68C7, name: "Madison [Mobility Radeon HD 5570/6550A]" },
		Device { id: 0x68C8, name: "Redwood XT GL [FirePro V4800]" },
		Device { id: 0x68C9, name: "Redwood PRO GL [FirePro V3800]" },
		Device { id: 0x68D8, name: "Redwood XT [Radeon HD 5670/5690/5730]" },
		Device { id: 0x68D9, name: "Redwood PRO [Radeon HD 5550/5570/5630/6510/6610/7570]" },
		Device { id: 0x68DA, name: "Redwood LE [Radeon HD 5550/5570/5630/6390/6490/7570]" },
		Device { id: 0x68DE, name: "Redwood" },
		Device { id: 0x68E0, name: "Park [Mobility Radeon HD 5430/5450/5470]" },
		Device { id: 0x68E1, name: "Park [Mobility Radeon HD 5430]" },
		Device { id: 0x68E4, name: "Robson CE [Radeon HD 6370M/7370M]" },
		Device { id: 0x68E5, name: "Robson LE [Radeon HD 6330M]" },
		Device { id: 0x68E8, name: "Cedar" },
		Device { id: 0x68E9, name: "Cedar [ATI FirePro (FireGL) Graphics Adapter]" },
		Device { id: 0x68F1, name: "Cedar GL [FirePro 2460]" },
		Device { id: 0x68F2, name: "Cedar GL [FirePro 2270]" },
		Device { id: 0x68F8, name: "Cedar [Radeon HD 7300 Series]" },
		Device { id: 0x68F9, name: "Cedar [Radeon HD 5000/6000/7350/8350 Series]" },
		Device { id: 0x68FA, name: "Cedar [Radeon HD 7350/8350 / R5 220]" },
		Device { id: 0x68FE, name: "Cedar LE" },
		Device { id: 0x6900, name: "Topaz XT [Radeon R7 M260/M265 / M340/M360 / M440/M445]" },
		Device { id: 0x6901, name: "Topaz PRO [Radeon R5 M255]" },
		Device { id: 0x6907, name: "Meso XT [Radeon R5 M315]" },
		Device { id: 0x6921, name: "Amethyst XT [Radeon R9 M295X]" },
		Device { id: 0x6929, name: "Tonga XT GL [FirePro S7150]" },
		Device { id: 0x692B, name: "Tonga PRO GL [FirePro W7100]" },
		Device { id: 0x692F, name: "Tonga XTV GL [FirePro S7150V]" },
		Device { id: 0x6938, name: "Tonga XT / Amethyst XT [Radeon R9 380X / R9 M295X]" },
		Device { id: 0x6939, name: "Tonga PRO [Radeon R9 285/380]" },
		Device { id: 0x6980, name: "Polaris12" },
		Device { id: 0x6981, name: "Polaris12" },
		Device { id: 0x6985, name: "Lexa XT [Radeon PRO WX 3100]" },
		Device { id: 0x6986, name: "Polaris12" },
		Device { id: 0x6987, name: "Polaris12" },
		Device { id: 0x6995, name: "Lexa XT [Radeon PRO WX 2100]" },
		Device { id: 0x699F, name: "Lexa PRO [Radeon RX 550]" },
		Device { id: 0x700F, name: "RS100 AGP Bridge" },
		Device { id: 0x7010, name: "RS200/RS250 AGP Bridge" },
		Device { id: 0x7100, name: "R520 [Radeon X1800 XT]" },
		Device { id: 0x7101, name: "R520/M58 [Mobility Radeon X1800 XT]" },
		Device { id: 0x7102, name: "R520/M58 [Mobility Radeon X1800]" },
		Device { id: 0x7104, name: "R520 GL [FireGL V7200]" },
		Device { id: 0x7109, name: "R520 [Radeon X1800 XL]" },
		Device { id: 0x710A, name: "R520 [Radeon X1800 GTO]" },
		Device { id: 0x710B, name: "R520 [Radeon X1800 GTO]" },
		Device { id: 0x7120, name: "R520 [Radeon X1800] (Secondary)" },
		Device { id: 0x7124, name: "R520 GL [FireGL V7200] (Secondary)" },
		Device { id: 0x7129, name: "R520 [Radeon X1800] (Secondary)" },
		Device { id: 0x7140, name: "RV515 [Radeon X1300/X1550/X1600 Series]" },
		Device { id: 0x7142, name: "RV515 PRO [Radeon X1300/X1550 Series]" },
		Device { id: 0x7143, name: "RV505 [Radeon X1300/X1550 Series]" },
		Device { id: 0x7145, name: "RV515/M54 [Mobility Radeon X1400]" },
		Device { id: 0x7146, name: "RV515 [Radeon X1300/X1550]" },
		Device { id: 0x7147, name: "RV505 [Radeon X1550 64-bit]" },
		Device { id: 0x7149, name: "RV515/M52 [Mobility Radeon X1300]" },
		Device { id: 0x714A, name: "RV515/M52 [Mobility Radeon X1300]" },
		Device { id: 0x7152, name: "RV515 GL [FireGL V3300]" },
		Device { id: 0x7153, name: "RV515 GL [FireGL V3350]" },
		Device { id: 0x715F, name: "RV505 CE [Radeon X1550 64-bit]" },
		Device { id: 0x7162, name: "RV515 PRO [Radeon X1300/X1550 Series] (Secondary)" },
		Device { id: 0x7163, name: "RV505 [Radeon X1550 Series] (Secondary)" },
		Device { id: 0x7166, name: "RV515 [Radeon X1300/X1550 Series] (Secondary)" },
		Device { id: 0x7167, name: "RV515 [Radeon X1550 64-bit] (Secondary)" },
		Device { id: 0x7172, name: "RV515 GL [FireGL V3300] (Secondary)" },
		Device { id: 0x7173, name: "RV515 GL [FireGL V3350] (Secondary)" },
		Device { id: 0x7181, name: "RV516 [Radeon X1600/X1650 Series]" },
		Device { id: 0x7183, name: "RV516 [Radeon X1300/X1550 Series]" },
		Device { id: 0x7186, name: "RV516/M64 [Mobility Radeon X1450]" },
		Device { id: 0x7187, name: "RV516 [Radeon X1300/X1550 Series]" },
		Device { id: 0x7188, name: "RV516/M64-S [Mobility Radeon X2300]" },
		Device { id: 0x718A, name: "RV516/M64 [Mobility Radeon X2300]" },
		Device { id: 0x718B, name: "RV516/M62 [Mobility Radeon X1350]" },
		Device { id: 0x718C, name: "RV516/M62-CSP64 [Mobility Radeon X1350]" },
		Device { id: 0x718D, name: "RV516/M64-CSP128 [Mobility Radeon X1450]" },
		Device { id: 0x7193, name: "RV516 [Radeon X1550 Series]" },
		Device { id: 0x7196, name: "RV516/M62-S [Mobility Radeon X1350]" },
		Device { id: 0x719B, name: "RV516 GL [FireMV 2250]" },
		Device { id: 0x719F, name: "RV516 [Radeon X1550 Series]" },
		Device { id: 0x71A0, name: "RV516 [Radeon X1300/X1550 Series] (Secondary)" },
		Device { id: 0x71A1, name: "RV516 [Radeon X1600/X1650 Series] (Secondary)" },
		Device { id: 0x71A3, name: "RV516 [Radeon X1300/X1550 Series] (Secondary)" },
		Device { id: 0x71A7, name: "RV516 [Radeon X1300/X1550 Series] (Secondary)" },
		Device { id: 0x71BB, name: "RV516 GL [FireMV 2250] (Secondary)" },
		Device { id: 0x71C0, name: "RV530 [Radeon X1600 XT/X1650 GTO]" },
		Device { id: 0x71C1, name: "RV535 [Radeon X1650 PRO]" },
		Device { id: 0x71C2, name: "RV530 [Radeon X1600 PRO]" },
		Device { id: 0x71C4, name: "RV530/M56 GL [Mobility FireGL V5200]" },
		Device { id: 0x71C5, name: "RV530/M56-P [Mobility Radeon X1600]" },
		Device { id: 0x71C6, name: "RV530LE [Radeon X1600/X1650 PRO]" },
		Device { id: 0x71C7, name: "RV535 [Radeon X1650 PRO]" },
		Device { id: 0x71CE, name: "RV530 [Radeon X1300 XT/X1600 PRO]" },
		Device { id: 0x71D2, name: "RV530 GL [FireGL V3400]" },
		Device { id: 0x71D4, name: "RV530/M66 GL [Mobility FireGL V5250]" },
		Device { id: 0x71D5, name: "RV530/M66-P [Mobility Radeon X1700]" },
		Device { id: 0x71D6, name: "RV530/M66-XT [Mobility Radeon X1700]" },
		Device { id: 0x71DE, name: "RV530/M66 [Mobility Radeon X1700/X2500]" },
		Device { id: 0x71E0, name: "RV530 [Radeon X1600] (Secondary)" },
		Device { id: 0x71E1, name: "RV535 [Radeon X1650 PRO] (Secondary)" },
		Device { id: 0x71E2, name: "RV530 [Radeon X1600] (Secondary)" },
		Device { id: 0x71E6, name: "RV530 [Radeon X1650] (Secondary)" },
		Device { id: 0x71E7, name: "RV535 [Radeon X1650 PRO] (Secondary)" },
		Device { id: 0x71F2, name: "RV530 GL [FireGL V3400] (Secondary)" },
		Device { id: 0x7210, name: "RV550/M71 [Mobility Radeon HD 2300]" },
		Device { id: 0x7211, name: "RV550/M71 [Mobility Radeon X2300 HD]" },
		Device { id: 0x7240, name: "R580+ [Radeon X1950 XTX]" },
		Device { id: 0x7244, name: "R580+ [Radeon X1950 XT]" },
		Device { id: 0x7248, name: "R580 [Radeon X1950]" },
		Device { id: 0x7249, name: "R580 [Radeon X1900 XT]" },
		Device { id: 0x724B, name: "R580 [Radeon X1900 GT]" },
		Device { id: 0x724E, name: "R580 GL [FireGL V7350]" },
		Device { id: 0x7269, name: "R580 [Radeon X1900 XT] (Secondary)" },
		Device { id: 0x726B, name: "R580 [Radeon X1900 GT] (Secondary)" },
		Device { id: 0x726E, name: "R580 [AMD Stream Processor] (Secondary)" },
		Device { id: 0x7280, name: "RV570 [Radeon X1950 PRO]" },
		Device { id: 0x7288, name: "RV570 [Radeon X1950 GT]" },
		Device { id: 0x7291, name: "RV560 [Radeon X1650 XT]" },
		Device { id: 0x7293, name: "RV560 [Radeon X1650 GT]" },
		Device { id: 0x72A0, name: "RV570 [Radeon X1950 PRO] (Secondary)" },
		Device { id: 0x72A8, name: "RV570 [Radeon X1950 GT] (Secondary)" },
		Device { id: 0x72B1, name: "RV560 [Radeon X1650 XT] (Secondary)" },
		Device { id: 0x72B3, name: "RV560 [Radeon X1650 GT] (Secondary)" },
		Device { id: 0x7300, name: "Fiji [Radeon R9 FURY / NANO Series]" },
		Device { id: 0x7833, name: "RS350 Host Bridge" },
		Device { id: 0x7834, name: "RS350 [Radeon 9100 PRO/XT IGP]" },
		Device { id: 0x7835, name: "RS350M [Mobility Radeon 9000 IGP]" },
		Device { id: 0x7838, name: "RS350 AGP Bridge" },
		Device { id: 0x7910, name: "RS690 Host Bridge" },
		Device { id: 0x7911, name: "RS690/RS740 Host Bridge" },
		Device { id: 0x7912, name: "RS690/RS740 PCI to PCI Bridge (Internal gfx)" },
		Device { id: 0x7913, name: "RS690 PCI to PCI Bridge (PCI Express Graphics Port 0)" },
		Device { id: 0x7915, name: "RS690 PCI to PCI Bridge (PCI Express Port 1)" },
		Device { id: 0x7916, name: "RS690 PCI to PCI Bridge (PCI Express Port 2)" },
		Device { id: 0x7917, name: "RS690 PCI to PCI Bridge (PCI Express Port 3)" },
		Device { id: 0x7919, name: "RS690 HDMI Audio [Radeon Xpress 1200 Series]" },
		Device { id: 0x791E, name: "RS690 [Radeon X1200]" },
		Device { id: 0x791F, name: "RS690M [Radeon Xpress 1200/1250/1270]" },
		Device { id: 0x7930, name: "RS600 Host Bridge" },
		Device { id: 0x7932, name: "RS600 PCI to PCI Bridge (Internal gfx)" },
		Device { id: 0x7933, name: "RS600 PCI to PCI Bridge (PCI Express Graphics Port 0)" },
		Device { id: 0x7935, name: "RS600 PCI to PCI Bridge (PCI Express Port 1)" },
		Device { id: 0x7936, name: "RS600 PCI to PCI Bridge (PCI Express Port 2)" },
		Device { id: 0x7937, name: "RS690 PCI to PCI Bridge (PCI Express Port 3)" },
		Device { id: 0x793B, name: "RS600 HDMI Audio [Radeon Xpress 1250]" },
		Device { id: 0x793F, name: "RS690M [Radeon Xpress 1200/1250/1270] (Secondary)" },
		Device { id: 0x7941, name: "RS600 [Radeon Xpress 1250]" },
		Device { id: 0x7942, name: "RS600M [Radeon Xpress 1250]" },
		Device { id: 0x796E, name: "RS740 [Radeon 2100]" },
		Device { id: 0x9400, name: "R600 [Radeon HD 2900 PRO/XT]" },
		Device { id: 0x9401, name: "R600 [Radeon HD 2900 XT]" },
		Device { id: 0x9403, name: "R600 [Radeon HD 2900 PRO]" },
		Device { id: 0x9405, name: "R600 [Radeon HD 2900 GT]" },
		Device { id: 0x940A, name: "R600 GL [FireGL V8650]" },
		Device { id: 0x940B, name: "R600 GL [FireGL V8600]" },
		Device { id: 0x940F, name: "R600 GL [FireGL V7600]" },
		Device { id: 0x9440, name: "RV770 [Radeon HD 4870]" },
		Device { id: 0x9441, name: "R700 [Radeon HD 4870 X2]" },
		Device { id: 0x9442, name: "RV770 [Radeon HD 4850]" },
		Device { id: 0x9443, name: "R700 [Radeon HD 4850 X2]" },
		Device { id: 0x9444, name: "RV770 GL [FirePro V8750]" },
		Device { id: 0x9446, name: "RV770 GL [FirePro V7760]" },
		Device { id: 0x944A, name: "RV770/M98L [Mobility Radeon HD 4850]" },
		Device { id: 0x944B, name: "RV770/M98 [Mobility Radeon HD 4850 X2]" },
		Device { id: 0x944C, name: "RV770 LE [Radeon HD 4830]" },
		Device { id: 0x944E, name: "RV770 CE [Radeon HD 4710]" },
		Device { id: 0x9450, name: "RV770 GL [FireStream 9270]" },
		Device { id: 0x9452, name: "RV770 GL [FireStream 9250]" },
		Device { id: 0x9456, name: "RV770 GL [FirePro V8700]" },
		Device { id: 0x945A, name: "RV770/M98-XT [Mobility Radeon HD 4870]" },
		Device { id: 0x9460, name: "RV790 [Radeon HD 4890]" },
		Device { id: 0x9462, name: "RV790 [Radeon HD 4860]" },
		Device { id: 0x946A, name: "RV770 GL [FirePro M7750]" },
		Device { id: 0x9480, name: "RV730/M96 [Mobility Radeon HD 4650/5165]" },
		Device { id: 0x9488, name: "RV730/M96-XT [Mobility Radeon HD 4670]" },
		Device { id: 0x9489, name: "RV730/M96 GL [Mobility FireGL V5725]" },
		Device { id: 0x9490, name: "RV730 XT [Radeon HD 4670]" },
		Device { id: 0x9491, name: "RV730/M96-CSP [Radeon E4690]" },
		Device { id: 0x9495, name: "RV730 [Radeon HD 4600 AGP Series]" },
		Device { id: 0x9498, name: "RV730 PRO [Radeon HD 4650]" },
		Device { id: 0x949C, name: "RV730 GL [FirePro V7750]" },
		Device { id: 0x949E, name: "RV730 GL [FirePro V5700]" },
		Device { id: 0x949F, name: "RV730 GL [FirePro V3750]" },
		Device { id: 0x94A0, name: "RV740/M97 [Mobility Radeon HD 4830]" },
		Device { id: 0x94A1, name: "RV740/M97-XT [Mobility Radeon HD 4860]" },
		Device { id: 0x94A3, name: "RV740/M97 GL [FirePro M7740]" },
		Device { id: 0x94B3, name: "RV740 PRO [Radeon HD 4770]" },
		Device { id: 0x94B4, name: "RV740 PRO [Radeon HD 4750]" },
		Device { id: 0x94C1, name: "RV610 [Radeon HD 2400 PRO/XT]" },
		Device { id: 0x94C3, name: "RV610 [Radeon HD 2400 PRO]" },
		Device { id: 0x94C4, name: "RV610 LE [Radeon HD 2400 PRO AGP]" },
		Device { id: 0x94C5, name: "RV610 [Radeon HD 2400 LE]" },
		Device { id: 0x94C7, name: "RV610 [Radeon HD 2350]" },
		Device { id: 0x94C8, name: "RV610/M74 [Mobility Radeon HD 2400 XT]" },
		Device { id: 0x94C9, name: "RV610/M72-S [Mobility Radeon HD 2400]" },
		Device { id: 0x94CB, name: "RV610 [Radeon E2400]" },
		Device { id: 0x94CC, name: "RV610 LE [Radeon HD 2400 PRO PCI]" },
		Device { id: 0x9500, name: "RV670 [Radeon HD 3850 X2]" },
		Device { id: 0x9501, name: "RV670 [Radeon HD 3870]" },
		Device { id: 0x9504, name: "RV670/M88 [Mobility Radeon HD 3850]" },
		Device { id: 0x9505, name: "RV670 [Radeon HD 3690/3850]" },
		Device { id: 0x9506, name: "RV670/M88 [Mobility Radeon HD 3850 X2]" },
		Device { id: 0x9507, name: "RV670 [Radeon HD 3830]" },
		Device { id: 0x9508, name: "RV670/M88-XT [Mobility Radeon HD 3870]" },
		Device { id: 0x9509, name: "RV670/M88 [Mobility Radeon HD 3870 X2]" },
		Device { id: 0x950F, name: "R680 [Radeon HD 3870 X2]" },
		Device { id: 0x9511, name: "RV670 GL [FireGL V7700]" },
		Device { id: 0x9513, name: "RV670 [Radeon HD 3850 X2]" },
		Device { id: 0x9515, name: "RV670 PRO [Radeon HD 3850 AGP]" },
		Device { id: 0x9519, name: "RV670 GL [FireStream 9170]" },
		Device { id: 0x9540, name: "RV710 [Radeon HD 4550]" },
		Device { id: 0x954F, name: "RV710 [Radeon HD 4350/4550]" },
		Device { id: 0x9552, name: "RV710/M92 [Mobility Radeon HD 4330/4350/4550]" },
		Device { id: 0x9553, name: "RV710/M92 [Mobility Radeon HD 4530/4570/545v]" },
		Device { id: 0x9555, name: "RV710/M92 [Mobility Radeon HD 4350/4550]" },
		Device { id: 0x9557, name: "RV711 GL [FirePro RG220]" },
		Device { id: 0x955F, name: "RV710/M92 [Mobility Radeon HD 4330]" },
		Device { id: 0x9580, name: "RV630 [Radeon HD 2600 PRO]" },
		Device { id: 0x9581, name: "RV630/M76 [Mobility Radeon HD 2600]" },
		Device { id: 0x9583, name: "RV630/M76 [Mobility Radeon HD 2600 XT/2700]" },
		Device { id: 0x9586, name: "RV630 XT [Radeon HD 2600 XT AGP]" },
		Device { id: 0x9587, name: "RV630 PRO [Radeon HD 2600 PRO AGP]" },
		Device { id: 0x9588, name: "RV630 XT [Radeon HD 2600 XT]" },
		Device { id: 0x9589, name: "RV630 PRO [Radeon HD 2600 PRO]" },
		Device { id: 0x958A, name: "RV630 [Radeon HD 2600 X2]" },
		Device { id: 0x958B, name: "RV630/M76 [Mobility Radeon HD 2600 XT]" },
		Device { id: 0x958C, name: "RV630 GL [FireGL V5600]" },
		Device { id: 0x958D, name: "RV630 GL [FireGL V3600]" },
		Device { id: 0x9591, name: "RV635/M86 [Mobility Radeon HD 3650]" },
		Device { id: 0x9593, name: "RV635/M86 [Mobility Radeon HD 3670]" },
		Device { id: 0x9595, name: "RV635/M86 GL [Mobility FireGL V5700]" },
		Device { id: 0x9596, name: "RV635 PRO [Radeon HD 3650 AGP]" },
		Device { id: 0x9597, name: "RV635 PRO [Radeon HD 3650 AGP]" },
		Device { id: 0x9598, name: "RV635 [Radeon HD 3650/3750/4570/4580]" },
		Device { id: 0x9599, name: "RV635 PRO [Radeon HD 3650 AGP]" },
		Device { id: 0x95C0, name: "RV620 PRO [Radeon HD 3470]" },
		Device { id: 0x95C2, name: "RV620/M82 [Mobility Radeon HD 3410/3430]" },
		Device { id: 0x95C4, name: "RV620/M82 [Mobility Radeon HD 3450/3470]" },
		Device { id: 0x95C5, name: "RV620 LE [Radeon HD 3450]" },
		Device { id: 0x95C6, name: "RV620 LE [Radeon HD 3450 AGP]" },
		Device { id: 0x95C9, name: "RV620 LE [Radeon HD 3450 PCI]" },
		Device { id: 0x95CC, name: "RV620 GL [FirePro V3700]" },
		Device { id: 0x95CD, name: "RV620 [FirePro 2450]" },
		Device { id: 0x95CF, name: "RV620 GL [FirePro 2260]" },
		Device { id: 0x960F, name: "RS780 HDMI Audio [Radeon 3000/3100 / HD 3200/3300]" },
		Device { id: 0x9610, name: "RS780 [Radeon HD 3200]" },
		Device { id: 0x9611, name: "RS780C [Radeon 3100]" },
		Device { id: 0x9612, name: "RS780M [Mobility Radeon HD 3200]" },
		Device { id: 0x9613, name: "RS780MC [Mobility Radeon HD 3100]" },
		Device { id: 0x9614, name: "RS780D [Radeon HD 3300]" },
		Device { id: 0x9616, name: "RS780L [Radeon 3000]" },
		Device { id: 0x9640, name: "BeaverCreek [Radeon HD 6550D]" },
		Device { id: 0x9641, name: "BeaverCreek [Radeon HD 6620G]" },
		Device { id: 0x9642, name: "Sumo [Radeon HD 6370D]" },
		Device { id: 0x9643, name: "Sumo [Radeon HD 6380G]" },
		Device { id: 0x9644, name: "Sumo [Radeon HD 6410D]" },
		Device { id: 0x9645, name: "Sumo [Radeon HD 6410D]" },
		Device { id: 0x9647, name: "BeaverCreek [Radeon HD 6520G]" },
		Device { id: 0x9648, name: "Sumo [Radeon HD 6480G]" },
		Device { id: 0x9649, name: "Sumo [Radeon HD 6480G]" },
		Device { id: 0x964A, name: "BeaverCreek [Radeon HD 6530D]" },
		Device { id: 0x964B, name: "Sumo" },
		Device { id: 0x964C, name: "Sumo" },
		Device { id: 0x964E, name: "Sumo" },
		Device { id: 0x964F, name: "Sumo" },
		Device { id: 0x970F, name: "RS880 HDMI Audio [Radeon HD 4200 Series]" },
		Device { id: 0x9710, name: "RS880 [Radeon HD 4200]" },
		Device { id: 0x9712, name: "RS880M [Mobility Radeon HD 4225/4250]" },
		Device { id: 0x9713, name: "RS880M [Mobility Radeon HD 4100]" },
		Device { id: 0x9714, name: "RS880 [Radeon HD 4290]" },
		Device { id: 0x9715, name: "RS880 [Radeon HD 4250]" },
		Device { id: 0x9802, name: "Wrestler [Radeon HD 6310]" },
		Device { id: 0x9803, name: "Wrestler [Radeon HD 6310]" },
		Device { id: 0x9804, name: "Wrestler [Radeon HD 6250]" },
		Device { id: 0x9805, name: "Wrestler [Radeon HD 6250]" },
		Device { id: 0x9806, name: "Wrestler [Radeon HD 6320]" },
		Device { id: 0x9807, name: "Wrestler [Radeon HD 6290]" },
		Device { id: 0x9808, name: "Wrestler [Radeon HD 7340]" },
		Device { id: 0x9809, name: "Wrestler [Radeon HD 7310]" },
		Device { id: 0x980A, name: "Wrestler [Radeon HD 7290]" },
		Device { id: 0x9830, name: "Kabini [Radeon HD 8400 / R3 Series]" },
		Device { id: 0x9831, name: "Kabini [Radeon HD 8400E]" },
		Device { id: 0x9832, name: "Kabini [Radeon HD 8330]" },
		Device { id: 0x9833, name: "Kabini [Radeon HD 8330E]" },
		Device { id: 0x9834, name: "Kabini [Radeon HD 8210]" },
		Device { id: 0x9835, name: "Kabini [Radeon HD 8310E]" },
		Device { id: 0x9836, name: "Kabini [Radeon HD 8280 / R3 Series]" },
		Device { id: 0x9837, name: "Kabini [Radeon HD 8280E]" },
		Device { id: 0x9838, name: "Kabini [Radeon HD 8240 / R3 Series]" },
		Device { id: 0x9839, name: "Kabini [Radeon HD 8180]" },
		Device { id: 0x983D, name: "Temash [Radeon HD 8250/8280G]" },
		Device { id: 0x9840, name: "Kabini HDMI/DP Audio" },
		Device { id: 0x9850, name: "Mullins [Radeon R3 Graphics]" },
		Device { id: 0x9851, name: "Mullins [Radeon R4/R5 Graphics]" },
		Device { id: 0x9852, name: "Mullins [Radeon R2 Graphics]" },
		Device { id: 0x9853, name: "Mullins [Radeon R2 Graphics]" },
		Device { id: 0x9854, name: "Mullins [Radeon R3E Graphics]" },
		Device { id: 0x9855, name: "Mullins [Radeon R6 Graphics]" },
		Device { id: 0x9856, name: "Mullins [Radeon R1E/R2E Graphics]" },
		Device { id: 0x9857, name: "Mullins [Radeon APU XX-2200M with R2 Graphics]" },
		Device { id: 0x9858, name: "Mullins" },
		Device { id: 0x9859, name: "Mullins" },
		Device { id: 0x985A, name: "Mullins" },
		Device { id: 0x985B, name: "Mullins" },
		Device { id: 0x985C, name: "Mullins" },
		Device { id: 0x985D, name: "Mullins" },
		Device { id: 0x985E, name: "Mullins" },
		Device { id: 0x985F, name: "Mullins" },
		Device { id: 0x9874, name: "Carrizo" },
		Device { id: 0x9900, name: "Trinity [Radeon HD 7660G]" },
		Device { id: 0x9901, name: "Trinity [Radeon HD 7660D]" },
		Device { id: 0x9902, name: "Trinity HDMI Audio Controller" },
		Device { id: 0x9903, name: "Trinity [Radeon HD 7640G]" },
		Device { id: 0x9904, name: "Trinity [Radeon HD 7560D]" },
		Device { id: 0x9905, name: "Trinity [FirePro A300 Series Graphics]" },
		Device { id: 0x9906, name: "Trinity [FirePro A300 Series Graphics]" },
		Device { id: 0x9907, name: "Trinity [Radeon HD 7620G]" },
		Device { id: 0x9908, name: "Trinity [Radeon HD 7600G]" },
		Device { id: 0x9909, name: "Trinity [Radeon HD 7500G]" },
		Device { id: 0x990A, name: "Trinity [Radeon HD 7500G]" },
		Device { id: 0x990B, name: "Richland [Radeon HD 8650G]" },
		Device { id: 0x990C, name: "Richland [Radeon HD 8670D]" },
		Device { id: 0x990D, name: "Richland [Radeon HD 8550G]" },
		Device { id: 0x990E, name: "Richland [Radeon HD 8570D]" },
		Device { id: 0x990F, name: "Richland [Radeon HD 8610G]" },
		Device { id: 0x9910, name: "Trinity [Radeon HD 7660G]" },
		Device { id: 0x9913, name: "Trinity [Radeon HD 7640G]" },
		Device { id: 0x9917, name: "Trinity [Radeon HD 7620G]" },
		Device { id: 0x9918, name: "Trinity [Radeon HD 7600G]" },
		Device { id: 0x9919, name: "Trinity [Radeon HD 7500G]" },
		Device { id: 0x9920, name: "Liverpool [Playstation 4 APU]" },
		Device { id: 0x9921, name: "Liverpool HDMI/DP Audio Controller" },
		Device { id: 0x9990, name: "Trinity [Radeon HD 7520G]" },
		Device { id: 0x9991, name: "Trinity [Radeon HD 7540D]" },
		Device { id: 0x9992, name: "Trinity [Radeon HD 7420G]" },
		Device { id: 0x9993, name: "Trinity [Radeon HD 7480D]" },
		Device { id: 0x9994, name: "Trinity [Radeon HD 7400G]" },
		Device { id: 0x9995, name: "Richland [Radeon HD 8450G]" },
		Device { id: 0x9996, name: "Richland [Radeon HD 8470D]" },
		Device { id: 0x9997, name: "Richland [Radeon HD 8350G]" },
		Device { id: 0x9998, name: "Richland [Radeon HD 8370D]" },
		Device { id: 0x9999, name: "Richland [Radeon HD 8510G]" },
		Device { id: 0x999A, name: "Richland [Radeon HD 8410G]" },
		Device { id: 0x999B, name: "Richland [Radeon HD 8310G]" },
		Device { id: 0x999C, name: "Richland" },
		Device { id: 0x999D, name: "Richland [Radeon HD 8550D]" },
		Device { id: 0x99A0, name: "Trinity [Radeon HD 7520G]" },
		Device { id: 0x99A2, name: "Trinity [Radeon HD 7420G]" },
		Device { id: 0x99A4, name: "Trinity [Radeon HD 7400G]" },
		Device { id: 0xAA00, name: "R600 HDMI Audio [Radeon HD 2900 GT/PRO/XT]" },
		Device { id: 0xAA01, name: "RV635 HDMI Audio [Radeon HD 3650/3730/3750]" },
		Device { id: 0xAA08, name: "RV630 HDMI Audio [Radeon HD 2600 PRO/XT / HD 3610]" },
		Device { id: 0xAA10, name: "RV610 HDMI Audio [Radeon HD 2350 PRO / 2400 PRO/XT / HD 3410]" },
		Device { id: 0xAA18, name: "RV670/680 HDMI Audio [Radeon HD 3690/3800 Series]" },
		Device { id: 0xAA20, name: "RV635 HDMI Audio [Radeon HD 3650/3730/3750]" },
		Device { id: 0xAA28, name: "RV620 HDMI Audio [Radeon HD 3450/3470/3550/3570]" },
		Device { id: 0xAA30, name: "RV770 HDMI Audio [Radeon HD 4850/4870]" },
		Device { id: 0xAA38, name: "RV710/730 HDMI Audio [Radeon HD 4000 series]" },
		Device { id: 0xAA50, name: "Cypress HDMI Audio [Radeon HD 5830/5850/5870 / 6850/6870 Rebrand]" },
		Device { id: 0xAA58, name: "Juniper HDMI Audio [Radeon HD 5700 Series]" },
		Device { id: 0xAA60, name: "Redwood HDMI Audio [Radeon HD 5000 Series]" },
		Device { id: 0xAA68, name: "Cedar HDMI Audio [Radeon HD 5400/6300/7300 Series]" },
		Device { id: 0xAA80, name: "Cayman/Antilles HDMI Audio [Radeon HD 6930/6950/6970/6990]" },
		Device { id: 0xAA88, name: "Barts HDMI Audio [Radeon HD 6790/6850/6870 / 7720 OEM]" },
		Device { id: 0xAA90, name: "Turks HDMI Audio [Radeon HD 6500/6600 / 6700M Series]" },
		Device { id: 0xAA98, name: "Caicos HDMI Audio [Radeon HD 6450 / 7450/8450/8490 OEM / R5 230/235/235X OEM]" },
		Device { id: 0xAAA0, name: "Tahiti HDMI Audio [Radeon HD 7870 XT / 7950/7970]" },
		Device { id: 0xAAB0, name: "Cape Verde/Pitcairn HDMI Audio [Radeon HD 7700/7800 Series]" },
		Device { id: 0xAAC0, name: "Tobago HDMI Audio [Radeon R7 360 / R9 360 OEM]" },
		Device { id: 0xAAC8, name: "Hawaii HDMI Audio [Radeon R9 290/290X / 390/390X]" },
		Device { id: 0xAAD8, name: "Tonga HDMI Audio [Radeon R9 285/380]" },
		Device { id: 0xAAE8, name: "Fiji HDMI/DP Audio [Radeon R9 Nano / FURY/FURY X]" },
		Device { id: 0xAAF0, name: "Ellesmere [Radeon RX 580]" },
		Device { id: 0xAC00, name: "Theater 600 Pro" },
		Device { id: 0xAC02, name: "TV Wonder HD 600 PCIe" },
		Device { id: 0xAC12, name: "Theater HD T507 (DVB-T) TV tuner/capture device" },
		Device { id: 0xCAB0, name: "RS100 Host Bridge" },
		Device { id: 0xCAB2, name: "RS200 Host Bridge" },
		Device { id: 0xCAB3, name: "RS250 Host Bridge" },
		Device { id: 0xCBB2, name: "RS200 Host Bridge" },
	] },
	Vendor { id: 0x1003, name: "ULSI Systems", devices: &[
		Device { id: 0x0201, name: "US201" },
	] },
	Vendor { id: 0x1004, name: "VLSI Technology Inc", devices: &[
		Device { id: 0x0005, name: "82C592-FC1" },
		Device { id: 0x0006, name: "82C593-FC1" },
		Device { id: 0x0007, name: "82C594-AFC2" },
		Device { id: 0x0008, name: "82C596/7 [Wildcat]" },
		Device { id: 0x0009, name: "82C597-AFC2" },
		Device { id: 0x000C, name: "82C541 [Lynx]" },
		Device { id: 0x000D, name: "82C543 [Lynx]" },
		Device { id: 0x0101, name: "82C532" },
		Device { id: 0x0102, name: "82C534 [Eagle]" },
		Device { id: 0x0103, name: "82C538" },
		Device { id: 0x0104, name: "82C535" },
		Device { id: 0x0105, name: "82C147" },
		Device { id: 0x0200, name: "82C975" },
		Device { id: 0x0280, name: "82C925" },
		Device { id: 0x0304, name: "QSound ThunderBird PCI Audio" },
		Device { id: 0x0305, name: "QSound ThunderBird PCI Audio Gameport" },
		Device { id: 0x0306, name: "QSound ThunderBird PCI Audio Support Registers" },
		Device { id: 0x0307, name: "SAA7785 ThunderBird PCI Audio" },
		Device { id: 0x0308, name: "SAA7785 ThunderBird PCI Audio Gameport" },
		Device { id: 0x0702, name: "VAS96011 [Golden Gate II]" },
		Device { id: 0x0703, name: "Tollgate" },
	] },
	Vendor { id: 0x1005, name: "Avance Logic Inc. [ALI]", devices: &[
		Device { id: 0x2064, name: "ALG2032/2064" },
		Device { id: 0x2128, name: "ALG2364A" },
		Device { id: 0x2301, name: "ALG2301" },
		Device { id: 0x2302, name: "ALG2302" },
		Device { id: 0x2364, name: "ALG2364" },
		Device { id: 0x2464, name: "ALG2364A" },
		Device { id: 0x2501, name: "ALG2564A/25128A" },
	] },
	Vendor { id: 0x1006, name: "Reply Group", devices: &[
	] },
	Vendor { id: 0x1007, name: "NetFrame Systems Inc", devices: &[
	] },
	Vendor { id: 0x1008, name: "Epson", devices: &[
	] },
	Vendor { id: 0x100A, name: "Phoenix Technologies", devices: &[
	] },
	Vendor { id: 0x100B, name: "National Semiconductor Corporation", devices: &[
		Device { id: 0x0001, name: "DP83810" },
		Device { id: 0x0002, name: "87415/87560 IDE" },
		Device { id: 0x000E, name: "87560 Legacy I/O" },
		Device { id: 0x000F, name: "FireWire Controller" },
		Device { id: 0x0011, name: "NS87560 National PCI System I/O" },
		Device { id: 0x0012, name: "USB Controller" },
		Device { id: 0x0020, name: "DP83815 (MacPhyter) Ethernet Controller" },
		Device { id: 0x0021, name: "PC87200 PCI to ISA Bridge" },
		Device { id: 0x0022, name: "DP83820 10/100/1000 Ethernet Controller" },
		Device { id: 0x0028, name: "Geode GX2 Host Bridge" },
		Device { id: 0x002A, name: "CS5535 South Bridge" },
		Device { id: 0x002B, name: "CS5535 ISA bridge" },
		Device { id: 0x002D, name: "CS5535 IDE" },
		Device { id: 0x002E, name: "CS5535 Audio" },
		Device { id: 0x002F, name: "CS5535 USB" },
		Device { id: 0x0030, name: "Geode GX2 Graphics Processor" },
		Device { id: 0x0035, name: "DP83065 [Saturn] 10/100/1000 Ethernet Controller" },
		Device { id: 0x0500, name: "SCx200 Bridge" },
		Device { id: 0x0501, name: "SCx200 SMI" },
		Device { id: 0x0502, name: "SCx200, SC1100 IDE controller" },
		Device { id: 0x0503, name: "SCx200, SC1100 Audio Controller" },
		Device { id: 0x0504, name: "SCx200 Video" },
		Device { id: 0x0505, name: "SCx200 XBus" },
		Device { id: 0x0510, name: "SC1100 Bridge" },
		Device { id: 0x0511, name: "SC1100 SMI & ACPI" },
		Device { id: 0x0515, name: "SC1100 XBus" },
		Device { id: 0xD001, name: "87410 IDE" },
	] },
	Vendor { id: 0x100C, name: "Tseng Labs Inc", devices: &[
		Device { id: 0x3202, name: "ET4000/W32p rev A" },
		Device { id: 0x3205, name: "ET4000/W32p rev B" },
		Device { id: 0x3206, name: "ET4000/W32p rev C" },
		Device { id: 0x3207, name: "ET4000/W32p rev D" },
		Device { id: 0x3208, name: "ET6000" },
		Device { id: 0x4702, name: "ET6300" },
	] },
	Vendor { id: 0x100D, name: "AST Research Inc", devices: &[
	] },
	Vendor { id: 0x100E, name: "Weitek", devices: &[
		Device { id: 0x9000, name: "P9000 Viper" },
		Device { id: 0x9001, name: "P9000 Viper" },
		Device { id: 0x9002, name: "P9000 Viper" },
		Device { id: 0x9100, name: "P9100 Viper Pro/SE" },
	] },
	Vendor { id: 0x1010, name: "Video Logic, Ltd.", devices: &[
	] },
	Vendor { id: 0x1011, name: "Digital Equipment Corporation", devices: &[
		Device { id: 0x0001, name: "DECchip 21050" },
		Device { id: 0x0002, name: "DECchip 21040 [Tulip]" },
		Device { id: 0x0004, name: "DECchip 21030 [TGA]" },
		Device { id: 0x0007, name: "NVRAM [Zephyr NVRAM]" },
		Device { id: 0x0008, name: "KZPSA [KZPSA]" },
		Device { id: 0x0009, name: "DECchip 21140 [FasterNet]" },
		Device { id: 0x000A, name: "21230 Video Codec" },
		Device { id: 0x000D, name: "PBXGB [TGA2]" },
		Device { id: 0x000F, name: "DEFPA FDDI PCI-to-PDQ Interface Chip [PFI]" },
		Device { id: 0x0014, name: "DECchip 21041 [Tulip Pass 3]" },
		Device { id: 0x0016, name: "DGLPB [OPPO]" },
		Device { id: 0x0017, name: "PV-PCI Graphics Controller (ZLXp-L)" },
		Device { id: 0x0018, name: "Memory Channel interface" },
		Device { id: 0x0019, name: "DECchip 21142/43" },
		Device { id: 0x001A, name: "Farallon PN9000SX Gigabit Ethernet" },
		Device { id: 0x0021, name: "DECchip 21052" },
		Device { id: 0x0022, name: "DECchip 21150" },
		Device { id: 0x0023, name: "DECchip 21150" },
		Device { id: 0x0024, name: "DECchip 21152" },
		Device { id: 0x0025, name: "DECchip 21153" },
		Device { id: 0x0026, name: "DECchip 21154" },
		Device { id: 0x0034, name: "56k Modem Cardbus" },
		Device { id: 0x0045, name: "DECchip 21553" },
		Device { id: 0x0046, name: "DECchip 21554" },
		Device { id: 0x1065, name: "StrongARM DC21285" },
	] },
	Vendor { id: 0x1012, name: "Micronics Computers Inc", devices: &[
	] },
	Vendor { id: 0x1013, name: "Cirrus Logic", devices: &[
		Device { id: 0x0038, name: "GD 7548" },
		Device { id: 0x0040, name: "GD 7555 Flat Panel GUI Accelerator" },
		Device { id: 0x004C, name: "GD 7556 Video/Graphics LCD/CRT Ctrlr" },
		Device { id: 0x00A0, name: "GD 5430/40 [Alpine]" },
		Device { id: 0x00A2, name: "GD 5432 [Alpine]" },
		Device { id: 0x00A4, name: "GD 5434-4 [Alpine]" },
		Device { id: 0x00A8, name: "GD 5434-8 [Alpine]" },
		Device { id: 0x00AC, name: "GD 5436 [Alpine]" },
		Device { id: 0x00B0, name: "GD 5440" },
		Device { id: 0x00B8, name: "GD 5446" },
		Device { id: 0x00BC, name: "GD 5480" },
		Device { id: 0x00D0, name: "GD 5462" },
		Device { id: 0x00D2, name: "GD 5462 [Laguna I]" },
		Device { id: 0x00D4, name: "GD 5464 [Laguna]" },
		Device { id: 0x00D5, name: "GD 5464 BD [Laguna]" },
		Device { id: 0x00D6, name: "GD 5465 [Laguna]" },
		Device { id: 0x00E8, name: "GD 5436U" },
		Device { id: 0x1100, name: "CL 6729" },
		Device { id: 0x1110, name: "PD 6832 PCMCIA/CardBus Ctrlr" },
		Device { id: 0x1112, name: "PD 6834 PCMCIA/CardBus Ctrlr" },
		Device { id: 0x1113, name: "PD 6833 PCMCIA/CardBus Ctrlr" },
		Device { id: 0x1200, name: "GD 7542 [Nordic]" },
		Device { id: 0x1202, name: "GD 7543 [Viking]" },
		Device { id: 0x1204, name: "GD 7541 [Nordic Light]" },
		Device { id: 0x4000, name: "MD 5620 [CLM Data Fax Voice]" },
		Device { id: 0x4400, name: "CD 4400" },
		Device { id: 0x6001, name: "CS 4610/11 [CrystalClear SoundFusion Audio Accelerator]" },
		Device { id: 0x6003, name: "CS 4614/22/24/30 [CrystalClear SoundFusion Audio Accelerator]" },
		Device { id: 0x6004, name: "CS 4614/22/24 [CrystalClear SoundFusion Audio Accelerator]" },
		Device { id: 0x6005, name: "Crystal CS4281 PCI Audio" },
	] },
	Vendor { id: 0x1014, name: "IBM", devices: &[
		Device { id: 0x0002, name: "PCI to MCA Bridge" },
		Device { id: 0x0005, name: "Processor to I/O Controller [Alta Lite]" },
		Device { id: 0x0007, name: "Processor to I/O Controller [Alta MP]" },
		Device { id: 0x000A, name: "PCI to ISA Bridge (IBM27-82376) [Fire Coral]" },
		Device { id: 0x0017, name: "CPU to PCI Bridge" },
		Device { id: 0x0018, name: "TR Auto LANstreamer" },
		Device { id: 0x001B, name: "GXT-150P" },
		Device { id: 0x001C, name: "Carrera" },
		Device { id: 0x001D, name: "SCSI-2 FAST PCI Adapter (82G2675)" },
		Device { id: 0x0020, name: "GXT1000 Graphics Adapter" },
		Device { id: 0x0022, name: "PCI to PCI Bridge (IBM27-82351)" },
		Device { id: 0x002D, name: "Processor to I/O Controller [Python]" },
		Device { id: 0x002E, name: "SCSI RAID Adapter [ServeRAID]" },
		Device { id: 0x0031, name: "2 Port Serial Adapter" },
		Device { id: 0x0036, name: "PCI to 32-bit LocalBus Bridge [Miami]" },
		Device { id: 0x0037, name: "PowerPC to PCI Bridge (IBM27-82660)" },
		Device { id: 0x003A, name: "CPU to PCI Bridge" },
		Device { id: 0x003C, name: "GXT250P/GXT255P Graphics Adapter" },
		Device { id: 0x003E, name: "16/4 Token ring UTP/STP controller" },
		Device { id: 0x0045, name: "SSA Adapter" },
		Device { id: 0x0046, name: "MPIC interrupt controller" },
		Device { id: 0x0047, name: "PCI to PCI Bridge" },
		Device { id: 0x0048, name: "PCI to PCI Bridge" },
		Device { id: 0x0049, name: "Warhead SCSI Controller" },
		Device { id: 0x004E, name: "ATM Controller (14104e00)" },
		Device { id: 0x004F, name: "ATM Controller (14104f00)" },
		Device { id: 0x0050, name: "ATM Controller (14105000)" },
		Device { id: 0x0053, name: "25 MBit ATM Controller" },
		Device { id: 0x0054, name: "GXT500P/GXT550P Graphics Adapter" },
		Device { id: 0x0057, name: "MPEG PCI Bridge" },
		Device { id: 0x0058, name: "SSA Adapter [Advanced SerialRAID/X]" },
		Device { id: 0x005E, name: "GXT800P Graphics Adapter" },
		Device { id: 0x007C, name: "ATM Controller (14107c00)" },
		Device { id: 0x007D, name: "3780IDSP [MWave]" },
		Device { id: 0x008B, name: "EADS PCI to PCI Bridge" },
		Device { id: 0x008E, name: "GXT3000P Graphics Adapter" },
		Device { id: 0x0090, name: "GXT 3000P" },
		Device { id: 0x0091, name: "SSA Adapter" },
		Device { id: 0x0095, name: "20H2999 PCI Docking Bridge" },
		Device { id: 0x0096, name: "Chukar chipset SCSI controller" },
		Device { id: 0x009F, name: "PCI 4758 Cryptographic Accelerator" },
		Device { id: 0x00A5, name: "ATM Controller (1410a500)" },
		Device { id: 0x00A6, name: "ATM 155MBPS MM Controller (1410a600)" },
		Device { id: 0x00B7, name: "GXT2000P Graphics Adapter" },
		Device { id: 0x00B8, name: "GXT2000P Graphics Adapter" },
		Device { id: 0x00BE, name: "ATM 622MBPS Controller (1410be00)" },
		Device { id: 0x00DC, name: "Advanced Systems Management Adapter (ASMA)" },
		Device { id: 0x00FC, name: "CPC710 Dual Bridge and Memory Controller (PCI-64)" },
		Device { id: 0x0105, name: "CPC710 Dual Bridge and Memory Controller (PCI-32)" },
		Device { id: 0x010F, name: "Remote Supervisor Adapter (RSA)" },
		Device { id: 0x0142, name: "Yotta Video Compositor Input" },
		Device { id: 0x0144, name: "Yotta Video Compositor Output" },
		Device { id: 0x0156, name: "405GP PLB to PCI Bridge" },
		Device { id: 0x015E, name: "622Mbps ATM PCI Adapter" },
		Device { id: 0x0160, name: "64bit/66MHz PCI ATM 155 MMF" },
		Device { id: 0x016E, name: "GXT4000P Graphics Adapter" },
		Device { id: 0x0170, name: "GXT6000P Graphics Adapter" },
		Device { id: 0x017D, name: "GXT300P Graphics Adapter" },
		Device { id: 0x0180, name: "Snipe chipset SCSI controller" },
		Device { id: 0x0188, name: "EADS-X PCI-X to PCI-X Bridge" },
		Device { id: 0x01A7, name: "PCI-X to PCI-X Bridge" },
		Device { id: 0x01BD, name: "ServeRAID Controller" },
		Device { id: 0x01C1, name: "64bit/66MHz PCI ATM 155 UTP" },
		Device { id: 0x01E6, name: "Cryptographic Accelerator" },
		Device { id: 0x01EF, name: "PowerPC 440GP PCI Bridge" },
		Device { id: 0x01FF, name: "10/100 Mbps Ethernet" },
		Device { id: 0x0219, name: "Multiport Serial Adapter" },
		Device { id: 0x021B, name: "GXT6500P Graphics Adapter" },
		Device { id: 0x021C, name: "GXT4500P Graphics Adapter" },
		Device { id: 0x0233, name: "GXT135P Graphics Adapter" },
		Device { id: 0x028C, name: "Citrine chipset SCSI controller" },
		Device { id: 0x02A1, name: "Calgary PCI-X Host Bridge" },
		Device { id: 0x02BD, name: "Obsidian chipset SCSI controller" },
		Device { id: 0x0302, name: "Winnipeg PCI-X Host Bridge" },
		Device { id: 0x0308, name: "CalIOC2 PCI-E Root Port" },
		Device { id: 0x0311, name: "FC 5740/1954 4-Port 10/100/1000 Base-TX PCI-X Adapter for POWER" },
		Device { id: 0x0314, name: "ZISC 036 Neural accelerator card" },
		Device { id: 0x032D, name: "Axon - Cell Companion Chip" },
		Device { id: 0x0339, name: "Obsidian-E PCI-E SCSI controller" },
		Device { id: 0x033D, name: "PCI-E IPR SAS Adapter (FPGA)" },
		Device { id: 0x034A, name: "PCI-E IPR SAS Adapter (ASIC)" },
		Device { id: 0x03DC, name: "POWER8 Host Bridge (PHB3)" },
		Device { id: 0x044B, name: "GenWQE Accelerator Adapter" },
		Device { id: 0x04AA, name: "Flash Adapter 90 (PCIe2 0.9TB)" },
		Device { id: 0x04DA, name: "PCI-E IPR SAS+ Adapter (ASIC)" },
		Device { id: 0x04ED, name: "Internal Shared Memory (ISM) virtual PCI device" },
		Device { id: 0x3022, name: "QLA3022 Network Adapter" },
		Device { id: 0x4022, name: "QLA3022 Network Adapter" },
		Device { id: 0xFFFF, name: "MPIC-2 interrupt controller" },
	] },
	Vendor { id: 0x1015, name: "LSI Logic Corp of Canada", devices: &[
	] },
	Vendor { id: 0x1016, name: "ICL Personal Systems", devices: &[
	] },
	Vendor { id: 0x1017, name: "SPEA Software AG", devices: &[
		Device { id: 0x5343, name: "SPEA 3D Accelerator" },
	] },
	Vendor { id: 0x1018, name: "Unisys Systems", devices: &[
	] },
	Vendor { id: 0x1019, name: "Elitegroup Computer Systems", devices: &[
	] },
	Vendor { id: 0x101A, name: "AT&T GIS (NCR)", devices: &[
		Device { id: 0x0005, name: "100VG ethernet" },
		Device { id: 0x0007, name: "BYNET BIC4G/2C/2G" },
		Device { id: 0x0009, name: "PQS Memory Controller" },
		Device { id: 0x000A, name: "BYNET BPCI Adapter" },
		Device { id: 0x000B, name: "BYNET 4 Port BYA Switch (BYA4P)" },
		Device { id: 0x000C, name: "BYNET 4 Port BYA Switch (BYA4G)" },
		Device { id: 0x0010, name: "NCR AMC Memory Controller" },
		Device { id: 0x1DC1, name: "BYNET BIC2M/BIC4M/BYA4M" },
		Device { id: 0x1FA8, name: "BYNET Multi-port BIC Adapter (XBIC Based)" },
	] },
	Vendor { id: 0x101B, name: "Vitesse Semiconductor", devices: &[
		Device { id: 0x0452, name: "VSC452 [SuperBMC]" },
	] },
	Vendor { id: 0x101C, name: "Western Digital", devices: &[
		Device { id: 0x0193, name: "33C193A" },
		Device { id: 0x0196, name: "33C196A" },
		Device { id: 0x0197, name: "33C197A" },
		Device { id: 0x0296, name: "33C296A" },
		Device { id: 0x3193, name: "7193" },
		Device { id: 0x3197, name: "7197" },
		Device { id: 0x3296, name: "33C296A" },
		Device { id: 0x4296, name: "34C296" },
		Device { id: 0x9710, name: "Pipeline 9710" },
		Device { id: 0x9712, name: "Pipeline 9712" },
		Device { id: 0xC24A, name: "90C" },
	] },
	Vendor { id: 0x101D, name: "Maxim Integrated Products", devices: &[
	] },
	Vendor { id: 0x101E, name: "American Megatrends Inc.", devices: &[
		Device { id: 0x0009, name: "MegaRAID 428 Ultra RAID Controller (rev 03)" },
		Device { id: 0x1960, name: "MegaRAID" },
		Device { id: 0x9010, name: "MegaRAID 428 Ultra RAID Controller" },
		Device { id: 0x9030, name: "EIDE Controller" },
		Device { id: 0x9031, name: "EIDE Controller" },
		Device { id: 0x9032, name: "EIDE & SCSI Controller" },
		Device { id: 0x9033, name: "SCSI Controller" },
		Device { id: 0x9040, name: "Multimedia card" },
		Device { id: 0x9060, name: "MegaRAID 434 Ultra GT RAID Controller" },
		Device { id: 0x9063, name: "MegaRAC" },
	] },
	Vendor { id: 0x101F, name: "PictureTel", devices: &[
	] },
	Vendor { id: 0x1020, name: "Hitachi Computer Products", devices: &[
	] },
	Vendor { id: 0x1021, name: "OKI Electric Industry Co. Ltd.", devices: &[
	] },
	Vendor { id: 0x1022, name: "Advanced Micro Devices, Inc. [AMD]", devices: &[
		Device { id: 0x1100, name: "K8 [Athlon64/Opteron] HyperTransport Technology Configuration" },
		Device { id: 0x1101, name: "K8 [Athlon64/Opteron] Address Map" },
		Device { id: 0x1102, name: "K8 [Athlon64/Opteron] DRAM Controller" },
		Device { id: 0x1103, name: "K8 [Athlon64/Opteron] Miscellaneous Control" },
		Device { id: 0x1200, name: "Family 10h Processor HyperTransport Configuration" },
		Device { id: 0x1201, name: "Family 10h Processor Address Map" },
		Device { id: 0x1202, name: "Family 10h Processor DRAM Controller" },
		Device { id: 0x1203, name: "Family 10h Processor Miscellaneous Control" },
		Device { id: 0x1204, name: "Family 10h Processor Link Control" },
		Device { id: 0x1300, name: "Family 11h Processor HyperTransport Configuration" },
		Device { id: 0x1301, name: "Family 11h Processor Address Map" },
		Device { id: 0x1302, name: "Family 11h Processor DRAM Controller" },
		Device { id: 0x1303, name: "Family 11h Processor Miscellaneous Control" },
		Device { id: 0x1304, name: "Family 11h Processor Link Control" },
		Device { id: 0x1400, name: "Family 15h (Models 10h-1fh) Processor Function 0" },
		Device { id: 0x1401, name: "Family 15h (Models 10h-1fh) Processor Function 1" },
		Device { id: 0x1402, name: "Family 15h (Models 10h-1fh) Processor Function 2" },
		Device { id: 0x1403, name: "Family 15h (Models 10h-1fh) Processor Function 3" },
		Device { id: 0x1404, name: "Family 15h (Models 10h-1fh) Processor Function 4" },
		Device { id: 0x1405, name: "Family 15h (Models 10h-1fh) Processor Function 5" },
		Device { id: 0x1410, name: "Family 15h (Models 10h-1fh) Processor Root Complex" },
		Device { id: 0x1412, name: "Family 15h (Models 10h-1fh) Processor Root Port" },
		Device { id: 0x1413, name: "Family 15h (Models 10h-1fh) Processor Root Port" },
		Device { id: 0x1414, name: "Family 15h (Models 10h-1fh) Processor Root Port" },
		Device { id: 0x1415, name: "Family 15h (Models 10h-1fh) Processor Root Port" },
		Device { id: 0x1416, name: "Family 15h (Models 10h-1fh) Processor Root Port" },
		Device { id: 0x1417, name: "Family 15h (Models 10h-1fh) Processor Root Port" },
		Device { id: 0x1418, name: "Family 15h (Models 10h-1fh) Processor Root Port" },
		Device { id: 0x1419, name: "Family 15h (Models 10h-1fh) I/O Memory Management Unit" },
		Device { id: 0x141A, name: "Family 15h (Models 30h-3fh) Processor Function 0" },
		Device { id: 0x141B, name: "Family 15h (Models 30h-3fh) Processor Function 1" },
		Device { id: 0x141C, name: "Family 15h (Models 30h-3fh) Processor Function 2" },
		Device { id: 0x141D, name: "Family 15h (Models 30h-3fh) Processor Function 3" },
		Device { id: 0x141E, name: "Family 15h (Models 30h-3fh) Processor Function 4" },
		Device { id: 0x141F, name: "Family 15h (Models 30h-3fh) Processor Function 5" },
		Device { id: 0x1422, name: "Family 15h (Models 30h-3fh) Processor Root Complex" },
		Device { id: 0x1423, name: "Family 15h (Models 30h-3fh) I/O Memory Management Unit" },
		Device { id: 0x1424, name: "Family 15h (Models 30h-3fh) Processor Root Port" },
		Device { id: 0x1426, name: "Family 15h (Models 30h-3fh) Processor Root Port" },
		Device { id: 0x1436, name: "Liverpool Processor Root Complex" },
		Device { id: 0x1437, name: "Liverpool I/O Memory Management Unit" },
		Device { id: 0x1438, name: "Liverpool Processor Root Port" },
		Device { id: 0x1439, name: "Family 16h Processor Functions 5:1" },
		Device { id: 0x1450, name: "Family 17h (Models 00h-0fh) Root Complex" },
		Device { id: 0x1451, name: "Family 17h (Models 00h-0fh) I/O Memory Management Unit" },
		Device { id: 0x1452, name: "Family 17h (Models 00h-0fh) PCIe Dummy Host Bridge" },
		Device { id: 0x1453, name: "Family 17h (Models 00h-0fh) PCIe GPP Bridge" },
		Device { id: 0x1454, name: "Family 17h (Models 00h-0fh) Internal PCIe GPP Bridge 0 to Bus B" },
		Device { id: 0x1456, name: "Family 17h (Models 00h-0fh) Platform Security Processor" },
		Device { id: 0x1457, name: "Family 17h (Models 00h-0fh) HD Audio Controller" },
		Device { id: 0x145B, name: "Zeppelin Non-Transparent Bridge" },
		Device { id: 0x145C, name: "Family 17h (Models 00h-0fh) USB 3.0 Host Controller" },
		Device { id: 0x145F, name: "USB 3.0 Host controller" },
		Device { id: 0x1460, name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 0" },
		Device { id: 0x1461, name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 1" },
		Device { id: 0x1462, name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 2" },
		Device { id: 0x1463, name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 3" },
		Device { id: 0x1464, name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 4" },
		Device { id: 0x1465, name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 5" },
		Device { id: 0x1466, name: "Family 17h (Models 00h-0fh) Data Fabric Device 18h Function 6" },
		Device { id: 0x1467, name: "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 7" },
		Device { id: 0x1510, name: "Family 14h Processor Root Complex" },
		Device { id: 0x1512, name: "Family 14h Processor Root Port" },
		Device { id: 0x1513, name: "Family 14h Processor Root Port" },
		Device { id: 0x1514, name: "Family 14h Processor Root Port" },
		Device { id: 0x1515, name: "Family 14h Processor Root Port" },
		Device { id: 0x1516, name: "Family 14h Processor Root Port" },
		Device { id: 0x1530, name: "Family 16h Processor Function 0" },
		Device { id: 0x1531, name: "Family 16h Processor Function 1" },
		Device { id: 0x1532, name: "Family 16h Processor Function 2" },
		Device { id: 0x1533, name: "Family 16h Processor Function 3" },
		Device { id: 0x1534, name: "Family 16h Processor Function 4" },
		Device { id: 0x1535, name: "Family 16h Processor Function 5" },
		Device { id: 0x1536, name: "Family 16h Processor Root Complex" },
		Device { id: 0x1538, name: "Family 16h Processor Function 0" },
		Device { id: 0x1600, name: "Family 15h Processor Function 0" },
		Device { id: 0x1601, name: "Family 15h Processor Function 1" },
		Device { id: 0x1602, name: "Family 15h Processor Function 2" },
		Device { id: 0x1603, name: "Family 15h Processor Function 3" },
		Device { id: 0x1604, name: "Family 15h Processor Function 4" },
		Device { id: 0x1605, name: "Family 15h Processor Function 5" },
		Device { id: 0x1700, name: "Family 12h/14h Processor Function 0" },
		Device { id: 0x1701, name: "Family 12h/14h Processor Function 1" },
		Device { id: 0x1702, name: "Family 12h/14h Processor Function 2" },
		Device { id: 0x1703, name: "Family 12h/14h Processor Function 3" },
		Device { id: 0x1704, name: "Family 12h/14h Processor Function 4" },
		Device { id: 0x1705, name: "Family 12h Processor Root Complex" },
		Device { id: 0x1707, name: "Family 12h Processor Root Port" },
		Device { id: 0x1708, name: "Family 12h Processor Root Port" },
		Device { id: 0x1709, name: "Family 12h Processor Root Port" },
		Device { id: 0x170A, name: "Family 12h Processor Root Port" },
		Device { id: 0x170B, name: "Family 12h Processor Root Port" },
		Device { id: 0x170C, name: "Family 12h Processor Root Port" },
		Device { id: 0x170D, name: "Family 12h Processor Root Port" },
		Device { id: 0x1716, name: "Family 12h/14h Processor Function 5" },
		Device { id: 0x1718, name: "Family 12h/14h Processor Function 6" },
		Device { id: 0x1719, name: "Family 12h/14h Processor Function 7" },
		Device { id: 0x2000, name: "79c970 [PCnet32 LANCE]" },
		Device { id: 0x2001, name: "79c978 [HomePNA]" },
		Device { id: 0x2003, name: "Am 1771 MBW [Alchemy]" },
		Device { id: 0x2020, name: "53c974 [PCscsi]" },
		Device { id: 0x2040, name: "79c974" },
		Device { id: 0x2080, name: "CS5536 [Geode companion] Host Bridge" },
		Device { id: 0x2081, name: "Geode LX Video" },
		Device { id: 0x2082, name: "Geode LX AES Security Block" },
		Device { id: 0x208F, name: "CS5536 GeodeLink PCI South Bridge" },
		Device { id: 0x2090, name: "CS5536 [Geode companion] ISA" },
		Device { id: 0x2091, name: "CS5536 [Geode companion] FLASH" },
		Device { id: 0x2093, name: "CS5536 [Geode companion] Audio" },
		Device { id: 0x2094, name: "CS5536 [Geode companion] OHC" },
		Device { id: 0x2095, name: "CS5536 [Geode companion] EHC" },
		Device { id: 0x2096, name: "CS5536 [Geode companion] UDC" },
		Device { id: 0x2097, name: "CS5536 [Geode companion] UOC" },
		Device { id: 0x209A, name: "CS5536 [Geode companion] IDE" },
		Device { id: 0x3000, name: "ELanSC520 Microcontroller" },
		Device { id: 0x43A0, name: "Hudson PCI to PCI bridge (PCIE port 0)" },
		Device { id: 0x43A1, name: "Hudson PCI to PCI bridge (PCIE port 1)" },
		Device { id: 0x43A2, name: "Hudson PCI to PCI bridge (PCIE port 2)" },
		Device { id: 0x43A3, name: "Hudson PCI to PCI bridge (PCIE port 3)" },
		Device { id: 0x43B4, name: "300 Series Chipset PCIe Port" },
		Device { id: 0x43B7, name: "300 Series Chipset SATA Controller" },
		Device { id: 0x43BB, name: "300 Series Chipset USB 3.1 xHCI Controller" },
		Device { id: 0x7006, name: "AMD-751 [Irongate] System Controller" },
		Device { id: 0x7007, name: "AMD-751 [Irongate] AGP Bridge" },
		Device { id: 0x700A, name: "AMD-IGR4 AGP Host to PCI Bridge" },
		Device { id: 0x700B, name: "AMD-IGR4 PCI to PCI Bridge" },
		Device { id: 0x700C, name: "AMD-760 MP [IGD4-2P] System Controller" },
		Device { id: 0x700D, name: "AMD-760 MP [IGD4-2P] AGP Bridge" },
		Device { id: 0x700E, name: "AMD-760 [IGD4-1P] System Controller" },
		Device { id: 0x700F, name: "AMD-760 [IGD4-1P] AGP Bridge" },
		Device { id: 0x7400, name: "AMD-755 [Cobra] ISA" },
		Device { id: 0x7401, name: "AMD-755 [Cobra] IDE" },
		Device { id: 0x7403, name: "AMD-755 [Cobra] ACPI" },
		Device { id: 0x7404, name: "AMD-755 [Cobra] USB" },
		Device { id: 0x7408, name: "AMD-756 [Viper] ISA" },
		Device { id: 0x7409, name: "AMD-756 [Viper] IDE" },
		Device { id: 0x740B, name: "AMD-756 [Viper] ACPI" },
		Device { id: 0x740C, name: "AMD-756 [Viper] USB" },
		Device { id: 0x7410, name: "AMD-766 [ViperPlus] ISA" },
		Device { id: 0x7411, name: "AMD-766 [ViperPlus] IDE" },
		Device { id: 0x7413, name: "AMD-766 [ViperPlus] ACPI" },
		Device { id: 0x7414, name: "AMD-766 [ViperPlus] USB" },
		Device { id: 0x7440, name: "AMD-768 [Opus] ISA" },
		Device { id: 0x7441, name: "AMD-768 [Opus] IDE" },
		Device { id: 0x7443, name: "AMD-768 [Opus] ACPI" },
		Device { id: 0x7445, name: "AMD-768 [Opus] Audio" },
		Device { id: 0x7446, name: "AMD-768 [Opus] MC97 Modem" },
		Device { id: 0x7448, name: "AMD-768 [Opus] PCI" },
		Device { id: 0x7449, name: "AMD-768 [Opus] USB" },
		Device { id: 0x7450, name: "AMD-8131 PCI-X Bridge" },
		Device { id: 0x7451, name: "AMD-8131 PCI-X IOAPIC" },
		Device { id: 0x7454, name: "AMD-8151 System Controller" },
		Device { id: 0x7455, name: "AMD-8151 AGP Bridge" },
		Device { id: 0x7458, name: "AMD-8132 PCI-X Bridge" },
		Device { id: 0x7459, name: "AMD-8132 PCI-X IOAPIC" },
		Device { id: 0x7460, name: "AMD-8111 PCI" },
		Device { id: 0x7461, name: "AMD-8111 USB" },
		Device { id: 0x7462, name: "AMD-8111 Ethernet" },
		Device { id: 0x7463, name: "AMD-8111 USB EHCI" },
		Device { id: 0x7464, name: "AMD-8111 USB OHCI" },
		Device { id: 0x7468, name: "AMD-8111 LPC" },
		Device { id: 0x7469, name: "AMD-8111 IDE" },
		Device { id: 0x746A, name: "AMD-8111 SMBus 2.0" },
		Device { id: 0x746B, name: "AMD-8111 ACPI" },
		Device { id: 0x746D, name: "AMD-8111 AC97 Audio" },
		Device { id: 0x746E, name: "AMD-8111 MC97 Modem" },
		Device { id: 0x756B, name: "AMD-8111 ACPI" },
		Device { id: 0x7800, name: "FCH SATA Controller [IDE mode]" },
		Device { id: 0x7801, name: "FCH SATA Controller [AHCI mode]" },
		Device { id: 0x7802, name: "FCH SATA Controller [RAID mode]" },
		Device { id: 0x7803, name: "FCH SATA Controller [RAID mode]" },
		Device { id: 0x7804, name: "FCH SATA Controller [AHCI mode]" },
		Device { id: 0x7805, name: "FCH SATA Controller [RAID mode]" },
		Device { id: 0x7806, name: "FCH SD Flash Controller" },
		Device { id: 0x7807, name: "FCH USB OHCI Controller" },
		Device { id: 0x7808, name: "FCH USB EHCI Controller" },
		Device { id: 0x7809, name: "FCH USB OHCI Controller" },
		Device { id: 0x780B, name: "FCH SMBus Controller" },
		Device { id: 0x780C, name: "FCH IDE Controller" },
		Device { id: 0x780D, name: "FCH Azalia Controller" },
		Device { id: 0x780E, name: "FCH LPC Bridge" },
		Device { id: 0x780F, name: "FCH PCI Bridge" },
		Device { id: 0x7812, name: "FCH USB XHCI Controller" },
		Device { id: 0x7813, name: "FCH SD Flash Controller" },
		Device { id: 0x7814, name: "FCH USB XHCI Controller" },
		Device { id: 0x7900, name: "FCH SATA Controller [IDE mode]" },
		Device { id: 0x7901, name: "FCH SATA Controller [AHCI mode]" },
		Device { id: 0x7902, name: "FCH SATA Controller [RAID mode]" },
		Device { id: 0x7903, name: "FCH SATA Controller [RAID mode]" },
		Device { id: 0x7904, name: "FCH SATA Controller [AHCI mode]" },
		Device { id: 0x7906, name: "FCH SD Flash Controller" },
		Device { id: 0x7908, name: "FCH USB EHCI Controller" },
		Device { id: 0x790B, name: "FCH SMBus Controller" },
		Device { id: 0x790E, name: "FCH LPC Bridge" },
		Device { id: 0x790F, name: "FCH PCI Bridge" },
		Device { id: 0x7914, name: "FCH USB XHCI Controller" },
		Device { id: 0x9600, name: "RS780 Host Bridge" },
		Device { id: 0x9601, name: "RS880 Host Bridge" },
		Device { id: 0x9602, name: "RS780/RS880 PCI to PCI bridge (int gfx)" },
		Device { id: 0x9603, name: "RS780 PCI to PCI bridge (ext gfx port 0)" },
		Device { id: 0x9604, name: "RS780/RS880 PCI to PCI bridge (PCIE port 0)" },
		Device { id: 0x9605, name: "RS780/RS880 PCI to PCI bridge (PCIE port 1)" },
		Device { id: 0x9606, name: "RS780 PCI to PCI bridge (PCIE port 2)" },
		Device { id: 0x9607, name: "RS780/RS880 PCI to PCI bridge (PCIE port 3)" },
		Device { id: 0x9608, name: "RS780/RS880 PCI to PCI bridge (PCIE port 4)" },
		Device { id: 0x9609, name: "RS780/RS880 PCI to PCI bridge (PCIE port 5)" },
		Device { id: 0x960A, name: "RS780 PCI to PCI bridge (NB-SB link)" },
		Device { id: 0x960B, name: "RS780 PCI to PCI bridge (ext gfx port 1)" },
	] },
	Vendor { id: 0x1023, name: "Trident Microsystems", devices: &[
		Device { id: 0x0194, name: "82C194" },
		Device { id: 0x2000, name: "4DWave DX" },
		Device { id: 0x2001, name: "4DWave NX" },
		Device { id: 0x2100, name: "CyberBlade XP4m32" },
		Device { id: 0x2200, name: "XGI Volari XP5" },
		Device { id: 0x8400, name: "CyberBlade/i7" },
		Device { id: 0x8420, name: "CyberBlade/i7d" },
		Device { id: 0x8500, name: "CyberBlade/i1" },
		Device { id: 0x8520, name: "CyberBlade i1" },
		Device { id: 0x8620, name: "CyberBlade/i1" },
		Device { id: 0x8820, name: "CyberBlade XPAi1" },
		Device { id: 0x9320, name: "TGUI 9320" },
		Device { id: 0x9350, name: "GUI Accelerator" },
		Device { id: 0x9360, name: "Flat panel GUI Accelerator" },
		Device { id: 0x9382, name: "Cyber 9382 [Reference design]" },
		Device { id: 0x9383, name: "Cyber 9383 [Reference design]" },
		Device { id: 0x9385, name: "Cyber 9385 [Reference design]" },
		Device { id: 0x9386, name: "Cyber 9386" },
		Device { id: 0x9388, name: "Cyber 9388" },
		Device { id: 0x9397, name: "Cyber 9397" },
		Device { id: 0x939A, name: "Cyber 9397DVD" },
		Device { id: 0x9420, name: "TGUI 9420" },
		Device { id: 0x9430, name: "TGUI 9430" },
		Device { id: 0x9440, name: "TGUI 9440" },
		Device { id: 0x9460, name: "TGUI 9460" },
		Device { id: 0x9470, name: "TGUI 9470" },
		Device { id: 0x9520, name: "Cyber 9520" },
		Device { id: 0x9525, name: "Cyber 9525" },
		Device { id: 0x9540, name: "Cyber 9540" },
		Device { id: 0x9660, name: "TGUI 9660/938x/968x" },
		Device { id: 0x9680, name: "TGUI 9680" },
		Device { id: 0x9682, name: "TGUI 9682" },
		Device { id: 0x9683, name: "TGUI 9683" },
		Device { id: 0x9685, name: "ProVIDIA 9685" },
		Device { id: 0x9750, name: "3DImage 9750" },
		Device { id: 0x9753, name: "TGUI 9753" },
		Device { id: 0x9754, name: "TGUI 9754" },
		Device { id: 0x9759, name: "TGUI 975" },
		Device { id: 0x9783, name: "TGUI 9783" },
		Device { id: 0x9785, name: "TGUI 9785" },
		Device { id: 0x9850, name: "3DImage 9850" },
		Device { id: 0x9880, name: "Blade 3D PCI/AGP" },
		Device { id: 0x9910, name: "CyberBlade/XP" },
		Device { id: 0x9930, name: "CyberBlade/XPm" },
		Device { id: 0x9960, name: "CyberBlade XP2" },
	] },
	Vendor { id: 0x1024, name: "Zenith Data Systems", devices: &[
	] },
	Vendor { id: 0x1025, name: "Acer Incorporated [ALI]", devices: &[
		Device { id: 0x1435, name: "M1435" },
		Device { id: 0x1445, name: "M1445" },
		Device { id: 0x1449, name: "M1449" },
		Device { id: 0x1451, name: "M1451" },
		Device { id: 0x1461, name: "M1461" },
		Device { id: 0x1489, name: "M1489" },
		Device { id: 0x1511, name: "M1511" },
		Device { id: 0x1512, name: "ALI M1512 Aladdin" },
		Device { id: 0x1513, name: "M1513" },
		Device { id: 0x1521, name: "ALI M1521 Aladdin III CPU Bridge" },
		Device { id: 0x1523, name: "ALI M1523 ISA Bridge" },
		Device { id: 0x1531, name: "M1531 Northbridge [Aladdin IV/IV+]" },
		Device { id: 0x1533, name: "M1533 PCI-to-ISA Bridge" },
		Device { id: 0x1535, name: "M1535 PCI Bridge + Super I/O + FIR" },
		Device { id: 0x1541, name: "M1541 Northbridge [Aladdin V]" },
		Device { id: 0x1542, name: "M1542 Northbridge [Aladdin V]" },
		Device { id: 0x1543, name: "M1543 PCI-to-ISA Bridge + Super I/O + FIR" },
		Device { id: 0x1561, name: "M1561 Northbridge [Aladdin 7]" },
		Device { id: 0x1621, name: "M1621 Northbridge [Aladdin-Pro II]" },
		Device { id: 0x1631, name: "M1631 Northbridge+3D Graphics [Aladdin TNT2]" },
		Device { id: 0x1641, name: "M1641 Northbridge [Aladdin-Pro IV]" },
		Device { id: 0x1647, name: "M1647 [MaGiK1] PCI North Bridge" },
		Device { id: 0x1671, name: "M1671 Northbridge [ALADDiN-P4]" },
		Device { id: 0x1672, name: "Northbridge [CyberALADDiN-P4]" },
		Device { id: 0x3141, name: "M3141" },
		Device { id: 0x3143, name: "M3143" },
		Device { id: 0x3145, name: "M3145" },
		Device { id: 0x3147, name: "M3147" },
		Device { id: 0x3149, name: "M3149" },
		Device { id: 0x3151, name: "M3151" },
		Device { id: 0x3307, name: "M3307 MPEG-I Video Controller" },
		Device { id: 0x3309, name: "M3309 MPEG-II Video w/ Software Audio Decoder" },
		Device { id: 0x3321, name: "M3321 MPEG-II Audio/Video Decoder" },
		Device { id: 0x5212, name: "M4803" },
		Device { id: 0x5215, name: "ALI PCI EIDE Controller" },
		Device { id: 0x5217, name: "M5217H" },
		Device { id: 0x5219, name: "M5219" },
		Device { id: 0x5225, name: "M5225" },
		Device { id: 0x5229, name: "M5229" },
		Device { id: 0x5235, name: "M5235" },
		Device { id: 0x5237, name: "M5237 PCI USB Host Controller" },
		Device { id: 0x5240, name: "EIDE Controller" },
		Device { id: 0x5241, name: "PCMCIA Bridge" },
		Device { id: 0x5242, name: "General Purpose Controller" },
		Device { id: 0x5243, name: "PCI to PCI Bridge Controller" },
		Device { id: 0x5244, name: "Floppy Disk Controller" },
		Device { id: 0x5247, name: "M1541 PCI to PCI Bridge" },
		Device { id: 0x5251, name: "M5251 P1394 Controller" },
		Device { id: 0x5427, name: "PCI to AGP Bridge" },
		Device { id: 0x5451, name: "M5451 PCI AC-Link Controller Audio Device" },
		Device { id: 0x5453, name: "M5453 PCI AC-Link Controller Modem Device" },
		Device { id: 0x7101, name: "M7101 PCI PMU Power Management Controller" },
		Device { id: 0x9602, name: "AMD RS780/RS880 PCI to PCI bridge (int gfx)" },
	] },
	Vendor { id: 0x1028, name: "Dell", devices: &[
		Device { id: 0x0001, name: "PowerEdge Expandable RAID Controller 2/Si" },
		Device { id: 0x0002, name: "PowerEdge Expandable RAID Controller 3/Di" },
		Device { id: 0x0003, name: "PowerEdge Expandable RAID Controller 3/Si" },
		Device { id: 0x0004, name: "PowerEdge Expandable RAID Controller 3/Di [Iguana]" },
		Device { id: 0x0006, name: "PowerEdge Expandable RAID Controller 3/Di" },
		Device { id: 0x0007, name: "Remote Access Card III" },
		Device { id: 0x0008, name: "Remote Access Card III" },
		Device { id: 0x0009, name: "Remote Access Card III: BMC/SMIC device not present" },
		Device { id: 0x000A, name: "PowerEdge Expandable RAID Controller 3/Di" },
		Device { id: 0x000C, name: "Embedded Remote Access or ERA/O" },
		Device { id: 0x000D, name: "Embedded Remote Access: BMC/SMIC device" },
		Device { id: 0x000E, name: "PowerEdge Expandable RAID controller 4/Di" },
		Device { id: 0x000F, name: "PowerEdge Expandable RAID controller 4/Di" },
		Device { id: 0x0010, name: "Remote Access Card 4" },
		Device { id: 0x0011, name: "Remote Access Card 4 Daughter Card" },
		Device { id: 0x0012, name: "Remote Access Card 4 Daughter Card Virtual UART" },
		Device { id: 0x0013, name: "PowerEdge Expandable RAID controller 4" },
		Device { id: 0x0014, name: "Remote Access Card 4 Daughter Card SMIC interface" },
		Device { id: 0x0015, name: "PowerEdge Expandable RAID controller 5" },
		Device { id: 0x0016, name: "PowerEdge Expandable RAID controller S300" },
		Device { id: 0x0073, name: "NV-RAM Adapter" },
	] },
	Vendor { id: 0x1029, name: "Siemens Nixdorf IS", devices: &[
	] },
	Vendor { id: 0x102A, name: "LSI Logic", devices: &[
		Device { id: 0x0000, name: "HYDRA" },
		Device { id: 0x0010, name: "ASPEN" },
		Device { id: 0x001F, name: "AHA-2940U2/U2W /7890/7891 SCSI Controllers" },
		Device { id: 0x00C5, name: "AIC-7899 U160/m SCSI Controller" },
		Device { id: 0x00CF, name: "AIC-7899P U160/m" },
	] },
	Vendor { id: 0x102B, name: "Matrox Electronics Systems Ltd.", devices: &[
		Device { id: 0x0010, name: "MGA-I [Impression?]" },
		Device { id: 0x0100, name: "MGA 1064SG [Mystique]" },
		Device { id: 0x0518, name: "MGA-II [Athena]" },
		Device { id: 0x0519, name: "MGA 2064W [Millennium]" },
		Device { id: 0x051A, name: "MGA 1064SG [Mystique]" },
		Device { id: 0x051B, name: "MGA 2164W [Millennium II]" },
		Device { id: 0x051E, name: "MGA 1064SG [Mystique] AGP" },
		Device { id: 0x051F, name: "MGA 2164W [Millennium II] AGP" },
		Device { id: 0x0520, name: "MGA G200" },
		Device { id: 0x0521, name: "MGA G200 AGP" },
		Device { id: 0x0522, name: "MGA G200e [Pilot] ServerEngines (SEP1)" },
		Device { id: 0x0525, name: "MGA G400/G450" },
		Device { id: 0x0527, name: "Parhelia" },
		Device { id: 0x0528, name: "Parhelia" },
		Device { id: 0x0530, name: "MGA G200EV" },
		Device { id: 0x0532, name: "MGA G200eW WPCM450" },
		Device { id: 0x0533, name: "MGA G200EH" },
		Device { id: 0x0534, name: "G200eR2" },
		Device { id: 0x0536, name: "Integrated Matrox G200eW3 Graphics Controller" },
		Device { id: 0x0538, name: "G200eH" },
		Device { id: 0x0540, name: "M91XX" },
		Device { id: 0x0550, name: "SV2" },
		Device { id: 0x0D10, name: "MGA Ultima/Impression" },
		Device { id: 0x1000, name: "MGA G100 [Productiva]" },
		Device { id: 0x1001, name: "MGA G100 [Productiva] AGP" },
		Device { id: 0x2007, name: "MGA Mistral" },
		Device { id: 0x2527, name: "Millennium G550" },
		Device { id: 0x2537, name: "Millennium P650/P750" },
		Device { id: 0x2538, name: "Millennium P650 PCIe" },
		Device { id: 0x2539, name: "Millennium P690" },
		Device { id: 0x4164, name: "Morphis QxT frame grabber" },
		Device { id: 0x43B4, name: "Morphis Qxt encoding engine" },
		Device { id: 0x4510, name: "Morphis COM port" },
		Device { id: 0x4536, name: "VIA Framegrabber" },
		Device { id: 0x4686, name: "Concord GX (customized Intel 82541)" },
		Device { id: 0x475B, name: "Solios eCL/XCL-B frame grabber" },
		Device { id: 0x475D, name: "Vio frame grabber family" },
		Device { id: 0x475F, name: "Solios (single-Full) CL frame grabber" },
		Device { id: 0x47A1, name: "Solios eA/XA frame grabber" },
		Device { id: 0x47A2, name: "Solios COM port" },
		Device { id: 0x47C1, name: "Solios (dual-Base/single-Medium) CL frame grabber" },
		Device { id: 0x47C2, name: "Solios COM port" },
		Device { id: 0x4949, name: "Radient frame grabber family" },
		Device { id: 0x4CDC, name: "Morphis JPEG2000 accelerator" },
		Device { id: 0x4F54, name: "Morphis (e)Quad frame grabber" },
		Device { id: 0x4FC5, name: "Morphis (e)Dual frame grabber" },
		Device { id: 0x5E10, name: "Morphis aux I/O" },
		Device { id: 0x6573, name: "Shark 10/100 Multiport SwitchNIC" },
	] },
	Vendor { id: 0x102C, name: "Chips and Technologies", devices: &[
		Device { id: 0x00B8, name: "F64310" },
		Device { id: 0x00C0, name: "F69000 HiQVideo" },
		Device { id: 0x00D0, name: "F65545" },
		Device { id: 0x00D8, name: "F65545" },
		Device { id: 0x00DC, name: "F65548" },
		Device { id: 0x00E0, name: "F65550" },
		Device { id: 0x00E4, name: "F65554" },
		Device { id: 0x00E5, name: "F65555 HiQVPro" },
		Device { id: 0x00F0, name: "F68554" },
		Device { id: 0x00F4, name: "F68554 HiQVision" },
		Device { id: 0x00F5, name: "F68555" },
		Device { id: 0x0C30, name: "F69030" },
	] },
	Vendor { id: 0x102D, name: "Wyse Technology Inc.", devices: &[
		Device { id: 0x50DC, name: "3328 Audio" },
	] },
	Vendor { id: 0x102E, name: "Olivetti Advanced Technology", devices: &[
	] },
	Vendor { id: 0x102F, name: "Toshiba America", devices: &[
		Device { id: 0x0009, name: "r4x00" },
		Device { id: 0x000A, name: "TX3927 MIPS RISC PCI Controller" },
		Device { id: 0x0020, name: "ATM Meteor 155" },
		Device { id: 0x0030, name: "TC35815CF PCI 10/100 Mbit Ethernet Controller" },
		Device { id: 0x0031, name: "TC35815CF PCI 10/100 Mbit Ethernet Controller with WOL" },
		Device { id: 0x0032, name: "TC35815CF PCI 10/100 Mbit Ethernet Controller on TX4939" },
		Device { id: 0x0105, name: "TC86C001 [goku-s] IDE" },
		Device { id: 0x0106, name: "TC86C001 [goku-s] USB 1.1 Host" },
		Device { id: 0x0107, name: "TC86C001 [goku-s] USB Device Controller" },
		Device { id: 0x0108, name: "TC86C001 [goku-s] I2C/SIO/GPIO Controller" },
		Device { id: 0x0180, name: "TX4927/38 MIPS RISC PCI Controller" },
		Device { id: 0x0181, name: "TX4925 MIPS RISC PCI Controller" },
		Device { id: 0x0182, name: "TX4937 MIPS RISC PCI Controller" },
		Device { id: 0x01B4, name: "Celleb platform IDE interface" },
		Device { id: 0x01B5, name: "SCC USB 2.0 EHCI controller" },
		Device { id: 0x01B6, name: "SCC USB 1.1 OHCI controller" },
	] },
	Vendor { id: 0x1030, name: "TMC Research", devices: &[
	] },
	Vendor { id: 0x1031, name: "Miro Computer Products AG", devices: &[
		Device { id: 0x5601, name: "DC20 ASIC" },
		Device { id: 0x5607, name: "Video I/O & motion JPEG compressor" },
		Device { id: 0x5631, name: "Media 3D" },
		Device { id: 0x6057, name: "MiroVideo DC10/DC30+" },
	] },
	Vendor { id: 0x1032, name: "Compaq", devices: &[
	] },
	Vendor { id: 0x1033, name: "NEC Corporation", devices: &[
		Device { id: 0x0000, name: "Vr4181A USB Host or Function Control Unit" },
		Device { id: 0x0001, name: "PCI to 486-like bus Bridge" },
		Device { id: 0x0002, name: "PCI to VL98 Bridge" },
		Device { id: 0x0003, name: "ATM Controller" },
		Device { id: 0x0004, name: "R4000 PCI Bridge" },
		Device { id: 0x0005, name: "PCI to 486-like bus Bridge" },
		Device { id: 0x0006, name: "PC-9800 Graphic Accelerator" },
		Device { id: 0x0007, name: "PCI to UX-Bus Bridge" },
		Device { id: 0x0008, name: "PC-9800 Graphic Accelerator" },
		Device { id: 0x0009, name: "PCI to PC9800 Core-Graph Bridge" },
		Device { id: 0x0016, name: "PCI to VL Bridge" },
		Device { id: 0x001A, name: "[Nile II]" },
		Device { id: 0x0021, name: "Vrc4373 [Nile I]" },
		Device { id: 0x0029, name: "PowerVR PCX1" },
		Device { id: 0x002A, name: "PowerVR 3D" },
		Device { id: 0x002C, name: "Star Alpha 2" },
		Device { id: 0x002D, name: "PCI to C-bus Bridge" },
		Device { id: 0x0035, name: "OHCI USB Controller" },
		Device { id: 0x003B, name: "PCI to C-bus Bridge" },
		Device { id: 0x003E, name: "NAPCCARD Cardbus Controller" },
		Device { id: 0x0046, name: "PowerVR PCX2 [midas]" },
		Device { id: 0x005A, name: "Vrc5074 [Nile 4]" },
		Device { id: 0x0063, name: "uPD72862 [Firewarden] IEEE1394 OHCI 1.0 Link Controller" },
		Device { id: 0x0067, name: "PowerVR Neon 250 Chipset" },
		Device { id: 0x0072, name: "uPD72874 IEEE1394 OHCI 1.1 3-port PHY-Link Ctrlr" },
		Device { id: 0x0074, name: "56k Voice Modem" },
		Device { id: 0x009B, name: "Vrc5476" },
		Device { id: 0x00A5, name: "VRC4173" },
		Device { id: 0x00A6, name: "VRC5477 AC97" },
		Device { id: 0x00CD, name: "uPD72870 [Firewarden] IEEE1394a OHCI 1.0 Link/3-port PHY Controller" },
		Device { id: 0x00CE, name: "uPD72871 [Firewarden] IEEE1394a OHCI 1.0 Link/1-port PHY Controller" },
		Device { id: 0x00DF, name: "Vr4131" },
		Device { id: 0x00E0, name: "uPD72010x USB 2.0 Controller" },
		Device { id: 0x00E7, name: "uPD72873 [Firewarden] IEEE1394a OHCI 1.1 Link/2-port PHY Controller" },
		Device { id: 0x00F2, name: "uPD72874 [Firewarden] IEEE1394a OHCI 1.1 Link/3-port PHY Controller" },
		Device { id: 0x00F3, name: "uPD6113x Multimedia Decoder/Processor [EMMA2]" },
		Device { id: 0x010C, name: "VR7701" },
		Device { id: 0x0125, name: "uPD720400 PCI Express - PCI/PCI-X Bridge" },
		Device { id: 0x013A, name: "Dual Tuner/MPEG Encoder" },
		Device { id: 0x0194, name: "uPD720200 USB 3.0 Host Controller" },
		Device { id: 0x01E7, name: "uPD72873 [Firewarden] IEEE1394a OHCI 1.1 Link/2-port PHY Controller" },
		Device { id: 0x01F2, name: "uPD72874 [Firewarden] IEEE1394a OHCI 1.1 Link/3-port PHY Controller" },
	] },
	Vendor { id: 0x1034, name: "Framatome Connectors USA Inc.", devices: &[
	] },
	Vendor { id: 0x1035, name: "Comp. & Comm. Research Lab", devices: &[
	] },
	Vendor { id: 0x1036, name: "Future Domain Corp.", devices: &[
		Device { id: 0x0000, name: "TMC-18C30 [36C70]" },
	] },
	Vendor { id: 0x1037, name: "Hitachi Micro Systems", devices: &[
	] },
	Vendor { id: 0x1038, name: "AMP, Inc", devices: &[
	] },
	Vendor { id: 0x1039, name: "Silicon Integrated Systems [SiS]", devices: &[
		Device { id: 0x0001, name: "AGP Port (virtual PCI-to-PCI bridge)" },
		Device { id: 0x0002, name: "AGP Port (virtual PCI-to-PCI bridge)" },
		Device { id: 0x0003, name: "AGP Port (virtual PCI-to-PCI bridge)" },
		Device { id: 0x0004, name: "PCI-to-PCI bridge" },
		Device { id: 0x0006, name: "85C501/2/3" },
		Device { id: 0x0008, name: "SiS85C503/5513 (LPC Bridge)" },
		Device { id: 0x0009, name: "5595 Power Management Controller" },
		Device { id: 0x000A, name: "PCI-to-PCI bridge" },
		Device { id: 0x0016, name: "SiS961/2/3 SMBus controller" },
		Device { id: 0x0018, name: "SiS85C503/5513 (LPC Bridge)" },
		Device { id: 0x0163, name: "163 802.11b/g Wireless LAN Adapter" },
		Device { id: 0x0180, name: "RAID bus controller 180 SATA/PATA  [SiS]" },
		Device { id: 0x0181, name: "SATA" },
		Device { id: 0x0182, name: "182 SATA/RAID Controller" },
		Device { id: 0x0186, name: "AHCI Controller (0106)" },
		Device { id: 0x0190, name: "190 Ethernet Adapter" },
		Device { id: 0x0191, name: "191 Gigabit Ethernet Adapter" },
		Device { id: 0x0200, name: "5597/5598/6326 VGA" },
		Device { id: 0x0204, name: "82C204" },
		Device { id: 0x0205, name: "SG86C205" },
		Device { id: 0x0300, name: "300/305 PCI/AGP VGA Display Adapter" },
		Device { id: 0x0310, name: "315H PCI/AGP VGA Display Adapter" },
		Device { id: 0x0315, name: "315 PCI/AGP VGA Display Adapter" },
		Device { id: 0x0325, name: "315PRO PCI/AGP VGA Display Adapter" },
		Device { id: 0x0330, name: "330 [Xabre] PCI/AGP VGA Display Adapter" },
		Device { id: 0x0406, name: "85C501/2" },
		Device { id: 0x0496, name: "85C496" },
		Device { id: 0x0530, name: "530 Host" },
		Device { id: 0x0540, name: "540 Host" },
		Device { id: 0x0550, name: "550 Host" },
		Device { id: 0x0597, name: "5513C" },
		Device { id: 0x0601, name: "85C601" },
		Device { id: 0x0620, name: "620 Host" },
		Device { id: 0x0630, name: "630 Host" },
		Device { id: 0x0633, name: "633 Host" },
		Device { id: 0x0635, name: "635 Host" },
		Device { id: 0x0645, name: "SiS645 Host & Memory & AGP Controller" },
		Device { id: 0x0646, name: "SiS645DX Host & Memory & AGP Controller" },
		Device { id: 0x0648, name: "645xx" },
		Device { id: 0x0649, name: "SiS649 Host" },
		Device { id: 0x0650, name: "650/M650 Host" },
		Device { id: 0x0651, name: "651 Host" },
		Device { id: 0x0655, name: "655 Host" },
		Device { id: 0x0660, name: "660 Host" },
		Device { id: 0x0661, name: "661FX/M661FX/M661MX Host" },
		Device { id: 0x0662, name: "662 Host" },
		Device { id: 0x0671, name: "671MX" },
		Device { id: 0x0730, name: "730 Host" },
		Device { id: 0x0733, name: "733 Host" },
		Device { id: 0x0735, name: "735 Host" },
		Device { id: 0x0740, name: "740 Host" },
		Device { id: 0x0741, name: "741/741GX/M741 Host" },
		Device { id: 0x0745, name: "745 Host" },
		Device { id: 0x0746, name: "746 Host" },
		Device { id: 0x0755, name: "755 Host" },
		Device { id: 0x0760, name: "760/M760 Host" },
		Device { id: 0x0761, name: "761/M761 Host" },
		Device { id: 0x0900, name: "SiS900 PCI Fast Ethernet" },
		Device { id: 0x0961, name: "SiS961 [MuTIOL Media IO]" },
		Device { id: 0x0962, name: "SiS962 [MuTIOL Media IO] LPC Controller" },
		Device { id: 0x0963, name: "SiS963 [MuTIOL Media IO] LPC Controller" },
		Device { id: 0x0964, name: "SiS964 [MuTIOL Media IO] LPC Controller" },
		Device { id: 0x0965, name: "SiS965 [MuTIOL Media IO]" },
		Device { id: 0x0966, name: "SiS966 [MuTIOL Media IO]" },
		Device { id: 0x0968, name: "SiS968 [MuTIOL Media IO]" },
		Device { id: 0x1180, name: "SATA Controller / IDE mode" },
		Device { id: 0x1182, name: "SATA Controller / RAID mode" },
		Device { id: 0x1183, name: "SATA Controller / IDE mode" },
		Device { id: 0x1184, name: "AHCI Controller / RAID mode" },
		Device { id: 0x1185, name: "AHCI IDE Controller (0106)" },
		Device { id: 0x3602, name: "83C602" },
		Device { id: 0x5107, name: "5107" },
		Device { id: 0x5300, name: "SiS540 PCI Display Adapter" },
		Device { id: 0x5315, name: "550 PCI/AGP VGA Display Adapter" },
		Device { id: 0x5401, name: "486 PCI Chipset" },
		Device { id: 0x5511, name: "5511/5512" },
		Device { id: 0x5513, name: "5513 IDE Controller" },
		Device { id: 0x5517, name: "5517" },
		Device { id: 0x5571, name: "5571" },
		Device { id: 0x5581, name: "5581 Pentium Chipset" },
		Device { id: 0x5582, name: "5582" },
		Device { id: 0x5591, name: "5591/5592 Host" },
		Device { id: 0x5596, name: "5596 Pentium Chipset" },
		Device { id: 0x5597, name: "5597 [SiS5582]" },
		Device { id: 0x5600, name: "5600 Host" },
		Device { id: 0x6204, name: "Video decoder & MPEG interface" },
		Device { id: 0x6205, name: "VGA Controller" },
		Device { id: 0x6236, name: "6236 3D-AGP" },
		Device { id: 0x6300, name: "630/730 PCI/AGP VGA Display Adapter" },
		Device { id: 0x6306, name: "530/620 PCI/AGP VGA Display Adapter" },
		Device { id: 0x6325, name: "65x/M650/740 PCI/AGP VGA Display Adapter" },
		Device { id: 0x6326, name: "86C326 5598/6326" },
		Device { id: 0x6330, name: "661/741/760 PCI/AGP or 662/761Gx PCIE VGA Display Adapter" },
		Device { id: 0x6350, name: "770/670 PCIE VGA Display Adapter" },
		Device { id: 0x6351, name: "771/671 PCIE VGA Display Adapter" },
		Device { id: 0x7001, name: "USB 1.1 Controller" },
		Device { id: 0x7002, name: "USB 2.0 Controller" },
		Device { id: 0x7007, name: "FireWire Controller" },
		Device { id: 0x7012, name: "SiS7012 AC'97 Sound Controller" },
		Device { id: 0x7013, name: "AC'97 Modem Controller" },
		Device { id: 0x7016, name: "SiS7016 PCI Fast Ethernet Adapter" },
		Device { id: 0x7018, name: "SiS PCI Audio Accelerator" },
		Device { id: 0x7019, name: "SiS7019 Audio Accelerator" },
		Device { id: 0x7502, name: "Azalia Audio Controller" },
	] },
	Vendor { id: 0x103A, name: "Seiko Epson Corporation", devices: &[
	] },
	Vendor { id: 0x103B, name: "Tatung Corp. Of America", devices: &[
	] },
	Vendor { id: 0x103C, name: "Hewlett-Packard Company", devices: &[
		Device { id: 0x1005, name: "A4977A Visualize EG" },
		Device { id: 0x1008, name: "Visualize FX" },
		Device { id: 0x1028, name: "Tach TL Fibre Channel Host Adapter" },
		Device { id: 0x1029, name: "Tach XL2 Fibre Channel Host Adapter" },
		Device { id: 0x102A, name: "Tach TS Fibre Channel Host Adapter" },
		Device { id: 0x1030, name: "J2585A DeskDirect 10/100VG NIC" },
		Device { id: 0x1031, name: "J2585B HP 10/100VG PCI LAN Adapter" },
		Device { id: 0x1040, name: "J2973A DeskDirect 10BaseT NIC" },
		Device { id: 0x1041, name: "J2585B DeskDirect 10/100 NIC" },
		Device { id: 0x1042, name: "J2970A DeskDirect 10BaseT/2 NIC" },
		Device { id: 0x1048, name: "Diva Serial [GSP] Multiport UART" },
		Device { id: 0x1054, name: "PCI Local Bus Adapter" },
		Device { id: 0x1064, name: "79C970 PCnet Ethernet Controller" },
		Device { id: 0x108B, name: "Visualize FXe" },
		Device { id: 0x10C1, name: "NetServer Smart IRQ Router" },
		Device { id: 0x10ED, name: "TopTools Remote Control" },
		Device { id: 0x10F0, name: "rio System Bus Adapter" },
		Device { id: 0x10F1, name: "rio I/O Controller" },
		Device { id: 0x1219, name: "NetServer PCI Hot-Plug Controller" },
		Device { id: 0x121A, name: "NetServer SMIC Controller" },
		Device { id: 0x121B, name: "NetServer Legacy COM Port Decoder" },
		Device { id: 0x121C, name: "NetServer PCI COM Port Decoder" },
		Device { id: 0x1229, name: "zx1 System Bus Adapter" },
		Device { id: 0x122A, name: "zx1 I/O Controller" },
		Device { id: 0x122E, name: "PCI-X Local Bus Adapter" },
		Device { id: 0x127B, name: "sx1000 System Bus Adapter" },
		Device { id: 0x127C, name: "sx1000 I/O Controller" },
		Device { id: 0x1290, name: "Auxiliary Diva Serial Port" },
		Device { id: 0x1291, name: "Auxiliary Diva Serial Port" },
		Device { id: 0x12B4, name: "zx1 QuickSilver AGP8x Local Bus Adapter" },
		Device { id: 0x12EB, name: "sx2000 System Bus Adapter" },
		Device { id: 0x12EC, name: "sx2000 I/O Controller" },
		Device { id: 0x12EE, name: "PCI-X 2.0 Local Bus Adapter" },
		Device { id: 0x1302, name: "RMP-3 Shared Memory Driver" },
		Device { id: 0x1303, name: "RMP-3 (Remote Management Processor)" },
		Device { id: 0x22F6, name: "iLO5 Virtual USB Controller" },
		Device { id: 0x2910, name: "E2910A PCIBus Exerciser" },
		Device { id: 0x2925, name: "E2925A 32 Bit, 33 MHzPCI Exerciser & Analyzer" },
		Device { id: 0x3206, name: "Adaptec Embedded Serial ATA HostRAID" },
		Device { id: 0x3220, name: "Smart Array P600" },
		Device { id: 0x3230, name: "Smart Array Controller" },
		Device { id: 0x3238, name: "Smart Array E200i (SAS Controller)" },
		Device { id: 0x3239, name: "Smart Array Gen9 Controllers" },
		Device { id: 0x323A, name: "Smart Array G6 controllers" },
		Device { id: 0x323B, name: "Smart Array Gen8 Controllers" },
		Device { id: 0x323C, name: "Smart Array Gen8+ Controllers" },
		Device { id: 0x3300, name: "Integrated Lights-Out Standard Virtual USB Controller" },
		Device { id: 0x3301, name: "Integrated Lights-Out Standard Serial Port" },
		Device { id: 0x3302, name: "Integrated Lights-Out Standard KCS Interface" },
		Device { id: 0x3305, name: "Integrated Lights-Out (iLO2) Controller" },
		Device { id: 0x3306, name: "Integrated Lights-Out Standard Slave Instrumentation & System Support" },
		Device { id: 0x3307, name: "Integrated Lights-Out Standard Management Processor Support and Messaging" },
		Device { id: 0x3308, name: "Integrated Lights-Out Standard MS Watchdog Timer" },
		Device { id: 0x4030, name: "zx2 System Bus Adapter" },
		Device { id: 0x4031, name: "zx2 I/O Controller" },
		Device { id: 0x4037, name: "PCIe Local Bus Adapter" },
	] },
	Vendor { id: 0x103E, name: "Solliday Engineering", devices: &[
	] },
	Vendor { id: 0x103F, name: "Synopsys/Logic Modeling Group", devices: &[
	] },
	Vendor { id: 0x1040, name: "Accelgraphics Inc.", devices: &[
	] },
	Vendor { id: 0x1041, name: "Computrend", devices: &[
	] },
	Vendor { id: 0x1042, name: "Micron", devices: &[
		Device { id: 0x1000, name: "PC Tech RZ1000" },
		Device { id: 0x1001, name: "PC Tech RZ1001" },
		Device { id: 0x3000, name: "Samurai_0" },
		Device { id: 0x3010, name: "Samurai_1" },
		Device { id: 0x3020, name: "Samurai_IDE" },
	] },
	Vendor { id: 0x1043, name: "ASUSTeK Computer Inc.", devices: &[
		Device { id: 0x0464, name: "Radeon R9 270x GPU" },
		Device { id: 0x0521, name: "RX580 [RX 580 Dual O8G]" },
		Device { id: 0x0675, name: "ISDNLink P-IN100-ST-D" },
		Device { id: 0x9602, name: "AMD RS780/RS880 PCI to PCI bridge (int gfx)" },
	] },
	Vendor { id: 0x1044, name: "Adaptec (formerly DPT)", devices: &[
		Device { id: 0x1012, name: "Domino RAID Engine" },
		Device { id: 0xA400, name: "SmartCache/Raid I-IV Controller" },
		Device { id: 0xA500, name: "PCI Bridge" },
		Device { id: 0xA501, name: "SmartRAID V Controller" },
		Device { id: 0xA511, name: "SmartRAID V Controller" },
		Device { id: 0xC066, name: "3010S Ultra3 Dual Channel" },
	] },
	Vendor { id: 0x1045, name: "OPTi Inc.", devices: &[
		Device { id: 0xA0F8, name: "82C750 [Vendetta] USB Controller" },
		Device { id: 0xC101, name: "92C264" },
		Device { id: 0xC178, name: "92C178" },
		Device { id: 0xC556, name: "82X556 [Viper]" },
		Device { id: 0xC557, name: "82C557 [Viper-M]" },
		Device { id: 0xC558, name: "82C558 [Viper-M ISA+IDE]" },
		Device { id: 0xC567, name: "82C750 [Vendetta], device 0" },
		Device { id: 0xC568, name: "82C750 [Vendetta], device 1" },
		Device { id: 0xC569, name: "82C579 [Viper XPress+ Chipset]" },
		Device { id: 0xC621, name: "82C621 [Viper-M/N+]" },
		Device { id: 0xC700, name: "82C700 [FireStar]" },
		Device { id: 0xC701, name: "82C701 [FireStar Plus]" },
		Device { id: 0xC814, name: "82C814 [Firebridge 1]" },
		Device { id: 0xC822, name: "82C822" },
		Device { id: 0xC824, name: "82C824" },
		Device { id: 0xC825, name: "82C825 [Firebridge 2]" },
		Device { id: 0xC832, name: "82C832" },
		Device { id: 0xC861, name: "82C861" },
		Device { id: 0xC881, name: "82C881 [FireLink] 1394 OHCI Link Controller" },
		Device { id: 0xC895, name: "82C895" },
		Device { id: 0xC935, name: "EV1935 ECTIVA MachOne PCIAudio" },
		Device { id: 0xD568, name: "82C825 [Firebridge 2]" },
		Device { id: 0xD721, name: "IDE [FireStar]" },
	] },
	Vendor { id: 0x1046, name: "IPC Corporation, Ltd.", devices: &[
	] },
	Vendor { id: 0x1047, name: "Genoa Systems Corp", devices: &[
	] },
	Vendor { id: 0x1048, name: "Elsa AG", devices: &[
		Device { id: 0x0C60, name: "Gladiac MX" },
		Device { id: 0x0D22, name: "Quadro4 900XGL [ELSA GLoria4 900XGL]" },
		Device { id: 0x1000, name: "QuickStep 1000" },
		Device { id: 0x3000, name: "QuickStep 3000" },
		Device { id: 0x8901, name: "Gloria XL" },
	] },
	Vendor { id: 0x1049, name: "Fountain Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x104A, name: "STMicroelectronics", devices: &[
		Device { id: 0x0000, name: "STLS2F Host Bridge" },
		Device { id: 0x0008, name: "STG 2000X" },
		Device { id: 0x0009, name: "STG 1764X" },
		Device { id: 0x0010, name: "STG4000 [3D Prophet Kyro Series]" },
		Device { id: 0x0201, name: "STPC Vega Northbridge" },
		Device { id: 0x0209, name: "STPC Consumer/Industrial North- and Southbridge" },
		Device { id: 0x020A, name: "STPC Atlas/ConsumerS/Consumer IIA Northbridge" },
		Device { id: 0x020B, name: "STPC Consumer II ISA Bridge" },
		Device { id: 0x0210, name: "STPC Atlas ISA Bridge" },
		Device { id: 0x021A, name: "STPC Consumer S Southbridge" },
		Device { id: 0x021B, name: "STPC Consumer IIA Southbridge" },
		Device { id: 0x0220, name: "STPC Industrial PCI to PCCard bridge" },
		Device { id: 0x0228, name: "STPC Atlas IDE" },
		Device { id: 0x0229, name: "STPC Vega IDE" },
		Device { id: 0x0230, name: "STPC Atlas/Vega OHCI USB Controller" },
		Device { id: 0x0238, name: "STPC Vega LAN" },
		Device { id: 0x0500, name: "ST70137 [Unicorn] ADSL DMT Transceiver" },
		Device { id: 0x0564, name: "STPC Client Northbridge" },
		Device { id: 0x0981, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
		Device { id: 0x1746, name: "STG 1764X" },
		Device { id: 0x2774, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
		Device { id: 0x3520, name: "MPEG-II decoder card" },
		Device { id: 0x55CC, name: "STPC Client Southbridge" },
	] },
	Vendor { id: 0x104B, name: "BusLogic", devices: &[
		Device { id: 0x0140, name: "BT-946C (old) [multimaster  01]" },
		Device { id: 0x1040, name: "BT-946C (BA80C30) [MultiMaster 10]" },
		Device { id: 0x8130, name: "Flashpoint LT" },
	] },
	Vendor { id: 0x104C, name: "Texas Instruments", devices: &[
		Device { id: 0x0500, name: "100 MBit LAN Controller" },
		Device { id: 0x0508, name: "TMS380C2X Compressor Interface" },
		Device { id: 0x1000, name: "Eagle i/f AS" },
		Device { id: 0x104C, name: "PCI1510 PC card Cardbus Controller" },
		Device { id: 0x3D04, name: "TVP4010 [Permedia]" },
		Device { id: 0x3D07, name: "TVP4020 [Permedia 2]" },
		Device { id: 0x8000, name: "PCILynx/PCILynx2 IEEE 1394 Link Layer Controller" },
		Device { id: 0x8009, name: "TSB12LV22 IEEE-1394 Controller" },
		Device { id: 0x8017, name: "PCI4410 FireWire Controller" },
		Device { id: 0x8019, name: "TSB12LV23 IEEE-1394 Controller" },
		Device { id: 0x8020, name: "TSB12LV26 IEEE-1394 Controller (Link)" },
		Device { id: 0x8021, name: "TSB43AA22 IEEE-1394 Controller (PHY/Link Integrated)" },
		Device { id: 0x8022, name: "TSB43AB22 IEEE-1394a-2000 Controller (PHY/Link) [iOHCI-Lynx]" },
		Device { id: 0x8023, name: "TSB43AB22A IEEE-1394a-2000 Controller (PHY/Link) [iOHCI-Lynx]" },
		Device { id: 0x8024, name: "TSB43AB23 IEEE-1394a-2000 Controller (PHY/Link)" },
		Device { id: 0x8025, name: "TSB82AA2 IEEE-1394b Link Layer Controller" },
		Device { id: 0x8026, name: "TSB43AB21 IEEE-1394a-2000 Controller (PHY/Link)" },
		Device { id: 0x8027, name: "PCI4451 IEEE-1394 Controller" },
		Device { id: 0x8029, name: "PCI4510 IEEE-1394 Controller" },
		Device { id: 0x802B, name: "PCI7410,7510,7610 OHCI-Lynx Controller" },
		Device { id: 0x802E, name: "PCI7x20 1394a-2000 OHCI Two-Port PHY/Link-Layer Controller" },
		Device { id: 0x8031, name: "PCIxx21/x515 Cardbus Controller" },
		Device { id: 0x8032, name: "OHCI Compliant IEEE 1394 Host Controller" },
		Device { id: 0x8033, name: "PCIxx21 Integrated FlashMedia Controller" },
		Device { id: 0x8034, name: "PCI6411/6421/6611/6621/7411/7421/7611/7621 Secure Digital Controller" },
		Device { id: 0x8035, name: "PCI6411/6421/6611/6621/7411/7421/7611/7621 Smart Card Controller" },
		Device { id: 0x8036, name: "PCI6515 Cardbus Controller" },
		Device { id: 0x8038, name: "PCI6515 SmartCard Controller" },
		Device { id: 0x8039, name: "PCIxx12 Cardbus Controller" },
		Device { id: 0x803A, name: "PCIxx12 OHCI Compliant IEEE 1394 Host Controller" },
		Device { id: 0x803B, name: "5-in-1 Multimedia Card Reader (SD/MMC/MS/MS PRO/xD)" },
		Device { id: 0x803C, name: "PCIxx12 SDA Standard Compliant SD Host Controller" },
		Device { id: 0x803D, name: "PCIxx12 GemCore based SmartCard controller" },
		Device { id: 0x8101, name: "TSB43DB42 IEEE-1394a-2000 Controller (PHY/Link)" },
		Device { id: 0x8201, name: "PCI1620 Firmware Loading Function" },
		Device { id: 0x8204, name: "PCI7410/7510/7610 PCI Firmware Loading Function" },
		Device { id: 0x8231, name: "XIO2000(A)/XIO2200A PCI Express-to-PCI Bridge" },
		Device { id: 0x8232, name: "XIO3130 PCI Express Switch (Upstream)" },
		Device { id: 0x8233, name: "XIO3130 PCI Express Switch (Downstream)" },
		Device { id: 0x8235, name: "XIO2200A IEEE-1394a-2000 Controller (PHY/Link)" },
		Device { id: 0x823E, name: "XIO2213A/B/XIO2221 PCI Express to PCI Bridge [Cheetah Express]" },
		Device { id: 0x823F, name: "XIO2213A/B/XIO2221 IEEE-1394b OHCI Controller [Cheetah Express]" },
		Device { id: 0x8240, name: "XIO2001 PCI Express-to-PCI Bridge" },
		Device { id: 0x8241, name: "TUSB73x0 SuperSpeed USB 3.0 xHCI Host Controller" },
		Device { id: 0x8400, name: "ACX 100 22Mbps Wireless Interface" },
		Device { id: 0x8401, name: "ACX 100 22Mbps Wireless Interface" },
		Device { id: 0x8888, name: "Multicore DSP+ARM KeyStone II SOC" },
		Device { id: 0x9000, name: "Wireless Interface (of unknown type)" },
		Device { id: 0x9065, name: "TMS320DM642" },
		Device { id: 0x9066, name: "ACX 111 54Mbps Wireless Interface" },
		Device { id: 0xA001, name: "TDC1570" },
		Device { id: 0xA100, name: "TDC1561" },
		Device { id: 0xA102, name: "TNETA1575 HyperSAR Plus w/PCI Host i/f & UTOPIA i/f" },
		Device { id: 0xA106, name: "TMS320C6414 TMS320C6415 TMS320C6416" },
		Device { id: 0xAC10, name: "PCI1050" },
		Device { id: 0xAC11, name: "PCI1053" },
		Device { id: 0xAC12, name: "PCI1130" },
		Device { id: 0xAC13, name: "PCI1031" },
		Device { id: 0xAC15, name: "PCI1131" },
		Device { id: 0xAC16, name: "PCI1250" },
		Device { id: 0xAC17, name: "PCI1220" },
		Device { id: 0xAC18, name: "PCI1260" },
		Device { id: 0xAC19, name: "PCI1221" },
		Device { id: 0xAC1A, name: "PCI1210" },
		Device { id: 0xAC1B, name: "PCI1450" },
		Device { id: 0xAC1C, name: "PCI1225" },
		Device { id: 0xAC1D, name: "PCI1251A" },
		Device { id: 0xAC1E, name: "PCI1211" },
		Device { id: 0xAC1F, name: "PCI1251B" },
		Device { id: 0xAC20, name: "TI 2030" },
		Device { id: 0xAC21, name: "PCI2031" },
		Device { id: 0xAC22, name: "PCI2032 PCI Docking Bridge" },
		Device { id: 0xAC23, name: "PCI2250 PCI-to-PCI Bridge" },
		Device { id: 0xAC28, name: "PCI2050 PCI-to-PCI Bridge" },
		Device { id: 0xAC2C, name: "PCI2060 PCI-to-PCI Bridge" },
		Device { id: 0xAC30, name: "PCI1260 PC card Cardbus Controller" },
		Device { id: 0xAC40, name: "PCI4450 PC card Cardbus Controller" },
		Device { id: 0xAC41, name: "PCI4410 PC card Cardbus Controller" },
		Device { id: 0xAC42, name: "PCI4451 PC card Cardbus Controller" },
		Device { id: 0xAC44, name: "PCI4510 PC card Cardbus Controller" },
		Device { id: 0xAC46, name: "PCI4520 PC card Cardbus Controller" },
		Device { id: 0xAC47, name: "PCI7510 PC card Cardbus Controller" },
		Device { id: 0xAC48, name: "PCI7610 PC Card Cardbus Controller" },
		Device { id: 0xAC49, name: "PCI7410 PC Card Cardbus Controller" },
		Device { id: 0xAC4A, name: "PCI7510/7610 CardBus Bridge" },
		Device { id: 0xAC4B, name: "PCI7610 SD/MMC controller" },
		Device { id: 0xAC4C, name: "PCI7610 Memory Stick controller" },
		Device { id: 0xAC50, name: "PCI1410 PC card Cardbus Controller" },
		Device { id: 0xAC51, name: "PCI1420 PC card Cardbus Controller" },
		Device { id: 0xAC52, name: "PCI1451 PC card Cardbus Controller" },
		Device { id: 0xAC53, name: "PCI1421 PC card Cardbus Controller" },
		Device { id: 0xAC54, name: "PCI1620 PC Card Controller" },
		Device { id: 0xAC55, name: "PCI1520 PC card Cardbus Controller" },
		Device { id: 0xAC56, name: "PCI1510 PC card Cardbus Controller" },
		Device { id: 0xAC60, name: "PCI2040 PCI to DSP Bridge Controller" },
		Device { id: 0xAC8D, name: "PCI 7620" },
		Device { id: 0xAC8E, name: "PCI7420 CardBus Controller" },
		Device { id: 0xAC8F, name: "PCI7420/7620 SD/MS-Pro Controller" },
		Device { id: 0xB001, name: "TMS320C6424" },
		Device { id: 0xFE00, name: "FireWire Host Controller" },
		Device { id: 0xFE03, name: "12C01A FireWire Host Controller" },
	] },
	Vendor { id: 0x104D, name: "Sony Corporation", devices: &[
		Device { id: 0x8004, name: "DTL-H2500 [Playstation development board]" },
		Device { id: 0x8009, name: "CXD1947Q i.LINK Controller" },
		Device { id: 0x8039, name: "CXD3222 i.LINK Controller" },
		Device { id: 0x8056, name: "Rockwell HCF 56K modem" },
		Device { id: 0x808A, name: "Memory Stick Controller" },
		Device { id: 0x81CE, name: "SxS Pro memory card" },
		Device { id: 0x905C, name: "SxS Pro memory card" },
		Device { id: 0x907F, name: "SxS Pro+ memory card" },
		Device { id: 0x908F, name: "Aeolia ACPI" },
		Device { id: 0x909E, name: "Aeolia Ethernet Controller (Marvell Yukon 2 Family)" },
		Device { id: 0x909F, name: "Aeolia SATA AHCI Controller" },
		Device { id: 0x90A0, name: "Aeolia SD/MMC Host Controller" },
		Device { id: 0x90A1, name: "Aeolia PCI Express Glue and Miscellaneous Devices" },
		Device { id: 0x90A2, name: "Aeolia DMA Controller" },
		Device { id: 0x90A3, name: "Aeolia Memory (DDR3/SPM)" },
		Device { id: 0x90A4, name: "Aeolia USB 3.0 xHCI Host Controller" },
		Device { id: 0x90BC, name: "SxS Pro+ memory card" },
	] },
	Vendor { id: 0x104E, name: "Oak Technology, Inc", devices: &[
		Device { id: 0x0017, name: "OTI-64017" },
		Device { id: 0x0107, name: "OTI-107 [Spitfire]" },
		Device { id: 0x0109, name: "Video Adapter" },
		Device { id: 0x0111, name: "OTI-64111 [Spitfire]" },
		Device { id: 0x0217, name: "OTI-64217" },
		Device { id: 0x0317, name: "OTI-64317" },
	] },
	Vendor { id: 0x104F, name: "Co-time Computer Ltd", devices: &[
	] },
	Vendor { id: 0x1050, name: "Winbond Electronics Corp", devices: &[
		Device { id: 0x0000, name: "NE2000" },
		Device { id: 0x0001, name: "W83769F" },
		Device { id: 0x0033, name: "W89C33D 802.11 a/b/g BB/MAC" },
		Device { id: 0x0105, name: "W82C105" },
		Device { id: 0x0840, name: "W89C840" },
		Device { id: 0x0940, name: "W89C940" },
		Device { id: 0x5A5A, name: "W89C940F" },
		Device { id: 0x6692, name: "W6692" },
		Device { id: 0x9921, name: "W99200F MPEG-1 Video Encoder" },
		Device { id: 0x9922, name: "W99200F/W9922PF MPEG-1/2 Video Encoder" },
		Device { id: 0x9970, name: "W9970CF" },
	] },
	Vendor { id: 0x1051, name: "Anigma, Inc.", devices: &[
	] },
	Vendor { id: 0x1052, name: "?Young Micro Systems", devices: &[
	] },
	Vendor { id: 0x1053, name: "Young Micro Systems", devices: &[
	] },
	Vendor { id: 0x1054, name: "Hitachi, Ltd", devices: &[
		Device { id: 0x3009, name: "2Gbps Fibre Channel to PCI HBA 3009" },
		Device { id: 0x300A, name: "4Gbps Fibre Channel to PCI-X HBA 300a" },
		Device { id: 0x300B, name: "4Gbps Fibre Channel to PCI-X HBA 300b" },
		Device { id: 0x300F, name: "ColdFusion 3 Chipset Processor to I/O Controller" },
		Device { id: 0x3010, name: "ColdFusion 3 Chipset Memory Controller Hub" },
		Device { id: 0x3011, name: "ColdFusion 3e Chipset Processor to I/O Controller" },
		Device { id: 0x3012, name: "ColdFusion 3e Chipset Memory Controller Hub" },
		Device { id: 0x3017, name: "Unassigned Hitachi Shared FC Device 3017" },
		Device { id: 0x301B, name: "Virtual VGA Device" },
		Device { id: 0x301D, name: "PCIe-to-PCIe Bridge with Virtualization IO Assist Feature" },
		Device { id: 0x3020, name: "FIVE-EX based Fibre Channel to PCIe HBA" },
		Device { id: 0x302C, name: "M001 PCI Express Switch Upstream Port" },
		Device { id: 0x302D, name: "M001 PCI Express Switch Downstream Port" },
		Device { id: 0x3070, name: "Hitachi FIVE-FX Fibre Channel to PCIe HBA" },
		Device { id: 0x3505, name: "SH7751 PCI Controller (PCIC)" },
		Device { id: 0x350E, name: "SH7751R PCI Controller (PCIC)" },
	] },
	Vendor { id: 0x1055, name: "Efar Microsystems", devices: &[
		Device { id: 0x9130, name: "SLC90E66 [Victory66] IDE" },
		Device { id: 0x9460, name: "SLC90E66 [Victory66] ISA" },
		Device { id: 0x9462, name: "SLC90E66 [Victory66] USB" },
		Device { id: 0x9463, name: "SLC90E66 [Victory66] ACPI" },
		Device { id: 0xE420, name: "LAN9420/LAN9420i" },
	] },
	Vendor { id: 0x1056, name: "ICL", devices: &[
	] },
	Vendor { id: 0x1057, name: "Motorola", devices: &[
		Device { id: 0x0001, name: "MPC105 [Eagle]" },
		Device { id: 0x0002, name: "MPC106 [Grackle]" },
		Device { id: 0x0003, name: "MPC8240 [Kahlua]" },
		Device { id: 0x0004, name: "MPC107" },
		Device { id: 0x0006, name: "MPC8245 [Unity]" },
		Device { id: 0x0008, name: "MPC8540" },
		Device { id: 0x0009, name: "MPC8560" },
		Device { id: 0x0012, name: "MPC8548 [PowerQUICC III]" },
		Device { id: 0x0100, name: "MC145575 [HFC-PCI]" },
		Device { id: 0x0431, name: "KTI829c 100VG" },
		Device { id: 0x1073, name: "Nokia N770" },
		Device { id: 0x1219, name: "Nokia N800" },
		Device { id: 0x1801, name: "DSP56301 Digital Signal Processor" },
		Device { id: 0x18C0, name: "MPC8265A/8266/8272" },
		Device { id: 0x18C1, name: "MPC8271/MPC8272" },
		Device { id: 0x3052, name: "SM56 Data Fax Modem" },
		Device { id: 0x3410, name: "DSP56361 Digital Signal Processor" },
		Device { id: 0x4801, name: "Raven" },
		Device { id: 0x4802, name: "Falcon" },
		Device { id: 0x4803, name: "Hawk" },
		Device { id: 0x4806, name: "CPX8216" },
		Device { id: 0x4D68, name: "20268" },
		Device { id: 0x5600, name: "SM56 PCI Modem" },
		Device { id: 0x5608, name: "Wildcard X100P" },
		Device { id: 0x5803, name: "MPC5200" },
		Device { id: 0x5806, name: "MCF54 Coldfire" },
		Device { id: 0x5808, name: "MPC8220" },
		Device { id: 0x5809, name: "MPC5200B" },
		Device { id: 0x6400, name: "MPC190 Security Processor (S1 family, encryption)" },
		Device { id: 0x6405, name: "MPC184 Security Processor (S1 family)" },
	] },
	Vendor { id: 0x1058, name: "Electronics & Telecommunications RSH", devices: &[
	] },
	Vendor { id: 0x1059, name: "Kontron", devices: &[
	] },
	Vendor { id: 0x105A, name: "Promise Technology, Inc.", devices: &[
		Device { id: 0x0D30, name: "PDC20265 (FastTrak100 Lite/Ultra100)" },
		Device { id: 0x0D38, name: "20263" },
		Device { id: 0x1275, name: "20275" },
		Device { id: 0x3318, name: "PDC20318 (SATA150 TX4)" },
		Device { id: 0x3319, name: "PDC20319 (FastTrak S150 TX4)" },
		Device { id: 0x3371, name: "PDC20371 (FastTrak S150 TX2plus)" },
		Device { id: 0x3373, name: "PDC20378 (FastTrak 378/SATA 378)" },
		Device { id: 0x3375, name: "PDC20375 (SATA150 TX2plus)" },
		Device { id: 0x3376, name: "PDC20376 (FastTrak 376)" },
		Device { id: 0x3515, name: "PDC40719 [FastTrak TX4300/TX4310]" },
		Device { id: 0x3519, name: "PDC40519 (FastTrak TX4200)" },
		Device { id: 0x3570, name: "PDC20771 [FastTrak TX2300]" },
		Device { id: 0x3571, name: "PDC20571 (FastTrak TX2200)" },
		Device { id: 0x3574, name: "PDC20579 SATAII 150 IDE Controller" },
		Device { id: 0x3577, name: "PDC40779 (SATA 300 779)" },
		Device { id: 0x3D17, name: "PDC40718 (SATA 300 TX4)" },
		Device { id: 0x3D18, name: "PDC20518/PDC40518 (SATAII 150 TX4)" },
		Device { id: 0x3D73, name: "PDC40775 (SATA 300 TX2plus)" },
		Device { id: 0x3D75, name: "PDC20575 (SATAII150 TX2plus)" },
		Device { id: 0x3F20, name: "PDC42819 [FastTrak TX2650/TX4650]" },
		Device { id: 0x4302, name: "80333 [SuperTrak EX4350]" },
		Device { id: 0x4D30, name: "PDC20267 (FastTrak100/Ultra100)" },
		Device { id: 0x4D33, name: "20246" },
		Device { id: 0x4D38, name: "PDC20262 (FastTrak66/Ultra66)" },
		Device { id: 0x4D68, name: "PDC20268 [Ultra100 TX2]" },
		Device { id: 0x4D69, name: "20269" },
		Device { id: 0x5275, name: "PDC20276 (MBFastTrak133 Lite)" },
		Device { id: 0x5300, name: "DC5300" },
		Device { id: 0x6268, name: "PDC20270 (FastTrak100 LP/TX2/TX4)" },
		Device { id: 0x6269, name: "PDC20271 (FastTrak TX2000)" },
		Device { id: 0x6300, name: "PDC81731 [FastTrak SX8300]" },
		Device { id: 0x6621, name: "PDC20621 (FastTrak S150 SX4/FastTrak SX4000 lite)" },
		Device { id: 0x6622, name: "PDC20621 [SATA150 SX4] 4 Channel IDE RAID Controller" },
		Device { id: 0x6624, name: "PDC20621 [FastTrak SX4100]" },
		Device { id: 0x6626, name: "PDC20618 (Ultra 618)" },
		Device { id: 0x6629, name: "PDC20619 (FastTrak TX4000)" },
		Device { id: 0x7275, name: "PDC20277 (SBFastTrak133 Lite)" },
		Device { id: 0x8002, name: "SATAII150 SX8" },
		Device { id: 0x8350, name: "80333 [SuperTrak EX8350/EX16350], 80331 [SuperTrak EX8300/EX16300]" },
		Device { id: 0x8650, name: "81384 [SuperTrak EX SAS and SATA RAID Controller]" },
		Device { id: 0x8760, name: "PM8010 [SuperTrak EX SAS and SATA 6G RAID Controller]" },
		Device { id: 0xC350, name: "80333 [SuperTrak EX12350]" },
		Device { id: 0xE350, name: "80333 [SuperTrak EX24350]" },
	] },
	Vendor { id: 0x105B, name: "Foxconn International, Inc.", devices: &[
	] },
	Vendor { id: 0x105C, name: "Wipro Infotech Limited", devices: &[
	] },
	Vendor { id: 0x105D, name: "Number 9 Computer Company", devices: &[
		Device { id: 0x2309, name: "Imagine 128" },
		Device { id: 0x2339, name: "Imagine 128-II" },
		Device { id: 0x493D, name: "Imagine 128 T2R [Ticket to Ride]" },
		Device { id: 0x5348, name: "Revolution 4" },
	] },
	Vendor { id: 0x105E, name: "Vtech Computers Ltd", devices: &[
	] },
	Vendor { id: 0x105F, name: "Infotronic America Inc", devices: &[
	] },
	Vendor { id: 0x1060, name: "United Microelectronics [UMC]", devices: &[
		Device { id: 0x0001, name: "UM82C881" },
		Device { id: 0x0002, name: "UM82C886" },
		Device { id: 0x0101, name: "UM8673F" },
		Device { id: 0x0881, name: "UM8881" },
		Device { id: 0x0886, name: "UM8886F" },
		Device { id: 0x0891, name: "UM8891A" },
		Device { id: 0x1001, name: "UM886A" },
		Device { id: 0x673A, name: "UM8886BF" },
		Device { id: 0x673B, name: "EIDE Master/DMA" },
		Device { id: 0x8710, name: "UM8710" },
		Device { id: 0x886A, name: "UM8886A" },
		Device { id: 0x8881, name: "UM8881F" },
		Device { id: 0x8886, name: "UM8886F" },
		Device { id: 0x888A, name: "UM8886A" },
		Device { id: 0x8891, name: "UM8891A" },
		Device { id: 0x9017, name: "UM9017F" },
		Device { id: 0x9018, name: "UM9018" },
		Device { id: 0x9026, name: "UM9026" },
		Device { id: 0xE881, name: "UM8881N" },
		Device { id: 0xE886, name: "UM8886N" },
		Device { id: 0xE88A, name: "UM8886N" },
		Device { id: 0xE891, name: "UM8891N" },
	] },
	Vendor { id: 0x1061, name: "I.I.T.", devices: &[
		Device { id: 0x0001, name: "AGX016" },
		Device { id: 0x0002, name: "IIT3204/3501" },
	] },
	Vendor { id: 0x1062, name: "Maspar Computer Corp", devices: &[
	] },
	Vendor { id: 0x1063, name: "Ocean Office Automation", devices: &[
	] },
	Vendor { id: 0x1064, name: "Alcatel", devices: &[
		Device { id: 0x1102, name: "Dynamite 2840 (ADSL PCI modem)" },
	] },
	Vendor { id: 0x1065, name: "Texas Microsystems", devices: &[
	] },
	Vendor { id: 0x1066, name: "PicoPower Technology", devices: &[
		Device { id: 0x0000, name: "PT80C826" },
		Device { id: 0x0001, name: "PT86C521 [Vesuvius v1] Host Bridge" },
		Device { id: 0x0002, name: "PT86C523 [Vesuvius v3] PCI-ISA Bridge Master" },
		Device { id: 0x0003, name: "PT86C524 [Nile] PCI-to-PCI Bridge" },
		Device { id: 0x0004, name: "PT86C525 [Nile-II] PCI-to-PCI Bridge" },
		Device { id: 0x0005, name: "National PC87550 System Controller" },
		Device { id: 0x8002, name: "PT86C523 [Vesuvius v3] PCI-ISA Bridge Slave" },
	] },
	Vendor { id: 0x1067, name: "Mitsubishi Electric", devices: &[
		Device { id: 0x0301, name: "AccelGraphics AccelECLIPSE" },
		Device { id: 0x0304, name: "AccelGALAXY A2100 [OEM Evans & Sutherland]" },
		Device { id: 0x0308, name: "Tornado 3000 [OEM Evans & Sutherland]" },
		Device { id: 0x1002, name: "VG500 [VolumePro Volume Rendering Accelerator]" },
	] },
	Vendor { id: 0x1068, name: "Diversified Technology", devices: &[
	] },
	Vendor { id: 0x1069, name: "Mylex Corporation", devices: &[
		Device { id: 0x0001, name: "DAC960P" },
		Device { id: 0x0002, name: "DAC960PD" },
		Device { id: 0x0010, name: "DAC960PG" },
		Device { id: 0x0020, name: "DAC960LA" },
		Device { id: 0x0050, name: "AcceleRAID 352/170/160 support Device" },
		Device { id: 0xB166, name: "AcceleRAID 600/500/400/Sapphire support Device" },
		Device { id: 0xBA55, name: "eXtremeRAID 1100 support Device" },
		Device { id: 0xBA56, name: "eXtremeRAID 2000/3000 support Device" },
		Device { id: 0xBA57, name: "eXtremeRAID 4000/5000 support Device" },
	] },
	Vendor { id: 0x106A, name: "Aten Research Inc", devices: &[
	] },
	Vendor { id: 0x106B, name: "Apple Inc.", devices: &[
		Device { id: 0x0001, name: "Bandit PowerPC host bridge" },
		Device { id: 0x0002, name: "Grand Central I/O" },
		Device { id: 0x0003, name: "Control Video" },
		Device { id: 0x0004, name: "PlanB Video-In" },
		Device { id: 0x0007, name: "O'Hare I/O" },
		Device { id: 0x000C, name: "DOS on Mac" },
		Device { id: 0x000E, name: "Hydra Mac I/O" },
		Device { id: 0x0010, name: "Heathrow Mac I/O" },
		Device { id: 0x0017, name: "Paddington Mac I/O" },
		Device { id: 0x0018, name: "UniNorth FireWire" },
		Device { id: 0x0019, name: "KeyLargo USB" },
		Device { id: 0x001E, name: "UniNorth Internal PCI" },
		Device { id: 0x001F, name: "UniNorth PCI" },
		Device { id: 0x0020, name: "UniNorth AGP" },
		Device { id: 0x0021, name: "UniNorth GMAC (Sun GEM)" },
		Device { id: 0x0022, name: "KeyLargo Mac I/O" },
		Device { id: 0x0024, name: "UniNorth/Pangea GMAC (Sun GEM)" },
		Device { id: 0x0025, name: "KeyLargo/Pangea Mac I/O" },
		Device { id: 0x0026, name: "KeyLargo/Pangea USB" },
		Device { id: 0x0027, name: "UniNorth/Pangea AGP" },
		Device { id: 0x0028, name: "UniNorth/Pangea PCI" },
		Device { id: 0x0029, name: "UniNorth/Pangea Internal PCI" },
		Device { id: 0x002D, name: "UniNorth 1.5 AGP" },
		Device { id: 0x002E, name: "UniNorth 1.5 PCI" },
		Device { id: 0x002F, name: "UniNorth 1.5 Internal PCI" },
		Device { id: 0x0030, name: "UniNorth/Pangea FireWire" },
		Device { id: 0x0031, name: "UniNorth 2 FireWire" },
		Device { id: 0x0032, name: "UniNorth 2 GMAC (Sun GEM)" },
		Device { id: 0x0033, name: "UniNorth 2 ATA/100" },
		Device { id: 0x0034, name: "UniNorth 2 AGP" },
		Device { id: 0x0035, name: "UniNorth 2 PCI" },
		Device { id: 0x0036, name: "UniNorth 2 Internal PCI" },
		Device { id: 0x003B, name: "UniNorth/Intrepid ATA/100" },
		Device { id: 0x003E, name: "KeyLargo/Intrepid Mac I/O" },
		Device { id: 0x003F, name: "KeyLargo/Intrepid USB" },
		Device { id: 0x0040, name: "K2 KeyLargo USB" },
		Device { id: 0x0041, name: "K2 KeyLargo Mac/IO" },
		Device { id: 0x0042, name: "K2 FireWire" },
		Device { id: 0x0043, name: "K2 ATA/100" },
		Device { id: 0x0045, name: "K2 HT-PCI Bridge" },
		Device { id: 0x0046, name: "K2 HT-PCI Bridge" },
		Device { id: 0x0047, name: "K2 HT-PCI Bridge" },
		Device { id: 0x0048, name: "K2 HT-PCI Bridge" },
		Device { id: 0x0049, name: "K2 HT-PCI Bridge" },
		Device { id: 0x004A, name: "CPC945 HT Bridge" },
		Device { id: 0x004B, name: "U3 AGP" },
		Device { id: 0x004C, name: "K2 GMAC (Sun GEM)" },
		Device { id: 0x004F, name: "Shasta Mac I/O" },
		Device { id: 0x0050, name: "Shasta IDE" },
		Device { id: 0x0051, name: "Shasta (Sun GEM)" },
		Device { id: 0x0052, name: "Shasta Firewire" },
		Device { id: 0x0053, name: "Shasta PCI Bridge" },
		Device { id: 0x0054, name: "Shasta PCI Bridge" },
		Device { id: 0x0055, name: "Shasta PCI Bridge" },
		Device { id: 0x0056, name: "U4 PCIe" },
		Device { id: 0x0057, name: "U3 HT Bridge" },
		Device { id: 0x0058, name: "U3L AGP Bridge" },
		Device { id: 0x0059, name: "U3H AGP Bridge" },
		Device { id: 0x005B, name: "CPC945 PCIe Bridge" },
		Device { id: 0x0066, name: "Intrepid2 AGP Bridge" },
		Device { id: 0x0067, name: "Intrepid2 PCI Bridge" },
		Device { id: 0x0068, name: "Intrepid2 PCI Bridge" },
		Device { id: 0x0069, name: "Intrepid2 ATA/100" },
		Device { id: 0x006A, name: "Intrepid2 Firewire" },
		Device { id: 0x006B, name: "Intrepid2 GMAC (Sun GEM)" },
		Device { id: 0x0074, name: "U4 HT Bridge" },
		Device { id: 0x1645, name: "Broadcom NetXtreme BCM5701 Gigabit Ethernet" },
		Device { id: 0x2001, name: "S1X NVMe Controller" },
		Device { id: 0x2002, name: "S3ELab NVMe Controller" },
		Device { id: 0x2003, name: "S3X NVMe Controller" },
		Device { id: 0x2005, name: "ANS2 NVMe Controller" },
	] },
	Vendor { id: 0x106C, name: "Hynix Semiconductor", devices: &[
		Device { id: 0x8139, name: "8139c 100BaseTX Ethernet Controller" },
		Device { id: 0x8801, name: "Dual Pentium ISA/PCI Motherboard" },
		Device { id: 0x8802, name: "PowerPC ISA/PCI Motherboard" },
		Device { id: 0x8803, name: "Dual Window Graphics Accelerator" },
		Device { id: 0x8804, name: "LAN Controller" },
		Device { id: 0x8805, name: "100-BaseT LAN" },
	] },
	Vendor { id: 0x106D, name: "Sequent Computer Systems", devices: &[
	] },
	Vendor { id: 0x106E, name: "DFI, Inc", devices: &[
	] },
	Vendor { id: 0x106F, name: "City Gate Development Ltd", devices: &[
	] },
	Vendor { id: 0x1070, name: "Daewoo Telecom Ltd", devices: &[
	] },
	Vendor { id: 0x1071, name: "Mitac", devices: &[
		Device { id: 0x8160, name: "Mitac 8060B Mobile Platform" },
	] },
	Vendor { id: 0x1072, name: "GIT Co Ltd", devices: &[
	] },
	Vendor { id: 0x1073, name: "Yamaha Corporation", devices: &[
		Device { id: 0x0001, name: "3D GUI Accelerator" },
		Device { id: 0x0002, name: "YGV615 [RPA3 3D-Graphics Controller]" },
		Device { id: 0x0003, name: "YMF-740" },
		Device { id: 0x0004, name: "YMF-724" },
		Device { id: 0x0005, name: "DS1 Audio" },
		Device { id: 0x0006, name: "DS1 Audio" },
		Device { id: 0x0008, name: "DS1 Audio" },
		Device { id: 0x000A, name: "DS1L Audio" },
		Device { id: 0x000C, name: "YMF-740C [DS-1L Audio Controller]" },
		Device { id: 0x000D, name: "YMF-724F [DS-1 Audio Controller]" },
		Device { id: 0x0010, name: "YMF-744B [DS-1S Audio Controller]" },
		Device { id: 0x0012, name: "YMF-754 [DS-1E Audio Controller]" },
		Device { id: 0x0020, name: "DS-1 Audio" },
		Device { id: 0x1000, name: "SW1000XG [XG Factory]" },
		Device { id: 0x2000, name: "DS2416 Digital Mixing Card" },
	] },
	Vendor { id: 0x1074, name: "NexGen Microsystems", devices: &[
		Device { id: 0x4E78, name: "82c500/1" },
	] },
	Vendor { id: 0x1075, name: "Advanced Integrations Research", devices: &[
	] },
	Vendor { id: 0x1076, name: "Chaintech Computer Co. Ltd", devices: &[
	] },
	Vendor { id: 0x1077, name: "QLogic Corp.", devices: &[
		Device { id: 0x1016, name: "ISP10160 Single Channel Ultra3 SCSI Processor" },
		Device { id: 0x1020, name: "ISP1020 Fast-wide SCSI" },
		Device { id: 0x1022, name: "ISP1022 Fast-wide SCSI" },
		Device { id: 0x1080, name: "ISP1080 SCSI Host Adapter" },
		Device { id: 0x1216, name: "ISP12160 Dual Channel Ultra3 SCSI Processor" },
		Device { id: 0x1240, name: "ISP1240 SCSI Host Adapter" },
		Device { id: 0x1280, name: "ISP1280 SCSI Host Adapter" },
		Device { id: 0x1634, name: "FastLinQ QL45000 Series 40GbE Controller" },
		Device { id: 0x1644, name: "FastLinQ QL45000 Series 100GbE Controller" },
		Device { id: 0x1654, name: "FastLinQ QL45000 Series 50GbE Controller" },
		Device { id: 0x1656, name: "FastLinQ QL45000 Series 25GbE Controller" },
		Device { id: 0x165C, name: "FastLinQ QL45000 Series 10/25/40/50GbE Controller (FCoE)" },
		Device { id: 0x165E, name: "FastLinQ QL45000 Series 10/25/40/50GbE Controller (iSCSI)" },
		Device { id: 0x1664, name: "FastLinQ QL45000 Series Gigabit Ethernet Controller (SR-IOV VF)" },
		Device { id: 0x2020, name: "ISP2020A Fast!SCSI Basic Adapter" },
		Device { id: 0x2031, name: "ISP8324-based 16Gb Fibre Channel to PCI Express Adapter" },
		Device { id: 0x2071, name: "ISP2714-based 16/32Gb Fibre Channel to PCIe Adapter" },
		Device { id: 0x2100, name: "QLA2100 64-bit Fibre Channel Adapter" },
		Device { id: 0x2200, name: "QLA2200 64-bit Fibre Channel Adapter" },
		Device { id: 0x2261, name: "ISP2722-based 16/32Gb Fibre Channel to PCIe Adapter" },
		Device { id: 0x2300, name: "QLA2300 64-bit Fibre Channel Adapter" },
		Device { id: 0x2312, name: "ISP2312-based 2Gb Fibre Channel to PCI-X HBA" },
		Device { id: 0x2322, name: "ISP2322-based 2Gb Fibre Channel to PCI-X HBA" },
		Device { id: 0x2422, name: "ISP2422-based 4Gb Fibre Channel to PCI-X HBA" },
		Device { id: 0x2432, name: "ISP2432-based 4Gb Fibre Channel to PCI Express HBA" },
		Device { id: 0x2532, name: "ISP2532-based 8Gb Fibre Channel to PCI Express HBA" },
		Device { id: 0x2971, name: "ISP2684" },
		Device { id: 0x3022, name: "ISP4022-based Ethernet NIC" },
		Device { id: 0x3032, name: "ISP4032-based Ethernet IPv6 NIC" },
		Device { id: 0x4010, name: "ISP4010-based iSCSI TOE HBA" },
		Device { id: 0x4022, name: "ISP4022-based iSCSI TOE HBA" },
		Device { id: 0x4032, name: "ISP4032-based iSCSI TOE IPv6 HBA" },
		Device { id: 0x5432, name: "SP232-based 4Gb Fibre Channel to PCI Express HBA" },
		Device { id: 0x6312, name: "SP202-based 2Gb Fibre Channel to PCI-X HBA" },
		Device { id: 0x6322, name: "SP212-based 2Gb Fibre Channel to PCI-X HBA" },
		Device { id: 0x7220, name: "IBA7220 InfiniBand HCA" },
		Device { id: 0x7322, name: "IBA7322 QDR InfiniBand HCA" },
		Device { id: 0x8000, name: "10GbE Converged Network Adapter (TCP/IP Networking)" },
		Device { id: 0x8001, name: "10GbE Converged Network Adapter (FCoE)" },
		Device { id: 0x8020, name: "cLOM8214 1/10GbE Controller" },
		Device { id: 0x8021, name: "8200 Series 10GbE Converged Network Adapter (FCoE)" },
		Device { id: 0x8022, name: "8200 Series 10GbE Converged Network Adapter (iSCSI)" },
		Device { id: 0x8030, name: "ISP8324 1/10GbE Converged Network Controller" },
		Device { id: 0x8031, name: "8300 Series 10GbE Converged Network Adapter (FCoE)" },
		Device { id: 0x8032, name: "8300 Series 10GbE Converged Network Adapter (iSCSI)" },
		Device { id: 0x8070, name: "FastLinQ QL41000 Series 10/25/40/50GbE Controller" },
		Device { id: 0x8080, name: "FastLinQ QL41000 Series 10/25/40/50GbE Controller (FCoE)" },
		Device { id: 0x8084, name: "FastLinQ QL41000 Series 10/25/40/50GbE Controller (iSCSI)" },
		Device { id: 0x8090, name: "FastLinQ QL41000 Series Gigabit Ethernet Controller (SR-IOV VF)" },
		Device { id: 0x8430, name: "ISP8324 1/10GbE Converged Network Controller (NIC VF)" },
		Device { id: 0x8431, name: "8300 Series 10GbE Converged Network Adapter (FCoE VF)" },
		Device { id: 0x8432, name: "ISP2432M-based 10GbE Converged Network Adapter (CNA)" },
	] },
	Vendor { id: 0x1078, name: "Cyrix Corporation", devices: &[
		Device { id: 0x0000, name: "5510 [Grappa]" },
		Device { id: 0x0001, name: "PCI Master" },
		Device { id: 0x0002, name: "5520 [Cognac]" },
		Device { id: 0x0100, name: "5530 Legacy [Kahlua]" },
		Device { id: 0x0101, name: "5530 SMI [Kahlua]" },
		Device { id: 0x0102, name: "5530 IDE [Kahlua]" },
		Device { id: 0x0103, name: "5530 Audio [Kahlua]" },
		Device { id: 0x0104, name: "5530 Video [Kahlua]" },
		Device { id: 0x0400, name: "ZFMicro PCI Bridge" },
		Device { id: 0x0401, name: "ZFMicro Chipset SMI" },
		Device { id: 0x0402, name: "ZFMicro Chipset IDE" },
		Device { id: 0x0403, name: "ZFMicro Expansion Bus" },
	] },
	Vendor { id: 0x1079, name: "I-Bus", devices: &[
	] },
	Vendor { id: 0x107A, name: "NetWorth", devices: &[
	] },
	Vendor { id: 0x107B, name: "Gateway, Inc.", devices: &[
	] },
	Vendor { id: 0x107C, name: "LG Electronics [Lucky Goldstar Co. Ltd]", devices: &[
	] },
	Vendor { id: 0x107D, name: "LeadTek Research Inc.", devices: &[
		Device { id: 0x0000, name: "P86C850" },
	] },
	Vendor { id: 0x107E, name: "Interphase Corporation", devices: &[
		Device { id: 0x0001, name: "5515 ATM Adapter [Flipper]" },
		Device { id: 0x0002, name: "100 VG AnyLan Controller" },
		Device { id: 0x0004, name: "5526 Fibre Channel Host Adapter" },
		Device { id: 0x0005, name: "x526 Fibre Channel Host Adapter" },
		Device { id: 0x0008, name: "5525/5575 ATM Adapter (155 Mbit) [Atlantic]" },
		Device { id: 0x9003, name: "5535-4P-BRI-ST" },
		Device { id: 0x9007, name: "5535-4P-BRI-U" },
		Device { id: 0x9008, name: "5535-1P-SR" },
		Device { id: 0x900C, name: "5535-1P-SR-ST" },
		Device { id: 0x900E, name: "5535-1P-SR-U" },
		Device { id: 0x9011, name: "5535-1P-PRI" },
		Device { id: 0x9013, name: "5535-2P-PRI" },
		Device { id: 0x9023, name: "5536-4P-BRI-ST" },
		Device { id: 0x9027, name: "5536-4P-BRI-U" },
		Device { id: 0x9031, name: "5536-1P-PRI" },
		Device { id: 0x9033, name: "5536-2P-PRI" },
	] },
	Vendor { id: 0x107F, name: "Data Technology Corporation", devices: &[
		Device { id: 0x0802, name: "SL82C105" },
	] },
	Vendor { id: 0x1080, name: "Contaq Microsystems", devices: &[
		Device { id: 0x0600, name: "82C599" },
		Device { id: 0xC691, name: "Cypress CY82C691" },
		Device { id: 0xC693, name: "82c693" },
	] },
	Vendor { id: 0x1081, name: "Supermac Technology", devices: &[
		Device { id: 0x0D47, name: "Radius PCI to NuBUS Bridge" },
	] },
	Vendor { id: 0x1082, name: "EFA Corporation of America", devices: &[
	] },
	Vendor { id: 0x1083, name: "Forex Computer Corporation", devices: &[
		Device { id: 0x0001, name: "FR710" },
	] },
	Vendor { id: 0x1084, name: "Parador", devices: &[
	] },
	Vendor { id: 0x1086, name: "J. Bond Computer Systems", devices: &[
	] },
	Vendor { id: 0x1087, name: "Cache Computer", devices: &[
	] },
	Vendor { id: 0x1088, name: "Microcomputer Systems (M) Son", devices: &[
	] },
	Vendor { id: 0x1089, name: "Data General Corporation", devices: &[
	] },
	Vendor { id: 0x108A, name: "SBS Technologies", devices: &[
		Device { id: 0x0001, name: "VME Bridge Model 617" },
		Device { id: 0x0010, name: "VME Bridge Model 618" },
		Device { id: 0x0040, name: "dataBLIZZARD" },
		Device { id: 0x3000, name: "VME Bridge Model 2706" },
	] },
	Vendor { id: 0x108C, name: "Oakleigh Systems Inc.", devices: &[
	] },
	Vendor { id: 0x108D, name: "Olicom", devices: &[
		Device { id: 0x0001, name: "Token-Ring 16/4 PCI Adapter (3136/3137)" },
		Device { id: 0x0002, name: "16/4 Token Ring" },
		Device { id: 0x0004, name: "RapidFire OC-3139/3140 Token-Ring 16/4 PCI Adapter" },
		Device { id: 0x0005, name: "GoCard 3250 Token-Ring 16/4 CardBus PC Card" },
		Device { id: 0x0006, name: "OC-3530 RapidFire Token-Ring 100" },
		Device { id: 0x0007, name: "RapidFire 3141 Token-Ring 16/4 PCI Fiber Adapter" },
		Device { id: 0x0008, name: "RapidFire 3540 HSTR 100/16/4 PCI Adapter" },
		Device { id: 0x0011, name: "OC-2315" },
		Device { id: 0x0012, name: "OC-2325" },
		Device { id: 0x0013, name: "OC-2183/2185" },
		Device { id: 0x0014, name: "OC-2326" },
		Device { id: 0x0019, name: "OC-2327/2250 10/100 Ethernet Adapter" },
		Device { id: 0x0021, name: "OC-6151/6152 [RapidFire ATM 155]" },
		Device { id: 0x0022, name: "ATM Adapter" },
	] },
	Vendor { id: 0x108E, name: "Oracle/SUN", devices: &[
		Device { id: 0x0001, name: "EBUS" },
		Device { id: 0x1000, name: "EBUS" },
		Device { id: 0x1001, name: "Happy Meal 10/100 Ethernet [hme]" },
		Device { id: 0x1100, name: "RIO EBUS" },
		Device { id: 0x1101, name: "RIO 10/100 Ethernet [eri]" },
		Device { id: 0x1102, name: "RIO 1394" },
		Device { id: 0x1103, name: "RIO USB" },
		Device { id: 0x1647, name: "Broadcom 570x 10/100/1000 Ethernet [bge]" },
		Device { id: 0x1648, name: "Broadcom 570x 10/100/1000 Ethernet [bge]" },
		Device { id: 0x16A7, name: "Broadcom 570x 10/100/1000 Ethernet [bge]" },
		Device { id: 0x16A8, name: "Broadcom 570x 10/100/1000 Ethernet [bge]" },
		Device { id: 0x2BAD, name: "GEM 10/100/1000 Ethernet [ge]" },
		Device { id: 0x5000, name: "Simba Advanced PCI Bridge" },
		Device { id: 0x5043, name: "SunPCI Co-processor" },
		Device { id: 0x5CA0, name: "Crypto Accelerator 6000 [mca]" },
		Device { id: 0x6300, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6301, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6302, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6303, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6310, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6311, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6312, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6313, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6320, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6323, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6330, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6331, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6332, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6333, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6340, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6343, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6350, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6353, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x6722, name: "Intel 21554 PCI-PCI bus bridge [db21554]" },
		Device { id: 0x676E, name: "SunPCiIII" },
		Device { id: 0x7063, name: "SunPCiII / SunPCiIIpro" },
		Device { id: 0x8000, name: "Psycho PCI Bus Module" },
		Device { id: 0x8001, name: "Schizo PCI Bus Module" },
		Device { id: 0x8002, name: "Schizo+ PCI Bus Module" },
		Device { id: 0x80F0, name: "PCIe switch [px]" },
		Device { id: 0x80F8, name: "PCIe switch [px]" },
		Device { id: 0x9010, name: "PCIe/PCI bridge switch [pxb_plx]" },
		Device { id: 0x9020, name: "PCIe/PCI bridge switch [pxb_plx]" },
		Device { id: 0x9102, name: "Davicom Fast Ethernet driver for Davicom DM9102A [dmfe]" },
		Device { id: 0xA000, name: "Psycho UPA-PCI Bus Module [pcipsy]" },
		Device { id: 0xA001, name: "Psycho UPA-PCI Bus Module [pcipsy]" },
		Device { id: 0xA801, name: "Schizo Fireplane-PCI bus bridge module [pcisch]" },
		Device { id: 0xAAAA, name: "Multithreaded Shared 10GbE Ethernet Network Controller" },
		Device { id: 0xABBA, name: "Cassini 10/100/1000" },
		Device { id: 0xABCD, name: "Multithreaded 10-Gigabit Ethernet Network Controller" },
		Device { id: 0xC416, name: "Sun Fire System/System Controller Interface chip [sbbc]" },
	] },
	Vendor { id: 0x108F, name: "Systemsoft", devices: &[
	] },
	Vendor { id: 0x1090, name: "Compro Computer Services, Inc.", devices: &[
		Device { id: 0x4610, name: "PCI RTOM" },
		Device { id: 0x4620, name: "GPIO HSD" },
	] },
	Vendor { id: 0x1091, name: "Intergraph Corporation", devices: &[
		Device { id: 0x0020, name: "3D graphics processor" },
		Device { id: 0x0021, name: "3D graphics processor w/Texturing" },
		Device { id: 0x0040, name: "3D graphics frame buffer" },
		Device { id: 0x0041, name: "3D graphics frame buffer" },
		Device { id: 0x0060, name: "Proprietary bus bridge" },
		Device { id: 0x00E4, name: "Powerstorm 4D50T" },
		Device { id: 0x0720, name: "Motion JPEG codec" },
		Device { id: 0x0780, name: "Intense3D Wildcat 3410 (MSMT496)" },
		Device { id: 0x07A0, name: "Sun Expert3D-Lite Graphics Accelerator" },
		Device { id: 0x1091, name: "Sun Expert3D Graphics Accelerator" },
	] },
	Vendor { id: 0x1092, name: "Diamond Multimedia Systems", devices: &[
		Device { id: 0x0028, name: "Viper V770" },
		Device { id: 0x00A0, name: "Speedstar Pro SE" },
		Device { id: 0x00A8, name: "Speedstar 64" },
		Device { id: 0x0550, name: "Viper V550" },
		Device { id: 0x08D4, name: "Supra 2260 Modem" },
		Device { id: 0x094C, name: "SupraExpress 56i Pro" },
		Device { id: 0x1001, name: "Video Crunch It 1001 capture card" },
		Device { id: 0x1092, name: "Viper V330" },
		Device { id: 0x6120, name: "Maximum DVD" },
		Device { id: 0x8810, name: "Stealth SE" },
		Device { id: 0x8811, name: "Stealth 64/SE" },
		Device { id: 0x8880, name: "Stealth" },
		Device { id: 0x8881, name: "Stealth" },
		Device { id: 0x88B0, name: "Stealth 64" },
		Device { id: 0x88B1, name: "Stealth 64" },
		Device { id: 0x88C0, name: "Stealth 64" },
		Device { id: 0x88C1, name: "Stealth 64" },
		Device { id: 0x88D0, name: "Stealth 64" },
		Device { id: 0x88D1, name: "Stealth 64" },
		Device { id: 0x88F0, name: "Stealth 64" },
		Device { id: 0x88F1, name: "Stealth 64" },
		Device { id: 0x9999, name: "DMD-I0928-1 \"Monster sound\" sound chip" },
	] },
	Vendor { id: 0x1093, name: "National Instruments", devices: &[
		Device { id: 0x0160, name: "PCI-DIO-96" },
		Device { id: 0x0162, name: "PCI-MIO-16XE-50" },
		Device { id: 0x0FE1, name: "PXI-8320" },
		Device { id: 0x1150, name: "PCI-6533 (PCI-DIO-32HS)" },
		Device { id: 0x1170, name: "PCI-MIO-16XE-10" },
		Device { id: 0x1180, name: "PCI-MIO-16E-1" },
		Device { id: 0x1190, name: "PCI-MIO-16E-4" },
		Device { id: 0x11B0, name: "PXI-6070E" },
		Device { id: 0x11C0, name: "PXI-6040E" },
		Device { id: 0x11D0, name: "PXI-6030E" },
		Device { id: 0x1270, name: "PCI-6032E" },
		Device { id: 0x1290, name: "PCI-6704" },
		Device { id: 0x12B0, name: "PCI-6534" },
		Device { id: 0x1310, name: "PCI-6602" },
		Device { id: 0x1320, name: "PXI-6533" },
		Device { id: 0x1330, name: "PCI-6031E" },
		Device { id: 0x1340, name: "PCI-6033E" },
		Device { id: 0x1350, name: "PCI-6071E" },
		Device { id: 0x1360, name: "PXI-6602" },
		Device { id: 0x13C0, name: "PXI-6508" },
		Device { id: 0x1490, name: "PXI-6534" },
		Device { id: 0x14E0, name: "PCI-6110" },
		Device { id: 0x14F0, name: "PCI-6111" },
		Device { id: 0x1580, name: "PXI-6031E" },
		Device { id: 0x15B0, name: "PXI-6071E" },
		Device { id: 0x1710, name: "PXI-6509" },
		Device { id: 0x17C0, name: "PXI-5690" },
		Device { id: 0x17D0, name: "PCI-6503" },
		Device { id: 0x1870, name: "PCI-6713" },
		Device { id: 0x1880, name: "PCI-6711" },
		Device { id: 0x18B0, name: "PCI-6052E" },
		Device { id: 0x18C0, name: "PXI-6052E" },
		Device { id: 0x1920, name: "PXI-6704" },
		Device { id: 0x1930, name: "PCI-6040E" },
		Device { id: 0x19C0, name: "PCI-4472" },
		Device { id: 0x1AA0, name: "PXI-4110" },
		Device { id: 0x1AD0, name: "PCI-6133" },
		Device { id: 0x1AE0, name: "PXI-6133" },
		Device { id: 0x1E30, name: "PCI-6624" },
		Device { id: 0x1E40, name: "PXI-6624" },
		Device { id: 0x1E50, name: "PXI-5404" },
		Device { id: 0x2410, name: "PCI-6733" },
		Device { id: 0x2420, name: "PXI-6733" },
		Device { id: 0x2430, name: "PCI-6731" },
		Device { id: 0x2470, name: "PCI-4474" },
		Device { id: 0x24A0, name: "PCI-4065" },
		Device { id: 0x24B0, name: "PXI-4200" },
		Device { id: 0x24F0, name: "PXI-4472" },
		Device { id: 0x2510, name: "PCI-4472" },
		Device { id: 0x2520, name: "PCI-4474" },
		Device { id: 0x27A0, name: "PCI-6123" },
		Device { id: 0x27B0, name: "PXI-6123" },
		Device { id: 0x2880, name: "DAQCard-6601" },
		Device { id: 0x2890, name: "PCI-6036E" },
		Device { id: 0x28A0, name: "PXI-4461" },
		Device { id: 0x28B0, name: "PCI-6013" },
		Device { id: 0x28C0, name: "PCI-6014" },
		Device { id: 0x28D0, name: "PCI-5122" },
		Device { id: 0x28E0, name: "PXI-5122" },
		Device { id: 0x29F0, name: "PXI-7334" },
		Device { id: 0x2A00, name: "PXI-7344" },
		Device { id: 0x2A60, name: "PCI-6023E" },
		Device { id: 0x2A70, name: "PCI-6024E" },
		Device { id: 0x2A80, name: "PCI-6025E" },
		Device { id: 0x2AB0, name: "PXI-6025E" },
		Device { id: 0x2B10, name: "PXI-6527" },
		Device { id: 0x2B20, name: "PCI-6527" },
		Device { id: 0x2B80, name: "PXI-6713" },
		Device { id: 0x2B90, name: "PXI-6711" },
		Device { id: 0x2C60, name: "PCI-6601" },
		Device { id: 0x2C70, name: "PXI-6601" },
		Device { id: 0x2C80, name: "PCI-6035E" },
		Device { id: 0x2C90, name: "PCI-6703" },
		Device { id: 0x2CA0, name: "PCI-6034E" },
		Device { id: 0x2CB0, name: "PCI-7344" },
		Device { id: 0x2CC0, name: "PXI-6608" },
		Device { id: 0x2D20, name: "PXI-5600" },
		Device { id: 0x2DB0, name: "PCI-6608" },
		Device { id: 0x2DC0, name: "PCI-4070" },
		Device { id: 0x2DD0, name: "PXI-4070" },
		Device { id: 0x2EB0, name: "PXI-4472" },
		Device { id: 0x2EC0, name: "PXI-6115" },
		Device { id: 0x2ED0, name: "PCI-6115" },
		Device { id: 0x2EE0, name: "PXI-6120" },
		Device { id: 0x2EF0, name: "PCI-6120" },
		Device { id: 0x2FD1, name: "PCI-7334" },
		Device { id: 0x2FD2, name: "PCI-7350" },
		Device { id: 0x2FD3, name: "PCI-7342" },
		Device { id: 0x2FD5, name: "PXI-7350" },
		Device { id: 0x2FD6, name: "PXI-7342" },
		Device { id: 0x7003, name: "PCI-6551" },
		Device { id: 0x7004, name: "PXI-6551" },
		Device { id: 0x700B, name: "PXI-5421" },
		Device { id: 0x700C, name: "PCI-5421" },
		Device { id: 0x701A, name: "VXIpc-87xB" },
		Device { id: 0x701B, name: "VXIpc-770" },
		Device { id: 0x7023, name: "PXI-2593" },
		Device { id: 0x7027, name: "PCI-MXI-2 Universal" },
		Device { id: 0x702C, name: "PXI-7831R" },
		Device { id: 0x702D, name: "PCI-7831R" },
		Device { id: 0x702E, name: "PXI-7811R" },
		Device { id: 0x702F, name: "PCI-7811R" },
		Device { id: 0x7030, name: "PCI-CAN (Series 2)" },
		Device { id: 0x7031, name: "PCI-CAN/2 (Series 2)" },
		Device { id: 0x7032, name: "PCI-CAN/LS (Series 2)" },
		Device { id: 0x7033, name: "PCI-CAN/LS2 (Series 2)" },
		Device { id: 0x7034, name: "PCI-CAN/DS (Series 2)" },
		Device { id: 0x7035, name: "PXI-8460 (Series 2, 1 port)" },
		Device { id: 0x7036, name: "PXI-8460 (Series 2, 2 ports)" },
		Device { id: 0x7037, name: "PXI-8461 (Series 2, 1 port)" },
		Device { id: 0x7038, name: "PXI-8461 (Series 2, 2 ports)" },
		Device { id: 0x7039, name: "PXI-8462 (Series 2)" },
		Device { id: 0x703F, name: "PXI-2566" },
		Device { id: 0x7040, name: "PXI-2567" },
		Device { id: 0x7044, name: "MXI-4 Connection Monitor" },
		Device { id: 0x7047, name: "PXI-6653" },
		Device { id: 0x704C, name: "PXI-2530" },
		Device { id: 0x704F, name: "PXI-4220" },
		Device { id: 0x7050, name: "PXI-4204" },
		Device { id: 0x7055, name: "PXI-7830R" },
		Device { id: 0x7056, name: "PCI-7830R" },
		Device { id: 0x705A, name: "PCI-CAN/XS (Series 2)" },
		Device { id: 0x705B, name: "PCI-CAN/XS2 (Series 2)" },
		Device { id: 0x705C, name: "PXI-8464 (Series 2, 1 port)" },
		Device { id: 0x705D, name: "PXI-8464 (Series 2, 2 ports)" },
		Device { id: 0x705E, name: "cRIO-9102" },
		Device { id: 0x7060, name: "PXI-5610" },
		Device { id: 0x7064, name: "PXI-1045 Trigger Routing Module" },
		Device { id: 0x7065, name: "PXI-6652" },
		Device { id: 0x7066, name: "PXI-6651" },
		Device { id: 0x7067, name: "PXI-2529" },
		Device { id: 0x7068, name: "PCI-CAN/SW (Series 2)" },
		Device { id: 0x7069, name: "PCI-CAN/SW2 (Series 2)" },
		Device { id: 0x706A, name: "PXI-8463 (Series 2, 1 port)" },
		Device { id: 0x706B, name: "PXI-8463 (Series 2, 2 ports)" },
		Device { id: 0x7073, name: "PCI-6723" },
		Device { id: 0x7074, name: "PXI-7833R" },
		Device { id: 0x7075, name: "PXI-6552" },
		Device { id: 0x7076, name: "PCI-6552" },
		Device { id: 0x707C, name: "PXI-1428" },
		Device { id: 0x707E, name: "PXI-4462" },
		Device { id: 0x7080, name: "PXI-8430/2 (RS-232) Interface" },
		Device { id: 0x7081, name: "PXI-8431/2 (RS-485) Interface" },
		Device { id: 0x7083, name: "PCI-7833R" },
		Device { id: 0x7085, name: "PCI-6509" },
		Device { id: 0x7086, name: "PXI-6528" },
		Device { id: 0x7087, name: "PCI-6515" },
		Device { id: 0x7088, name: "PCI-6514" },
		Device { id: 0x708C, name: "PXI-2568" },
		Device { id: 0x708D, name: "PXI-2569" },
		Device { id: 0x70A9, name: "PCI-6528" },
		Device { id: 0x70AA, name: "PCI-6229" },
		Device { id: 0x70AB, name: "PCI-6259" },
		Device { id: 0x70AC, name: "PCI-6289" },
		Device { id: 0x70AD, name: "PXI-6251" },
		Device { id: 0x70AE, name: "PXI-6220" },
		Device { id: 0x70AF, name: "PCI-6221" },
		Device { id: 0x70B0, name: "PCI-6220" },
		Device { id: 0x70B1, name: "PXI-6229" },
		Device { id: 0x70B2, name: "PXI-6259" },
		Device { id: 0x70B3, name: "PXI-6289" },
		Device { id: 0x70B4, name: "PCI-6250" },
		Device { id: 0x70B5, name: "PXI-6221" },
		Device { id: 0x70B6, name: "PCI-6280" },
		Device { id: 0x70B7, name: "PCI-6254" },
		Device { id: 0x70B8, name: "PCI-6251" },
		Device { id: 0x70B9, name: "PXI-6250" },
		Device { id: 0x70BA, name: "PXI-6254" },
		Device { id: 0x70BB, name: "PXI-6280" },
		Device { id: 0x70BC, name: "PCI-6284" },
		Device { id: 0x70BD, name: "PCI-6281" },
		Device { id: 0x70BE, name: "PXI-6284" },
		Device { id: 0x70BF, name: "PXI-6281" },
		Device { id: 0x70C0, name: "PCI-6143" },
		Device { id: 0x70C3, name: "PCI-6511" },
		Device { id: 0x70C4, name: "PXI-7330" },
		Device { id: 0x70C5, name: "PXI-7340" },
		Device { id: 0x70C6, name: "PCI-7330" },
		Device { id: 0x70C7, name: "PCI-7340" },
		Device { id: 0x70C8, name: "PCI-6513" },
		Device { id: 0x70C9, name: "PXI-6515" },
		Device { id: 0x70CA, name: "PCI-1405" },
		Device { id: 0x70CC, name: "PCI-6512" },
		Device { id: 0x70CD, name: "PXI-6514" },
		Device { id: 0x70CE, name: "PXI-1405" },
		Device { id: 0x70CF, name: "PCIe-GPIB" },
		Device { id: 0x70D0, name: "PXI-2570" },
		Device { id: 0x70D1, name: "PXI-6513" },
		Device { id: 0x70D2, name: "PXI-6512" },
		Device { id: 0x70D3, name: "PXI-6511" },
		Device { id: 0x70D4, name: "PCI-6722" },
		Device { id: 0x70D6, name: "PXI-4072" },
		Device { id: 0x70D7, name: "PXI-6541" },
		Device { id: 0x70D8, name: "PXI-6542" },
		Device { id: 0x70D9, name: "PCI-6541" },
		Device { id: 0x70DA, name: "PCI-6542" },
		Device { id: 0x70DB, name: "PCI-8430/2 (RS-232) Interface" },
		Device { id: 0x70DC, name: "PCI-8431/2 (RS-485) Interface" },
		Device { id: 0x70DD, name: "PXI-8430/4 (RS-232) Interface" },
		Device { id: 0x70DE, name: "PXI-8431/4 (RS-485) Interface" },
		Device { id: 0x70DF, name: "PCI-8430/4 (RS-232) Interface" },
		Device { id: 0x70E0, name: "PCI-8431/4 (RS-485) Interface" },
		Device { id: 0x70E1, name: "PXI-2532" },
		Device { id: 0x70E2, name: "PXI-8430/8 (RS-232) Interface" },
		Device { id: 0x70E3, name: "PXI-8431/8 (RS-485) Interface" },
		Device { id: 0x70E4, name: "PCI-8430/8 (RS-232) Interface" },
		Device { id: 0x70E5, name: "PCI-8431/8 (RS-485) Interface" },
		Device { id: 0x70E6, name: "PXI-8430/16 (RS-232) Interface" },
		Device { id: 0x70E7, name: "PCI-8430/16 (RS-232) Interface" },
		Device { id: 0x70E8, name: "PXI-8432/2 (Isolated RS-232) Interface" },
		Device { id: 0x70E9, name: "PXI-8433/2 (Isolated RS-485) Interface" },
		Device { id: 0x70EA, name: "PCI-8432/2 (Isolated RS-232) Interface" },
		Device { id: 0x70EB, name: "PCI-8433/2 (Isolated RS-485) Interface" },
		Device { id: 0x70EC, name: "PXI-8432/4 (Isolated RS-232) Interface" },
		Device { id: 0x70ED, name: "PXI-8433/4 (Isolated RS-485) Interface" },
		Device { id: 0x70EE, name: "PCI-8432/4 (Isolated RS-232) Interface" },
		Device { id: 0x70EF, name: "PCI-8433/4 (Isolated RS-485) Interface" },
		Device { id: 0x70F0, name: "PXI-5922" },
		Device { id: 0x70F1, name: "PCI-5922" },
		Device { id: 0x70F2, name: "PCI-6224" },
		Device { id: 0x70F3, name: "PXI-6224" },
		Device { id: 0x70F6, name: "cRIO-9101" },
		Device { id: 0x70F7, name: "cRIO-9103" },
		Device { id: 0x70F8, name: "cRIO-9104" },
		Device { id: 0x70FF, name: "PXI-6723" },
		Device { id: 0x7100, name: "PXI-6722" },
		Device { id: 0x7104, name: "PCIx-1429" },
		Device { id: 0x7105, name: "PCIe-1429" },
		Device { id: 0x710A, name: "PXI-4071" },
		Device { id: 0x710D, name: "PXI-6143" },
		Device { id: 0x710E, name: "PCIe-GPIB" },
		Device { id: 0x710F, name: "PXI-5422" },
		Device { id: 0x7110, name: "PCI-5422" },
		Device { id: 0x7111, name: "PXI-5441" },
		Device { id: 0x7119, name: "PXI-6561" },
		Device { id: 0x711A, name: "PXI-6562" },
		Device { id: 0x711B, name: "PCI-6561" },
		Device { id: 0x711C, name: "PCI-6562" },
		Device { id: 0x7120, name: "PCI-7390" },
		Device { id: 0x7121, name: "PXI-5122EX" },
		Device { id: 0x7122, name: "PCI-5122EX" },
		Device { id: 0x7123, name: "PXIe-5653" },
		Device { id: 0x7124, name: "PCI-6510" },
		Device { id: 0x7125, name: "PCI-6516" },
		Device { id: 0x7126, name: "PCI-6517" },
		Device { id: 0x7127, name: "PCI-6518" },
		Device { id: 0x7128, name: "PCI-6519" },
		Device { id: 0x7137, name: "PXI-2575" },
		Device { id: 0x713C, name: "PXI-2585" },
		Device { id: 0x713D, name: "PXI-2586" },
		Device { id: 0x7142, name: "PXI-4224" },
		Device { id: 0x7144, name: "PXI-5124" },
		Device { id: 0x7145, name: "PCI-5124" },
		Device { id: 0x7146, name: "PCI-6132" },
		Device { id: 0x7147, name: "PXI-6132" },
		Device { id: 0x7148, name: "PCI-6122" },
		Device { id: 0x7149, name: "PXI-6122" },
		Device { id: 0x714C, name: "PXI-5114" },
		Device { id: 0x714D, name: "PCI-5114" },
		Device { id: 0x7150, name: "PXI-2564" },
		Device { id: 0x7152, name: "PCI-5640R" },
		Device { id: 0x7156, name: "PXI-1044 Trigger Routing Module" },
		Device { id: 0x715D, name: "PCI-1426" },
		Device { id: 0x7167, name: "PXI-5412" },
		Device { id: 0x7168, name: "PCI-5412" },
		Device { id: 0x716B, name: "PCI-6230" },
		Device { id: 0x716C, name: "PCI-6225" },
		Device { id: 0x716D, name: "PXI-6225" },
		Device { id: 0x716F, name: "PCI-4461" },
		Device { id: 0x7170, name: "PCI-4462" },
		Device { id: 0x7171, name: "PCI-6010" },
		Device { id: 0x7174, name: "PXI-8360" },
		Device { id: 0x7177, name: "PXI-6230" },
		Device { id: 0x717D, name: "PCIe-6251" },
		Device { id: 0x717F, name: "PCIe-6259" },
		Device { id: 0x7187, name: "PCI-1410" },
		Device { id: 0x718B, name: "PCI-6521" },
		Device { id: 0x718C, name: "PXI-6521" },
		Device { id: 0x7191, name: "PCI-6154" },
		Device { id: 0x7193, name: "PXI-7813R" },
		Device { id: 0x7194, name: "PCI-7813R" },
		Device { id: 0x7195, name: "PCI-8254R" },
		Device { id: 0x7197, name: "PXI-5402" },
		Device { id: 0x7198, name: "PCI-5402" },
		Device { id: 0x719F, name: "PCIe-6535" },
		Device { id: 0x71A0, name: "PCIe-6536" },
		Device { id: 0x71A3, name: "PXI-5650" },
		Device { id: 0x71A4, name: "PXI-5652" },
		Device { id: 0x71A5, name: "PXI-2594" },
		Device { id: 0x71A7, name: "PXI-2595" },
		Device { id: 0x71A9, name: "PXI-2596" },
		Device { id: 0x71AA, name: "PXI-2597" },
		Device { id: 0x71AB, name: "PXI-2598" },
		Device { id: 0x71AC, name: "PXI-2599" },
		Device { id: 0x71AD, name: "PCI-GPIB+" },
		Device { id: 0x71AE, name: "PCIe-1430" },
		Device { id: 0x71B7, name: "PXI-1056 Trigger Routing Module" },
		Device { id: 0x71B8, name: "PXI-1045 Trigger Routing Module" },
		Device { id: 0x71B9, name: "PXI-1044 Trigger Routing Module" },
		Device { id: 0x71BB, name: "PXI-2584" },
		Device { id: 0x71BC, name: "PCI-6221 (37-pin)" },
		Device { id: 0x71BF, name: "PCIe-1427" },
		Device { id: 0x71C5, name: "PCI-6520" },
		Device { id: 0x71C6, name: "PXI-2576" },
		Device { id: 0x71C7, name: "cRIO-9072" },
		Device { id: 0x71DC, name: "PCI-1588" },
		Device { id: 0x71E0, name: "PCI-6255" },
		Device { id: 0x71E1, name: "PXI-6255" },
		Device { id: 0x71E2, name: "PXI-5406" },
		Device { id: 0x71E3, name: "PCI-5406" },
		Device { id: 0x71FC, name: "PXI-4022" },
		Device { id: 0x7209, name: "PCI-6233" },
		Device { id: 0x720A, name: "PXI-6233" },
		Device { id: 0x720B, name: "PCI-6238" },
		Device { id: 0x720C, name: "PXI-6238" },
		Device { id: 0x7260, name: "PXI-5142" },
		Device { id: 0x7261, name: "PCI-5142" },
		Device { id: 0x726D, name: "PXI-5651" },
		Device { id: 0x7273, name: "PXI-4461" },
		Device { id: 0x7274, name: "PXI-4462" },
		Device { id: 0x7279, name: "PCI-6232" },
		Device { id: 0x727A, name: "PXI-6232" },
		Device { id: 0x727B, name: "PCI-6239" },
		Device { id: 0x727C, name: "PXI-6239" },
		Device { id: 0x727E, name: "SMBus Controller" },
		Device { id: 0x7281, name: "PCI-6236" },
		Device { id: 0x7282, name: "PXI-6236" },
		Device { id: 0x7283, name: "PXI-2554" },
		Device { id: 0x7288, name: "PXIe-5611" },
		Device { id: 0x7293, name: "PCIe-8255R" },
		Device { id: 0x729D, name: "cRIO-9074" },
		Device { id: 0x72A4, name: "PCIe-4065" },
		Device { id: 0x72A7, name: "PCIe-6537" },
		Device { id: 0x72A8, name: "PXI-5152" },
		Device { id: 0x72A9, name: "PCI-5152" },
		Device { id: 0x72AA, name: "PXI-5105" },
		Device { id: 0x72AB, name: "PCI-5105" },
		Device { id: 0x72B8, name: "PXI-6682" },
		Device { id: 0x72D0, name: "PXI-2545" },
		Device { id: 0x72D1, name: "PXI-2546" },
		Device { id: 0x72D2, name: "PXI-2547" },
		Device { id: 0x72D3, name: "PXI-2548" },
		Device { id: 0x72D4, name: "PXI-2549" },
		Device { id: 0x72D5, name: "PXI-2555" },
		Device { id: 0x72D6, name: "PXI-2556" },
		Device { id: 0x72D7, name: "PXI-2557" },
		Device { id: 0x72D8, name: "PXI-2558" },
		Device { id: 0x72D9, name: "PXI-2559" },
		Device { id: 0x72E8, name: "PXIe-6251" },
		Device { id: 0x72E9, name: "PXIe-6259" },
		Device { id: 0x72EF, name: "PXI-4498" },
		Device { id: 0x72F0, name: "PXI-4496" },
		Device { id: 0x72FB, name: "PXIe-6672" },
		Device { id: 0x730E, name: "PXI-4130" },
		Device { id: 0x730F, name: "PXI-5922EX" },
		Device { id: 0x7310, name: "PCI-5922EX" },
		Device { id: 0x731C, name: "PXI-2535" },
		Device { id: 0x731D, name: "PXI-2536" },
		Device { id: 0x7322, name: "PXIe-6124" },
		Device { id: 0x7327, name: "PXI-6529" },
		Device { id: 0x732C, name: "VXI-8360T" },
		Device { id: 0x7331, name: "PXIe-5602" },
		Device { id: 0x7332, name: "PXIe-5601" },
		Device { id: 0x7333, name: "PXI-5900" },
		Device { id: 0x7335, name: "PXI-2533" },
		Device { id: 0x7336, name: "PXI-2534" },
		Device { id: 0x7342, name: "PXI-4461" },
		Device { id: 0x7349, name: "PXI-5154" },
		Device { id: 0x734A, name: "PCI-5154" },
		Device { id: 0x7357, name: "PXI-4065" },
		Device { id: 0x7359, name: "PXI-4495" },
		Device { id: 0x7370, name: "PXI-4461" },
		Device { id: 0x7373, name: "sbRIO-9601" },
		Device { id: 0x7374, name: "IOtech-9601" },
		Device { id: 0x7375, name: "sbRIO-9602" },
		Device { id: 0x7378, name: "sbRIO-9641" },
		Device { id: 0x737D, name: "PXI-5124EX" },
		Device { id: 0x7384, name: "PXI-7851R" },
		Device { id: 0x7385, name: "PXI-7852R" },
		Device { id: 0x7386, name: "PCIe-7851R" },
		Device { id: 0x7387, name: "PCIe-7852R" },
		Device { id: 0x7390, name: "PXI-7841R" },
		Device { id: 0x7391, name: "PXI-7842R" },
		Device { id: 0x7392, name: "PXI-7853R" },
		Device { id: 0x7393, name: "PCIe-7841R" },
		Device { id: 0x7394, name: "PCIe-7842R" },
		Device { id: 0x7397, name: "sbRIO-9611" },
		Device { id: 0x7398, name: "sbRIO-9612" },
		Device { id: 0x7399, name: "sbRIO-9631" },
		Device { id: 0x739A, name: "sbRIO-9632" },
		Device { id: 0x739B, name: "sbRIO-9642" },
		Device { id: 0x73A1, name: "PXIe-4498" },
		Device { id: 0x73A2, name: "PXIe-4496" },
		Device { id: 0x73A5, name: "PXIe-5641R" },
		Device { id: 0x73A7, name: "PXI-8250 Chassis Monitor Module" },
		Device { id: 0x73A8, name: "PXI-8511 CAN/LS" },
		Device { id: 0x73A9, name: "PXI-8511 CAN/LS" },
		Device { id: 0x73AA, name: "PXI-8512 CAN/HS" },
		Device { id: 0x73AB, name: "PXI-8512 CAN/HS" },
		Device { id: 0x73AC, name: "PXI-8513 CAN/XS" },
		Device { id: 0x73AD, name: "PXI-8513 CAN/XS" },
		Device { id: 0x73AF, name: "PXI-8516 LIN" },
		Device { id: 0x73B1, name: "PXI-8517 FlexRay" },
		Device { id: 0x73B2, name: "PXI-8531 CANopen" },
		Device { id: 0x73B3, name: "PXI-8531 CANopen" },
		Device { id: 0x73B4, name: "PXI-8532 DeviceNet" },
		Device { id: 0x73B5, name: "PXI-8532 DeviceNet" },
		Device { id: 0x73B6, name: "PCI-8511 CAN/LS" },
		Device { id: 0x73B7, name: "PCI-8511 CAN/LS" },
		Device { id: 0x73B8, name: "PCI-8512 CAN/HS" },
		Device { id: 0x73B9, name: "PCI-8512 CAN/HS" },
		Device { id: 0x73BA, name: "PCI-8513 CAN/XS" },
		Device { id: 0x73BB, name: "PCI-8513 CAN/XS" },
		Device { id: 0x73BD, name: "PCI-8516 LIN" },
		Device { id: 0x73BF, name: "PCI-8517 FlexRay" },
		Device { id: 0x73C0, name: "PCI-8531 CANopen" },
		Device { id: 0x73C1, name: "PCI-8531 CANopen" },
		Device { id: 0x73C2, name: "PCI-8532 DeviceNet" },
		Device { id: 0x73C3, name: "PCI-8532 DeviceNet" },
		Device { id: 0x73C5, name: "PXIe-2527" },
		Device { id: 0x73C6, name: "PXIe-2529" },
		Device { id: 0x73C8, name: "PXIe-2530" },
		Device { id: 0x73C9, name: "PXIe-2532" },
		Device { id: 0x73CA, name: "PXIe-2569" },
		Device { id: 0x73CB, name: "PXIe-2575" },
		Device { id: 0x73CC, name: "PXIe-2593" },
		Device { id: 0x73D5, name: "PXI-7951R" },
		Device { id: 0x73D6, name: "PXI-7952R" },
		Device { id: 0x73D7, name: "PXI-7953R" },
		Device { id: 0x73E1, name: "PXI-7854R" },
		Device { id: 0x73EC, name: "PXI-7954R" },
		Device { id: 0x73ED, name: "cRIO-9073" },
		Device { id: 0x73F0, name: "PXI-5153" },
		Device { id: 0x73F1, name: "PCI-5153" },
		Device { id: 0x73F4, name: "PXI-2515" },
		Device { id: 0x73F6, name: "cRIO-9111" },
		Device { id: 0x73F7, name: "cRIO-9112" },
		Device { id: 0x73F8, name: "cRIO-9113" },
		Device { id: 0x73F9, name: "cRIO-9114" },
		Device { id: 0x73FA, name: "cRIO-9116" },
		Device { id: 0x73FB, name: "cRIO-9118" },
		Device { id: 0x7404, name: "PXI-4132" },
		Device { id: 0x7405, name: "PXIe-6674T" },
		Device { id: 0x7406, name: "PXIe-6674" },
		Device { id: 0x740E, name: "PCIe-8430/16 (RS-232) Interface" },
		Device { id: 0x740F, name: "PCIe-8430/8 (RS-232) Interface" },
		Device { id: 0x7410, name: "PCIe-8431/16 (RS-485) Interface" },
		Device { id: 0x7411, name: "PCIe-8431/8 (RS-485) Interface" },
		Device { id: 0x7414, name: "PCIe-GPIB+" },
		Device { id: 0x741C, name: "PXI-5691" },
		Device { id: 0x741D, name: "PXI-5695" },
		Device { id: 0x743C, name: "CSC-3059" },
		Device { id: 0x7448, name: "PXI-2510" },
		Device { id: 0x7454, name: "PXI-2512" },
		Device { id: 0x7455, name: "PXI-2514" },
		Device { id: 0x7456, name: "PXIe-2512" },
		Device { id: 0x7457, name: "PXIe-2514" },
		Device { id: 0x745A, name: "PXI-6682H" },
		Device { id: 0x745E, name: "PXI-5153EX" },
		Device { id: 0x745F, name: "PCI-5153EX" },
		Device { id: 0x7460, name: "PXI-5154EX" },
		Device { id: 0x7461, name: "PCI-5154EX" },
		Device { id: 0x746D, name: "PXIe-5650" },
		Device { id: 0x746E, name: "PXIe-5651" },
		Device { id: 0x746F, name: "PXIe-5652" },
		Device { id: 0x7472, name: "PXI-2800" },
		Device { id: 0x7495, name: "PXIe-5603" },
		Device { id: 0x7497, name: "PXIe-5605" },
		Device { id: 0x74AE, name: "PXIe-2515" },
		Device { id: 0x74B4, name: "PXI-2531" },
		Device { id: 0x74B5, name: "PXIe-2531" },
		Device { id: 0x74C1, name: "PXIe-8430/16 (RS-232) Interface" },
		Device { id: 0x74C2, name: "PXIe-8430/8 (RS-232) Interface" },
		Device { id: 0x74C3, name: "PXIe-8431/16 (RS-485) Interface" },
		Device { id: 0x74C4, name: "PXIe-8431/8 (RS-485) Interface" },
		Device { id: 0x74D5, name: "PXIe-5630" },
		Device { id: 0x74D9, name: "PCIe-8432/2 (Isolated RS-232) Interface" },
		Device { id: 0x74DA, name: "PCIe-8433/2 (Isolated RS-485) Interface" },
		Device { id: 0x74DB, name: "PCIe-8432/4 (Isolated RS-232) Interface" },
		Device { id: 0x74DC, name: "PCIe-8433/4 (Isolated RS-485) Interface" },
		Device { id: 0x74E8, name: "NI 9148" },
		Device { id: 0x7515, name: "PCIe-8430/2 (RS-232) Interface" },
		Device { id: 0x7516, name: "PCIe-8430/4 (RS-232) Interface" },
		Device { id: 0x7517, name: "PCIe-8431/2 (RS-485) Interface" },
		Device { id: 0x7518, name: "PCIe-8431/4 (RS-485) Interface" },
		Device { id: 0x751B, name: "cRIO-9081" },
		Device { id: 0x751C, name: "cRIO-9082" },
		Device { id: 0x7528, name: "PXIe-4497" },
		Device { id: 0x7529, name: "PXIe-4499" },
		Device { id: 0x752A, name: "PXIe-4492" },
		Device { id: 0x7539, name: "NI 9157" },
		Device { id: 0x753A, name: "NI 9159" },
		Device { id: 0x7598, name: "PXI-2571" },
		Device { id: 0x75A4, name: "PXI-4131A" },
		Device { id: 0x75B1, name: "PCIe-7854R" },
		Device { id: 0x75BA, name: "PXI-2543" },
		Device { id: 0x75BB, name: "PXIe-2543" },
		Device { id: 0x75E5, name: "PXI-6683" },
		Device { id: 0x75E6, name: "PXI-6683H" },
		Device { id: 0x75EF, name: "PXIe-5632" },
		Device { id: 0x761C, name: "VXI-8360LT" },
		Device { id: 0x761F, name: "PXI-2540" },
		Device { id: 0x7620, name: "PXIe-2540" },
		Device { id: 0x7621, name: "PXI-2541" },
		Device { id: 0x7622, name: "PXIe-2541" },
		Device { id: 0x7626, name: "NI 9154" },
		Device { id: 0x7627, name: "NI 9155" },
		Device { id: 0x7638, name: "PXI-2720" },
		Device { id: 0x7639, name: "PXI-2722" },
		Device { id: 0x763A, name: "PXIe-2725" },
		Device { id: 0x763B, name: "PXIe-2727" },
		Device { id: 0x763C, name: "PXI-4465" },
		Device { id: 0x764B, name: "PXIe-2790" },
		Device { id: 0x764C, name: "PXI-2520" },
		Device { id: 0x764D, name: "PXI-2521" },
		Device { id: 0x764E, name: "PXI-2522" },
		Device { id: 0x764F, name: "PXI-2523" },
		Device { id: 0x7654, name: "PXI-2796" },
		Device { id: 0x7655, name: "PXI-2797" },
		Device { id: 0x7656, name: "PXI-2798" },
		Device { id: 0x7657, name: "PXI-2799" },
		Device { id: 0x765D, name: "PXI-2542" },
		Device { id: 0x765E, name: "PXIe-2542" },
		Device { id: 0x765F, name: "PXI-2544" },
		Device { id: 0x7660, name: "PXIe-2544" },
		Device { id: 0x766D, name: "PCIe-6535B" },
		Device { id: 0x766E, name: "PCIe-6536B" },
		Device { id: 0x766F, name: "PCIe-6537B" },
		Device { id: 0x76A3, name: "PXIe-6535B" },
		Device { id: 0x76A4, name: "PXIe-6536B" },
		Device { id: 0x76A5, name: "PXIe-6537B" },
		Device { id: 0x783E, name: "PXI-8368" },
		Device { id: 0x9020, name: "PXI-2501" },
		Device { id: 0x9030, name: "PXI-2503" },
		Device { id: 0x9040, name: "PXI-2527" },
		Device { id: 0x9050, name: "PXI-2565" },
		Device { id: 0x9060, name: "PXI-2590" },
		Device { id: 0x9070, name: "PXI-2591" },
		Device { id: 0x9080, name: "PXI-2580" },
		Device { id: 0x9090, name: "PCI-4021" },
		Device { id: 0x90A0, name: "PXI-4021" },
		Device { id: 0xA001, name: "PCI-MXI-2" },
		Device { id: 0xB001, name: "PCI-1408" },
		Device { id: 0xB011, name: "PXI-1408" },
		Device { id: 0xB021, name: "PCI-1424" },
		Device { id: 0xB022, name: "PXI-1424" },
		Device { id: 0xB031, name: "PCI-1413" },
		Device { id: 0xB041, name: "PCI-1407" },
		Device { id: 0xB051, name: "PXI-1407" },
		Device { id: 0xB061, name: "PCI-1411" },
		Device { id: 0xB071, name: "PCI-1422" },
		Device { id: 0xB081, name: "PXI-1422" },
		Device { id: 0xB091, name: "PXI-1411" },
		Device { id: 0xB0B1, name: "PCI-1409" },
		Device { id: 0xB0C1, name: "PXI-1409" },
		Device { id: 0xB0E1, name: "PCI-1428" },
		Device { id: 0xC4C4, name: "PXIe/PCIe Device" },
		Device { id: 0xC801, name: "PCI-GPIB" },
		Device { id: 0xC811, name: "PCI-GPIB+" },
		Device { id: 0xC821, name: "PXI-GPIB" },
		Device { id: 0xC831, name: "PMC-GPIB" },
		Device { id: 0xC840, name: "PCI-GPIB" },
		Device { id: 0xD130, name: "PCI-232/2 Interface" },
		Device { id: 0xD140, name: "PCI-232/4 Interface" },
		Device { id: 0xD150, name: "PCI-232/8 Interface" },
		Device { id: 0xD160, name: "PCI-485/2 Interface" },
		Device { id: 0xD170, name: "PCI-485/4 Interface" },
		Device { id: 0xD190, name: "PXI-8422/2 (Isolated RS-232) Interface" },
		Device { id: 0xD1A0, name: "PXI-8422/4 (Isolated RS-232) Interface" },
		Device { id: 0xD1B0, name: "PXI-8423/2 (Isolated RS-485) Interface" },
		Device { id: 0xD1C0, name: "PXI-8423/4 (Isolated RS-485) Interface" },
		Device { id: 0xD1D0, name: "PXI-8420/2 (RS-232) Interface" },
		Device { id: 0xD1E0, name: "PXI-8420/4 (RS-232) Interface" },
		Device { id: 0xD1F0, name: "PXI-8420/8 (RS-232) Interface" },
		Device { id: 0xD1F1, name: "PXI-8420/16 (RS-232) Interface" },
		Device { id: 0xD230, name: "PXI-8421/2 (RS-485) Interface" },
		Device { id: 0xD240, name: "PXI-8421/4 (RS-485) Interface" },
		Device { id: 0xD250, name: "PCI-232/2 (Isolated) Interface" },
		Device { id: 0xD260, name: "PCI-485/2 (Isolated) Interface" },
		Device { id: 0xD270, name: "PCI-232/4 (Isolated) Interface" },
		Device { id: 0xD280, name: "PCI-485/4 (Isolated) Interface" },
		Device { id: 0xD290, name: "PCI-485/8 Interface" },
		Device { id: 0xD2A0, name: "PXI-8421/8 (RS-485) Interface" },
		Device { id: 0xD2B0, name: "PCI-232/16 Interface" },
		Device { id: 0xE111, name: "PCI-CAN" },
		Device { id: 0xE131, name: "PXI-8461 (1 port)" },
		Device { id: 0xE141, name: "PCI-CAN/LS" },
		Device { id: 0xE151, name: "PXI-8460 (1 port)" },
		Device { id: 0xE211, name: "PCI-CAN/2" },
		Device { id: 0xE231, name: "PXI-8461 (2 ports)" },
		Device { id: 0xE241, name: "PCI-CAN/LS2" },
		Device { id: 0xE251, name: "PXI-8460 (2 ports)" },
		Device { id: 0xE261, name: "PCI-CAN/DS" },
		Device { id: 0xE271, name: "PXI-8462" },
		Device { id: 0xF110, name: "VMEpc-650" },
		Device { id: 0xF120, name: "VXIpc-650" },
		Device { id: 0xFE00, name: "VXIpc-87x" },
		Device { id: 0xFE41, name: "VXIpc-860" },
		Device { id: 0xFE51, name: "VXIpc-74x" },
		Device { id: 0xFE61, name: "VXIpc-850" },
		Device { id: 0xFE70, name: "VXIpc-880" },
	] },
	Vendor { id: 0x1094, name: "First International Computers [FIC]", devices: &[
	] },
	Vendor { id: 0x1095, name: "Silicon Image, Inc.", devices: &[
		Device { id: 0x0240, name: "Adaptec AAR-1210SA SATA HostRAID Controller" },
		Device { id: 0x0640, name: "PCI0640" },
		Device { id: 0x0643, name: "PCI0643" },
		Device { id: 0x0646, name: "PCI0646" },
		Device { id: 0x0647, name: "PCI0647" },
		Device { id: 0x0648, name: "PCI0648" },
		Device { id: 0x0649, name: "SiI 0649 Ultra ATA/100 PCI to ATA Host Controller" },
		Device { id: 0x0650, name: "PBC0650A" },
		Device { id: 0x0670, name: "USB0670" },
		Device { id: 0x0673, name: "USB0673" },
		Device { id: 0x0680, name: "PCI0680 Ultra ATA-133 Host Controller" },
		Device { id: 0x3112, name: "SiI 3112 [SATALink/SATARaid] Serial ATA Controller" },
		Device { id: 0x3114, name: "SiI 3114 [SATALink/SATARaid] Serial ATA Controller" },
		Device { id: 0x3124, name: "SiI 3124 PCI-X Serial ATA Controller" },
		Device { id: 0x3132, name: "SiI 3132 Serial ATA Raid II Controller" },
		Device { id: 0x3512, name: "SiI 3512 [SATALink/SATARaid] Serial ATA Controller" },
		Device { id: 0x3531, name: "SiI 3531 [SATALink/SATARaid] Serial ATA Controller" },
	] },
	Vendor { id: 0x1096, name: "Alacron", devices: &[
	] },
	Vendor { id: 0x1097, name: "Appian Technology", devices: &[
	] },
	Vendor { id: 0x1098, name: "Quantum Designs (H.K.) Ltd", devices: &[
		Device { id: 0x0001, name: "QD-8500" },
		Device { id: 0x0002, name: "QD-8580" },
	] },
	Vendor { id: 0x1099, name: "Samsung Electronics Co., Ltd", devices: &[
	] },
	Vendor { id: 0x109A, name: "Packard Bell", devices: &[
	] },
	Vendor { id: 0x109B, name: "Gemlight Computer Ltd.", devices: &[
	] },
	Vendor { id: 0x109C, name: "Megachips Corporation", devices: &[
	] },
	Vendor { id: 0x109D, name: "Zida Technologies Ltd.", devices: &[
	] },
	Vendor { id: 0x109E, name: "Brooktree Corporation", devices: &[
		Device { id: 0x0310, name: "Bt848 Video Capture" },
		Device { id: 0x032E, name: "Bt878 Video Capture" },
		Device { id: 0x0350, name: "Bt848 Video Capture" },
		Device { id: 0x0351, name: "Bt849A Video capture" },
		Device { id: 0x0369, name: "Bt878 Video Capture" },
		Device { id: 0x036C, name: "Bt879(??) Video Capture" },
		Device { id: 0x036E, name: "Bt878 Video Capture" },
		Device { id: 0x036F, name: "Bt879 Video Capture" },
		Device { id: 0x0370, name: "Bt880 Video Capture" },
		Device { id: 0x0878, name: "Bt878 Audio Capture" },
		Device { id: 0x0879, name: "Bt879 Audio Capture" },
		Device { id: 0x0880, name: "Bt880 Audio Capture" },
		Device { id: 0x2115, name: "BtV 2115 Mediastream controller" },
		Device { id: 0x2125, name: "BtV 2125 Mediastream controller" },
		Device { id: 0x2164, name: "BtV 2164" },
		Device { id: 0x2165, name: "BtV 2165" },
		Device { id: 0x8230, name: "Bt8230 ATM Segment/Reassembly Ctrlr (SRC)" },
		Device { id: 0x8472, name: "Bt8472" },
		Device { id: 0x8474, name: "Bt8474" },
	] },
	Vendor { id: 0x109F, name: "Trigem Computer Inc.", devices: &[
	] },
	Vendor { id: 0x10A0, name: "Meidensha Corporation", devices: &[
	] },
	Vendor { id: 0x10A1, name: "Juko Electronics Ind. Co. Ltd", devices: &[
	] },
	Vendor { id: 0x10A2, name: "Quantum Corporation", devices: &[
	] },
	Vendor { id: 0x10A3, name: "Everex Systems Inc", devices: &[
	] },
	Vendor { id: 0x10A4, name: "Globe Manufacturing Sales", devices: &[
	] },
	Vendor { id: 0x10A5, name: "Smart Link Ltd.", devices: &[
		Device { id: 0x3052, name: "SmartPCI562 56K Modem" },
		Device { id: 0x5449, name: "SmartPCI561 modem" },
	] },
	Vendor { id: 0x10A6, name: "Informtech Industrial Ltd.", devices: &[
	] },
	Vendor { id: 0x10A7, name: "Benchmarq Microelectronics", devices: &[
	] },
	Vendor { id: 0x10A8, name: "Sierra Semiconductor", devices: &[
		Device { id: 0x0000, name: "STB Horizon 64" },
	] },
	Vendor { id: 0x10A9, name: "Silicon Graphics Intl. Corp.", devices: &[
		Device { id: 0x0001, name: "Crosstalk to PCI Bridge" },
		Device { id: 0x0002, name: "Linc I/O controller" },
		Device { id: 0x0003, name: "IOC3 I/O controller" },
		Device { id: 0x0004, name: "O2 MACE" },
		Device { id: 0x0005, name: "RAD Audio" },
		Device { id: 0x0006, name: "HPCEX" },
		Device { id: 0x0007, name: "RPCEX" },
		Device { id: 0x0008, name: "DiVO VIP" },
		Device { id: 0x0009, name: "AceNIC Gigabit Ethernet" },
		Device { id: 0x0010, name: "AMP Video I/O" },
		Device { id: 0x0011, name: "GRIP" },
		Device { id: 0x0012, name: "SGH PSHAC GSN" },
		Device { id: 0x0208, name: "SSIM1 SAS Adapter" },
		Device { id: 0x1001, name: "Magic Carpet" },
		Device { id: 0x1002, name: "Lithium" },
		Device { id: 0x1003, name: "Dual JPEG 1" },
		Device { id: 0x1004, name: "Dual JPEG 2" },
		Device { id: 0x1005, name: "Dual JPEG 3" },
		Device { id: 0x1006, name: "Dual JPEG 4" },
		Device { id: 0x1007, name: "Dual JPEG 5" },
		Device { id: 0x1008, name: "Cesium" },
		Device { id: 0x100A, name: "IOC4 I/O controller" },
		Device { id: 0x1504, name: "SSIM1 Fibre Channel Adapter" },
		Device { id: 0x2001, name: "Fibre Channel" },
		Device { id: 0x2002, name: "ASDE" },
		Device { id: 0x4001, name: "TIO-CE PCI Express Bridge" },
		Device { id: 0x4002, name: "TIO-CE PCI Express Port" },
		Device { id: 0x8001, name: "O2 1394" },
		Device { id: 0x8002, name: "G-net NT" },
		Device { id: 0x802B, name: "REACT external interrupt controller" },
	] },
	Vendor { id: 0x10AA, name: "ACC Microelectronics", devices: &[
		Device { id: 0x0000, name: "ACCM 2188" },
		Device { id: 0x2051, name: "2051 CPU bridge" },
		Device { id: 0x5842, name: "2051 ISA bridge" },
	] },
	Vendor { id: 0x10AB, name: "Digicom", devices: &[
	] },
	Vendor { id: 0x10AC, name: "Honeywell IAC", devices: &[
	] },
	Vendor { id: 0x10AD, name: "Symphony Labs", devices: &[
		Device { id: 0x0001, name: "W83769F" },
		Device { id: 0x0003, name: "SL82C103" },
		Device { id: 0x0005, name: "SL82C105" },
		Device { id: 0x0103, name: "SL82c103" },
		Device { id: 0x0105, name: "SL82c105" },
		Device { id: 0x0565, name: "W83C553F/W83C554F" },
	] },
	Vendor { id: 0x10AE, name: "Cornerstone Technology", devices: &[
	] },
	Vendor { id: 0x10AF, name: "Micro Computer Systems Inc", devices: &[
	] },
	Vendor { id: 0x10B0, name: "CardExpert Technology", devices: &[
	] },
	Vendor { id: 0x10B1, name: "Cabletron Systems Inc", devices: &[
	] },
	Vendor { id: 0x10B2, name: "Raytheon Company", devices: &[
	] },
	Vendor { id: 0x10B3, name: "Databook Inc", devices: &[
		Device { id: 0x3106, name: "DB87144" },
		Device { id: 0xB106, name: "DB87144" },
	] },
	Vendor { id: 0x10B4, name: "STB Systems Inc", devices: &[
		Device { id: 0x1B1D, name: "Velocity 128 3D" },
	] },
	Vendor { id: 0x10B5, name: "PLX Technology, Inc.", devices: &[
		Device { id: 0x0001, name: "i960 PCI bus interface" },
		Device { id: 0x0557, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x1000, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x1024, name: "Acromag, Inc. IndustryPack Carrier Card" },
		Device { id: 0x1042, name: "Brandywine / jxi2, Inc. - PMC-SyncClock32, IRIG A & B, Nasa 36" },
		Device { id: 0x106A, name: "Dual OX16C952 4 port serial adapter [Megawolf Romulus/4]" },
		Device { id: 0x1076, name: "VScom 800 8 port serial adaptor" },
		Device { id: 0x1077, name: "VScom 400 4 port serial adaptor" },
		Device { id: 0x1078, name: "VScom 210 2 port serial and 1 port parallel adaptor" },
		Device { id: 0x1103, name: "VScom 200 2 port serial adaptor" },
		Device { id: 0x1146, name: "VScom 010 1 port parallel adaptor" },
		Device { id: 0x1147, name: "VScom 020 2 port parallel adaptor" },
		Device { id: 0x2000, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x2540, name: "IXXAT CAN-Interface PC-I 04/PCI" },
		Device { id: 0x2724, name: "Thales PCSM Security Card" },
		Device { id: 0x3376, name: "Cosateq 4 Port CAN Card" },
		Device { id: 0x4000, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x4001, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x4002, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x6140, name: "PCI6140 32-bit 33MHz PCI-to-PCI Bridge" },
		Device { id: 0x6150, name: "PCI6150 32-bit 33MHz PCI-to-PCI Bridge" },
		Device { id: 0x6152, name: "PCI6152 32-bit 66MHz PCI-to-PCI Bridge" },
		Device { id: 0x6154, name: "PCI6154 64-bit 66MHz PCI-to-PCI Bridge" },
		Device { id: 0x6254, name: "PCI6254 64-bit 66MHz PCI-to-PCI Bridge" },
		Device { id: 0x6466, name: "PCI6466 64-bit 66MHz PCI-to-PCI Bridge" },
		Device { id: 0x6520, name: "PCI6520 64-bit 133MHz PCI-X-to-PCI-X Bridge" },
		Device { id: 0x6540, name: "PCI6540 64-bit 133MHz PCI-X-to-PCI-X Bridge" },
		Device { id: 0x6541, name: "PCI6540/6466 PCI-PCI bridge (non-transparent mode, primary side)" },
		Device { id: 0x6542, name: "PCI6540/6466 PCI-PCI bridge (non-transparent mode, secondary side)" },
		Device { id: 0x8111, name: "PEX 8111 PCI Express-to-PCI Bridge" },
		Device { id: 0x8112, name: "PEX8112 x1 Lane PCI Express-to-PCI Bridge" },
		Device { id: 0x8114, name: "PEX 8114 PCI Express-to-PCI/PCI-X Bridge" },
		Device { id: 0x8311, name: "PEX8311 x1 Lane PCI Express-to-Generic Local Bus Bridge" },
		Device { id: 0x8505, name: "PEX 8505 5-lane, 5-port PCI Express Switch" },
		Device { id: 0x8508, name: "PEX 8508 8-lane, 5-port PCI Express Switch" },
		Device { id: 0x8509, name: "PEX 8509 8-lane, 8-port PCI Express Switch" },
		Device { id: 0x8512, name: "PEX 8512 12-lane, 5-port PCI Express Switch" },
		Device { id: 0x8516, name: "PEX 8516  Versatile PCI Express Switch" },
		Device { id: 0x8517, name: "PEX 8517 16-lane, 5-port PCI Express Switch" },
		Device { id: 0x8518, name: "PEX 8518 16-lane, 5-port PCI Express Switch" },
		Device { id: 0x8524, name: "PEX 8524 24-lane, 6-port PCI Express Switch" },
		Device { id: 0x8525, name: "PEX 8525 24-lane, 5-port PCI Express Switch" },
		Device { id: 0x8532, name: "PEX 8532  Versatile PCI Express Switch" },
		Device { id: 0x8533, name: "PEX 8533 32-lane, 6-port PCI Express Switch" },
		Device { id: 0x8547, name: "PEX 8547 48-lane, 3-port PCI Express Switch" },
		Device { id: 0x8548, name: "PEX 8548 48-lane, 9-port PCI Express Switch" },
		Device { id: 0x8603, name: "PEX 8603 3-lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8604, name: "PEX 8604 4-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8605, name: "PEX 8605 PCI Express 4-port Gen2 Switch" },
		Device { id: 0x8606, name: "PEX 8606 6 Lane, 6 Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8608, name: "PEX 8608 8-lane, 8-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8609, name: "PEX 8609 8-lane, 8-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA" },
		Device { id: 0x8612, name: "PEX 8612 12-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8613, name: "PEX 8613 12-lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8614, name: "PEX 8614 12-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8615, name: "PEX 8615 12-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA" },
		Device { id: 0x8616, name: "PEX 8616 16-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8617, name: "PEX 8617 16-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch with P2P" },
		Device { id: 0x8618, name: "PEX 8618 16-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8619, name: "PEX 8619 16-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA" },
		Device { id: 0x8624, name: "PEX 8624 24-lane, 6-Port PCI Express Gen 2 (5.0 GT/s) Switch [ExpressLane]" },
		Device { id: 0x8625, name: "PEX 8625 24-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8632, name: "PEX 8632 32-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8636, name: "PEX 8636 36-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8647, name: "PEX 8647 48-Lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8648, name: "PEX 8648 48-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8649, name: "PEX 8649 48-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8664, name: "PEX 8664 64-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch" },
		Device { id: 0x8680, name: "PEX 8680 80-lane, 20-Port PCI Express Gen 2 (5.0 GT/s) Multi-Root Switch" },
		Device { id: 0x8696, name: "PEX 8696 96-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Multi-Root Switch" },
		Device { id: 0x8717, name: "PEX 8717 16-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch with DMA" },
		Device { id: 0x8718, name: "PEX 8718 16-Lane, 5-Port PCI Express Gen 3 (8.0 GT/s) Switch" },
		Device { id: 0x8724, name: "PEX 8724 24-Lane, 6-Port PCI Express Gen 3 (8 GT/s) Switch, 19 x 19mm FCBGA" },
		Device { id: 0x8732, name: "PEX 8732 32-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch" },
		Device { id: 0x8734, name: "PEX 8734 32-lane, 8-Port PCI Express Gen 3 (8.0GT/s) Switch" },
		Device { id: 0x8747, name: "PEX 8747 48-Lane, 5-Port PCI Express Gen 3 (8.0 GT/s) Switch" },
		Device { id: 0x8748, name: "PEX 8748 48-Lane, 12-Port PCI Express Gen 3 (8 GT/s) Switch, 27 x 27mm FCBGA" },
		Device { id: 0x87B0, name: "PEX 8732 32-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch" },
		Device { id: 0x9016, name: "PLX 9016 8-port serial controller" },
		Device { id: 0x9030, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x9036, name: "9036" },
		Device { id: 0x9050, name: "PCI <-> IOBus Bridge" },
		Device { id: 0x9052, name: "PCI9052 PCI <-> IOBus Bridge" },
		Device { id: 0x9054, name: "PCI9054 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x9056, name: "PCI9056 32-bit 66MHz PCI <-> IOBus Bridge" },
		Device { id: 0x9060, name: "PCI9060 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x906D, name: "9060SD" },
		Device { id: 0x906E, name: "9060ES" },
		Device { id: 0x9080, name: "PCI9080 32-bit; 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0x9656, name: "PCI9656 PCI <-> IOBus Bridge" },
		Device { id: 0x9733, name: "PEX 9733 33-lane, 9-port PCI Express Gen 3 (8.0 GT/s) Switch" },
		Device { id: 0x9749, name: "PEX 9749 49-lane, 13-port PCI Express Gen 3 (8.0 GT/s) Switch" },
		Device { id: 0xA100, name: "Blackmagic Design DeckLink" },
		Device { id: 0xBB04, name: "B&B 3PCIOSD1A Isolated PCI Serial" },
		Device { id: 0xC001, name: "CronyxOmega-PCI (8-port RS232)" },
		Device { id: 0xD00D, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0xD33D, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
		Device { id: 0xD44D, name: "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge" },
	] },
	Vendor { id: 0x10B6, name: "Madge Networks", devices: &[
		Device { id: 0x0001, name: "Smart 16/4 PCI Ringnode" },
		Device { id: 0x0002, name: "Smart 16/4 PCI Ringnode Mk2" },
		Device { id: 0x0003, name: "Smart 16/4 PCI Ringnode Mk3" },
		Device { id: 0x0004, name: "Smart 16/4 PCI Ringnode Mk1" },
		Device { id: 0x0006, name: "16/4 Cardbus Adapter" },
		Device { id: 0x0007, name: "Presto PCI Adapter" },
		Device { id: 0x0009, name: "Smart 100/16/4 PCI-HS Ringnode" },
		Device { id: 0x000A, name: "Token Ring 100/16/4 Ringnode/Ringrunner" },
		Device { id: 0x000B, name: "16/4 CardBus Adapter Mk2" },
		Device { id: 0x000C, name: "RapidFire 3140V2 16/4 TR Adapter" },
		Device { id: 0x1000, name: "Collage 25/155 ATM Client Adapter" },
		Device { id: 0x1001, name: "Collage 155 ATM Server Adapter" },
	] },
	Vendor { id: 0x10B7, name: "3Com Corporation", devices: &[
		Device { id: 0x0001, name: "3c985 1000BaseSX (SX/TX)" },
		Device { id: 0x0013, name: "AR5212 802.11abg NIC (3CRDAG675)" },
		Device { id: 0x0910, name: "3C910-A01" },
		Device { id: 0x1006, name: "MINI PCI type 3B Data Fax Modem" },
		Device { id: 0x1007, name: "Mini PCI 56k Winmodem" },
		Device { id: 0x1201, name: "3c982-TXM 10/100baseTX Dual Port A [Hydra]" },
		Device { id: 0x1202, name: "3c982-TXM 10/100baseTX Dual Port B [Hydra]" },
		Device { id: 0x1700, name: "3c940 10/100/1000Base-T [Marvell]" },
		Device { id: 0x3390, name: "3c339 TokenLink Velocity" },
		Device { id: 0x3590, name: "3c359 TokenLink Velocity XL" },
		Device { id: 0x4500, name: "3c450 HomePNA [Tornado]" },
		Device { id: 0x5055, name: "3c555 Laptop Hurricane" },
		Device { id: 0x5057, name: "3c575 Megahertz 10/100 LAN CardBus [Boomerang]" },
		Device { id: 0x5157, name: "3cCFE575BT Megahertz 10/100 LAN CardBus [Cyclone]" },
		Device { id: 0x5257, name: "3cCFE575CT CardBus [Cyclone]" },
		Device { id: 0x5900, name: "3c590 10BaseT [Vortex]" },
		Device { id: 0x5920, name: "3c592 EISA 10mbps Demon/Vortex" },
		Device { id: 0x5950, name: "3c595 100BaseTX [Vortex]" },
		Device { id: 0x5951, name: "3c595 100BaseT4 [Vortex]" },
		Device { id: 0x5952, name: "3c595 100Base-MII [Vortex]" },
		Device { id: 0x5970, name: "3c597 EISA Fast Demon/Vortex" },
		Device { id: 0x5B57, name: "3c595 Megahertz 10/100 LAN CardBus [Boomerang]" },
		Device { id: 0x6000, name: "3CRSHPW796 [OfficeConnect Wireless CardBus]" },
		Device { id: 0x6001, name: "3com 3CRWE154G72 [Office Connect Wireless LAN Adapter]" },
		Device { id: 0x6055, name: "3c556 Hurricane CardBus [Cyclone]" },
		Device { id: 0x6056, name: "3c556B CardBus [Tornado]" },
		Device { id: 0x6560, name: "3cCFE656 CardBus [Cyclone]" },
		Device { id: 0x6561, name: "3cCFEM656 10/100 LAN+56K Modem CardBus" },
		Device { id: 0x6562, name: "3cCFEM656B 10/100 LAN+Winmodem CardBus [Cyclone]" },
		Device { id: 0x6563, name: "3cCFEM656B 10/100 LAN+56K Modem CardBus" },
		Device { id: 0x6564, name: "3cXFEM656C 10/100 LAN+Winmodem CardBus [Tornado]" },
		Device { id: 0x7646, name: "3cSOHO100-TX Hurricane" },
		Device { id: 0x7770, name: "3CRWE777 PCI Wireless Adapter [Airconnect]" },
		Device { id: 0x7940, name: "3c803 FDDILink UTP Controller" },
		Device { id: 0x7980, name: "3c804 FDDILink SAS Controller" },
		Device { id: 0x7990, name: "3c805 FDDILink DAS Controller" },
		Device { id: 0x80EB, name: "3c940B 10/100/1000Base-T" },
		Device { id: 0x8811, name: "Token ring" },
		Device { id: 0x9000, name: "3c900 10BaseT [Boomerang]" },
		Device { id: 0x9001, name: "3c900 10Mbps Combo [Boomerang]" },
		Device { id: 0x9004, name: "3c900B-TPO Etherlink XL [Cyclone]" },
		Device { id: 0x9005, name: "3c900B-Combo Etherlink XL [Cyclone]" },
		Device { id: 0x9006, name: "3c900B-TPC Etherlink XL [Cyclone]" },
		Device { id: 0x900A, name: "3c900B-FL 10base-FL [Cyclone]" },
		Device { id: 0x9050, name: "3c905 100BaseTX [Boomerang]" },
		Device { id: 0x9051, name: "3c905 100BaseT4 [Boomerang]" },
		Device { id: 0x9054, name: "3C905B-TX Fast Etherlink XL PCI" },
		Device { id: 0x9055, name: "3c905B 100BaseTX [Cyclone]" },
		Device { id: 0x9056, name: "3c905B-T4 Fast EtherLink XL [Cyclone]" },
		Device { id: 0x9058, name: "3c905B Deluxe Etherlink 10/100/BNC [Cyclone]" },
		Device { id: 0x905A, name: "3c905B-FX Fast Etherlink XL FX 100baseFx [Cyclone]" },
		Device { id: 0x9200, name: "3c905C-TX/TX-M [Tornado]" },
		Device { id: 0x9201, name: "3C920B-EMB Integrated Fast Ethernet Controller [Tornado]" },
		Device { id: 0x9202, name: "3Com 3C920B-EMB-WNM Integrated Fast Ethernet Controller" },
		Device { id: 0x9210, name: "3C920B-EMB-WNM Integrated Fast Ethernet Controller" },
		Device { id: 0x9300, name: "3CSOHO100B-TX 910-A01 [tulip]" },
		Device { id: 0x9800, name: "3c980-TX Fast Etherlink XL Server Adapter [Cyclone]" },
		Device { id: 0x9805, name: "3c980-C 10/100baseTX NIC [Python-T]" },
		Device { id: 0x9900, name: "3C990-TX [Typhoon]" },
		Device { id: 0x9902, name: "3CR990-TX-95 [Typhoon 56-bit]" },
		Device { id: 0x9903, name: "3CR990-TX-97 [Typhoon 168-bit]" },
		Device { id: 0x9904, name: "3C990B-TX-M/3C990BSVR [Typhoon2]" },
		Device { id: 0x9905, name: "3CR990-FX-95/97/95 [Typhon Fiber]" },
		Device { id: 0x9908, name: "3CR990SVR95 [Typhoon Server 56-bit]" },
		Device { id: 0x9909, name: "3CR990SVR97 [Typhoon Server 168-bit]" },
		Device { id: 0x990A, name: "3C990SVR [Typhoon Server]" },
		Device { id: 0x990B, name: "3C990SVR [Typhoon Server]" },
	] },
	Vendor { id: 0x10B8, name: "Standard Microsystems Corp [SMC]", devices: &[
		Device { id: 0x0005, name: "83c170 EPIC/100 Fast Ethernet Adapter" },
		Device { id: 0x0006, name: "83c175 EPIC/100 Fast Ethernet Adapter" },
		Device { id: 0x1000, name: "FDC 37c665" },
		Device { id: 0x1001, name: "FDC 37C922" },
		Device { id: 0xA011, name: "83C170QF" },
		Device { id: 0xB106, name: "SMC34C90" },
	] },
	Vendor { id: 0x10B9, name: "ULi Electronics Inc.", devices: &[
		Device { id: 0x0101, name: "CMI8338/C3DX PCI Audio Device" },
		Device { id: 0x0111, name: "C-Media CMI8738/C3DX Audio Device (OEM)" },
		Device { id: 0x0780, name: "Multi-IO Card" },
		Device { id: 0x0782, name: "Multi-IO Card" },
		Device { id: 0x1435, name: "M1435" },
		Device { id: 0x1445, name: "M1445" },
		Device { id: 0x1449, name: "M1449" },
		Device { id: 0x1451, name: "M1451" },
		Device { id: 0x1461, name: "M1461" },
		Device { id: 0x1489, name: "M1489" },
		Device { id: 0x1511, name: "M1511 [Aladdin]" },
		Device { id: 0x1512, name: "M1512 [Aladdin]" },
		Device { id: 0x1513, name: "M1513 [Aladdin]" },
		Device { id: 0x1521, name: "M1521 [Aladdin III]" },
		Device { id: 0x1523, name: "M1523" },
		Device { id: 0x1531, name: "M1531 [Aladdin IV]" },
		Device { id: 0x1533, name: "M1533/M1535/M1543 PCI to ISA Bridge [Aladdin IV/V/V+]" },
		Device { id: 0x1541, name: "M1541" },
		Device { id: 0x1543, name: "M1543" },
		Device { id: 0x1563, name: "M1563 HyperTransport South Bridge" },
		Device { id: 0x1573, name: "PCI to LPC Controller" },
		Device { id: 0x1575, name: "M1575 South Bridge" },
		Device { id: 0x1621, name: "M1621" },
		Device { id: 0x1631, name: "ALI M1631 PCI North Bridge Aladdin Pro III" },
		Device { id: 0x1632, name: "M1632M Northbridge+Trident" },
		Device { id: 0x1641, name: "ALI M1641 PCI North Bridge Aladdin Pro IV" },
		Device { id: 0x1644, name: "M1644/M1644T Northbridge+Trident" },
		Device { id: 0x1646, name: "M1646 Northbridge+Trident" },
		Device { id: 0x1647, name: "M1647 Northbridge [MAGiK 1 / MobileMAGiK 1]" },
		Device { id: 0x1651, name: "M1651/M1651T Northbridge [Aladdin-Pro 5/5M,Aladdin-Pro 5T/5TM]" },
		Device { id: 0x1671, name: "M1671 Super P4 Northbridge [AGP4X,PCI and SDR/DDR]" },
		Device { id: 0x1672, name: "M1672 Northbridge [CyberALADDiN-P4]" },
		Device { id: 0x1681, name: "M1681 P4 Northbridge [AGP8X,HyperTransport and SDR/DDR]" },
		Device { id: 0x1687, name: "M1687 K8 Northbridge [AGP8X and HyperTransport]" },
		Device { id: 0x1689, name: "M1689 K8 Northbridge [Super K8 Single Chip]" },
		Device { id: 0x1695, name: "M1695 Host Bridge" },
		Device { id: 0x1697, name: "M1697 HTT Host Bridge" },
		Device { id: 0x3141, name: "M3141" },
		Device { id: 0x3143, name: "M3143" },
		Device { id: 0x3145, name: "M3145" },
		Device { id: 0x3147, name: "M3147" },
		Device { id: 0x3149, name: "M3149" },
		Device { id: 0x3151, name: "M3151" },
		Device { id: 0x3307, name: "M3307" },
		Device { id: 0x3309, name: "M3309" },
		Device { id: 0x3323, name: "M3325 Video/Audio Decoder" },
		Device { id: 0x5212, name: "M4803" },
		Device { id: 0x5215, name: "MS4803" },
		Device { id: 0x5217, name: "M5217H" },
		Device { id: 0x5219, name: "M5219" },
		Device { id: 0x5225, name: "M5225" },
		Device { id: 0x5228, name: "M5228 ALi ATA/RAID Controller" },
		Device { id: 0x5229, name: "M5229 IDE" },
		Device { id: 0x5235, name: "M5225" },
		Device { id: 0x5237, name: "USB 1.1 Controller" },
		Device { id: 0x5239, name: "USB 2.0 Controller" },
		Device { id: 0x5243, name: "M1541 PCI to AGP Controller" },
		Device { id: 0x5246, name: "AGP8X Controller" },
		Device { id: 0x5247, name: "PCI to AGP Controller" },
		Device { id: 0x5249, name: "M5249 HTT to PCI Bridge" },
		Device { id: 0x524B, name: "PCI Express Root Port" },
		Device { id: 0x524C, name: "PCI Express Root Port" },
		Device { id: 0x524D, name: "PCI Express Root Port" },
		Device { id: 0x524E, name: "PCI Express Root Port" },
		Device { id: 0x5251, name: "M5251 P1394 OHCI 1.0 Controller" },
		Device { id: 0x5253, name: "M5253 P1394 OHCI 1.1 Controller" },
		Device { id: 0x5261, name: "M5261 Ethernet Controller" },
		Device { id: 0x5263, name: "ULi 1689,1573 integrated ethernet." },
		Device { id: 0x5281, name: "ALi M5281 Serial ATA / RAID Host Controller" },
		Device { id: 0x5287, name: "ULi 5287 SATA" },
		Device { id: 0x5288, name: "ULi M5288 SATA" },
		Device { id: 0x5289, name: "ULi 5289 SATA" },
		Device { id: 0x5450, name: "Lucent Technologies Soft Modem AMR" },
		Device { id: 0x5451, name: "M5451 PCI AC-Link Controller Audio Device" },
		Device { id: 0x5453, name: "M5453 PCI AC-Link Controller Modem Device" },
		Device { id: 0x5455, name: "M5455 PCI AC-Link Controller Audio Device" },
		Device { id: 0x5457, name: "M5457 AC'97 Modem Controller" },
		Device { id: 0x5459, name: "SmartLink SmartPCI561 56K Modem" },
		Device { id: 0x545A, name: "SmartLink SmartPCI563 56K Modem" },
		Device { id: 0x5461, name: "HD Audio Controller" },
		Device { id: 0x5471, name: "M5471 Memory Stick Controller" },
		Device { id: 0x5473, name: "M5473 SD-MMC Controller" },
		Device { id: 0x7101, name: "M7101 Power Management Controller [PMU]" },
	] },
	Vendor { id: 0x10BA, name: "Mitsubishi Electric Corp.", devices: &[
		Device { id: 0x0301, name: "AccelGraphics AccelECLIPSE" },
		Device { id: 0x0304, name: "AccelGALAXY A2100 [OEM Evans & Sutherland]" },
		Device { id: 0x0308, name: "Tornado 3000 [OEM Evans & Sutherland]" },
		Device { id: 0x1002, name: "VG500 [VolumePro Volume Rendering Accelerator]" },
	] },
	Vendor { id: 0x10BB, name: "Dapha Electronics Corporation", devices: &[
	] },
	Vendor { id: 0x10BC, name: "Advanced Logic Research", devices: &[
	] },
	Vendor { id: 0x10BD, name: "Surecom Technology", devices: &[
		Device { id: 0x0E34, name: "NE-34" },
	] },
	Vendor { id: 0x10BE, name: "Tseng Labs International Co.", devices: &[
	] },
	Vendor { id: 0x10BF, name: "Most Inc", devices: &[
	] },
	Vendor { id: 0x10C0, name: "Boca Research Inc.", devices: &[
	] },
	Vendor { id: 0x10C1, name: "ICM Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x10C2, name: "Auspex Systems Inc.", devices: &[
	] },
	Vendor { id: 0x10C3, name: "Samsung Semiconductors, Inc.", devices: &[
	] },
	Vendor { id: 0x10C4, name: "Award Software International Inc.", devices: &[
	] },
	Vendor { id: 0x10C5, name: "Xerox Corporation", devices: &[
	] },
	Vendor { id: 0x10C6, name: "Rambus Inc.", devices: &[
	] },
	Vendor { id: 0x10C7, name: "Media Vision", devices: &[
	] },
	Vendor { id: 0x10C8, name: "Neomagic Corporation", devices: &[
		Device { id: 0x0001, name: "NM2070 [MagicGraph 128]" },
		Device { id: 0x0002, name: "NM2090 [MagicGraph 128V]" },
		Device { id: 0x0003, name: "NM2093 [MagicGraph 128ZV]" },
		Device { id: 0x0004, name: "NM2160 [MagicGraph 128XD]" },
		Device { id: 0x0005, name: "NM2200 [MagicGraph 256AV]" },
		Device { id: 0x0006, name: "NM2360 [MagicMedia 256ZX]" },
		Device { id: 0x0016, name: "NM2380 [MagicMedia 256XL+]" },
		Device { id: 0x0025, name: "NM2230 [MagicGraph 256AV+]" },
		Device { id: 0x0083, name: "NM2093 [MagicGraph 128ZV+]" },
		Device { id: 0x8005, name: "NM2200 [MagicMedia 256AV Audio]" },
		Device { id: 0x8006, name: "NM2360 [MagicMedia 256ZX Audio]" },
		Device { id: 0x8016, name: "NM2380 [MagicMedia 256XL+ Audio]" },
	] },
	Vendor { id: 0x10C9, name: "Dataexpert Corporation", devices: &[
	] },
	Vendor { id: 0x10CA, name: "Fujitsu Microelectr., Inc.", devices: &[
	] },
	Vendor { id: 0x10CB, name: "Omron Corporation", devices: &[
	] },
	Vendor { id: 0x10CC, name: "Mai Logic Incorporated", devices: &[
		Device { id: 0x0660, name: "Articia S Host Bridge" },
		Device { id: 0x0661, name: "Articia S PCI Bridge" },
	] },
	Vendor { id: 0x10CD, name: "Advanced System Products, Inc", devices: &[
		Device { id: 0x1100, name: "ASC1100" },
		Device { id: 0x1200, name: "ASC1200 [(abp940) Fast SCSI-II]" },
		Device { id: 0x1300, name: "ASC1300 / ASC3030 [ABP940-U / ABP960-U / ABP3925]" },
		Device { id: 0x2300, name: "ABP940-UW" },
		Device { id: 0x2500, name: "ABP940-U2W" },
		Device { id: 0x2700, name: "ABP3950-U3W" },
	] },
	Vendor { id: 0x10CE, name: "Radius", devices: &[
	] },
	Vendor { id: 0x10CF, name: "Fujitsu Limited.", devices: &[
		Device { id: 0x01EF, name: "PCEA4 PCI-Express Dual Port ESCON Adapter" },
		Device { id: 0x1414, name: "On-board USB 1.1 companion controller" },
		Device { id: 0x1415, name: "On-board USB 2.0 EHCI controller" },
		Device { id: 0x1422, name: "E8410 nVidia graphics adapter" },
		Device { id: 0x142D, name: "HD audio (Realtek ALC262)" },
		Device { id: 0x1430, name: "82566MM Intel 1Gb copper LAN interface" },
		Device { id: 0x1623, name: "PCEA4 PCI-Express Dual Port ESCON Adapter" },
		Device { id: 0x2001, name: "mb86605" },
		Device { id: 0x200C, name: "MB86613L IEEE1394 OHCI 1.0 Controller" },
		Device { id: 0x2010, name: "MB86613S IEEE1394 OHCI 1.1 Controller" },
		Device { id: 0x2019, name: "MB86295S [CORAL P]" },
		Device { id: 0x201E, name: "MB86296S [CORAL PA]" },
		Device { id: 0x202B, name: "MB86297A [Carmine Graphics Controller]" },
	] },
	Vendor { id: 0x10D1, name: "FuturePlus Systems Corp.", devices: &[
	] },
	Vendor { id: 0x10D2, name: "Molex Incorporated", devices: &[
	] },
	Vendor { id: 0x10D3, name: "Jabil Circuit Inc", devices: &[
	] },
	Vendor { id: 0x10D4, name: "Hualon Microelectronics", devices: &[
	] },
	Vendor { id: 0x10D5, name: "Autologic Inc.", devices: &[
	] },
	Vendor { id: 0x10D6, name: "Cetia", devices: &[
	] },
	Vendor { id: 0x10D7, name: "BCM Advanced Research", devices: &[
	] },
	Vendor { id: 0x10D8, name: "Advanced Peripherals Labs", devices: &[
	] },
	Vendor { id: 0x10D9, name: "Macronix, Inc. [MXIC]", devices: &[
		Device { id: 0x0431, name: "MX98715" },
		Device { id: 0x0512, name: "MX98713" },
		Device { id: 0x0531, name: "MX987x5" },
		Device { id: 0x8625, name: "MX86250" },
		Device { id: 0x8626, name: "Macronix MX86251 + 3Dfx Voodoo Rush" },
		Device { id: 0x8888, name: "MX86200" },
	] },
	Vendor { id: 0x10DA, name: "Compaq IPG-Austin", devices: &[
		Device { id: 0x0508, name: "TC4048 Token Ring 4/16" },
		Device { id: 0x3390, name: "Tl3c3x9" },
	] },
	Vendor { id: 0x10DB, name: "Rohm LSI Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x10DC, name: "CERN/ECP/EDU", devices: &[
		Device { id: 0x0001, name: "STAR/RD24 SCI-PCI (PMC)" },
		Device { id: 0x0002, name: "TAR/RD24 SCI-PCI (PMC)" },
		Device { id: 0x0021, name: "HIPPI destination" },
		Device { id: 0x0022, name: "HIPPI source" },
		Device { id: 0x10DC, name: "ATT2C15-3 FPGA" },
	] },
	Vendor { id: 0x10DD, name: "Evans & Sutherland", devices: &[
		Device { id: 0x0100, name: "Lightning 1200" },
	] },
	Vendor { id: 0x10DE, name: "NVIDIA Corporation", devices: &[
		Device { id: 0x0008, name: "NV1 [EDGE 3D]" },
		Device { id: 0x0009, name: "NV1 [EDGE 3D]" },
		Device { id: 0x0020, name: "NV4 [Riva TNT]" },
		Device { id: 0x0028, name: "NV5 [Riva TNT2 / TNT2 Pro]" },
		Device { id: 0x0029, name: "NV5 [Riva TNT2 Ultra]" },
		Device { id: 0x002A, name: "NV5 [Riva TNT2]" },
		Device { id: 0x002B, name: "NV5 [Riva TNT2]" },
		Device { id: 0x002C, name: "NV5 [Vanta / Vanta LT]" },
		Device { id: 0x002D, name: "NV5 [Riva TNT2 Model 64 / Model 64 Pro]" },
		Device { id: 0x0034, name: "MCP04 SMBus" },
		Device { id: 0x0035, name: "MCP04 IDE" },
		Device { id: 0x0036, name: "MCP04 Serial ATA Controller" },
		Device { id: 0x0037, name: "MCP04 Ethernet Controller" },
		Device { id: 0x0038, name: "MCP04 Ethernet Controller" },
		Device { id: 0x003A, name: "MCP04 AC'97 Audio Controller" },
		Device { id: 0x003B, name: "MCP04 USB Controller" },
		Device { id: 0x003C, name: "MCP04 USB Controller" },
		Device { id: 0x003D, name: "MCP04 PCI Bridge" },
		Device { id: 0x003E, name: "MCP04 Serial ATA Controller" },
		Device { id: 0x0040, name: "NV40 [GeForce 6800 Ultra]" },
		Device { id: 0x0041, name: "NV40 [GeForce 6800]" },
		Device { id: 0x0042, name: "NV40 [GeForce 6800 LE]" },
		Device { id: 0x0043, name: "NV40 [GeForce 6800 XE]" },
		Device { id: 0x0044, name: "NV40 [GeForce 6800 XT]" },
		Device { id: 0x0045, name: "NV40 [GeForce 6800 GT]" },
		Device { id: 0x0047, name: "NV40 [GeForce 6800 GS]" },
		Device { id: 0x0048, name: "NV40 [GeForce 6800 XT]" },
		Device { id: 0x004E, name: "NV40GL [Quadro FX 4000]" },
		Device { id: 0x0050, name: "CK804 ISA Bridge" },
		Device { id: 0x0051, name: "CK804 ISA Bridge" },
		Device { id: 0x0052, name: "CK804 SMBus" },
		Device { id: 0x0053, name: "CK804 IDE" },
		Device { id: 0x0054, name: "CK804 Serial ATA Controller" },
		Device { id: 0x0055, name: "CK804 Serial ATA Controller" },
		Device { id: 0x0056, name: "CK804 Ethernet Controller" },
		Device { id: 0x0057, name: "CK804 Ethernet Controller" },
		Device { id: 0x0058, name: "CK804 AC'97 Modem" },
		Device { id: 0x0059, name: "CK804 AC'97 Audio Controller" },
		Device { id: 0x005A, name: "CK804 USB Controller" },
		Device { id: 0x005B, name: "CK804 USB Controller" },
		Device { id: 0x005C, name: "CK804 PCI Bridge" },
		Device { id: 0x005D, name: "CK804 PCIE Bridge" },
		Device { id: 0x005E, name: "CK804 Memory Controller" },
		Device { id: 0x005F, name: "CK804 Memory Controller" },
		Device { id: 0x0060, name: "nForce2 ISA Bridge" },
		Device { id: 0x0064, name: "nForce2 SMBus (MCP)" },
		Device { id: 0x0065, name: "nForce2 IDE" },
		Device { id: 0x0066, name: "nForce2 Ethernet Controller" },
		Device { id: 0x0067, name: "nForce2 USB Controller" },
		Device { id: 0x0068, name: "nForce2 USB Controller" },
		Device { id: 0x006A, name: "nForce2 AC97 Audio Controler (MCP)" },
		Device { id: 0x006B, name: "nForce Audio Processing Unit" },
		Device { id: 0x006C, name: "nForce2 External PCI Bridge" },
		Device { id: 0x006D, name: "nForce2 PCI Bridge" },
		Device { id: 0x006E, name: "nForce2 FireWire (IEEE 1394) Controller" },
		Device { id: 0x0080, name: "MCP2A ISA bridge" },
		Device { id: 0x0084, name: "MCP2A SMBus" },
		Device { id: 0x0085, name: "MCP2A IDE" },
		Device { id: 0x0086, name: "MCP2A Ethernet Controller" },
		Device { id: 0x0087, name: "MCP2A USB Controller" },
		Device { id: 0x0088, name: "MCP2A USB Controller" },
		Device { id: 0x008A, name: "MCP2S AC'97 Audio Controller" },
		Device { id: 0x008B, name: "MCP2A PCI Bridge" },
		Device { id: 0x008C, name: "MCP2A Ethernet Controller" },
		Device { id: 0x008E, name: "nForce2 Serial ATA Controller" },
		Device { id: 0x0090, name: "G70 [GeForce 7800 GTX]" },
		Device { id: 0x0091, name: "G70 [GeForce 7800 GTX]" },
		Device { id: 0x0092, name: "G70 [GeForce 7800 GT]" },
		Device { id: 0x0093, name: "G70 [GeForce 7800 GS]" },
		Device { id: 0x0095, name: "G70 [GeForce 7800 SLI]" },
		Device { id: 0x0097, name: "G70 [GeForce GTS 250]" },
		Device { id: 0x0098, name: "G70M [GeForce Go 7800]" },
		Device { id: 0x0099, name: "G70M [GeForce Go 7800 GTX]" },
		Device { id: 0x009D, name: "G70GL [Quadro FX 4500]" },
		Device { id: 0x00A0, name: "NV5 [Aladdin TNT2]" },
		Device { id: 0x00C0, name: "NV41 [GeForce 6800 GS]" },
		Device { id: 0x00C1, name: "NV41 [GeForce 6800]" },
		Device { id: 0x00C2, name: "NV41 [GeForce 6800 LE]" },
		Device { id: 0x00C3, name: "NV41 [GeForce 6800 XT]" },
		Device { id: 0x00C5, name: "NV41" },
		Device { id: 0x00C6, name: "NV41" },
		Device { id: 0x00C7, name: "NV41" },
		Device { id: 0x00C8, name: "NV41M [GeForce Go 6800]" },
		Device { id: 0x00C9, name: "NV41M [GeForce Go 6800 Ultra]" },
		Device { id: 0x00CC, name: "NV41GLM [Quadro FX Go1400]" },
		Device { id: 0x00CD, name: "NV42GL [Quadro FX 3450/4000 SDI]" },
		Device { id: 0x00CE, name: "NV41GL [Quadro FX 1400]" },
		Device { id: 0x00CF, name: "NV41" },
		Device { id: 0x00D0, name: "nForce3 LPC Bridge" },
		Device { id: 0x00D1, name: "nForce3 Host Bridge" },
		Device { id: 0x00D2, name: "nForce3 AGP Bridge" },
		Device { id: 0x00D3, name: "CK804 Memory Controller" },
		Device { id: 0x00D4, name: "nForce3 SMBus" },
		Device { id: 0x00D5, name: "nForce3 IDE" },
		Device { id: 0x00D6, name: "nForce3 Ethernet" },
		Device { id: 0x00D7, name: "nForce3 USB 1.1" },
		Device { id: 0x00D8, name: "nForce3 USB 2.0" },
		Device { id: 0x00D9, name: "nForce3 Audio" },
		Device { id: 0x00DA, name: "nForce3 Audio" },
		Device { id: 0x00DD, name: "nForce3 PCI Bridge" },
		Device { id: 0x00DF, name: "CK8S Ethernet Controller" },
		Device { id: 0x00E0, name: "nForce3 250Gb LPC Bridge" },
		Device { id: 0x00E1, name: "nForce3 250Gb Host Bridge" },
		Device { id: 0x00E2, name: "nForce3 250Gb AGP Host to PCI Bridge" },
		Device { id: 0x00E3, name: "nForce3 Serial ATA Controller" },
		Device { id: 0x00E4, name: "nForce 250Gb PCI System Management" },
		Device { id: 0x00E5, name: "CK8S Parallel ATA Controller (v2.5)" },
		Device { id: 0x00E6, name: "CK8S Ethernet Controller" },
		Device { id: 0x00E7, name: "CK8S USB Controller" },
		Device { id: 0x00E8, name: "nForce3 EHCI USB 2.0 Controller" },
		Device { id: 0x00EA, name: "nForce3 250Gb AC'97 Audio Controller" },
		Device { id: 0x00ED, name: "nForce3 250Gb PCI-to-PCI Bridge" },
		Device { id: 0x00EE, name: "nForce3 Serial ATA Controller 2" },
		Device { id: 0x00F1, name: "NV43 [GeForce 6600 GT]" },
		Device { id: 0x00F2, name: "NV43 [GeForce 6600]" },
		Device { id: 0x00F3, name: "NV43 [GeForce 6200]" },
		Device { id: 0x00F4, name: "NV43 [GeForce 6600 LE]" },
		Device { id: 0x00F5, name: "G71 [GeForce 7800 GS]" },
		Device { id: 0x00F6, name: "NV43 [GeForce 6800 GS/XT]" },
		Device { id: 0x00F8, name: "NV40GL [Quadro FX 3400/4400]" },
		Device { id: 0x00F9, name: "NV40 [GeForce 6800 GT/GTO/Ultra]" },
		Device { id: 0x00FA, name: "NV36 [GeForce PCX 5750]" },
		Device { id: 0x00FB, name: "NV38 [GeForce PCX 5900]" },
		Device { id: 0x00FC, name: "NV37GL [Quadro FX 330/GeForce PCX 5300]" },
		Device { id: 0x00FD, name: "NV37GL [Quadro PCI-E Series]" },
		Device { id: 0x00FE, name: "NV38GL [Quadro FX 1300]" },
		Device { id: 0x00FF, name: "NV18 [GeForce PCX 4300]" },
		Device { id: 0x0100, name: "NV10 [GeForce 256 SDR]" },
		Device { id: 0x0101, name: "NV10 [GeForce 256 DDR]" },
		Device { id: 0x0103, name: "NV10GL [Quadro]" },
		Device { id: 0x0110, name: "NV11 [GeForce2 MX/MX 400]" },
		Device { id: 0x0111, name: "NV11 [GeForce2 MX200]" },
		Device { id: 0x0112, name: "NV11M [GeForce2 Go]" },
		Device { id: 0x0113, name: "NV11GL [Quadro2 MXR/EX/Go]" },
		Device { id: 0x0140, name: "NV43 [GeForce 6600 GT]" },
		Device { id: 0x0141, name: "NV43 [GeForce 6600]" },
		Device { id: 0x0142, name: "NV43 [GeForce 6600 LE]" },
		Device { id: 0x0143, name: "NV43 [GeForce 6600 VE]" },
		Device { id: 0x0144, name: "NV43M [GeForce Go 6600]" },
		Device { id: 0x0145, name: "NV43 [GeForce 6610 XL]" },
		Device { id: 0x0146, name: "NV43M [GeForce Go6200 TE / 6600 TE]" },
		Device { id: 0x0147, name: "NV43 [GeForce 6700 XL]" },
		Device { id: 0x0148, name: "NV43M [GeForce Go 6600]" },
		Device { id: 0x0149, name: "NV43M [GeForce Go 6600 GT]" },
		Device { id: 0x014A, name: "NV43 [Quadro NVS 440]" },
		Device { id: 0x014B, name: "NV43" },
		Device { id: 0x014D, name: "NV43GL [Quadro FX 550]" },
		Device { id: 0x014E, name: "NV43GL [Quadro FX 540]" },
		Device { id: 0x014F, name: "NV43 [GeForce 6200]" },
		Device { id: 0x0150, name: "NV15 [GeForce2 GTS/Pro]" },
		Device { id: 0x0151, name: "NV15 [GeForce2 Ti]" },
		Device { id: 0x0152, name: "NV15 [GeForce2 Ultra]" },
		Device { id: 0x0153, name: "NV15GL [Quadro2 Pro]" },
		Device { id: 0x0160, name: "NV44 [GeForce 6500]" },
		Device { id: 0x0161, name: "NV44 [GeForce 6200 TurboCache]" },
		Device { id: 0x0162, name: "NV44 [GeForce 6200 SE TurboCache]" },
		Device { id: 0x0163, name: "NV44 [GeForce 6200 LE]" },
		Device { id: 0x0164, name: "NV44M [GeForce Go 6200]" },
		Device { id: 0x0165, name: "NV44 [Quadro NVS 285]" },
		Device { id: 0x0166, name: "NV44M [GeForce Go 6400]" },
		Device { id: 0x0167, name: "NV44M [GeForce Go 6200]" },
		Device { id: 0x0168, name: "NV44M [GeForce Go 6400]" },
		Device { id: 0x0169, name: "NV44 [GeForce 6250]" },
		Device { id: 0x016A, name: "NV44 [GeForce 7100 GS]" },
		Device { id: 0x016D, name: "NV44" },
		Device { id: 0x016E, name: "NV44" },
		Device { id: 0x016F, name: "NV44" },
		Device { id: 0x0170, name: "NV17 [GeForce4 MX 460]" },
		Device { id: 0x0171, name: "NV17 [GeForce4 MX 440]" },
		Device { id: 0x0172, name: "NV17 [GeForce4 MX 420]" },
		Device { id: 0x0173, name: "NV17 [GeForce4 MX 440-SE]" },
		Device { id: 0x0174, name: "NV17M [GeForce4 440 Go]" },
		Device { id: 0x0175, name: "NV17M [GeForce4 420 Go]" },
		Device { id: 0x0176, name: "NV17M [GeForce4 420 Go 32M]" },
		Device { id: 0x0177, name: "NV17M [GeForce4 460 Go]" },
		Device { id: 0x0178, name: "NV17GL [Quadro4 550 XGL]" },
		Device { id: 0x0179, name: "NV17M [GeForce4 440 Go 64M]" },
		Device { id: 0x017A, name: "NV17GL [Quadro NVS]" },
		Device { id: 0x017B, name: "NV17GL [Quadro4 550 XGL]" },
		Device { id: 0x017C, name: "NV17GL [Quadro4 500 GoGL]" },
		Device { id: 0x017F, name: "NV17" },
		Device { id: 0x0181, name: "NV18 [GeForce4 MX 440 AGP 8x]" },
		Device { id: 0x0182, name: "NV18 [GeForce4 MX 440SE AGP 8x]" },
		Device { id: 0x0183, name: "NV18 [GeForce4 MX 420 AGP 8x]" },
		Device { id: 0x0184, name: "NV18 [GeForce4 MX]" },
		Device { id: 0x0185, name: "NV18 [GeForce4 MX 4000]" },
		Device { id: 0x0186, name: "NV18M [GeForce4 448 Go]" },
		Device { id: 0x0187, name: "NV18M [GeForce4 488 Go]" },
		Device { id: 0x0188, name: "NV18GL [Quadro4 580 XGL]" },
		Device { id: 0x0189, name: "NV18 [GeForce4 MX with AGP8X (Mac)]" },
		Device { id: 0x018A, name: "NV18GL [Quadro NVS 280 SD]" },
		Device { id: 0x018B, name: "NV18GL [Quadro4 380 XGL]" },
		Device { id: 0x018C, name: "NV18GL [Quadro NVS 50 PCI]" },
		Device { id: 0x018D, name: "NV18M [GeForce4 448 Go]" },
		Device { id: 0x018F, name: "NV18" },
		Device { id: 0x0190, name: "G80 [GeForce 8800 GTS / 8800 GTX]" },
		Device { id: 0x0191, name: "G80 [GeForce 8800 GTX]" },
		Device { id: 0x0192, name: "G80 [GeForce 8800 GTS]" },
		Device { id: 0x0193, name: "G80 [GeForce 8800 GTS]" },
		Device { id: 0x0194, name: "G80 [GeForce 8800 Ultra]" },
		Device { id: 0x0197, name: "G80GL [Tesla C870]" },
		Device { id: 0x019D, name: "G80GL [Quadro FX 5600]" },
		Device { id: 0x019E, name: "G80GL [Quadro FX 4600]" },
		Device { id: 0x01A0, name: "nForce 220/420 NV11 [GeForce2 MX]" },
		Device { id: 0x01A4, name: "nForce CPU bridge" },
		Device { id: 0x01AB, name: "nForce 420 Memory Controller (DDR)" },
		Device { id: 0x01AC, name: "nForce 220/420 Memory Controller" },
		Device { id: 0x01AD, name: "nForce 220/420 Memory Controller" },
		Device { id: 0x01B0, name: "nForce Audio Processing Unit" },
		Device { id: 0x01B1, name: "nForce AC'97 Audio Controller" },
		Device { id: 0x01B2, name: "nForce ISA Bridge" },
		Device { id: 0x01B4, name: "nForce PCI System Management" },
		Device { id: 0x01B7, name: "nForce AGP to PCI Bridge" },
		Device { id: 0x01B8, name: "nForce PCI-to-PCI bridge" },
		Device { id: 0x01BC, name: "nForce IDE" },
		Device { id: 0x01C1, name: "nForce AC'97 Modem Controller" },
		Device { id: 0x01C2, name: "nForce USB Controller" },
		Device { id: 0x01C3, name: "nForce Ethernet Controller" },
		Device { id: 0x01D0, name: "G72 [GeForce 7350 LE]" },
		Device { id: 0x01D1, name: "G72 [GeForce 7300 LE]" },
		Device { id: 0x01D2, name: "G72 [GeForce 7550 LE]" },
		Device { id: 0x01D3, name: "G72 [GeForce 7200 GS / 7300 SE]" },
		Device { id: 0x01D5, name: "G72" },
		Device { id: 0x01D6, name: "G72M [GeForce Go 7200]" },
		Device { id: 0x01D7, name: "G72M [Quadro NVS 110M/GeForce Go 7300]" },
		Device { id: 0x01D8, name: "G72M [GeForce Go 7400]" },
		Device { id: 0x01D9, name: "G72M [GeForce Go 7450]" },
		Device { id: 0x01DA, name: "G72M [Quadro NVS 110M]" },
		Device { id: 0x01DB, name: "G72M [Quadro NVS 120M]" },
		Device { id: 0x01DC, name: "G72GLM [Quadro FX 350M]" },
		Device { id: 0x01DD, name: "G72 [GeForce 7500 LE]" },
		Device { id: 0x01DE, name: "G72GL [Quadro FX 350]" },
		Device { id: 0x01DF, name: "G72 [GeForce 7300 GS]" },
		Device { id: 0x01E0, name: "nForce2 IGP2" },
		Device { id: 0x01E8, name: "nForce2 AGP" },
		Device { id: 0x01EA, name: "nForce2 Memory Controller 0" },
		Device { id: 0x01EB, name: "nForce2 Memory Controller 1" },
		Device { id: 0x01EC, name: "nForce2 Memory Controller 2" },
		Device { id: 0x01ED, name: "nForce2 Memory Controller 3" },
		Device { id: 0x01EE, name: "nForce2 Memory Controller 4" },
		Device { id: 0x01EF, name: "nForce2 Memory Controller 5" },
		Device { id: 0x01F0, name: "C17 [GeForce4 MX IGP]" },
		Device { id: 0x0200, name: "NV20 [GeForce3]" },
		Device { id: 0x0201, name: "NV20 [GeForce3 Ti 200]" },
		Device { id: 0x0202, name: "NV20 [GeForce3 Ti 500]" },
		Device { id: 0x0203, name: "NV20GL [Quadro DCC]" },
		Device { id: 0x0211, name: "NV48 [GeForce 6800]" },
		Device { id: 0x0212, name: "NV48 [GeForce 6800 LE]" },
		Device { id: 0x0215, name: "NV48 [GeForce 6800 GT]" },
		Device { id: 0x0218, name: "NV48 [GeForce 6800 XT]" },
		Device { id: 0x0221, name: "NV44A [GeForce 6200]" },
		Device { id: 0x0222, name: "NV44 [GeForce 6200 A-LE]" },
		Device { id: 0x0224, name: "NV44" },
		Device { id: 0x0240, name: "C51PV [GeForce 6150]" },
		Device { id: 0x0241, name: "C51 [GeForce 6150 LE]" },
		Device { id: 0x0242, name: "C51G [GeForce 6100]" },
		Device { id: 0x0243, name: "C51 PCI Express Bridge" },
		Device { id: 0x0244, name: "C51 [GeForce Go 6150]" },
		Device { id: 0x0245, name: "C51 [Quadro NVS 210S/GeForce 6150LE]" },
		Device { id: 0x0246, name: "C51 PCI Express Bridge" },
		Device { id: 0x0247, name: "C51 [GeForce Go 6100]" },
		Device { id: 0x0248, name: "C51 PCI Express Bridge" },
		Device { id: 0x0249, name: "C51 PCI Express Bridge" },
		Device { id: 0x024A, name: "C51 PCI Express Bridge" },
		Device { id: 0x024B, name: "C51 PCI Express Bridge" },
		Device { id: 0x024C, name: "C51 PCI Express Bridge" },
		Device { id: 0x024D, name: "C51 PCI Express Bridge" },
		Device { id: 0x024E, name: "C51 PCI Express Bridge" },
		Device { id: 0x024F, name: "C51 PCI Express Bridge" },
		Device { id: 0x0250, name: "NV25 [GeForce4 Ti 4600]" },
		Device { id: 0x0251, name: "NV25 [GeForce4 Ti 4400]" },
		Device { id: 0x0252, name: "NV25 [GeForce4 Ti]" },
		Device { id: 0x0253, name: "NV25 [GeForce4 Ti 4200]" },
		Device { id: 0x0258, name: "NV25GL [Quadro4 900 XGL]" },
		Device { id: 0x0259, name: "NV25GL [Quadro4 750 XGL]" },
		Device { id: 0x025B, name: "NV25GL [Quadro4 700 XGL]" },
		Device { id: 0x0260, name: "MCP51 LPC Bridge" },
		Device { id: 0x0261, name: "MCP51 LPC Bridge" },
		Device { id: 0x0262, name: "MCP51 LPC Bridge" },
		Device { id: 0x0263, name: "MCP51 LPC Bridge" },
		Device { id: 0x0264, name: "MCP51 SMBus" },
		Device { id: 0x0265, name: "MCP51 IDE" },
		Device { id: 0x0266, name: "MCP51 Serial ATA Controller" },
		Device { id: 0x0267, name: "MCP51 Serial ATA Controller" },
		Device { id: 0x0268, name: "MCP51 Ethernet Controller" },
		Device { id: 0x0269, name: "MCP51 Ethernet Controller" },
		Device { id: 0x026A, name: "MCP51 MCI" },
		Device { id: 0x026B, name: "MCP51 AC97 Audio Controller" },
		Device { id: 0x026C, name: "MCP51 High Definition Audio" },
		Device { id: 0x026D, name: "MCP51 USB Controller" },
		Device { id: 0x026E, name: "MCP51 USB Controller" },
		Device { id: 0x026F, name: "MCP51 PCI Bridge" },
		Device { id: 0x0270, name: "MCP51 Host Bridge" },
		Device { id: 0x0271, name: "MCP51 PMU" },
		Device { id: 0x0272, name: "MCP51 Memory Controller 0" },
		Device { id: 0x027E, name: "C51 Memory Controller 2" },
		Device { id: 0x027F, name: "C51 Memory Controller 3" },
		Device { id: 0x0280, name: "NV28 [GeForce4 Ti 4800]" },
		Device { id: 0x0281, name: "NV28 [GeForce4 Ti 4200 AGP 8x]" },
		Device { id: 0x0282, name: "NV28 [GeForce4 Ti 4800 SE]" },
		Device { id: 0x0286, name: "NV28M [GeForce4 Ti 4200 Go AGP 8x]" },
		Device { id: 0x0288, name: "NV28GL [Quadro4 980 XGL]" },
		Device { id: 0x0289, name: "NV28GL [Quadro4 780 XGL]" },
		Device { id: 0x028C, name: "NV28GLM [Quadro4 Go700]" },
		Device { id: 0x0290, name: "G71 [GeForce 7900 GTX]" },
		Device { id: 0x0291, name: "G71 [GeForce 7900 GT/GTO]" },
		Device { id: 0x0292, name: "G71 [GeForce 7900 GS]" },
		Device { id: 0x0293, name: "G71 [GeForce 7900 GX2]" },
		Device { id: 0x0294, name: "G71 [GeForce 7950 GX2]" },
		Device { id: 0x0295, name: "G71 [GeForce 7950 GT]" },
		Device { id: 0x0297, name: "G71M [GeForce Go 7950 GTX]" },
		Device { id: 0x0298, name: "G71M [GeForce Go 7900 GS]" },
		Device { id: 0x0299, name: "G71M [GeForce Go 7900 GTX]" },
		Device { id: 0x029A, name: "G71GLM [Quadro FX 2500M]" },
		Device { id: 0x029B, name: "G71GLM [Quadro FX 1500M]" },
		Device { id: 0x029C, name: "G71GL [Quadro FX 5500]" },
		Device { id: 0x029D, name: "G71GL [Quadro FX 3500]" },
		Device { id: 0x029E, name: "G71GL [Quadro FX 1500]" },
		Device { id: 0x029F, name: "G71GL [Quadro FX 4500 X2]" },
		Device { id: 0x02A0, name: "NV2A [XGPU]" },
		Device { id: 0x02A5, name: "MCPX CPU Bridge" },
		Device { id: 0x02A6, name: "MCPX Memory Controller" },
		Device { id: 0x02E0, name: "G73 [GeForce 7600 GT]" },
		Device { id: 0x02E1, name: "G73 [GeForce 7600 GS]" },
		Device { id: 0x02E2, name: "G73 [GeForce 7300 GT]" },
		Device { id: 0x02E3, name: "G71 [GeForce 7900 GS]" },
		Device { id: 0x02E4, name: "G71 [GeForce 7950 GT]" },
		Device { id: 0x02F0, name: "C51 Host Bridge" },
		Device { id: 0x02F1, name: "C51 Host Bridge" },
		Device { id: 0x02F2, name: "C51 Host Bridge" },
		Device { id: 0x02F3, name: "C51 Host Bridge" },
		Device { id: 0x02F4, name: "C51 Host Bridge" },
		Device { id: 0x02F5, name: "C51 Host Bridge" },
		Device { id: 0x02F6, name: "C51 Host Bridge" },
		Device { id: 0x02F7, name: "C51 Host Bridge" },
		Device { id: 0x02F8, name: "C51 Memory Controller 5" },
		Device { id: 0x02F9, name: "C51 Memory Controller 4" },
		Device { id: 0x02FA, name: "C51 Memory Controller 0" },
		Device { id: 0x02FB, name: "C51 PCI Express Bridge" },
		Device { id: 0x02FC, name: "C51 PCI Express Bridge" },
		Device { id: 0x02FD, name: "C51 PCI Express Bridge" },
		Device { id: 0x02FE, name: "C51 Memory Controller 1" },
		Device { id: 0x02FF, name: "C51 Host Bridge" },
		Device { id: 0x0300, name: "NV30 [GeForce FX]" },
		Device { id: 0x0301, name: "NV30 [GeForce FX 5800 Ultra]" },
		Device { id: 0x0302, name: "NV30 [GeForce FX 5800]" },
		Device { id: 0x0308, name: "NV30GL [Quadro FX 2000]" },
		Device { id: 0x0309, name: "NV30GL [Quadro FX 1000]" },
		Device { id: 0x0311, name: "NV31 [GeForce FX 5600 Ultra]" },
		Device { id: 0x0312, name: "NV31 [GeForce FX 5600]" },
		Device { id: 0x0314, name: "NV31 [GeForce FX 5600XT]" },
		Device { id: 0x0316, name: "NV31M" },
		Device { id: 0x0318, name: "NV31GL" },
		Device { id: 0x031A, name: "NV31M [GeForce FX Go5600]" },
		Device { id: 0x031B, name: "NV31M [GeForce FX Go5650]" },
		Device { id: 0x031C, name: "NV31GLM [Quadro FX Go700]" },
		Device { id: 0x0320, name: "NV34 [GeForce FX 5200]" },
		Device { id: 0x0321, name: "NV34 [GeForce FX 5200 Ultra]" },
		Device { id: 0x0322, name: "NV34 [GeForce FX 5200]" },
		Device { id: 0x0323, name: "NV34 [GeForce FX 5200LE]" },
		Device { id: 0x0324, name: "NV34M [GeForce FX Go5200 64M]" },
		Device { id: 0x0325, name: "NV34M [GeForce FX Go5250]" },
		Device { id: 0x0326, name: "NV34 [GeForce FX 5500]" },
		Device { id: 0x0327, name: "NV34 [GeForce FX 5100]" },
		Device { id: 0x0328, name: "NV34M [GeForce FX Go5200 32M/64M]" },
		Device { id: 0x0329, name: "NV34M [GeForce FX Go5200]" },
		Device { id: 0x032A, name: "NV34GL [Quadro NVS 280 PCI]" },
		Device { id: 0x032B, name: "NV34GL [Quadro FX 500/600 PCI]" },
		Device { id: 0x032C, name: "NV34M [GeForce FX Go5300 / Go5350]" },
		Device { id: 0x032D, name: "NV34M [GeForce FX Go5100]" },
		Device { id: 0x032E, name: "NV34" },
		Device { id: 0x032F, name: "NV34 [GeForce FX 5200]" },
		Device { id: 0x0330, name: "NV35 [GeForce FX 5900 Ultra]" },
		Device { id: 0x0331, name: "NV35 [GeForce FX 5900]" },
		Device { id: 0x0332, name: "NV35 [GeForce FX 5900XT]" },
		Device { id: 0x0333, name: "NV38 [GeForce FX 5950 Ultra]" },
		Device { id: 0x0334, name: "NV35 [GeForce FX 5900ZT]" },
		Device { id: 0x0338, name: "NV35GL [Quadro FX 3000]" },
		Device { id: 0x033F, name: "NV35GL [Quadro FX 700]" },
		Device { id: 0x0341, name: "NV36 [GeForce FX 5700 Ultra]" },
		Device { id: 0x0342, name: "NV36 [GeForce FX 5700]" },
		Device { id: 0x0343, name: "NV36 [GeForce FX 5700LE]" },
		Device { id: 0x0344, name: "NV36 [GeForce FX 5700VE]" },
		Device { id: 0x0347, name: "NV36M [GeForce FX Go5700]" },
		Device { id: 0x0348, name: "NV36M [GeForce FX Go5700]" },
		Device { id: 0x034C, name: "NV36 [Quadro FX Go1000]" },
		Device { id: 0x034D, name: "NV36" },
		Device { id: 0x034E, name: "NV36GL [Quadro FX 1100]" },
		Device { id: 0x0360, name: "MCP55 LPC Bridge" },
		Device { id: 0x0361, name: "MCP55 LPC Bridge" },
		Device { id: 0x0362, name: "MCP55 LPC Bridge" },
		Device { id: 0x0363, name: "MCP55 LPC Bridge" },
		Device { id: 0x0364, name: "MCP55 LPC Bridge" },
		Device { id: 0x0365, name: "MCP55 LPC Bridge" },
		Device { id: 0x0366, name: "MCP55 LPC Bridge" },
		Device { id: 0x0367, name: "MCP55 LPC Bridge" },
		Device { id: 0x0368, name: "MCP55 SMBus Controller" },
		Device { id: 0x0369, name: "MCP55 Memory Controller" },
		Device { id: 0x036A, name: "MCP55 Memory Controller" },
		Device { id: 0x036B, name: "MCP55 SMU" },
		Device { id: 0x036C, name: "MCP55 USB Controller" },
		Device { id: 0x036D, name: "MCP55 USB Controller" },
		Device { id: 0x036E, name: "MCP55 IDE" },
		Device { id: 0x0370, name: "MCP55 PCI bridge" },
		Device { id: 0x0371, name: "MCP55 High Definition Audio" },
		Device { id: 0x0372, name: "MCP55 Ethernet" },
		Device { id: 0x0373, name: "MCP55 Ethernet" },
		Device { id: 0x0374, name: "MCP55 PCI Express bridge" },
		Device { id: 0x0375, name: "MCP55 PCI Express bridge" },
		Device { id: 0x0376, name: "MCP55 PCI Express bridge" },
		Device { id: 0x0377, name: "MCP55 PCI Express bridge" },
		Device { id: 0x0378, name: "MCP55 PCI Express bridge" },
		Device { id: 0x037A, name: "MCP55 Memory Controller" },
		Device { id: 0x037E, name: "MCP55 SATA Controller" },
		Device { id: 0x037F, name: "MCP55 SATA Controller" },
		Device { id: 0x038B, name: "G73 [GeForce 7650 GS]" },
		Device { id: 0x0390, name: "G73 [GeForce 7650 GS]" },
		Device { id: 0x0391, name: "G73 [GeForce 7600 GT]" },
		Device { id: 0x0392, name: "G73 [GeForce 7600 GS]" },
		Device { id: 0x0393, name: "G73 [GeForce 7300 GT]" },
		Device { id: 0x0394, name: "G73 [GeForce 7600 LE]" },
		Device { id: 0x0395, name: "G73 [GeForce 7300 GT]" },
		Device { id: 0x0396, name: "G73" },
		Device { id: 0x0397, name: "G73M [GeForce Go 7700]" },
		Device { id: 0x0398, name: "G73M [GeForce Go 7600]" },
		Device { id: 0x0399, name: "G73M [GeForce Go 7600 GT]" },
		Device { id: 0x039A, name: "G73M [Quadro NVS 300M]" },
		Device { id: 0x039B, name: "G73M [GeForce Go 7900 SE]" },
		Device { id: 0x039C, name: "G73GLM [Quadro FX 550M]" },
		Device { id: 0x039D, name: "G73" },
		Device { id: 0x039E, name: "G73GL [Quadro FX 560]" },
		Device { id: 0x039F, name: "G73" },
		Device { id: 0x03A0, name: "C55 Host Bridge" },
		Device { id: 0x03A1, name: "C55 Host Bridge" },
		Device { id: 0x03A2, name: "C55 Host Bridge" },
		Device { id: 0x03A3, name: "C55 Host Bridge" },
		Device { id: 0x03A4, name: "C55 Host Bridge" },
		Device { id: 0x03A5, name: "C55 Host Bridge" },
		Device { id: 0x03A6, name: "C55 Host Bridge" },
		Device { id: 0x03A7, name: "C55 Host Bridge" },
		Device { id: 0x03A8, name: "C55 Memory Controller" },
		Device { id: 0x03A9, name: "C55 Memory Controller" },
		Device { id: 0x03AA, name: "C55 Memory Controller" },
		Device { id: 0x03AB, name: "C55 Memory Controller" },
		Device { id: 0x03AC, name: "C55 Memory Controller" },
		Device { id: 0x03AD, name: "C55 Memory Controller" },
		Device { id: 0x03AE, name: "C55 Memory Controller" },
		Device { id: 0x03AF, name: "C55 Memory Controller" },
		Device { id: 0x03B0, name: "C55 Memory Controller" },
		Device { id: 0x03B1, name: "C55 Memory Controller" },
		Device { id: 0x03B2, name: "C55 Memory Controller" },
		Device { id: 0x03B3, name: "C55 Memory Controller" },
		Device { id: 0x03B4, name: "C55 Memory Controller" },
		Device { id: 0x03B5, name: "C55 Memory Controller" },
		Device { id: 0x03B6, name: "C55 Memory Controller" },
		Device { id: 0x03B7, name: "C55 PCI Express bridge" },
		Device { id: 0x03B8, name: "C55 PCI Express bridge" },
		Device { id: 0x03B9, name: "C55 PCI Express bridge" },
		Device { id: 0x03BA, name: "C55 Memory Controller" },
		Device { id: 0x03BB, name: "C55 PCI Express bridge" },
		Device { id: 0x03BC, name: "C55 Memory Controller" },
		Device { id: 0x03D0, name: "C61 [GeForce 6150SE nForce 430]" },
		Device { id: 0x03D1, name: "C61 [GeForce 6100 nForce 405]" },
		Device { id: 0x03D2, name: "C61 [GeForce 6100 nForce 400]" },
		Device { id: 0x03D5, name: "C61 [GeForce 6100 nForce 420]" },
		Device { id: 0x03D6, name: "C61 [GeForce 7025 / nForce 630a]" },
		Device { id: 0x03E0, name: "MCP61 LPC Bridge" },
		Device { id: 0x03E1, name: "MCP61 LPC Bridge" },
		Device { id: 0x03E2, name: "MCP61 Host Bridge" },
		Device { id: 0x03E3, name: "MCP61 LPC Bridge" },
		Device { id: 0x03E4, name: "MCP61 High Definition Audio" },
		Device { id: 0x03E5, name: "MCP61 Ethernet" },
		Device { id: 0x03E6, name: "MCP61 Ethernet" },
		Device { id: 0x03E7, name: "MCP61 SATA Controller" },
		Device { id: 0x03E8, name: "MCP61 PCI Express bridge" },
		Device { id: 0x03E9, name: "MCP61 PCI Express bridge" },
		Device { id: 0x03EA, name: "MCP61 Memory Controller" },
		Device { id: 0x03EB, name: "MCP61 SMBus" },
		Device { id: 0x03EC, name: "MCP61 IDE" },
		Device { id: 0x03EE, name: "MCP61 Ethernet" },
		Device { id: 0x03EF, name: "MCP61 Ethernet" },
		Device { id: 0x03F0, name: "MCP61 High Definition Audio" },
		Device { id: 0x03F1, name: "MCP61 USB 1.1 Controller" },
		Device { id: 0x03F2, name: "MCP61 USB 2.0 Controller" },
		Device { id: 0x03F3, name: "MCP61 PCI bridge" },
		Device { id: 0x03F4, name: "MCP61 SMU" },
		Device { id: 0x03F5, name: "MCP61 Memory Controller" },
		Device { id: 0x03F6, name: "MCP61 SATA Controller" },
		Device { id: 0x03F7, name: "MCP61 SATA Controller" },
		Device { id: 0x0400, name: "G84 [GeForce 8600 GTS]" },
		Device { id: 0x0401, name: "G84 [GeForce 8600 GT]" },
		Device { id: 0x0402, name: "G84 [GeForce 8600 GT]" },
		Device { id: 0x0403, name: "G84 [GeForce 8600 GS]" },
		Device { id: 0x0404, name: "G84 [GeForce 8400 GS]" },
		Device { id: 0x0405, name: "G84M [GeForce 9500M GS]" },
		Device { id: 0x0406, name: "G84 [GeForce 8300 GS]" },
		Device { id: 0x0407, name: "G84M [GeForce 8600M GT]" },
		Device { id: 0x0408, name: "G84M [GeForce 9650M GS]" },
		Device { id: 0x0409, name: "G84M [GeForce 8700M GT]" },
		Device { id: 0x040A, name: "G84GL [Quadro FX 370]" },
		Device { id: 0x040B, name: "G84GLM [Quadro NVS 320M]" },
		Device { id: 0x040C, name: "G84GLM [Quadro FX 570M]" },
		Device { id: 0x040D, name: "G84GLM [Quadro FX 1600M]" },
		Device { id: 0x040E, name: "G84GL [Quadro FX 570]" },
		Device { id: 0x040F, name: "G84GL [Quadro FX 1700]" },
		Device { id: 0x0410, name: "G92 [GeForce GT 330]" },
		Device { id: 0x0414, name: "G92 [GeForce 9800 GT]" },
		Device { id: 0x0420, name: "G86 [GeForce 8400 SE]" },
		Device { id: 0x0421, name: "G86 [GeForce 8500 GT]" },
		Device { id: 0x0422, name: "G86 [GeForce 8400 GS]" },
		Device { id: 0x0423, name: "G86 [GeForce 8300 GS]" },
		Device { id: 0x0424, name: "G86 [GeForce 8400 GS]" },
		Device { id: 0x0425, name: "G86M [GeForce 8600M GS]" },
		Device { id: 0x0426, name: "G86M [GeForce 8400M GT]" },
		Device { id: 0x0427, name: "G86M [GeForce 8400M GS]" },
		Device { id: 0x0428, name: "G86M [GeForce 8400M G]" },
		Device { id: 0x0429, name: "G86M [Quadro NVS 140M]" },
		Device { id: 0x042A, name: "G86M [Quadro NVS 130M]" },
		Device { id: 0x042B, name: "G86M [Quadro NVS 135M]" },
		Device { id: 0x042C, name: "G86 [GeForce 9400 GT]" },
		Device { id: 0x042D, name: "G86GLM [Quadro FX 360M]" },
		Device { id: 0x042E, name: "G86M [GeForce 9300M G]" },
		Device { id: 0x042F, name: "G86 [Quadro NVS 290]" },
		Device { id: 0x0440, name: "MCP65 LPC Bridge" },
		Device { id: 0x0441, name: "MCP65 LPC Bridge" },
		Device { id: 0x0442, name: "MCP65 LPC Bridge" },
		Device { id: 0x0443, name: "MCP65 LPC Bridge" },
		Device { id: 0x0444, name: "MCP65 Memory Controller" },
		Device { id: 0x0445, name: "MCP65 Memory Controller" },
		Device { id: 0x0446, name: "MCP65 SMBus" },
		Device { id: 0x0447, name: "MCP65 SMU" },
		Device { id: 0x0448, name: "MCP65 IDE" },
		Device { id: 0x0449, name: "MCP65 PCI bridge" },
		Device { id: 0x044A, name: "MCP65 High Definition Audio" },
		Device { id: 0x044B, name: "MCP65 High Definition Audio" },
		Device { id: 0x044C, name: "MCP65 AHCI Controller" },
		Device { id: 0x044D, name: "MCP65 AHCI Controller" },
		Device { id: 0x044E, name: "MCP65 AHCI Controller" },
		Device { id: 0x044F, name: "MCP65 AHCI Controller" },
		Device { id: 0x0450, name: "MCP65 Ethernet" },
		Device { id: 0x0451, name: "MCP65 Ethernet" },
		Device { id: 0x0452, name: "MCP65 Ethernet" },
		Device { id: 0x0453, name: "MCP65 Ethernet" },
		Device { id: 0x0454, name: "MCP65 USB 1.1 OHCI Controller" },
		Device { id: 0x0455, name: "MCP65 USB 2.0 EHCI Controller" },
		Device { id: 0x0456, name: "MCP65 USB Controller" },
		Device { id: 0x0457, name: "MCP65 USB Controller" },
		Device { id: 0x0458, name: "MCP65 PCI Express bridge" },
		Device { id: 0x0459, name: "MCP65 PCI Express bridge" },
		Device { id: 0x045A, name: "MCP65 PCI Express bridge" },
		Device { id: 0x045B, name: "MCP65 PCI Express bridge" },
		Device { id: 0x045C, name: "MCP65 SATA Controller" },
		Device { id: 0x045D, name: "MCP65 SATA Controller" },
		Device { id: 0x045E, name: "MCP65 SATA Controller" },
		Device { id: 0x045F, name: "MCP65 SATA Controller" },
		Device { id: 0x0531, name: "C67 [GeForce 7150M / nForce 630M]" },
		Device { id: 0x0533, name: "C67 [GeForce 7000M / nForce 610M]" },
		Device { id: 0x053A, name: "C68 [GeForce 7050 PV / nForce 630a]" },
		Device { id: 0x053B, name: "C68 [GeForce 7050 PV / nForce 630a]" },
		Device { id: 0x053E, name: "C68 [GeForce 7025 / nForce 630a]" },
		Device { id: 0x0541, name: "MCP67 Memory Controller" },
		Device { id: 0x0542, name: "MCP67 SMBus" },
		Device { id: 0x0543, name: "MCP67 Co-processor" },
		Device { id: 0x0547, name: "MCP67 Memory Controller" },
		Device { id: 0x0548, name: "MCP67 ISA Bridge" },
		Device { id: 0x054C, name: "MCP67 Ethernet" },
		Device { id: 0x054D, name: "MCP67 Ethernet" },
		Device { id: 0x054E, name: "MCP67 Ethernet" },
		Device { id: 0x054F, name: "MCP67 Ethernet" },
		Device { id: 0x0550, name: "MCP67 AHCI Controller" },
		Device { id: 0x0554, name: "MCP67 AHCI Controller" },
		Device { id: 0x0555, name: "MCP67 SATA Controller" },
		Device { id: 0x055C, name: "MCP67 High Definition Audio" },
		Device { id: 0x055D, name: "MCP67 High Definition Audio" },
		Device { id: 0x055E, name: "MCP67 OHCI USB 1.1 Controller" },
		Device { id: 0x055F, name: "MCP67 EHCI USB 2.0 Controller" },
		Device { id: 0x0560, name: "MCP67 IDE Controller" },
		Device { id: 0x0561, name: "MCP67 PCI Bridge" },
		Device { id: 0x0562, name: "MCP67 PCI Express Bridge" },
		Device { id: 0x0563, name: "MCP67 PCI Express Bridge" },
		Device { id: 0x0568, name: "MCP78S [GeForce 8200] Memory Controller" },
		Device { id: 0x0569, name: "MCP78S [GeForce 8200] PCI Express Bridge" },
		Device { id: 0x056A, name: "MCP73 [nForce 630i] USB 2.0 Controller (EHCI)" },
		Device { id: 0x056C, name: "MCP73 IDE Controller" },
		Device { id: 0x056D, name: "MCP73 PCI Express bridge" },
		Device { id: 0x056E, name: "MCP73 PCI Express bridge" },
		Device { id: 0x056F, name: "MCP73 PCI Express bridge" },
		Device { id: 0x05B1, name: "NF200 PCIe 2.0 switch" },
		Device { id: 0x05B8, name: "NF200 PCIe 2.0 switch for GTX 295" },
		Device { id: 0x05BE, name: "NF200 PCIe 2.0 switch for Quadro Plex S4 / Tesla S870 / Tesla S1070 / Tesla S2050" },
		Device { id: 0x05E0, name: "GT200b [GeForce GTX 295]" },
		Device { id: 0x05E1, name: "GT200 [GeForce GTX 280]" },
		Device { id: 0x05E2, name: "GT200 [GeForce GTX 260]" },
		Device { id: 0x05E3, name: "GT200b [GeForce GTX 285]" },
		Device { id: 0x05E6, name: "GT200b [GeForce GTX 275]" },
		Device { id: 0x05E7, name: "GT200GL [Tesla C1060 / M1060]" },
		Device { id: 0x05EA, name: "GT200 [GeForce GTX 260]" },
		Device { id: 0x05EB, name: "GT200 [GeForce GTX 295]" },
		Device { id: 0x05ED, name: "GT200GL [Quadro Plex 2200 D2]" },
		Device { id: 0x05F1, name: "GT200 [GeForce GTX 280]" },
		Device { id: 0x05F2, name: "GT200 [GeForce GTX 260]" },
		Device { id: 0x05F8, name: "GT200GL [Quadro Plex 2200 S4]" },
		Device { id: 0x05F9, name: "GT200GL [Quadro CX]" },
		Device { id: 0x05FD, name: "GT200GL [Quadro FX 5800]" },
		Device { id: 0x05FE, name: "GT200GL [Quadro FX 4800]" },
		Device { id: 0x05FF, name: "GT200GL [Quadro FX 3800]" },
		Device { id: 0x0600, name: "G92 [GeForce 8800 GTS 512]" },
		Device { id: 0x0601, name: "G92 [GeForce 9800 GT]" },
		Device { id: 0x0602, name: "G92 [GeForce 8800 GT]" },
		Device { id: 0x0603, name: "G92 [GeForce GT 230 OEM]" },
		Device { id: 0x0604, name: "G92 [GeForce 9800 GX2]" },
		Device { id: 0x0605, name: "G92 [GeForce 9800 GT]" },
		Device { id: 0x0606, name: "G92 [GeForce 8800 GS]" },
		Device { id: 0x0607, name: "G92 [GeForce GTS 240]" },
		Device { id: 0x0608, name: "G92M [GeForce 9800M GTX]" },
		Device { id: 0x0609, name: "G92M [GeForce 8800M GTS]" },
		Device { id: 0x060A, name: "G92M [GeForce GTX 280M]" },
		Device { id: 0x060B, name: "G92M [GeForce 9800M GT]" },
		Device { id: 0x060C, name: "G92M [GeForce 8800M GTX]" },
		Device { id: 0x060D, name: "G92 [GeForce 8800 GS]" },
		Device { id: 0x060F, name: "G92M [GeForce GTX 285M]" },
		Device { id: 0x0610, name: "G92 [GeForce 9600 GSO]" },
		Device { id: 0x0611, name: "G92 [GeForce 8800 GT]" },
		Device { id: 0x0612, name: "G92 [GeForce 9800 GTX / 9800 GTX+]" },
		Device { id: 0x0613, name: "G92 [GeForce 9800 GTX+]" },
		Device { id: 0x0614, name: "G92 [GeForce 9800 GT]" },
		Device { id: 0x0615, name: "G92 [GeForce GTS 250]" },
		Device { id: 0x0617, name: "G92M [GeForce 9800M GTX]" },
		Device { id: 0x0618, name: "G92M [GeForce GTX 260M]" },
		Device { id: 0x0619, name: "G92GL [Quadro FX 4700 X2]" },
		Device { id: 0x061A, name: "G92GL [Quadro FX 3700]" },
		Device { id: 0x061B, name: "G92GL [Quadro VX 200]" },
		Device { id: 0x061C, name: "G92GLM [Quadro FX 3600M]" },
		Device { id: 0x061D, name: "G92GLM [Quadro FX 2800M]" },
		Device { id: 0x061E, name: "G92GLM [Quadro FX 3700M]" },
		Device { id: 0x061F, name: "G92GLM [Quadro FX 3800M]" },
		Device { id: 0x0620, name: "G94 [GeForce 9800 GT]" },
		Device { id: 0x0621, name: "G94 [GeForce GT 230]" },
		Device { id: 0x0622, name: "G94 [GeForce 9600 GT]" },
		Device { id: 0x0623, name: "G94 [GeForce 9600 GS]" },
		Device { id: 0x0624, name: "G94 [GeForce 9600 GT Green Edition]" },
		Device { id: 0x0625, name: "G94 [GeForce 9600 GSO 512]" },
		Device { id: 0x0626, name: "G94 [GeForce GT 130]" },
		Device { id: 0x0627, name: "G94 [GeForce GT 140]" },
		Device { id: 0x0628, name: "G94M [GeForce 9800M GTS]" },
		Device { id: 0x062A, name: "G94M [GeForce 9700M GTS]" },
		Device { id: 0x062B, name: "G94M [GeForce 9800M GS]" },
		Device { id: 0x062C, name: "G94M [GeForce 9800M GTS]" },
		Device { id: 0x062D, name: "G94 [GeForce 9600 GT]" },
		Device { id: 0x062E, name: "G94 [GeForce 9600 GT]" },
		Device { id: 0x062F, name: "G94 [GeForce 9800 S]" },
		Device { id: 0x0630, name: "G94 [GeForce 9600 GT]" },
		Device { id: 0x0631, name: "G94M [GeForce GTS 160M]" },
		Device { id: 0x0632, name: "G94M [GeForce GTS 150M]" },
		Device { id: 0x0633, name: "G94 [GeForce GT 220]" },
		Device { id: 0x0635, name: "G94 [GeForce 9600 GSO]" },
		Device { id: 0x0637, name: "G94 [GeForce 9600 GT]" },
		Device { id: 0x0638, name: "G94GL [Quadro FX 1800]" },
		Device { id: 0x063A, name: "G94GLM [Quadro FX 2700M]" },
		Device { id: 0x063F, name: "G94 [GeForce 9600 GE]" },
		Device { id: 0x0640, name: "G96 [GeForce 9500 GT]" },
		Device { id: 0x0641, name: "G96 [GeForce 9400 GT]" },
		Device { id: 0x0642, name: "G96 [D9M-10]" },
		Device { id: 0x0643, name: "G96 [GeForce 9500 GT]" },
		Device { id: 0x0644, name: "G96 [GeForce 9500 GS]" },
		Device { id: 0x0645, name: "G96 [GeForce 9500 GS]" },
		Device { id: 0x0646, name: "G96 [GeForce GT 120]" },
		Device { id: 0x0647, name: "G96M [GeForce 9600M GT]" },
		Device { id: 0x0648, name: "G96M [GeForce 9600M GS]" },
		Device { id: 0x0649, name: "G96M [GeForce 9600M GT]" },
		Device { id: 0x064A, name: "G96M [GeForce 9700M GT]" },
		Device { id: 0x064B, name: "G96M [GeForce 9500M G]" },
		Device { id: 0x064C, name: "G96M [GeForce 9650M GT]" },
		Device { id: 0x064D, name: "G96 [GeForce 9600 GT]" },
		Device { id: 0x064E, name: "G96 [GeForce 9600 GT / 9800 GT]" },
		Device { id: 0x0651, name: "G96M [GeForce G 110M]" },
		Device { id: 0x0652, name: "G96M [GeForce GT 130M]" },
		Device { id: 0x0653, name: "G96M [GeForce GT 120M]" },
		Device { id: 0x0654, name: "G96M [GeForce GT 220M]" },
		Device { id: 0x0655, name: "G96 [GeForce GT 120]" },
		Device { id: 0x0656, name: "G96 [GeForce 9650 S]" },
		Device { id: 0x0658, name: "G96GL [Quadro FX 380]" },
		Device { id: 0x0659, name: "G96GL [Quadro FX 580]" },
		Device { id: 0x065A, name: "G96GLM [Quadro FX 1700M]" },
		Device { id: 0x065B, name: "G96 [GeForce 9400 GT]" },
		Device { id: 0x065C, name: "G96GLM [Quadro FX 770M]" },
		Device { id: 0x065D, name: "G96 [GeForce 9500 GA / 9600 GT / GTS 250]" },
		Device { id: 0x065F, name: "G96 [GeForce G210]" },
		Device { id: 0x06C0, name: "GF100 [GeForce GTX 480]" },
		Device { id: 0x06C4, name: "GF100 [GeForce GTX 465]" },
		Device { id: 0x06CA, name: "GF100M [GeForce GTX 480M]" },
		Device { id: 0x06CB, name: "GF100 [GeForce GTX 480]" },
		Device { id: 0x06CD, name: "GF100 [GeForce GTX 470]" },
		Device { id: 0x06D1, name: "GF100GL [Tesla C2050 / C2070]" },
		Device { id: 0x06D2, name: "GF100GL [Tesla M2070]" },
		Device { id: 0x06D8, name: "GF100GL [Quadro 6000]" },
		Device { id: 0x06D9, name: "GF100GL [Quadro 5000]" },
		Device { id: 0x06DA, name: "GF100GLM [Quadro 5000M]" },
		Device { id: 0x06DC, name: "GF100GL [Quadro 6000]" },
		Device { id: 0x06DD, name: "GF100GL [Quadro 4000]" },
		Device { id: 0x06DE, name: "GF100GL [Tesla T20 Processor]" },
		Device { id: 0x06DF, name: "GF100GL [Tesla M2070-Q]" },
		Device { id: 0x06E0, name: "G98 [GeForce 9300 GE]" },
		Device { id: 0x06E1, name: "G98 [GeForce 9300 GS]" },
		Device { id: 0x06E2, name: "G98 [GeForce 8400]" },
		Device { id: 0x06E3, name: "G98 [GeForce 8300 GS]" },
		Device { id: 0x06E4, name: "G98 [GeForce 8400 GS Rev. 2]" },
		Device { id: 0x06E5, name: "G98M [GeForce 9300M GS]" },
		Device { id: 0x06E6, name: "G98 [GeForce G 100]" },
		Device { id: 0x06E7, name: "G98 [GeForce 9300 SE]" },
		Device { id: 0x06E8, name: "G98M [GeForce 9200M GS]" },
		Device { id: 0x06E9, name: "G98M [GeForce 9300M GS]" },
		Device { id: 0x06EA, name: "G98M [Quadro NVS 150M]" },
		Device { id: 0x06EB, name: "G98M [Quadro NVS 160M]" },
		Device { id: 0x06EC, name: "G98M [GeForce G 105M]" },
		Device { id: 0x06ED, name: "G98 [GeForce 9600 GT / 9800 GT]" },
		Device { id: 0x06EE, name: "G98 [GeForce 9600 GT / 9800 GT]" },
		Device { id: 0x06EF, name: "G98M [GeForce G 103M]" },
		Device { id: 0x06F1, name: "G98M [GeForce G 105M]" },
		Device { id: 0x06F8, name: "G98 [Quadro NVS 420]" },
		Device { id: 0x06F9, name: "G98GL [Quadro FX 370 LP]" },
		Device { id: 0x06FA, name: "G98 [Quadro NVS 450]" },
		Device { id: 0x06FB, name: "G98GLM [Quadro FX 370M]" },
		Device { id: 0x06FD, name: "G98 [Quadro NVS 295]" },
		Device { id: 0x06FF, name: "G98 [HICx16 + Graphics]" },
		Device { id: 0x0751, name: "MCP78S [GeForce 8200] Memory Controller" },
		Device { id: 0x0752, name: "MCP78S [GeForce 8200] SMBus" },
		Device { id: 0x0753, name: "MCP78S [GeForce 8200] Co-Processor" },
		Device { id: 0x0754, name: "MCP78S [GeForce 8200] Memory Controller" },
		Device { id: 0x0759, name: "MCP78S [GeForce 8200] IDE" },
		Device { id: 0x075A, name: "MCP78S [GeForce 8200] PCI Bridge" },
		Device { id: 0x075B, name: "MCP78S [GeForce 8200] PCI Express Bridge" },
		Device { id: 0x075C, name: "MCP78S [GeForce 8200] LPC Bridge" },
		Device { id: 0x075D, name: "MCP78S [GeForce 8200] LPC Bridge" },
		Device { id: 0x0760, name: "MCP77 Ethernet" },
		Device { id: 0x0761, name: "MCP77 Ethernet" },
		Device { id: 0x0762, name: "MCP77 Ethernet" },
		Device { id: 0x0763, name: "MCP77 Ethernet" },
		Device { id: 0x0774, name: "MCP72XE/MCP72P/MCP78U/MCP78S High Definition Audio" },
		Device { id: 0x0778, name: "MCP78S [GeForce 8200] PCI Express Bridge" },
		Device { id: 0x077A, name: "MCP78S [GeForce 8200] PCI Bridge" },
		Device { id: 0x077B, name: "MCP78S [GeForce 8200] OHCI USB 1.1 Controller" },
		Device { id: 0x077C, name: "MCP78S [GeForce 8200] EHCI USB 2.0 Controller" },
		Device { id: 0x077D, name: "MCP78S [GeForce 8200] OHCI USB 1.1 Controller" },
		Device { id: 0x077E, name: "MCP78S [GeForce 8200] EHCI USB 2.0 Controller" },
		Device { id: 0x07C0, name: "MCP73 Host Bridge" },
		Device { id: 0x07C1, name: "MCP73 Host Bridge" },
		Device { id: 0x07C2, name: "MCP73 Host Bridge" },
		Device { id: 0x07C3, name: "MCP73 Host Bridge" },
		Device { id: 0x07C5, name: "MCP73 Host Bridge" },
		Device { id: 0x07C8, name: "MCP73 Memory Controller" },
		Device { id: 0x07CB, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07CD, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07CE, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07CF, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07D0, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07D1, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07D2, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07D3, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07D6, name: "nForce 610i/630i memory controller" },
		Device { id: 0x07D7, name: "MCP73 LPC Bridge" },
		Device { id: 0x07D8, name: "MCP73 SMBus" },
		Device { id: 0x07D9, name: "MCP73 Memory Controller" },
		Device { id: 0x07DA, name: "MCP73 Co-processor" },
		Device { id: 0x07DC, name: "MCP73 Ethernet" },
		Device { id: 0x07DD, name: "MCP73 Ethernet" },
		Device { id: 0x07DE, name: "MCP73 Ethernet" },
		Device { id: 0x07DF, name: "MCP73 Ethernet" },
		Device { id: 0x07E0, name: "C73 [GeForce 7150 / nForce 630i]" },
		Device { id: 0x07E1, name: "C73 [GeForce 7100 / nForce 630i]" },
		Device { id: 0x07E2, name: "C73 [GeForce 7050 / nForce 630i]" },
		Device { id: 0x07E3, name: "C73 [GeForce 7050 / nForce 610i]" },
		Device { id: 0x07E5, name: "C73 [GeForce 7100 / nForce 620i]" },
		Device { id: 0x07F0, name: "MCP73 SATA Controller (IDE mode)" },
		Device { id: 0x07F4, name: "GeForce 7100/nForce 630i SATA" },
		Device { id: 0x07F8, name: "MCP73 SATA RAID Controller" },
		Device { id: 0x07FC, name: "MCP73 High Definition Audio" },
		Device { id: 0x07FE, name: "MCP73 OHCI USB 1.1 Controller" },
		Device { id: 0x0840, name: "C77 [GeForce 8200M]" },
		Device { id: 0x0844, name: "C77 [GeForce 9100M G]" },
		Device { id: 0x0845, name: "C77 [GeForce 8200M G]" },
		Device { id: 0x0846, name: "C77 [GeForce 9200]" },
		Device { id: 0x0847, name: "C78 [GeForce 9100]" },
		Device { id: 0x0848, name: "C77 [GeForce 8300]" },
		Device { id: 0x0849, name: "C77 [GeForce 8200]" },
		Device { id: 0x084A, name: "C77 [nForce 730a]" },
		Device { id: 0x084B, name: "C77 [GeForce 8200]" },
		Device { id: 0x084C, name: "C77 [nForce 780a/980a SLI]" },
		Device { id: 0x084D, name: "C77 [nForce 750a SLI]" },
		Device { id: 0x084F, name: "C77 [GeForce 8100 / nForce 720a]" },
		Device { id: 0x0860, name: "C79 [GeForce 9300]" },
		Device { id: 0x0861, name: "C79 [GeForce 9400]" },
		Device { id: 0x0862, name: "C79 [GeForce 9400M G]" },
		Device { id: 0x0863, name: "C79 [GeForce 9400M]" },
		Device { id: 0x0864, name: "C79 [GeForce 9300]" },
		Device { id: 0x0865, name: "C79 [GeForce 9300/ION]" },
		Device { id: 0x0866, name: "C79 [GeForce 9400M G]" },
		Device { id: 0x0867, name: "C79 [GeForce 9400]" },
		Device { id: 0x0868, name: "C79 [nForce 760i SLI]" },
		Device { id: 0x0869, name: "MCP7A [GeForce 9400]" },
		Device { id: 0x086A, name: "C79 [GeForce 9400]" },
		Device { id: 0x086C, name: "C79 [GeForce 9300 / nForce 730i]" },
		Device { id: 0x086D, name: "C79 [GeForce 9200]" },
		Device { id: 0x086E, name: "C79 [GeForce 9100M G]" },
		Device { id: 0x086F, name: "MCP79 [GeForce 8200M G]" },
		Device { id: 0x0870, name: "C79 [GeForce 9400M]" },
		Device { id: 0x0871, name: "C79 [GeForce 9200]" },
		Device { id: 0x0872, name: "C79 [GeForce G102M]" },
		Device { id: 0x0873, name: "C79 [GeForce G102M]" },
		Device { id: 0x0874, name: "C79 [ION]" },
		Device { id: 0x0876, name: "ION VGA [GeForce 9400M]" },
		Device { id: 0x087A, name: "C79 [GeForce 9400]" },
		Device { id: 0x087D, name: "ION VGA" },
		Device { id: 0x087E, name: "ION LE VGA" },
		Device { id: 0x087F, name: "ION LE VGA" },
		Device { id: 0x08A0, name: "MCP89 [GeForce 320M]" },
		Device { id: 0x08A2, name: "MCP89 [GeForce 320M]" },
		Device { id: 0x08A3, name: "MCP89 [GeForce 320M]" },
		Device { id: 0x08A4, name: "MCP89 [GeForce 320M]" },
		Device { id: 0x08A5, name: "MCP89 [GeForce 320M]" },
		Device { id: 0x0A20, name: "GT216 [GeForce GT 220]" },
		Device { id: 0x0A21, name: "GT216M [GeForce GT 330M]" },
		Device { id: 0x0A22, name: "GT216 [GeForce 315]" },
		Device { id: 0x0A23, name: "GT216 [GeForce 210]" },
		Device { id: 0x0A26, name: "GT216 [GeForce 405]" },
		Device { id: 0x0A27, name: "GT216 [GeForce 405]" },
		Device { id: 0x0A28, name: "GT216M [GeForce GT 230M]" },
		Device { id: 0x0A29, name: "GT216M [GeForce GT 330M]" },
		Device { id: 0x0A2A, name: "GT216M [GeForce GT 230M]" },
		Device { id: 0x0A2B, name: "GT216M [GeForce GT 330M]" },
		Device { id: 0x0A2C, name: "GT216M [NVS 5100M]" },
		Device { id: 0x0A2D, name: "GT216M [GeForce GT 320M]" },
		Device { id: 0x0A30, name: "GT216 [GeForce 505]" },
		Device { id: 0x0A32, name: "GT216 [GeForce GT 415]" },
		Device { id: 0x0A34, name: "GT216M [GeForce GT 240M]" },
		Device { id: 0x0A35, name: "GT216M [GeForce GT 325M]" },
		Device { id: 0x0A38, name: "GT216GL [Quadro 400]" },
		Device { id: 0x0A3C, name: "GT216GLM [Quadro FX 880M]" },
		Device { id: 0x0A60, name: "GT218 [GeForce G210]" },
		Device { id: 0x0A62, name: "GT218 [GeForce 205]" },
		Device { id: 0x0A63, name: "GT218 [GeForce 310]" },
		Device { id: 0x0A64, name: "GT218 [ION]" },
		Device { id: 0x0A65, name: "GT218 [GeForce 210]" },
		Device { id: 0x0A66, name: "GT218 [GeForce 310]" },
		Device { id: 0x0A67, name: "GT218 [GeForce 315]" },
		Device { id: 0x0A68, name: "GT218M [GeForce G 105M]" },
		Device { id: 0x0A69, name: "GT218M [GeForce G 105M]" },
		Device { id: 0x0A6A, name: "GT218M [NVS 2100M]" },
		Device { id: 0x0A6C, name: "GT218M [NVS 3100M]" },
		Device { id: 0x0A6E, name: "GT218M [GeForce 305M]" },
		Device { id: 0x0A6F, name: "GT218 [ION]" },
		Device { id: 0x0A70, name: "GT218M [GeForce 310M]" },
		Device { id: 0x0A71, name: "GT218M [GeForce 305M]" },
		Device { id: 0x0A72, name: "GT218M [GeForce 310M]" },
		Device { id: 0x0A73, name: "GT218M [GeForce 305M]" },
		Device { id: 0x0A74, name: "GT218M [GeForce G210M]" },
		Device { id: 0x0A75, name: "GT218M [GeForce 310M]" },
		Device { id: 0x0A76, name: "GT218 [ION 2]" },
		Device { id: 0x0A78, name: "GT218GL [Quadro FX 380 LP]" },
		Device { id: 0x0A7A, name: "GT218M [GeForce 315M]" },
		Device { id: 0x0A7B, name: "GT218 [GeForce 505]" },
		Device { id: 0x0A7C, name: "GT218GLM [Quadro FX 380M]" },
		Device { id: 0x0A80, name: "MCP79 Host Bridge" },
		Device { id: 0x0A81, name: "MCP79 Host Bridge" },
		Device { id: 0x0A82, name: "MCP79 Host Bridge" },
		Device { id: 0x0A83, name: "MCP79 Host Bridge" },
		Device { id: 0x0A84, name: "MCP79 Host Bridge" },
		Device { id: 0x0A85, name: "MCP79 Host Bridge" },
		Device { id: 0x0A86, name: "MCP79 Host Bridge" },
		Device { id: 0x0A87, name: "MCP79 Host Bridge" },
		Device { id: 0x0A88, name: "MCP79 Memory Controller" },
		Device { id: 0x0A89, name: "MCP79 Memory Controller" },
		Device { id: 0x0A98, name: "MCP79 Memory Controller" },
		Device { id: 0x0AA0, name: "MCP79 PCI Express Bridge" },
		Device { id: 0x0AA2, name: "MCP79 SMBus" },
		Device { id: 0x0AA3, name: "MCP79 Co-processor" },
		Device { id: 0x0AA4, name: "MCP79 Memory Controller" },
		Device { id: 0x0AA5, name: "MCP79 OHCI USB 1.1 Controller" },
		Device { id: 0x0AA6, name: "MCP79 EHCI USB 2.0 Controller" },
		Device { id: 0x0AA7, name: "MCP79 OHCI USB 1.1 Controller" },
		Device { id: 0x0AA8, name: "MCP79 OHCI USB 1.1 Controller" },
		Device { id: 0x0AA9, name: "MCP79 EHCI USB 2.0 Controller" },
		Device { id: 0x0AAA, name: "MCP79 EHCI USB 2.0 Controller" },
		Device { id: 0x0AAB, name: "MCP79 PCI Bridge" },
		Device { id: 0x0AAC, name: "MCP79 LPC Bridge" },
		Device { id: 0x0AAD, name: "MCP79 LPC Bridge" },
		Device { id: 0x0AAE, name: "MCP79 LPC Bridge" },
		Device { id: 0x0AAF, name: "MCP79 LPC Bridge" },
		Device { id: 0x0AB0, name: "MCP79 Ethernet" },
		Device { id: 0x0AB1, name: "MCP79 Ethernet" },
		Device { id: 0x0AB2, name: "MCP79 Ethernet" },
		Device { id: 0x0AB3, name: "MCP79 Ethernet" },
		Device { id: 0x0AB4, name: "MCP79 SATA Controller" },
		Device { id: 0x0AB5, name: "MCP79 SATA Controller" },
		Device { id: 0x0AB6, name: "MCP79 SATA Controller" },
		Device { id: 0x0AB7, name: "MCP79 SATA Controller" },
		Device { id: 0x0AB8, name: "MCP79 AHCI Controller" },
		Device { id: 0x0AB9, name: "MCP79 AHCI Controller" },
		Device { id: 0x0ABA, name: "MCP79 AHCI Controller" },
		Device { id: 0x0ABB, name: "MCP79 AHCI Controller" },
		Device { id: 0x0ABC, name: "MCP79 RAID Controller" },
		Device { id: 0x0ABD, name: "MCP79 RAID Controller" },
		Device { id: 0x0ABE, name: "MCP79 RAID Controller" },
		Device { id: 0x0ABF, name: "MCP79 RAID Controller" },
		Device { id: 0x0AC0, name: "MCP79 High Definition Audio" },
		Device { id: 0x0AC1, name: "MCP79 High Definition Audio" },
		Device { id: 0x0AC2, name: "MCP79 High Definition Audio" },
		Device { id: 0x0AC3, name: "MCP79 High Definition Audio" },
		Device { id: 0x0AC4, name: "MCP79 PCI Express Bridge" },
		Device { id: 0x0AC5, name: "MCP79 PCI Express Bridge" },
		Device { id: 0x0AC6, name: "MCP79 PCI Express Bridge" },
		Device { id: 0x0AC7, name: "MCP79 PCI Express Bridge" },
		Device { id: 0x0AC8, name: "MCP79 PCI Express Bridge" },
		Device { id: 0x0AD0, name: "MCP78S [GeForce 8200] SATA Controller (non-AHCI mode)" },
		Device { id: 0x0AD4, name: "MCP78S [GeForce 8200] AHCI Controller" },
		Device { id: 0x0AD8, name: "MCP78S [GeForce 8200] SATA Controller (RAID mode)" },
		Device { id: 0x0BE2, name: "GT216 HDMI Audio Controller" },
		Device { id: 0x0BE3, name: "High Definition Audio Controller" },
		Device { id: 0x0BE4, name: "High Definition Audio Controller" },
		Device { id: 0x0BE5, name: "GF100 High Definition Audio Controller" },
		Device { id: 0x0BE9, name: "GF106 High Definition Audio Controller" },
		Device { id: 0x0BEA, name: "GF108 High Definition Audio Controller" },
		Device { id: 0x0BEB, name: "GF104 High Definition Audio Controller" },
		Device { id: 0x0BEE, name: "GF116 High Definition Audio Controller" },
		Device { id: 0x0BF0, name: "Tegra2 PCIe x4 Bridge" },
		Device { id: 0x0BF1, name: "Tegra2 PCIe x2 Bridge" },
		Device { id: 0x0CA0, name: "GT215 [GeForce GT 330]" },
		Device { id: 0x0CA2, name: "GT215 [GeForce GT 320]" },
		Device { id: 0x0CA3, name: "GT215 [GeForce GT 240]" },
		Device { id: 0x0CA4, name: "GT215 [GeForce GT 340]" },
		Device { id: 0x0CA5, name: "GT215 [GeForce GT 220]" },
		Device { id: 0x0CA7, name: "GT215 [GeForce GT 330]" },
		Device { id: 0x0CA8, name: "GT215M [GeForce GTS 260M]" },
		Device { id: 0x0CA9, name: "GT215M [GeForce GTS 250M]" },
		Device { id: 0x0CAC, name: "GT215 [GeForce GT 220/315]" },
		Device { id: 0x0CAF, name: "GT215M [GeForce GT 335M]" },
		Device { id: 0x0CB0, name: "GT215M [GeForce GTS 350M]" },
		Device { id: 0x0CB1, name: "GT215M [GeForce GTS 360M]" },
		Device { id: 0x0CBC, name: "GT215GLM [Quadro FX 1800M]" },
		Device { id: 0x0D60, name: "MCP89 HOST Bridge" },
		Device { id: 0x0D68, name: "MCP89 Memory Controller" },
		Device { id: 0x0D69, name: "MCP89 Memory Controller" },
		Device { id: 0x0D76, name: "MCP89 PCI Express Bridge" },
		Device { id: 0x0D79, name: "MCP89 SMBus" },
		Device { id: 0x0D7A, name: "MCP89 Co-Processor" },
		Device { id: 0x0D7B, name: "MCP89 Memory Controller" },
		Device { id: 0x0D7D, name: "MCP89 Ethernet" },
		Device { id: 0x0D80, name: "MCP89 LPC Bridge" },
		Device { id: 0x0D85, name: "MCP89 SATA Controller" },
		Device { id: 0x0D88, name: "MCP89 SATA Controller (AHCI mode)" },
		Device { id: 0x0D89, name: "MCP89 SATA Controller (AHCI mode)" },
		Device { id: 0x0D8D, name: "MCP89 SATA Controller (RAID mode)" },
		Device { id: 0x0D94, name: "MCP89 High Definition Audio" },
		Device { id: 0x0D9C, name: "MCP89 OHCI USB 1.1 Controller" },
		Device { id: 0x0D9D, name: "MCP89 EHCI USB 2.0 Controller" },
		Device { id: 0x0DC0, name: "GF106 [GeForce GT 440]" },
		Device { id: 0x0DC4, name: "GF106 [GeForce GTS 450]" },
		Device { id: 0x0DC5, name: "GF106 [GeForce GTS 450 OEM]" },
		Device { id: 0x0DC6, name: "GF106 [GeForce GTS 450 OEM]" },
		Device { id: 0x0DCD, name: "GF106M [GeForce GT 555M]" },
		Device { id: 0x0DCE, name: "GF106M [GeForce GT 555M]" },
		Device { id: 0x0DD1, name: "GF106M [GeForce GTX 460M]" },
		Device { id: 0x0DD2, name: "GF106M [GeForce GT 445M]" },
		Device { id: 0x0DD3, name: "GF106M [GeForce GT 435M]" },
		Device { id: 0x0DD6, name: "GF106M [GeForce GT 550M]" },
		Device { id: 0x0DD8, name: "GF106GL [Quadro 2000]" },
		Device { id: 0x0DDA, name: "GF106GLM [Quadro 2000M]" },
		Device { id: 0x0DE0, name: "GF108 [GeForce GT 440]" },
		Device { id: 0x0DE1, name: "GF108 [GeForce GT 430]" },
		Device { id: 0x0DE2, name: "GF108 [GeForce GT 420]" },
		Device { id: 0x0DE3, name: "GF108M [GeForce GT 635M]" },
		Device { id: 0x0DE4, name: "GF108 [GeForce GT 520]" },
		Device { id: 0x0DE5, name: "GF108 [GeForce GT 530]" },
		Device { id: 0x0DE7, name: "GF108 [GeForce GT 610]" },
		Device { id: 0x0DE8, name: "GF108M [GeForce GT 620M]" },
		Device { id: 0x0DE9, name: "GF108M [GeForce GT 620M/630M/635M/640M LE]" },
		Device { id: 0x0DEA, name: "GF108M [GeForce 610M]" },
		Device { id: 0x0DEB, name: "GF108M [GeForce GT 555M]" },
		Device { id: 0x0DEC, name: "GF108M [GeForce GT 525M]" },
		Device { id: 0x0DED, name: "GF108M [GeForce GT 520M]" },
		Device { id: 0x0DEE, name: "GF108M [GeForce GT 415M]" },
		Device { id: 0x0DEF, name: "GF108M [NVS 5400M]" },
		Device { id: 0x0DF0, name: "GF108M [GeForce GT 425M]" },
		Device { id: 0x0DF1, name: "GF108M [GeForce GT 420M]" },
		Device { id: 0x0DF2, name: "GF108M [GeForce GT 435M]" },
		Device { id: 0x0DF3, name: "GF108M [GeForce GT 420M]" },
		Device { id: 0x0DF4, name: "GF108M [GeForce GT 540M]" },
		Device { id: 0x0DF5, name: "GF108M [GeForce GT 525M]" },
		Device { id: 0x0DF6, name: "GF108M [GeForce GT 550M]" },
		Device { id: 0x0DF7, name: "GF108M [GeForce GT 520M]" },
		Device { id: 0x0DF8, name: "GF108GL [Quadro 600]" },
		Device { id: 0x0DF9, name: "GF108GLM [Quadro 500M]" },
		Device { id: 0x0DFA, name: "GF108GLM [Quadro 1000M]" },
		Device { id: 0x0DFC, name: "GF108GLM [NVS 5200M]" },
		Device { id: 0x0E08, name: "GF119 HDMI Audio Controller" },
		Device { id: 0x0E09, name: "GF110 High Definition Audio Controller" },
		Device { id: 0x0E0A, name: "GK104 HDMI Audio Controller" },
		Device { id: 0x0E0B, name: "GK106 HDMI Audio Controller" },
		Device { id: 0x0E0C, name: "GF114 HDMI Audio Controller" },
		Device { id: 0x0E0F, name: "GK208 HDMI/DP Audio Controller" },
		Device { id: 0x0E12, name: "TegraK1 PCIe x4 Bridge" },
		Device { id: 0x0E13, name: "TegraK1 PCIe x1 Bridge" },
		Device { id: 0x0E1A, name: "GK110 HDMI Audio" },
		Device { id: 0x0E1B, name: "GK107 HDMI Audio Controller" },
		Device { id: 0x0E1C, name: "Tegra3+ PCIe x4 Bridge" },
		Device { id: 0x0E1D, name: "Tegra3+ PCIe x2 Bridge" },
		Device { id: 0x0E22, name: "GF104 [GeForce GTX 460]" },
		Device { id: 0x0E23, name: "GF104 [GeForce GTX 460 SE]" },
		Device { id: 0x0E24, name: "GF104 [GeForce GTX 460 OEM]" },
		Device { id: 0x0E30, name: "GF104M [GeForce GTX 470M]" },
		Device { id: 0x0E31, name: "GF104M [GeForce GTX 485M]" },
		Device { id: 0x0E3A, name: "GF104GLM [Quadro 3000M]" },
		Device { id: 0x0E3B, name: "GF104GLM [Quadro 4000M]" },
		Device { id: 0x0F00, name: "GF108 [GeForce GT 630]" },
		Device { id: 0x0F01, name: "GF108 [GeForce GT 620]" },
		Device { id: 0x0F02, name: "GF108 [GeForce GT 730]" },
		Device { id: 0x0F06, name: "GF108 [GeForce GT 730]" },
		Device { id: 0x0FB0, name: "GM200 High Definition Audio" },
		Device { id: 0x0FB8, name: "GP108 High Definition Audio Controller" },
		Device { id: 0x0FB9, name: "GP107GL High Definition Audio Controller" },
		Device { id: 0x0FBB, name: "GM204 High Definition Audio Controller" },
		Device { id: 0x0FC0, name: "GK107 [GeForce GT 640 OEM]" },
		Device { id: 0x0FC1, name: "GK107 [GeForce GT 640]" },
		Device { id: 0x0FC2, name: "GK107 [GeForce GT 630 OEM]" },
		Device { id: 0x0FC6, name: "GK107 [GeForce GTX 650]" },
		Device { id: 0x0FC8, name: "GK107 [GeForce GT 740]" },
		Device { id: 0x0FC9, name: "GK107 [GeForce GT 730]" },
		Device { id: 0x0FCD, name: "GK107M [GeForce GT 755M]" },
		Device { id: 0x0FCE, name: "GK107M [GeForce GT 640M LE]" },
		Device { id: 0x0FD1, name: "GK107M [GeForce GT 650M]" },
		Device { id: 0x0FD2, name: "GK107M [GeForce GT 640M]" },
		Device { id: 0x0FD3, name: "GK107M [GeForce GT 640M LE]" },
		Device { id: 0x0FD4, name: "GK107M [GeForce GTX 660M]" },
		Device { id: 0x0FD5, name: "GK107M [GeForce GT 650M Mac Edition]" },
		Device { id: 0x0FD8, name: "GK107M [GeForce GT 640M Mac Edition]" },
		Device { id: 0x0FD9, name: "GK107M [GeForce GT 645M]" },
		Device { id: 0x0FDB, name: "GK107M" },
		Device { id: 0x0FDF, name: "GK107M [GeForce GT 740M]" },
		Device { id: 0x0FE0, name: "GK107M [GeForce GTX 660M Mac Edition]" },
		Device { id: 0x0FE1, name: "GK107M [GeForce GT 730M]" },
		Device { id: 0x0FE2, name: "GK107M [GeForce GT 745M]" },
		Device { id: 0x0FE3, name: "GK107M [GeForce GT 745M]" },
		Device { id: 0x0FE4, name: "GK107M [GeForce GT 750M]" },
		Device { id: 0x0FE5, name: "GK107 [GeForce K340 USM]" },
		Device { id: 0x0FE6, name: "GK107 [GRID K1 NVS USM]" },
		Device { id: 0x0FE7, name: "GK107GL [GRID K100 vGPU]" },
		Device { id: 0x0FE9, name: "GK107M [GeForce GT 750M Mac Edition]" },
		Device { id: 0x0FEA, name: "GK107M [GeForce GT 755M Mac Edition]" },
		Device { id: 0x0FEC, name: "GK107M [GeForce 710A]" },
		Device { id: 0x0FED, name: "GK107M [GeForce 820M]" },
		Device { id: 0x0FEE, name: "GK107M [GeForce 810M]" },
		Device { id: 0x0FEF, name: "GK107GL [GRID K340]" },
		Device { id: 0x0FF1, name: "GK107 [NVS 1000]" },
		Device { id: 0x0FF2, name: "GK107GL [GRID K1]" },
		Device { id: 0x0FF3, name: "GK107GL [Quadro K420]" },
		Device { id: 0x0FF5, name: "GK107GL [GRID K1 Tesla USM]" },
		Device { id: 0x0FF6, name: "GK107GLM [Quadro K1100M]" },
		Device { id: 0x0FF7, name: "GK107GL [GRID K140Q vGPU]" },
		Device { id: 0x0FF8, name: "GK107GLM [Quadro K500M]" },
		Device { id: 0x0FF9, name: "GK107GL [Quadro K2000D]" },
		Device { id: 0x0FFA, name: "GK107GL [Quadro K600]" },
		Device { id: 0x0FFB, name: "GK107GLM [Quadro K2000M]" },
		Device { id: 0x0FFC, name: "GK107GLM [Quadro K1000M]" },
		Device { id: 0x0FFD, name: "GK107 [NVS 510]" },
		Device { id: 0x0FFE, name: "GK107GL [Quadro K2000]" },
		Device { id: 0x0FFF, name: "GK107GL [Quadro 410]" },
		Device { id: 0x1001, name: "GK110B [GeForce GTX TITAN Z]" },
		Device { id: 0x1003, name: "GK110 [GeForce GTX Titan LE]" },
		Device { id: 0x1004, name: "GK110 [GeForce GTX 780]" },
		Device { id: 0x1005, name: "GK110 [GeForce GTX TITAN]" },
		Device { id: 0x1007, name: "GK110 [GeForce GTX 780 Rev. 2]" },
		Device { id: 0x1008, name: "GK110 [GeForce GTX 780 Ti Rev. 2]" },
		Device { id: 0x100A, name: "GK110B [GeForce GTX 780 Ti]" },
		Device { id: 0x100C, name: "GK110B [GeForce GTX TITAN Black]" },
		Device { id: 0x101E, name: "GK110GL [Tesla K20X]" },
		Device { id: 0x101F, name: "GK110GL [Tesla K20]" },
		Device { id: 0x1020, name: "GK110GL [Tesla K20X]" },
		Device { id: 0x1021, name: "GK110GL [Tesla K20Xm]" },
		Device { id: 0x1022, name: "GK110GL [Tesla K20c]" },
		Device { id: 0x1023, name: "GK110BGL [Tesla K40m]" },
		Device { id: 0x1024, name: "GK110BGL [Tesla K40c]" },
		Device { id: 0x1026, name: "GK110GL [Tesla K20s]" },
		Device { id: 0x1027, name: "GK110BGL [Tesla K40st]" },
		Device { id: 0x1028, name: "GK110GL [Tesla K20m]" },
		Device { id: 0x1029, name: "GK110BGL [Tesla K40s]" },
		Device { id: 0x102A, name: "GK110BGL [Tesla K40t]" },
		Device { id: 0x102D, name: "GK210GL [Tesla K80]" },
		Device { id: 0x102E, name: "GK110BGL [Tesla K40d]" },
		Device { id: 0x103A, name: "GK110GL [Quadro K6000]" },
		Device { id: 0x103C, name: "GK110GL [Quadro K5200]" },
		Device { id: 0x1040, name: "GF119 [GeForce GT 520]" },
		Device { id: 0x1042, name: "GF119 [GeForce 510]" },
		Device { id: 0x1048, name: "GF119 [GeForce 605]" },
		Device { id: 0x1049, name: "GF119 [GeForce GT 620 OEM]" },
		Device { id: 0x104A, name: "GF119 [GeForce GT 610]" },
		Device { id: 0x104B, name: "GF119 [GeForce GT 625 OEM]" },
		Device { id: 0x104C, name: "GF119 [GeForce GT 705]" },
		Device { id: 0x104D, name: "GF119 [GeForce GT 710]" },
		Device { id: 0x1050, name: "GF119M [GeForce GT 520M]" },
		Device { id: 0x1051, name: "GF119M [GeForce GT 520MX]" },
		Device { id: 0x1052, name: "GF119M [GeForce GT 520M]" },
		Device { id: 0x1054, name: "GF119M [GeForce 410M]" },
		Device { id: 0x1055, name: "GF119M [GeForce 410M]" },
		Device { id: 0x1056, name: "GF119M [NVS 4200M]" },
		Device { id: 0x1057, name: "GF119M [Quadro NVS 4200M]" },
		Device { id: 0x1058, name: "GF119M [GeForce 610M]" },
		Device { id: 0x1059, name: "GF119M [GeForce 610M]" },
		Device { id: 0x105A, name: "GF119M [GeForce 610M]" },
		Device { id: 0x105B, name: "GF119M [GeForce 705M]" },
		Device { id: 0x107C, name: "GF119 [NVS 315]" },
		Device { id: 0x107D, name: "GF119 [NVS 310]" },
		Device { id: 0x1080, name: "GF110 [GeForce GTX 580]" },
		Device { id: 0x1081, name: "GF110 [GeForce GTX 570]" },
		Device { id: 0x1082, name: "GF110 [GeForce GTX 560 Ti OEM]" },
		Device { id: 0x1084, name: "GF110 [GeForce GTX 560 OEM]" },
		Device { id: 0x1086, name: "GF110 [GeForce GTX 570 Rev. 2]" },
		Device { id: 0x1087, name: "GF110 [GeForce GTX 560 Ti 448 Cores]" },
		Device { id: 0x1088, name: "GF110 [GeForce GTX 590]" },
		Device { id: 0x1089, name: "GF110 [GeForce GTX 580 Rev. 2]" },
		Device { id: 0x108B, name: "GF110 [GeForce GTX 580]" },
		Device { id: 0x108E, name: "GF110GL [Tesla C2090]" },
		Device { id: 0x1091, name: "GF110GL [Tesla M2090]" },
		Device { id: 0x1094, name: "GF110GL [Tesla M2075]" },
		Device { id: 0x1096, name: "GF110GL [Tesla C2050 / C2075]" },
		Device { id: 0x109A, name: "GF100GLM [Quadro 5010M]" },
		Device { id: 0x109B, name: "GF100GL [Quadro 7000]" },
		Device { id: 0x10C0, name: "GT218 [GeForce 9300 GS Rev. 2]" },
		Device { id: 0x10C3, name: "GT218 [GeForce 8400 GS Rev. 3]" },
		Device { id: 0x10C5, name: "GT218 [GeForce 405]" },
		Device { id: 0x10D8, name: "GT218 [NVS 300]" },
		Device { id: 0x10EF, name: "GP102 HDMI Audio Controller" },
		Device { id: 0x10F0, name: "GP104 High Definition Audio Controller" },
		Device { id: 0x10F1, name: "GP106 High Definition Audio Controller" },
		Device { id: 0x1140, name: "GF117M [GeForce 610M/710M/810M/820M / GT 620M/625M/630M/720M]" },
		Device { id: 0x1180, name: "GK104 [GeForce GTX 680]" },
		Device { id: 0x1182, name: "GK104 [GeForce GTX 760 Ti]" },
		Device { id: 0x1183, name: "GK104 [GeForce GTX 660 Ti]" },
		Device { id: 0x1184, name: "GK104 [GeForce GTX 770]" },
		Device { id: 0x1185, name: "GK104 [GeForce GTX 660 OEM]" },
		Device { id: 0x1187, name: "GK104 [GeForce GTX 760]" },
		Device { id: 0x1188, name: "GK104 [GeForce GTX 690]" },
		Device { id: 0x1189, name: "GK104 [GeForce GTX 670]" },
		Device { id: 0x118A, name: "GK104GL [GRID K520]" },
		Device { id: 0x118B, name: "GK104GL [GRID K2 GeForce USM]" },
		Device { id: 0x118C, name: "GK104 [GRID K2 NVS USM]" },
		Device { id: 0x118D, name: "GK104GL [GRID K200 vGPU]" },
		Device { id: 0x118E, name: "GK104 [GeForce GTX 760 OEM]" },
		Device { id: 0x118F, name: "GK104GL [Tesla K10]" },
		Device { id: 0x1191, name: "GK104 [GeForce GTX 760 Rev. 2]" },
		Device { id: 0x1193, name: "GK104 [GeForce GTX 760 Ti OEM]" },
		Device { id: 0x1194, name: "GK104GL [Tesla K8]" },
		Device { id: 0x1195, name: "GK104 [GeForce GTX 660 Rev. 2]" },
		Device { id: 0x1198, name: "GK104M [GeForce GTX 880M]" },
		Device { id: 0x1199, name: "GK104M [GeForce GTX 870M]" },
		Device { id: 0x119A, name: "GK104M [GeForce GTX 860M]" },
		Device { id: 0x119D, name: "GK104M [GeForce GTX 775M Mac Edition]" },
		Device { id: 0x119E, name: "GK104M [GeForce GTX 780M Mac Edition]" },
		Device { id: 0x119F, name: "GK104M [GeForce GTX 780M]" },
		Device { id: 0x11A0, name: "GK104M [GeForce GTX 680M]" },
		Device { id: 0x11A1, name: "GK104M [GeForce GTX 670MX]" },
		Device { id: 0x11A2, name: "GK104M [GeForce GTX 675MX Mac Edition]" },
		Device { id: 0x11A3, name: "GK104M [GeForce GTX 680MX]" },
		Device { id: 0x11A7, name: "GK104M [GeForce GTX 675MX]" },
		Device { id: 0x11B0, name: "GK104GL [GRID K240Q\\K260Q vGPU]" },
		Device { id: 0x11B1, name: "GK104GL [GRID K2 Tesla USM]" },
		Device { id: 0x11B4, name: "GK104GL [Quadro K4200]" },
		Device { id: 0x11B6, name: "GK104GLM [Quadro K3100M]" },
		Device { id: 0x11B7, name: "GK104GLM [Quadro K4100M]" },
		Device { id: 0x11B8, name: "GK104GLM [Quadro K5100M]" },
		Device { id: 0x11BA, name: "GK104GL [Quadro K5000]" },
		Device { id: 0x11BB, name: "GK104GL [Quadro 4100]" },
		Device { id: 0x11BC, name: "GK104GLM [Quadro K5000M]" },
		Device { id: 0x11BD, name: "GK104GLM [Quadro K4000M]" },
		Device { id: 0x11BE, name: "GK104GLM [Quadro K3000M]" },
		Device { id: 0x11BF, name: "GK104GL [GRID K2]" },
		Device { id: 0x11C0, name: "GK106 [GeForce GTX 660]" },
		Device { id: 0x11C2, name: "GK106 [GeForce GTX 650 Ti Boost]" },
		Device { id: 0x11C3, name: "GK106 [GeForce GTX 650 Ti OEM]" },
		Device { id: 0x11C4, name: "GK106 [GeForce GTX 645 OEM]" },
		Device { id: 0x11C5, name: "GK106 [GeForce GT 740]" },
		Device { id: 0x11C6, name: "GK106 [GeForce GTX 650 Ti]" },
		Device { id: 0x11C7, name: "GK106 [GeForce GTX 750 Ti]" },
		Device { id: 0x11C8, name: "GK106 [GeForce GTX 650 OEM]" },
		Device { id: 0x11CB, name: "GK106 [GeForce GT 740]" },
		Device { id: 0x11E0, name: "GK106M [GeForce GTX 770M]" },
		Device { id: 0x11E1, name: "GK106M [GeForce GTX 765M]" },
		Device { id: 0x11E2, name: "GK106M [GeForce GTX 765M]" },
		Device { id: 0x11E3, name: "GK106M [GeForce GTX 760M]" },
		Device { id: 0x11E7, name: "GK106M" },
		Device { id: 0x11FA, name: "GK106GL [Quadro K4000]" },
		Device { id: 0x11FC, name: "GK106GLM [Quadro K2100M]" },
		Device { id: 0x1200, name: "GF114 [GeForce GTX 560 Ti]" },
		Device { id: 0x1201, name: "GF114 [GeForce GTX 560]" },
		Device { id: 0x1202, name: "GF114 [GeForce GTX 560 Ti OEM]" },
		Device { id: 0x1203, name: "GF114 [GeForce GTX 460 SE v2]" },
		Device { id: 0x1205, name: "GF114 [GeForce GTX 460 v2]" },
		Device { id: 0x1206, name: "GF114 [GeForce GTX 555]" },
		Device { id: 0x1207, name: "GF114 [GeForce GT 645 OEM]" },
		Device { id: 0x1208, name: "GF114 [GeForce GTX 560 SE]" },
		Device { id: 0x1210, name: "GF114M [GeForce GTX 570M]" },
		Device { id: 0x1211, name: "GF114M [GeForce GTX 580M]" },
		Device { id: 0x1212, name: "GF114M [GeForce GTX 675M]" },
		Device { id: 0x1213, name: "GF114M [GeForce GTX 670M]" },
		Device { id: 0x1241, name: "GF116 [GeForce GT 545 OEM]" },
		Device { id: 0x1243, name: "GF116 [GeForce GT 545]" },
		Device { id: 0x1244, name: "GF116 [GeForce GTX 550 Ti]" },
		Device { id: 0x1245, name: "GF116 [GeForce GTS 450 Rev. 2]" },
		Device { id: 0x1246, name: "GF116M [GeForce GT 550M]" },
		Device { id: 0x1247, name: "GF116M [GeForce GT 555M/635M]" },
		Device { id: 0x1248, name: "GF116M [GeForce GT 555M/635M]" },
		Device { id: 0x1249, name: "GF116 [GeForce GTS 450 Rev. 3]" },
		Device { id: 0x124B, name: "GF116 [GeForce GT 640 OEM]" },
		Device { id: 0x124D, name: "GF116M [GeForce GT 555M/635M]" },
		Device { id: 0x1251, name: "GF116M [GeForce GT 560M]" },
		Device { id: 0x1280, name: "GK208 [GeForce GT 635]" },
		Device { id: 0x1281, name: "GK208 [GeForce GT 710]" },
		Device { id: 0x1282, name: "GK208 [GeForce GT 640 Rev. 2]" },
		Device { id: 0x1284, name: "GK208 [GeForce GT 630 Rev. 2]" },
		Device { id: 0x1286, name: "GK208 [GeForce GT 720]" },
		Device { id: 0x1287, name: "GK208B [GeForce GT 730]" },
		Device { id: 0x1288, name: "GK208B [GeForce GT 720]" },
		Device { id: 0x1289, name: "GK208 [GeForce GT 710]" },
		Device { id: 0x128B, name: "GK208B [GeForce GT 710]" },
		Device { id: 0x1290, name: "GK208M [GeForce GT 730M]" },
		Device { id: 0x1291, name: "GK208M [GeForce GT 735M]" },
		Device { id: 0x1292, name: "GK208M [GeForce GT 740M]" },
		Device { id: 0x1293, name: "GK208M [GeForce GT 730M]" },
		Device { id: 0x1294, name: "GK208M [GeForce GT 740M]" },
		Device { id: 0x1295, name: "GK208M [GeForce 710M]" },
		Device { id: 0x1296, name: "GK208M [GeForce 825M]" },
		Device { id: 0x1298, name: "GK208M [GeForce GT 720M]" },
		Device { id: 0x1299, name: "GK208BM [GeForce 920M]" },
		Device { id: 0x129A, name: "GK208BM [GeForce 910M]" },
		Device { id: 0x12A0, name: "GK208" },
		Device { id: 0x12B9, name: "GK208GLM [Quadro K610M]" },
		Device { id: 0x12BA, name: "GK208GLM [Quadro K510M]" },
		Device { id: 0x1340, name: "GM108M [GeForce 830M]" },
		Device { id: 0x1341, name: "GM108M [GeForce 840M]" },
		Device { id: 0x1344, name: "GM108M [GeForce 845M]" },
		Device { id: 0x1346, name: "GM108M [GeForce 930M]" },
		Device { id: 0x1347, name: "GM108M [GeForce 940M]" },
		Device { id: 0x1348, name: "GM108M [GeForce 945M / 945A]" },
		Device { id: 0x1349, name: "GM108M [GeForce 930M]" },
		Device { id: 0x134B, name: "GM108M [GeForce 940MX]" },
		Device { id: 0x134D, name: "GM108M [GeForce 940MX]" },
		Device { id: 0x134E, name: "GM108M [GeForce 930MX]" },
		Device { id: 0x134F, name: "GM108M [GeForce 920MX]" },
		Device { id: 0x137A, name: "GM108GLM [Quadro K620M / Quadro M500M]" },
		Device { id: 0x137B, name: "GM108GLM [Quadro M520 Mobile]" },
		Device { id: 0x137D, name: "GM108M [GeForce 940A]" },
		Device { id: 0x1380, name: "GM107 [GeForce GTX 750 Ti]" },
		Device { id: 0x1381, name: "GM107 [GeForce GTX 750]" },
		Device { id: 0x1382, name: "GM107 [GeForce GTX 745]" },
		Device { id: 0x1389, name: "GM107GL [GRID M30]" },
		Device { id: 0x1390, name: "GM107M [GeForce 845M]" },
		Device { id: 0x1391, name: "GM107M [GeForce GTX 850M]" },
		Device { id: 0x1392, name: "GM107M [GeForce GTX 860M]" },
		Device { id: 0x1393, name: "GM107M [GeForce 840M]" },
		Device { id: 0x1398, name: "GM107M [GeForce 845M]" },
		Device { id: 0x139A, name: "GM107M [GeForce GTX 950M]" },
		Device { id: 0x139B, name: "GM107M [GeForce GTX 960M]" },
		Device { id: 0x139C, name: "GM107M [GeForce 940M]" },
		Device { id: 0x139D, name: "GM107M [GeForce GTX 750 Ti]" },
		Device { id: 0x13B0, name: "GM107GLM [Quadro M2000M]" },
		Device { id: 0x13B1, name: "GM107GLM [Quadro M1000M]" },
		Device { id: 0x13B2, name: "GM107GLM [Quadro M600M]" },
		Device { id: 0x13B3, name: "GM107GLM [Quadro K2200M]" },
		Device { id: 0x13B4, name: "GM107GLM [Quadro M620 Mobile]" },
		Device { id: 0x13B6, name: "GM107GLM [Quadro M1200 Mobile]" },
		Device { id: 0x13B9, name: "GM107GL [NVS 810]" },
		Device { id: 0x13BA, name: "GM107GL [Quadro K2200]" },
		Device { id: 0x13BB, name: "GM107GL [Quadro K620]" },
		Device { id: 0x13BC, name: "GM107GL [Quadro K1200]" },
		Device { id: 0x13BD, name: "GM107GL [Tesla M10]" },
		Device { id: 0x13C0, name: "GM204 [GeForce GTX 980]" },
		Device { id: 0x13C1, name: "GM204" },
		Device { id: 0x13C2, name: "GM204 [GeForce GTX 970]" },
		Device { id: 0x13C3, name: "GM204" },
		Device { id: 0x13D7, name: "GM204M [GeForce GTX 980M]" },
		Device { id: 0x13D8, name: "GM204M [GeForce GTX 970M]" },
		Device { id: 0x13D9, name: "GM204M [GeForce GTX 965M]" },
		Device { id: 0x13DA, name: "GM204M [GeForce GTX 980 Mobile]" },
		Device { id: 0x13E7, name: "GM204 [GeForce GTX 980 Engineering Sample]" },
		Device { id: 0x13F0, name: "GM204GL [Quadro M5000]" },
		Device { id: 0x13F1, name: "GM204GL [Quadro M4000]" },
		Device { id: 0x13F2, name: "GM204GL [Tesla M60]" },
		Device { id: 0x13F3, name: "GM204GL [Tesla M6]" },
		Device { id: 0x13F8, name: "GM204GLM [Quadro M5000M / M5000 SE]" },
		Device { id: 0x13F9, name: "GM204GLM [Quadro M4000M]" },
		Device { id: 0x13FA, name: "GM204GLM [Quadro M3000M]" },
		Device { id: 0x13FB, name: "GM204GLM [Quadro M5500]" },
		Device { id: 0x1401, name: "GM206 [GeForce GTX 960]" },
		Device { id: 0x1402, name: "GM206 [GeForce GTX 950]" },
		Device { id: 0x1406, name: "GM206 [GeForce GTX 960 OEM]" },
		Device { id: 0x1407, name: "GM206 [GeForce GTX 750 v2]" },
		Device { id: 0x1427, name: "GM206M [GeForce GTX 965M]" },
		Device { id: 0x1430, name: "GM206GL [Quadro M2000]" },
		Device { id: 0x1431, name: "GM206GL [Tesla M4]" },
		Device { id: 0x1436, name: "GM206GLM [Quadro M2200 Mobile]" },
		Device { id: 0x15F0, name: "GP100GL [Quadro GP100]" },
		Device { id: 0x15F1, name: "GP100GL" },
		Device { id: 0x15F7, name: "GP100GL [Tesla P100 PCIe 12GB]" },
		Device { id: 0x15F8, name: "GP100GL [Tesla P100 PCIe 16GB]" },
		Device { id: 0x15F9, name: "GP100GL [Tesla P100 SXM2 16GB]" },
		Device { id: 0x1617, name: "GM204M [GeForce GTX 980M]" },
		Device { id: 0x1618, name: "GM204M [GeForce GTX 970M]" },
		Device { id: 0x1619, name: "GM204M [GeForce GTX 965M]" },
		Device { id: 0x161A, name: "GM204M [GeForce GTX 980 Mobile]" },
		Device { id: 0x1667, name: "GM204M [GeForce GTX 965M]" },
		Device { id: 0x1725, name: "GP100" },
		Device { id: 0x172E, name: "GP100" },
		Device { id: 0x172F, name: "GP100" },
		Device { id: 0x174D, name: "GM108M [GeForce MX130]" },
		Device { id: 0x174E, name: "GM108M [GeForce MX110]" },
		Device { id: 0x17C2, name: "GM200 [GeForce GTX TITAN X]" },
		Device { id: 0x17C8, name: "GM200 [GeForce GTX 980 Ti]" },
		Device { id: 0x17F0, name: "GM200GL [Quadro M6000]" },
		Device { id: 0x17F1, name: "GM200GL [Quadro M6000 24GB]" },
		Device { id: 0x17FD, name: "GM200GL [Tesla M40]" },
		Device { id: 0x1B00, name: "GP102 [TITAN X]" },
		Device { id: 0x1B01, name: "GP102" },
		Device { id: 0x1B02, name: "GP102 [TITAN Xp]" },
		Device { id: 0x1B06, name: "GP102 [GeForce GTX 1080 Ti]" },
		Device { id: 0x1B30, name: "GP102GL [Quadro P6000]" },
		Device { id: 0x1B38, name: "GP102GL [Tesla P40]" },
		Device { id: 0x1B70, name: "GP102GL" },
		Device { id: 0x1B78, name: "GP102GL" },
		Device { id: 0x1B80, name: "GP104 [GeForce GTX 1080]" },
		Device { id: 0x1B81, name: "GP104 [GeForce GTX 1070]" },
		Device { id: 0x1B82, name: "GP104 [GeForce GTX 1070 Ti]" },
		Device { id: 0x1B83, name: "GP104" },
		Device { id: 0x1B84, name: "GP104 [GeForce GTX 1060 3GB]" },
		Device { id: 0x1B87, name: "GP104 [P104-100]" },
		Device { id: 0x1BA0, name: "GP104M [GeForce GTX 1080 Mobile]" },
		Device { id: 0x1BA1, name: "GP104M [GeForce GTX 1070 Mobile]" },
		Device { id: 0x1BAD, name: "GP104 [GeForce GTX 1070 Engineering Sample]" },
		Device { id: 0x1BB0, name: "GP104GL [Quadro P5000]" },
		Device { id: 0x1BB1, name: "GP104GL [Quadro P4000]" },
		Device { id: 0x1BB3, name: "GP104GL [Tesla P4]" },
		Device { id: 0x1BB4, name: "GP104GL [Tesla P6]" },
		Device { id: 0x1BB5, name: "GP104GLM [Quadro P5200 Mobile]" },
		Device { id: 0x1BB6, name: "GP104GLM [Quadro P5000 Mobile]" },
		Device { id: 0x1BB7, name: "GP104GLM [Quadro P4000 Mobile]" },
		Device { id: 0x1BB8, name: "GP104GLM [Quadro P3000 Mobile]" },
		Device { id: 0x1BE0, name: "GP104M [GeForce GTX 1080 Mobile]" },
		Device { id: 0x1BE1, name: "GP104M [GeForce GTX 1070 Mobile]" },
		Device { id: 0x1C00, name: "GP106" },
		Device { id: 0x1C01, name: "GP106" },
		Device { id: 0x1C02, name: "GP106 [GeForce GTX 1060 3GB]" },
		Device { id: 0x1C03, name: "GP106 [GeForce GTX 1060 6GB]" },
		Device { id: 0x1C07, name: "GP106 [P106-100]" },
		Device { id: 0x1C09, name: "GP106 [P106-090]" },
		Device { id: 0x1C20, name: "GP106M [GeForce GTX 1060 Mobile]" },
		Device { id: 0x1C21, name: "GP106M [GeForce GTX 1050 Ti Mobile]" },
		Device { id: 0x1C22, name: "GP106M [GeForce GTX 1050 Mobile]" },
		Device { id: 0x1C30, name: "GP106GL [Quadro P2000]" },
		Device { id: 0x1C35, name: "GP106" },
		Device { id: 0x1C60, name: "GP106M [GeForce GTX 1060 Mobile 6GB]" },
		Device { id: 0x1C61, name: "GP106M [GeForce GTX 1050 Ti Mobile]" },
		Device { id: 0x1C62, name: "GP106M [GeForce GTX 1050 Mobile]" },
		Device { id: 0x1C70, name: "GP106GL" },
		Device { id: 0x1C80, name: "GP107" },
		Device { id: 0x1C81, name: "GP107 [GeForce GTX 1050]" },
		Device { id: 0x1C82, name: "GP107 [GeForce GTX 1050 Ti]" },
		Device { id: 0x1C8C, name: "GP107M [GeForce GTX 1050 Ti Mobile]" },
		Device { id: 0x1C8D, name: "GP107M [GeForce GTX 1050 Mobile]" },
		Device { id: 0x1C8E, name: "GP107M" },
		Device { id: 0x1CA7, name: "GP107GL" },
		Device { id: 0x1CA8, name: "GP107GL" },
		Device { id: 0x1CAA, name: "GP107GL" },
		Device { id: 0x1CB1, name: "GP107GL [Quadro P1000]" },
		Device { id: 0x1CB2, name: "GP107GL [Quadro P600]" },
		Device { id: 0x1CB3, name: "GP107GL [Quadro P400]" },
		Device { id: 0x1D01, name: "GP108 [GeForce GT 1030]" },
		Device { id: 0x1D10, name: "GP108M [GeForce MX150]" },
		Device { id: 0x1D81, name: "GV100" },
		Device { id: 0x1DB1, name: "GV100 [Tesla V100 SXM2]" },
		Device { id: 0x1DB4, name: "GV100 [Tesla V100 PCIe]" },
	] },
	Vendor { id: 0x10DF, name: "Emulex Corporation", devices: &[
		Device { id: 0x0720, name: "OneConnect NIC (Skyhawk)" },
		Device { id: 0x0722, name: "OneConnect iSCSI Initiator (Skyhawk)" },
		Device { id: 0x0723, name: "OneConnect iSCSI Initiator + Target (Skyhawk)" },
		Device { id: 0x0724, name: "OneConnect FCoE Initiator (Skyhawk)" },
		Device { id: 0x0728, name: "OneConnect NIC (Skyhawk-VF)" },
		Device { id: 0x072A, name: "OneConnect iSCSI Initiator (Skyhawk-VF)" },
		Device { id: 0x072B, name: "OneConnect iSCSI Initiator + Target (Skyhawk-VF)" },
		Device { id: 0x072C, name: "OneConnect FCoE Initiator (Skyhawk-VF)" },
		Device { id: 0x1AE5, name: "LP6000 Fibre Channel Host Adapter" },
		Device { id: 0xE100, name: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter" },
		Device { id: 0xE131, name: "LightPulse 8Gb/s PCIe Shared I/O Fibre Channel Adapter" },
		Device { id: 0xE180, name: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter" },
		Device { id: 0xE200, name: "LightPulse LPe16002" },
		Device { id: 0xE208, name: "LightPulse 16Gb Fibre Channel Host Adapter (Lancer-VF)" },
		Device { id: 0xE220, name: "OneConnect NIC (Lancer)" },
		Device { id: 0xE240, name: "OneConnect iSCSI Initiator (Lancer)" },
		Device { id: 0xE260, name: "OneConnect FCoE Initiator (Lancer)" },
		Device { id: 0xE268, name: "OneConnect 10Gb FCoE Converged Network Adapter (Lancer-VF)" },
		Device { id: 0xE300, name: "Lancer Gen6: LPe32000 Fibre Channel Host Adapter" },
		Device { id: 0xF011, name: "Saturn: LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF015, name: "Saturn: LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF085, name: "LP850 Fibre Channel Host Adapter" },
		Device { id: 0xF095, name: "LP952 Fibre Channel Host Adapter" },
		Device { id: 0xF098, name: "LP982 Fibre Channel Host Adapter" },
		Device { id: 0xF0A1, name: "Thor LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF0A5, name: "Thor LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF0B5, name: "Viper LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF0D1, name: "Helios LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF0D5, name: "Helios LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF0E1, name: "Zephyr LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF0E5, name: "Zephyr LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF0F5, name: "Neptune LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF100, name: "Saturn-X: LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF111, name: "Saturn-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF112, name: "Saturn-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xF180, name: "LPSe12002 EmulexSecure Fibre Channel Adapter" },
		Device { id: 0xF400, name: "LPe36000 Fibre Channel Host Adapter [Prism]" },
		Device { id: 0xF700, name: "LP7000 Fibre Channel Host Adapter" },
		Device { id: 0xF701, name: "LP7000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)" },
		Device { id: 0xF800, name: "LP8000 Fibre Channel Host Adapter" },
		Device { id: 0xF801, name: "LP8000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)" },
		Device { id: 0xF900, name: "LP9000 Fibre Channel Host Adapter" },
		Device { id: 0xF901, name: "LP9000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)" },
		Device { id: 0xF980, name: "LP9802 Fibre Channel Host Adapter" },
		Device { id: 0xF981, name: "LP9802 Fibre Channel Host Adapter Alternate ID" },
		Device { id: 0xF982, name: "LP9802 Fibre Channel Host Adapter Alternate ID" },
		Device { id: 0xFA00, name: "Thor-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFB00, name: "Viper LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFC00, name: "Thor-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFC10, name: "Helios-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFC20, name: "Zephyr-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFC40, name: "Saturn-X: LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFC50, name: "Proteus-X: LightPulse IOV Fibre Channel Host Adapter" },
		Device { id: 0xFD00, name: "Helios-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFD11, name: "Helios-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFD12, name: "Helios-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFE00, name: "Zephyr-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFE05, name: "Zephyr-X: LightPulse FCoE Adapter" },
		Device { id: 0xFE11, name: "Zephyr-X LightPulse Fibre Channel Host Adapter" },
		Device { id: 0xFE12, name: "Zephyr-X LightPulse FCoE Adapter" },
		Device { id: 0xFF00, name: "Neptune LightPulse Fibre Channel Host Adapter" },
	] },
	Vendor { id: 0x10E0, name: "Integrated Micro Solutions Inc.", devices: &[
		Device { id: 0x5026, name: "IMS5026/27/28" },
		Device { id: 0x5027, name: "IMS5027" },
		Device { id: 0x5028, name: "IMS5028" },
		Device { id: 0x8849, name: "IMS8849" },
		Device { id: 0x8853, name: "IMS8853" },
		Device { id: 0x9128, name: "IMS9128 [Twin turbo 128]" },
	] },
	Vendor { id: 0x10E1, name: "Tekram Technology Co.,Ltd.", devices: &[
		Device { id: 0x0391, name: "TRM-S1040" },
		Device { id: 0x690C, name: "DC-690c" },
		Device { id: 0xDC29, name: "DC-290" },
	] },
	Vendor { id: 0x10E2, name: "Aptix Corporation", devices: &[
	] },
	Vendor { id: 0x10E3, name: "Tundra Semiconductor Corp.", devices: &[
		Device { id: 0x0000, name: "CA91C042 [Universe]" },
		Device { id: 0x0108, name: "Tsi108 Host Bridge for Single PowerPC" },
		Device { id: 0x0148, name: "Tsi148 [Tempe]" },
		Device { id: 0x0860, name: "CA91C860 [QSpan]" },
		Device { id: 0x0862, name: "CA91C862A [QSpan-II]" },
		Device { id: 0x8260, name: "CA91L8200B [Dual PCI PowerSpan II]" },
		Device { id: 0x8261, name: "CA91L8260B [Single PCI PowerSpan II]" },
		Device { id: 0xA108, name: "Tsi109 Host Bridge for Dual PowerPC" },
	] },
	Vendor { id: 0x10E4, name: "Tandem Computers", devices: &[
		Device { id: 0x8029, name: "Realtek 8029 Network Card" },
	] },
	Vendor { id: 0x10E5, name: "Micro Industries Corporation", devices: &[
	] },
	Vendor { id: 0x10E6, name: "Gainbery Computer Products Inc.", devices: &[
	] },
	Vendor { id: 0x10E7, name: "Vadem", devices: &[
	] },
	Vendor { id: 0x10E8, name: "Applied Micro Circuits Corp.", devices: &[
		Device { id: 0x1072, name: "INES GPIB-PCI (AMCC5920 based)" },
		Device { id: 0x2011, name: "Q-Motion Video Capture/Edit board" },
		Device { id: 0x4750, name: "S5930 [Matchmaker]" },
		Device { id: 0x5920, name: "S5920" },
		Device { id: 0x8043, name: "LANai4.x [Myrinet LANai interface chip]" },
		Device { id: 0x8062, name: "S5933_PARASTATION" },
		Device { id: 0x807D, name: "S5933 [Matchmaker]" },
		Device { id: 0x8088, name: "Kongsberg Spacetec Format Synchronizer" },
		Device { id: 0x8089, name: "Kongsberg Spacetec Serial Output Board" },
		Device { id: 0x809C, name: "S5933_HEPC3" },
		Device { id: 0x80B9, name: "Harmonix Hi-Card P8 (4x active ISDN BRI)" },
		Device { id: 0x80D7, name: "PCI-9112" },
		Device { id: 0x80D8, name: "PCI-7200" },
		Device { id: 0x80D9, name: "PCI-9118" },
		Device { id: 0x80DA, name: "PCI-9812" },
		Device { id: 0x80FC, name: "APCI1500 Signal processing controller (16 dig. inputs + 16 dig. outputs)" },
		Device { id: 0x811A, name: "PCI-IEEE1355-DS-DE Interface" },
		Device { id: 0x814C, name: "Fastcom ESCC-PCI (Commtech, Inc.)" },
		Device { id: 0x8170, name: "S5933 [Matchmaker] (Chipset Development Tool)" },
		Device { id: 0x81E6, name: "Multimedia video controller" },
		Device { id: 0x828D, name: "APCI3001 Signal processing controller (up to 16 analog inputs)" },
		Device { id: 0x8291, name: "Fastcom 232/8-PCI (Commtech, Inc.)" },
		Device { id: 0x82C4, name: "Fastcom 422/4-PCI (Commtech, Inc.)" },
		Device { id: 0x82C5, name: "Fastcom 422/2-PCI (Commtech, Inc.)" },
		Device { id: 0x82C6, name: "Fastcom IG422/1-PCI (Commtech, Inc.)" },
		Device { id: 0x82C7, name: "Fastcom IG232/2-PCI (Commtech, Inc.)" },
		Device { id: 0x82CA, name: "Fastcom 232/4-PCI (Commtech, Inc.)" },
		Device { id: 0x82DB, name: "AJA HDNTV HD SDI Framestore" },
		Device { id: 0x82E2, name: "Fastcom DIO24H-PCI (Commtech, Inc.)" },
		Device { id: 0x8406, name: "PCIcanx/PCIcan CAN interface [Kvaser AB]" },
		Device { id: 0x8407, name: "PCIcan II CAN interface (A1021, PCB-07, PCB-08) [Kvaser AB]" },
		Device { id: 0x8851, name: "S5933 on Innes Corp FM Radio Capture card" },
		Device { id: 0xE004, name: "X-Gene PCIe bridge" },
	] },
	Vendor { id: 0x10E9, name: "Alps Electric Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x10EA, name: "Integraphics", devices: &[
		Device { id: 0x1680, name: "IGA-1680" },
		Device { id: 0x1682, name: "IGA-1682" },
		Device { id: 0x1683, name: "IGA-1683" },
		Device { id: 0x2000, name: "CyberPro 2000" },
		Device { id: 0x2010, name: "CyberPro 2000A" },
		Device { id: 0x5000, name: "CyberPro 5000" },
		Device { id: 0x5050, name: "CyberPro 5050" },
		Device { id: 0x5202, name: "CyberPro 5202" },
		Device { id: 0x5252, name: "CyberPro5252" },
	] },
	Vendor { id: 0x10EB, name: "Artists Graphics", devices: &[
		Device { id: 0x0101, name: "3GA" },
		Device { id: 0x8111, name: "Twist3 Frame Grabber" },
	] },
	Vendor { id: 0x10EC, name: "Realtek Semiconductor Co., Ltd.", devices: &[
		Device { id: 0x0139, name: "RTL-8139/8139C/8139C+ Ethernet Controller" },
		Device { id: 0x5208, name: "RTS5208 PCI Express Card Reader" },
		Device { id: 0x5209, name: "RTS5209 PCI Express Card Reader" },
		Device { id: 0x5227, name: "RTS5227 PCI Express Card Reader" },
		Device { id: 0x5229, name: "RTS5229 PCI Express Card Reader" },
		Device { id: 0x522A, name: "RTS522A PCI Express Card Reader" },
		Device { id: 0x5249, name: "RTS5249 PCI Express Card Reader" },
		Device { id: 0x524A, name: "RTS524A PCI Express Card Reader" },
		Device { id: 0x5250, name: "RTS5250 PCI Express Card Reader" },
		Device { id: 0x525A, name: "RTS525A PCI Express Card Reader" },
		Device { id: 0x5286, name: "RTS5286 PCI Express Card Reader" },
		Device { id: 0x5287, name: "RTL8411B PCI Express Card Reader" },
		Device { id: 0x5288, name: "RTS5288 PCI Express Card Reader" },
		Device { id: 0x5289, name: "RTL8411 PCI Express Card Reader" },
		Device { id: 0x8029, name: "RTL-8029(AS)" },
		Device { id: 0x8129, name: "RTL-8129" },
		Device { id: 0x8136, name: "RTL8101/2/6E PCI Express Fast Ethernet controller" },
		Device { id: 0x8138, name: "RT8139 (B/C) Cardbus Fast Ethernet Adapter" },
		Device { id: 0x8139, name: "RTL-8100/8101L/8139 PCI Fast Ethernet Adapter" },
		Device { id: 0x8167, name: "RTL-8110SC/8169SC Gigabit Ethernet" },
		Device { id: 0x8168, name: "RTL8111/8168/8411 PCI Express Gigabit Ethernet Controller" },
		Device { id: 0x8169, name: "RTL8169 PCI Gigabit Ethernet Controller" },
		Device { id: 0x8171, name: "RTL8191SEvA Wireless LAN Controller" },
		Device { id: 0x8172, name: "RTL8191SEvB Wireless LAN Controller" },
		Device { id: 0x8173, name: "RTL8192SE Wireless LAN Controller" },
		Device { id: 0x8174, name: "RTL8192SE Wireless LAN Controller" },
		Device { id: 0x8176, name: "RTL8188CE 802.11b/g/n WiFi Adapter" },
		Device { id: 0x8177, name: "RTL8191CE PCIe Wireless Network Adapter" },
		Device { id: 0x8178, name: "RTL8192CE PCIe Wireless Network Adapter" },
		Device { id: 0x8179, name: "RTL8188EE Wireless Network Adapter" },
		Device { id: 0x8180, name: "RTL8180L 802.11b MAC" },
		Device { id: 0x8185, name: "RTL-8185 IEEE 802.11a/b/g Wireless LAN Controller" },
		Device { id: 0x818B, name: "RTL8192EE PCIe Wireless Network Adapter" },
		Device { id: 0x8190, name: "RTL8190 802.11n PCI Wireless Network Adapter" },
		Device { id: 0x8191, name: "RTL8192CE PCIe Wireless Network Adapter" },
		Device { id: 0x8192, name: "RTL8192E/RTL8192SE Wireless LAN Controller" },
		Device { id: 0x8193, name: "RTL8192DE Wireless LAN Controller" },
		Device { id: 0x8196, name: "RTL8196 Integrated PCI-e Bridge" },
		Device { id: 0x8197, name: "SmartLAN56 56K Modem" },
		Device { id: 0x8199, name: "RTL8187SE Wireless LAN Controller" },
		Device { id: 0x8723, name: "RTL8723AE PCIe Wireless Network Adapter" },
		Device { id: 0x8812, name: "RTL8812AE 802.11ac PCIe Wireless Network Adapter" },
		Device { id: 0x8813, name: "RTL8813AE 802.11ac PCIe Wireless Network Adapter" },
		Device { id: 0x8821, name: "RTL8821AE 802.11ac PCIe Wireless Network Adapter" },
		Device { id: 0xB723, name: "RTL8723BE PCIe Wireless Network Adapter" },
		Device { id: 0xC821, name: "RTL8821CE 802.11ac PCIe Wireless Network Adapter" },
	] },
	Vendor { id: 0x10ED, name: "Ascii Corporation", devices: &[
		Device { id: 0x7310, name: "V7310" },
	] },
	Vendor { id: 0x10EE, name: "Xilinx Corporation", devices: &[
		Device { id: 0x0001, name: "EUROCOM for PCI (ECOMP)" },
		Device { id: 0x0002, name: "Octal E1/T1 for PCI ETP Card" },
		Device { id: 0x0007, name: "Default PCIe endpoint ID" },
		Device { id: 0x0205, name: "Wildcard TE205P" },
		Device { id: 0x0210, name: "Wildcard TE210P" },
		Device { id: 0x0300, name: "Spartan 3 Designs (Xilinx IP)" },
		Device { id: 0x0314, name: "Wildcard TE405P/TE410P (1st Gen)" },
		Device { id: 0x0405, name: "Wildcard TE405P (2nd Gen)" },
		Device { id: 0x0410, name: "Wildcard TE410P (2nd Gen)" },
		Device { id: 0x0600, name: "Xilinx 6 Designs (Xilinx IP)" },
		Device { id: 0x3FC0, name: "RME Digi96" },
		Device { id: 0x3FC1, name: "RME Digi96/8" },
		Device { id: 0x3FC2, name: "RME Digi96/8 Pro" },
		Device { id: 0x3FC3, name: "RME Digi96/8 Pad" },
		Device { id: 0x3FC4, name: "RME Digi9652 (Hammerfall)" },
		Device { id: 0x3FC5, name: "RME Hammerfall DSP" },
		Device { id: 0x3FC6, name: "RME Hammerfall DSP MADI" },
		Device { id: 0x7038, name: "FPGA Card XC7VX690T" },
		Device { id: 0x8380, name: "Ellips ProfiXpress Profibus Master" },
		Device { id: 0x8381, name: "Ellips Santos Frame Grabber" },
		Device { id: 0xD154, name: "Copley Controls CAN card (PCI-CAN-02)" },
		Device { id: 0xEBF0, name: "SED Systems Modulator/Demodulator" },
		Device { id: 0xEBF1, name: "SED Systems Audio Interface Card" },
		Device { id: 0xEBF2, name: "SED Systems Common PCI Interface" },
	] },
	Vendor { id: 0x10EF, name: "Racore Computer Products, Inc.", devices: &[
		Device { id: 0x8154, name: "M815x Token Ring Adapter" },
	] },
	Vendor { id: 0x10F0, name: "Peritek Corporation", devices: &[
	] },
	Vendor { id: 0x10F1, name: "Tyan Computer", devices: &[
		Device { id: 0x2865, name: "Tyan Thunder K8E S2865" },
		Device { id: 0x5300, name: "Tyan S5380 Mainboard" },
	] },
	Vendor { id: 0x10F2, name: "Achme Computer, Inc.", devices: &[
	] },
	Vendor { id: 0x10F3, name: "Alaris, Inc.", devices: &[
	] },
	Vendor { id: 0x10F4, name: "S-MOS Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x10F5, name: "NKK Corporation", devices: &[
		Device { id: 0xA001, name: "NDR4000 [NR4600 Bridge]" },
	] },
	Vendor { id: 0x10F6, name: "Creative Electronic Systems SA", devices: &[
	] },
	Vendor { id: 0x10F7, name: "Matsushita Electric Industrial Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x10F8, name: "Altos India Ltd", devices: &[
	] },
	Vendor { id: 0x10F9, name: "PC Direct", devices: &[
	] },
	Vendor { id: 0x10FA, name: "Truevision", devices: &[
		Device { id: 0x000C, name: "TARGA 1000" },
	] },
	Vendor { id: 0x10FB, name: "Thesys Gesellschaft fuer Mikroelektronik mbH", devices: &[
		Device { id: 0x186F, name: "TH 6255" },
	] },
	Vendor { id: 0x10FC, name: "I-O Data Device, Inc.", devices: &[
		Device { id: 0x0003, name: "Cardbus IDE Controller" },
		Device { id: 0x0005, name: "Cardbus SCSI CBSC II" },
	] },
	Vendor { id: 0x10FD, name: "Soyo Computer, Inc", devices: &[
	] },
	Vendor { id: 0x10FE, name: "Fast Multimedia AG", devices: &[
	] },
	Vendor { id: 0x10FF, name: "NCube", devices: &[
	] },
	Vendor { id: 0x1100, name: "Jazz Multimedia", devices: &[
	] },
	Vendor { id: 0x1101, name: "Initio Corporation", devices: &[
		Device { id: 0x0002, name: "INI-920 Ultra SCSI Adapter" },
		Device { id: 0x1060, name: "INI-A100U2W" },
		Device { id: 0x1622, name: "INI-1623 PCI SATA-II Controller" },
		Device { id: 0x9100, name: "INI-9100/9100W" },
		Device { id: 0x9400, name: "INI-940 Fast Wide SCSI Adapter" },
		Device { id: 0x9401, name: "INI-935 Fast Wide SCSI Adapter" },
		Device { id: 0x9500, name: "INI-950 SCSI Adapter" },
		Device { id: 0x9502, name: "INI-950P Ultra Wide SCSI Adapter" },
	] },
	Vendor { id: 0x1102, name: "Creative Labs", devices: &[
		Device { id: 0x0002, name: "EMU10k1 [Sound Blaster Live! Series]" },
		Device { id: 0x0003, name: "SB AWE64(D)" },
		Device { id: 0x0004, name: "EMU10k2/CA0100/CA0102/CA10200 [Sound Blaster Audigy Series]" },
		Device { id: 0x0005, name: "EMU20k1 [Sound Blaster X-Fi Series]" },
		Device { id: 0x0006, name: "EMU10k1X [SB Live! Value/OEM Series]" },
		Device { id: 0x0007, name: "CA0106/CA0111 [SB Live!/Audigy/X-Fi Series]" },
		Device { id: 0x0008, name: "CA0108/CA10300 [Sound Blaster Audigy Series]" },
		Device { id: 0x0009, name: "CA0110 [Sound Blaster X-Fi Xtreme Audio]" },
		Device { id: 0x000B, name: "EMU20k2 [Sound Blaster X-Fi Titanium Series]" },
		Device { id: 0x0012, name: "Sound Core3D [Sound Blaster Recon3D / Z-Series]" },
		Device { id: 0x4001, name: "SB Audigy FireWire Port" },
		Device { id: 0x7002, name: "SB Live! Game Port" },
		Device { id: 0x7003, name: "SB Audigy Game Port" },
		Device { id: 0x7004, name: "[SB Live! Value] Input device controller" },
		Device { id: 0x7005, name: "SB Audigy LS Game Port" },
		Device { id: 0x7006, name: "[SB X-Fi Xtreme Audio] CA0110-IBG PCIe to PCI Bridge" },
		Device { id: 0x8938, name: "Ectiva EV1938" },
	] },
	Vendor { id: 0x1103, name: "HighPoint Technologies, Inc.", devices: &[
		Device { id: 0x0003, name: "HPT343/345/346/363" },
		Device { id: 0x0004, name: "HPT366/368/370/370A/372/372N" },
		Device { id: 0x0005, name: "HPT372A/372N" },
		Device { id: 0x0006, name: "HPT302/302N" },
		Device { id: 0x0007, name: "HPT371/371N" },
		Device { id: 0x0008, name: "HPT374" },
		Device { id: 0x0009, name: "HPT372N" },
		Device { id: 0x0620, name: "RocketRAID 620 2 Port SATA-III Controller" },
		Device { id: 0x0622, name: "RocketRAID 622 2 Port SATA-III Controller" },
		Device { id: 0x0640, name: "RocketRAID 640 4 Port SATA-III Controller" },
		Device { id: 0x0641, name: "RocketRAID 640L 4 Port SATA-III Controller" },
		Device { id: 0x0642, name: "RocketRAID 642L SATA-III Controller (2 eSATA ports + 2 internal SATA ports)" },
		Device { id: 0x0644, name: "RocketRAID 644 4 Port SATA-III Controller (eSATA)" },
		Device { id: 0x0645, name: "RocketRAID 644L 4 Port SATA-III Controller (eSATA)" },
		Device { id: 0x0646, name: "RocketRAID 644LS SATA-III Controller (4 eSATA devices connected by 1 SAS cable)" },
		Device { id: 0x1720, name: "RocketRAID 1720 (2x SATA II RAID Controller)" },
		Device { id: 0x1740, name: "RocketRAID 1740" },
		Device { id: 0x1742, name: "RocketRAID 1742" },
		Device { id: 0x2210, name: "RocketRAID 2210 SATA-II Controller" },
		Device { id: 0x2300, name: "RocketRAID 230x 4 Port SATA-II Controller" },
		Device { id: 0x2310, name: "RocketRAID 2310 4 Port SATA-II Controller" },
		Device { id: 0x2320, name: "RocketRAID 2320 SATA-II Controller" },
		Device { id: 0x2322, name: "RocketRAID 2322 SATA-II Controller" },
		Device { id: 0x2340, name: "RocketRAID 2340 16 Port SATA-II Controller" },
		Device { id: 0x2640, name: "RocketRAID 2640 SAS/SATA Controller" },
		Device { id: 0x2722, name: "RocketRAID 2722" },
		Device { id: 0x2740, name: "RocketRAID 2740" },
		Device { id: 0x2744, name: "RocketRaid 2744" },
		Device { id: 0x2782, name: "RocketRAID 2782" },
		Device { id: 0x3120, name: "RocketRAID 3120" },
		Device { id: 0x3220, name: "RocketRAID 3220" },
		Device { id: 0x3320, name: "RocketRAID 3320" },
		Device { id: 0x4310, name: "RocketRaid 4310" },
	] },
	Vendor { id: 0x1104, name: "RasterOps Corp.", devices: &[
	] },
	Vendor { id: 0x1105, name: "Sigma Designs, Inc.", devices: &[
		Device { id: 0x1105, name: "REALmagic Xcard MPEG 1/2/3/4 DVD Decoder" },
		Device { id: 0x8300, name: "REALmagic Hollywood Plus DVD Decoder" },
		Device { id: 0x8400, name: "EM840x REALmagic DVD/MPEG-2 Audio/Video Decoder" },
		Device { id: 0x8401, name: "EM8401 REALmagic DVD/MPEG-2 A/V Decoder" },
		Device { id: 0x8470, name: "EM8470 REALmagic DVD/MPEG-4 A/V Decoder" },
		Device { id: 0x8471, name: "EM8471 REALmagic DVD/MPEG-4 A/V Decoder" },
		Device { id: 0x8475, name: "EM8475 REALmagic DVD/MPEG-4 A/V Decoder" },
		Device { id: 0x8476, name: "EM8476 REALmagic DVD/MPEG-4 A/V Decoder" },
		Device { id: 0x8485, name: "EM8485 REALmagic DVD/MPEG-4 A/V Decoder" },
		Device { id: 0x8486, name: "EM8486 REALmagic DVD/MPEG-4 A/V Decoder" },
		Device { id: 0xC621, name: "EM8621L Digital Media Processor" },
		Device { id: 0xC622, name: "EM8622L MPEG-4.10 (H.264) and SMPTE 421M (VC-1) A/V Decoder" },
	] },
	Vendor { id: 0x1106, name: "VIA Technologies, Inc.", devices: &[
		Device { id: 0x0102, name: "Embedded VIA Ethernet Controller" },
		Device { id: 0x0130, name: "VT6305 1394.A Controller" },
		Device { id: 0x0198, name: "P4X600 Host Bridge" },
		Device { id: 0x0204, name: "K8M800 Host Bridge" },
		Device { id: 0x0208, name: "PT890 Host Bridge" },
		Device { id: 0x0238, name: "K8T890 Host Bridge" },
		Device { id: 0x0258, name: "PT880 Host Bridge" },
		Device { id: 0x0259, name: "CN333/CN400/PM880 Host Bridge" },
		Device { id: 0x0269, name: "KT880 Host Bridge" },
		Device { id: 0x0282, name: "K8T800Pro Host Bridge" },
		Device { id: 0x0290, name: "K8M890 Host Bridge" },
		Device { id: 0x0293, name: "PM896 Host Bridge" },
		Device { id: 0x0296, name: "P4M800 Host Bridge" },
		Device { id: 0x0305, name: "VT8363/8365 [KT133/KM133]" },
		Device { id: 0x0308, name: "PT880 Ultra/PT894 Host Bridge" },
		Device { id: 0x0314, name: "CN700/VN800/P4M800CE/Pro Host Bridge" },
		Device { id: 0x0324, name: "CX700/VX700 Host Bridge" },
		Device { id: 0x0327, name: "P4M890 Host Bridge" },
		Device { id: 0x0336, name: "K8M890CE Host Bridge" },
		Device { id: 0x0340, name: "PT900 Host Bridge" },
		Device { id: 0x0351, name: "K8T890CF Host Bridge" },
		Device { id: 0x0353, name: "VX800 Host Bridge" },
		Device { id: 0x0364, name: "CN896/VN896/P4M900 Host Bridge" },
		Device { id: 0x0391, name: "VT8371 [KX133]" },
		Device { id: 0x0409, name: "VX855/VX875 Host Bridge: Host Control" },
		Device { id: 0x0410, name: "VX900 Host Bridge: Host Control" },
		Device { id: 0x0415, name: "VT6415 PATA IDE Host Controller" },
		Device { id: 0x0501, name: "VT8501 [Apollo MVP4]" },
		Device { id: 0x0505, name: "VT82C505" },
		Device { id: 0x0561, name: "VT82C576MV" },
		Device { id: 0x0571, name: "VT82C586A/B/VT82C686/A/B/VT823x/A/C PIPC Bus Master IDE" },
		Device { id: 0x0576, name: "VT82C576 3V [Apollo Master]" },
		Device { id: 0x0581, name: "CX700/VX700 RAID Controller" },
		Device { id: 0x0585, name: "VT82C585VP [Apollo VP1/VPX]" },
		Device { id: 0x0586, name: "VT82C586/A/B PCI-to-ISA [Apollo VP]" },
		Device { id: 0x0591, name: "VT8237A SATA 2-Port Controller" },
		Device { id: 0x0595, name: "VT82C595 [Apollo VP2]" },
		Device { id: 0x0596, name: "VT82C596 ISA [Mobile South]" },
		Device { id: 0x0597, name: "VT82C597 [Apollo VP3]" },
		Device { id: 0x0598, name: "VT82C598 [Apollo MVP3]" },
		Device { id: 0x0601, name: "VT8601 [Apollo ProMedia]" },
		Device { id: 0x0605, name: "VT8605 [ProSavage PM133]" },
		Device { id: 0x0680, name: "VT82C680 [Apollo P6]" },
		Device { id: 0x0686, name: "VT82C686 [Apollo Super South]" },
		Device { id: 0x0691, name: "VT82C693A/694x [Apollo PRO133x]" },
		Device { id: 0x0693, name: "VT82C693 [Apollo Pro Plus]" },
		Device { id: 0x0698, name: "VT82C693A [Apollo Pro133 AGP]" },
		Device { id: 0x0709, name: "VX11 Standard Host Bridge" },
		Device { id: 0x070A, name: "VX11 PCI Express Root Port" },
		Device { id: 0x070B, name: "VX11 PCI Express Root Port" },
		Device { id: 0x070C, name: "VX11 PCI Express Root Port" },
		Device { id: 0x070D, name: "VX11 PCI Express Root Port" },
		Device { id: 0x070E, name: "VX11 PCI Express Root Port" },
		Device { id: 0x0926, name: "VT82C926 [Amazon]" },
		Device { id: 0x1000, name: "VT82C570MV" },
		Device { id: 0x1106, name: "VT82C570MV" },
		Device { id: 0x1122, name: "VX800/VX820 Chrome 9 HC3 Integrated Graphics" },
		Device { id: 0x1204, name: "K8M800 Host Bridge" },
		Device { id: 0x1208, name: "PT890 Host Bridge" },
		Device { id: 0x1238, name: "K8T890 Host Bridge" },
		Device { id: 0x1258, name: "PT880 Host Bridge" },
		Device { id: 0x1259, name: "CN333/CN400/PM880 Host Bridge" },
		Device { id: 0x1269, name: "KT880 Host Bridge" },
		Device { id: 0x1282, name: "K8T800Pro Host Bridge" },
		Device { id: 0x1290, name: "K8M890 Host Bridge" },
		Device { id: 0x1293, name: "PM896 Host Bridge" },
		Device { id: 0x1296, name: "P4M800 Host Bridge" },
		Device { id: 0x1308, name: "PT894 Host Bridge" },
		Device { id: 0x1314, name: "CN700/VN800/P4M800CE/Pro Host Bridge" },
		Device { id: 0x1324, name: "CX700/VX700 Host Bridge" },
		Device { id: 0x1327, name: "P4M890 Host Bridge" },
		Device { id: 0x1336, name: "K8M890CE Host Bridge" },
		Device { id: 0x1340, name: "PT900 Host Bridge" },
		Device { id: 0x1351, name: "VT3351 Host Bridge" },
		Device { id: 0x1353, name: "VX800/VX820 Error Reporting" },
		Device { id: 0x1364, name: "CN896/VN896/P4M900 Host Bridge" },
		Device { id: 0x1409, name: "VX855/VX875 Error Reporting" },
		Device { id: 0x1410, name: "VX900 Error Reporting" },
		Device { id: 0x1571, name: "VT82C576M/VT82C586" },
		Device { id: 0x1595, name: "VT82C595/97 [Apollo VP2/97]" },
		Device { id: 0x1732, name: "VT1732 [Envy24 II] PCI Multi-Channel Audio Controller" },
		Device { id: 0x2106, name: "VIA Rhine Family Fast Ethernet Adapter (VT6105)" },
		Device { id: 0x2204, name: "K8M800 Host Bridge" },
		Device { id: 0x2208, name: "PT890 Host Bridge" },
		Device { id: 0x2238, name: "K8T890 Host Bridge" },
		Device { id: 0x2258, name: "PT880 Host Bridge" },
		Device { id: 0x2259, name: "CN333/CN400/PM880 CPU Host Bridge" },
		Device { id: 0x2269, name: "KT880 Host Bridge" },
		Device { id: 0x2282, name: "K8T800Pro Host Bridge" },
		Device { id: 0x2290, name: "K8M890 Host Bridge" },
		Device { id: 0x2293, name: "PM896 Host Bridge" },
		Device { id: 0x2296, name: "P4M800 Host Bridge" },
		Device { id: 0x2308, name: "PT894 Host Bridge" },
		Device { id: 0x2314, name: "CN700/VN800/P4M800CE/Pro Host Bridge" },
		Device { id: 0x2324, name: "CX700/VX700 Host Bridge" },
		Device { id: 0x2327, name: "P4M890 Host Bridge" },
		Device { id: 0x2336, name: "K8M890CE Host Bridge" },
		Device { id: 0x2340, name: "PT900 Host Bridge" },
		Device { id: 0x2351, name: "VT3351 Host Bridge" },
		Device { id: 0x2353, name: "VX800/VX820 Host Bus Control" },
		Device { id: 0x2364, name: "CN896/VN896/P4M900 Host Bridge" },
		Device { id: 0x2409, name: "VX855/VX875 Host Bus Control" },
		Device { id: 0x2410, name: "VX900 CPU Bus Controller" },
		Device { id: 0x287A, name: "VT8251 PCI to PCI Bridge" },
		Device { id: 0x287B, name: "VT8251 Host Bridge" },
		Device { id: 0x287C, name: "VT8251 PCIE Root Port" },
		Device { id: 0x287D, name: "VT8251 PCIE Root Port" },
		Device { id: 0x287E, name: "VT8237/8251 Ultra VLINK Controller" },
		Device { id: 0x3022, name: "CLE266" },
		Device { id: 0x3038, name: "VT82xx/62xx UHCI USB 1.1 Controller" },
		Device { id: 0x3040, name: "VT82C586B ACPI" },
		Device { id: 0x3043, name: "VT86C100A [Rhine]" },
		Device { id: 0x3044, name: "VT6306/7/8 [Fire II(M)] IEEE 1394 OHCI Controller" },
		Device { id: 0x3050, name: "VT82C596 Power Management" },
		Device { id: 0x3051, name: "VT82C596 Power Management" },
		Device { id: 0x3053, name: "VT6105M [Rhine-III]" },
		Device { id: 0x3057, name: "VT82C686 [Apollo Super ACPI]" },
		Device { id: 0x3058, name: "VT82C686 AC97 Audio Controller" },
		Device { id: 0x3059, name: "VT8233/A/8235/8237 AC97 Audio Controller" },
		Device { id: 0x3065, name: "VT6102/VT6103 [Rhine-II]" },
		Device { id: 0x3068, name: "AC'97 Modem Controller" },
		Device { id: 0x3074, name: "VT8233 PCI to ISA Bridge" },
		Device { id: 0x3091, name: "VT8633 [Apollo Pro266]" },
		Device { id: 0x3099, name: "VT8366/A/7 [Apollo KT266/A/333]" },
		Device { id: 0x3101, name: "VT8653 Host Bridge" },
		Device { id: 0x3102, name: "VT8662 Host Bridge" },
		Device { id: 0x3103, name: "VT8615 Host Bridge" },
		Device { id: 0x3104, name: "USB 2.0" },
		Device { id: 0x3106, name: "VT6105/VT6106S [Rhine-III]" },
		Device { id: 0x3108, name: "K8M800/K8N800/K8N800A [S3 UniChrome Pro]" },
		Device { id: 0x3109, name: "VT8233C PCI to ISA Bridge" },
		Device { id: 0x3112, name: "VT8361 [KLE133] Host Bridge" },
		Device { id: 0x3113, name: "VPX/VPX2 PCI to PCI Bridge Controller" },
		Device { id: 0x3116, name: "VT8375 [KM266/KL266] Host Bridge" },
		Device { id: 0x3118, name: "CN400/PM800/PM880/PN800/PN880 [S3 UniChrome Pro]" },
		Device { id: 0x3119, name: "VT6120/VT6121/VT6122 Gigabit Ethernet Adapter" },
		Device { id: 0x3122, name: "VT8623 [Apollo CLE266] integrated CastleRock graphics" },
		Device { id: 0x3123, name: "VT8623 [Apollo CLE266]" },
		Device { id: 0x3128, name: "VT8753 [P4X266 AGP]" },
		Device { id: 0x3133, name: "VT3133 Host Bridge" },
		Device { id: 0x3142, name: "VT6651 WiFi Adapter, 802.11b" },
		Device { id: 0x3147, name: "VT8233A ISA Bridge" },
		Device { id: 0x3148, name: "P4M266 Host Bridge" },
		Device { id: 0x3149, name: "VIA VT6420 SATA RAID Controller" },
		Device { id: 0x3156, name: "P/KN266 Host Bridge" },
		Device { id: 0x3157, name: "CX700/VX700 [S3 UniChrome Pro]" },
		Device { id: 0x3164, name: "VT6410 ATA133 RAID controller" },
		Device { id: 0x3168, name: "P4X333/P4X400/PT800 AGP Bridge" },
		Device { id: 0x3177, name: "VT8235 ISA Bridge" },
		Device { id: 0x3178, name: "ProSavageDDR P4N333 Host Bridge" },
		Device { id: 0x3188, name: "VT8385 [K8T800 AGP] Host Bridge" },
		Device { id: 0x3189, name: "VT8377 [KT400/KT600 AGP] Host Bridge" },
		Device { id: 0x31B0, name: "VX11 Standard Host Bridge" },
		Device { id: 0x31B1, name: "VX11 Standard Host Bridge" },
		Device { id: 0x31B2, name: "VX11 DRAM Controller" },
		Device { id: 0x31B3, name: "VX11 Power Management Controller" },
		Device { id: 0x31B4, name: "VX11 I/O APIC" },
		Device { id: 0x31B5, name: "VX11 Scratch Device" },
		Device { id: 0x31B7, name: "VX11 Standard Host Bridge" },
		Device { id: 0x31B8, name: "VX11 PCI to PCI Bridge" },
		Device { id: 0x3204, name: "K8M800 Host Bridge" },
		Device { id: 0x3205, name: "VT8378 [KM400/A] Chipset Host Bridge" },
		Device { id: 0x3208, name: "PT890 Host Bridge" },
		Device { id: 0x3213, name: "VPX/VPX2 PCI to PCI Bridge Controller" },
		Device { id: 0x3218, name: "K8T800M Host Bridge" },
		Device { id: 0x3227, name: "VT8237 ISA bridge [KT600/K8T800/K8T890 South]" },
		Device { id: 0x3230, name: "K8M890CE/K8N890CE [Chrome 9]" },
		Device { id: 0x3238, name: "K8T890 Host Bridge" },
		Device { id: 0x3249, name: "VT6421 IDE/SATA Controller" },
		Device { id: 0x324A, name: "CX700/VX700 PCI to PCI Bridge" },
		Device { id: 0x324B, name: "CX700/VX700 Host Bridge" },
		Device { id: 0x324E, name: "CX700/VX700 Internal Module Bus" },
		Device { id: 0x3253, name: "VT6655 WiFi Adapter, 802.11a/b/g" },
		Device { id: 0x3258, name: "PT880 Host Bridge" },
		Device { id: 0x3259, name: "CN333/CN400/PM880 Host Bridge" },
		Device { id: 0x3260, name: "VIA Chrome9 HC IGP" },
		Device { id: 0x3269, name: "KT880 Host Bridge" },
		Device { id: 0x3282, name: "K8T800Pro Host Bridge" },
		Device { id: 0x3287, name: "VT8251 PCI to ISA Bridge" },
		Device { id: 0x3288, name: "VT8237A/VT8251 HDA Controller" },
		Device { id: 0x3290, name: "K8M890 Host Bridge" },
		Device { id: 0x3296, name: "P4M800 Host Bridge" },
		Device { id: 0x3324, name: "CX700/VX700 Host Bridge" },
		Device { id: 0x3327, name: "P4M890 Host Bridge" },
		Device { id: 0x3336, name: "K8M890CE Host Bridge" },
		Device { id: 0x3337, name: "VT8237A PCI to ISA Bridge" },
		Device { id: 0x3340, name: "PT900 Host Bridge" },
		Device { id: 0x3343, name: "P4M890 [S3 UniChrome Pro]" },
		Device { id: 0x3344, name: "CN700/P4M800 Pro/P4M800 CE/VN800 Graphics [S3 UniChrome Pro]" },
		Device { id: 0x3349, name: "VT8251 AHCI/SATA 4-Port Controller" },
		Device { id: 0x3351, name: "VT3351 Host Bridge" },
		Device { id: 0x3353, name: "VX800 PCI to PCI Bridge" },
		Device { id: 0x3364, name: "CN896/VN896/P4M900 Host Bridge" },
		Device { id: 0x3371, name: "CN896/VN896/P4M900 [Chrome 9 HC]" },
		Device { id: 0x3372, name: "VT8237S PCI to ISA Bridge" },
		Device { id: 0x337A, name: "VT8237A PCI to PCI Bridge" },
		Device { id: 0x337B, name: "VT8237A Host Bridge" },
		Device { id: 0x3403, name: "VT6315 Series Firewire Controller" },
		Device { id: 0x3409, name: "VX855/VX875 DRAM Bus Control" },
		Device { id: 0x3410, name: "VX900 DRAM Bus Control" },
		Device { id: 0x3432, name: "VL80x xHCI USB 3.0 Controller" },
		Device { id: 0x3456, name: "VX11 Standard Host Bridge" },
		Device { id: 0x345B, name: "VX11 Miscellaneous Bus" },
		Device { id: 0x3483, name: "VL805 USB 3.0 Host Controller" },
		Device { id: 0x3A01, name: "VX11 Graphics [Chrome 645/640]" },
		Device { id: 0x4149, name: "VIA VT6420 (ATA133) Controller" },
		Device { id: 0x4204, name: "K8M800 Host Bridge" },
		Device { id: 0x4208, name: "PT890 Host Bridge" },
		Device { id: 0x4238, name: "K8T890 Host Bridge" },
		Device { id: 0x4258, name: "PT880 Host Bridge" },
		Device { id: 0x4259, name: "CN333/CN400/PM880 Host Bridge" },
		Device { id: 0x4269, name: "KT880 Host Bridge" },
		Device { id: 0x4282, name: "K8T800Pro Host Bridge" },
		Device { id: 0x4290, name: "K8M890 Host Bridge" },
		Device { id: 0x4293, name: "PM896 Host Bridge" },
		Device { id: 0x4296, name: "P4M800 Host Bridge" },
		Device { id: 0x4308, name: "PT894 Host Bridge" },
		Device { id: 0x4314, name: "CN700/VN800/P4M800CE/Pro Host Bridge" },
		Device { id: 0x4324, name: "CX700/VX700 Host Bridge" },
		Device { id: 0x4327, name: "P4M890 Host Bridge" },
		Device { id: 0x4336, name: "K8M890CE Host Bridge" },
		Device { id: 0x4340, name: "PT900 Host Bridge" },
		Device { id: 0x4351, name: "VT3351 Host Bridge" },
		Device { id: 0x4353, name: "VX800/VX820 Power Management Control" },
		Device { id: 0x4364, name: "CN896/VN896/P4M900 Host Bridge" },
		Device { id: 0x4409, name: "VX855/VX875 Power Management Control" },
		Device { id: 0x4410, name: "VX900 Power Management and Chip Testing Control" },
		Device { id: 0x5030, name: "VT82C596 ACPI [Apollo PRO]" },
		Device { id: 0x5122, name: "VX855/VX875 Chrome 9 HCM Integrated Graphics" },
		Device { id: 0x5208, name: "PT890 I/O APIC Interrupt Controller" },
		Device { id: 0x5238, name: "K8T890 I/O APIC Interrupt Controller" },
		Device { id: 0x5287, name: "VT8251 Serial ATA Controller" },
		Device { id: 0x5290, name: "K8M890 I/O APIC Interrupt Controller" },
		Device { id: 0x5308, name: "PT894 I/O APIC Interrupt Controller" },
		Device { id: 0x5324, name: "VX800 Serial ATA and EIDE Controller" },
		Device { id: 0x5327, name: "P4M890 I/O APIC Interrupt Controller" },
		Device { id: 0x5336, name: "K8M890CE I/O APIC Interrupt Controller" },
		Device { id: 0x5340, name: "PT900 I/O APIC Interrupt Controller" },
		Device { id: 0x5351, name: "VT3351 I/O APIC Interrupt Controller" },
		Device { id: 0x5353, name: "VX800/VX820 APIC and Central Traffic Control" },
		Device { id: 0x5364, name: "CN896/VN896/P4M900 I/O APIC Interrupt Controller" },
		Device { id: 0x5372, name: "VT8237/8251 Serial ATA Controller" },
		Device { id: 0x5409, name: "VX855/VX875 APIC and Central Traffic Control" },
		Device { id: 0x5410, name: "VX900 APIC and Central Traffic Control" },
		Device { id: 0x6100, name: "VT85C100A [Rhine II]" },
		Device { id: 0x6287, name: "SATA RAID Controller" },
		Device { id: 0x6290, name: "K8M890CE Host Bridge" },
		Device { id: 0x6327, name: "P4M890 Security Device" },
		Device { id: 0x6353, name: "VX800/VX820 Scratch Registers" },
		Device { id: 0x6364, name: "CN896/VN896/P4M900 Security Device" },
		Device { id: 0x6409, name: "VX855/VX875 Scratch Registers" },
		Device { id: 0x6410, name: "VX900 Scratch Registers" },
		Device { id: 0x7122, name: "VX900 Graphics [Chrome9 HD]" },
		Device { id: 0x7204, name: "K8M800 Host Bridge" },
		Device { id: 0x7205, name: "KM400/KN400/P4M800 [S3 UniChrome]" },
		Device { id: 0x7208, name: "PT890 Host Bridge" },
		Device { id: 0x7238, name: "K8T890 Host Bridge" },
		Device { id: 0x7258, name: "PT880 Host Bridge" },
		Device { id: 0x7259, name: "CN333/CN400/PM880 Host Bridge" },
		Device { id: 0x7269, name: "KT880 Host Bridge" },
		Device { id: 0x7282, name: "K8T800Pro Host Bridge" },
		Device { id: 0x7290, name: "K8M890 Host Bridge" },
		Device { id: 0x7293, name: "PM896 Host Bridge" },
		Device { id: 0x7296, name: "P4M800 Host Bridge" },
		Device { id: 0x7308, name: "PT894 Host Bridge" },
		Device { id: 0x7314, name: "CN700/VN800/P4M800CE/Pro Host Bridge" },
		Device { id: 0x7324, name: "CX700/VX700 Host Bridge" },
		Device { id: 0x7327, name: "P4M890 Host Bridge" },
		Device { id: 0x7336, name: "K8M890CE Host Bridge" },
		Device { id: 0x7340, name: "PT900 Host Bridge" },
		Device { id: 0x7351, name: "VT3351 Host Bridge" },
		Device { id: 0x7353, name: "VX800/VX820 North-South Module Interface Control" },
		Device { id: 0x7364, name: "CN896/VN896/P4M900 Host Bridge" },
		Device { id: 0x7409, name: "VX855/VX875 North-South Module Interface Control" },
		Device { id: 0x7410, name: "VX900 North-South Module Interface Control" },
		Device { id: 0x8231, name: "VT8231 [PCI-to-ISA Bridge]" },
		Device { id: 0x8235, name: "VT8235 ACPI" },
		Device { id: 0x8305, name: "VT8363/8365 [KT133/KM133 AGP]" },
		Device { id: 0x8324, name: "CX700/VX700 PCI to ISA Bridge" },
		Device { id: 0x8353, name: "VX800/VX820 Bus Control and Power Management" },
		Device { id: 0x8391, name: "VT8371 [KX133 AGP]" },
		Device { id: 0x8400, name: "MVP4" },
		Device { id: 0x8409, name: "VX855/VX875 Bus Control and Power Management" },
		Device { id: 0x8410, name: "VX900 Bus Control and Power Management" },
		Device { id: 0x8500, name: "KLE133/PLE133/PLE133T" },
		Device { id: 0x8501, name: "VT8501 [Apollo MVP4 AGP]" },
		Device { id: 0x8596, name: "VT82C596 [Apollo PRO AGP]" },
		Device { id: 0x8597, name: "VT82C597 [Apollo VP3 AGP]" },
		Device { id: 0x8598, name: "VT82C598/694x [Apollo MVP3/Pro133x AGP]" },
		Device { id: 0x8601, name: "VT8601 [Apollo ProMedia AGP]" },
		Device { id: 0x8605, name: "VT8605 [PM133 AGP]" },
		Device { id: 0x8691, name: "VT82C691 [Apollo Pro]" },
		Device { id: 0x8693, name: "VT82C693 [Apollo Pro Plus] PCI Bridge" },
		Device { id: 0x8A25, name: "PL133/PL133T [S3 ProSavage]" },
		Device { id: 0x8A26, name: "KL133/KL133A/KM133/KM133A [S3 ProSavage]" },
		Device { id: 0x8D01, name: "PN133/PN133T [S3 Twister]" },
		Device { id: 0x8D04, name: "KM266/P4M266/P4M266A/P4N266 [S3 ProSavageDDR]" },
		Device { id: 0x9001, name: "VX900 Serial ATA Controller" },
		Device { id: 0x9082, name: "Standard AHCI 1.0 SATA Controller" },
		Device { id: 0x9140, name: "HDMI Audio Device" },
		Device { id: 0x9201, name: "USB3.0 Controller" },
		Device { id: 0x9530, name: "Secure Digital Memory Card Controller" },
		Device { id: 0x95D0, name: "SDIO Host Controller" },
		Device { id: 0xA208, name: "PT890 PCI to PCI Bridge Controller" },
		Device { id: 0xA238, name: "K8T890 PCI to PCI Bridge Controller" },
		Device { id: 0xA327, name: "P4M890 PCI to PCI Bridge Controller" },
		Device { id: 0xA353, name: "VX8xx South-North Module Interface Control" },
		Device { id: 0xA364, name: "CN896/VN896/P4M900 PCI to PCI Bridge Controller" },
		Device { id: 0xA409, name: "VX855/VX875 USB Device Controller" },
		Device { id: 0xA410, name: "VX900 PCI Express Root Port 0" },
		Device { id: 0xB091, name: "VT8633 [Apollo Pro266 AGP]" },
		Device { id: 0xB099, name: "VT8366/A/7 [Apollo KT266/A/333 AGP]" },
		Device { id: 0xB101, name: "VT8653 AGP Bridge" },
		Device { id: 0xB102, name: "VT8362 AGP Bridge" },
		Device { id: 0xB103, name: "VT8615 AGP Bridge" },
		Device { id: 0xB112, name: "VT8361 [KLE133] AGP Bridge" },
		Device { id: 0xB113, name: "VPX/VPX2 I/O APIC Interrupt Controller" },
		Device { id: 0xB115, name: "VT8363/8365 [KT133/KM133] PCI Bridge" },
		Device { id: 0xB168, name: "VT8235 PCI Bridge" },
		Device { id: 0xB188, name: "VT8237/8251 PCI bridge [K8M890/K8T800/K8T890 South]" },
		Device { id: 0xB198, name: "VT8237/VX700 PCI Bridge" },
		Device { id: 0xB213, name: "VPX/VPX2 I/O APIC Interrupt Controller" },
		Device { id: 0xB353, name: "VX855/VX875/VX900 PCI to PCI Bridge" },
		Device { id: 0xB410, name: "VX900 PCI Express Root Port 1" },
		Device { id: 0xB999, name: "[K8T890 North / VT8237 South] PCI Bridge" },
		Device { id: 0xC208, name: "PT890 PCI to PCI Bridge Controller" },
		Device { id: 0xC238, name: "K8T890 PCI to PCI Bridge Controller" },
		Device { id: 0xC327, name: "P4M890 PCI to PCI Bridge Controller" },
		Device { id: 0xC340, name: "PT900 PCI to PCI Bridge Controller" },
		Device { id: 0xC353, name: "VX800/VX820 PCI Express Root Port" },
		Device { id: 0xC364, name: "CN896/VN896/P4M900 PCI to PCI Bridge Controller" },
		Device { id: 0xC409, name: "VX855/VX875 EIDE Controller" },
		Device { id: 0xC410, name: "VX900 PCI Express Root Port 2" },
		Device { id: 0xD104, name: "VT8237R USB UDCI Controller" },
		Device { id: 0xD208, name: "PT890 PCI to PCI Bridge Controller" },
		Device { id: 0xD213, name: "VPX/VPX2 PCI to PCI Bridge Controller" },
		Device { id: 0xD238, name: "K8T890 PCI to PCI Bridge Controller" },
		Device { id: 0xD340, name: "PT900 PCI to PCI Bridge Controller" },
		Device { id: 0xD410, name: "VX900 PCI Express Root Port 3" },
		Device { id: 0xE208, name: "PT890 PCI to PCI Bridge Controller" },
		Device { id: 0xE238, name: "K8T890 PCI to PCI Bridge Controller" },
		Device { id: 0xE340, name: "PT900 PCI to PCI Bridge Controller" },
		Device { id: 0xE353, name: "VX800/VX820 PCI Express Root Port" },
		Device { id: 0xE410, name: "VX900 PCI Express Physical Layer Electrical Sub-block" },
		Device { id: 0xF208, name: "PT890 PCI to PCI Bridge Controller" },
		Device { id: 0xF238, name: "K8T890 PCI to PCI Bridge Controller" },
		Device { id: 0xF340, name: "PT900 PCI to PCI Bridge Controller" },
		Device { id: 0xF353, name: "VX800/VX820 PCI Express Root Port" },
	] },
	Vendor { id: 0x1107, name: "Stratus Computers", devices: &[
		Device { id: 0x0576, name: "VIA VT82C570MV [Apollo] (Wrong vendor ID!)" },
	] },
	Vendor { id: 0x1108, name: "Proteon, Inc.", devices: &[
		Device { id: 0x0100, name: "p1690plus_AA" },
		Device { id: 0x0101, name: "p1690plus_AB" },
		Device { id: 0x0105, name: "P1690Plus" },
		Device { id: 0x0108, name: "P1690Plus" },
		Device { id: 0x0138, name: "P1690Plus" },
		Device { id: 0x0139, name: "P1690Plus" },
		Device { id: 0x013C, name: "P1690Plus" },
		Device { id: 0x013D, name: "P1690Plus" },
	] },
	Vendor { id: 0x1109, name: "Cogent Data Technologies, Inc.", devices: &[
		Device { id: 0x1400, name: "EM110TX [EX110TX]" },
	] },
	Vendor { id: 0x110A, name: "Siemens AG", devices: &[
		Device { id: 0x0002, name: "Pirahna 2-port" },
		Device { id: 0x0005, name: "Tulip controller, power management, switch extender" },
		Device { id: 0x0006, name: "FSC PINC (I/O-APIC)" },
		Device { id: 0x0015, name: "FSC Multiprocessor Interrupt Controller" },
		Device { id: 0x001D, name: "FSC Copernicus Management Controller" },
		Device { id: 0x007B, name: "FSC Remote Service Controller, mailbox device" },
		Device { id: 0x007C, name: "FSC Remote Service Controller, shared memory device" },
		Device { id: 0x007D, name: "FSC Remote Service Controller, SMIC device" },
		Device { id: 0x2101, name: "HST SAPHIR V Primary PCI (ISDN/PMx)" },
		Device { id: 0x2102, name: "DSCC4 PEB/PEF 20534 DMA Supported Serial Communication Controller with 4 Channels" },
		Device { id: 0x2104, name: "Eicon Diva 2.02 compatible passive ISDN card" },
		Device { id: 0x3141, name: "SIMATIC NET CP 5611 / 5621" },
		Device { id: 0x3142, name: "SIMATIC NET CP 5613 / 5614" },
		Device { id: 0x3143, name: "SIMATIC NET CP 1613" },
		Device { id: 0x4021, name: "SIMATIC NET CP 5512 (Profibus and MPI Cardbus Adapter)" },
		Device { id: 0x4029, name: "SIMATIC NET CP 5613 A2" },
		Device { id: 0x4035, name: "SIMATIC NET CP 1613 A2" },
		Device { id: 0x4036, name: "SIMATIC NET CP 1616" },
		Device { id: 0x4038, name: "SIMATIC NET CP 1604" },
		Device { id: 0x4069, name: "SIMATIC NET CP 5623" },
		Device { id: 0x407C, name: "SIMATIC NET CP 5612" },
		Device { id: 0x407D, name: "SIMATIC NET CP 5613 A3" },
		Device { id: 0x407E, name: "SIMATIC NET CP 5622" },
		Device { id: 0x4083, name: "SIMATIC NET CP 5614 A3" },
		Device { id: 0x4084, name: "SIMATIC NET CP 1626" },
		Device { id: 0x4942, name: "FPGA I-Bus Tracer for MBD" },
		Device { id: 0x6120, name: "SZB6120" },
	] },
	Vendor { id: 0x110B, name: "Chromatic Research Inc.", devices: &[
		Device { id: 0x0001, name: "Mpact Media Processor" },
		Device { id: 0x0004, name: "Mpact 2" },
	] },
	Vendor { id: 0x110C, name: "Mini-Max Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x110D, name: "Znyx Advanced Systems", devices: &[
	] },
	Vendor { id: 0x110E, name: "CPU Technology", devices: &[
	] },
	Vendor { id: 0x110F, name: "Ross Technology", devices: &[
	] },
	Vendor { id: 0x1110, name: "Powerhouse Systems", devices: &[
		Device { id: 0x6037, name: "Firepower Powerized SMP I/O ASIC" },
		Device { id: 0x6073, name: "Firepower Powerized SMP I/O ASIC" },
	] },
	Vendor { id: 0x1111, name: "Santa Cruz Operation", devices: &[
	] },
	Vendor { id: 0x1112, name: "Osicom Technologies Inc", devices: &[
		Device { id: 0x2200, name: "FDDI Adapter" },
		Device { id: 0x2300, name: "Fast Ethernet Adapter" },
		Device { id: 0x2340, name: "4 Port Fast Ethernet Adapter" },
		Device { id: 0x2400, name: "ATM Adapter" },
	] },
	Vendor { id: 0x1113, name: "Accton Technology Corporation", devices: &[
		Device { id: 0x1211, name: "SMC2-1211TX" },
		Device { id: 0x1216, name: "EN-1216 Ethernet Adapter" },
		Device { id: 0x1217, name: "EN-1217 Ethernet Adapter" },
		Device { id: 0x5105, name: "10Mbps Network card" },
		Device { id: 0x9211, name: "EN-1207D Fast Ethernet Adapter" },
		Device { id: 0x9511, name: "21x4x DEC-Tulip compatible Fast Ethernet" },
		Device { id: 0xD301, name: "CPWNA100 (Philips wireless PCMCIA)" },
		Device { id: 0xEC02, name: "SMC 1244TX v3" },
		Device { id: 0xEE23, name: "SMCWPCIT-G 108Mbps Wireless PCI adapter" },
	] },
	Vendor { id: 0x1114, name: "Atmel Corporation", devices: &[
		Device { id: 0x0506, name: "at76c506 802.11b Wireless Network Adaptor" },
	] },
	Vendor { id: 0x1115, name: "3D Labs", devices: &[
	] },
	Vendor { id: 0x1116, name: "Data Translation", devices: &[
		Device { id: 0x0022, name: "DT3001" },
		Device { id: 0x0023, name: "DT3002" },
		Device { id: 0x0024, name: "DT3003" },
		Device { id: 0x0025, name: "DT3004" },
		Device { id: 0x0026, name: "DT3005" },
		Device { id: 0x0027, name: "DT3001-PGL" },
		Device { id: 0x0028, name: "DT3003-PGL" },
		Device { id: 0x0051, name: "DT322" },
		Device { id: 0x0060, name: "DT340" },
		Device { id: 0x0069, name: "DT332" },
		Device { id: 0x80C2, name: "DT3162" },
	] },
	Vendor { id: 0x1117, name: "Datacube, Inc", devices: &[
		Device { id: 0x9500, name: "Max-1C SVGA card" },
		Device { id: 0x9501, name: "Max-1C image processing" },
	] },
	Vendor { id: 0x1118, name: "Berg Electronics", devices: &[
	] },
	Vendor { id: 0x1119, name: "ICP Vortex Computersysteme GmbH", devices: &[
		Device { id: 0x0000, name: "GDT 6000/6020/6050" },
		Device { id: 0x0001, name: "GDT 6000B/6010" },
		Device { id: 0x0002, name: "GDT 6110/6510" },
		Device { id: 0x0003, name: "GDT 6120/6520" },
		Device { id: 0x0004, name: "GDT 6530" },
		Device { id: 0x0005, name: "GDT 6550" },
		Device { id: 0x0006, name: "GDT 6117/6517" },
		Device { id: 0x0007, name: "GDT 6127/6527" },
		Device { id: 0x0008, name: "GDT 6537" },
		Device { id: 0x0009, name: "GDT 6557/6557-ECC" },
		Device { id: 0x000A, name: "GDT 6115/6515" },
		Device { id: 0x000B, name: "GDT 6125/6525" },
		Device { id: 0x000C, name: "GDT 6535" },
		Device { id: 0x000D, name: "GDT 6555/6555-ECC" },
		Device { id: 0x0100, name: "GDT 6117RP/6517RP" },
		Device { id: 0x0101, name: "GDT 6127RP/6527RP" },
		Device { id: 0x0102, name: "GDT 6537RP" },
		Device { id: 0x0103, name: "GDT 6557RP" },
		Device { id: 0x0104, name: "GDT 6111RP/6511RP" },
		Device { id: 0x0105, name: "GDT 6121RP/6521RP" },
		Device { id: 0x0110, name: "GDT 6117RD/6517RD" },
		Device { id: 0x0111, name: "GDT 6127RD/6527RD" },
		Device { id: 0x0112, name: "GDT 6537RD" },
		Device { id: 0x0113, name: "GDT 6557RD" },
		Device { id: 0x0114, name: "GDT 6111RD/6511RD" },
		Device { id: 0x0115, name: "GDT 6121RD/6521RD" },
		Device { id: 0x0118, name: "GDT 6118RD/6518RD/6618RD" },
		Device { id: 0x0119, name: "GDT 6128RD/6528RD/6628RD" },
		Device { id: 0x011A, name: "GDT 6538RD/6638RD" },
		Device { id: 0x011B, name: "GDT 6558RD/6658RD" },
		Device { id: 0x0120, name: "GDT 6117RP2/6517RP2" },
		Device { id: 0x0121, name: "GDT 6127RP2/6527RP2" },
		Device { id: 0x0122, name: "GDT 6537RP2" },
		Device { id: 0x0123, name: "GDT 6557RP2" },
		Device { id: 0x0124, name: "GDT 6111RP2/6511RP2" },
		Device { id: 0x0125, name: "GDT 6121RP2/6521RP2" },
		Device { id: 0x0136, name: "GDT 6113RS/6513RS" },
		Device { id: 0x0137, name: "GDT 6123RS/6523RS" },
		Device { id: 0x0138, name: "GDT 6118RS/6518RS/6618RS" },
		Device { id: 0x0139, name: "GDT 6128RS/6528RS/6628RS" },
		Device { id: 0x013A, name: "GDT 6538RS/6638RS" },
		Device { id: 0x013B, name: "GDT 6558RS/6658RS" },
		Device { id: 0x013C, name: "GDT 6533RS/6633RS" },
		Device { id: 0x013D, name: "GDT 6543RS/6643RS" },
		Device { id: 0x013E, name: "GDT 6553RS/6653RS" },
		Device { id: 0x013F, name: "GDT 6563RS/6663RS" },
		Device { id: 0x0166, name: "GDT 7113RN/7513RN/7613RN" },
		Device { id: 0x0167, name: "GDT 7123RN/7523RN/7623RN" },
		Device { id: 0x0168, name: "GDT 7118RN/7518RN/7518RN" },
		Device { id: 0x0169, name: "GDT 7128RN/7528RN/7628RN" },
		Device { id: 0x016A, name: "GDT 7538RN/7638RN" },
		Device { id: 0x016B, name: "GDT 7558RN/7658RN" },
		Device { id: 0x016C, name: "GDT 7533RN/7633RN" },
		Device { id: 0x016D, name: "GDT 7543RN/7643RN" },
		Device { id: 0x016E, name: "GDT 7553RN/7653RN" },
		Device { id: 0x016F, name: "GDT 7563RN/7663RN" },
		Device { id: 0x01D6, name: "GDT 4x13RZ" },
		Device { id: 0x01D7, name: "GDT 4x23RZ" },
		Device { id: 0x01F6, name: "GDT 8x13RZ" },
		Device { id: 0x01F7, name: "GDT 8x23RZ" },
		Device { id: 0x01FC, name: "GDT 8x33RZ" },
		Device { id: 0x01FD, name: "GDT 8x43RZ" },
		Device { id: 0x01FE, name: "GDT 8x53RZ" },
		Device { id: 0x01FF, name: "GDT 8x63RZ" },
		Device { id: 0x0210, name: "GDT 6519RD/6619RD" },
		Device { id: 0x0211, name: "GDT 6529RD/6629RD" },
		Device { id: 0x0260, name: "GDT 7519RN/7619RN" },
		Device { id: 0x0261, name: "GDT 7529RN/7629RN" },
		Device { id: 0x02FF, name: "GDT MAXRP" },
		Device { id: 0x0300, name: "GDT NEWRX" },
		Device { id: 0x0301, name: "GDT NEWRX2" },
	] },
	Vendor { id: 0x111A, name: "Efficient Networks, Inc", devices: &[
		Device { id: 0x0000, name: "155P-MF1 (FPGA)" },
		Device { id: 0x0002, name: "155P-MF1 (ASIC)" },
		Device { id: 0x0003, name: "ENI-25P ATM" },
		Device { id: 0x0005, name: "SpeedStream (LANAI)" },
		Device { id: 0x0007, name: "SpeedStream ADSL" },
		Device { id: 0x1020, name: "SpeedStream PCI 10/100 Network Card" },
		Device { id: 0x1203, name: "SpeedStream 1023 Wireless PCI Adapter" },
	] },
	Vendor { id: 0x111B, name: "Teledyne Electronic Systems", devices: &[
	] },
	Vendor { id: 0x111C, name: "Tricord Systems Inc.", devices: &[
		Device { id: 0x0001, name: "Powerbis Bridge" },
	] },
	Vendor { id: 0x111D, name: "Integrated Device Technology, Inc. [IDT]", devices: &[
		Device { id: 0x0001, name: "IDT77201/77211 155Mbps ATM SAR Controller [NICStAR]" },
		Device { id: 0x0003, name: "IDT77222/77252 155Mbps ATM MICRO ABR SAR Controller" },
		Device { id: 0x0004, name: "IDT77V252 155Mbps ATM MICRO ABR SAR Controller" },
		Device { id: 0x0005, name: "IDT77V222 155Mbps ATM MICRO ABR SAR Controller" },
		Device { id: 0x8018, name: "PES12N3A PCI Express Switch" },
		Device { id: 0x801C, name: "PES24N3A PCI Express Switch" },
		Device { id: 0x8028, name: "PES4T4 PCI Express Switch" },
		Device { id: 0x802B, name: "PES8T5A PCI Express Switch" },
		Device { id: 0x802C, name: "PES16T4 PCI Express Switch" },
		Device { id: 0x802D, name: "PES16T7 PCI Express Switch" },
		Device { id: 0x802E, name: "PES24T6 PCI Express Switch" },
		Device { id: 0x802F, name: "PES32T8 PCI Express Switch" },
		Device { id: 0x8032, name: "PES48T12 PCI Express Switch" },
		Device { id: 0x8034, name: "PES16/22/34H16 PCI Express Switch" },
		Device { id: 0x8035, name: "PES32H8 PCI Express Switch" },
		Device { id: 0x8036, name: "PES48H12 PCI Express Switch" },
		Device { id: 0x8037, name: "PES64H16 PCI Express Switch" },
		Device { id: 0x8039, name: "PES3T3 PCI Express Switch" },
		Device { id: 0x803A, name: "PES4T4 PCI Express Switch" },
		Device { id: 0x803C, name: "PES5T5 PCI Express Switch" },
		Device { id: 0x803D, name: "PES6T5 PCI Express Switch" },
		Device { id: 0x8048, name: "PES8NT2 PCI Express Switch" },
		Device { id: 0x8049, name: "PES8NT2 PCI Express Switch" },
		Device { id: 0x804A, name: "PES8NT2 PCI Express Internal NTB" },
		Device { id: 0x804B, name: "PES8NT2 PCI Express External NTB" },
		Device { id: 0x804C, name: "PES16NT2 PCI Express Switch" },
		Device { id: 0x804D, name: "PES16NT2 PCI Express Switch" },
		Device { id: 0x804E, name: "PES16NT2 PCI Express Internal NTB" },
		Device { id: 0x804F, name: "PES16NT2 PCI Express External NTB" },
		Device { id: 0x8058, name: "PES12NT3 PCI Express Switch" },
		Device { id: 0x8059, name: "PES12NT3 PCI Express Switch" },
		Device { id: 0x805A, name: "PES12NT3 PCI Express Internal NTB" },
		Device { id: 0x805B, name: "PES12NT3 PCI Express External NTB" },
		Device { id: 0x805C, name: "PES24NT3 PCI Express Switch" },
		Device { id: 0x805D, name: "PES24NT3 PCI Express Switch" },
		Device { id: 0x805E, name: "PES24NT3 PCI Express Internal NTB" },
		Device { id: 0x805F, name: "PES24NT3 PCI Express External NTB" },
		Device { id: 0x8060, name: "PES16T4G2 PCI Express Gen2 Switch" },
		Device { id: 0x8061, name: "PES12T3G2 PCI Express Gen2 Switch" },
		Device { id: 0x8068, name: "PES6T6G2 PCI Express Gen2 Switch" },
		Device { id: 0x806A, name: "PES24T3G2 PCI Express Gen2 Switch" },
		Device { id: 0x806C, name: "PES16T4A/4T4G2 PCI Express Gen2 Switch" },
		Device { id: 0x806E, name: "PES24T6G2 PCI Express Gen2 Switch" },
		Device { id: 0x806F, name: "HIO524G2 PCI Express Gen2 Switch" },
		Device { id: 0x8088, name: "PES32NT8BG2 PCI Express Switch" },
		Device { id: 0x808E, name: "PES24NT24G2 PCI Express Switch" },
		Device { id: 0x808F, name: "PES32NT8AG2" },
		Device { id: 0x80CF, name: "F32P08xG3 [PCIe boot mode]" },
		Device { id: 0x80D2, name: "F32P08xG3 NVMe controller" },
	] },
	Vendor { id: 0x111E, name: "Eldec", devices: &[
	] },
	Vendor { id: 0x111F, name: "Precision Digital Images", devices: &[
		Device { id: 0x4A47, name: "Precision MX Video engine interface" },
		Device { id: 0x5243, name: "Frame capture bus interface" },
	] },
	Vendor { id: 0x1120, name: "Dell EMC", devices: &[
		Device { id: 0x2306, name: "Unity Fibre Channel Controller" },
		Device { id: 0x2501, name: "Unity Ethernet Controller" },
		Device { id: 0x2505, name: "Unity Fibre Channel Controller" },
	] },
	Vendor { id: 0x1121, name: "Zilog", devices: &[
	] },
	Vendor { id: 0x1122, name: "Multi-tech Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x1123, name: "Excellent Design, Inc.", devices: &[
	] },
	Vendor { id: 0x1124, name: "Leutron Vision AG", devices: &[
		Device { id: 0x2581, name: "Picport Monochrome" },
	] },
	Vendor { id: 0x1125, name: "Eurocore", devices: &[
	] },
	Vendor { id: 0x1126, name: "Vigra", devices: &[
	] },
	Vendor { id: 0x1127, name: "FORE Systems Inc", devices: &[
		Device { id: 0x0200, name: "ForeRunner PCA-200 ATM" },
		Device { id: 0x0210, name: "PCA-200PC" },
		Device { id: 0x0250, name: "ATM" },
		Device { id: 0x0300, name: "ForeRunner PCA-200EPC ATM" },
		Device { id: 0x0310, name: "ATM" },
		Device { id: 0x0400, name: "ForeRunnerHE ATM Adapter" },
	] },
	Vendor { id: 0x1129, name: "Firmworks", devices: &[
	] },
	Vendor { id: 0x112A, name: "Hermes Electronics Company, Ltd.", devices: &[
	] },
	Vendor { id: 0x112B, name: "Linotype - Hell AG", devices: &[
	] },
	Vendor { id: 0x112C, name: "Zenith Data Systems", devices: &[
	] },
	Vendor { id: 0x112D, name: "Ravicad", devices: &[
	] },
	Vendor { id: 0x112E, name: "Infomedia Microelectronics Inc.", devices: &[
	] },
	Vendor { id: 0x112F, name: "Dalsa Inc.", devices: &[
		Device { id: 0x0000, name: "MVC IC-PCI" },
		Device { id: 0x0001, name: "MVC IM-PCI Video frame grabber/processor" },
		Device { id: 0x0008, name: "PC-CamLink PCI framegrabber" },
	] },
	Vendor { id: 0x1130, name: "Computervision", devices: &[
	] },
	Vendor { id: 0x1131, name: "Philips Semiconductors", devices: &[
		Device { id: 0x1561, name: "USB 1.1 Host Controller" },
		Device { id: 0x1562, name: "USB 2.0 Host Controller" },
		Device { id: 0x3400, name: "SmartPCI56(UCB1500) 56K Modem" },
		Device { id: 0x5400, name: "TriMedia TM1000/1100" },
		Device { id: 0x5402, name: "TriMedia TM1300" },
		Device { id: 0x5405, name: "TriMedia TM1500" },
		Device { id: 0x5406, name: "TriMedia TM1700" },
		Device { id: 0x540B, name: "PNX1005 Media Processor" },
		Device { id: 0x7130, name: "SAA7130 Video Broadcast Decoder" },
		Device { id: 0x7133, name: "SAA7131/SAA7133/SAA7135 Video Broadcast Decoder" },
		Device { id: 0x7134, name: "SAA7134/SAA7135HL Video Broadcast Decoder" },
		Device { id: 0x7145, name: "SAA7145" },
		Device { id: 0x7146, name: "SAA7146" },
		Device { id: 0x7160, name: "SAA7160" },
		Device { id: 0x7162, name: "SAA7162" },
		Device { id: 0x7164, name: "SAA7164" },
		Device { id: 0x7231, name: "SAA7231" },
		Device { id: 0x9730, name: "SAA9730 Integrated Multimedia and Peripheral Controller" },
	] },
	Vendor { id: 0x1132, name: "Mitel Corp.", devices: &[
	] },
	Vendor { id: 0x1133, name: "Dialogic Corporation", devices: &[
		Device { id: 0x7701, name: "Eiconcard C90" },
		Device { id: 0x7711, name: "Eiconcard C91" },
		Device { id: 0x7901, name: "EiconCard S90" },
		Device { id: 0x7902, name: "EiconCard S90" },
		Device { id: 0x7911, name: "EiconCard S91" },
		Device { id: 0x7912, name: "EiconCard S91" },
		Device { id: 0x7921, name: "Eiconcard S92" },
		Device { id: 0x7941, name: "EiconCard S94" },
		Device { id: 0x7942, name: "EiconCard S94" },
		Device { id: 0x7943, name: "EiconCard S94" },
		Device { id: 0x7944, name: "EiconCard S94" },
		Device { id: 0x7945, name: "Eiconcard S94" },
		Device { id: 0x7948, name: "Eiconcard S94 64bit/66MHz" },
		Device { id: 0x9711, name: "Eiconcard S91 V2" },
		Device { id: 0x9911, name: "Eiconcard S91 V2" },
		Device { id: 0x9941, name: "Eiconcard S94 V2" },
		Device { id: 0x9A41, name: "Eiconcard S94 PCIe" },
		Device { id: 0xB921, name: "EiconCard P92" },
		Device { id: 0xB922, name: "EiconCard P92" },
		Device { id: 0xB923, name: "EiconCard P92" },
		Device { id: 0xE001, name: "Diva Pro 2.0 S/T" },
		Device { id: 0xE002, name: "Diva 2.0 S/T PCI" },
		Device { id: 0xE003, name: "Diva Pro 2.0 U" },
		Device { id: 0xE004, name: "Diva 2.0 U PCI" },
		Device { id: 0xE005, name: "Diva 2.01 S/T PCI" },
		Device { id: 0xE006, name: "Diva CT S/T PCI" },
		Device { id: 0xE007, name: "Diva CT U PCI" },
		Device { id: 0xE008, name: "Diva CT Lite S/T PCI" },
		Device { id: 0xE009, name: "Diva CT Lite U PCI" },
		Device { id: 0xE00A, name: "Diva ISDN+V.90 PCI" },
		Device { id: 0xE00B, name: "Diva ISDN PCI 2.02" },
		Device { id: 0xE00C, name: "Diva 2.02 PCI U" },
		Device { id: 0xE00D, name: "Diva Pro 3.0 PCI" },
		Device { id: 0xE00E, name: "Diva ISDN+CT S/T PCI Rev 2" },
		Device { id: 0xE010, name: "Diva Server BRI-2M PCI" },
		Device { id: 0xE011, name: "Diva Server BRI S/T Rev 2" },
		Device { id: 0xE012, name: "Diva Server 4BRI-8M PCI" },
		Device { id: 0xE013, name: "4BRI" },
		Device { id: 0xE014, name: "Diva Server PRI-30M PCI" },
		Device { id: 0xE015, name: "Diva PRI PCI v2" },
		Device { id: 0xE016, name: "Diva Server Voice 4BRI PCI" },
		Device { id: 0xE017, name: "Diva Server Voice 4BRI Rev 2" },
		Device { id: 0xE018, name: "BRI" },
		Device { id: 0xE019, name: "Diva Server Voice PRI Rev 2" },
		Device { id: 0xE01A, name: "Diva BRI-2FX PCI v2" },
		Device { id: 0xE01B, name: "Diva Server Voice BRI-2M 2.0 PCI" },
		Device { id: 0xE01C, name: "PRI" },
		Device { id: 0xE01E, name: "2PRI" },
		Device { id: 0xE020, name: "4PRI" },
		Device { id: 0xE022, name: "Analog-2" },
		Device { id: 0xE024, name: "Analog-4" },
		Device { id: 0xE028, name: "Analog-8" },
		Device { id: 0xE02A, name: "Diva IPM-300 PCI v1" },
		Device { id: 0xE02C, name: "Diva IPM-600 PCI v1" },
		Device { id: 0xE02E, name: "4BRI" },
		Device { id: 0xE032, name: "BRI" },
		Device { id: 0xE034, name: "Diva BRI-CTI PCI v2" },
	] },
	Vendor { id: 0x1134, name: "Mercury Computer Systems", devices: &[
		Device { id: 0x0001, name: "Raceway Bridge" },
		Device { id: 0x0002, name: "Dual PCI to RapidIO Bridge" },
		Device { id: 0x000B, name: "POET Serial RapidIO Bridge" },
		Device { id: 0x000D, name: "POET PSDMS Device" },
	] },
	Vendor { id: 0x1135, name: "Fuji Xerox Co Ltd", devices: &[
		Device { id: 0x0001, name: "Printer controller" },
	] },
	Vendor { id: 0x1136, name: "Momentum Data Systems", devices: &[
		Device { id: 0x0002, name: "PCI-JTAG" },
	] },
	Vendor { id: 0x1137, name: "Cisco Systems Inc", devices: &[
		Device { id: 0x0023, name: "VIC 81 PCIe Upstream Port" },
		Device { id: 0x0040, name: "VIC PCIe Upstream Port" },
		Device { id: 0x0041, name: "VIC PCIe Downstream Port" },
		Device { id: 0x0042, name: "VIC Management Controller" },
		Device { id: 0x0043, name: "VIC Ethernet NIC" },
		Device { id: 0x0044, name: "VIC Ethernet NIC Dynamic" },
		Device { id: 0x0045, name: "VIC FCoE HBA" },
		Device { id: 0x0046, name: "VIC SCSI Controller" },
		Device { id: 0x004E, name: "VIC 82 PCIe Upstream Port" },
		Device { id: 0x0071, name: "VIC SR-IOV VF" },
		Device { id: 0x007A, name: "VIC 1300 PCIe Upstream Port" },
		Device { id: 0x00CF, name: "VIC Userspace NIC" },
	] },
	Vendor { id: 0x1138, name: "Ziatech Corporation", devices: &[
		Device { id: 0x8905, name: "8905 [STD 32 Bridge]" },
	] },
	Vendor { id: 0x1139, name: "Dynamic Pictures, Inc", devices: &[
		Device { id: 0x0001, name: "VGA Compatible 3D Graphics" },
	] },
	Vendor { id: 0x113A, name: "FWB Inc", devices: &[
	] },
	Vendor { id: 0x113B, name: "Network Computing Devices", devices: &[
	] },
	Vendor { id: 0x113C, name: "Cyclone Microsystems, Inc.", devices: &[
		Device { id: 0x0000, name: "PCI-9060 i960 Bridge" },
		Device { id: 0x0001, name: "PCI-SDK [PCI i960 Evaluation Platform]" },
		Device { id: 0x0911, name: "PCI-911 [i960Jx-based Intelligent I/O Controller]" },
		Device { id: 0x0912, name: "PCI-912 [i960CF-based Intelligent I/O Controller]" },
		Device { id: 0x0913, name: "PCI-913" },
		Device { id: 0x0914, name: "PCI-914 [I/O Controller w/ secondary PCI bus]" },
	] },
	Vendor { id: 0x113D, name: "Leading Edge Products Inc", devices: &[
	] },
	Vendor { id: 0x113E, name: "Sanyo Electric Co - Computer Engineering Dept", devices: &[
	] },
	Vendor { id: 0x113F, name: "Equinox Systems, Inc.", devices: &[
		Device { id: 0x0808, name: "SST-64P Adapter" },
		Device { id: 0x1010, name: "SST-128P Adapter" },
		Device { id: 0x80C0, name: "SST-16P DB Adapter" },
		Device { id: 0x80C4, name: "SST-16P RJ Adapter" },
		Device { id: 0x80C8, name: "SST-16P Adapter" },
		Device { id: 0x8888, name: "SST-4P Adapter" },
		Device { id: 0x9090, name: "SST-8P Adapter" },
	] },
	Vendor { id: 0x1140, name: "Intervoice Inc", devices: &[
	] },
	Vendor { id: 0x1141, name: "Crest Microsystem Inc", devices: &[
	] },
	Vendor { id: 0x1142, name: "Alliance Semiconductor Corporation", devices: &[
		Device { id: 0x3210, name: "AP6410" },
		Device { id: 0x6422, name: "ProVideo 6422" },
		Device { id: 0x6424, name: "ProVideo 6424" },
		Device { id: 0x6425, name: "ProMotion AT25" },
		Device { id: 0x643D, name: "ProMotion AT3D" },
	] },
	Vendor { id: 0x1143, name: "NetPower, Inc", devices: &[
	] },
	Vendor { id: 0x1144, name: "Cincinnati Milacron", devices: &[
		Device { id: 0x0001, name: "Noservo controller" },
	] },
	Vendor { id: 0x1145, name: "Workbit Corporation", devices: &[
		Device { id: 0x8007, name: "NinjaSCSI-32 Workbit" },
		Device { id: 0xF007, name: "NinjaSCSI-32 KME" },
		Device { id: 0xF010, name: "NinjaSCSI-32 Workbit" },
		Device { id: 0xF012, name: "NinjaSCSI-32 Logitec" },
		Device { id: 0xF013, name: "NinjaSCSI-32 Logitec" },
		Device { id: 0xF015, name: "NinjaSCSI-32 Melco" },
		Device { id: 0xF020, name: "NinjaSCSI-32 Sony PCGA-DVD51" },
		Device { id: 0xF021, name: "NinjaPATA-32 Delkin Cardbus UDMA" },
		Device { id: 0xF024, name: "NinjaPATA-32 Delkin Cardbus UDMA" },
		Device { id: 0xF103, name: "NinjaPATA-32 Delkin Cardbus UDMA" },
	] },
	Vendor { id: 0x1146, name: "Force Computers", devices: &[
	] },
	Vendor { id: 0x1147, name: "Interface Corp", devices: &[
	] },
	Vendor { id: 0x1148, name: "SysKonnect", devices: &[
		Device { id: 0x4000, name: "FDDI Adapter" },
		Device { id: 0x4200, name: "Token Ring adapter" },
		Device { id: 0x4300, name: "SK-9872 Gigabit Ethernet Server Adapter (SK-NET GE-ZX dual link)" },
		Device { id: 0x4320, name: "SK-9871 V2.0 Gigabit Ethernet 1000Base-ZX Adapter, PCI64, Fiber ZX/SC" },
		Device { id: 0x4400, name: "SK-9Dxx Gigabit Ethernet Adapter" },
		Device { id: 0x4500, name: "SK-9Mxx Gigabit Ethernet Adapter" },
		Device { id: 0x9000, name: "SK-9S21 10/100/1000Base-T Server Adapter, PCI-X, Copper RJ-45" },
		Device { id: 0x9843, name: "[Fujitsu] Gigabit Ethernet" },
		Device { id: 0x9E00, name: "SK-9E21D 10/100/1000Base-T Adapter, Copper RJ-45" },
		Device { id: 0x9E01, name: "SK-9E21M 10/100/1000Base-T Adapter" },
	] },
	Vendor { id: 0x1149, name: "Win System Corporation", devices: &[
	] },
	Vendor { id: 0x114A, name: "VMIC", devices: &[
		Device { id: 0x5565, name: "GE-IP PCI5565,PMC5565 Reflective Memory Node" },
		Device { id: 0x5579, name: "VMIPCI-5579 (Reflective Memory Card)" },
		Device { id: 0x5587, name: "VMIPCI-5587 (Reflective Memory Card)" },
		Device { id: 0x6504, name: "VMIC PCI 7755 FPGA" },
		Device { id: 0x7587, name: "VMIVME-7587" },
	] },
	Vendor { id: 0x114B, name: "Canopus Co., Ltd", devices: &[
	] },
	Vendor { id: 0x114C, name: "Annabooks", devices: &[
	] },
	Vendor { id: 0x114D, name: "IC Corporation", devices: &[
	] },
	Vendor { id: 0x114E, name: "Nikon Systems Inc", devices: &[
	] },
	Vendor { id: 0x114F, name: "Digi International", devices: &[
		Device { id: 0x0002, name: "AccelePort EPC" },
		Device { id: 0x0003, name: "RightSwitch SE-6" },
		Device { id: 0x0004, name: "AccelePort Xem" },
		Device { id: 0x0005, name: "AccelePort Xr" },
		Device { id: 0x0006, name: "AccelePort Xr,C/X" },
		Device { id: 0x0009, name: "AccelePort Xr/J" },
		Device { id: 0x000A, name: "AccelePort EPC/J" },
		Device { id: 0x000C, name: "DataFirePRIme T1 (1-port)" },
		Device { id: 0x000D, name: "SyncPort 2-Port (x.25/FR)" },
		Device { id: 0x0011, name: "AccelePort 8r EIA-232 (IBM)" },
		Device { id: 0x0012, name: "AccelePort 8r EIA-422" },
		Device { id: 0x0013, name: "AccelePort Xr" },
		Device { id: 0x0014, name: "AccelePort 8r EIA-422" },
		Device { id: 0x0015, name: "AccelePort Xem" },
		Device { id: 0x0016, name: "AccelePort EPC/X" },
		Device { id: 0x0017, name: "AccelePort C/X" },
		Device { id: 0x001A, name: "DataFirePRIme E1 (1-port)" },
		Device { id: 0x001B, name: "AccelePort C/X (IBM)" },
		Device { id: 0x001C, name: "AccelePort Xr (SAIP)" },
		Device { id: 0x001D, name: "DataFire RAS T1/E1/PRI" },
		Device { id: 0x0023, name: "AccelePort RAS" },
		Device { id: 0x0024, name: "DataFire RAS B4 ST/U" },
		Device { id: 0x0026, name: "AccelePort 4r 920" },
		Device { id: 0x0027, name: "AccelePort Xr 920" },
		Device { id: 0x0028, name: "ClassicBoard 4" },
		Device { id: 0x0029, name: "ClassicBoard 8" },
		Device { id: 0x0034, name: "AccelePort 2r 920" },
		Device { id: 0x0035, name: "DataFire DSP T1/E1/PRI cPCI" },
		Device { id: 0x0040, name: "AccelePort Xp" },
		Device { id: 0x0042, name: "AccelePort 2p" },
		Device { id: 0x0043, name: "AccelePort 4p" },
		Device { id: 0x0044, name: "AccelePort 8p" },
		Device { id: 0x0045, name: "AccelePort 16p" },
		Device { id: 0x004E, name: "AccelePort 32p" },
		Device { id: 0x0070, name: "Datafire Micro V IOM2 (Europe)" },
		Device { id: 0x0071, name: "Datafire Micro V (Europe)" },
		Device { id: 0x0072, name: "Datafire Micro V IOM2 (North America)" },
		Device { id: 0x0073, name: "Datafire Micro V (North America)" },
		Device { id: 0x00B0, name: "Digi Neo 4" },
		Device { id: 0x00B1, name: "Digi Neo 8" },
		Device { id: 0x00C8, name: "Digi Neo 2 DB9" },
		Device { id: 0x00C9, name: "Digi Neo 2 DB9 PRI" },
		Device { id: 0x00CA, name: "Digi Neo 2 RJ45" },
		Device { id: 0x00CB, name: "Digi Neo 2 RJ45 PRI" },
		Device { id: 0x00CC, name: "Digi Neo 1 422" },
		Device { id: 0x00CD, name: "Digi Neo 1 422 485" },
		Device { id: 0x00CE, name: "Digi Neo 2 422 485" },
		Device { id: 0x00D0, name: "ClassicBoard 4 422" },
		Device { id: 0x00D1, name: "ClassicBoard 8 422" },
		Device { id: 0x00F1, name: "Digi Neo PCI-E 4 port" },
		Device { id: 0x00F4, name: "Digi Neo 4 (IBM version)" },
		Device { id: 0x6001, name: "Avanstar" },
	] },
	Vendor { id: 0x1150, name: "Thinking Machines Corp", devices: &[
	] },
	Vendor { id: 0x1151, name: "JAE Electronics Inc.", devices: &[
	] },
	Vendor { id: 0x1152, name: "Megatek", devices: &[
	] },
	Vendor { id: 0x1153, name: "Land Win Electronic Corp", devices: &[
	] },
	Vendor { id: 0x1154, name: "Melco Inc", devices: &[
	] },
	Vendor { id: 0x1155, name: "Pine Technology Ltd", devices: &[
	] },
	Vendor { id: 0x1156, name: "Periscope Engineering", devices: &[
	] },
	Vendor { id: 0x1157, name: "Avsys Corporation", devices: &[
	] },
	Vendor { id: 0x1158, name: "Voarx R & D Inc", devices: &[
		Device { id: 0x3011, name: "Tokenet/vg 1001/10m anylan" },
		Device { id: 0x9050, name: "Lanfleet/Truevalue" },
		Device { id: 0x9051, name: "Lanfleet/Truevalue" },
	] },
	Vendor { id: 0x1159, name: "MuTech Corporation", devices: &[
		Device { id: 0x0001, name: "MV-1000" },
		Device { id: 0x0002, name: "MV-1500" },
	] },
	Vendor { id: 0x115A, name: "Harlequin Ltd", devices: &[
	] },
	Vendor { id: 0x115B, name: "Parallax Graphics", devices: &[
	] },
	Vendor { id: 0x115C, name: "Photron Ltd.", devices: &[
	] },
	Vendor { id: 0x115D, name: "Xircom", devices: &[
		Device { id: 0x0003, name: "Cardbus Ethernet 10/100" },
		Device { id: 0x0005, name: "Cardbus Ethernet 10/100" },
		Device { id: 0x0007, name: "Cardbus Ethernet 10/100" },
		Device { id: 0x000B, name: "Cardbus Ethernet 10/100" },
		Device { id: 0x000C, name: "Mini-PCI V.90 56k Modem" },
		Device { id: 0x000F, name: "Cardbus Ethernet 10/100" },
		Device { id: 0x00D4, name: "Mini-PCI K56Flex Modem" },
		Device { id: 0x0101, name: "Cardbus 56k modem" },
		Device { id: 0x0103, name: "Cardbus Ethernet + 56k Modem" },
	] },
	Vendor { id: 0x115E, name: "Peer Protocols Inc", devices: &[
	] },
	Vendor { id: 0x115F, name: "Maxtor Corporation", devices: &[
	] },
	Vendor { id: 0x1160, name: "Megasoft Inc", devices: &[
	] },
	Vendor { id: 0x1161, name: "PFU Limited", devices: &[
	] },
	Vendor { id: 0x1162, name: "OA Laboratory Co Ltd", devices: &[
	] },
	Vendor { id: 0x1163, name: "Rendition", devices: &[
		Device { id: 0x0001, name: "Verite 1000" },
		Device { id: 0x2000, name: "Verite V2000/V2100/V2200" },
	] },
	Vendor { id: 0x1164, name: "Advanced Peripherals Technologies", devices: &[
	] },
	Vendor { id: 0x1165, name: "Imagraph Corporation", devices: &[
		Device { id: 0x0001, name: "Motion TPEG Recorder/Player with audio" },
	] },
	Vendor { id: 0x1166, name: "Broadcom", devices: &[
		Device { id: 0x0000, name: "CMIC-LE" },
		Device { id: 0x0005, name: "CNB20-LE Host Bridge" },
		Device { id: 0x0006, name: "CNB20HE Host Bridge" },
		Device { id: 0x0007, name: "CNB20-LE Host Bridge" },
		Device { id: 0x0008, name: "CNB20HE Host Bridge" },
		Device { id: 0x0009, name: "CNB20LE Host Bridge" },
		Device { id: 0x0010, name: "CIOB30" },
		Device { id: 0x0011, name: "CMIC-HE" },
		Device { id: 0x0012, name: "CMIC-WS Host Bridge (GC-LE chipset)" },
		Device { id: 0x0013, name: "CNB20-HE Host Bridge" },
		Device { id: 0x0014, name: "CMIC-LE Host Bridge (GC-LE chipset)" },
		Device { id: 0x0015, name: "CMIC-GC Host Bridge" },
		Device { id: 0x0016, name: "CMIC-GC Host Bridge" },
		Device { id: 0x0017, name: "GCNB-LE Host Bridge" },
		Device { id: 0x0031, name: "HT1100 HPX0 HT Host Bridge" },
		Device { id: 0x0036, name: "BCM5785 [HT1000] PCI/PCI-X Bridge" },
		Device { id: 0x0101, name: "CIOB-X2 PCI-X I/O Bridge" },
		Device { id: 0x0103, name: "EPB PCI-Express to PCI-X Bridge" },
		Device { id: 0x0104, name: "BCM5785 [HT1000] PCI/PCI-X Bridge" },
		Device { id: 0x0110, name: "CIOB-E I/O Bridge with Gigabit Ethernet" },
		Device { id: 0x0130, name: "BCM5780 [HT2000] PCI-X bridge" },
		Device { id: 0x0132, name: "BCM5780 [HT2000] PCI-Express Bridge" },
		Device { id: 0x0140, name: "HT2100 PCI-Express Bridge" },
		Device { id: 0x0141, name: "HT2100 PCI-Express Bridge" },
		Device { id: 0x0142, name: "HT2100 PCI-Express Bridge" },
		Device { id: 0x0144, name: "HT2100 PCI-Express Bridge" },
		Device { id: 0x0200, name: "OSB4 South Bridge" },
		Device { id: 0x0201, name: "CSB5 South Bridge" },
		Device { id: 0x0203, name: "CSB6 South Bridge" },
		Device { id: 0x0205, name: "BCM5785 [HT1000] Legacy South Bridge" },
		Device { id: 0x0211, name: "OSB4 IDE Controller" },
		Device { id: 0x0212, name: "CSB5 IDE Controller" },
		Device { id: 0x0213, name: "CSB6 RAID/IDE Controller" },
		Device { id: 0x0214, name: "BCM5785 [HT1000] IDE" },
		Device { id: 0x0217, name: "CSB6 IDE Controller" },
		Device { id: 0x021B, name: "HT1100 HD Audio" },
		Device { id: 0x0220, name: "OSB4/CSB5 OHCI USB Controller" },
		Device { id: 0x0221, name: "CSB6 OHCI USB Controller" },
		Device { id: 0x0223, name: "BCM5785 [HT1000] USB" },
		Device { id: 0x0225, name: "CSB5 LPC bridge" },
		Device { id: 0x0227, name: "GCLE-2 Host Bridge" },
		Device { id: 0x0230, name: "CSB5 LPC bridge" },
		Device { id: 0x0234, name: "BCM5785 [HT1000] LPC" },
		Device { id: 0x0235, name: "BCM5785 [HT1000] XIOAPIC0-2" },
		Device { id: 0x0238, name: "BCM5785 [HT1000] WDTimer" },
		Device { id: 0x0240, name: "K2 SATA" },
		Device { id: 0x0241, name: "RAIDCore RC4000" },
		Device { id: 0x0242, name: "RAIDCore BC4000" },
		Device { id: 0x024A, name: "BCM5785 [HT1000] SATA (Native SATA Mode)" },
		Device { id: 0x024B, name: "BCM5785 [HT1000] SATA (PATA/IDE Mode)" },
		Device { id: 0x0406, name: "HT1100 PCI-X Bridge" },
		Device { id: 0x0408, name: "HT1100 Legacy Device" },
		Device { id: 0x040A, name: "HT1100 ISA-LPC Bridge" },
		Device { id: 0x0410, name: "HT1100 SATA Controller (Native SATA Mode)" },
		Device { id: 0x0411, name: "HT1100 SATA Controller (PATA / IDE Mode)" },
		Device { id: 0x0412, name: "HT1100 USB OHCI Controller" },
		Device { id: 0x0414, name: "HT1100 USB EHCI Controller" },
		Device { id: 0x0416, name: "HT1100 USB EHCI Controller (with Debug Port)" },
		Device { id: 0x0420, name: "HT1100 PCI-Express Bridge" },
		Device { id: 0x0421, name: "HT1100 SAS/SATA Controller" },
		Device { id: 0x0422, name: "HT1100 PCI-Express Bridge" },
	] },
	Vendor { id: 0x1167, name: "Mutoh Industries Inc", devices: &[
	] },
	Vendor { id: 0x1168, name: "Thine Electronics Inc", devices: &[
	] },
	Vendor { id: 0x1169, name: "Centre for Development of Advanced Computing", devices: &[
	] },
	Vendor { id: 0x116A, name: "Luminex Software, Inc.", devices: &[
		Device { id: 0x6100, name: "Bus/Tag Channel" },
		Device { id: 0x6800, name: "Escon Channel" },
		Device { id: 0x7100, name: "Bus/Tag Channel" },
		Device { id: 0x7800, name: "Escon Channel" },
	] },
	Vendor { id: 0x116B, name: "Connectware Inc", devices: &[
	] },
	Vendor { id: 0x116C, name: "Intelligent Resources Integrated Systems", devices: &[
	] },
	Vendor { id: 0x116D, name: "Martin-Marietta", devices: &[
	] },
	Vendor { id: 0x116E, name: "Electronics for Imaging", devices: &[
	] },
	Vendor { id: 0x116F, name: "Workstation Technology", devices: &[
	] },
	Vendor { id: 0x1170, name: "Inventec Corporation", devices: &[
	] },
	Vendor { id: 0x1171, name: "Loughborough Sound Images Plc", devices: &[
	] },
	Vendor { id: 0x1172, name: "Altera Corporation", devices: &[
	] },
	Vendor { id: 0x1173, name: "Adobe Systems, Inc", devices: &[
	] },
	Vendor { id: 0x1174, name: "Bridgeport Machines", devices: &[
	] },
	Vendor { id: 0x1175, name: "Mitron Computer Inc.", devices: &[
	] },
	Vendor { id: 0x1176, name: "SBE Incorporated", devices: &[
	] },
	Vendor { id: 0x1177, name: "Silicon Engineering", devices: &[
	] },
	Vendor { id: 0x1178, name: "Alfa, Inc.", devices: &[
		Device { id: 0xAFA1, name: "Fast Ethernet Adapter" },
	] },
	Vendor { id: 0x1179, name: "Toshiba America Info Systems", devices: &[
		Device { id: 0x0102, name: "Extended IDE Controller" },
		Device { id: 0x0103, name: "EX-IDE Type-B" },
		Device { id: 0x010F, name: "NVMe Controller" },
		Device { id: 0x0404, name: "DVD Decoder card" },
		Device { id: 0x0406, name: "Tecra Video Capture device" },
		Device { id: 0x0407, name: "DVD Decoder card (Version 2)" },
		Device { id: 0x0601, name: "CPU to PCI bridge" },
		Device { id: 0x0602, name: "PCI to ISA bridge" },
		Device { id: 0x0603, name: "ToPIC95 PCI to CardBus Bridge for Notebooks" },
		Device { id: 0x0604, name: "PCI-Docking Host bridge" },
		Device { id: 0x060A, name: "ToPIC95" },
		Device { id: 0x060F, name: "ToPIC97" },
		Device { id: 0x0617, name: "ToPIC100 PCI to Cardbus Bridge with ZV Support" },
		Device { id: 0x0618, name: "CPU to PCI and PCI to ISA bridge" },
		Device { id: 0x0701, name: "FIR Port Type-O" },
		Device { id: 0x0803, name: "TC6371AF SD Host Controller" },
		Device { id: 0x0804, name: "TC6371AF SmartMedia Controller" },
		Device { id: 0x0805, name: "SD TypA Controller" },
		Device { id: 0x0D01, name: "FIR Port Type-DO" },
	] },
	Vendor { id: 0x117A, name: "A-Trend Technology", devices: &[
	] },
	Vendor { id: 0x117B, name: "L G Electronics, Inc.", devices: &[
	] },
	Vendor { id: 0x117C, name: "ATTO Technology, Inc.", devices: &[
		Device { id: 0x002C, name: "ExpressSAS R380" },
		Device { id: 0x002D, name: "ExpressSAS R348" },
		Device { id: 0x0030, name: "Ultra320 SCSI Host Adapter" },
		Device { id: 0x0033, name: "SAS Adapter" },
		Device { id: 0x0041, name: "ExpressSAS R30F" },
		Device { id: 0x8013, name: "ExpressPCI UL4D" },
		Device { id: 0x8014, name: "ExpressPCI UL4S" },
		Device { id: 0x8027, name: "ExpressPCI UL5D" },
	] },
	Vendor { id: 0x117D, name: "Becton & Dickinson", devices: &[
	] },
	Vendor { id: 0x117E, name: "T/R Systems", devices: &[
	] },
	Vendor { id: 0x117F, name: "Integrated Circuit Systems", devices: &[
	] },
	Vendor { id: 0x1180, name: "Ricoh Co Ltd", devices: &[
		Device { id: 0x0465, name: "RL5c465" },
		Device { id: 0x0466, name: "RL5c466" },
		Device { id: 0x0475, name: "RL5c475" },
		Device { id: 0x0476, name: "RL5c476 II" },
		Device { id: 0x0477, name: "RL5c477" },
		Device { id: 0x0478, name: "RL5c478" },
		Device { id: 0x0511, name: "R5C511" },
		Device { id: 0x0522, name: "R5C522 IEEE 1394 Controller" },
		Device { id: 0x0551, name: "R5C551 IEEE 1394 Controller" },
		Device { id: 0x0552, name: "R5C552 IEEE 1394 Controller" },
		Device { id: 0x0554, name: "R5C554" },
		Device { id: 0x0575, name: "R5C575 SD Bus Host Adapter" },
		Device { id: 0x0576, name: "R5C576 SD Bus Host Adapter" },
		Device { id: 0x0592, name: "R5C592 Memory Stick Bus Host Adapter" },
		Device { id: 0x0811, name: "R5C811" },
		Device { id: 0x0822, name: "R5C822 SD/SDIO/MMC/MS/MSPro Host Adapter" },
		Device { id: 0x0832, name: "R5C832 IEEE 1394 Controller" },
		Device { id: 0x0841, name: "R5C841 CardBus/SD/SDIO/MMC/MS/MSPro/xD/IEEE1394" },
		Device { id: 0x0843, name: "R5C843 MMC Host Controller" },
		Device { id: 0x0852, name: "xD-Picture Card Controller" },
		Device { id: 0xE230, name: "R5U2xx (R5U230 / R5U231 / R5U241) [Memory Stick Host Controller]" },
		Device { id: 0xE476, name: "CardBus bridge" },
		Device { id: 0xE822, name: "MMC/SD Host Controller" },
		Device { id: 0xE823, name: "PCIe SDXC/MMC Host Controller" },
		Device { id: 0xE832, name: "R5C832 PCIe IEEE 1394 Controller" },
		Device { id: 0xE852, name: "PCIe xD-Picture Card Controller" },
	] },
	Vendor { id: 0x1181, name: "Telmatics International", devices: &[
	] },
	Vendor { id: 0x1183, name: "Fujikura Ltd", devices: &[
	] },
	Vendor { id: 0x1184, name: "Forks Inc", devices: &[
	] },
	Vendor { id: 0x1185, name: "Dataworld International Ltd", devices: &[
	] },
	Vendor { id: 0x1186, name: "D-Link System Inc", devices: &[
		Device { id: 0x1002, name: "DL10050 Sundance Ethernet" },
		Device { id: 0x1025, name: "AirPlus Xtreme G DWL-G650 Adapter" },
		Device { id: 0x1026, name: "AirXpert DWL-AG650 Wireless Cardbus Adapter" },
		Device { id: 0x1043, name: "AirXpert DWL-AG650 Wireless Cardbus Adapter" },
		Device { id: 0x1300, name: "RTL8139 Ethernet" },
		Device { id: 0x1340, name: "DFE-690TXD CardBus PC Card" },
		Device { id: 0x1540, name: "DFE-680TX" },
		Device { id: 0x1541, name: "DFE-680TXD CardBus PC Card" },
		Device { id: 0x1561, name: "DRP-32TXD Cardbus PC Card" },
		Device { id: 0x3300, name: "DWL-510 / DWL-610 802.11b [Realtek RTL8180L]" },
		Device { id: 0x3A10, name: "AirXpert DWL-AG650 Wireless Cardbus Adapter(rev.B)" },
		Device { id: 0x3A11, name: "AirXpert DWL-AG520 Wireless PCI Adapter(rev.B)" },
		Device { id: 0x4000, name: "DL2000-based Gigabit Ethernet" },
		Device { id: 0x4001, name: "DGE-550SX PCI-X Gigabit Ethernet Adapter" },
		Device { id: 0x4200, name: "DFE-520TX Fast Ethernet PCI Adapter" },
		Device { id: 0x4300, name: "DGE-528T Gigabit Ethernet Adapter" },
		Device { id: 0x4302, name: "DGE-530T Gigabit Ethernet Adapter (rev.C1) [Realtek RTL8169]" },
		Device { id: 0x4B00, name: "DGE-560T PCI Express Gigabit Ethernet Adapter" },
		Device { id: 0x4B01, name: "DGE-530T Gigabit Ethernet Adapter (rev 11)" },
		Device { id: 0x4B02, name: "DGE-560SX PCI Express Gigabit Ethernet Adapter" },
		Device { id: 0x4B03, name: "DGE-550T Gigabit Ethernet Adapter V.B1" },
		Device { id: 0x4C00, name: "Gigabit Ethernet Adapter" },
		Device { id: 0x8400, name: "D-Link DWL-650+ CardBus PC Card" },
	] },
	Vendor { id: 0x1187, name: "Advanced Technology Laboratories, Inc.", devices: &[
	] },
	Vendor { id: 0x1188, name: "Shima Seiki Manufacturing Ltd.", devices: &[
	] },
	Vendor { id: 0x1189, name: "Matsushita Electronics Co Ltd", devices: &[
	] },
	Vendor { id: 0x118A, name: "Hilevel Technology", devices: &[
	] },
	Vendor { id: 0x118B, name: "Hypertec Pty Limited", devices: &[
	] },
	Vendor { id: 0x118C, name: "Corollary, Inc", devices: &[
		Device { id: 0x0014, name: "PCIB [C-bus II to PCI bus host bridge chip]" },
		Device { id: 0x1117, name: "Intel 8-way XEON Profusion Chipset [Cache Coherency Filter]" },
	] },
	Vendor { id: 0x118D, name: "BitFlow Inc", devices: &[
		Device { id: 0x0001, name: "Raptor-PCI framegrabber" },
		Device { id: 0x0012, name: "Model 12 Road Runner Frame Grabber" },
		Device { id: 0x0014, name: "Model 14 Road Runner Frame Grabber" },
		Device { id: 0x0024, name: "Model 24 Road Runner Frame Grabber" },
		Device { id: 0x0044, name: "Model 44 Road Runner Frame Grabber" },
		Device { id: 0x0112, name: "Model 12 Road Runner Frame Grabber" },
		Device { id: 0x0114, name: "Model 14 Road Runner Frame Grabber" },
		Device { id: 0x0124, name: "Model 24 Road Runner Frame Grabber" },
		Device { id: 0x0144, name: "Model 44 Road Runner Frame Grabber" },
		Device { id: 0x0212, name: "Model 12 Road Runner Frame Grabber" },
		Device { id: 0x0214, name: "Model 14 Road Runner Frame Grabber" },
		Device { id: 0x0224, name: "Model 24 Road Runner Frame Grabber" },
		Device { id: 0x0244, name: "Model 44 Road Runner Frame Grabber" },
		Device { id: 0x0312, name: "Model 12 Road Runner Frame Grabber" },
		Device { id: 0x0314, name: "Model 14 Road Runner Frame Grabber" },
		Device { id: 0x0324, name: "Model 24 Road Runner Frame Grabber" },
		Device { id: 0x0344, name: "Model 44 Road Runner Frame Grabber" },
	] },
	Vendor { id: 0x118E, name: "Hermstedt GmbH", devices: &[
	] },
	Vendor { id: 0x118F, name: "Green Logic", devices: &[
	] },
	Vendor { id: 0x1190, name: "Tripace", devices: &[
		Device { id: 0xC731, name: "TP-910/920/940 PCI Ultra(Wide) SCSI Adapter" },
	] },
	Vendor { id: 0x1191, name: "Artop Electronic Corp", devices: &[
		Device { id: 0x0003, name: "SCSI Cache Host Adapter" },
		Device { id: 0x0004, name: "ATP8400" },
		Device { id: 0x0005, name: "ATP850UF" },
		Device { id: 0x0006, name: "ATP860 NO-BIOS" },
		Device { id: 0x0007, name: "ATP860" },
		Device { id: 0x0008, name: "ATP865 NO-ROM" },
		Device { id: 0x0009, name: "ATP865" },
		Device { id: 0x000A, name: "ATP867-A" },
		Device { id: 0x000B, name: "ATP867-B" },
		Device { id: 0x000D, name: "ATP8620" },
		Device { id: 0x000E, name: "ATP8620" },
		Device { id: 0x8002, name: "AEC6710 SCSI-2 Host Adapter" },
		Device { id: 0x8010, name: "AEC6712UW SCSI" },
		Device { id: 0x8020, name: "AEC6712U SCSI" },
		Device { id: 0x8030, name: "AEC6712S SCSI" },
		Device { id: 0x8040, name: "AEC6712D SCSI" },
		Device { id: 0x8050, name: "AEC6712SUW SCSI" },
		Device { id: 0x8060, name: "AEC6712 SCSI" },
		Device { id: 0x8080, name: "AEC67160 SCSI" },
		Device { id: 0x8081, name: "AEC67160S SCSI" },
		Device { id: 0x808A, name: "AEC67162 2-ch. LVD SCSI" },
	] },
	Vendor { id: 0x1192, name: "Densan Company Ltd", devices: &[
	] },
	Vendor { id: 0x1193, name: "Zeitnet Inc.", devices: &[
		Device { id: 0x0001, name: "1221" },
		Device { id: 0x0002, name: "1225" },
	] },
	Vendor { id: 0x1194, name: "Toucan Technology", devices: &[
	] },
	Vendor { id: 0x1195, name: "Ratoc System Inc", devices: &[
	] },
	Vendor { id: 0x1196, name: "Hytec Electronics Ltd", devices: &[
	] },
	Vendor { id: 0x1197, name: "Gage Applied Sciences, Inc.", devices: &[
		Device { id: 0x010C, name: "CompuScope 82G 8bit 2GS/s Analog Input Card" },
	] },
	Vendor { id: 0x1198, name: "Lambda Systems Inc", devices: &[
	] },
	Vendor { id: 0x1199, name: "Attachmate Corporation", devices: &[
		Device { id: 0x0101, name: "Advanced ISCA/PCI Adapter" },
	] },
	Vendor { id: 0x119A, name: "Mind Share, Inc.", devices: &[
	] },
	Vendor { id: 0x119B, name: "Omega Micro Inc.", devices: &[
		Device { id: 0x1221, name: "82C092G" },
	] },
	Vendor { id: 0x119C, name: "Information Technology Inst.", devices: &[
	] },
	Vendor { id: 0x119D, name: "Bug, Inc. Sapporo Japan", devices: &[
	] },
	Vendor { id: 0x119E, name: "Fujitsu Microelectronics Ltd.", devices: &[
		Device { id: 0x0001, name: "FireStream 155" },
		Device { id: 0x0003, name: "FireStream 50" },
	] },
	Vendor { id: 0x119F, name: "Bull HN Information Systems", devices: &[
		Device { id: 0x1081, name: "BXI Host Channel Adapter" },
	] },
	Vendor { id: 0x11A0, name: "Convex Computer Corporation", devices: &[
	] },
	Vendor { id: 0x11A1, name: "Hamamatsu Photonics K.K.", devices: &[
	] },
	Vendor { id: 0x11A2, name: "Sierra Research and Technology", devices: &[
	] },
	Vendor { id: 0x11A3, name: "Deuretzbacher GmbH & Co. Eng. KG", devices: &[
	] },
	Vendor { id: 0x11A4, name: "Barco Graphics NV", devices: &[
	] },
	Vendor { id: 0x11A5, name: "Microunity Systems Eng. Inc", devices: &[
	] },
	Vendor { id: 0x11A6, name: "Pure Data Ltd.", devices: &[
	] },
	Vendor { id: 0x11A7, name: "Power Computing Corp.", devices: &[
	] },
	Vendor { id: 0x11A8, name: "Systech Corp.", devices: &[
	] },
	Vendor { id: 0x11A9, name: "InnoSys Inc.", devices: &[
		Device { id: 0x4240, name: "AMCC S933Q Intelligent Serial Card" },
	] },
	Vendor { id: 0x11AA, name: "Actel", devices: &[
	] },
	Vendor { id: 0x11AB, name: "Marvell Technology Group Ltd.", devices: &[
		Device { id: 0x0146, name: "GT-64010/64010A System Controller" },
		Device { id: 0x0F53, name: "88E6318 Link Street network controller" },
		Device { id: 0x11AB, name: "MV88SE614x SATA II PCI-E controller" },
		Device { id: 0x138F, name: "W8300 802.11 Adapter (rev 07)" },
		Device { id: 0x1FA6, name: "Marvell W8300 802.11 Adapter" },
		Device { id: 0x1FA7, name: "88W8310 and 88W8000G [Libertas] 802.11g client chipset" },
		Device { id: 0x1FAA, name: "88w8335 [Libertas] 802.11b/g Wireless" },
		Device { id: 0x2211, name: "88SB2211 PCI Express to PCI Bridge" },
		Device { id: 0x2A01, name: "88W8335 [Libertas] 802.11b/g Wireless" },
		Device { id: 0x2A02, name: "88W8361 [TopDog] 802.11n Wireless" },
		Device { id: 0x2A08, name: "88W8362e [TopDog] 802.11a/b/g/n Wireless" },
		Device { id: 0x2A0A, name: "88W8363 [TopDog] 802.11n Wireless" },
		Device { id: 0x2A0C, name: "88W8363 [TopDog] 802.11n Wireless" },
		Device { id: 0x2A24, name: "88W8363 [TopDog] 802.11n Wireless" },
		Device { id: 0x2A2B, name: "88W8687 [TopDog] 802.11b/g Wireless" },
		Device { id: 0x2A30, name: "88W8687 [TopDog] 802.11b/g Wireless" },
		Device { id: 0x2A40, name: "88W8366 [TopDog] 802.11n Wireless" },
		Device { id: 0x2A41, name: "88W8366 [TopDog] 802.11n Wireless" },
		Device { id: 0x2A42, name: "88W8366 [TopDog] 802.11n Wireless" },
		Device { id: 0x2A43, name: "88W8366 [TopDog] 802.11n Wireless" },
		Device { id: 0x2A55, name: "88W8864 [Avastar] 802.11ac Wireless" },
		Device { id: 0x2B36, name: "88W8764 [Avastar] 802.11n Wireless" },
		Device { id: 0x2B38, name: "88W8897 [AVASTAR] 802.11ac Wireless" },
		Device { id: 0x2B40, name: "88W8964 [Avastar] 802.11ac Wireless" },
		Device { id: 0x4101, name: "OLPC Cafe Controller Secure Digital Controller" },
		Device { id: 0x4320, name: "88E8001 Gigabit Ethernet Controller" },
		Device { id: 0x4340, name: "88E8021 PCI-X IPMI Gigabit Ethernet Controller" },
		Device { id: 0x4341, name: "88E8022 PCI-X IPMI Gigabit Ethernet Controller" },
		Device { id: 0x4342, name: "88E8061 PCI-E IPMI Gigabit Ethernet Controller" },
		Device { id: 0x4343, name: "88E8062 PCI-E IPMI Gigabit Ethernet Controller" },
		Device { id: 0x4344, name: "88E8021 PCI-X IPMI Gigabit Ethernet Controller" },
		Device { id: 0x4345, name: "88E8022 PCI-X IPMI Gigabit Ethernet Controller" },
		Device { id: 0x4346, name: "88E8061 PCI-E IPMI Gigabit Ethernet Controller" },
		Device { id: 0x4347, name: "88E8062 PCI-E IPMI Gigabit Ethernet Controller" },
		Device { id: 0x4350, name: "88E8035 PCI-E Fast Ethernet Controller" },
		Device { id: 0x4351, name: "88E8036 PCI-E Fast Ethernet Controller" },
		Device { id: 0x4352, name: "88E8038 PCI-E Fast Ethernet Controller" },
		Device { id: 0x4353, name: "88E8039 PCI-E Fast Ethernet Controller" },
		Device { id: 0x4354, name: "88E8040 PCI-E Fast Ethernet Controller" },
		Device { id: 0x4355, name: "88E8040T PCI-E Fast Ethernet Controller" },
		Device { id: 0x4356, name: "88EC033 PCI-E Fast Ethernet Controller" },
		Device { id: 0x4357, name: "88E8042 PCI-E Fast Ethernet Controller" },
		Device { id: 0x435A, name: "88E8048 PCI-E Fast Ethernet Controller" },
		Device { id: 0x4360, name: "88E8052 PCI-E ASF Gigabit Ethernet Controller" },
		Device { id: 0x4361, name: "88E8050 PCI-E ASF Gigabit Ethernet Controller" },
		Device { id: 0x4362, name: "88E8053 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x4363, name: "88E8055 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x4364, name: "88E8056 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x4365, name: "88E8070 based Ethernet Controller" },
		Device { id: 0x4366, name: "88EC036 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x4367, name: "88EC032 Ethernet Controller" },
		Device { id: 0x4368, name: "88EC034 Ethernet Controller" },
		Device { id: 0x4369, name: "88EC042 Ethernet Controller" },
		Device { id: 0x436A, name: "88E8058 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x436B, name: "88E8071 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x436C, name: "88E8072 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x436D, name: "88E8055 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x4370, name: "88E8075 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x4380, name: "88E8057 PCI-E Gigabit Ethernet Controller" },
		Device { id: 0x4381, name: "Yukon Optima 88E8059 [PCIe Gigabit Ethernet Controller with AVB]" },
		Device { id: 0x4611, name: "GT-64115 System Controller" },
		Device { id: 0x4620, name: "GT-64120/64120A/64121A System Controller" },
		Device { id: 0x4801, name: "GT-48001" },
		Device { id: 0x5005, name: "Belkin F5D5005 Gigabit Desktop Network PCI Card" },
		Device { id: 0x5040, name: "MV88SX5040 4-port SATA I PCI-X Controller" },
		Device { id: 0x5041, name: "MV88SX5041 4-port SATA I PCI-X Controller" },
		Device { id: 0x5080, name: "MV88SX5080 8-port SATA I PCI-X Controller" },
		Device { id: 0x5081, name: "MV88SX5081 8-port SATA I PCI-X Controller" },
		Device { id: 0x5181, name: "88f5181 [Orion-1] ARM SoC" },
		Device { id: 0x5182, name: "88f5182 [Orion-NAS] ARM SoC" },
		Device { id: 0x5281, name: "88f5281 [Orion-2] ARM SoC" },
		Device { id: 0x6041, name: "MV88SX6041 4-port SATA II PCI-X Controller" },
		Device { id: 0x6042, name: "88SX6042 PCI-X 4-Port SATA-II" },
		Device { id: 0x6081, name: "MV88SX6081 8-port SATA II PCI-X Controller" },
		Device { id: 0x6101, name: "88SE6101/6102 single-port PATA133 interface" },
		Device { id: 0x6111, name: "88SE6111 1-port PATA133(IDE) and 1-port SATA II Controllers" },
		Device { id: 0x6121, name: "88SE6121 SATA II / PATA Controller" },
		Device { id: 0x6141, name: "88SE614x SATA II PCI-E controller" },
		Device { id: 0x6145, name: "88SE6145 SATA II PCI-E controller" },
		Device { id: 0x6180, name: "88F6180 [Kirkwood] ARM SoC" },
		Device { id: 0x6192, name: "88F6190/6192 [Kirkwood] ARM SoC" },
		Device { id: 0x6281, name: "88F6281 [Kirkwood] ARM SoC" },
		Device { id: 0x6381, name: "MV78xx0 [Discovery Innovation] ARM SoC" },
		Device { id: 0x6440, name: "88SE6440 SAS/SATA PCIe controller" },
		Device { id: 0x6450, name: "64560 System Controller" },
		Device { id: 0x6460, name: "MV64360/64361/64362 System Controller" },
		Device { id: 0x6480, name: "MV64460/64461/64462 System Controller" },
		Device { id: 0x6485, name: "MV64460/64461/64462 System Controller, Revision B" },
		Device { id: 0x7042, name: "88SX7042 PCI-e 4-port SATA-II" },
		Device { id: 0x7810, name: "MV78100 [Discovery Innovation] ARM SoC" },
		Device { id: 0x7820, name: "MV78200 [Discovery Innovation] ARM SoC" },
		Device { id: 0x7823, name: "MV78230 [Armada XP] ARM SoC" },
		Device { id: 0x7846, name: "88F6820 [Armada 385] ARM SoC" },
		Device { id: 0xF003, name: "GT-64010 Primary Image Piranha Image Generator" },
	] },
	Vendor { id: 0x11AC, name: "Canon Information Systems Research Aust.", devices: &[
	] },
	Vendor { id: 0x11AD, name: "Lite-On Communications Inc", devices: &[
		Device { id: 0x0002, name: "LNE100TX" },
		Device { id: 0xC115, name: "LNE100TX [Linksys EtherFast 10/100]" },
	] },
	Vendor { id: 0x11AE, name: "Aztech System Ltd", devices: &[
	] },
	Vendor { id: 0x11AF, name: "Avid Technology Inc.", devices: &[
		Device { id: 0x0001, name: "Cinema" },
		Device { id: 0xEE40, name: "Digidesign Audiomedia III" },
	] },
	Vendor { id: 0x11B0, name: "V3 Semiconductor Inc.", devices: &[
		Device { id: 0x0002, name: "V300PSC" },
		Device { id: 0x0292, name: "V292PBC [Am29030/40 Bridge]" },
		Device { id: 0x0960, name: "V96xPBC" },
		Device { id: 0x880A, name: "Deltacast Delta-HD-22" },
		Device { id: 0xC960, name: "V96DPC" },
	] },
	Vendor { id: 0x11B1, name: "Apricot Computers", devices: &[
	] },
	Vendor { id: 0x11B2, name: "Eastman Kodak", devices: &[
	] },
	Vendor { id: 0x11B3, name: "Barr Systems Inc.", devices: &[
	] },
	Vendor { id: 0x11B4, name: "Leitch Technology International", devices: &[
	] },
	Vendor { id: 0x11B5, name: "Radstone Technology Plc", devices: &[
	] },
	Vendor { id: 0x11B6, name: "United Video Corp", devices: &[
	] },
	Vendor { id: 0x11B7, name: "Motorola", devices: &[
	] },
	Vendor { id: 0x11B8, name: "XPoint Technologies, Inc", devices: &[
		Device { id: 0x0001, name: "Quad PeerMaster" },
	] },
	Vendor { id: 0x11B9, name: "Pathlight Technology Inc.", devices: &[
		Device { id: 0xC0ED, name: "SSA Controller" },
	] },
	Vendor { id: 0x11BA, name: "Videotron Corp", devices: &[
	] },
	Vendor { id: 0x11BB, name: "Pyramid Technology", devices: &[
	] },
	Vendor { id: 0x11BC, name: "Network Peripherals Inc", devices: &[
		Device { id: 0x0001, name: "NP-PCI" },
	] },
	Vendor { id: 0x11BD, name: "Pinnacle Systems Inc.", devices: &[
		Device { id: 0x002E, name: "PCTV 40i" },
		Device { id: 0x0040, name: "Royal TS Function 1" },
		Device { id: 0x0041, name: "RoyalTS Function 2" },
		Device { id: 0x0042, name: "Royal TS Function 3" },
		Device { id: 0x0051, name: "PCTV HD 800i" },
		Device { id: 0xBEDE, name: "AV/DV Studio Capture Card" },
	] },
	Vendor { id: 0x11BE, name: "International Microcircuits Inc", devices: &[
	] },
	Vendor { id: 0x11BF, name: "Astrodesign, Inc.", devices: &[
	] },
	Vendor { id: 0x11C0, name: "Hewlett Packard", devices: &[
	] },
	Vendor { id: 0x11C1, name: "LSI Corporation", devices: &[
		Device { id: 0x0440, name: "56k WinModem" },
		Device { id: 0x0441, name: "56k WinModem" },
		Device { id: 0x0442, name: "56k WinModem" },
		Device { id: 0x0443, name: "LT WinModem" },
		Device { id: 0x0444, name: "LT WinModem" },
		Device { id: 0x0445, name: "LT WinModem" },
		Device { id: 0x0446, name: "LT WinModem" },
		Device { id: 0x0447, name: "LT WinModem" },
		Device { id: 0x0448, name: "WinModem 56k" },
		Device { id: 0x0449, name: "L56xM+S [Mars-2] WinModem 56k" },
		Device { id: 0x044A, name: "F-1156IV WinModem (V90, 56KFlex)" },
		Device { id: 0x044B, name: "LT WinModem" },
		Device { id: 0x044C, name: "LT WinModem" },
		Device { id: 0x044D, name: "LT WinModem" },
		Device { id: 0x044E, name: "LT WinModem" },
		Device { id: 0x044F, name: "V90 WildWire Modem" },
		Device { id: 0x0450, name: "LT WinModem" },
		Device { id: 0x0451, name: "LT WinModem" },
		Device { id: 0x0452, name: "LT WinModem" },
		Device { id: 0x0453, name: "LT WinModem" },
		Device { id: 0x0454, name: "LT WinModem" },
		Device { id: 0x0455, name: "LT WinModem" },
		Device { id: 0x0456, name: "LT WinModem" },
		Device { id: 0x0457, name: "LT WinModem" },
		Device { id: 0x0458, name: "LT WinModem" },
		Device { id: 0x0459, name: "LT WinModem" },
		Device { id: 0x045A, name: "LT WinModem" },
		Device { id: 0x045C, name: "LT WinModem" },
		Device { id: 0x0461, name: "V90 WildWire Modem" },
		Device { id: 0x0462, name: "V90 WildWire Modem" },
		Device { id: 0x0480, name: "Venus Modem (V90, 56KFlex)" },
		Device { id: 0x048C, name: "V.92 56K WinModem" },
		Device { id: 0x048F, name: "V.92 56k WinModem" },
		Device { id: 0x0620, name: "Lucent V.92 Data/Fax Modem" },
		Device { id: 0x2600, name: "StarPro26XX family (SP2601, SP2603, SP2612) DSP" },
		Device { id: 0x5400, name: "OR3TP12 FPSC" },
		Device { id: 0x5656, name: "Venus Modem" },
		Device { id: 0x5801, name: "USB" },
		Device { id: 0x5802, name: "USS-312 USB Controller" },
		Device { id: 0x5803, name: "USS-344S USB Controller" },
		Device { id: 0x5811, name: "FW322/323 [TrueFire] 1394a Controller" },
		Device { id: 0x5901, name: "FW643 [TrueFire] PCIe 1394b Controller" },
		Device { id: 0x5903, name: "FW533 [TrueFire] PCIe 1394a Controller" },
		Device { id: 0x8110, name: "T8110 H.100/H.110 TDM switch" },
		Device { id: 0xAB10, name: "WL60010 Wireless LAN MAC" },
		Device { id: 0xAB11, name: "WL60040 Multimode Wireles LAN MAC" },
		Device { id: 0xAB20, name: "ORiNOCO PCI Adapter" },
		Device { id: 0xAB21, name: "Agere Wireless PCI Adapter" },
		Device { id: 0xAB30, name: "Hermes2 Mini-PCI WaveLAN a/b/g" },
		Device { id: 0xED00, name: "ET-131x PCI-E Ethernet Controller" },
		Device { id: 0xED01, name: "ET-131x PCI-E Ethernet Controller" },
	] },
	Vendor { id: 0x11C2, name: "Sand Microelectronics", devices: &[
	] },
	Vendor { id: 0x11C3, name: "NEC Corporation", devices: &[
	] },
	Vendor { id: 0x11C4, name: "Document Technologies, Inc", devices: &[
	] },
	Vendor { id: 0x11C5, name: "Shiva Corporation", devices: &[
	] },
	Vendor { id: 0x11C6, name: "Dainippon Screen Mfg. Co. Ltd", devices: &[
	] },
	Vendor { id: 0x11C7, name: "D.C.M. Data Systems", devices: &[
	] },
	Vendor { id: 0x11C8, name: "Dolphin Interconnect Solutions AS", devices: &[
		Device { id: 0x0658, name: "PSB32 SCI-Adapter D31x" },
		Device { id: 0xD665, name: "PSB64 SCI-Adapter D32x" },
		Device { id: 0xD667, name: "PSB66 SCI-Adapter D33x" },
	] },
	Vendor { id: 0x11C9, name: "Magma", devices: &[
		Device { id: 0x0010, name: "16-line serial port w/- DMA" },
		Device { id: 0x0011, name: "4-line serial port w/- DMA" },
	] },
	Vendor { id: 0x11CA, name: "LSI Systems, Inc", devices: &[
	] },
	Vendor { id: 0x11CB, name: "Specialix Research Ltd.", devices: &[
		Device { id: 0x2000, name: "PCI_9050" },
		Device { id: 0x4000, name: "SUPI_1" },
		Device { id: 0x8000, name: "T225" },
	] },
	Vendor { id: 0x11CC, name: "Michels & Kleberhoff Computer GmbH", devices: &[
	] },
	Vendor { id: 0x11CD, name: "HAL Computer Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x11CE, name: "Netaccess", devices: &[
	] },
	Vendor { id: 0x11CF, name: "Pioneer Electronic Corporation", devices: &[
	] },
	Vendor { id: 0x11D0, name: "Lockheed Martin Federal Systems-Manassas", devices: &[
	] },
	Vendor { id: 0x11D1, name: "Auravision", devices: &[
		Device { id: 0x01F7, name: "VxP524" },
		Device { id: 0x01F9, name: "VxP951" },
	] },
	Vendor { id: 0x11D2, name: "Intercom Inc.", devices: &[
	] },
	Vendor { id: 0x11D3, name: "Trancell Systems Inc", devices: &[
	] },
	Vendor { id: 0x11D4, name: "Analog Devices", devices: &[
		Device { id: 0x1535, name: "Blackfin BF535 processor" },
		Device { id: 0x1805, name: "SM56 PCI modem" },
	] },
	Vendor { id: 0x11D5, name: "Ikon Corporation", devices: &[
		Device { id: 0x0115, name: "10115" },
		Device { id: 0x0117, name: "10117" },
	] },
	Vendor { id: 0x11D6, name: "Tekelec Telecom", devices: &[
	] },
	Vendor { id: 0x11D7, name: "Trenton Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x11D8, name: "Image Technologies Development", devices: &[
	] },
	Vendor { id: 0x11D9, name: "TEC Corporation", devices: &[
	] },
	Vendor { id: 0x11DA, name: "Novell", devices: &[
	] },
	Vendor { id: 0x11DB, name: "Sega Enterprises Ltd", devices: &[
	] },
	Vendor { id: 0x11DC, name: "Questra Corporation", devices: &[
	] },
	Vendor { id: 0x11DD, name: "Crosfield Electronics Limited", devices: &[
	] },
	Vendor { id: 0x11DE, name: "Zoran Corporation", devices: &[
		Device { id: 0x6017, name: "miroVIDEO DC30" },
		Device { id: 0x6057, name: "ZR36057PQC Video cutting chipset" },
		Device { id: 0x6120, name: "ZR36120" },
	] },
	Vendor { id: 0x11DF, name: "New Wave PDG", devices: &[
	] },
	Vendor { id: 0x11E0, name: "Cray Communications A/S", devices: &[
	] },
	Vendor { id: 0x11E1, name: "GEC Plessey Semi Inc.", devices: &[
	] },
	Vendor { id: 0x11E2, name: "Samsung Information Systems America", devices: &[
	] },
	Vendor { id: 0x11E3, name: "Quicklogic Corporation", devices: &[
		Device { id: 0x0001, name: "COM-ON-AIR Dosch&Amand DECT" },
		Device { id: 0x0560, name: "QL5064 Companion Design Demo Board" },
		Device { id: 0x5030, name: "PC Watchdog" },
		Device { id: 0x8417, name: "QL5064 [QuickPCI] PCI v2.2 bridge for SMT417 Dual TMS320C6416T PMC Module" },
	] },
	Vendor { id: 0x11E4, name: "Second Wave Inc", devices: &[
	] },
	Vendor { id: 0x11E5, name: "IIX Consulting", devices: &[
	] },
	Vendor { id: 0x11E6, name: "Mitsui-Zosen System Research", devices: &[
	] },
	Vendor { id: 0x11E7, name: "Toshiba America, Elec. Company", devices: &[
	] },
	Vendor { id: 0x11E8, name: "Digital Processing Systems Inc.", devices: &[
	] },
	Vendor { id: 0x11E9, name: "Highwater Designs Ltd.", devices: &[
	] },
	Vendor { id: 0x11EA, name: "Elsag Bailey", devices: &[
	] },
	Vendor { id: 0x11EB, name: "Formation Inc.", devices: &[
	] },
	Vendor { id: 0x11EC, name: "Coreco Inc", devices: &[
		Device { id: 0x000D, name: "Oculus-F/64P" },
		Device { id: 0x1800, name: "Cobra/C6" },
	] },
	Vendor { id: 0x11ED, name: "Mediamatics", devices: &[
	] },
	Vendor { id: 0x11EE, name: "Dome Imaging Systems Inc", devices: &[
	] },
	Vendor { id: 0x11EF, name: "Nicolet Technologies B.V.", devices: &[
	] },
	Vendor { id: 0x11F0, name: "Compu-Shack", devices: &[
		Device { id: 0x4231, name: "FDDI" },
		Device { id: 0x4232, name: "FASTline UTP Quattro" },
		Device { id: 0x4233, name: "FASTline FO" },
		Device { id: 0x4234, name: "FASTline UTP" },
		Device { id: 0x4235, name: "FASTline-II UTP" },
		Device { id: 0x4236, name: "FASTline-II FO" },
		Device { id: 0x4731, name: "GIGAline" },
	] },
	Vendor { id: 0x11F1, name: "Symbios Logic Inc", devices: &[
	] },
	Vendor { id: 0x11F2, name: "Picture Tel Japan K.K.", devices: &[
	] },
	Vendor { id: 0x11F3, name: "Keithley Metrabyte", devices: &[
		Device { id: 0x0011, name: "KPCI-PIO24" },
	] },
	Vendor { id: 0x11F4, name: "Kinetic Systems Corporation", devices: &[
		Device { id: 0x2915, name: "CAMAC controller" },
	] },
	Vendor { id: 0x11F5, name: "Computing Devices International", devices: &[
	] },
	Vendor { id: 0x11F6, name: "Compex", devices: &[
		Device { id: 0x0112, name: "ENet100VG4" },
		Device { id: 0x0113, name: "FreedomLine 100" },
		Device { id: 0x1401, name: "ReadyLink 2000" },
		Device { id: 0x2011, name: "RL100-ATX 10/100" },
		Device { id: 0x2201, name: "ReadyLink 100TX (Winbond W89C840)" },
		Device { id: 0x9881, name: "RL100TX Fast Ethernet" },
	] },
	Vendor { id: 0x11F7, name: "Scientific Atlanta", devices: &[
	] },
	Vendor { id: 0x11F8, name: "PMC-Sierra Inc.", devices: &[
		Device { id: 0x5220, name: "BR522x [PMC-Sierra maxRAID SAS Controller]" },
		Device { id: 0x7364, name: "PM7364 [FREEDM - 32 Frame Engine & Datalink Mgr]" },
		Device { id: 0x7375, name: "PM7375 [LASAR-155 ATM SAR]" },
		Device { id: 0x7384, name: "PM7384 [FREEDM - 84P672 Frm Engine & Datalink Mgr]" },
		Device { id: 0x8000, name: "PM8000  [SPC - SAS Protocol Controller]" },
		Device { id: 0x8009, name: "PM8009 SPCve 8x6G" },
		Device { id: 0x8032, name: "ATTO Celerity FC8xEN" },
		Device { id: 0x8053, name: "PM8053 SXP 12G 24-port SAS/SATA expander" },
		Device { id: 0x8054, name: "PM8054 SXP 12G 36-port SAS/SATA expander" },
		Device { id: 0x8055, name: "PM8055 SXP 12G 48-port SAS/SATA expander" },
		Device { id: 0x8056, name: "PM8056 SXP 12G 68-port SAS/SATA expander" },
		Device { id: 0x8060, name: "PM8060 SRCv 12G eight-port SAS/SATA RoC" },
		Device { id: 0x8063, name: "PM8063 SRCv 12G 16-port SAS/SATA RoC" },
		Device { id: 0x8070, name: "PM8070 Tachyon SPCv 12G eight-port SAS/SATA controller" },
		Device { id: 0x8071, name: "PM8071 Tachyon SPCve 12G eight-port SAS/SATA controller" },
		Device { id: 0x8072, name: "PM8072 Tachyon SPCv 12G 16-port SAS/SATA controller" },
		Device { id: 0x8073, name: "PM8073 Tachyon SPCve 12G 16-port SAS/SATA controller" },
		Device { id: 0x8531, name: "PM8531 PFX 24xG3 Fanout PCIe Switches" },
		Device { id: 0x8546, name: "PM8546 B-FEIP PSX 96xG3 PCIe Storage Switch" },
	] },
	Vendor { id: 0x11F9, name: "I-Cube Inc", devices: &[
	] },
	Vendor { id: 0x11FA, name: "Kasan Electronics Company, Ltd.", devices: &[
	] },
	Vendor { id: 0x11FB, name: "Datel Inc", devices: &[
	] },
	Vendor { id: 0x11FC, name: "Silicon Magic", devices: &[
	] },
	Vendor { id: 0x11FD, name: "High Street Consultants", devices: &[
	] },
	Vendor { id: 0x11FE, name: "Comtrol Corporation", devices: &[
		Device { id: 0x0001, name: "RocketPort 32 port w/external I/F" },
		Device { id: 0x0002, name: "RocketPort 8 port w/external I/F" },
		Device { id: 0x0003, name: "RocketPort 16 port w/external I/F" },
		Device { id: 0x0004, name: "RocketPort 4 port w/quad cable" },
		Device { id: 0x0005, name: "RocketPort 8 port w/octa cable" },
		Device { id: 0x0006, name: "RocketPort 8 port w/RJ11 connectors" },
		Device { id: 0x0007, name: "RocketPort 4 port w/RJ11 connectors" },
		Device { id: 0x0008, name: "RocketPort 8 port w/ DB78 SNI (Siemens) connector" },
		Device { id: 0x0009, name: "RocketPort 16 port w/ DB78 SNI (Siemens) connector" },
		Device { id: 0x000A, name: "RocketPort Plus 4 port" },
		Device { id: 0x000B, name: "RocketPort Plus 8 port" },
		Device { id: 0x000C, name: "RocketModem 6 port" },
		Device { id: 0x000D, name: "RocketModem 4-port" },
		Device { id: 0x000E, name: "RocketPort Plus 2 port RS232" },
		Device { id: 0x000F, name: "RocketPort Plus 2 port RS422" },
		Device { id: 0x0040, name: "RocketPort Infinity Octa, 8port, RJ45" },
		Device { id: 0x0041, name: "RocketPort Infinity 32port, External Interface" },
		Device { id: 0x0042, name: "RocketPort Infinity 8port, External Interface" },
		Device { id: 0x0043, name: "RocketPort Infinity 16port, External Interface" },
		Device { id: 0x0044, name: "RocketPort Infinity Quad, 4port, DB" },
		Device { id: 0x0045, name: "RocketPort Infinity Octa, 8port, DB" },
		Device { id: 0x0047, name: "RocketPort Infinity 4port, RJ45" },
		Device { id: 0x004F, name: "RocketPort Infinity 2port, SMPTE" },
		Device { id: 0x0052, name: "RocketPort Infinity Octa, 8port, SMPTE" },
		Device { id: 0x0801, name: "RocketPort UPCI 32 port w/external I/F" },
		Device { id: 0x0802, name: "RocketPort UPCI 8 port w/external I/F" },
		Device { id: 0x0803, name: "RocketPort UPCI 16 port w/external I/F" },
		Device { id: 0x0805, name: "RocketPort UPCI 8 port w/octa cable" },
		Device { id: 0x080C, name: "RocketModem III 8 port" },
		Device { id: 0x080D, name: "RocketModem III 4 port" },
		Device { id: 0x0810, name: "RocketPort UPCI Plus 4 port RS232" },
		Device { id: 0x0811, name: "RocketPort UPCI Plus 8 port RS232" },
		Device { id: 0x0812, name: "RocketPort UPCI Plus 8 port RS422" },
		Device { id: 0x0903, name: "RocketPort Compact PCI 16 port w/external I/F" },
		Device { id: 0x8015, name: "RocketPort 4-port UART 16954" },
	] },
	Vendor { id: 0x11FF, name: "Scion Corporation", devices: &[
		Device { id: 0x0003, name: "AG-5" },
	] },
	Vendor { id: 0x1200, name: "CSS Corporation", devices: &[
	] },
	Vendor { id: 0x1201, name: "Vista Controls Corp", devices: &[
	] },
	Vendor { id: 0x1202, name: "Network General Corp.", devices: &[
		Device { id: 0x4300, name: "Gigabit Ethernet Adapter" },
	] },
	Vendor { id: 0x1203, name: "Bayer Corporation, Agfa Division", devices: &[
	] },
	Vendor { id: 0x1204, name: "Lattice Semiconductor Corporation", devices: &[
		Device { id: 0x1965, name: "SB6501 802.11ad Wireless Network Adapter" },
	] },
	Vendor { id: 0x1205, name: "Array Corporation", devices: &[
	] },
	Vendor { id: 0x1206, name: "Amdahl Corporation", devices: &[
	] },
	Vendor { id: 0x1208, name: "Parsytec GmbH", devices: &[
		Device { id: 0x4853, name: "HS-Link Device" },
	] },
	Vendor { id: 0x1209, name: "SCI Systems Inc", devices: &[
	] },
	Vendor { id: 0x120A, name: "Synaptel", devices: &[
	] },
	Vendor { id: 0x120B, name: "Adaptive Solutions", devices: &[
	] },
	Vendor { id: 0x120C, name: "Technical Corp.", devices: &[
	] },
	Vendor { id: 0x120D, name: "Compression Labs, Inc.", devices: &[
	] },
	Vendor { id: 0x120E, name: "Cyclades Corporation", devices: &[
		Device { id: 0x0100, name: "Cyclom-Y below first megabyte" },
		Device { id: 0x0101, name: "Cyclom-Y above first megabyte" },
		Device { id: 0x0102, name: "Cyclom-4Y below first megabyte" },
		Device { id: 0x0103, name: "Cyclom-4Y above first megabyte" },
		Device { id: 0x0104, name: "Cyclom-8Y below first megabyte" },
		Device { id: 0x0105, name: "Cyclom-8Y above first megabyte" },
		Device { id: 0x0200, name: "Cyclades-Z below first megabyte" },
		Device { id: 0x0201, name: "Cyclades-Z above first megabyte" },
		Device { id: 0x0300, name: "PC300/RSV or /X21 (2 ports)" },
		Device { id: 0x0301, name: "PC300/RSV or /X21 (1 port)" },
		Device { id: 0x0310, name: "PC300/TE (2 ports)" },
		Device { id: 0x0311, name: "PC300/TE (1 port)" },
		Device { id: 0x0320, name: "PC300/TE-M (2 ports)" },
		Device { id: 0x0321, name: "PC300/TE-M (1 port)" },
		Device { id: 0x0400, name: "PC400" },
	] },
	Vendor { id: 0x120F, name: "Essential Communications", devices: &[
		Device { id: 0x0001, name: "Roadrunner serial HIPPI" },
	] },
	Vendor { id: 0x1210, name: "Hyperparallel Technologies", devices: &[
	] },
	Vendor { id: 0x1211, name: "Braintech Inc", devices: &[
	] },
	Vendor { id: 0x1212, name: "Kingston Technology Corp.", devices: &[
	] },
	Vendor { id: 0x1213, name: "Applied Intelligent Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x1214, name: "Performance Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x1215, name: "Interware Co., Ltd", devices: &[
	] },
	Vendor { id: 0x1216, name: "Purup Prepress A/S", devices: &[
	] },
	Vendor { id: 0x1217, name: "O2 Micro, Inc.", devices: &[
		Device { id: 0x00F7, name: "Firewire (IEEE 1394)" },
		Device { id: 0x10F7, name: "1394 OHCI Compliant Host Controller" },
		Device { id: 0x11F7, name: "OZ600 1394a-2000 Controller" },
		Device { id: 0x13F7, name: "1394 OHCI Compliant Host Controller" },
		Device { id: 0x6729, name: "OZ6729" },
		Device { id: 0x673A, name: "OZ6730" },
		Device { id: 0x6832, name: "OZ6832/6833 CardBus Controller" },
		Device { id: 0x6836, name: "OZ6836/6860 CardBus Controller" },
		Device { id: 0x6872, name: "OZ6812 CardBus Controller" },
		Device { id: 0x6925, name: "OZ6922 CardBus Controller" },
		Device { id: 0x6933, name: "OZ6933/711E1 CardBus/SmartCardBus Controller" },
		Device { id: 0x6972, name: "OZ601/6912/711E0 CardBus/SmartCardBus Controller" },
		Device { id: 0x7110, name: "OZ711Mx 4-in-1 MemoryCardBus Accelerator" },
		Device { id: 0x7112, name: "OZ711EC1/M1 SmartCardBus/MemoryCardBus Controller" },
		Device { id: 0x7113, name: "OZ711EC1 SmartCardBus Controller" },
		Device { id: 0x7114, name: "OZ711M1/MC1 4-in-1 MemoryCardBus Controller" },
		Device { id: 0x7120, name: "Integrated MMC/SD Controller" },
		Device { id: 0x7130, name: "Integrated MS/xD Controller" },
		Device { id: 0x7134, name: "OZ711MP1/MS1 MemoryCardBus Controller" },
		Device { id: 0x7135, name: "Cardbus bridge" },
		Device { id: 0x7136, name: "OZ711SP1 Memory CardBus Controller" },
		Device { id: 0x71E2, name: "OZ711E2 SmartCardBus Controller" },
		Device { id: 0x7212, name: "OZ711M2 4-in-1 MemoryCardBus Controller" },
		Device { id: 0x7213, name: "OZ6933E CardBus Controller" },
		Device { id: 0x7223, name: "OZ711M3/MC3 4-in-1 MemoryCardBus Controller" },
		Device { id: 0x7233, name: "OZ711MP3/MS3 4-in-1 MemoryCardBus Controller" },
		Device { id: 0x8120, name: "Integrated MMC/SD Controller" },
		Device { id: 0x8130, name: "Integrated MS/MSPRO/xD Controller" },
		Device { id: 0x8220, name: "OZ600FJ1/OZ900FJ1 SD/MMC Card Reader Controller" },
		Device { id: 0x8221, name: "OZ600FJ0/OZ900FJ0/OZ600FJS SD/MMC Card Reader Controller" },
		Device { id: 0x8320, name: "OZ600RJ1/OZ900RJ1 SD/MMC Card Reader Controller" },
		Device { id: 0x8321, name: "OZ600RJ0/OZ900RJ0/OZ600RJS SD/MMC Card Reader Controller" },
		Device { id: 0x8330, name: "OZ600 MS/xD Controller" },
		Device { id: 0x8331, name: "O2 Flash Memory Card" },
		Device { id: 0x8520, name: "SD/MMC Card Reader Controller" },
		Device { id: 0x8621, name: "SD/MMC Card Reader Controller" },
	] },
	Vendor { id: 0x1218, name: "Hybricon Corp.", devices: &[
	] },
	Vendor { id: 0x1219, name: "First Virtual Corporation", devices: &[
	] },
	Vendor { id: 0x121A, name: "3Dfx Interactive, Inc.", devices: &[
		Device { id: 0x0001, name: "Voodoo" },
		Device { id: 0x0002, name: "Voodoo 2" },
		Device { id: 0x0003, name: "Voodoo Banshee" },
		Device { id: 0x0004, name: "Voodoo Banshee [Velocity 100]" },
		Device { id: 0x0005, name: "Voodoo 3" },
		Device { id: 0x0009, name: "Voodoo 4 / Voodoo 5" },
		Device { id: 0x0057, name: "Voodoo 3/3000 [Avenger]" },
	] },
	Vendor { id: 0x121B, name: "Advanced Telecommunications Modules", devices: &[
	] },
	Vendor { id: 0x121C, name: "Nippon Texaco., Ltd", devices: &[
	] },
	Vendor { id: 0x121D, name: "LiPPERT ADLINK Technology GmbH", devices: &[
	] },
	Vendor { id: 0x121E, name: "CSPI", devices: &[
		Device { id: 0x0201, name: "Myrinet 2000 Scalable Cluster Interconnect" },
	] },
	Vendor { id: 0x121F, name: "Arcus Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x1220, name: "Ariel Corporation", devices: &[
		Device { id: 0x1220, name: "AMCC 5933 TMS320C80 DSP/Imaging board" },
	] },
	Vendor { id: 0x1221, name: "Contec Co., Ltd", devices: &[
		Device { id: 0x9172, name: "PO-64L(PCI)H [Isolated Digital Output Board for PCI]" },
		Device { id: 0x91A2, name: "PO-32L(PCI)H [Isolated Digital Output Board for PCI]" },
		Device { id: 0x91C3, name: "DA16-16(LPCI)L [Un-insulated highly precise analog output board for Low Profile PCI]" },
		Device { id: 0xB152, name: "DIO-96D2-LPCI" },
		Device { id: 0xC103, name: "ADA16-32/2(PCI)F [High-Speed Analog I/O Board for PCI]" },
	] },
	Vendor { id: 0x1222, name: "Ancor Communications, Inc.", devices: &[
	] },
	Vendor { id: 0x1223, name: "Artesyn Communication Products", devices: &[
		Device { id: 0x0003, name: "PM/Link" },
		Device { id: 0x0004, name: "PM/T1" },
		Device { id: 0x0005, name: "PM/E1" },
		Device { id: 0x0008, name: "PM/SLS" },
		Device { id: 0x0009, name: "BajaSpan Resource Target" },
		Device { id: 0x000A, name: "BajaSpan Section 0" },
		Device { id: 0x000B, name: "BajaSpan Section 1" },
		Device { id: 0x000C, name: "BajaSpan Section 2" },
		Device { id: 0x000D, name: "BajaSpan Section 3" },
		Device { id: 0x000E, name: "PM/PPC" },
	] },
	Vendor { id: 0x1224, name: "Interactive Images", devices: &[
	] },
	Vendor { id: 0x1225, name: "Power I/O, Inc.", devices: &[
	] },
	Vendor { id: 0x1227, name: "Tech-Source", devices: &[
		Device { id: 0x0006, name: "Raptor GFX 8P" },
		Device { id: 0x0023, name: "Raptor GFX [1100T]" },
		Device { id: 0x0045, name: "Raptor 4000-L [Linux version]" },
		Device { id: 0x004A, name: "Raptor 4000-LR-L [Linux version]" },
	] },
	Vendor { id: 0x1228, name: "Norsk Elektro Optikk A/S", devices: &[
	] },
	Vendor { id: 0x1229, name: "Data Kinesis Inc.", devices: &[
	] },
	Vendor { id: 0x122A, name: "Integrated Telecom", devices: &[
	] },
	Vendor { id: 0x122B, name: "LG Industrial Systems Co., Ltd", devices: &[
	] },
	Vendor { id: 0x122C, name: "Sican GmbH", devices: &[
	] },
	Vendor { id: 0x122D, name: "Aztech System Ltd", devices: &[
		Device { id: 0x1206, name: "368DSP" },
		Device { id: 0x1400, name: "Trident PCI288-Q3DII (NX)" },
		Device { id: 0x50DC, name: "3328 Audio" },
		Device { id: 0x80DA, name: "3328 Audio" },
	] },
	Vendor { id: 0x122E, name: "Xyratex", devices: &[
		Device { id: 0x7722, name: "Napatech XL1" },
		Device { id: 0x7724, name: "Napatech XL2/XA" },
		Device { id: 0x7729, name: "Napatech XD" },
	] },
	Vendor { id: 0x122F, name: "Andrew Corporation", devices: &[
	] },
	Vendor { id: 0x1230, name: "Fishcamp Engineering", devices: &[
	] },
	Vendor { id: 0x1231, name: "Woodward McCoach, Inc.", devices: &[
		Device { id: 0x04E1, name: "Desktop PCI Telephony 4" },
		Device { id: 0x05E1, name: "Desktop PCI Telephony 5/6" },
		Device { id: 0x0D00, name: "LightParser" },
		Device { id: 0x0D02, name: "LightParser 2" },
		Device { id: 0x0D13, name: "Desktop PCI L1/L3 Telephony" },
	] },
	Vendor { id: 0x1232, name: "GPT Limited", devices: &[
	] },
	Vendor { id: 0x1233, name: "Bus-Tech, Inc.", devices: &[
	] },
	Vendor { id: 0x1235, name: "Risq Modular Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x1236, name: "Sigma Designs Corporation", devices: &[
		Device { id: 0x0000, name: "RealMagic64/GX" },
		Device { id: 0x6401, name: "REALmagic 64/GX (SD 6425)" },
	] },
	Vendor { id: 0x1237, name: "Alta Technology Corporation", devices: &[
	] },
	Vendor { id: 0x1238, name: "Adtran", devices: &[
	] },
	Vendor { id: 0x1239, name: "3DO Company", devices: &[
	] },
	Vendor { id: 0x123A, name: "Visicom Laboratories, Inc.", devices: &[
	] },
	Vendor { id: 0x123B, name: "Seeq Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x123C, name: "Century Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x123D, name: "Engineering Design Team, Inc.", devices: &[
		Device { id: 0x0000, name: "EasyConnect 8/32" },
		Device { id: 0x0002, name: "EasyConnect 8/64" },
		Device { id: 0x0003, name: "EasyIO" },
	] },
	Vendor { id: 0x123E, name: "Simutech, Inc.", devices: &[
	] },
	Vendor { id: 0x123F, name: "LSI Logic", devices: &[
		Device { id: 0x00E4, name: "MPEG" },
		Device { id: 0x8120, name: "DVxplore Codec" },
		Device { id: 0x8888, name: "Cinemaster C 3.0 DVD Decoder" },
	] },
	Vendor { id: 0x1240, name: "Marathon Technologies Corp.", devices: &[
	] },
	Vendor { id: 0x1241, name: "DSC Communications", devices: &[
	] },
	Vendor { id: 0x1242, name: "JNI Corporation", devices: &[
		Device { id: 0x1560, name: "JNIC-1560 PCI-X Fibre Channel Controller" },
		Device { id: 0x4643, name: "FCI-1063 Fibre Channel Adapter" },
		Device { id: 0x6562, name: "FCX2-6562 Dual Channel PCI-X Fibre Channel Adapter" },
		Device { id: 0x656A, name: "FCX-6562 PCI-X Fibre Channel Adapter" },
	] },
	Vendor { id: 0x1243, name: "Delphax", devices: &[
	] },
	Vendor { id: 0x1244, name: "AVM GmbH", devices: &[
		Device { id: 0x0700, name: "B1 ISDN" },
		Device { id: 0x0800, name: "C4 ISDN" },
		Device { id: 0x0A00, name: "A1 ISDN [Fritz]" },
		Device { id: 0x0E00, name: "Fritz!Card PCI v2.0 ISDN" },
		Device { id: 0x0E80, name: "Fritz!Card PCI v2.1 ISDN" },
		Device { id: 0x1100, name: "C2 ISDN" },
		Device { id: 0x1200, name: "T1 ISDN" },
		Device { id: 0x2700, name: "Fritz!Card DSL SL" },
		Device { id: 0x2900, name: "Fritz!Card DSL v2.0" },
	] },
	Vendor { id: 0x1245, name: "A.P.D., S.A.", devices: &[
	] },
	Vendor { id: 0x1246, name: "Dipix Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x1247, name: "Xylon Research, Inc.", devices: &[
	] },
	Vendor { id: 0x1248, name: "Central Data Corporation", devices: &[
	] },
	Vendor { id: 0x1249, name: "Samsung Electronics Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x124A, name: "AEG Electrocom GmbH", devices: &[
	] },
	Vendor { id: 0x124B, name: "SBS/Greenspring Modular I/O", devices: &[
		Device { id: 0x0040, name: "PCI-40A or cPCI-200 Quad IndustryPack carrier" },
	] },
	Vendor { id: 0x124C, name: "Solitron Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x124D, name: "Stallion Technologies, Inc.", devices: &[
		Device { id: 0x0000, name: "EasyConnection 8/32" },
		Device { id: 0x0002, name: "EasyConnection 8/64" },
		Device { id: 0x0003, name: "EasyIO" },
		Device { id: 0x0004, name: "EasyConnection/RA" },
	] },
	Vendor { id: 0x124E, name: "Cylink", devices: &[
	] },
	Vendor { id: 0x124F, name: "Infortrend Technology, Inc.", devices: &[
		Device { id: 0x0041, name: "IFT-2000 Series RAID Controller" },
	] },
	Vendor { id: 0x1250, name: "Hitachi Microcomputer System Ltd", devices: &[
	] },
	Vendor { id: 0x1251, name: "VLSI Solutions Oy", devices: &[
	] },
	Vendor { id: 0x1253, name: "Guzik Technical Enterprises", devices: &[
	] },
	Vendor { id: 0x1254, name: "Linear Systems Ltd.", devices: &[
		Device { id: 0x0065, name: "DVB Master FD" },
		Device { id: 0x007C, name: "DVB Master Quad/o" },
	] },
	Vendor { id: 0x1255, name: "Optibase Ltd", devices: &[
		Device { id: 0x1110, name: "MPEG Forge" },
		Device { id: 0x1210, name: "MPEG Fusion" },
		Device { id: 0x2110, name: "VideoPlex" },
		Device { id: 0x2120, name: "VideoPlex CC" },
		Device { id: 0x2130, name: "VideoQuest" },
	] },
	Vendor { id: 0x1256, name: "Perceptive Solutions, Inc.", devices: &[
		Device { id: 0x4201, name: "PCI-2220I" },
		Device { id: 0x4401, name: "PCI-2240I" },
		Device { id: 0x5201, name: "PCI-2000" },
	] },
	Vendor { id: 0x1257, name: "Vertex Networks, Inc.", devices: &[
	] },
	Vendor { id: 0x1258, name: "Gilbarco, Inc.", devices: &[
	] },
	Vendor { id: 0x1259, name: "Allied Telesis", devices: &[
		Device { id: 0x2560, name: "AT-2560 Fast Ethernet Adapter (i82557B)" },
		Device { id: 0x2801, name: "AT-2801FX (RTL-8139)" },
		Device { id: 0xA117, name: "RTL81xx Fast Ethernet" },
		Device { id: 0xA11E, name: "RTL81xx Fast Ethernet" },
		Device { id: 0xA120, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
	] },
	Vendor { id: 0x125A, name: "ABB Power Systems", devices: &[
	] },
	Vendor { id: 0x125B, name: "Asix Electronics Corporation", devices: &[
		Device { id: 0x1400, name: "AX88141 Fast Ethernet Controller" },
	] },
	Vendor { id: 0x125C, name: "Aurora Technologies, Inc.", devices: &[
		Device { id: 0x0101, name: "Saturn 4520P" },
		Device { id: 0x0640, name: "Aries 16000P" },
	] },
	Vendor { id: 0x125D, name: "ESS Technology", devices: &[
		Device { id: 0x0000, name: "ES336H Fax Modem (Early Model)" },
		Device { id: 0x1948, name: "ES1948 Maestro-1" },
		Device { id: 0x1968, name: "ES1968 Maestro 2" },
		Device { id: 0x1969, name: "ES1938/ES1946/ES1969 Solo-1 Audiodrive" },
		Device { id: 0x1978, name: "ES1978 Maestro 2E" },
		Device { id: 0x1988, name: "ES1988 Allegro-1" },
		Device { id: 0x1989, name: "ESS Modem" },
		Device { id: 0x1998, name: "ES1983S Maestro-3i PCI Audio Accelerator" },
		Device { id: 0x1999, name: "ES1983S Maestro-3i PCI Modem Accelerator" },
		Device { id: 0x199A, name: "ES1983S Maestro-3i PCI Audio Accelerator" },
		Device { id: 0x199B, name: "ES1983S Maestro-3i PCI Modem Accelerator" },
		Device { id: 0x2808, name: "ES336H Fax Modem (Later Model)" },
		Device { id: 0x2838, name: "ES2838/2839 SuperLink Modem" },
		Device { id: 0x2898, name: "ES2898 Modem" },
	] },
	Vendor { id: 0x125E, name: "Specialvideo Engineering SRL", devices: &[
	] },
	Vendor { id: 0x125F, name: "Concurrent Technologies, Inc.", devices: &[
		Device { id: 0x2071, name: "CC PMC/232" },
		Device { id: 0x2084, name: "CC PMC/23P" },
		Device { id: 0x2091, name: "CC PMC/422" },
	] },
	Vendor { id: 0x1260, name: "Intersil Corporation", devices: &[
		Device { id: 0x3872, name: "ISL3872 [Prism 3]" },
		Device { id: 0x3873, name: "ISL3874 [Prism 2.5]/ISL3872 [Prism 3]" },
		Device { id: 0x3877, name: "ISL3877 [Prism Indigo]" },
		Device { id: 0x3886, name: "ISL3886 [Prism Javelin/Prism Xbow]" },
		Device { id: 0x3890, name: "ISL3890 [Prism GT/Prism Duette]/ISL3886 [Prism Javelin/Prism Xbow]" },
		Device { id: 0x8130, name: "HMP8130 NTSC/PAL Video Decoder" },
		Device { id: 0x8131, name: "HMP8131 NTSC/PAL Video Decoder" },
		Device { id: 0xFFFF, name: "ISL3886IK" },
	] },
	Vendor { id: 0x1261, name: "Matsushita-Kotobuki Electronics Industries, Ltd.", devices: &[
	] },
	Vendor { id: 0x1262, name: "ES Computer Company, Ltd.", devices: &[
	] },
	Vendor { id: 0x1263, name: "Sonic Solutions", devices: &[
	] },
	Vendor { id: 0x1264, name: "Aval Nagasaki Corporation", devices: &[
	] },
	Vendor { id: 0x1265, name: "Casio Computer Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1266, name: "Microdyne Corporation", devices: &[
		Device { id: 0x0001, name: "NE10/100 Adapter (i82557B)" },
		Device { id: 0x1910, name: "NE2000Plus (RT8029) Ethernet Adapter" },
	] },
	Vendor { id: 0x1267, name: "S. A. Telecommunications", devices: &[
		Device { id: 0x5352, name: "PCR2101" },
		Device { id: 0x5A4B, name: "Telsat Turbo" },
	] },
	Vendor { id: 0x1268, name: "Tektronix", devices: &[
	] },
	Vendor { id: 0x1269, name: "Thomson-CSF/TTM", devices: &[
	] },
	Vendor { id: 0x126A, name: "Lexmark International, Inc.", devices: &[
	] },
	Vendor { id: 0x126B, name: "Adax, Inc.", devices: &[
	] },
	Vendor { id: 0x126C, name: "Northern Telecom", devices: &[
		Device { id: 0x1211, name: "10/100BaseTX [RTL81xx]" },
		Device { id: 0x126C, name: "802.11b Wireless Ethernet Adapter" },
	] },
	Vendor { id: 0x126D, name: "Splash Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x126E, name: "Sumitomo Metal Industries, Ltd.", devices: &[
	] },
	Vendor { id: 0x126F, name: "Silicon Motion, Inc.", devices: &[
		Device { id: 0x0501, name: "SM501 VoyagerGX Rev. AA" },
		Device { id: 0x0510, name: "SM501 VoyagerGX Rev. B" },
		Device { id: 0x0710, name: "SM710 LynxEM" },
		Device { id: 0x0712, name: "SM712 LynxEM+" },
		Device { id: 0x0718, name: "SM718 LynxSE+" },
		Device { id: 0x0720, name: "SM720 Lynx3DM" },
		Device { id: 0x0730, name: "SM731 Cougar3DR" },
		Device { id: 0x0750, name: "SM750" },
		Device { id: 0x0810, name: "SM810 LynxE" },
		Device { id: 0x0811, name: "SM811 LynxE" },
		Device { id: 0x0820, name: "SM820 Lynx3D" },
		Device { id: 0x0910, name: "SM910" },
	] },
	Vendor { id: 0x1270, name: "Olympus Optical Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1271, name: "GW Instruments", devices: &[
	] },
	Vendor { id: 0x1272, name: "Telematics International", devices: &[
	] },
	Vendor { id: 0x1273, name: "Hughes Network Systems", devices: &[
		Device { id: 0x0002, name: "DirecPC" },
	] },
	Vendor { id: 0x1274, name: "Ensoniq", devices: &[
		Device { id: 0x1171, name: "ES1373 / Creative Labs CT5803 [AudioPCI]" },
		Device { id: 0x1371, name: "ES1371/ES1373 / Creative Labs CT2518" },
		Device { id: 0x5000, name: "ES1370 [AudioPCI]" },
		Device { id: 0x5880, name: "5880B / Creative Labs CT5880" },
		Device { id: 0x8001, name: "CT5880 [AudioPCI]" },
		Device { id: 0x8002, name: "5880A [AudioPCI]" },
	] },
	Vendor { id: 0x1275, name: "Network Appliance Corporation", devices: &[
	] },
	Vendor { id: 0x1276, name: "Switched Network Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x1277, name: "Comstream", devices: &[
	] },
	Vendor { id: 0x1278, name: "Transtech Parallel Systems Ltd.", devices: &[
		Device { id: 0x0701, name: "TPE3/TM3 PowerPC Node" },
		Device { id: 0x0710, name: "TPE5 PowerPC PCI board" },
		Device { id: 0x1100, name: "PMC-FPGA02" },
		Device { id: 0x1101, name: "TS-C43 card with 4 ADSP-TS101 processors" },
	] },
	Vendor { id: 0x1279, name: "Transmeta Corporation", devices: &[
		Device { id: 0x0060, name: "TM8000 Northbridge" },
		Device { id: 0x0061, name: "TM8000 AGP bridge" },
		Device { id: 0x0295, name: "Northbridge" },
		Device { id: 0x0395, name: "LongRun Northbridge" },
		Device { id: 0x0396, name: "SDRAM controller" },
		Device { id: 0x0397, name: "BIOS scratchpad" },
	] },
	Vendor { id: 0x127A, name: "Rockwell International", devices: &[
		Device { id: 0x1002, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x1003, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x1004, name: "HCF 56k Data/Fax/Voice Modem" },
		Device { id: 0x1005, name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x1022, name: "HCF 56k Modem" },
		Device { id: 0x1023, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x1024, name: "HCF 56k Data/Fax/Voice Modem" },
		Device { id: 0x1025, name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x1026, name: "HCF 56k PCI Speakerphone Modem" },
		Device { id: 0x1032, name: "HCF 56k Modem" },
		Device { id: 0x1033, name: "HCF 56k Modem" },
		Device { id: 0x1034, name: "HCF 56k Modem" },
		Device { id: 0x1035, name: "HCF 56k PCI Speakerphone Modem" },
		Device { id: 0x1036, name: "HCF 56k Modem" },
		Device { id: 0x1085, name: "HCF 56k Volcano PCI Modem" },
		Device { id: 0x2004, name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x2005, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x2013, name: "HSF 56k Data/Fax Modem" },
		Device { id: 0x2014, name: "HSF 56k Data/Fax/Voice Modem" },
		Device { id: 0x2015, name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x2016, name: "HSF 56k Data/Fax/Voice/Spkp Modem" },
		Device { id: 0x4311, name: "Riptide HSF 56k PCI Modem" },
		Device { id: 0x4320, name: "Riptide PCI Audio Controller" },
		Device { id: 0x4321, name: "Riptide HCF 56k PCI Modem" },
		Device { id: 0x4322, name: "Riptide PCI Game Controller" },
		Device { id: 0x8234, name: "RapidFire 616X ATM155 Adapter" },
	] },
	Vendor { id: 0x127B, name: "Pixera Corporation", devices: &[
	] },
	Vendor { id: 0x127C, name: "Crosspoint Solutions, Inc.", devices: &[
	] },
	Vendor { id: 0x127D, name: "Vela Research", devices: &[
	] },
	Vendor { id: 0x127E, name: "Winnov, L.P.", devices: &[
		Device { id: 0x0010, name: "Videum 1000 Plus" },
	] },
	Vendor { id: 0x127F, name: "Fujifilm", devices: &[
	] },
	Vendor { id: 0x1280, name: "Photoscript Group Ltd.", devices: &[
	] },
	Vendor { id: 0x1281, name: "Yokogawa Electric Corporation", devices: &[
	] },
	Vendor { id: 0x1282, name: "Davicom Semiconductor, Inc.", devices: &[
		Device { id: 0x6585, name: "DM562P V90 Modem" },
		Device { id: 0x9009, name: "Ethernet 100/10 MBit" },
		Device { id: 0x9100, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
		Device { id: 0x9102, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
		Device { id: 0x9132, name: "Ethernet 100/10 MBit" },
	] },
	Vendor { id: 0x1283, name: "Integrated Technology Express, Inc.", devices: &[
		Device { id: 0x673A, name: "IT8330G" },
		Device { id: 0x8152, name: "IT8152F/G Advanced RISC-to-PCI Companion Chip" },
		Device { id: 0x8211, name: "ITE 8211F Single Channel UDMA 133" },
		Device { id: 0x8212, name: "IT8212 Dual channel ATA RAID controller" },
		Device { id: 0x8213, name: "IT8213 IDE Controller" },
		Device { id: 0x8330, name: "IT8330G" },
		Device { id: 0x8872, name: "IT887xF PCI to ISA I/O chip with SMB, GPIO, Serial or Parallel Port" },
		Device { id: 0x8888, name: "IT8888F/G PCI to ISA Bridge with SMB [Golden Gate]" },
		Device { id: 0x8889, name: "IT8889F PCI to ISA Bridge" },
		Device { id: 0x8893, name: "IT8893E PCIe to PCI Bridge" },
		Device { id: 0xE886, name: "IT8330G" },
	] },
	Vendor { id: 0x1284, name: "Sahara Networks, Inc.", devices: &[
	] },
	Vendor { id: 0x1285, name: "Platform Technologies, Inc.", devices: &[
		Device { id: 0x0100, name: "AGOGO sound chip (aka ESS Maestro 1)" },
	] },
	Vendor { id: 0x1286, name: "Mazet GmbH", devices: &[
	] },
	Vendor { id: 0x1287, name: "M-Pact, Inc.", devices: &[
		Device { id: 0x001E, name: "LS220D DVD Decoder" },
		Device { id: 0x001F, name: "LS220C DVD Decoder" },
	] },
	Vendor { id: 0x1288, name: "Timestep Corporation", devices: &[
	] },
	Vendor { id: 0x1289, name: "AVC Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x128A, name: "Asante Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x128B, name: "Transwitch Corporation", devices: &[
	] },
	Vendor { id: 0x128C, name: "Retix Corporation", devices: &[
	] },
	Vendor { id: 0x128D, name: "G2 Networks, Inc.", devices: &[
		Device { id: 0x0021, name: "ATM155 Adapter" },
	] },
	Vendor { id: 0x128E, name: "Hoontech Corporation/Samho Multi Tech Ltd.", devices: &[
		Device { id: 0x0008, name: "ST128 WSS/SB" },
		Device { id: 0x0009, name: "ST128 SAM9407" },
		Device { id: 0x000A, name: "ST128 Game Port" },
		Device { id: 0x000B, name: "ST128 MPU Port" },
		Device { id: 0x000C, name: "ST128 Ctrl Port" },
	] },
	Vendor { id: 0x128F, name: "Tateno Dennou, Inc.", devices: &[
	] },
	Vendor { id: 0x1290, name: "Sord Computer Corporation", devices: &[
	] },
	Vendor { id: 0x1291, name: "NCS Computer Italia", devices: &[
	] },
	Vendor { id: 0x1292, name: "Tritech Microelectronics Inc", devices: &[
		Device { id: 0xFC02, name: "Pyramid3D TR25202" },
	] },
	Vendor { id: 0x1293, name: "Media Reality Technology", devices: &[
	] },
	Vendor { id: 0x1294, name: "Rhetorex, Inc.", devices: &[
	] },
	Vendor { id: 0x1295, name: "Imagenation Corporation", devices: &[
		Device { id: 0x0800, name: "PXR800" },
		Device { id: 0x1000, name: "PXD1000" },
	] },
	Vendor { id: 0x1296, name: "Kofax Image Products", devices: &[
	] },
	Vendor { id: 0x1297, name: "Holco Enterprise Co, Ltd/Shuttle Computer", devices: &[
	] },
	Vendor { id: 0x1298, name: "Spellcaster Telecommunications Inc.", devices: &[
	] },
	Vendor { id: 0x1299, name: "Knowledge Technology Lab.", devices: &[
	] },
	Vendor { id: 0x129A, name: "VMetro, inc.", devices: &[
		Device { id: 0x0615, name: "PBT-615 PCI-X Bus Analyzer" },
		Device { id: 0x1100, name: "PMC-FPGA05" },
		Device { id: 0x1106, name: "XMC-FPGA05F, PCI interface" },
		Device { id: 0x1107, name: "XMC-FPGA05F, PCIe interface" },
		Device { id: 0x1108, name: "XMC-FPGA05D, PCI interface" },
		Device { id: 0x1109, name: "XMC-FPGA05D, PCIe interface" },
	] },
	Vendor { id: 0x129B, name: "Image Access", devices: &[
	] },
	Vendor { id: 0x129C, name: "Jaycor", devices: &[
	] },
	Vendor { id: 0x129D, name: "Compcore Multimedia, Inc.", devices: &[
	] },
	Vendor { id: 0x129E, name: "Victor Company of Japan, Ltd.", devices: &[
	] },
	Vendor { id: 0x129F, name: "OEC Medical Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x12A0, name: "Allen-Bradley Company", devices: &[
	] },
	Vendor { id: 0x12A1, name: "Simpact Associates, Inc.", devices: &[
	] },
	Vendor { id: 0x12A2, name: "Newgen Systems Corporation", devices: &[
	] },
	Vendor { id: 0x12A3, name: "Lucent Technologies", devices: &[
		Device { id: 0x8105, name: "T8105 H100 Digital Switch" },
	] },
	Vendor { id: 0x12A4, name: "NTT Electronics Technology Company", devices: &[
	] },
	Vendor { id: 0x12A5, name: "Vision Dynamics Ltd.", devices: &[
	] },
	Vendor { id: 0x12A6, name: "Scalable Networks, Inc.", devices: &[
	] },
	Vendor { id: 0x12A7, name: "AMO GmbH", devices: &[
	] },
	Vendor { id: 0x12A8, name: "News Datacom", devices: &[
	] },
	Vendor { id: 0x12A9, name: "Xiotech Corporation", devices: &[
	] },
	Vendor { id: 0x12AA, name: "SDL Communications, Inc.", devices: &[
	] },
	Vendor { id: 0x12AB, name: "YUAN High-Tech Development Co., Ltd.", devices: &[
		Device { id: 0x0000, name: "MPG160/Kuroutoshikou ITVC15-STVLP" },
		Device { id: 0x0002, name: "AU8830 [Vortex2] Based Sound Card With A3D Support" },
		Device { id: 0x0003, name: "T507 (DVB-T) TV tuner/capture device" },
		Device { id: 0x2300, name: "Club-3D Zap TV2100" },
		Device { id: 0x3000, name: "MPG-200C PCI DVD Decoder Card" },
		Device { id: 0x4789, name: "MPC788 MiniPCI Hybrid TV Tuner" },
		Device { id: 0xFFF3, name: "MPG600/Kuroutoshikou ITVC16-STVLP" },
		Device { id: 0xFFFF, name: "MPG600/Kuroutoshikou ITVC16-STVLP" },
	] },
	Vendor { id: 0x12AC, name: "Measurex Corporation", devices: &[
	] },
	Vendor { id: 0x12AD, name: "Multidata GmbH", devices: &[
	] },
	Vendor { id: 0x12AE, name: "Alteon Networks Inc.", devices: &[
		Device { id: 0x0001, name: "AceNIC Gigabit Ethernet" },
		Device { id: 0x0002, name: "AceNIC Gigabit Ethernet (Copper)" },
		Device { id: 0x00FA, name: "Farallon PN9100-T Gigabit Ethernet" },
	] },
	Vendor { id: 0x12AF, name: "TDK USA Corp", devices: &[
	] },
	Vendor { id: 0x12B0, name: "Jorge Scientific Corp", devices: &[
	] },
	Vendor { id: 0x12B1, name: "GammaLink", devices: &[
	] },
	Vendor { id: 0x12B2, name: "General Signal Networks", devices: &[
	] },
	Vendor { id: 0x12B3, name: "Inter-Face Co Ltd", devices: &[
	] },
	Vendor { id: 0x12B4, name: "FutureTel Inc", devices: &[
	] },
	Vendor { id: 0x12B5, name: "Granite Systems Inc.", devices: &[
	] },
	Vendor { id: 0x12B6, name: "Natural Microsystems", devices: &[
	] },
	Vendor { id: 0x12B7, name: "Cognex Modular Vision Systems Div. - Acumen Inc.", devices: &[
	] },
	Vendor { id: 0x12B8, name: "Korg", devices: &[
	] },
	Vendor { id: 0x12B9, name: "3Com Corp, Modem Division", devices: &[
		Device { id: 0x1006, name: "WinModem" },
		Device { id: 0x1007, name: "USR 56k Internal WinModem" },
		Device { id: 0x1008, name: "56K FaxModem Model 5610" },
	] },
	Vendor { id: 0x12BA, name: "BittWare, Inc.", devices: &[
	] },
	Vendor { id: 0x12BB, name: "Nippon Unisoft Corporation", devices: &[
	] },
	Vendor { id: 0x12BC, name: "Array Microsystems", devices: &[
	] },
	Vendor { id: 0x12BD, name: "Computerm Corp.", devices: &[
	] },
	Vendor { id: 0x12BE, name: "Anchor Chips Inc.", devices: &[
		Device { id: 0x3041, name: "AN3041Q CO-MEM" },
		Device { id: 0x3042, name: "AN3042Q CO-MEM Lite" },
	] },
	Vendor { id: 0x12BF, name: "Fujifilm Microdevices", devices: &[
	] },
	Vendor { id: 0x12C0, name: "Infimed", devices: &[
	] },
	Vendor { id: 0x12C1, name: "GMM Research Corp", devices: &[
	] },
	Vendor { id: 0x12C2, name: "Mentec Limited", devices: &[
	] },
	Vendor { id: 0x12C3, name: "Holtek Microelectronics Inc", devices: &[
		Device { id: 0x0058, name: "PCI NE2K Ethernet" },
		Device { id: 0x5598, name: "PCI NE2K Ethernet" },
	] },
	Vendor { id: 0x12C4, name: "Connect Tech Inc", devices: &[
		Device { id: 0x0001, name: "Blue HEAT/PCI 8 (RS232/CL/RJ11)" },
		Device { id: 0x0002, name: "Blue HEAT/PCI 4 (RS232)" },
		Device { id: 0x0003, name: "Blue HEAT/PCI 2 (RS232)" },
		Device { id: 0x0004, name: "Blue HEAT/PCI 8 (UNIV, RS485)" },
		Device { id: 0x0005, name: "Blue HEAT/PCI 4+4/6+2 (UNIV, RS232/485)" },
		Device { id: 0x0006, name: "Blue HEAT/PCI 4 (OPTO, RS485)" },
		Device { id: 0x0007, name: "Blue HEAT/PCI 2+2 (RS232/485)" },
		Device { id: 0x0008, name: "Blue HEAT/PCI 2 (OPTO, Tx, RS485)" },
		Device { id: 0x0009, name: "Blue HEAT/PCI 2+6 (RS232/485)" },
		Device { id: 0x000A, name: "Blue HEAT/PCI 8 (Tx, RS485)" },
		Device { id: 0x000B, name: "Blue HEAT/PCI 4 (Tx, RS485)" },
		Device { id: 0x000C, name: "Blue HEAT/PCI 2 (20 MHz, RS485)" },
		Device { id: 0x000D, name: "Blue HEAT/PCI 2 PTM" },
		Device { id: 0x0100, name: "NT960/PCI" },
		Device { id: 0x0201, name: "cPCI Titan - 2 Port" },
		Device { id: 0x0202, name: "cPCI Titan - 4 Port" },
		Device { id: 0x0300, name: "CTI PCI UART 2 (RS232)" },
		Device { id: 0x0301, name: "CTI PCI UART 4 (RS232)" },
		Device { id: 0x0302, name: "CTI PCI UART 8 (RS232)" },
		Device { id: 0x0310, name: "CTI PCI UART 1+1 (RS232/485)" },
		Device { id: 0x0311, name: "CTI PCI UART 2+2 (RS232/485)" },
		Device { id: 0x0312, name: "CTI PCI UART 4+4 (RS232/485)" },
		Device { id: 0x0320, name: "CTI PCI UART 2" },
		Device { id: 0x0321, name: "CTI PCI UART 4" },
		Device { id: 0x0322, name: "CTI PCI UART 8" },
		Device { id: 0x0330, name: "CTI PCI UART 2 (RS485)" },
		Device { id: 0x0331, name: "CTI PCI UART 4 (RS485)" },
		Device { id: 0x0332, name: "CTI PCI UART 8 (RS485)" },
	] },
	Vendor { id: 0x12C5, name: "Picture Elements Incorporated", devices: &[
		Device { id: 0x007E, name: "Imaging/Scanning Subsystem Engine" },
		Device { id: 0x007F, name: "Imaging/Scanning Subsystem Engine" },
		Device { id: 0x0081, name: "PCIVST [Grayscale Thresholding Engine]" },
		Device { id: 0x0085, name: "Video Simulator/Sender" },
		Device { id: 0x0086, name: "THR2 Multi-scale Thresholder" },
	] },
	Vendor { id: 0x12C6, name: "Mitani Corporation", devices: &[
	] },
	Vendor { id: 0x12C7, name: "Dialogic Corp", devices: &[
		Device { id: 0x0546, name: "Springware D/120JCT-LS" },
		Device { id: 0x0647, name: "Springware D/240JCT-T1" },
		Device { id: 0x0676, name: "Springware D/41JCT-LS" },
		Device { id: 0x0685, name: "Springware D/480JCT-2T1" },
	] },
	Vendor { id: 0x12C8, name: "G Force Co, Ltd", devices: &[
	] },
	Vendor { id: 0x12C9, name: "Gigi Operations", devices: &[
	] },
	Vendor { id: 0x12CA, name: "Integrated Computing Engines", devices: &[
	] },
	Vendor { id: 0x12CB, name: "Antex Electronics Corporation", devices: &[
		Device { id: 0x0027, name: "SC4 (StudioCard)" },
		Device { id: 0x002E, name: "StudioCard 2000" },
	] },
	Vendor { id: 0x12CC, name: "Pluto Technologies International", devices: &[
	] },
	Vendor { id: 0x12CD, name: "Aims Lab", devices: &[
	] },
	Vendor { id: 0x12CE, name: "Netspeed Inc.", devices: &[
	] },
	Vendor { id: 0x12CF, name: "Prophet Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x12D0, name: "GDE Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x12D1, name: "PSITech", devices: &[
	] },
	Vendor { id: 0x12D2, name: "NVidia / SGS Thomson (Joint Venture)", devices: &[
		Device { id: 0x0008, name: "NV1" },
		Device { id: 0x0009, name: "DAC64" },
		Device { id: 0x0018, name: "Riva128" },
		Device { id: 0x0019, name: "Riva128ZX" },
		Device { id: 0x0020, name: "TNT" },
		Device { id: 0x0028, name: "TNT2" },
		Device { id: 0x0029, name: "UTNT2" },
		Device { id: 0x002C, name: "VTNT2" },
		Device { id: 0x00A0, name: "ITNT2" },
	] },
	Vendor { id: 0x12D3, name: "Vingmed Sound A/S", devices: &[
	] },
	Vendor { id: 0x12D4, name: "Ulticom (Formerly DGM&S)", devices: &[
		Device { id: 0x0200, name: "T1 Card" },
	] },
	Vendor { id: 0x12D5, name: "Equator Technologies Inc", devices: &[
		Device { id: 0x0003, name: "BSP16" },
		Device { id: 0x1000, name: "BSP15" },
	] },
	Vendor { id: 0x12D6, name: "Analogic Corp", devices: &[
	] },
	Vendor { id: 0x12D7, name: "Biotronic SRL", devices: &[
	] },
	Vendor { id: 0x12D8, name: "Pericom Semiconductor", devices: &[
		Device { id: 0x01A7, name: "7C21P100 2-port PCI-X to PCI-X Bridge" },
		Device { id: 0x2608, name: "PI7C9X2G608GP PCIe2 6-Port/8-Lane Packet Switch" },
		Device { id: 0x400A, name: "PI7C9X442SL PCI Express Bridge Port" },
		Device { id: 0x400E, name: "PI7C9X442SL USB OHCI Controller" },
		Device { id: 0x400F, name: "PI7C9X442SL USB EHCI Controller" },
		Device { id: 0x71E2, name: "PI7C7300A/PI7C7300D PCI-to-PCI Bridge" },
		Device { id: 0x71E3, name: "PI7C7300A/PI7C7300D PCI-to-PCI Bridge (Secondary Bus 2)" },
		Device { id: 0x8140, name: "PI7C8140A PCI-to-PCI Bridge" },
		Device { id: 0x8148, name: "PI7C8148A/PI7C8148B PCI-to-PCI Bridge" },
		Device { id: 0x8150, name: "PCI to PCI Bridge" },
		Device { id: 0x8152, name: "PI7C8152A/PI7C8152B/PI7C8152BI PCI-to-PCI Bridge" },
		Device { id: 0x8154, name: "PI7C8154A/PI7C8154B/PI7C8154BI PCI-to-PCI Bridge" },
		Device { id: 0xE110, name: "PI7C9X110 PCI Express to PCI bridge" },
		Device { id: 0xE111, name: "PI7C9X111SL PCIe-to-PCI Reversible Bridge" },
		Device { id: 0xE130, name: "PCI Express to PCI-XPI7C9X130 PCI-X Bridge" },
	] },
	Vendor { id: 0x12D9, name: "Aculab PLC", devices: &[
		Device { id: 0x0002, name: "PCI Prosody" },
		Device { id: 0x0004, name: "cPCI Prosody" },
		Device { id: 0x0005, name: "Aculab E1/T1 PCI card" },
		Device { id: 0x1078, name: "Prosody X class e1000 device" },
	] },
	Vendor { id: 0x12DA, name: "True Time Inc.", devices: &[
	] },
	Vendor { id: 0x12DB, name: "Annapolis Micro Systems, Inc", devices: &[
	] },
	Vendor { id: 0x12DC, name: "Symicron Computer Communication Ltd.", devices: &[
	] },
	Vendor { id: 0x12DD, name: "Management Graphics", devices: &[
	] },
	Vendor { id: 0x12DE, name: "Rainbow Technologies", devices: &[
		Device { id: 0x0200, name: "CryptoSwift CS200" },
	] },
	Vendor { id: 0x12DF, name: "SBS Technologies Inc", devices: &[
	] },
	Vendor { id: 0x12E0, name: "Chase Research", devices: &[
		Device { id: 0x0010, name: "ST16C654 Quad UART" },
		Device { id: 0x0020, name: "ST16C654 Quad UART" },
		Device { id: 0x0030, name: "ST16C654 Quad UART" },
	] },
	Vendor { id: 0x12E1, name: "Nintendo Co, Ltd", devices: &[
	] },
	Vendor { id: 0x12E2, name: "Datum Inc. Bancomm-Timing Division", devices: &[
	] },
	Vendor { id: 0x12E3, name: "Imation Corp - Medical Imaging Systems", devices: &[
	] },
	Vendor { id: 0x12E4, name: "Brooktrout Technology Inc", devices: &[
	] },
	Vendor { id: 0x12E5, name: "Apex Semiconductor Inc", devices: &[
	] },
	Vendor { id: 0x12E6, name: "Cirel Systems", devices: &[
	] },
	Vendor { id: 0x12E7, name: "Sunsgroup Corporation", devices: &[
	] },
	Vendor { id: 0x12E8, name: "Crisc Corp", devices: &[
	] },
	Vendor { id: 0x12E9, name: "GE Spacenet", devices: &[
	] },
	Vendor { id: 0x12EA, name: "Zuken", devices: &[
	] },
	Vendor { id: 0x12EB, name: "Aureal Semiconductor", devices: &[
		Device { id: 0x0001, name: "Vortex 1" },
		Device { id: 0x0002, name: "Vortex 2" },
		Device { id: 0x0003, name: "AU8810 Vortex Digital Audio Processor" },
		Device { id: 0x8803, name: "Vortex 56k Software Modem" },
	] },
	Vendor { id: 0x12EC, name: "3A International, Inc.", devices: &[
	] },
	Vendor { id: 0x12ED, name: "Optivision Inc.", devices: &[
	] },
	Vendor { id: 0x12EE, name: "Orange Micro", devices: &[
	] },
	Vendor { id: 0x12EF, name: "Vienna Systems", devices: &[
	] },
	Vendor { id: 0x12F0, name: "Pentek", devices: &[
	] },
	Vendor { id: 0x12F1, name: "Sorenson Vision Inc", devices: &[
	] },
	Vendor { id: 0x12F2, name: "Gammagraphx, Inc.", devices: &[
	] },
	Vendor { id: 0x12F3, name: "Radstone Technology", devices: &[
	] },
	Vendor { id: 0x12F4, name: "Megatel", devices: &[
	] },
	Vendor { id: 0x12F5, name: "Forks", devices: &[
	] },
	Vendor { id: 0x12F6, name: "Dawson France", devices: &[
	] },
	Vendor { id: 0x12F7, name: "Cognex", devices: &[
	] },
	Vendor { id: 0x12F8, name: "Electronic Design GmbH", devices: &[
		Device { id: 0x0002, name: "VideoMaker" },
	] },
	Vendor { id: 0x12F9, name: "Four Fold Ltd", devices: &[
	] },
	Vendor { id: 0x12FB, name: "Spectrum Signal Processing", devices: &[
		Device { id: 0x0001, name: "PMC-MAI" },
		Device { id: 0x00F5, name: "F5 Dakar" },
		Device { id: 0x02AD, name: "PMC-2MAI" },
		Device { id: 0x2ADC, name: "ePMC-2ADC" },
		Device { id: 0x3100, name: "PRO-3100" },
		Device { id: 0x3500, name: "PRO-3500" },
		Device { id: 0x4D4F, name: "Modena" },
		Device { id: 0x8120, name: "ePMC-8120" },
		Device { id: 0xDA62, name: "Daytona C6201 PCI (Hurricane)" },
		Device { id: 0xDB62, name: "Ingliston XBIF" },
		Device { id: 0xDC62, name: "Ingliston PLX9054" },
		Device { id: 0xDD62, name: "Ingliston JTAG/ISP" },
		Device { id: 0xEDDC, name: "ePMC-MSDDC" },
		Device { id: 0xFA01, name: "ePMC-FPGA" },
	] },
	Vendor { id: 0x12FC, name: "Capital Equipment Corp", devices: &[
	] },
	Vendor { id: 0x12FD, name: "I2S", devices: &[
	] },
	Vendor { id: 0x12FE, name: "ESD Electronic System Design GmbH", devices: &[
	] },
	Vendor { id: 0x12FF, name: "Lexicon", devices: &[
	] },
	Vendor { id: 0x1300, name: "Harman International Industries Inc", devices: &[
	] },
	Vendor { id: 0x1302, name: "Computer Sciences Corp", devices: &[
	] },
	Vendor { id: 0x1303, name: "Innovative Integration", devices: &[
		Device { id: 0x0030, name: "X3-SDF 4-channel XMC acquisition board" },
	] },
	Vendor { id: 0x1304, name: "Juniper Networks", devices: &[
	] },
	Vendor { id: 0x1305, name: "Netphone, Inc", devices: &[
	] },
	Vendor { id: 0x1306, name: "Duet Technologies", devices: &[
	] },
	Vendor { id: 0x1307, name: "Measurement Computing", devices: &[
		Device { id: 0x0001, name: "PCI-DAS1602/16" },
		Device { id: 0x000B, name: "PCI-DIO48H" },
		Device { id: 0x000C, name: "PCI-PDISO8" },
		Device { id: 0x000D, name: "PCI-PDISO16" },
		Device { id: 0x000F, name: "PCI-DAS1200" },
		Device { id: 0x0010, name: "PCI-DAS1602/12" },
		Device { id: 0x0014, name: "PCI-DIO24H" },
		Device { id: 0x0015, name: "PCI-DIO24H/CTR3" },
		Device { id: 0x0016, name: "PCI-DIO48H/CTR15" },
		Device { id: 0x0017, name: "PCI-DIO96H" },
		Device { id: 0x0018, name: "PCI-CTR05" },
		Device { id: 0x0019, name: "PCI-DAS1200/JR" },
		Device { id: 0x001A, name: "PCI-DAS1001" },
		Device { id: 0x001B, name: "PCI-DAS1002" },
		Device { id: 0x001C, name: "PCI-DAS1602JR/16" },
		Device { id: 0x001D, name: "PCI-DAS6402/16" },
		Device { id: 0x001E, name: "PCI-DAS6402/12" },
		Device { id: 0x001F, name: "PCI-DAS16/M1" },
		Device { id: 0x0020, name: "PCI-DDA02/12" },
		Device { id: 0x0021, name: "PCI-DDA04/12" },
		Device { id: 0x0022, name: "PCI-DDA08/12" },
		Device { id: 0x0023, name: "PCI-DDA02/16" },
		Device { id: 0x0024, name: "PCI-DDA04/16" },
		Device { id: 0x0025, name: "PCI-DDA08/16" },
		Device { id: 0x0026, name: "PCI-DAC04/12-HS" },
		Device { id: 0x0027, name: "PCI-DAC04/16-HS" },
		Device { id: 0x0028, name: "PCI-DIO24" },
		Device { id: 0x0029, name: "PCI-DAS08" },
		Device { id: 0x002C, name: "PCI-INT32" },
		Device { id: 0x0033, name: "PCI-DUAL-AC5" },
		Device { id: 0x0034, name: "PCI-DAS-TC" },
		Device { id: 0x0035, name: "PCI-DAS64/M1/16" },
		Device { id: 0x0036, name: "PCI-DAS64/M2/16" },
		Device { id: 0x0037, name: "PCI-DAS64/M3/16" },
		Device { id: 0x004C, name: "PCI-DAS1000" },
		Device { id: 0x004D, name: "PCI-QUAD04" },
		Device { id: 0x0052, name: "PCI-DAS4020/12" },
		Device { id: 0x0053, name: "PCIM-DDA06/16" },
		Device { id: 0x0054, name: "PCI-DIO96" },
		Device { id: 0x005D, name: "PCI-DAS6023" },
		Device { id: 0x005E, name: "PCI-DAS6025" },
		Device { id: 0x005F, name: "PCI-DAS6030" },
		Device { id: 0x0060, name: "PCI-DAS6031" },
		Device { id: 0x0061, name: "PCI-DAS6032" },
		Device { id: 0x0062, name: "PCI-DAS6033" },
		Device { id: 0x0063, name: "PCI-DAS6034" },
		Device { id: 0x0064, name: "PCI-DAS6035" },
		Device { id: 0x0065, name: "PCI-DAS6040" },
		Device { id: 0x0066, name: "PCI-DAS6052" },
		Device { id: 0x0067, name: "PCI-DAS6070" },
		Device { id: 0x0068, name: "PCI-DAS6071" },
		Device { id: 0x006F, name: "PCI-DAS6036" },
		Device { id: 0x0070, name: "PCI-DAC6702" },
		Device { id: 0x0078, name: "PCI-DAS6013" },
		Device { id: 0x0079, name: "PCI-DAS6014" },
		Device { id: 0x0115, name: "PCIe-DAS1602/16" },
	] },
	Vendor { id: 0x1308, name: "Jato Technologies Inc.", devices: &[
		Device { id: 0x0001, name: "NetCelerator Adapter" },
	] },
	Vendor { id: 0x1309, name: "AB Semiconductor Ltd", devices: &[
	] },
	Vendor { id: 0x130A, name: "Mitsubishi Electric Microcomputer", devices: &[
	] },
	Vendor { id: 0x130B, name: "Colorgraphic Communications Corp", devices: &[
	] },
	Vendor { id: 0x130C, name: "Ambex Technologies, Inc", devices: &[
	] },
	Vendor { id: 0x130D, name: "Accelerix Inc", devices: &[
	] },
	Vendor { id: 0x130E, name: "Yamatake-Honeywell Co. Ltd", devices: &[
	] },
	Vendor { id: 0x130F, name: "Advanet Inc", devices: &[
	] },
	Vendor { id: 0x1310, name: "Gespac", devices: &[
	] },
	Vendor { id: 0x1311, name: "Videoserver, Inc", devices: &[
	] },
	Vendor { id: 0x1312, name: "Acuity Imaging, Inc", devices: &[
	] },
	Vendor { id: 0x1313, name: "Yaskawa Electric Co.", devices: &[
	] },
	Vendor { id: 0x1315, name: "Wavesat", devices: &[
	] },
	Vendor { id: 0x1316, name: "Teradyne Inc", devices: &[
	] },
	Vendor { id: 0x1317, name: "ADMtek", devices: &[
		Device { id: 0x0981, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
		Device { id: 0x0985, name: "NC100 Network Everywhere Fast Ethernet 10/100" },
		Device { id: 0x1985, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
		Device { id: 0x2850, name: "HSP MicroModem 56" },
		Device { id: 0x5120, name: "ADM5120 OpenGate System-on-Chip" },
		Device { id: 0x8201, name: "ADM8211 802.11b Wireless Interface" },
		Device { id: 0x8211, name: "ADM8211 802.11b Wireless Interface" },
		Device { id: 0x9511, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
	] },
	Vendor { id: 0x1318, name: "Packet Engines Inc.", devices: &[
		Device { id: 0x0911, name: "GNIC-II PCI Gigabit Ethernet [Hamachi]" },
	] },
	Vendor { id: 0x1319, name: "Fortemedia, Inc", devices: &[
		Device { id: 0x0801, name: "Xwave QS3000A [FM801]" },
		Device { id: 0x0802, name: "Xwave QS3000A [FM801 game port]" },
		Device { id: 0x1000, name: "FM801 PCI Audio" },
		Device { id: 0x1001, name: "FM801 PCI Joystick" },
	] },
	Vendor { id: 0x131A, name: "Finisar Corp.", devices: &[
	] },
	Vendor { id: 0x131C, name: "Nippon Electro-Sensory Devices Corp", devices: &[
	] },
	Vendor { id: 0x131D, name: "Sysmic, Inc.", devices: &[
	] },
	Vendor { id: 0x131E, name: "Xinex Networks Inc", devices: &[
	] },
	Vendor { id: 0x131F, name: "Siig Inc", devices: &[
		Device { id: 0x1000, name: "CyberSerial (1-port) 16550" },
		Device { id: 0x1001, name: "CyberSerial (1-port) 16650" },
		Device { id: 0x1002, name: "CyberSerial (1-port) 16850" },
		Device { id: 0x1010, name: "Duet 1S(16550)+1P" },
		Device { id: 0x1011, name: "Duet 1S(16650)+1P" },
		Device { id: 0x1012, name: "Duet 1S(16850)+1P" },
		Device { id: 0x1020, name: "CyberParallel (1-port)" },
		Device { id: 0x1021, name: "CyberParallel (2-port)" },
		Device { id: 0x1030, name: "CyberSerial (2-port) 16550" },
		Device { id: 0x1031, name: "CyberSerial (2-port) 16650" },
		Device { id: 0x1032, name: "CyberSerial (2-port) 16850" },
		Device { id: 0x1034, name: "Trio 2S(16550)+1P" },
		Device { id: 0x1035, name: "Trio 2S(16650)+1P" },
		Device { id: 0x1036, name: "Trio 2S(16850)+1P" },
		Device { id: 0x1050, name: "CyberSerial (4-port) 16550" },
		Device { id: 0x1051, name: "CyberSerial (4-port) 16650" },
		Device { id: 0x1052, name: "CyberSerial (4-port) 16850" },
		Device { id: 0x2000, name: "CyberSerial (1-port) 16550" },
		Device { id: 0x2001, name: "CyberSerial (1-port) 16650" },
		Device { id: 0x2002, name: "CyberSerial (1-port) 16850" },
		Device { id: 0x2010, name: "Duet 1S(16550)+1P" },
		Device { id: 0x2011, name: "Duet 1S(16650)+1P" },
		Device { id: 0x2012, name: "Duet 1S(16850)+1P" },
		Device { id: 0x2020, name: "CyberParallel (1-port)" },
		Device { id: 0x2021, name: "CyberParallel (2-port)" },
		Device { id: 0x2030, name: "CyberSerial (2-port) 16550" },
		Device { id: 0x2031, name: "CyberSerial (2-port) 16650" },
		Device { id: 0x2032, name: "CyberSerial (2-port) 16850" },
		Device { id: 0x2040, name: "Trio 1S(16550)+2P" },
		Device { id: 0x2041, name: "Trio 1S(16650)+2P" },
		Device { id: 0x2042, name: "Trio 1S(16850)+2P" },
		Device { id: 0x2050, name: "CyberSerial (4-port) 16550" },
		Device { id: 0x2051, name: "CyberSerial (4-port) 16650" },
		Device { id: 0x2052, name: "CyberSerial (4-port) 16850" },
		Device { id: 0x2060, name: "Trio 2S(16550)+1P" },
		Device { id: 0x2061, name: "Trio 2S(16650)+1P" },
		Device { id: 0x2062, name: "Trio 2S(16850)+1P" },
		Device { id: 0x2081, name: "CyberSerial (8-port) ST16654" },
	] },
	Vendor { id: 0x1320, name: "Crypto AG", devices: &[
	] },
	Vendor { id: 0x1321, name: "Arcobel Graphics BV", devices: &[
	] },
	Vendor { id: 0x1322, name: "MTT Co., Ltd", devices: &[
	] },
	Vendor { id: 0x1323, name: "Dome Inc", devices: &[
	] },
	Vendor { id: 0x1324, name: "Sphere Communications", devices: &[
	] },
	Vendor { id: 0x1325, name: "Salix Technologies, Inc", devices: &[
	] },
	Vendor { id: 0x1326, name: "Seachange international", devices: &[
	] },
	Vendor { id: 0x1327, name: "Voss scientific", devices: &[
	] },
	Vendor { id: 0x1328, name: "quadrant international", devices: &[
	] },
	Vendor { id: 0x1329, name: "Productivity Enhancement", devices: &[
	] },
	Vendor { id: 0x132A, name: "Microcom Inc.", devices: &[
	] },
	Vendor { id: 0x132B, name: "Broadband Technologies", devices: &[
	] },
	Vendor { id: 0x132C, name: "Micrel Inc", devices: &[
	] },
	Vendor { id: 0x132D, name: "Integrated Silicon Solution, Inc.", devices: &[
	] },
	Vendor { id: 0x1330, name: "MMC Networks", devices: &[
	] },
	Vendor { id: 0x1331, name: "RadiSys Corporation", devices: &[
		Device { id: 0x0030, name: "ENP-2611" },
		Device { id: 0x8200, name: "82600 Host Bridge" },
		Device { id: 0x8201, name: "82600 IDE" },
		Device { id: 0x8202, name: "82600 USB" },
		Device { id: 0x8210, name: "82600 PCI Bridge" },
	] },
	Vendor { id: 0x1332, name: "Micro Memory", devices: &[
		Device { id: 0x5415, name: "MM-5415CN PCI Memory Module with Battery Backup" },
		Device { id: 0x5425, name: "MM-5425CN PCI 64/66 Memory Module with Battery Backup" },
		Device { id: 0x6140, name: "MM-6140D" },
	] },
	Vendor { id: 0x1334, name: "Redcreek Communications, Inc", devices: &[
	] },
	Vendor { id: 0x1335, name: "Videomail, Inc", devices: &[
	] },
	Vendor { id: 0x1337, name: "Third Planet Publishing", devices: &[
	] },
	Vendor { id: 0x1338, name: "BT Electronics", devices: &[
	] },
	Vendor { id: 0x133A, name: "Vtel Corp", devices: &[
	] },
	Vendor { id: 0x133B, name: "Softcom Microsystems", devices: &[
	] },
	Vendor { id: 0x133C, name: "Holontech Corp", devices: &[
	] },
	Vendor { id: 0x133D, name: "SS Technologies", devices: &[
	] },
	Vendor { id: 0x133E, name: "Virtual Computer Corp", devices: &[
	] },
	Vendor { id: 0x133F, name: "SCM Microsystems", devices: &[
	] },
	Vendor { id: 0x1340, name: "Atalla Corp", devices: &[
	] },
	Vendor { id: 0x1341, name: "Kyoto Microcomputer Co", devices: &[
	] },
	Vendor { id: 0x1342, name: "Promax Systems Inc", devices: &[
	] },
	Vendor { id: 0x1343, name: "Phylon Communications Inc", devices: &[
	] },
	Vendor { id: 0x1344, name: "Micron Technology Inc", devices: &[
		Device { id: 0x5150, name: "RealSSD P320h" },
		Device { id: 0x5151, name: "RealSSD P320m" },
		Device { id: 0x5152, name: "RealSSD P320s" },
		Device { id: 0x5153, name: "RealSSD P325m" },
		Device { id: 0x5160, name: "RealSSD P420h" },
		Device { id: 0x5161, name: "RealSSD P420m" },
		Device { id: 0x5163, name: "RealSSD P425m" },
		Device { id: 0x5180, name: "9100 PRO NVMe SSD" },
		Device { id: 0x5181, name: "9100 MAX NVMe SSD" },
	] },
	Vendor { id: 0x1345, name: "Arescom Inc", devices: &[
	] },
	Vendor { id: 0x1347, name: "Odetics", devices: &[
	] },
	Vendor { id: 0x1349, name: "Sumitomo Electric Industries, Ltd.", devices: &[
	] },
	Vendor { id: 0x134A, name: "DTC Technology Corp.", devices: &[
		Device { id: 0x0001, name: "Domex 536" },
		Device { id: 0x0002, name: "Domex DMX3194UP SCSI Adapter" },
	] },
	Vendor { id: 0x134B, name: "ARK Research Corp.", devices: &[
	] },
	Vendor { id: 0x134C, name: "Chori Joho System Co. Ltd", devices: &[
	] },
	Vendor { id: 0x134D, name: "PCTel Inc", devices: &[
		Device { id: 0x2189, name: "HSP56 MicroModem" },
		Device { id: 0x2486, name: "2304WT V.92 MDC Modem" },
		Device { id: 0x7890, name: "HSP MicroModem 56" },
		Device { id: 0x7891, name: "HSP MicroModem 56" },
		Device { id: 0x7892, name: "HSP MicroModem 56" },
		Device { id: 0x7893, name: "HSP MicroModem 56" },
		Device { id: 0x7894, name: "HSP MicroModem 56" },
		Device { id: 0x7895, name: "HSP MicroModem 56" },
		Device { id: 0x7896, name: "HSP MicroModem 56" },
		Device { id: 0x7897, name: "HSP MicroModem 56" },
	] },
	Vendor { id: 0x134E, name: "CSTI", devices: &[
	] },
	Vendor { id: 0x134F, name: "Algo System Co Ltd", devices: &[
	] },
	Vendor { id: 0x1350, name: "Systec Co. Ltd", devices: &[
	] },
	Vendor { id: 0x1351, name: "Sonix Inc", devices: &[
	] },
	Vendor { id: 0x1353, name: "Vierling Communication SAS", devices: &[
		Device { id: 0x0002, name: "Proserver" },
		Device { id: 0x0003, name: "PCI-FUT" },
		Device { id: 0x0004, name: "PCI-S0" },
		Device { id: 0x0005, name: "PCI-FUT-S0" },
	] },
	Vendor { id: 0x1354, name: "Dwave System Inc", devices: &[
	] },
	Vendor { id: 0x1355, name: "Kratos Analytical Ltd", devices: &[
	] },
	Vendor { id: 0x1356, name: "The Logical Co", devices: &[
	] },
	Vendor { id: 0x1359, name: "Prisa Networks", devices: &[
	] },
	Vendor { id: 0x135A, name: "Brain Boxes", devices: &[
		Device { id: 0x0A61, name: "UC-324 [VELOCITY RS422/485]" },
	] },
	Vendor { id: 0x135B, name: "Giganet Inc", devices: &[
	] },
	Vendor { id: 0x135C, name: "Quatech Inc", devices: &[
		Device { id: 0x0010, name: "QSC-100" },
		Device { id: 0x0020, name: "DSC-100" },
		Device { id: 0x0030, name: "DSC-200/300" },
		Device { id: 0x0040, name: "QSC-200/300" },
		Device { id: 0x0050, name: "ESC-100D" },
		Device { id: 0x0060, name: "ESC-100M" },
		Device { id: 0x00F0, name: "MPAC-100 Synchronous Serial Card (Zilog 85230)" },
		Device { id: 0x0170, name: "QSCLP-100" },
		Device { id: 0x0180, name: "DSCLP-100" },
		Device { id: 0x0190, name: "SSCLP-100" },
		Device { id: 0x01A0, name: "QSCLP-200/300" },
		Device { id: 0x01B0, name: "DSCLP-200/300" },
		Device { id: 0x01C0, name: "SSCLP-200/300" },
		Device { id: 0x0258, name: "DSPSX-200/300" },
	] },
	Vendor { id: 0x135D, name: "ABB Network Partner AB", devices: &[
	] },
	Vendor { id: 0x135E, name: "Sealevel Systems Inc", devices: &[
		Device { id: 0x5101, name: "Route 56.PCI - Multi-Protocol Serial Interface (Zilog Z16C32)" },
		Device { id: 0x7101, name: "Single Port RS-232/422/485/530" },
		Device { id: 0x7201, name: "Dual Port RS-232/422/485 Interface" },
		Device { id: 0x7202, name: "Dual Port RS-232 Interface" },
		Device { id: 0x7401, name: "Four Port RS-232 Interface" },
		Device { id: 0x7402, name: "Four Port RS-422/485 Interface" },
		Device { id: 0x7801, name: "Eight Port RS-232 Interface" },
		Device { id: 0x7804, name: "Eight Port RS-232/422/485 Interface" },
		Device { id: 0x8001, name: "8001 Digital I/O Adapter" },
	] },
	Vendor { id: 0x135F, name: "I-Data International A-S", devices: &[
	] },
	Vendor { id: 0x1360, name: "Meinberg Funkuhren", devices: &[
		Device { id: 0x0101, name: "PCI32 DCF77 Radio Clock" },
		Device { id: 0x0102, name: "PCI509 DCF77 Radio Clock" },
		Device { id: 0x0103, name: "PCI510 DCF77 Radio Clock" },
		Device { id: 0x0104, name: "PCI511 DCF77 Radio Clock" },
		Device { id: 0x0105, name: "PEX511 DCF77 Radio Clock (PCI Express)" },
		Device { id: 0x0106, name: "PZF180PEX High Precision DCF77 Radio Clock (PCI Express)" },
		Device { id: 0x0201, name: "GPS167PCI GPS Receiver" },
		Device { id: 0x0202, name: "GPS168PCI GPS Receiver" },
		Device { id: 0x0203, name: "GPS169PCI GPS Receiver" },
		Device { id: 0x0204, name: "GPS170PCI GPS Receiver" },
		Device { id: 0x0205, name: "GPS170PEX GPS Receiver (PCI Express)" },
		Device { id: 0x0206, name: "GPS180PEX GPS Receiver (PCI Express)" },
		Device { id: 0x0207, name: "GLN180PEX GPS/GLONASS receiver (PCI Express)" },
		Device { id: 0x0208, name: "GPS180AMC GPS Receiver (PCI Express / MicroTCA / AdvancedMC)" },
		Device { id: 0x0209, name: "GNS181PEX GPS/Galileo/GLONASS/BEIDOU receiver (PCI Express)" },
		Device { id: 0x0301, name: "TCR510PCI IRIG Timecode Reader" },
		Device { id: 0x0302, name: "TCR167PCI IRIG Timecode Reader" },
		Device { id: 0x0303, name: "TCR511PCI IRIG Timecode Reader" },
		Device { id: 0x0304, name: "TCR511PEX IRIG Timecode Reader (PCI Express)" },
		Device { id: 0x0305, name: "TCR170PEX IRIG Timecode Reader (PCI Express)" },
		Device { id: 0x0306, name: "TCR180PEX IRIG Timecode Reader (PCI Express)" },
		Device { id: 0x0501, name: "PTP270PEX PTP/IEEE1588 slave card (PCI Express)" },
		Device { id: 0x0601, name: "FRC511PEX Free Running Clock (PCI Express)" },
	] },
	Vendor { id: 0x1361, name: "Soliton Systems K.K.", devices: &[
	] },
	Vendor { id: 0x1362, name: "Fujifacom Corporation", devices: &[
	] },
	Vendor { id: 0x1363, name: "Phoenix Technology Ltd", devices: &[
	] },
	Vendor { id: 0x1364, name: "ATM Communications Inc", devices: &[
	] },
	Vendor { id: 0x1365, name: "Hypercope GmbH", devices: &[
	] },
	Vendor { id: 0x1366, name: "Teijin Seiki Co. Ltd", devices: &[
	] },
	Vendor { id: 0x1367, name: "Hitachi Zosen Corporation", devices: &[
	] },
	Vendor { id: 0x1368, name: "Skyware Corporation", devices: &[
	] },
	Vendor { id: 0x1369, name: "Digigram", devices: &[
	] },
	Vendor { id: 0x136A, name: "High Soft Tech", devices: &[
		Device { id: 0x0004, name: "HST Saphir VII mini PCI" },
		Device { id: 0x0007, name: "HST Saphir III E MultiLink 4" },
		Device { id: 0x0008, name: "HST Saphir III E MultiLink 8" },
		Device { id: 0x000A, name: "HST Saphir III E MultiLink 2" },
	] },
	Vendor { id: 0x136B, name: "Kawasaki Steel Corporation", devices: &[
		Device { id: 0xFF01, name: "KL5A72002 Motion JPEG" },
	] },
	Vendor { id: 0x136C, name: "Adtek System Science Co Ltd", devices: &[
	] },
	Vendor { id: 0x136D, name: "Gigalabs Inc", devices: &[
	] },
	Vendor { id: 0x136F, name: "Applied Magic Inc", devices: &[
	] },
	Vendor { id: 0x1370, name: "ATL Products", devices: &[
	] },
	Vendor { id: 0x1371, name: "CNet Technology Inc", devices: &[
		Device { id: 0x434E, name: "GigaCard Network Adapter" },
	] },
	Vendor { id: 0x1373, name: "Silicon Vision Inc", devices: &[
	] },
	Vendor { id: 0x1374, name: "Silicom Ltd.", devices: &[
		Device { id: 0x0024, name: "Silicom Dual port Giga Ethernet BGE Bypass Server Adapter" },
		Device { id: 0x0025, name: "Silicom Quad port Giga Ethernet BGE Bypass Server Adapter" },
		Device { id: 0x0026, name: "Silicom Dual port Fiber Giga Ethernet 546 Bypass Server Adapter" },
		Device { id: 0x0027, name: "Silicom Dual port Fiber LX Giga Ethernet 546 Bypass Server Adapter" },
		Device { id: 0x0029, name: "Silicom Dual port Copper Giga Ethernet 546GB Bypass Server Adapter" },
		Device { id: 0x002A, name: "Silicom Dual port Fiber Giga Ethernet 546 TAP/Bypass Server Adapter" },
		Device { id: 0x002B, name: "Silicom Dual port Copper Fast Ethernet 546 TAP/Bypass Server Adapter (PXE2TBI)" },
		Device { id: 0x002C, name: "Silicom Quad port Copper Giga Ethernet 546GB Bypass Server Adapter (PXG4BPI)" },
		Device { id: 0x002D, name: "Silicom Quad port Fiber-SX Giga Ethernet 546GB Bypass Server Adapter (PXG4BPFI)" },
		Device { id: 0x002E, name: "Silicom Quad port Fiber-LX Giga Ethernet 546GB Bypass Server Adapter (PXG4BPFI-LX)" },
		Device { id: 0x002F, name: "Silicom Dual port Fiber-SX Giga Ethernet 546GB Low profile Bypass Server Adapter (PXG2BPFIL)" },
		Device { id: 0x0030, name: "Silicom Dual port Fiber-LX Giga Ethernet 546GB Low profile Bypass Server Adapter" },
		Device { id: 0x0031, name: "Silicom Quad port Copper Giga Ethernet PCI-E Bypass Server Adapter" },
		Device { id: 0x0032, name: "Silicom Dual port Copper Fast Ethernet 546 TAP/Bypass Server Adapter" },
		Device { id: 0x0034, name: "Silicom Dual port Copper Giga Ethernet PCI-E BGE Bypass Server Adapter" },
		Device { id: 0x0035, name: "Silicom Quad port Copper Giga Ethernet PCI-E BGE Bypass Server Adapter" },
		Device { id: 0x0036, name: "Silicom Dual port Fiber Giga Ethernet PCI-E BGE Bypass Server Adapter" },
		Device { id: 0x0037, name: "Silicom Dual port Copper Ethernet PCI-E Intel based Bypass Server Adapter" },
		Device { id: 0x0038, name: "Silicom Quad port Copper Ethernet PCI-E Intel based Bypass Server Adapter" },
		Device { id: 0x0039, name: "Silicom Dual port Fiber-SX Ethernet PCI-E Intel based Bypass Server Adapter" },
		Device { id: 0x003A, name: "Silicom Dual port Fiber-LX Ethernet PCI-E Intel based Bypass Server Adapter" },
		Device { id: 0x003B, name: "Silicom Dual port Fiber Ethernet PMC Intel based Bypass Server Adapter (PMCX2BPFI)" },
		Device { id: 0x003C, name: "Silicom Dual port Copper Ethernet PCI-X BGE based Bypass Server Adapter (PXG2BPRB)" },
		Device { id: 0x003D, name: "2-port Copper GBE Bypass with Caviume 1010 PCI-X" },
		Device { id: 0x003E, name: "Silicom Dual port Fiber Giga Ethernet PCI-E 571 TAP/Bypass Server Adapter (PEG2TBFI)" },
		Device { id: 0x003F, name: "Silicom Dual port Copper Giga Ethernet PCI-X 546 TAP/Bypass Server Adapter (PXG2TBI)" },
		Device { id: 0x0040, name: "Silicom Quad port Fiber-SX Giga Ethernet 571 Bypass Server Adapter (PEG4BPFI)" },
		Device { id: 0x0042, name: "4-port Copper GBE PMC-X Bypass" },
		Device { id: 0x0043, name: "Silicom Quad port Fiber-SX Giga Ethernet 546 Bypass Server Adapter (PXG4BPFID)" },
		Device { id: 0x0045, name: "Silicom 6 port Copper Giga Ethernet 546 Bypass Server Adapter (PXG6BPI)" },
		Device { id: 0x0046, name: "4-port bypass PCI-E w disconnect low profile" },
		Device { id: 0x0047, name: "Silicom Dual port Fiber-SX Giga Ethernet 571 Bypass Disconnect Server Adapter (PEG2BPFID)" },
		Device { id: 0x004A, name: "Silicom Quad port Fiber-LX Giga Ethernet 571 Bypass Server Adapter (PEG4BPFI-LX)" },
		Device { id: 0x004D, name: "Dual port Copper Giga Ethernet PCI-E Bypass Server Adapter" },
		Device { id: 0x0401, name: "Gigabit Ethernet ExpressModule Bypass Server Adapter" },
		Device { id: 0x0420, name: "Gigabit Ethernet ExpressModule Bypass Server Adapter" },
		Device { id: 0x0460, name: "Gigabit Ethernet Express Module Bypass Server Adapter" },
		Device { id: 0x0461, name: "Gigabit Ethernet ExpressModule Bypass Server Adapter" },
		Device { id: 0x0462, name: "Gigabit Ethernet ExpressModule Bypass Server Adapter" },
		Device { id: 0x0470, name: "Octal-port Copper Gigabit Ethernet Express Module Bypass Server Adapter" },
		Device { id: 0x0482, name: "Dual-port Fiber (SR) 10 Gigabit Ethernet ExpressModule Bypass Server Adapter" },
		Device { id: 0x0483, name: "Dual-port Fiber (LR) 10 Gigabit Ethernet ExpressModule Bypass Server Adapter" },
	] },
	Vendor { id: 0x1375, name: "Argosystems Inc", devices: &[
	] },
	Vendor { id: 0x1376, name: "LMC", devices: &[
	] },
	Vendor { id: 0x1377, name: "Electronic Equipment Production & Distribution GmbH", devices: &[
	] },
	Vendor { id: 0x1378, name: "Telemann Co. Ltd", devices: &[
	] },
	Vendor { id: 0x1379, name: "Asahi Kasei Microsystems Co Ltd", devices: &[
	] },
	Vendor { id: 0x137A, name: "Mark of the Unicorn Inc", devices: &[
		Device { id: 0x0001, name: "PCI-324 Audiowire Interface" },
	] },
	Vendor { id: 0x137B, name: "PPT Vision", devices: &[
	] },
	Vendor { id: 0x137C, name: "Iwatsu Electric Co Ltd", devices: &[
	] },
	Vendor { id: 0x137D, name: "Dynachip Corporation", devices: &[
	] },
	Vendor { id: 0x137E, name: "Patriot Scientific Corporation", devices: &[
	] },
	Vendor { id: 0x137F, name: "Japan Satellite Systems Inc", devices: &[
	] },
	Vendor { id: 0x1380, name: "Sanritz Automation Co Ltd", devices: &[
	] },
	Vendor { id: 0x1381, name: "Brains Co. Ltd", devices: &[
	] },
	Vendor { id: 0x1382, name: "Marian - Electronic & Software", devices: &[
		Device { id: 0x0001, name: "ARC88 audio recording card" },
		Device { id: 0x2008, name: "Prodif 96 Pro sound system" },
		Device { id: 0x2048, name: "Prodif Plus sound system" },
		Device { id: 0x2088, name: "Marc 8 Midi sound system" },
		Device { id: 0x20C8, name: "Marc A sound system" },
		Device { id: 0x4008, name: "Marc 2 sound system" },
		Device { id: 0x4010, name: "Marc 2 Pro sound system" },
		Device { id: 0x4048, name: "Marc 4 MIDI sound system" },
		Device { id: 0x4088, name: "Marc 4 Digi sound system" },
		Device { id: 0x4248, name: "Marc X sound system" },
		Device { id: 0x4424, name: "TRACE D4 Sound System" },
	] },
	Vendor { id: 0x1383, name: "Controlnet Inc", devices: &[
	] },
	Vendor { id: 0x1384, name: "Reality Simulation Systems Inc", devices: &[
	] },
	Vendor { id: 0x1385, name: "Netgear", devices: &[
		Device { id: 0x006B, name: "WA301 802.11b Wireless PCI Adapter" },
		Device { id: 0x4100, name: "MA301 802.11b Wireless PCI Adapter" },
		Device { id: 0x4601, name: "WAG511 802.11a/b/g Dual Band Wireless PC Card" },
		Device { id: 0x620A, name: "GA620 Gigabit Ethernet" },
		Device { id: 0x630A, name: "GA630 Gigabit Ethernet" },
	] },
	Vendor { id: 0x1386, name: "Video Domain Technologies", devices: &[
	] },
	Vendor { id: 0x1387, name: "Systran Corp", devices: &[
	] },
	Vendor { id: 0x1388, name: "Hitachi Information Technology Co Ltd", devices: &[
	] },
	Vendor { id: 0x1389, name: "Applicom International", devices: &[
		Device { id: 0x0001, name: "PCI1500PFB [Intelligent fieldbus adaptor]" },
	] },
	Vendor { id: 0x138A, name: "Fusion Micromedia Corp", devices: &[
		Device { id: 0x003D, name: "VFS491 Validity Sensor" },
	] },
	Vendor { id: 0x138B, name: "Tokimec Inc", devices: &[
	] },
	Vendor { id: 0x138C, name: "Silicon Reality", devices: &[
	] },
	Vendor { id: 0x138D, name: "Future Techno Designs pte Ltd", devices: &[
	] },
	Vendor { id: 0x138E, name: "Basler GmbH", devices: &[
	] },
	Vendor { id: 0x138F, name: "Patapsco Designs Inc", devices: &[
	] },
	Vendor { id: 0x1390, name: "Concept Development Inc", devices: &[
	] },
	Vendor { id: 0x1391, name: "Development Concepts Inc", devices: &[
	] },
	Vendor { id: 0x1392, name: "Medialight Inc", devices: &[
	] },
	Vendor { id: 0x1393, name: "Moxa Technologies Co Ltd", devices: &[
		Device { id: 0x0001, name: "UC7000 Serial" },
		Device { id: 0x1020, name: "CP-102 (2-port RS-232 PCI)" },
		Device { id: 0x1021, name: "CP-102UL (2-port RS-232 Universal PCI)" },
		Device { id: 0x1022, name: "CP-102U (2-port RS-232 Universal PCI)" },
		Device { id: 0x1023, name: "CP-102UF" },
		Device { id: 0x1024, name: "CP-102E (2-port RS-232 Smart PCI Express Serial Board)" },
		Device { id: 0x1025, name: "CP-102EL (2-port RS-232 Smart PCI Express Serial Board)" },
		Device { id: 0x1040, name: "Smartio C104H/PCI" },
		Device { id: 0x1041, name: "CP104U (4-port RS-232 Universal PCI)" },
		Device { id: 0x1042, name: "CP104JU (4-port RS-232 Universal PCI)" },
		Device { id: 0x1043, name: "CP104EL (4-port RS-232 Smart PCI Express)" },
		Device { id: 0x1044, name: "POS104UL (4-port RS-232 Universal PCI)" },
		Device { id: 0x1045, name: "CP-104EL-A (4-port RS-232 PCI Express Serial Board)" },
		Device { id: 0x1080, name: "CB108 (8-port RS-232 PC/104-plus Module)" },
		Device { id: 0x1140, name: "CT-114 series" },
		Device { id: 0x1141, name: "Industrio CP-114" },
		Device { id: 0x1142, name: "CB114 (4-port RS-232/422/485 PC/104-plus Module)" },
		Device { id: 0x1143, name: "CP-114UL (4-port RS-232/422/485 Smart Universal PCI Serial Board)" },
		Device { id: 0x1144, name: "CP-114EL (4-port RS-232/422/485 Smart PCI Express Serial Board)" },
		Device { id: 0x1180, name: "CP118U (8-port RS-232/422/485 Smart Universal PCI)" },
		Device { id: 0x1181, name: "CP118EL (8-port RS-232/422/485 Smart PCI Express)" },
		Device { id: 0x1182, name: "CP-118EL-A (8-port RS-232/422/485 PCI Express Serial Board)" },
		Device { id: 0x1320, name: "CP132 (2-port RS-422/485 PCI)" },
		Device { id: 0x1321, name: "CP132U (2-Port RS-422/485 Universal PCI)" },
		Device { id: 0x1322, name: "CP-132EL (2-port RS-422/485 Smart PCI Express Serial Board)" },
		Device { id: 0x1340, name: "CP134U (4-Port RS-422/485 Universal PCI)" },
		Device { id: 0x1341, name: "CB134I (4-port RS-422/485 PC/104-plus Module)" },
		Device { id: 0x1380, name: "CP138U (8-port RS-232/422/485 Smart Universal PCI)" },
		Device { id: 0x1680, name: "Smartio C168H/PCI" },
		Device { id: 0x1681, name: "CP-168U V2 Smart Serial Board (8-port RS-232)" },
		Device { id: 0x1682, name: "CP-168EL (8-port RS-232 Smart PCI Express)" },
		Device { id: 0x1683, name: "CP-168EL-A (8-port RS-232 PCI Express Serial Board)" },
		Device { id: 0x2040, name: "Intellio CP-204J" },
		Device { id: 0x2180, name: "Intellio C218 Turbo PCI" },
		Device { id: 0x3200, name: "Intellio C320 Turbo PCI" },
	] },
	Vendor { id: 0x1394, name: "Level One Communications", devices: &[
		Device { id: 0x0001, name: "LXT1001 Gigabit Ethernet" },
	] },
	Vendor { id: 0x1395, name: "Ambicom Inc", devices: &[
	] },
	Vendor { id: 0x1396, name: "Cipher Systems Inc", devices: &[
	] },
	Vendor { id: 0x1397, name: "Cologne Chip Designs GmbH", devices: &[
		Device { id: 0x08B4, name: "ISDN network Controller [HFC-4S]" },
		Device { id: 0x16B8, name: "ISDN network Controller [HFC-8S]" },
		Device { id: 0x2BD0, name: "ISDN network controller [HFC-PCI]" },
		Device { id: 0x30B1, name: "ISDN network Controller [HFC-E1]" },
		Device { id: 0xB700, name: "ISDN network controller PrimuX S0 [HFC-PCI]" },
		Device { id: 0xF001, name: "GSM Network Controller [HFC-4GSM]" },
	] },
	Vendor { id: 0x1398, name: "Clarion co. Ltd", devices: &[
	] },
	Vendor { id: 0x1399, name: "Rios systems Co Ltd", devices: &[
	] },
	Vendor { id: 0x139A, name: "Alacritech Inc", devices: &[
		Device { id: 0x0001, name: "Quad Port 10/100 Server Accelerator" },
		Device { id: 0x0003, name: "Single Port 10/100 Server Accelerator" },
		Device { id: 0x0005, name: "Single Port Gigabit Server Accelerator" },
	] },
	Vendor { id: 0x139B, name: "Mediasonic Multimedia Systems Ltd", devices: &[
	] },
	Vendor { id: 0x139C, name: "Quantum 3d Inc", devices: &[
	] },
	Vendor { id: 0x139D, name: "EPL limited", devices: &[
	] },
	Vendor { id: 0x139E, name: "Media4", devices: &[
	] },
	Vendor { id: 0x139F, name: "Aethra s.r.l.", devices: &[
	] },
	Vendor { id: 0x13A0, name: "Crystal Group Inc", devices: &[
	] },
	Vendor { id: 0x13A1, name: "Kawasaki Heavy Industries Ltd", devices: &[
	] },
	Vendor { id: 0x13A2, name: "Ositech Communications Inc", devices: &[
	] },
	Vendor { id: 0x13A3, name: "Hifn Inc.", devices: &[
		Device { id: 0x0005, name: "7751 Security Processor" },
		Device { id: 0x0006, name: "6500 Public Key Processor" },
		Device { id: 0x0007, name: "7811 Security Processor" },
		Device { id: 0x0012, name: "7951 Security Processor" },
		Device { id: 0x0014, name: "78XX Security Processor" },
		Device { id: 0x0016, name: "8065 Security Processor" },
		Device { id: 0x0017, name: "8165 Security Processor" },
		Device { id: 0x0018, name: "8154 Security Processor" },
		Device { id: 0x001D, name: "7956 Security Processor" },
		Device { id: 0x001F, name: "7855 Security Processor" },
		Device { id: 0x0020, name: "7955 Security Processor" },
		Device { id: 0x0026, name: "8155 Security Processor" },
		Device { id: 0x002E, name: "9630 Compression Processor" },
		Device { id: 0x002F, name: "9725 Compression and Security Processor" },
		Device { id: 0x0033, name: "8201 Acceleration Processor" },
		Device { id: 0x0034, name: "8202 Acceleration Processor" },
		Device { id: 0x0035, name: "8203 Acceleration Processor" },
		Device { id: 0x0037, name: "8204 Acceleration Processor" },
	] },
	Vendor { id: 0x13A4, name: "Rascom Inc", devices: &[
	] },
	Vendor { id: 0x13A5, name: "Audio Digital Imaging Inc", devices: &[
	] },
	Vendor { id: 0x13A6, name: "Videonics Inc", devices: &[
	] },
	Vendor { id: 0x13A7, name: "Teles AG", devices: &[
	] },
	Vendor { id: 0x13A8, name: "Exar Corp.", devices: &[
		Device { id: 0x0152, name: "XR17C/D152 Dual PCI UART" },
		Device { id: 0x0154, name: "XR17C154 Quad UART" },
		Device { id: 0x0158, name: "XR17C158 Octal UART" },
		Device { id: 0x0252, name: "XR17V252 Dual UART PCI controller" },
		Device { id: 0x0254, name: "XR17V254 Quad UART PCI controller" },
		Device { id: 0x0258, name: "XR17V258 Octal UART PCI controller" },
	] },
	Vendor { id: 0x13A9, name: "Siemens Medical Systems, Ultrasound Group", devices: &[
	] },
	Vendor { id: 0x13AA, name: "Broadband Networks Inc", devices: &[
	] },
	Vendor { id: 0x13AB, name: "Arcom Control Systems Ltd", devices: &[
	] },
	Vendor { id: 0x13AC, name: "Motion Media Technology Ltd", devices: &[
	] },
	Vendor { id: 0x13AD, name: "Nexus Inc", devices: &[
	] },
	Vendor { id: 0x13AE, name: "ALD Technology Ltd", devices: &[
	] },
	Vendor { id: 0x13AF, name: "T.Sqware", devices: &[
	] },
	Vendor { id: 0x13B0, name: "Maxspeed Corp", devices: &[
	] },
	Vendor { id: 0x13B1, name: "Tamura corporation", devices: &[
	] },
	Vendor { id: 0x13B2, name: "Techno Chips Co. Ltd", devices: &[
	] },
	Vendor { id: 0x13B3, name: "Lanart Corporation", devices: &[
	] },
	Vendor { id: 0x13B4, name: "Wellbean Co Inc", devices: &[
	] },
	Vendor { id: 0x13B5, name: "ARM", devices: &[
	] },
	Vendor { id: 0x13B6, name: "Dlog GmbH", devices: &[
	] },
	Vendor { id: 0x13B7, name: "Logic Devices Inc", devices: &[
	] },
	Vendor { id: 0x13B8, name: "Nokia Telecommunications oy", devices: &[
	] },
	Vendor { id: 0x13B9, name: "Elecom Co Ltd", devices: &[
	] },
	Vendor { id: 0x13BA, name: "Oxford Instruments", devices: &[
	] },
	Vendor { id: 0x13BB, name: "Sanyo Technosound Co Ltd", devices: &[
	] },
	Vendor { id: 0x13BC, name: "Bitran Corporation", devices: &[
	] },
	Vendor { id: 0x13BD, name: "Sharp corporation", devices: &[
	] },
	Vendor { id: 0x13BE, name: "Miroku Jyoho Service Co. Ltd", devices: &[
	] },
	Vendor { id: 0x13BF, name: "Sharewave Inc", devices: &[
	] },
	Vendor { id: 0x13C0, name: "Microgate Corporation", devices: &[
		Device { id: 0x0010, name: "SyncLink Adapter v1" },
		Device { id: 0x0020, name: "SyncLink SCC Adapter" },
		Device { id: 0x0030, name: "SyncLink Multiport Adapter" },
		Device { id: 0x0070, name: "SyncLink GT Adapter" },
		Device { id: 0x0080, name: "SyncLink GT4 Adapter" },
		Device { id: 0x00A0, name: "SyncLink GT2 Adapter" },
		Device { id: 0x0210, name: "SyncLink Adapter v2" },
	] },
	Vendor { id: 0x13C1, name: "3ware Inc", devices: &[
		Device { id: 0x1000, name: "5xxx/6xxx-series PATA-RAID" },
		Device { id: 0x1001, name: "7xxx/8xxx-series PATA/SATA-RAID" },
		Device { id: 0x1002, name: "9xxx-series SATA-RAID" },
		Device { id: 0x1003, name: "9550SX SATA-II RAID PCI-X" },
		Device { id: 0x1004, name: "9650SE SATA-II RAID PCIe" },
		Device { id: 0x1005, name: "9690SA SAS/SATA-II RAID PCIe" },
		Device { id: 0x1010, name: "9750 SAS2/SATA-II RAID PCIe" },
	] },
	Vendor { id: 0x13C2, name: "Technotrend Systemtechnik GmbH", devices: &[
		Device { id: 0x000E, name: "Technotrend/Hauppauge DVB card rev2.3" },
		Device { id: 0x1019, name: "TTechnoTrend-budget DVB S2-3200" },
	] },
	Vendor { id: 0x13C3, name: "Janz Computer AG", devices: &[
	] },
	Vendor { id: 0x13C4, name: "Phase Metrics", devices: &[
	] },
	Vendor { id: 0x13C5, name: "Alphi Technology Corp", devices: &[
	] },
	Vendor { id: 0x13C6, name: "Condor Engineering Inc", devices: &[
		Device { id: 0x0520, name: "CEI-520 A429 Card" },
		Device { id: 0x0620, name: "CEI-620 A429 Card" },
		Device { id: 0x0820, name: "CEI-820 A429 Card" },
		Device { id: 0x0830, name: "CEI-830 A429 Card" },
		Device { id: 0x1004, name: "P-SER Multi-channel PMC to RS-485/422/232 adapter" },
	] },
	Vendor { id: 0x13C7, name: "Blue Chip Technology Ltd", devices: &[
		Device { id: 0x0ADC, name: "PCI-ADC" },
		Device { id: 0x0B10, name: "PCI-PIO" },
		Device { id: 0x0D10, name: "PCI-DIO" },
		Device { id: 0x524C, name: "PCI-RLY" },
		Device { id: 0x5744, name: "PCI-WDT" },
	] },
	Vendor { id: 0x13C8, name: "Apptech Inc", devices: &[
	] },
	Vendor { id: 0x13C9, name: "Eaton Corporation", devices: &[
	] },
	Vendor { id: 0x13CA, name: "Iomega Corporation", devices: &[
	] },
	Vendor { id: 0x13CB, name: "Yano Electric Co Ltd", devices: &[
	] },
	Vendor { id: 0x13CC, name: "Metheus Corporation", devices: &[
	] },
	Vendor { id: 0x13CD, name: "Compatible Systems Corporation", devices: &[
	] },
	Vendor { id: 0x13CE, name: "Cocom A/S", devices: &[
	] },
	Vendor { id: 0x13CF, name: "Studio Audio & Video Ltd", devices: &[
	] },
	Vendor { id: 0x13D0, name: "Techsan Electronics Co Ltd", devices: &[
		Device { id: 0x2103, name: "B2C2 FlexCopII DVB chip / Technisat SkyStar2 DVB card" },
		Device { id: 0x2104, name: "B2C2 FlexCopIII DVB chip / Technisat SkyStar2 DVB card (rev 01)" },
		Device { id: 0x2200, name: "B2C2 FlexCopIII DVB chip / Technisat SkyStar2 DVB card" },
	] },
	Vendor { id: 0x13D1, name: "Abocom Systems Inc", devices: &[
		Device { id: 0xAB02, name: "ADMtek Centaur-C rev 17 [D-Link DFE-680TX] CardBus Fast Ethernet Adapter" },
		Device { id: 0xAB03, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
		Device { id: 0xAB06, name: "RTL8139 [FE2000VX] CardBus Fast Ethernet Attached Port Adapter" },
		Device { id: 0xAB08, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
	] },
	Vendor { id: 0x13D2, name: "Shark Multimedia Inc", devices: &[
	] },
	Vendor { id: 0x13D4, name: "Graphics Microsystems Inc", devices: &[
	] },
	Vendor { id: 0x13D5, name: "Media 100 Inc", devices: &[
	] },
	Vendor { id: 0x13D6, name: "K.I. Technology Co Ltd", devices: &[
	] },
	Vendor { id: 0x13D7, name: "Toshiba Engineering Corporation", devices: &[
	] },
	Vendor { id: 0x13D8, name: "Phobos corporation", devices: &[
	] },
	Vendor { id: 0x13D9, name: "Apex PC Solutions Inc", devices: &[
	] },
	Vendor { id: 0x13DA, name: "Intresource Systems pte Ltd", devices: &[
	] },
	Vendor { id: 0x13DB, name: "Janich & Klass Computertechnik GmbH", devices: &[
	] },
	Vendor { id: 0x13DC, name: "Netboost Corporation", devices: &[
	] },
	Vendor { id: 0x13DD, name: "Multimedia Bundle Inc", devices: &[
	] },
	Vendor { id: 0x13DE, name: "ABB Robotics Products AB", devices: &[
	] },
	Vendor { id: 0x13DF, name: "E-Tech Inc", devices: &[
		Device { id: 0x0001, name: "PCI56RVP Modem" },
	] },
	Vendor { id: 0x13E0, name: "GVC Corporation", devices: &[
	] },
	Vendor { id: 0x13E1, name: "Silicom Multimedia Systems Inc", devices: &[
	] },
	Vendor { id: 0x13E2, name: "Dynamics Research Corporation", devices: &[
	] },
	Vendor { id: 0x13E3, name: "Nest Inc", devices: &[
	] },
	Vendor { id: 0x13E4, name: "Calculex Inc", devices: &[
	] },
	Vendor { id: 0x13E5, name: "Telesoft Design Ltd", devices: &[
	] },
	Vendor { id: 0x13E6, name: "Argosy research Inc", devices: &[
	] },
	Vendor { id: 0x13E7, name: "NAC Incorporated", devices: &[
	] },
	Vendor { id: 0x13E8, name: "Chip Express Corporation", devices: &[
	] },
	Vendor { id: 0x13E9, name: "Intraserver Technology Inc", devices: &[
	] },
	Vendor { id: 0x13EA, name: "Dallas Semiconductor", devices: &[
	] },
	Vendor { id: 0x13EB, name: "Hauppauge Computer Works Inc", devices: &[
	] },
	Vendor { id: 0x13EC, name: "Zydacron Inc", devices: &[
		Device { id: 0x000A, name: "NPC-RC01 Remote control receiver" },
	] },
	Vendor { id: 0x13ED, name: "Raytheion E-Systems", devices: &[
	] },
	Vendor { id: 0x13EE, name: "Hayes Microcomputer Products Inc", devices: &[
	] },
	Vendor { id: 0x13EF, name: "Coppercom Inc", devices: &[
	] },
	Vendor { id: 0x13F0, name: "Sundance Technology Inc / IC Plus Corp", devices: &[
		Device { id: 0x0200, name: "IC Plus IP100A Integrated 10/100 Ethernet MAC + PHY" },
		Device { id: 0x0201, name: "ST201 Sundance Ethernet" },
		Device { id: 0x1021, name: "TC902x Gigabit Ethernet" },
		Device { id: 0x1023, name: "IP1000 Family Gigabit Ethernet" },
	] },
	Vendor { id: 0x13F1, name: "Oce' - Technologies B.V.", devices: &[
	] },
	Vendor { id: 0x13F2, name: "Ford Microelectronics Inc", devices: &[
	] },
	Vendor { id: 0x13F3, name: "Mcdata Corporation", devices: &[
	] },
	Vendor { id: 0x13F4, name: "Troika Networks, Inc.", devices: &[
		Device { id: 0x1401, name: "Zentai Fibre Channel Adapter" },
	] },
	Vendor { id: 0x13F5, name: "Kansai Electric Co. Ltd", devices: &[
	] },
	Vendor { id: 0x13F6, name: "C-Media Electronics Inc", devices: &[
		Device { id: 0x0011, name: "CMI8738" },
		Device { id: 0x0100, name: "CM8338A" },
		Device { id: 0x0101, name: "CM8338B" },
		Device { id: 0x0111, name: "CMI8738/CMI8768 PCI Audio" },
		Device { id: 0x0211, name: "CM8738" },
		Device { id: 0x5011, name: "CM8888 [Oxygen Express]" },
		Device { id: 0x8788, name: "CMI8788 [Oxygen HD Audio]" },
	] },
	Vendor { id: 0x13F7, name: "Wildfire Communications", devices: &[
	] },
	Vendor { id: 0x13F8, name: "Ad Lib Multimedia Inc", devices: &[
	] },
	Vendor { id: 0x13F9, name: "NTT Advanced Technology Corp.", devices: &[
	] },
	Vendor { id: 0x13FA, name: "Pentland Systems Ltd", devices: &[
	] },
	Vendor { id: 0x13FB, name: "Aydin Corp", devices: &[
	] },
	Vendor { id: 0x13FC, name: "Computer Peripherals International", devices: &[
	] },
	Vendor { id: 0x13FD, name: "Micro Science Inc", devices: &[
	] },
	Vendor { id: 0x13FE, name: "Advantech Co. Ltd", devices: &[
		Device { id: 0x1240, name: "PCI-1240 4-channel stepper motor controller card" },
		Device { id: 0x1600, name: "PCI-16xx series PCI multiport serial board (function 0)" },
		Device { id: 0x1603, name: "PCI-1603 2-port isolated RS-232/current loop" },
		Device { id: 0x1604, name: "PCI-1604 2-port RS-232" },
		Device { id: 0x16FF, name: "PCI-16xx series PCI multiport serial board (function 1: RX/TX steering CPLD)" },
		Device { id: 0x1711, name: "PCI-1711 16-channel data acquisition card 12-bit, 100kS/s" },
		Device { id: 0x1733, name: "PCI-1733 32-channel isolated digital input card" },
		Device { id: 0x1752, name: "PCI-1752" },
		Device { id: 0x1754, name: "PCI-1754" },
		Device { id: 0x1756, name: "PCI-1756" },
		Device { id: 0xC302, name: "MIOe-3680 2-Port CAN-Bus MIOe Module with Isolation Protection" },
	] },
	Vendor { id: 0x13FF, name: "Silicon Spice Inc", devices: &[
	] },
	Vendor { id: 0x1400, name: "Artx Inc", devices: &[
		Device { id: 0x1401, name: "9432 TX" },
	] },
	Vendor { id: 0x1401, name: "CR-Systems A/S", devices: &[
	] },
	Vendor { id: 0x1402, name: "Meilhaus Electronic GmbH", devices: &[
		Device { id: 0x0630, name: "ME-630" },
		Device { id: 0x0940, name: "ME-94" },
		Device { id: 0x0950, name: "ME-95" },
		Device { id: 0x0960, name: "ME-96" },
		Device { id: 0x1000, name: "ME-1000" },
		Device { id: 0x100A, name: "ME-1000" },
		Device { id: 0x100B, name: "ME-1000" },
		Device { id: 0x1400, name: "ME-1400" },
		Device { id: 0x140A, name: "ME-1400A" },
		Device { id: 0x140B, name: "ME-1400B" },
		Device { id: 0x140C, name: "ME-1400C" },
		Device { id: 0x140D, name: "ME-1400D" },
		Device { id: 0x140E, name: "ME-1400E" },
		Device { id: 0x14EA, name: "ME-1400EA" },
		Device { id: 0x14EB, name: "ME-1400EB" },
		Device { id: 0x1604, name: "ME-1600/4U" },
		Device { id: 0x1608, name: "ME-1600/8U" },
		Device { id: 0x160C, name: "ME-1600/12U" },
		Device { id: 0x160F, name: "ME-1600/16U" },
		Device { id: 0x168F, name: "ME-1600/16U8I" },
		Device { id: 0x4610, name: "ME-4610" },
		Device { id: 0x4650, name: "ME-4650" },
		Device { id: 0x4660, name: "ME-4660" },
		Device { id: 0x4661, name: "ME-4660I" },
		Device { id: 0x4662, name: "ME-4660" },
		Device { id: 0x4663, name: "ME-4660I" },
		Device { id: 0x4670, name: "ME-4670" },
		Device { id: 0x4671, name: "ME-4670I" },
		Device { id: 0x4672, name: "ME-4670S" },
		Device { id: 0x4673, name: "ME-4670IS" },
		Device { id: 0x4680, name: "ME-4680" },
		Device { id: 0x4681, name: "ME-4680I" },
		Device { id: 0x4682, name: "ME-4680S" },
		Device { id: 0x4683, name: "ME-4680IS" },
		Device { id: 0x6004, name: "ME-6000/4" },
		Device { id: 0x6008, name: "ME-6000/8" },
		Device { id: 0x600F, name: "ME-6000/16" },
		Device { id: 0x6014, name: "ME-6000I/4" },
		Device { id: 0x6018, name: "ME-6000I/8" },
		Device { id: 0x601F, name: "ME-6000I/16" },
		Device { id: 0x6034, name: "ME-6000ISLE/4" },
		Device { id: 0x6038, name: "ME-6000ISLE/8" },
		Device { id: 0x603F, name: "ME-6000ISLE/16" },
		Device { id: 0x6044, name: "ME-6000/4/DIO" },
		Device { id: 0x6048, name: "ME-6000/8/DIO" },
		Device { id: 0x604F, name: "ME-6000/16/DIO" },
		Device { id: 0x6054, name: "ME-6000I/4/DIO" },
		Device { id: 0x6058, name: "ME-6000I/8/DIO" },
		Device { id: 0x605F, name: "ME-6000I/16/DIO" },
		Device { id: 0x6074, name: "ME-6000ISLE/4/DIO" },
		Device { id: 0x6078, name: "ME-6000ISLE/8/DIO" },
		Device { id: 0x607F, name: "ME-6000ISLE/16/DIO" },
		Device { id: 0x6104, name: "ME-6100/4" },
		Device { id: 0x6108, name: "ME-6100/8" },
		Device { id: 0x610F, name: "ME-6100/16" },
		Device { id: 0x6114, name: "ME-6100I/4" },
		Device { id: 0x6118, name: "ME-6100I/8" },
		Device { id: 0x611F, name: "ME-6100I/16" },
		Device { id: 0x6134, name: "ME-6100ISLE/4" },
		Device { id: 0x6138, name: "ME-6100ISLE/8" },
		Device { id: 0x613F, name: "ME-6100ISLE/16" },
		Device { id: 0x6144, name: "ME-6100/4/DIO" },
		Device { id: 0x6148, name: "ME-6100/8/DIO" },
		Device { id: 0x614F, name: "ME-6100/16/DIO" },
		Device { id: 0x6154, name: "ME-6100I/4/DIO" },
		Device { id: 0x6158, name: "ME-6100I/8/DIO" },
		Device { id: 0x615F, name: "ME-6100I/16/DIO" },
		Device { id: 0x6174, name: "ME-6100ISLE/4/DIO" },
		Device { id: 0x6178, name: "ME-6100ISLE/8/DIO" },
		Device { id: 0x617F, name: "ME-6100ISLE/16/DIO" },
		Device { id: 0x6259, name: "ME-6200I/9/DIO" },
		Device { id: 0x6359, name: "ME-6300I/9/DIO" },
		Device { id: 0x810A, name: "ME-8100A" },
		Device { id: 0x810B, name: "ME-8100B" },
		Device { id: 0x820A, name: "ME-8200A" },
		Device { id: 0x820B, name: "ME-8200B" },
	] },
	Vendor { id: 0x1403, name: "Ascor Inc", devices: &[
	] },
	Vendor { id: 0x1404, name: "Fundamental Software Inc", devices: &[
	] },
	Vendor { id: 0x1405, name: "Excalibur Systems Inc", devices: &[
	] },
	Vendor { id: 0x1406, name: "Oce' Printing Systems GmbH", devices: &[
	] },
	Vendor { id: 0x1407, name: "Lava Computer mfg Inc", devices: &[
		Device { id: 0x0100, name: "Lava Dual Serial" },
		Device { id: 0x0101, name: "Lava Quatro A" },
		Device { id: 0x0102, name: "Lava Quatro B" },
		Device { id: 0x0110, name: "Lava DSerial-PCI Port A" },
		Device { id: 0x0111, name: "Lava DSerial-PCI Port B" },
		Device { id: 0x0120, name: "Quattro-PCI A" },
		Device { id: 0x0121, name: "Quattro-PCI B" },
		Device { id: 0x0180, name: "Lava Octo A" },
		Device { id: 0x0181, name: "Lava Octo B" },
		Device { id: 0x0200, name: "Lava Port Plus" },
		Device { id: 0x0201, name: "Lava Quad A" },
		Device { id: 0x0202, name: "Lava Quad B" },
		Device { id: 0x0220, name: "Lava Quattro PCI Ports A/B" },
		Device { id: 0x0221, name: "Lava Quattro PCI Ports C/D" },
		Device { id: 0x0400, name: "Lava 8255-PIO-PCI" },
		Device { id: 0x0500, name: "Lava Single Serial" },
		Device { id: 0x0520, name: "Lava RS422-SS-PCI" },
		Device { id: 0x0600, name: "Lava Port 650" },
		Device { id: 0x8000, name: "Lava Parallel" },
		Device { id: 0x8001, name: "Dual parallel port controller A" },
		Device { id: 0x8002, name: "Lava Dual Parallel port A" },
		Device { id: 0x8003, name: "Lava Dual Parallel port B" },
		Device { id: 0x8800, name: "BOCA Research IOPPAR" },
	] },
	Vendor { id: 0x1408, name: "Aloka Co. Ltd", devices: &[
	] },
	Vendor { id: 0x1409, name: "Timedia Technology Co Ltd", devices: &[
		Device { id: 0x7168, name: "PCI2S550 (Dual 16550 UART)" },
		Device { id: 0x7268, name: "SUN1888 (Dual IEEE1284 parallel port)" },
	] },
	Vendor { id: 0x140A, name: "DSP Research Inc", devices: &[
	] },
	Vendor { id: 0x140B, name: "Abaco Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x140C, name: "Elmic Systems Inc", devices: &[
	] },
	Vendor { id: 0x140D, name: "Matsushita Electric Works Ltd", devices: &[
	] },
	Vendor { id: 0x140E, name: "Goepel Electronic GmbH", devices: &[
	] },
	Vendor { id: 0x140F, name: "Salient Systems Corp", devices: &[
	] },
	Vendor { id: 0x1410, name: "Midas lab Inc", devices: &[
	] },
	Vendor { id: 0x1411, name: "Ikos Systems Inc", devices: &[
	] },
	Vendor { id: 0x1412, name: "VIA Technologies Inc.", devices: &[
		Device { id: 0x1712, name: "ICE1712 [Envy24] PCI Multi-Channel I/O Controller" },
		Device { id: 0x1724, name: "VT1720/24 [Envy24PT/HT] PCI Multi-Channel Audio Controller" },
	] },
	Vendor { id: 0x1413, name: "Addonics", devices: &[
	] },
	Vendor { id: 0x1414, name: "Microsoft Corporation", devices: &[
		Device { id: 0x0001, name: "MN-120 (ADMtek Centaur-C based)" },
		Device { id: 0x0002, name: "MN-130 (ADMtek Centaur-P based)" },
		Device { id: 0x5353, name: "Hyper-V virtual VGA" },
		Device { id: 0x5801, name: "XMA Decoder (Xenon)" },
		Device { id: 0x5802, name: "SATA Controller - CdRom (Xenon)" },
		Device { id: 0x5803, name: "SATA Controller - Disk (Xenon)" },
		Device { id: 0x5804, name: "OHCI Controller 0 (Xenon)" },
		Device { id: 0x5805, name: "EHCI Controller 0 (Xenon)" },
		Device { id: 0x5806, name: "OHCI Controller 1 (Xenon)" },
		Device { id: 0x5807, name: "EHCI Controller 1 (Xenon)" },
		Device { id: 0x580A, name: "Fast Ethernet Adapter (Xenon)" },
		Device { id: 0x580B, name: "Secure Flash Controller (Xenon)" },
		Device { id: 0x580D, name: "System Management Controller (Xenon)" },
		Device { id: 0x5811, name: "Xenos GPU (Xenon)" },
	] },
	Vendor { id: 0x1415, name: "Oxford Semiconductor Ltd", devices: &[
		Device { id: 0x8401, name: "OX9162 Mode 1 (8-bit bus)" },
		Device { id: 0x8403, name: "OX9162 Mode 0 (parallel port)" },
		Device { id: 0x9500, name: "OX16PCI954 (Quad 16950 UART) function 0 (Disabled)" },
		Device { id: 0x9501, name: "OX16PCI954 (Quad 16950 UART) function 0 (Uart)" },
		Device { id: 0x9505, name: "OXuPCI952 (Dual 16C950 UART)" },
		Device { id: 0x950A, name: "EXSYS EX-41092 Dual 16950 Serial adapter" },
		Device { id: 0x950B, name: "OXCB950 Cardbus 16950 UART" },
		Device { id: 0x9510, name: "OX16PCI954 (Quad 16950 UART) function 1 (Disabled)" },
		Device { id: 0x9511, name: "OX16PCI954 (Quad 16950 UART) function 1 (8bit bus)" },
		Device { id: 0x9512, name: "OX16PCI954 (Quad 16950 UART) function 1 (32bit bus)" },
		Device { id: 0x9513, name: "OX16PCI954 (Quad 16950 UART) function 1 (parallel port)" },
		Device { id: 0x9521, name: "OX16PCI952 (Dual 16950 UART)" },
		Device { id: 0x9523, name: "OX16PCI952 Integrated Parallel Port" },
		Device { id: 0xC158, name: "OXPCIe952 Dual 16C950 UART" },
		Device { id: 0xC308, name: "EX-44016 16-port serial" },
	] },
	Vendor { id: 0x1416, name: "Multiwave Innovation pte Ltd", devices: &[
	] },
	Vendor { id: 0x1417, name: "Convergenet Technologies Inc", devices: &[
	] },
	Vendor { id: 0x1418, name: "Kyushu electronics systems Inc", devices: &[
	] },
	Vendor { id: 0x1419, name: "Excel Switching Corp", devices: &[
	] },
	Vendor { id: 0x141A, name: "Apache Micro Peripherals Inc", devices: &[
	] },
	Vendor { id: 0x141B, name: "Zoom Telephonics Inc", devices: &[
	] },
	Vendor { id: 0x141D, name: "Digitan Systems Inc", devices: &[
	] },
	Vendor { id: 0x141E, name: "Fanuc Ltd", devices: &[
	] },
	Vendor { id: 0x141F, name: "Visiontech Ltd", devices: &[
	] },
	Vendor { id: 0x1420, name: "Psion Dacom plc", devices: &[
		Device { id: 0x8002, name: "Gold Card NetGlobal 56k+10/100Mb CardBus (Ethernet part)" },
		Device { id: 0x8003, name: "Gold Card NetGlobal 56k+10/100Mb CardBus (Modem part)" },
	] },
	Vendor { id: 0x1421, name: "Ads Technologies Inc", devices: &[
	] },
	Vendor { id: 0x1422, name: "Ygrec Systems Co Ltd", devices: &[
	] },
	Vendor { id: 0x1423, name: "Custom Technology Corp.", devices: &[
	] },
	Vendor { id: 0x1424, name: "Videoserver Connections", devices: &[
	] },
	Vendor { id: 0x1425, name: "Chelsio Communications Inc", devices: &[
		Device { id: 0x000B, name: "T210 Protocol Engine" },
		Device { id: 0x000C, name: "T204 Protocol Engine" },
		Device { id: 0x0022, name: "10GbE Ethernet Adapter" },
		Device { id: 0x0030, name: "T310 10GbE Single Port Adapter" },
		Device { id: 0x0031, name: "T320 10GbE Dual Port Adapter" },
		Device { id: 0x0032, name: "T302 1GbE Dual Port Adapter" },
		Device { id: 0x0033, name: "T304 1GbE Quad Port Adapter" },
		Device { id: 0x0034, name: "B320 10GbE Dual Port Adapter" },
		Device { id: 0x0035, name: "S310-CR 10GbE Single Port Adapter" },
		Device { id: 0x0036, name: "S320-LP-CR 10GbE Dual Port Adapter" },
		Device { id: 0x0037, name: "N320-G2-CR 10GbE Dual Port Adapter" },
		Device { id: 0x4001, name: "T420-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4002, name: "T422-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4003, name: "T440-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4004, name: "T420-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x4005, name: "T440-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x4006, name: "T440-CH Unified Wire Ethernet Controller" },
		Device { id: 0x4007, name: "T420-SO Unified Wire Ethernet Controller" },
		Device { id: 0x4008, name: "T420-CX Unified Wire Ethernet Controller" },
		Device { id: 0x4009, name: "T420-BT Unified Wire Ethernet Controller" },
		Device { id: 0x400A, name: "T404-BT Unified Wire Ethernet Controller" },
		Device { id: 0x400B, name: "B420-SR Unified Wire Ethernet Controller" },
		Device { id: 0x400C, name: "B404-BT Unified Wire Ethernet Controller" },
		Device { id: 0x400D, name: "T480 Unified Wire Ethernet Controller" },
		Device { id: 0x400E, name: "T440-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x400F, name: "T440 [Amsterdam] Unified Wire Ethernet Controller" },
		Device { id: 0x4080, name: "T480-4080 T480 Unified Wire Ethernet Controller" },
		Device { id: 0x4081, name: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller" },
		Device { id: 0x4082, name: "T420-4082  Unified Wire Ethernet Controller" },
		Device { id: 0x4083, name: "T420X-4083 Unified Wire Ethernet Controller" },
		Device { id: 0x4084, name: "T440-4084 Unified Wire Ethernet Controller" },
		Device { id: 0x4085, name: "T420-4085 SFP+ Unified Wire Ethernet Controller" },
		Device { id: 0x4086, name: "T440-4086 10Gbase-T Unified Wire Ethernet Controller" },
		Device { id: 0x4087, name: "T440T-4087 Unified Wire Ethernet Controller" },
		Device { id: 0x4088, name: "T440-4088 Unified Wire Ethernet Controller" },
		Device { id: 0x4401, name: "T420-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4402, name: "T422-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4403, name: "T440-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4404, name: "T420-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x4405, name: "T440-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x4406, name: "T440-CH Unified Wire Ethernet Controller" },
		Device { id: 0x4407, name: "T420-SO Unified Wire Ethernet Controller" },
		Device { id: 0x4408, name: "T420-CX Unified Wire Ethernet Controller" },
		Device { id: 0x4409, name: "T420-BT Unified Wire Ethernet Controller" },
		Device { id: 0x440A, name: "T404-BT Unified Wire Ethernet Controller" },
		Device { id: 0x440B, name: "B420-SR Unified Wire Ethernet Controller" },
		Device { id: 0x440C, name: "B404-BT Unified Wire Ethernet Controller" },
		Device { id: 0x440D, name: "T480 Unified Wire Ethernet Controller" },
		Device { id: 0x440E, name: "T440-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x440F, name: "T440 [Amsterdam] Unified Wire Ethernet Controller" },
		Device { id: 0x4480, name: "T480-4080 T480 Unified Wire Ethernet Controller" },
		Device { id: 0x4481, name: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller" },
		Device { id: 0x4482, name: "T420-4082  Unified Wire Ethernet Controller" },
		Device { id: 0x4483, name: "T420X-4083 Unified Wire Ethernet Controller" },
		Device { id: 0x4484, name: "T440-4084 Unified Wire Ethernet Controller" },
		Device { id: 0x4485, name: "T420-4085 SFP+ Unified Wire Ethernet Controller" },
		Device { id: 0x4486, name: "T440-4086 10Gbase-T Unified Wire Ethernet Controller" },
		Device { id: 0x4487, name: "T440T-4087 Unified Wire Ethernet Controller" },
		Device { id: 0x4488, name: "T440-4088 Unified Wire Ethernet Controller" },
		Device { id: 0x4501, name: "T420-CR Unified Wire Storage Controller" },
		Device { id: 0x4502, name: "T422-CR Unified Wire Storage Controller" },
		Device { id: 0x4503, name: "T440-CR Unified Wire Storage Controller" },
		Device { id: 0x4504, name: "T420-BCH Unified Wire Storage Controller" },
		Device { id: 0x4505, name: "T440-BCH Unified Wire Storage Controller" },
		Device { id: 0x4506, name: "T440-CH Unified Wire Storage Controller" },
		Device { id: 0x4507, name: "T420-SO Unified Wire Storage Controller" },
		Device { id: 0x4508, name: "T420-CX Unified Wire Storage Controller" },
		Device { id: 0x4509, name: "T420-BT Unified Wire Storage Controller" },
		Device { id: 0x450A, name: "T404-BT Unified Wire Storage Controller" },
		Device { id: 0x450B, name: "B420-SR Unified Wire Storage Controller" },
		Device { id: 0x450C, name: "B404-BT Unified Wire Storage Controller" },
		Device { id: 0x450D, name: "T480 Unified Wire Storage Controller" },
		Device { id: 0x450E, name: "T440-LP-CR Unified Wire Storage Controller" },
		Device { id: 0x450F, name: "T440 [Amsterdam] Unified Wire Storage Controller" },
		Device { id: 0x4580, name: "T480-4080 T480 Unified Wire Storage Controller" },
		Device { id: 0x4581, name: "T440F-4081 T440-FCoE Unified Wire Storage Controller" },
		Device { id: 0x4582, name: "T420-4082  Unified Wire Storage Controller" },
		Device { id: 0x4583, name: "T420X-4083 Unified Wire Storage Controller" },
		Device { id: 0x4584, name: "T440-4084 Unified Wire Storage Controller" },
		Device { id: 0x4585, name: "T420-4085 SFP+ Unified Wire Storage Controller" },
		Device { id: 0x4586, name: "T440-4086 10Gbase-T Unified Wire Storage Controller" },
		Device { id: 0x4587, name: "T440T-4087 Unified Wire Storage Controller" },
		Device { id: 0x4588, name: "T440-4088 Unified Wire Storage Controller" },
		Device { id: 0x4601, name: "T420-CR Unified Wire Storage Controller" },
		Device { id: 0x4602, name: "T422-CR Unified Wire Storage Controller" },
		Device { id: 0x4603, name: "T440-CR Unified Wire Storage Controller" },
		Device { id: 0x4604, name: "T420-BCH Unified Wire Storage Controller" },
		Device { id: 0x4605, name: "T440-BCH Unified Wire Storage Controller" },
		Device { id: 0x4606, name: "T440-CH Unified Wire Storage Controller" },
		Device { id: 0x4607, name: "T420-SO Unified Wire Storage Controller" },
		Device { id: 0x4608, name: "T420-CX Unified Wire Storage Controller" },
		Device { id: 0x4609, name: "T420-BT Unified Wire Storage Controller" },
		Device { id: 0x460A, name: "T404-BT Unified Wire Storage Controller" },
		Device { id: 0x460B, name: "B420-SR Unified Wire Storage Controller" },
		Device { id: 0x460C, name: "B404-BT Unified Wire Storage Controller" },
		Device { id: 0x460D, name: "T480 Unified Wire Storage Controller" },
		Device { id: 0x460E, name: "T440-LP-CR Unified Wire Storage Controller" },
		Device { id: 0x460F, name: "T440 [Amsterdam] Unified Wire Storage Controller" },
		Device { id: 0x4680, name: "T480-4080 T480 Unified Wire Storage Controller" },
		Device { id: 0x4681, name: "T440F-4081 T440-FCoE Unified Wire Storage Controller" },
		Device { id: 0x4682, name: "T420-4082  Unified Wire Storage Controller" },
		Device { id: 0x4683, name: "T420X-4083 Unified Wire Storage Controller" },
		Device { id: 0x4684, name: "T440-4084 Unified Wire Storage Controller" },
		Device { id: 0x4685, name: "T420-4085 SFP+ Unified Wire Storage Controller" },
		Device { id: 0x4686, name: "T440-4086 10Gbase-T Unified Wire Storage Controller" },
		Device { id: 0x4687, name: "T440T-4087 Unified Wire Storage Controller" },
		Device { id: 0x4688, name: "T440-4088 Unified Wire Storage Controller" },
		Device { id: 0x4701, name: "T420-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4702, name: "T422-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4703, name: "T440-CR Unified Wire Ethernet Controller" },
		Device { id: 0x4704, name: "T420-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x4705, name: "T440-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x4706, name: "T440-CH Unified Wire Ethernet Controller" },
		Device { id: 0x4707, name: "T420-SO Unified Wire Ethernet Controller" },
		Device { id: 0x4708, name: "T420-CX Unified Wire Ethernet Controller" },
		Device { id: 0x4709, name: "T420-BT Unified Wire Ethernet Controller" },
		Device { id: 0x470A, name: "T404-BT Unified Wire Ethernet Controller" },
		Device { id: 0x470B, name: "B420-SR Unified Wire Ethernet Controller" },
		Device { id: 0x470C, name: "B404-BT Unified Wire Ethernet Controller" },
		Device { id: 0x470D, name: "T480 Unified Wire Ethernet Controller" },
		Device { id: 0x470E, name: "T440-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x470F, name: "T440 [Amsterdam] Unified Wire Ethernet Controller" },
		Device { id: 0x4780, name: "T480-4080 T480 Unified Wire Ethernet Controller" },
		Device { id: 0x4781, name: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller" },
		Device { id: 0x4782, name: "T420-4082  Unified Wire Ethernet Controller" },
		Device { id: 0x4783, name: "T420X-4083 Unified Wire Ethernet Controller" },
		Device { id: 0x4784, name: "T440-4084 Unified Wire Ethernet Controller" },
		Device { id: 0x4785, name: "T420-4085 SFP+ Unified Wire Ethernet Controller" },
		Device { id: 0x4786, name: "T440-4086 10Gbase-T Unified Wire Ethernet Controller" },
		Device { id: 0x4787, name: "T440T-4087 Unified Wire Ethernet Controller" },
		Device { id: 0x4788, name: "T440-4088 Unified Wire Ethernet Controller" },
		Device { id: 0x4801, name: "T420-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4802, name: "T422-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4803, name: "T440-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4804, name: "T420-BCH Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4805, name: "T440-BCH Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4806, name: "T440-CH Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4807, name: "T420-SO Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4808, name: "T420-CX Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4809, name: "T420-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x480A, name: "T404-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x480B, name: "B420-SR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x480C, name: "B404-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x480D, name: "T480 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x480E, name: "T440-LP-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x480F, name: "T440 [Amsterdam] Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4880, name: "T480-4080 T480 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4881, name: "T440F-4081 T440-FCoE Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4882, name: "T420-4082 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4883, name: "T420X-4083 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4884, name: "T440-4084 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4885, name: "T420-4085 SFP+ Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4886, name: "T440-4086 10Gbase-T Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4887, name: "T440T-4087 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x4888, name: "T440-4088 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5001, name: "T520-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5002, name: "T522-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5003, name: "T540-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5004, name: "T520-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x5005, name: "T540-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x5006, name: "T540-CH Unified Wire Ethernet Controller" },
		Device { id: 0x5007, name: "T520-SO Unified Wire Ethernet Controller" },
		Device { id: 0x5008, name: "T520-CX Unified Wire Ethernet Controller" },
		Device { id: 0x5009, name: "T520-BT Unified Wire Ethernet Controller" },
		Device { id: 0x500A, name: "T504-BT Unified Wire Ethernet Controller" },
		Device { id: 0x500B, name: "B520-SR Unified Wire Ethernet Controller" },
		Device { id: 0x500C, name: "B504-BT Unified Wire Ethernet Controller" },
		Device { id: 0x500D, name: "T580-CR Unified Wire Ethernet Controller" },
		Device { id: 0x500E, name: "T540-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x500F, name: "T540 [Amsterdam] Unified Wire Ethernet Controller" },
		Device { id: 0x5010, name: "T580-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5011, name: "T520-LL-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5012, name: "T560-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5013, name: "T580-CHR Unified Wire Ethernet Controller" },
		Device { id: 0x5014, name: "T580-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5015, name: "T502-BT Unified Wire Ethernet Controller" },
		Device { id: 0x5016, name: "T580-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x5017, name: "T520-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x5018, name: "T540-BT Unified Wire Ethernet Controller" },
		Device { id: 0x5080, name: "T540-5080 Unified Wire Ethernet Controller" },
		Device { id: 0x5081, name: "T540-5081 Unified Wire Ethernet Controller" },
		Device { id: 0x5082, name: "T504-5082 Unified Wire Ethernet Controller" },
		Device { id: 0x5083, name: "T540-5083 Unified Wire Ethernet Controller" },
		Device { id: 0x5084, name: "T540-5084 Unified Wire Ethernet Controller" },
		Device { id: 0x5085, name: "T580-5085 Unified Wire Ethernet Controller" },
		Device { id: 0x5086, name: "T580-5086 Unified Wire Ethernet Controller" },
		Device { id: 0x5087, name: "T580-5087 Unified Wire Ethernet Controller" },
		Device { id: 0x5088, name: "T570-5088 Unified Wire Ethernet Controller" },
		Device { id: 0x5089, name: "T520-5089 Unified Wire Ethernet Controller" },
		Device { id: 0x5090, name: "T540-5090 Unified Wire Ethernet Controller" },
		Device { id: 0x5091, name: "T522-5091 Unified Wire Ethernet Controller" },
		Device { id: 0x5092, name: "T520-5092 Unified Wire Ethernet Controller" },
		Device { id: 0x5093, name: "T580-5093 Unified Wire Ethernet Controller" },
		Device { id: 0x5094, name: "T540-5094 Unified Wire Ethernet Controller" },
		Device { id: 0x5095, name: "T540-5095 Unified Wire Ethernet Controller" },
		Device { id: 0x5096, name: "T580-5096 Unified Wire Ethernet Controller" },
		Device { id: 0x5097, name: "T520-5097 Unified Wire Ethernet Controller" },
		Device { id: 0x5098, name: "T580-5098 Unified Wire Ethernet Controller" },
		Device { id: 0x5099, name: "T580-5099 Unified Wire Ethernet Controller" },
		Device { id: 0x509A, name: "T520-509A Unified Wire Ethernet Controller" },
		Device { id: 0x509B, name: "T540-509B Unified Wire Ethernet Controller" },
		Device { id: 0x509C, name: "T520-509C Unified Wire Ethernet Controller" },
		Device { id: 0x509D, name: "T540-509D Unified Wire Ethernet Controller" },
		Device { id: 0x509E, name: "T520-509E Unified Wire Ethernet Controller" },
		Device { id: 0x509F, name: "T540-509F Unified Wire Ethernet Controller" },
		Device { id: 0x50A0, name: "T540-50A0 Unified Wire Ethernet Controller" },
		Device { id: 0x50A1, name: "T540-50A1 Unified Wire Ethernet Controller" },
		Device { id: 0x50A2, name: "T580-50A2 Unified Wire Ethernet Controller" },
		Device { id: 0x50A3, name: "T580-50A3 Unified Wire Ethernet Controller" },
		Device { id: 0x50A4, name: "T540-50A4 Unified Wire Ethernet Controller" },
		Device { id: 0x50A5, name: "T522-50A5 Unified Wire Ethernet Controller" },
		Device { id: 0x50A6, name: "T522-50A6 Unified Wire Ethernet Controller" },
		Device { id: 0x50A7, name: "T580-50A7 Unified Wire Ethernet Controller" },
		Device { id: 0x50A8, name: "T580-50A8 Unified Wire Ethernet Controller" },
		Device { id: 0x50A9, name: "T580-50A9 Unified Wire Ethernet Controller" },
		Device { id: 0x50AA, name: "T580-50AA Unified Wire Ethernet Controller" },
		Device { id: 0x50AB, name: "T520-50AB Unified Wire Ethernet Controller" },
		Device { id: 0x5401, name: "T520-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5402, name: "T522-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5403, name: "T540-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5404, name: "T520-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x5405, name: "T540-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x5406, name: "T540-CH Unified Wire Ethernet Controller" },
		Device { id: 0x5407, name: "T520-SO Unified Wire Ethernet Controller" },
		Device { id: 0x5408, name: "T520-CX Unified Wire Ethernet Controller" },
		Device { id: 0x5409, name: "T520-BT Unified Wire Ethernet Controller" },
		Device { id: 0x540A, name: "T504-BT Unified Wire Ethernet Controller" },
		Device { id: 0x540B, name: "B520-SR Unified Wire Ethernet Controller" },
		Device { id: 0x540C, name: "B504-BT Unified Wire Ethernet Controller" },
		Device { id: 0x540D, name: "T580-CR Unified Wire Ethernet Controller" },
		Device { id: 0x540E, name: "T540-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x540F, name: "T540 [Amsterdam] Unified Wire Ethernet Controller" },
		Device { id: 0x5410, name: "T580-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5411, name: "T520-LL-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5412, name: "T560-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5413, name: "T580-CHR Unified Wire Ethernet Controller" },
		Device { id: 0x5414, name: "T580-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5415, name: "T502-BT Unified Wire Ethernet Controller" },
		Device { id: 0x5416, name: "T580-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x5417, name: "T520-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x5418, name: "T540-BT Unified Wire Ethernet Controller" },
		Device { id: 0x5480, name: "T540-5080 Unified Wire Ethernet Controller" },
		Device { id: 0x5481, name: "T540-5081 Unified Wire Ethernet Controller" },
		Device { id: 0x5482, name: "T504-5082 Unified Wire Ethernet Controller" },
		Device { id: 0x5483, name: "T540-5083 Unified Wire Ethernet Controller" },
		Device { id: 0x5484, name: "T540-5084 Unified Wire Ethernet Controller" },
		Device { id: 0x5485, name: "T580-5085 Unified Wire Ethernet Controller" },
		Device { id: 0x5486, name: "T580-5086 Unified Wire Ethernet Controller" },
		Device { id: 0x5487, name: "T580-5087 Unified Wire Ethernet Controller" },
		Device { id: 0x5488, name: "T570-5088 Unified Wire Ethernet Controller" },
		Device { id: 0x5489, name: "T520-5089 Unified Wire Ethernet Controller" },
		Device { id: 0x5490, name: "T540-5090 Unified Wire Ethernet Controller" },
		Device { id: 0x5491, name: "T522-5091 Unified Wire Ethernet Controller" },
		Device { id: 0x5492, name: "T520-5092 Unified Wire Ethernet Controller" },
		Device { id: 0x5493, name: "T580-5093 Unified Wire Ethernet Controller" },
		Device { id: 0x5494, name: "T540-5094 Unified Wire Ethernet Controller" },
		Device { id: 0x5495, name: "T540-5095 Unified Wire Ethernet Controller" },
		Device { id: 0x5496, name: "T580-5096 Unified Wire Ethernet Controller" },
		Device { id: 0x5497, name: "T520-5097 Unified Wire Ethernet Controller" },
		Device { id: 0x5498, name: "T580-5098 Unified Wire Ethernet Controller" },
		Device { id: 0x5499, name: "T580-5099 Unified Wire Ethernet Controller" },
		Device { id: 0x549A, name: "T520-509A Unified Wire Ethernet Controller" },
		Device { id: 0x549B, name: "T540-509B Unified Wire Ethernet Controller" },
		Device { id: 0x549C, name: "T520-509C Unified Wire Ethernet Controller" },
		Device { id: 0x549D, name: "T540-509D Unified Wire Ethernet Controller" },
		Device { id: 0x549E, name: "T520-509E Unified Wire Ethernet Controller" },
		Device { id: 0x549F, name: "T540-509F Unified Wire Ethernet Controller" },
		Device { id: 0x54A0, name: "T540-50A0 Unified Wire Ethernet Controller" },
		Device { id: 0x54A1, name: "T540-50A1 Unified Wire Ethernet Controller" },
		Device { id: 0x54A2, name: "T580-50A2 Unified Wire Ethernet Controller" },
		Device { id: 0x54A3, name: "T580-50A3 Unified Wire Ethernet Controller" },
		Device { id: 0x54A4, name: "T540-50A4 Unified Wire Ethernet Controller" },
		Device { id: 0x54A5, name: "T522-50A5 Unified Wire Ethernet Controller" },
		Device { id: 0x54A6, name: "T522-50A6 Unified Wire Ethernet Controller" },
		Device { id: 0x54A7, name: "T580-50A7 Unified Wire Ethernet Controller" },
		Device { id: 0x54A8, name: "T580-50A8 Unified Wire Ethernet Controller" },
		Device { id: 0x54A9, name: "T580-50A9 Unified Wire Ethernet Controller" },
		Device { id: 0x54AA, name: "T580-50AA Unified Wire Ethernet Controller" },
		Device { id: 0x54AB, name: "T520-50AB Unified Wire Ethernet Controller" },
		Device { id: 0x5501, name: "T520-CR Unified Wire Storage Controller" },
		Device { id: 0x5502, name: "T522-CR Unified Wire Storage Controller" },
		Device { id: 0x5503, name: "T540-CR Unified Wire Storage Controller" },
		Device { id: 0x5504, name: "T520-BCH Unified Wire Storage Controller" },
		Device { id: 0x5505, name: "T540-BCH Unified Wire Storage Controller" },
		Device { id: 0x5506, name: "T540-CH Unified Wire Storage Controller" },
		Device { id: 0x5507, name: "T520-SO Unified Wire Storage Controller" },
		Device { id: 0x5508, name: "T520-CX Unified Wire Storage Controller" },
		Device { id: 0x5509, name: "T520-BT Unified Wire Storage Controller" },
		Device { id: 0x550A, name: "T504-BT Unified Wire Storage Controller" },
		Device { id: 0x550B, name: "B520-SR Unified Wire Storage Controller" },
		Device { id: 0x550C, name: "B504-BT Unified Wire Storage Controller" },
		Device { id: 0x550D, name: "T580-CR Unified Wire Storage Controller" },
		Device { id: 0x550E, name: "T540-LP-CR Unified Wire Storage Controller" },
		Device { id: 0x550F, name: "T540 [Amsterdam] Unified Wire Storage Controller" },
		Device { id: 0x5510, name: "T580-LP-CR Unified Wire Storage Controller" },
		Device { id: 0x5511, name: "T520-LL-CR Unified Wire Storage Controller" },
		Device { id: 0x5512, name: "T560-CR Unified Wire Storage Controller" },
		Device { id: 0x5513, name: "T580-CHR Unified Wire Storage Controller" },
		Device { id: 0x5514, name: "T580-SO-CR Unified Wire Storage Controller" },
		Device { id: 0x5515, name: "T502-BT Unified Wire Storage Controller" },
		Device { id: 0x5516, name: "T580-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x5517, name: "T520-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x5518, name: "T540-BT Unified Wire Storage Controller" },
		Device { id: 0x5580, name: "T540-5080 Unified Wire Storage Controller" },
		Device { id: 0x5581, name: "T540-5081 Unified Wire Storage Controller" },
		Device { id: 0x5582, name: "T504-5082 Unified Wire Storage Controller" },
		Device { id: 0x5583, name: "T540-5083 Unified Wire Storage Controller" },
		Device { id: 0x5584, name: "T540-5084 Unified Wire Storage Controller" },
		Device { id: 0x5585, name: "T580-5085 Unified Wire Storage Controller" },
		Device { id: 0x5586, name: "T580-5086 Unified Wire Storage Controller" },
		Device { id: 0x5587, name: "T580-5087 Unified Wire Storage Controller" },
		Device { id: 0x5588, name: "T570-5088 Unified Wire Storage Controller" },
		Device { id: 0x5589, name: "T520-5089 Unified Wire Storage Controller" },
		Device { id: 0x5590, name: "T540-5090 Unified Wire Storage Controller" },
		Device { id: 0x5591, name: "T522-5091 Unified Wire Storage Controller" },
		Device { id: 0x5592, name: "T520-5092 Unified Wire Storage Controller" },
		Device { id: 0x5593, name: "T580-5093 Unified Wire Storage Controller" },
		Device { id: 0x5594, name: "T540-5094 Unified Wire Storage Controller" },
		Device { id: 0x5595, name: "T540-5095 Unified Wire Storage Controller" },
		Device { id: 0x5596, name: "T580-5096 Unified Wire Storage Controller" },
		Device { id: 0x5597, name: "T520-5097 Unified Wire Storage Controller" },
		Device { id: 0x5598, name: "T580-5098 Unified Wire Storage Controller" },
		Device { id: 0x5599, name: "T580-5099 Unified Wire Storage Controller" },
		Device { id: 0x559A, name: "T520-509A Unified Wire Storage Controller" },
		Device { id: 0x559B, name: "T540-509B Unified Wire Storage Controller" },
		Device { id: 0x559C, name: "T520-509C Unified Wire Storage Controller" },
		Device { id: 0x559D, name: "T540-509D Unified Wire Storage Controller" },
		Device { id: 0x559E, name: "T520-509E Unified Wire Storage Controller" },
		Device { id: 0x559F, name: "T540-509F Unified Wire Storage Controller" },
		Device { id: 0x55A0, name: "T540-50A0 Unified Wire Storage Controller" },
		Device { id: 0x55A1, name: "T540-50A1 Unified Wire Storage Controller" },
		Device { id: 0x55A2, name: "T580-50A2 Unified Wire Storage Controller" },
		Device { id: 0x55A3, name: "T580-50A3 Unified Wire Storage Controller" },
		Device { id: 0x55A4, name: "T540-50A4 Unified Wire Storage Controller" },
		Device { id: 0x55A5, name: "T522-50A5 Unified Wire Storage Controller" },
		Device { id: 0x55A6, name: "T522-50A6 Unified Wire Storage Controller" },
		Device { id: 0x55A7, name: "T580-50A7 Unified Wire Storage Controller" },
		Device { id: 0x55A8, name: "T580-50A8 Unified Wire Storage Controller" },
		Device { id: 0x55A9, name: "T580-50A9 Unified Wire Storage Controller" },
		Device { id: 0x5601, name: "T520-CR Unified Wire Storage Controller" },
		Device { id: 0x5602, name: "T522-CR Unified Wire Storage Controller" },
		Device { id: 0x5603, name: "T540-CR Unified Wire Storage Controller" },
		Device { id: 0x5604, name: "T520-BCH Unified Wire Storage Controller" },
		Device { id: 0x5605, name: "T540-BCH Unified Wire Storage Controller" },
		Device { id: 0x5606, name: "T540-CH Unified Wire Storage Controller" },
		Device { id: 0x5607, name: "T520-SO Unified Wire Storage Controller" },
		Device { id: 0x5608, name: "T520-CX Unified Wire Storage Controller" },
		Device { id: 0x5609, name: "T520-BT Unified Wire Storage Controller" },
		Device { id: 0x560A, name: "T504-BT Unified Wire Storage Controller" },
		Device { id: 0x560B, name: "B520-SR Unified Wire Storage Controller" },
		Device { id: 0x560C, name: "B504-BT Unified Wire Storage Controller" },
		Device { id: 0x560D, name: "T580-CR Unified Wire Storage Controller" },
		Device { id: 0x560E, name: "T540-LP-CR Unified Wire Storage Controller" },
		Device { id: 0x560F, name: "T540 [Amsterdam] Unified Wire Storage Controller" },
		Device { id: 0x5610, name: "T580-LP-CR Unified Wire Storage Controller" },
		Device { id: 0x5611, name: "T520-LL-CR Unified Wire Storage Controller" },
		Device { id: 0x5612, name: "T560-CR Unified Wire Storage Controller" },
		Device { id: 0x5613, name: "T580-CHR Unified Wire Storage Controller" },
		Device { id: 0x5614, name: "T580-SO-CR Unified Wire Storage Controller" },
		Device { id: 0x5615, name: "T502-BT Unified Wire Storage Controller" },
		Device { id: 0x5616, name: "T580-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x5617, name: "T520-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x5618, name: "T540-BT Unified Wire Storage Controller" },
		Device { id: 0x5680, name: "T540-5080 Unified Wire Storage Controller" },
		Device { id: 0x5681, name: "T540-5081 Unified Wire Storage Controller" },
		Device { id: 0x5682, name: "T504-5082 Unified Wire Storage Controller" },
		Device { id: 0x5683, name: "T540-5083 Unified Wire Storage Controller" },
		Device { id: 0x5684, name: "T540-5084 Unified Wire Storage Controller" },
		Device { id: 0x5685, name: "T580-5085 Unified Wire Storage Controller" },
		Device { id: 0x5686, name: "T580-5086 Unified Wire Storage Controller" },
		Device { id: 0x5687, name: "T580-5087 Unified Wire Storage Controller" },
		Device { id: 0x5688, name: "T570-5088 Unified Wire Storage Controller" },
		Device { id: 0x5689, name: "T520-5089 Unified Wire Storage Controller" },
		Device { id: 0x5690, name: "T540-5090 Unified Wire Storage Controller" },
		Device { id: 0x5691, name: "T522-5091 Unified Wire Storage Controller" },
		Device { id: 0x5692, name: "T520-5092 Unified Wire Storage Controller" },
		Device { id: 0x5693, name: "T580-5093 Unified Wire Storage Controller" },
		Device { id: 0x5694, name: "T540-5094 Unified Wire Storage Controller" },
		Device { id: 0x5695, name: "T540-5095 Unified Wire Storage Controller" },
		Device { id: 0x5696, name: "T580-5096 Unified Wire Storage Controller" },
		Device { id: 0x5697, name: "T520-5097 Unified Wire Storage Controller" },
		Device { id: 0x5698, name: "T580-5098 Unified Wire Storage Controller" },
		Device { id: 0x5699, name: "T580-5099 Unified Wire Storage Controller" },
		Device { id: 0x569A, name: "T520-509A Unified Wire Storage Controller" },
		Device { id: 0x569B, name: "T540-509B Unified Wire Storage Controller" },
		Device { id: 0x569C, name: "T520-509C Unified Wire Storage Controller" },
		Device { id: 0x569D, name: "T540-509D Unified Wire Storage Controller" },
		Device { id: 0x569E, name: "T520-509E Unified Wire Storage Controller" },
		Device { id: 0x569F, name: "T540-509F Unified Wire Storage Controller" },
		Device { id: 0x56A0, name: "T540-50A0 Unified Wire Storage Controller" },
		Device { id: 0x56A1, name: "T540-50A1 Unified Wire Storage Controller" },
		Device { id: 0x56A2, name: "T580-50A2 Unified Wire Storage Controller" },
		Device { id: 0x56A3, name: "T580-50A3 Unified Wire Storage Controller" },
		Device { id: 0x56A4, name: "T540-50A4 Unified Wire Storage Controller" },
		Device { id: 0x56A5, name: "T522-50A5 Unified Wire Storage Controller" },
		Device { id: 0x56A6, name: "T522-50A6 Unified Wire Storage Controller" },
		Device { id: 0x56A7, name: "T580-50A7 Unified Wire Storage Controller" },
		Device { id: 0x56A8, name: "T580-50A8 Unified Wire Storage Controller" },
		Device { id: 0x56A9, name: "T580-50A9 Unified Wire Storage Controller" },
		Device { id: 0x56AA, name: "T580-50AA Unified Wire Storage Controller" },
		Device { id: 0x56AB, name: "T520-50AB Unified Wire Storage Controller" },
		Device { id: 0x5701, name: "T520-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5702, name: "T522-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5703, name: "T540-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5704, name: "T520-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x5705, name: "T540-BCH Unified Wire Ethernet Controller" },
		Device { id: 0x5706, name: "T540-CH Unified Wire Ethernet Controller" },
		Device { id: 0x5707, name: "T520-SO Unified Wire Ethernet Controller" },
		Device { id: 0x5708, name: "T520-CX Unified Wire Ethernet Controller" },
		Device { id: 0x5709, name: "T520-BT Unified Wire Ethernet Controller" },
		Device { id: 0x570A, name: "T504-BT Unified Wire Ethernet Controller" },
		Device { id: 0x570B, name: "B520-SR Unified Wire Ethernet Controller" },
		Device { id: 0x570C, name: "B504-BT Unified Wire Ethernet Controller" },
		Device { id: 0x570D, name: "T580-CR Unified Wire Ethernet Controller" },
		Device { id: 0x570E, name: "T540-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x570F, name: "T540 [Amsterdam] Unified Wire Ethernet Controller" },
		Device { id: 0x5710, name: "T580-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5711, name: "T520-LL-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5712, name: "T560-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5713, name: "T580-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5714, name: "T580-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x5715, name: "T502-BT Unified Wire Ethernet Controller" },
		Device { id: 0x5780, name: "T540-5080 Unified Wire Ethernet Controller" },
		Device { id: 0x5781, name: "T540-5081 Unified Wire Ethernet Controller" },
		Device { id: 0x5782, name: "T504-5082 Unified Wire Ethernet Controller" },
		Device { id: 0x5783, name: "T540-5083 Unified Wire Ethernet Controller" },
		Device { id: 0x5784, name: "T580-5084 Unified Wire Ethernet Controller" },
		Device { id: 0x5785, name: "T580-5085 Unified Wire Ethernet Controller" },
		Device { id: 0x5786, name: "T580-5086 Unified Wire Ethernet Controller" },
		Device { id: 0x5787, name: "T580-5087 Unified Wire Ethernet Controller" },
		Device { id: 0x5788, name: "T570-5088 Unified Wire Ethernet Controller" },
		Device { id: 0x5789, name: "T520-5089 Unified Wire Ethernet Controller" },
		Device { id: 0x5790, name: "T540-5090 Unified Wire Ethernet Controller" },
		Device { id: 0x5791, name: "T522-5091 Unified Wire Ethernet Controller" },
		Device { id: 0x5792, name: "T520-5092 Unified Wire Ethernet Controller" },
		Device { id: 0x5793, name: "T580-5093 Unified Wire Ethernet Controller" },
		Device { id: 0x5794, name: "T540-5094 Unified Wire Ethernet Controller" },
		Device { id: 0x5795, name: "T540-5095 Unified Wire Ethernet Controller" },
		Device { id: 0x5796, name: "T580-5096 Unified Wire Ethernet Controller" },
		Device { id: 0x5797, name: "T520-5097 Unified Wire Ethernet Controller" },
		Device { id: 0x5801, name: "T520-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5802, name: "T522-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5803, name: "T540-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5804, name: "T520-BCH Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5805, name: "T540-BCH Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5806, name: "T540-CH Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5807, name: "T520-SO Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5808, name: "T520-CX Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5809, name: "T520-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x580A, name: "T504-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x580B, name: "B520-SR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x580C, name: "B504-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x580D, name: "T580-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x580E, name: "T540-LP-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x580F, name: "T540 [Amsterdam] Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5810, name: "T580-LP-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5811, name: "T520-LL-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5812, name: "T560-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5813, name: "T580-CHR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5814, name: "T580-SO-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5815, name: "T502-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5816, name: "T580-OCP-SO Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5817, name: "T520-OCP-SO Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5818, name: "T540-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5880, name: "T540-5080 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5881, name: "T540-5081 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5882, name: "T504-5082 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5883, name: "T540-5083 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5884, name: "T540-5084 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5885, name: "T580-5085 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5886, name: "T580-5086 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5887, name: "T580-5087 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5888, name: "T570-5088 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5889, name: "T520-5089 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5890, name: "T540-5090 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5891, name: "T522-5091 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5892, name: "T520-5092 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5893, name: "T580-5093 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5894, name: "T540-5094 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5895, name: "T540-5095 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5896, name: "T580-5096 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5897, name: "T520-5097 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5898, name: "T580-5098 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x5899, name: "T580-5099 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x589A, name: "T520-509A Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x589B, name: "T540-509B Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x589C, name: "T520-509C Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x589D, name: "T540-509D Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x589E, name: "T520-509E Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x589F, name: "T540-509F Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A0, name: "T540-50A0 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A1, name: "T540-50A1 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A2, name: "T580-50A2 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A3, name: "T580-50A3 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A4, name: "T540-50A4 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A5, name: "T522-50A5 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A6, name: "T522-50A6 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A7, name: "T580-50A7 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A8, name: "T580-50A8 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58A9, name: "T580-50A9 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58AA, name: "T580-50AA Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x58AB, name: "T520-50AB Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6001, name: "T6225-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6002, name: "T6225-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6003, name: "T6425-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6004, name: "T6425-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6005, name: "T6225-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x6006, name: "T62100-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x6007, name: "T62100-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6008, name: "T62100-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6009, name: "T6210-BT Unified Wire Ethernet Controller" },
		Device { id: 0x600D, name: "T62100-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6011, name: "T6225-LL-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6014, name: "T61100-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x6015, name: "T6201-BT Unified Wire Ethernet Controller" },
		Device { id: 0x6080, name: "T6225-6080 Unified Wire Ethernet Controller" },
		Device { id: 0x6081, name: "T62100-6081 Unified Wire Ethernet Controller" },
		Device { id: 0x6082, name: "T6225-6082 Unified Wire Ethernet Controller" },
		Device { id: 0x6083, name: "T62100-6083 Unified Wire Ethernet Controller" },
		Device { id: 0x6084, name: "T64100-6084 Unified Wire Ethernet Controller" },
		Device { id: 0x6085, name: "T6240-6085 Unified Wire Ethernet Controller" },
		Device { id: 0x6086, name: "T6225-6086 Unified Wire Ethernet Controller" },
		Device { id: 0x6401, name: "T6225-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6402, name: "T6225-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6403, name: "T6425-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6404, name: "T6425-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6405, name: "T6225-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x6406, name: "T62100-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x6407, name: "T62100-LP-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6408, name: "T62100-SO-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6409, name: "T6210-BT Unified Wire Ethernet Controller" },
		Device { id: 0x640D, name: "T62100-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6411, name: "T6225-LL-CR Unified Wire Ethernet Controller" },
		Device { id: 0x6414, name: "T61100-OCP-SO Unified Wire Ethernet Controller" },
		Device { id: 0x6415, name: "T6201-BT Unified Wire Ethernet Controller" },
		Device { id: 0x6480, name: "T6225-6080 Unified Wire Ethernet Controller" },
		Device { id: 0x6481, name: "T62100-6081 Unified Wire Ethernet Controller" },
		Device { id: 0x6482, name: "T6225-6082 Unified Wire Ethernet Controller" },
		Device { id: 0x6483, name: "T62100-6083 Unified Wire Ethernet Controller" },
		Device { id: 0x6484, name: "T64100-6084 Unified Wire Ethernet Controller" },
		Device { id: 0x6485, name: "T6240-6085 Unified Wire Ethernet Controller" },
		Device { id: 0x6486, name: "T6225-6086 Unified Wire Ethernet Controller" },
		Device { id: 0x6501, name: "T6225-CR Unified Wire Storage Controller" },
		Device { id: 0x6502, name: "T6225-SO-CR Unified Wire Storage Controller" },
		Device { id: 0x6503, name: "T6425-CR Unified Wire Storage Controller" },
		Device { id: 0x6504, name: "T6425-SO-CR Unified Wire Storage Controller" },
		Device { id: 0x6505, name: "T6225-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x6506, name: "T62100-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x6507, name: "T62100-LP-CR Unified Wire Storage Controller" },
		Device { id: 0x6508, name: "T62100-SO-CR Unified Wire Storage Controller" },
		Device { id: 0x6509, name: "T6210-BT Unified Wire Storage Controller" },
		Device { id: 0x650D, name: "T62100-CR Unified Wire Storage Controller" },
		Device { id: 0x6511, name: "T6225-LL-CR Unified Wire Storage Controller" },
		Device { id: 0x6514, name: "T61100-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x6515, name: "T6201-BT Unified Wire Storage Controller" },
		Device { id: 0x6580, name: "T6225-6080 Unified Wire Storage Controller" },
		Device { id: 0x6581, name: "T62100-6081 Unified Wire Storage Controller" },
		Device { id: 0x6582, name: "T6225-6082 Unified Wire Storage Controller" },
		Device { id: 0x6583, name: "T62100-6083 Unified Wire Storage Controller" },
		Device { id: 0x6584, name: "T64100-6084 Unified Wire Storage Controller" },
		Device { id: 0x6585, name: "T6240-6085 Unified Wire Storage Controller" },
		Device { id: 0x6586, name: "T6225-6086 Unified Wire Storage Controller" },
		Device { id: 0x6601, name: "T6225-CR Unified Wire Storage Controller" },
		Device { id: 0x6602, name: "T6225-SO-CR Unified Wire Storage Controller" },
		Device { id: 0x6603, name: "T6425-CR Unified Wire Storage Controller" },
		Device { id: 0x6604, name: "T6425-SO-CR Unified Wire Storage Controller" },
		Device { id: 0x6605, name: "T6225-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x6606, name: "T62100-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x6607, name: "T62100-LP-CR Unified Wire Storage Controller" },
		Device { id: 0x6608, name: "T62100-SO-CR Unified Wire Storage Controller" },
		Device { id: 0x6609, name: "T6210-BT Unified Wire Storage Controller" },
		Device { id: 0x660D, name: "T62100-CR Unified Wire Storage Controller" },
		Device { id: 0x6611, name: "T6225-LL-CR Unified Wire Storage Controller" },
		Device { id: 0x6614, name: "T61100-OCP-SO Unified Wire Storage Controller" },
		Device { id: 0x6615, name: "T6201-BT Unified Wire Storage Controller" },
		Device { id: 0x6680, name: "T6225-6080 Unified Wire Storage Controller" },
		Device { id: 0x6681, name: "T62100-6081 Unified Wire Storage Controller" },
		Device { id: 0x6682, name: "T6225-6082 Unified Wire Storage Controller" },
		Device { id: 0x6683, name: "T62100-6083 Unified Wire Storage Controller" },
		Device { id: 0x6684, name: "T64100-6084 Unified Wire Storage Controller" },
		Device { id: 0x6685, name: "T6240-6085 Unified Wire Storage Controller" },
		Device { id: 0x6686, name: "T6225-6086 Unified Wire Storage Controller" },
		Device { id: 0x6801, name: "T6225-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6802, name: "T6225-SO-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6803, name: "T6425-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6804, name: "T6425-SO-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6805, name: "T6225-OCP-SO Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6806, name: "T62100-OCP-SO Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6807, name: "T62100-LP-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6808, name: "T62100-SO-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6809, name: "T6210-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x680D, name: "T62100-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6811, name: "T6225-LL-CR Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6814, name: "T61100-OCP-SO Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6815, name: "T6201-BT Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6880, name: "T6225-6080 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6881, name: "T62100-6081 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6882, name: "T6225-6082 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6883, name: "T62100-6083 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6884, name: "T64100-6084 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6885, name: "T6240-6085 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0x6886, name: "T6225-6086 Unified Wire Ethernet Controller [VF]" },
		Device { id: 0xA000, name: "PE10K Unified Wire Ethernet Controller" },
	] },
	Vendor { id: 0x1426, name: "Storage Technology Corp.", devices: &[
	] },
	Vendor { id: 0x1427, name: "Better On-Line Solutions", devices: &[
	] },
	Vendor { id: 0x1428, name: "Edec Co Ltd", devices: &[
	] },
	Vendor { id: 0x1429, name: "Unex Technology Corp.", devices: &[
	] },
	Vendor { id: 0x142A, name: "Kingmax Technology Inc", devices: &[
	] },
	Vendor { id: 0x142B, name: "Radiolan", devices: &[
	] },
	Vendor { id: 0x142C, name: "Minton Optic Industry Co Ltd", devices: &[
	] },
	Vendor { id: 0x142D, name: "Pix stream Inc", devices: &[
	] },
	Vendor { id: 0x142E, name: "Vitec Multimedia", devices: &[
		Device { id: 0x4020, name: "VM2-2 [Video Maker 2] MPEG1/2 Encoder" },
		Device { id: 0x4337, name: "VM2-2-C7 [Video Maker 2 rev. C7] MPEG1/2 Encoder" },
	] },
	Vendor { id: 0x142F, name: "Radicom Research Inc", devices: &[
	] },
	Vendor { id: 0x1430, name: "ITT Aerospace/Communications Division", devices: &[
	] },
	Vendor { id: 0x1431, name: "Gilat Satellite Networks", devices: &[
	] },
	Vendor { id: 0x1432, name: "Edimax Computer Co.", devices: &[
		Device { id: 0x9130, name: "RTL81xx Fast Ethernet" },
	] },
	Vendor { id: 0x1433, name: "Eltec Elektronik GmbH", devices: &[
	] },
	Vendor { id: 0x1435, name: "RTD Embedded Technologies, Inc.", devices: &[
		Device { id: 0x4520, name: "PCI4520" },
		Device { id: 0x6020, name: "SPM6020" },
		Device { id: 0x6030, name: "SPM6030" },
		Device { id: 0x6420, name: "SPM186420" },
		Device { id: 0x6430, name: "SPM176430" },
		Device { id: 0x6431, name: "SPM176431" },
		Device { id: 0x7520, name: "DM7520" },
		Device { id: 0x7540, name: "SDM7540" },
		Device { id: 0x7820, name: "DM7820" },
	] },
	Vendor { id: 0x1436, name: "CIS Technology Inc", devices: &[
	] },
	Vendor { id: 0x1437, name: "Nissin Inc Co", devices: &[
	] },
	Vendor { id: 0x1438, name: "Atmel-dream", devices: &[
	] },
	Vendor { id: 0x1439, name: "Outsource Engineering & Mfg. Inc", devices: &[
	] },
	Vendor { id: 0x143A, name: "Stargate Solutions Inc", devices: &[
	] },
	Vendor { id: 0x143B, name: "Canon Research Center, America", devices: &[
	] },
	Vendor { id: 0x143C, name: "Amlogic Inc", devices: &[
	] },
	Vendor { id: 0x143D, name: "Tamarack Microelectronics Inc", devices: &[
	] },
	Vendor { id: 0x143E, name: "Jones Futurex Inc", devices: &[
	] },
	Vendor { id: 0x143F, name: "Lightwell Co Ltd - Zax Division", devices: &[
	] },
	Vendor { id: 0x1440, name: "ALGOL Corp.", devices: &[
	] },
	Vendor { id: 0x1441, name: "AGIE Ltd", devices: &[
	] },
	Vendor { id: 0x1442, name: "Phoenix Contact GmbH & Co.", devices: &[
	] },
	Vendor { id: 0x1443, name: "Unibrain S.A.", devices: &[
	] },
	Vendor { id: 0x1444, name: "TRW", devices: &[
	] },
	Vendor { id: 0x1445, name: "Logical DO Ltd", devices: &[
	] },
	Vendor { id: 0x1446, name: "Graphin Co Ltd", devices: &[
	] },
	Vendor { id: 0x1447, name: "AIM GmBH", devices: &[
	] },
	Vendor { id: 0x1448, name: "Alesis Studio Electronics", devices: &[
	] },
	Vendor { id: 0x1449, name: "TUT Systems Inc", devices: &[
	] },
	Vendor { id: 0x144A, name: "Adlink Technology", devices: &[
		Device { id: 0x6208, name: "PCI-6208V" },
		Device { id: 0x7250, name: "PCI-7250" },
		Device { id: 0x7296, name: "PCI-7296" },
		Device { id: 0x7432, name: "PCI-7432" },
		Device { id: 0x7433, name: "PCI-7433" },
		Device { id: 0x7434, name: "PCI-7434" },
		Device { id: 0x7841, name: "PCI-7841" },
		Device { id: 0x8133, name: "PCI-8133" },
		Device { id: 0x8164, name: "PCI-8164" },
		Device { id: 0x8554, name: "PCI-8554" },
		Device { id: 0x9111, name: "PCI-9111" },
		Device { id: 0x9113, name: "PCI-9113" },
		Device { id: 0x9114, name: "PCI-9114" },
		Device { id: 0xA001, name: "ADi-BSEC" },
	] },
	Vendor { id: 0x144B, name: "Verint Systems Inc.", devices: &[
	] },
	Vendor { id: 0x144C, name: "Catalina Research Inc", devices: &[
	] },
	Vendor { id: 0x144D, name: "Samsung Electronics Co Ltd", devices: &[
		Device { id: 0x1600, name: "Apple PCIe SSD" },
		Device { id: 0xA800, name: "XP941 PCIe SSD" },
		Device { id: 0xA802, name: "NVMe SSD Controller SM951/PM951" },
		Device { id: 0xA804, name: "NVMe SSD Controller SM961/PM961" },
		Device { id: 0xA820, name: "NVMe SSD Controller 171X" },
		Device { id: 0xA821, name: "NVMe SSD Controller 172X" },
		Device { id: 0xA822, name: "NVMe SSD Controller 172Xa" },
	] },
	Vendor { id: 0x144E, name: "OLITEC", devices: &[
	] },
	Vendor { id: 0x144F, name: "Askey Computer Corp.", devices: &[
	] },
	Vendor { id: 0x1450, name: "Octave Communications Ind.", devices: &[
	] },
	Vendor { id: 0x1451, name: "SP3D Chip Design GmBH", devices: &[
	] },
	Vendor { id: 0x1453, name: "MYCOM Inc", devices: &[
	] },
	Vendor { id: 0x1454, name: "Altiga Networks", devices: &[
	] },
	Vendor { id: 0x1455, name: "Logic Plus Plus Inc", devices: &[
	] },
	Vendor { id: 0x1456, name: "Advanced Hardware Architectures", devices: &[
	] },
	Vendor { id: 0x1457, name: "Nuera Communications Inc", devices: &[
	] },
	Vendor { id: 0x1458, name: "Gigabyte Technology Co., Ltd", devices: &[
	] },
	Vendor { id: 0x1459, name: "DOOIN Electronics", devices: &[
	] },
	Vendor { id: 0x145A, name: "Escalate Networks Inc", devices: &[
	] },
	Vendor { id: 0x145B, name: "PRAIM SRL", devices: &[
	] },
	Vendor { id: 0x145C, name: "Cryptek", devices: &[
	] },
	Vendor { id: 0x145D, name: "Gallant Computer Inc", devices: &[
	] },
	Vendor { id: 0x145E, name: "Aashima Technology B.V.", devices: &[
	] },
	Vendor { id: 0x145F, name: "Baldor Electric Company", devices: &[
		Device { id: 0x0001, name: "NextMove PCI" },
	] },
	Vendor { id: 0x1460, name: "DYNARC INC", devices: &[
	] },
	Vendor { id: 0x1461, name: "Avermedia Technologies Inc", devices: &[
		Device { id: 0xA3CE, name: "M179" },
		Device { id: 0xA3CF, name: "M179" },
		Device { id: 0xA836, name: "M115 DVB-T, PAL/SECAM/NTSC Tuner" },
		Device { id: 0xE836, name: "M115S Hybrid Analog/DVB PAL/SECAM/NTSC Tuner" },
		Device { id: 0xF436, name: "AVerTV Hybrid+FM" },
	] },
	Vendor { id: 0x1462, name: "Micro-Star International Co., Ltd. [MSI]", devices: &[
		Device { id: 0xAAF0, name: "Radeon RX 580 Gaming X 8G" },
	] },
	Vendor { id: 0x1463, name: "Fast Corporation", devices: &[
	] },
	Vendor { id: 0x1464, name: "Interactive Circuits & Systems Ltd", devices: &[
	] },
	Vendor { id: 0x1465, name: "GN NETTEST Telecom DIV.", devices: &[
	] },
	Vendor { id: 0x1466, name: "Designpro Inc.", devices: &[
	] },
	Vendor { id: 0x1467, name: "DIGICOM SPA", devices: &[
	] },
	Vendor { id: 0x1468, name: "AMBIT Microsystem Corp.", devices: &[
	] },
	Vendor { id: 0x1469, name: "Cleveland Motion Controls", devices: &[
	] },
	Vendor { id: 0x146A, name: "Aeroflex", devices: &[
		Device { id: 0x3010, name: "3010 RF Synthesizer" },
		Device { id: 0x3A11, name: "3011A PXI RF Synthesizer" },
	] },
	Vendor { id: 0x146B, name: "Parascan Technologies Ltd", devices: &[
	] },
	Vendor { id: 0x146C, name: "Ruby Tech Corp.", devices: &[
		Device { id: 0x1430, name: "FE-1430TX Fast Ethernet PCI Adapter" },
	] },
	Vendor { id: 0x146D, name: "Tachyon, INC.", devices: &[
	] },
	Vendor { id: 0x146E, name: "Williams Electronics Games, Inc.", devices: &[
	] },
	Vendor { id: 0x146F, name: "Multi Dimensional Consulting Inc", devices: &[
	] },
	Vendor { id: 0x1470, name: "Bay Networks", devices: &[
	] },
	Vendor { id: 0x1471, name: "Integrated Telecom Express Inc", devices: &[
	] },
	Vendor { id: 0x1472, name: "DAIKIN Industries, Ltd", devices: &[
	] },
	Vendor { id: 0x1473, name: "ZAPEX Technologies Inc", devices: &[
	] },
	Vendor { id: 0x1474, name: "Doug Carson & Associates", devices: &[
	] },
	Vendor { id: 0x1475, name: "PICAZO Communications", devices: &[
	] },
	Vendor { id: 0x1476, name: "MORTARA Instrument Inc", devices: &[
	] },
	Vendor { id: 0x1477, name: "Net Insight", devices: &[
	] },
	Vendor { id: 0x1478, name: "DIATREND Corporation", devices: &[
	] },
	Vendor { id: 0x1479, name: "TORAY Industries Inc", devices: &[
	] },
	Vendor { id: 0x147A, name: "FORMOSA Industrial Computing", devices: &[
	] },
	Vendor { id: 0x147B, name: "ABIT Computer Corp.", devices: &[
		Device { id: 0x1084, name: "IP35 [Dark Raider]" },
	] },
	Vendor { id: 0x147C, name: "AWARE, Inc.", devices: &[
	] },
	Vendor { id: 0x147D, name: "Interworks Computer Products", devices: &[
	] },
	Vendor { id: 0x147E, name: "Matsushita Graphic Communication Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x147F, name: "NIHON UNISYS, Ltd.", devices: &[
	] },
	Vendor { id: 0x1480, name: "SCII Telecom", devices: &[
	] },
	Vendor { id: 0x1481, name: "BIOPAC Systems Inc", devices: &[
	] },
	Vendor { id: 0x1482, name: "ISYTEC - Integrierte Systemtechnik GmBH", devices: &[
		Device { id: 0x0001, name: "PCI-16 Host Interface for ITC-16" },
	] },
	Vendor { id: 0x1483, name: "LABWAY Corporation", devices: &[
	] },
	Vendor { id: 0x1484, name: "Logic Corporation", devices: &[
	] },
	Vendor { id: 0x1485, name: "ERMA - Electronic GmBH", devices: &[
	] },
	Vendor { id: 0x1486, name: "L3 Communications Telemetry & Instrumentation", devices: &[
	] },
	Vendor { id: 0x1487, name: "MARQUETTE Medical Systems", devices: &[
	] },
	Vendor { id: 0x1489, name: "KYE Systems Corporation", devices: &[
	] },
	Vendor { id: 0x148A, name: "OPTO", devices: &[
	] },
	Vendor { id: 0x148B, name: "INNOMEDIALOGIC Inc.", devices: &[
	] },
	Vendor { id: 0x148C, name: "Tul Corporation / PowerColor", devices: &[
	] },
	Vendor { id: 0x148D, name: "DIGICOM Systems, Inc.", devices: &[
		Device { id: 0x1003, name: "HCF 56k Data/Fax Modem" },
	] },
	Vendor { id: 0x148E, name: "OSI Plus Corporation", devices: &[
	] },
	Vendor { id: 0x148F, name: "Plant Equipment, Inc.", devices: &[
	] },
	Vendor { id: 0x1490, name: "Stone Microsystems PTY Ltd.", devices: &[
	] },
	Vendor { id: 0x1491, name: "ZEAL Corporation", devices: &[
	] },
	Vendor { id: 0x1492, name: "Time Logic Corporation", devices: &[
	] },
	Vendor { id: 0x1493, name: "MAKER Communications", devices: &[
	] },
	Vendor { id: 0x1494, name: "WINTOP Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x1495, name: "TOKAI Communications Industry Co. Ltd", devices: &[
	] },
	Vendor { id: 0x1496, name: "JOYTECH Computer Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1497, name: "SMA Regelsysteme GmBH", devices: &[
		Device { id: 0x1497, name: "SMA Technologie AG" },
	] },
	Vendor { id: 0x1498, name: "TEWS Technologies GmbH", devices: &[
		Device { id: 0x0330, name: "TPMC816 2 Channel CAN bus controller." },
		Device { id: 0x035D, name: "TPMC861 4-Channel Isolated Serial Interface RS422/RS485" },
		Device { id: 0x0385, name: "TPMC901 Extended CAN bus with 2/4/6 CAN controller" },
		Device { id: 0x21CC, name: "TCP460 CompactPCI 16 Channel Serial Interface RS232/RS422" },
		Device { id: 0x21CD, name: "TCP461 CompactPCI 8 Channel Serial Interface RS232/RS422" },
		Device { id: 0x3064, name: "TPCI100 (2 Slot IndustryPack PCI Carrier)" },
		Device { id: 0x30C8, name: "TPCI200 4 Slot IndustryPack PCI Carrier" },
		Device { id: 0x70C8, name: "TPCE200 4 Slot IndustryPack PCIe Carrier" },
		Device { id: 0x9177, name: "TXMC375 8 channel RS232/RS422/RS485 programmable serial interface" },
	] },
	Vendor { id: 0x1499, name: "EMTEC CO., Ltd", devices: &[
	] },
	Vendor { id: 0x149A, name: "ANDOR Technology Ltd", devices: &[
	] },
	Vendor { id: 0x149B, name: "SEIKO Instruments Inc", devices: &[
	] },
	Vendor { id: 0x149C, name: "OVISLINK Corp.", devices: &[
	] },
	Vendor { id: 0x149D, name: "NEWTEK Inc", devices: &[
		Device { id: 0x0001, name: "Video Toaster for PC" },
	] },
	Vendor { id: 0x149E, name: "Mapletree Networks Inc.", devices: &[
	] },
	Vendor { id: 0x149F, name: "LECTRON Co Ltd", devices: &[
	] },
	Vendor { id: 0x14A0, name: "SOFTING GmBH", devices: &[
	] },
	Vendor { id: 0x14A1, name: "Systembase Co Ltd", devices: &[
	] },
	Vendor { id: 0x14A2, name: "Millennium Engineering Inc", devices: &[
	] },
	Vendor { id: 0x14A3, name: "Maverick Networks", devices: &[
	] },
	Vendor { id: 0x14A4, name: "Lite-On Technology Corporation", devices: &[
		Device { id: 0x22F1, name: "M8Pe Series NVMe SSD" },
		Device { id: 0x4318, name: "Broadcom BCM4318 [AirForce One 54g] 802.11g WLAN Controller" },
	] },
	Vendor { id: 0x14A5, name: "XIONICS Document Technologies Inc", devices: &[
	] },
	Vendor { id: 0x14A6, name: "INOVA Computers GmBH & Co KG", devices: &[
	] },
	Vendor { id: 0x14A7, name: "MYTHOS Systems Inc", devices: &[
	] },
	Vendor { id: 0x14A8, name: "FEATRON Technologies Corporation", devices: &[
	] },
	Vendor { id: 0x14A9, name: "HIVERTEC Inc", devices: &[
	] },
	Vendor { id: 0x14AA, name: "Advanced MOS Technology Inc", devices: &[
	] },
	Vendor { id: 0x14AB, name: "Mentor Graphics Corp.", devices: &[
	] },
	Vendor { id: 0x14AC, name: "Novaweb Technologies Inc", devices: &[
	] },
	Vendor { id: 0x14AD, name: "Time Space Radio AB", devices: &[
	] },
	Vendor { id: 0x14AE, name: "CTI, Inc", devices: &[
	] },
	Vendor { id: 0x14AF, name: "Guillemot Corporation", devices: &[
		Device { id: 0x7102, name: "3D Prophet II MX" },
	] },
	Vendor { id: 0x14B0, name: "BST Communication Technology Ltd", devices: &[
	] },
	Vendor { id: 0x14B1, name: "Nextcom K.K.", devices: &[
	] },
	Vendor { id: 0x14B2, name: "ENNOVATE Networks Inc", devices: &[
	] },
	Vendor { id: 0x14B3, name: "XPEED Inc", devices: &[
		Device { id: 0x0000, name: "DSL NIC" },
	] },
	Vendor { id: 0x14B4, name: "PHILIPS Business Electronics B.V.", devices: &[
	] },
	Vendor { id: 0x14B5, name: "Creamware GmBH", devices: &[
		Device { id: 0x0200, name: "Scope" },
		Device { id: 0x0300, name: "Pulsar" },
		Device { id: 0x0400, name: "PulsarSRB" },
		Device { id: 0x0600, name: "Pulsar2" },
		Device { id: 0x0800, name: "DSP-Board" },
		Device { id: 0x0900, name: "DSP-Board" },
		Device { id: 0x0A00, name: "DSP-Board" },
		Device { id: 0x0B00, name: "DSP-Board" },
	] },
	Vendor { id: 0x14B6, name: "Quantum Data Corp.", devices: &[
	] },
	Vendor { id: 0x14B7, name: "PROXIM Inc", devices: &[
		Device { id: 0x0001, name: "Symphony 4110" },
	] },
	Vendor { id: 0x14B8, name: "Techsoft Technology Co Ltd", devices: &[
	] },
	Vendor { id: 0x14B9, name: "Cisco Aironet Wireless Communications", devices: &[
		Device { id: 0x0001, name: "PC4800" },
		Device { id: 0x0340, name: "PC4800" },
		Device { id: 0x0350, name: "350 series 802.11b Wireless LAN Adapter" },
		Device { id: 0x4500, name: "PC4500" },
		Device { id: 0x4800, name: "Cisco Aironet 340 802.11b Wireless LAN Adapter/Aironet PC4800" },
		Device { id: 0xA504, name: "Cisco Aironet Wireless 802.11b" },
		Device { id: 0xA505, name: "Cisco Aironet CB20a 802.11a Wireless LAN Adapter" },
		Device { id: 0xA506, name: "Cisco Aironet Mini PCI b/g" },
	] },
	Vendor { id: 0x14BA, name: "INTERNIX Inc.", devices: &[
		Device { id: 0x0600, name: "ARC-PCI/22" },
	] },
	Vendor { id: 0x14BB, name: "SEMTECH Corporation", devices: &[
	] },
	Vendor { id: 0x14BC, name: "Globespan Semiconductor Inc.", devices: &[
		Device { id: 0xD002, name: "Pulsar [PCI ADSL Card]" },
		Device { id: 0xD00F, name: "Pulsar [PCI ADSL Card]" },
	] },
	Vendor { id: 0x14BD, name: "CARDIO Control N.V.", devices: &[
	] },
	Vendor { id: 0x14BE, name: "L3 Communications", devices: &[
	] },
	Vendor { id: 0x14BF, name: "SPIDER Communications Inc.", devices: &[
	] },
	Vendor { id: 0x14C0, name: "COMPAL Electronics Inc", devices: &[
	] },
	Vendor { id: 0x14C1, name: "MYRICOM Inc.", devices: &[
		Device { id: 0x0008, name: "Myri-10G Dual-Protocol NIC" },
		Device { id: 0x8043, name: "Myrinet 2000 Scalable Cluster Interconnect" },
	] },
	Vendor { id: 0x14C2, name: "DTK Computer", devices: &[
	] },
	Vendor { id: 0x14C3, name: "MEDIATEK Corp.", devices: &[
		Device { id: 0x7630, name: "MT7630e 802.11bgn Wireless Network Adapter" },
		Device { id: 0x7662, name: "MT7662E 802.11ac PCI Express Wireless Network Adapter" },
	] },
	Vendor { id: 0x14C4, name: "IWASAKI Information Systems Co Ltd", devices: &[
	] },
	Vendor { id: 0x14C5, name: "Automation Products AB", devices: &[
	] },
	Vendor { id: 0x14C6, name: "Data Race Inc", devices: &[
	] },
	Vendor { id: 0x14C7, name: "Modular Technology Holdings Ltd", devices: &[
	] },
	Vendor { id: 0x14C8, name: "Turbocomm Tech. Inc.", devices: &[
	] },
	Vendor { id: 0x14C9, name: "ODIN Telesystems Inc", devices: &[
	] },
	Vendor { id: 0x14CA, name: "PE Logic Corp.", devices: &[
	] },
	Vendor { id: 0x14CB, name: "Billionton Systems Inc", devices: &[
	] },
	Vendor { id: 0x14CC, name: "NAKAYO Telecommunications Inc", devices: &[
	] },
	Vendor { id: 0x14CD, name: "Universal Global Scientific Industrial Co.,Ltd", devices: &[
		Device { id: 0x0001, name: "USI-1514-1GbaseT [OCP1]" },
		Device { id: 0x0002, name: "USI-4227-SFP [OCP2]" },
		Device { id: 0x0003, name: "USI-X557-10GbaseT [OCP3]" },
	] },
	Vendor { id: 0x14CE, name: "Whistle Communications", devices: &[
	] },
	Vendor { id: 0x14CF, name: "TEK Microsystems Inc.", devices: &[
	] },
	Vendor { id: 0x14D0, name: "Ericsson Axe R & D", devices: &[
	] },
	Vendor { id: 0x14D1, name: "Computer Hi-Tech Co Ltd", devices: &[
	] },
	Vendor { id: 0x14D2, name: "Titan Electronics Inc", devices: &[
		Device { id: 0x8001, name: "VScom 010L 1 port parallel adaptor" },
		Device { id: 0x8002, name: "VScom 020L 2 port parallel adaptor" },
		Device { id: 0x8010, name: "VScom 100L 1 port serial adaptor" },
		Device { id: 0x8011, name: "VScom 110L 1 port serial and 1 port parallel adaptor" },
		Device { id: 0x8020, name: "VScom 200L 1 or 2 port serial adaptor" },
		Device { id: 0x8021, name: "VScom 210L 2 port serial and 1 port parallel adaptor" },
		Device { id: 0x8028, name: "VScom 200I/200I-SI 2-port serial adapter" },
		Device { id: 0x8040, name: "VScom 400L 4 port serial adaptor" },
		Device { id: 0x8043, name: "VScom 430L 4-port serial and 3-port parallel adapter" },
		Device { id: 0x8048, name: "VScom 400I 4-port serial adapter" },
		Device { id: 0x8080, name: "VScom 800L 8 port serial adaptor" },
		Device { id: 0x8088, name: "VScom 800I 8-port serial adapter" },
		Device { id: 0xA000, name: "VScom 010H 1 port parallel adaptor" },
		Device { id: 0xA001, name: "VScom 100H 1 port serial adaptor" },
		Device { id: 0xA003, name: "VScom 400H 4 port serial adaptor" },
		Device { id: 0xA004, name: "VScom 400HF1 4 port serial adaptor" },
		Device { id: 0xA005, name: "VScom 200H 2 port serial adaptor" },
		Device { id: 0xA007, name: "VScom PCI800EH (PCIe) 8-port serial adapter Port 1-4" },
		Device { id: 0xA008, name: "VScom PCI800EH (PCIe) 8-port serial adapter Port 5-8" },
		Device { id: 0xA009, name: "VScom PCI400EH (PCIe) 4-port serial adapter" },
		Device { id: 0xE001, name: "VScom 010HV2 1 port parallel adaptor" },
		Device { id: 0xE010, name: "VScom 100HV2 1 port serial adaptor" },
		Device { id: 0xE020, name: "VScom 200HV2 2 port serial adaptor" },
	] },
	Vendor { id: 0x14D3, name: "CIRTECH (UK) Ltd", devices: &[
	] },
	Vendor { id: 0x14D4, name: "Panacom Technology Corp", devices: &[
	] },
	Vendor { id: 0x14D5, name: "Nitsuko Corporation", devices: &[
	] },
	Vendor { id: 0x14D6, name: "Accusys Inc", devices: &[
		Device { id: 0x6101, name: "ACS-61xxx, PCIe to SAS/SATA RAID HBA" },
		Device { id: 0x6201, name: "ACS-62xxx, External PCIe to SAS/SATA RAID controller" },
	] },
	Vendor { id: 0x14D7, name: "Hirakawa Hewtech Corp", devices: &[
	] },
	Vendor { id: 0x14D8, name: "HOPF Elektronik GmBH", devices: &[
	] },
	Vendor { id: 0x14D9, name: "Alliance Semiconductor Corporation", devices: &[
		Device { id: 0x0010, name: "AP1011/SP1011 HyperTransport-PCI Bridge [Sturgeon]" },
		Device { id: 0x9000, name: "AS90L10204/10208 HyperTransport to PCI-X Bridge" },
	] },
	Vendor { id: 0x14DA, name: "National Aerospace Laboratories", devices: &[
	] },
	Vendor { id: 0x14DB, name: "AFAVLAB Technology Inc", devices: &[
		Device { id: 0x2120, name: "TK9902" },
		Device { id: 0x2182, name: "AFAVLAB Technology Inc. 8-port serial card" },
	] },
	Vendor { id: 0x14DC, name: "Amplicon Liveline Ltd", devices: &[
		Device { id: 0x0000, name: "PCI230" },
		Device { id: 0x0001, name: "PCI242" },
		Device { id: 0x0002, name: "PCI244" },
		Device { id: 0x0003, name: "PCI247" },
		Device { id: 0x0004, name: "PCI248" },
		Device { id: 0x0005, name: "PCI249" },
		Device { id: 0x0006, name: "PCI260" },
		Device { id: 0x0007, name: "PCI224" },
		Device { id: 0x0008, name: "PCI234" },
		Device { id: 0x0009, name: "PCI236" },
		Device { id: 0x000A, name: "PCI272" },
		Device { id: 0x000B, name: "PCI215" },
	] },
	Vendor { id: 0x14DD, name: "Boulder Design Labs Inc", devices: &[
	] },
	Vendor { id: 0x14DE, name: "Applied Integration Corporation", devices: &[
	] },
	Vendor { id: 0x14DF, name: "ASIC Communications Corp", devices: &[
	] },
	Vendor { id: 0x14E1, name: "INVERTEX", devices: &[
	] },
	Vendor { id: 0x14E2, name: "INFOLIBRIA", devices: &[
	] },
	Vendor { id: 0x14E3, name: "AMTELCO", devices: &[
	] },
	Vendor { id: 0x14E4, name: "Broadcom Limited", devices: &[
		Device { id: 0x0576, name: "BCM43224 802.11a/b/g/n" },
		Device { id: 0x0800, name: "Sentry5 Chipcommon I/O Controller" },
		Device { id: 0x0804, name: "Sentry5 PCI Bridge" },
		Device { id: 0x0805, name: "Sentry5 MIPS32 CPU" },
		Device { id: 0x0806, name: "Sentry5 Ethernet Controller" },
		Device { id: 0x080B, name: "Sentry5 Crypto Accelerator" },
		Device { id: 0x080F, name: "Sentry5 DDR/SDR RAM Controller" },
		Device { id: 0x0811, name: "Sentry5 External Interface Core" },
		Device { id: 0x0816, name: "BCM3302 Sentry5 MIPS32 CPU" },
		Device { id: 0x1570, name: "720p FaceTime HD Camera" },
		Device { id: 0x1600, name: "NetXtreme BCM5752 Gigabit Ethernet PCI Express" },
		Device { id: 0x1601, name: "NetXtreme BCM5752M Gigabit Ethernet PCI Express" },
		Device { id: 0x1612, name: "BCM70012 Video Decoder [Crystal HD]" },
		Device { id: 0x1615, name: "BCM70015 Video Decoder [Crystal HD]" },
		Device { id: 0x1639, name: "NetXtreme II BCM5709 Gigabit Ethernet" },
		Device { id: 0x163A, name: "NetXtreme II BCM5709S Gigabit Ethernet" },
		Device { id: 0x163B, name: "NetXtreme II BCM5716 Gigabit Ethernet" },
		Device { id: 0x163C, name: "NetXtreme II BCM5716S Gigabit Ethernet" },
		Device { id: 0x163D, name: "NetXtreme II BCM57811 10-Gigabit Ethernet" },
		Device { id: 0x163E, name: "NetXtreme II BCM57811 10 Gigabit Ethernet Multi Function" },
		Device { id: 0x163F, name: "NetXtreme II BCM57811 10-Gigabit Ethernet Virtual Function" },
		Device { id: 0x1641, name: "NetXtreme BCM57787 Gigabit Ethernet PCIe" },
		Device { id: 0x1642, name: "NetXtreme BCM57764 Gigabit Ethernet PCIe" },
		Device { id: 0x1643, name: "NetXtreme BCM5725 Gigabit Ethernet PCIe" },
		Device { id: 0x1644, name: "NetXtreme BCM5700 Gigabit Ethernet" },
		Device { id: 0x1645, name: "NetXtreme BCM5701 Gigabit Ethernet" },
		Device { id: 0x1646, name: "NetXtreme BCM5702 Gigabit Ethernet" },
		Device { id: 0x1647, name: "NetXtreme BCM5703 Gigabit Ethernet" },
		Device { id: 0x1648, name: "NetXtreme BCM5704 Gigabit Ethernet" },
		Device { id: 0x1649, name: "NetXtreme BCM5704S_2 Gigabit Ethernet" },
		Device { id: 0x164A, name: "NetXtreme II BCM5706 Gigabit Ethernet" },
		Device { id: 0x164C, name: "NetXtreme II BCM5708 Gigabit Ethernet" },
		Device { id: 0x164D, name: "NetXtreme BCM5702FE Gigabit Ethernet" },
		Device { id: 0x164E, name: "NetXtreme II BCM57710 10-Gigabit PCIe [Everest]" },
		Device { id: 0x164F, name: "NetXtreme II BCM57711 10-Gigabit PCIe" },
		Device { id: 0x1650, name: "NetXtreme II BCM57711E 10-Gigabit PCIe" },
		Device { id: 0x1653, name: "NetXtreme BCM5705 Gigabit Ethernet" },
		Device { id: 0x1654, name: "NetXtreme BCM5705_2 Gigabit Ethernet" },
		Device { id: 0x1655, name: "NetXtreme BCM5717 Gigabit Ethernet PCIe" },
		Device { id: 0x1656, name: "NetXtreme BCM5718 Gigabit Ethernet PCIe" },
		Device { id: 0x1657, name: "NetXtreme BCM5719 Gigabit Ethernet PCIe" },
		Device { id: 0x1659, name: "NetXtreme BCM5721 Gigabit Ethernet PCI Express" },
		Device { id: 0x165A, name: "NetXtreme BCM5722 Gigabit Ethernet PCI Express" },
		Device { id: 0x165B, name: "NetXtreme BCM5723 Gigabit Ethernet PCIe" },
		Device { id: 0x165C, name: "NetXtreme BCM5724 Gigabit Ethernet PCIe" },
		Device { id: 0x165D, name: "NetXtreme BCM5705M Gigabit Ethernet" },
		Device { id: 0x165E, name: "NetXtreme BCM5705M_2 Gigabit Ethernet" },
		Device { id: 0x165F, name: "NetXtreme BCM5720 Gigabit Ethernet PCIe" },
		Device { id: 0x1662, name: "NetXtreme II BCM57712 10 Gigabit Ethernet" },
		Device { id: 0x1663, name: "NetXtreme II BCM57712 10 Gigabit Ethernet Multi Function" },
		Device { id: 0x1665, name: "NetXtreme BCM5717 Gigabit Ethernet PCIe" },
		Device { id: 0x1668, name: "NetXtreme BCM5714 Gigabit Ethernet" },
		Device { id: 0x1669, name: "NetXtreme 5714S Gigabit Ethernet" },
		Device { id: 0x166A, name: "NetXtreme BCM5780 Gigabit Ethernet" },
		Device { id: 0x166B, name: "NetXtreme BCM5780S Gigabit Ethernet" },
		Device { id: 0x166E, name: "570x 10/100 Integrated Controller" },
		Device { id: 0x166F, name: "NetXtreme II BCM57712 10 Gigabit Ethernet Virtual Function" },
		Device { id: 0x1672, name: "NetXtreme BCM5754M Gigabit Ethernet PCI Express" },
		Device { id: 0x1673, name: "NetXtreme BCM5755M Gigabit Ethernet PCI Express" },
		Device { id: 0x1674, name: "NetXtreme BCM5756ME Gigabit Ethernet PCI Express" },
		Device { id: 0x1677, name: "NetXtreme BCM5751 Gigabit Ethernet PCI Express" },
		Device { id: 0x1678, name: "NetXtreme BCM5715 Gigabit Ethernet" },
		Device { id: 0x1679, name: "NetXtreme BCM5715S Gigabit Ethernet" },
		Device { id: 0x167A, name: "NetXtreme BCM5754 Gigabit Ethernet PCI Express" },
		Device { id: 0x167B, name: "NetXtreme BCM5755 Gigabit Ethernet PCI Express" },
		Device { id: 0x167D, name: "NetXtreme BCM5751M Gigabit Ethernet PCI Express" },
		Device { id: 0x167E, name: "NetXtreme BCM5751F Fast Ethernet PCI Express" },
		Device { id: 0x167F, name: "NetLink BCM5787F Fast Ethernet PCI Express" },
		Device { id: 0x1680, name: "NetXtreme BCM5761e Gigabit Ethernet PCIe" },
		Device { id: 0x1681, name: "NetXtreme BCM5761 Gigabit Ethernet PCIe" },
		Device { id: 0x1682, name: "NetXtreme BCM57762 Gigabit Ethernet PCIe" },
		Device { id: 0x1683, name: "NetXtreme BCM57767 Gigabit Ethernet PCIe" },
		Device { id: 0x1684, name: "NetXtreme BCM5764M Gigabit Ethernet PCIe" },
		Device { id: 0x1685, name: "NetXtreme II BCM57500S Gigabit Ethernet" },
		Device { id: 0x1686, name: "NetXtreme BCM57766 Gigabit Ethernet PCIe" },
		Device { id: 0x1687, name: "NetXtreme BCM5762 Gigabit Ethernet PCIe" },
		Device { id: 0x1688, name: "NetXtreme BCM5761 10/100/1000BASE-T Ethernet" },
		Device { id: 0x168A, name: "NetXtreme II BCM57800 1/10 Gigabit Ethernet" },
		Device { id: 0x168D, name: "NetXtreme II BCM57840 10/20 Gigabit Ethernet" },
		Device { id: 0x168E, name: "NetXtreme II BCM57810 10 Gigabit Ethernet" },
		Device { id: 0x1690, name: "NetXtreme BCM57760 Gigabit Ethernet PCIe" },
		Device { id: 0x1691, name: "NetLink BCM57788 Gigabit Ethernet PCIe" },
		Device { id: 0x1692, name: "NetLink BCM57780 Gigabit Ethernet PCIe" },
		Device { id: 0x1693, name: "NetLink BCM5787M Gigabit Ethernet PCI Express" },
		Device { id: 0x1694, name: "NetLink BCM57790 Gigabit Ethernet PCIe" },
		Device { id: 0x1696, name: "NetXtreme BCM5782 Gigabit Ethernet" },
		Device { id: 0x1698, name: "NetLink BCM5784M Gigabit Ethernet PCIe" },
		Device { id: 0x1699, name: "NetLink BCM5785 Gigabit Ethernet" },
		Device { id: 0x169A, name: "NetLink BCM5786 Gigabit Ethernet PCI Express" },
		Device { id: 0x169B, name: "NetLink BCM5787 Gigabit Ethernet PCI Express" },
		Device { id: 0x169C, name: "NetXtreme BCM5788 Gigabit Ethernet" },
		Device { id: 0x169D, name: "NetLink BCM5789 Gigabit Ethernet PCI Express" },
		Device { id: 0x16A0, name: "NetLink BCM5785 Fast Ethernet" },
		Device { id: 0x16A1, name: "BCM57840 NetXtreme II 10 Gigabit Ethernet" },
		Device { id: 0x16A2, name: "BCM57840 NetXtreme II 10/20-Gigabit Ethernet" },
		Device { id: 0x16A3, name: "NetXtreme BCM57786 Gigabit Ethernet PCIe" },
		Device { id: 0x16A4, name: "BCM57840 NetXtreme II Ethernet Multi Function" },
		Device { id: 0x16A5, name: "NetXtreme II BCM57800 1/10 Gigabit Ethernet Multi Function" },
		Device { id: 0x16A6, name: "NetXtreme BCM5702X Gigabit Ethernet" },
		Device { id: 0x16A7, name: "NetXtreme BCM5703X Gigabit Ethernet" },
		Device { id: 0x16A8, name: "NetXtreme BCM5704S Gigabit Ethernet" },
		Device { id: 0x16A9, name: "NetXtreme II BCM57800 1/10 Gigabit Ethernet Virtual Function" },
		Device { id: 0x16AA, name: "NetXtreme II BCM5706S Gigabit Ethernet" },
		Device { id: 0x16AB, name: "NetXtreme II BCM57840 10/20 Gigabit Ethernet Multi Function" },
		Device { id: 0x16AC, name: "NetXtreme II BCM5708S Gigabit Ethernet" },
		Device { id: 0x16AD, name: "NetXtreme II BCM57840 10/20 Gigabit Ethernet Virtual Function" },
		Device { id: 0x16AE, name: "NetXtreme II BCM57810 10 Gigabit Ethernet Multi Function" },
		Device { id: 0x16AF, name: "NetXtreme II BCM57810 10 Gigabit Ethernet Virtual Function" },
		Device { id: 0x16B0, name: "NetXtreme BCM57761 Gigabit Ethernet PCIe" },
		Device { id: 0x16B1, name: "NetLink BCM57781 Gigabit Ethernet PCIe" },
		Device { id: 0x16B2, name: "NetLink BCM57791 Gigabit Ethernet PCIe" },
		Device { id: 0x16B3, name: "NetXtreme BCM57786 Gigabit Ethernet PCIe" },
		Device { id: 0x16B4, name: "NetXtreme BCM57765 Gigabit Ethernet PCIe" },
		Device { id: 0x16B5, name: "NetLink BCM57785 Gigabit Ethernet PCIe" },
		Device { id: 0x16B6, name: "NetLink BCM57795 Gigabit Ethernet PCIe" },
		Device { id: 0x16B7, name: "NetXtreme BCM57782 Gigabit Ethernet PCIe" },
		Device { id: 0x16BC, name: "BCM57765/57785 SDXC/MMC Card Reader" },
		Device { id: 0x16BE, name: "BCM57765/57785 MS Card Reader" },
		Device { id: 0x16BF, name: "BCM57765/57785 xD-Picture Card Reader" },
		Device { id: 0x16C1, name: "NetXtreme-E RDMA Virtual Function" },
		Device { id: 0x16C6, name: "NetXtreme BCM5702A3 Gigabit Ethernet" },
		Device { id: 0x16C7, name: "NetXtreme BCM5703 Gigabit Ethernet" },
		Device { id: 0x16C8, name: "BCM57301 NetXtreme-C 10Gb Ethernet Controller" },
		Device { id: 0x16C9, name: "BCM57302 NetXtreme-C 10Gb/25Gb Ethernet Controller" },
		Device { id: 0x16CA, name: "BCM57304 NetXtreme-C 10Gb/25Gb/40Gb/50Gb Ethernet Controller" },
		Device { id: 0x16CB, name: "NetXtreme-C Ethernet Virtual Function" },
		Device { id: 0x16CC, name: "BCM57417 NetXtreme-E Ethernet Partition" },
		Device { id: 0x16CE, name: "BCM57311 NetXtreme-C 10Gb RDMA Ethernet Controller" },
		Device { id: 0x16CF, name: "BCM57312 NetXtreme-C 10Gb/25Gb RDMA Ethernet Controller" },
		Device { id: 0x16D0, name: "BCM57402 NetXtreme-E 10Gb Ethernet Controller" },
		Device { id: 0x16D1, name: "BCM57404 NetXtreme-E 10Gb/25Gb Ethernet Controller" },
		Device { id: 0x16D2, name: "BCM57406 NetXtreme-E 10GBASE-T Ethernet Controller" },
		Device { id: 0x16D3, name: "NetXtreme-E Ethernet Virtual Function" },
		Device { id: 0x16D4, name: "BCM57402 NetXtreme-E Ethernet Partition" },
		Device { id: 0x16D5, name: "BCM57407 NetXtreme-E 10GBase-T Ethernet Controller" },
		Device { id: 0x16D6, name: "BCM57412 NetXtreme-E 10Gb RDMA Ethernet Controller" },
		Device { id: 0x16D7, name: "BCM57414 NetXtreme-E 10Gb/25Gb RDMA Ethernet Controller" },
		Device { id: 0x16D8, name: "BCM57416 NetXtreme-E Dual-Media 10G RDMA Ethernet Controller" },
		Device { id: 0x16D9, name: "BCM57417 NetXtreme-E 10GBASE-T RDMA Ethernet Controller" },
		Device { id: 0x16DC, name: "NetXtreme-E Ethernet Virtual Function" },
		Device { id: 0x16DD, name: "NetLink BCM5781 Gigabit Ethernet PCI Express" },
		Device { id: 0x16DE, name: "BCM57412 NetXtreme-E Ethernet Partition" },
		Device { id: 0x16DF, name: "BCM57314 NetXtreme-C 10Gb/25Gb/40Gb/50Gb RDMA Ethernet Controller" },
		Device { id: 0x16E1, name: "NetXtreme-C Ethernet Virtual Function" },
		Device { id: 0x16E2, name: "BCM57417 NetXtreme-E 10Gb/25Gb RDMA Ethernet Controller" },
		Device { id: 0x16E3, name: "BCM57416 NetXtreme-E 10Gb RDMA Ethernet Controller" },
		Device { id: 0x16E5, name: "NetXtreme-C RDMA Virtual Function" },
		Device { id: 0x16E7, name: "BCM57404 NetXtreme-E Ethernet Partition" },
		Device { id: 0x16E8, name: "BCM57406 NetXtreme-E Ethernet Partition" },
		Device { id: 0x16E9, name: "BCM57407 NetXtreme-E 25Gb Ethernet Controller" },
		Device { id: 0x16EC, name: "BCM57414 NetXtreme-E Ethernet Partition" },
		Device { id: 0x16ED, name: "BCM57414 NetXtreme-E RDMA Partition" },
		Device { id: 0x16EE, name: "BCM57416 NetXtreme-E Ethernet Partition" },
		Device { id: 0x16EF, name: "BCM57416 NetXtreme-E RDMA Partition" },
		Device { id: 0x16F3, name: "NetXtreme BCM5727 Gigabit Ethernet PCIe" },
		Device { id: 0x16F7, name: "NetXtreme BCM5753 Gigabit Ethernet PCI Express" },
		Device { id: 0x16FD, name: "NetXtreme BCM5753M Gigabit Ethernet PCI Express" },
		Device { id: 0x16FE, name: "NetXtreme BCM5753F Fast Ethernet PCI Express" },
		Device { id: 0x170C, name: "BCM4401-B0 100Base-TX" },
		Device { id: 0x170D, name: "NetXtreme BCM5901 100Base-TX" },
		Device { id: 0x170E, name: "NetXtreme BCM5901 100Base-TX" },
		Device { id: 0x1712, name: "NetLink BCM5906 Fast Ethernet PCI Express" },
		Device { id: 0x1713, name: "NetLink BCM5906M Fast Ethernet PCI Express" },
		Device { id: 0x3352, name: "BCM3352" },
		Device { id: 0x3360, name: "BCM3360" },
		Device { id: 0x4210, name: "BCM4210 iLine10 HomePNA 2.0" },
		Device { id: 0x4211, name: "BCM4211 iLine10 HomePNA 2.0 + V.90 56k modem" },
		Device { id: 0x4212, name: "BCM4212 v.90 56k modem" },
		Device { id: 0x4220, name: "802-11b/g Wireless PCI controller, packaged as a Linksys WPC54G ver 1.2 PCMCIA card" },
		Device { id: 0x4222, name: "NetXtreme BCM5753M Gigabit Ethernet PCI Express" },
		Device { id: 0x4301, name: "BCM4301 802.11b Wireless LAN Controller" },
		Device { id: 0x4305, name: "BCM4307 V.90 56k Modem" },
		Device { id: 0x4306, name: "BCM4306 802.11bg Wireless LAN controller" },
		Device { id: 0x4307, name: "BCM4306 802.11bg Wireless LAN Controller" },
		Device { id: 0x4310, name: "BCM4310 Chipcommon I/OController" },
		Device { id: 0x4311, name: "BCM4311 802.11b/g WLAN" },
		Device { id: 0x4312, name: "BCM4311 802.11a/b/g" },
		Device { id: 0x4313, name: "BCM4311 802.11a" },
		Device { id: 0x4315, name: "BCM4312 802.11b/g LP-PHY" },
		Device { id: 0x4318, name: "BCM4318 [AirForce One 54g] 802.11g Wireless LAN Controller" },
		Device { id: 0x4319, name: "BCM4318 [AirForce 54g] 802.11a/b/g PCI Express Transceiver" },
		Device { id: 0x4320, name: "BCM4306 802.11b/g Wireless LAN Controller" },
		Device { id: 0x4321, name: "BCM4321 802.11a Wireless Network Controller" },
		Device { id: 0x4322, name: "BCM4322 802.11bgn Wireless Network Controller" },
		Device { id: 0x4324, name: "BCM4309 802.11abg Wireless Network Controller" },
		Device { id: 0x4325, name: "BCM4306 802.11bg Wireless Network Controller" },
		Device { id: 0x4326, name: "BCM4307 Chipcommon I/O Controller?" },
		Device { id: 0x4328, name: "BCM4321 802.11a/b/g/n" },
		Device { id: 0x4329, name: "BCM4321 802.11b/g/n" },
		Device { id: 0x432A, name: "BCM4321 802.11an Wireless Network Controller" },
		Device { id: 0x432B, name: "BCM4322 802.11a/b/g/n Wireless LAN Controller" },
		Device { id: 0x432C, name: "BCM4322 802.11b/g/n" },
		Device { id: 0x432D, name: "BCM4322 802.11an Wireless Network Controller" },
		Device { id: 0x4331, name: "BCM4331 802.11a/b/g/n" },
		Device { id: 0x4333, name: "Serial (EDGE/GPRS modem part of Option GT Combo Edge)" },
		Device { id: 0x4344, name: "EDGE/GPRS data and 802.11b/g combo cardbus [GC89]" },
		Device { id: 0x4350, name: "BCM43222 Wireless Network Adapter" },
		Device { id: 0x4351, name: "BCM43222 802.11abgn Wireless Network Adapter" },
		Device { id: 0x4353, name: "BCM43224 802.11a/b/g/n" },
		Device { id: 0x4357, name: "BCM43225 802.11b/g/n" },
		Device { id: 0x4358, name: "BCM43227 802.11b/g/n" },
		Device { id: 0x4359, name: "BCM43228 802.11a/b/g/n" },
		Device { id: 0x4360, name: "BCM4360 802.11ac Wireless Network Adapter" },
		Device { id: 0x4365, name: "BCM43142 802.11b/g/n" },
		Device { id: 0x43A0, name: "BCM4360 802.11ac Wireless Network Adapter" },
		Device { id: 0x43A1, name: "BCM4360 802.11ac Wireless Network Adapter" },
		Device { id: 0x43A2, name: "BCM4360 802.11ac Wireless Network Adapter" },
		Device { id: 0x43A3, name: "BCM4350 802.11ac Wireless Network Adapter" },
		Device { id: 0x43A9, name: "BCM43217 802.11b/g/n" },
		Device { id: 0x43AA, name: "BCM43131 802.11b/g/n" },
		Device { id: 0x43AE, name: "BCM43162 802.11ac Wireless Network Adapter" },
		Device { id: 0x43B1, name: "BCM4352 802.11ac Wireless Network Adapter" },
		Device { id: 0x43BA, name: "BCM43602 802.11ac Wireless LAN SoC" },
		Device { id: 0x43BB, name: "BCM43602 802.11ac Wireless LAN SoC" },
		Device { id: 0x43BC, name: "BCM43602 802.11ac Wireless LAN SoC" },
		Device { id: 0x43D3, name: "BCM43567 802.11ac Wireless Network Adapter" },
		Device { id: 0x43D9, name: "BCM43570 802.11ac Wireless Network Adapter" },
		Device { id: 0x43DF, name: "BCM4354 802.11ac Wireless LAN SoC" },
		Device { id: 0x43E9, name: "BCM4358 802.11ac Wireless LAN SoC" },
		Device { id: 0x43EC, name: "BCM4356 802.11ac Wireless Network Adapter" },
		Device { id: 0x4401, name: "BCM4401 100Base-T" },
		Device { id: 0x4402, name: "BCM4402 Integrated 10/100BaseT" },
		Device { id: 0x4403, name: "BCM4402 V.90 56k Modem" },
		Device { id: 0x4410, name: "BCM4413 iLine32 HomePNA 2.0" },
		Device { id: 0x4411, name: "BCM4413 V.90 56k modem" },
		Device { id: 0x4412, name: "BCM4412 10/100BaseT" },
		Device { id: 0x4430, name: "BCM44xx CardBus iLine32 HomePNA 2.0" },
		Device { id: 0x4432, name: "BCM4432 CardBus 10/100BaseT" },
		Device { id: 0x4610, name: "BCM4610 Sentry5 PCI to SB Bridge" },
		Device { id: 0x4611, name: "BCM4610 Sentry5 iLine32 HomePNA 1.0" },
		Device { id: 0x4612, name: "BCM4610 Sentry5 V.90 56k Modem" },
		Device { id: 0x4613, name: "BCM4610 Sentry5 Ethernet Controller" },
		Device { id: 0x4614, name: "BCM4610 Sentry5 External Interface" },
		Device { id: 0x4615, name: "BCM4610 Sentry5 USB Controller" },
		Device { id: 0x4704, name: "BCM4704 PCI to SB Bridge" },
		Device { id: 0x4705, name: "BCM4704 Sentry5 802.11b Wireless LAN Controller" },
		Device { id: 0x4706, name: "BCM4704 Sentry5 Ethernet Controller" },
		Device { id: 0x4707, name: "BCM4704 Sentry5 USB Controller" },
		Device { id: 0x4708, name: "BCM4704 Crypto Accelerator" },
		Device { id: 0x4710, name: "BCM4710 Sentry5 PCI to SB Bridge" },
		Device { id: 0x4711, name: "BCM47xx Sentry5 iLine32 HomePNA 2.0" },
		Device { id: 0x4712, name: "BCM47xx V.92 56k modem" },
		Device { id: 0x4713, name: "Sentry5 Ethernet Controller" },
		Device { id: 0x4714, name: "BCM47xx Sentry5 External Interface" },
		Device { id: 0x4715, name: "BCM47xx Sentry5 USB / Ethernet Controller" },
		Device { id: 0x4716, name: "BCM47xx Sentry5 USB Host Controller" },
		Device { id: 0x4717, name: "BCM47xx Sentry5 USB Device Controller" },
		Device { id: 0x4718, name: "Sentry5 Crypto Accelerator" },
		Device { id: 0x4719, name: "BCM47xx/53xx RoboSwitch Core" },
		Device { id: 0x4720, name: "BCM4712 MIPS CPU" },
		Device { id: 0x4727, name: "BCM4313 802.11bgn Wireless Network Adapter" },
		Device { id: 0x5365, name: "BCM5365P Sentry5 Host Bridge" },
		Device { id: 0x5600, name: "BCM5600 StrataSwitch 24+2 Ethernet Switch Controller" },
		Device { id: 0x5605, name: "BCM5605 StrataSwitch 24+2 Ethernet Switch Controller" },
		Device { id: 0x5615, name: "BCM5615 StrataSwitch 24+2 Ethernet Switch Controller" },
		Device { id: 0x5625, name: "BCM5625 StrataSwitch 24+2 Ethernet Switch Controller" },
		Device { id: 0x5645, name: "BCM5645 StrataSwitch 24+2 Ethernet Switch Controller" },
		Device { id: 0x5670, name: "BCM5670 8-Port 10GE Ethernet Switch Fabric" },
		Device { id: 0x5680, name: "BCM5680 G-Switch 8 Port Gigabit Ethernet Switch Controller" },
		Device { id: 0x5690, name: "BCM5690 12-port Multi-Layer Gigabit Ethernet Switch" },
		Device { id: 0x5691, name: "BCM5691 GE/10GE 8+2 Gigabit Ethernet Switch Controller" },
		Device { id: 0x5692, name: "BCM5692 12-port Multi-Layer Gigabit Ethernet Switch" },
		Device { id: 0x5695, name: "BCM5695 12-port + HiGig Multi-Layer Gigabit Ethernet Switch" },
		Device { id: 0x5698, name: "BCM5698 12-port Multi-Layer Gigabit Ethernet Switch" },
		Device { id: 0x5820, name: "BCM5820 Crypto Accelerator" },
		Device { id: 0x5821, name: "BCM5821 Crypto Accelerator" },
		Device { id: 0x5822, name: "BCM5822 Crypto Accelerator" },
		Device { id: 0x5823, name: "BCM5823 Crypto Accelerator" },
		Device { id: 0x5824, name: "BCM5824 Crypto Accelerator" },
		Device { id: 0x5840, name: "BCM5840 Crypto Accelerator" },
		Device { id: 0x5841, name: "BCM5841 Crypto Accelerator" },
		Device { id: 0x5850, name: "BCM5850 Crypto Accelerator" },
		Device { id: 0x8602, name: "BCM7400/BCM7405 Serial ATA Controller" },
		Device { id: 0xA8D8, name: "BCM43224/5 Wireless Network Adapter" },
		Device { id: 0xAA52, name: "BCM43602 802.11ac Wireless LAN SoC" },
		Device { id: 0xB302, name: "BCM56302 StrataXGS 24x1GE 2x10GE Switch Controller" },
		Device { id: 0xB334, name: "BCM56334 StrataXGS 24x1GE 4x10GE Switch Controller" },
		Device { id: 0xB800, name: "BCM56800 StrataXGS 10GE Switch Controller" },
		Device { id: 0xB842, name: "BCM56842 Trident 10GE Switch Controller" },
		Device { id: 0xB850, name: "Broadcom BCM56850 Switch ASIC" },
		Device { id: 0xB960, name: "Broadcom BCM56960 Switch ASIC" },
	] },
	Vendor { id: 0x14E5, name: "Pixelfusion Ltd", devices: &[
	] },
	Vendor { id: 0x14E6, name: "SHINING Technology Inc", devices: &[
	] },
	Vendor { id: 0x14E7, name: "3CX", devices: &[
	] },
	Vendor { id: 0x14E8, name: "RAYCER Inc", devices: &[
	] },
	Vendor { id: 0x14E9, name: "GARNETS System CO Ltd", devices: &[
	] },
	Vendor { id: 0x14EA, name: "Planex Communications, Inc", devices: &[
		Device { id: 0xAB06, name: "FNW-3603-TX CardBus Fast Ethernet" },
		Device { id: 0xAB07, name: "RTL81xx RealTek Ethernet" },
		Device { id: 0xAB08, name: "FNW-3602-TX CardBus Fast Ethernet" },
	] },
	Vendor { id: 0x14EB, name: "SEIKO EPSON Corp", devices: &[
	] },
	Vendor { id: 0x14EC, name: "Agilent Technologies", devices: &[
		Device { id: 0x0000, name: "Aciris Digitizer (malformed ID)" },
	] },
	Vendor { id: 0x14ED, name: "DATAKINETICS Ltd", devices: &[
	] },
	Vendor { id: 0x14EE, name: "MASPRO KENKOH Corp", devices: &[
	] },
	Vendor { id: 0x14EF, name: "CARRY Computer ENG. CO Ltd", devices: &[
	] },
	Vendor { id: 0x14F0, name: "CANON RESEACH CENTRE FRANCE", devices: &[
	] },
	Vendor { id: 0x14F1, name: "Conexant Systems, Inc.", devices: &[
		Device { id: 0x1002, name: "HCF 56k Modem" },
		Device { id: 0x1003, name: "HCF 56k Modem" },
		Device { id: 0x1004, name: "HCF 56k Modem" },
		Device { id: 0x1005, name: "HCF 56k Modem" },
		Device { id: 0x1006, name: "HCF 56k Modem" },
		Device { id: 0x1022, name: "HCF 56k Modem" },
		Device { id: 0x1023, name: "HCF 56k Modem" },
		Device { id: 0x1024, name: "HCF 56k Modem" },
		Device { id: 0x1025, name: "HCF 56k Modem" },
		Device { id: 0x1026, name: "HCF 56k Modem" },
		Device { id: 0x1032, name: "HCF 56k Modem" },
		Device { id: 0x1033, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x1034, name: "HCF 56k Data/Fax/Voice Modem" },
		Device { id: 0x1035, name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x1036, name: "HCF 56k Data/Fax/Voice/Spkp Modem" },
		Device { id: 0x1052, name: "HCF 56k Data/Fax Modem (Worldwide)" },
		Device { id: 0x1053, name: "HCF 56k Data/Fax Modem (Worldwide)" },
		Device { id: 0x1054, name: "HCF 56k Data/Fax/Voice Modem (Worldwide)" },
		Device { id: 0x1055, name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (Worldwide)" },
		Device { id: 0x1056, name: "HCF 56k Data/Fax/Voice/Spkp Modem (Worldwide)" },
		Device { id: 0x1057, name: "HCF 56k Data/Fax/Voice/Spkp Modem (Worldwide)" },
		Device { id: 0x1059, name: "HCF 56k Data/Fax/Voice Modem (Worldwide)" },
		Device { id: 0x1063, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x1064, name: "HCF 56k Data/Fax/Voice Modem" },
		Device { id: 0x1065, name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x1066, name: "HCF 56k Data/Fax/Voice/Spkp Modem" },
		Device { id: 0x1085, name: "HCF V90 56k Data/Fax/Voice/Spkp PCI Modem" },
		Device { id: 0x10B6, name: "CX06834-11 HCF V.92 56k Data/Fax/Voice/Spkp Modem" },
		Device { id: 0x1433, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x1434, name: "HCF 56k Data/Fax/Voice Modem" },
		Device { id: 0x1435, name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x1436, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x1453, name: "HCF 56k Data/Fax Modem" },
		Device { id: 0x1454, name: "HCF 56k Data/Fax/Voice Modem" },
		Device { id: 0x1455, name: "HCF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x1456, name: "HCF 56k Data/Fax/Voice/Spkp Modem" },
		Device { id: 0x1610, name: "ADSL AccessRunner PCI Arbitration Device" },
		Device { id: 0x1611, name: "AccessRunner PCI ADSL Interface Device" },
		Device { id: 0x1620, name: "AccessRunner V2 PCI ADSL Arbitration Device" },
		Device { id: 0x1621, name: "AccessRunner V2 PCI ADSL Interface Device" },
		Device { id: 0x1622, name: "AccessRunner V2 PCI ADSL Yukon WAN Adapter" },
		Device { id: 0x1803, name: "HCF 56k Modem" },
		Device { id: 0x1811, name: "MiniPCI Network Adapter" },
		Device { id: 0x1815, name: "HCF 56k Modem" },
		Device { id: 0x1830, name: "CX861xx Integrated Host Bridge" },
		Device { id: 0x2003, name: "HSF 56k Data/Fax Modem" },
		Device { id: 0x2004, name: "HSF 56k Data/Fax/Voice Modem" },
		Device { id: 0x2005, name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x2006, name: "HSF 56k Data/Fax/Voice/Spkp Modem" },
		Device { id: 0x2013, name: "HSF 56k Data/Fax Modem" },
		Device { id: 0x2014, name: "HSF 56k Data/Fax/Voice Modem" },
		Device { id: 0x2015, name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem" },
		Device { id: 0x2016, name: "HSF 56k Data/Fax/Voice/Spkp Modem" },
		Device { id: 0x2043, name: "HSF 56k Data/Fax Modem (WorldW SmartDAA)" },
		Device { id: 0x2044, name: "HSF 56k Data/Fax/Voice Modem (WorldW SmartDAA)" },
		Device { id: 0x2045, name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (WorldW SmartDAA)" },
		Device { id: 0x2046, name: "HSF 56k Data/Fax/Voice/Spkp Modem (WorldW SmartDAA)" },
		Device { id: 0x2063, name: "HSF 56k Data/Fax Modem (SmartDAA)" },
		Device { id: 0x2064, name: "HSF 56k Data/Fax/Voice Modem (SmartDAA)" },
		Device { id: 0x2065, name: "HSF 56k Data/Fax/Voice/Spkp (w/Handset) Modem (SmartDAA)" },
		Device { id: 0x2066, name: "HSF 56k Data/Fax/Voice/Spkp Modem (SmartDAA)" },
		Device { id: 0x2093, name: "HSF 56k Modem" },
		Device { id: 0x2143, name: "HSF 56k Data/Fax/Cell Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2144, name: "HSF 56k Data/Fax/Voice/Cell Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2145, name: "HSF 56k Data/Fax/Voice/Spkp (w/HS)/Cell Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2146, name: "HSF 56k Data/Fax/Voice/Spkp/Cell Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2163, name: "HSF 56k Data/Fax/Cell Modem (Mob SmartDAA)" },
		Device { id: 0x2164, name: "HSF 56k Data/Fax/Voice/Cell Modem (Mob SmartDAA)" },
		Device { id: 0x2165, name: "HSF 56k Data/Fax/Voice/Spkp (w/HS)/Cell Modem (Mob SmartDAA)" },
		Device { id: 0x2166, name: "HSF 56k Data/Fax/Voice/Spkp/Cell Modem (Mob SmartDAA)" },
		Device { id: 0x2343, name: "HSF 56k Data/Fax CardBus Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2344, name: "HSF 56k Data/Fax/Voice CardBus Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2345, name: "HSF 56k Data/Fax/Voice/Spkp (w/HS) CardBus Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2346, name: "HSF 56k Data/Fax/Voice/Spkp CardBus Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2363, name: "HSF 56k Data/Fax CardBus Modem (Mob SmartDAA)" },
		Device { id: 0x2364, name: "HSF 56k Data/Fax/Voice CardBus Modem (Mob SmartDAA)" },
		Device { id: 0x2365, name: "HSF 56k Data/Fax/Voice/Spkp (w/HS) CardBus Modem (Mob SmartDAA)" },
		Device { id: 0x2366, name: "HSF 56k Data/Fax/Voice/Spkp CardBus Modem (Mob SmartDAA)" },
		Device { id: 0x2443, name: "HSF 56k Data/Fax Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2444, name: "HSF 56k Data/Fax/Voice Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2445, name: "HSF 56k Data/Fax/Voice/Spkp (w/HS) Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2446, name: "HSF 56k Data/Fax/Voice/Spkp Modem (Mob WorldW SmartDAA)" },
		Device { id: 0x2463, name: "HSF 56k Data/Fax Modem (Mob SmartDAA)" },
		Device { id: 0x2464, name: "HSF 56k Data/Fax/Voice Modem (Mob SmartDAA)" },
		Device { id: 0x2465, name: "HSF 56k Data/Fax/Voice/Spkp (w/HS) Modem (Mob SmartDAA)" },
		Device { id: 0x2466, name: "HSF 56k Data/Fax/Voice/Spkp Modem (Mob SmartDAA)" },
		Device { id: 0x2702, name: "HSFi modem RD01-D270" },
		Device { id: 0x2F00, name: "HSF 56k HSFi Modem" },
		Device { id: 0x2F02, name: "HSF 56k HSFi Data/Fax" },
		Device { id: 0x2F11, name: "HSF 56k HSFi Modem" },
		Device { id: 0x2F20, name: "HSF 56k Data/Fax Modem" },
		Device { id: 0x2F30, name: "SoftV92 SpeakerPhone SoftRing Modem with SmartSP" },
		Device { id: 0x2F50, name: "Conexant SoftK56 Data/Fax Modem" },
		Device { id: 0x5B7A, name: "CX23418 Single-Chip MPEG-2 Encoder with Integrated Analog Video/Broadcast Audio Decoder" },
		Device { id: 0x8200, name: "CX25850" },
		Device { id: 0x8234, name: "RS8234 ATM SAR Controller [ServiceSAR Plus]" },
		Device { id: 0x8800, name: "CX23880/1/2/3 PCI Video and Audio Decoder" },
		Device { id: 0x8801, name: "CX23880/1/2/3 PCI Video and Audio Decoder [Audio Port]" },
		Device { id: 0x8802, name: "CX23880/1/2/3 PCI Video and Audio Decoder [MPEG Port]" },
		Device { id: 0x8804, name: "CX23880/1/2/3 PCI Video and Audio Decoder [IR Port]" },
		Device { id: 0x8811, name: "CX23880/1/2/3 PCI Video and Audio Decoder [Audio Port]" },
		Device { id: 0x8852, name: "CX23885 PCI Video and Audio Decoder" },
		Device { id: 0x8880, name: "CX23887/8 PCIe Broadcast Audio and Video Decoder with 3D Comb" },
	] },
	Vendor { id: 0x14F2, name: "MOBILITY Electronics", devices: &[
		Device { id: 0x0120, name: "EV1000 bridge" },
		Device { id: 0x0121, name: "EV1000 Parallel port" },
		Device { id: 0x0122, name: "EV1000 Serial port" },
		Device { id: 0x0123, name: "EV1000 Keyboard controller" },
		Device { id: 0x0124, name: "EV1000 Mouse controller" },
	] },
	Vendor { id: 0x14F3, name: "BroadLogic", devices: &[
		Device { id: 0x2030, name: "2030 DVB-S Satellite Receiver" },
		Device { id: 0x2035, name: "2035 DVB-S Satellite Receiver" },
		Device { id: 0x2050, name: "2050 DVB-T Terrestrial (Cable) Receiver" },
		Device { id: 0x2060, name: "2060 ATSC Terrestrial (Cable) Receiver" },
	] },
	Vendor { id: 0x14F4, name: "TOKYO Electronic Industry CO Ltd", devices: &[
	] },
	Vendor { id: 0x14F5, name: "SOPAC Ltd", devices: &[
	] },
	Vendor { id: 0x14F6, name: "COYOTE Technologies LLC", devices: &[
	] },
	Vendor { id: 0x14F7, name: "WOLF Technology Inc", devices: &[
	] },
	Vendor { id: 0x14F8, name: "AUDIOCODES Inc", devices: &[
		Device { id: 0x2077, name: "TP-240 dual span E1 VoIP PCI card" },
	] },
	Vendor { id: 0x14F9, name: "AG COMMUNICATIONS", devices: &[
	] },
	Vendor { id: 0x14FA, name: "WANDEL & GOLTERMANN", devices: &[
	] },
	Vendor { id: 0x14FB, name: "TRANSAS MARINE (UK) Ltd", devices: &[
	] },
	Vendor { id: 0x14FC, name: "Quadrics Ltd", devices: &[
		Device { id: 0x0000, name: "QsNet Elan3 Network Adapter" },
		Device { id: 0x0001, name: "QsNetII Elan4 Network Adapter" },
		Device { id: 0x0002, name: "QsNetIII Elan5 Network Adapter" },
	] },
	Vendor { id: 0x14FD, name: "JAPAN Computer Industry Inc", devices: &[
	] },
	Vendor { id: 0x14FE, name: "ARCHTEK TELECOM Corp", devices: &[
	] },
	Vendor { id: 0x14FF, name: "TWINHEAD INTERNATIONAL Corp", devices: &[
	] },
	Vendor { id: 0x1500, name: "DELTA Electronics, Inc", devices: &[
		Device { id: 0x1360, name: "RTL81xx RealTek Ethernet" },
	] },
	Vendor { id: 0x1501, name: "BANKSOFT CANADA Ltd", devices: &[
	] },
	Vendor { id: 0x1502, name: "MITSUBISHI ELECTRIC LOGISTICS SUPPORT Co Ltd", devices: &[
	] },
	Vendor { id: 0x1503, name: "KAWASAKI LSI USA Inc", devices: &[
	] },
	Vendor { id: 0x1504, name: "KAISER Electronics", devices: &[
	] },
	Vendor { id: 0x1505, name: "ITA INGENIEURBURO FUR TESTAUFGABEN GmbH", devices: &[
	] },
	Vendor { id: 0x1506, name: "CHAMELEON Systems Inc", devices: &[
	] },
	Vendor { id: 0x1507, name: "Motorola ?? / HTEC", devices: &[
		Device { id: 0x0001, name: "MPC105 [Eagle]" },
		Device { id: 0x0002, name: "MPC106 [Grackle]" },
		Device { id: 0x0003, name: "MPC8240 [Kahlua]" },
		Device { id: 0x0100, name: "MC145575 [HFC-PCI]" },
		Device { id: 0x0431, name: "KTI829c 100VG" },
		Device { id: 0x4801, name: "Raven" },
		Device { id: 0x4802, name: "Falcon" },
		Device { id: 0x4803, name: "Hawk" },
		Device { id: 0x4806, name: "CPX8216" },
	] },
	Vendor { id: 0x1508, name: "HONDA CONNECTORS/MHOTRONICS Inc", devices: &[
	] },
	Vendor { id: 0x1509, name: "FIRST INTERNATIONAL Computer Inc", devices: &[
	] },
	Vendor { id: 0x150A, name: "FORVUS RESEARCH Inc", devices: &[
	] },
	Vendor { id: 0x150B, name: "YAMASHITA Systems Corp", devices: &[
	] },
	Vendor { id: 0x150C, name: "KYOPAL CO Ltd", devices: &[
	] },
	Vendor { id: 0x150D, name: "WARPSPPED Inc", devices: &[
	] },
	Vendor { id: 0x150E, name: "C-PORT Corp", devices: &[
	] },
	Vendor { id: 0x150F, name: "INTEC GmbH", devices: &[
	] },
	Vendor { id: 0x1510, name: "BEHAVIOR TECH Computer Corp", devices: &[
	] },
	Vendor { id: 0x1511, name: "CENTILLIUM Technology Corp", devices: &[
	] },
	Vendor { id: 0x1512, name: "ROSUN Technologies Inc", devices: &[
	] },
	Vendor { id: 0x1513, name: "Raychem", devices: &[
	] },
	Vendor { id: 0x1514, name: "TFL LAN Inc", devices: &[
	] },
	Vendor { id: 0x1515, name: "Advent design", devices: &[
	] },
	Vendor { id: 0x1516, name: "MYSON Technology Inc", devices: &[
		Device { id: 0x0800, name: "MTD-8xx 100/10M Ethernet PCI Adapter" },
		Device { id: 0x0803, name: "SURECOM EP-320X-S 100/10M Ethernet PCI Adapter" },
		Device { id: 0x0891, name: "MTD-8xx 100/10M Ethernet PCI Adapter" },
	] },
	Vendor { id: 0x1517, name: "ECHOTEK Corp", devices: &[
	] },
	Vendor { id: 0x1518, name: "Kontron", devices: &[
	] },
	Vendor { id: 0x1519, name: "TELEFON AKTIEBOLAGET LM Ericsson", devices: &[
	] },
	Vendor { id: 0x151A, name: "Globetek", devices: &[
		Device { id: 0x1002, name: "PCI-1002" },
		Device { id: 0x1004, name: "PCI-1004" },
		Device { id: 0x1008, name: "PCI-1008" },
	] },
	Vendor { id: 0x151B, name: "COMBOX Ltd", devices: &[
	] },
	Vendor { id: 0x151C, name: "DIGITAL AUDIO LABS Inc", devices: &[
		Device { id: 0x0003, name: "Prodif T 2496" },
		Device { id: 0x4000, name: "Prodif 88" },
	] },
	Vendor { id: 0x151D, name: "Fujitsu Computer Products Of America", devices: &[
	] },
	Vendor { id: 0x151E, name: "MATRIX Corp", devices: &[
	] },
	Vendor { id: 0x151F, name: "TOPIC SEMICONDUCTOR Corp", devices: &[
		Device { id: 0x0000, name: "TP560 Data/Fax/Voice 56k modem" },
	] },
	Vendor { id: 0x1520, name: "CHAPLET System Inc", devices: &[
	] },
	Vendor { id: 0x1521, name: "BELL Corp", devices: &[
	] },
	Vendor { id: 0x1522, name: "MainPine Ltd", devices: &[
		Device { id: 0x0100, name: "PCI <-> IOBus Bridge" },
		Device { id: 0x4000, name: "PCI Express UART" },
	] },
	Vendor { id: 0x1523, name: "MUSIC Semiconductors", devices: &[
	] },
	Vendor { id: 0x1524, name: "ENE Technology Inc", devices: &[
		Device { id: 0x0510, name: "CB710 Memory Card Reader Controller" },
		Device { id: 0x0520, name: "FLASH memory: ENE Technology Inc:" },
		Device { id: 0x0530, name: "ENE PCI Memory Stick Card Reader Controller" },
		Device { id: 0x0550, name: "ENE PCI Secure Digital Card Reader Controller" },
		Device { id: 0x0551, name: "SD/MMC Card Reader Controller" },
		Device { id: 0x0610, name: "PCI Smart Card Reader Controller" },
		Device { id: 0x0720, name: "Memory Stick Card Reader Controller" },
		Device { id: 0x0730, name: "ENE PCI Memory Stick Card Reader Controller" },
		Device { id: 0x0750, name: "ENE PCI SmartMedia / xD Card Reader Controller" },
		Device { id: 0x0751, name: "ENE PCI Secure Digital / MMC Card Reader Controller" },
		Device { id: 0x1211, name: "CB1211 Cardbus Controller" },
		Device { id: 0x1225, name: "CB1225 Cardbus Controller" },
		Device { id: 0x1410, name: "CB1410 Cardbus Controller" },
		Device { id: 0x1411, name: "CB-710/2/4 Cardbus Controller" },
		Device { id: 0x1412, name: "CB-712/4 Cardbus Controller" },
		Device { id: 0x1420, name: "CB1420 Cardbus Controller" },
		Device { id: 0x1421, name: "CB-720/2/4 Cardbus Controller" },
		Device { id: 0x1422, name: "CB-722/4 Cardbus Controller" },
	] },
	Vendor { id: 0x1525, name: "IMPACT Technologies", devices: &[
	] },
	Vendor { id: 0x1526, name: "ISS, Inc", devices: &[
	] },
	Vendor { id: 0x1527, name: "SOLECTRON", devices: &[
	] },
	Vendor { id: 0x1528, name: "ACKSYS", devices: &[
	] },
	Vendor { id: 0x1529, name: "AMERICAN MICROSystems Inc", devices: &[
	] },
	Vendor { id: 0x152A, name: "QUICKTURN DESIGN Systems", devices: &[
	] },
	Vendor { id: 0x152B, name: "FLYTECH Technology CO Ltd", devices: &[
	] },
	Vendor { id: 0x152C, name: "MACRAIGOR Systems LLC", devices: &[
	] },
	Vendor { id: 0x152D, name: "QUANTA Computer Inc", devices: &[
	] },
	Vendor { id: 0x152E, name: "MELEC Inc", devices: &[
	] },
	Vendor { id: 0x152F, name: "PHILIPS - CRYPTO", devices: &[
	] },
	Vendor { id: 0x1530, name: "ACQIS Technology Inc", devices: &[
	] },
	Vendor { id: 0x1531, name: "CHRYON Corp", devices: &[
	] },
	Vendor { id: 0x1532, name: "ECHELON Corp", devices: &[
		Device { id: 0x0020, name: "LonWorks PCLTA-20 PCI LonTalk Adapter" },
	] },
	Vendor { id: 0x1533, name: "BALTIMORE", devices: &[
	] },
	Vendor { id: 0x1534, name: "ROAD Corp", devices: &[
	] },
	Vendor { id: 0x1535, name: "EVERGREEN Technologies Inc", devices: &[
	] },
	Vendor { id: 0x1536, name: "ACTIS Computer", devices: &[
	] },
	Vendor { id: 0x1537, name: "DATALEX COMMUNCATIONS", devices: &[
	] },
	Vendor { id: 0x1538, name: "ARALION Inc", devices: &[
		Device { id: 0x0303, name: "ARS106S Ultra ATA 133/100/66 Host Controller" },
	] },
	Vendor { id: 0x1539, name: "ATELIER INFORMATIQUES et ELECTRONIQUE ETUDES S.A.", devices: &[
	] },
	Vendor { id: 0x153A, name: "ONO SOKKI", devices: &[
	] },
	Vendor { id: 0x153B, name: "TERRATEC Electronic GmbH", devices: &[
		Device { id: 0x1144, name: "Aureon 5.1" },
		Device { id: 0x1147, name: "Aureon 5.1 Sky" },
		Device { id: 0x1158, name: "Philips Semiconductors SAA7134 (rev 01) [Terratec Cinergy 600 TV]" },
	] },
	Vendor { id: 0x153C, name: "ANTAL Electronic", devices: &[
	] },
	Vendor { id: 0x153D, name: "FILANET Corp", devices: &[
	] },
	Vendor { id: 0x153E, name: "TECHWELL Inc", devices: &[
	] },
	Vendor { id: 0x153F, name: "MIPS Technologies, Inc.", devices: &[
		Device { id: 0x0001, name: "SOC-it 101 System Controller" },
	] },
	Vendor { id: 0x1540, name: "PROVIDEO MULTIMEDIA Co Ltd", devices: &[
	] },
	Vendor { id: 0x1541, name: "MACHONE Communications", devices: &[
	] },
	Vendor { id: 0x1542, name: "Concurrent Real-Time", devices: &[
		Device { id: 0x9260, name: "RCIM-II Real-Time Clock & Interrupt Module" },
		Device { id: 0x9271, name: "RCIM-III Real-Time Clock & Interrupt Module (PCIe)" },
		Device { id: 0x9272, name: "Pulse Width Modulator Card" },
		Device { id: 0x9277, name: "5 Volt Delta Sigma Converter Card" },
		Device { id: 0x9278, name: "10 Volt Delta Sigma Converter Card" },
		Device { id: 0x9287, name: "Analog Output Card" },
		Device { id: 0x9290, name: "FPGA Card" },
	] },
	Vendor { id: 0x1543, name: "SILICON Laboratories", devices: &[
		Device { id: 0x3052, name: "Intel 537 [Winmodem]" },
		Device { id: 0x4C22, name: "Si3036 MC'97 DAA" },
	] },
	Vendor { id: 0x1544, name: "DCM DATA Systems", devices: &[
	] },
	Vendor { id: 0x1545, name: "VISIONTEK", devices: &[
	] },
	Vendor { id: 0x1546, name: "IOI Technology Corp", devices: &[
	] },
	Vendor { id: 0x1547, name: "MITUTOYO Corp", devices: &[
	] },
	Vendor { id: 0x1548, name: "JET PROPULSION Laboratory", devices: &[
	] },
	Vendor { id: 0x1549, name: "INTERCONNECT Systems Solutions", devices: &[
	] },
	Vendor { id: 0x154A, name: "MAX Technologies Inc", devices: &[
	] },
	Vendor { id: 0x154B, name: "COMPUTEX Co Ltd", devices: &[
	] },
	Vendor { id: 0x154C, name: "VISUAL Technology Inc", devices: &[
	] },
	Vendor { id: 0x154D, name: "PAN INTERNATIONAL Industrial Corp", devices: &[
	] },
	Vendor { id: 0x154E, name: "SERVOTEST Ltd", devices: &[
	] },
	Vendor { id: 0x154F, name: "STRATABEAM Technology", devices: &[
	] },
	Vendor { id: 0x1550, name: "OPEN NETWORK Co Ltd", devices: &[
	] },
	Vendor { id: 0x1551, name: "SMART Electronic DEVELOPMENT GmBH", devices: &[
	] },
	Vendor { id: 0x1552, name: "RACAL AIRTECH Ltd", devices: &[
	] },
	Vendor { id: 0x1553, name: "CHICONY Electronics Co Ltd", devices: &[
	] },
	Vendor { id: 0x1554, name: "PROLINK Microsystems Corp", devices: &[
	] },
	Vendor { id: 0x1555, name: "GESYTEC GmBH", devices: &[
	] },
	Vendor { id: 0x1556, name: "PLDA", devices: &[
		Device { id: 0x1100, name: "PCI Express Core Reference Design" },
		Device { id: 0x110F, name: "PCI Express Core Reference Design Virtual Function" },
	] },
	Vendor { id: 0x1557, name: "MEDIASTAR Co Ltd", devices: &[
	] },
	Vendor { id: 0x1558, name: "CLEVO/KAPOK Computer", devices: &[
	] },
	Vendor { id: 0x1559, name: "SI LOGIC Ltd", devices: &[
	] },
	Vendor { id: 0x155A, name: "INNOMEDIA Inc", devices: &[
	] },
	Vendor { id: 0x155B, name: "PROTAC INTERNATIONAL Corp", devices: &[
	] },
	Vendor { id: 0x155C, name: "Cemax-Icon Inc", devices: &[
	] },
	Vendor { id: 0x155D, name: "Mac System Co Ltd", devices: &[
	] },
	Vendor { id: 0x155E, name: "LP Elektronik GmbH", devices: &[
	] },
	Vendor { id: 0x155F, name: "Perle Systems Ltd", devices: &[
	] },
	Vendor { id: 0x1560, name: "Terayon Communications Systems", devices: &[
	] },
	Vendor { id: 0x1561, name: "Viewgraphics Inc", devices: &[
	] },
	Vendor { id: 0x1562, name: "Symbol Technologies", devices: &[
	] },
	Vendor { id: 0x1563, name: "A-Trend Technology Co Ltd", devices: &[
	] },
	Vendor { id: 0x1564, name: "Yamakatsu Electronics Industry Co Ltd", devices: &[
	] },
	Vendor { id: 0x1565, name: "Biostar Microtech Int'l Corp", devices: &[
	] },
	Vendor { id: 0x1566, name: "Ardent Technologies Inc", devices: &[
	] },
	Vendor { id: 0x1567, name: "Jungsoft", devices: &[
	] },
	Vendor { id: 0x1568, name: "DDK Electronics Inc", devices: &[
	] },
	Vendor { id: 0x1569, name: "Palit Microsystems Inc.", devices: &[
	] },
	Vendor { id: 0x156A, name: "Avtec Systems", devices: &[
	] },
	Vendor { id: 0x156B, name: "2wire Inc", devices: &[
	] },
	Vendor { id: 0x156C, name: "Vidac Electronics GmbH", devices: &[
	] },
	Vendor { id: 0x156D, name: "Alpha-Top Corp", devices: &[
	] },
	Vendor { id: 0x156E, name: "Alfa Inc", devices: &[
	] },
	Vendor { id: 0x156F, name: "M-Systems Flash Disk Pioneers Ltd", devices: &[
	] },
	Vendor { id: 0x1570, name: "Lecroy Corp", devices: &[
	] },
	Vendor { id: 0x1571, name: "Contemporary Controls", devices: &[
		Device { id: 0xA001, name: "CCSI PCI20-485 ARCnet" },
		Device { id: 0xA002, name: "CCSI PCI20-485D ARCnet" },
		Device { id: 0xA003, name: "CCSI PCI20-485X ARCnet" },
		Device { id: 0xA004, name: "CCSI PCI20-CXB ARCnet" },
		Device { id: 0xA005, name: "CCSI PCI20-CXS ARCnet" },
		Device { id: 0xA006, name: "CCSI PCI20-FOG-SMA ARCnet" },
		Device { id: 0xA007, name: "CCSI PCI20-FOG-ST ARCnet" },
		Device { id: 0xA008, name: "CCSI PCI20-TB5 ARCnet" },
		Device { id: 0xA009, name: "CCSI PCI20-5-485 5Mbit ARCnet" },
		Device { id: 0xA00A, name: "CCSI PCI20-5-485D 5Mbit ARCnet" },
		Device { id: 0xA00B, name: "CCSI PCI20-5-485X 5Mbit ARCnet" },
		Device { id: 0xA00C, name: "CCSI PCI20-5-FOG-ST 5Mbit ARCnet" },
		Device { id: 0xA00D, name: "CCSI PCI20-5-FOG-SMA 5Mbit ARCnet" },
		Device { id: 0xA201, name: "CCSI PCI22-485 10Mbit ARCnet" },
		Device { id: 0xA202, name: "CCSI PCI22-485D 10Mbit ARCnet" },
		Device { id: 0xA203, name: "CCSI PCI22-485X 10Mbit ARCnet" },
		Device { id: 0xA204, name: "CCSI PCI22-CHB 10Mbit ARCnet" },
		Device { id: 0xA205, name: "CCSI PCI22-FOG_ST 10Mbit ARCnet" },
		Device { id: 0xA206, name: "CCSI PCI22-THB 10Mbit ARCnet" },
	] },
	Vendor { id: 0x1572, name: "Otis Elevator Company", devices: &[
	] },
	Vendor { id: 0x1573, name: "Lattice - Vantis", devices: &[
	] },
	Vendor { id: 0x1574, name: "Fairchild Semiconductor", devices: &[
	] },
	Vendor { id: 0x1575, name: "Voltaire Advanced Data Security Ltd", devices: &[
	] },
	Vendor { id: 0x1576, name: "Viewcast COM", devices: &[
	] },
	Vendor { id: 0x1578, name: "HITT", devices: &[
		Device { id: 0x4D34, name: "VPMK4 [Video Processor Mk IV]" },
		Device { id: 0x5615, name: "VPMK3 [Video Processor Mk III]" },
	] },
	Vendor { id: 0x1579, name: "Dual Technology Corp", devices: &[
	] },
	Vendor { id: 0x157A, name: "Japan Elecronics Ind Inc", devices: &[
	] },
	Vendor { id: 0x157B, name: "Star Multimedia Corp", devices: &[
	] },
	Vendor { id: 0x157C, name: "Eurosoft (UK)", devices: &[
		Device { id: 0x8001, name: "Fix2000 PCI Y2K Compliance Card" },
	] },
	Vendor { id: 0x157D, name: "Gemflex Networks", devices: &[
	] },
	Vendor { id: 0x157E, name: "Transition Networks", devices: &[
	] },
	Vendor { id: 0x157F, name: "PX Instruments Technology Ltd", devices: &[
	] },
	Vendor { id: 0x1580, name: "Primex Aerospace Co", devices: &[
	] },
	Vendor { id: 0x1581, name: "SEH Computertechnik GmbH", devices: &[
	] },
	Vendor { id: 0x1582, name: "Cytec Corp", devices: &[
	] },
	Vendor { id: 0x1583, name: "Inet Technologies Inc", devices: &[
	] },
	Vendor { id: 0x1584, name: "Uniwill Computer Corp", devices: &[
	] },
	Vendor { id: 0x1585, name: "Logitron", devices: &[
	] },
	Vendor { id: 0x1586, name: "Lancast Inc", devices: &[
	] },
	Vendor { id: 0x1587, name: "Konica Corp", devices: &[
	] },
	Vendor { id: 0x1588, name: "Solidum Systems Corp", devices: &[
	] },
	Vendor { id: 0x1589, name: "Atlantek Microsystems Pty Ltd", devices: &[
		Device { id: 0x0008, name: "Leutron Vision PicPortExpress CL" },
		Device { id: 0x0009, name: "Leutron Vision PicPortExpress CL Stereo" },
	] },
	Vendor { id: 0x158A, name: "Digalog Systems Inc", devices: &[
	] },
	Vendor { id: 0x158B, name: "Allied Data Technologies", devices: &[
	] },
	Vendor { id: 0x158C, name: "Hitachi Semiconductor & Devices Sales Co Ltd", devices: &[
	] },
	Vendor { id: 0x158D, name: "Point Multimedia Systems", devices: &[
	] },
	Vendor { id: 0x158E, name: "Lara Technology Inc", devices: &[
	] },
	Vendor { id: 0x158F, name: "Ditect Coop", devices: &[
	] },
	Vendor { id: 0x1590, name: "Hewlett Packard Enterprise", devices: &[
		Device { id: 0x0001, name: "Eagle Cluster Manager" },
		Device { id: 0x0002, name: "Osprey Cluster Manager" },
		Device { id: 0x0003, name: "Harrier Cluster Manager" },
		Device { id: 0xA01D, name: "FC044X Fibre Channel HBA" },
	] },
	Vendor { id: 0x1591, name: "ARN", devices: &[
	] },
	Vendor { id: 0x1592, name: "Syba Tech Ltd", devices: &[
		Device { id: 0x0781, name: "Multi-IO Card" },
		Device { id: 0x0782, name: "Parallel Port Card 2xEPP" },
		Device { id: 0x0783, name: "Multi-IO Card" },
		Device { id: 0x0785, name: "Multi-IO Card" },
		Device { id: 0x0786, name: "Multi-IO Card" },
		Device { id: 0x0787, name: "Multi-IO Card" },
		Device { id: 0x0788, name: "Multi-IO Card" },
		Device { id: 0x078A, name: "Multi-IO Card" },
	] },
	Vendor { id: 0x1593, name: "Bops Inc", devices: &[
	] },
	Vendor { id: 0x1594, name: "Netgame Ltd", devices: &[
	] },
	Vendor { id: 0x1595, name: "Diva Systems Corp", devices: &[
	] },
	Vendor { id: 0x1596, name: "Folsom Research Inc", devices: &[
	] },
	Vendor { id: 0x1597, name: "Memec Design Services", devices: &[
	] },
	Vendor { id: 0x1598, name: "Granite Microsystems", devices: &[
	] },
	Vendor { id: 0x1599, name: "Delta Electronics Inc", devices: &[
	] },
	Vendor { id: 0x159A, name: "General Instrument", devices: &[
	] },
	Vendor { id: 0x159B, name: "Faraday Technology Corp", devices: &[
		Device { id: 0x4321, name: "StorLink SL3516 (Gemini) Host Bridge" },
	] },
	Vendor { id: 0x159C, name: "Stratus Computer Systems", devices: &[
	] },
	Vendor { id: 0x159D, name: "Ningbo Harrison Electronics Co Ltd", devices: &[
	] },
	Vendor { id: 0x159E, name: "A-Max Technology Co Ltd", devices: &[
	] },
	Vendor { id: 0x159F, name: "Galea Network Security", devices: &[
	] },
	Vendor { id: 0x15A0, name: "Compumaster SRL", devices: &[
	] },
	Vendor { id: 0x15A1, name: "Geocast Network Systems", devices: &[
	] },
	Vendor { id: 0x15A2, name: "Catalyst Enterprises Inc", devices: &[
		Device { id: 0x0001, name: "TA700 PCI Bus Analyzer/Exerciser" },
	] },
	Vendor { id: 0x15A3, name: "Italtel", devices: &[
	] },
	Vendor { id: 0x15A4, name: "X-Net OY", devices: &[
	] },
	Vendor { id: 0x15A5, name: "Toyota Macs Inc", devices: &[
	] },
	Vendor { id: 0x15A6, name: "Sunlight Ultrasound Technologies Ltd", devices: &[
	] },
	Vendor { id: 0x15A7, name: "SSE Telecom Inc", devices: &[
	] },
	Vendor { id: 0x15A8, name: "Shanghai Communications Technologies Center", devices: &[
	] },
	Vendor { id: 0x15AA, name: "Moreton Bay", devices: &[
	] },
	Vendor { id: 0x15AB, name: "Bluesteel Networks Inc", devices: &[
	] },
	Vendor { id: 0x15AC, name: "North Atlantic Instruments", devices: &[
		Device { id: 0x6893, name: "3U OpenVPX Multi-function I/O Board [Model 68C3]" },
	] },
	Vendor { id: 0x15AD, name: "VMware", devices: &[
		Device { id: 0x0405, name: "SVGA II Adapter" },
		Device { id: 0x0710, name: "SVGA Adapter" },
		Device { id: 0x0720, name: "VMXNET Ethernet Controller" },
		Device { id: 0x0740, name: "Virtual Machine Communication Interface" },
		Device { id: 0x0770, name: "USB2 EHCI Controller" },
		Device { id: 0x0774, name: "USB1.1 UHCI Controller" },
		Device { id: 0x0778, name: "USB3 xHCI 0.96 Controller" },
		Device { id: 0x0779, name: "USB3 xHCI 1.0 Controller" },
		Device { id: 0x0790, name: "PCI bridge" },
		Device { id: 0x07A0, name: "PCI Express Root Port" },
		Device { id: 0x07B0, name: "VMXNET3 Ethernet Controller" },
		Device { id: 0x07C0, name: "PVSCSI SCSI Controller" },
		Device { id: 0x07E0, name: "SATA AHCI controller" },
		Device { id: 0x0801, name: "Virtual Machine Interface" },
		Device { id: 0x0820, name: "Paravirtual RDMA controller" },
		Device { id: 0x1977, name: "HD Audio Controller" },
	] },
	Vendor { id: 0x15AE, name: "Amersham Pharmacia Biotech", devices: &[
	] },
	Vendor { id: 0x15B0, name: "Zoltrix International Ltd", devices: &[
	] },
	Vendor { id: 0x15B1, name: "Source Technology Inc", devices: &[
	] },
	Vendor { id: 0x15B2, name: "Mosaid Technologies Inc", devices: &[
	] },
	Vendor { id: 0x15B3, name: "Mellanox Technologies", devices: &[
		Device { id: 0x0191, name: "MT25408 [ConnectX IB Flash Recovery]" },
		Device { id: 0x01F6, name: "MT27500 Family [ConnectX-3 Flash Recovery]" },
		Device { id: 0x01F8, name: "MT27520 Family [ConnectX-3 Pro Flash Recovery]" },
		Device { id: 0x01FF, name: "MT27600 Family [Connect-IB Flash Recovery]" },
		Device { id: 0x0209, name: "MT27700 Family [ConnectX-4 Flash Recovery]" },
		Device { id: 0x020B, name: "MT27710 Family [ConnectX-4 Lx Flash Recovery]" },
		Device { id: 0x020D, name: "MT28800 Family [ConnectX-5 Flash Recovery]" },
		Device { id: 0x020F, name: "MT28908A0 Family [ConnectX-6 Flash Recovery]" },
		Device { id: 0x0211, name: "MT416842 Family [BlueField SoC Flash Recovery]" },
		Device { id: 0x024E, name: "MT53100 [Spectrum-2, Flash recovery mode]" },
		Device { id: 0x024F, name: "MT53100 [Spectrum-2, Flash recovery mode]" },
		Device { id: 0x0262, name: "MT27710 [ConnectX-4 Lx Programmable] EN" },
		Device { id: 0x0263, name: "MT27710 [ConnectX-4 Lx Programmable Virtual Function] EN" },
		Device { id: 0x0281, name: "NPS-600 Flash Recovery" },
		Device { id: 0x1002, name: "MT25400 Family [ConnectX-2 Virtual Function]" },
		Device { id: 0x1003, name: "MT27500 Family [ConnectX-3]" },
		Device { id: 0x1004, name: "MT27500/MT27520 Family [ConnectX-3/ConnectX-3 Pro Virtual Function]" },
		Device { id: 0x1005, name: "MT27510 Family" },
		Device { id: 0x1006, name: "MT27511 Family" },
		Device { id: 0x1007, name: "MT27520 Family [ConnectX-3 Pro]" },
		Device { id: 0x1009, name: "MT27530 Family" },
		Device { id: 0x100A, name: "MT27531 Family" },
		Device { id: 0x100B, name: "MT27540 Family" },
		Device { id: 0x100C, name: "MT27541 Family" },
		Device { id: 0x100D, name: "MT27550 Family" },
		Device { id: 0x100E, name: "MT27551 Family" },
		Device { id: 0x100F, name: "MT27560 Family" },
		Device { id: 0x1010, name: "MT27561 Family" },
		Device { id: 0x1011, name: "MT27600 [Connect-IB]" },
		Device { id: 0x1012, name: "MT27600 Family [Connect-IB Virtual Function]" },
		Device { id: 0x1013, name: "MT27700 Family [ConnectX-4]" },
		Device { id: 0x1014, name: "MT27700 Family [ConnectX-4 Virtual Function]" },
		Device { id: 0x1015, name: "MT27710 Family [ConnectX-4 Lx]" },
		Device { id: 0x1016, name: "MT27710 Family [ConnectX-4 Lx Virtual Function]" },
		Device { id: 0x1017, name: "MT27800 Family [ConnectX-5]" },
		Device { id: 0x1018, name: "MT27800 Family [ConnectX-5 Virtual Function]" },
		Device { id: 0x1019, name: "MT28800 Family [ConnectX-5 Ex]" },
		Device { id: 0x101A, name: "MT28800 Family [ConnectX-5 Ex Virtual Function]" },
		Device { id: 0x101B, name: "MT28908 Family [ConnectX-6]" },
		Device { id: 0x101C, name: "MT28908 Family [ConnectX-6 Virtual Function]" },
		Device { id: 0x101D, name: "MT28841" },
		Device { id: 0x101E, name: "MT28850" },
		Device { id: 0x101F, name: "MT28851" },
		Device { id: 0x1020, name: "MT28860" },
		Device { id: 0x1021, name: "MT28861" },
		Device { id: 0x1974, name: "MT28800 Family [ConnectX-5 PCIe Bridge]" },
		Device { id: 0x1975, name: "MT416842 Family [BlueField SoC PCIe Bridge]" },
		Device { id: 0x5274, name: "MT21108 InfiniBridge" },
		Device { id: 0x5A44, name: "MT23108 InfiniHost" },
		Device { id: 0x5A45, name: "MT23108 [Infinihost HCA Flash Recovery]" },
		Device { id: 0x5A46, name: "MT23108 PCI Bridge" },
		Device { id: 0x5E8C, name: "MT24204 [InfiniHost III Lx HCA]" },
		Device { id: 0x5E8D, name: "MT25204 [InfiniHost III Lx HCA Flash Recovery]" },
		Device { id: 0x6274, name: "MT25204 [InfiniHost III Lx HCA]" },
		Device { id: 0x6278, name: "MT25208 InfiniHost III Ex (Tavor compatibility mode)" },
		Device { id: 0x6279, name: "MT25208 [InfiniHost III Ex HCA Flash Recovery]" },
		Device { id: 0x6282, name: "MT25208 [InfiniHost III Ex]" },
		Device { id: 0x6340, name: "MT25408 [ConnectX VPI - IB SDR / 10GigE]" },
		Device { id: 0x634A, name: "MT25418 [ConnectX VPI PCIe 2.0 2.5GT/s - IB DDR / 10GigE]" },
		Device { id: 0x6368, name: "MT25448 [ConnectX EN 10GigE, PCIe 2.0 2.5GT/s]" },
		Device { id: 0x6372, name: "MT25408 [ConnectX EN 10GigE 10GBaseT, PCIe 2.0 2.5GT/s]" },
		Device { id: 0x6732, name: "MT26418 [ConnectX VPI PCIe 2.0 5GT/s - IB DDR / 10GigE]" },
		Device { id: 0x673C, name: "MT26428 [ConnectX VPI PCIe 2.0 5GT/s - IB QDR / 10GigE]" },
		Device { id: 0x6746, name: "MT26438 [ConnectX VPI PCIe 2.0 5GT/s - IB QDR / 10GigE Virtualization+]" },
		Device { id: 0x6750, name: "MT26448 [ConnectX EN 10GigE, PCIe 2.0 5GT/s]" },
		Device { id: 0x675A, name: "MT25408 [ConnectX EN 10GigE 10GBaseT, PCIe Gen2 5GT/s]" },
		Device { id: 0x6764, name: "MT26468 [ConnectX EN 10GigE, PCIe 2.0 5GT/s Virtualization+]" },
		Device { id: 0x676E, name: "MT26478 [ConnectX EN 40GigE, PCIe 2.0 5GT/s]" },
		Device { id: 0x6778, name: "MT26488 [ConnectX VPI PCIe 2.0 5GT/s - IB DDR / 10GigE Virtualization+]" },
		Device { id: 0x7101, name: "NPS-400 configuration and management interface" },
		Device { id: 0x7102, name: "NPS-400 network interface PF" },
		Device { id: 0x7103, name: "NPS-400 network interface VF" },
		Device { id: 0x7121, name: "NPS-600 configuration and management interface" },
		Device { id: 0x7122, name: "NPS-600 network interface PF" },
		Device { id: 0x7123, name: "NPS-600 network interface VF" },
		Device { id: 0xA2D0, name: "MT416842 BlueField SoC Crypto enabled" },
		Device { id: 0xA2D1, name: "MT416842 BlueField SoC Crypto disabled" },
		Device { id: 0xA2D2, name: "MT416842 BlueField integrated ConnectX-5 network controller" },
		Device { id: 0xA2D3, name: "MT416842 BlueField multicore SoC family VF" },
		Device { id: 0xC738, name: "MT51136" },
		Device { id: 0xC739, name: "MT51136 GW" },
		Device { id: 0xC838, name: "MT52236" },
		Device { id: 0xC839, name: "MT52236 router" },
		Device { id: 0xCAF1, name: "ConnectX-4 CAPI Function" },
		Device { id: 0xCB84, name: "MT52100" },
		Device { id: 0xCF08, name: "MT53236" },
		Device { id: 0xCF6C, name: "MT53100 [Spectrum-2, 64 x 100GbE switch]" },
		Device { id: 0xD2F0, name: "Switch-IB 3 HDR (200Gbps) switch" },
	] },
	Vendor { id: 0x15B4, name: "CCI/TRIAD", devices: &[
	] },
	Vendor { id: 0x15B5, name: "Cimetrics Inc", devices: &[
	] },
	Vendor { id: 0x15B6, name: "Texas Memory Systems Inc", devices: &[
		Device { id: 0x0001, name: "XP15 DSP Accelerator" },
		Device { id: 0x0002, name: "XP30 DSP Accelerator" },
		Device { id: 0x0003, name: "XP00 Data Acquisition Device" },
		Device { id: 0x0004, name: "XP35 DSP Accelerator" },
		Device { id: 0x0007, name: "XP100 DSP Accelerator [XP100-T0]" },
		Device { id: 0x0008, name: "XP100 DSP Accelerator [XP100-T1]" },
		Device { id: 0x0009, name: "XP100 DSP Accelerator [XP100-E0]" },
		Device { id: 0x000A, name: "XP100 DSP Accelerator [XP100-E1]" },
		Device { id: 0x000E, name: "XP100 DSP Accelerator [XP100-0]" },
		Device { id: 0x000F, name: "XP100 DSP Accelerator [XP100-1]" },
		Device { id: 0x0010, name: "XP100 DSP Accelerator [XP100-P0]" },
		Device { id: 0x0011, name: "XP100 DSP Accelerator [XP100-P1]" },
		Device { id: 0x0012, name: "XP100 DSP Accelerator [XP100-P2]" },
		Device { id: 0x0013, name: "XP100 DSP Accelerator [XP100-P3]" },
		Device { id: 0x0014, name: "RamSan Flash SSD" },
		Device { id: 0x0015, name: "ZBox" },
	] },
	Vendor { id: 0x15B7, name: "Sandisk Corp", devices: &[
		Device { id: 0x2001, name: "Skyhawk Series NVME SSD" },
	] },
	Vendor { id: 0x15B8, name: "ADDI-DATA GmbH", devices: &[
		Device { id: 0x1001, name: "APCI1516 SP controller (16 digi outputs)" },
		Device { id: 0x1003, name: "APCI1032 SP controller (32 digi inputs w/ opto coupler)" },
		Device { id: 0x1004, name: "APCI2032 SP controller (32 digi outputs)" },
		Device { id: 0x1005, name: "APCI2200 SP controller (8/16 digi outputs (relay))" },
		Device { id: 0x1006, name: "APCI1564 SP controller (32 digi ins, 32 digi outs)" },
		Device { id: 0x100A, name: "APCI1696 SP controller (96 TTL I/Os)" },
		Device { id: 0x3001, name: "APCI3501 SP controller (analog output board)" },
		Device { id: 0x300F, name: "APCI3600 Noise and vibration measurement board" },
		Device { id: 0x7001, name: "APCI7420 2-port Serial Controller" },
		Device { id: 0x7002, name: "APCI7300 Serial Controller" },
	] },
	Vendor { id: 0x15B9, name: "Maestro Digital Communications", devices: &[
	] },
	Vendor { id: 0x15BA, name: "Impacct Technology Corp", devices: &[
	] },
	Vendor { id: 0x15BB, name: "Portwell Inc", devices: &[
	] },
	Vendor { id: 0x15BC, name: "Agilent Technologies", devices: &[
		Device { id: 0x0100, name: "HPFC-5600 Tachyon DX2+ FC" },
		Device { id: 0x0103, name: "QX4 PCI Express quad 4-gigabit Fibre Channel controller" },
		Device { id: 0x0105, name: "Celerity FC-44XS/FC-42XS/FC-41XS/FC-44ES/FC-42ES/FC-41ES" },
		Device { id: 0x1100, name: "E8001-66442 PCI Express CIC" },
		Device { id: 0x2922, name: "64 Bit, 133MHz PCI-X Exerciser & Protocol Checker" },
		Device { id: 0x2928, name: "64 Bit, 66MHz PCI Exerciser & Analyzer" },
		Device { id: 0x2929, name: "64 Bit, 133MHz PCI-X Analyzer & Exerciser" },
	] },
	Vendor { id: 0x15BD, name: "DFI Inc", devices: &[
	] },
	Vendor { id: 0x15BE, name: "Sola Electronics", devices: &[
	] },
	Vendor { id: 0x15BF, name: "High Tech Computer Corp (HTC)", devices: &[
	] },
	Vendor { id: 0x15C0, name: "BVM Ltd", devices: &[
	] },
	Vendor { id: 0x15C1, name: "Quantel", devices: &[
	] },
	Vendor { id: 0x15C2, name: "Newer Technology Inc", devices: &[
	] },
	Vendor { id: 0x15C3, name: "Taiwan Mycomp Co Ltd", devices: &[
	] },
	Vendor { id: 0x15C4, name: "EVSX Inc", devices: &[
	] },
	Vendor { id: 0x15C5, name: "Procomp Informatics Ltd", devices: &[
		Device { id: 0x8010, name: "1394b - 1394 Firewire 3-Port Host Adapter Card" },
	] },
	Vendor { id: 0x15C6, name: "Technical University of Budapest", devices: &[
	] },
	Vendor { id: 0x15C7, name: "Tateyama System Laboratory Co Ltd", devices: &[
		Device { id: 0x0349, name: "Tateyama C-PCI PLC/NC card Rev.01A" },
	] },
	Vendor { id: 0x15C8, name: "Penta Media Co Ltd", devices: &[
	] },
	Vendor { id: 0x15C9, name: "Serome Technology Inc", devices: &[
	] },
	Vendor { id: 0x15CA, name: "Bitboys OY", devices: &[
	] },
	Vendor { id: 0x15CB, name: "AG Electronics Ltd", devices: &[
	] },
	Vendor { id: 0x15CC, name: "Hotrail Inc", devices: &[
	] },
	Vendor { id: 0x15CD, name: "Dreamtech Co Ltd", devices: &[
	] },
	Vendor { id: 0x15CE, name: "Genrad Inc", devices: &[
	] },
	Vendor { id: 0x15CF, name: "Hilscher GmbH", devices: &[
		Device { id: 0x0000, name: "CIFX 50E-DP(M/S)" },
	] },
	Vendor { id: 0x15D1, name: "Infineon Technologies AG", devices: &[
	] },
	Vendor { id: 0x15D2, name: "FIC (First International Computer Inc)", devices: &[
	] },
	Vendor { id: 0x15D3, name: "NDS Technologies Israel Ltd", devices: &[
	] },
	Vendor { id: 0x15D4, name: "Iwill Corp", devices: &[
	] },
	Vendor { id: 0x15D5, name: "Tatung Co", devices: &[
	] },
	Vendor { id: 0x15D6, name: "Entridia Corp", devices: &[
	] },
	Vendor { id: 0x15D7, name: "Rockwell-Collins Inc", devices: &[
	] },
	Vendor { id: 0x15D8, name: "Cybernetics Technology Co Ltd", devices: &[
	] },
	Vendor { id: 0x15D9, name: "Super Micro Computer Inc", devices: &[
	] },
	Vendor { id: 0x15DA, name: "Cyberfirm Inc", devices: &[
	] },
	Vendor { id: 0x15DB, name: "Applied Computing Systems Inc", devices: &[
	] },
	Vendor { id: 0x15DC, name: "Litronic Inc", devices: &[
		Device { id: 0x0001, name: "Argus 300 PCI Cryptography Module" },
	] },
	Vendor { id: 0x15DD, name: "Sigmatel Inc", devices: &[
	] },
	Vendor { id: 0x15DE, name: "Malleable Technologies Inc", devices: &[
	] },
	Vendor { id: 0x15DF, name: "Infinilink Corp", devices: &[
	] },
	Vendor { id: 0x15E0, name: "Cacheflow Inc", devices: &[
	] },
	Vendor { id: 0x15E1, name: "Voice Technologies Group Inc", devices: &[
	] },
	Vendor { id: 0x15E2, name: "Quicknet Technologies Inc", devices: &[
		Device { id: 0x0500, name: "PhoneJack-PCI" },
	] },
	Vendor { id: 0x15E3, name: "Networth Technologies Inc", devices: &[
	] },
	Vendor { id: 0x15E4, name: "VSN Systemen BV", devices: &[
	] },
	Vendor { id: 0x15E5, name: "Valley technologies Inc", devices: &[
	] },
	Vendor { id: 0x15E6, name: "Agere Inc", devices: &[
	] },
	Vendor { id: 0x15E7, name: "Get Engineering Corp", devices: &[
	] },
	Vendor { id: 0x15E8, name: "National Datacomm Corp", devices: &[
		Device { id: 0x0130, name: "Wireless PCI Card" },
		Device { id: 0x0131, name: "NCP130A2 Wireless NIC" },
	] },
	Vendor { id: 0x15E9, name: "Pacific Digital Corp", devices: &[
		Device { id: 0x1841, name: "ADMA-100 DiscStaQ ATA Controller" },
	] },
	Vendor { id: 0x15EA, name: "Tokyo Denshi Sekei K.K.", devices: &[
	] },
	Vendor { id: 0x15EB, name: "DResearch Digital Media Systems GmbH", devices: &[
	] },
	Vendor { id: 0x15EC, name: "Beckhoff GmbH", devices: &[
		Device { id: 0x3101, name: "FC3101 Profibus DP 1 Channel PCI" },
		Device { id: 0x5102, name: "FC5102" },
	] },
	Vendor { id: 0x15ED, name: "Macrolink Inc", devices: &[
	] },
	Vendor { id: 0x15EE, name: "In Win Development Inc", devices: &[
	] },
	Vendor { id: 0x15EF, name: "Intelligent Paradigm Inc", devices: &[
	] },
	Vendor { id: 0x15F0, name: "B-Tree Systems Inc", devices: &[
	] },
	Vendor { id: 0x15F1, name: "Times N Systems Inc", devices: &[
	] },
	Vendor { id: 0x15F2, name: "Diagnostic Instruments Inc", devices: &[
	] },
	Vendor { id: 0x15F3, name: "Digitmedia Corp", devices: &[
	] },
	Vendor { id: 0x15F4, name: "Valuesoft", devices: &[
	] },
	Vendor { id: 0x15F5, name: "Power Micro Research", devices: &[
	] },
	Vendor { id: 0x15F6, name: "Extreme Packet Device Inc", devices: &[
	] },
	Vendor { id: 0x15F7, name: "Banctec", devices: &[
	] },
	Vendor { id: 0x15F8, name: "Koga Electronics Co", devices: &[
	] },
	Vendor { id: 0x15F9, name: "Zenith Electronics Corp", devices: &[
	] },
	Vendor { id: 0x15FA, name: "J.P. Axzam Corp", devices: &[
	] },
	Vendor { id: 0x15FB, name: "Zilog Inc", devices: &[
	] },
	Vendor { id: 0x15FC, name: "Techsan Electronics Co Ltd", devices: &[
	] },
	Vendor { id: 0x15FD, name: "N-CUBED.NET", devices: &[
	] },
	Vendor { id: 0x15FE, name: "Kinpo Electronics Inc", devices: &[
	] },
	Vendor { id: 0x15FF, name: "Fastpoint Technologies Inc", devices: &[
	] },
	Vendor { id: 0x1600, name: "Northrop Grumman - Canada Ltd", devices: &[
	] },
	Vendor { id: 0x1601, name: "Tenta Technology", devices: &[
	] },
	Vendor { id: 0x1602, name: "Prosys-tec Inc", devices: &[
	] },
	Vendor { id: 0x1603, name: "Nokia Wireless Communications", devices: &[
	] },
	Vendor { id: 0x1604, name: "Central System Research Co Ltd", devices: &[
	] },
	Vendor { id: 0x1605, name: "Pairgain Technologies", devices: &[
	] },
	Vendor { id: 0x1606, name: "Europop AG", devices: &[
	] },
	Vendor { id: 0x1607, name: "Lava Semiconductor Manufacturing Inc", devices: &[
	] },
	Vendor { id: 0x1608, name: "Automated Wagering International", devices: &[
	] },
	Vendor { id: 0x1609, name: "Scimetric Instruments Inc", devices: &[
	] },
	Vendor { id: 0x1612, name: "Telesynergy Research Inc.", devices: &[
	] },
	Vendor { id: 0x1618, name: "Stone Ridge Technology", devices: &[
		Device { id: 0x0001, name: "RDX 11" },
		Device { id: 0x0002, name: "HFT-01" },
		Device { id: 0x0400, name: "FarSync T2P (2 port X.21/V.35/V.24)" },
		Device { id: 0x0440, name: "FarSync T4P (4 port X.21/V.35/V.24)" },
		Device { id: 0x0610, name: "FarSync T1U (1 port X.21/V.35/V.24)" },
		Device { id: 0x0620, name: "FarSync T2U (2 port X.21/V.35/V.24)" },
		Device { id: 0x0640, name: "FarSync T4U (4 port X.21/V.35/V.24)" },
		Device { id: 0x1610, name: "FarSync TE1 (T1,E1)" },
		Device { id: 0x2610, name: "FarSync DSL-S1 (SHDSL)" },
		Device { id: 0x3640, name: "FarSync T4E (4-port X.21/V.35/V.24)" },
		Device { id: 0x4620, name: "FarSync T2Ue PCI Express (2-port X.21/V.35/V.24)" },
		Device { id: 0x4640, name: "FarSync T4Ue PCI Express (4-port X.21/V.35/V.24)" },
	] },
	Vendor { id: 0x1619, name: "FarSite Communications Ltd", devices: &[
		Device { id: 0x0400, name: "FarSync T2P (2 port X.21/V.35/V.24)" },
		Device { id: 0x0440, name: "FarSync T4P (4 port X.21/V.35/V.24)" },
		Device { id: 0x0610, name: "FarSync T1U (1 port X.21/V.35/V.24)" },
		Device { id: 0x0620, name: "FarSync T2U (2 port X.21/V.35/V.24)" },
		Device { id: 0x0640, name: "FarSync T4U (4 port X.21/V.35/V.24)" },
		Device { id: 0x1610, name: "FarSync TE1 (T1,E1)" },
		Device { id: 0x1612, name: "FarSync TE1 PCI Express (T1,E1)" },
		Device { id: 0x2610, name: "FarSync DSL-S1 (SHDSL)" },
		Device { id: 0x3640, name: "FarSync T4E (4-port X.21/V.35/V.24)" },
		Device { id: 0x4620, name: "FarSync T2Ue PCI Express (2-port X.21/V.35/V.24)" },
		Device { id: 0x4640, name: "FarSync T4Ue PCI Express (4-port X.21/V.35/V.24)" },
		Device { id: 0x5621, name: "FarSync T2Ee PCI Express (2 port X.21/V.35/V.24)" },
		Device { id: 0x5641, name: "FarSync T4Ee PCI Express (4 port X.21/V.35/V.24)" },
		Device { id: 0x6620, name: "FarSync T2U-PMC PCI Express (2 port X.21/V.35/V.24)" },
	] },
	Vendor { id: 0x161F, name: "Rioworks", devices: &[
	] },
	Vendor { id: 0x1626, name: "TDK Semiconductor Corp.", devices: &[
		Device { id: 0x8410, name: "RTL81xx Fast Ethernet" },
	] },
	Vendor { id: 0x1629, name: "Kongsberg Spacetec AS", devices: &[
		Device { id: 0x1003, name: "Format synchronizer v3.0" },
		Device { id: 0x1006, name: "Format synchronizer, model 10500" },
		Device { id: 0x1007, name: "Format synchronizer, model 21000" },
		Device { id: 0x2002, name: "Fast Universal Data Output" },
	] },
	Vendor { id: 0x1631, name: "Packard Bell B.V.", devices: &[
	] },
	Vendor { id: 0x1638, name: "Standard Microsystems Corp [SMC]", devices: &[
		Device { id: 0x1100, name: "SMC2602W EZConnect / Addtron AWA-100 / Eumitcom PCI WL11000" },
	] },
	Vendor { id: 0x163C, name: "Smart Link Ltd.", devices: &[
		Device { id: 0x3052, name: "SmartLink SmartPCI562 56K Modem" },
		Device { id: 0x5449, name: "SmartPCI561 Modem" },
	] },
	Vendor { id: 0x1641, name: "MKNet Corp.", devices: &[
	] },
	Vendor { id: 0x1642, name: "Bitland(ShenZhen) Information Technology Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1657, name: "Brocade Communications Systems, Inc.", devices: &[
		Device { id: 0x0013, name: "425/825/42B/82B 4Gbps/8Gbps PCIe dual port FC HBA" },
		Device { id: 0x0014, name: "1010/1020/1007/1741 10Gbps CNA" },
		Device { id: 0x0017, name: "415/815/41B/81B 4Gbps/8Gbps PCIe single port FC HBA" },
		Device { id: 0x0021, name: "804 8Gbps FC HBA for HP Bladesystem c-class" },
		Device { id: 0x0022, name: "1860 16Gbps/10Gbps Fabric Adapter" },
		Device { id: 0x0023, name: "1867/1869 16Gbps FC HBA" },
		Device { id: 0x0646, name: "400 4Gbps PCIe FC HBA" },
	] },
	Vendor { id: 0x165A, name: "Epix Inc", devices: &[
		Device { id: 0xC100, name: "PIXCI(R) CL1 Camera Link Video Capture Board [custom QL5232]" },
		Device { id: 0xD200, name: "PIXCI(R) D2X Digital Video Capture Board [custom QL5232]" },
		Device { id: 0xD300, name: "PIXCI(R) D3X Digital Video Capture Board [custom QL5232]" },
		Device { id: 0xEB01, name: "PIXCI(R) EB1 PCI Camera Link Video Capture Board" },
	] },
	Vendor { id: 0x165C, name: "Gidel Ltd.", devices: &[
		Device { id: 0x5361, name: "PROCStarII60-1" },
		Device { id: 0x5362, name: "PROCStarII60-2" },
		Device { id: 0x5364, name: "PROCStarII60-4" },
		Device { id: 0x5435, name: "ProcSparkII" },
		Device { id: 0x5661, name: "ProcE60" },
		Device { id: 0x56E1, name: "ProcE180" },
		Device { id: 0x5911, name: "ProcStarIII110-1" },
		Device { id: 0x5912, name: "ProcStarIII110-2" },
		Device { id: 0x5913, name: "ProcStarIII110-3" },
		Device { id: 0x5914, name: "ProcStarIII110-4" },
		Device { id: 0x5921, name: "ProcStarIII150-1" },
		Device { id: 0x5922, name: "ProcStarIII150-2" },
		Device { id: 0x5923, name: "ProcStarIII150-3" },
		Device { id: 0x5924, name: "ProcStarIII150-4" },
		Device { id: 0x5931, name: "ProcStarIII260-1" },
		Device { id: 0x5932, name: "ProcStarIII260-2" },
		Device { id: 0x5933, name: "ProcStarIII260-3" },
		Device { id: 0x5934, name: "ProcStarIII260-4" },
		Device { id: 0x5941, name: "ProcStarIII340-1" },
		Device { id: 0x5942, name: "ProcStarIII340-2" },
		Device { id: 0x5943, name: "ProcStarIII340-3" },
		Device { id: 0x5944, name: "ProcStarIII340-4" },
		Device { id: 0x5A01, name: "ProceIII80" },
		Device { id: 0x5A11, name: "ProceIII110" },
		Device { id: 0x5A21, name: "ProceIII150" },
		Device { id: 0x5A31, name: "ProceIII260" },
		Device { id: 0x5A41, name: "ProceIII340" },
		Device { id: 0x5B51, name: "ProceIV360" },
		Device { id: 0x5B61, name: "ProceIV530" },
		Device { id: 0x5B71, name: "ProceIV820" },
		Device { id: 0x5C01, name: "ProcStarIV80-1" },
		Device { id: 0x5C02, name: "ProcStarIV80-2" },
		Device { id: 0x5C03, name: "ProcStarIV80-3" },
		Device { id: 0x5C04, name: "ProcStarIV80-4" },
		Device { id: 0x5C11, name: "ProcStarIV110-1" },
		Device { id: 0x5C12, name: "ProcStarIV110-2" },
		Device { id: 0x5C13, name: "ProcStarIV110-3" },
		Device { id: 0x5C14, name: "ProcStarIV110-4" },
		Device { id: 0x5C51, name: "ProcStarIV360-1" },
		Device { id: 0x5C52, name: "ProcStarIV360-2" },
		Device { id: 0x5C53, name: "ProcStarIV360-3" },
		Device { id: 0x5C54, name: "ProcStarIV360-4" },
		Device { id: 0x5C61, name: "ProcStarIV530-1" },
		Device { id: 0x5C62, name: "ProcStarIV530-2" },
		Device { id: 0x5C63, name: "ProcStarIV530-3" },
		Device { id: 0x5C64, name: "ProcStarIV530-4" },
		Device { id: 0x5C71, name: "ProcStarIV820-1" },
		Device { id: 0x5C72, name: "ProcStarIV820-2" },
		Device { id: 0x5C73, name: "ProcStarIV820-3" },
		Device { id: 0x5C74, name: "ProcStarIV820-4" },
		Device { id: 0x5D01, name: "Proc10480" },
		Device { id: 0x5D11, name: "Proc104110" },
		Device { id: 0x5F01, name: "ProceV_A3" },
		Device { id: 0x5F11, name: "ProceV_A7" },
		Device { id: 0x5F21, name: "ProceV_AB" },
		Device { id: 0x5F31, name: "ProceV_D5" },
		Device { id: 0x5F41, name: "ProceV_D8" },
		Device { id: 0x6732, name: "Proc6M" },
		Device { id: 0x6832, name: "Proc12M" },
		Device { id: 0x7101, name: "Proc10a_27" },
		Device { id: 0x7111, name: "Proc10a_48" },
		Device { id: 0x7121, name: "Proc10a_66" },
		Device { id: 0x7141, name: "Proc10a_115" },
		Device { id: 0x7181, name: "Proc10a_27S" },
		Device { id: 0x7191, name: "Proc10a_48S" },
		Device { id: 0x71A1, name: "Proc10a_66S" },
		Device { id: 0x71B1, name: "Proc10A" },
	] },
	Vendor { id: 0x165D, name: "Hsing Tech. Enterprise Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x165F, name: "Linux Media Labs, LLC", devices: &[
		Device { id: 0x1020, name: "LMLM4 MPEG-4 encoder" },
	] },
	Vendor { id: 0x1661, name: "Worldspace Corp.", devices: &[
	] },
	Vendor { id: 0x1668, name: "Actiontec Electronics Inc", devices: &[
		Device { id: 0x0100, name: "Mini-PCI bridge" },
	] },
	Vendor { id: 0x166D, name: "Broadcom Corporation", devices: &[
		Device { id: 0x0001, name: "SiByte BCM1125/1125H/1250 System-on-a-Chip PCI" },
		Device { id: 0x0002, name: "SiByte BCM1125H/1250 System-on-a-Chip HyperTransport" },
		Device { id: 0x0012, name: "SiByte BCM1280/BCM1480 System-on-a-Chip PCI-X" },
		Device { id: 0x0014, name: "Sibyte BCM1280/BCM1480 System-on-a-Chip HyperTransport" },
	] },
	Vendor { id: 0x1677, name: "Bernecker + Rainer", devices: &[
		Device { id: 0x104E, name: "5LS172.6 B&R Dual CAN Interface Card" },
		Device { id: 0x12D7, name: "5LS172.61 B&R Dual CAN Interface Card" },
		Device { id: 0x20AD, name: "5ACPCI.MFIO-K01 Profibus DP / K-Feldbus / COM" },
	] },
	Vendor { id: 0x1678, name: "NetEffect", devices: &[
		Device { id: 0x0100, name: "NE020 10Gb Accelerated Ethernet Adapter (iWARP RNIC)" },
	] },
	Vendor { id: 0x1679, name: "Tokyo Electron Device Ltd.", devices: &[
		Device { id: 0x3000, name: "SD Standard host controller [Ellen]" },
	] },
	Vendor { id: 0x167B, name: "ZyDAS Technology Corp.", devices: &[
		Device { id: 0x2102, name: "ZyDAS ZD1202" },
		Device { id: 0x2116, name: "ZD1212B Wireless Adapter" },
	] },
	Vendor { id: 0x167D, name: "Samsung Electro-Mechanics Co., Ltd.", devices: &[
		Device { id: 0xA000, name: "MagicLAN SWL-2210P 802.11b [Intersil ISL3874]" },
	] },
	Vendor { id: 0x167E, name: "ONNTO Corp.", devices: &[
	] },
	Vendor { id: 0x1681, name: "Hercules", devices: &[
	] },
	Vendor { id: 0x1682, name: "XFX Pine Group Inc.", devices: &[
	] },
	Vendor { id: 0x1688, name: "CastleNet Technology Inc.", devices: &[
		Device { id: 0x1170, name: "WLAN 802.11b card" },
	] },
	Vendor { id: 0x168C, name: "Qualcomm Atheros", devices: &[
		Device { id: 0x0007, name: "AR5210 Wireless Network Adapter [AR5000 802.11a]" },
		Device { id: 0x0011, name: "AR5211 Wireless Network Adapter [AR5001A 802.11a]" },
		Device { id: 0x0012, name: "AR5211 Wireless Network Adapter [AR5001X 802.11ab]" },
		Device { id: 0x0013, name: "AR5212/5213/2414 Wireless Network Adapter" },
		Device { id: 0x001A, name: "AR2413/AR2414 Wireless Network Adapter [AR5005G(S) 802.11bg]" },
		Device { id: 0x001B, name: "AR5413/AR5414 Wireless Network Adapter [AR5006X(S) 802.11abg]" },
		Device { id: 0x001C, name: "AR242x / AR542x Wireless Network Adapter (PCI-Express)" },
		Device { id: 0x001D, name: "AR2417 Wireless Network Adapter [AR5007G 802.11bg]" },
		Device { id: 0x0020, name: "AR5513 802.11abg Wireless NIC" },
		Device { id: 0x0023, name: "AR5416 Wireless Network Adapter [AR5008 802.11(a)bgn]" },
		Device { id: 0x0024, name: "AR5418 Wireless Network Adapter [AR5008E 802.11(a)bgn] (PCI-Express)" },
		Device { id: 0x0027, name: "AR9160 Wireless Network Adapter [AR9001 802.11(a)bgn]" },
		Device { id: 0x0029, name: "AR922X Wireless Network Adapter" },
		Device { id: 0x002A, name: "AR928X Wireless Network Adapter (PCI-Express)" },
		Device { id: 0x002B, name: "AR9285 Wireless Network Adapter (PCI-Express)" },
		Device { id: 0x002C, name: "AR2427 802.11bg Wireless Network Adapter (PCI-Express)" },
		Device { id: 0x002D, name: "AR9227 Wireless Network Adapter" },
		Device { id: 0x002E, name: "AR9287 Wireless Network Adapter (PCI-Express)" },
		Device { id: 0x0030, name: "AR93xx Wireless Network Adapter" },
		Device { id: 0x0032, name: "AR9485 Wireless Network Adapter" },
		Device { id: 0x0033, name: "AR958x 802.11abgn Wireless Network Adapter" },
		Device { id: 0x0034, name: "AR9462 Wireless Network Adapter" },
		Device { id: 0x0036, name: "QCA9565 / AR9565 Wireless Network Adapter" },
		Device { id: 0x0037, name: "AR9485 Wireless Network Adapter" },
		Device { id: 0x003C, name: "QCA986x/988x 802.11ac Wireless Network Adapter" },
		Device { id: 0x003E, name: "QCA6174 802.11ac Wireless Network Adapter" },
		Device { id: 0x0040, name: "QCA9980/9990 802.11ac Wireless Network Adapter" },
		Device { id: 0x0041, name: "QCA6164 802.11ac Wireless Network Adapter" },
		Device { id: 0x0042, name: "QCA9377 802.11ac Wireless Network Adapter" },
		Device { id: 0x0050, name: "QCA9887 802.11ac Wireless Network Adapter" },
		Device { id: 0x0207, name: "AR5210 Wireless Network Adapter [AR5000 802.11a]" },
		Device { id: 0x1014, name: "AR5212 802.11abg NIC" },
		Device { id: 0x9013, name: "AR5002X Wireless Network Adapter" },
		Device { id: 0xFF19, name: "AR5006X Wireless Network Adapter" },
		Device { id: 0xFF1B, name: "AR2425 Wireless Network Adapter [AR5007EG 802.11bg]" },
		Device { id: 0xFF1C, name: "AR5008 Wireless Network Adapter" },
		Device { id: 0xFF1D, name: "AR922x Wireless Network Adapter" },
	] },
	Vendor { id: 0x1695, name: "EPoX Computer Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x169C, name: "Netcell Corporation", devices: &[
		Device { id: 0x0044, name: "Revolution Storage Processing Card" },
	] },
	Vendor { id: 0x169D, name: "Club-3D VB (Wrong ID)", devices: &[
	] },
	Vendor { id: 0x16A5, name: "Tekram Technology Co.,Ltd.", devices: &[
	] },
	Vendor { id: 0x16AB, name: "Global Sun Technology Inc", devices: &[
		Device { id: 0x1100, name: "GL24110P" },
		Device { id: 0x1101, name: "PLX9052 PCMCIA-to-PCI Wireless LAN" },
		Device { id: 0x1102, name: "PCMCIA-to-PCI Wireless Network Bridge" },
		Device { id: 0x8501, name: "WL-8305 Wireless LAN PCI Adapter" },
	] },
	Vendor { id: 0x16AE, name: "SafeNet Inc", devices: &[
		Device { id: 0x0001, name: "SafeXcel 1140" },
		Device { id: 0x000A, name: "SafeXcel 1841" },
		Device { id: 0x1141, name: "SafeXcel 1141" },
		Device { id: 0x1841, name: "SafeXcel 1842" },
	] },
	Vendor { id: 0x16AF, name: "SparkLAN Communications, Inc.", devices: &[
	] },
	Vendor { id: 0x16B4, name: "Aspex Semiconductor Ltd", devices: &[
	] },
	Vendor { id: 0x16B8, name: "Sonnet Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x16BE, name: "Creatix Polymedia GmbH", devices: &[
	] },
	Vendor { id: 0x16C3, name: "Synopsys, Inc.", devices: &[
	] },
	Vendor { id: 0x16C6, name: "Micrel-Kendin", devices: &[
		Device { id: 0x8695, name: "Centaur KS8695 ARM processor" },
		Device { id: 0x8842, name: "KSZ8842-PMQL 2-Port Ethernet Switch" },
	] },
	Vendor { id: 0x16C8, name: "Octasic Inc.", devices: &[
	] },
	Vendor { id: 0x16C9, name: "EONIC B.V. The Netherlands", devices: &[
	] },
	Vendor { id: 0x16CA, name: "CENATEK Inc", devices: &[
		Device { id: 0x0001, name: "Rocket Drive DL" },
	] },
	Vendor { id: 0x16CD, name: "Advantech Co. Ltd", devices: &[
		Device { id: 0x0101, name: "DirectPCI SRAM for DPX-11x series" },
		Device { id: 0x0102, name: "DirectPCI SRAM for DPX-S/C/E-series" },
		Device { id: 0x0103, name: "DirectPCI ROM for DPX-11x series" },
		Device { id: 0x0104, name: "DirectPCI ROM for DPX-S/C/E-series" },
		Device { id: 0x0105, name: "DirectPCI I/O for DPX-114/DPX-115" },
		Device { id: 0x0106, name: "DirectPCI I/O for DPX-116" },
		Device { id: 0x0107, name: "DirectPCI I/O for DPX-116U" },
		Device { id: 0x0108, name: "DirectPCI I/O for DPX-117" },
		Device { id: 0x0109, name: "DirectPCI I/O for DPX-112" },
		Device { id: 0x010A, name: "DirectPCI I/O for DPX-C/E-series" },
		Device { id: 0x010B, name: "DirectPCI I/O for DPX-S series" },
	] },
	Vendor { id: 0x16CE, name: "Roland Corp.", devices: &[
	] },
	Vendor { id: 0x16D5, name: "Acromag, Inc.", devices: &[
		Device { id: 0x0504, name: "PMC-DX504 Reconfigurable FPGA with LVDS I/O" },
		Device { id: 0x0520, name: "PMC520 Serial Communication, 232 Octal" },
		Device { id: 0x0521, name: "PMC521 Serial Communication, 422/485 Octal" },
		Device { id: 0x1020, name: "PMC-AX1020 Reconfigurable FPGA with A/D & D/A" },
		Device { id: 0x1065, name: "PMC-AX1065 Reconfigurable FPGA with A/D & D/A" },
		Device { id: 0x2004, name: "PMC-DX2004 Reconfigurable FPGA with LVDS I/O" },
		Device { id: 0x2020, name: "PMC-AX2020 Reconfigurable FPGA with A/D & D/A" },
		Device { id: 0x2065, name: "PMC-AX2065 Reconfigurable FPGA with A/D & D/A" },
		Device { id: 0x3020, name: "PMC-AX3020 Reconfigurable FPGA with A/D & D/A" },
		Device { id: 0x3065, name: "PMC-AX3065 Reconfigurable FPGA with A/D & D/A" },
		Device { id: 0x4243, name: "PMC424, APC424, AcPC424 Digital I/O and Counter Timer Module" },
		Device { id: 0x4248, name: "PMC464, APC464, AcPC464 Digital I/O and Counter Timer Module" },
		Device { id: 0x424B, name: "PMC-DX2002 Reconfigurable FPGA with Differential I/O" },
		Device { id: 0x4253, name: "PMC-DX503 Reconfigurable FPGA with TTL and Differential I/O" },
		Device { id: 0x4312, name: "PMC-CX1002 Reconfigurable Conduction-Cooled FPGA Virtex-II with Differential I/O" },
		Device { id: 0x4313, name: "PMC-CX1003 Reconfigurable Conduction-Cooled FPGA Virtex-II with CMOS and Differential I/O" },
		Device { id: 0x4322, name: "PMC-CX2002 Reconfigurable Conduction-Cooled FPGA Virtex-II with Differential I/O" },
		Device { id: 0x4323, name: "PMC-CX2003 Reconfigurable Conduction-Cooled FPGA Virtex-II with CMOS and Differential I/O" },
		Device { id: 0x4350, name: "PMC-DX501 Reconfigurable Digital I/O Module" },
		Device { id: 0x4353, name: "PMC-DX2003 Reconfigurable FPGA with TTL and Differential I/O" },
		Device { id: 0x4357, name: "PMC-DX502 Reconfigurable Differential I/O Module" },
		Device { id: 0x4457, name: "PMC730, APC730, AcPC730 Multifunction Module" },
		Device { id: 0x464D, name: "PMC408 32-Channel Digital Input/Output Module" },
		Device { id: 0x4850, name: "PMC220-16 12-Bit Analog Output Module" },
		Device { id: 0x4A42, name: "PMC483, APC483, AcPC483 Counter Timer Module" },
		Device { id: 0x4A50, name: "PMC484, APC484, AcPC484 Counter Timer Module" },
		Device { id: 0x4A56, name: "PMC230 16-Bit Analog Output Module" },
		Device { id: 0x4B47, name: "PMC330, APC330, AcPC330 Analog Input Module, 16-bit A/D" },
		Device { id: 0x4C40, name: "PMC-LX40 Reconfigurable Virtex-4 FPGA with plug-in I/O" },
		Device { id: 0x4C60, name: "PMC-LX60 Reconfigurable Virtex-4 FPGA with plug-in I/O" },
		Device { id: 0x4D4D, name: "PMC341, APC341, AcPC341 Analog Input Module, Simultaneous Sample & Hold" },
		Device { id: 0x4D4E, name: "PMC482, APC482, AcPC482 Counter Timer Board" },
		Device { id: 0x524D, name: "PMC-DX2001 Reconfigurable FPGA with TTL I/O" },
		Device { id: 0x5335, name: "PMC-SX35 Reconfigurable Virtex-4 FPGA with plug-in I/O" },
		Device { id: 0x5456, name: "PMC470 48-Channel Digital Input/Output Module" },
		Device { id: 0x5601, name: "PMC-VLX85 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5602, name: "PMC-VLX110 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5603, name: "PMC-VSX95 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5604, name: "PMC-VLX155 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5605, name: "PMC-VFX70 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5606, name: "PMC-VLX155-1M Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5701, name: "PMC-SLX150: Reconfigurable Spartan-6 FPGA with plug-in I/O" },
		Device { id: 0x5702, name: "PMC-SLX150-1M: Reconfigurable Spartan-6 FPGA with plug-in I/O" },
		Device { id: 0x5801, name: "XMC-VLX85 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5802, name: "XMC-VLX110 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5803, name: "XMC-VSX95 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5804, name: "XMC-VLX155 Reconfigurable Virtex-5 FPGA with plug-in I/O" },
		Device { id: 0x5807, name: "XMC-SLX150: Reconfigurable Spartan-6 FPGA with plug-in I/O" },
		Device { id: 0x5808, name: "XMC-SLX150-1M: Reconfigurable Spartan-6 FPGA with plug-in I/O" },
		Device { id: 0x5901, name: "APCe8650 PCI Express IndustryPack Carrier Card" },
		Device { id: 0x6301, name: "XMC Module with user-configurable Virtex-6 FPGA, 240k logic cells, SFP front I/O" },
		Device { id: 0x6302, name: "XMC Module with user-configurable Virtex-6 FPGA, 365k logic cells, SFP front I/O" },
		Device { id: 0x6303, name: "XMC Module with user-configurable Virtex-6 FPGA, 240k logic cells, no front I/O" },
		Device { id: 0x6304, name: "XMC Module with user-configurable Virtex-6 FPGA, 365k logic cells, no front I/O" },
		Device { id: 0x7000, name: "XMC-7K325F: User-configurable Kintex-7 FPGA, 325k logic cells plus SFP front I/O" },
		Device { id: 0x7001, name: "XMC-7K410F: User-configurable Kintex-7 FPGA, 410k logic cells plus SFP front I/O" },
		Device { id: 0x7002, name: "XMC-7K325AX: User-Configurable Kintex-7 FPGA, 325k logic cells with AXM Plug-In I/O" },
		Device { id: 0x7003, name: "XMC-7K410AX: User-Configurable Kintex-7 FPGA, 410k logic cells with AXM Plug-In I/O" },
		Device { id: 0x7004, name: "XMC-7K325CC: User-Configurable Kintex-7 FPGA, 325k logic cells, conduction-cooled" },
		Device { id: 0x7005, name: "XMC-7K410CC: User-Configurable Kintex-7 FPGA, 410k logic cells, conduction-cooled" },
		Device { id: 0x7006, name: "XMC-7A200: User-Configurable Artix-7 FPGA, 200k logic cells with Plug-In I/O" },
		Device { id: 0x7007, name: "XMC-7A200CC: User-Configurable Conduction-Cooled Artix-7 FPGA, with 200k logic cells" },
		Device { id: 0x7011, name: "AP440-1: 32-Channel Isolated Digital Input Module" },
		Device { id: 0x7012, name: "AP440-2: 32-Channel Isolated Digital Input Module" },
		Device { id: 0x7013, name: "AP440-3: 32-Channel Isolated Digital Input Module" },
		Device { id: 0x7014, name: "AP445: 32-Channel Isolated Digital Output Module" },
		Device { id: 0x7016, name: "AP470 48-Channel TTL Level Digital Input/Output Module" },
		Device { id: 0x7017, name: "AP323 16-bit, 20 or 40 Channel Analog Input Module" },
		Device { id: 0x7018, name: "AP408: 32-Channel Digital I/O Module" },
		Device { id: 0x7019, name: "AP341 14-bit, 16-Channel Simultaneous Conversion Analog Input Module" },
		Device { id: 0x701A, name: "AP220-16 12-Bit, 16-Channel Analog Output Module" },
		Device { id: 0x701B, name: "AP231-16 16-Bit, 16-Channel Analog Output Module" },
		Device { id: 0x7021, name: "APA7-201 Reconfigurable Artix-7 FPGA module 48 TTL channels" },
		Device { id: 0x7022, name: "APA7-202 Reconfigurable Artix-7 FPGA module 24 RS485 channels" },
		Device { id: 0x7023, name: "APA7-203 Reconfigurable Artix-7 FPGA module 24 TTL & 12 RS485 channels" },
		Device { id: 0x7024, name: "APA7-204 Reconfigurable Artix-7 FPGA module 24 LVDS channels" },
		Device { id: 0x7027, name: "AP418 16-Channel High Voltage Digital Input/Output Module" },
		Device { id: 0x7042, name: "AP482 Counter Timer Module with TTL Level Input/Output" },
		Device { id: 0x7043, name: "AP483 Counter Timer Module with TTL Level and RS422 Input/Output" },
		Device { id: 0x7044, name: "AP484 Counter Timer Module with RS422 Input/Output" },
	] },
	Vendor { id: 0x16DA, name: "Advantech Co., Ltd.", devices: &[
		Device { id: 0x0011, name: "INES GPIB-PCI" },
	] },
	Vendor { id: 0x16DF, name: "PIKA Technologies Inc.", devices: &[
	] },
	Vendor { id: 0x16E2, name: "Geotest-MTS", devices: &[
	] },
	Vendor { id: 0x16E3, name: "European Space Agency", devices: &[
		Device { id: 0x1E0F, name: "LEON2FT Processor" },
	] },
	Vendor { id: 0x16E5, name: "Intellon Corp.", devices: &[
		Device { id: 0x6000, name: "INT6000 Ethernet-to-Powerline Bridge [HomePlug AV]" },
		Device { id: 0x6300, name: "INT6300 Ethernet-to-Powerline Bridge [HomePlug AV]" },
	] },
	Vendor { id: 0x16EC, name: "U.S. Robotics", devices: &[
		Device { id: 0x00ED, name: "USR997900" },
		Device { id: 0x0116, name: "USR997902 10/100/1000 Mbps PCI Network Card" },
		Device { id: 0x2F00, name: "USR5660A (USR265660A, USR5660A-BP) 56K PCI Faxmodem" },
		Device { id: 0x3685, name: "Wireless Access PCI Adapter Model 022415" },
		Device { id: 0x4320, name: "USR997904 10/100/1000 64-bit NIC (Marvell Yukon)" },
		Device { id: 0xAB06, name: "USR997901A 10/100 Cardbus NIC" },
	] },
	Vendor { id: 0x16ED, name: "Sycron N. V.", devices: &[
		Device { id: 0x1001, name: "UMIO communication card" },
	] },
	Vendor { id: 0x16F2, name: "ETAS GmbH", devices: &[
		Device { id: 0x0200, name: "I/O board" },
	] },
	Vendor { id: 0x16F3, name: "Jetway Information Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x16F4, name: "Vweb Corp", devices: &[
		Device { id: 0x8000, name: "VW2010" },
	] },
	Vendor { id: 0x16F6, name: "VideoTele.com, Inc.", devices: &[
	] },
	Vendor { id: 0x1702, name: "Internet Machines Corporation (IMC)", devices: &[
	] },
	Vendor { id: 0x1705, name: "Digital First, Inc.", devices: &[
	] },
	Vendor { id: 0x170B, name: "NetOctave", devices: &[
		Device { id: 0x0100, name: "NSP2000-SSL crypto accelerator" },
	] },
	Vendor { id: 0x170C, name: "YottaYotta Inc.", devices: &[
	] },
	Vendor { id: 0x1719, name: "EZChip Technologies", devices: &[
		Device { id: 0x1000, name: "NPA Access Network Processor Family" },
	] },
	Vendor { id: 0x1725, name: "Vitesse Semiconductor", devices: &[
		Device { id: 0x7174, name: "VSC7174 PCI/PCI-X Serial ATA Host Bus Controller" },
	] },
	Vendor { id: 0x172A, name: "Accelerated Encryption", devices: &[
		Device { id: 0x13C8, name: "AEP SureWare Runner 1000V3" },
	] },
	Vendor { id: 0x1734, name: "Fujitsu Technology Solutions", devices: &[
	] },
	Vendor { id: 0x1735, name: "Aten International Co. Ltd.", devices: &[
	] },
	Vendor { id: 0x1737, name: "Linksys", devices: &[
		Device { id: 0x0029, name: "WPG54G ver. 4 PCI Card" },
		Device { id: 0x1032, name: "Gigabit Network Adapter" },
		Device { id: 0x1064, name: "Gigabit Network Adapter" },
		Device { id: 0xAB08, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
		Device { id: 0xAB09, name: "21x4x DEC-Tulip compatible 10/100 Ethernet" },
	] },
	Vendor { id: 0x173B, name: "Altima (nee Broadcom)", devices: &[
		Device { id: 0x03E8, name: "AC1000 Gigabit Ethernet" },
		Device { id: 0x03E9, name: "AC1001 Gigabit Ethernet" },
		Device { id: 0x03EA, name: "AC9100 Gigabit Ethernet" },
		Device { id: 0x03EB, name: "AC1003 Gigabit Ethernet" },
	] },
	Vendor { id: 0x1743, name: "Peppercon AG", devices: &[
		Device { id: 0x8139, name: "ROL/F-100 Fast Ethernet Adapter with ROL" },
	] },
	Vendor { id: 0x1745, name: "ViXS Systems, Inc.", devices: &[
		Device { id: 0x2020, name: "XCode II Series" },
		Device { id: 0x2100, name: "XCode 2100 Series" },
	] },
	Vendor { id: 0x1749, name: "RLX Technologies", devices: &[
	] },
	Vendor { id: 0x174B, name: "PC Partner Limited / Sapphire Technology", devices: &[
	] },
	Vendor { id: 0x174D, name: "WellX Telecom SA", devices: &[
	] },
	Vendor { id: 0x175C, name: "AudioScience Inc", devices: &[
	] },
	Vendor { id: 0x175E, name: "Sanera Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x1760, name: "TEDIA spol. s r. o.", devices: &[
		Device { id: 0x0101, name: "PCD-7004 Digital Bi-Directional Ports PCI Card" },
		Device { id: 0x0102, name: "PCD-7104 Digital Input & Output PCI Card" },
		Device { id: 0x0303, name: "PCD-7006C Digital Input & Output PCI Card" },
	] },
	Vendor { id: 0x1771, name: "InnoVISION Multimedia Ltd.", devices: &[
	] },
	Vendor { id: 0x1775, name: "GE Intelligent Platforms", devices: &[
	] },
	Vendor { id: 0x177D, name: "Cavium, Inc.", devices: &[
		Device { id: 0x0001, name: "Nitrox XL N1" },
		Device { id: 0x0003, name: "Nitrox XL N1 Lite" },
		Device { id: 0x0004, name: "Octeon (and older) FIPS" },
		Device { id: 0x0005, name: "Octeon CN38XX Network Processor Pass 3.x" },
		Device { id: 0x0006, name: "RoHS" },
		Device { id: 0x0010, name: "Nitrox XL NPX" },
		Device { id: 0x0020, name: "Octeon CN31XX Network Processor" },
		Device { id: 0x0030, name: "Octeon CN30XX Network Processor" },
		Device { id: 0x0040, name: "Octeon CN58XX Network Processor" },
		Device { id: 0x0050, name: "Octeon CN57XX Network Processor (CN54XX/CN55XX/CN56XX)" },
		Device { id: 0x0070, name: "Octeon CN50XX Network Processor" },
		Device { id: 0x0080, name: "Octeon CN52XX Network Processor" },
		Device { id: 0x0090, name: "Octeon II CN63XX Network Processor" },
		Device { id: 0x0091, name: "Octeon II CN68XX Network Processor" },
		Device { id: 0x0092, name: "Octeon II CN65XX Network Processor" },
		Device { id: 0x0093, name: "Octeon II CN61XX Network Processor" },
		Device { id: 0x0094, name: "Octeon Fusion CNF71XX Cell processor" },
		Device { id: 0x0095, name: "Octeon III CN78XX Network Processor" },
		Device { id: 0x0096, name: "Octeon III CN70XX Network Processor" },
		Device { id: 0x9700, name: "Octeon III CN73XX Network Processor" },
		Device { id: 0x9702, name: "CN23XX [LiquidIO II] Intelligent Adapter" },
		Device { id: 0x9703, name: "CN23XX [LiquidIO II] NVMe Controller" },
		Device { id: 0x9712, name: "CN23XX [LiquidIO II] SRIOV Virtual Function" },
		Device { id: 0x9713, name: "CN23XX [LiquidIO II] NVMe SRIOV Virtual Function" },
		Device { id: 0x9800, name: "Octeon Fusion CNF75XX Processor" },
		Device { id: 0xA001, name: "ThunderX MRML(Master RML Bridge to RSL devices)" },
		Device { id: 0xA002, name: "THUNDERX PCC Bridge" },
		Device { id: 0xA008, name: "THUNDERX SMMU" },
		Device { id: 0xA009, name: "THUNDERX Generic Interrupt Controller" },
		Device { id: 0xA00A, name: "THUNDERX GPIO Controller" },
		Device { id: 0xA00B, name: "THUNDERX MPI / SPI Controller" },
		Device { id: 0xA00C, name: "THUNDERX MIO-PTP Controller" },
		Device { id: 0xA00D, name: "THUNDERX MIX Network Controller" },
		Device { id: 0xA00E, name: "THUNDERX Reset Controller" },
		Device { id: 0xA00F, name: "THUNDERX UART Controller" },
		Device { id: 0xA010, name: "THUNDERX eMMC/SD Controller" },
		Device { id: 0xA011, name: "THUNDERX MIO-BOOT Controller" },
		Device { id: 0xA012, name: "THUNDERX TWSI / I2C Controller" },
		Device { id: 0xA013, name: "THUNDERX CCPI (Multi-node connect)" },
		Device { id: 0xA014, name: "THUNDERX Voltage Regulator Module" },
		Device { id: 0xA015, name: "THUNDERX PCIe Switch Logic Interface" },
		Device { id: 0xA016, name: "THUNDERX Key Memory" },
		Device { id: 0xA017, name: "THUNDERX GTI (Global System Timers)" },
		Device { id: 0xA018, name: "THUNDERX Random Number Generator" },
		Device { id: 0xA019, name: "THUNDERX DFA" },
		Device { id: 0xA01A, name: "THUNDERX Zip Coprocessor" },
		Device { id: 0xA01B, name: "THUNDERX xHCI USB Controller" },
		Device { id: 0xA01C, name: "THUNDERX AHCI SATA Controller" },
		Device { id: 0xA01D, name: "THUNDERX RAID Coprocessor" },
		Device { id: 0xA01E, name: "THUNDERX Network Interface Controller" },
		Device { id: 0xA01F, name: "THUNDERX Traffic Network Switch" },
		Device { id: 0xA020, name: "THUNDERX PEM (PCI Express Interface)" },
		Device { id: 0xA021, name: "THUNDERX L2C (Level-2 Cache Controller)" },
		Device { id: 0xA022, name: "THUNDERX LMC (DRAM Controller)" },
		Device { id: 0xA023, name: "THUNDERX OCLA (On-Chip Logic Analyzer)" },
		Device { id: 0xA024, name: "THUNDERX OSM" },
		Device { id: 0xA025, name: "THUNDERX GSER (General Serializer/Deserializer)" },
		Device { id: 0xA026, name: "THUNDERX BGX (Common Ethernet Interface)" },
		Device { id: 0xA027, name: "THUNDERX IOBN" },
		Device { id: 0xA029, name: "THUNDERX NCSI (Network Controller Sideband Interface)" },
		Device { id: 0xA02A, name: "ThunderX SGPIO (Serial GPIO controller for SATA disk lights)" },
		Device { id: 0xA02B, name: "THUNDERX SMI / MDIO Controller" },
		Device { id: 0xA02C, name: "THUNDERX DAP (Debug Access Port)" },
		Device { id: 0xA02D, name: "THUNDERX PCIERC (PCIe Root Complex)" },
		Device { id: 0xA02E, name: "ThunderX L2C-TAD (Level 2 cache tag and data)" },
		Device { id: 0xA02F, name: "THUNDERX L2C-CBC" },
		Device { id: 0xA030, name: "THUNDERX L2C-MCI" },
		Device { id: 0xA031, name: "THUNDERX MIO-FUS (Fuse Access Controller)" },
		Device { id: 0xA032, name: "THUNDERX FUSF (Fuse Controller)" },
		Device { id: 0xA033, name: "THUNDERX Random Number Generator virtual function" },
		Device { id: 0xA034, name: "THUNDERX Network Interface Controller virtual function" },
		Device { id: 0xA035, name: "THUNDERX Parallel Bus" },
		Device { id: 0xA036, name: "ThunderX RAD (RAID acceleration engine) virtual function" },
		Device { id: 0xA037, name: "THUNDERX ZIP virtual function" },
		Device { id: 0xA040, name: "THUNDERX CPT Cryptographic Accelerator" },
		Device { id: 0xA100, name: "THUNDERX CN88XX 48 core SoC" },
		Device { id: 0xA200, name: "OCTEON TX CN81XX/CN80XX" },
		Device { id: 0xA300, name: "OCTEON TX CN83XX" },
	] },
	Vendor { id: 0x1787, name: "Hightech Information System Ltd.", devices: &[
	] },
	Vendor { id: 0x1789, name: "Ennyah Technologies Corp.", devices: &[
	] },
	Vendor { id: 0x1796, name: "Research Centre Juelich", devices: &[
		Device { id: 0x0001, name: "SIS1100 [Gigabit link]" },
		Device { id: 0x0002, name: "HOTlink" },
		Device { id: 0x0003, name: "Counter Timer" },
		Device { id: 0x0004, name: "CAMAC Controller" },
		Device { id: 0x0005, name: "PROFIBUS" },
		Device { id: 0x0006, name: "AMCC HOTlink" },
		Device { id: 0x000D, name: "Synchronisation Slave" },
		Device { id: 0x000E, name: "SIS1100-eCMC" },
		Device { id: 0x000F, name: "TDC (GPX)" },
		Device { id: 0x0010, name: "PCIe Counter Timer" },
		Device { id: 0x0011, name: "SIS1100-e single link" },
		Device { id: 0x0012, name: "SIS1100-e quad link" },
		Device { id: 0x0015, name: "SIS8100 [Gigabit link, MicroTCA]" },
	] },
	Vendor { id: 0x1797, name: "Intersil Techwell", devices: &[
		Device { id: 0x5864, name: "TW5864 multimedia video controller" },
		Device { id: 0x6801, name: "TW6802 multimedia video card" },
		Device { id: 0x6802, name: "TW6802 multimedia other device" },
		Device { id: 0x6810, name: "TW6816 multimedia video controller" },
		Device { id: 0x6811, name: "TW6816 multimedia video controller" },
		Device { id: 0x6812, name: "TW6816 multimedia video controller" },
		Device { id: 0x6813, name: "TW6816 multimedia video controller" },
		Device { id: 0x6814, name: "TW6816 multimedia video controller" },
		Device { id: 0x6815, name: "TW6816 multimedia video controller" },
		Device { id: 0x6816, name: "TW6816 multimedia video controller" },
		Device { id: 0x6817, name: "TW6816 multimedia video controller" },
		Device { id: 0x6864, name: "TW6864 multimedia video controller" },
	] },
	Vendor { id: 0x1799, name: "Belkin", devices: &[
		Device { id: 0x6001, name: "F5D6001 Wireless PCI Card [Realtek RTL8180]" },
		Device { id: 0x6020, name: "F5D6020 v3000 Wireless PCMCIA Card [Realtek RTL8180]" },
		Device { id: 0x6060, name: "F5D6060 Wireless PDA Card" },
		Device { id: 0x700F, name: "F5D7000 v7000 Wireless G Desktop Card [Realtek RTL8185]" },
		Device { id: 0x701F, name: "F5D7010 v7000 Wireless G Notebook Card [Realtek RTL8185]" },
	] },
	Vendor { id: 0x179A, name: "id Quantique", devices: &[
		Device { id: 0x0001, name: "Quantis PCI 16Mbps" },
	] },
	Vendor { id: 0x179C, name: "Data Patterns", devices: &[
		Device { id: 0x0557, name: "DP-PCI-557 [PCI 1553B]" },
		Device { id: 0x0566, name: "DP-PCI-566 [Intelligent PCI 1553B]" },
		Device { id: 0x1152, name: "DP-cPCI-1152 (8-channel Isolated ADC Module)" },
		Device { id: 0x5031, name: "DP-CPCI-5031-Synchro Module" },
		Device { id: 0x5112, name: "DP-cPCI-5112 [MM-Carrier]" },
		Device { id: 0x5121, name: "DP-CPCI-5121-IP Carrier" },
		Device { id: 0x5211, name: "DP-CPCI-5211-IP Carrier" },
		Device { id: 0x5679, name: "AGE Display Module" },
	] },
	Vendor { id: 0x17A0, name: "Genesys Logic, Inc", devices: &[
		Device { id: 0x7163, name: "GL9701 PCIe to PCI Bridge" },
		Device { id: 0x8083, name: "GL880 USB 1.1 UHCI controller" },
		Device { id: 0x8084, name: "GL880 USB 2.0 EHCI controller" },
	] },
	Vendor { id: 0x17AA, name: "Lenovo", devices: &[
		Device { id: 0x402B, name: "Intel 82599ES 10Gb 2-port Server Adapter X520-2" },
	] },
	Vendor { id: 0x17AB, name: "Phillips Components", devices: &[
	] },
	Vendor { id: 0x17AF, name: "Hightech Information System Ltd.", devices: &[
	] },
	Vendor { id: 0x17B3, name: "Hawking Technologies", devices: &[
		Device { id: 0xAB08, name: "PN672TX 10/100 Ethernet" },
	] },
	Vendor { id: 0x17B4, name: "Indra Networks, Inc.", devices: &[
		Device { id: 0x0011, name: "WebEnhance 100 GZIP Compression Card" },
		Device { id: 0x0012, name: "WebEnhance 200 GZIP Compression Card" },
		Device { id: 0x0015, name: "WebEnhance 300 GZIP Compression Card" },
		Device { id: 0x0016, name: "StorCompress 300 GZIP Compression Card" },
		Device { id: 0x0017, name: "StorSecure 300 GZIP Compression and AES Encryption Card" },
	] },
	Vendor { id: 0x17C0, name: "Wistron Corp.", devices: &[
	] },
	Vendor { id: 0x17C2, name: "Newisys, Inc.", devices: &[
	] },
	Vendor { id: 0x17CB, name: "Qualcomm", devices: &[
		Device { id: 0x0001, name: "AGN100 802.11 a/b/g True MIMO Wireless Card" },
		Device { id: 0x0002, name: "AGN300 802.11 a/b/g True MIMO Wireless Card" },
		Device { id: 0x0400, name: "Datacenter Technologies QDF2432 PCI Express Root Port" },
		Device { id: 0x0401, name: "Datacenter Technologies QDF2400 PCI Express Root Port" },
	] },
	Vendor { id: 0x17CC, name: "NetChip Technology, Inc", devices: &[
		Device { id: 0x2280, name: "USB 2.0" },
	] },
	Vendor { id: 0x17CD, name: "Cadence Design Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x17CF, name: "Z-Com, Inc.", devices: &[
	] },
	Vendor { id: 0x17D3, name: "Areca Technology Corp.", devices: &[
		Device { id: 0x1110, name: "ARC-1110 4-Port PCI-X to SATA RAID Controller" },
		Device { id: 0x1120, name: "ARC-1120 8-Port PCI-X to SATA RAID Controller" },
		Device { id: 0x1130, name: "ARC-1130 12-Port PCI-X to SATA RAID Controller" },
		Device { id: 0x1160, name: "ARC-1160 16-Port PCI-X to SATA RAID Controller" },
		Device { id: 0x1170, name: "ARC-1170 24-Port PCI-X to SATA RAID Controller" },
		Device { id: 0x1201, name: "ARC-1200 2-Port PCI-Express to SATA II RAID Controller" },
		Device { id: 0x1203, name: "ARC-1203 2/4/8 Port PCIe 2.0 to SATA 6Gb RAID Controller" },
		Device { id: 0x1210, name: "ARC-1210 4-Port PCI-Express to SATA RAID Controller" },
		Device { id: 0x1214, name: "ARC-12x4 PCIe 2.0 to SAS/SATA 6Gb RAID Controller" },
		Device { id: 0x1220, name: "ARC-1220 8-Port PCI-Express to SATA RAID Controller" },
		Device { id: 0x1222, name: "ARC-1222 8-Port PCI-Express to SAS/SATA II RAID Controller" },
		Device { id: 0x1230, name: "ARC-1230 12-Port PCI-Express to SATA RAID Controller" },
		Device { id: 0x1260, name: "ARC-1260 16-Port PCI-Express to SATA RAID Controller" },
		Device { id: 0x1280, name: "ARC-1280/1280ML 24-Port PCI-Express to SATA II RAID Controller" },
		Device { id: 0x1300, name: "ARC-1300ix-16 16-Port PCI-Express to SAS Non-RAID Host Adapter" },
		Device { id: 0x1320, name: "ARC-1320 8/16 Port PCIe 2.0 to SAS/SATA 6Gb Non-RAID Host Adapter" },
		Device { id: 0x1330, name: "ARC-1330 16 Port PCIe 3.0 to SAS/SATA 12Gb Non-RAID Host Adapter" },
		Device { id: 0x1680, name: "ARC-1680 series PCIe to SAS/SATA 3Gb RAID Controller" },
		Device { id: 0x1880, name: "ARC-188x series PCIe 2.0/3.0 to SAS/SATA 6/12Gb RAID Controller" },
		Device { id: 0x1884, name: "ARC-1884 series PCIe 3.0 to SAS/SATA 12/6Gb RAID Controller" },
	] },
	Vendor { id: 0x17D5, name: "Exar Corp.", devices: &[
		Device { id: 0x5731, name: "Xframe 10-Gigabit Ethernet PCI-X" },
		Device { id: 0x5732, name: "Xframe II 10-Gigabit Ethernet PCI-X 2.0" },
		Device { id: 0x5831, name: "Xframe 10-Gigabit Ethernet PCI-X" },
		Device { id: 0x5832, name: "Xframe II 10-Gigabit Ethernet PCI-X 2.0" },
		Device { id: 0x5833, name: "X3100 Series 10 Gigabit Ethernet PCIe" },
	] },
	Vendor { id: 0x17DB, name: "Cray Inc", devices: &[
		Device { id: 0x0101, name: "XT Series [Seastar] 3D Toroidal Router" },
	] },
	Vendor { id: 0x17DE, name: "KWorld Computer Co. Ltd.", devices: &[
	] },
	Vendor { id: 0x17DF, name: "Dini Group", devices: &[
		Device { id: 0x1864, name: "Virtex4 PCI Board w/ QL5064 Bridge [DN7000K10PCI/DN8000K10PCI/DN8000K10PSX/NOTUS]" },
		Device { id: 0x1865, name: "Virtex4 ASIC Emulator [DN8000K10PCIe]" },
		Device { id: 0x1866, name: "Virtex4 ASIC Emulator Cable Connection [DN8000K10PCI]" },
		Device { id: 0x1867, name: "Virtex4 ASIC Emulator Cable Connection [DN8000K10PCIe]" },
		Device { id: 0x1868, name: "Virtex4 ASIC Emulator [DN8000K10PCIe-8]" },
		Device { id: 0x1900, name: "Virtex5 PCIe ASIC Emulator [DN9000K10PCIe8T/DN9002K10PCIe8T/DN9200K10PCIe8T/DN7006K10PCIe8T/DN7406K10PCIe8T]" },
		Device { id: 0x1901, name: "Virtex5 PCIe ASIC Emulator Large BARs [DN9000K10PCIe8T/DN9002K10PCIe8T/DN9200K10PCIe8T/DN7006K10PCIe8T/DN7406K10PCIe8T]" },
		Device { id: 0x1902, name: "Virtex5 PCIe ASIC Emulator Low Power [Interceptor]" },
		Device { id: 0x1903, name: "Spartan6 PCIe FPGA Accelerator Board [DNBFCS12PCIe]" },
		Device { id: 0x1904, name: "Virtex6 PCIe ASIC Emulation Board [DNDUALV6_PCIe4]" },
		Device { id: 0x1905, name: "Virtex6 PCIe ASIC Emulation Board [DNV6F6PCIe]" },
		Device { id: 0x1906, name: "Virtex6 PCIe ASIC Emulation Board [DN2076K10]" },
		Device { id: 0x1907, name: "Virtex6 PCIe ASIC Emulation Board [DNV6F2PCIe]" },
		Device { id: 0x1908, name: "Virtex6 PCIe ASIC Emulation Board Large BARs[DNV6F2PCIe]" },
		Device { id: 0x1909, name: "Kintex7 PCIe FPGA Accelerator Board [DNK7F5PCIe]" },
		Device { id: 0x190A, name: "Virtex7 PCIe ASIC Emulation Board [DNV7F1A]" },
		Device { id: 0x190B, name: "Stratix5 PCIe ASIC Emulation Board [DNS5GXF2]" },
		Device { id: 0x190C, name: "Virtex7 PCIe ASIC Emulation Board [DNV7F2A]" },
		Device { id: 0x190D, name: "Virtex7 PCIe ASIC Emulation Board [DNV7F4A]" },
		Device { id: 0x190E, name: "Virtex7 PCIe ASIC Emulation Board [DNV7F2B]" },
		Device { id: 0x190F, name: "KintexUS PCIe MainRef Design [DNPCIE_40G_KU_LL]" },
		Device { id: 0x1910, name: "VirtexUS ASIC Emulation Board [DNVUF4A]" },
		Device { id: 0x1911, name: "VirtexUS PCIe ASIC Emulation Board [DNVU_F2PCIe]" },
		Device { id: 0x1912, name: "KintexUS PCIe MainRef Design [DNPCIe_40G_KU_LL_QSFP]" },
		Device { id: 0x1913, name: "VirtexUS ASIC Emulation Board [DNVUF1A]" },
		Device { id: 0x1914, name: "VirtexUS ASIC Emulation Board [DNVUF2A]" },
		Device { id: 0x1915, name: "Arria10 PCIe MainRef Design [DNPCIe_80G_A10_LL]" },
		Device { id: 0x1916, name: "VirtexUS PCIe Accelerator Board [DNVUF2_HPC_PCIe]" },
		Device { id: 0x1A00, name: "Virtex6 PCIe DMA Netlist Design" },
		Device { id: 0x1A01, name: "Virtex6 PCIe Darklite Design [DNPCIe_HXT_10G_LL]" },
		Device { id: 0x1A02, name: "Virtex7 PCIe DMA Netlist Design" },
		Device { id: 0x1A03, name: "Kintex7 PCIe Darklite Design [DNPCIe_K7_10G_LL]" },
		Device { id: 0x1A05, name: "Stratix5 PCIe Darklite Design [DNS5GX_F2]" },
		Device { id: 0x1A06, name: "VirtexUS PCIe DMA Netlist Design" },
		Device { id: 0x1A07, name: "KintexUS PCIe Darklite Design [DNPCIe_40G_KU_LL]" },
		Device { id: 0x1A08, name: "KintexUS PCIe Darklite Design [DNPCIe_40G_KU_LL_QSFP]" },
		Device { id: 0x1A09, name: "Arria10 PCIe Darklite Design [DNPCIe_80G_A10_LL]" },
		Device { id: 0x1A0A, name: "VirtexUS PCIe Darklite Design [DNVUF2_HPC_PCIe]" },
	] },
	Vendor { id: 0x17E4, name: "Sectra AB", devices: &[
		Device { id: 0x0001, name: "KK671 Cardbus encryption board" },
		Device { id: 0x0002, name: "KK672 Cardbus encryption board" },
	] },
	Vendor { id: 0x17E6, name: "MaxLinear", devices: &[
		Device { id: 0x0010, name: "EN2010 [c.Link] MoCA Network Controller (Coax, PCI interface)" },
		Device { id: 0x0011, name: "EN2010 [c.Link] MoCA Network Controller (Coax, MPEG interface)" },
		Device { id: 0x0021, name: "EN2210 [c.Link] MoCA Network Controller (Coax)" },
		Device { id: 0x0025, name: "EN2510 [c.Link] MoCA Network Controller (Coax, PCIe interface)" },
		Device { id: 0x0027, name: "EN2710 [c.Link] MoCA 2.0 Network Controller (Coax, PCIe interface)" },
		Device { id: 0x3700, name: "MoCA 2.0 Network Controller (Coax, PCIe interface)" },
		Device { id: 0x3710, name: "MoCA 2.5 Network Controller (Coax, PCIe interface)" },
	] },
	Vendor { id: 0x17EE, name: "Connect Components Ltd", devices: &[
	] },
	Vendor { id: 0x17F2, name: "Albatron Corp.", devices: &[
	] },
	Vendor { id: 0x17F3, name: "RDC Semiconductor, Inc.", devices: &[
		Device { id: 0x1010, name: "R1010 IDE Controller" },
		Device { id: 0x2012, name: "M2012/R3308 VGA-compatible graphics adapter" },
		Device { id: 0x6020, name: "R6020 North Bridge" },
		Device { id: 0x6021, name: "R6021 Host Bridge" },
		Device { id: 0x6030, name: "R6030 ISA Bridge" },
		Device { id: 0x6031, name: "R6031 ISA Bridge" },
		Device { id: 0x6040, name: "R6040 MAC Controller" },
		Device { id: 0x6060, name: "R6060 USB 1.1 Controller" },
		Device { id: 0x6061, name: "R6061 USB 2.0 Controller" },
	] },
	Vendor { id: 0x17F7, name: "Topdek Semiconductor Inc.", devices: &[
	] },
	Vendor { id: 0x17F9, name: "Gemtek Technology Co., Ltd", devices: &[
	] },
	Vendor { id: 0x17FC, name: "IOGEAR, Inc.", devices: &[
	] },
	Vendor { id: 0x17FE, name: "InProComm Inc.", devices: &[
		Device { id: 0x2120, name: "IPN 2120 802.11b" },
		Device { id: 0x2220, name: "IPN 2220 802.11g" },
	] },
	Vendor { id: 0x17FF, name: "Benq Corporation", devices: &[
	] },
	Vendor { id: 0x1800, name: "Qualcore Logic Inc.", devices: &[
		Device { id: 0x1100, name: "Nanospeed Trading Gateway" },
	] },
	Vendor { id: 0x1803, name: "ProdaSafe GmbH", devices: &[
	] },
	Vendor { id: 0x1805, name: "Euresys S.A.", devices: &[
	] },
	Vendor { id: 0x1809, name: "Lumanate, Inc.", devices: &[
	] },
	Vendor { id: 0x180C, name: "IEI Integration Corp", devices: &[
	] },
	Vendor { id: 0x1813, name: "Ambient Technologies Inc", devices: &[
		Device { id: 0x4000, name: "HaM controllerless modem" },
		Device { id: 0x4100, name: "HaM plus Data Fax Modem" },
	] },
	Vendor { id: 0x1814, name: "Ralink corp.", devices: &[
		Device { id: 0x0101, name: "Wireless PCI Adapter RT2400 / RT2460" },
		Device { id: 0x0200, name: "RT2500 802.11g PCI [PC54G2]" },
		Device { id: 0x0201, name: "RT2500 Wireless 802.11bg" },
		Device { id: 0x0300, name: "Wireless Adapter Canyon CN-WF511" },
		Device { id: 0x0301, name: "RT2561/RT61 802.11g PCI" },
		Device { id: 0x0302, name: "RT2561/RT61 rev B 802.11g" },
		Device { id: 0x0401, name: "RT2600 802.11 MIMO" },
		Device { id: 0x0601, name: "RT2800 802.11n PCI" },
		Device { id: 0x0681, name: "RT2890 Wireless 802.11n PCIe" },
		Device { id: 0x0701, name: "RT2760 Wireless 802.11n 1T/2R" },
		Device { id: 0x0781, name: "RT2790 Wireless 802.11n 1T/2R PCIe" },
		Device { id: 0x3060, name: "RT3060 Wireless 802.11n 1T/1R" },
		Device { id: 0x3062, name: "RT3062 Wireless 802.11n 2T/2R" },
		Device { id: 0x3090, name: "RT3090 Wireless 802.11n 1T/1R PCIe" },
		Device { id: 0x3091, name: "RT3091 Wireless 802.11n 1T/2R PCIe" },
		Device { id: 0x3092, name: "RT3092 Wireless 802.11n 2T/2R PCIe" },
		Device { id: 0x3290, name: "RT3290 Wireless 802.11n 1T/1R PCIe" },
		Device { id: 0x3298, name: "RT3290 Bluetooth" },
		Device { id: 0x3592, name: "RT3592 Wireless 802.11abgn 2T/2R PCIe" },
		Device { id: 0x359F, name: "RT3592 PCIe Wireless Network Adapter" },
		Device { id: 0x5360, name: "RT5360 Wireless 802.11n 1T/1R" },
		Device { id: 0x5362, name: "RT5362 PCI 802.11n Wireless Network Adapter" },
		Device { id: 0x5390, name: "RT5390 Wireless 802.11n 1T/1R PCIe" },
		Device { id: 0x5392, name: "RT5392 PCIe Wireless Network Adapter" },
		Device { id: 0x539B, name: "RT5390R 802.11bgn PCIe Wireless Network Adapter" },
		Device { id: 0x539F, name: "RT5390 [802.11 b/g/n 1T1R G-band PCI Express Single Chip]" },
		Device { id: 0x5592, name: "RT5592 PCIe Wireless Network Adapter" },
		Device { id: 0xE932, name: "RT2560F 802.11 b/g PCI" },
	] },
	Vendor { id: 0x1815, name: "Devolo AG", devices: &[
	] },
	Vendor { id: 0x1820, name: "InfiniCon Systems Inc.", devices: &[
	] },
	Vendor { id: 0x1822, name: "Twinhan Technology Co. Ltd", devices: &[
		Device { id: 0x4E35, name: "Mantis DTV PCI Bridge Controller [Ver 1.0]" },
	] },
	Vendor { id: 0x182D, name: "SiteCom Europe BV", devices: &[
		Device { id: 0x3069, name: "ISDN PCI DC-105V2" },
		Device { id: 0x9790, name: "WL-121 Wireless Network Adapter 100g+ [Ver.3]" },
	] },
	Vendor { id: 0x182E, name: "Raza Microelectronics, Inc.", devices: &[
		Device { id: 0x0008, name: "XLR516 Processor" },
	] },
	Vendor { id: 0x182F, name: "Broadcom", devices: &[
		Device { id: 0x000B, name: "BCM5785 [HT1000] SATA (RAID Mode)" },
	] },
	Vendor { id: 0x1830, name: "Credence Systems Corporation", devices: &[
	] },
	Vendor { id: 0x183B, name: "MikroM GmbH", devices: &[
		Device { id: 0x08A7, name: "MVC100 DVI" },
		Device { id: 0x08A8, name: "MVC101 SDI" },
		Device { id: 0x08A9, name: "MVC102 DVI+Audio" },
		Device { id: 0x08B0, name: "MVC200-DC" },
	] },
	Vendor { id: 0x1846, name: "Alcatel-Lucent", devices: &[
	] },
	Vendor { id: 0x1849, name: "ASRock Incorporation", devices: &[
	] },
	Vendor { id: 0x184A, name: "Thales Computers", devices: &[
		Device { id: 0x1100, name: "MAX II cPLD" },
	] },
	Vendor { id: 0x1850, name: "Advantest Corporation", devices: &[
		Device { id: 0x0048, name: "EK220-66401 Computer Interface Card" },
	] },
	Vendor { id: 0x1851, name: "Microtune, Inc.", devices: &[
	] },
	Vendor { id: 0x1852, name: "Anritsu Corp.", devices: &[
	] },
	Vendor { id: 0x1853, name: "SMSC Automotive Infotainment System Group", devices: &[
	] },
	Vendor { id: 0x1854, name: "LG Electronics, Inc.", devices: &[
	] },
	Vendor { id: 0x185B, name: "Compro Technology, Inc.", devices: &[
		Device { id: 0x1489, name: "VideoMate Vista T100" },
	] },
	Vendor { id: 0x185F, name: "Wistron NeWeb Corp.", devices: &[
	] },
	Vendor { id: 0x1864, name: "SilverBack", devices: &[
		Device { id: 0x2110, name: "ISNAP 2110" },
	] },
	Vendor { id: 0x1867, name: "Topspin Communications", devices: &[
		Device { id: 0x5A44, name: "MT23108 InfiniHost HCA" },
		Device { id: 0x5A45, name: "MT23108 InfiniHost HCA flash recovery" },
		Device { id: 0x5A46, name: "MT23108 InfiniHost HCA bridge" },
		Device { id: 0x6278, name: "MT25208 InfiniHost III Ex (Tavor compatibility mode)" },
		Device { id: 0x6282, name: "MT25208 InfiniHost III Ex" },
	] },
	Vendor { id: 0x186C, name: "Humusoft, s.r.o.", devices: &[
		Device { id: 0x0612, name: "AD612 Data Acquisition Device" },
		Device { id: 0x0614, name: "MF614 Multifunction I/O Card" },
		Device { id: 0x0622, name: "AD622 Data Acquisition Device" },
		Device { id: 0x0624, name: "MF624 Multifunction I/O PCI Card" },
		Device { id: 0x0625, name: "MF625 3-phase Motor Driver" },
		Device { id: 0x0634, name: "MF634 Multifunction I/O PCIe Card" },
	] },
	Vendor { id: 0x186F, name: "WiNRADiO Communications", devices: &[
	] },
	Vendor { id: 0x1876, name: "L-3 Communications", devices: &[
		Device { id: 0xA101, name: "VigraWATCH PCI" },
		Device { id: 0xA102, name: "VigraWATCH PMC" },
		Device { id: 0xA103, name: "Vigra I/O" },
	] },
	Vendor { id: 0x187E, name: "ZyXEL Communications Corporation", devices: &[
		Device { id: 0x3403, name: "ZyAir G-110 802.11g" },
		Device { id: 0x340E, name: "M-302 802.11g XtremeMIMO" },
	] },
	Vendor { id: 0x1885, name: "Avvida Systems Inc.", devices: &[
	] },
	Vendor { id: 0x1888, name: "Varisys Ltd", devices: &[
		Device { id: 0x0301, name: "VMFX1 FPGA PMC module" },
		Device { id: 0x0601, name: "VSM2 dual PMC carrier" },
		Device { id: 0x0710, name: "VS14x series PowerPC PCI board" },
		Device { id: 0x0720, name: "VS24x series PowerPC PCI board" },
	] },
	Vendor { id: 0x188A, name: "Ample Communications, Inc", devices: &[
	] },
	Vendor { id: 0x1890, name: "Egenera, Inc.", devices: &[
	] },
	Vendor { id: 0x1894, name: "KNC One", devices: &[
	] },
	Vendor { id: 0x1896, name: "B&B Electronics Manufacturing Company, Inc.", devices: &[
		Device { id: 0x4202, name: "MIport 3PCIU2 2-port Serial" },
		Device { id: 0x4204, name: "MIport 3PCIU4 4-port Serial" },
		Device { id: 0x4208, name: "MIport 3PCIU8 8-port Serial" },
		Device { id: 0x4211, name: "MIport 3PCIOU1 1-port Isolated Serial" },
		Device { id: 0x4212, name: "MIport 3PCIOU2 2-port Isolated Serial" },
		Device { id: 0x4214, name: "MIport 3PCIOU4 4-port Isolated Serial" },
		Device { id: 0xBB10, name: "3PCI2 2-Port Serial" },
		Device { id: 0xBB11, name: "3PCIO1 1-Port Isolated Serial" },
	] },
	Vendor { id: 0x1897, name: "AMtek", devices: &[
	] },
	Vendor { id: 0x18A1, name: "Astute Networks Inc.", devices: &[
	] },
	Vendor { id: 0x18A2, name: "Stretch Inc.", devices: &[
		Device { id: 0x0002, name: "VRC6016 16-Channel PCIe DVR Card" },
	] },
	Vendor { id: 0x18A3, name: "AT&T", devices: &[
	] },
	Vendor { id: 0x18AC, name: "DViCO Corporation", devices: &[
		Device { id: 0xD500, name: "FusionHDTV 5" },
		Device { id: 0xD800, name: "FusionHDTV 3 Gold" },
		Device { id: 0xD810, name: "FusionHDTV 3 Gold-Q" },
		Device { id: 0xD820, name: "FusionHDTV 3 Gold-T" },
		Device { id: 0xDB30, name: "FusionHDTV DVB-T Pro" },
		Device { id: 0xDB40, name: "FusionHDTV DVB-T Hybrid" },
		Device { id: 0xDB78, name: "FusionHDTV DVB-T Dual Express" },
	] },
	Vendor { id: 0x18B8, name: "Ammasso", devices: &[
		Device { id: 0xB001, name: "AMSO 1100 iWARP/RDMA Gigabit Ethernet Coprocessor" },
	] },
	Vendor { id: 0x18BC, name: "GeCube Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x18C3, name: "Micronas Semiconductor Holding AG", devices: &[
		Device { id: 0x0720, name: "nGene PCI-Express Multimedia Controller" },
	] },
	Vendor { id: 0x18C8, name: "Cray Inc", devices: &[
	] },
	Vendor { id: 0x18C9, name: "ARVOO Engineering BV", devices: &[
	] },
	Vendor { id: 0x18CA, name: "XGI Technology Inc. (eXtreme Graphics Innovation)", devices: &[
		Device { id: 0x0020, name: "Z7/Z9 (XG20 core)" },
		Device { id: 0x0021, name: "Z9s/Z9m (XG21 core)" },
		Device { id: 0x0027, name: "Z11/Z11M" },
		Device { id: 0x0040, name: "Volari V3XT/V5/V8" },
		Device { id: 0x0047, name: "Volari 8300 (chip: XP10, codename: XG47)" },
	] },
	Vendor { id: 0x18D2, name: "Sitecom Europe BV (Wrong ID)", devices: &[
		Device { id: 0x3069, name: "DC-105v2 ISDN controller" },
	] },
	Vendor { id: 0x18D4, name: "Celestica", devices: &[
	] },
	Vendor { id: 0x18D8, name: "Dialogue Technology Corp.", devices: &[
	] },
	Vendor { id: 0x18DD, name: "Artimi Inc", devices: &[
		Device { id: 0x4C6F, name: "Artimi RTMI-100 UWB adapter" },
	] },
	Vendor { id: 0x18DF, name: "LeWiz Communications", devices: &[
	] },
	Vendor { id: 0x18E6, name: "MPL AG", devices: &[
		Device { id: 0x0001, name: "OSCI [Octal Serial Communication Interface]" },
	] },
	Vendor { id: 0x18EB, name: "Advance Multimedia Internet Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x18EC, name: "Cesnet, z.s.p.o.", devices: &[
		Device { id: 0x6D05, name: "ML555" },
		Device { id: 0xC006, name: "COMBO6" },
		Device { id: 0xC032, name: "COMBO-LXT110" },
		Device { id: 0xC045, name: "COMBO6E" },
		Device { id: 0xC050, name: "COMBO-PTM" },
		Device { id: 0xC058, name: "COMBO6X" },
		Device { id: 0xC132, name: "COMBO-LXT155" },
		Device { id: 0xC232, name: "COMBO-FXT100" },
	] },
	Vendor { id: 0x18EE, name: "Chenming Mold Ind. Corp.", devices: &[
	] },
	Vendor { id: 0x18F1, name: "Spectrum GmbH", devices: &[
	] },
	Vendor { id: 0x18F4, name: "Napatech A/S", devices: &[
		Device { id: 0x0031, name: "NT20X Network Adapter" },
		Device { id: 0x0051, name: "NT20X Capture Card" },
		Device { id: 0x0061, name: "NT20E Capture Card" },
		Device { id: 0x0064, name: "NT20E Inline Card" },
		Device { id: 0x0071, name: "NT4E Capture Card" },
		Device { id: 0x0074, name: "NT4E Inline Card" },
		Device { id: 0x0081, name: "NT4E 4-port Expansion Card" },
		Device { id: 0x0091, name: "NT20X Capture Card [New Rev]" },
		Device { id: 0x00A1, name: "NT4E-STD Capture Card" },
		Device { id: 0x00A4, name: "NT4E-STD Inline Card" },
		Device { id: 0x00B1, name: "NTBPE Optical Bypass Adapter" },
		Device { id: 0x00C5, name: "NT20E2 Network Adapter 2x10Gb" },
		Device { id: 0x00D5, name: "NT40E2-4 Network Adapter 4x10Gb" },
		Device { id: 0x00E5, name: "NT40E2-1 Network Adapter 1x40Gb" },
		Device { id: 0x00F5, name: "NT4E2-4T-BP Network Adapter 4x1Gb with Electrical Bypass" },
		Device { id: 0x0105, name: "NT4E2-4-PTP Network Adapter 4x1Gb" },
		Device { id: 0x0115, name: "NT20E2-PTP Network Adapter 2x10Gb" },
		Device { id: 0x0125, name: "NT4E2-4-PTP Network Adapter 4x1Gb" },
		Device { id: 0x0135, name: "NT20E2-PTP Network Adapter 2x10Gb" },
		Device { id: 0x0145, name: "NT40E3-4-PTP Network Adapter 4x10Gb" },
		Device { id: 0x0155, name: "NT100E3-1-PTP Network Adapter 1x100Gb" },
		Device { id: 0x0165, name: "NT80E3-2-PTP Network Adapter 2x40Gb" },
		Device { id: 0x0175, name: "NT20E3-2-PTP Network Adapter 2x10Gb" },
		Device { id: 0x0185, name: "NT40A01 Network Adapter" },
		Device { id: 0x01A5, name: "NT200A01 Network Adapter" },
	] },
	Vendor { id: 0x18F6, name: "NextIO", devices: &[
		Device { id: 0x1000, name: "[Nexsis] Switch Virtual P2P PCIe Bridge" },
		Device { id: 0x1001, name: "[Texsis] Switch Virtual P2P PCIe Bridge" },
		Device { id: 0x1050, name: "[Nexsis] Switch Virtual P2P PCI Bridge" },
		Device { id: 0x1051, name: "[Texsis] Switch Virtual P2P PCI Bridge" },
		Device { id: 0x2000, name: "[Nexsis] Switch Integrated Mgmt. Endpoint" },
		Device { id: 0x2001, name: "[Texsis] Switch Integrated Mgmt. Endpoint" },
	] },
	Vendor { id: 0x18F7, name: "Commtech, Inc.", devices: &[
		Device { id: 0x0001, name: "ESCC-PCI-335 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0002, name: "422/4-PCI-335 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0003, name: "232/4-1M-PCI Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0004, name: "422/2-PCI-335 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0005, name: "IGESCC-PCI-ISO/1 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x000A, name: "232/4-PCI-335 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x000B, name: "232/8-PCI-335 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x000F, name: "FSCC Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0010, name: "GSCC Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0011, name: "QSSB Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0014, name: "SuperFSCC Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0015, name: "SuperFSCC-104-LVDS Serial PC/104+ Adapter [Fastcom]" },
		Device { id: 0x0016, name: "FSCC-232 RS-232 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0017, name: "SuperFSCC-104 Serial PC/104+ Adapter [Fastcom]" },
		Device { id: 0x0018, name: "SuperFSCC/4 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0019, name: "SuperFSCC Serial PCI Adapter [Fastcom]" },
		Device { id: 0x001A, name: "SuperFSCC-LVDS Serial PCI Adapter [Fastcom]" },
		Device { id: 0x001B, name: "FSCC/4 Serial PCI Adapter [Fastcom]" },
		Device { id: 0x001C, name: "SuperFSCC/4-LVDS Serial PCI Adapter [Fastcom]" },
		Device { id: 0x001D, name: "FSCC Serial PCI Adapter [Fastcom]" },
		Device { id: 0x001E, name: "SuperFSCC/4 Serial PCIe Adapter [Fastcom]" },
		Device { id: 0x001F, name: "SuperFSCC/4 Serial cPCI Adapter [Fastcom]" },
		Device { id: 0x0020, name: "422/4-PCIe Serial PCIe Adapter [Fastcom]" },
		Device { id: 0x0021, name: "422/8-PCIe Serial PCIe Adapter [Fastcom]" },
		Device { id: 0x0022, name: "SuperFSCC/4-LVDS Serial PCIe Adapter [Fastcom]" },
		Device { id: 0x0023, name: "SuperFSCC/4 Serial cPCI Adapter [Fastcom]" },
		Device { id: 0x0025, name: "SuperFSCC/4-LVDS Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0026, name: "SuperFSCC-LVDS Serial PCI Adapter [Fastcom]" },
		Device { id: 0x0027, name: "FSCC/4 Serial PCIe Adapter [Fastcom]" },
	] },
	Vendor { id: 0x18FB, name: "Resilience Corporation", devices: &[
	] },
	Vendor { id: 0x1904, name: "Hangzhou Silan Microelectronics Co., Ltd.", devices: &[
		Device { id: 0x2031, name: "SC92031 PCI Fast Ethernet Adapter" },
		Device { id: 0x8139, name: "RTL8139D [Realtek] PCI 10/100BaseTX ethernet adaptor" },
	] },
	Vendor { id: 0x1905, name: "Micronas USA, Inc.", devices: &[
	] },
	Vendor { id: 0x1912, name: "Renesas Technology Corp.", devices: &[
		Device { id: 0x0002, name: "SH7780 PCI Controller (PCIC)" },
		Device { id: 0x0011, name: "SH7757 PCIe End-Point [PBI]" },
		Device { id: 0x0012, name: "SH7757 PCIe-PCI Bridge [PPB]" },
		Device { id: 0x0013, name: "SH7757 PCIe Switch [PS]" },
		Device { id: 0x0014, name: "uPD720201 USB 3.0 Host Controller" },
		Device { id: 0x0015, name: "uPD720202 USB 3.0 Host Controller" },
		Device { id: 0x001A, name: "SH7758 PCIe-PCI Bridge [PPB]" },
		Device { id: 0x001B, name: "SH7758 PCIe End-Point [PBI]" },
		Device { id: 0x001D, name: "SH7758 PCIe Switch [PS]" },
	] },
	Vendor { id: 0x1919, name: "Soltek Computer Inc.", devices: &[
	] },
	Vendor { id: 0x1923, name: "Sangoma Technologies Corp.", devices: &[
		Device { id: 0x0040, name: "A200/Remora FXO/FXS Analog AFT card" },
		Device { id: 0x0100, name: "A104d QUAD T1/E1 AFT card" },
		Device { id: 0x0300, name: "A101 single-port T1/E1" },
		Device { id: 0x0400, name: "A104u Quad T1/E1 AFT" },
	] },
	Vendor { id: 0x1924, name: "Solarflare Communications", devices: &[
		Device { id: 0x0703, name: "SFC4000 rev A net [Solarstorm]" },
		Device { id: 0x0710, name: "SFC4000 rev B [Solarstorm]" },
		Device { id: 0x0803, name: "SFC9020 10G Ethernet Controller" },
		Device { id: 0x0813, name: "SFL9021 10GBASE-T Ethernet Controller" },
		Device { id: 0x0903, name: "SFC9120 10G Ethernet Controller" },
		Device { id: 0x0923, name: "SFC9140 10/40G Ethernet Controller" },
		Device { id: 0x0A03, name: "SFC9220 10/40G Ethernet Controller" },
		Device { id: 0x1803, name: "SFC9020 10G Ethernet Controller (Virtual Function)" },
		Device { id: 0x1813, name: "SFL9021 10GBASE-T Ethernet Controller (Virtual Function)" },
		Device { id: 0x1903, name: "SFC9120 10G Ethernet Controller (Virtual Function)" },
		Device { id: 0x1923, name: "SFC9140 10/40G Ethernet Controller (Virtual Function)" },
		Device { id: 0x1A03, name: "SFC9220 10/40G Ethernet Controller (Virtual Function)" },
		Device { id: 0x6703, name: "SFC4000 rev A iSCSI/Onload [Solarstorm]" },
		Device { id: 0xC101, name: "EF1-21022T [EtherFabric]" },
	] },
	Vendor { id: 0x192A, name: "BiTMICRO Networks Inc.", devices: &[
	] },
	Vendor { id: 0x192E, name: "TransDimension", devices: &[
	] },
	Vendor { id: 0x1931, name: "Option N.V.", devices: &[
		Device { id: 0x000C, name: "Qualcomm MSM6275 UMTS chip" },
	] },
	Vendor { id: 0x1932, name: "DiBcom", devices: &[
	] },
	Vendor { id: 0x193C, name: "MAXIM Integrated Products", devices: &[
	] },
	Vendor { id: 0x193F, name: "AHA Products Group", devices: &[
		Device { id: 0x0001, name: "AHA36x-PCIX" },
		Device { id: 0x0360, name: "AHA360-PCIe" },
		Device { id: 0x0363, name: "AHA363-PCIe" },
		Device { id: 0x0364, name: "AHA364-PCIe" },
		Device { id: 0x0367, name: "AHA367-PCIe" },
		Device { id: 0x0370, name: "AHA370-PCIe" },
		Device { id: 0x0604, name: "AHA604" },
		Device { id: 0x0605, name: "AHA605" },
		Device { id: 0x3641, name: "AHA3641" },
		Device { id: 0x3642, name: "AHA3642" },
		Device { id: 0x6101, name: "AHA6101" },
		Device { id: 0x6102, name: "AHA6102" },
	] },
	Vendor { id: 0x1942, name: "ClearSpeed Technology plc", devices: &[
		Device { id: 0xE511, name: "Advance X620 accelerator card" },
		Device { id: 0xE521, name: "Advance e620 accelerator card" },
	] },
	Vendor { id: 0x1947, name: "C-guys, Inc.", devices: &[
		Device { id: 0x4743, name: "CG200 Dual SD/SDIO Host controller device" },
	] },
	Vendor { id: 0x1948, name: "Alpha Networks Inc.", devices: &[
	] },
	Vendor { id: 0x194A, name: "DapTechnology B.V.", devices: &[
		Device { id: 0x1111, name: "FireSpy3850" },
		Device { id: 0x1112, name: "FireSpy450b" },
		Device { id: 0x1113, name: "FireSpy450bT" },
		Device { id: 0x1114, name: "FireSpy850" },
		Device { id: 0x1115, name: "FireSpy850bT" },
		Device { id: 0x1200, name: "FireTrac 3460bT" },
		Device { id: 0x1201, name: "FireTrac 3460bT (fallback firmware)" },
		Device { id: 0x1202, name: "FireTrac 3460bT" },
		Device { id: 0x1203, name: "FireTrac 3460bT (fallback firmware)" },
	] },
	Vendor { id: 0x1954, name: "One Stop Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x1957, name: "Freescale Semiconductor Inc", devices: &[
		Device { id: 0x0012, name: "MPC8548E" },
		Device { id: 0x0013, name: "MPC8548" },
		Device { id: 0x0014, name: "MPC8543E" },
		Device { id: 0x0015, name: "MPC8543" },
		Device { id: 0x0018, name: "MPC8547E" },
		Device { id: 0x0019, name: "MPC8545E" },
		Device { id: 0x001A, name: "MPC8545" },
		Device { id: 0x0020, name: "MPC8568E" },
		Device { id: 0x0021, name: "MPC8568" },
		Device { id: 0x0022, name: "MPC8567E" },
		Device { id: 0x0023, name: "MPC8567" },
		Device { id: 0x0030, name: "MPC8533E" },
		Device { id: 0x0031, name: "MPC8533" },
		Device { id: 0x0032, name: "MPC8544E" },
		Device { id: 0x0033, name: "MPC8544" },
		Device { id: 0x0040, name: "MPC8572E" },
		Device { id: 0x0041, name: "MPC8572" },
		Device { id: 0x0050, name: "MPC8536E" },
		Device { id: 0x0051, name: "MPC8536" },
		Device { id: 0x0052, name: "MPC8535E" },
		Device { id: 0x0053, name: "MPC8535" },
		Device { id: 0x0060, name: "MPC8569" },
		Device { id: 0x0061, name: "MPC8569E" },
		Device { id: 0x0070, name: "P2020E" },
		Device { id: 0x0071, name: "P2020" },
		Device { id: 0x0078, name: "P2010E" },
		Device { id: 0x0079, name: "P2010" },
		Device { id: 0x0080, name: "MPC8349E" },
		Device { id: 0x0081, name: "MPC8349" },
		Device { id: 0x0082, name: "MPC8347E TBGA" },
		Device { id: 0x0083, name: "MPC8347 TBGA" },
		Device { id: 0x0084, name: "MPC8347E PBGA" },
		Device { id: 0x0085, name: "MPC8347 PBGA" },
		Device { id: 0x0086, name: "MPC8343E" },
		Device { id: 0x0087, name: "MPC8343" },
		Device { id: 0x00B4, name: "MPC8315E" },
		Device { id: 0x00B6, name: "MPC8314E" },
		Device { id: 0x00C2, name: "MPC8379E" },
		Device { id: 0x00C3, name: "MPC8379" },
		Device { id: 0x00C4, name: "MPC8378E" },
		Device { id: 0x00C5, name: "MPC8378" },
		Device { id: 0x00C6, name: "MPC8377E" },
		Device { id: 0x00C7, name: "MPC8377" },
		Device { id: 0x0100, name: "P1020E" },
		Device { id: 0x0101, name: "P1020" },
		Device { id: 0x0102, name: "P1021E" },
		Device { id: 0x0103, name: "P1021" },
		Device { id: 0x0108, name: "P1011E" },
		Device { id: 0x0109, name: "P1011" },
		Device { id: 0x010A, name: "P1012E" },
		Device { id: 0x010B, name: "P1012" },
		Device { id: 0x0110, name: "P1022E" },
		Device { id: 0x0111, name: "P1022" },
		Device { id: 0x0118, name: "P1013E" },
		Device { id: 0x0119, name: "P1013" },
		Device { id: 0x0128, name: "P1010" },
		Device { id: 0x0400, name: "P4080E" },
		Device { id: 0x0401, name: "P4080" },
		Device { id: 0x0408, name: "P4040E" },
		Device { id: 0x0409, name: "P4040" },
		Device { id: 0x041F, name: "P3041" },
		Device { id: 0x0440, name: "T4240 with security" },
		Device { id: 0x0441, name: "T4240 without security" },
		Device { id: 0x0446, name: "T4160 with security" },
		Device { id: 0x0447, name: "T4160 without security" },
		Device { id: 0x0830, name: "T2080 with security" },
		Device { id: 0x0831, name: "T2080 without security" },
		Device { id: 0x0838, name: "T2081 with security" },
		Device { id: 0x0839, name: "T2081 without security" },
		Device { id: 0x580C, name: "MPC5121e" },
		Device { id: 0x7010, name: "MPC8641 PCI Host Bridge" },
		Device { id: 0x7011, name: "MPC8641D PCI Host Bridge" },
		Device { id: 0x7018, name: "MPC8610" },
		Device { id: 0xC006, name: "MPC8308" },
		Device { id: 0xFC02, name: "RedStone" },
		Device { id: 0xFC03, name: "CFI" },
	] },
	Vendor { id: 0x1958, name: "Faster Technology, LLC.", devices: &[
	] },
	Vendor { id: 0x1959, name: "PA Semi, Inc", devices: &[
		Device { id: 0xA000, name: "PA6T Core" },
		Device { id: 0xA001, name: "PWRficient Host Bridge" },
		Device { id: 0xA002, name: "PWRficient PCI-Express Port" },
		Device { id: 0xA003, name: "PWRficient SMBus Controller" },
		Device { id: 0xA004, name: "PWRficient 16550 UART" },
		Device { id: 0xA005, name: "PWRficient Gigabit Ethernet" },
		Device { id: 0xA006, name: "PWRficient 10-Gigabit Ethernet" },
		Device { id: 0xA007, name: "PWRficient DMA Controller" },
		Device { id: 0xA008, name: "PWRficient LPC/Localbus Interface" },
		Device { id: 0xA009, name: "PWRficient L2 Cache" },
		Device { id: 0xA00A, name: "PWRficient DDR2 Memory Controller" },
		Device { id: 0xA00B, name: "PWRficient SERDES" },
		Device { id: 0xA00C, name: "PWRficient System/Debug Controller" },
		Device { id: 0xA00D, name: "PWRficient PCI-Express Internal Endpoint" },
	] },
	Vendor { id: 0x1966, name: "Orad Hi-Tec Systems", devices: &[
		Device { id: 0x1975, name: "DVG64 family" },
		Device { id: 0x1977, name: "DVG128 family" },
	] },
	Vendor { id: 0x1969, name: "Qualcomm Atheros", devices: &[
		Device { id: 0x1026, name: "AR8121/AR8113/AR8114 Gigabit or Fast Ethernet" },
		Device { id: 0x1048, name: "Attansic L1 Gigabit Ethernet" },
		Device { id: 0x1062, name: "AR8132 Fast Ethernet" },
		Device { id: 0x1063, name: "AR8131 Gigabit Ethernet" },
		Device { id: 0x1066, name: "Attansic L2c Gigabit Ethernet" },
		Device { id: 0x1067, name: "Attansic L1c Gigabit Ethernet" },
		Device { id: 0x1073, name: "AR8151 v1.0 Gigabit Ethernet" },
		Device { id: 0x1083, name: "AR8151 v2.0 Gigabit Ethernet" },
		Device { id: 0x1090, name: "AR8162 Fast Ethernet" },
		Device { id: 0x1091, name: "AR8161 Gigabit Ethernet" },
		Device { id: 0x10A0, name: "QCA8172 Fast Ethernet" },
		Device { id: 0x10A1, name: "QCA8171 Gigabit Ethernet" },
		Device { id: 0x2048, name: "Attansic L2 Fast Ethernet" },
		Device { id: 0x2060, name: "AR8152 v1.1 Fast Ethernet" },
		Device { id: 0x2062, name: "AR8152 v2.0 Fast Ethernet" },
		Device { id: 0xE091, name: "Killer E220x Gigabit Ethernet Controller" },
		Device { id: 0xE0A1, name: "Killer E2400 Gigabit Ethernet Controller" },
		Device { id: 0xE0B1, name: "Killer E2500 Gigabit Ethernet Controller" },
	] },
	Vendor { id: 0x196A, name: "Sensory Networks Inc.", devices: &[
		Device { id: 0x0101, name: "NodalCore C-1000 Content Classification Accelerator" },
		Device { id: 0x0102, name: "NodalCore C-2000 Content Classification Accelerator" },
		Device { id: 0x0105, name: "NodalCore C-3000 Content Classification Accelerator" },
	] },
	Vendor { id: 0x196D, name: "Club-3D BV", devices: &[
	] },
	Vendor { id: 0x1971, name: "AGEIA Technologies, Inc.", devices: &[
		Device { id: 0x1011, name: "Physics Processing Unit [PhysX]" },
	] },
	Vendor { id: 0x1974, name: "Eberspaecher Electronics", devices: &[
	] },
	Vendor { id: 0x1976, name: "TRENDnet", devices: &[
	] },
	Vendor { id: 0x1977, name: "Parsec", devices: &[
	] },
	Vendor { id: 0x197B, name: "JMicron Technology Corp.", devices: &[
		Device { id: 0x0250, name: "JMC250 PCI Express Gigabit Ethernet Controller" },
		Device { id: 0x0260, name: "JMC260 PCI Express Fast Ethernet Controller" },
		Device { id: 0x0368, name: "JMB368 IDE controller" },
		Device { id: 0x2360, name: "JMB360 AHCI Controller" },
		Device { id: 0x2361, name: "JMB361 AHCI/IDE" },
		Device { id: 0x2362, name: "JMB362 SATA Controller" },
		Device { id: 0x2363, name: "JMB363 SATA/IDE Controller" },
		Device { id: 0x2364, name: "JMB364 AHCI Controller" },
		Device { id: 0x2365, name: "JMB365 AHCI/IDE" },
		Device { id: 0x2366, name: "JMB366 AHCI/IDE" },
		Device { id: 0x2368, name: "JMB368 IDE controller" },
		Device { id: 0x2369, name: "JMB369 Serial ATA Controller" },
		Device { id: 0x2380, name: "IEEE 1394 Host Controller" },
		Device { id: 0x2381, name: "Standard SD Host Controller" },
		Device { id: 0x2382, name: "SD/MMC Host Controller" },
		Device { id: 0x2383, name: "MS Host Controller" },
		Device { id: 0x2384, name: "xD Host Controller" },
		Device { id: 0x2386, name: "Standard SD Host Controller" },
		Device { id: 0x2387, name: "SD/MMC Host Controller" },
		Device { id: 0x2388, name: "MS Host Controller" },
		Device { id: 0x2389, name: "xD Host Controller" },
		Device { id: 0x2391, name: "Standard SD Host Controller" },
		Device { id: 0x2392, name: "SD/MMC Host Controller" },
		Device { id: 0x2393, name: "MS Host Controller" },
		Device { id: 0x2394, name: "xD Host Controller" },
	] },
	Vendor { id: 0x1982, name: "Distant Early Warning Communications Inc", devices: &[
		Device { id: 0x1600, name: "OX16C954 HOST-A" },
		Device { id: 0x16FF, name: "OX16C954 HOST-B" },
	] },
	Vendor { id: 0x1989, name: "Montilio Inc.", devices: &[
		Device { id: 0x0001, name: "RapidFile Bridge" },
		Device { id: 0x8001, name: "RapidFile" },
	] },
	Vendor { id: 0x198A, name: "Nallatech Ltd.", devices: &[
	] },
	Vendor { id: 0x1993, name: "Innominate Security Technologies AG", devices: &[
	] },
	Vendor { id: 0x1999, name: "A-Logics", devices: &[
		Device { id: 0xA900, name: "AM-7209 Video Processor" },
	] },
	Vendor { id: 0x199A, name: "Pulse-LINK, Inc.", devices: &[
	] },
	Vendor { id: 0x199D, name: "Xsigo Systems", devices: &[
		Device { id: 0x8209, name: "Virtual NIC Device" },
		Device { id: 0x890A, name: "Virtual HBA Device" },
	] },
	Vendor { id: 0x199F, name: "Auvitek", devices: &[
		Device { id: 0x8501, name: "AU85X1 PCI REV1.1" },
		Device { id: 0x8521, name: "AU8521 TV card" },
	] },
	Vendor { id: 0x19A2, name: "Emulex Corporation", devices: &[
		Device { id: 0x0120, name: "x1 PCIe Gen2 Bridge[Pilot4]" },
		Device { id: 0x0200, name: "BladeEngine 10Gb PCI-E iSCSI adapter" },
		Device { id: 0x0201, name: "BladeEngine 10Gb PCIe Network Adapter" },
		Device { id: 0x0211, name: "BladeEngine2 10Gb Gen2 PCIe Network Adapter" },
		Device { id: 0x0212, name: "BladeEngine2 10Gb Gen2 PCIe iSCSI Adapter" },
		Device { id: 0x0221, name: "BladeEngine3 10Gb Gen2 PCIe Network Adapter" },
		Device { id: 0x0222, name: "BladeEngine3 10Gb Gen2 PCIe iSCSI Adapter" },
		Device { id: 0x0700, name: "OneConnect OCe10100/OCe10102 Series 10 GbE" },
		Device { id: 0x0702, name: "OneConnect 10Gb iSCSI Initiator" },
		Device { id: 0x0704, name: "OneConnect OCe10100/OCe10102 Series 10 GbE CNA" },
		Device { id: 0x0710, name: "OneConnect 10Gb NIC (be3)" },
		Device { id: 0x0712, name: "OneConnect 10Gb iSCSI Initiator (be3)" },
		Device { id: 0x0714, name: "OneConnect 10Gb FCoE Initiator (be3)" },
		Device { id: 0x0800, name: "ServerView iRMC HTI" },
	] },
	Vendor { id: 0x19A8, name: "DAQDATA GmbH", devices: &[
	] },
	Vendor { id: 0x19AC, name: "Kasten Chase Applied Research", devices: &[
		Device { id: 0x0001, name: "ACA2400 Crypto Accelerator" },
	] },
	Vendor { id: 0x19AE, name: "Progeny Systems Corporation", devices: &[
		Device { id: 0x0520, name: "4135 HFT Interface Controller" },
		Device { id: 0x0521, name: "Decimator" },
	] },
	Vendor { id: 0x19BA, name: "ZyXEL Communications Corp.", devices: &[
		Device { id: 0x2330, name: "ZyWALL Turbo Card" },
	] },
	Vendor { id: 0x19C1, name: "Exegy Inc.", devices: &[
	] },
	Vendor { id: 0x19D1, name: "Motorola Expedience", devices: &[
	] },
	Vendor { id: 0x19D4, name: "Quixant Limited", devices: &[
	] },
	Vendor { id: 0x19DA, name: "ZOTAC International (MCO) Ltd.", devices: &[
	] },
	Vendor { id: 0x19DE, name: "Pico Computing", devices: &[
	] },
	Vendor { id: 0x19E2, name: "Vector Informatik GmbH", devices: &[
	] },
	Vendor { id: 0x19E3, name: "DDRdrive LLC", devices: &[
		Device { id: 0x5801, name: "DDRdrive X1" },
		Device { id: 0x5808, name: "DDRdrive X8" },
		Device { id: 0xDD52, name: "DDRdrive X1-30" },
	] },
	Vendor { id: 0x19E5, name: "Huawei Technologies Co., Ltd.", devices: &[
		Device { id: 0x1711, name: "Hi1710 [iBMC Intelligent Management system chip w/VGA support]" },
	] },
	Vendor { id: 0x19E7, name: "NET (Network Equipment Technologies)", devices: &[
		Device { id: 0x1001, name: "STIX DSP Card" },
		Device { id: 0x1002, name: "STIX - 1 Port T1/E1 Card" },
		Device { id: 0x1003, name: "STIX - 2 Port T1/E1 Card" },
		Device { id: 0x1004, name: "STIX - 4 Port T1/E1 Card" },
		Device { id: 0x1005, name: "STIX - 4 Port FXS Card" },
	] },
	Vendor { id: 0x19EE, name: "Netronome Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x19F1, name: "BFG Tech", devices: &[
	] },
	Vendor { id: 0x19FF, name: "Eclipse Electronic Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x1A03, name: "ASPEED Technology, Inc.", devices: &[
		Device { id: 0x1150, name: "AST1150 PCI-to-PCI Bridge" },
		Device { id: 0x2000, name: "ASPEED Graphics Family" },
	] },
	Vendor { id: 0x1A07, name: "Kvaser AB", devices: &[
		Device { id: 0x0006, name: "CAN interface PC104+ HS/HS" },
		Device { id: 0x0007, name: "CAN interface PCIcanx II HS or HS/HS" },
		Device { id: 0x0008, name: "CAN interface PCIEcan HS or HS/HS" },
		Device { id: 0x0009, name: "CAN interface PCI104 HS/HS" },
	] },
	Vendor { id: 0x1A08, name: "Sierra semiconductor", devices: &[
		Device { id: 0x0000, name: "SC15064" },
	] },
	Vendor { id: 0x1A0E, name: "DekTec Digital Video B.V.", devices: &[
		Device { id: 0x083F, name: "DTA-2111 VHF/UHF Modulator" },
	] },
	Vendor { id: 0x1A17, name: "Force10 Networks, Inc.", devices: &[
		Device { id: 0x8002, name: "PB-10GE-2P 10GbE Security Card" },
	] },
	Vendor { id: 0x1A1D, name: "GFaI e.V.", devices: &[
		Device { id: 0x1A17, name: "Meta Networks MTP-1G IDPS NIC" },
	] },
	Vendor { id: 0x1A1E, name: "3Leaf Systems, Inc.", devices: &[
	] },
	Vendor { id: 0x1A22, name: "Ambric Inc.", devices: &[
	] },
	Vendor { id: 0x1A29, name: "Fortinet, Inc.", devices: &[
		Device { id: 0x4338, name: "CP8 Content Processor ASIC" },
		Device { id: 0x4E36, name: "NP6 Network Processor" },
	] },
	Vendor { id: 0x1A2B, name: "Ascom AG", devices: &[
		Device { id: 0x0000, name: "GESP v1.2" },
		Device { id: 0x0001, name: "GESP v1.3" },
		Device { id: 0x0002, name: "ECOMP v1.3" },
		Device { id: 0x0005, name: "ETP v1.4" },
		Device { id: 0x000A, name: "ETP-104 v1.1" },
		Device { id: 0x000E, name: "DSLP-104 v1.1" },
	] },
	Vendor { id: 0x1A30, name: "Lantiq", devices: &[
		Device { id: 0x0680, name: "MtW8171 [Hyperion II]" },
		Device { id: 0x0700, name: "Wave300 PSB8224 [Hyperion III]" },
		Device { id: 0x0710, name: "Wave300 PSB8231 [Hyperion III]" },
	] },
	Vendor { id: 0x1A32, name: "Quanta Microsystems, Inc", devices: &[
	] },
	Vendor { id: 0x1A3B, name: "AzureWave", devices: &[
		Device { id: 0x1112, name: "AR9285 Wireless Network Adapter (PCI-Express)" },
	] },
	Vendor { id: 0x1A41, name: "Tilera Corp.", devices: &[
		Device { id: 0x0001, name: "TILE64 processor" },
		Device { id: 0x0002, name: "TILEPro processor" },
		Device { id: 0x0200, name: "TILE-Gx processor" },
		Device { id: 0x0201, name: "TILE-Gx Processor Virtual Function" },
		Device { id: 0x2000, name: "TILE-Gx PCI Express Root Port" },
	] },
	Vendor { id: 0x1A4A, name: "SLAC National Accelerator Lab PPA-REG", devices: &[
		Device { id: 0x1000, name: "MCOR Power Supply Controller" },
		Device { id: 0x1010, name: "AMC EVR - Stockholm Timing Board" },
		Device { id: 0x2000, name: "PGPCard - 4 Lane" },
		Device { id: 0x2001, name: "PGPCard - 8 Lane Plus EVR" },
		Device { id: 0x2010, name: "PCI-Express EVR" },
	] },
	Vendor { id: 0x1A51, name: "Hectronic AB", devices: &[
	] },
	Vendor { id: 0x1A55, name: "Rohde & Schwarz DVS GmbH", devices: &[
		Device { id: 0x0010, name: "SDStationOEM" },
		Device { id: 0x0011, name: "SDStationOEM II" },
		Device { id: 0x0020, name: "Centaurus" },
		Device { id: 0x0021, name: "Centaurus II" },
		Device { id: 0x0022, name: "Centaurus II LT" },
		Device { id: 0x0030, name: "CLIPSTER-VPU 1.x (Hugo)" },
		Device { id: 0x0040, name: "Hydra Cinema (JPEG)" },
		Device { id: 0x0050, name: "CLIPSTER-VPU 2.x (DigiLab)" },
		Device { id: 0x0060, name: "CLIPSTER-DCI 2.x (HydraX)" },
		Device { id: 0x0061, name: "Atomix" },
		Device { id: 0x0062, name: "Atomix LT" },
		Device { id: 0x0063, name: "Atomix HDMI" },
		Device { id: 0x0064, name: "Atomix STAN" },
		Device { id: 0x0065, name: "Atomix HDMI STAN" },
		Device { id: 0x0070, name: "RED Rocket" },
		Device { id: 0x0090, name: "CinePlay" },
	] },
	Vendor { id: 0x1A56, name: "Bigfoot Networks, Inc.", devices: &[
	] },
	Vendor { id: 0x1A57, name: "Highly Reliable Systems", devices: &[
	] },
	Vendor { id: 0x1A58, name: "Razer USA Ltd.", devices: &[
	] },
	Vendor { id: 0x1A5D, name: "Celoxica", devices: &[
	] },
	Vendor { id: 0x1A5E, name: "Aprius Inc.", devices: &[
	] },
	Vendor { id: 0x1A5F, name: "System TALKS Inc.", devices: &[
	] },
	Vendor { id: 0x1A68, name: "VirtenSys Limited", devices: &[
	] },
	Vendor { id: 0x1A71, name: "XenSource, Inc.", devices: &[
	] },
	Vendor { id: 0x1A73, name: "Violin Memory, Inc", devices: &[
		Device { id: 0x0001, name: "Mozart [Memory Appliance 1010]" },
	] },
	Vendor { id: 0x1A76, name: "Wavesat", devices: &[
	] },
	Vendor { id: 0x1A77, name: "Lightfleet Corporation", devices: &[
	] },
	Vendor { id: 0x1A78, name: "Virident Systems Inc.", devices: &[
		Device { id: 0x0031, name: "FlashMAX Drive" },
		Device { id: 0x0040, name: "FlashMAX II" },
		Device { id: 0x0041, name: "FlashMAX II" },
		Device { id: 0x0042, name: "FlashMAX II" },
		Device { id: 0x0050, name: "FlashMAX III" },
	] },
	Vendor { id: 0x1A84, name: "Commex Technologies", devices: &[
		Device { id: 0x0001, name: "Vulcan SP HT6210 10-Gigabit Ethernet (rev 02)" },
	] },
	Vendor { id: 0x1A88, name: "MEN Mikro Elektronik", devices: &[
		Device { id: 0x4D45, name: "Multifunction IP core" },
	] },
	Vendor { id: 0x1A8A, name: "StarBridge, Inc.", devices: &[
	] },
	Vendor { id: 0x1A8C, name: "Verigy Pte. Ltd.", devices: &[
		Device { id: 0x1100, name: "E8001-66443 PCI Express CIC" },
	] },
	Vendor { id: 0x1A8E, name: "DRS Technologies", devices: &[
		Device { id: 0x2090, name: "Model 2090 PCI Express" },
	] },
	Vendor { id: 0x1AA8, name: "Ciprico, Inc.", devices: &[
		Device { id: 0x0009, name: "RAIDCore Controller" },
		Device { id: 0x000A, name: "RAIDCore Controller" },
	] },
	Vendor { id: 0x1AAE, name: "Global Velocity, Inc.", devices: &[
	] },
	Vendor { id: 0x1AB6, name: "CalDigit, Inc.", devices: &[
		Device { id: 0x6201, name: "RAID Card" },
	] },
	Vendor { id: 0x1AB8, name: "Parallels, Inc.", devices: &[
		Device { id: 0x4000, name: "Virtual Machine Communication Interface" },
		Device { id: 0x4005, name: "Accelerated Virtual Video Adapter" },
		Device { id: 0x4006, name: "Memory Ballooning Controller" },
	] },
	Vendor { id: 0x1AB9, name: "Espia Srl", devices: &[
	] },
	Vendor { id: 0x1AC8, name: "Aeroflex Gaisler", devices: &[
	] },
	Vendor { id: 0x1ACC, name: "Point of View BV", devices: &[
	] },
	Vendor { id: 0x1AD7, name: "Spectracom Corporation", devices: &[
		Device { id: 0x8000, name: "TSync-PCIe Time Code Processor" },
		Device { id: 0x9100, name: "TPRO-PCI-66U Timecode Reader/Generator" },
	] },
	Vendor { id: 0x1ADE, name: "Spin Master Ltd.", devices: &[
		Device { id: 0x1501, name: "Swipetech barcode scanner" },
		Device { id: 0x3038, name: "PCIe Video Bridge" },
	] },
	Vendor { id: 0x1AE0, name: "Google, Inc.", devices: &[
	] },
	Vendor { id: 0x1AE7, name: "First Wise Media GmbH", devices: &[
		Device { id: 0x0520, name: "HFC-S PCI A [X-TENSIONS XC-520]" },
	] },
	Vendor { id: 0x1AE8, name: "Silicon Software GmbH", devices: &[
		Device { id: 0x0A40, name: "microEnable IV-BASE x1" },
		Device { id: 0x0A41, name: "microEnable IV-FULL x1" },
		Device { id: 0x0A44, name: "microEnable IV-FULL x4" },
		Device { id: 0x0E44, name: "microEnable IV-GigE x4" },
	] },
	Vendor { id: 0x1AE9, name: "Wilocity Ltd.", devices: &[
		Device { id: 0x0101, name: "Wil6200 PCI Express Root Port" },
		Device { id: 0x0200, name: "Wil6200 PCI Express Port" },
		Device { id: 0x0201, name: "Wil6200 Wireless PCI Express Port" },
		Device { id: 0x0301, name: "Wil6200 802.11ad Wireless Network Adapter" },
		Device { id: 0x0302, name: "Wil6200 802.11ad Wireless Network Adapter" },
		Device { id: 0x0310, name: "Wil6200 802.11ad Wireless Network Adapter" },
	] },
	Vendor { id: 0x1AEA, name: "Alcor Micro", devices: &[
		Device { id: 0x6601, name: "AU6601 PCI-E Flash card reader controller" },
	] },
	Vendor { id: 0x1AEC, name: "Wolfson Microelectronics", devices: &[
	] },
	Vendor { id: 0x1AED, name: "SanDisk", devices: &[
		Device { id: 0x1003, name: "ioDimm3 (v1.2)" },
		Device { id: 0x1005, name: "ioDimm3" },
		Device { id: 0x1006, name: "ioXtreme" },
		Device { id: 0x1007, name: "ioXtreme Pro" },
		Device { id: 0x1008, name: "ioXtreme-2" },
		Device { id: 0x2001, name: "ioDrive2" },
		Device { id: 0x3001, name: "ioMemory FHHL" },
		Device { id: 0x3002, name: "ioMemory HHHL" },
		Device { id: 0x3003, name: "ioMemory Mezzanine" },
	] },
	Vendor { id: 0x1AEE, name: "Caustic Graphics Inc.", devices: &[
	] },
	Vendor { id: 0x1AF4, name: "Red Hat, Inc.", devices: &[
		Device { id: 0x1000, name: "Virtio network device" },
		Device { id: 0x1001, name: "Virtio block device" },
		Device { id: 0x1002, name: "Virtio memory balloon" },
		Device { id: 0x1003, name: "Virtio console" },
		Device { id: 0x1004, name: "Virtio SCSI" },
		Device { id: 0x1005, name: "Virtio RNG" },
		Device { id: 0x1009, name: "Virtio filesystem" },
		Device { id: 0x1041, name: "Virtio network device" },
		Device { id: 0x1042, name: "Virtio block device" },
		Device { id: 0x1043, name: "Virtio console" },
		Device { id: 0x1044, name: "Virtio RNG" },
		Device { id: 0x1045, name: "Virtio memory balloon" },
		Device { id: 0x1048, name: "Virtio SCSI" },
		Device { id: 0x1049, name: "Virtio filesystem" },
		Device { id: 0x1050, name: "Virtio GPU" },
		Device { id: 0x1052, name: "Virtio input" },
		Device { id: 0x1110, name: "Inter-VM shared memory" },
	] },
	Vendor { id: 0x1AF5, name: "Netezza Corp.", devices: &[
	] },
	Vendor { id: 0x1AFA, name: "J & W Electronics Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1B03, name: "Magnum Semiconductor, Inc,", devices: &[
		Device { id: 0x6100, name: "DXT/DXTPro Multiformat Broadcast HD/SD Encoder/Decoder/Transcoder" },
		Device { id: 0x7000, name: "D7 Multiformat Broadcast HD/SD Encoder/Decoder/Transcoder" },
	] },
	Vendor { id: 0x1B08, name: "MSC Technologies GmbH", devices: &[
	] },
	Vendor { id: 0x1B0A, name: "Pegatron", devices: &[
	] },
	Vendor { id: 0x1B13, name: "Jaton Corp", devices: &[
	] },
	Vendor { id: 0x1B1A, name: "K&F Computing Research Co.", devices: &[
		Device { id: 0x0E70, name: "GRAPE" },
	] },
	Vendor { id: 0x1B21, name: "ASMedia Technology Inc.", devices: &[
		Device { id: 0x0611, name: "ASM1061 SATA IDE Controller" },
		Device { id: 0x0612, name: "ASM1062 Serial ATA Controller" },
		Device { id: 0x1042, name: "ASM1042 SuperSpeed USB Host Controller" },
		Device { id: 0x1080, name: "ASM1083/1085 PCIe to PCI Bridge" },
		Device { id: 0x1142, name: "ASM1042A USB 3.0 Host Controller" },
		Device { id: 0x1242, name: "ASM1142 USB 3.1 Host Controller" },
	] },
	Vendor { id: 0x1B2C, name: "Opal-RT Technologies Inc.", devices: &[
	] },
	Vendor { id: 0x1B36, name: "Red Hat, Inc.", devices: &[
		Device { id: 0x0001, name: "QEMU PCI-PCI bridge" },
		Device { id: 0x0002, name: "QEMU PCI 16550A Adapter" },
		Device { id: 0x0003, name: "QEMU PCI Dual-port 16550A Adapter" },
		Device { id: 0x0004, name: "QEMU PCI Quad-port 16550A Adapter" },
		Device { id: 0x0005, name: "QEMU PCI Test Device" },
		Device { id: 0x0006, name: "PCI Rocker Ethernet switch device" },
		Device { id: 0x0007, name: "PCI SD Card Host Controller Interface" },
		Device { id: 0x0008, name: "QEMU PCIe Host bridge" },
		Device { id: 0x0009, name: "QEMU PCI Expander bridge" },
		Device { id: 0x000A, name: "PCI-PCI bridge (multiseat)" },
		Device { id: 0x000B, name: "QEMU PCIe Expander bridge" },
		Device { id: 0x000C, name: "QEMU PCIe Root port" },
		Device { id: 0x000D, name: "QEMU XHCI Host Controller" },
		Device { id: 0x0100, name: "QXL paravirtual graphic card" },
	] },
	Vendor { id: 0x1B37, name: "Signal Processing Devices Sweden AB", devices: &[
		Device { id: 0x0001, name: "ADQ214" },
		Device { id: 0x0003, name: "ADQ114" },
		Device { id: 0x0005, name: "ADQ112" },
		Device { id: 0x000E, name: "ADQ108" },
		Device { id: 0x000F, name: "ADQDSP" },
		Device { id: 0x0014, name: "ADQ412" },
		Device { id: 0x0015, name: "ADQ212" },
		Device { id: 0x001B, name: "SDR14" },
		Device { id: 0x001C, name: "ADQ1600" },
		Device { id: 0x001E, name: "ADQ208" },
		Device { id: 0x001F, name: "DSU" },
		Device { id: 0x0020, name: "ADQ14" },
		Device { id: 0x0023, name: "ADQ7" },
		Device { id: 0x2014, name: "TX320" },
		Device { id: 0x2019, name: "S6000" },
	] },
	Vendor { id: 0x1B39, name: "sTec, Inc.", devices: &[
		Device { id: 0x0001, name: "S1120 PCIe Accelerator SSD" },
	] },
	Vendor { id: 0x1B3A, name: "Westar Display Technologies", devices: &[
		Device { id: 0x7589, name: "HRED J2000 - JPEG 2000 Video Codec Device" },
	] },
	Vendor { id: 0x1B3E, name: "Teradata Corp.", devices: &[
		Device { id: 0x1FA8, name: "BYNET BIC2SE/X" },
	] },
	Vendor { id: 0x1B40, name: "Schooner Information Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x1B47, name: "Numascale AS", devices: &[
		Device { id: 0x0601, name: "NumaChip N601" },
		Device { id: 0x0602, name: "NumaChip N602" },
	] },
	Vendor { id: 0x1B4B, name: "Marvell Technology Group Ltd.", devices: &[
		Device { id: 0x0640, name: "88SE9128 SATA III 6Gb/s RAID Controller" },
		Device { id: 0x9120, name: "88SE9120 SATA 6Gb/s Controller" },
		Device { id: 0x9123, name: "88SE9123 PCIe SATA 6.0 Gb/s controller" },
		Device { id: 0x9125, name: "88SE9125 PCIe SATA 6.0 Gb/s controller" },
		Device { id: 0x9128, name: "88SE9128 PCIe SATA 6 Gb/s RAID controller" },
		Device { id: 0x9130, name: "88SE9128 PCIe SATA 6 Gb/s RAID controller with HyperDuo" },
		Device { id: 0x9172, name: "88SE9172 SATA 6Gb/s Controller" },
		Device { id: 0x9178, name: "88SE9170 PCIe SATA 6Gb/s Controller" },
		Device { id: 0x917A, name: "88SE9172 SATA III 6Gb/s RAID Controller" },
		Device { id: 0x9183, name: "88SS9183 PCIe SSD Controller" },
		Device { id: 0x9192, name: "88SE9172 SATA III 6Gb/s RAID Controller" },
		Device { id: 0x91A0, name: "88SE912x SATA 6Gb/s Controller [IDE mode]" },
		Device { id: 0x91A4, name: "88SE912x IDE Controller" },
		Device { id: 0x9220, name: "88SE9220 PCIe 2.0 x2 2-port SATA 6 Gb/s RAID Controller" },
		Device { id: 0x9230, name: "88SE9230 PCIe SATA 6Gb/s Controller" },
		Device { id: 0x9235, name: "88SE9235 PCIe 2.0 x2 4-port SATA 6 Gb/s Controller" },
		Device { id: 0x9445, name: "88SE9445 PCIe 2.0 x4 4-Port SAS/SATA 6 Gbps RAID Controller" },
		Device { id: 0x9480, name: "88SE9480 SAS/SATA 6Gb/s RAID controller" },
		Device { id: 0x9485, name: "88SE9485 SAS/SATA 6Gb/s controller" },
	] },
	Vendor { id: 0x1B55, name: "NetUP Inc.", devices: &[
		Device { id: 0x18F6, name: "Dual DVB Universal CI card" },
		Device { id: 0x18F7, name: "Dual DVB Universal CI card rev 1.4" },
		Device { id: 0x2A2C, name: "Dual DVB-S2-CI card" },
		Device { id: 0xE2E4, name: "Dual DVB-T/C-CI RF card" },
		Device { id: 0xE5F4, name: "MPEG2 and H264 Encoder-Transcoder" },
		Device { id: 0xF1C4, name: "Dual ASI-RX/TX-CI card" },
	] },
	Vendor { id: 0x1B66, name: "Deltacast", devices: &[
		Device { id: 0x0007, name: "Delta-3G-elp-11 SDI I/O Board" },
	] },
	Vendor { id: 0x1B6F, name: "Etron Technology, Inc.", devices: &[
		Device { id: 0x7023, name: "EJ168 USB 3.0 Host Controller" },
		Device { id: 0x7052, name: "EJ188/EJ198 USB 3.0 Host Controller" },
	] },
	Vendor { id: 0x1B73, name: "Fresco Logic", devices: &[
		Device { id: 0x1000, name: "FL1000G USB 3.0 Host Controller" },
		Device { id: 0x1009, name: "FL1009 USB 3.0 Host Controller" },
		Device { id: 0x1100, name: "FL1100 USB 3.0 Host Controller" },
	] },
	Vendor { id: 0x1B74, name: "OpenVox Communication Co. Ltd.", devices: &[
		Device { id: 0x0115, name: "D115P/D115E Single-port E1/T1 card" },
		Device { id: 0xD130, name: "D130P/D130E Single-port E1/T1 card (3rd GEN)" },
		Device { id: 0xD210, name: "D210P/D210E Dual-port E1/T1 card(2nd generation)" },
		Device { id: 0xD230, name: "D230 Dual-port E1/T1 card (2nd generation)" },
		Device { id: 0xD410, name: "D410/430 Quad-port E1/T1 card" },
		Device { id: 0xD430, name: "D410/430 Quad-port E1/T1 card" },
	] },
	Vendor { id: 0x1B79, name: "Absolute Analysis", devices: &[
	] },
	Vendor { id: 0x1B85, name: "OCZ Technology Group, Inc.", devices: &[
		Device { id: 0x1041, name: "RevoDrive 3 X2 PCI-Express SSD 240 GB (Marvell Controller)" },
		Device { id: 0x6018, name: "RD400/400A SSD" },
		Device { id: 0x8788, name: "RevoDrive Hybrid" },
	] },
	Vendor { id: 0x1B94, name: "Signatec / Dynamic Signals Corp", devices: &[
		Device { id: 0xE400, name: "PX14400 Dual Xilinx Virtex5 based Digitizer" },
	] },
	Vendor { id: 0x1B96, name: "Western Digital", devices: &[
	] },
	Vendor { id: 0x1B9A, name: "XAVi Technologies Corp.", devices: &[
	] },
	Vendor { id: 0x1BAD, name: "ReFLEX CES", devices: &[
	] },
	Vendor { id: 0x1BB0, name: "SimpliVity Corporation", devices: &[
		Device { id: 0x0002, name: "OmniCube Accelerator OA-3000" },
		Device { id: 0x0010, name: "OmniCube Accelerator OA-3000-2" },
	] },
	Vendor { id: 0x1BB1, name: "Seagate Technology PLC", devices: &[
		Device { id: 0x005D, name: "Nytro PCIe Flash Storage" },
		Device { id: 0x0100, name: "Nytro Flash Storage" },
	] },
	Vendor { id: 0x1BB3, name: "Bluecherry", devices: &[
		Device { id: 0x4304, name: "BC-04120A MPEG4 4 port video encoder / decoder" },
		Device { id: 0x4309, name: "BC-08240A MPEG4 4 port video encoder / decoder" },
		Device { id: 0x4310, name: "BC-16480A MPEG4 16 port video encoder / decoder" },
		Device { id: 0x4E04, name: "BC-04120A 4 port MPEG4 video encoder / decoder" },
		Device { id: 0x4E09, name: "BC-08240A 8 port MPEG4 video encoder / decoder" },
		Device { id: 0x4E10, name: "BC-16480A 16 port MPEG4 video encoder / decoder" },
		Device { id: 0x5304, name: "BC-H04120A 4 port H.264 video and audio encoder / decoder" },
		Device { id: 0x5308, name: "BC-H08240A 8 port H.264 video and audio encoder / decoder" },
		Device { id: 0x5310, name: "BC-H16480A 16 port H.264 video and audio encoder / decoder" },
	] },
	Vendor { id: 0x1BB5, name: "Quantenna Communications, Inc.", devices: &[
	] },
	Vendor { id: 0x1BBF, name: "Maxeler Technologies Ltd.", devices: &[
		Device { id: 0x0003, name: "MAX3" },
		Device { id: 0x0004, name: "MAX4" },
	] },
	Vendor { id: 0x1BD0, name: "Astronics Corporation", devices: &[
		Device { id: 0x1001, name: "Mx5 PMC/XMC Databus Interface Card" },
		Device { id: 0x1002, name: "PM1553-5 (PC/104+ MIL-STD-1553 Interface Card)" },
		Device { id: 0x1004, name: "AB3000 Series Rugged Computer" },
		Device { id: 0x1005, name: "PE1000 (Multi-Protocol PCIe/104 Interface Card)" },
		Device { id: 0x1101, name: "OmniBus II PCIe Multi-Protocol Interface Card" },
		Device { id: 0x1102, name: "OmniBusBox II Multi-Protocol Interface Core" },
		Device { id: 0x1103, name: "OmniBus II cPCIe/PXIe Multi-Protocol Interface Card" },
	] },
	Vendor { id: 0x1BD4, name: "Inspur Electronic Information Industry Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1BEE, name: "IXXAT Automation GmbH", devices: &[
		Device { id: 0x0003, name: "CAN-IB200/PCIe" },
	] },
	Vendor { id: 0x1BEF, name: "Lantiq", devices: &[
		Device { id: 0x0011, name: "MIPS SoC PCI Express Port" },
	] },
	Vendor { id: 0x1BF4, name: "VTI Instruments Corporation", devices: &[
		Device { id: 0x0001, name: "SentinelEX" },
	] },
	Vendor { id: 0x1BFD, name: "EeeTOP", devices: &[
	] },
	Vendor { id: 0x1C09, name: "CSP, Inc.", devices: &[
		Device { id: 0x4254, name: "10G-PCIE3-8D-2S" },
		Device { id: 0x4255, name: "10G-PCIE3-8D-Q" },
		Device { id: 0x4256, name: "10G-PCIE3-8D-2S" },
		Device { id: 0x4258, name: "10G-PCIE3-8E-2S Network Adapter" },
		Device { id: 0x4260, name: "10G-PCIE3-8E-4S Network Adapter" },
		Device { id: 0x4261, name: "10G-PCIE3-8E-4S Network Adapter" },
		Device { id: 0x4262, name: "10G-PCIE3-8E-4S Network Adapter" },
		Device { id: 0x4263, name: "10G-PCIE3-8E-4S Network Adapter" },
		Device { id: 0x4264, name: "10G-PCIE3-8E-2S Network Adapter" },
		Device { id: 0x4265, name: "10G-PCIE3-8E-2S Network Adapter" },
	] },
	Vendor { id: 0x1C1C, name: "Symphony", devices: &[
		Device { id: 0x0001, name: "82C101" },
	] },
	Vendor { id: 0x1C28, name: "Lite-On IT Corp. / Plextor", devices: &[
		Device { id: 0x0122, name: "M6e PCI Express SSD [Marvell 88SS9183]" },
	] },
	Vendor { id: 0x1C2C, name: "Fiberblaze", devices: &[
		Device { id: 0x000A, name: "Capture" },
		Device { id: 0x000F, name: "SmartNIC" },
		Device { id: 0x00A0, name: "FBC4G Capture 4x1Gb" },
		Device { id: 0x00A1, name: "FBC4XG Capture 4x10Gb" },
		Device { id: 0x00A2, name: "FBC8XG Capture 8x10Gb" },
		Device { id: 0x00A3, name: "FBC2XG Capture 2x10Gb" },
		Device { id: 0x00A4, name: "FBC4XGG3 Capture 4x10Gb" },
		Device { id: 0x00A5, name: "FBC2XLG Capture 2x40Gb" },
		Device { id: 0x00A6, name: "FBC1CG Capture 1x100Gb" },
		Device { id: 0x00A9, name: "FBC2XGHH Capture 2x10Gb" },
		Device { id: 0x00AD, name: "FBC2CGG3HL Capture 2x200Gb" },
		Device { id: 0x00AF, name: "Capture slave device" },
		Device { id: 0xA001, name: "FBC2CGG3 Capture 2x200Gb" },
	] },
	Vendor { id: 0x1C32, name: "Highland Technology, Inc.", devices: &[
	] },
	Vendor { id: 0x1C33, name: "Daktronics, Inc", devices: &[
	] },
	Vendor { id: 0x1C3B, name: "Accensus, LLC", devices: &[
		Device { id: 0x0200, name: "Telas2" },
		Device { id: 0x0300, name: "Telas 2.V" },
	] },
	Vendor { id: 0x1C44, name: "Enmotus Inc", devices: &[
		Device { id: 0x8000, name: "8000 Storage IO Controller" },
	] },
	Vendor { id: 0x1C58, name: "HGST, Inc.", devices: &[
		Device { id: 0x0003, name: "Ultrastar SN100 Series NVMe SSD" },
		Device { id: 0x0023, name: "Ultrastar SN200 Series NVMe SSD" },
	] },
	Vendor { id: 0x1C5F, name: "Beijing Memblaze Technology Co. Ltd.", devices: &[
		Device { id: 0x0540, name: "PBlaze4 NVMe SSD" },
	] },
	Vendor { id: 0x1C63, name: "Science and Research Centre of Computer Technology (JSC \"NICEVT\")", devices: &[
		Device { id: 0x0008, name: "K1927BB1Ya [EC8430] Angara Interconnection Network Adapter" },
	] },
	Vendor { id: 0x1C7E, name: "TTTech Computertechnik AG", devices: &[
		Device { id: 0x0200, name: "zFAS Debug Port" },
	] },
	Vendor { id: 0x1C7F, name: "Elektrobit Austria GmbH", devices: &[
		Device { id: 0x5100, name: "EB5100" },
	] },
	Vendor { id: 0x1C8A, name: "TSF5 Corporation", devices: &[
		Device { id: 0x0001, name: "Hunter PCI Express" },
	] },
	Vendor { id: 0x1CB1, name: "Collion UG & Co.KG", devices: &[
	] },
	Vendor { id: 0x1CB8, name: "Dawning Information Industry Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1CC5, name: "Embedded Intelligence, Inc.", devices: &[
		Device { id: 0x0100, name: "CAN-PCIe-02" },
	] },
	Vendor { id: 0x1CC7, name: "Radian Memory Systems Inc.", devices: &[
		Device { id: 0x0200, name: "RMS-200" },
		Device { id: 0x0250, name: "RMS-250" },
	] },
	Vendor { id: 0x1CCF, name: "Zoom Corporation", devices: &[
		Device { id: 0x0001, name: "TAC-2 Thunderbolt Audio Converter" },
	] },
	Vendor { id: 0x1CD2, name: "SesKion GmbH", devices: &[
		Device { id: 0x0301, name: "Simulyzer-RT CompactPCI Serial DIO-1 card" },
		Device { id: 0x0302, name: "Simulyzer-RT CompactPCI Serial PSI5-ECU-1 card" },
		Device { id: 0x0303, name: "Simulyzer-RT CompactPCI Serial PSI5-SIM-1 card" },
		Device { id: 0x0304, name: "Simulyzer-RT CompactPCI Serial PWR-ANA-1 card" },
		Device { id: 0x0305, name: "Simulyzer-RT CompactPCI Serial CAN-1 card" },
	] },
	Vendor { id: 0x1CD7, name: "Nanjing Magewell Electronics Co., Ltd.", devices: &[
		Device { id: 0x0010, name: "Pro Capture Endpoint" },
	] },
	Vendor { id: 0x1CDD, name: "secunet Security Networks AG", devices: &[
	] },
	Vendor { id: 0x1CE4, name: "Exablaze", devices: &[
		Device { id: 0x0001, name: "ExaNIC X4" },
		Device { id: 0x0002, name: "ExaNIC X2" },
		Device { id: 0x0003, name: "ExaNIC X10" },
		Device { id: 0x0004, name: "ExaNIC X10-GM" },
		Device { id: 0x0005, name: "ExaNIC X40" },
		Device { id: 0x0006, name: "ExaNIC X10-HPT" },
		Device { id: 0x0007, name: "ExaNIC X40" },
		Device { id: 0x0008, name: "ExaNIC V5P" },
	] },
	Vendor { id: 0x1CF7, name: "Subspace Dynamics", devices: &[
	] },
	Vendor { id: 0x1D00, name: "Pure Storage", devices: &[
	] },
	Vendor { id: 0x1D0F, name: "Amazon.com, Inc.", devices: &[
		Device { id: 0xCD01, name: "NVMe SSD Controller" },
		Device { id: 0xEC20, name: "Elastic Network Adapter (ENA)" },
	] },
	Vendor { id: 0x1D17, name: "Zhaoxin", devices: &[
		Device { id: 0x070F, name: "ZX-100 PCI Express Root Port" },
		Device { id: 0x0710, name: "ZX-100/ZX-200 PCI Express Root Port" },
		Device { id: 0x0711, name: "ZX-100/ZX-200 PCI Express Root Port" },
		Device { id: 0x0712, name: "ZX-100/ZX-200 PCI Express Root Port" },
		Device { id: 0x0713, name: "ZX-100/ZX-200 PCI Express Root Port" },
		Device { id: 0x0714, name: "ZX-100/ZX-200 PCI Express Root Port" },
		Device { id: 0x0715, name: "ZX-100/ZX-200 PCI Express Root Port" },
		Device { id: 0x0716, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x0717, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x0718, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x0719, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x071A, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x071B, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x071C, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x071D, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x071E, name: "ZX-D PCI Express Root Port" },
		Device { id: 0x071F, name: "ZX-200 Upstream Port of PCI Express Switch" },
		Device { id: 0x0720, name: "ZX-200 PCIE RC6 controller" },
		Device { id: 0x0721, name: "ZX-200 Downstream Port of PCI Express Switch" },
		Device { id: 0x0722, name: "ZX-200 PCIE P2C bridge" },
		Device { id: 0x1000, name: "ZX-D Standard Host Bridge" },
		Device { id: 0x1001, name: "ZX-D Miscellaneous Bus" },
		Device { id: 0x3001, name: "ZX-100 Standard Host Bridge" },
		Device { id: 0x300A, name: "ZX-100 Miscellaneous Bus" },
		Device { id: 0x3038, name: "ZX-100/ZX-200 Standard Universal PCI to USB Host Controller" },
		Device { id: 0x3104, name: "ZX-100/ZX-200 Standard Enhanced PCI to USB Host Controller" },
		Device { id: 0x31B0, name: "ZX-100/ZX-D Standard Host Bridge" },
		Device { id: 0x31B1, name: "ZX-100/ZX-D Standard Host Bridge" },
		Device { id: 0x31B2, name: "ZX-100/ZX-D DRAM Controller" },
		Device { id: 0x31B3, name: "ZX-100/ZX-D Power Management Controller" },
		Device { id: 0x31B4, name: "ZX-100/ZX-D I/O APIC" },
		Device { id: 0x31B5, name: "ZX-100/ZX-D Scratch Device" },
		Device { id: 0x31B7, name: "ZX-100/ZX-D Standard Host Bridge" },
		Device { id: 0x31B8, name: "ZX-100/ZX-D PCI to PCI Bridge" },
		Device { id: 0x3288, name: "ZX-100/ZX-D High Definition Audio Controller" },
		Device { id: 0x345B, name: "ZX-100/ZX-D Miscellaneous Bus" },
		Device { id: 0x3A02, name: "ZX-100 C-320 GPU" },
		Device { id: 0x3A03, name: "ZX-D C-860 GPU" },
		Device { id: 0x9002, name: "ZX-100/ZX-200 EIDE Controller" },
		Device { id: 0x9003, name: "ZX-100 EIDE Controller" },
		Device { id: 0x9045, name: "ZX-100/ZX-D RAID Accelerator" },
		Device { id: 0x9046, name: "ZX-D RAID Accelerator" },
		Device { id: 0x9083, name: "ZX-100/ZX-200 StorX AHCI Controller" },
		Device { id: 0x9084, name: "ZX-100 StorX AHCI Controller" },
		Device { id: 0x9100, name: "ZX-200 Cross bus" },
		Device { id: 0x9101, name: "ZX-200 Traffic Controller" },
		Device { id: 0x9141, name: "ZX-100 High Definition Audio Controller" },
		Device { id: 0x9142, name: "ZX-D High Definition Audio Controller" },
		Device { id: 0x9180, name: "ZX-200 Networking Gigabit Ethernet Adapter" },
		Device { id: 0x9202, name: "ZX-100 USB eXtensible Host Controller" },
		Device { id: 0x9203, name: "ZX-200 USB eXtensible Host Controller" },
		Device { id: 0x9286, name: "ZX-D eMMC Host Controller" },
		Device { id: 0x9300, name: "ZX-D eSPI Host Controller" },
		Device { id: 0x95D0, name: "ZX-100 Universal SD Host Controller" },
		Device { id: 0xF410, name: "ZX-100/ZX-D PCI Com Port" },
	] },
	Vendor { id: 0x1D18, name: "RME", devices: &[
		Device { id: 0x0001, name: "Fireface UFX+" },
	] },
	Vendor { id: 0x1D1D, name: "CNEX Labs", devices: &[
		Device { id: 0x1F1F, name: "QEMU NVM Express LightNVM Controller" },
		Device { id: 0x2807, name: "8800 series NVMe SSD" },
	] },
	Vendor { id: 0x1D21, name: "Allo", devices: &[
	] },
	Vendor { id: 0x1D26, name: "Kalray Inc.", devices: &[
		Device { id: 0x0040, name: "Turbocard2 Accelerator" },
		Device { id: 0x0080, name: "Open Network Interface Card 80G" },
		Device { id: 0x00C0, name: "Turbocard3 Accelerator" },
		Device { id: 0xE004, name: "AB01/EMB01 Development Board" },
	] },
	Vendor { id: 0x1D40, name: "Techman Electronics (Changshu) Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x1D44, name: "DPT", devices: &[
		Device { id: 0xA400, name: "PM2x24/PM3224" },
	] },
	Vendor { id: 0x1D49, name: "Lenovo", devices: &[
	] },
	Vendor { id: 0x1D4C, name: "Diamanti, Inc.", devices: &[
	] },
	Vendor { id: 0x1D5C, name: "Fantasia Trading LLC", devices: &[
	] },
	Vendor { id: 0x1D61, name: "Technobox, Inc.", devices: &[
	] },
	Vendor { id: 0x1D62, name: "Nebbiolo Technologies", devices: &[
	] },
	Vendor { id: 0x1D65, name: "Imagine Communications Corp.", devices: &[
		Device { id: 0x04DE, name: "Taurus/McKinley" },
	] },
	Vendor { id: 0x1D6A, name: "Aquantia Corp.", devices: &[
		Device { id: 0xD107, name: "AQC107 NBase-T/IEEE 802.3bz Ethernet Controller [AQtion]" },
	] },
	Vendor { id: 0x1D6C, name: "Atomic Rules LLC", devices: &[
		Device { id: 0x1001, name: "A5PL-E1" },
		Device { id: 0x1002, name: "A5PL-E7" },
		Device { id: 0x1003, name: "S5PEDS-AB" },
		Device { id: 0x1004, name: "KC705-K325" },
		Device { id: 0x1005, name: "ZC706-Z045" },
		Device { id: 0x1006, name: "KCU105-KU040" },
		Device { id: 0x1007, name: "XUSP3S-VU095 [Jasper]" },
		Device { id: 0x1008, name: "XUSPL4-VU065 [Mustang UltraScale]" },
		Device { id: 0x1009, name: "XUSPL4-VU3P [Mustang UltraScale+]" },
		Device { id: 0x100A, name: "A10PL4-A10GX115" },
		Device { id: 0x100B, name: "K35-2SFP" },
		Device { id: 0x100C, name: "K35-4SFP" },
		Device { id: 0x100D, name: "AR-ARKA-FX0 [Arkville 32B DPDK Data Mover]" },
		Device { id: 0x100E, name: "AR-ARKA-FX1 [Arkville 64B DPDK Data Mover]" },
		Device { id: 0x4200, name: "A5PL-E1-10GETI [10 GbE Ethernet Traffic Instrument]" },
	] },
	Vendor { id: 0x1D78, name: "DERA", devices: &[
	] },
	Vendor { id: 0x1D7C, name: "Aerotech, Inc.", devices: &[
	] },
	Vendor { id: 0x1D87, name: "Fuzhou Rockchip Electronics Co., Ltd", devices: &[
	] },
	Vendor { id: 0x1D8F, name: "Enyx", devices: &[
	] },
	Vendor { id: 0x1D95, name: "Graphcore Ltd", devices: &[
	] },
	Vendor { id: 0x1DA1, name: "Teko Telecom S.r.l.", devices: &[
	] },
	Vendor { id: 0x1DA2, name: "Sapphire Technology Limited", devices: &[
	] },
	Vendor { id: 0x1DE1, name: "Tekram Technology Co.,Ltd.", devices: &[
		Device { id: 0x0391, name: "TRM-S1040 [DC-315 / DC-395 series]" },
		Device { id: 0x2020, name: "DC-390" },
		Device { id: 0x690C, name: "690c" },
		Device { id: 0xDC29, name: "DC290" },
	] },
	Vendor { id: 0x1DE5, name: "Eideticom, Inc", devices: &[
		Device { id: 0x1000, name: "IO Memory Controller" },
		Device { id: 0x2000, name: "NoLoad Hardware Development Kit" },
	] },
	Vendor { id: 0x1FC0, name: "Ascom (Finland) Oy", devices: &[
		Device { id: 0x0300, name: "E2200 Dual E1/Rawpipe Card" },
		Device { id: 0x0301, name: "C5400 SHDSL/E1 Card" },
	] },
	Vendor { id: 0x1FC1, name: "QLogic, Corp.", devices: &[
		Device { id: 0x000D, name: "IBA6110 InfiniBand HCA" },
		Device { id: 0x0010, name: "IBA6120 InfiniBand HCA" },
	] },
	Vendor { id: 0x1FC9, name: "Tehuti Networks Ltd.", devices: &[
		Device { id: 0x3009, name: "10-Giga TOE SmartNIC" },
		Device { id: 0x3010, name: "10-Giga TOE SmartNIC" },
		Device { id: 0x3014, name: "10-Giga TOE SmartNIC 2-Port" },
		Device { id: 0x3110, name: "10-Giga TOE Single Port SmartNIC" },
		Device { id: 0x3114, name: "10-Giga TOE Dual Port Low Profile SmartNIC" },
		Device { id: 0x3310, name: "10-Giga TOE SFP+ Single Port SmartNIC" },
		Device { id: 0x3314, name: "10-Giga TOE Dual Port Low Profile SmartNIC" },
		Device { id: 0x4010, name: "TN4010 Clean SROM" },
		Device { id: 0x4020, name: "TN9030 10GbE CX4 Ethernet Adapter" },
		Device { id: 0x4022, name: "TN9310 10GbE SFP+ Ethernet Adapter" },
		Device { id: 0x4024, name: "TN9210 10GBase-T Ethernet Adapter" },
		Device { id: 0x4025, name: "TN9510 10GBase-T/NBASE-T Ethernet Adapter" },
		Device { id: 0x4026, name: "TN9610 10GbE SFP+ Ethernet Adapter" },
		Device { id: 0x4027, name: "TN9710P 10GBase-T/NBASE-T Ethernet Adapter" },
		Device { id: 0x4527, name: "TN9710Q 5GBase-T/NBASE-T Ethernet Adapter" },
	] },
	Vendor { id: 0x1FCC, name: "StreamLabs", devices: &[
		Device { id: 0xF416, name: "MS416" },
		Device { id: 0xFB01, name: "MH4LM" },
	] },
	Vendor { id: 0x1FCE, name: "Cognio Inc.", devices: &[
		Device { id: 0x0001, name: "Spectrum Analyzer PC Card (SAgE)" },
	] },
	Vendor { id: 0x1FD4, name: "SUNIX Co., Ltd.", devices: &[
		Device { id: 0x0001, name: "Matrix multiport serial adapter" },
		Device { id: 0x1999, name: "Multiport serial controller" },
	] },
	Vendor { id: 0x2000, name: "Smart Link Ltd.", devices: &[
		Device { id: 0x2800, name: "SmartPCI2800 V.92 PCI Soft DFT" },
	] },
	Vendor { id: 0x2001, name: "Temporal Research Ltd", devices: &[
	] },
	Vendor { id: 0x2003, name: "Smart Link Ltd.", devices: &[
		Device { id: 0x8800, name: "LM-I56N" },
	] },
	Vendor { id: 0x2004, name: "Smart Link Ltd.", devices: &[
	] },
	Vendor { id: 0x20F4, name: "TRENDnet", devices: &[
	] },
	Vendor { id: 0x2116, name: "ZyDAS Technology Corp.", devices: &[
	] },
	Vendor { id: 0x21C3, name: "21st Century Computer Corp.", devices: &[
	] },
	Vendor { id: 0x2304, name: "Colorgraphic Communications Corp.", devices: &[
	] },
	Vendor { id: 0x2348, name: "Racore", devices: &[
		Device { id: 0x2010, name: "8142 100VG/AnyLAN" },
	] },
	Vendor { id: 0x2646, name: "Kingston Technologies", devices: &[
	] },
	Vendor { id: 0x270B, name: "Xantel Corporation", devices: &[
	] },
	Vendor { id: 0x270F, name: "Chaintech Computer Co. Ltd", devices: &[
	] },
	Vendor { id: 0x2711, name: "AVID Technology Inc.", devices: &[
	] },
	Vendor { id: 0x2955, name: "Connectix Virtual PC", devices: &[
		Device { id: 0x6E61, name: "OHCI USB 1.1 controller" },
	] },
	Vendor { id: 0x2A15, name: "3D Vision(???)", devices: &[
	] },
	Vendor { id: 0x2BD8, name: "ROPEX Industrie-Elektronik GmbH", devices: &[
	] },
	Vendor { id: 0x3000, name: "Hansol Electronics Inc.", devices: &[
	] },
	Vendor { id: 0x3112, name: "Satelco Ingenieria S.A.", devices: &[
	] },
	Vendor { id: 0x3130, name: "AUDIOTRAK", devices: &[
	] },
	Vendor { id: 0x3142, name: "Post Impression Systems.", devices: &[
	] },
	Vendor { id: 0x31AB, name: "Zonet", devices: &[
		Device { id: 0x1FAA, name: "ZEW1602 802.11b/g Wireless Adapter" },
	] },
	Vendor { id: 0x3388, name: "Hint Corp", devices: &[
		Device { id: 0x0013, name: "HiNT HC4 PCI to ISDN bridge, Multimedia audio controller" },
		Device { id: 0x0014, name: "HiNT HC4 PCI to ISDN bridge, Network controller" },
		Device { id: 0x0020, name: "HB6 Universal PCI-PCI bridge (transparent mode)" },
		Device { id: 0x0021, name: "HB6 Universal PCI-PCI bridge (non-transparent mode)" },
		Device { id: 0x0022, name: "HiNT HB4 PCI-PCI Bridge (PCI6150)" },
		Device { id: 0x0026, name: "HB2 PCI-PCI Bridge" },
		Device { id: 0x1014, name: "AudioTrak Maya" },
		Device { id: 0x1018, name: "Audiotrak INCA88" },
		Device { id: 0x1019, name: "Miditrak 2120" },
		Device { id: 0x101A, name: "E.Band [AudioTrak Inca88]" },
		Device { id: 0x101B, name: "E.Band [AudioTrak Inca88]" },
		Device { id: 0x8011, name: "VXPro II Chipset" },
		Device { id: 0x8012, name: "VXPro II Chipset" },
		Device { id: 0x8013, name: "VXPro II IDE" },
		Device { id: 0xA103, name: "Blackmagic Design DeckLink HD Pro" },
	] },
	Vendor { id: 0x3411, name: "Quantum Designs (H.K.) Inc", devices: &[
	] },
	Vendor { id: 0x3442, name: "Bihl+Wiedemann GmbH", devices: &[
		Device { id: 0x1783, name: "AS-i 3.0 cPCI Master" },
		Device { id: 0x1922, name: "AS-i 3.0 PCI Master" },
	] },
	Vendor { id: 0x3475, name: "Arastra Inc.", devices: &[
	] },
	Vendor { id: 0x3513, name: "ARCOM Control Systems Ltd", devices: &[
	] },
	Vendor { id: 0x37D9, name: "ITD Firm ltd.", devices: &[
		Device { id: 0x1138, name: "SCHD-PH-8 Phase detector" },
		Device { id: 0x1140, name: "VR-12-PCI" },
		Device { id: 0x1141, name: "PCI-485(422)" },
		Device { id: 0x1142, name: "PCI-CAN2" },
	] },
	Vendor { id: 0x3842, name: "eVga.com. Corp.", devices: &[
	] },
	Vendor { id: 0x38EF, name: "4Links", devices: &[
	] },
	Vendor { id: 0x3D3D, name: "3DLabs", devices: &[
		Device { id: 0x0001, name: "GLINT 300SX" },
		Device { id: 0x0002, name: "GLINT 500TX" },
		Device { id: 0x0003, name: "GLINT Delta" },
		Device { id: 0x0004, name: "Permedia" },
		Device { id: 0x0005, name: "Permedia" },
		Device { id: 0x0006, name: "GLINT MX" },
		Device { id: 0x0007, name: "3D Extreme" },
		Device { id: 0x0008, name: "GLINT Gamma G1" },
		Device { id: 0x0009, name: "Permedia II 2D+3D" },
		Device { id: 0x000A, name: "GLINT R3" },
		Device { id: 0x000C, name: "GLINT R3 [Oxygen VX1]" },
		Device { id: 0x000D, name: "GLint R4 rev A" },
		Device { id: 0x000E, name: "GLINT Gamma G2" },
		Device { id: 0x0011, name: "GLint R4 rev B" },
		Device { id: 0x0012, name: "GLint R5 rev A" },
		Device { id: 0x0013, name: "GLint R5 rev B" },
		Device { id: 0x0020, name: "VP10 visual processor" },
		Device { id: 0x0022, name: "VP10 visual processor" },
		Device { id: 0x0024, name: "VP9 visual processor" },
		Device { id: 0x002C, name: "Wildcat Realizm 100/200" },
		Device { id: 0x0030, name: "Wildcat Realizm 800" },
		Device { id: 0x0032, name: "Wildcat Realizm 500" },
		Device { id: 0x0100, name: "Permedia II 2D+3D" },
		Device { id: 0x07A1, name: "Wildcat III 6210" },
		Device { id: 0x07A2, name: "Sun XVR-500 Graphics Accelerator" },
		Device { id: 0x07A3, name: "Wildcat IV 7210" },
		Device { id: 0x1004, name: "Permedia" },
		Device { id: 0x3D04, name: "Permedia" },
		Device { id: 0xFFFF, name: "Glint VGA" },
	] },
	Vendor { id: 0x4005, name: "Avance Logic Inc.", devices: &[
		Device { id: 0x0300, name: "ALS300 PCI Audio Device" },
		Device { id: 0x0308, name: "ALS300+ PCI Audio Device" },
		Device { id: 0x0309, name: "PCI Input Controller" },
		Device { id: 0x1064, name: "ALG-2064" },
		Device { id: 0x2064, name: "ALG-2064i" },
		Device { id: 0x2128, name: "ALG-2364A GUI Accelerator" },
		Device { id: 0x2301, name: "ALG-2301" },
		Device { id: 0x2302, name: "ALG-2302" },
		Device { id: 0x2303, name: "AVG-2302 GUI Accelerator" },
		Device { id: 0x2364, name: "ALG-2364A" },
		Device { id: 0x2464, name: "ALG-2464" },
		Device { id: 0x2501, name: "ALG-2564A/25128A" },
		Device { id: 0x4000, name: "ALS4000 Audio Chipset" },
		Device { id: 0x4710, name: "ALC200/200P" },
	] },
	Vendor { id: 0x4033, name: "Addtron Technology Co, Inc.", devices: &[
		Device { id: 0x1360, name: "RTL8139 Ethernet" },
	] },
	Vendor { id: 0x4040, name: "NetXen Incorporated", devices: &[
		Device { id: 0x0001, name: "NXB-10GXSR 10-Gigabit Ethernet PCIe Adapter with SR-XFP optical interface" },
		Device { id: 0x0002, name: "NXB-10GCX4 10-Gigabit Ethernet PCIe Adapter with CX4 copper interface" },
		Device { id: 0x0003, name: "NXB-4GCU Quad Gigabit Ethernet PCIe Adapter with 1000-BASE-T interface" },
		Device { id: 0x0004, name: "BladeCenter-H 10-Gigabit Ethernet High Speed Daughter Card" },
		Device { id: 0x0005, name: "NetXen Dual Port 10GbE Multifunction Adapter for c-Class" },
		Device { id: 0x0024, name: "XG Mgmt" },
		Device { id: 0x0025, name: "XG Mgmt" },
		Device { id: 0x0100, name: "NX3031 Multifunction 1/10-Gigabit Server Adapter" },
	] },
	Vendor { id: 0x4143, name: "Digital Equipment Corp", devices: &[
	] },
	Vendor { id: 0x4144, name: "Alpha Data", devices: &[
		Device { id: 0x0044, name: "ADM-XRCIIPro" },
	] },
	Vendor { id: 0x4150, name: "ONA Electroerosion", devices: &[
		Device { id: 0x0001, name: "PCI32TLITE FILSTRUP1 PCI to VME Bridge Controller" },
		Device { id: 0x0006, name: "PCI32TLITE UART 16550 Opencores" },
		Device { id: 0x0007, name: "PCI32TLITE CAN Controller Opencores" },
	] },
	Vendor { id: 0x415A, name: "Auzentech, Inc.", devices: &[
	] },
	Vendor { id: 0x416C, name: "Aladdin Knowledge Systems", devices: &[
		Device { id: 0x0100, name: "AladdinCARD" },
		Device { id: 0x0200, name: "CPC" },
	] },
	Vendor { id: 0x4254, name: "DVBSky", devices: &[
	] },
	Vendor { id: 0x4321, name: "Tata Power Strategic Electronics Division", devices: &[
	] },
	Vendor { id: 0x4348, name: "WCH.CN", devices: &[
		Device { id: 0x2273, name: "CH351 PCI Dual Serial Port Controller" },
		Device { id: 0x3253, name: "CH352 PCI Dual Serial Port Controller" },
		Device { id: 0x3453, name: "CH353 PCI Quad Serial Port Controller" },
		Device { id: 0x5053, name: "CH352 PCI Serial and Parallel Port Controller" },
		Device { id: 0x7053, name: "CH353 PCI Dual Serial and Parallel Ports Controller" },
		Device { id: 0x7073, name: "CH356 PCI Quad Serial and Parallel Ports Controller" },
		Device { id: 0x7173, name: "CH355 PCI Quad Serial Port Controller" },
	] },
	Vendor { id: 0x434E, name: "CAST Navigation LLC", devices: &[
	] },
	Vendor { id: 0x4444, name: "Internext Compression Inc", devices: &[
		Device { id: 0x0016, name: "iTVC16 (CX23416) Video Decoder" },
		Device { id: 0x0803, name: "iTVC15 (CX23415) Video Decoder" },
	] },
	Vendor { id: 0x4468, name: "Bridgeport machines", devices: &[
	] },
	Vendor { id: 0x4594, name: "Cogetec Informatique Inc", devices: &[
	] },
	Vendor { id: 0x45FB, name: "Baldor Electric Company", devices: &[
	] },
	Vendor { id: 0x4624, name: "Budker Institute of Nuclear Physics", devices: &[
		Device { id: 0xADC1, name: "ADC200ME High speed ADC" },
		Device { id: 0xDE01, name: "DL200ME High resolution delay line PCI based card" },
		Device { id: 0xDE02, name: "DL200ME Middle resolution delay line PCI based card" },
	] },
	Vendor { id: 0x4651, name: "TXIC", devices: &[
	] },
	Vendor { id: 0x4680, name: "Umax Computer Corp", devices: &[
	] },
	Vendor { id: 0x4843, name: "Hercules Computer Technology Inc", devices: &[
	] },
	Vendor { id: 0x4916, name: "RedCreek Communications Inc", devices: &[
		Device { id: 0x1960, name: "RedCreek PCI adapter" },
	] },
	Vendor { id: 0x4943, name: "Growth Networks", devices: &[
	] },
	Vendor { id: 0x494F, name: "ACCES I/O Products, Inc.", devices: &[
		Device { id: 0x0508, name: "PCI-IDO-16A FET Output Card" },
		Device { id: 0x0518, name: "PCI-IDO-32A FET Output Card" },
		Device { id: 0x0520, name: "PCI-IDO-48 FET Output Card" },
		Device { id: 0x0521, name: "PCI-IDO-48A FET Output Card" },
		Device { id: 0x0703, name: "PCIe-RO-4 Electromechanical Relay Output Card" },
		Device { id: 0x07D0, name: "PCIe-IDO-24 FET Output Card" },
		Device { id: 0x0920, name: "PCI-IDI-48 Isolated Digital Input Card" },
		Device { id: 0x0BD0, name: "PCIe-IDI-24 Isolated Digital Input Card" },
		Device { id: 0x0C50, name: "PCI-DIO-24H 1x 8255 Digital Input / Output Card" },
		Device { id: 0x0C51, name: "PCI-DIO-24D 1x 8255 Digital Input / Output Card" },
		Device { id: 0x0C52, name: "PCIe-DIO-24 1x 8255 Digital Input / Output Card" },
		Device { id: 0x0C53, name: "PCIe-DIO-24H 8255 Digital Input / Output Card" },
		Device { id: 0x0C57, name: "mPCIe-DIO-24 8255 Digital Input / Output Card" },
		Device { id: 0x0C60, name: "PCI-DIO-48H 8255 Digital Input / Output Card" },
		Device { id: 0x0C61, name: "PCIe-DIO-48 8255 Digital Input / Output Card" },
		Device { id: 0x0C62, name: "P104-DIO-48 8255 Digital Input / Output Card" },
		Device { id: 0x0C68, name: "PCI-DIO-72 8255 Digital Input / Output Card" },
		Device { id: 0x0C69, name: "P104-DIO-96 8255 Digital Input / Output Card" },
		Device { id: 0x0C70, name: "PCI-DIO-96 8255 Digital Input / Output Card" },
		Device { id: 0x0C78, name: "PCI-DIO-120 8255 Digital Input / Output Card" },
		Device { id: 0x0DC8, name: "PCI-IDIO-16 Isolated Digital Input / FET Output Card" },
		Device { id: 0x0E50, name: "PCI-DIO-24S 8255 Digital Input / Output Card" },
		Device { id: 0x0E51, name: "PCI-DIO-24H(C) 8255 Digital Input / Output Card" },
		Device { id: 0x0E52, name: "PCI-DIO-24D(C) 8255 Digital Input / Output Card" },
		Device { id: 0x0E53, name: "PCIe-DIO-24S 8255 Digital Input / Output Card" },
		Device { id: 0x0E54, name: "PCIe-DIO-24HS 8255 Digital Input / Output Card" },
		Device { id: 0x0E55, name: "PCIe-DIO-24DC 8255 Digital Input / Output Card" },
		Device { id: 0x0E56, name: "PCIe-DIO-24DCS 8255 Digital Input / Output Card" },
		Device { id: 0x0E57, name: "mPCIe-DIO-24S 8255 Digital Input / Output Card" },
		Device { id: 0x0E60, name: "PCI-DIO-48S 2x 8255 Digital Input / Output Card" },
		Device { id: 0x0E61, name: "PCIe-DIO-48S 2x 8255 Digital Input / Output Card" },
		Device { id: 0x0E62, name: "P104-DIO-48S 2x 8255 Digital Input / Output Card" },
		Device { id: 0x0F00, name: "PCI-IIRO-8 Isolated Digital / Relay Output Card" },
		Device { id: 0x0F01, name: "LPCI-IIRO-8 Isolated Digital / Relay Output Card" },
		Device { id: 0x0F02, name: "PCIe-IIRO-8 Isolated Digital / Relay Output Card" },
		Device { id: 0x0F08, name: "PCI-IIRO-16 Isolated Digital / Relay Output Card" },
		Device { id: 0x0F09, name: "PCIe-IIRO-16 Isolated Digital / Relay Output Card" },
		Device { id: 0x0FC0, name: "PCIe-IDIO-12 Isolated Digital Input / FET Output Card" },
		Device { id: 0x0FC1, name: "PCIe-IDI-12 Isolated Digital Input Card" },
		Device { id: 0x0FC2, name: "PCIe-IDO-12 FET Output Card" },
		Device { id: 0x0FD0, name: "PCIe-IDIO-24 Isolated Digital Input / FET Output Card" },
		Device { id: 0x1050, name: "PCI-422/485-2 2x RS422/RS484 Card" },
		Device { id: 0x1051, name: "PCIe-COM-2SRJ 2x RS422/RS484 Card w/RJ45 Connectors" },
		Device { id: 0x1052, name: "104I-COM-2S 2x RS422/RS484 PCI/104 Board" },
		Device { id: 0x1053, name: "mPCIe-COM-2S 2x RS422/RS484 PCI Express Mini Card" },
		Device { id: 0x1058, name: "PCI-COM422/4 4x RS422 Card" },
		Device { id: 0x1059, name: "PCI-COM485/4 4x RS485 Card" },
		Device { id: 0x105A, name: "PCIe-COM422-4 4x RS422 Card" },
		Device { id: 0x105B, name: "PCIe-COM485-4 4x RS485 Card" },
		Device { id: 0x105C, name: "PCIe-COM-4SRJ 4x RS422/RS485 Card w/RJ45 Connectors" },
		Device { id: 0x105D, name: "104I-COM-4S 4x RS422/RS484 PCI/104 Board" },
		Device { id: 0x105E, name: "mPCIe-COM-4S 4x RS422/RS484 PCI Express Mini Card" },
		Device { id: 0x1068, name: "PCI-COM422/8 8x RS422 Card" },
		Device { id: 0x1069, name: "PCI-COM485/8 8x RS485 Card" },
		Device { id: 0x106A, name: "PCIe-COM422-8 8x RS422 Card" },
		Device { id: 0x106B, name: "PCIe-COM485-8 8x RS485 Card" },
		Device { id: 0x106C, name: "104I-COM-8S 8x RS422/RS485 PCI/104 Board" },
		Device { id: 0x1088, name: "PCI-COM232/1 1x RS232 Card" },
		Device { id: 0x1090, name: "PCI-COM232/2 2x RS232 Card" },
		Device { id: 0x1091, name: "PCIe-COM232-2RJ 2x RS232 Card w/RJ45 Connectors" },
		Device { id: 0x1093, name: "mPCIe-COM232-2 2x RS232 PCI Express Mini Card" },
		Device { id: 0x1098, name: "PCIe-COM232-4 4x RS232 Card" },
		Device { id: 0x1099, name: "PCIe-COM232-4RJ 4x RS232 Card w/RJ45 Connectors" },
		Device { id: 0x109B, name: "mPCIe-COM232-4 4x RS232 PCI Express Mini Card" },
		Device { id: 0x10A8, name: "P104-COM232-8 8x RS232 PC-104+ Board" },
		Device { id: 0x10A9, name: "PCIe-COM232-8 8x RS232 Card" },
		Device { id: 0x10C9, name: "PCI-COM-1S 1x RS422/RS485 Card" },
		Device { id: 0x10D0, name: "PCI-COM2S 2x RS422/RS485 Card" },
		Device { id: 0x10D1, name: "PCIe-COM-2SMRJ 2x RS232/RS422/RS485 Card w/RJ45 Connectors" },
		Device { id: 0x10D2, name: "104I-COM-2SM 2x RS232/RS422/RS485 PCI/104 Board" },
		Device { id: 0x10D3, name: "mPCIe-COM-2SM 2x RS232/RS422/RS485 PCI Express Mini Card" },
		Device { id: 0x10D8, name: "PCI-COM-4SM 4x RS232/RS422/RS485 Card" },
		Device { id: 0x10D9, name: "PCIe-COM-4SM 4x RS232/RS422/RS485 Card" },
		Device { id: 0x10DA, name: "PCIe-COM-4SMRJ 4x RS232/RS422/RS485 Card w/RJ45 Connectors" },
		Device { id: 0x10DB, name: "104I-COM-4SM 4x RS232/RS422/RS485 PCI/104 Board" },
		Device { id: 0x10DC, name: "mPCIe-COM-4SM 4x RS232/RS422/RS485 PCI Express Mini Card" },
		Device { id: 0x10E8, name: "PCI-COM-8SM 8x RS232/RS422/RS485 Card" },
		Device { id: 0x10E9, name: "PCIe-COM-8SM 8x RS232/RS422/RS485 Card" },
		Device { id: 0x10EA, name: "104I-COM-8SM 8x RS232/RS422/RS485 PCI-104 Board" },
		Device { id: 0x1108, name: "mPCIe-ICM485-1 1x Isolated RS485 PCI Express Mini Card" },
		Device { id: 0x1110, name: "mPCIe-ICM422-2 2x Isolated RS422 PCI Express Mini Card" },
		Device { id: 0x1111, name: "mPCIe-ICM485-2 2x Isolated RS485 PCI Express Mini Card" },
		Device { id: 0x1118, name: "mPCIe-ICM422-4 4x Isolated RS422 PCI Express Mini Card" },
		Device { id: 0x1119, name: "mPCIe-ICM485-4 4x Isolated RS485 PCI Express Mini Card" },
		Device { id: 0x1148, name: "PCI-ICM-1S 1x Isolated RS422/RS485 Card" },
		Device { id: 0x1150, name: "PCI-ICM-2S 2x Isolated RS422/RS485 Card" },
		Device { id: 0x1152, name: "PCIe-ICM-2S 2x Isolated RS422/RS485 Card" },
		Device { id: 0x1158, name: "PCI-ICM422/4 4x Isolated RS422 Card" },
		Device { id: 0x1159, name: "PCI-ICM485/4 4x Isolated RS485 Card" },
		Device { id: 0x115A, name: "PCIe-ICM-4S 4x Isolated RS422/RS485 Card" },
		Device { id: 0x1190, name: "PCIe-ICM232-2 2x Isolated RS232 Card" },
		Device { id: 0x1191, name: "mPCIe-ICM232-2 2x Isolated RS232 PCI Express Mini Card" },
		Device { id: 0x1198, name: "PCIe-ICM232-4 4x Isolated RS232 Card" },
		Device { id: 0x1199, name: "mPCIe-ICM232-4 4x Isolated RS422 PCI Express Mini Card" },
		Device { id: 0x11D0, name: "PCIe-ICM-2SM 2x Isolated RS232/RS422/RS485 Card" },
		Device { id: 0x11D8, name: "PCIe-ICM-4SM 4x Isolated RS232/RS422/RS485 Card" },
		Device { id: 0x1250, name: "PCI-WDG-2S Watchdog and 2x Serial Card" },
		Device { id: 0x12D0, name: "PCI-WDG-IMPAC" },
		Device { id: 0x2230, name: "PCI-QUAD-8 8x Quadrature Input Card" },
		Device { id: 0x2231, name: "PCI-QUAD-4 4x Quadrature Input Card" },
		Device { id: 0x22C0, name: "PCI-WDG-CSM Watchdog Card" },
		Device { id: 0x25C0, name: "P104-WDG-E Watchdog PC/104+ Board" },
		Device { id: 0x2C50, name: "PCI-DIO-96CT 96x Digital Input / Output Card" },
		Device { id: 0x2C58, name: "PCI-DIO-96C3 96x Digital Input / Output Card w/3x 8254 Counter Card" },
		Device { id: 0x2EE0, name: "PCIe-DIO24S-CTR12 24x Digital Input / Output Card w/4x 8254 Counter Card" },
		Device { id: 0x2FC0, name: "P104-WDG-CSM Watchdog PC/104+ Board" },
		Device { id: 0x2FC1, name: "P104-WDG-CSMA Advanced Watchdog PC/104+ Board" },
		Device { id: 0x5ED0, name: "PCI-DAC" },
		Device { id: 0x6C90, name: "PCI-DA12-2 2x 12-bit Analog Output Card" },
		Device { id: 0x6C98, name: "PCI-DA12-4 4x 12-bit Analog Output Card" },
		Device { id: 0x6CA0, name: "PCI-DA12-6 6x 12-bit Analog Output Card" },
		Device { id: 0x6CA8, name: "PCI-DA12-8 8x 12-bit Analog Output Card" },
		Device { id: 0x6CA9, name: "PCI-DA12-8V" },
		Device { id: 0x6CB0, name: "PCI-DA12-16 16x 12-bit Analog Output Card" },
		Device { id: 0x6CB1, name: "PCI-DA12-16V" },
		Device { id: 0x8EF0, name: "P104-FAS16-16" },
		Device { id: 0xACA8, name: "PCI-AI12-16 12-bit 100kHz Analog Input Card" },
		Device { id: 0xACA9, name: "PCI-AI12-16A 12-bit 100kHz Analog Input w/FIFO Card" },
		Device { id: 0xECA8, name: "PCI-AIO12-16 12-bit 100kHz Analog Input w/2x Analog Output and FIFO Card" },
		Device { id: 0xECAA, name: "PCI-A12-16A 12-bit 100kHz Analog Input w/2x Analog Output and FIFO Card" },
		Device { id: 0xECE8, name: "LPCI-A16-16A 16-bit 500kHz Analog Input low-profile Card" },
		Device { id: 0xECE9, name: "LPCI-AIO16A 16-bit 500kHz Analog Input low-profile Card" },
	] },
	Vendor { id: 0x4978, name: "Axil Computer Inc", devices: &[
	] },
	Vendor { id: 0x4A14, name: "NetVin", devices: &[
		Device { id: 0x5000, name: "NV5000SC" },
	] },
	Vendor { id: 0x4B10, name: "Buslogic Inc.", devices: &[
	] },
	Vendor { id: 0x4C48, name: "LUNG HWA Electronics", devices: &[
	] },
	Vendor { id: 0x4C53, name: "SBS Technologies", devices: &[
		Device { id: 0x0000, name: "PLUSTEST device" },
		Device { id: 0x0001, name: "PLUSTEST-MM device" },
	] },
	Vendor { id: 0x4CA1, name: "Seanix Technology Inc", devices: &[
	] },
	Vendor { id: 0x4D51, name: "MediaQ Inc.", devices: &[
		Device { id: 0x0200, name: "MQ-200" },
	] },
	Vendor { id: 0x4D54, name: "Microtechnica Co Ltd", devices: &[
	] },
	Vendor { id: 0x4D56, name: "MATRIX VISION GmbH", devices: &[
		Device { id: 0x0000, name: "[mvHYPERION-CLe/CLb] CameraLink PCI Express x1 Frame Grabber" },
		Device { id: 0x0001, name: "[mvHYPERION-CLf/CLm] CameraLink PCI Express x4 Frame Grabber" },
		Device { id: 0x0010, name: "[mvHYPERION-16R16/-32R16] 16 Video Channel PCI Express x4 Frame Grabber" },
		Device { id: 0x0020, name: "[mvHYPERION-HD-SDI] HD-SDI PCI Express x4 Frame Grabber" },
		Device { id: 0x0030, name: "[mvHYPERION-HD-SDI-Merger] HD-SDI PCI Express x4 Frame Grabber" },
	] },
	Vendor { id: 0x4DDC, name: "ILC Data Device Corp", devices: &[
		Device { id: 0x0100, name: "DD-42924I5-300 (ARINC 429 Data Bus)" },
		Device { id: 0x0801, name: "BU-65570I1 MIL-STD-1553 Test and Simulation" },
		Device { id: 0x0802, name: "BU-65570I2 MIL-STD-1553 Test and Simulation" },
		Device { id: 0x0811, name: "BU-65572I1 MIL-STD-1553 Test and Simulation" },
		Device { id: 0x0812, name: "BU-65572I2 MIL-STD-1553 Test and Simulation" },
		Device { id: 0x0881, name: "BU-65570T1 MIL-STD-1553 Test and Simulation" },
		Device { id: 0x0882, name: "BU-65570T2 MIL-STD-1553 Test and Simulation" },
		Device { id: 0x0891, name: "BU-65572T1 MIL-STD-1553 Test and Simulation" },
		Device { id: 0x0892, name: "BU-65572T2 MIL-STD-1553 Test and Simulation" },
		Device { id: 0x0901, name: "BU-65565C1 MIL-STD-1553 Data Bus" },
		Device { id: 0x0902, name: "BU-65565C2 MIL-STD-1553 Data Bus" },
		Device { id: 0x0903, name: "BU-65565C3 MIL-STD-1553 Data Bus" },
		Device { id: 0x0904, name: "BU-65565C4 MIL-STD-1553 Data Bus" },
		Device { id: 0x0B01, name: "BU-65569I1 MIL-STD-1553 Data Bus" },
		Device { id: 0x0B02, name: "BU-65569I2 MIL-STD-1553 Data Bus" },
		Device { id: 0x0B03, name: "BU-65569I3 MIL-STD-1553 Data Bus" },
		Device { id: 0x0B04, name: "BU-65569I4 MIL-STD-1553 Data Bus" },
	] },
	Vendor { id: 0x5045, name: "University of Toronto", devices: &[
		Device { id: 0x4243, name: "BLASTbus PCI Interface Card v1" },
	] },
	Vendor { id: 0x5046, name: "GemTek Technology Corporation", devices: &[
		Device { id: 0x1001, name: "PCI Radio" },
	] },
	Vendor { id: 0x5053, name: "Voyetra Technologies", devices: &[
		Device { id: 0x2010, name: "Daytona Audio Adapter" },
	] },
	Vendor { id: 0x50B2, name: "TerraTec Electronic GmbH", devices: &[
	] },
	Vendor { id: 0x5136, name: "S S Technologies", devices: &[
	] },
	Vendor { id: 0x5143, name: "Qualcomm Inc", devices: &[
	] },
	Vendor { id: 0x5145, name: "Ensoniq (Old)", devices: &[
		Device { id: 0x3031, name: "Concert AudioPCI" },
	] },
	Vendor { id: 0x5168, name: "Animation Technologies Inc.", devices: &[
		Device { id: 0x0300, name: "FlyDVB-S" },
		Device { id: 0x0301, name: "FlyDVB-T" },
	] },
	Vendor { id: 0x5301, name: "Alliance Semiconductor Corp.", devices: &[
		Device { id: 0x0001, name: "ProMotion aT3D" },
	] },
	Vendor { id: 0x5333, name: "S3 Graphics Ltd.", devices: &[
		Device { id: 0x0551, name: "Plato/PX (system)" },
		Device { id: 0x5631, name: "86c325 [ViRGE]" },
		Device { id: 0x8800, name: "86c866 [Vision 866]" },
		Device { id: 0x8801, name: "86c964 [Vision 964]" },
		Device { id: 0x8810, name: "86c764_0 [Trio 32 vers 0]" },
		Device { id: 0x8811, name: "86c764/765 [Trio32/64/64V+]" },
		Device { id: 0x8812, name: "86cM65 [Aurora64V+]" },
		Device { id: 0x8813, name: "86c764_3 [Trio 32/64 vers 3]" },
		Device { id: 0x8814, name: "86c767 [Trio 64UV+]" },
		Device { id: 0x8815, name: "86cM65 [Aurora 128]" },
		Device { id: 0x883D, name: "86c988 [ViRGE/VX]" },
		Device { id: 0x8870, name: "FireGL" },
		Device { id: 0x8880, name: "86c868 [Vision 868 VRAM] vers 0" },
		Device { id: 0x8881, name: "86c868 [Vision 868 VRAM] vers 1" },
		Device { id: 0x8882, name: "86c868 [Vision 868 VRAM] vers 2" },
		Device { id: 0x8883, name: "86c868 [Vision 868 VRAM] vers 3" },
		Device { id: 0x88B0, name: "86c928 [Vision 928 VRAM] vers 0" },
		Device { id: 0x88B1, name: "86c928 [Vision 928 VRAM] vers 1" },
		Device { id: 0x88B2, name: "86c928 [Vision 928 VRAM] vers 2" },
		Device { id: 0x88B3, name: "86c928 [Vision 928 VRAM] vers 3" },
		Device { id: 0x88C0, name: "86c864 [Vision 864 DRAM] vers 0" },
		Device { id: 0x88C1, name: "86c864 [Vision 864 DRAM] vers 1" },
		Device { id: 0x88C2, name: "86c864 [Vision 864-P DRAM] vers 2" },
		Device { id: 0x88C3, name: "86c864 [Vision 864-P DRAM] vers 3" },
		Device { id: 0x88D0, name: "86c964 [Vision 964 VRAM] vers 0" },
		Device { id: 0x88D1, name: "86c964 [Vision 964 VRAM] vers 1" },
		Device { id: 0x88D2, name: "86c964 [Vision 964-P VRAM] vers 2" },
		Device { id: 0x88D3, name: "86c964 [Vision 964-P VRAM] vers 3" },
		Device { id: 0x88F0, name: "86c968 [Vision 968 VRAM] rev 0" },
		Device { id: 0x88F1, name: "86c968 [Vision 968 VRAM] rev 1" },
		Device { id: 0x88F2, name: "86c968 [Vision 968 VRAM] rev 2" },
		Device { id: 0x88F3, name: "86c968 [Vision 968 VRAM] rev 3" },
		Device { id: 0x8900, name: "86c755 [Trio 64V2/DX]" },
		Device { id: 0x8901, name: "86c775/86c785 [Trio 64V2/DX or /GX]" },
		Device { id: 0x8902, name: "Plato/PX" },
		Device { id: 0x8903, name: "Trio 3D business multimedia" },
		Device { id: 0x8904, name: "86c365, 86c366 [Trio 3D]" },
		Device { id: 0x8905, name: "Trio 64V+ family" },
		Device { id: 0x8906, name: "Trio 64V+ family" },
		Device { id: 0x8907, name: "Trio 64V+ family" },
		Device { id: 0x8908, name: "Trio 64V+ family" },
		Device { id: 0x8909, name: "Trio 64V+ family" },
		Device { id: 0x890A, name: "Trio 64V+ family" },
		Device { id: 0x890B, name: "Trio 64V+ family" },
		Device { id: 0x890C, name: "Trio 64V+ family" },
		Device { id: 0x890D, name: "Trio 64V+ family" },
		Device { id: 0x890E, name: "Trio 64V+ family" },
		Device { id: 0x890F, name: "Trio 64V+ family" },
		Device { id: 0x8A01, name: "86c375 [ViRGE/DX] or 86c385 [ViRGE/GX]" },
		Device { id: 0x8A10, name: "ViRGE/GX2" },
		Device { id: 0x8A13, name: "86c360 [Trio 3D/1X], 86c362, 86c368 [Trio 3D/2X]" },
		Device { id: 0x8A20, name: "86c794 [Savage 3D]" },
		Device { id: 0x8A21, name: "86c390 [Savage 3D/MV]" },
		Device { id: 0x8A22, name: "Savage 4" },
		Device { id: 0x8A23, name: "Savage 4" },
		Device { id: 0x8A25, name: "ProSavage PM133" },
		Device { id: 0x8A26, name: "ProSavage KM133" },
		Device { id: 0x8C00, name: "ViRGE/M3" },
		Device { id: 0x8C01, name: "ViRGE/MX" },
		Device { id: 0x8C02, name: "ViRGE/MX+" },
		Device { id: 0x8C03, name: "ViRGE/MX+MV" },
		Device { id: 0x8C10, name: "86C270-294 [SavageMX-MV]" },
		Device { id: 0x8C11, name: "82C270-294 [SavageMX]" },
		Device { id: 0x8C12, name: "86C270-294 [SavageIX-MV]" },
		Device { id: 0x8C13, name: "86C270-294 [SavageIX]" },
		Device { id: 0x8C22, name: "SuperSavage MX/128" },
		Device { id: 0x8C24, name: "SuperSavage MX/64" },
		Device { id: 0x8C26, name: "SuperSavage MX/64C" },
		Device { id: 0x8C2A, name: "SuperSavage IX/128 SDR" },
		Device { id: 0x8C2B, name: "SuperSavage IX/128 DDR" },
		Device { id: 0x8C2C, name: "SuperSavage IX/64 SDR" },
		Device { id: 0x8C2D, name: "SuperSavage IX/64 DDR" },
		Device { id: 0x8C2E, name: "SuperSavage IX/C SDR" },
		Device { id: 0x8C2F, name: "SuperSavage IX/C DDR" },
		Device { id: 0x8D01, name: "86C380 [ProSavageDDR K4M266]" },
		Device { id: 0x8D02, name: "VT8636A [ProSavage KN133] AGP4X VGA Controller (TwisterK)" },
		Device { id: 0x8D03, name: "VT8751 [ProSavageDDR P4M266]" },
		Device { id: 0x8D04, name: "VT8375 [ProSavage8 KM266/KL266]" },
		Device { id: 0x8E00, name: "DeltaChrome" },
		Device { id: 0x8E26, name: "ProSavage" },
		Device { id: 0x8E40, name: "2300E Graphics Processor" },
		Device { id: 0x8E48, name: "Matrix [Chrome S25 / S27]" },
		Device { id: 0x9043, name: "Chrome 430 GT" },
		Device { id: 0x9045, name: "Chrome 430 ULP / 435 ULP / 440 GTX" },
		Device { id: 0x9060, name: "Chrome 530 GT" },
		Device { id: 0x9102, name: "86C410 [Savage 2000]" },
		Device { id: 0xCA00, name: "SonicVibes" },
	] },
	Vendor { id: 0x5431, name: "AuzenTech, Inc.", devices: &[
	] },
	Vendor { id: 0x544C, name: "Teralogic Inc", devices: &[
		Device { id: 0x0350, name: "TL880-based HDTV/ATSC tuner" },
	] },
	Vendor { id: 0x544D, name: "TBS Technologies", devices: &[
		Device { id: 0x6178, name: "DVB-S2 4 Tuner PCIe Card" },
	] },
	Vendor { id: 0x5452, name: "SCANLAB AG", devices: &[
		Device { id: 0x3443, name: "RTC4" },
	] },
	Vendor { id: 0x5455, name: "Technische University Berlin", devices: &[
		Device { id: 0x4458, name: "S5933" },
	] },
	Vendor { id: 0x5456, name: "GoTView", devices: &[
	] },
	Vendor { id: 0x5519, name: "Cnet Technologies, Inc.", devices: &[
	] },
	Vendor { id: 0x5544, name: "Dunord Technologies", devices: &[
		Device { id: 0x0001, name: "I-30xx Scanner Interface" },
	] },
	Vendor { id: 0x5555, name: "Genroco, Inc", devices: &[
		Device { id: 0x0003, name: "TURBOstor HFP-832 [HiPPI NIC]" },
		Device { id: 0x3B00, name: "Epiphan DVI2PCIe video capture card" },
	] },
	Vendor { id: 0x5646, name: "Vector Fabrics BV", devices: &[
	] },
	Vendor { id: 0x5654, name: "VoiceTronix Pty Ltd", devices: &[
	] },
	Vendor { id: 0x5678, name: "Dawicontrol Computersysteme GmbH", devices: &[
	] },
	Vendor { id: 0x5700, name: "Netpower", devices: &[
	] },
	Vendor { id: 0x5845, name: "X-ES, Inc.", devices: &[
	] },
	Vendor { id: 0x584D, name: "AuzenTech Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x5851, name: "Exacq Technologies", devices: &[
		Device { id: 0x8008, name: "tDVR8008 8-port video capture card" },
		Device { id: 0x8016, name: "tDVR8016 16-chan video capture card" },
		Device { id: 0x8032, name: "tDVR8032 32-chan video capture card" },
	] },
	Vendor { id: 0x5853, name: "XenSource, Inc.", devices: &[
		Device { id: 0x0001, name: "Xen Platform Device" },
		Device { id: 0xC000, name: "Citrix XenServer PCI Device for Windows Update" },
		Device { id: 0xC110, name: "Virtualized HID" },
		Device { id: 0xC147, name: "Virtualized Graphics Device" },
	] },
	Vendor { id: 0x5854, name: "GoTView", devices: &[
	] },
	Vendor { id: 0x5ACE, name: "Beholder International Ltd.", devices: &[
	] },
	Vendor { id: 0x6205, name: "TBS Technologies (wrong ID)", devices: &[
	] },
	Vendor { id: 0x6209, name: "TBS Technologies (wrong ID)", devices: &[
	] },
	Vendor { id: 0x631C, name: "SmartInfra Ltd", devices: &[
		Device { id: 0x1652, name: "PXI-1652 Signal Generator" },
		Device { id: 0x2504, name: "PXI-2504 Signal Interrogator" },
	] },
	Vendor { id: 0x6356, name: "UltraStor", devices: &[
	] },
	Vendor { id: 0x6374, name: "c't Magazin fuer Computertechnik", devices: &[
		Device { id: 0x6773, name: "GPPCI" },
	] },
	Vendor { id: 0x6409, name: "Logitec Corp.", devices: &[
	] },
	Vendor { id: 0x6549, name: "Teradici Corp.", devices: &[
		Device { id: 0x1200, name: "TERA1200 PC-over-IP Host" },
	] },
	Vendor { id: 0x6666, name: "Decision Computer International Co.", devices: &[
		Device { id: 0x0001, name: "PCCOM4" },
		Device { id: 0x0002, name: "PCCOM8" },
		Device { id: 0x0004, name: "PCCOM2" },
		Device { id: 0x0101, name: "PCI 8255/8254 I/O Card" },
		Device { id: 0x0200, name: "12-bit AD/DA Card" },
		Device { id: 0x0201, name: "14-bit AD/DA Card" },
		Device { id: 0x1011, name: "Industrial Card" },
		Device { id: 0x1021, name: "8 photo couple 8 relay Card" },
		Device { id: 0x1022, name: "4 photo couple 4 relay Card" },
		Device { id: 0x1025, name: "16 photo couple 16 relay Card" },
		Device { id: 0x4000, name: "WatchDog Card" },
	] },
	Vendor { id: 0x6688, name: "Zycoo Co., Ltd", devices: &[
		Device { id: 0x1200, name: "CooVox TDM Analog Module" },
		Device { id: 0x1400, name: "CooVOX TDM GSM Module" },
		Device { id: 0x1600, name: "CooVOX TDM E1/T1 Module" },
		Device { id: 0x1800, name: "CooVOX TDM BRI Module" },
	] },
	Vendor { id: 0x6900, name: "Red Hat, Inc.", devices: &[
	] },
	Vendor { id: 0x7063, name: "pcHDTV", devices: &[
		Device { id: 0x2000, name: "HD-2000" },
		Device { id: 0x3000, name: "HD-3000" },
		Device { id: 0x5500, name: "HD5500 HDTV" },
	] },
	Vendor { id: 0x7284, name: "HT OMEGA Inc.", devices: &[
	] },
	Vendor { id: 0x7401, name: "EndRun Technologies", devices: &[
		Device { id: 0xE100, name: "PTP3100 PCIe PTP Slave Clock" },
	] },
	Vendor { id: 0x7470, name: "TP-LINK Technologies Co., Ltd.", devices: &[
	] },
	Vendor { id: 0x7604, name: "O.N. Electronic Co Ltd.", devices: &[
	] },
	Vendor { id: 0x7BDE, name: "MIDAC Corporation", devices: &[
	] },
	Vendor { id: 0x7FED, name: "PowerTV", devices: &[
	] },
	Vendor { id: 0x8008, name: "Quancom Electronic GmbH", devices: &[
		Device { id: 0x0010, name: "WDOG1 [PCI-Watchdog 1]" },
		Device { id: 0x0011, name: "PWDOG2 [PCI-Watchdog 2]" },
		Device { id: 0x0015, name: "Clock77/PCI & Clock77/PCIe (DCF-77 receiver)" },
	] },
	Vendor { id: 0x807D, name: "Asustek Computer, Inc.", devices: &[
	] },
	Vendor { id: 0x8086, name: "Intel Corporation", devices: &[
		Device { id: 0x0007, name: "82379AB" },
		Device { id: 0x0008, name: "Extended Express System Support Controller" },
		Device { id: 0x0039, name: "21145 Fast Ethernet" },
		Device { id: 0x0040, name: "Core Processor DRAM Controller" },
		Device { id: 0x0041, name: "Core Processor PCI Express x16 Root Port" },
		Device { id: 0x0042, name: "Core Processor Integrated Graphics Controller" },
		Device { id: 0x0043, name: "Core Processor Secondary PCI Express Root Port" },
		Device { id: 0x0044, name: "Core Processor DRAM Controller" },
		Device { id: 0x0045, name: "Core Processor PCI Express x16 Root Port" },
		Device { id: 0x0046, name: "Core Processor Integrated Graphics Controller" },
		Device { id: 0x0047, name: "Core Processor Secondary PCI Express Root Port" },
		Device { id: 0x0048, name: "Core Processor DRAM Controller" },
		Device { id: 0x0049, name: "Core Processor PCI Express x16 Root Port" },
		Device { id: 0x004A, name: "Core Processor Integrated Graphics Controller" },
		Device { id: 0x004B, name: "Core Processor Secondary PCI Express Root Port" },
		Device { id: 0x0050, name: "Core Processor Thermal Management Controller" },
		Device { id: 0x0069, name: "Core Processor DRAM Controller" },
		Device { id: 0x0082, name: "Centrino Advanced-N 6205 [Taylor Peak]" },
		Device { id: 0x0083, name: "Centrino Wireless-N 1000 [Condor Peak]" },
		Device { id: 0x0084, name: "Centrino Wireless-N 1000 [Condor Peak]" },
		Device { id: 0x0085, name: "Centrino Advanced-N 6205 [Taylor Peak]" },
		Device { id: 0x0087, name: "Centrino Advanced-N + WiMAX 6250 [Kilmer Peak]" },
		Device { id: 0x0089, name: "Centrino Advanced-N + WiMAX 6250 [Kilmer Peak]" },
		Device { id: 0x008A, name: "Centrino Wireless-N 1030 [Rainbow Peak]" },
		Device { id: 0x008B, name: "Centrino Wireless-N 1030 [Rainbow Peak]" },
		Device { id: 0x0090, name: "Centrino Advanced-N 6230 [Rainbow Peak]" },
		Device { id: 0x0091, name: "Centrino Advanced-N 6230 [Rainbow Peak]" },
		Device { id: 0x0100, name: "2nd Generation Core Processor Family DRAM Controller" },
		Device { id: 0x0101, name: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port" },
		Device { id: 0x0102, name: "2nd Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x0104, name: "2nd Generation Core Processor Family DRAM Controller" },
		Device { id: 0x0105, name: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port" },
		Device { id: 0x0106, name: "2nd Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x0108, name: "Xeon E3-1200 Processor Family DRAM Controller" },
		Device { id: 0x0109, name: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port" },
		Device { id: 0x010A, name: "Xeon E3-1200 Processor Family Integrated Graphics Controller" },
		Device { id: 0x010B, name: "Xeon E3-1200/2nd Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x010C, name: "Xeon E3-1200/2nd Generation Core Processor Family DRAM Controller" },
		Device { id: 0x010D, name: "Xeon E3-1200/2nd Generation Core Processor Family PCI Express Root Port" },
		Device { id: 0x010E, name: "Xeon E3-1200/2nd Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x0112, name: "2nd Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x0116, name: "2nd Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x0122, name: "2nd Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x0126, name: "2nd Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x0150, name: "Xeon E3-1200 v2/3rd Gen Core processor DRAM Controller" },
		Device { id: 0x0151, name: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port" },
		Device { id: 0x0152, name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller" },
		Device { id: 0x0153, name: "3rd Gen Core Processor Thermal Subsystem" },
		Device { id: 0x0154, name: "3rd Gen Core processor DRAM Controller" },
		Device { id: 0x0155, name: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port" },
		Device { id: 0x0156, name: "3rd Gen Core processor Graphics Controller" },
		Device { id: 0x0158, name: "Xeon E3-1200 v2/Ivy Bridge DRAM Controller" },
		Device { id: 0x0159, name: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port" },
		Device { id: 0x015A, name: "Xeon E3-1200 v2/Ivy Bridge Graphics Controller" },
		Device { id: 0x015C, name: "Xeon E3-1200 v2/3rd Gen Core processor DRAM Controller" },
		Device { id: 0x015D, name: "Xeon E3-1200 v2/3rd Gen Core processor PCI Express Root Port" },
		Device { id: 0x015E, name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller" },
		Device { id: 0x0162, name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller" },
		Device { id: 0x0166, name: "3rd Gen Core processor Graphics Controller" },
		Device { id: 0x016A, name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller" },
		Device { id: 0x0172, name: "Xeon E3-1200 v2/3rd Gen Core processor Graphics Controller" },
		Device { id: 0x0176, name: "3rd Gen Core processor Graphics Controller" },
		Device { id: 0x0309, name: "80303 I/O Processor PCI-to-PCI Bridge" },
		Device { id: 0x030D, name: "80312 I/O Companion Chip PCI-to-PCI Bridge" },
		Device { id: 0x0326, name: "6700/6702PXH I/OxAPIC Interrupt Controller A" },
		Device { id: 0x0327, name: "6700PXH I/OxAPIC Interrupt Controller B" },
		Device { id: 0x0329, name: "6700PXH PCI Express-to-PCI Bridge A" },
		Device { id: 0x032A, name: "6700PXH PCI Express-to-PCI Bridge B" },
		Device { id: 0x032C, name: "6702PXH PCI Express-to-PCI Bridge A" },
		Device { id: 0x0330, name: "80332 [Dobson] I/O processor (A-Segment Bridge)" },
		Device { id: 0x0331, name: "80332 [Dobson] I/O processor (A-Segment IOAPIC)" },
		Device { id: 0x0332, name: "80332 [Dobson] I/O processor (B-Segment Bridge)" },
		Device { id: 0x0333, name: "80332 [Dobson] I/O processor (B-Segment IOAPIC)" },
		Device { id: 0x0334, name: "80332 [Dobson] I/O processor (ATU)" },
		Device { id: 0x0335, name: "80331 [Lindsay] I/O processor (PCI-X Bridge)" },
		Device { id: 0x0336, name: "80331 [Lindsay] I/O processor (ATU)" },
		Device { id: 0x0340, name: "41210 [Lanai] Serial to Parallel PCI Bridge (A-Segment Bridge)" },
		Device { id: 0x0341, name: "41210 [Lanai] Serial to Parallel PCI Bridge (B-Segment Bridge)" },
		Device { id: 0x0370, name: "80333 Segment-A PCIe Express to PCI-X bridge" },
		Device { id: 0x0371, name: "80333 A-Bus IOAPIC" },
		Device { id: 0x0372, name: "80333 Segment-B PCIe Express to PCI-X bridge" },
		Device { id: 0x0373, name: "80333 B-Bus IOAPIC" },
		Device { id: 0x0374, name: "80333 Address Translation Unit" },
		Device { id: 0x0402, name: "Xeon E3-1200 v3/4th Gen Core Processor Integrated Graphics Controller" },
		Device { id: 0x0406, name: "4th Gen Core Processor Integrated Graphics Controller" },
		Device { id: 0x040A, name: "Xeon E3-1200 v3 Processor Integrated Graphics Controller" },
		Device { id: 0x0412, name: "Xeon E3-1200 v3/4th Gen Core Processor Integrated Graphics Controller" },
		Device { id: 0x0416, name: "4th Gen Core Processor Integrated Graphics Controller" },
		Device { id: 0x041A, name: "Xeon E3-1200 v3 Processor Integrated Graphics Controller" },
		Device { id: 0x041E, name: "4th Generation Core Processor Family Integrated Graphics Controller" },
		Device { id: 0x0434, name: "DH89XXCC Series QAT" },
		Device { id: 0x0435, name: "DH895XCC Series QAT" },
		Device { id: 0x0436, name: "DH8900CC Null Device" },
		Device { id: 0x0438, name: "DH8900CC Series Gigabit Network Connection" },
		Device { id: 0x043A, name: "DH8900CC Series Gigabit Fiber Network Connection" },
		Device { id: 0x043C, name: "DH8900CC Series Gigabit Backplane Network Connection" },
		Device { id: 0x0440, name: "DH8900CC Series Gigabit SFP Network Connection" },
		Device { id: 0x0442, name: "DH89XXCC Series QAT Virtual Function" },
		Device { id: 0x0443, name: "DH895XCC Series QAT Virtual Function" },
		Device { id: 0x0482, name: "82375EB/SB PCI to EISA Bridge" },
		Device { id: 0x0483, name: "82424TX/ZX [Saturn] CPU to PCI bridge" },
		Device { id: 0x0484, name: "82378ZB/IB, 82379AB (SIO, SIO.A) PCI to ISA Bridge" },
		Device { id: 0x0486, name: "82425EX/ZX [Aries] PCIset with ISA bridge" },
		Device { id: 0x04A3, name: "82434LX/NX [Mercury/Neptune] Processor to PCI bridge" },
		Device { id: 0x04D0, name: "82437FX [Triton FX]" },
		Device { id: 0x0500, name: "E8870 Processor bus control" },
		Device { id: 0x0501, name: "E8870 Memory controller" },
		Device { id: 0x0502, name: "E8870 Scalability Port 0" },
		Device { id: 0x0503, name: "E8870 Scalability Port 1" },
		Device { id: 0x0510, name: "E8870IO Hub Interface Port 0 registers (8-bit compatibility port)" },
		Device { id: 0x0511, name: "E8870IO Hub Interface Port 1 registers" },
		Device { id: 0x0512, name: "E8870IO Hub Interface Port 2 registers" },
		Device { id: 0x0513, name: "E8870IO Hub Interface Port 3 registers" },
		Device { id: 0x0514, name: "E8870IO Hub Interface Port 4 registers" },
		Device { id: 0x0515, name: "E8870IO General SIOH registers" },
		Device { id: 0x0516, name: "E8870IO RAS registers" },
		Device { id: 0x0530, name: "E8870SP Scalability Port 0 registers" },
		Device { id: 0x0531, name: "E8870SP Scalability Port 1 registers" },
		Device { id: 0x0532, name: "E8870SP Scalability Port 2 registers" },
		Device { id: 0x0533, name: "E8870SP Scalability Port 3 registers" },
		Device { id: 0x0534, name: "E8870SP Scalability Port 4 registers" },
		Device { id: 0x0535, name: "E8870SP Scalability Port 5 registers" },
		Device { id: 0x0536, name: "E8870SP Interleave registers 0 and 1" },
		Device { id: 0x0537, name: "E8870SP Interleave registers 2 and 3" },
		Device { id: 0x0600, name: "RAID Controller" },
		Device { id: 0x061F, name: "80303 I/O Processor" },
		Device { id: 0x0700, name: "CE Media Processor A/V Bridge" },
		Device { id: 0x0701, name: "CE Media Processor NAND Flash Controller" },
		Device { id: 0x0703, name: "CE Media Processor Media Control Unit 1" },
		Device { id: 0x0704, name: "CE Media Processor Video Capture Interface" },
		Device { id: 0x0707, name: "CE Media Processor SPI Slave" },
		Device { id: 0x0708, name: "CE Media Processor 4100" },
		Device { id: 0x0800, name: "Moorestown SPI Ctrl 0" },
		Device { id: 0x0801, name: "Moorestown SPI Ctrl 1" },
		Device { id: 0x0802, name: "Moorestown I2C 0" },
		Device { id: 0x0803, name: "Moorestown I2C 1" },
		Device { id: 0x0804, name: "Moorestown I2C 2" },
		Device { id: 0x0805, name: "Moorestown Keyboard Ctrl" },
		Device { id: 0x0806, name: "Moorestown USB Ctrl" },
		Device { id: 0x0807, name: "Moorestown SD Host Ctrl 0" },
		Device { id: 0x0808, name: "Moorestown SD Host Ctrl 1" },
		Device { id: 0x0809, name: "Moorestown NAND Ctrl" },
		Device { id: 0x080A, name: "Moorestown Audio Ctrl" },
		Device { id: 0x080B, name: "Moorestown ISP" },
		Device { id: 0x080C, name: "Moorestown Security Controller" },
		Device { id: 0x080D, name: "Moorestown External Displays" },
		Device { id: 0x080E, name: "Moorestown SCU IPC" },
		Device { id: 0x080F, name: "Moorestown GPIO Controller" },
		Device { id: 0x0810, name: "Moorestown Power Management Unit" },
		Device { id: 0x0811, name: "Moorestown OTG Ctrl" },
		Device { id: 0x0812, name: "Moorestown SPI Ctrl 2" },
		Device { id: 0x0813, name: "Moorestown SC DMA" },
		Device { id: 0x0814, name: "Moorestown LPE DMA" },
		Device { id: 0x0815, name: "Moorestown SSP0" },
		Device { id: 0x0817, name: "Medfield Serial IO I2C Controller #3" },
		Device { id: 0x0818, name: "Medfield Serial IO I2C Controller #4" },
		Device { id: 0x0819, name: "Medfield Serial IO I2C Controller #5" },
		Device { id: 0x081A, name: "Medfield GPIO Controller [Core]" },
		Device { id: 0x081B, name: "Medfield Serial IO HSUART Controller #1" },
		Device { id: 0x081C, name: "Medfield Serial IO HSUART Controller #2" },
		Device { id: 0x081D, name: "Medfield Serial IO HSUART Controller #3" },
		Device { id: 0x081E, name: "Medfield Serial IO HSUART DMA Controller" },
		Device { id: 0x081F, name: "Medfield GPIO Controller [AON]" },
		Device { id: 0x0820, name: "Medfield SD Host Controller" },
		Device { id: 0x0821, name: "Medfield SDIO Controller #1" },
		Device { id: 0x0822, name: "Medfield SDIO Controller #2" },
		Device { id: 0x0823, name: "Medfield eMMC Controller #0" },
		Device { id: 0x0824, name: "Medfield eMMC Controller #1" },
		Device { id: 0x0827, name: "Medfield Serial IO DMA Controller" },
		Device { id: 0x0828, name: "Medfield Power Management Unit" },
		Device { id: 0x0829, name: "Medfield USB Device Controller (OTG)" },
		Device { id: 0x082A, name: "Medfield SCU IPC" },
		Device { id: 0x082C, name: "Medfield Serial IO I2C Controller #0" },
		Device { id: 0x082D, name: "Medfield Serial IO I2C Controller #1" },
		Device { id: 0x082E, name: "Medfield Serial IO I2C Controller #2" },
		Device { id: 0x0885, name: "Centrino Wireless-N + WiMAX 6150" },
		Device { id: 0x0886, name: "Centrino Wireless-N + WiMAX 6150" },
		Device { id: 0x0887, name: "Centrino Wireless-N 2230" },
		Device { id: 0x0888, name: "Centrino Wireless-N 2230" },
		Device { id: 0x088E, name: "Centrino Advanced-N 6235" },
		Device { id: 0x088F, name: "Centrino Advanced-N 6235" },
		Device { id: 0x0890, name: "Centrino Wireless-N 2200" },
		Device { id: 0x0891, name: "Centrino Wireless-N 2200" },
		Device { id: 0x0892, name: "Centrino Wireless-N 135" },
		Device { id: 0x0893, name: "Centrino Wireless-N 135" },
		Device { id: 0x0894, name: "Centrino Wireless-N 105" },
		Device { id: 0x0895, name: "Centrino Wireless-N 105" },
		Device { id: 0x0896, name: "Centrino Wireless-N 130" },
		Device { id: 0x0897, name: "Centrino Wireless-N 130" },
		Device { id: 0x08A7, name: "Quark SoC X1000 SDIO / eMMC Controller" },
		Device { id: 0x08AE, name: "Centrino Wireless-N 100" },
		Device { id: 0x08AF, name: "Centrino Wireless-N 100" },
		Device { id: 0x08B1, name: "Wireless 7260" },
		Device { id: 0x08B2, name: "Wireless 7260" },
		Device { id: 0x08B3, name: "Wireless 3160" },
		Device { id: 0x08B4, name: "Wireless 3160" },
		Device { id: 0x08CF, name: "Atom Processor Z2760 Integrated Graphics Controller" },
		Device { id: 0x0934, name: "Quark SoC X1000 I2C Controller and GPIO Controller" },
		Device { id: 0x0935, name: "Quark SoC X1000 SPI Controller" },
		Device { id: 0x0936, name: "Quark SoC X1000 HS-UART" },
		Device { id: 0x0937, name: "Quark SoC X1000 10/100 Ethernet MAC" },
		Device { id: 0x0939, name: "Quark SoC X1000 USB EHCI Host Controller / USB 2.0 Device" },
		Device { id: 0x093A, name: "Quark SoC X1000 USB OHCI Host Controller" },
		Device { id: 0x0953, name: "PCIe Data Center SSD" },
		Device { id: 0x0958, name: "Quark SoC X1000 Host Bridge" },
		Device { id: 0x095A, name: "Wireless 7265" },
		Device { id: 0x095B, name: "Wireless 7265" },
		Device { id: 0x095E, name: "Quark SoC X1000 Legacy Bridge" },
		Device { id: 0x0960, name: "80960RP (i960RP) Microprocessor/Bridge" },
		Device { id: 0x0962, name: "80960RM (i960RM) Bridge" },
		Device { id: 0x0964, name: "80960RP (i960RP) Microprocessor/Bridge" },
		Device { id: 0x0A03, name: "Haswell-ULT Thermal Subsystem" },
		Device { id: 0x0A04, name: "Haswell-ULT DRAM Controller" },
		Device { id: 0x0A06, name: "Haswell-ULT Integrated Graphics Controller" },
		Device { id: 0x0A0C, name: "Haswell-ULT HD Audio Controller" },
		Device { id: 0x0A16, name: "Haswell-ULT Integrated Graphics Controller" },
		Device { id: 0x0A22, name: "Haswell-ULT Integrated Graphics Controller" },
		Device { id: 0x0A26, name: "Haswell-ULT Integrated Graphics Controller" },
		Device { id: 0x0A2A, name: "Haswell-ULT Integrated Graphics Controller" },
		Device { id: 0x0A2E, name: "Haswell-ULT Integrated Graphics Controller" },
		Device { id: 0x0A53, name: "DC P3520 SSD" },
		Device { id: 0x0A54, name: "Express Flash NVMe P4500" },
		Device { id: 0x0A55, name: "Express Flash NVMe P4600" },
		Device { id: 0x0BE0, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE1, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE2, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE3, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE4, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE5, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE6, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE7, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE8, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BE9, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BEA, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BEB, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BEC, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BED, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BEE, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BEF, name: "Atom Processor D2xxx/N2xxx Integrated Graphics Controller" },
		Device { id: 0x0BF0, name: "Atom Processor D2xxx/N2xxx DRAM Controller" },
		Device { id: 0x0BF1, name: "Atom Processor D2xxx/N2xxx DRAM Controller" },
		Device { id: 0x0BF2, name: "Atom Processor D2xxx/N2xxx DRAM Controller" },
		Device { id: 0x0BF3, name: "Atom Processor D2xxx/N2xxx DRAM Controller" },
		Device { id: 0x0BF4, name: "Atom Processor D2xxx/N2xxx DRAM Controller" },
		Device { id: 0x0BF5, name: "Atom Processor D2xxx/N2xxx DRAM Controller" },
		Device { id: 0x0BF6, name: "Atom Processor D2xxx/N2xxx DRAM Controller" },
		Device { id: 0x0BF7, name: "Atom Processor D2xxx/N2xxx DRAM Controller" },
		Device { id: 0x0C00, name: "4th Gen Core Processor DRAM Controller" },
		Device { id: 0x0C01, name: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x16 Controller" },
		Device { id: 0x0C04, name: "Xeon E3-1200 v3/4th Gen Core Processor DRAM Controller" },
		Device { id: 0x0C05, name: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x8 Controller" },
		Device { id: 0x0C08, name: "Xeon E3-1200 v3 Processor DRAM Controller" },
		Device { id: 0x0C09, name: "Xeon E3-1200 v3/4th Gen Core Processor PCI Express x4 Controller" },
		Device { id: 0x0C0C, name: "Xeon E3-1200 v3/4th Gen Core Processor HD Audio Controller" },
		Device { id: 0x0C46, name: "Atom Processor S1200 PCI Express Root Port 1" },
		Device { id: 0x0C47, name: "Atom Processor S1200 PCI Express Root Port 2" },
		Device { id: 0x0C48, name: "Atom Processor S1200 PCI Express Root Port 3" },
		Device { id: 0x0C49, name: "Atom Processor S1200 PCI Express Root Port 4" },
		Device { id: 0x0C4E, name: "Atom Processor S1200 NTB Primary" },
		Device { id: 0x0C50, name: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device" },
		Device { id: 0x0C51, name: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device" },
		Device { id: 0x0C52, name: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device" },
		Device { id: 0x0C53, name: "Xeon E7 v4/Xeon E5 v4/Xeon E3 v4/Xeon D QuickData Technology Device" },
		Device { id: 0x0C54, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C55, name: "Atom Processor S1200 DFX 1" },
		Device { id: 0x0C56, name: "Atom Processor S1200 DFX 2" },
		Device { id: 0x0C59, name: "Atom Processor S1200 SMBus 2.0 Controller 0" },
		Device { id: 0x0C5A, name: "Atom Processor S1200 SMBus 2.0 Controller 1" },
		Device { id: 0x0C5B, name: "Atom Processor S1200 SMBus Controller 2" },
		Device { id: 0x0C5C, name: "Atom Processor S1200 SMBus Controller 3" },
		Device { id: 0x0C5D, name: "Atom Processor S1200 SMBus Controller 4" },
		Device { id: 0x0C5E, name: "Atom Processor S1200 SMBus Controller 5" },
		Device { id: 0x0C5F, name: "Atom Processor S1200 UART" },
		Device { id: 0x0C60, name: "Atom Processor S1200 Integrated Legacy Bus" },
		Device { id: 0x0C70, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C71, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C72, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C73, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C74, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C75, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C76, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C77, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C78, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C79, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C7A, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C7B, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C7C, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C7D, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C7E, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0C7F, name: "Atom Processor S1200 Internal" },
		Device { id: 0x0D00, name: "Crystal Well DRAM Controller" },
		Device { id: 0x0D01, name: "Crystal Well PCI Express x16 Controller" },
		Device { id: 0x0D04, name: "Crystal Well DRAM Controller" },
		Device { id: 0x0D05, name: "Crystal Well PCI Express x8 Controller" },
		Device { id: 0x0D09, name: "Crystal Well PCI Express x4 Controller" },
		Device { id: 0x0D0C, name: "Crystal Well HD Audio Controller" },
		Device { id: 0x0D16, name: "Crystal Well Integrated Graphics Controller" },
		Device { id: 0x0D26, name: "Crystal Well Integrated Graphics Controller" },
		Device { id: 0x0D36, name: "Crystal Well Integrated Graphics Controller" },
		Device { id: 0x0E00, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DMI2" },
		Device { id: 0x0E01, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port in DMI2 Mode" },
		Device { id: 0x0E02, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 1a" },
		Device { id: 0x0E03, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 1b" },
		Device { id: 0x0E04, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2a" },
		Device { id: 0x0E05, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2b" },
		Device { id: 0x0E06, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2c" },
		Device { id: 0x0E07, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 2d" },
		Device { id: 0x0E08, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3a" },
		Device { id: 0x0E09, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3b" },
		Device { id: 0x0E0A, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3c" },
		Device { id: 0x0E0B, name: "Xeon E7 v2/Xeon E5 v2/Core i7 PCI Express Root Port 3d" },
		Device { id: 0x0E10, name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers" },
		Device { id: 0x0E13, name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers" },
		Device { id: 0x0E17, name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers" },
		Device { id: 0x0E18, name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers" },
		Device { id: 0x0E1C, name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO Configuration Registers" },
		Device { id: 0x0E1D, name: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe" },
		Device { id: 0x0E1E, name: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers" },
		Device { id: 0x0E1F, name: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers" },
		Device { id: 0x0E20, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 0" },
		Device { id: 0x0E21, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 1" },
		Device { id: 0x0E22, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 2" },
		Device { id: 0x0E23, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 3" },
		Device { id: 0x0E24, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 4" },
		Device { id: 0x0E25, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 5" },
		Device { id: 0x0E26, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 6" },
		Device { id: 0x0E27, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Crystal Beach DMA Channel 7" },
		Device { id: 0x0E28, name: "Xeon E7 v2/Xeon E5 v2/Core i7 VTd/Memory Map/Misc" },
		Device { id: 0x0E29, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Memory Hotplug" },
		Device { id: 0x0E2A, name: "Xeon E7 v2/Xeon E5 v2/Core i7 IIO RAS" },
		Device { id: 0x0E2C, name: "Xeon E7 v2/Xeon E5 v2/Core i7 IOAPIC" },
		Device { id: 0x0E2E, name: "Xeon E7 v2/Xeon E5 v2/Core i7 CBDMA" },
		Device { id: 0x0E2F, name: "Xeon E7 v2/Xeon E5 v2/Core i7 CBDMA" },
		Device { id: 0x0E30, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 0" },
		Device { id: 0x0E32, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 0" },
		Device { id: 0x0E33, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1" },
		Device { id: 0x0E34, name: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe" },
		Device { id: 0x0E36, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring" },
		Device { id: 0x0E37, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring" },
		Device { id: 0x0E38, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 1" },
		Device { id: 0x0E3A, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 2" },
		Device { id: 0x0E3E, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring" },
		Device { id: 0x0E3F, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Performance Ring Monitoring" },
		Device { id: 0x0E40, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 2" },
		Device { id: 0x0E41, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers" },
		Device { id: 0x0E43, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 2" },
		Device { id: 0x0E44, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 2" },
		Device { id: 0x0E45, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register" },
		Device { id: 0x0E47, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register" },
		Device { id: 0x0E60, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 1" },
		Device { id: 0x0E68, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Target Address/Thermal Registers" },
		Device { id: 0x0E6A, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers" },
		Device { id: 0x0E6B, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers" },
		Device { id: 0x0E6C, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers" },
		Device { id: 0x0E6D, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder Registers" },
		Device { id: 0x0E71, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 RAS Registers" },
		Device { id: 0x0E74, name: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe" },
		Device { id: 0x0E75, name: "Xeon E7 v2/Xeon E5 v2/Core i7 R2PCIe" },
		Device { id: 0x0E77, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers" },
		Device { id: 0x0E79, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 RAS Registers" },
		Device { id: 0x0E7D, name: "Xeon E7 v2/Xeon E5 v2/Core i7 UBOX Registers" },
		Device { id: 0x0E7F, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers" },
		Device { id: 0x0E80, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 0" },
		Device { id: 0x0E81, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Ring Registers" },
		Device { id: 0x0E83, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 0" },
		Device { id: 0x0E84, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 0" },
		Device { id: 0x0E85, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register" },
		Device { id: 0x0E87, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Registers" },
		Device { id: 0x0E90, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1" },
		Device { id: 0x0E93, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link 1" },
		Device { id: 0x0E94, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Reut 1" },
		Device { id: 0x0E95, name: "Xeon E7 v2/Xeon E5 v2/Core i7 QPI Link Agent Register" },
		Device { id: 0x0EA0, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Home Agent 0" },
		Device { id: 0x0EA8, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Target Address/Thermal Registers" },
		Device { id: 0x0EAA, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers" },
		Device { id: 0x0EAB, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers" },
		Device { id: 0x0EAC, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers" },
		Device { id: 0x0EAD, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder Registers" },
		Device { id: 0x0EAE, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers" },
		Device { id: 0x0EAF, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers" },
		Device { id: 0x0EB0, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 0" },
		Device { id: 0x0EB1, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 1" },
		Device { id: 0x0EB2, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 0" },
		Device { id: 0x0EB3, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 1" },
		Device { id: 0x0EB4, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 2" },
		Device { id: 0x0EB5, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 Thermal Control 3" },
		Device { id: 0x0EB6, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 2" },
		Device { id: 0x0EB7, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 1 Channel 0-3 ERROR Registers 3" },
		Device { id: 0x0EBC, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers" },
		Device { id: 0x0EBE, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers" },
		Device { id: 0x0EBF, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO Registers" },
		Device { id: 0x0EC0, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 0" },
		Device { id: 0x0EC1, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 1" },
		Device { id: 0x0EC2, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 2" },
		Device { id: 0x0EC3, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 3" },
		Device { id: 0x0EC4, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Power Control Unit 4" },
		Device { id: 0x0EC8, name: "Xeon E7 v2/Xeon E5 v2/Core i7 System Address Decoder" },
		Device { id: 0x0EC9, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Broadcast Registers" },
		Device { id: 0x0ECA, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Broadcast Registers" },
		Device { id: 0x0ED8, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0ED9, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EDC, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EDD, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EDE, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EDF, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EE0, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE1, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE2, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE3, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE4, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE5, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE6, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE7, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE8, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EE9, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EEA, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EEB, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EEC, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EED, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EEE, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Unicast Registers" },
		Device { id: 0x0EF0, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 0" },
		Device { id: 0x0EF1, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 1" },
		Device { id: 0x0EF2, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 0" },
		Device { id: 0x0EF3, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 1" },
		Device { id: 0x0EF4, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 2" },
		Device { id: 0x0EF5, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 Thermal Control 3" },
		Device { id: 0x0EF6, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 2" },
		Device { id: 0x0EF7, name: "Xeon E7 v2/Xeon E5 v2/Core i7 Integrated Memory Controller 0 Channel 0-3 ERROR Registers 3" },
		Device { id: 0x0EF8, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EF9, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EFA, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EFB, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EFC, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0EFD, name: "Xeon E7 v2/Xeon E5 v2/Core i7 DDRIO" },
		Device { id: 0x0F00, name: "Atom Processor Z36xxx/Z37xxx Series SoC Transaction Register" },
		Device { id: 0x0F04, name: "Atom Processor Z36xxx/Z37xxx Series High Definition Audio Controller" },
		Device { id: 0x0F06, name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 DMA Controller" },
		Device { id: 0x0F08, name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 PWM Controller" },
		Device { id: 0x0F09, name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 PWM Controller" },
		Device { id: 0x0F0A, name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 HSUART Controller #1" },
		Device { id: 0x0F0C, name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 HSUART Controller #2" },
		Device { id: 0x0F0E, name: "Atom Processor Z36xxx/Z37xxx Series LPIO1 SPI Controller" },
		Device { id: 0x0F12, name: "Atom Processor E3800 Series SMBus Controller" },
		Device { id: 0x0F14, name: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller" },
		Device { id: 0x0F15, name: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller" },
		Device { id: 0x0F16, name: "Atom Processor Z36xxx/Z37xxx Series SDIO Controller" },
		Device { id: 0x0F18, name: "Atom Processor Z36xxx/Z37xxx Series Trusted Execution Engine" },
		Device { id: 0x0F1C, name: "Atom Processor Z36xxx/Z37xxx Series Power Control Unit" },
		Device { id: 0x0F20, name: "Atom Processor E3800 Series SATA IDE Controller" },
		Device { id: 0x0F21, name: "Atom Processor E3800 Series SATA IDE Controller" },
		Device { id: 0x0F22, name: "Atom Processor E3800 Series SATA AHCI Controller" },
		Device { id: 0x0F23, name: "Atom Processor E3800 Series SATA AHCI Controller" },
		Device { id: 0x0F28, name: "Atom Processor Z36xxx/Z37xxx Series LPE Audio Controller" },
		Device { id: 0x0F31, name: "Atom Processor Z36xxx/Z37xxx Series Graphics & Display" },
		Device { id: 0x0F34, name: "Atom Processor Z36xxx/Z37xxx Series USB EHCI" },
		Device { id: 0x0F35, name: "Atom Processor Z36xxx/Z37xxx, Celeron N2000 Series USB xHCI" },
		Device { id: 0x0F37, name: "Atom Processor Z36xxx/Z37xxx Series OTG USB Device" },
		Device { id: 0x0F38, name: "Atom Processor Z36xxx/Z37xxx Series Camera ISP" },
		Device { id: 0x0F40, name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 DMA Controller" },
		Device { id: 0x0F41, name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #1" },
		Device { id: 0x0F42, name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #2" },
		Device { id: 0x0F43, name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #3" },
		Device { id: 0x0F44, name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #4" },
		Device { id: 0x0F45, name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #5" },
		Device { id: 0x0F46, name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #6" },
		Device { id: 0x0F47, name: "Atom Processor Z36xxx/Z37xxx Series LPIO2 I2C Controller #7" },
		Device { id: 0x0F48, name: "Atom Processor E3800 Series PCI Express Root Port 1" },
		Device { id: 0x0F4A, name: "Atom Processor E3800 Series PCI Express Root Port 2" },
		Device { id: 0x0F4C, name: "Atom Processor E3800 Series PCI Express Root Port 3" },
		Device { id: 0x0F4E, name: "Atom Processor E3800 Series PCI Express Root Port 4" },
		Device { id: 0x0F50, name: "Atom Processor E3800 Series eMMC 4.5 Controller" },
		Device { id: 0x1000, name: "82542 Gigabit Ethernet Controller (Fiber)" },
		Device { id: 0x1001, name: "82543GC Gigabit Ethernet Controller (Fiber)" },
		Device { id: 0x1002, name: "Pro 100 LAN+Modem 56 Cardbus II" },
		Device { id: 0x1004, name: "82543GC Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x1008, name: "82544EI Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x1009, name: "82544EI Gigabit Ethernet Controller (Fiber)" },
		Device { id: 0x100A, name: "82540EM Gigabit Ethernet Controller" },
		Device { id: 0x100C, name: "82544GC Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x100D, name: "82544GC Gigabit Ethernet Controller (LOM)" },
		Device { id: 0x100E, name: "82540EM Gigabit Ethernet Controller" },
		Device { id: 0x100F, name: "82545EM Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x1010, name: "82546EB Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x1011, name: "82545EM Gigabit Ethernet Controller (Fiber)" },
		Device { id: 0x1012, name: "82546EB Gigabit Ethernet Controller (Fiber)" },
		Device { id: 0x1013, name: "82541EI Gigabit Ethernet Controller" },
		Device { id: 0x1014, name: "82541ER Gigabit Ethernet Controller" },
		Device { id: 0x1015, name: "82540EM Gigabit Ethernet Controller (LOM)" },
		Device { id: 0x1016, name: "82540EP Gigabit Ethernet Controller (Mobile)" },
		Device { id: 0x1017, name: "82540EP Gigabit Ethernet Controller" },
		Device { id: 0x1018, name: "82541EI Gigabit Ethernet Controller" },
		Device { id: 0x1019, name: "82547EI Gigabit Ethernet Controller" },
		Device { id: 0x101A, name: "82547EI Gigabit Ethernet Controller (Mobile)" },
		Device { id: 0x101D, name: "82546EB Gigabit Ethernet Controller" },
		Device { id: 0x101E, name: "82540EP Gigabit Ethernet Controller (Mobile)" },
		Device { id: 0x1026, name: "82545GM Gigabit Ethernet Controller" },
		Device { id: 0x1027, name: "82545GM Gigabit Ethernet Controller" },
		Device { id: 0x1028, name: "82545GM Gigabit Ethernet Controller" },
		Device { id: 0x1029, name: "82559 Ethernet Controller" },
		Device { id: 0x1030, name: "82559 InBusiness 10/100" },
		Device { id: 0x1031, name: "82801CAM (ICH3) PRO/100 VE (LOM) Ethernet Controller" },
		Device { id: 0x1032, name: "82801CAM (ICH3) PRO/100 VE Ethernet Controller" },
		Device { id: 0x1033, name: "82801CAM (ICH3) PRO/100 VM (LOM) Ethernet Controller" },
		Device { id: 0x1034, name: "82801CAM (ICH3) PRO/100 VM Ethernet Controller" },
		Device { id: 0x1035, name: "82801CAM (ICH3)/82562EH (LOM) Ethernet Controller" },
		Device { id: 0x1036, name: "82801CAM (ICH3) 82562EH Ethernet Controller" },
		Device { id: 0x1037, name: "82801CAM (ICH3) Chipset Ethernet Controller" },
		Device { id: 0x1038, name: "82801CAM (ICH3) PRO/100 VM (KM) Ethernet Controller" },
		Device { id: 0x1039, name: "82801DB PRO/100 VE (LOM) Ethernet Controller" },
		Device { id: 0x103A, name: "82801DB PRO/100 VE (CNR) Ethernet Controller" },
		Device { id: 0x103B, name: "82801DB PRO/100 VM (LOM) Ethernet Controller" },
		Device { id: 0x103C, name: "82801DB PRO/100 VM (CNR) Ethernet Controller" },
		Device { id: 0x103D, name: "82801DB PRO/100 VE (MOB) Ethernet Controller" },
		Device { id: 0x103E, name: "82801DB PRO/100 VM (MOB) Ethernet Controller" },
		Device { id: 0x1040, name: "536EP Data Fax Modem" },
		Device { id: 0x1043, name: "PRO/Wireless LAN 2100 3B Mini PCI Adapter" },
		Device { id: 0x1048, name: "82597EX 10GbE Ethernet Controller" },
		Device { id: 0x1049, name: "82566MM Gigabit Network Connection" },
		Device { id: 0x104A, name: "82566DM Gigabit Network Connection" },
		Device { id: 0x104B, name: "82566DC Gigabit Network Connection" },
		Device { id: 0x104C, name: "82562V 10/100 Network Connection" },
		Device { id: 0x104D, name: "82566MC Gigabit Network Connection" },
		Device { id: 0x1050, name: "82562EZ 10/100 Ethernet Controller" },
		Device { id: 0x1051, name: "82801EB/ER (ICH5/ICH5R) integrated LAN Controller" },
		Device { id: 0x1052, name: "PRO/100 VM Network Connection" },
		Device { id: 0x1053, name: "PRO/100 VM Network Connection" },
		Device { id: 0x1054, name: "PRO/100 VE Network Connection" },
		Device { id: 0x1055, name: "PRO/100 VM Network Connection" },
		Device { id: 0x1056, name: "PRO/100 VE Network Connection" },
		Device { id: 0x1057, name: "PRO/100 VE Network Connection" },
		Device { id: 0x1059, name: "82551QM Ethernet Controller" },
		Device { id: 0x105B, name: "82546GB Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x105E, name: "82571EB Gigabit Ethernet Controller" },
		Device { id: 0x105F, name: "82571EB Gigabit Ethernet Controller" },
		Device { id: 0x1060, name: "82571EB Gigabit Ethernet Controller" },
		Device { id: 0x1064, name: "82562ET/EZ/GT/GZ - PRO/100 VE (LOM) Ethernet Controller" },
		Device { id: 0x1065, name: "82562ET/EZ/GT/GZ - PRO/100 VE Ethernet Controller" },
		Device { id: 0x1066, name: "82562 EM/EX/GX - PRO/100 VM (LOM) Ethernet Controller" },
		Device { id: 0x1067, name: "82562 EM/EX/GX - PRO/100 VM Ethernet Controller" },
		Device { id: 0x1068, name: "82562ET/EZ/GT/GZ - PRO/100 VE (LOM) Ethernet Controller Mobile" },
		Device { id: 0x1069, name: "82562EM/EX/GX - PRO/100 VM (LOM) Ethernet Controller Mobile" },
		Device { id: 0x106A, name: "82562G - PRO/100 VE (LOM) Ethernet Controller" },
		Device { id: 0x106B, name: "82562G - PRO/100 VE Ethernet Controller Mobile" },
		Device { id: 0x1075, name: "82547GI Gigabit Ethernet Controller" },
		Device { id: 0x1076, name: "82541GI Gigabit Ethernet Controller" },
		Device { id: 0x1077, name: "82541GI Gigabit Ethernet Controller" },
		Device { id: 0x1078, name: "82541ER Gigabit Ethernet Controller" },
		Device { id: 0x1079, name: "82546GB Gigabit Ethernet Controller" },
		Device { id: 0x107A, name: "82546GB Gigabit Ethernet Controller" },
		Device { id: 0x107B, name: "82546GB Gigabit Ethernet Controller" },
		Device { id: 0x107C, name: "82541PI Gigabit Ethernet Controller" },
		Device { id: 0x107D, name: "82572EI Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x107E, name: "82572EI Gigabit Ethernet Controller (Fiber)" },
		Device { id: 0x107F, name: "82572EI Gigabit Ethernet Controller" },
		Device { id: 0x1080, name: "FA82537EP 56K V.92 Data/Fax Modem PCI" },
		Device { id: 0x1081, name: "631xESB/632xESB LAN Controller Copper" },
		Device { id: 0x1082, name: "631xESB/632xESB LAN Controller fiber" },
		Device { id: 0x1083, name: "631xESB/632xESB LAN Controller SERDES" },
		Device { id: 0x1084, name: "631xESB/632xESB IDE Redirection" },
		Device { id: 0x1085, name: "631xESB/632xESB Serial Port Redirection" },
		Device { id: 0x1086, name: "631xESB/632xESB IPMI/KCS0" },
		Device { id: 0x1087, name: "631xESB/632xESB UHCI Redirection" },
		Device { id: 0x1089, name: "631xESB/632xESB BT" },
		Device { id: 0x108A, name: "82546GB Gigabit Ethernet Controller" },
		Device { id: 0x108B, name: "82573V Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x108C, name: "82573E Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x108E, name: "82573E KCS (Active Management)" },
		Device { id: 0x108F, name: "Active Management Technology - SOL" },
		Device { id: 0x1091, name: "PRO/100 VM Network Connection" },
		Device { id: 0x1092, name: "PRO/100 VE Network Connection" },
		Device { id: 0x1093, name: "PRO/100 VM Network Connection" },
		Device { id: 0x1094, name: "PRO/100 VE Network Connection" },
		Device { id: 0x1095, name: "PRO/100 VE Network Connection" },
		Device { id: 0x1096, name: "80003ES2LAN Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x1097, name: "631xESB/632xESB DPT LAN Controller (Fiber)" },
		Device { id: 0x1098, name: "80003ES2LAN Gigabit Ethernet Controller (Serdes)" },
		Device { id: 0x1099, name: "82546GB Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x109A, name: "82573L Gigabit Ethernet Controller" },
		Device { id: 0x109B, name: "82546GB PRO/1000 GF Quad Port Server Adapter" },
		Device { id: 0x109E, name: "82597EX 10GbE Ethernet Controller" },
		Device { id: 0x10A0, name: "82571EB PRO/1000 AT Quad Port Bypass Adapter" },
		Device { id: 0x10A1, name: "82571EB PRO/1000 AF Quad Port Bypass Adapter" },
		Device { id: 0x10A4, name: "82571EB Gigabit Ethernet Controller" },
		Device { id: 0x10A5, name: "82571EB Gigabit Ethernet Controller (Fiber)" },
		Device { id: 0x10A6, name: "82599EB 10-Gigabit Dummy Function" },
		Device { id: 0x10A7, name: "82575EB Gigabit Network Connection" },
		Device { id: 0x10A9, name: "82575EB Gigabit Backplane Connection" },
		Device { id: 0x10B0, name: "82573L PRO/1000 PL Network Connection" },
		Device { id: 0x10B2, name: "82573V PRO/1000 PM Network Connection" },
		Device { id: 0x10B3, name: "82573E PRO/1000 PM Network Connection" },
		Device { id: 0x10B4, name: "82573L PRO/1000 PL Network Connection" },
		Device { id: 0x10B5, name: "82546GB Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x10B6, name: "82598 10GbE PCI-Express Ethernet Controller" },
		Device { id: 0x10B9, name: "82572EI Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x10BA, name: "80003ES2LAN Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x10BB, name: "80003ES2LAN Gigabit Ethernet Controller (Serdes)" },
		Device { id: 0x10BC, name: "82571EB Gigabit Ethernet Controller (Copper)" },
		Device { id: 0x10BD, name: "82566DM-2 Gigabit Network Connection" },
		Device { id: 0x10BF, name: "82567LF Gigabit Network Connection" },
		Device { id: 0x10C0, name: "82562V-2 10/100 Network Connection" },
		Device { id: 0x10C2, name: "82562G-2 10/100 Network Connection" },
		Device { id: 0x10C3, name: "82562GT-2 10/100 Network Connection" },
		Device { id: 0x10C4, name: "82562GT 10/100 Network Connection" },
		Device { id: 0x10C5, name: "82562G 10/100 Network Connection" },
		Device { id: 0x10C6, name: "82598EB 10-Gigabit AF Dual Port Network Connection" },
		Device { id: 0x10C7, name: "82598EB 10-Gigabit AF Network Connection" },
		Device { id: 0x10C8, name: "82598EB 10-Gigabit AT Network Connection" },
		Device { id: 0x10C9, name: "82576 Gigabit Network Connection" },
		Device { id: 0x10CA, name: "82576 Virtual Function" },
		Device { id: 0x10CB, name: "82567V Gigabit Network Connection" },
		Device { id: 0x10CC, name: "82567LM-2 Gigabit Network Connection" },
		Device { id: 0x10CD, name: "82567LF-2 Gigabit Network Connection" },
		Device { id: 0x10CE, name: "82567V-2 Gigabit Network Connection" },
		Device { id: 0x10D3, name: "82574L Gigabit Network Connection" },
		Device { id: 0x10D4, name: "Matrox Concord GE (customized Intel 82574)" },
		Device { id: 0x10D5, name: "82571PT Gigabit PT Quad Port Server ExpressModule" },
		Device { id: 0x10D6, name: "82575GB Gigabit Network Connection" },
		Device { id: 0x10D8, name: "82599EB 10 Gigabit Unprogrammed" },
		Device { id: 0x10D9, name: "82571EB Dual Port Gigabit Mezzanine Adapter" },
		Device { id: 0x10DA, name: "82571EB Quad Port Gigabit Mezzanine Adapter" },
		Device { id: 0x10DB, name: "82598EB 10-Gigabit Dual Port Network Connection" },
		Device { id: 0x10DD, name: "82598EB 10-Gigabit AT CX4 Network Connection" },
		Device { id: 0x10DE, name: "82567LM-3 Gigabit Network Connection" },
		Device { id: 0x10DF, name: "82567LF-3 Gigabit Network Connection" },
		Device { id: 0x10E1, name: "82598EB 10-Gigabit AF Dual Port Network Connection" },
		Device { id: 0x10E2, name: "82575GB Gigabit Network Connection" },
		Device { id: 0x10E5, name: "82567LM-4 Gigabit Network Connection" },
		Device { id: 0x10E6, name: "82576 Gigabit Network Connection" },
		Device { id: 0x10E7, name: "82576 Gigabit Network Connection" },
		Device { id: 0x10E8, name: "82576 Gigabit Network Connection" },
		Device { id: 0x10EA, name: "82577LM Gigabit Network Connection" },
		Device { id: 0x10EB, name: "82577LC Gigabit Network Connection" },
		Device { id: 0x10EC, name: "82598EB 10-Gigabit AT CX4 Network Connection" },
		Device { id: 0x10ED, name: "82599 Ethernet Controller Virtual Function" },
		Device { id: 0x10EF, name: "82578DM Gigabit Network Connection" },
		Device { id: 0x10F0, name: "82578DC Gigabit Network Connection" },
		Device { id: 0x10F1, name: "82598EB 10-Gigabit AF Dual Port Network Connection" },
		Device { id: 0x10F4, name: "82598EB 10-Gigabit AF Network Connection" },
		Device { id: 0x10F5, name: "82567LM Gigabit Network Connection" },
		Device { id: 0x10F6, name: "82574L Gigabit Network Connection" },
		Device { id: 0x10F7, name: "10 Gigabit BR KX4 Dual Port Network Connection" },
		Device { id: 0x10F8, name: "82599 10 Gigabit Dual Port Backplane Connection" },
		Device { id: 0x10F9, name: "82599 10 Gigabit Dual Port Network Connection" },
		Device { id: 0x10FB, name: "82599ES 10-Gigabit SFI/SFP+ Network Connection" },
		Device { id: 0x10FC, name: "82599 10 Gigabit Dual Port Network Connection" },
		Device { id: 0x10FE, name: "82552 10/100 Network Connection" },
		Device { id: 0x1107, name: "PRO/1000 MF Server Adapter (LX)" },
		Device { id: 0x1130, name: "82815 815 Chipset Host Bridge and Memory Controller Hub" },
		Device { id: 0x1131, name: "82815 815 Chipset AGP Bridge" },
		Device { id: 0x1132, name: "82815 Chipset Graphics Controller (CGC)" },
		Device { id: 0x1161, name: "82806AA PCI64 Hub Advanced Programmable Interrupt Controller" },
		Device { id: 0x1162, name: "Xscale 80200 Big Endian Companion Chip" },
		Device { id: 0x1190, name: "Merrifield SD/SDIO/eMMC Controller" },
		Device { id: 0x1191, name: "Merrifield Serial IO HSUART Controller" },
		Device { id: 0x1192, name: "Merrifield Serial IO HSUART DMA Controller" },
		Device { id: 0x1194, name: "Merrifield Serial IO SPI Controller" },
		Device { id: 0x1195, name: "Merrifield Serial IO I2C Controller" },
		Device { id: 0x1196, name: "Merrifield Serial IO I2C Controller" },
		Device { id: 0x1199, name: "Merrifield GPIO Controller" },
		Device { id: 0x119E, name: "Merrifield USB Device Controller (OTG)" },
		Device { id: 0x11A0, name: "Merrifield SCU IPC" },
		Device { id: 0x11A1, name: "Merrifield Power Management Unit" },
		Device { id: 0x11A2, name: "Merrifield Serial IO DMA Controller" },
		Device { id: 0x11A5, name: "Merrifield Serial IO PWM Controller" },
		Device { id: 0x11C3, name: "Quark SoC X1000 PCIe Root Port 0" },
		Device { id: 0x11C4, name: "Quark SoC X1000 PCIe Root Port 1" },
		Device { id: 0x1200, name: "IXP1200 Network Processor" },
		Device { id: 0x1209, name: "8255xER/82551IT Fast Ethernet Controller" },
		Device { id: 0x1221, name: "82092AA PCI to PCMCIA Bridge" },
		Device { id: 0x1222, name: "82092AA IDE Controller" },
		Device { id: 0x1223, name: "SAA7116" },
		Device { id: 0x1225, name: "82452KX/GX [Orion]" },
		Device { id: 0x1226, name: "82596 PRO/10 PCI" },
		Device { id: 0x1227, name: "82865 EtherExpress PRO/100A" },
		Device { id: 0x1228, name: "82556 EtherExpress PRO/100 Smart" },
		Device { id: 0x1229, name: "82557/8/9/0/1 Ethernet Pro 100" },
		Device { id: 0x122D, name: "430FX - 82437FX TSC [Triton I]" },
		Device { id: 0x122E, name: "82371FB PIIX ISA [Triton I]" },
		Device { id: 0x1230, name: "82371FB PIIX IDE [Triton I]" },
		Device { id: 0x1231, name: "DSVD Modem" },
		Device { id: 0x1234, name: "430MX - 82371MX Mobile PCI I/O IDE Xcelerator (MPIIX)" },
		Device { id: 0x1235, name: "430MX - 82437MX Mob. System Ctrlr (MTSC) & 82438MX Data Path (MTDP)" },
		Device { id: 0x1237, name: "440FX - 82441FX PMC [Natoma]" },
		Device { id: 0x1239, name: "82371FB PIIX IDE Interface" },
		Device { id: 0x123B, name: "82380PB PCI to PCI Docking Bridge" },
		Device { id: 0x123C, name: "82380AB (MISA) Mobile PCI-to-ISA Bridge" },
		Device { id: 0x123D, name: "683053 Programmable Interrupt Device" },
		Device { id: 0x123E, name: "82466GX (IHPC) Integrated Hot-Plug Controller (hidden mode)" },
		Device { id: 0x123F, name: "82466GX Integrated Hot-Plug Controller (IHPC)" },
		Device { id: 0x1240, name: "82752 (752) AGP Graphics Accelerator" },
		Device { id: 0x124B, name: "82380FB (MPCI2) Mobile Docking Controller" },
		Device { id: 0x1250, name: "430HX - 82439HX TXC [Triton II]" },
		Device { id: 0x1360, name: "82806AA PCI64 Hub PCI Bridge" },
		Device { id: 0x1361, name: "82806AA PCI64 Hub Controller (HRes)" },
		Device { id: 0x1460, name: "82870P2 P64H2 Hub PCI Bridge" },
		Device { id: 0x1461, name: "82870P2 P64H2 I/OxAPIC" },
		Device { id: 0x1462, name: "82870P2 P64H2 Hot Plug Controller" },
		Device { id: 0x1501, name: "82567V-3 Gigabit Network Connection" },
		Device { id: 0x1502, name: "82579LM Gigabit Network Connection (Lewisville)" },
		Device { id: 0x1503, name: "82579V Gigabit Network Connection" },
		Device { id: 0x1507, name: "Ethernet Express Module X520-P2" },
		Device { id: 0x1508, name: "82598EB Gigabit BX Network Connection" },
		Device { id: 0x150A, name: "82576NS Gigabit Network Connection" },
		Device { id: 0x150B, name: "82598EB 10-Gigabit AT2 Server Adapter" },
		Device { id: 0x150C, name: "82583V Gigabit Network Connection" },
		Device { id: 0x150D, name: "82576 Gigabit Backplane Connection" },
		Device { id: 0x150E, name: "82580 Gigabit Network Connection" },
		Device { id: 0x150F, name: "82580 Gigabit Fiber Network Connection" },
		Device { id: 0x1510, name: "82580 Gigabit Backplane Connection" },
		Device { id: 0x1511, name: "82580 Gigabit SFP Connection" },
		Device { id: 0x1513, name: "CV82524 Thunderbolt Controller [Light Ridge 4C 2010]" },
		Device { id: 0x1514, name: "Ethernet X520 10GbE Dual Port KX4 Mezz" },
		Device { id: 0x1515, name: "X540 Ethernet Controller Virtual Function" },
		Device { id: 0x1516, name: "82580 Gigabit Network Connection" },
		Device { id: 0x1517, name: "82599ES 10 Gigabit Network Connection" },
		Device { id: 0x1518, name: "82576NS SerDes Gigabit Network Connection" },
		Device { id: 0x151A, name: "DSL2310 Thunderbolt Controller [Eagle Ridge 2C 2011]" },
		Device { id: 0x151B, name: "CVL2510 Thunderbolt Controller [Light Peak 2C 2010]" },
		Device { id: 0x151C, name: "82599 10 Gigabit TN Network Connection" },
		Device { id: 0x1520, name: "I350 Ethernet Controller Virtual Function" },
		Device { id: 0x1521, name: "I350 Gigabit Network Connection" },
		Device { id: 0x1522, name: "I350 Gigabit Fiber Network Connection" },
		Device { id: 0x1523, name: "I350 Gigabit Backplane Connection" },
		Device { id: 0x1524, name: "I350 Gigabit Connection" },
		Device { id: 0x1525, name: "82567V-4 Gigabit Network Connection" },
		Device { id: 0x1526, name: "82576 Gigabit Network Connection" },
		Device { id: 0x1527, name: "82580 Gigabit Fiber Network Connection" },
		Device { id: 0x1528, name: "Ethernet Controller 10-Gigabit X540-AT2" },
		Device { id: 0x1529, name: "82599 10 Gigabit Dual Port Network Connection with FCoE" },
		Device { id: 0x152A, name: "82599 10 Gigabit Dual Port Backplane Connection with FCoE" },
		Device { id: 0x152E, name: "82599 Virtual Function" },
		Device { id: 0x152F, name: "I350 Virtual Function" },
		Device { id: 0x1530, name: "X540 Virtual Function" },
		Device { id: 0x1533, name: "I210 Gigabit Network Connection" },
		Device { id: 0x1536, name: "I210 Gigabit Fiber Network Connection" },
		Device { id: 0x1537, name: "I210 Gigabit Backplane Connection" },
		Device { id: 0x1538, name: "I210 Gigabit Network Connection" },
		Device { id: 0x1539, name: "I211 Gigabit Network Connection" },
		Device { id: 0x153A, name: "Ethernet Connection I217-LM" },
		Device { id: 0x153B, name: "Ethernet Connection I217-V" },
		Device { id: 0x1547, name: "DSL3510 Thunderbolt Controller [Cactus Ridge 4C 2012]" },
		Device { id: 0x1548, name: "DSL3310 Thunderbolt Controller [Cactus Ridge 2C 2012]" },
		Device { id: 0x1549, name: "DSL2210 Thunderbolt Controller [Port Ridge 1C 2011]" },
		Device { id: 0x154A, name: "Ethernet Server Adapter X520-4" },
		Device { id: 0x154C, name: "Ethernet Virtual Function 700 Series" },
		Device { id: 0x154D, name: "Ethernet 10G 2P X520 Adapter" },
		Device { id: 0x1557, name: "82599 10 Gigabit Network Connection" },
		Device { id: 0x1558, name: "Ethernet Converged Network Adapter X520-Q1" },
		Device { id: 0x1559, name: "Ethernet Connection I218-V" },
		Device { id: 0x155A, name: "Ethernet Connection I218-LM" },
		Device { id: 0x155C, name: "Ethernet Server Bypass Adapter" },
		Device { id: 0x155D, name: "Ethernet Server Bypass Adapter" },
		Device { id: 0x1560, name: "Ethernet Controller X540" },
		Device { id: 0x1563, name: "Ethernet Controller 10G X550T" },
		Device { id: 0x1564, name: "X550 Virtual Function" },
		Device { id: 0x1565, name: "X550 Virtual Function" },
		Device { id: 0x1566, name: "DSL4410 Thunderbolt NHI [Redwood Ridge 2C 2013]" },
		Device { id: 0x1567, name: "DSL4410 Thunderbolt Bridge [Redwood Ridge 2C 2013]" },
		Device { id: 0x1568, name: "DSL4510 Thunderbolt NHI [Redwood Ridge 4C 2013]" },
		Device { id: 0x1569, name: "DSL4510 Thunderbolt Bridge [Redwood Ridge 4C 2013]" },
		Device { id: 0x156A, name: "DSL5320 Thunderbolt 2 NHI [Falcon Ridge 2C 2013]" },
		Device { id: 0x156B, name: "DSL5320 Thunderbolt 2 Bridge [Falcon Ridge 2C 2013]" },
		Device { id: 0x156C, name: "DSL5520 Thunderbolt 2 NHI [Falcon Ridge 4C 2013]" },
		Device { id: 0x156D, name: "DSL5520 Thunderbolt 2 Bridge [Falcon Ridge 4C 2013]" },
		Device { id: 0x156F, name: "Ethernet Connection I219-LM" },
		Device { id: 0x1570, name: "Ethernet Connection I219-V" },
		Device { id: 0x1571, name: "Ethernet Virtual Function 700 Series" },
		Device { id: 0x1572, name: "Ethernet Controller X710 for 10GbE SFP+" },
		Device { id: 0x1575, name: "DSL6340 Thunderbolt 3 NHI [Alpine Ridge 2C 2015]" },
		Device { id: 0x1576, name: "DSL6340 Thunderbolt 3 Bridge [Alpine Ridge 2C 2015]" },
		Device { id: 0x1577, name: "DSL6540 Thunderbolt 3 NHI [Alpine Ridge 4C 2015]" },
		Device { id: 0x1578, name: "DSL6540 Thunderbolt 3 Bridge [Alpine Ridge 4C 2015]" },
		Device { id: 0x157B, name: "I210 Gigabit Network Connection" },
		Device { id: 0x157C, name: "I210 Gigabit Backplane Connection" },
		Device { id: 0x157D, name: "DSL5110 Thunderbolt 2 NHI (Low Power) [Win Ridge 2C 2014]" },
		Device { id: 0x157E, name: "DSL5110 Thunderbolt 2 Bridge (Low Power) [Win Ridge 2C 2014]" },
		Device { id: 0x1580, name: "Ethernet Controller XL710 for 40GbE backplane" },
		Device { id: 0x1581, name: "Ethernet Controller X710 for 10GbE backplane" },
		Device { id: 0x1583, name: "Ethernet Controller XL710 for 40GbE QSFP+" },
		Device { id: 0x1584, name: "Ethernet Controller XL710 for 40GbE QSFP+" },
		Device { id: 0x1585, name: "Ethernet Controller X710 for 10GbE QSFP+" },
		Device { id: 0x1586, name: "Ethernet Controller X710 for 10GBASE-T" },
		Device { id: 0x1587, name: "Ethernet Controller XL710 for 20GbE backplane" },
		Device { id: 0x1588, name: "Ethernet Controller XL710 for 20GbE backplane" },
		Device { id: 0x1589, name: "Ethernet Controller X710/X557-AT 10GBASE-T" },
		Device { id: 0x158A, name: "Ethernet Controller XXV710 for 25GbE backplane" },
		Device { id: 0x158B, name: "Ethernet Controller XXV710 for 25GbE SFP28" },
		Device { id: 0x15A0, name: "Ethernet Connection (2) I218-LM" },
		Device { id: 0x15A1, name: "Ethernet Connection (2) I218-V" },
		Device { id: 0x15A2, name: "Ethernet Connection (3) I218-LM" },
		Device { id: 0x15A3, name: "Ethernet Connection (3) I218-V" },
		Device { id: 0x15A4, name: "Ethernet Switch FM10000 Host Interface" },
		Device { id: 0x15A5, name: "Ethernet Switch FM10000 Host Virtual Interface" },
		Device { id: 0x15A8, name: "Ethernet Connection X552 Virtual Function" },
		Device { id: 0x15A9, name: "X552 Virtual Function" },
		Device { id: 0x15AA, name: "Ethernet Connection X552 10 GbE Backplane" },
		Device { id: 0x15AB, name: "Ethernet Connection X552 10 GbE Backplane" },
		Device { id: 0x15AC, name: "Ethernet Connection X552 10 GbE SFP+" },
		Device { id: 0x15AD, name: "Ethernet Connection X552/X557-AT 10GBASE-T" },
		Device { id: 0x15AE, name: "Ethernet Connection X552 1000BASE-T" },
		Device { id: 0x15B0, name: "Ethernet Connection X552 Backplane" },
		Device { id: 0x15B4, name: "X553 Virtual Function" },
		Device { id: 0x15B5, name: "DSL6340 USB 3.1 Controller [Alpine Ridge]" },
		Device { id: 0x15B6, name: "DSL6540 USB 3.1 Controller [Alpine Ridge]" },
		Device { id: 0x15B7, name: "Ethernet Connection (2) I219-LM" },
		Device { id: 0x15B8, name: "Ethernet Connection (2) I219-V" },
		Device { id: 0x15B9, name: "Ethernet Connection (3) I219-LM" },
		Device { id: 0x15BB, name: "Ethernet Connection (7) I219-LM" },
		Device { id: 0x15BC, name: "Ethernet Connection (7) I219-V" },
		Device { id: 0x15BD, name: "Ethernet Connection (6) I219-LM" },
		Device { id: 0x15BE, name: "Ethernet Connection (6) I219-V" },
		Device { id: 0x15BF, name: "JHL6240 Thunderbolt 3 NHI (Low Power) [Alpine Ridge LP 2016]" },
		Device { id: 0x15C0, name: "JHL6240 Thunderbolt 3 Bridge (Low Power) [Alpine Ridge LP 2016]" },
		Device { id: 0x15C2, name: "Ethernet Connection X553 Backplane" },
		Device { id: 0x15C3, name: "Ethernet Connection X553 Backplane" },
		Device { id: 0x15C4, name: "Ethernet Connection X553 10 GbE SFP+" },
		Device { id: 0x15C5, name: "X553 Virtual Function" },
		Device { id: 0x15C6, name: "Ethernet Connection X553 1GbE" },
		Device { id: 0x15C7, name: "Ethernet Connection X553 1GbE" },
		Device { id: 0x15C8, name: "Ethernet Connection X553/X557-AT 10GBASE-T" },
		Device { id: 0x15CE, name: "Ethernet Connection X553 10 GbE SFP+" },
		Device { id: 0x15D0, name: "Ethernet SDI Adapter FM10420-100GbE-QDA2" },
		Device { id: 0x15D1, name: "Ethernet Controller 10G X550T" },
		Device { id: 0x15D2, name: "JHL6540 Thunderbolt 3 NHI (C step) [Alpine Ridge 4C 2016]" },
		Device { id: 0x15D3, name: "JHL6540 Thunderbolt 3 Bridge (C step) [Alpine Ridge 4C 2016]" },
		Device { id: 0x15D4, name: "JHL6540 Thunderbolt 3 USB Controller (C step) [Alpine Ridge 4C 2016]" },
		Device { id: 0x15D5, name: "Ethernet SDI Adapter FM10420-25GbE-DA2" },
		Device { id: 0x15D6, name: "Ethernet Connection (5) I219-V" },
		Device { id: 0x15D7, name: "Ethernet Connection (4) I219-LM" },
		Device { id: 0x15D8, name: "Ethernet Connection (4) I219-V" },
		Device { id: 0x15D9, name: "JHL6340 Thunderbolt 3 NHI (C step) [Alpine Ridge 2C 2016]" },
		Device { id: 0x15DA, name: "JHL6340 Thunderbolt 3 Bridge (C step) [Alpine Ridge 2C 2016]" },
		Device { id: 0x15DF, name: "Ethernet Connection (8) I219-LM" },
		Device { id: 0x15E0, name: "Ethernet Connection (8) I219-V" },
		Device { id: 0x15E1, name: "Ethernet Connection (9) I219-LM" },
		Device { id: 0x15E2, name: "Ethernet Connection (9) I219-V" },
		Device { id: 0x15E3, name: "Ethernet Connection (5) I219-LM" },
		Device { id: 0x15E4, name: "Ethernet Connection X553 1GbE" },
		Device { id: 0x15E5, name: "Ethernet Connection X553 1GbE" },
		Device { id: 0x1600, name: "Broadwell-U Host Bridge -OPI" },
		Device { id: 0x1601, name: "Broadwell-U PCI Express x16 Controller" },
		Device { id: 0x1602, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x1603, name: "Broadwell-U Processor Thermal Subsystem" },
		Device { id: 0x1604, name: "Broadwell-U Host Bridge -OPI" },
		Device { id: 0x1605, name: "Broadwell-U PCI Express x8 Controller" },
		Device { id: 0x1606, name: "HD Graphics" },
		Device { id: 0x1607, name: "Broadwell-U CHAPS Device" },
		Device { id: 0x1608, name: "Broadwell-U Host Bridge -OPI" },
		Device { id: 0x1609, name: "Broadwell-U x4 PCIe" },
		Device { id: 0x160A, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x160B, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x160C, name: "Broadwell-U Audio Controller" },
		Device { id: 0x160D, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x160E, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x160F, name: "Broadwell-U SoftSKU" },
		Device { id: 0x1610, name: "Broadwell-U Host Bridge - DMI" },
		Device { id: 0x1612, name: "HD Graphics 5600" },
		Device { id: 0x1614, name: "Broadwell-U Host Bridge - DMI" },
		Device { id: 0x1616, name: "HD Graphics 5500" },
		Device { id: 0x1618, name: "Broadwell-U Host Bridge - DMI" },
		Device { id: 0x161A, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x161B, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x161D, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x161E, name: "HD Graphics 5300" },
		Device { id: 0x1622, name: "Iris Pro Graphics 6200" },
		Device { id: 0x1626, name: "HD Graphics 6000" },
		Device { id: 0x162A, name: "Iris Pro Graphics P6300" },
		Device { id: 0x162B, name: "Iris Graphics 6100" },
		Device { id: 0x162D, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x162E, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x1632, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x1636, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x163A, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x163B, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x163D, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x163E, name: "Broadwell-U Integrated Graphics" },
		Device { id: 0x1889, name: "Ethernet Adaptive Virtual Function" },
		Device { id: 0x1900, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x1901, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor PCIe Controller (x16)" },
		Device { id: 0x1902, name: "HD Graphics 510" },
		Device { id: 0x1903, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Thermal Subsystem" },
		Device { id: 0x1904, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x1905, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor PCIe Controller (x8)" },
		Device { id: 0x1906, name: "HD Graphics 510" },
		Device { id: 0x1908, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x1909, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor PCIe Controller (x4)" },
		Device { id: 0x190C, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x190F, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x1910, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x1911, name: "Xeon E3-1200 v5/v6 / E3-1500 v5 / 6th/7th Gen Core Processor Gaussian Mixture Model" },
		Device { id: 0x1912, name: "HD Graphics 530" },
		Device { id: 0x1916, name: "Skylake GT2 [HD Graphics 520]" },
		Device { id: 0x1918, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x1919, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Imaging Unit" },
		Device { id: 0x191B, name: "HD Graphics 530" },
		Device { id: 0x191D, name: "HD Graphics P530" },
		Device { id: 0x191E, name: "HD Graphics 515" },
		Device { id: 0x191F, name: "Xeon E3-1200 v5/E3-1500 v5/6th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x1921, name: "HD Graphics 520" },
		Device { id: 0x1926, name: "Iris Graphics 540" },
		Device { id: 0x1927, name: "Iris Graphics 550" },
		Device { id: 0x192B, name: "Iris Graphics 555" },
		Device { id: 0x192D, name: "Iris Graphics P555" },
		Device { id: 0x1932, name: "Iris Pro Graphics 580" },
		Device { id: 0x193A, name: "Iris Pro Graphics P580" },
		Device { id: 0x193B, name: "Iris Pro Graphics 580" },
		Device { id: 0x193D, name: "Iris Pro Graphics P580" },
		Device { id: 0x1960, name: "80960RP (i960RP) Microprocessor" },
		Device { id: 0x1962, name: "80960RM (i960RM) Microprocessor" },
		Device { id: 0x19AC, name: "DNV SMBus Contoller - Host" },
		Device { id: 0x19B0, name: "DNV SATA Controller 0" },
		Device { id: 0x19B1, name: "DNV SATA Controller 0" },
		Device { id: 0x19B2, name: "DNV SATA Controller 0" },
		Device { id: 0x19B3, name: "DNV SATA Controller 0" },
		Device { id: 0x19B4, name: "DNV SATA Controller 0" },
		Device { id: 0x19B5, name: "DNV SATA Controller 0" },
		Device { id: 0x19B6, name: "DNV SATA Controller 0" },
		Device { id: 0x19B7, name: "DNV SATA Controller 0" },
		Device { id: 0x19BE, name: "DNV SATA Controller 0" },
		Device { id: 0x19BF, name: "DNV SATA Controller 0" },
		Device { id: 0x19C0, name: "DNV SATA Controller 1" },
		Device { id: 0x19C1, name: "DNV SATA Controller 1" },
		Device { id: 0x19C2, name: "DNV SATA Controller 1" },
		Device { id: 0x19C3, name: "DNV SATA Controller 1" },
		Device { id: 0x19C4, name: "DNV SATA Controller 1" },
		Device { id: 0x19C5, name: "DNV SATA Controller 1" },
		Device { id: 0x19C6, name: "DNV SATA Controller 1" },
		Device { id: 0x19C7, name: "DNV SATA Controller 1" },
		Device { id: 0x19CE, name: "DNV SATA Controller 1" },
		Device { id: 0x19CF, name: "DNV SATA Controller 1" },
		Device { id: 0x19DC, name: "DNV LPC or eSPI" },
		Device { id: 0x19DF, name: "DNV SMBus controller" },
		Device { id: 0x19E0, name: "DNV SPI Controller" },
		Device { id: 0x1A21, name: "82840 840 [Carmel] Chipset Host Bridge (Hub A)" },
		Device { id: 0x1A23, name: "82840 840 [Carmel] Chipset AGP Bridge" },
		Device { id: 0x1A24, name: "82840 840 [Carmel] Chipset PCI Bridge (Hub B)" },
		Device { id: 0x1A30, name: "82845 845 [Brookdale] Chipset Host Bridge" },
		Device { id: 0x1A31, name: "82845 845 [Brookdale] Chipset AGP Bridge" },
		Device { id: 0x1A38, name: "5000 Series Chipset DMA Engine" },
		Device { id: 0x1A48, name: "82597EX 10GbE Ethernet Controller" },
		Device { id: 0x1B48, name: "82597EX 10GbE Ethernet Controller" },
		Device { id: 0x1C00, name: "6 Series/C200 Series Chipset Family Desktop SATA Controller (IDE mode, ports 0-3)" },
		Device { id: 0x1C01, name: "6 Series/C200 Series Chipset Family Mobile SATA Controller (IDE mode, ports 0-3)" },
		Device { id: 0x1C02, name: "6 Series/C200 Series Chipset Family 6 port Desktop SATA AHCI Controller" },
		Device { id: 0x1C03, name: "6 Series/C200 Series Chipset Family 6 port Mobile SATA AHCI Controller" },
		Device { id: 0x1C04, name: "6 Series/C200 Series Desktop SATA RAID Controller" },
		Device { id: 0x1C05, name: "6 Series/C200 Series Mobile SATA RAID Controller" },
		Device { id: 0x1C06, name: "Z68 Express Chipset SATA RAID Controller" },
		Device { id: 0x1C08, name: "6 Series/C200 Series Chipset Family Desktop SATA Controller (IDE mode, ports 4-5)" },
		Device { id: 0x1C09, name: "6 Series/C200 Series Chipset Family Mobile SATA Controller (IDE mode, ports 4-5)" },
		Device { id: 0x1C10, name: "6 Series/C200 Series Chipset Family PCI Express Root Port 1" },
		Device { id: 0x1C12, name: "6 Series/C200 Series Chipset Family PCI Express Root Port 2" },
		Device { id: 0x1C14, name: "6 Series/C200 Series Chipset Family PCI Express Root Port 3" },
		Device { id: 0x1C16, name: "6 Series/C200 Series Chipset Family PCI Express Root Port 4" },
		Device { id: 0x1C18, name: "6 Series/C200 Series Chipset Family PCI Express Root Port 5" },
		Device { id: 0x1C1A, name: "6 Series/C200 Series Chipset Family PCI Express Root Port 6" },
		Device { id: 0x1C1C, name: "6 Series/C200 Series Chipset Family PCI Express Root Port 7" },
		Device { id: 0x1C1E, name: "6 Series/C200 Series Chipset Family PCI Express Root Port 8" },
		Device { id: 0x1C20, name: "6 Series/C200 Series Chipset Family High Definition Audio Controller" },
		Device { id: 0x1C22, name: "6 Series/C200 Series Chipset Family SMBus Controller" },
		Device { id: 0x1C24, name: "6 Series/C200 Series Chipset Family Thermal Management Controller" },
		Device { id: 0x1C25, name: "6 Series/C200 Series Chipset Family DMI to PCI Bridge" },
		Device { id: 0x1C26, name: "6 Series/C200 Series Chipset Family USB Enhanced Host Controller #1" },
		Device { id: 0x1C27, name: "6 Series/C200 Series Chipset Family USB Universal Host Controller #1" },
		Device { id: 0x1C2C, name: "6 Series/C200 Series Chipset Family USB Universal Host Controller #5" },
		Device { id: 0x1C2D, name: "6 Series/C200 Series Chipset Family USB Enhanced Host Controller #2" },
		Device { id: 0x1C33, name: "6 Series/C200 Series Chipset Family LAN Controller" },
		Device { id: 0x1C35, name: "6 Series/C200 Series Chipset Family VECI Controller" },
		Device { id: 0x1C3A, name: "6 Series/C200 Series Chipset Family MEI Controller #1" },
		Device { id: 0x1C3B, name: "6 Series/C200 Series Chipset Family MEI Controller #2" },
		Device { id: 0x1C3C, name: "6 Series/C200 Series Chipset Family IDE-r Controller" },
		Device { id: 0x1C3D, name: "6 Series/C200 Series Chipset Family KT Controller" },
		Device { id: 0x1C40, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C41, name: "Mobile SFF 6 Series Chipset Family LPC Controller" },
		Device { id: 0x1C42, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C43, name: "Mobile 6 Series Chipset Family LPC Controller" },
		Device { id: 0x1C44, name: "Z68 Express Chipset Family LPC Controller" },
		Device { id: 0x1C45, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C46, name: "P67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C47, name: "UM67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C48, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C49, name: "HM65 Express Chipset Family LPC Controller" },
		Device { id: 0x1C4A, name: "H67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C4B, name: "HM67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C4C, name: "Q65 Express Chipset Family LPC Controller" },
		Device { id: 0x1C4D, name: "QS67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C4E, name: "Q67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C4F, name: "QM67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C50, name: "B65 Express Chipset Family LPC Controller" },
		Device { id: 0x1C51, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C52, name: "C202 Chipset Family LPC Controller" },
		Device { id: 0x1C53, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C54, name: "C204 Chipset Family LPC Controller" },
		Device { id: 0x1C55, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C56, name: "C206 Chipset Family LPC Controller" },
		Device { id: 0x1C57, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C58, name: "Upgraded B65 Express Chipset Family LPC Controller" },
		Device { id: 0x1C59, name: "Upgraded HM67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C5A, name: "Upgraded Q67 Express Chipset Family LPC Controller" },
		Device { id: 0x1C5B, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C5C, name: "H61 Express Chipset Family LPC Controller" },
		Device { id: 0x1C5D, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C5E, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1C5F, name: "6 Series/C200 Series Chipset Family LPC Controller" },
		Device { id: 0x1D00, name: "C600/X79 series chipset 4-Port SATA IDE Controller" },
		Device { id: 0x1D02, name: "C600/X79 series chipset 6-Port SATA AHCI Controller" },
		Device { id: 0x1D04, name: "C600/X79 series chipset SATA RAID Controller" },
		Device { id: 0x1D06, name: "C600/X79 series chipset SATA Premium RAID Controller" },
		Device { id: 0x1D08, name: "C600/X79 series chipset 2-Port SATA IDE Controller" },
		Device { id: 0x1D10, name: "C600/X79 series chipset PCI Express Root Port 1" },
		Device { id: 0x1D11, name: "C600/X79 series chipset PCI Express Root Port 1" },
		Device { id: 0x1D12, name: "C600/X79 series chipset PCI Express Root Port 2" },
		Device { id: 0x1D13, name: "C600/X79 series chipset PCI Express Root Port 2" },
		Device { id: 0x1D14, name: "C600/X79 series chipset PCI Express Root Port 3" },
		Device { id: 0x1D15, name: "C600/X79 series chipset PCI Express Root Port 3" },
		Device { id: 0x1D16, name: "C600/X79 series chipset PCI Express Root Port 4" },
		Device { id: 0x1D17, name: "C600/X79 series chipset PCI Express Root Port 4" },
		Device { id: 0x1D18, name: "C600/X79 series chipset PCI Express Root Port 5" },
		Device { id: 0x1D19, name: "C600/X79 series chipset PCI Express Root Port 5" },
		Device { id: 0x1D1A, name: "C600/X79 series chipset PCI Express Root Port 6" },
		Device { id: 0x1D1B, name: "C600/X79 series chipset PCI Express Root Port 6" },
		Device { id: 0x1D1C, name: "C600/X79 series chipset PCI Express Root Port 7" },
		Device { id: 0x1D1D, name: "C600/X79 series chipset PCI Express Root Port 7" },
		Device { id: 0x1D1E, name: "C600/X79 series chipset PCI Express Root Port 8" },
		Device { id: 0x1D1F, name: "C600/X79 series chipset PCI Express Root Port 8" },
		Device { id: 0x1D20, name: "C600/X79 series chipset High Definition Audio Controller" },
		Device { id: 0x1D22, name: "C600/X79 series chipset SMBus Host Controller" },
		Device { id: 0x1D24, name: "C600/X79 series chipset Thermal Management Controller" },
		Device { id: 0x1D25, name: "C600/X79 series chipset DMI to PCI Bridge" },
		Device { id: 0x1D26, name: "C600/X79 series chipset USB2 Enhanced Host Controller #1" },
		Device { id: 0x1D2D, name: "C600/X79 series chipset USB2 Enhanced Host Controller #2" },
		Device { id: 0x1D33, name: "C600/X79 series chipset LAN Controller" },
		Device { id: 0x1D35, name: "C600/X79 series chipset VECI Controller" },
		Device { id: 0x1D3A, name: "C600/X79 series chipset MEI Controller #1" },
		Device { id: 0x1D3B, name: "C600/X79 series chipset MEI Controller #2" },
		Device { id: 0x1D3C, name: "C600/X79 series chipset IDE-r Controller" },
		Device { id: 0x1D3D, name: "C600/X79 series chipset KT Controller" },
		Device { id: 0x1D3E, name: "C600/X79 series chipset PCI Express Virtual Root Port" },
		Device { id: 0x1D3F, name: "C608/C606/X79 series chipset PCI Express Virtual Switch Port" },
		Device { id: 0x1D40, name: "C600/X79 series chipset LPC Controller" },
		Device { id: 0x1D41, name: "C600/X79 series chipset LPC Controller" },
		Device { id: 0x1D50, name: "C608 chipset Dual 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D54, name: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D55, name: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D58, name: "C606 chipset Dual 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D59, name: "C604/X79 series chipset 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D5A, name: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit" },
		Device { id: 0x1D5B, name: "C602 chipset 4-Port SATA Storage Control Unit" },
		Device { id: 0x1D5C, name: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D5D, name: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D5E, name: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit" },
		Device { id: 0x1D5F, name: "C600/X79 series chipset 4-Port SATA Storage Control Unit" },
		Device { id: 0x1D60, name: "C608 chipset Dual 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D64, name: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D65, name: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D68, name: "C606 chipset Dual 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D69, name: "C604/X79 series chipset 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D6A, name: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit" },
		Device { id: 0x1D6B, name: "C602 chipset 4-Port SATA Storage Control Unit" },
		Device { id: 0x1D6C, name: "C600/X79 series chipset Dual 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D6D, name: "C600/X79 series chipset 4-Port SATA/SAS Storage Control Unit" },
		Device { id: 0x1D6E, name: "C600/X79 series chipset Dual 4-Port SATA Storage Control Unit" },
		Device { id: 0x1D6F, name: "C600/X79 series chipset 4-Port SATA Storage Control Unit" },
		Device { id: 0x1D70, name: "C600/X79 series chipset SMBus Controller 0" },
		Device { id: 0x1D71, name: "C608/C606/X79 series chipset SMBus Controller 1" },
		Device { id: 0x1D72, name: "C608 chipset SMBus Controller 2" },
		Device { id: 0x1D74, name: "C608/C606/X79 series chipset PCI Express Upstream Port" },
		Device { id: 0x1D76, name: "C600/X79 series chipset Multi-Function Glue" },
		Device { id: 0x1E00, name: "7 Series/C210 Series Chipset Family 4-port SATA Controller [IDE mode]" },
		Device { id: 0x1E01, name: "7 Series Chipset Family 4-port SATA Controller [IDE mode]" },
		Device { id: 0x1E02, name: "7 Series/C210 Series Chipset Family 6-port SATA Controller [AHCI mode]" },
		Device { id: 0x1E03, name: "7 Series Chipset Family 6-port SATA Controller [AHCI mode]" },
		Device { id: 0x1E04, name: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]" },
		Device { id: 0x1E05, name: "7 Series Chipset SATA Controller [RAID mode]" },
		Device { id: 0x1E06, name: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]" },
		Device { id: 0x1E07, name: "7 Series Chipset Family SATA Controller [RAID mode]" },
		Device { id: 0x1E08, name: "7 Series/C210 Series Chipset Family 2-port SATA Controller [IDE mode]" },
		Device { id: 0x1E09, name: "7 Series Chipset Family 2-port SATA Controller [IDE mode]" },
		Device { id: 0x1E0E, name: "7 Series/C210 Series Chipset Family SATA Controller [RAID mode]" },
		Device { id: 0x1E10, name: "7 Series/C216 Chipset Family PCI Express Root Port 1" },
		Device { id: 0x1E12, name: "7 Series/C210 Series Chipset Family PCI Express Root Port 2" },
		Device { id: 0x1E14, name: "7 Series/C210 Series Chipset Family PCI Express Root Port 3" },
		Device { id: 0x1E16, name: "7 Series/C216 Chipset Family PCI Express Root Port 4" },
		Device { id: 0x1E18, name: "7 Series/C210 Series Chipset Family PCI Express Root Port 5" },
		Device { id: 0x1E1A, name: "7 Series/C210 Series Chipset Family PCI Express Root Port 6" },
		Device { id: 0x1E1C, name: "7 Series/C210 Series Chipset Family PCI Express Root Port 7" },
		Device { id: 0x1E1E, name: "7 Series/C210 Series Chipset Family PCI Express Root Port 8" },
		Device { id: 0x1E20, name: "7 Series/C216 Chipset Family High Definition Audio Controller" },
		Device { id: 0x1E22, name: "7 Series/C216 Chipset Family SMBus Controller" },
		Device { id: 0x1E24, name: "7 Series/C210 Series Chipset Family Thermal Management Controller" },
		Device { id: 0x1E25, name: "7 Series/C210 Series Chipset Family DMI to PCI Bridge" },
		Device { id: 0x1E26, name: "7 Series/C216 Chipset Family USB Enhanced Host Controller #1" },
		Device { id: 0x1E2D, name: "7 Series/C216 Chipset Family USB Enhanced Host Controller #2" },
		Device { id: 0x1E31, name: "7 Series/C210 Series Chipset Family USB xHCI Host Controller" },
		Device { id: 0x1E33, name: "7 Series/C210 Series Chipset Family LAN Controller" },
		Device { id: 0x1E3A, name: "7 Series/C216 Chipset Family MEI Controller #1" },
		Device { id: 0x1E3B, name: "7 Series/C210 Series Chipset Family MEI Controller #2" },
		Device { id: 0x1E3C, name: "7 Series/C210 Series Chipset Family IDE-r Controller" },
		Device { id: 0x1E3D, name: "7 Series/C210 Series Chipset Family KT Controller" },
		Device { id: 0x1E41, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E42, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E43, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E44, name: "Z77 Express Chipset LPC Controller" },
		Device { id: 0x1E45, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E46, name: "Z75 Express Chipset LPC Controller" },
		Device { id: 0x1E47, name: "Q77 Express Chipset LPC Controller" },
		Device { id: 0x1E48, name: "Q75 Express Chipset LPC Controller" },
		Device { id: 0x1E49, name: "B75 Express Chipset LPC Controller" },
		Device { id: 0x1E4A, name: "H77 Express Chipset LPC Controller" },
		Device { id: 0x1E4B, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E4C, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E4D, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E4E, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E4F, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E50, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E51, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E52, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E53, name: "C216 Series Chipset LPC Controller" },
		Device { id: 0x1E54, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E55, name: "QM77 Express Chipset LPC Controller" },
		Device { id: 0x1E56, name: "QS77 Express Chipset LPC Controller" },
		Device { id: 0x1E57, name: "HM77 Express Chipset LPC Controller" },
		Device { id: 0x1E58, name: "UM77 Express Chipset LPC Controller" },
		Device { id: 0x1E59, name: "HM76 Express Chipset LPC Controller" },
		Device { id: 0x1E5A, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E5B, name: "UM77 Express Chipset LPC Controller" },
		Device { id: 0x1E5C, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E5D, name: "HM75 Express Chipset LPC Controller" },
		Device { id: 0x1E5E, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1E5F, name: "7 Series Chipset Family LPC Controller" },
		Device { id: 0x1F00, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F01, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F02, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F03, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F04, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F05, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F06, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F07, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F08, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F09, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F0A, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F0B, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F0C, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F0D, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F0E, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F0F, name: "Atom processor C2000 SoC Transaction Router" },
		Device { id: 0x1F10, name: "Atom processor C2000 PCIe Root Port 1" },
		Device { id: 0x1F11, name: "Atom processor C2000 PCIe Root Port 2" },
		Device { id: 0x1F12, name: "Atom processor C2000 PCIe Root Port 3" },
		Device { id: 0x1F13, name: "Atom processor C2000 PCIe Root Port 4" },
		Device { id: 0x1F14, name: "Atom processor C2000 RAS" },
		Device { id: 0x1F15, name: "Atom processor C2000 SMBus 2.0" },
		Device { id: 0x1F16, name: "Atom processor C2000 RCEC" },
		Device { id: 0x1F18, name: "Atom processor C2000 QAT" },
		Device { id: 0x1F19, name: "Atom processor C2000 QAT" },
		Device { id: 0x1F20, name: "Atom processor C2000 4-Port IDE SATA2 Controller" },
		Device { id: 0x1F21, name: "Atom processor C2000 4-Port IDE SATA2 Controller" },
		Device { id: 0x1F22, name: "Atom processor C2000 AHCI SATA2 Controller" },
		Device { id: 0x1F23, name: "Atom processor C2000 AHCI SATA2 Controller" },
		Device { id: 0x1F24, name: "Atom processor C2000 RAID SATA2 Controller" },
		Device { id: 0x1F25, name: "Atom processor C2000 RAID SATA2 Controller" },
		Device { id: 0x1F26, name: "Atom processor C2000 RAID SATA2 Controller" },
		Device { id: 0x1F27, name: "Atom processor C2000 RAID SATA2 Controller" },
		Device { id: 0x1F2C, name: "Atom processor C2000 USB Enhanced Host Controller" },
		Device { id: 0x1F2E, name: "Atom processor C2000 RAID SATA2 Controller" },
		Device { id: 0x1F2F, name: "Atom processor C2000 RAID SATA2 Controller" },
		Device { id: 0x1F30, name: "Atom processor C2000 2-Port IDE SATA3 Controller" },
		Device { id: 0x1F31, name: "Atom processor C2000 2-Port IDE SATA3 Controller" },
		Device { id: 0x1F32, name: "Atom processor C2000 AHCI SATA3 Controller" },
		Device { id: 0x1F33, name: "Atom processor C2000 AHCI SATA3 Controller" },
		Device { id: 0x1F34, name: "Atom processor C2000 RAID SATA3 Controller" },
		Device { id: 0x1F35, name: "Atom processor C2000 RAID SATA3 Controller" },
		Device { id: 0x1F36, name: "Atom processor C2000 RAID SATA3 Controller" },
		Device { id: 0x1F37, name: "Atom processor C2000 RAID SATA3 Controller" },
		Device { id: 0x1F38, name: "Atom processor C2000 PCU" },
		Device { id: 0x1F39, name: "Atom processor C2000 PCU" },
		Device { id: 0x1F3A, name: "Atom processor C2000 PCU" },
		Device { id: 0x1F3B, name: "Atom processor C2000 PCU" },
		Device { id: 0x1F3C, name: "Atom processor C2000 PCU SMBus" },
		Device { id: 0x1F3E, name: "Atom processor C2000 RAID SATA3 Controller" },
		Device { id: 0x1F3F, name: "Atom processor C2000 RAID SATA3 Controller" },
		Device { id: 0x1F40, name: "Ethernet Connection I354 1.0 GbE Backplane" },
		Device { id: 0x1F41, name: "Ethernet Connection I354" },
		Device { id: 0x1F42, name: "Atom processor C2000 GbE" },
		Device { id: 0x1F44, name: "Atom processor C2000 GbE Virtual Function" },
		Device { id: 0x1F45, name: "Ethernet Connection I354 2.5 GbE Backplane" },
		Device { id: 0x2014, name: "Sky Lake-E Ubox Registers" },
		Device { id: 0x2015, name: "Sky Lake-E Ubox Registers" },
		Device { id: 0x2016, name: "Sky Lake-E Ubox Registers" },
		Device { id: 0x2018, name: "Sky Lake-E M2PCI Registers" },
		Device { id: 0x201A, name: "Sky Lake-E Non-Transparent Bridge Registers" },
		Device { id: 0x201C, name: "Sky Lake-E Non-Transparent Bridge Registers" },
		Device { id: 0x2020, name: "Sky Lake-E DMI3 Registers" },
		Device { id: 0x2021, name: "Sky Lake-E CBDMA Registers" },
		Device { id: 0x2024, name: "Sky Lake-E MM/Vt-d Configuration Registers" },
		Device { id: 0x2030, name: "Sky Lake-E PCI Express Root Port A" },
		Device { id: 0x2031, name: "Sky Lake-E PCI Express Root Port B" },
		Device { id: 0x2032, name: "Sky Lake-E PCI Express Root Port C" },
		Device { id: 0x2033, name: "Sky Lake-E PCI Express Root Port D" },
		Device { id: 0x2035, name: "Sky Lake-E RAS Configuration Registers" },
		Device { id: 0x204C, name: "Sky Lake-E M3KTI Registers" },
		Device { id: 0x204D, name: "Sky Lake-E M3KTI Registers" },
		Device { id: 0x204E, name: "Sky Lake-E M3KTI Registers" },
		Device { id: 0x2054, name: "Sky Lake-E CHA Registers" },
		Device { id: 0x2055, name: "Sky Lake-E CHA Registers" },
		Device { id: 0x2056, name: "Sky Lake-E CHA Registers" },
		Device { id: 0x2057, name: "Sky Lake-E CHA Registers" },
		Device { id: 0x2068, name: "Sky Lake-E DDRIO Registers" },
		Device { id: 0x2069, name: "Sky Lake-E DDRIO Registers" },
		Device { id: 0x206A, name: "Sky Lake-E IOxAPIC Configuration Registers" },
		Device { id: 0x206E, name: "Sky Lake-E DDRIO Registers" },
		Device { id: 0x206F, name: "Sky Lake-E DDRIO Registers" },
		Device { id: 0x2078, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x207A, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x2080, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x2081, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x2082, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x2083, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x2084, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x2085, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x2086, name: "Sky Lake-E PCU Registers" },
		Device { id: 0x208D, name: "Sky Lake-E CHA Registers" },
		Device { id: 0x208E, name: "Sky Lake-E CHA Registers" },
		Device { id: 0x2250, name: "Xeon Phi coprocessor 5100 series" },
		Device { id: 0x225C, name: "Xeon Phi coprocessor SE10/7120 series" },
		Device { id: 0x225D, name: "Xeon Phi coprocessor 3120 series " },
		Device { id: 0x225E, name: "Xeon Phi coprocessor 31S1" },
		Device { id: 0x2280, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SoC Transaction Register" },
		Device { id: 0x2284, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series High Definition Audio Controller" },
		Device { id: 0x2286, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 DMA Controller" },
		Device { id: 0x228A, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 HSUART Controller #1" },
		Device { id: 0x228C, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO1 HSUART Controller #2" },
		Device { id: 0x2292, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx SMBus Controller" },
		Device { id: 0x2294, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series MMC Controller" },
		Device { id: 0x2295, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SDIO Controller" },
		Device { id: 0x2296, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SD Controller" },
		Device { id: 0x2298, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Trusted Execution Engine" },
		Device { id: 0x229C, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCU" },
		Device { id: 0x22A3, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SATA Controller" },
		Device { id: 0x22A4, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series SATA AHCI Controller" },
		Device { id: 0x22A8, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Low Power Engine Audio" },
		Device { id: 0x22B0, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Configuration Registers" },
		Device { id: 0x22B1, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Integrated Graphics Controller" },
		Device { id: 0x22B5, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series USB xHCI Controller" },
		Device { id: 0x22B8, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Imaging Unit" },
		Device { id: 0x22C0, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 DMA Controller" },
		Device { id: 0x22C1, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #1" },
		Device { id: 0x22C2, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #2" },
		Device { id: 0x22C3, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #3" },
		Device { id: 0x22C4, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #4" },
		Device { id: 0x22C5, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #5" },
		Device { id: 0x22C6, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #6" },
		Device { id: 0x22C7, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series LPIO2 I2C Controller #7" },
		Device { id: 0x22C8, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #1" },
		Device { id: 0x22CA, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #2" },
		Device { id: 0x22CC, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #3" },
		Device { id: 0x22CE, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series PCI Express Port #4" },
		Device { id: 0x22DC, name: "Atom/Celeron/Pentium Processor x5-E8000/J3xxx/N3xxx Series Power Management Controller" },
		Device { id: 0x2310, name: "DH89xxCC LPC Controller" },
		Device { id: 0x2323, name: "DH89xxCC 4 Port SATA AHCI Controller" },
		Device { id: 0x2330, name: "DH89xxCC SMBus Controller" },
		Device { id: 0x2331, name: "DH89xxCC Chap Counter" },
		Device { id: 0x2332, name: "DH89xxCC Thermal Subsystem" },
		Device { id: 0x2334, name: "DH89xxCC USB2 Enhanced Host Controller #1" },
		Device { id: 0x2335, name: "DH89xxCC USB2 Enhanced Host Controller #1" },
		Device { id: 0x2342, name: "DH89xxCC PCI Express Root Port #1" },
		Device { id: 0x2343, name: "DH89xxCC PCI Express Root Port #1" },
		Device { id: 0x2344, name: "DH89xxCC PCI Express Root Port #2" },
		Device { id: 0x2345, name: "DH89xxCC PCI Express Root Port #2" },
		Device { id: 0x2346, name: "DH89xxCC PCI Express Root Port #3" },
		Device { id: 0x2347, name: "DH89xxCC PCI Express Root Port #3" },
		Device { id: 0x2348, name: "DH89xxCC PCI Express Root Port #4" },
		Device { id: 0x2349, name: "DH89xxCC PCI Express Root Port #4" },
		Device { id: 0x2360, name: "DH89xxCC Watchdog Timer" },
		Device { id: 0x2364, name: "DH89xxCC MEI 0" },
		Device { id: 0x2365, name: "DH89xxCC MEI 1" },
		Device { id: 0x2390, name: "DH895XCC Series LPC Controller" },
		Device { id: 0x23A1, name: "DH895XCC Series 2-Port SATA Controller [IDE Mode]" },
		Device { id: 0x23A3, name: "DH895XCC Series 4-Port SATA Controller [AHCI Mode]" },
		Device { id: 0x23A6, name: "DH895XCC Series 2-Port SATA Controller [IDE Mode]" },
		Device { id: 0x23B0, name: "DH895XCC Series SMBus Controller" },
		Device { id: 0x23B1, name: "DH895XCC Series CHAP Counter" },
		Device { id: 0x23B2, name: "DH895XCC Series Thermal Management Controller" },
		Device { id: 0x23B4, name: "DH895XCC Series USB2 Enhanced Host Controller #1" },
		Device { id: 0x23B5, name: "DH895XCC Series USB2 Enhanced Host Controller #1" },
		Device { id: 0x23C2, name: "DH895XCC Series PCI Express Root Port #1" },
		Device { id: 0x23C3, name: "DH895XCC Series PCI Express Root Port #1" },
		Device { id: 0x23C4, name: "DH895XCC Series PCI Express Root Port #2" },
		Device { id: 0x23C5, name: "DH895XCC Series PCI Express Root Port #2" },
		Device { id: 0x23C6, name: "CDH895XCC Series PCI Express Root Port #3" },
		Device { id: 0x23C7, name: "DH895XCC Series PCI Express Root Port #3" },
		Device { id: 0x23C8, name: "DH895XCC Series PCI Express Root Port #4" },
		Device { id: 0x23C9, name: "DH895XCC Series PCI Express Root Port #4" },
		Device { id: 0x23E0, name: "DH895XCC Series Watchdog Timer" },
		Device { id: 0x23E4, name: "DH895XCC Series MEI Controller #1" },
		Device { id: 0x23E5, name: "DH895XCC Series MEI Controller #2" },
		Device { id: 0x2410, name: "82801AA ISA Bridge (LPC)" },
		Device { id: 0x2411, name: "82801AA IDE Controller" },
		Device { id: 0x2412, name: "82801AA USB Controller" },
		Device { id: 0x2413, name: "82801AA SMBus Controller" },
		Device { id: 0x2415, name: "82801AA AC'97 Audio Controller" },
		Device { id: 0x2416, name: "82801AA AC'97 Modem Controller" },
		Device { id: 0x2418, name: "82801AA PCI Bridge" },
		Device { id: 0x2420, name: "82801AB ISA Bridge (LPC)" },
		Device { id: 0x2421, name: "82801AB IDE Controller" },
		Device { id: 0x2422, name: "82801AB USB Controller" },
		Device { id: 0x2423, name: "82801AB SMBus Controller" },
		Device { id: 0x2425, name: "82801AB AC'97 Audio Controller" },
		Device { id: 0x2426, name: "82801AB AC'97 Modem Controller" },
		Device { id: 0x2428, name: "82801AB PCI Bridge" },
		Device { id: 0x2440, name: "82801BA ISA Bridge (LPC)" },
		Device { id: 0x2442, name: "82801BA/BAM UHCI USB 1.1 Controller #1" },
		Device { id: 0x2443, name: "82801BA/BAM SMBus Controller" },
		Device { id: 0x2444, name: "82801BA/BAM UHCI USB 1.1 Controller #2" },
		Device { id: 0x2445, name: "82801BA/BAM AC'97 Audio Controller" },
		Device { id: 0x2446, name: "82801BA/BAM AC'97 Modem Controller" },
		Device { id: 0x2448, name: "82801 Mobile PCI Bridge" },
		Device { id: 0x2449, name: "82801BA/BAM/CA/CAM Ethernet Controller" },
		Device { id: 0x244A, name: "82801BAM IDE U100 Controller" },
		Device { id: 0x244B, name: "82801BA IDE U100 Controller" },
		Device { id: 0x244C, name: "82801BAM ISA Bridge (LPC)" },
		Device { id: 0x244E, name: "82801 PCI Bridge" },
		Device { id: 0x2450, name: "82801E ISA Bridge (LPC)" },
		Device { id: 0x2452, name: "82801E USB Controller" },
		Device { id: 0x2453, name: "82801E SMBus Controller" },
		Device { id: 0x2459, name: "82801E Ethernet Controller 0" },
		Device { id: 0x245B, name: "82801E IDE U100 Controller" },
		Device { id: 0x245D, name: "82801E Ethernet Controller 1" },
		Device { id: 0x245E, name: "82801E PCI Bridge" },
		Device { id: 0x2480, name: "82801CA LPC Interface Controller" },
		Device { id: 0x2482, name: "82801CA/CAM USB Controller #1" },
		Device { id: 0x2483, name: "82801CA/CAM SMBus Controller" },
		Device { id: 0x2484, name: "82801CA/CAM USB Controller #2" },
		Device { id: 0x2485, name: "82801CA/CAM AC'97 Audio Controller" },
		Device { id: 0x2486, name: "82801CA/CAM AC'97 Modem Controller" },
		Device { id: 0x2487, name: "82801CA/CAM USB Controller #3" },
		Device { id: 0x248A, name: "82801CAM IDE U100 Controller" },
		Device { id: 0x248B, name: "82801CA Ultra ATA Storage Controller" },
		Device { id: 0x248C, name: "82801CAM ISA Bridge (LPC)" },
		Device { id: 0x24C0, name: "82801DB/DBL (ICH4/ICH4-L) LPC Interface Bridge" },
		Device { id: 0x24C1, name: "82801DBL (ICH4-L) IDE Controller" },
		Device { id: 0x24C2, name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #1" },
		Device { id: 0x24C3, name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) SMBus Controller" },
		Device { id: 0x24C4, name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #2" },
		Device { id: 0x24C5, name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) AC'97 Audio Controller" },
		Device { id: 0x24C6, name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) AC'97 Modem Controller" },
		Device { id: 0x24C7, name: "82801DB/DBL/DBM (ICH4/ICH4-L/ICH4-M) USB UHCI Controller #3" },
		Device { id: 0x24CA, name: "82801DBM (ICH4-M) IDE Controller" },
		Device { id: 0x24CB, name: "82801DB (ICH4) IDE Controller" },
		Device { id: 0x24CC, name: "82801DBM (ICH4-M) LPC Interface Bridge" },
		Device { id: 0x24CD, name: "82801DB/DBM (ICH4/ICH4-M) USB2 EHCI Controller" },
		Device { id: 0x24D0, name: "82801EB/ER (ICH5/ICH5R) LPC Interface Bridge" },
		Device { id: 0x24D1, name: "82801EB (ICH5) SATA Controller" },
		Device { id: 0x24D2, name: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #1" },
		Device { id: 0x24D3, name: "82801EB/ER (ICH5/ICH5R) SMBus Controller" },
		Device { id: 0x24D4, name: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #2" },
		Device { id: 0x24D5, name: "82801EB/ER (ICH5/ICH5R) AC'97 Audio Controller" },
		Device { id: 0x24D6, name: "82801EB/ER (ICH5/ICH5R) AC'97 Modem Controller" },
		Device { id: 0x24D7, name: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #3" },
		Device { id: 0x24DB, name: "82801EB/ER (ICH5/ICH5R) IDE Controller" },
		Device { id: 0x24DC, name: "82801EB (ICH5) LPC Interface Bridge" },
		Device { id: 0x24DD, name: "82801EB/ER (ICH5/ICH5R) USB2 EHCI Controller" },
		Device { id: 0x24DE, name: "82801EB/ER (ICH5/ICH5R) USB UHCI Controller #4" },
		Device { id: 0x24DF, name: "82801ER (ICH5R) SATA Controller" },
		Device { id: 0x24F0, name: "Omni-Path HFI Silicon 100 Series [discrete]" },
		Device { id: 0x24F1, name: "Omni-Path HFI Silicon 100 Series [integrated]" },
		Device { id: 0x24F3, name: "Wireless 8260" },
		Device { id: 0x24F4, name: "Wireless 8260" },
		Device { id: 0x24FD, name: "Wireless 8265 / 8275" },
		Device { id: 0x2500, name: "82820 820 (Camino) Chipset Host Bridge (MCH)" },
		Device { id: 0x2501, name: "82820 820 (Camino) Chipset Host Bridge (MCH)" },
		Device { id: 0x250B, name: "82820 820 (Camino) Chipset Host Bridge" },
		Device { id: 0x250F, name: "82820 820 (Camino) Chipset AGP Bridge" },
		Device { id: 0x2520, name: "82805AA MTH Memory Translator Hub" },
		Device { id: 0x2521, name: "82804AA MRH-S Memory Repeater Hub for SDRAM" },
		Device { id: 0x2530, name: "82850 850 (Tehama) Chipset Host Bridge (MCH)" },
		Device { id: 0x2531, name: "82860 860 (Wombat) Chipset Host Bridge (MCH)" },
		Device { id: 0x2532, name: "82850 850 (Tehama) Chipset AGP Bridge" },
		Device { id: 0x2533, name: "82860 860 (Wombat) Chipset AGP Bridge" },
		Device { id: 0x2534, name: "82860 860 (Wombat) Chipset PCI Bridge" },
		Device { id: 0x2540, name: "E7500 Memory Controller Hub" },
		Device { id: 0x2541, name: "E7500/E7501 Host RASUM Controller" },
		Device { id: 0x2543, name: "E7500/E7501 Hub Interface B PCI-to-PCI Bridge" },
		Device { id: 0x2544, name: "E7500/E7501 Hub Interface B RASUM Controller" },
		Device { id: 0x2545, name: "E7500/E7501 Hub Interface C PCI-to-PCI Bridge" },
		Device { id: 0x2546, name: "E7500/E7501 Hub Interface C RASUM Controller" },
		Device { id: 0x2547, name: "E7500/E7501 Hub Interface D PCI-to-PCI Bridge" },
		Device { id: 0x2548, name: "E7500/E7501 Hub Interface D RASUM Controller" },
		Device { id: 0x254C, name: "E7501 Memory Controller Hub" },
		Device { id: 0x2550, name: "E7505 Memory Controller Hub" },
		Device { id: 0x2551, name: "E7505/E7205 Series RAS Controller" },
		Device { id: 0x2552, name: "E7505/E7205 PCI-to-AGP Bridge" },
		Device { id: 0x2553, name: "E7505 Hub Interface B PCI-to-PCI Bridge" },
		Device { id: 0x2554, name: "E7505 Hub Interface B PCI-to-PCI Bridge RAS Controller" },
		Device { id: 0x255D, name: "E7205 Memory Controller Hub" },
		Device { id: 0x2560, name: "82845G/GL[Brookdale-G]/GE/PE DRAM Controller/Host-Hub Interface" },
		Device { id: 0x2561, name: "82845G/GL[Brookdale-G]/GE/PE Host-to-AGP Bridge" },
		Device { id: 0x2562, name: "82845G/GL[Brookdale-G]/GE Chipset Integrated Graphics Device" },
		Device { id: 0x2570, name: "82865G/PE/P DRAM Controller/Host-Hub Interface" },
		Device { id: 0x2571, name: "82865G/PE/P AGP Bridge" },
		Device { id: 0x2572, name: "82865G Integrated Graphics Controller" },
		Device { id: 0x2573, name: "82865G/PE/P PCI to CSA Bridge" },
		Device { id: 0x2576, name: "82865G/PE/P Processor to I/O Memory Interface" },
		Device { id: 0x2578, name: "82875P/E7210 Memory Controller Hub" },
		Device { id: 0x2579, name: "82875P Processor to AGP Controller" },
		Device { id: 0x257B, name: "82875P/E7210 Processor to PCI to CSA Bridge" },
		Device { id: 0x257E, name: "82875P/E7210 Processor to I/O Memory Interface" },
		Device { id: 0x2580, name: "82915G/P/GV/GL/PL/910GL Memory Controller Hub" },
		Device { id: 0x2581, name: "82915G/P/GV/GL/PL/910GL PCI Express Root Port" },
		Device { id: 0x2582, name: "82915G/GV/910GL Integrated Graphics Controller" },
		Device { id: 0x2584, name: "82925X/XE Memory Controller Hub" },
		Device { id: 0x2585, name: "82925X/XE PCI Express Root Port" },
		Device { id: 0x2588, name: "E7220/E7221 Memory Controller Hub" },
		Device { id: 0x2589, name: "E7220/E7221 PCI Express Root Port" },
		Device { id: 0x258A, name: "E7221 Integrated Graphics Controller" },
		Device { id: 0x2590, name: "Mobile 915GM/PM/GMS/910GML Express Processor to DRAM Controller" },
		Device { id: 0x2591, name: "Mobile 915GM/PM Express PCI Express Root Port" },
		Device { id: 0x2592, name: "Mobile 915GM/GMS/910GML Express Graphics Controller" },
		Device { id: 0x25A1, name: "6300ESB LPC Interface Controller" },
		Device { id: 0x25A2, name: "6300ESB PATA Storage Controller" },
		Device { id: 0x25A3, name: "6300ESB SATA Storage Controller" },
		Device { id: 0x25A4, name: "6300ESB SMBus Controller" },
		Device { id: 0x25A6, name: "6300ESB AC'97 Audio Controller" },
		Device { id: 0x25A7, name: "6300ESB AC'97 Modem Controller" },
		Device { id: 0x25A9, name: "6300ESB USB Universal Host Controller" },
		Device { id: 0x25AA, name: "6300ESB USB Universal Host Controller" },
		Device { id: 0x25AB, name: "6300ESB Watchdog Timer" },
		Device { id: 0x25AC, name: "6300ESB I/O Advanced Programmable Interrupt Controller" },
		Device { id: 0x25AD, name: "6300ESB USB2 Enhanced Host Controller" },
		Device { id: 0x25AE, name: "6300ESB 64-bit PCI-X Bridge" },
		Device { id: 0x25B0, name: "6300ESB SATA RAID Controller" },
		Device { id: 0x25C0, name: "5000X Chipset Memory Controller Hub" },
		Device { id: 0x25D0, name: "5000Z Chipset Memory Controller Hub" },
		Device { id: 0x25D4, name: "5000V Chipset Memory Controller Hub" },
		Device { id: 0x25D8, name: "5000P Chipset Memory Controller Hub" },
		Device { id: 0x25E2, name: "5000 Series Chipset PCI Express x4 Port 2" },
		Device { id: 0x25E3, name: "5000 Series Chipset PCI Express x4 Port 3" },
		Device { id: 0x25E4, name: "5000 Series Chipset PCI Express x4 Port 4" },
		Device { id: 0x25E5, name: "5000 Series Chipset PCI Express x4 Port 5" },
		Device { id: 0x25E6, name: "5000 Series Chipset PCI Express x4 Port 6" },
		Device { id: 0x25E7, name: "5000 Series Chipset PCI Express x4 Port 7" },
		Device { id: 0x25F0, name: "5000 Series Chipset FSB Registers" },
		Device { id: 0x25F1, name: "5000 Series Chipset Reserved Registers" },
		Device { id: 0x25F3, name: "5000 Series Chipset Reserved Registers" },
		Device { id: 0x25F5, name: "5000 Series Chipset FBD Registers" },
		Device { id: 0x25F6, name: "5000 Series Chipset FBD Registers" },
		Device { id: 0x25F7, name: "5000 Series Chipset PCI Express x8 Port 2-3" },
		Device { id: 0x25F8, name: "5000 Series Chipset PCI Express x8 Port 4-5" },
		Device { id: 0x25F9, name: "5000 Series Chipset PCI Express x8 Port 6-7" },
		Device { id: 0x25FA, name: "5000X Chipset PCI Express x16 Port 4-7" },
		Device { id: 0x2600, name: "E8500/E8501 Hub Interface 1.5" },
		Device { id: 0x2601, name: "E8500/E8501 PCI Express x4 Port D" },
		Device { id: 0x2602, name: "E8500/E8501 PCI Express x4 Port C0" },
		Device { id: 0x2603, name: "E8500/E8501 PCI Express x4 Port C1" },
		Device { id: 0x2604, name: "E8500/E8501 PCI Express x4 Port B0" },
		Device { id: 0x2605, name: "E8500/E8501 PCI Express x4 Port B1" },
		Device { id: 0x2606, name: "E8500/E8501 PCI Express x4 Port A0" },
		Device { id: 0x2607, name: "E8500/E8501 PCI Express x4 Port A1" },
		Device { id: 0x2608, name: "E8500/E8501 PCI Express x8 Port C" },
		Device { id: 0x2609, name: "E8500/E8501 PCI Express x8 Port B" },
		Device { id: 0x260A, name: "E8500/E8501 PCI Express x8 Port A" },
		Device { id: 0x260C, name: "E8500/E8501 IMI Registers" },
		Device { id: 0x2610, name: "E8500/E8501 FSB Registers" },
		Device { id: 0x2611, name: "E8500/E8501 Address Mapping Registers" },
		Device { id: 0x2612, name: "E8500/E8501 RAS Registers" },
		Device { id: 0x2613, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x2614, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x2615, name: "E8500/E8501 Miscellaneous Registers" },
		Device { id: 0x2617, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x2618, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x2619, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x261A, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x261B, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x261C, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x261D, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x261E, name: "E8500/E8501 Reserved Registers" },
		Device { id: 0x2620, name: "E8500/E8501 eXternal Memory Bridge" },
		Device { id: 0x2621, name: "E8500/E8501 XMB Miscellaneous Registers" },
		Device { id: 0x2622, name: "E8500/E8501 XMB Memory Interleaving Registers" },
		Device { id: 0x2623, name: "E8500/E8501 XMB DDR Initialization and Calibration" },
		Device { id: 0x2624, name: "E8500/E8501 XMB Reserved Registers" },
		Device { id: 0x2625, name: "E8500/E8501 XMB Reserved Registers" },
		Device { id: 0x2626, name: "E8500/E8501 XMB Reserved Registers" },
		Device { id: 0x2627, name: "E8500/E8501 XMB Reserved Registers" },
		Device { id: 0x2640, name: "82801FB/FR (ICH6/ICH6R) LPC Interface Bridge" },
		Device { id: 0x2641, name: "82801FBM (ICH6M) LPC Interface Bridge" },
		Device { id: 0x2642, name: "82801FW/FRW (ICH6W/ICH6RW) LPC Interface Bridge" },
		Device { id: 0x2651, name: "82801FB/FW (ICH6/ICH6W) SATA Controller" },
		Device { id: 0x2652, name: "82801FR/FRW (ICH6R/ICH6RW) SATA Controller" },
		Device { id: 0x2653, name: "82801FBM (ICH6M) SATA Controller" },
		Device { id: 0x2658, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #1" },
		Device { id: 0x2659, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #2" },
		Device { id: 0x265A, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #3" },
		Device { id: 0x265B, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB UHCI #4" },
		Device { id: 0x265C, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) USB2 EHCI Controller" },
		Device { id: 0x2660, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 1" },
		Device { id: 0x2662, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 2" },
		Device { id: 0x2664, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 3" },
		Device { id: 0x2666, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) PCI Express Port 4" },
		Device { id: 0x2668, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) High Definition Audio Controller" },
		Device { id: 0x266A, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) SMBus Controller" },
		Device { id: 0x266C, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) LAN Controller" },
		Device { id: 0x266D, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) AC'97 Modem Controller" },
		Device { id: 0x266E, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) AC'97 Audio Controller" },
		Device { id: 0x266F, name: "82801FB/FBM/FR/FW/FRW (ICH6 Family) IDE Controller" },
		Device { id: 0x2670, name: "631xESB/632xESB/3100 Chipset LPC Interface Controller" },
		Device { id: 0x2680, name: "631xESB/632xESB/3100 Chipset SATA IDE Controller" },
		Device { id: 0x2681, name: "631xESB/632xESB SATA AHCI Controller" },
		Device { id: 0x2682, name: "631xESB/632xESB SATA RAID Controller" },
		Device { id: 0x2683, name: "631xESB/632xESB SATA RAID Controller" },
		Device { id: 0x2688, name: "631xESB/632xESB/3100 Chipset UHCI USB Controller #1" },
		Device { id: 0x2689, name: "631xESB/632xESB/3100 Chipset UHCI USB Controller #2" },
		Device { id: 0x268A, name: "631xESB/632xESB/3100 Chipset UHCI USB Controller #3" },
		Device { id: 0x268B, name: "631xESB/632xESB/3100 Chipset UHCI USB Controller #4" },
		Device { id: 0x268C, name: "631xESB/632xESB/3100 Chipset EHCI USB2 Controller" },
		Device { id: 0x2690, name: "631xESB/632xESB/3100 Chipset PCI Express Root Port 1" },
		Device { id: 0x2692, name: "631xESB/632xESB/3100 Chipset PCI Express Root Port 2" },
		Device { id: 0x2694, name: "631xESB/632xESB/3100 Chipset PCI Express Root Port 3" },
		Device { id: 0x2696, name: "631xESB/632xESB/3100 Chipset PCI Express Root Port 4" },
		Device { id: 0x2698, name: "631xESB/632xESB AC '97 Audio Controller" },
		Device { id: 0x2699, name: "631xESB/632xESB AC '97 Modem Controller" },
		Device { id: 0x269A, name: "631xESB/632xESB High Definition Audio Controller" },
		Device { id: 0x269B, name: "631xESB/632xESB/3100 Chipset SMBus Controller" },
		Device { id: 0x269E, name: "631xESB/632xESB IDE Controller" },
		Device { id: 0x2770, name: "82945G/GZ/P/PL Memory Controller Hub" },
		Device { id: 0x2771, name: "82945G/GZ/P/PL PCI Express Root Port" },
		Device { id: 0x2772, name: "82945G/GZ Integrated Graphics Controller" },
		Device { id: 0x2774, name: "82955X Memory Controller Hub" },
		Device { id: 0x2775, name: "82955X PCI Express Root Port" },
		Device { id: 0x2776, name: "82945G/GZ Integrated Graphics Controller" },
		Device { id: 0x2778, name: "E7230/3000/3010 Memory Controller Hub" },
		Device { id: 0x2779, name: "E7230/3000/3010 PCI Express Root Port" },
		Device { id: 0x277A, name: "82975X/3010 PCI Express Root Port" },
		Device { id: 0x277C, name: "82975X Memory Controller Hub" },
		Device { id: 0x277D, name: "82975X PCI Express Root Port" },
		Device { id: 0x2782, name: "82915G Integrated Graphics Controller" },
		Device { id: 0x2792, name: "Mobile 915GM/GMS/910GML Express Graphics Controller" },
		Device { id: 0x27A0, name: "Mobile 945GM/PM/GMS, 943/940GML and 945GT Express Memory Controller Hub" },
		Device { id: 0x27A1, name: "Mobile 945GM/PM/GMS, 943/940GML and 945GT Express PCI Express Root Port" },
		Device { id: 0x27A2, name: "Mobile 945GM/GMS, 943/940GML Express Integrated Graphics Controller" },
		Device { id: 0x27A6, name: "Mobile 945GM/GMS/GME, 943/940GML Express Integrated Graphics Controller" },
		Device { id: 0x27AC, name: "Mobile 945GSE Express Memory Controller Hub" },
		Device { id: 0x27AD, name: "Mobile 945GSE Express PCI Express Root Port" },
		Device { id: 0x27AE, name: "Mobile 945GSE Express Integrated Graphics Controller" },
		Device { id: 0x27B0, name: "82801GH (ICH7DH) LPC Interface Bridge" },
		Device { id: 0x27B8, name: "82801GB/GR (ICH7 Family) LPC Interface Bridge" },
		Device { id: 0x27B9, name: "82801GBM (ICH7-M) LPC Interface Bridge" },
		Device { id: 0x27BC, name: "NM10 Family LPC Controller" },
		Device { id: 0x27BD, name: "82801GHM (ICH7-M DH) LPC Interface Bridge" },
		Device { id: 0x27C0, name: "NM10/ICH7 Family SATA Controller [IDE mode]" },
		Device { id: 0x27C1, name: "NM10/ICH7 Family SATA Controller [AHCI mode]" },
		Device { id: 0x27C3, name: "82801GR/GDH (ICH7R/ICH7DH) SATA Controller [RAID mode]" },
		Device { id: 0x27C4, name: "82801GBM/GHM (ICH7-M Family) SATA Controller [IDE mode]" },
		Device { id: 0x27C5, name: "82801GBM/GHM (ICH7-M Family) SATA Controller [AHCI mode]" },
		Device { id: 0x27C6, name: "82801GHM (ICH7-M DH) SATA Controller [RAID mode]" },
		Device { id: 0x27C8, name: "NM10/ICH7 Family USB UHCI Controller #1" },
		Device { id: 0x27C9, name: "NM10/ICH7 Family USB UHCI Controller #2" },
		Device { id: 0x27CA, name: "NM10/ICH7 Family USB UHCI Controller #3" },
		Device { id: 0x27CB, name: "NM10/ICH7 Family USB UHCI Controller #4" },
		Device { id: 0x27CC, name: "NM10/ICH7 Family USB2 EHCI Controller" },
		Device { id: 0x27D0, name: "NM10/ICH7 Family PCI Express Port 1" },
		Device { id: 0x27D2, name: "NM10/ICH7 Family PCI Express Port 2" },
		Device { id: 0x27D4, name: "NM10/ICH7 Family PCI Express Port 3" },
		Device { id: 0x27D6, name: "NM10/ICH7 Family PCI Express Port 4" },
		Device { id: 0x27D8, name: "NM10/ICH7 Family High Definition Audio Controller" },
		Device { id: 0x27DA, name: "NM10/ICH7 Family SMBus Controller" },
		Device { id: 0x27DC, name: "NM10/ICH7 Family LAN Controller" },
		Device { id: 0x27DD, name: "82801G (ICH7 Family) AC'97 Modem Controller" },
		Device { id: 0x27DE, name: "82801G (ICH7 Family) AC'97 Audio Controller" },
		Device { id: 0x27DF, name: "82801G (ICH7 Family) IDE Controller" },
		Device { id: 0x27E0, name: "82801GR/GH/GHM (ICH7 Family) PCI Express Port 5" },
		Device { id: 0x27E2, name: "82801GR/GH/GHM (ICH7 Family) PCI Express Port 6" },
		Device { id: 0x2810, name: "82801HB/HR (ICH8/R) LPC Interface Controller" },
		Device { id: 0x2811, name: "82801HEM (ICH8M-E) LPC Interface Controller" },
		Device { id: 0x2812, name: "82801HH (ICH8DH) LPC Interface Controller" },
		Device { id: 0x2814, name: "82801HO (ICH8DO) LPC Interface Controller" },
		Device { id: 0x2815, name: "82801HM (ICH8M) LPC Interface Controller" },
		Device { id: 0x2820, name: "82801H (ICH8 Family) 4 port SATA Controller [IDE mode]" },
		Device { id: 0x2821, name: "82801HR/HO/HH (ICH8R/DO/DH) 6 port SATA Controller [AHCI mode]" },
		Device { id: 0x2822, name: "SATA Controller [RAID mode]" },
		Device { id: 0x2823, name: "C610/X99 series chipset sSATA Controller [RAID mode]" },
		Device { id: 0x2824, name: "82801HB (ICH8) 4 port SATA Controller [AHCI mode]" },
		Device { id: 0x2825, name: "82801HR/HO/HH (ICH8R/DO/DH) 2 port SATA Controller [IDE mode]" },
		Device { id: 0x2826, name: "C600/X79 series chipset SATA RAID Controller" },
		Device { id: 0x2827, name: "C610/X99 series chipset sSATA Controller [RAID mode]" },
		Device { id: 0x2828, name: "82801HM/HEM (ICH8M/ICH8M-E) SATA Controller [IDE mode]" },
		Device { id: 0x2829, name: "82801HM/HEM (ICH8M/ICH8M-E) SATA Controller [AHCI mode]" },
		Device { id: 0x282A, name: "82801 Mobile SATA Controller [RAID mode]" },
		Device { id: 0x2830, name: "82801H (ICH8 Family) USB UHCI Controller #1" },
		Device { id: 0x2831, name: "82801H (ICH8 Family) USB UHCI Controller #2" },
		Device { id: 0x2832, name: "82801H (ICH8 Family) USB UHCI Controller #3" },
		Device { id: 0x2833, name: "82801H (ICH8 Family) USB UHCI Controller #4" },
		Device { id: 0x2834, name: "82801H (ICH8 Family) USB UHCI Controller #4" },
		Device { id: 0x2835, name: "82801H (ICH8 Family) USB UHCI Controller #5" },
		Device { id: 0x2836, name: "82801H (ICH8 Family) USB2 EHCI Controller #1" },
		Device { id: 0x283A, name: "82801H (ICH8 Family) USB2 EHCI Controller #2" },
		Device { id: 0x283E, name: "82801H (ICH8 Family) SMBus Controller" },
		Device { id: 0x283F, name: "82801H (ICH8 Family) PCI Express Port 1" },
		Device { id: 0x2841, name: "82801H (ICH8 Family) PCI Express Port 2" },
		Device { id: 0x2843, name: "82801H (ICH8 Family) PCI Express Port 3" },
		Device { id: 0x2845, name: "82801H (ICH8 Family) PCI Express Port 4" },
		Device { id: 0x2847, name: "82801H (ICH8 Family) PCI Express Port 5" },
		Device { id: 0x2849, name: "82801H (ICH8 Family) PCI Express Port 6" },
		Device { id: 0x284B, name: "82801H (ICH8 Family) HD Audio Controller" },
		Device { id: 0x284F, name: "82801H (ICH8 Family) Thermal Reporting Device" },
		Device { id: 0x2850, name: "82801HM/HEM (ICH8M/ICH8M-E) IDE Controller" },
		Device { id: 0x2912, name: "82801IH (ICH9DH) LPC Interface Controller" },
		Device { id: 0x2914, name: "82801IO (ICH9DO) LPC Interface Controller" },
		Device { id: 0x2916, name: "82801IR (ICH9R) LPC Interface Controller" },
		Device { id: 0x2917, name: "ICH9M-E LPC Interface Controller" },
		Device { id: 0x2918, name: "82801IB (ICH9) LPC Interface Controller" },
		Device { id: 0x2919, name: "ICH9M LPC Interface Controller" },
		Device { id: 0x2920, name: "82801IR/IO/IH (ICH9R/DO/DH) 4 port SATA Controller [IDE mode]" },
		Device { id: 0x2921, name: "82801IB (ICH9) 2 port SATA Controller [IDE mode]" },
		Device { id: 0x2922, name: "82801IR/IO/IH (ICH9R/DO/DH) 6 port SATA Controller [AHCI mode]" },
		Device { id: 0x2923, name: "82801IB (ICH9) 4 port SATA Controller [AHCI mode]" },
		Device { id: 0x2925, name: "82801IR/IO (ICH9R/DO) SATA Controller [RAID mode]" },
		Device { id: 0x2926, name: "82801I (ICH9 Family) 2 port SATA Controller [IDE mode]" },
		Device { id: 0x2928, name: "82801IBM/IEM (ICH9M/ICH9M-E) 2 port SATA Controller [IDE mode]" },
		Device { id: 0x2929, name: "82801IBM/IEM (ICH9M/ICH9M-E) 4 port SATA Controller [AHCI mode]" },
		Device { id: 0x292C, name: "82801IEM (ICH9M-E) SATA Controller [RAID mode]" },
		Device { id: 0x292D, name: "82801IBM/IEM (ICH9M/ICH9M-E) 2 port SATA Controller [IDE mode]" },
		Device { id: 0x2930, name: "82801I (ICH9 Family) SMBus Controller" },
		Device { id: 0x2932, name: "82801I (ICH9 Family) Thermal Subsystem" },
		Device { id: 0x2934, name: "82801I (ICH9 Family) USB UHCI Controller #1" },
		Device { id: 0x2935, name: "82801I (ICH9 Family) USB UHCI Controller #2" },
		Device { id: 0x2936, name: "82801I (ICH9 Family) USB UHCI Controller #3" },
		Device { id: 0x2937, name: "82801I (ICH9 Family) USB UHCI Controller #4" },
		Device { id: 0x2938, name: "82801I (ICH9 Family) USB UHCI Controller #5" },
		Device { id: 0x2939, name: "82801I (ICH9 Family) USB UHCI Controller #6" },
		Device { id: 0x293A, name: "82801I (ICH9 Family) USB2 EHCI Controller #1" },
		Device { id: 0x293C, name: "82801I (ICH9 Family) USB2 EHCI Controller #2" },
		Device { id: 0x293E, name: "82801I (ICH9 Family) HD Audio Controller" },
		Device { id: 0x2940, name: "82801I (ICH9 Family) PCI Express Port 1" },
		Device { id: 0x2942, name: "82801I (ICH9 Family) PCI Express Port 2" },
		Device { id: 0x2944, name: "82801I (ICH9 Family) PCI Express Port 3" },
		Device { id: 0x2946, name: "82801I (ICH9 Family) PCI Express Port 4" },
		Device { id: 0x2948, name: "82801I (ICH9 Family) PCI Express Port 5" },
		Device { id: 0x294A, name: "82801I (ICH9 Family) PCI Express Port 6" },
		Device { id: 0x294C, name: "82566DC-2 Gigabit Network Connection" },
		Device { id: 0x2970, name: "82946GZ/PL/GL Memory Controller Hub" },
		Device { id: 0x2971, name: "82946GZ/PL/GL PCI Express Root Port" },
		Device { id: 0x2972, name: "82946GZ/GL Integrated Graphics Controller" },
		Device { id: 0x2973, name: "82946GZ/GL Integrated Graphics Controller" },
		Device { id: 0x2974, name: "82946GZ/GL HECI Controller" },
		Device { id: 0x2975, name: "82946GZ/GL HECI Controller" },
		Device { id: 0x2976, name: "82946GZ/GL PT IDER Controller" },
		Device { id: 0x2977, name: "82946GZ/GL KT Controller" },
		Device { id: 0x2980, name: "82G35 Express DRAM Controller" },
		Device { id: 0x2981, name: "82G35 Express PCI Express Root Port" },
		Device { id: 0x2982, name: "82G35 Express Integrated Graphics Controller" },
		Device { id: 0x2983, name: "82G35 Express Integrated Graphics Controller" },
		Device { id: 0x2984, name: "82G35 Express HECI Controller" },
		Device { id: 0x2990, name: "82Q963/Q965 Memory Controller Hub" },
		Device { id: 0x2991, name: "82Q963/Q965 PCI Express Root Port" },
		Device { id: 0x2992, name: "82Q963/Q965 Integrated Graphics Controller" },
		Device { id: 0x2993, name: "82Q963/Q965 Integrated Graphics Controller" },
		Device { id: 0x2994, name: "82Q963/Q965 HECI Controller" },
		Device { id: 0x2995, name: "82Q963/Q965 HECI Controller" },
		Device { id: 0x2996, name: "82Q963/Q965 PT IDER Controller" },
		Device { id: 0x2997, name: "82Q963/Q965 KT Controller" },
		Device { id: 0x29A0, name: "82P965/G965 Memory Controller Hub" },
		Device { id: 0x29A1, name: "82P965/G965 PCI Express Root Port" },
		Device { id: 0x29A2, name: "82G965 Integrated Graphics Controller" },
		Device { id: 0x29A3, name: "82G965 Integrated Graphics Controller" },
		Device { id: 0x29A4, name: "82P965/G965 HECI Controller" },
		Device { id: 0x29A5, name: "82P965/G965 HECI Controller" },
		Device { id: 0x29A6, name: "82P965/G965 PT IDER Controller" },
		Device { id: 0x29A7, name: "82P965/G965 KT Controller" },
		Device { id: 0x29B0, name: "82Q35 Express DRAM Controller" },
		Device { id: 0x29B1, name: "82Q35 Express PCI Express Root Port" },
		Device { id: 0x29B2, name: "82Q35 Express Integrated Graphics Controller" },
		Device { id: 0x29B3, name: "82Q35 Express Integrated Graphics Controller" },
		Device { id: 0x29B4, name: "82Q35 Express MEI Controller" },
		Device { id: 0x29B5, name: "82Q35 Express MEI Controller" },
		Device { id: 0x29B6, name: "82Q35 Express PT IDER Controller" },
		Device { id: 0x29B7, name: "82Q35 Express Serial KT Controller" },
		Device { id: 0x29C0, name: "82G33/G31/P35/P31 Express DRAM Controller" },
		Device { id: 0x29C1, name: "82G33/G31/P35/P31 Express PCI Express Root Port" },
		Device { id: 0x29C2, name: "82G33/G31 Express Integrated Graphics Controller" },
		Device { id: 0x29C3, name: "82G33/G31 Express Integrated Graphics Controller" },
		Device { id: 0x29C4, name: "82G33/G31/P35/P31 Express MEI Controller" },
		Device { id: 0x29C5, name: "82G33/G31/P35/P31 Express MEI Controller" },
		Device { id: 0x29C6, name: "82G33/G31/P35/P31 Express PT IDER Controller" },
		Device { id: 0x29C7, name: "82G33/G31/P35/P31 Express Serial KT Controller" },
		Device { id: 0x29CF, name: "Virtual HECI Controller" },
		Device { id: 0x29D0, name: "82Q33 Express DRAM Controller" },
		Device { id: 0x29D1, name: "82Q33 Express PCI Express Root Port" },
		Device { id: 0x29D2, name: "82Q33 Express Integrated Graphics Controller" },
		Device { id: 0x29D3, name: "82Q33 Express Integrated Graphics Controller" },
		Device { id: 0x29D4, name: "82Q33 Express MEI Controller" },
		Device { id: 0x29D5, name: "82Q33 Express MEI Controller" },
		Device { id: 0x29D6, name: "82Q33 Express PT IDER Controller" },
		Device { id: 0x29D7, name: "82Q33 Express Serial KT Controller" },
		Device { id: 0x29E0, name: "82X38/X48 Express DRAM Controller" },
		Device { id: 0x29E1, name: "82X38/X48 Express Host-Primary PCI Express Bridge" },
		Device { id: 0x29E4, name: "82X38/X48 Express MEI Controller" },
		Device { id: 0x29E5, name: "82X38/X48 Express MEI Controller" },
		Device { id: 0x29E6, name: "82X38/X48 Express PT IDER Controller" },
		Device { id: 0x29E7, name: "82X38/X48 Express Serial KT Controller" },
		Device { id: 0x29E9, name: "82X38/X48 Express Host-Secondary PCI Express Bridge" },
		Device { id: 0x29F0, name: "3200/3210 Chipset DRAM Controller" },
		Device { id: 0x29F1, name: "3200/3210 Chipset Host-Primary PCI Express Bridge" },
		Device { id: 0x29F4, name: "3200/3210 Chipset MEI Controller" },
		Device { id: 0x29F5, name: "3200/3210 Chipset MEI Controller" },
		Device { id: 0x29F6, name: "3200/3210 Chipset PT IDER Controller" },
		Device { id: 0x29F7, name: "3200/3210 Chipset Serial KT Controller" },
		Device { id: 0x29F9, name: "3210 Chipset Host-Secondary PCI Express Bridge" },
		Device { id: 0x2A00, name: "Mobile PM965/GM965/GL960 Memory Controller Hub" },
		Device { id: 0x2A01, name: "Mobile PM965/GM965/GL960 PCI Express Root Port" },
		Device { id: 0x2A02, name: "Mobile GM965/GL960 Integrated Graphics Controller (primary)" },
		Device { id: 0x2A03, name: "Mobile GM965/GL960 Integrated Graphics Controller (secondary)" },
		Device { id: 0x2A04, name: "Mobile PM965/GM965 MEI Controller" },
		Device { id: 0x2A05, name: "Mobile PM965/GM965 MEI Controller" },
		Device { id: 0x2A06, name: "Mobile PM965/GM965 PT IDER Controller" },
		Device { id: 0x2A07, name: "Mobile PM965/GM965 KT Controller" },
		Device { id: 0x2A10, name: "Mobile GME965/GLE960 Memory Controller Hub" },
		Device { id: 0x2A11, name: "Mobile GME965/GLE960 PCI Express Root Port" },
		Device { id: 0x2A12, name: "Mobile GME965/GLE960 Integrated Graphics Controller" },
		Device { id: 0x2A13, name: "Mobile GME965/GLE960 Integrated Graphics Controller" },
		Device { id: 0x2A14, name: "Mobile GME965/GLE960 MEI Controller" },
		Device { id: 0x2A15, name: "Mobile GME965/GLE960 MEI Controller" },
		Device { id: 0x2A16, name: "Mobile GME965/GLE960 PT IDER Controller" },
		Device { id: 0x2A17, name: "Mobile GME965/GLE960 KT Controller" },
		Device { id: 0x2A40, name: "Mobile 4 Series Chipset Memory Controller Hub" },
		Device { id: 0x2A41, name: "Mobile 4 Series Chipset PCI Express Graphics Port" },
		Device { id: 0x2A42, name: "Mobile 4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2A43, name: "Mobile 4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2A44, name: "Mobile 4 Series Chipset MEI Controller" },
		Device { id: 0x2A45, name: "Mobile 4 Series Chipset MEI Controller" },
		Device { id: 0x2A46, name: "Mobile 4 Series Chipset PT IDER Controller" },
		Device { id: 0x2A47, name: "Mobile 4 Series Chipset AMT SOL Redirection" },
		Device { id: 0x2A50, name: "Cantiga MEI Controller" },
		Device { id: 0x2A51, name: "Cantiga MEI Controller" },
		Device { id: 0x2A52, name: "Cantiga PT IDER Controller" },
		Device { id: 0x2A53, name: "Cantiga AMT SOL Redirection" },
		Device { id: 0x2B00, name: "Xeon Processor E7 Product Family System Configuration Controller 1" },
		Device { id: 0x2B02, name: "Xeon Processor E7 Product Family System Configuration Controller 2" },
		Device { id: 0x2B04, name: "Xeon Processor E7 Product Family Power Controller" },
		Device { id: 0x2B08, name: "Xeon Processor E7 Product Family Caching Agent 0" },
		Device { id: 0x2B0C, name: "Xeon Processor E7 Product Family Caching Agent 1" },
		Device { id: 0x2B10, name: "Xeon Processor E7 Product Family QPI Home Agent 0" },
		Device { id: 0x2B13, name: "Xeon Processor E7 Product Family Memory Controller 0c" },
		Device { id: 0x2B14, name: "Xeon Processor E7 Product Family Memory Controller 0a" },
		Device { id: 0x2B16, name: "Xeon Processor E7 Product Family Memory Controller 0b" },
		Device { id: 0x2B18, name: "Xeon Processor E7 Product Family QPI Home Agent 1" },
		Device { id: 0x2B1B, name: "Xeon Processor E7 Product Family Memory Controller 1c" },
		Device { id: 0x2B1C, name: "Xeon Processor E7 Product Family Memory Controller 1a" },
		Device { id: 0x2B1E, name: "Xeon Processor E7 Product Family Memory Controller 1b" },
		Device { id: 0x2B20, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 0" },
		Device { id: 0x2B22, name: "Xeon Processor E7 Product Family System Configuration Controller 3" },
		Device { id: 0x2B24, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 1" },
		Device { id: 0x2B28, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 2" },
		Device { id: 0x2B2A, name: "Xeon Processor E7 Product Family System Configuration Controller 4" },
		Device { id: 0x2B2C, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 3" },
		Device { id: 0x2B30, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 4" },
		Device { id: 0x2B34, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 5" },
		Device { id: 0x2B38, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 6" },
		Device { id: 0x2B3C, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 7" },
		Device { id: 0x2B40, name: "Xeon Processor E7 Product Family QPI Router Port 0-1" },
		Device { id: 0x2B42, name: "Xeon Processor E7 Product Family QPI Router Port 2-3" },
		Device { id: 0x2B44, name: "Xeon Processor E7 Product Family QPI Router Port 4-5" },
		Device { id: 0x2B46, name: "Xeon Processor E7 Product Family QPI Router Port 6-7" },
		Device { id: 0x2B48, name: "Xeon Processor E7 Product Family Test and Debug 0" },
		Device { id: 0x2B4C, name: "Xeon Processor E7 Product Family Test and Debug 1" },
		Device { id: 0x2B50, name: "Xeon Processor E7 Product Family QPI Physical Port 0: REUT control/status" },
		Device { id: 0x2B52, name: "Xeon Processor E7 Product Family QPI Physical Port 0: Misc. control/status" },
		Device { id: 0x2B54, name: "Xeon Processor E7 Product Family QPI Physical Port 1: REUT control/status" },
		Device { id: 0x2B56, name: "Xeon Processor E7 Product Family QPI Physical Port 1: Misc. control/status" },
		Device { id: 0x2B58, name: "Xeon Processor E7 Product Family QPI Physical Port 2: REUT control/status" },
		Device { id: 0x2B5A, name: "Xeon Processor E7 Product Family QPI Physical Port 2: Misc. control/status" },
		Device { id: 0x2B5C, name: "Xeon Processor E7 Product Family QPI Physical Port 3: REUT control/status" },
		Device { id: 0x2B5E, name: "Xeon Processor E7 Product Family QPI Physical Port 3: Misc. control/status" },
		Device { id: 0x2B60, name: "Xeon Processor E7 Product Family SMI Physical Port 0: REUT control/status" },
		Device { id: 0x2B62, name: "Xeon Processor E7 Product Family SMI Physical Port 0: Misc control/status" },
		Device { id: 0x2B64, name: "Xeon Processor E7 Product Family SMI Physical Port 1: REUT control/status" },
		Device { id: 0x2B66, name: "Xeon Processor E7 Product Family SMI Physical Port 1: Misc control/status" },
		Device { id: 0x2B68, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 8" },
		Device { id: 0x2B6C, name: "Xeon Processor E7 Product Family Last Level Cache Coherence Engine 9" },
		Device { id: 0x2C01, name: "Xeon 5500/Core i7 QuickPath Architecture System Address Decoder" },
		Device { id: 0x2C10, name: "Xeon 5500/Core i7 QPI Link 0" },
		Device { id: 0x2C11, name: "Xeon 5500/Core i7 QPI Physical 0" },
		Device { id: 0x2C14, name: "Xeon 5500/Core i7 QPI Link 1" },
		Device { id: 0x2C15, name: "Xeon 5500/Core i7 QPI Physical 1" },
		Device { id: 0x2C18, name: "Xeon 5500/Core i7 Integrated Memory Controller" },
		Device { id: 0x2C19, name: "Xeon 5500/Core i7 Integrated Memory Controller Target Address Decoder" },
		Device { id: 0x2C1A, name: "Xeon 5500/Core i7 Integrated Memory Controller RAS Registers" },
		Device { id: 0x2C1C, name: "Xeon 5500/Core i7 Integrated Memory Controller Test Registers" },
		Device { id: 0x2C20, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Control Registers" },
		Device { id: 0x2C21, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Address Registers" },
		Device { id: 0x2C22, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Rank Registers" },
		Device { id: 0x2C23, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 0 Thermal Control Registers" },
		Device { id: 0x2C28, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Control Registers" },
		Device { id: 0x2C29, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Address Registers" },
		Device { id: 0x2C2A, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Rank Registers" },
		Device { id: 0x2C2B, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 1 Thermal Control Registers" },
		Device { id: 0x2C30, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Control Registers" },
		Device { id: 0x2C31, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Address Registers" },
		Device { id: 0x2C32, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Rank Registers" },
		Device { id: 0x2C33, name: "Xeon 5500/Core i7 Integrated Memory Controller Channel 2 Thermal Control Registers" },
		Device { id: 0x2C40, name: "Xeon 5500/Core i7 QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C41, name: "Xeon 5500/Core i7 QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C50, name: "Core Processor QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C51, name: "Core Processor QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C52, name: "Core Processor QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C53, name: "Core Processor QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C54, name: "Core Processor QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C55, name: "Core Processor QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C56, name: "Core Processor QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C57, name: "Core Processor QuickPath Architecture Generic Non-Core Registers" },
		Device { id: 0x2C58, name: "Xeon C5500/C3500 QPI Generic Non-core Registers" },
		Device { id: 0x2C59, name: "Xeon C5500/C3500 QPI Generic Non-core Registers" },
		Device { id: 0x2C5A, name: "Xeon C5500/C3500 QPI Generic Non-core Registers" },
		Device { id: 0x2C5B, name: "Xeon C5500/C3500 QPI Generic Non-core Registers" },
		Device { id: 0x2C5C, name: "Xeon C5500/C3500 QPI Generic Non-core Registers" },
		Device { id: 0x2C5D, name: "Xeon C5500/C3500 QPI Generic Non-core Registers" },
		Device { id: 0x2C5E, name: "Xeon C5500/C3500 QPI Generic Non-core Registers" },
		Device { id: 0x2C5F, name: "Xeon C5500/C3500 QPI Generic Non-core Registers" },
		Device { id: 0x2C61, name: "Core Processor QuickPath Architecture Generic Non-core Registers" },
		Device { id: 0x2C62, name: "Core Processor QuickPath Architecture Generic Non-core Registers" },
		Device { id: 0x2C70, name: "Xeon 5600 Series QuickPath Architecture Generic Non-core Registers" },
		Device { id: 0x2C81, name: "Core Processor QuickPath Architecture System Address Decoder" },
		Device { id: 0x2C90, name: "Core Processor QPI Link 0" },
		Device { id: 0x2C91, name: "Core Processor QPI Physical 0" },
		Device { id: 0x2C98, name: "Core Processor Integrated Memory Controller" },
		Device { id: 0x2C99, name: "Core Processor Integrated Memory Controller Target Address Decoder" },
		Device { id: 0x2C9A, name: "Core Processor Integrated Memory Controller Test Registers" },
		Device { id: 0x2C9C, name: "Core Processor Integrated Memory Controller Test Registers" },
		Device { id: 0x2CA0, name: "Core Processor Integrated Memory Controller Channel 0 Control Registers" },
		Device { id: 0x2CA1, name: "Core Processor Integrated Memory Controller Channel 0 Address Registers" },
		Device { id: 0x2CA2, name: "Core Processor Integrated Memory Controller Channel 0 Rank Registers" },
		Device { id: 0x2CA3, name: "Core Processor Integrated Memory Controller Channel 0 Thermal Control Registers" },
		Device { id: 0x2CA8, name: "Core Processor Integrated Memory Controller Channel 1 Control Registers" },
		Device { id: 0x2CA9, name: "Core Processor Integrated Memory Controller Channel 1 Address Registers" },
		Device { id: 0x2CAA, name: "Core Processor Integrated Memory Controller Channel 1 Rank Registers" },
		Device { id: 0x2CAB, name: "Core Processor Integrated Memory Controller Channel 1 Thermal Control Registers" },
		Device { id: 0x2CC1, name: "Xeon C5500/C3500 QPI System Address Decoder" },
		Device { id: 0x2CD0, name: "Xeon C5500/C3500 QPI Link 0" },
		Device { id: 0x2CD1, name: "Xeon C5500/C3500 QPI Physical 0" },
		Device { id: 0x2CD4, name: "Xeon C5500/C3500 QPI Link 1" },
		Device { id: 0x2CD5, name: "Xeon C5500/C3500 QPI Physical 1" },
		Device { id: 0x2CD8, name: "Xeon C5500/C3500 Integrated Memory Controller Registers" },
		Device { id: 0x2CD9, name: "Xeon C5500/C3500 Integrated Memory Controller Target Address Decoder" },
		Device { id: 0x2CDA, name: "Xeon C5500/C3500 Integrated Memory Controller RAS Registers" },
		Device { id: 0x2CDC, name: "Xeon C5500/C3500 Integrated Memory Controller Test Registers" },
		Device { id: 0x2CE0, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Control" },
		Device { id: 0x2CE1, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Address" },
		Device { id: 0x2CE2, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Rank" },
		Device { id: 0x2CE3, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 0 Thermal Control" },
		Device { id: 0x2CE8, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Control" },
		Device { id: 0x2CE9, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Address" },
		Device { id: 0x2CEA, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Rank" },
		Device { id: 0x2CEB, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 1 Thermal Control" },
		Device { id: 0x2CF0, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Control" },
		Device { id: 0x2CF1, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Address" },
		Device { id: 0x2CF2, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Rank" },
		Device { id: 0x2CF3, name: "Xeon C5500/C3500 Integrated Memory Controller Channel 2 Thermal Control" },
		Device { id: 0x2D01, name: "Core Processor QuickPath Architecture System Address Decoder" },
		Device { id: 0x2D10, name: "Core Processor QPI Link 0" },
		Device { id: 0x2D11, name: "1st Generation Core i3/5/7 Processor QPI Physical 0" },
		Device { id: 0x2D12, name: "1st Generation Core i3/5/7 Processor Reserved" },
		Device { id: 0x2D13, name: "1st Generation Core i3/5/7 Processor Reserved" },
		Device { id: 0x2D81, name: "Xeon 5600 Series QuickPath Architecture System Address Decoder" },
		Device { id: 0x2D90, name: "Xeon 5600 Series QPI Link 0" },
		Device { id: 0x2D91, name: "Xeon 5600 Series QPI Physical 0" },
		Device { id: 0x2D92, name: "Xeon 5600 Series Mirror Port Link 0" },
		Device { id: 0x2D93, name: "Xeon 5600 Series Mirror Port Link 1" },
		Device { id: 0x2D94, name: "Xeon 5600 Series QPI Link 1" },
		Device { id: 0x2D95, name: "Xeon 5600 Series QPI Physical 1" },
		Device { id: 0x2D98, name: "Xeon 5600 Series Integrated Memory Controller Registers" },
		Device { id: 0x2D99, name: "Xeon 5600 Series Integrated Memory Controller Target Address Decoder" },
		Device { id: 0x2D9A, name: "Xeon 5600 Series Integrated Memory Controller RAS Registers" },
		Device { id: 0x2D9C, name: "Xeon 5600 Series Integrated Memory Controller Test Registers" },
		Device { id: 0x2DA0, name: "Xeon 5600 Series Integrated Memory Controller Channel 0 Control" },
		Device { id: 0x2DA1, name: "Xeon 5600 Series Integrated Memory Controller Channel 0 Address" },
		Device { id: 0x2DA2, name: "Xeon 5600 Series Integrated Memory Controller Channel 0 Rank" },
		Device { id: 0x2DA3, name: "Xeon 5600 Series Integrated Memory Controller Channel 0 Thermal Control" },
		Device { id: 0x2DA8, name: "Xeon 5600 Series Integrated Memory Controller Channel 1 Control" },
		Device { id: 0x2DA9, name: "Xeon 5600 Series Integrated Memory Controller Channel 1 Address" },
		Device { id: 0x2DAA, name: "Xeon 5600 Series Integrated Memory Controller Channel 1 Rank" },
		Device { id: 0x2DAB, name: "Xeon 5600 Series Integrated Memory Controller Channel 1 Thermal Control" },
		Device { id: 0x2DB0, name: "Xeon 5600 Series Integrated Memory Controller Channel 2 Control" },
		Device { id: 0x2DB1, name: "Xeon 5600 Series Integrated Memory Controller Channel 2 Address" },
		Device { id: 0x2DB2, name: "Xeon 5600 Series Integrated Memory Controller Channel 2 Rank" },
		Device { id: 0x2DB3, name: "Xeon 5600 Series Integrated Memory Controller Channel 2 Thermal Control" },
		Device { id: 0x2E00, name: "4 Series Chipset DRAM Controller" },
		Device { id: 0x2E01, name: "4 Series Chipset PCI Express Root Port" },
		Device { id: 0x2E02, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E03, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E04, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E05, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E06, name: "4 Series Chipset PT IDER Controller" },
		Device { id: 0x2E07, name: "4 Series Chipset Serial KT Controller" },
		Device { id: 0x2E10, name: "4 Series Chipset DRAM Controller" },
		Device { id: 0x2E11, name: "4 Series Chipset PCI Express Root Port" },
		Device { id: 0x2E12, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E13, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E14, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E15, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E16, name: "4 Series Chipset PT IDER Controller" },
		Device { id: 0x2E17, name: "4 Series Chipset Serial KT Controller" },
		Device { id: 0x2E20, name: "4 Series Chipset DRAM Controller" },
		Device { id: 0x2E21, name: "4 Series Chipset PCI Express Root Port" },
		Device { id: 0x2E22, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E23, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E24, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E25, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E26, name: "4 Series Chipset PT IDER Controller" },
		Device { id: 0x2E27, name: "4 Series Chipset Serial KT Controller" },
		Device { id: 0x2E29, name: "4 Series Chipset PCI Express Root Port" },
		Device { id: 0x2E30, name: "4 Series Chipset DRAM Controller" },
		Device { id: 0x2E31, name: "4 Series Chipset PCI Express Root Port" },
		Device { id: 0x2E32, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E33, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E34, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E35, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E36, name: "4 Series Chipset PT IDER Controller" },
		Device { id: 0x2E37, name: "4 Series Chipset Serial KT Controller" },
		Device { id: 0x2E40, name: "4 Series Chipset DRAM Controller" },
		Device { id: 0x2E41, name: "4 Series Chipset PCI Express Root Port" },
		Device { id: 0x2E42, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E43, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E44, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E45, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E46, name: "4 Series Chipset PT IDER Controller" },
		Device { id: 0x2E47, name: "4 Series Chipset Serial KT Controller" },
		Device { id: 0x2E50, name: "CE Media Processor CE3100" },
		Device { id: 0x2E52, name: "CE Media Processor Clock and Reset Controller" },
		Device { id: 0x2E58, name: "CE Media Processor Interrupt Controller" },
		Device { id: 0x2E5A, name: "CE Media Processor CE3100 A/V Bridge" },
		Device { id: 0x2E5B, name: "Graphics Media Accelerator 500 Graphics" },
		Device { id: 0x2E5C, name: "CE Media Processor Video Decoder" },
		Device { id: 0x2E5D, name: "CE Media Processor Transport Stream Interface" },
		Device { id: 0x2E5E, name: "CE Media Processor Transport Stream Processor 0" },
		Device { id: 0x2E5F, name: "CE Media Processor Audio DSP" },
		Device { id: 0x2E60, name: "CE Media Processor Audio Interfaces" },
		Device { id: 0x2E61, name: "CE Media Processor Video Display Controller" },
		Device { id: 0x2E62, name: "CE Media Processor Video Processing Unit" },
		Device { id: 0x2E63, name: "CE Media Processor HDMI Tx Interface" },
		Device { id: 0x2E65, name: "CE Media Processor Expansion Bus Interface" },
		Device { id: 0x2E66, name: "CE Media Processor UART" },
		Device { id: 0x2E67, name: "CE Media Processor General Purpose I/Os" },
		Device { id: 0x2E68, name: "CE Media Processor I2C Interface" },
		Device { id: 0x2E69, name: "CE Media Processor Smart Card Interface" },
		Device { id: 0x2E6A, name: "CE Media Processor SPI Master Interface" },
		Device { id: 0x2E6E, name: "CE Media Processor Gigabit Ethernet Controller" },
		Device { id: 0x2E6F, name: "CE Media Processor Media Timing Unit" },
		Device { id: 0x2E70, name: "CE Media Processor USB" },
		Device { id: 0x2E71, name: "CE Media Processor SATA" },
		Device { id: 0x2E73, name: "CE Media Processor CE3100 PCI Express" },
		Device { id: 0x2E90, name: "4 Series Chipset DRAM Controller" },
		Device { id: 0x2E91, name: "4 Series Chipset PCI Express Root Port" },
		Device { id: 0x2E92, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E93, name: "4 Series Chipset Integrated Graphics Controller" },
		Device { id: 0x2E94, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E95, name: "4 Series Chipset HECI Controller" },
		Device { id: 0x2E96, name: "4 Series Chipset PT IDER Controller" },
		Device { id: 0x2F00, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMI2" },
		Device { id: 0x2F01, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 0" },
		Device { id: 0x2F02, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 1" },
		Device { id: 0x2F03, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 1" },
		Device { id: 0x2F04, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2" },
		Device { id: 0x2F05, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2" },
		Device { id: 0x2F06, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2" },
		Device { id: 0x2F07, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 2" },
		Device { id: 0x2F08, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3" },
		Device { id: 0x2F09, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3" },
		Device { id: 0x2F0A, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3" },
		Device { id: 0x2F0B, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCI Express Root Port 3" },
		Device { id: 0x2F0D, name: "Haswell Xeon Non-Transparent Bridge (Back-to-back)" },
		Device { id: 0x2F0E, name: "Haswell Xeon Non-Transparent Bridge (Primary Side)" },
		Device { id: 0x2F0F, name: "Haswell Xeon Non-Transparent Bridge (Secondary Side)" },
		Device { id: 0x2F10, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F11, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F12, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F13, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F14, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F15, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F16, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F17, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F18, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F19, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F1A, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F1B, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F1C, name: "Xeon E7 v3/Xeon E5 v3/Core i7 IIO Debug" },
		Device { id: 0x2F1D, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCIe Ring Interface" },
		Device { id: 0x2F1E, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers" },
		Device { id: 0x2F1F, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers" },
		Device { id: 0x2F20, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 0" },
		Device { id: 0x2F21, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 1" },
		Device { id: 0x2F22, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 2" },
		Device { id: 0x2F23, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 3" },
		Device { id: 0x2F24, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 4" },
		Device { id: 0x2F25, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 5" },
		Device { id: 0x2F26, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 6" },
		Device { id: 0x2F27, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DMA Channel 7" },
		Device { id: 0x2F28, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Address Map, VTd_Misc, System Management" },
		Device { id: 0x2F29, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Hot Plug" },
		Device { id: 0x2F2A, name: "Xeon E7 v3/Xeon E5 v3/Core i7 RAS, Control Status and Global Errors" },
		Device { id: 0x2F2C, name: "Xeon E7 v3/Xeon E5 v3/Core i7 I/O APIC" },
		Device { id: 0x2F2E, name: "Xeon E7 v3/Xeon E5 v3/Core i7 RAID 5/6" },
		Device { id: 0x2F2F, name: "Xeon E7 v3/Xeon E5 v3/Core i7 RAID 5/6" },
		Device { id: 0x2F30, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0" },
		Device { id: 0x2F32, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0" },
		Device { id: 0x2F33, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1" },
		Device { id: 0x2F34, name: "Xeon E7 v3/Xeon E5 v3/Core i7 PCIe Ring Interface" },
		Device { id: 0x2F36, name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring" },
		Device { id: 0x2F37, name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring" },
		Device { id: 0x2F38, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1" },
		Device { id: 0x2F39, name: "Xeon E7 v3/Xeon E5 v3/Core i7 I/O Performance Monitoring" },
		Device { id: 0x2F3A, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2" },
		Device { id: 0x2F3E, name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring" },
		Device { id: 0x2F3F, name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring" },
		Device { id: 0x2F40, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2" },
		Device { id: 0x2F41, name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 2 Monitoring" },
		Device { id: 0x2F43, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2" },
		Device { id: 0x2F45, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug" },
		Device { id: 0x2F46, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug" },
		Device { id: 0x2F47, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 2 Debug" },
		Device { id: 0x2F60, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1" },
		Device { id: 0x2F68, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Target Address, Thermal & RAS Registers" },
		Device { id: 0x2F6A, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder" },
		Device { id: 0x2F6B, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder" },
		Device { id: 0x2F6C, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder" },
		Device { id: 0x2F6D, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel Target Address Decoder" },
		Device { id: 0x2F6E, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Channel 2/3 Broadcast" },
		Device { id: 0x2F6F, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Global Broadcast" },
		Device { id: 0x2F70, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0 Debug" },
		Device { id: 0x2F71, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Target Address, Thermal & RAS Registers" },
		Device { id: 0x2F76, name: "Xeon E7 v3/Xeon E5 v3/Core i7 E3 QPI Link Debug" },
		Device { id: 0x2F78, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 1 Debug" },
		Device { id: 0x2F79, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Target Address, Thermal & RAS Registers" },
		Device { id: 0x2F7D, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Scratchpad & Semaphore Registers" },
		Device { id: 0x2F7E, name: "Xeon E7 v3/Xeon E5 v3/Core i7 E3 QPI Link Debug" },
		Device { id: 0x2F80, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0" },
		Device { id: 0x2F81, name: "Xeon E7 v3/Xeon E5 v3/Core i7 R3 QPI Link 0 & 1 Monitoring" },
		Device { id: 0x2F83, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0" },
		Device { id: 0x2F85, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug" },
		Device { id: 0x2F86, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug" },
		Device { id: 0x2F87, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 0 Debug" },
		Device { id: 0x2F88, name: "Xeon E7 v3/Xeon E5 v3/Core i7 VCU" },
		Device { id: 0x2F8A, name: "Xeon E7 v3/Xeon E5 v3/Core i7 VCU" },
		Device { id: 0x2F90, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1" },
		Device { id: 0x2F93, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1" },
		Device { id: 0x2F95, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1 Debug" },
		Device { id: 0x2F96, name: "Xeon E7 v3/Xeon E5 v3/Core i7 QPI Link 1 Debug" },
		Device { id: 0x2F98, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2F99, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2F9A, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2F9C, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2FA0, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Home Agent 0" },
		Device { id: 0x2FA8, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Target Address, Thermal & RAS Registers" },
		Device { id: 0x2FAA, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder" },
		Device { id: 0x2FAB, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder" },
		Device { id: 0x2FAC, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder" },
		Device { id: 0x2FAD, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel Target Address Decoder" },
		Device { id: 0x2FAE, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Channel 0/1 Broadcast" },
		Device { id: 0x2FAF, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO Global Broadcast" },
		Device { id: 0x2FB0, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 0 Thermal Control" },
		Device { id: 0x2FB1, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 1 Thermal Control" },
		Device { id: 0x2FB2, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 0 ERROR Registers" },
		Device { id: 0x2FB3, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 1 ERROR Registers" },
		Device { id: 0x2FB4, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 2 Thermal Control" },
		Device { id: 0x2FB5, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 3 Thermal Control" },
		Device { id: 0x2FB6, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 2 ERROR Registers" },
		Device { id: 0x2FB7, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 0 Channel 3 ERROR Registers" },
		Device { id: 0x2FB8, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3" },
		Device { id: 0x2FB9, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3" },
		Device { id: 0x2FBA, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3" },
		Device { id: 0x2FBB, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 2 & 3" },
		Device { id: 0x2FBC, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1" },
		Device { id: 0x2FBD, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1" },
		Device { id: 0x2FBE, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1" },
		Device { id: 0x2FBF, name: "Xeon E7 v3/Xeon E5 v3/Core i7 DDRIO (VMSE) 0 & 1" },
		Device { id: 0x2FC0, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2FC1, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2FC2, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2FC3, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2FC4, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2FC5, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Power Control Unit" },
		Device { id: 0x2FD0, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 0 Thermal Control" },
		Device { id: 0x2FD1, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 1 Thermal Control" },
		Device { id: 0x2FD2, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 0 ERROR Registers" },
		Device { id: 0x2FD3, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 1 ERROR Registers" },
		Device { id: 0x2FD4, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 2 Thermal Control" },
		Device { id: 0x2FD5, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 3 Thermal Control" },
		Device { id: 0x2FD6, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 2 ERROR Registers" },
		Device { id: 0x2FD7, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Integrated Memory Controller 1 Channel 3 ERROR Registers" },
		Device { id: 0x2FE0, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE1, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE2, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE3, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE4, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE5, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE6, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE7, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE8, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FE9, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FEA, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FEB, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FEC, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FED, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FEE, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FEF, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF0, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF1, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF2, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF3, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF4, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF5, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF6, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF7, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Unicast Registers" },
		Device { id: 0x2FF8, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent" },
		Device { id: 0x2FF9, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent" },
		Device { id: 0x2FFA, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent" },
		Device { id: 0x2FFB, name: "Xeon E7 v3/Xeon E5 v3/Core i7 Buffered Ring Agent" },
		Device { id: 0x2FFC, name: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers" },
		Device { id: 0x2FFD, name: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers" },
		Device { id: 0x2FFE, name: "Xeon E7 v3/Xeon E5 v3/Core i7 System Address Decoder & Broadcast Registers" },
		Device { id: 0x3165, name: "Wireless 3165" },
		Device { id: 0x3166, name: "Dual Band Wireless-AC 3165 Plus Bluetooth" },
		Device { id: 0x3200, name: "GD31244 PCI-X SATA HBA" },
		Device { id: 0x3310, name: "IOP348 I/O Processor" },
		Device { id: 0x3313, name: "IOP348 I/O Processor (SL8e) in IOC Mode SAS/SATA" },
		Device { id: 0x331B, name: "IOP348 I/O Processor (SL8x) in IOC Mode SAS/SATA" },
		Device { id: 0x3331, name: "IOC340 I/O Controller (VV8e) SAS/SATA" },
		Device { id: 0x3339, name: "IOC340 I/O Controller (VV8x) SAS/SATA" },
		Device { id: 0x3340, name: "82855PM Processor to I/O Controller" },
		Device { id: 0x3341, name: "82855PM Processor to AGP Controller" },
		Device { id: 0x3363, name: "IOC340 I/O Controller in IOC Mode SAS/SATA" },
		Device { id: 0x3382, name: "81342 [Chevelon] I/O Processor (ATUe)" },
		Device { id: 0x33C3, name: "IOP348 I/O Processor (SL8De) in IOC Mode SAS/SATA" },
		Device { id: 0x33CB, name: "IOP348 I/O Processor (SL8Dx) in IOC Mode SAS/SATA" },
		Device { id: 0x3400, name: "5520/5500/X58 I/O Hub to ESI Port" },
		Device { id: 0x3401, name: "5520/5500/X58 I/O Hub to ESI Port" },
		Device { id: 0x3402, name: "5520/5500/X58 I/O Hub to ESI Port" },
		Device { id: 0x3403, name: "5500 I/O Hub to ESI Port" },
		Device { id: 0x3404, name: "5520/5500/X58 I/O Hub to ESI Port" },
		Device { id: 0x3405, name: "5520/5500/X58 I/O Hub to ESI Port" },
		Device { id: 0x3406, name: "5520 I/O Hub to ESI Port" },
		Device { id: 0x3407, name: "5520/5500/X58 I/O Hub to ESI Port" },
		Device { id: 0x3408, name: "5520/5500/X58 I/O Hub PCI Express Root Port 1" },
		Device { id: 0x3409, name: "5520/5500/X58 I/O Hub PCI Express Root Port 2" },
		Device { id: 0x340A, name: "5520/5500/X58 I/O Hub PCI Express Root Port 3" },
		Device { id: 0x340B, name: "5520/X58 I/O Hub PCI Express Root Port 4" },
		Device { id: 0x340C, name: "5520/X58 I/O Hub PCI Express Root Port 5" },
		Device { id: 0x340D, name: "5520/X58 I/O Hub PCI Express Root Port 6" },
		Device { id: 0x340E, name: "5520/5500/X58 I/O Hub PCI Express Root Port 7" },
		Device { id: 0x340F, name: "5520/5500/X58 I/O Hub PCI Express Root Port 8" },
		Device { id: 0x3410, name: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 9" },
		Device { id: 0x3411, name: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 10" },
		Device { id: 0x3418, name: "7500/5520/5500/X58 Physical Layer Port 0" },
		Device { id: 0x3419, name: "7500/5520/5500 Physical Layer Port 1" },
		Device { id: 0x3420, name: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 0" },
		Device { id: 0x3421, name: "7500/5520/5500/X58 I/O Hub PCI Express Root Port 0" },
		Device { id: 0x3422, name: "7500/5520/5500/X58 I/O Hub GPIO and Scratch Pad Registers" },
		Device { id: 0x3423, name: "7500/5520/5500/X58 I/O Hub Control Status and RAS Registers" },
		Device { id: 0x3425, name: "7500/5520/5500/X58 Physical and Link Layer Registers Port 0" },
		Device { id: 0x3426, name: "7500/5520/5500/X58 Routing and Protocol Layer Registers Port 0" },
		Device { id: 0x3427, name: "7500/5520/5500 Physical and Link Layer Registers Port 1" },
		Device { id: 0x3428, name: "7500/5520/5500 Routing & Protocol Layer Register Port 1" },
		Device { id: 0x3429, name: "5520/5500/X58 Chipset QuickData Technology Device" },
		Device { id: 0x342A, name: "5520/5500/X58 Chipset QuickData Technology Device" },
		Device { id: 0x342B, name: "5520/5500/X58 Chipset QuickData Technology Device" },
		Device { id: 0x342C, name: "5520/5500/X58 Chipset QuickData Technology Device" },
		Device { id: 0x342D, name: "7500/5520/5500/X58 I/O Hub I/OxAPIC Interrupt Controller" },
		Device { id: 0x342E, name: "7500/5520/5500/X58 I/O Hub System Management Registers" },
		Device { id: 0x342F, name: "7500/5520/5500/X58 Trusted Execution Technology Registers" },
		Device { id: 0x3430, name: "5520/5500/X58 Chipset QuickData Technology Device" },
		Device { id: 0x3431, name: "5520/5500/X58 Chipset QuickData Technology Device" },
		Device { id: 0x3432, name: "5520/5500/X58 Chipset QuickData Technology Device" },
		Device { id: 0x3433, name: "5520/5500/X58 Chipset QuickData Technology Device" },
		Device { id: 0x3438, name: "7500/5520/5500/X58 I/O Hub Throttle Registers" },
		Device { id: 0x3500, name: "6311ESB/6321ESB PCI Express Upstream Port" },
		Device { id: 0x3501, name: "6310ESB PCI Express Upstream Port" },
		Device { id: 0x3504, name: "6311ESB/6321ESB I/OxAPIC Interrupt Controller" },
		Device { id: 0x3505, name: "6310ESB I/OxAPIC Interrupt Controller" },
		Device { id: 0x350C, name: "6311ESB/6321ESB PCI Express to PCI-X Bridge" },
		Device { id: 0x350D, name: "6310ESB PCI Express to PCI-X Bridge" },
		Device { id: 0x3510, name: "6311ESB/6321ESB PCI Express Downstream Port E1" },
		Device { id: 0x3511, name: "6310ESB PCI Express Downstream Port E1" },
		Device { id: 0x3514, name: "6311ESB/6321ESB PCI Express Downstream Port E2" },
		Device { id: 0x3515, name: "6310ESB PCI Express Downstream Port E2" },
		Device { id: 0x3518, name: "6311ESB/6321ESB PCI Express Downstream Port E3" },
		Device { id: 0x3519, name: "6310ESB PCI Express Downstream Port E3" },
		Device { id: 0x3575, name: "82830M/MG/MP Host Bridge" },
		Device { id: 0x3576, name: "82830M/MP AGP Bridge" },
		Device { id: 0x3577, name: "82830M/MG Integrated Graphics Controller" },
		Device { id: 0x3578, name: "82830M/MG/MP Host Bridge" },
		Device { id: 0x3580, name: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller" },
		Device { id: 0x3581, name: "82852/82855 GM/GME/PM/GMV Processor to AGP Controller" },
		Device { id: 0x3582, name: "82852/855GM Integrated Graphics Device" },
		Device { id: 0x3584, name: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller" },
		Device { id: 0x3585, name: "82852/82855 GM/GME/PM/GMV Processor to I/O Controller" },
		Device { id: 0x358C, name: "82854 GMCH" },
		Device { id: 0x358E, name: "82854 GMCH Integrated Graphics Device" },
		Device { id: 0x3590, name: "E7520 Memory Controller Hub" },
		Device { id: 0x3591, name: "E7525/E7520 Error Reporting Registers" },
		Device { id: 0x3592, name: "E7320 Memory Controller Hub" },
		Device { id: 0x3593, name: "E7320 Error Reporting Registers" },
		Device { id: 0x3594, name: "E7520 DMA Controller" },
		Device { id: 0x3595, name: "E7525/E7520/E7320 PCI Express Port A" },
		Device { id: 0x3596, name: "E7525/E7520/E7320 PCI Express Port A1" },
		Device { id: 0x3597, name: "E7525/E7520 PCI Express Port B" },
		Device { id: 0x3598, name: "E7520 PCI Express Port B1" },
		Device { id: 0x3599, name: "E7520 PCI Express Port C" },
		Device { id: 0x359A, name: "E7520 PCI Express Port C1" },
		Device { id: 0x359B, name: "E7525/E7520/E7320 Extended Configuration Registers" },
		Device { id: 0x359E, name: "E7525 Memory Controller Hub" },
		Device { id: 0x35B0, name: "3100 Chipset Memory I/O Controller Hub" },
		Device { id: 0x35B1, name: "3100 DRAM Controller Error Reporting Registers" },
		Device { id: 0x35B5, name: "3100 Chipset Enhanced DMA Controller" },
		Device { id: 0x35B6, name: "3100 Chipset PCI Express Port A" },
		Device { id: 0x35B7, name: "3100 Chipset PCI Express Port A1" },
		Device { id: 0x35C8, name: "3100 Extended Configuration Test Overflow Registers" },
		Device { id: 0x3600, name: "7300 Chipset Memory Controller Hub" },
		Device { id: 0x3604, name: "7300 Chipset PCI Express Port 1" },
		Device { id: 0x3605, name: "7300 Chipset PCI Express Port 2" },
		Device { id: 0x3606, name: "7300 Chipset PCI Express Port 3" },
		Device { id: 0x3607, name: "7300 Chipset PCI Express Port 4" },
		Device { id: 0x3608, name: "7300 Chipset PCI Express Port 5" },
		Device { id: 0x3609, name: "7300 Chipset PCI Express Port 6" },
		Device { id: 0x360A, name: "7300 Chipset PCI Express Port 7" },
		Device { id: 0x360B, name: "7300 Chipset QuickData Technology Device" },
		Device { id: 0x360C, name: "7300 Chipset FSB Registers" },
		Device { id: 0x360D, name: "7300 Chipset Snoop Filter Registers" },
		Device { id: 0x360E, name: "7300 Chipset Debug and Miscellaneous Registers" },
		Device { id: 0x360F, name: "7300 Chipset FBD Branch 0 Registers" },
		Device { id: 0x3610, name: "7300 Chipset FBD Branch 1 Registers" },
		Device { id: 0x3700, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3701, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3702, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3703, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3704, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3705, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3706, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3707, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3708, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3709, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x370A, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x370B, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x370C, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x370D, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x370E, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x370F, name: "Xeon C5500/C3500 DMI" },
		Device { id: 0x3710, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3711, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3712, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3713, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3714, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3715, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3716, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3717, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3718, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x3719, name: "Xeon C5500/C3500 CB3 DMA" },
		Device { id: 0x371A, name: "Xeon C5500/C3500 QPI Link" },
		Device { id: 0x371B, name: "Xeon C5500/C3500 QPI Routing and Protocol" },
		Device { id: 0x371D, name: "Xeon C5500/C3500 QPI Routing and Protocol" },
		Device { id: 0x3720, name: "Xeon C5500/C3500 PCI Express Root Port 0" },
		Device { id: 0x3721, name: "Xeon C5500/C3500 PCI Express Root Port 1" },
		Device { id: 0x3722, name: "Xeon C5500/C3500 PCI Express Root Port 2" },
		Device { id: 0x3723, name: "Xeon C5500/C3500 PCI Express Root Port 3" },
		Device { id: 0x3724, name: "Xeon C5500/C3500 PCI Express Root Port 4" },
		Device { id: 0x3725, name: "Xeon C5500/C3500 NTB Primary" },
		Device { id: 0x3726, name: "Xeon C5500/C3500 NTB Primary" },
		Device { id: 0x3727, name: "Xeon C5500/C3500 NTB Secondary" },
		Device { id: 0x3728, name: "Xeon C5500/C3500 Core" },
		Device { id: 0x3729, name: "Xeon C5500/C3500 Core" },
		Device { id: 0x372A, name: "Xeon C5500/C3500 Core" },
		Device { id: 0x372B, name: "Xeon C5500/C3500 Core" },
		Device { id: 0x372C, name: "Xeon C5500/C3500 Reserved" },
		Device { id: 0x373F, name: "Xeon C5500/C3500 IOxAPIC" },
		Device { id: 0x37CD, name: "Ethernet Virtual Function 700 Series" },
		Device { id: 0x37CE, name: "Ethernet Connection X722 for 10GbE backplane" },
		Device { id: 0x37CF, name: "Ethernet Connection X722 for 10GbE QSFP+" },
		Device { id: 0x37D0, name: "Ethernet Connection X722 for 10GbE SFP+" },
		Device { id: 0x37D1, name: "Ethernet Connection X722 for 1GbE" },
		Device { id: 0x37D2, name: "Ethernet Connection X722 for 10GBASE-T" },
		Device { id: 0x37D3, name: "Ethernet Connection X722 for 10GbE SFP+" },
		Device { id: 0x37D4, name: "Ethernet Connection X722 for 10GbE QSFP+" },
		Device { id: 0x37D9, name: "X722 Hyper-V Virtual Function" },
		Device { id: 0x3A00, name: "82801JD/DO (ICH10 Family) 4-port SATA IDE Controller" },
		Device { id: 0x3A02, name: "82801JD/DO (ICH10 Family) SATA AHCI Controller" },
		Device { id: 0x3A05, name: "82801JD/DO (ICH10 Family) SATA RAID Controller" },
		Device { id: 0x3A06, name: "82801JD/DO (ICH10 Family) 2-port SATA IDE Controller" },
		Device { id: 0x3A14, name: "82801JDO (ICH10DO) LPC Interface Controller" },
		Device { id: 0x3A16, name: "82801JIR (ICH10R) LPC Interface Controller" },
		Device { id: 0x3A18, name: "82801JIB (ICH10) LPC Interface Controller" },
		Device { id: 0x3A1A, name: "82801JD (ICH10D) LPC Interface Controller" },
		Device { id: 0x3A20, name: "82801JI (ICH10 Family) 4 port SATA IDE Controller #1" },
		Device { id: 0x3A22, name: "82801JI (ICH10 Family) SATA AHCI Controller" },
		Device { id: 0x3A25, name: "82801JIR (ICH10R) SATA RAID Controller" },
		Device { id: 0x3A26, name: "82801JI (ICH10 Family) 2 port SATA IDE Controller #2" },
		Device { id: 0x3A30, name: "82801JI (ICH10 Family) SMBus Controller" },
		Device { id: 0x3A32, name: "82801JI (ICH10 Family) Thermal Subsystem" },
		Device { id: 0x3A34, name: "82801JI (ICH10 Family) USB UHCI Controller #1" },
		Device { id: 0x3A35, name: "82801JI (ICH10 Family) USB UHCI Controller #2" },
		Device { id: 0x3A36, name: "82801JI (ICH10 Family) USB UHCI Controller #3" },
		Device { id: 0x3A37, name: "82801JI (ICH10 Family) USB UHCI Controller #4" },
		Device { id: 0x3A38, name: "82801JI (ICH10 Family) USB UHCI Controller #5" },
		Device { id: 0x3A39, name: "82801JI (ICH10 Family) USB UHCI Controller #6" },
		Device { id: 0x3A3A, name: "82801JI (ICH10 Family) USB2 EHCI Controller #1" },
		Device { id: 0x3A3C, name: "82801JI (ICH10 Family) USB2 EHCI Controller #2" },
		Device { id: 0x3A3E, name: "82801JI (ICH10 Family) HD Audio Controller" },
		Device { id: 0x3A40, name: "82801JI (ICH10 Family) PCI Express Root Port 1" },
		Device { id: 0x3A42, name: "82801JI (ICH10 Family) PCI Express Port 2" },
		Device { id: 0x3A44, name: "82801JI (ICH10 Family) PCI Express Root Port 3" },
		Device { id: 0x3A46, name: "82801JI (ICH10 Family) PCI Express Root Port 4" },
		Device { id: 0x3A48, name: "82801JI (ICH10 Family) PCI Express Root Port 5" },
		Device { id: 0x3A4A, name: "82801JI (ICH10 Family) PCI Express Root Port 6" },
		Device { id: 0x3A4C, name: "82801JI (ICH10 Family) Gigabit Ethernet Controller" },
		Device { id: 0x3A51, name: "82801JDO (ICH10DO) VECI Controller" },
		Device { id: 0x3A55, name: "82801JD/DO (ICH10 Family) Virtual SATA Controller" },
		Device { id: 0x3A60, name: "82801JD/DO (ICH10 Family) SMBus Controller" },
		Device { id: 0x3A62, name: "82801JD/DO (ICH10 Family) Thermal Subsystem" },
		Device { id: 0x3A64, name: "82801JD/DO (ICH10 Family) USB UHCI Controller #1" },
		Device { id: 0x3A65, name: "82801JD/DO (ICH10 Family) USB UHCI Controller #2" },
		Device { id: 0x3A66, name: "82801JD/DO (ICH10 Family) USB UHCI Controller #3" },
		Device { id: 0x3A67, name: "82801JD/DO (ICH10 Family) USB UHCI Controller #4" },
		Device { id: 0x3A68, name: "82801JD/DO (ICH10 Family) USB UHCI Controller #5" },
		Device { id: 0x3A69, name: "82801JD/DO (ICH10 Family) USB UHCI Controller #6" },
		Device { id: 0x3A6A, name: "82801JD/DO (ICH10 Family) USB2 EHCI Controller #1" },
		Device { id: 0x3A6C, name: "82801JD/DO (ICH10 Family) USB2 EHCI Controller #2" },
		Device { id: 0x3A6E, name: "82801JD/DO (ICH10 Family) HD Audio Controller" },
		Device { id: 0x3A70, name: "82801JD/DO (ICH10 Family) PCI Express Port 1" },
		Device { id: 0x3A72, name: "82801JD/DO (ICH10 Family) PCI Express Port 2" },
		Device { id: 0x3A74, name: "82801JD/DO (ICH10 Family) PCI Express Port 3" },
		Device { id: 0x3A76, name: "82801JD/DO (ICH10 Family) PCI Express Port 4" },
		Device { id: 0x3A78, name: "82801JD/DO (ICH10 Family) PCI Express Port 5" },
		Device { id: 0x3A7A, name: "82801JD/DO (ICH10 Family) PCI Express Port 6" },
		Device { id: 0x3A7C, name: "82801JD/DO (ICH10 Family) Gigabit Ethernet Controller" },
		Device { id: 0x3B00, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B01, name: "Mobile 5 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B02, name: "P55 Chipset LPC Interface Controller" },
		Device { id: 0x3B03, name: "PM55 Chipset LPC Interface Controller" },
		Device { id: 0x3B04, name: "5 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B05, name: "Mobile 5 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B06, name: "H55 Chipset LPC Interface Controller" },
		Device { id: 0x3B07, name: "QM57 Chipset LPC Interface Controller" },
		Device { id: 0x3B08, name: "H57 Chipset LPC Interface Controller" },
		Device { id: 0x3B09, name: "HM55 Chipset LPC Interface Controller" },
		Device { id: 0x3B0A, name: "Q57 Chipset LPC Interface Controller" },
		Device { id: 0x3B0B, name: "HM57 Chipset LPC Interface Controller" },
		Device { id: 0x3B0C, name: "5 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B0D, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B0E, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B0F, name: "QS57 Chipset LPC Interface Controller" },
		Device { id: 0x3B10, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B11, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B12, name: "3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B13, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B14, name: "3420 Chipset LPC Interface Controller" },
		Device { id: 0x3B15, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B16, name: "3450 Chipset LPC Interface Controller" },
		Device { id: 0x3B17, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B18, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B19, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B1A, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B1B, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B1C, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B1D, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B1E, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B1F, name: "5 Series/3400 Series Chipset LPC Interface Controller" },
		Device { id: 0x3B20, name: "5 Series/3400 Series Chipset 4 port SATA IDE Controller" },
		Device { id: 0x3B21, name: "5 Series/3400 Series Chipset 2 port SATA IDE Controller" },
		Device { id: 0x3B22, name: "5 Series/3400 Series Chipset 6 port SATA AHCI Controller" },
		Device { id: 0x3B23, name: "5 Series/3400 Series Chipset 4 port SATA AHCI Controller" },
		Device { id: 0x3B25, name: "5 Series/3400 Series Chipset SATA RAID Controller" },
		Device { id: 0x3B26, name: "5 Series/3400 Series Chipset 2 port SATA IDE Controller" },
		Device { id: 0x3B28, name: "5 Series/3400 Series Chipset 4 port SATA IDE Controller" },
		Device { id: 0x3B29, name: "5 Series/3400 Series Chipset 4 port SATA AHCI Controller" },
		Device { id: 0x3B2C, name: "5 Series/3400 Series Chipset SATA RAID Controller" },
		Device { id: 0x3B2D, name: "5 Series/3400 Series Chipset 2 port SATA IDE Controller" },
		Device { id: 0x3B2E, name: "5 Series/3400 Series Chipset 4 port SATA IDE Controller" },
		Device { id: 0x3B2F, name: "5 Series/3400 Series Chipset 6 port SATA AHCI Controller" },
		Device { id: 0x3B30, name: "5 Series/3400 Series Chipset SMBus Controller" },
		Device { id: 0x3B32, name: "5 Series/3400 Series Chipset Thermal Subsystem" },
		Device { id: 0x3B34, name: "5 Series/3400 Series Chipset USB2 Enhanced Host Controller" },
		Device { id: 0x3B36, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B37, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B38, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B39, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B3A, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B3B, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B3C, name: "5 Series/3400 Series Chipset USB2 Enhanced Host Controller" },
		Device { id: 0x3B3E, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B3F, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B40, name: "5 Series/3400 Series Chipset USB Universal Host Controller" },
		Device { id: 0x3B41, name: "5 Series/3400 Series Chipset LAN Controller" },
		Device { id: 0x3B42, name: "5 Series/3400 Series Chipset PCI Express Root Port 1" },
		Device { id: 0x3B44, name: "5 Series/3400 Series Chipset PCI Express Root Port 2" },
		Device { id: 0x3B46, name: "5 Series/3400 Series Chipset PCI Express Root Port 3" },
		Device { id: 0x3B48, name: "5 Series/3400 Series Chipset PCI Express Root Port 4" },
		Device { id: 0x3B4A, name: "5 Series/3400 Series Chipset PCI Express Root Port 5" },
		Device { id: 0x3B4C, name: "5 Series/3400 Series Chipset PCI Express Root Port 6" },
		Device { id: 0x3B4E, name: "5 Series/3400 Series Chipset PCI Express Root Port 7" },
		Device { id: 0x3B50, name: "5 Series/3400 Series Chipset PCI Express Root Port 8" },
		Device { id: 0x3B53, name: "5 Series/3400 Series Chipset VECI Controller" },
		Device { id: 0x3B56, name: "5 Series/3400 Series Chipset High Definition Audio" },
		Device { id: 0x3B57, name: "5 Series/3400 Series Chipset High Definition Audio" },
		Device { id: 0x3B64, name: "5 Series/3400 Series Chipset HECI Controller" },
		Device { id: 0x3B65, name: "5 Series/3400 Series Chipset HECI Controller" },
		Device { id: 0x3B66, name: "5 Series/3400 Series Chipset PT IDER Controller" },
		Device { id: 0x3B67, name: "5 Series/3400 Series Chipset KT Controller" },
		Device { id: 0x3C00, name: "Xeon E5/Core i7 DMI2" },
		Device { id: 0x3C01, name: "Xeon E5/Core i7 DMI2 in PCI Express Mode" },
		Device { id: 0x3C02, name: "Xeon E5/Core i7 IIO PCI Express Root Port 1a" },
		Device { id: 0x3C03, name: "Xeon E5/Core i7 IIO PCI Express Root Port 1b" },
		Device { id: 0x3C04, name: "Xeon E5/Core i7 IIO PCI Express Root Port 2a" },
		Device { id: 0x3C05, name: "Xeon E5/Core i7 IIO PCI Express Root Port 2b" },
		Device { id: 0x3C06, name: "Xeon E5/Core i7 IIO PCI Express Root Port 2c" },
		Device { id: 0x3C07, name: "Xeon E5/Core i7 IIO PCI Express Root Port 2d" },
		Device { id: 0x3C08, name: "Xeon E5/Core i7 IIO PCI Express Root Port 3a in PCI Express Mode" },
		Device { id: 0x3C09, name: "Xeon E5/Core i7 IIO PCI Express Root Port 3b" },
		Device { id: 0x3C0A, name: "Xeon E5/Core i7 IIO PCI Express Root Port 3c" },
		Device { id: 0x3C0B, name: "Xeon E5/Core i7 IIO PCI Express Root Port 3d" },
		Device { id: 0x3C0D, name: "Xeon E5/Core i7 Non-Transparent Bridge" },
		Device { id: 0x3C0E, name: "Xeon E5/Core i7 Non-Transparent Bridge" },
		Device { id: 0x3C0F, name: "Xeon E5/Core i7 Non-Transparent Bridge" },
		Device { id: 0x3C20, name: "Xeon E5/Core i7 DMA Channel 0" },
		Device { id: 0x3C21, name: "Xeon E5/Core i7 DMA Channel 1" },
		Device { id: 0x3C22, name: "Xeon E5/Core i7 DMA Channel 2" },
		Device { id: 0x3C23, name: "Xeon E5/Core i7 DMA Channel 3" },
		Device { id: 0x3C24, name: "Xeon E5/Core i7 DMA Channel 4" },
		Device { id: 0x3C25, name: "Xeon E5/Core i7 DMA Channel 5" },
		Device { id: 0x3C26, name: "Xeon E5/Core i7 DMA Channel 6" },
		Device { id: 0x3C27, name: "Xeon E5/Core i7 DMA Channel 7" },
		Device { id: 0x3C28, name: "Xeon E5/Core i7 Address Map, VTd_Misc, System Management" },
		Device { id: 0x3C2A, name: "Xeon E5/Core i7 Control Status and Global Errors" },
		Device { id: 0x3C2C, name: "Xeon E5/Core i7 I/O APIC" },
		Device { id: 0x3C2E, name: "Xeon E5/Core i7 DMA" },
		Device { id: 0x3C2F, name: "Xeon E5/Core i7 DMA" },
		Device { id: 0x3C40, name: "Xeon E5/Core i7 IIO Switch and IRP Performance Monitor" },
		Device { id: 0x3C43, name: "Xeon E5/Core i7 Ring to PCI Express Performance Monitor" },
		Device { id: 0x3C44, name: "Xeon E5/Core i7 Ring to QuickPath Interconnect Link 0 Performance Monitor" },
		Device { id: 0x3C45, name: "Xeon E5/Core i7 Ring to QuickPath Interconnect Link 1 Performance Monitor" },
		Device { id: 0x3C46, name: "Xeon E5/Core i7 Processor Home Agent Performance Monitoring" },
		Device { id: 0x3C71, name: "Xeon E5/Core i7 Integrated Memory Controller RAS Registers" },
		Device { id: 0x3C80, name: "Xeon E5/Core i7 QPI Link 0" },
		Device { id: 0x3C83, name: "Xeon E5/Core i7 QPI Link Reut 0" },
		Device { id: 0x3C84, name: "Xeon E5/Core i7 QPI Link Reut 0" },
		Device { id: 0x3C90, name: "Xeon E5/Core i7 QPI Link 1" },
		Device { id: 0x3C93, name: "Xeon E5/Core i7 QPI Link Reut 1" },
		Device { id: 0x3C94, name: "Xeon E5/Core i7 QPI Link Reut 1" },
		Device { id: 0x3CA0, name: "Xeon E5/Core i7 Processor Home Agent" },
		Device { id: 0x3CA8, name: "Xeon E5/Core i7 Integrated Memory Controller Registers" },
		Device { id: 0x3CAA, name: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 0" },
		Device { id: 0x3CAB, name: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 1" },
		Device { id: 0x3CAC, name: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 2" },
		Device { id: 0x3CAD, name: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 3" },
		Device { id: 0x3CAE, name: "Xeon E5/Core i7 Integrated Memory Controller Target Address Decoder 4" },
		Device { id: 0x3CB0, name: "Xeon E5/Core i7 Integrated Memory Controller Channel 0-3 Thermal Control 0" },
		Device { id: 0x3CB1, name: "Xeon E5/Core i7 Integrated Memory Controller Channel 0-3 Thermal Control 1" },
		Device { id: 0x3CB2, name: "Xeon E5/Core i7 Integrated Memory Controller ERROR Registers 0" },
		Device { id: 0x3CB3, name: "Xeon E5/Core i7 Integrated Memory Controller ERROR Registers 1" },
		Device { id: 0x3CB4, name: "Xeon E5/Core i7 Integrated Memory Controller Channel 0-3 Thermal Control 2" },
		Device { id: 0x3CB5, name: "Xeon E5/Core i7 Integrated Memory Controller Channel 0-3 Thermal Control 3" },
		Device { id: 0x3CB6, name: "Xeon E5/Core i7 Integrated Memory Controller ERROR Registers 2" },
		Device { id: 0x3CB7, name: "Xeon E5/Core i7 Integrated Memory Controller ERROR Registers 3" },
		Device { id: 0x3CB8, name: "Xeon E5/Core i7 DDRIO" },
		Device { id: 0x3CC0, name: "Xeon E5/Core i7 Power Control Unit 0" },
		Device { id: 0x3CC1, name: "Xeon E5/Core i7 Power Control Unit 1" },
		Device { id: 0x3CC2, name: "Xeon E5/Core i7 Power Control Unit 2" },
		Device { id: 0x3CD0, name: "Xeon E5/Core i7 Power Control Unit 3" },
		Device { id: 0x3CE0, name: "Xeon E5/Core i7 Interrupt Control Registers" },
		Device { id: 0x3CE3, name: "Xeon E5/Core i7 Semaphore and Scratchpad Configuration Registers" },
		Device { id: 0x3CE4, name: "Xeon E5/Core i7 R2PCIe" },
		Device { id: 0x3CE6, name: "Xeon E5/Core i7 QuickPath Interconnect Agent Ring Registers" },
		Device { id: 0x3CE8, name: "Xeon E5/Core i7 Unicast Register 0" },
		Device { id: 0x3CE9, name: "Xeon E5/Core i7 Unicast Register 5" },
		Device { id: 0x3CEA, name: "Xeon E5/Core i7 Unicast Register 1" },
		Device { id: 0x3CEB, name: "Xeon E5/Core i7 Unicast Register 6" },
		Device { id: 0x3CEC, name: "Xeon E5/Core i7 Unicast Register 3" },
		Device { id: 0x3CED, name: "Xeon E5/Core i7 Unicast Register 7" },
		Device { id: 0x3CEE, name: "Xeon E5/Core i7 Unicast Register 4" },
		Device { id: 0x3CEF, name: "Xeon E5/Core i7 Unicast Register 8" },
		Device { id: 0x3CF4, name: "Xeon E5/Core i7 Integrated Memory Controller System Address Decoder 0" },
		Device { id: 0x3CF5, name: "Xeon E5/Core i7 Integrated Memory Controller System Address Decoder 1" },
		Device { id: 0x3CF6, name: "Xeon E5/Core i7 System Address Decoder" },
		Device { id: 0x4000, name: "5400 Chipset Memory Controller Hub" },
		Device { id: 0x4001, name: "5400 Chipset Memory Controller Hub" },
		Device { id: 0x4003, name: "5400 Chipset Memory Controller Hub" },
		Device { id: 0x4021, name: "5400 Chipset PCI Express Port 1" },
		Device { id: 0x4022, name: "5400 Chipset PCI Express Port 2" },
		Device { id: 0x4023, name: "5400 Chipset PCI Express Port 3" },
		Device { id: 0x4024, name: "5400 Chipset PCI Express Port 4" },
		Device { id: 0x4025, name: "5400 Chipset PCI Express Port 5" },
		Device { id: 0x4026, name: "5400 Chipset PCI Express Port 6" },
		Device { id: 0x4027, name: "5400 Chipset PCI Express Port 7" },
		Device { id: 0x4028, name: "5400 Chipset PCI Express Port 8" },
		Device { id: 0x4029, name: "5400 Chipset PCI Express Port 9" },
		Device { id: 0x402D, name: "5400 Chipset IBIST Registers" },
		Device { id: 0x402E, name: "5400 Chipset IBIST Registers" },
		Device { id: 0x402F, name: "5400 Chipset QuickData Technology Device" },
		Device { id: 0x4030, name: "5400 Chipset FSB Registers" },
		Device { id: 0x4031, name: "5400 Chipset CE/SF Registers" },
		Device { id: 0x4032, name: "5400 Chipset IOxAPIC" },
		Device { id: 0x4035, name: "5400 Chipset FBD Registers" },
		Device { id: 0x4036, name: "5400 Chipset FBD Registers" },
		Device { id: 0x4100, name: "Moorestown Graphics and Video" },
		Device { id: 0x4108, name: "Atom Processor E6xx Integrated Graphics Controller" },
		Device { id: 0x4109, name: "Atom Processor E6xx Integrated Graphics Controller" },
		Device { id: 0x410A, name: "Atom Processor E6xx Integrated Graphics Controller" },
		Device { id: 0x410B, name: "Atom Processor E6xx Integrated Graphics Controller" },
		Device { id: 0x410C, name: "Atom Processor E6xx Integrated Graphics Controller" },
		Device { id: 0x410D, name: "Atom Processor E6xx Integrated Graphics Controller" },
		Device { id: 0x410E, name: "Atom Processor E6xx Integrated Graphics Controller" },
		Device { id: 0x410F, name: "Atom Processor E6xx Integrated Graphics Controller" },
		Device { id: 0x4114, name: "Atom Processor E6xx PCI Host Bridge #1" },
		Device { id: 0x4115, name: "Atom Processor E6xx PCI Host Bridge #2" },
		Device { id: 0x4116, name: "Atom Processor E6xx PCI Host Bridge #3" },
		Device { id: 0x4117, name: "Atom Processor E6xx PCI Host Bridge #4" },
		Device { id: 0x4220, name: "PRO/Wireless 2200BG [Calexico2] Network Connection" },
		Device { id: 0x4222, name: "PRO/Wireless 3945ABG [Golan] Network Connection" },
		Device { id: 0x4223, name: "PRO/Wireless 2915ABG [Calexico2] Network Connection" },
		Device { id: 0x4224, name: "PRO/Wireless 2915ABG [Calexico2] Network Connection" },
		Device { id: 0x4227, name: "PRO/Wireless 3945ABG [Golan] Network Connection" },
		Device { id: 0x4229, name: "PRO/Wireless 4965 AG or AGN [Kedron] Network Connection" },
		Device { id: 0x422B, name: "Centrino Ultimate-N 6300" },
		Device { id: 0x422C, name: "Centrino Advanced-N 6200" },
		Device { id: 0x4230, name: "PRO/Wireless 4965 AG or AGN [Kedron] Network Connection" },
		Device { id: 0x4232, name: "WiFi Link 5100" },
		Device { id: 0x4235, name: "Ultimate N WiFi Link 5300" },
		Device { id: 0x4236, name: "Ultimate N WiFi Link 5300" },
		Device { id: 0x4237, name: "PRO/Wireless 5100 AGN [Shiloh] Network Connection" },
		Device { id: 0x4238, name: "Centrino Ultimate-N 6300" },
		Device { id: 0x4239, name: "Centrino Advanced-N 6200" },
		Device { id: 0x423A, name: "PRO/Wireless 5350 AGN [Echo Peak] Network Connection" },
		Device { id: 0x423B, name: "PRO/Wireless 5350 AGN [Echo Peak] Network Connection" },
		Device { id: 0x423C, name: "WiMAX/WiFi Link 5150" },
		Device { id: 0x423D, name: "WiMAX/WiFi Link 5150" },
		Device { id: 0x444E, name: "Turbo Memory Controller" },
		Device { id: 0x5001, name: "LE80578" },
		Device { id: 0x5002, name: "LE80578 Graphics Processor Unit" },
		Device { id: 0x5009, name: "LE80578 Video Display Controller" },
		Device { id: 0x500D, name: "LE80578 Expansion Bus" },
		Device { id: 0x500E, name: "LE80578 UART Controller" },
		Device { id: 0x500F, name: "LE80578 General Purpose IO" },
		Device { id: 0x5010, name: "LE80578 I2C Controller" },
		Device { id: 0x5012, name: "LE80578 Serial Peripheral Interface Bus" },
		Device { id: 0x5020, name: "EP80579 Memory Controller Hub" },
		Device { id: 0x5021, name: "EP80579 DRAM Error Reporting Registers" },
		Device { id: 0x5023, name: "EP80579 EDMA Controller" },
		Device { id: 0x5024, name: "EP80579 PCI Express Port PEA0" },
		Device { id: 0x5025, name: "EP80579 PCI Express Port PEA1" },
		Device { id: 0x5028, name: "EP80579 S-ATA IDE" },
		Device { id: 0x5029, name: "EP80579 S-ATA AHCI" },
		Device { id: 0x502A, name: "EP80579 S-ATA Reserved" },
		Device { id: 0x502B, name: "EP80579 S-ATA Reserved" },
		Device { id: 0x502C, name: "EP80579 Integrated Processor ASU" },
		Device { id: 0x502D, name: "EP80579 Integrated Processor with QuickAssist ASU" },
		Device { id: 0x502E, name: "EP80579 Reserved" },
		Device { id: 0x502F, name: "EP80579 Reserved" },
		Device { id: 0x5030, name: "EP80579 Reserved" },
		Device { id: 0x5031, name: "EP80579 LPC Bus" },
		Device { id: 0x5032, name: "EP80579 SMBus Controller" },
		Device { id: 0x5033, name: "EP80579 USB 1.1 Controller" },
		Device { id: 0x5035, name: "EP80579 USB 2.0 Controller" },
		Device { id: 0x5037, name: "EP80579 PCI-PCI Bridge (transparent mode)" },
		Device { id: 0x5039, name: "EP80579 Controller Area Network (CAN) interface #1" },
		Device { id: 0x503A, name: "EP80579 Controller Area Network (CAN) interface #2" },
		Device { id: 0x503B, name: "EP80579 Synchronous Serial Port (SPP)" },
		Device { id: 0x503C, name: "EP80579 IEEE 1588 Hardware Assist" },
		Device { id: 0x503D, name: "EP80579 Local Expansion Bus" },
		Device { id: 0x503E, name: "EP80579 Global Control Unit (GCU)" },
		Device { id: 0x503F, name: "EP80579 Reserved" },
		Device { id: 0x5040, name: "EP80579 Integrated Processor Gigabit Ethernet MAC" },
		Device { id: 0x5041, name: "EP80579 Integrated Processor with QuickAssist Gigabit Ethernet MAC" },
		Device { id: 0x5042, name: "EP80579 Reserved" },
		Device { id: 0x5043, name: "EP80579 Reserved" },
		Device { id: 0x5044, name: "EP80579 Integrated Processor Gigabit Ethernet MAC" },
		Device { id: 0x5045, name: "EP80579 Integrated Processor with QuickAssist Gigabit Ethernet MAC" },
		Device { id: 0x5046, name: "EP80579 Reserved" },
		Device { id: 0x5047, name: "EP80579 Reserved" },
		Device { id: 0x5048, name: "EP80579 Integrated Processor Gigabit Ethernet MAC" },
		Device { id: 0x5049, name: "EP80579 Integrated Processor with QuickAssist Gigabit Ethernet MAC" },
		Device { id: 0x504A, name: "EP80579 Reserved" },
		Device { id: 0x504B, name: "EP80579 Reserved" },
		Device { id: 0x504C, name: "EP80579 Integrated Processor with QuickAssist TDM" },
		Device { id: 0x5200, name: "EtherExpress PRO/100 Intelligent Server PCI Bridge" },
		Device { id: 0x5201, name: "EtherExpress PRO/100 Intelligent Server Fast Ethernet Controller" },
		Device { id: 0x530D, name: "80310 (IOP) IO Processor" },
		Device { id: 0x5845, name: "QEMU NVM Express Controller" },
		Device { id: 0x5902, name: "HD Graphics 610" },
		Device { id: 0x5904, name: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x590F, name: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x5910, name: "Xeon E3-1200 v6/7th Gen Core Processor Host Bridge/DRAM Registers" },
		Device { id: 0x5912, name: "HD Graphics 630" },
		Device { id: 0x5916, name: "HD Graphics 620" },
		Device { id: 0x591D, name: "HD Graphics P630" },
		Device { id: 0x591F, name: "Intel Kaby Lake Host Bridge" },
		Device { id: 0x5A84, name: "Celeron N3350/Pentium N4200/Atom E3900 Series Integrated Graphics Controller" },
		Device { id: 0x5A88, name: "Celeron N3350/Pentium N4200/Atom E3900 Series Imaging Unit" },
		Device { id: 0x5A98, name: "Celeron N3350/Pentium N4200/Atom E3900 Series Audio Cluster" },
		Device { id: 0x5A9A, name: "Celeron N3350/Pentium N4200/Atom E3900 Series Trusted Execution Engine" },
		Device { id: 0x5AA2, name: "Celeron N3350/Pentium N4200/Atom E3900 Series Integrated Sensor Hub" },
		Device { id: 0x5AA8, name: "Celeron N3350/Pentium N4200/Atom E3900 Series USB xHCI" },
		Device { id: 0x5AAC, name: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #1" },
		Device { id: 0x5AAE, name: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #2" },
		Device { id: 0x5AB0, name: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #3" },
		Device { id: 0x5AB2, name: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #4" },
		Device { id: 0x5AB4, name: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #5" },
		Device { id: 0x5AB6, name: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #6" },
		Device { id: 0x5AB8, name: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #7" },
		Device { id: 0x5ABA, name: "Celeron N3350/Pentium N4200/Atom E3900 Series I2C Controller #8" },
		Device { id: 0x5ABC, name: "Celeron N3350/Pentium N4200/Atom E3900 Series HSUART Controller #1" },
		Device { id: 0x5ABE, name: "Celeron N3350/Pentium N4200/Atom E3900 Series HSUART Controller #2" },
		Device { id: 0x5AC0, name: "Celeron N3350/Pentium N4200/Atom E3900 Series HSUART Controller #3" },
		Device { id: 0x5AC2, name: "Celeron N3350/Pentium N4200/Atom E3900 Series SPI Controller #1" },
		Device { id: 0x5AC4, name: "Celeron N3350/Pentium N4200/Atom E3900 Series SPI Controller #2" },
		Device { id: 0x5AC6, name: "Celeron N3350/Pentium N4200/Atom E3900 Series SPI Controller #3" },
		Device { id: 0x5AC8, name: "Celeron N3350/Pentium N4200/Atom E3900 Series PWM Pin Controller" },
		Device { id: 0x5ACA, name: "Celeron N3350/Pentium N4200/Atom E3900 Series SDXC/MMC Host Controller" },
		Device { id: 0x5ACC, name: "Celeron N3350/Pentium N4200/Atom E3900 Series eMMC Controller" },
		Device { id: 0x5AD0, name: "Celeron N3350/Pentium N4200/Atom E3900 Series SDIO Controller" },
		Device { id: 0x5AD4, name: "Celeron N3350/Pentium N4200/Atom E3900 Series SMBus Controller" },
		Device { id: 0x5AD6, name: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port B #1" },
		Device { id: 0x5AD7, name: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port B #2" },
		Device { id: 0x5AD8, name: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port A #1" },
		Device { id: 0x5AD9, name: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port A #2" },
		Device { id: 0x5ADA, name: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port A #3" },
		Device { id: 0x5ADB, name: "Celeron N3350/Pentium N4200/Atom E3900 Series PCI Express Port A #4" },
		Device { id: 0x5AE3, name: "Celeron N3350/Pentium N4200/Atom E3900 Series SATA AHCI Controller" },
		Device { id: 0x5AE8, name: "Celeron N3350/Pentium N4200/Atom E3900 Series Low Pin Count Interface" },
		Device { id: 0x5AEE, name: "Celeron N3350/Pentium N4200/Atom E3900 Series HSUART Controller #4" },
		Device { id: 0x5AF0, name: "Celeron N3350/Pentium N4200/Atom E3900 Series Host Bridge" },
		Device {