/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!(
            (bit_offset + (bit_width as usize)) / 8
                <= self.storage.as_ref().len()
        );
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!(
            (bit_offset + (bit_width as usize)) / 8
                <= self.storage.as_ref().len()
        );
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const FACILITY_DXGI: u32 = 2170;
pub const FACILITY_DXGI_DDI: u32 = 2171;
pub const DXGI_STANDARD_MULTISAMPLE_QUALITY_PATTERN: u32 = 4294967295;
pub const DXGI_CENTER_MULTISAMPLE_QUALITY_PATTERN: u32 = 4294967294;
pub const DXGI_FORMAT_DEFINED: u32 = 1;
pub const D3D12_16BIT_INDEX_STRIP_CUT_VALUE: u32 = 65535;
pub const D3D12_32BIT_INDEX_STRIP_CUT_VALUE: u32 = 4294967295;
pub const D3D12_8BIT_INDEX_STRIP_CUT_VALUE: u32 = 255;
pub const D3D12_APPEND_ALIGNED_ELEMENT: u32 = 4294967295;
pub const D3D12_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT: u32 = 9;
pub const D3D12_CLIP_OR_CULL_DISTANCE_COUNT: u32 = 8;
pub const D3D12_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: u32 = 2;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT: u32 = 14;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS: u32 = 4;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT: u32 = 15;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT : u32 = 16 ;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT: u32 = 15;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST: u32 = 1;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT: u32 = 64;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS:
    u32 = 4;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT: u32 = 1;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST : u32 = 1 ;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS:
    u32 = 1;
pub const D3D12_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT: u32 = 128;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST: u32 = 1;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT: u32 = 128;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_COUNT: u32 = 16;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST: u32 = 1;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_COMMONSHADER_SAMPLER_SLOT_COUNT: u32 = 16;
pub const D3D12_COMMONSHADER_SUBROUTINE_NESTING_LIMIT: u32 = 32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COUNT: u32 = 4096;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_READS_PER_INST: u32 = 3;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_READ_PORTS: u32 = 3;
pub const D3D12_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX: u32 = 10;
pub const D3D12_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN: i32 = -10;
pub const D3D12_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE: i32 = -8;
pub const D3D12_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE: u32 = 7;
pub const D3D12_CONSTANT_BUFFER_DATA_PLACEMENT_ALIGNMENT: u32 = 256;
pub const D3D12_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 256;
pub const D3D12_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP: u32 = 64;
pub const D3D12_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 240;
pub const D3D12_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP: u32 = 68;
pub const D3D12_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 224;
pub const D3D12_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP: u32 = 72;
pub const D3D12_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 208;
pub const D3D12_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP: u32 = 76;
pub const D3D12_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 192;
pub const D3D12_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP: u32 = 84;
pub const D3D12_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 176;
pub const D3D12_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP: u32 = 92;
pub const D3D12_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 160;
pub const D3D12_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP: u32 = 100;
pub const D3D12_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 144;
pub const D3D12_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP: u32 = 112;
pub const D3D12_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 128;
pub const D3D12_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP: u32 = 128;
pub const D3D12_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 112;
pub const D3D12_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP: u32 = 144;
pub const D3D12_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 96;
pub const D3D12_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP: u32 = 168;
pub const D3D12_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 80;
pub const D3D12_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP: u32 = 204;
pub const D3D12_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 64;
pub const D3D12_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP: u32 = 256;
pub const D3D12_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 48;
pub const D3D12_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP: u32 = 340;
pub const D3D12_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 32;
pub const D3D12_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP: u32 = 512;
pub const D3D12_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 16;
pub const D3D12_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP: u32 = 768;
pub const D3D12_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION: u32 = 1;
pub const D3D12_CS_4_X_RAW_UAV_BYTE_ALIGNMENT: u32 = 256;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP: u32 = 768;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_X: u32 = 768;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_Y: u32 = 768;
pub const D3D12_CS_4_X_UAV_REGISTER_COUNT: u32 = 1;
pub const D3D12_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION: u32 = 65535;
pub const D3D12_CS_TGSM_REGISTER_COUNT: u32 = 8192;
pub const D3D12_CS_TGSM_REGISTER_READS_PER_INST: u32 = 1;
pub const D3D12_CS_TGSM_RESOURCE_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_CS_TGSM_RESOURCE_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_CS_THREADGROUPID_REGISTER_COMPONENTS: u32 = 3;
pub const D3D12_CS_THREADGROUPID_REGISTER_COUNT: u32 = 1;
pub const D3D12_CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT: u32 = 1;
pub const D3D12_CS_THREADIDINGROUP_REGISTER_COMPONENTS: u32 = 3;
pub const D3D12_CS_THREADIDINGROUP_REGISTER_COUNT: u32 = 1;
pub const D3D12_CS_THREADID_REGISTER_COMPONENTS: u32 = 3;
pub const D3D12_CS_THREADID_REGISTER_COUNT: u32 = 1;
pub const D3D12_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP: u32 = 1024;
pub const D3D12_CS_THREAD_GROUP_MAX_X: u32 = 1024;
pub const D3D12_CS_THREAD_GROUP_MAX_Y: u32 = 1024;
pub const D3D12_CS_THREAD_GROUP_MAX_Z: u32 = 64;
pub const D3D12_CS_THREAD_GROUP_MIN_X: u32 = 1;
pub const D3D12_CS_THREAD_GROUP_MIN_Y: u32 = 1;
pub const D3D12_CS_THREAD_GROUP_MIN_Z: u32 = 1;
pub const D3D12_CS_THREAD_LOCAL_TEMP_REGISTER_POOL: u32 = 16384;
pub const D3D12_DEFAULT_BLEND_FACTOR_ALPHA: f64 = 1.0;
pub const D3D12_DEFAULT_BLEND_FACTOR_BLUE: f64 = 1.0;
pub const D3D12_DEFAULT_BLEND_FACTOR_GREEN: f64 = 1.0;
pub const D3D12_DEFAULT_BLEND_FACTOR_RED: f64 = 1.0;
pub const D3D12_DEFAULT_BORDER_COLOR_COMPONENT: f64 = 0.0;
pub const D3D12_DEFAULT_DEPTH_BIAS: u32 = 0;
pub const D3D12_DEFAULT_DEPTH_BIAS_CLAMP: f64 = 0.0;
pub const D3D12_DEFAULT_MAX_ANISOTROPY: u32 = 16;
pub const D3D12_DEFAULT_MIP_LOD_BIAS: f64 = 0.0;
pub const D3D12_DEFAULT_MSAA_RESOURCE_PLACEMENT_ALIGNMENT: u32 = 4194304;
pub const D3D12_DEFAULT_RENDER_TARGET_ARRAY_INDEX: u32 = 0;
pub const D3D12_DEFAULT_RESOURCE_PLACEMENT_ALIGNMENT: u32 = 65536;
pub const D3D12_DEFAULT_SAMPLE_MASK: u32 = 4294967295;
pub const D3D12_DEFAULT_SCISSOR_ENDX: u32 = 0;
pub const D3D12_DEFAULT_SCISSOR_ENDY: u32 = 0;
pub const D3D12_DEFAULT_SCISSOR_STARTX: u32 = 0;
pub const D3D12_DEFAULT_SCISSOR_STARTY: u32 = 0;
pub const D3D12_DEFAULT_SLOPE_SCALED_DEPTH_BIAS: f64 = 0.0;
pub const D3D12_DEFAULT_STENCIL_READ_MASK: u32 = 255;
pub const D3D12_DEFAULT_STENCIL_REFERENCE: u32 = 0;
pub const D3D12_DEFAULT_STENCIL_WRITE_MASK: u32 = 255;
pub const D3D12_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX: u32 = 0;
pub const D3D12_DEFAULT_VIEWPORT_HEIGHT: u32 = 0;
pub const D3D12_DEFAULT_VIEWPORT_MAX_DEPTH: f64 = 0.0;
pub const D3D12_DEFAULT_VIEWPORT_MIN_DEPTH: f64 = 0.0;
pub const D3D12_DEFAULT_VIEWPORT_TOPLEFTX: u32 = 0;
pub const D3D12_DEFAULT_VIEWPORT_TOPLEFTY: u32 = 0;
pub const D3D12_DEFAULT_VIEWPORT_WIDTH: u32 = 0;
pub const D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND: u32 = 4294967295;
pub const D3D12_DRIVER_RESERVED_REGISTER_SPACE_VALUES_END: u32 = 4294967287;
pub const D3D12_DRIVER_RESERVED_REGISTER_SPACE_VALUES_START: u32 = 4294967280;
pub const D3D12_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: u32 = 3968;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COUNT: u32 = 32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS: u32 = 3;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT: u32 = 1;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT: u32 = 32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: u32 = 1;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_DS_OUTPUT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_DS_OUTPUT_REGISTER_COUNT: u32 = 32;
pub const D3D12_FLOAT16_FUSED_TOLERANCE_IN_ULP: f64 = 0.6;
pub const D3D12_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP: f64 = 0.6;
pub const D3D12_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR: f64 = 2.4;
pub const D3D12_FLOAT_TO_SRGB_EXPONENT_NUMERATOR: f64 = 1.0;
pub const D3D12_FLOAT_TO_SRGB_OFFSET: f64 = 0.055;
pub const D3D12_FLOAT_TO_SRGB_SCALE_1: f64 = 12.92;
pub const D3D12_FLOAT_TO_SRGB_SCALE_2: f64 = 1.055;
pub const D3D12_FLOAT_TO_SRGB_THRESHOLD: f64 = 0.0031308;
pub const D3D12_FTOI_INSTRUCTION_MAX_INPUT: f64 = 2147483647.999;
pub const D3D12_FTOI_INSTRUCTION_MIN_INPUT: f64 = -2147483648.999;
pub const D3D12_FTOU_INSTRUCTION_MAX_INPUT: f64 = 4294967295.999;
pub const D3D12_FTOU_INSTRUCTION_MIN_INPUT: f64 = 0.0;
pub const D3D12_GS_INPUT_INSTANCE_ID_READS_PER_INST: u32 = 2;
pub const D3D12_GS_INPUT_INSTANCE_ID_READ_PORTS: u32 = 1;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COUNT: u32 = 1;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COUNT: u32 = 1;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_GS_INPUT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_GS_INPUT_REGISTER_COUNT: u32 = 32;
pub const D3D12_GS_INPUT_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_GS_INPUT_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_GS_INPUT_REGISTER_VERTICES: u32 = 32;
pub const D3D12_GS_MAX_INSTANCE_COUNT: u32 = 32;
pub const D3D12_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES: u32 = 1024;
pub const D3D12_GS_OUTPUT_ELEMENTS: u32 = 32;
pub const D3D12_GS_OUTPUT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_GS_OUTPUT_REGISTER_COUNT: u32 = 32;
pub const D3D12_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT: u32 = 32;
pub const D3D12_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT: u32 = 32;
pub const D3D12_HS_CONTROL_POINT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_HS_CONTROL_POINT_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_HS_CONTROL_POINT_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND: u32 = 4294967295;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 =
    32;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT: u32 = 1;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 =
    32;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT: u32 = 1;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: u32 = 1;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND: u32 = 4294967295;
pub const D3D12_HS_MAXTESSFACTOR_LOWER_BOUND: f64 = 1.0;
pub const D3D12_HS_MAXTESSFACTOR_UPPER_BOUND: f64 = 64.0;
pub const D3D12_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: u32 = 3968;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT: u32 =
    32;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT: u32 = 1;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT: u32 = 32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS: u32 = 128;
pub const D3D12_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES: u32 = 0;
pub const D3D12_IA_DEFAULT_PRIMITIVE_TOPOLOGY: u32 = 0;
pub const D3D12_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES: u32 = 0;
pub const D3D12_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT: u32 = 1;
pub const D3D12_IA_INSTANCE_ID_BIT_COUNT: u32 = 32;
pub const D3D12_IA_INTEGER_ARITHMETIC_BIT_COUNT: u32 = 32;
pub const D3D12_IA_PATCH_MAX_CONTROL_POINT_COUNT: u32 = 32;
pub const D3D12_IA_PRIMITIVE_ID_BIT_COUNT: u32 = 32;
pub const D3D12_IA_VERTEX_ID_BIT_COUNT: u32 = 32;
pub const D3D12_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT: u32 = 32;
pub const D3D12_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS: u32 = 128;
pub const D3D12_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT: u32 = 32;
pub const D3D12_INTEGER_DIVIDE_BY_ZERO_QUOTIENT: u32 = 4294967295;
pub const D3D12_INTEGER_DIVIDE_BY_ZERO_REMAINDER: u32 = 4294967295;
pub const D3D12_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL: u32 = 4294967295;
pub const D3D12_KEEP_UNORDERED_ACCESS_VIEWS: u32 = 4294967295;
pub const D3D12_LINEAR_GAMMA: f64 = 1.0;
pub const D3D12_MAJOR_VERSION: u32 = 12;
pub const D3D12_MAX_BORDER_COLOR_COMPONENT: f64 = 1.0;
pub const D3D12_MAX_DEPTH: f64 = 1.0;
pub const D3D12_MAX_LIVE_STATIC_SAMPLERS: u32 = 2032;
pub const D3D12_MAX_MAXANISOTROPY: u32 = 16;
pub const D3D12_MAX_MULTISAMPLE_SAMPLE_COUNT: u32 = 32;
pub const D3D12_MAX_ROOT_COST: u32 = 64;
pub const D3D12_MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_1: u32 = 1000000;
pub const D3D12_MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_2: u32 = 1000000;
pub const D3D12_MAX_SHADER_VISIBLE_SAMPLER_HEAP_SIZE: u32 = 2048;
pub const D3D12_MAX_TEXTURE_DIMENSION_2_TO_EXP: u32 = 17;
pub const D3D12_MAX_VIEW_INSTANCE_COUNT: u32 = 4;
pub const D3D12_MINOR_VERSION: u32 = 0;
pub const D3D12_MIN_BORDER_COLOR_COMPONENT: f64 = 0.0;
pub const D3D12_MIN_DEPTH: f64 = 0.0;
pub const D3D12_MIN_MAXANISOTROPY: u32 = 0;
pub const D3D12_MIP_LOD_BIAS_MAX: f64 = 15.99;
pub const D3D12_MIP_LOD_BIAS_MIN: f64 = -16.0;
pub const D3D12_MIP_LOD_FRACTIONAL_BIT_COUNT: u32 = 8;
pub const D3D12_MIP_LOD_RANGE_BIT_COUNT: u32 = 8;
pub const D3D12_MULTISAMPLE_ANTIALIAS_LINE_WIDTH: f64 = 1.4;
pub const D3D12_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT: u32 = 0;
pub const D3D12_OS_RESERVED_REGISTER_SPACE_VALUES_END: u32 = 4294967295;
pub const D3D12_OS_RESERVED_REGISTER_SPACE_VALUES_START: u32 = 4294967288;
pub const D3D12_PACKED_TILE: u32 = 4294967295;
pub const D3D12_PIXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 15;
pub const D3D12_PREVIEW_SDK_VERSION: u32 = 700;
pub const D3D12_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 16;
pub const D3D12_PS_CS_UAV_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_PS_CS_UAV_REGISTER_COUNT: u32 = 8;
pub const D3D12_PS_CS_UAV_REGISTER_READS_PER_INST: u32 = 1;
pub const D3D12_PS_CS_UAV_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_PS_FRONTFACING_DEFAULT_VALUE: u32 = 4294967295;
pub const D3D12_PS_FRONTFACING_FALSE_VALUE: u32 = 0;
pub const D3D12_PS_FRONTFACING_TRUE_VALUE: u32 = 4294967295;
pub const D3D12_PS_INPUT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_PS_INPUT_REGISTER_COUNT: u32 = 32;
pub const D3D12_PS_INPUT_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_PS_INPUT_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT: f64 = 0.0;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COUNT: u32 = 1;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COMPONENTS: u32 = 1;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COUNT: u32 = 1;
pub const D3D12_PS_OUTPUT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_PS_OUTPUT_REGISTER_COUNT: u32 = 8;
pub const D3D12_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT: f64 = 0.5;
pub const D3D12_RAW_UAV_SRV_BYTE_ALIGNMENT: u32 = 16;
pub const D3D12_RAYTRACING_AABB_BYTE_ALIGNMENT: u32 = 8;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BYTE_ALIGNMENT: u32 = 256;
pub const D3D12_RAYTRACING_INSTANCE_DESCS_BYTE_ALIGNMENT: u32 = 16;
pub const D3D12_RAYTRACING_MAX_ATTRIBUTE_SIZE_IN_BYTES: u32 = 32;
pub const D3D12_RAYTRACING_MAX_DECLARABLE_TRACE_RECURSION_DEPTH: u32 = 31;
pub const D3D12_RAYTRACING_MAX_GEOMETRIES_PER_BOTTOM_LEVEL_ACCELERATION_STRUCTURE : u32 = 16777216 ;
pub const D3D12_RAYTRACING_MAX_INSTANCES_PER_TOP_LEVEL_ACCELERATION_STRUCTURE : u32 = 16777216 ;
pub const D3D12_RAYTRACING_MAX_PRIMITIVES_PER_BOTTOM_LEVEL_ACCELERATION_STRUCTURE : u32 = 536870912 ;
pub const D3D12_RAYTRACING_MAX_RAY_GENERATION_SHADER_THREADS: u32 = 1073741824;
pub const D3D12_RAYTRACING_MAX_SHADER_RECORD_STRIDE: u32 = 4096;
pub const D3D12_RAYTRACING_SHADER_RECORD_BYTE_ALIGNMENT: u32 = 32;
pub const D3D12_RAYTRACING_SHADER_TABLE_BYTE_ALIGNMENT: u32 = 64;
pub const D3D12_RAYTRACING_TRANSFORM3X4_BYTE_ALIGNMENT: u32 = 16;
pub const D3D12_REQ_BLEND_OBJECT_COUNT_PER_DEVICE: u32 = 4096;
pub const D3D12_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP: u32 = 27;
pub const D3D12_REQ_CONSTANT_BUFFER_ELEMENT_COUNT: u32 = 4096;
pub const D3D12_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE: u32 = 4096;
pub const D3D12_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: u32 = 32;
pub const D3D12_REQ_DRAW_VERTEX_COUNT_2_TO_EXP: u32 = 32;
pub const D3D12_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION: u32 = 16384;
pub const D3D12_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT: u32 = 1024;
pub const D3D12_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT: u32 = 4096;
pub const D3D12_REQ_MAXANISOTROPY: u32 = 16;
pub const D3D12_REQ_MIP_LEVELS: u32 = 15;
pub const D3D12_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES: u32 = 2048;
pub const D3D12_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE: u32 = 4096;
pub const D3D12_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH: u32 = 16384;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM: u32 = 128;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM: f64 = 0.25;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM: u32 = 2048;
pub const D3D12_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP: u32 = 20;
pub const D3D12_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE: u32 = 4096;
pub const D3D12_REQ_SUBRESOURCES: u32 = 30720;
pub const D3D12_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION: u32 = 2048;
pub const D3D12_REQ_TEXTURE1D_U_DIMENSION: u32 = 16384;
pub const D3D12_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION: u32 = 2048;
pub const D3D12_REQ_TEXTURE2D_U_OR_V_DIMENSION: u32 = 16384;
pub const D3D12_REQ_TEXTURE3D_U_V_OR_W_DIMENSION: u32 = 2048;
pub const D3D12_REQ_TEXTURECUBE_DIMENSION: u32 = 16384;
pub const D3D12_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL: u32 = 0;
pub const D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES: u32 = 4294967295;
pub const D3D12_RS_SET_SHADING_RATE_COMBINER_COUNT: u32 = 2;
pub const D3D12_SDK_VERSION: u32 = 600;
pub const D3D12_SHADER_IDENTIFIER_SIZE_IN_BYTES: u32 = 32;
pub const D3D12_SHADER_MAJOR_VERSION: u32 = 5;
pub const D3D12_SHADER_MAX_INSTANCES: u32 = 65535;
pub const D3D12_SHADER_MAX_INTERFACES: u32 = 253;
pub const D3D12_SHADER_MAX_INTERFACE_CALL_SITES: u32 = 4096;
pub const D3D12_SHADER_MAX_TYPES: u32 = 65535;
pub const D3D12_SHADER_MINOR_VERSION: u32 = 1;
pub const D3D12_SHIFT_INSTRUCTION_PAD_VALUE: u32 = 0;
pub const D3D12_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT: u32 = 5;
pub const D3D12_SIMULTANEOUS_RENDER_TARGET_COUNT: u32 = 8;
pub const D3D12_SMALL_MSAA_RESOURCE_PLACEMENT_ALIGNMENT: u32 = 65536;
pub const D3D12_SMALL_RESOURCE_PLACEMENT_ALIGNMENT: u32 = 4096;
pub const D3D12_SO_BUFFER_MAX_STRIDE_IN_BYTES: u32 = 2048;
pub const D3D12_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES: u32 = 512;
pub const D3D12_SO_BUFFER_SLOT_COUNT: u32 = 4;
pub const D3D12_SO_DDI_REGISTER_INDEX_DENOTING_GAP: u32 = 4294967295;
pub const D3D12_SO_NO_RASTERIZED_STREAM: u32 = 4294967295;
pub const D3D12_SO_OUTPUT_COMPONENT_COUNT: u32 = 128;
pub const D3D12_SO_STREAM_COUNT: u32 = 4;
pub const D3D12_SPEC_DATE_DAY: u32 = 14;
pub const D3D12_SPEC_DATE_MONTH: u32 = 11;
pub const D3D12_SPEC_DATE_YEAR: u32 = 2014;
pub const D3D12_SPEC_VERSION: f64 = 1.16;
pub const D3D12_SRGB_GAMMA: f64 = 2.2;
pub const D3D12_SRGB_TO_FLOAT_DENOMINATOR_1: f64 = 12.92;
pub const D3D12_SRGB_TO_FLOAT_DENOMINATOR_2: f64 = 1.055;
pub const D3D12_SRGB_TO_FLOAT_EXPONENT: f64 = 2.4;
pub const D3D12_SRGB_TO_FLOAT_OFFSET: f64 = 0.055;
pub const D3D12_SRGB_TO_FLOAT_THRESHOLD: f64 = 0.04045;
pub const D3D12_SRGB_TO_FLOAT_TOLERANCE_IN_ULP: f64 = 0.5;
pub const D3D12_STANDARD_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_STANDARD_COMPONENT_BIT_COUNT_DOUBLED: u32 = 64;
pub const D3D12_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE: u32 = 4;
pub const D3D12_STANDARD_PIXEL_COMPONENT_COUNT: u32 = 128;
pub const D3D12_STANDARD_PIXEL_ELEMENT_COUNT: u32 = 32;
pub const D3D12_STANDARD_VECTOR_SIZE: u32 = 4;
pub const D3D12_STANDARD_VERTEX_ELEMENT_COUNT: u32 = 32;
pub const D3D12_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT: u32 = 64;
pub const D3D12_SUBPIXEL_FRACTIONAL_BIT_COUNT: u32 = 8;
pub const D3D12_SUBTEXEL_FRACTIONAL_BIT_COUNT: u32 = 8;
pub const D3D12_SYSTEM_RESERVED_REGISTER_SPACE_VALUES_END: u32 = 4294967295;
pub const D3D12_SYSTEM_RESERVED_REGISTER_SPACE_VALUES_START: u32 = 4294967280;
pub const D3D12_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR: u32 = 64;
pub const D3D12_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR: u32 = 64;
pub const D3D12_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR: u32 = 63;
pub const D3D12_TESSELLATOR_MAX_TESSELLATION_FACTOR: u32 = 64;
pub const D3D12_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR: u32 = 2;
pub const D3D12_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR: u32 = 1;
pub const D3D12_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR: u32 = 1;
pub const D3D12_TEXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 16;
pub const D3D12_TEXTURE_DATA_PITCH_ALIGNMENT: u32 = 256;
pub const D3D12_TEXTURE_DATA_PLACEMENT_ALIGNMENT: u32 = 512;
pub const D3D12_TILED_RESOURCE_TILE_SIZE_IN_BYTES: u32 = 65536;
pub const D3D12_TRACKED_WORKLOAD_MAX_INSTANCES: u32 = 32;
pub const D3D12_UAV_COUNTER_PLACEMENT_ALIGNMENT: u32 = 4096;
pub const D3D12_UAV_SLOT_COUNT: u32 = 64;
pub const D3D12_UNBOUND_MEMORY_ACCESS_RESULT: u32 = 0;
pub const D3D12_VIDEO_DECODE_MAX_ARGUMENTS: u32 = 10;
pub const D3D12_VIDEO_DECODE_MAX_HISTOGRAM_COMPONENTS: u32 = 4;
pub const D3D12_VIDEO_DECODE_MIN_BITSTREAM_OFFSET_ALIGNMENT: u32 = 256;
pub const D3D12_VIDEO_DECODE_MIN_HISTOGRAM_OFFSET_ALIGNMENT: u32 = 256;
pub const D3D12_VIDEO_DECODE_STATUS_MACROBLOCKS_AFFECTED_UNKNOWN: u32 =
    4294967295;
pub const D3D12_VIDEO_PROCESS_MAX_FILTERS: u32 = 32;
pub const D3D12_VIDEO_PROCESS_STEREO_VIEWS: u32 = 2;
pub const D3D12_VIEWPORT_AND_SCISSORRECT_MAX_INDEX: u32 = 15;
pub const D3D12_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE: u32 = 16;
pub const D3D12_VIEWPORT_BOUNDS_MAX: u32 = 32767;
pub const D3D12_VIEWPORT_BOUNDS_MIN: i32 = -32768;
pub const D3D12_VS_INPUT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_VS_INPUT_REGISTER_COUNT: u32 = 32;
pub const D3D12_VS_INPUT_REGISTER_READS_PER_INST: u32 = 2;
pub const D3D12_VS_INPUT_REGISTER_READ_PORTS: u32 = 1;
pub const D3D12_VS_OUTPUT_REGISTER_COMPONENTS: u32 = 4;
pub const D3D12_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32;
pub const D3D12_VS_OUTPUT_REGISTER_COUNT: u32 = 32;
pub const D3D12_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT: u32 = 10;
pub const D3D12_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: u32 = 25;
pub const D3D12_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP: u32 = 25;
pub const D3D12_SHADER_COMPONENT_MAPPING_MASK: u32 = 7;
pub const D3D12_SHADER_COMPONENT_MAPPING_SHIFT: u32 = 3;
pub const D3D12_SHADER_COMPONENT_MAPPING_ALWAYS_SET_BIT_AVOIDING_ZEROMEM_MISTAKES : u32 = 4096 ;
pub const D3D12_FILTER_REDUCTION_TYPE_MASK: u32 = 3;
pub const D3D12_FILTER_REDUCTION_TYPE_SHIFT: u32 = 7;
pub const D3D12_FILTER_TYPE_MASK: u32 = 3;
pub const D3D12_MIN_FILTER_SHIFT: u32 = 4;
pub const D3D12_MAG_FILTER_SHIFT: u32 = 2;
pub const D3D12_MIP_FILTER_SHIFT: u32 = 0;
pub const D3D12_ANISOTROPIC_FILTERING_BIT: u32 = 64;
pub const D3D12_INFO_QUEUE_DEFAULT_MESSAGE_COUNT_LIMIT: u32 = 1024;
pub const D3D12_SHADING_RATE_X_AXIS_SHIFT: u32 = 2;
pub const D3D12_SHADING_RATE_VALID_MASK: u32 = 3;
pub const _FACDXGI: u32 = 2170;
pub const DXGI_CPU_ACCESS_NONE: u32 = 0;
pub const DXGI_CPU_ACCESS_DYNAMIC: u32 = 1;
pub const DXGI_CPU_ACCESS_READ_WRITE: u32 = 2;
pub const DXGI_CPU_ACCESS_SCRATCH: u32 = 3;
pub const DXGI_CPU_ACCESS_FIELD: u32 = 15;
pub const DXGI_USAGE_SHADER_INPUT: u32 = 16;
pub const DXGI_USAGE_RENDER_TARGET_OUTPUT: u32 = 32;
pub const DXGI_USAGE_BACK_BUFFER: u32 = 64;
pub const DXGI_USAGE_SHARED: u32 = 128;
pub const DXGI_USAGE_READ_ONLY: u32 = 256;
pub const DXGI_USAGE_DISCARD_ON_PRESENT: u32 = 512;
pub const DXGI_USAGE_UNORDERED_ACCESS: u32 = 1024;
pub const DXGI_RESOURCE_PRIORITY_MINIMUM: u32 = 671088640;
pub const DXGI_RESOURCE_PRIORITY_LOW: u32 = 1342177280;
pub const DXGI_RESOURCE_PRIORITY_NORMAL: u32 = 2013265920;
pub const DXGI_RESOURCE_PRIORITY_HIGH: u32 = 2684354560;
pub const DXGI_RESOURCE_PRIORITY_MAXIMUM: u32 = 3355443200;
pub const DXGI_MAP_READ: u32 = 1;
pub const DXGI_MAP_WRITE: u32 = 2;
pub const DXGI_MAP_DISCARD: u32 = 4;
pub const DXGI_ENUM_MODES_INTERLACED: u32 = 1;
pub const DXGI_ENUM_MODES_SCALING: u32 = 2;
pub const DXGI_MAX_SWAP_CHAIN_BUFFERS: u32 = 16;
pub const DXGI_PRESENT_TEST: u32 = 1;
pub const DXGI_PRESENT_DO_NOT_SEQUENCE: u32 = 2;
pub const DXGI_PRESENT_RESTART: u32 = 4;
pub const DXGI_PRESENT_DO_NOT_WAIT: u32 = 8;
pub const DXGI_PRESENT_STEREO_PREFER_RIGHT: u32 = 16;
pub const DXGI_PRESENT_STEREO_TEMPORARY_MONO: u32 = 32;
pub const DXGI_PRESENT_RESTRICT_TO_OUTPUT: u32 = 64;
pub const DXGI_PRESENT_USE_DURATION: u32 = 256;
pub const DXGI_PRESENT_ALLOW_TEARING: u32 = 512;
pub const DXGI_MWA_NO_WINDOW_CHANGES: u32 = 1;
pub const DXGI_MWA_NO_ALT_ENTER: u32 = 2;
pub const DXGI_MWA_NO_PRINT_SCREEN: u32 = 4;
pub const DXGI_MWA_VALID: u32 = 7;
pub const DXGI_ENUM_MODES_STEREO: u32 = 4;
pub const DXGI_ENUM_MODES_DISABLED_STEREO: u32 = 8;
pub const DXGI_SHARED_RESOURCE_READ: u32 = 2147483648;
pub const DXGI_SHARED_RESOURCE_WRITE: u32 = 1;
pub const DXGI_CREATE_FACTORY_DEBUG: u32 = 1;
pub type wchar_t = ::std::os::raw::c_ushort;
pub type ULONG = ::std::os::raw::c_ulong;
pub type DWORD = ::std::os::raw::c_ulong;
pub type BOOL = ::std::os::raw::c_int;
pub type BYTE = ::std::os::raw::c_uchar;
pub type WORD = ::std::os::raw::c_ushort;
pub type FLOAT = f32;
pub type LPBYTE = *mut BYTE;
pub type LPDWORD = *mut DWORD;
pub type LPVOID = *mut ::std::os::raw::c_void;
pub type LPCVOID = *const ::std::os::raw::c_void;
pub type INT = ::std::os::raw::c_int;
pub type UINT = ::std::os::raw::c_uint;
pub type INT8 = ::std::os::raw::c_schar;
pub type UINT8 = ::std::os::raw::c_uchar;
pub type UINT16 = ::std::os::raw::c_ushort;
pub type UINT32 = ::std::os::raw::c_uint;
pub type UINT64 = ::std::os::raw::c_ulonglong;
pub type LONG_PTR = ::std::os::raw::c_longlong;
pub type ULONG_PTR = ::std::os::raw::c_ulonglong;
pub type SIZE_T = ULONG_PTR;
pub type PVOID = *mut ::std::os::raw::c_void;
pub type CHAR = ::std::os::raw::c_char;
pub type LONG = ::std::os::raw::c_long;
pub type WCHAR = wchar_t;
pub type LPWSTR = *mut WCHAR;
pub type PWSTR = *mut WCHAR;
pub type LPCWSTR = *const WCHAR;
pub type LPSTR = *mut CHAR;
pub type LPCSTR = *const CHAR;
pub type HANDLE = *mut ::std::os::raw::c_void;
pub type HRESULT = ::std::os::raw::c_long;
pub type LCID = DWORD;
pub type LANGID = WORD;
pub type LONGLONG = ::std::os::raw::c_longlong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _LARGE_INTEGER {
    pub __bindgen_anon_1: _LARGE_INTEGER__bindgen_ty_1,
    pub u: _LARGE_INTEGER__bindgen_ty_2,
    pub QuadPart: LONGLONG,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _LARGE_INTEGER__bindgen_ty_1 {
    pub LowPart: DWORD,
    pub HighPart: LONG,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _LARGE_INTEGER__bindgen_ty_2 {
    pub LowPart: DWORD,
    pub HighPart: LONG,
}
impl Default for _LARGE_INTEGER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for _LARGE_INTEGER {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_LARGE_INTEGER {{ union }}")
    }
}
pub type LARGE_INTEGER = _LARGE_INTEGER;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _LUID {
    pub LowPart: DWORD,
    pub HighPart: LONG,
}
pub type LUID = _LUID;
pub type BOOLEAN = BYTE;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _GUID {
    pub Data1: ::std::os::raw::c_ulong,
    pub Data2: ::std::os::raw::c_ushort,
    pub Data3: ::std::os::raw::c_ushort,
    pub Data4: [::std::os::raw::c_uchar; 8usize],
}
pub type GUID = _GUID;
pub type IID = GUID;
pub type LPARAM = LONG_PTR;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct HMETAFILE__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HMETAFILE = *mut HMETAFILE__;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct HINSTANCE__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HINSTANCE = *mut HINSTANCE__;
pub type HMODULE = HINSTANCE;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct HWINSTA__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HWINSTA = *mut HWINSTA__;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct HWND__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HWND = *mut HWND__;
pub type HGDIOBJ = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct HDC__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HDC = *mut HDC__;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct HDESK__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HDESK = *mut HDESK__;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct HENHMETAFILE__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HENHMETAFILE = *mut HENHMETAFILE__;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct HMONITOR__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HMONITOR = *mut HMONITOR__;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagRECT {
    pub left: LONG,
    pub top: LONG,
    pub right: LONG,
    pub bottom: LONG,
}
pub type RECT = tagRECT;
pub type LPRECT = *mut tagRECT;
pub type LPCRECT = *const RECT;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagPOINT {
    pub x: LONG,
    pub y: LONG,
}
pub type POINT = tagPOINT;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _POINTL {
    pub x: LONG,
    pub y: LONG,
}
pub type POINTL = _POINTL;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _SECURITY_ATTRIBUTES {
    pub nLength: DWORD,
    pub lpSecurityDescriptor: LPVOID,
    pub bInheritHandle: BOOL,
}
impl Default for _SECURITY_ATTRIBUTES {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SECURITY_ATTRIBUTES = _SECURITY_ATTRIBUTES;
pub type LPSECURITY_ATTRIBUTES = *mut _SECURITY_ATTRIBUTES;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _SYSTEMTIME {
    pub wYear: WORD,
    pub wMonth: WORD,
    pub wDayOfWeek: WORD,
    pub wDay: WORD,
    pub wHour: WORD,
    pub wMinute: WORD,
    pub wSecond: WORD,
    pub wMilliseconds: WORD,
}
pub type SYSTEMTIME = _SYSTEMTIME;
extern "C" {
    pub fn CloseHandle(hObject: HANDLE) -> BOOL;
}
extern "C" {
    pub fn WaitForSingleObject(hHandle: HANDLE, dwMilliseconds: DWORD)
        -> DWORD;
}
extern "C" {
    pub fn CreateEventW(
        lpEventAttributes: LPSECURITY_ATTRIBUTES,
        bManualReset: BOOL,
        bInitialState: BOOL,
        lpName: LPCWSTR,
    ) -> HANDLE;
}
extern "C" {
    pub fn EnumSystemFirmwareTables(
        FirmwareTableProviderSignature: DWORD,
        pFirmwareTableEnumBuffer: PVOID,
        BufferSize: DWORD,
    ) -> UINT;
}
pub type ENUMRESLANGPROCA = ::std::option::Option<
    unsafe extern "C" fn(
        hModule: HMODULE,
        lpType: LPCSTR,
        lpName: LPCSTR,
        wLanguage: WORD,
        lParam: LONG_PTR,
    ) -> BOOL,
>;
pub type ENUMRESLANGPROCW = ::std::option::Option<
    unsafe extern "C" fn(
        hModule: HMODULE,
        lpType: LPCWSTR,
        lpName: LPCWSTR,
        wLanguage: WORD,
        lParam: LONG_PTR,
    ) -> BOOL,
>;
pub type ENUMRESNAMEPROCA = ::std::option::Option<
    unsafe extern "C" fn(
        hModule: HMODULE,
        lpType: LPCSTR,
        lpName: LPSTR,
        lParam: LONG_PTR,
    ) -> BOOL,
>;
pub type ENUMRESNAMEPROCW = ::std::option::Option<
    unsafe extern "C" fn(
        hModule: HMODULE,
        lpType: LPCWSTR,
        lpName: LPWSTR,
        lParam: LONG_PTR,
    ) -> BOOL,
>;
pub type ENUMRESTYPEPROCA = ::std::option::Option<
    unsafe extern "C" fn(
        hModule: HMODULE,
        lpType: LPSTR,
        lParam: LONG_PTR,
    ) -> BOOL,
>;
pub type ENUMRESTYPEPROCW = ::std::option::Option<
    unsafe extern "C" fn(
        hModule: HMODULE,
        lpType: LPWSTR,
        lParam: LONG_PTR,
    ) -> BOOL,
>;
extern "C" {
    pub fn EnumResourceLanguagesExA(
        hModule: HMODULE,
        lpType: LPCSTR,
        lpName: LPCSTR,
        lpEnumFunc: ENUMRESLANGPROCA,
        lParam: LONG_PTR,
        dwFlags: DWORD,
        LangId: LANGID,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceLanguagesExW(
        hModule: HMODULE,
        lpType: LPCWSTR,
        lpName: LPCWSTR,
        lpEnumFunc: ENUMRESLANGPROCW,
        lParam: LONG_PTR,
        dwFlags: DWORD,
        LangId: LANGID,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceNamesExA(
        hModule: HMODULE,
        lpType: LPCSTR,
        lpEnumFunc: ENUMRESNAMEPROCA,
        lParam: LONG_PTR,
        dwFlags: DWORD,
        LangId: LANGID,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceNamesExW(
        hModule: HMODULE,
        lpType: LPCWSTR,
        lpEnumFunc: ENUMRESNAMEPROCW,
        lParam: LONG_PTR,
        dwFlags: DWORD,
        LangId: LANGID,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceTypesExA(
        hModule: HMODULE,
        lpEnumFunc: ENUMRESTYPEPROCA,
        lParam: LONG_PTR,
        dwFlags: DWORD,
        LangId: LANGID,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceTypesExW(
        hModule: HMODULE,
        lpEnumFunc: ENUMRESTYPEPROCW,
        lParam: LONG_PTR,
        dwFlags: DWORD,
        LangId: LANGID,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceNamesW(
        hModule: HMODULE,
        lpType: LPCWSTR,
        lpEnumFunc: ENUMRESNAMEPROCW,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceNamesA(
        hModule: HMODULE,
        lpType: LPCSTR,
        lpEnumFunc: ENUMRESNAMEPROCA,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceTypesA(
        hModule: HMODULE,
        lpEnumFunc: ENUMRESTYPEPROCA,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceTypesW(
        hModule: HMODULE,
        lpEnumFunc: ENUMRESTYPEPROCW,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceLanguagesA(
        hModule: HMODULE,
        lpType: LPCSTR,
        lpName: LPCSTR,
        lpEnumFunc: ENUMRESLANGPROCA,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumResourceLanguagesW(
        hModule: HMODULE,
        lpType: LPCWSTR,
        lpName: LPCWSTR,
        lpEnumFunc: ENUMRESLANGPROCW,
        lParam: LONG_PTR,
    ) -> BOOL;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _TIME_DYNAMIC_ZONE_INFORMATION {
    pub Bias: LONG,
    pub StandardName: [WCHAR; 32usize],
    pub StandardDate: SYSTEMTIME,
    pub StandardBias: LONG,
    pub DaylightName: [WCHAR; 32usize],
    pub DaylightDate: SYSTEMTIME,
    pub DaylightBias: LONG,
    pub TimeZoneKeyName: [WCHAR; 128usize],
    pub DynamicDaylightTimeDisabled: BOOLEAN,
}
impl Default for _TIME_DYNAMIC_ZONE_INFORMATION {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PDYNAMIC_TIME_ZONE_INFORMATION = *mut _TIME_DYNAMIC_ZONE_INFORMATION;
extern "C" {
    pub fn EnumDynamicTimeZoneInformation(
        dwIndex: DWORD,
        lpTimeZoneInformation: PDYNAMIC_TIME_ZONE_INFORMATION,
    ) -> DWORD;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagHANDLETABLE {
    pub objectHandle: [HGDIOBJ; 1usize],
}
impl Default for tagHANDLETABLE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HANDLETABLE = tagHANDLETABLE;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagMETARECORD {
    pub rdSize: DWORD,
    pub rdFunction: WORD,
    pub rdParm: [WORD; 1usize],
}
pub type METARECORD = tagMETARECORD;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagENHMETARECORD {
    pub iType: DWORD,
    pub nSize: DWORD,
    pub dParm: [DWORD; 1usize],
}
pub type ENHMETARECORD = tagENHMETARECORD;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagTEXTMETRICA {
    pub tmHeight: LONG,
    pub tmAscent: LONG,
    pub tmDescent: LONG,
    pub tmInternalLeading: LONG,
    pub tmExternalLeading: LONG,
    pub tmAveCharWidth: LONG,
    pub tmMaxCharWidth: LONG,
    pub tmWeight: LONG,
    pub tmOverhang: LONG,
    pub tmDigitizedAspectX: LONG,
    pub tmDigitizedAspectY: LONG,
    pub tmFirstChar: BYTE,
    pub tmLastChar: BYTE,
    pub tmDefaultChar: BYTE,
    pub tmBreakChar: BYTE,
    pub tmItalic: BYTE,
    pub tmUnderlined: BYTE,
    pub tmStruckOut: BYTE,
    pub tmPitchAndFamily: BYTE,
    pub tmCharSet: BYTE,
}
pub type TEXTMETRICA = tagTEXTMETRICA;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagTEXTMETRICW {
    pub tmHeight: LONG,
    pub tmAscent: LONG,
    pub tmDescent: LONG,
    pub tmInternalLeading: LONG,
    pub tmExternalLeading: LONG,
    pub tmAveCharWidth: LONG,
    pub tmMaxCharWidth: LONG,
    pub tmWeight: LONG,
    pub tmOverhang: LONG,
    pub tmDigitizedAspectX: LONG,
    pub tmDigitizedAspectY: LONG,
    pub tmFirstChar: WCHAR,
    pub tmLastChar: WCHAR,
    pub tmDefaultChar: WCHAR,
    pub tmBreakChar: WCHAR,
    pub tmItalic: BYTE,
    pub tmUnderlined: BYTE,
    pub tmStruckOut: BYTE,
    pub tmPitchAndFamily: BYTE,
    pub tmCharSet: BYTE,
}
pub type TEXTMETRICW = tagTEXTMETRICW;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagLOGFONTA {
    pub lfHeight: LONG,
    pub lfWidth: LONG,
    pub lfEscapement: LONG,
    pub lfOrientation: LONG,
    pub lfWeight: LONG,
    pub lfItalic: BYTE,
    pub lfUnderline: BYTE,
    pub lfStrikeOut: BYTE,
    pub lfCharSet: BYTE,
    pub lfOutPrecision: BYTE,
    pub lfClipPrecision: BYTE,
    pub lfQuality: BYTE,
    pub lfPitchAndFamily: BYTE,
    pub lfFaceName: [CHAR; 32usize],
}
pub type LOGFONTA = tagLOGFONTA;
pub type LPLOGFONTA = *mut tagLOGFONTA;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tagLOGFONTW {
    pub lfHeight: LONG,
    pub lfWidth: LONG,
    pub lfEscapement: LONG,
    pub lfOrientation: LONG,
    pub lfWeight: LONG,
    pub lfItalic: BYTE,
    pub lfUnderline: BYTE,
    pub lfStrikeOut: BYTE,
    pub lfCharSet: BYTE,
    pub lfOutPrecision: BYTE,
    pub lfClipPrecision: BYTE,
    pub lfQuality: BYTE,
    pub lfPitchAndFamily: BYTE,
    pub lfFaceName: [WCHAR; 32usize],
}
pub type LOGFONTW = tagLOGFONTW;
pub type LPLOGFONTW = *mut tagLOGFONTW;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _devicemodeA {
    pub dmDeviceName: [BYTE; 32usize],
    pub dmSpecVersion: WORD,
    pub dmDriverVersion: WORD,
    pub dmSize: WORD,
    pub dmDriverExtra: WORD,
    pub dmFields: DWORD,
    pub __bindgen_anon_1: _devicemodeA__bindgen_ty_1,
    pub dmColor: ::std::os::raw::c_short,
    pub dmDuplex: ::std::os::raw::c_short,
    pub dmYResolution: ::std::os::raw::c_short,
    pub dmTTOption: ::std::os::raw::c_short,
    pub dmCollate: ::std::os::raw::c_short,
    pub dmFormName: [BYTE; 32usize],
    pub dmLogPixels: WORD,
    pub dmBitsPerPel: DWORD,
    pub dmPelsWidth: DWORD,
    pub dmPelsHeight: DWORD,
    pub __bindgen_anon_2: _devicemodeA__bindgen_ty_2,
    pub dmDisplayFrequency: DWORD,
    pub dmICMMethod: DWORD,
    pub dmICMIntent: DWORD,
    pub dmMediaType: DWORD,
    pub dmDitherType: DWORD,
    pub dmReserved1: DWORD,
    pub dmReserved2: DWORD,
    pub dmPanningWidth: DWORD,
    pub dmPanningHeight: DWORD,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _devicemodeA__bindgen_ty_1 {
    pub __bindgen_anon_1: _devicemodeA__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: _devicemodeA__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _devicemodeA__bindgen_ty_1__bindgen_ty_1 {
    pub dmOrientation: ::std::os::raw::c_short,
    pub dmPaperSize: ::std::os::raw::c_short,
    pub dmPaperLength: ::std::os::raw::c_short,
    pub dmPaperWidth: ::std::os::raw::c_short,
    pub dmScale: ::std::os::raw::c_short,
    pub dmCopies: ::std::os::raw::c_short,
    pub dmDefaultSource: ::std::os::raw::c_short,
    pub dmPrintQuality: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _devicemodeA__bindgen_ty_1__bindgen_ty_2 {
    pub dmPosition: POINTL,
    pub dmDisplayOrientation: DWORD,
    pub dmDisplayFixedOutput: DWORD,
}
impl Default for _devicemodeA__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for _devicemodeA__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_devicemodeA__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _devicemodeA__bindgen_ty_2 {
    pub dmDisplayFlags: DWORD,
    pub dmNup: DWORD,
}
impl Default for _devicemodeA__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for _devicemodeA__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_devicemodeA__bindgen_ty_2 {{ union }}")
    }
}
impl Default for _devicemodeA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for _devicemodeA {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "_devicemodeA {{ dmDeviceName: {:?}, dmSpecVersion: {:?}, dmDriverVersion: {:?}, dmSize: {:?}, dmDriverExtra: {:?}, dmFields: {:?}, __bindgen_anon_1: {:?}, dmColor: {:?}, dmDuplex: {:?}, dmYResolution: {:?}, dmTTOption: {:?}, dmCollate: {:?}, dmFormName: {:?}, dmLogPixels: {:?}, dmBitsPerPel: {:?}, dmPelsWidth: {:?}, dmPelsHeight: {:?}, __bindgen_anon_2: {:?}, dmDisplayFrequency: {:?}, dmICMMethod: {:?}, dmICMIntent: {:?}, dmMediaType: {:?}, dmDitherType: {:?}, dmReserved1: {:?}, dmReserved2: {:?}, dmPanningWidth: {:?}, dmPanningHeight: {:?} }}" , self . dmDeviceName , self . dmSpecVersion , self . dmDriverVersion , self . dmSize , self . dmDriverExtra , self . dmFields , self . __bindgen_anon_1 , self . dmColor , self . dmDuplex , self . dmYResolution , self . dmTTOption , self . dmCollate , self . dmFormName , self . dmLogPixels , self . dmBitsPerPel , self . dmPelsWidth , self . dmPelsHeight , self . __bindgen_anon_2 , self . dmDisplayFrequency , self . dmICMMethod , self . dmICMIntent , self . dmMediaType , self . dmDitherType , self . dmReserved1 , self . dmReserved2 , self . dmPanningWidth , self . dmPanningHeight)
    }
}
pub type DEVMODEA = _devicemodeA;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _devicemodeW {
    pub dmDeviceName: [WCHAR; 32usize],
    pub dmSpecVersion: WORD,
    pub dmDriverVersion: WORD,
    pub dmSize: WORD,
    pub dmDriverExtra: WORD,
    pub dmFields: DWORD,
    pub __bindgen_anon_1: _devicemodeW__bindgen_ty_1,
    pub dmColor: ::std::os::raw::c_short,
    pub dmDuplex: ::std::os::raw::c_short,
    pub dmYResolution: ::std::os::raw::c_short,
    pub dmTTOption: ::std::os::raw::c_short,
    pub dmCollate: ::std::os::raw::c_short,
    pub dmFormName: [WCHAR; 32usize],
    pub dmLogPixels: WORD,
    pub dmBitsPerPel: DWORD,
    pub dmPelsWidth: DWORD,
    pub dmPelsHeight: DWORD,
    pub __bindgen_anon_2: _devicemodeW__bindgen_ty_2,
    pub dmDisplayFrequency: DWORD,
    pub dmICMMethod: DWORD,
    pub dmICMIntent: DWORD,
    pub dmMediaType: DWORD,
    pub dmDitherType: DWORD,
    pub dmReserved1: DWORD,
    pub dmReserved2: DWORD,
    pub dmPanningWidth: DWORD,
    pub dmPanningHeight: DWORD,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _devicemodeW__bindgen_ty_1 {
    pub __bindgen_anon_1: _devicemodeW__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: _devicemodeW__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _devicemodeW__bindgen_ty_1__bindgen_ty_1 {
    pub dmOrientation: ::std::os::raw::c_short,
    pub dmPaperSize: ::std::os::raw::c_short,
    pub dmPaperLength: ::std::os::raw::c_short,
    pub dmPaperWidth: ::std::os::raw::c_short,
    pub dmScale: ::std::os::raw::c_short,
    pub dmCopies: ::std::os::raw::c_short,
    pub dmDefaultSource: ::std::os::raw::c_short,
    pub dmPrintQuality: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _devicemodeW__bindgen_ty_1__bindgen_ty_2 {
    pub dmPosition: POINTL,
    pub dmDisplayOrientation: DWORD,
    pub dmDisplayFixedOutput: DWORD,
}
impl Default for _devicemodeW__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for _devicemodeW__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_devicemodeW__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _devicemodeW__bindgen_ty_2 {
    pub dmDisplayFlags: DWORD,
    pub dmNup: DWORD,
}
impl Default for _devicemodeW__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for _devicemodeW__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_devicemodeW__bindgen_ty_2 {{ union }}")
    }
}
impl Default for _devicemodeW {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for _devicemodeW {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "_devicemodeW {{ dmDeviceName: {:?}, dmSpecVersion: {:?}, dmDriverVersion: {:?}, dmSize: {:?}, dmDriverExtra: {:?}, dmFields: {:?}, __bindgen_anon_1: {:?}, dmColor: {:?}, dmDuplex: {:?}, dmYResolution: {:?}, dmTTOption: {:?}, dmCollate: {:?}, dmFormName: {:?}, dmLogPixels: {:?}, dmBitsPerPel: {:?}, dmPelsWidth: {:?}, dmPelsHeight: {:?}, __bindgen_anon_2: {:?}, dmDisplayFrequency: {:?}, dmICMMethod: {:?}, dmICMIntent: {:?}, dmMediaType: {:?}, dmDitherType: {:?}, dmReserved1: {:?}, dmReserved2: {:?}, dmPanningWidth: {:?}, dmPanningHeight: {:?} }}" , self . dmDeviceName , self . dmSpecVersion , self . dmDriverVersion , self . dmSize , self . dmDriverExtra , self . dmFields , self . __bindgen_anon_1 , self . dmColor , self . dmDuplex , self . dmYResolution , self . dmTTOption , self . dmCollate , self . dmFormName , self . dmLogPixels , self . dmBitsPerPel , self . dmPelsWidth , self . dmPelsHeight , self . __bindgen_anon_2 , self . dmDisplayFrequency , self . dmICMMethod , self . dmICMIntent , self . dmMediaType , self . dmDitherType , self . dmReserved1 , self . dmReserved2 , self . dmPanningWidth , self . dmPanningHeight)
    }
}
pub type DEVMODEW = _devicemodeW;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _DISPLAY_DEVICEA {
    pub cb: DWORD,
    pub DeviceName: [CHAR; 32usize],
    pub DeviceString: [CHAR; 128usize],
    pub StateFlags: DWORD,
    pub DeviceID: [CHAR; 128usize],
    pub DeviceKey: [CHAR; 128usize],
}
impl Default for _DISPLAY_DEVICEA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PDISPLAY_DEVICEA = *mut _DISPLAY_DEVICEA;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _DISPLAY_DEVICEW {
    pub cb: DWORD,
    pub DeviceName: [WCHAR; 32usize],
    pub DeviceString: [WCHAR; 128usize],
    pub StateFlags: DWORD,
    pub DeviceID: [WCHAR; 128usize],
    pub DeviceKey: [WCHAR; 128usize],
}
impl Default for _DISPLAY_DEVICEW {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PDISPLAY_DEVICEW = *mut _DISPLAY_DEVICEW;
pub type OLDFONTENUMPROCA = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const LOGFONTA,
        arg2: *const TEXTMETRICA,
        arg3: DWORD,
        arg4: LPARAM,
    ) -> ::std::os::raw::c_int,
>;
pub type OLDFONTENUMPROCW = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const LOGFONTW,
        arg2: *const TEXTMETRICW,
        arg3: DWORD,
        arg4: LPARAM,
    ) -> ::std::os::raw::c_int,
>;
pub type FONTENUMPROCA = OLDFONTENUMPROCA;
pub type FONTENUMPROCW = OLDFONTENUMPROCW;
pub type GOBJENUMPROC = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPVOID, arg2: LPARAM) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn EnumFontFamiliesExA(
        hdc: HDC,
        lpLogfont: LPLOGFONTA,
        lpProc: FONTENUMPROCA,
        lParam: LPARAM,
        dwFlags: DWORD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumFontFamiliesExW(
        hdc: HDC,
        lpLogfont: LPLOGFONTW,
        lpProc: FONTENUMPROCW,
        lParam: LPARAM,
        dwFlags: DWORD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumFontFamiliesA(
        hdc: HDC,
        lpLogfont: LPCSTR,
        lpProc: FONTENUMPROCA,
        lParam: LPARAM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumFontFamiliesW(
        hdc: HDC,
        lpLogfont: LPCWSTR,
        lpProc: FONTENUMPROCW,
        lParam: LPARAM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumFontsA(
        hdc: HDC,
        lpLogfont: LPCSTR,
        lpProc: FONTENUMPROCA,
        lParam: LPARAM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumFontsW(
        hdc: HDC,
        lpLogfont: LPCWSTR,
        lpProc: FONTENUMPROCW,
        lParam: LPARAM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumObjects(
        hdc: HDC,
        nType: ::std::os::raw::c_int,
        lpFunc: GOBJENUMPROC,
        lParam: LPARAM,
    ) -> ::std::os::raw::c_int;
}
pub type MFENUMPROC = ::std::option::Option<
    unsafe extern "C" fn(
        hdc: HDC,
        lpht: *mut HANDLETABLE,
        lpMR: *mut METARECORD,
        nObj: ::std::os::raw::c_int,
        param: LPARAM,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn EnumMetaFile(
        hdc: HDC,
        hmf: HMETAFILE,
        proc_: MFENUMPROC,
        param: LPARAM,
    ) -> BOOL;
}
pub type ENHMFENUMPROC = ::std::option::Option<
    unsafe extern "C" fn(
        hdc: HDC,
        lpht: *mut HANDLETABLE,
        lpmr: *const ENHMETARECORD,
        nHandles: ::std::os::raw::c_int,
        data: LPARAM,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn EnumEnhMetaFile(
        hdc: HDC,
        hmf: HENHMETAFILE,
        proc_: ENHMFENUMPROC,
        param: LPVOID,
        lpRect: *const RECT,
    ) -> BOOL;
}
pub type ICMENUMPROCA = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPSTR, arg2: LPARAM) -> ::std::os::raw::c_int,
>;
pub type ICMENUMPROCW = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPWSTR, arg2: LPARAM) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn EnumICMProfilesA(
        hdc: HDC,
        proc_: ICMENUMPROCA,
        param: LPARAM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumICMProfilesW(
        hdc: HDC,
        proc_: ICMENUMPROCW,
        param: LPARAM,
    ) -> ::std::os::raw::c_int;
}
pub type WNDENUMPROC = ::std::option::Option<
    unsafe extern "C" fn(arg1: HWND, arg2: LPARAM) -> BOOL,
>;
pub type PROPENUMPROCA = ::std::option::Option<
    unsafe extern "C" fn(arg1: HWND, arg2: LPCSTR, arg3: HANDLE) -> BOOL,
>;
pub type PROPENUMPROCW = ::std::option::Option<
    unsafe extern "C" fn(arg1: HWND, arg2: LPCWSTR, arg3: HANDLE) -> BOOL,
>;
pub type PROPENUMPROCEXA = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: HWND,
        arg2: LPSTR,
        arg3: HANDLE,
        arg4: ULONG_PTR,
    ) -> BOOL,
>;
pub type PROPENUMPROCEXW = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: HWND,
        arg2: LPWSTR,
        arg3: HANDLE,
        arg4: ULONG_PTR,
    ) -> BOOL,
>;
pub type NAMEENUMPROCA = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPSTR, arg2: LPARAM) -> BOOL,
>;
pub type NAMEENUMPROCW = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPWSTR, arg2: LPARAM) -> BOOL,
>;
pub type WINSTAENUMPROCA = NAMEENUMPROCA;
pub type DESKTOPENUMPROCA = NAMEENUMPROCA;
pub type WINSTAENUMPROCW = NAMEENUMPROCW;
pub type DESKTOPENUMPROCW = NAMEENUMPROCW;
extern "C" {
    pub fn EnumDesktopsA(
        hwinsta: HWINSTA,
        lpEnumFunc: DESKTOPENUMPROCA,
        lParam: LPARAM,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDesktopsW(
        hwinsta: HWINSTA,
        lpEnumFunc: DESKTOPENUMPROCW,
        lParam: LPARAM,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDesktopWindows(
        hDesktop: HDESK,
        lpfn: WNDENUMPROC,
        lParam: LPARAM,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumWindowStationsA(
        lpEnumFunc: WINSTAENUMPROCA,
        lParam: LPARAM,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumWindowStationsW(
        lpEnumFunc: WINSTAENUMPROCW,
        lParam: LPARAM,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumClipboardFormats(format: UINT) -> UINT;
}
extern "C" {
    pub fn EnumPropsExA(
        hWnd: HWND,
        lpEnumFunc: PROPENUMPROCEXA,
        lParam: LPARAM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumPropsExW(
        hWnd: HWND,
        lpEnumFunc: PROPENUMPROCEXW,
        lParam: LPARAM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumPropsA(
        hWnd: HWND,
        lpEnumFunc: PROPENUMPROCA,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumPropsW(
        hWnd: HWND,
        lpEnumFunc: PROPENUMPROCW,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EnumChildWindows(
        hWndParent: HWND,
        lpEnumFunc: WNDENUMPROC,
        lParam: LPARAM,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumWindows(lpEnumFunc: WNDENUMPROC, lParam: LPARAM) -> BOOL;
}
extern "C" {
    pub fn EnumThreadWindows(
        dwThreadId: DWORD,
        lpfn: WNDENUMPROC,
        lParam: LPARAM,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDisplaySettingsA(
        lpszDeviceName: LPCSTR,
        iModeNum: DWORD,
        lpDevMode: *mut DEVMODEA,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDisplaySettingsW(
        lpszDeviceName: LPCWSTR,
        iModeNum: DWORD,
        lpDevMode: *mut DEVMODEW,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDisplaySettingsExA(
        lpszDeviceName: LPCSTR,
        iModeNum: DWORD,
        lpDevMode: *mut DEVMODEA,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDisplaySettingsExW(
        lpszDeviceName: LPCWSTR,
        iModeNum: DWORD,
        lpDevMode: *mut DEVMODEW,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDisplayDevicesA(
        lpDevice: LPCSTR,
        iDevNum: DWORD,
        lpDisplayDevice: PDISPLAY_DEVICEA,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDisplayDevicesW(
        lpDevice: LPCWSTR,
        iDevNum: DWORD,
        lpDisplayDevice: PDISPLAY_DEVICEW,
        dwFlags: DWORD,
    ) -> BOOL;
}
pub type MONITORENUMPROC = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: HMONITOR,
        arg2: HDC,
        arg3: LPRECT,
        arg4: LPARAM,
    ) -> BOOL,
>;
extern "C" {
    pub fn EnumDisplayMonitors(
        hdc: HDC,
        lprcClip: LPCRECT,
        lpfnEnum: MONITORENUMPROC,
        dwData: LPARAM,
    ) -> BOOL;
}
pub type LGRPID = DWORD;
pub type CALTYPE = DWORD;
pub type CALID = DWORD;
pub type GEOCLASS = DWORD;
pub type GEOID = LONG;
pub type LOCALE_ENUMPROCA =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPSTR) -> BOOL>;
pub type LOCALE_ENUMPROCW =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPWSTR) -> BOOL>;
pub type LANGUAGEGROUP_ENUMPROCA = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LGRPID,
        arg2: LPSTR,
        arg3: LPSTR,
        arg4: DWORD,
        arg5: LONG_PTR,
    ) -> BOOL,
>;
pub type LANGGROUPLOCALE_ENUMPROCA = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LGRPID,
        arg2: LCID,
        arg3: LPSTR,
        arg4: LONG_PTR,
    ) -> BOOL,
>;
pub type UILANGUAGE_ENUMPROCA = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPSTR, arg2: LONG_PTR) -> BOOL,
>;
pub type CODEPAGE_ENUMPROCA =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPSTR) -> BOOL>;
pub type DATEFMT_ENUMPROCA =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPSTR) -> BOOL>;
pub type DATEFMT_ENUMPROCEXA = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPSTR, arg2: CALID) -> BOOL,
>;
pub type TIMEFMT_ENUMPROCA =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPSTR) -> BOOL>;
pub type CALINFO_ENUMPROCA =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPSTR) -> BOOL>;
pub type CALINFO_ENUMPROCEXA = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPSTR, arg2: CALID) -> BOOL,
>;
pub type LANGUAGEGROUP_ENUMPROCW = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LGRPID,
        arg2: LPWSTR,
        arg3: LPWSTR,
        arg4: DWORD,
        arg5: LONG_PTR,
    ) -> BOOL,
>;
pub type LANGGROUPLOCALE_ENUMPROCW = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LGRPID,
        arg2: LCID,
        arg3: LPWSTR,
        arg4: LONG_PTR,
    ) -> BOOL,
>;
pub type UILANGUAGE_ENUMPROCW = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPWSTR, arg2: LONG_PTR) -> BOOL,
>;
pub type CODEPAGE_ENUMPROCW =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPWSTR) -> BOOL>;
pub type DATEFMT_ENUMPROCW =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPWSTR) -> BOOL>;
pub type DATEFMT_ENUMPROCEXW = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPWSTR, arg2: CALID) -> BOOL,
>;
pub type TIMEFMT_ENUMPROCW =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPWSTR) -> BOOL>;
pub type CALINFO_ENUMPROCW =
    ::std::option::Option<unsafe extern "C" fn(arg1: LPWSTR) -> BOOL>;
pub type CALINFO_ENUMPROCEXW = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPWSTR, arg2: CALID) -> BOOL,
>;
pub type GEO_ENUMPROC =
    ::std::option::Option<unsafe extern "C" fn(arg1: GEOID) -> BOOL>;
pub type GEO_ENUMNAMEPROC = ::std::option::Option<
    unsafe extern "C" fn(arg1: PWSTR, arg2: LPARAM) -> BOOL,
>;
extern "C" {
    pub fn EnumCalendarInfoA(
        lpCalInfoEnumProc: CALINFO_ENUMPROCA,
        Locale: LCID,
        Calendar: CALID,
        CalType: CALTYPE,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumCalendarInfoW(
        lpCalInfoEnumProc: CALINFO_ENUMPROCW,
        Locale: LCID,
        Calendar: CALID,
        CalType: CALTYPE,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumCalendarInfoExA(
        lpCalInfoEnumProcEx: CALINFO_ENUMPROCEXA,
        Locale: LCID,
        Calendar: CALID,
        CalType: CALTYPE,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumCalendarInfoExW(
        lpCalInfoEnumProcEx: CALINFO_ENUMPROCEXW,
        Locale: LCID,
        Calendar: CALID,
        CalType: CALTYPE,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumTimeFormatsA(
        lpTimeFmtEnumProc: TIMEFMT_ENUMPROCA,
        Locale: LCID,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumTimeFormatsW(
        lpTimeFmtEnumProc: TIMEFMT_ENUMPROCW,
        Locale: LCID,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDateFormatsA(
        lpDateFmtEnumProc: DATEFMT_ENUMPROCA,
        Locale: LCID,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDateFormatsW(
        lpDateFmtEnumProc: DATEFMT_ENUMPROCW,
        Locale: LCID,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDateFormatsExA(
        lpDateFmtEnumProcEx: DATEFMT_ENUMPROCEXA,
        Locale: LCID,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDateFormatsExW(
        lpDateFmtEnumProcEx: DATEFMT_ENUMPROCEXW,
        Locale: LCID,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumSystemGeoID(
        GeoClass: GEOCLASS,
        ParentGeoId: GEOID,
        lpGeoEnumProc: GEO_ENUMPROC,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumSystemGeoNames(
        geoClass: GEOCLASS,
        geoEnumProc: GEO_ENUMNAMEPROC,
        data: LPARAM,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumSystemLocalesA(
        lpLocaleEnumProc: LOCALE_ENUMPROCA,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumSystemLocalesW(
        lpLocaleEnumProc: LOCALE_ENUMPROCW,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumSystemLanguageGroupsA(
        lpLanguageGroupEnumProc: LANGUAGEGROUP_ENUMPROCA,
        dwFlags: DWORD,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumSystemLanguageGroupsW(
        lpLanguageGroupEnumProc: LANGUAGEGROUP_ENUMPROCW,
        dwFlags: DWORD,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumLanguageGroupLocalesA(
        lpLangGroupLocaleEnumProc: LANGGROUPLOCALE_ENUMPROCA,
        LanguageGroup: LGRPID,
        dwFlags: DWORD,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumLanguageGroupLocalesW(
        lpLangGroupLocaleEnumProc: LANGGROUPLOCALE_ENUMPROCW,
        LanguageGroup: LGRPID,
        dwFlags: DWORD,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumUILanguagesA(
        lpUILanguageEnumProc: UILANGUAGE_ENUMPROCA,
        dwFlags: DWORD,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumUILanguagesW(
        lpUILanguageEnumProc: UILANGUAGE_ENUMPROCW,
        dwFlags: DWORD,
        lParam: LONG_PTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumSystemCodePagesA(
        lpCodePageEnumProc: CODEPAGE_ENUMPROCA,
        dwFlags: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumSystemCodePagesW(
        lpCodePageEnumProc: CODEPAGE_ENUMPROCW,
        dwFlags: DWORD,
    ) -> BOOL;
}
pub type CALINFO_ENUMPROCEXEX = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LPWSTR,
        arg2: CALID,
        arg3: LPWSTR,
        arg4: LPARAM,
    ) -> BOOL,
>;
extern "C" {
    pub fn EnumCalendarInfoExEx(
        pCalInfoEnumProcExEx: CALINFO_ENUMPROCEXEX,
        lpLocaleName: LPCWSTR,
        Calendar: CALID,
        lpReserved: LPCWSTR,
        CalType: CALTYPE,
        lParam: LPARAM,
    ) -> BOOL;
}
pub type DATEFMT_ENUMPROCEXEX = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPWSTR, arg2: CALID, arg3: LPARAM) -> BOOL,
>;
extern "C" {
    pub fn EnumDateFormatsExEx(
        lpDateFmtEnumProcExEx: DATEFMT_ENUMPROCEXEX,
        lpLocaleName: LPCWSTR,
        dwFlags: DWORD,
        lParam: LPARAM,
    ) -> BOOL;
}
pub type TIMEFMT_ENUMPROCEX = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPWSTR, arg2: LPARAM) -> BOOL,
>;
extern "C" {
    pub fn EnumTimeFormatsEx(
        lpTimeFmtEnumProcEx: TIMEFMT_ENUMPROCEX,
        lpLocaleName: LPCWSTR,
        dwFlags: DWORD,
        lParam: LPARAM,
    ) -> BOOL;
}
pub type LOCALE_ENUMPROCEX = ::std::option::Option<
    unsafe extern "C" fn(arg1: LPWSTR, arg2: DWORD, arg3: LPARAM) -> BOOL,
>;
extern "C" {
    pub fn EnumSystemLocalesEx(
        lpLocaleEnumProcEx: LOCALE_ENUMPROCEX,
        dwFlags: DWORD,
        lParam: LPARAM,
        lpReserved: LPVOID,
    ) -> BOOL;
}
pub type UUID = GUID;
extern "C" {
    pub fn EnumPrintersA(
        Flags: DWORD,
        Name: LPSTR,
        Level: DWORD,
        pPrinterEnum: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPrintersW(
        Flags: DWORD,
        Name: LPWSTR,
        Level: DWORD,
        pPrinterEnum: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumJobsA(
        hPrinter: HANDLE,
        FirstJob: DWORD,
        NoJobs: DWORD,
        Level: DWORD,
        pJob: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumJobsW(
        hPrinter: HANDLE,
        FirstJob: DWORD,
        NoJobs: DWORD,
        Level: DWORD,
        pJob: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPrinterDriversA(
        pName: LPSTR,
        pEnvironment: LPSTR,
        Level: DWORD,
        pDriverInfo: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPrinterDriversW(
        pName: LPWSTR,
        pEnvironment: LPWSTR,
        Level: DWORD,
        pDriverInfo: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPrintProcessorsA(
        pName: LPSTR,
        pEnvironment: LPSTR,
        Level: DWORD,
        pPrintProcessorInfo: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPrintProcessorsW(
        pName: LPWSTR,
        pEnvironment: LPWSTR,
        Level: DWORD,
        pPrintProcessorInfo: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPrintProcessorDatatypesA(
        pName: LPSTR,
        pPrintProcessorName: LPSTR,
        Level: DWORD,
        pDatatypes: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPrintProcessorDatatypesW(
        pName: LPWSTR,
        pPrintProcessorName: LPWSTR,
        Level: DWORD,
        pDatatypes: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPrinterDataA(
        hPrinter: HANDLE,
        dwIndex: DWORD,
        pValueName: LPSTR,
        cbValueName: DWORD,
        pcbValueName: LPDWORD,
        pType: LPDWORD,
        pData: LPBYTE,
        cbData: DWORD,
        pcbData: LPDWORD,
    ) -> DWORD;
}
extern "C" {
    pub fn EnumPrinterDataW(
        hPrinter: HANDLE,
        dwIndex: DWORD,
        pValueName: LPWSTR,
        cbValueName: DWORD,
        pcbValueName: LPDWORD,
        pType: LPDWORD,
        pData: LPBYTE,
        cbData: DWORD,
        pcbData: LPDWORD,
    ) -> DWORD;
}
extern "C" {
    pub fn EnumPrinterDataExA(
        hPrinter: HANDLE,
        pKeyName: LPCSTR,
        pEnumValues: LPBYTE,
        cbEnumValues: DWORD,
        pcbEnumValues: LPDWORD,
        pnEnumValues: LPDWORD,
    ) -> DWORD;
}
extern "C" {
    pub fn EnumPrinterDataExW(
        hPrinter: HANDLE,
        pKeyName: LPCWSTR,
        pEnumValues: LPBYTE,
        cbEnumValues: DWORD,
        pcbEnumValues: LPDWORD,
        pnEnumValues: LPDWORD,
    ) -> DWORD;
}
extern "C" {
    pub fn EnumPrinterKeyA(
        hPrinter: HANDLE,
        pKeyName: LPCSTR,
        pSubkey: LPSTR,
        cbSubkey: DWORD,
        pcbSubkey: LPDWORD,
    ) -> DWORD;
}
extern "C" {
    pub fn EnumPrinterKeyW(
        hPrinter: HANDLE,
        pKeyName: LPCWSTR,
        pSubkey: LPWSTR,
        cbSubkey: DWORD,
        pcbSubkey: LPDWORD,
    ) -> DWORD;
}
extern "C" {
    pub fn EnumFormsA(
        hPrinter: HANDLE,
        Level: DWORD,
        pForm: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumFormsW(
        hPrinter: HANDLE,
        Level: DWORD,
        pForm: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumMonitorsA(
        pName: LPSTR,
        Level: DWORD,
        pMonitor: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumMonitorsW(
        pName: LPWSTR,
        Level: DWORD,
        pMonitor: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPortsA(
        pName: LPSTR,
        Level: DWORD,
        pPort: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumPortsW(
        pName: LPWSTR,
        Level: DWORD,
        pPort: LPBYTE,
        cbBuf: DWORD,
        pcbNeeded: LPDWORD,
        pcReturned: LPDWORD,
    ) -> BOOL;
}
pub const EPrintPropertyType_kPropertyTypeString: EPrintPropertyType = 1;
pub const EPrintPropertyType_kPropertyTypeInt32: EPrintPropertyType = 2;
pub const EPrintPropertyType_kPropertyTypeInt64: EPrintPropertyType = 3;
pub const EPrintPropertyType_kPropertyTypeByte: EPrintPropertyType = 4;
pub const EPrintPropertyType_kPropertyTypeTime: EPrintPropertyType = 5;
pub const EPrintPropertyType_kPropertyTypeDevMode: EPrintPropertyType = 6;
pub const EPrintPropertyType_kPropertyTypeSD: EPrintPropertyType = 7;
pub const EPrintPropertyType_kPropertyTypeNotificationReply:
    EPrintPropertyType = 8;
pub const EPrintPropertyType_kPropertyTypeNotificationOptions:
    EPrintPropertyType = 9;
pub const EPrintPropertyType_kPropertyTypeBuffer: EPrintPropertyType = 10;
pub type EPrintPropertyType = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct PrintPropertyValue {
    pub ePropertyType: EPrintPropertyType,
    pub value: PrintPropertyValue__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PrintPropertyValue__bindgen_ty_1 {
    pub propertyByte: BYTE,
    pub propertyString: PWSTR,
    pub propertyInt32: LONG,
    pub propertyInt64: LONGLONG,
    pub propertyBlob: PrintPropertyValue__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct PrintPropertyValue__bindgen_ty_1__bindgen_ty_1 {
    pub cbBuf: DWORD,
    pub pBuf: LPVOID,
}
impl Default for PrintPropertyValue__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for PrintPropertyValue__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for PrintPropertyValue__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "PrintPropertyValue__bindgen_ty_1 {{ union }}")
    }
}
impl Default for PrintPropertyValue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for PrintPropertyValue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "PrintPropertyValue {{ ePropertyType: {:?}, value: {:?} }}",
            self.ePropertyType, self.value
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct PrintNamedProperty {
    pub propertyName: *mut WCHAR,
    pub propertyValue: PrintPropertyValue,
}
impl Default for PrintNamedProperty {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for PrintNamedProperty {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "PrintNamedProperty {{ propertyName: {:?}, propertyValue: {:?} }}",
            self.propertyName, self.propertyValue
        )
    }
}
extern "C" {
    pub fn EnumJobNamedProperties(
        hPrinter: HANDLE,
        JobId: DWORD,
        pcProperties: *mut DWORD,
        ppProperties: *mut *mut PrintNamedProperty,
    ) -> DWORD;
}
extern "C" {
    pub static IID_IUnknown: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IUnknownVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IUnknown,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IUnknown) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IUnknown) -> ULONG,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IUnknown {
    pub lpVtbl: *mut IUnknownVtbl,
}
impl Default for IUnknown {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_AsyncIUnknown: IID;
}
extern "C" {
    pub static IID_IClassFactory: IID;
}
extern "C" {
    pub static IID_IMarshal: IID;
}
extern "C" {
    pub static IID_INoMarshal: IID;
}
extern "C" {
    pub static IID_IAgileObject: IID;
}
extern "C" {
    pub static IID_IActivationFilter: IID;
}
extern "C" {
    pub static IID_IMarshal2: IID;
}
extern "C" {
    pub static IID_IMalloc: IID;
}
extern "C" {
    pub static IID_IStdMarshalInfo: IID;
}
extern "C" {
    pub static IID_IExternalConnection: IID;
}
extern "C" {
    pub static IID_IMultiQI: IID;
}
extern "C" {
    pub static IID_AsyncIMultiQI: IID;
}
extern "C" {
    pub static IID_IInternalUnknown: IID;
}
extern "C" {
    pub static IID_IEnumUnknown: IID;
}
extern "C" {
    pub static IID_IEnumString: IID;
}
extern "C" {
    pub static IID_ISequentialStream: IID;
}
extern "C" {
    pub static IID_IStream: IID;
}
extern "C" {
    pub static IID_IRpcChannelBuffer: IID;
}
extern "C" {
    pub static IID_IRpcChannelBuffer2: IID;
}
extern "C" {
    pub static IID_IAsyncRpcChannelBuffer: IID;
}
extern "C" {
    pub static IID_IRpcChannelBuffer3: IID;
}
extern "C" {
    pub static IID_IRpcSyntaxNegotiate: IID;
}
extern "C" {
    pub static IID_IRpcProxyBuffer: IID;
}
extern "C" {
    pub static IID_IRpcStubBuffer: IID;
}
extern "C" {
    pub static IID_IPSFactoryBuffer: IID;
}
extern "C" {
    pub static IID_IChannelHook: IID;
}
extern "C" {
    pub static IID_IClientSecurity: IID;
}
extern "C" {
    pub static IID_IServerSecurity: IID;
}
extern "C" {
    pub static IID_IRpcOptions: IID;
}
extern "C" {
    pub static IID_IGlobalOptions: IID;
}
extern "C" {
    pub static IID_ISurrogate: IID;
}
extern "C" {
    pub static IID_IGlobalInterfaceTable: IID;
}
extern "C" {
    pub static IID_ISynchronize: IID;
}
extern "C" {
    pub static IID_ISynchronizeHandle: IID;
}
extern "C" {
    pub static IID_ISynchronizeEvent: IID;
}
extern "C" {
    pub static IID_ISynchronizeContainer: IID;
}
extern "C" {
    pub static IID_ISynchronizeMutex: IID;
}
extern "C" {
    pub static IID_ICancelMethodCalls: IID;
}
extern "C" {
    pub static IID_IAsyncManager: IID;
}
extern "C" {
    pub static IID_ICallFactory: IID;
}
extern "C" {
    pub static IID_IRpcHelper: IID;
}
extern "C" {
    pub static IID_IReleaseMarshalBuffers: IID;
}
extern "C" {
    pub static IID_IWaitMultiple: IID;
}
extern "C" {
    pub static IID_IAddrTrackingControl: IID;
}
extern "C" {
    pub static IID_IAddrExclusionControl: IID;
}
extern "C" {
    pub static IID_IPipeByte: IID;
}
extern "C" {
    pub static IID_AsyncIPipeByte: IID;
}
extern "C" {
    pub static IID_IPipeLong: IID;
}
extern "C" {
    pub static IID_AsyncIPipeLong: IID;
}
extern "C" {
    pub static IID_IPipeDouble: IID;
}
extern "C" {
    pub static IID_AsyncIPipeDouble: IID;
}
extern "C" {
    pub static IID_IComThreadingInfo: IID;
}
extern "C" {
    pub static IID_IProcessInitControl: IID;
}
extern "C" {
    pub static IID_IFastRundown: IID;
}
extern "C" {
    pub static IID_IMarshalingStream: IID;
}
extern "C" {
    pub static IID_IAgileReference: IID;
}
extern "C" {
    pub static IID_ICallbackWithNoReentrancyToApplicationSTA: GUID;
}
extern "C" {
    pub static IID_IMachineGlobalObjectTable: IID;
}
extern "C" {
    pub static IID_IRpcChannel: IID;
}
extern "C" {
    pub static IID_IRpcStub: IID;
}
extern "C" {
    pub static IID_IStubManager: IID;
}
extern "C" {
    pub static IID_IRpcProxy: IID;
}
extern "C" {
    pub static IID_IProxyManager: IID;
}
extern "C" {
    pub static IID_IPSFactory: IID;
}
extern "C" {
    pub static IID_IInternalMoniker: IID;
}
extern "C" {
    pub static IID_IDfReserved1: IID;
}
extern "C" {
    pub static IID_IDfReserved2: IID;
}
extern "C" {
    pub static IID_IDfReserved3: IID;
}
extern "C" {
    pub static IID_IStub: IID;
}
extern "C" {
    pub static IID_IProxy: IID;
}
extern "C" {
    pub static IID_IEnumGeneric: IID;
}
extern "C" {
    pub static IID_IEnumHolder: IID;
}
extern "C" {
    pub static IID_IEnumCallback: IID;
}
extern "C" {
    pub static IID_IOleManager: IID;
}
extern "C" {
    pub static IID_IOlePresObj: IID;
}
extern "C" {
    pub static IID_IDebug: IID;
}
extern "C" {
    pub static IID_IDebugStream: IID;
}
extern "C" {
    pub static IID_IMallocSpy: IID;
}
extern "C" {
    pub static IID_IBindCtx: IID;
}
extern "C" {
    pub static IID_IEnumMoniker: IID;
}
extern "C" {
    pub static IID_IRunnableObject: IID;
}
extern "C" {
    pub static IID_IRunningObjectTable: IID;
}
extern "C" {
    pub static IID_IPersist: IID;
}
extern "C" {
    pub static IID_IPersistStream: IID;
}
extern "C" {
    pub static IID_IMoniker: IID;
}
extern "C" {
    pub static IID_IROTData: IID;
}
extern "C" {
    pub static IID_IEnumSTATSTG: IID;
}
extern "C" {
    pub static IID_IStorage: IID;
}
extern "C" {
    pub static IID_IPersistFile: IID;
}
extern "C" {
    pub static IID_IPersistStorage: IID;
}
extern "C" {
    pub static IID_ILockBytes: IID;
}
extern "C" {
    pub static IID_IEnumFORMATETC: IID;
}
extern "C" {
    pub static IID_IEnumSTATDATA: IID;
}
extern "C" {
    pub static IID_IRootStorage: IID;
}
extern "C" {
    pub static IID_IAdviseSink: IID;
}
extern "C" {
    pub static IID_AsyncIAdviseSink: IID;
}
extern "C" {
    pub static IID_IAdviseSink2: IID;
}
extern "C" {
    pub static IID_AsyncIAdviseSink2: IID;
}
extern "C" {
    pub static IID_IDataObject: IID;
}
extern "C" {
    pub static IID_IDataAdviseHolder: IID;
}
extern "C" {
    pub static IID_IMessageFilter: IID;
}
extern "C" {
    pub static IID_IClassActivator: IID;
}
extern "C" {
    pub static IID_IFillLockBytes: IID;
}
extern "C" {
    pub static IID_IProgressNotify: IID;
}
extern "C" {
    pub static IID_ILayoutStorage: IID;
}
extern "C" {
    pub static IID_IBlockingLock: IID;
}
extern "C" {
    pub static IID_ITimeAndNoticeControl: IID;
}
extern "C" {
    pub static IID_IOplockStorage: IID;
}
extern "C" {
    pub static IID_IDirectWriterLock: IID;
}
extern "C" {
    pub static IID_IUrlMon: IID;
}
extern "C" {
    pub static IID_IForegroundTransfer: IID;
}
extern "C" {
    pub static IID_IThumbnailExtractor: IID;
}
extern "C" {
    pub static IID_IDummyHICONIncluder: IID;
}
extern "C" {
    pub static IID_IProcessLock: IID;
}
extern "C" {
    pub static IID_ISurrogateService: IID;
}
extern "C" {
    pub static IID_IInitializeSpy: IID;
}
extern "C" {
    pub static IID_IApartmentShutdown: IID;
}
extern "C" {
    pub static IID_ICreateTypeInfo: IID;
}
extern "C" {
    pub static IID_ICreateTypeInfo2: IID;
}
extern "C" {
    pub static IID_ICreateTypeLib: IID;
}
extern "C" {
    pub static IID_ICreateTypeLib2: IID;
}
extern "C" {
    pub static IID_IDispatch: IID;
}
extern "C" {
    pub static IID_IEnumVARIANT: IID;
}
extern "C" {
    pub static IID_ITypeComp: IID;
}
extern "C" {
    pub static IID_ITypeInfo: IID;
}
extern "C" {
    pub static IID_ITypeInfo2: IID;
}
extern "C" {
    pub static IID_ITypeLib: IID;
}
extern "C" {
    pub static IID_ITypeLib2: IID;
}
extern "C" {
    pub static IID_ITypeChangeEvents: IID;
}
extern "C" {
    pub static IID_IErrorInfo: IID;
}
extern "C" {
    pub static IID_ICreateErrorInfo: IID;
}
extern "C" {
    pub static IID_ISupportErrorInfo: IID;
}
extern "C" {
    pub static IID_ITypeFactory: IID;
}
extern "C" {
    pub static IID_ITypeMarshal: IID;
}
extern "C" {
    pub static IID_IRecordInfo: IID;
}
extern "C" {
    pub static IID_IErrorLog: IID;
}
extern "C" {
    pub static IID_IPropertyBag: IID;
}
extern "C" {
    pub static IID_ITypeLibRegistrationReader: IID;
}
extern "C" {
    pub static IID_ITypeLibRegistration: IID;
}
extern "C" {
    pub static IID_IPropertyStorage: IID;
}
extern "C" {
    pub static IID_IPropertySetStorage: IID;
}
extern "C" {
    pub static IID_IEnumSTATPROPSTG: IID;
}
extern "C" {
    pub static IID_IEnumSTATPROPSETSTG: IID;
}
extern "C" {
    pub static IID_IOleAdviseHolder: IID;
}
extern "C" {
    pub static IID_IOleCache: IID;
}
extern "C" {
    pub static IID_IOleCache2: IID;
}
extern "C" {
    pub static IID_IOleCacheControl: IID;
}
extern "C" {
    pub static IID_IParseDisplayName: IID;
}
extern "C" {
    pub static IID_IOleContainer: IID;
}
extern "C" {
    pub static IID_IOleClientSite: IID;
}
extern "C" {
    pub static IID_IOleObject: IID;
}
extern "C" {
    pub static IID_IOleWindow: IID;
}
extern "C" {
    pub static IID_IOleLink: IID;
}
extern "C" {
    pub static IID_IOleItemContainer: IID;
}
extern "C" {
    pub static IID_IOleInPlaceUIWindow: IID;
}
extern "C" {
    pub static IID_IOleInPlaceActiveObject: IID;
}
extern "C" {
    pub static IID_IOleInPlaceFrame: IID;
}
extern "C" {
    pub static IID_IOleInPlaceObject: IID;
}
extern "C" {
    pub static IID_IOleInPlaceSite: IID;
}
extern "C" {
    pub static IID_IContinue: IID;
}
extern "C" {
    pub static IID_IViewObject: IID;
}
extern "C" {
    pub static IID_IViewObject2: IID;
}
extern "C" {
    pub static IID_IDropSource: IID;
}
extern "C" {
    pub static IID_IDropTarget: IID;
}
extern "C" {
    pub static IID_IDropSourceNotify: IID;
}
extern "C" {
    pub static IID_IEnterpriseDropTarget: IID;
}
extern "C" {
    pub static IID_IEnumOLEVERB: IID;
}
extern "C" {
    pub static IID_IServiceProvider: IID;
}
extern "C" {
    pub static IID_IXMLDOMImplementation: IID;
}
extern "C" {
    pub static IID_IXMLDOMNode: IID;
}
extern "C" {
    pub static IID_IXMLDOMDocumentFragment: IID;
}
extern "C" {
    pub static IID_IXMLDOMDocument: IID;
}
extern "C" {
    pub static IID_IXMLDOMNodeList: IID;
}
extern "C" {
    pub static IID_IXMLDOMNamedNodeMap: IID;
}
extern "C" {
    pub static IID_IXMLDOMCharacterData: IID;
}
extern "C" {
    pub static IID_IXMLDOMAttribute: IID;
}
extern "C" {
    pub static IID_IXMLDOMElement: IID;
}
extern "C" {
    pub static IID_IXMLDOMText: IID;
}
extern "C" {
    pub static IID_IXMLDOMComment: IID;
}
extern "C" {
    pub static IID_IXMLDOMProcessingInstruction: IID;
}
extern "C" {
    pub static IID_IXMLDOMCDATASection: IID;
}
extern "C" {
    pub static IID_IXMLDOMDocumentType: IID;
}
extern "C" {
    pub static IID_IXMLDOMNotation: IID;
}
extern "C" {
    pub static IID_IXMLDOMEntity: IID;
}
extern "C" {
    pub static IID_IXMLDOMEntityReference: IID;
}
extern "C" {
    pub static IID_IXMLDOMParseError: IID;
}
extern "C" {
    pub static IID_IXTLRuntime: IID;
}
extern "C" {
    pub static DIID_XMLDOMDocumentEvents: IID;
}
extern "C" {
    pub static IID_IXMLHttpRequest: IID;
}
extern "C" {
    pub static IID_IXMLDSOControl: IID;
}
extern "C" {
    pub static IID_IXMLElementCollection: IID;
}
extern "C" {
    pub static IID_IXMLDocument: IID;
}
extern "C" {
    pub static IID_IXMLDocument2: IID;
}
extern "C" {
    pub static IID_IXMLElement: IID;
}
extern "C" {
    pub static IID_IXMLElement2: IID;
}
extern "C" {
    pub static IID_IXMLAttribute: IID;
}
extern "C" {
    pub static IID_IXMLError: IID;
}
extern "C" {
    pub static IID_IAsyncMoniker: IID;
}
extern "C" {
    pub static IID_IAsyncBindCtx: IID;
}
extern "C" {
    pub static IID_IPersistMoniker: IID;
}
extern "C" {
    pub static IID_IMonikerProp: IID;
}
extern "C" {
    pub static IID_IBindProtocol: IID;
}
extern "C" {
    pub static IID_IBinding: IID;
}
extern "C" {
    pub static IID_IBindStatusCallback: IID;
}
extern "C" {
    pub static IID_IBindStatusCallbackEx: IID;
}
extern "C" {
    pub static IID_IAuthenticate: IID;
}
extern "C" {
    pub static IID_IAuthenticateEx: IID;
}
extern "C" {
    pub static IID_IHttpNegotiate: IID;
}
extern "C" {
    pub static IID_IHttpNegotiate2: IID;
}
extern "C" {
    pub static IID_IHttpNegotiate3: IID;
}
extern "C" {
    pub static IID_IWinInetFileStream: IID;
}
extern "C" {
    pub static IID_IWindowForBindingUI: IID;
}
extern "C" {
    pub static IID_ICodeInstall: IID;
}
extern "C" {
    pub static IID_IUri: IID;
}
extern "C" {
    pub static IID_IUriContainer: IID;
}
extern "C" {
    pub static IID_IUriBuilder: IID;
}
extern "C" {
    pub static IID_IUriBuilderFactory: IID;
}
extern "C" {
    pub static IID_IWinInetInfo: IID;
}
extern "C" {
    pub static IID_IHttpSecurity: IID;
}
extern "C" {
    pub static IID_IWinInetHttpInfo: IID;
}
extern "C" {
    pub static IID_IWinInetHttpTimeouts: IID;
}
extern "C" {
    pub static IID_IWinInetCacheHints: IID;
}
extern "C" {
    pub static IID_IWinInetCacheHints2: IID;
}
extern "C" {
    pub static IID_IBindHost: IID;
}
extern "C" {
    pub static IID_IInternet: IID;
}
extern "C" {
    pub static IID_IInternetBindInfo: IID;
}
extern "C" {
    pub static IID_IInternetBindInfoEx: IID;
}
extern "C" {
    pub static IID_IInternetProtocolRoot: IID;
}
extern "C" {
    pub static IID_IInternetProtocol: IID;
}
extern "C" {
    pub static IID_IInternetProtocolEx: IID;
}
extern "C" {
    pub static IID_IInternetProtocolSink: IID;
}
extern "C" {
    pub static IID_IInternetProtocolSinkStackable: IID;
}
extern "C" {
    pub static IID_IInternetSession: IID;
}
extern "C" {
    pub static IID_IInternetThreadSwitch: IID;
}
extern "C" {
    pub static IID_IInternetPriority: IID;
}
extern "C" {
    pub static IID_IInternetProtocolInfo: IID;
}
extern "C" {
    pub static IID_IInternetSecurityMgrSite: IID;
}
extern "C" {
    pub static IID_IInternetSecurityManager: IID;
}
extern "C" {
    pub static IID_IInternetSecurityManagerEx: IID;
}
extern "C" {
    pub static IID_IInternetSecurityManagerEx2: IID;
}
extern "C" {
    pub static IID_IZoneIdentifier: IID;
}
extern "C" {
    pub static IID_IZoneIdentifier2: IID;
}
extern "C" {
    pub static IID_IInternetHostSecurityManager: IID;
}
extern "C" {
    pub static IID_IInternetZoneManager: IID;
}
extern "C" {
    pub static IID_IInternetZoneManagerEx: IID;
}
extern "C" {
    pub static IID_IInternetZoneManagerEx2: IID;
}
extern "C" {
    pub static IID_ISoftDistExt: IID;
}
extern "C" {
    pub static IID_ICatalogFileInfo: IID;
}
extern "C" {
    pub static IID_IDataFilter: IID;
}
extern "C" {
    pub static IID_IEncodingFilterFactory: IID;
}
extern "C" {
    pub static IID_IWrappedProtocol: IID;
}
extern "C" {
    pub static IID_IGetBindHandle: IID;
}
extern "C" {
    pub static IID_IBindCallbackRedirect: IID;
}
extern "C" {
    pub static IID_IBindHttpSecurity: IID;
}
extern "C" {
    pub static IID_StdOle: IID;
}
extern "C" {
    pub static IID_IPrintDialogCallback: GUID;
}
extern "C" {
    pub static IID_IPrintDialogServices: GUID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SC_HANDLE__ {
    pub unused: ::std::os::raw::c_int,
}
pub type SC_HANDLE = *mut SC_HANDLE__;
pub const _SC_ENUM_TYPE_SC_ENUM_PROCESS_INFO: _SC_ENUM_TYPE = 0;
pub type _SC_ENUM_TYPE = ::std::os::raw::c_int;
pub use self::_SC_ENUM_TYPE as SC_ENUM_TYPE;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _SERVICE_STATUS {
    pub dwServiceType: DWORD,
    pub dwCurrentState: DWORD,
    pub dwControlsAccepted: DWORD,
    pub dwWin32ExitCode: DWORD,
    pub dwServiceSpecificExitCode: DWORD,
    pub dwCheckPoint: DWORD,
    pub dwWaitHint: DWORD,
}
pub type SERVICE_STATUS = _SERVICE_STATUS;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _ENUM_SERVICE_STATUSA {
    pub lpServiceName: LPSTR,
    pub lpDisplayName: LPSTR,
    pub ServiceStatus: SERVICE_STATUS,
}
impl Default for _ENUM_SERVICE_STATUSA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LPENUM_SERVICE_STATUSA = *mut _ENUM_SERVICE_STATUSA;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _ENUM_SERVICE_STATUSW {
    pub lpServiceName: LPWSTR,
    pub lpDisplayName: LPWSTR,
    pub ServiceStatus: SERVICE_STATUS,
}
impl Default for _ENUM_SERVICE_STATUSW {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LPENUM_SERVICE_STATUSW = *mut _ENUM_SERVICE_STATUSW;
extern "C" {
    pub fn EnumDependentServicesA(
        hService: SC_HANDLE,
        dwServiceState: DWORD,
        lpServices: LPENUM_SERVICE_STATUSA,
        cbBufSize: DWORD,
        pcbBytesNeeded: LPDWORD,
        lpServicesReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumDependentServicesW(
        hService: SC_HANDLE,
        dwServiceState: DWORD,
        lpServices: LPENUM_SERVICE_STATUSW,
        cbBufSize: DWORD,
        pcbBytesNeeded: LPDWORD,
        lpServicesReturned: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumServicesStatusA(
        hSCManager: SC_HANDLE,
        dwServiceType: DWORD,
        dwServiceState: DWORD,
        lpServices: LPENUM_SERVICE_STATUSA,
        cbBufSize: DWORD,
        pcbBytesNeeded: LPDWORD,
        lpServicesReturned: LPDWORD,
        lpResumeHandle: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumServicesStatusW(
        hSCManager: SC_HANDLE,
        dwServiceType: DWORD,
        dwServiceState: DWORD,
        lpServices: LPENUM_SERVICE_STATUSW,
        cbBufSize: DWORD,
        pcbBytesNeeded: LPDWORD,
        lpServicesReturned: LPDWORD,
        lpResumeHandle: LPDWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumServicesStatusExA(
        hSCManager: SC_HANDLE,
        InfoLevel: SC_ENUM_TYPE,
        dwServiceType: DWORD,
        dwServiceState: DWORD,
        lpServices: LPBYTE,
        cbBufSize: DWORD,
        pcbBytesNeeded: LPDWORD,
        lpServicesReturned: LPDWORD,
        lpResumeHandle: LPDWORD,
        pszGroupName: LPCSTR,
    ) -> BOOL;
}
extern "C" {
    pub fn EnumServicesStatusExW(
        hSCManager: SC_HANDLE,
        InfoLevel: SC_ENUM_TYPE,
        dwServiceType: DWORD,
        dwServiceState: DWORD,
        lpServices: LPBYTE,
        cbBufSize: DWORD,
        pcbBytesNeeded: LPDWORD,
        lpServicesReturned: LPDWORD,
        lpResumeHandle: LPDWORD,
        pszGroupName: LPCWSTR,
    ) -> BOOL;
}
extern "C" {
    pub static IID_IEnumConnections: IID;
}
extern "C" {
    pub static IID_IConnectionPoint: IID;
}
extern "C" {
    pub static IID_IEnumConnectionPoints: IID;
}
extern "C" {
    pub static IID_IConnectionPointContainer: IID;
}
extern "C" {
    pub static IID_IClassFactory2: IID;
}
extern "C" {
    pub static IID_IProvideClassInfo: IID;
}
extern "C" {
    pub static IID_IProvideClassInfo2: IID;
}
extern "C" {
    pub static IID_IProvideMultipleClassInfo: IID;
}
extern "C" {
    pub static IID_IOleControl: IID;
}
extern "C" {
    pub static IID_IOleControlSite: IID;
}
extern "C" {
    pub static IID_IPropertyPage: IID;
}
extern "C" {
    pub static IID_IPropertyPage2: IID;
}
extern "C" {
    pub static IID_IPropertyPageSite: IID;
}
extern "C" {
    pub static IID_IPropertyNotifySink: IID;
}
extern "C" {
    pub static IID_ISpecifyPropertyPages: IID;
}
extern "C" {
    pub static IID_IPersistMemory: IID;
}
extern "C" {
    pub static IID_IPersistStreamInit: IID;
}
extern "C" {
    pub static IID_IPersistPropertyBag: IID;
}
extern "C" {
    pub static IID_ISimpleFrameSite: IID;
}
extern "C" {
    pub static IID_IFont: IID;
}
extern "C" {
    pub static IID_IPicture: IID;
}
extern "C" {
    pub static IID_IPicture2: IID;
}
extern "C" {
    pub static IID_IFontEventsDisp: IID;
}
extern "C" {
    pub static IID_IFontDisp: IID;
}
extern "C" {
    pub static IID_IPictureDisp: IID;
}
extern "C" {
    pub static IID_IOleInPlaceObjectWindowless: IID;
}
extern "C" {
    pub static IID_IOleInPlaceSiteEx: IID;
}
extern "C" {
    pub static IID_IOleInPlaceSiteWindowless: IID;
}
extern "C" {
    pub static IID_IViewObjectEx: IID;
}
extern "C" {
    pub static IID_IOleUndoUnit: IID;
}
extern "C" {
    pub static IID_IOleParentUndoUnit: IID;
}
extern "C" {
    pub static IID_IEnumOleUndoUnits: IID;
}
extern "C" {
    pub static IID_IOleUndoManager: IID;
}
extern "C" {
    pub static IID_IPointerInactive: IID;
}
extern "C" {
    pub static IID_IObjectWithSite: IID;
}
extern "C" {
    pub static IID_IPerPropertyBrowsing: IID;
}
extern "C" {
    pub static IID_IPropertyBag2: IID;
}
extern "C" {
    pub static IID_IPersistPropertyBag2: IID;
}
extern "C" {
    pub static IID_IAdviseSinkEx: IID;
}
extern "C" {
    pub static IID_IQuickActivate: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_RATIONAL {
    pub Numerator: UINT,
    pub Denominator: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_SAMPLE_DESC {
    pub Count: UINT,
    pub Quality: UINT,
}
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_FULL_G22_NONE_P709:
    DXGI_COLOR_SPACE_TYPE = 0;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_FULL_G10_NONE_P709:
    DXGI_COLOR_SPACE_TYPE = 1;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_STUDIO_G22_NONE_P709:
    DXGI_COLOR_SPACE_TYPE = 2;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_STUDIO_G22_NONE_P2020:
    DXGI_COLOR_SPACE_TYPE = 3;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RESERVED:
    DXGI_COLOR_SPACE_TYPE = 4;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_FULL_G22_NONE_P709_X601 : DXGI_COLOR_SPACE_TYPE = 5 ;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G22_LEFT_P601:
    DXGI_COLOR_SPACE_TYPE = 6;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_FULL_G22_LEFT_P601:
    DXGI_COLOR_SPACE_TYPE = 7;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G22_LEFT_P709:
    DXGI_COLOR_SPACE_TYPE = 8;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_FULL_G22_LEFT_P709:
    DXGI_COLOR_SPACE_TYPE = 9;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G22_LEFT_P2020:
    DXGI_COLOR_SPACE_TYPE = 10;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_FULL_G22_LEFT_P2020:
    DXGI_COLOR_SPACE_TYPE = 11;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_FULL_G2084_NONE_P2020:
    DXGI_COLOR_SPACE_TYPE = 12;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G2084_LEFT_P2020 : DXGI_COLOR_SPACE_TYPE = 13 ;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_STUDIO_G2084_NONE_P2020:
    DXGI_COLOR_SPACE_TYPE = 14;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G22_TOPLEFT_P2020 : DXGI_COLOR_SPACE_TYPE = 15 ;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G2084_TOPLEFT_P2020 : DXGI_COLOR_SPACE_TYPE = 16 ;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_FULL_G22_NONE_P2020:
    DXGI_COLOR_SPACE_TYPE = 17;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_GHLG_TOPLEFT_P2020 : DXGI_COLOR_SPACE_TYPE = 18 ;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_FULL_GHLG_TOPLEFT_P2020 : DXGI_COLOR_SPACE_TYPE = 19 ;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_STUDIO_G24_NONE_P709:
    DXGI_COLOR_SPACE_TYPE = 20;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_RGB_STUDIO_G24_NONE_P2020:
    DXGI_COLOR_SPACE_TYPE = 21;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G24_LEFT_P709:
    DXGI_COLOR_SPACE_TYPE = 22;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G24_LEFT_P2020:
    DXGI_COLOR_SPACE_TYPE = 23;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_YCBCR_STUDIO_G24_TOPLEFT_P2020 : DXGI_COLOR_SPACE_TYPE = 24 ;
pub const DXGI_COLOR_SPACE_TYPE_DXGI_COLOR_SPACE_CUSTOM: DXGI_COLOR_SPACE_TYPE =
    -1;
pub type DXGI_COLOR_SPACE_TYPE = ::std::os::raw::c_int;
pub const DXGI_FORMAT_DXGI_FORMAT_UNKNOWN: DXGI_FORMAT = 0;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32B32A32_TYPELESS: DXGI_FORMAT = 1;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32B32A32_FLOAT: DXGI_FORMAT = 2;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32B32A32_UINT: DXGI_FORMAT = 3;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32B32A32_SINT: DXGI_FORMAT = 4;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32B32_TYPELESS: DXGI_FORMAT = 5;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32B32_FLOAT: DXGI_FORMAT = 6;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32B32_UINT: DXGI_FORMAT = 7;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32B32_SINT: DXGI_FORMAT = 8;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16B16A16_TYPELESS: DXGI_FORMAT = 9;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16B16A16_FLOAT: DXGI_FORMAT = 10;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16B16A16_UNORM: DXGI_FORMAT = 11;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16B16A16_UINT: DXGI_FORMAT = 12;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16B16A16_SNORM: DXGI_FORMAT = 13;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16B16A16_SINT: DXGI_FORMAT = 14;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32_TYPELESS: DXGI_FORMAT = 15;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32_FLOAT: DXGI_FORMAT = 16;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32_UINT: DXGI_FORMAT = 17;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G32_SINT: DXGI_FORMAT = 18;
pub const DXGI_FORMAT_DXGI_FORMAT_R32G8X24_TYPELESS: DXGI_FORMAT = 19;
pub const DXGI_FORMAT_DXGI_FORMAT_D32_FLOAT_S8X24_UINT: DXGI_FORMAT = 20;
pub const DXGI_FORMAT_DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS: DXGI_FORMAT = 21;
pub const DXGI_FORMAT_DXGI_FORMAT_X32_TYPELESS_G8X24_UINT: DXGI_FORMAT = 22;
pub const DXGI_FORMAT_DXGI_FORMAT_R10G10B10A2_TYPELESS: DXGI_FORMAT = 23;
pub const DXGI_FORMAT_DXGI_FORMAT_R10G10B10A2_UNORM: DXGI_FORMAT = 24;
pub const DXGI_FORMAT_DXGI_FORMAT_R10G10B10A2_UINT: DXGI_FORMAT = 25;
pub const DXGI_FORMAT_DXGI_FORMAT_R11G11B10_FLOAT: DXGI_FORMAT = 26;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8B8A8_TYPELESS: DXGI_FORMAT = 27;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8B8A8_UNORM: DXGI_FORMAT = 28;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8B8A8_UNORM_SRGB: DXGI_FORMAT = 29;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8B8A8_UINT: DXGI_FORMAT = 30;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8B8A8_SNORM: DXGI_FORMAT = 31;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8B8A8_SINT: DXGI_FORMAT = 32;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16_TYPELESS: DXGI_FORMAT = 33;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16_FLOAT: DXGI_FORMAT = 34;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16_UNORM: DXGI_FORMAT = 35;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16_UINT: DXGI_FORMAT = 36;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16_SNORM: DXGI_FORMAT = 37;
pub const DXGI_FORMAT_DXGI_FORMAT_R16G16_SINT: DXGI_FORMAT = 38;
pub const DXGI_FORMAT_DXGI_FORMAT_R32_TYPELESS: DXGI_FORMAT = 39;
pub const DXGI_FORMAT_DXGI_FORMAT_D32_FLOAT: DXGI_FORMAT = 40;
pub const DXGI_FORMAT_DXGI_FORMAT_R32_FLOAT: DXGI_FORMAT = 41;
pub const DXGI_FORMAT_DXGI_FORMAT_R32_UINT: DXGI_FORMAT = 42;
pub const DXGI_FORMAT_DXGI_FORMAT_R32_SINT: DXGI_FORMAT = 43;
pub const DXGI_FORMAT_DXGI_FORMAT_R24G8_TYPELESS: DXGI_FORMAT = 44;
pub const DXGI_FORMAT_DXGI_FORMAT_D24_UNORM_S8_UINT: DXGI_FORMAT = 45;
pub const DXGI_FORMAT_DXGI_FORMAT_R24_UNORM_X8_TYPELESS: DXGI_FORMAT = 46;
pub const DXGI_FORMAT_DXGI_FORMAT_X24_TYPELESS_G8_UINT: DXGI_FORMAT = 47;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8_TYPELESS: DXGI_FORMAT = 48;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8_UNORM: DXGI_FORMAT = 49;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8_UINT: DXGI_FORMAT = 50;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8_SNORM: DXGI_FORMAT = 51;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8_SINT: DXGI_FORMAT = 52;
pub const DXGI_FORMAT_DXGI_FORMAT_R16_TYPELESS: DXGI_FORMAT = 53;
pub const DXGI_FORMAT_DXGI_FORMAT_R16_FLOAT: DXGI_FORMAT = 54;
pub const DXGI_FORMAT_DXGI_FORMAT_D16_UNORM: DXGI_FORMAT = 55;
pub const DXGI_FORMAT_DXGI_FORMAT_R16_UNORM: DXGI_FORMAT = 56;
pub const DXGI_FORMAT_DXGI_FORMAT_R16_UINT: DXGI_FORMAT = 57;
pub const DXGI_FORMAT_DXGI_FORMAT_R16_SNORM: DXGI_FORMAT = 58;
pub const DXGI_FORMAT_DXGI_FORMAT_R16_SINT: DXGI_FORMAT = 59;
pub const DXGI_FORMAT_DXGI_FORMAT_R8_TYPELESS: DXGI_FORMAT = 60;
pub const DXGI_FORMAT_DXGI_FORMAT_R8_UNORM: DXGI_FORMAT = 61;
pub const DXGI_FORMAT_DXGI_FORMAT_R8_UINT: DXGI_FORMAT = 62;
pub const DXGI_FORMAT_DXGI_FORMAT_R8_SNORM: DXGI_FORMAT = 63;
pub const DXGI_FORMAT_DXGI_FORMAT_R8_SINT: DXGI_FORMAT = 64;
pub const DXGI_FORMAT_DXGI_FORMAT_A8_UNORM: DXGI_FORMAT = 65;
pub const DXGI_FORMAT_DXGI_FORMAT_R1_UNORM: DXGI_FORMAT = 66;
pub const DXGI_FORMAT_DXGI_FORMAT_R9G9B9E5_SHAREDEXP: DXGI_FORMAT = 67;
pub const DXGI_FORMAT_DXGI_FORMAT_R8G8_B8G8_UNORM: DXGI_FORMAT = 68;
pub const DXGI_FORMAT_DXGI_FORMAT_G8R8_G8B8_UNORM: DXGI_FORMAT = 69;
pub const DXGI_FORMAT_DXGI_FORMAT_BC1_TYPELESS: DXGI_FORMAT = 70;
pub const DXGI_FORMAT_DXGI_FORMAT_BC1_UNORM: DXGI_FORMAT = 71;
pub const DXGI_FORMAT_DXGI_FORMAT_BC1_UNORM_SRGB: DXGI_FORMAT = 72;
pub const DXGI_FORMAT_DXGI_FORMAT_BC2_TYPELESS: DXGI_FORMAT = 73;
pub const DXGI_FORMAT_DXGI_FORMAT_BC2_UNORM: DXGI_FORMAT = 74;
pub const DXGI_FORMAT_DXGI_FORMAT_BC2_UNORM_SRGB: DXGI_FORMAT = 75;
pub const DXGI_FORMAT_DXGI_FORMAT_BC3_TYPELESS: DXGI_FORMAT = 76;
pub const DXGI_FORMAT_DXGI_FORMAT_BC3_UNORM: DXGI_FORMAT = 77;
pub const DXGI_FORMAT_DXGI_FORMAT_BC3_UNORM_SRGB: DXGI_FORMAT = 78;
pub const DXGI_FORMAT_DXGI_FORMAT_BC4_TYPELESS: DXGI_FORMAT = 79;
pub const DXGI_FORMAT_DXGI_FORMAT_BC4_UNORM: DXGI_FORMAT = 80;
pub const DXGI_FORMAT_DXGI_FORMAT_BC4_SNORM: DXGI_FORMAT = 81;
pub const DXGI_FORMAT_DXGI_FORMAT_BC5_TYPELESS: DXGI_FORMAT = 82;
pub const DXGI_FORMAT_DXGI_FORMAT_BC5_UNORM: DXGI_FORMAT = 83;
pub const DXGI_FORMAT_DXGI_FORMAT_BC5_SNORM: DXGI_FORMAT = 84;
pub const DXGI_FORMAT_DXGI_FORMAT_B5G6R5_UNORM: DXGI_FORMAT = 85;
pub const DXGI_FORMAT_DXGI_FORMAT_B5G5R5A1_UNORM: DXGI_FORMAT = 86;
pub const DXGI_FORMAT_DXGI_FORMAT_B8G8R8A8_UNORM: DXGI_FORMAT = 87;
pub const DXGI_FORMAT_DXGI_FORMAT_B8G8R8X8_UNORM: DXGI_FORMAT = 88;
pub const DXGI_FORMAT_DXGI_FORMAT_R10G10B10_XR_BIAS_A2_UNORM: DXGI_FORMAT = 89;
pub const DXGI_FORMAT_DXGI_FORMAT_B8G8R8A8_TYPELESS: DXGI_FORMAT = 90;
pub const DXGI_FORMAT_DXGI_FORMAT_B8G8R8A8_UNORM_SRGB: DXGI_FORMAT = 91;
pub const DXGI_FORMAT_DXGI_FORMAT_B8G8R8X8_TYPELESS: DXGI_FORMAT = 92;
pub const DXGI_FORMAT_DXGI_FORMAT_B8G8R8X8_UNORM_SRGB: DXGI_FORMAT = 93;
pub const DXGI_FORMAT_DXGI_FORMAT_BC6H_TYPELESS: DXGI_FORMAT = 94;
pub const DXGI_FORMAT_DXGI_FORMAT_BC6H_UF16: DXGI_FORMAT = 95;
pub const DXGI_FORMAT_DXGI_FORMAT_BC6H_SF16: DXGI_FORMAT = 96;
pub const DXGI_FORMAT_DXGI_FORMAT_BC7_TYPELESS: DXGI_FORMAT = 97;
pub const DXGI_FORMAT_DXGI_FORMAT_BC7_UNORM: DXGI_FORMAT = 98;
pub const DXGI_FORMAT_DXGI_FORMAT_BC7_UNORM_SRGB: DXGI_FORMAT = 99;
pub const DXGI_FORMAT_DXGI_FORMAT_AYUV: DXGI_FORMAT = 100;
pub const DXGI_FORMAT_DXGI_FORMAT_Y410: DXGI_FORMAT = 101;
pub const DXGI_FORMAT_DXGI_FORMAT_Y416: DXGI_FORMAT = 102;
pub const DXGI_FORMAT_DXGI_FORMAT_NV12: DXGI_FORMAT = 103;
pub const DXGI_FORMAT_DXGI_FORMAT_P010: DXGI_FORMAT = 104;
pub const DXGI_FORMAT_DXGI_FORMAT_P016: DXGI_FORMAT = 105;
pub const DXGI_FORMAT_DXGI_FORMAT_420_OPAQUE: DXGI_FORMAT = 106;
pub const DXGI_FORMAT_DXGI_FORMAT_YUY2: DXGI_FORMAT = 107;
pub const DXGI_FORMAT_DXGI_FORMAT_Y210: DXGI_FORMAT = 108;
pub const DXGI_FORMAT_DXGI_FORMAT_Y216: DXGI_FORMAT = 109;
pub const DXGI_FORMAT_DXGI_FORMAT_NV11: DXGI_FORMAT = 110;
pub const DXGI_FORMAT_DXGI_FORMAT_AI44: DXGI_FORMAT = 111;
pub const DXGI_FORMAT_DXGI_FORMAT_IA44: DXGI_FORMAT = 112;
pub const DXGI_FORMAT_DXGI_FORMAT_P8: DXGI_FORMAT = 113;
pub const DXGI_FORMAT_DXGI_FORMAT_A8P8: DXGI_FORMAT = 114;
pub const DXGI_FORMAT_DXGI_FORMAT_B4G4R4A4_UNORM: DXGI_FORMAT = 115;
pub const DXGI_FORMAT_DXGI_FORMAT_P208: DXGI_FORMAT = 130;
pub const DXGI_FORMAT_DXGI_FORMAT_V208: DXGI_FORMAT = 131;
pub const DXGI_FORMAT_DXGI_FORMAT_V408: DXGI_FORMAT = 132;
pub const DXGI_FORMAT_DXGI_FORMAT_SAMPLER_FEEDBACK_MIN_MIP_OPAQUE: DXGI_FORMAT =
    189;
pub const DXGI_FORMAT_DXGI_FORMAT_SAMPLER_FEEDBACK_MIP_REGION_USED_OPAQUE:
    DXGI_FORMAT = 190;
pub const DXGI_FORMAT_DXGI_FORMAT_FORCE_UINT: DXGI_FORMAT = -1;
pub type DXGI_FORMAT = ::std::os::raw::c_int;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_1_0_CORE: D3D_FEATURE_LEVEL =
    4096;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_9_1: D3D_FEATURE_LEVEL = 37120;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_9_2: D3D_FEATURE_LEVEL = 37376;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_9_3: D3D_FEATURE_LEVEL = 37632;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_10_0: D3D_FEATURE_LEVEL = 40960;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_10_1: D3D_FEATURE_LEVEL = 41216;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_11_0: D3D_FEATURE_LEVEL = 45056;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_11_1: D3D_FEATURE_LEVEL = 45312;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_12_0: D3D_FEATURE_LEVEL = 49152;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_12_1: D3D_FEATURE_LEVEL = 49408;
pub const D3D_FEATURE_LEVEL_D3D_FEATURE_LEVEL_12_2: D3D_FEATURE_LEVEL = 49664;
pub type D3D_FEATURE_LEVEL = ::std::os::raw::c_int;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_UNDEFINED:
    D3D_PRIMITIVE_TOPOLOGY = 0;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_POINTLIST:
    D3D_PRIMITIVE_TOPOLOGY = 1;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_LINELIST:
    D3D_PRIMITIVE_TOPOLOGY = 2;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_LINESTRIP:
    D3D_PRIMITIVE_TOPOLOGY = 3;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST:
    D3D_PRIMITIVE_TOPOLOGY = 4;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP:
    D3D_PRIMITIVE_TOPOLOGY = 5;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_LINELIST_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 10;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 11;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 12;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 13;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 33 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 34 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 35 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 36 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 37 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 38 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 39 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 40 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 41 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 42 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 43 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 44 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 45 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 46 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 47 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 48 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 49 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 50 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 51 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 52 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 53 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 54 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 55 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 56 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 57 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 58 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 59 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 60 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 61 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 62 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 63 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 64 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_UNDEFINED:
    D3D_PRIMITIVE_TOPOLOGY = 0;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_POINTLIST:
    D3D_PRIMITIVE_TOPOLOGY = 1;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_LINELIST:
    D3D_PRIMITIVE_TOPOLOGY = 2;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP:
    D3D_PRIMITIVE_TOPOLOGY = 3;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST:
    D3D_PRIMITIVE_TOPOLOGY = 4;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP:
    D3D_PRIMITIVE_TOPOLOGY = 5;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_LINELIST_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 10;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 11;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 12;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 13;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED:
    D3D_PRIMITIVE_TOPOLOGY = 0;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_POINTLIST:
    D3D_PRIMITIVE_TOPOLOGY = 1;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_LINELIST:
    D3D_PRIMITIVE_TOPOLOGY = 2;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP:
    D3D_PRIMITIVE_TOPOLOGY = 3;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST:
    D3D_PRIMITIVE_TOPOLOGY = 4;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP:
    D3D_PRIMITIVE_TOPOLOGY = 5;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 10;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 11;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 12;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ:
    D3D_PRIMITIVE_TOPOLOGY = 13;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 33 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 34 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 35 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 36 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 37 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 38 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 39 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 40 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 41 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 42 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 43 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 44 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 45 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 46 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 47 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 48 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 49 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 50 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 51 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 52 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 53 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 54 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 55 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 56 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 57 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 58 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 59 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 60 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 61 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 62 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 63 ;
pub const D3D_PRIMITIVE_TOPOLOGY_D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST : D3D_PRIMITIVE_TOPOLOGY = 64 ;
pub type D3D_PRIMITIVE_TOPOLOGY = ::std::os::raw::c_int;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_UNDEFINED: D3D_PRIMITIVE = 0;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_POINT: D3D_PRIMITIVE = 1;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_LINE: D3D_PRIMITIVE = 2;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_TRIANGLE: D3D_PRIMITIVE = 3;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_LINE_ADJ: D3D_PRIMITIVE = 6;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_TRIANGLE_ADJ: D3D_PRIMITIVE = 7;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_1_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 8;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_2_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 9;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_3_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 10;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_4_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 11;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_5_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 12;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_6_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 13;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_7_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 14;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_8_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 15;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_9_CONTROL_POINT_PATCH: D3D_PRIMITIVE = 16;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_10_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    17;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_11_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    18;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_12_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    19;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_13_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    20;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_14_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    21;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_15_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    22;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_16_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    23;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_17_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    24;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_18_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    25;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_19_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    26;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_20_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    27;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_21_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    28;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_22_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    29;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_23_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    30;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_24_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    31;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_25_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    32;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_26_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    33;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_27_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    34;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_28_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    35;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_29_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    36;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_30_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    37;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_31_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    38;
pub const D3D_PRIMITIVE_D3D_PRIMITIVE_32_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    39;
pub const D3D_PRIMITIVE_D3D10_PRIMITIVE_UNDEFINED: D3D_PRIMITIVE = 0;
pub const D3D_PRIMITIVE_D3D10_PRIMITIVE_POINT: D3D_PRIMITIVE = 1;
pub const D3D_PRIMITIVE_D3D10_PRIMITIVE_LINE: D3D_PRIMITIVE = 2;
pub const D3D_PRIMITIVE_D3D10_PRIMITIVE_TRIANGLE: D3D_PRIMITIVE = 3;
pub const D3D_PRIMITIVE_D3D10_PRIMITIVE_LINE_ADJ: D3D_PRIMITIVE = 6;
pub const D3D_PRIMITIVE_D3D10_PRIMITIVE_TRIANGLE_ADJ: D3D_PRIMITIVE = 7;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_UNDEFINED: D3D_PRIMITIVE = 0;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_POINT: D3D_PRIMITIVE = 1;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_LINE: D3D_PRIMITIVE = 2;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_TRIANGLE: D3D_PRIMITIVE = 3;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_LINE_ADJ: D3D_PRIMITIVE = 6;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_TRIANGLE_ADJ: D3D_PRIMITIVE = 7;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    8;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    9;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    10;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    11;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    12;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    13;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    14;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    15;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    16;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    17;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    18;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    19;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    20;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    21;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    22;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    23;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    24;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    25;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    26;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    27;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    28;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    29;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    30;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    31;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    32;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    33;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    34;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    35;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    36;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    37;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    38;
pub const D3D_PRIMITIVE_D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH: D3D_PRIMITIVE =
    39;
pub type D3D_PRIMITIVE = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D10Blob: GUID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D10BlobVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D10Blob,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D10Blob) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D10Blob) -> ULONG,
    >,
    pub GetBufferPointer: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D10Blob) -> LPVOID,
    >,
    pub GetBufferSize: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D10Blob) -> SIZE_T,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D10Blob {
    pub lpVtbl: *mut ID3D10BlobVtbl,
}
impl Default for ID3D10Blob {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ID3DBlob = ID3D10Blob;
extern "C" {
    pub static IID_ID3DDestructionNotifier: IID;
}
extern "C" {
    pub static WKPDID_D3DDebugObjectName: GUID;
}
extern "C" {
    pub static WKPDID_D3DDebugObjectNameW: GUID;
}
extern "C" {
    pub static WKPDID_CommentStringW: GUID;
}
extern "C" {
    pub static WKPDID_D3D12UniqueObjectId: GUID;
}
pub type D3D12_GPU_VIRTUAL_ADDRESS = UINT64;
pub const D3D12_COMMAND_LIST_TYPE_D3D12_COMMAND_LIST_TYPE_DIRECT:
    D3D12_COMMAND_LIST_TYPE = 0;
pub const D3D12_COMMAND_LIST_TYPE_D3D12_COMMAND_LIST_TYPE_BUNDLE:
    D3D12_COMMAND_LIST_TYPE = 1;
pub const D3D12_COMMAND_LIST_TYPE_D3D12_COMMAND_LIST_TYPE_COMPUTE:
    D3D12_COMMAND_LIST_TYPE = 2;
pub const D3D12_COMMAND_LIST_TYPE_D3D12_COMMAND_LIST_TYPE_COPY:
    D3D12_COMMAND_LIST_TYPE = 3;
pub const D3D12_COMMAND_LIST_TYPE_D3D12_COMMAND_LIST_TYPE_VIDEO_DECODE:
    D3D12_COMMAND_LIST_TYPE = 4;
pub const D3D12_COMMAND_LIST_TYPE_D3D12_COMMAND_LIST_TYPE_VIDEO_PROCESS:
    D3D12_COMMAND_LIST_TYPE = 5;
pub const D3D12_COMMAND_LIST_TYPE_D3D12_COMMAND_LIST_TYPE_VIDEO_ENCODE:
    D3D12_COMMAND_LIST_TYPE = 6;
pub type D3D12_COMMAND_LIST_TYPE = ::std::os::raw::c_int;
pub const D3D12_COMMAND_QUEUE_FLAGS_D3D12_COMMAND_QUEUE_FLAG_NONE:
    D3D12_COMMAND_QUEUE_FLAGS = 0;
pub const D3D12_COMMAND_QUEUE_FLAGS_D3D12_COMMAND_QUEUE_FLAG_DISABLE_GPU_TIMEOUT : D3D12_COMMAND_QUEUE_FLAGS = 1 ;
pub type D3D12_COMMAND_QUEUE_FLAGS = ::std::os::raw::c_int;
pub const D3D12_COMMAND_QUEUE_PRIORITY_D3D12_COMMAND_QUEUE_PRIORITY_NORMAL:
    D3D12_COMMAND_QUEUE_PRIORITY = 0;
pub const D3D12_COMMAND_QUEUE_PRIORITY_D3D12_COMMAND_QUEUE_PRIORITY_HIGH:
    D3D12_COMMAND_QUEUE_PRIORITY = 100;
pub const D3D12_COMMAND_QUEUE_PRIORITY_D3D12_COMMAND_QUEUE_PRIORITY_GLOBAL_REALTIME : D3D12_COMMAND_QUEUE_PRIORITY = 10000 ;
pub type D3D12_COMMAND_QUEUE_PRIORITY = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_COMMAND_QUEUE_DESC {
    pub Type: D3D12_COMMAND_LIST_TYPE,
    pub Priority: INT,
    pub Flags: D3D12_COMMAND_QUEUE_FLAGS,
    pub NodeMask: UINT,
}
impl Default for D3D12_COMMAND_QUEUE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_D3D12_PRIMITIVE_TOPOLOGY_TYPE_UNDEFINED : D3D12_PRIMITIVE_TOPOLOGY_TYPE = 0 ;
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_D3D12_PRIMITIVE_TOPOLOGY_TYPE_POINT:
    D3D12_PRIMITIVE_TOPOLOGY_TYPE = 1;
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_D3D12_PRIMITIVE_TOPOLOGY_TYPE_LINE:
    D3D12_PRIMITIVE_TOPOLOGY_TYPE = 2;
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_D3D12_PRIMITIVE_TOPOLOGY_TYPE_TRIANGLE : D3D12_PRIMITIVE_TOPOLOGY_TYPE = 3 ;
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_D3D12_PRIMITIVE_TOPOLOGY_TYPE_PATCH:
    D3D12_PRIMITIVE_TOPOLOGY_TYPE = 4;
pub type D3D12_PRIMITIVE_TOPOLOGY_TYPE = ::std::os::raw::c_int;
pub const D3D12_INPUT_CLASSIFICATION_D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA : D3D12_INPUT_CLASSIFICATION = 0 ;
pub const D3D12_INPUT_CLASSIFICATION_D3D12_INPUT_CLASSIFICATION_PER_INSTANCE_DATA : D3D12_INPUT_CLASSIFICATION = 1 ;
pub type D3D12_INPUT_CLASSIFICATION = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INPUT_ELEMENT_DESC {
    pub SemanticName: LPCSTR,
    pub SemanticIndex: UINT,
    pub Format: DXGI_FORMAT,
    pub InputSlot: UINT,
    pub AlignedByteOffset: UINT,
    pub InputSlotClass: D3D12_INPUT_CLASSIFICATION,
    pub InstanceDataStepRate: UINT,
}
impl Default for D3D12_INPUT_ELEMENT_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_FILL_MODE_D3D12_FILL_MODE_WIREFRAME: D3D12_FILL_MODE = 2;
pub const D3D12_FILL_MODE_D3D12_FILL_MODE_SOLID: D3D12_FILL_MODE = 3;
pub type D3D12_FILL_MODE = ::std::os::raw::c_int;
pub use self::D3D_PRIMITIVE as D3D12_PRIMITIVE;
pub use self::D3D_PRIMITIVE_TOPOLOGY as D3D12_PRIMITIVE_TOPOLOGY;
pub const D3D12_CULL_MODE_D3D12_CULL_MODE_NONE: D3D12_CULL_MODE = 1;
pub const D3D12_CULL_MODE_D3D12_CULL_MODE_FRONT: D3D12_CULL_MODE = 2;
pub const D3D12_CULL_MODE_D3D12_CULL_MODE_BACK: D3D12_CULL_MODE = 3;
pub type D3D12_CULL_MODE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SO_DECLARATION_ENTRY {
    pub Stream: UINT,
    pub SemanticName: LPCSTR,
    pub SemanticIndex: UINT,
    pub StartComponent: BYTE,
    pub ComponentCount: BYTE,
    pub OutputSlot: BYTE,
}
impl Default for D3D12_SO_DECLARATION_ENTRY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_VIEWPORT {
    pub TopLeftX: FLOAT,
    pub TopLeftY: FLOAT,
    pub Width: FLOAT,
    pub Height: FLOAT,
    pub MinDepth: FLOAT,
    pub MaxDepth: FLOAT,
}
pub type D3D12_RECT = RECT;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_BOX {
    pub left: UINT,
    pub top: UINT,
    pub front: UINT,
    pub right: UINT,
    pub bottom: UINT,
    pub back: UINT,
}
pub const D3D12_COMPARISON_FUNC_D3D12_COMPARISON_FUNC_NEVER:
    D3D12_COMPARISON_FUNC = 1;
pub const D3D12_COMPARISON_FUNC_D3D12_COMPARISON_FUNC_LESS:
    D3D12_COMPARISON_FUNC = 2;
pub const D3D12_COMPARISON_FUNC_D3D12_COMPARISON_FUNC_EQUAL:
    D3D12_COMPARISON_FUNC = 3;
pub const D3D12_COMPARISON_FUNC_D3D12_COMPARISON_FUNC_LESS_EQUAL:
    D3D12_COMPARISON_FUNC = 4;
pub const D3D12_COMPARISON_FUNC_D3D12_COMPARISON_FUNC_GREATER:
    D3D12_COMPARISON_FUNC = 5;
pub const D3D12_COMPARISON_FUNC_D3D12_COMPARISON_FUNC_NOT_EQUAL:
    D3D12_COMPARISON_FUNC = 6;
pub const D3D12_COMPARISON_FUNC_D3D12_COMPARISON_FUNC_GREATER_EQUAL:
    D3D12_COMPARISON_FUNC = 7;
pub const D3D12_COMPARISON_FUNC_D3D12_COMPARISON_FUNC_ALWAYS:
    D3D12_COMPARISON_FUNC = 8;
pub type D3D12_COMPARISON_FUNC = ::std::os::raw::c_int;
pub const D3D12_DEPTH_WRITE_MASK_D3D12_DEPTH_WRITE_MASK_ZERO:
    D3D12_DEPTH_WRITE_MASK = 0;
pub const D3D12_DEPTH_WRITE_MASK_D3D12_DEPTH_WRITE_MASK_ALL:
    D3D12_DEPTH_WRITE_MASK = 1;
pub type D3D12_DEPTH_WRITE_MASK = ::std::os::raw::c_int;
pub const D3D12_STENCIL_OP_D3D12_STENCIL_OP_KEEP: D3D12_STENCIL_OP = 1;
pub const D3D12_STENCIL_OP_D3D12_STENCIL_OP_ZERO: D3D12_STENCIL_OP = 2;
pub const D3D12_STENCIL_OP_D3D12_STENCIL_OP_REPLACE: D3D12_STENCIL_OP = 3;
pub const D3D12_STENCIL_OP_D3D12_STENCIL_OP_INCR_SAT: D3D12_STENCIL_OP = 4;
pub const D3D12_STENCIL_OP_D3D12_STENCIL_OP_DECR_SAT: D3D12_STENCIL_OP = 5;
pub const D3D12_STENCIL_OP_D3D12_STENCIL_OP_INVERT: D3D12_STENCIL_OP = 6;
pub const D3D12_STENCIL_OP_D3D12_STENCIL_OP_INCR: D3D12_STENCIL_OP = 7;
pub const D3D12_STENCIL_OP_D3D12_STENCIL_OP_DECR: D3D12_STENCIL_OP = 8;
pub type D3D12_STENCIL_OP = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEPTH_STENCILOP_DESC {
    pub StencilFailOp: D3D12_STENCIL_OP,
    pub StencilDepthFailOp: D3D12_STENCIL_OP,
    pub StencilPassOp: D3D12_STENCIL_OP,
    pub StencilFunc: D3D12_COMPARISON_FUNC,
}
impl Default for D3D12_DEPTH_STENCILOP_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEPTH_STENCIL_DESC {
    pub DepthEnable: BOOL,
    pub DepthWriteMask: D3D12_DEPTH_WRITE_MASK,
    pub DepthFunc: D3D12_COMPARISON_FUNC,
    pub StencilEnable: BOOL,
    pub StencilReadMask: UINT8,
    pub StencilWriteMask: UINT8,
    pub FrontFace: D3D12_DEPTH_STENCILOP_DESC,
    pub BackFace: D3D12_DEPTH_STENCILOP_DESC,
}
impl Default for D3D12_DEPTH_STENCIL_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEPTH_STENCIL_DESC1 {
    pub DepthEnable: BOOL,
    pub DepthWriteMask: D3D12_DEPTH_WRITE_MASK,
    pub DepthFunc: D3D12_COMPARISON_FUNC,
    pub StencilEnable: BOOL,
    pub StencilReadMask: UINT8,
    pub StencilWriteMask: UINT8,
    pub FrontFace: D3D12_DEPTH_STENCILOP_DESC,
    pub BackFace: D3D12_DEPTH_STENCILOP_DESC,
    pub DepthBoundsTestEnable: BOOL,
}
impl Default for D3D12_DEPTH_STENCIL_DESC1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_BLEND_D3D12_BLEND_ZERO: D3D12_BLEND = 1;
pub const D3D12_BLEND_D3D12_BLEND_ONE: D3D12_BLEND = 2;
pub const D3D12_BLEND_D3D12_BLEND_SRC_COLOR: D3D12_BLEND = 3;
pub const D3D12_BLEND_D3D12_BLEND_INV_SRC_COLOR: D3D12_BLEND = 4;
pub const D3D12_BLEND_D3D12_BLEND_SRC_ALPHA: D3D12_BLEND = 5;
pub const D3D12_BLEND_D3D12_BLEND_INV_SRC_ALPHA: D3D12_BLEND = 6;
pub const D3D12_BLEND_D3D12_BLEND_DEST_ALPHA: D3D12_BLEND = 7;
pub const D3D12_BLEND_D3D12_BLEND_INV_DEST_ALPHA: D3D12_BLEND = 8;
pub const D3D12_BLEND_D3D12_BLEND_DEST_COLOR: D3D12_BLEND = 9;
pub const D3D12_BLEND_D3D12_BLEND_INV_DEST_COLOR: D3D12_BLEND = 10;
pub const D3D12_BLEND_D3D12_BLEND_SRC_ALPHA_SAT: D3D12_BLEND = 11;
pub const D3D12_BLEND_D3D12_BLEND_BLEND_FACTOR: D3D12_BLEND = 14;
pub const D3D12_BLEND_D3D12_BLEND_INV_BLEND_FACTOR: D3D12_BLEND = 15;
pub const D3D12_BLEND_D3D12_BLEND_SRC1_COLOR: D3D12_BLEND = 16;
pub const D3D12_BLEND_D3D12_BLEND_INV_SRC1_COLOR: D3D12_BLEND = 17;
pub const D3D12_BLEND_D3D12_BLEND_SRC1_ALPHA: D3D12_BLEND = 18;
pub const D3D12_BLEND_D3D12_BLEND_INV_SRC1_ALPHA: D3D12_BLEND = 19;
pub type D3D12_BLEND = ::std::os::raw::c_int;
pub const D3D12_BLEND_OP_D3D12_BLEND_OP_ADD: D3D12_BLEND_OP = 1;
pub const D3D12_BLEND_OP_D3D12_BLEND_OP_SUBTRACT: D3D12_BLEND_OP = 2;
pub const D3D12_BLEND_OP_D3D12_BLEND_OP_REV_SUBTRACT: D3D12_BLEND_OP = 3;
pub const D3D12_BLEND_OP_D3D12_BLEND_OP_MIN: D3D12_BLEND_OP = 4;
pub const D3D12_BLEND_OP_D3D12_BLEND_OP_MAX: D3D12_BLEND_OP = 5;
pub type D3D12_BLEND_OP = ::std::os::raw::c_int;
pub const D3D12_COLOR_WRITE_ENABLE_D3D12_COLOR_WRITE_ENABLE_RED:
    D3D12_COLOR_WRITE_ENABLE = 1;
pub const D3D12_COLOR_WRITE_ENABLE_D3D12_COLOR_WRITE_ENABLE_GREEN:
    D3D12_COLOR_WRITE_ENABLE = 2;
pub const D3D12_COLOR_WRITE_ENABLE_D3D12_COLOR_WRITE_ENABLE_BLUE:
    D3D12_COLOR_WRITE_ENABLE = 4;
pub const D3D12_COLOR_WRITE_ENABLE_D3D12_COLOR_WRITE_ENABLE_ALPHA:
    D3D12_COLOR_WRITE_ENABLE = 8;
pub const D3D12_COLOR_WRITE_ENABLE_D3D12_COLOR_WRITE_ENABLE_ALL:
    D3D12_COLOR_WRITE_ENABLE = 15;
pub type D3D12_COLOR_WRITE_ENABLE = ::std::os::raw::c_int;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_CLEAR: D3D12_LOGIC_OP = 0;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_SET: D3D12_LOGIC_OP = 1;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_COPY: D3D12_LOGIC_OP = 2;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_COPY_INVERTED: D3D12_LOGIC_OP = 3;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_NOOP: D3D12_LOGIC_OP = 4;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_INVERT: D3D12_LOGIC_OP = 5;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_AND: D3D12_LOGIC_OP = 6;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_NAND: D3D12_LOGIC_OP = 7;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_OR: D3D12_LOGIC_OP = 8;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_NOR: D3D12_LOGIC_OP = 9;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_XOR: D3D12_LOGIC_OP = 10;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_EQUIV: D3D12_LOGIC_OP = 11;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_AND_REVERSE: D3D12_LOGIC_OP = 12;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_AND_INVERTED: D3D12_LOGIC_OP = 13;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_OR_REVERSE: D3D12_LOGIC_OP = 14;
pub const D3D12_LOGIC_OP_D3D12_LOGIC_OP_OR_INVERTED: D3D12_LOGIC_OP = 15;
pub type D3D12_LOGIC_OP = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RENDER_TARGET_BLEND_DESC {
    pub BlendEnable: BOOL,
    pub LogicOpEnable: BOOL,
    pub SrcBlend: D3D12_BLEND,
    pub DestBlend: D3D12_BLEND,
    pub BlendOp: D3D12_BLEND_OP,
    pub SrcBlendAlpha: D3D12_BLEND,
    pub DestBlendAlpha: D3D12_BLEND,
    pub BlendOpAlpha: D3D12_BLEND_OP,
    pub LogicOp: D3D12_LOGIC_OP,
    pub RenderTargetWriteMask: UINT8,
}
impl Default for D3D12_RENDER_TARGET_BLEND_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_BLEND_DESC {
    pub AlphaToCoverageEnable: BOOL,
    pub IndependentBlendEnable: BOOL,
    pub RenderTarget: [D3D12_RENDER_TARGET_BLEND_DESC; 8usize],
}
impl Default for D3D12_BLEND_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_CONSERVATIVE_RASTERIZATION_MODE_D3D12_CONSERVATIVE_RASTERIZATION_MODE_OFF : D3D12_CONSERVATIVE_RASTERIZATION_MODE = 0 ;
pub const D3D12_CONSERVATIVE_RASTERIZATION_MODE_D3D12_CONSERVATIVE_RASTERIZATION_MODE_ON : D3D12_CONSERVATIVE_RASTERIZATION_MODE = 1 ;
pub type D3D12_CONSERVATIVE_RASTERIZATION_MODE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_RASTERIZER_DESC {
    pub FillMode: D3D12_FILL_MODE,
    pub CullMode: D3D12_CULL_MODE,
    pub FrontCounterClockwise: BOOL,
    pub DepthBias: INT,
    pub DepthBiasClamp: FLOAT,
    pub SlopeScaledDepthBias: FLOAT,
    pub DepthClipEnable: BOOL,
    pub MultisampleEnable: BOOL,
    pub AntialiasedLineEnable: BOOL,
    pub ForcedSampleCount: UINT,
    pub ConservativeRaster: D3D12_CONSERVATIVE_RASTERIZATION_MODE,
}
impl Default for D3D12_RASTERIZER_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Object: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ObjectVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Object,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Object) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Object) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Object,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Object,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Object,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Object, Name: LPCWSTR) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Object {
    pub lpVtbl: *mut ID3D12ObjectVtbl,
}
impl Default for ID3D12Object {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DeviceChild: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceChildVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceChild,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DeviceChild) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DeviceChild) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceChild,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceChild,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceChild,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceChild,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceChild,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceChild {
    pub lpVtbl: *mut ID3D12DeviceChildVtbl,
}
impl Default for ID3D12DeviceChild {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12RootSignature: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12RootSignatureVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignature,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12RootSignature) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12RootSignature) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignature,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignature,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignature,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignature,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignature,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12RootSignature {
    pub lpVtbl: *mut ID3D12RootSignatureVtbl,
}
impl Default for ID3D12RootSignature {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SHADER_BYTECODE {
    pub pShaderBytecode: *const ::std::os::raw::c_void,
    pub BytecodeLength: SIZE_T,
}
impl Default for D3D12_SHADER_BYTECODE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_STREAM_OUTPUT_DESC {
    pub pSODeclaration: *const D3D12_SO_DECLARATION_ENTRY,
    pub NumEntries: UINT,
    pub pBufferStrides: *const UINT,
    pub NumStrides: UINT,
    pub RasterizedStream: UINT,
}
impl Default for D3D12_STREAM_OUTPUT_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INPUT_LAYOUT_DESC {
    pub pInputElementDescs: *const D3D12_INPUT_ELEMENT_DESC,
    pub NumElements: UINT,
}
impl Default for D3D12_INPUT_LAYOUT_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_DISABLED : D3D12_INDEX_BUFFER_STRIP_CUT_VALUE = 0 ;
pub const D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_0xFFFF : D3D12_INDEX_BUFFER_STRIP_CUT_VALUE = 1 ;
pub const D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_0xFFFFFFFF : D3D12_INDEX_BUFFER_STRIP_CUT_VALUE = 2 ;
pub type D3D12_INDEX_BUFFER_STRIP_CUT_VALUE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_CACHED_PIPELINE_STATE {
    pub pCachedBlob: *const ::std::os::raw::c_void,
    pub CachedBlobSizeInBytes: SIZE_T,
}
impl Default for D3D12_CACHED_PIPELINE_STATE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_PIPELINE_STATE_FLAGS_D3D12_PIPELINE_STATE_FLAG_NONE:
    D3D12_PIPELINE_STATE_FLAGS = 0;
pub const D3D12_PIPELINE_STATE_FLAGS_D3D12_PIPELINE_STATE_FLAG_TOOL_DEBUG:
    D3D12_PIPELINE_STATE_FLAGS = 1;
pub type D3D12_PIPELINE_STATE_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_GRAPHICS_PIPELINE_STATE_DESC {
    pub pRootSignature: *mut ID3D12RootSignature,
    pub VS: D3D12_SHADER_BYTECODE,
    pub PS: D3D12_SHADER_BYTECODE,
    pub DS: D3D12_SHADER_BYTECODE,
    pub HS: D3D12_SHADER_BYTECODE,
    pub GS: D3D12_SHADER_BYTECODE,
    pub StreamOutput: D3D12_STREAM_OUTPUT_DESC,
    pub BlendState: D3D12_BLEND_DESC,
    pub SampleMask: UINT,
    pub RasterizerState: D3D12_RASTERIZER_DESC,
    pub DepthStencilState: D3D12_DEPTH_STENCIL_DESC,
    pub InputLayout: D3D12_INPUT_LAYOUT_DESC,
    pub IBStripCutValue: D3D12_INDEX_BUFFER_STRIP_CUT_VALUE,
    pub PrimitiveTopologyType: D3D12_PRIMITIVE_TOPOLOGY_TYPE,
    pub NumRenderTargets: UINT,
    pub RTVFormats: [DXGI_FORMAT; 8usize],
    pub DSVFormat: DXGI_FORMAT,
    pub SampleDesc: DXGI_SAMPLE_DESC,
    pub NodeMask: UINT,
    pub CachedPSO: D3D12_CACHED_PIPELINE_STATE,
    pub Flags: D3D12_PIPELINE_STATE_FLAGS,
}
impl Default for D3D12_GRAPHICS_PIPELINE_STATE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_COMPUTE_PIPELINE_STATE_DESC {
    pub pRootSignature: *mut ID3D12RootSignature,
    pub CS: D3D12_SHADER_BYTECODE,
    pub NodeMask: UINT,
    pub CachedPSO: D3D12_CACHED_PIPELINE_STATE,
    pub Flags: D3D12_PIPELINE_STATE_FLAGS,
}
impl Default for D3D12_COMPUTE_PIPELINE_STATE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RT_FORMAT_ARRAY {
    pub RTFormats: [DXGI_FORMAT; 8usize],
    pub NumRenderTargets: UINT,
}
impl Default for D3D12_RT_FORMAT_ARRAY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_PIPELINE_STATE_STREAM_DESC {
    pub SizeInBytes: SIZE_T,
    pub pPipelineStateSubobjectStream: *mut ::std::os::raw::c_void,
}
impl Default for D3D12_PIPELINE_STATE_STREAM_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_ROOT_SIGNATURE : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 0 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 1 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 2 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 3 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_HS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 4 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_GS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 5 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 6 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_STREAM_OUTPUT : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 7 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_BLEND : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 8 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_MASK : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 9 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RASTERIZER : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 10 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 11 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_INPUT_LAYOUT : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 12 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_IB_STRIP_CUT_VALUE : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 13 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PRIMITIVE_TOPOLOGY : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 14 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RENDER_TARGET_FORMATS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 15 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL_FORMAT : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 16 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_DESC : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 17 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_NODE_MASK : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 18 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CACHED_PSO : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 19 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_FLAGS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 20 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL1 : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 21 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VIEW_INSTANCING : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 22 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_AS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 24 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_MS : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 25 ;
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_MAX_VALID : D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = 26 ;
pub type D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = ::std::os::raw::c_int;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS: D3D12_FEATURE = 0;
pub const D3D12_FEATURE_D3D12_FEATURE_ARCHITECTURE: D3D12_FEATURE = 1;
pub const D3D12_FEATURE_D3D12_FEATURE_FEATURE_LEVELS: D3D12_FEATURE = 2;
pub const D3D12_FEATURE_D3D12_FEATURE_FORMAT_SUPPORT: D3D12_FEATURE = 3;
pub const D3D12_FEATURE_D3D12_FEATURE_MULTISAMPLE_QUALITY_LEVELS:
    D3D12_FEATURE = 4;
pub const D3D12_FEATURE_D3D12_FEATURE_FORMAT_INFO: D3D12_FEATURE = 5;
pub const D3D12_FEATURE_D3D12_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT:
    D3D12_FEATURE = 6;
pub const D3D12_FEATURE_D3D12_FEATURE_SHADER_MODEL: D3D12_FEATURE = 7;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS1: D3D12_FEATURE = 8;
pub const D3D12_FEATURE_D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_SUPPORT:
    D3D12_FEATURE = 10;
pub const D3D12_FEATURE_D3D12_FEATURE_ROOT_SIGNATURE: D3D12_FEATURE = 12;
pub const D3D12_FEATURE_D3D12_FEATURE_ARCHITECTURE1: D3D12_FEATURE = 16;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS2: D3D12_FEATURE = 18;
pub const D3D12_FEATURE_D3D12_FEATURE_SHADER_CACHE: D3D12_FEATURE = 19;
pub const D3D12_FEATURE_D3D12_FEATURE_COMMAND_QUEUE_PRIORITY: D3D12_FEATURE =
    20;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS3: D3D12_FEATURE = 21;
pub const D3D12_FEATURE_D3D12_FEATURE_EXISTING_HEAPS: D3D12_FEATURE = 22;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS4: D3D12_FEATURE = 23;
pub const D3D12_FEATURE_D3D12_FEATURE_SERIALIZATION: D3D12_FEATURE = 24;
pub const D3D12_FEATURE_D3D12_FEATURE_CROSS_NODE: D3D12_FEATURE = 25;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS5: D3D12_FEATURE = 27;
pub const D3D12_FEATURE_D3D12_FEATURE_DISPLAYABLE: D3D12_FEATURE = 28;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS6: D3D12_FEATURE = 30;
pub const D3D12_FEATURE_D3D12_FEATURE_QUERY_META_COMMAND: D3D12_FEATURE = 31;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS7: D3D12_FEATURE = 32;
pub const D3D12_FEATURE_D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_TYPE_COUNT:
    D3D12_FEATURE = 33;
pub const D3D12_FEATURE_D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_TYPES:
    D3D12_FEATURE = 34;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS8: D3D12_FEATURE = 36;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS9: D3D12_FEATURE = 37;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS10: D3D12_FEATURE = 39;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS11: D3D12_FEATURE = 40;
pub const D3D12_FEATURE_D3D12_FEATURE_D3D12_OPTIONS12: D3D12_FEATURE = 41;
pub type D3D12_FEATURE = ::std::os::raw::c_int;
pub const D3D12_SHADER_MIN_PRECISION_SUPPORT_D3D12_SHADER_MIN_PRECISION_SUPPORT_NONE : D3D12_SHADER_MIN_PRECISION_SUPPORT = 0 ;
pub const D3D12_SHADER_MIN_PRECISION_SUPPORT_D3D12_SHADER_MIN_PRECISION_SUPPORT_10_BIT : D3D12_SHADER_MIN_PRECISION_SUPPORT = 1 ;
pub const D3D12_SHADER_MIN_PRECISION_SUPPORT_D3D12_SHADER_MIN_PRECISION_SUPPORT_16_BIT : D3D12_SHADER_MIN_PRECISION_SUPPORT = 2 ;
pub type D3D12_SHADER_MIN_PRECISION_SUPPORT = ::std::os::raw::c_int;
pub const D3D12_TILED_RESOURCES_TIER_D3D12_TILED_RESOURCES_TIER_NOT_SUPPORTED : D3D12_TILED_RESOURCES_TIER = 0 ;
pub const D3D12_TILED_RESOURCES_TIER_D3D12_TILED_RESOURCES_TIER_1:
    D3D12_TILED_RESOURCES_TIER = 1;
pub const D3D12_TILED_RESOURCES_TIER_D3D12_TILED_RESOURCES_TIER_2:
    D3D12_TILED_RESOURCES_TIER = 2;
pub const D3D12_TILED_RESOURCES_TIER_D3D12_TILED_RESOURCES_TIER_3:
    D3D12_TILED_RESOURCES_TIER = 3;
pub const D3D12_TILED_RESOURCES_TIER_D3D12_TILED_RESOURCES_TIER_4:
    D3D12_TILED_RESOURCES_TIER = 4;
pub type D3D12_TILED_RESOURCES_TIER = ::std::os::raw::c_int;
pub const D3D12_RESOURCE_BINDING_TIER_D3D12_RESOURCE_BINDING_TIER_1:
    D3D12_RESOURCE_BINDING_TIER = 1;
pub const D3D12_RESOURCE_BINDING_TIER_D3D12_RESOURCE_BINDING_TIER_2:
    D3D12_RESOURCE_BINDING_TIER = 2;
pub const D3D12_RESOURCE_BINDING_TIER_D3D12_RESOURCE_BINDING_TIER_3:
    D3D12_RESOURCE_BINDING_TIER = 3;
pub type D3D12_RESOURCE_BINDING_TIER = ::std::os::raw::c_int;
pub const D3D12_CONSERVATIVE_RASTERIZATION_TIER_D3D12_CONSERVATIVE_RASTERIZATION_TIER_NOT_SUPPORTED : D3D12_CONSERVATIVE_RASTERIZATION_TIER = 0 ;
pub const D3D12_CONSERVATIVE_RASTERIZATION_TIER_D3D12_CONSERVATIVE_RASTERIZATION_TIER_1 : D3D12_CONSERVATIVE_RASTERIZATION_TIER = 1 ;
pub const D3D12_CONSERVATIVE_RASTERIZATION_TIER_D3D12_CONSERVATIVE_RASTERIZATION_TIER_2 : D3D12_CONSERVATIVE_RASTERIZATION_TIER = 2 ;
pub const D3D12_CONSERVATIVE_RASTERIZATION_TIER_D3D12_CONSERVATIVE_RASTERIZATION_TIER_3 : D3D12_CONSERVATIVE_RASTERIZATION_TIER = 3 ;
pub type D3D12_CONSERVATIVE_RASTERIZATION_TIER = ::std::os::raw::c_int;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_NONE:
    D3D12_FORMAT_SUPPORT1 = 0;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_BUFFER:
    D3D12_FORMAT_SUPPORT1 = 1;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_IA_VERTEX_BUFFER:
    D3D12_FORMAT_SUPPORT1 = 2;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_IA_INDEX_BUFFER:
    D3D12_FORMAT_SUPPORT1 = 4;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_SO_BUFFER:
    D3D12_FORMAT_SUPPORT1 = 8;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_TEXTURE1D:
    D3D12_FORMAT_SUPPORT1 = 16;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_TEXTURE2D:
    D3D12_FORMAT_SUPPORT1 = 32;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_TEXTURE3D:
    D3D12_FORMAT_SUPPORT1 = 64;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_TEXTURECUBE:
    D3D12_FORMAT_SUPPORT1 = 128;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_SHADER_LOAD:
    D3D12_FORMAT_SUPPORT1 = 256;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE:
    D3D12_FORMAT_SUPPORT1 = 512;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE_COMPARISON : D3D12_FORMAT_SUPPORT1 = 1024 ;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE_MONO_TEXT : D3D12_FORMAT_SUPPORT1 = 2048 ;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_MIP:
    D3D12_FORMAT_SUPPORT1 = 4096;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_RENDER_TARGET:
    D3D12_FORMAT_SUPPORT1 = 16384;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_BLENDABLE:
    D3D12_FORMAT_SUPPORT1 = 32768;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_DEPTH_STENCIL:
    D3D12_FORMAT_SUPPORT1 = 65536;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_MULTISAMPLE_RESOLVE:
    D3D12_FORMAT_SUPPORT1 = 262144;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_DISPLAY:
    D3D12_FORMAT_SUPPORT1 = 524288;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_CAST_WITHIN_BIT_LAYOUT:
    D3D12_FORMAT_SUPPORT1 = 1048576;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_MULTISAMPLE_RENDERTARGET : D3D12_FORMAT_SUPPORT1 = 2097152 ;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_MULTISAMPLE_LOAD:
    D3D12_FORMAT_SUPPORT1 = 4194304;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_SHADER_GATHER:
    D3D12_FORMAT_SUPPORT1 = 8388608;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_BACK_BUFFER_CAST:
    D3D12_FORMAT_SUPPORT1 = 16777216;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_TYPED_UNORDERED_ACCESS_VIEW : D3D12_FORMAT_SUPPORT1 = 33554432 ;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_SHADER_GATHER_COMPARISON : D3D12_FORMAT_SUPPORT1 = 67108864 ;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_DECODER_OUTPUT:
    D3D12_FORMAT_SUPPORT1 = 134217728;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_VIDEO_PROCESSOR_OUTPUT:
    D3D12_FORMAT_SUPPORT1 = 268435456;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_VIDEO_PROCESSOR_INPUT:
    D3D12_FORMAT_SUPPORT1 = 536870912;
pub const D3D12_FORMAT_SUPPORT1_D3D12_FORMAT_SUPPORT1_VIDEO_ENCODER:
    D3D12_FORMAT_SUPPORT1 = 1073741824;
pub type D3D12_FORMAT_SUPPORT1 = ::std::os::raw::c_int;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_NONE:
    D3D12_FORMAT_SUPPORT2 = 0;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_ADD:
    D3D12_FORMAT_SUPPORT2 = 1;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS:
    D3D12_FORMAT_SUPPORT2 = 2;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE : D3D12_FORMAT_SUPPORT2 = 4 ;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE:
    D3D12_FORMAT_SUPPORT2 = 8;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX : D3D12_FORMAT_SUPPORT2 = 16 ;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX : D3D12_FORMAT_SUPPORT2 = 32 ;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_UAV_TYPED_LOAD:
    D3D12_FORMAT_SUPPORT2 = 64;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_UAV_TYPED_STORE:
    D3D12_FORMAT_SUPPORT2 = 128;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_OUTPUT_MERGER_LOGIC_OP:
    D3D12_FORMAT_SUPPORT2 = 256;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_TILED:
    D3D12_FORMAT_SUPPORT2 = 512;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_MULTIPLANE_OVERLAY:
    D3D12_FORMAT_SUPPORT2 = 16384;
pub const D3D12_FORMAT_SUPPORT2_D3D12_FORMAT_SUPPORT2_SAMPLER_FEEDBACK:
    D3D12_FORMAT_SUPPORT2 = 32768;
pub type D3D12_FORMAT_SUPPORT2 = ::std::os::raw::c_int;
pub const D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS_D3D12_MULTISAMPLE_QUALITY_LEVELS_FLAG_NONE : D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS = 0 ;
pub const D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS_D3D12_MULTISAMPLE_QUALITY_LEVELS_FLAG_TILED_RESOURCE : D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS = 1 ;
pub type D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS = ::std::os::raw::c_int;
pub const D3D12_CROSS_NODE_SHARING_TIER_D3D12_CROSS_NODE_SHARING_TIER_NOT_SUPPORTED : D3D12_CROSS_NODE_SHARING_TIER = 0 ;
pub const D3D12_CROSS_NODE_SHARING_TIER_D3D12_CROSS_NODE_SHARING_TIER_1_EMULATED : D3D12_CROSS_NODE_SHARING_TIER = 1 ;
pub const D3D12_CROSS_NODE_SHARING_TIER_D3D12_CROSS_NODE_SHARING_TIER_1:
    D3D12_CROSS_NODE_SHARING_TIER = 2;
pub const D3D12_CROSS_NODE_SHARING_TIER_D3D12_CROSS_NODE_SHARING_TIER_2:
    D3D12_CROSS_NODE_SHARING_TIER = 3;
pub const D3D12_CROSS_NODE_SHARING_TIER_D3D12_CROSS_NODE_SHARING_TIER_3:
    D3D12_CROSS_NODE_SHARING_TIER = 4;
pub type D3D12_CROSS_NODE_SHARING_TIER = ::std::os::raw::c_int;
pub const D3D12_RESOURCE_HEAP_TIER_D3D12_RESOURCE_HEAP_TIER_1:
    D3D12_RESOURCE_HEAP_TIER = 1;
pub const D3D12_RESOURCE_HEAP_TIER_D3D12_RESOURCE_HEAP_TIER_2:
    D3D12_RESOURCE_HEAP_TIER = 2;
pub type D3D12_RESOURCE_HEAP_TIER = ::std::os::raw::c_int;
pub const D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_NOT_SUPPORTED : D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER = 0 ;
pub const D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_1 : D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER = 1 ;
pub const D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_2 : D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER = 2 ;
pub type D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER = ::std::os::raw::c_int;
pub const D3D12_VIEW_INSTANCING_TIER_D3D12_VIEW_INSTANCING_TIER_NOT_SUPPORTED : D3D12_VIEW_INSTANCING_TIER = 0 ;
pub const D3D12_VIEW_INSTANCING_TIER_D3D12_VIEW_INSTANCING_TIER_1:
    D3D12_VIEW_INSTANCING_TIER = 1;
pub const D3D12_VIEW_INSTANCING_TIER_D3D12_VIEW_INSTANCING_TIER_2:
    D3D12_VIEW_INSTANCING_TIER = 2;
pub const D3D12_VIEW_INSTANCING_TIER_D3D12_VIEW_INSTANCING_TIER_3:
    D3D12_VIEW_INSTANCING_TIER = 3;
pub type D3D12_VIEW_INSTANCING_TIER = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS {
    pub DoublePrecisionFloatShaderOps: BOOL,
    pub OutputMergerLogicOp: BOOL,
    pub MinPrecisionSupport: D3D12_SHADER_MIN_PRECISION_SUPPORT,
    pub TiledResourcesTier: D3D12_TILED_RESOURCES_TIER,
    pub ResourceBindingTier: D3D12_RESOURCE_BINDING_TIER,
    pub PSSpecifiedStencilRefSupported: BOOL,
    pub TypedUAVLoadAdditionalFormats: BOOL,
    pub ROVsSupported: BOOL,
    pub ConservativeRasterizationTier: D3D12_CONSERVATIVE_RASTERIZATION_TIER,
    pub MaxGPUVirtualAddressBitsPerResource: UINT,
    pub StandardSwizzle64KBSupported: BOOL,
    pub CrossNodeSharingTier: D3D12_CROSS_NODE_SHARING_TIER,
    pub CrossAdapterRowMajorTextureSupported: BOOL,
    pub VPAndRTArrayIndexFromAnyShaderFeedingRasterizerSupportedWithoutGSEmulation:
        BOOL,
    pub ResourceHeapTier: D3D12_RESOURCE_HEAP_TIER,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS1 {
    pub WaveOps: BOOL,
    pub WaveLaneCountMin: UINT,
    pub WaveLaneCountMax: UINT,
    pub TotalLaneCount: UINT,
    pub ExpandedComputeResourceStates: BOOL,
    pub Int64ShaderOps: BOOL,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS2 {
    pub DepthBoundsTestSupported: BOOL,
    pub ProgrammableSamplePositionsTier:
        D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D_ROOT_SIGNATURE_VERSION_D3D_ROOT_SIGNATURE_VERSION_1:
    D3D_ROOT_SIGNATURE_VERSION = 1;
pub const D3D_ROOT_SIGNATURE_VERSION_D3D_ROOT_SIGNATURE_VERSION_1_0:
    D3D_ROOT_SIGNATURE_VERSION = 1;
pub const D3D_ROOT_SIGNATURE_VERSION_D3D_ROOT_SIGNATURE_VERSION_1_1:
    D3D_ROOT_SIGNATURE_VERSION = 2;
pub type D3D_ROOT_SIGNATURE_VERSION = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_ROOT_SIGNATURE {
    pub HighestVersion: D3D_ROOT_SIGNATURE_VERSION,
}
impl Default for D3D12_FEATURE_DATA_ROOT_SIGNATURE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_ARCHITECTURE {
    pub NodeIndex: UINT,
    pub TileBasedRenderer: BOOL,
    pub UMA: BOOL,
    pub CacheCoherentUMA: BOOL,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_ARCHITECTURE1 {
    pub NodeIndex: UINT,
    pub TileBasedRenderer: BOOL,
    pub UMA: BOOL,
    pub CacheCoherentUMA: BOOL,
    pub IsolatedMMU: BOOL,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_FEATURE_LEVELS {
    pub NumFeatureLevels: UINT,
    pub pFeatureLevelsRequested: *const D3D_FEATURE_LEVEL,
    pub MaxSupportedFeatureLevel: D3D_FEATURE_LEVEL,
}
impl Default for D3D12_FEATURE_DATA_FEATURE_LEVELS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_5_1: D3D_SHADER_MODEL = 81;
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_6_0: D3D_SHADER_MODEL = 96;
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_6_1: D3D_SHADER_MODEL = 97;
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_6_2: D3D_SHADER_MODEL = 98;
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_6_3: D3D_SHADER_MODEL = 99;
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_6_4: D3D_SHADER_MODEL = 100;
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_6_5: D3D_SHADER_MODEL = 101;
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_6_6: D3D_SHADER_MODEL = 102;
pub const D3D_SHADER_MODEL_D3D_SHADER_MODEL_6_7: D3D_SHADER_MODEL = 103;
pub const D3D_SHADER_MODEL_D3D_HIGHEST_SHADER_MODEL: D3D_SHADER_MODEL = 103;
pub type D3D_SHADER_MODEL = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_SHADER_MODEL {
    pub HighestShaderModel: D3D_SHADER_MODEL,
}
impl Default for D3D12_FEATURE_DATA_SHADER_MODEL {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_FORMAT_SUPPORT {
    pub Format: DXGI_FORMAT,
    pub Support1: D3D12_FORMAT_SUPPORT1,
    pub Support2: D3D12_FORMAT_SUPPORT2,
}
impl Default for D3D12_FEATURE_DATA_FORMAT_SUPPORT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {
    pub Format: DXGI_FORMAT,
    pub SampleCount: UINT,
    pub Flags: D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS,
    pub NumQualityLevels: UINT,
}
impl Default for D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_FORMAT_INFO {
    pub Format: DXGI_FORMAT,
    pub PlaneCount: UINT8,
}
impl Default for D3D12_FEATURE_DATA_FORMAT_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    pub MaxGPUVirtualAddressBitsPerResource: UINT,
    pub MaxGPUVirtualAddressBitsPerProcess: UINT,
}
pub const D3D12_SHADER_CACHE_SUPPORT_FLAGS_D3D12_SHADER_CACHE_SUPPORT_NONE:
    D3D12_SHADER_CACHE_SUPPORT_FLAGS = 0;
pub const D3D12_SHADER_CACHE_SUPPORT_FLAGS_D3D12_SHADER_CACHE_SUPPORT_SINGLE_PSO : D3D12_SHADER_CACHE_SUPPORT_FLAGS = 1 ;
pub const D3D12_SHADER_CACHE_SUPPORT_FLAGS_D3D12_SHADER_CACHE_SUPPORT_LIBRARY : D3D12_SHADER_CACHE_SUPPORT_FLAGS = 2 ;
pub const D3D12_SHADER_CACHE_SUPPORT_FLAGS_D3D12_SHADER_CACHE_SUPPORT_AUTOMATIC_INPROC_CACHE : D3D12_SHADER_CACHE_SUPPORT_FLAGS = 4 ;
pub const D3D12_SHADER_CACHE_SUPPORT_FLAGS_D3D12_SHADER_CACHE_SUPPORT_AUTOMATIC_DISK_CACHE : D3D12_SHADER_CACHE_SUPPORT_FLAGS = 8 ;
pub const D3D12_SHADER_CACHE_SUPPORT_FLAGS_D3D12_SHADER_CACHE_SUPPORT_DRIVER_MANAGED_CACHE : D3D12_SHADER_CACHE_SUPPORT_FLAGS = 16 ;
pub const D3D12_SHADER_CACHE_SUPPORT_FLAGS_D3D12_SHADER_CACHE_SUPPORT_SHADER_CONTROL_CLEAR : D3D12_SHADER_CACHE_SUPPORT_FLAGS = 32 ;
pub const D3D12_SHADER_CACHE_SUPPORT_FLAGS_D3D12_SHADER_CACHE_SUPPORT_SHADER_SESSION_DELETE : D3D12_SHADER_CACHE_SUPPORT_FLAGS = 64 ;
pub type D3D12_SHADER_CACHE_SUPPORT_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_SHADER_CACHE {
    pub SupportFlags: D3D12_SHADER_CACHE_SUPPORT_FLAGS,
}
impl Default for D3D12_FEATURE_DATA_SHADER_CACHE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {
    pub CommandListType: D3D12_COMMAND_LIST_TYPE,
    pub Priority: UINT,
    pub PriorityForTypeIsSupported: BOOL,
}
impl Default for D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_COMMAND_LIST_SUPPORT_FLAGS_D3D12_COMMAND_LIST_SUPPORT_FLAG_NONE : D3D12_COMMAND_LIST_SUPPORT_FLAGS = 0 ;
pub const D3D12_COMMAND_LIST_SUPPORT_FLAGS_D3D12_COMMAND_LIST_SUPPORT_FLAG_DIRECT : D3D12_COMMAND_LIST_SUPPORT_FLAGS = 1 ;
pub const D3D12_COMMAND_LIST_SUPPORT_FLAGS_D3D12_COMMAND_LIST_SUPPORT_FLAG_BUNDLE : D3D12_COMMAND_LIST_SUPPORT_FLAGS = 2 ;
pub const D3D12_COMMAND_LIST_SUPPORT_FLAGS_D3D12_COMMAND_LIST_SUPPORT_FLAG_COMPUTE : D3D12_COMMAND_LIST_SUPPORT_FLAGS = 4 ;
pub const D3D12_COMMAND_LIST_SUPPORT_FLAGS_D3D12_COMMAND_LIST_SUPPORT_FLAG_COPY : D3D12_COMMAND_LIST_SUPPORT_FLAGS = 8 ;
pub const D3D12_COMMAND_LIST_SUPPORT_FLAGS_D3D12_COMMAND_LIST_SUPPORT_FLAG_VIDEO_DECODE : D3D12_COMMAND_LIST_SUPPORT_FLAGS = 16 ;
pub const D3D12_COMMAND_LIST_SUPPORT_FLAGS_D3D12_COMMAND_LIST_SUPPORT_FLAG_VIDEO_PROCESS : D3D12_COMMAND_LIST_SUPPORT_FLAGS = 32 ;
pub const D3D12_COMMAND_LIST_SUPPORT_FLAGS_D3D12_COMMAND_LIST_SUPPORT_FLAG_VIDEO_ENCODE : D3D12_COMMAND_LIST_SUPPORT_FLAGS = 64 ;
pub type D3D12_COMMAND_LIST_SUPPORT_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS3 {
    pub CopyQueueTimestampQueriesSupported: BOOL,
    pub CastingFullyTypedFormatSupported: BOOL,
    pub WriteBufferImmediateSupportFlags: D3D12_COMMAND_LIST_SUPPORT_FLAGS,
    pub ViewInstancingTier: D3D12_VIEW_INSTANCING_TIER,
    pub BarycentricsSupported: BOOL,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_EXISTING_HEAPS {
    pub Supported: BOOL,
}
pub const D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_0 : D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER = 0 ;
pub const D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_1 : D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER = 1 ;
pub const D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_2 : D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER = 2 ;
pub type D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_DISPLAYABLE {
    pub DisplayableTexture: BOOL,
    pub SharedResourceCompatibilityTier:
        D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER,
}
impl Default for D3D12_FEATURE_DATA_DISPLAYABLE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS4 {
    pub MSAA64KBAlignedTextureSupported: BOOL,
    pub SharedResourceCompatibilityTier:
        D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER,
    pub Native16BitShaderOpsSupported: BOOL,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_HEAP_SERIALIZATION_TIER_D3D12_HEAP_SERIALIZATION_TIER_0:
    D3D12_HEAP_SERIALIZATION_TIER = 0;
pub const D3D12_HEAP_SERIALIZATION_TIER_D3D12_HEAP_SERIALIZATION_TIER_10:
    D3D12_HEAP_SERIALIZATION_TIER = 10;
pub type D3D12_HEAP_SERIALIZATION_TIER = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_SERIALIZATION {
    pub NodeIndex: UINT,
    pub HeapSerializationTier: D3D12_HEAP_SERIALIZATION_TIER,
}
impl Default for D3D12_FEATURE_DATA_SERIALIZATION {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_CROSS_NODE {
    pub SharingTier: D3D12_CROSS_NODE_SHARING_TIER,
    pub AtomicShaderInstructions: BOOL,
}
impl Default for D3D12_FEATURE_DATA_CROSS_NODE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_RENDER_PASS_TIER_D3D12_RENDER_PASS_TIER_0:
    D3D12_RENDER_PASS_TIER = 0;
pub const D3D12_RENDER_PASS_TIER_D3D12_RENDER_PASS_TIER_1:
    D3D12_RENDER_PASS_TIER = 1;
pub const D3D12_RENDER_PASS_TIER_D3D12_RENDER_PASS_TIER_2:
    D3D12_RENDER_PASS_TIER = 2;
pub type D3D12_RENDER_PASS_TIER = ::std::os::raw::c_int;
pub const D3D12_RAYTRACING_TIER_D3D12_RAYTRACING_TIER_NOT_SUPPORTED:
    D3D12_RAYTRACING_TIER = 0;
pub const D3D12_RAYTRACING_TIER_D3D12_RAYTRACING_TIER_1_0:
    D3D12_RAYTRACING_TIER = 10;
pub const D3D12_RAYTRACING_TIER_D3D12_RAYTRACING_TIER_1_1:
    D3D12_RAYTRACING_TIER = 11;
pub type D3D12_RAYTRACING_TIER = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS5 {
    pub SRVOnlyTiledResourceTier3: BOOL,
    pub RenderPassesTier: D3D12_RENDER_PASS_TIER,
    pub RaytracingTier: D3D12_RAYTRACING_TIER,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_VARIABLE_SHADING_RATE_TIER_D3D12_VARIABLE_SHADING_RATE_TIER_NOT_SUPPORTED : D3D12_VARIABLE_SHADING_RATE_TIER = 0 ;
pub const D3D12_VARIABLE_SHADING_RATE_TIER_D3D12_VARIABLE_SHADING_RATE_TIER_1 : D3D12_VARIABLE_SHADING_RATE_TIER = 1 ;
pub const D3D12_VARIABLE_SHADING_RATE_TIER_D3D12_VARIABLE_SHADING_RATE_TIER_2 : D3D12_VARIABLE_SHADING_RATE_TIER = 2 ;
pub type D3D12_VARIABLE_SHADING_RATE_TIER = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS6 {
    pub AdditionalShadingRatesSupported: BOOL,
    pub PerPrimitiveShadingRateSupportedWithViewportIndexing: BOOL,
    pub VariableShadingRateTier: D3D12_VARIABLE_SHADING_RATE_TIER,
    pub ShadingRateImageTileSize: UINT,
    pub BackgroundProcessingSupported: BOOL,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_MESH_SHADER_TIER_D3D12_MESH_SHADER_TIER_NOT_SUPPORTED:
    D3D12_MESH_SHADER_TIER = 0;
pub const D3D12_MESH_SHADER_TIER_D3D12_MESH_SHADER_TIER_1:
    D3D12_MESH_SHADER_TIER = 10;
pub type D3D12_MESH_SHADER_TIER = ::std::os::raw::c_int;
pub const D3D12_SAMPLER_FEEDBACK_TIER_D3D12_SAMPLER_FEEDBACK_TIER_NOT_SUPPORTED : D3D12_SAMPLER_FEEDBACK_TIER = 0 ;
pub const D3D12_SAMPLER_FEEDBACK_TIER_D3D12_SAMPLER_FEEDBACK_TIER_0_9:
    D3D12_SAMPLER_FEEDBACK_TIER = 90;
pub const D3D12_SAMPLER_FEEDBACK_TIER_D3D12_SAMPLER_FEEDBACK_TIER_1_0:
    D3D12_SAMPLER_FEEDBACK_TIER = 100;
pub type D3D12_SAMPLER_FEEDBACK_TIER = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS7 {
    pub MeshShaderTier: D3D12_MESH_SHADER_TIER,
    pub SamplerFeedbackTier: D3D12_SAMPLER_FEEDBACK_TIER,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS7 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_QUERY_META_COMMAND {
    pub CommandId: GUID,
    pub NodeMask: UINT,
    pub pQueryInputData: *const ::std::os::raw::c_void,
    pub QueryInputDataSizeInBytes: SIZE_T,
    pub pQueryOutputData: *mut ::std::os::raw::c_void,
    pub QueryOutputDataSizeInBytes: SIZE_T,
}
impl Default for D3D12_FEATURE_DATA_QUERY_META_COMMAND {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS8 {
    pub UnalignedBlockTexturesSupported: BOOL,
}
pub const D3D12_WAVE_MMA_TIER_D3D12_WAVE_MMA_TIER_NOT_SUPPORTED:
    D3D12_WAVE_MMA_TIER = 0;
pub const D3D12_WAVE_MMA_TIER_D3D12_WAVE_MMA_TIER_1_0: D3D12_WAVE_MMA_TIER = 10;
pub type D3D12_WAVE_MMA_TIER = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS9 {
    pub MeshShaderPipelineStatsSupported: BOOL,
    pub MeshShaderSupportsFullRangeRenderTargetArrayIndex: BOOL,
    pub AtomicInt64OnTypedResourceSupported: BOOL,
    pub AtomicInt64OnGroupSharedSupported: BOOL,
    pub DerivativesInMeshAndAmplificationShadersSupported: BOOL,
    pub WaveMMATier: D3D12_WAVE_MMA_TIER,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS9 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS10 {
    pub VariableRateShadingSumCombinerSupported: BOOL,
    pub MeshShaderPerPrimitiveShadingRateSupported: BOOL,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS11 {
    pub AtomicInt64OnDescriptorHeapResourceSupported: BOOL,
}
pub const D3D12_TRI_STATE_D3D12_TRI_STATE_UNKNOWN: D3D12_TRI_STATE = -1;
pub const D3D12_TRI_STATE_D3D12_TRI_STATE_FALSE: D3D12_TRI_STATE = 0;
pub const D3D12_TRI_STATE_D3D12_TRI_STATE_TRUE: D3D12_TRI_STATE = 1;
pub type D3D12_TRI_STATE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS12 {
    pub MSPrimitivesPipelineStatisticIncludesCulledPrimitives: D3D12_TRI_STATE,
    pub EnhancedBarriersSupported: BOOL,
    pub RelaxedFormatCastingSupported: BOOL,
}
impl Default for D3D12_FEATURE_DATA_D3D12_OPTIONS12 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RESOURCE_ALLOCATION_INFO {
    pub SizeInBytes: UINT64,
    pub Alignment: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RESOURCE_ALLOCATION_INFO1 {
    pub Offset: UINT64,
    pub Alignment: UINT64,
    pub SizeInBytes: UINT64,
}
pub const D3D12_HEAP_TYPE_D3D12_HEAP_TYPE_DEFAULT: D3D12_HEAP_TYPE = 1;
pub const D3D12_HEAP_TYPE_D3D12_HEAP_TYPE_UPLOAD: D3D12_HEAP_TYPE = 2;
pub const D3D12_HEAP_TYPE_D3D12_HEAP_TYPE_READBACK: D3D12_HEAP_TYPE = 3;
pub const D3D12_HEAP_TYPE_D3D12_HEAP_TYPE_CUSTOM: D3D12_HEAP_TYPE = 4;
pub type D3D12_HEAP_TYPE = ::std::os::raw::c_int;
pub const D3D12_CPU_PAGE_PROPERTY_D3D12_CPU_PAGE_PROPERTY_UNKNOWN:
    D3D12_CPU_PAGE_PROPERTY = 0;
pub const D3D12_CPU_PAGE_PROPERTY_D3D12_CPU_PAGE_PROPERTY_NOT_AVAILABLE:
    D3D12_CPU_PAGE_PROPERTY = 1;
pub const D3D12_CPU_PAGE_PROPERTY_D3D12_CPU_PAGE_PROPERTY_WRITE_COMBINE:
    D3D12_CPU_PAGE_PROPERTY = 2;
pub const D3D12_CPU_PAGE_PROPERTY_D3D12_CPU_PAGE_PROPERTY_WRITE_BACK:
    D3D12_CPU_PAGE_PROPERTY = 3;
pub type D3D12_CPU_PAGE_PROPERTY = ::std::os::raw::c_int;
pub const D3D12_MEMORY_POOL_D3D12_MEMORY_POOL_UNKNOWN: D3D12_MEMORY_POOL = 0;
pub const D3D12_MEMORY_POOL_D3D12_MEMORY_POOL_L0: D3D12_MEMORY_POOL = 1;
pub const D3D12_MEMORY_POOL_D3D12_MEMORY_POOL_L1: D3D12_MEMORY_POOL = 2;
pub type D3D12_MEMORY_POOL = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_HEAP_PROPERTIES {
    pub Type: D3D12_HEAP_TYPE,
    pub CPUPageProperty: D3D12_CPU_PAGE_PROPERTY,
    pub MemoryPoolPreference: D3D12_MEMORY_POOL,
    pub CreationNodeMask: UINT,
    pub VisibleNodeMask: UINT,
}
impl Default for D3D12_HEAP_PROPERTIES {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_NONE: D3D12_HEAP_FLAGS = 0;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_SHARED: D3D12_HEAP_FLAGS = 1;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_DENY_BUFFERS: D3D12_HEAP_FLAGS = 4;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_ALLOW_DISPLAY: D3D12_HEAP_FLAGS = 8;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_SHARED_CROSS_ADAPTER:
    D3D12_HEAP_FLAGS = 32;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_DENY_RT_DS_TEXTURES:
    D3D12_HEAP_FLAGS = 64;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_DENY_NON_RT_DS_TEXTURES:
    D3D12_HEAP_FLAGS = 128;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_HARDWARE_PROTECTED:
    D3D12_HEAP_FLAGS = 256;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_ALLOW_WRITE_WATCH: D3D12_HEAP_FLAGS =
    512;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_ALLOW_SHADER_ATOMICS:
    D3D12_HEAP_FLAGS = 1024;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_CREATE_NOT_RESIDENT:
    D3D12_HEAP_FLAGS = 2048;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_CREATE_NOT_ZEROED: D3D12_HEAP_FLAGS =
    4096;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_ALLOW_ALL_BUFFERS_AND_TEXTURES:
    D3D12_HEAP_FLAGS = 0;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_ALLOW_ONLY_BUFFERS:
    D3D12_HEAP_FLAGS = 192;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_ALLOW_ONLY_NON_RT_DS_TEXTURES:
    D3D12_HEAP_FLAGS = 68;
pub const D3D12_HEAP_FLAGS_D3D12_HEAP_FLAG_ALLOW_ONLY_RT_DS_TEXTURES:
    D3D12_HEAP_FLAGS = 132;
pub type D3D12_HEAP_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_HEAP_DESC {
    pub SizeInBytes: UINT64,
    pub Properties: D3D12_HEAP_PROPERTIES,
    pub Alignment: UINT64,
    pub Flags: D3D12_HEAP_FLAGS,
}
impl Default for D3D12_HEAP_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_RESOURCE_DIMENSION_D3D12_RESOURCE_DIMENSION_UNKNOWN:
    D3D12_RESOURCE_DIMENSION = 0;
pub const D3D12_RESOURCE_DIMENSION_D3D12_RESOURCE_DIMENSION_BUFFER:
    D3D12_RESOURCE_DIMENSION = 1;
pub const D3D12_RESOURCE_DIMENSION_D3D12_RESOURCE_DIMENSION_TEXTURE1D:
    D3D12_RESOURCE_DIMENSION = 2;
pub const D3D12_RESOURCE_DIMENSION_D3D12_RESOURCE_DIMENSION_TEXTURE2D:
    D3D12_RESOURCE_DIMENSION = 3;
pub const D3D12_RESOURCE_DIMENSION_D3D12_RESOURCE_DIMENSION_TEXTURE3D:
    D3D12_RESOURCE_DIMENSION = 4;
pub type D3D12_RESOURCE_DIMENSION = ::std::os::raw::c_int;
pub const D3D12_TEXTURE_LAYOUT_D3D12_TEXTURE_LAYOUT_UNKNOWN:
    D3D12_TEXTURE_LAYOUT = 0;
pub const D3D12_TEXTURE_LAYOUT_D3D12_TEXTURE_LAYOUT_ROW_MAJOR:
    D3D12_TEXTURE_LAYOUT = 1;
pub const D3D12_TEXTURE_LAYOUT_D3D12_TEXTURE_LAYOUT_64KB_UNDEFINED_SWIZZLE:
    D3D12_TEXTURE_LAYOUT = 2;
pub const D3D12_TEXTURE_LAYOUT_D3D12_TEXTURE_LAYOUT_64KB_STANDARD_SWIZZLE:
    D3D12_TEXTURE_LAYOUT = 3;
pub type D3D12_TEXTURE_LAYOUT = ::std::os::raw::c_int;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_NONE: D3D12_RESOURCE_FLAGS =
    0;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_ALLOW_RENDER_TARGET:
    D3D12_RESOURCE_FLAGS = 1;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_ALLOW_DEPTH_STENCIL:
    D3D12_RESOURCE_FLAGS = 2;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS:
    D3D12_RESOURCE_FLAGS = 4;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_DENY_SHADER_RESOURCE:
    D3D12_RESOURCE_FLAGS = 8;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_ALLOW_CROSS_ADAPTER:
    D3D12_RESOURCE_FLAGS = 16;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_ALLOW_SIMULTANEOUS_ACCESS:
    D3D12_RESOURCE_FLAGS = 32;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_VIDEO_DECODE_REFERENCE_ONLY : D3D12_RESOURCE_FLAGS = 64 ;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_VIDEO_ENCODE_REFERENCE_ONLY : D3D12_RESOURCE_FLAGS = 128 ;
pub const D3D12_RESOURCE_FLAGS_D3D12_RESOURCE_FLAG_RAYTRACING_ACCELERATION_STRUCTURE : D3D12_RESOURCE_FLAGS = 256 ;
pub type D3D12_RESOURCE_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_MIP_REGION {
    pub Width: UINT,
    pub Height: UINT,
    pub Depth: UINT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RESOURCE_DESC {
    pub Dimension: D3D12_RESOURCE_DIMENSION,
    pub Alignment: UINT64,
    pub Width: UINT64,
    pub Height: UINT,
    pub DepthOrArraySize: UINT16,
    pub MipLevels: UINT16,
    pub Format: DXGI_FORMAT,
    pub SampleDesc: DXGI_SAMPLE_DESC,
    pub Layout: D3D12_TEXTURE_LAYOUT,
    pub Flags: D3D12_RESOURCE_FLAGS,
}
impl Default for D3D12_RESOURCE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RESOURCE_DESC1 {
    pub Dimension: D3D12_RESOURCE_DIMENSION,
    pub Alignment: UINT64,
    pub Width: UINT64,
    pub Height: UINT,
    pub DepthOrArraySize: UINT16,
    pub MipLevels: UINT16,
    pub Format: DXGI_FORMAT,
    pub SampleDesc: DXGI_SAMPLE_DESC,
    pub Layout: D3D12_TEXTURE_LAYOUT,
    pub Flags: D3D12_RESOURCE_FLAGS,
    pub SamplerFeedbackMipRegion: D3D12_MIP_REGION,
}
impl Default for D3D12_RESOURCE_DESC1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_DEPTH_STENCIL_VALUE {
    pub Depth: FLOAT,
    pub Stencil: UINT8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_CLEAR_VALUE {
    pub Format: DXGI_FORMAT,
    pub __bindgen_anon_1: D3D12_CLEAR_VALUE__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_CLEAR_VALUE__bindgen_ty_1 {
    pub Color: [FLOAT; 4usize],
    pub DepthStencil: D3D12_DEPTH_STENCIL_VALUE,
}
impl Default for D3D12_CLEAR_VALUE__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_CLEAR_VALUE__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_CLEAR_VALUE__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_CLEAR_VALUE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_CLEAR_VALUE {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "D3D12_CLEAR_VALUE {{ Format: {:?}, __bindgen_anon_1: {:?} }}",
            self.Format, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RANGE {
    pub Begin: SIZE_T,
    pub End: SIZE_T,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RANGE_UINT64 {
    pub Begin: UINT64,
    pub End: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SUBRESOURCE_RANGE_UINT64 {
    pub Subresource: UINT,
    pub Range: D3D12_RANGE_UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SUBRESOURCE_INFO {
    pub Offset: UINT64,
    pub RowPitch: UINT,
    pub DepthPitch: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TILED_RESOURCE_COORDINATE {
    pub X: UINT,
    pub Y: UINT,
    pub Z: UINT,
    pub Subresource: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TILE_REGION_SIZE {
    pub NumTiles: UINT,
    pub UseBox: BOOL,
    pub Width: UINT,
    pub Height: UINT16,
    pub Depth: UINT16,
}
pub const D3D12_TILE_RANGE_FLAGS_D3D12_TILE_RANGE_FLAG_NONE:
    D3D12_TILE_RANGE_FLAGS = 0;
pub const D3D12_TILE_RANGE_FLAGS_D3D12_TILE_RANGE_FLAG_NULL:
    D3D12_TILE_RANGE_FLAGS = 1;
pub const D3D12_TILE_RANGE_FLAGS_D3D12_TILE_RANGE_FLAG_SKIP:
    D3D12_TILE_RANGE_FLAGS = 2;
pub const D3D12_TILE_RANGE_FLAGS_D3D12_TILE_RANGE_FLAG_REUSE_SINGLE_TILE:
    D3D12_TILE_RANGE_FLAGS = 4;
pub type D3D12_TILE_RANGE_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SUBRESOURCE_TILING {
    pub WidthInTiles: UINT,
    pub HeightInTiles: UINT16,
    pub DepthInTiles: UINT16,
    pub StartTileIndexInOverallResource: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TILE_SHAPE {
    pub WidthInTexels: UINT,
    pub HeightInTexels: UINT,
    pub DepthInTexels: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_PACKED_MIP_INFO {
    pub NumStandardMips: UINT8,
    pub NumPackedMips: UINT8,
    pub NumTilesForPackedMips: UINT,
    pub StartTileIndexInOverallResource: UINT,
}
pub const D3D12_TILE_MAPPING_FLAGS_D3D12_TILE_MAPPING_FLAG_NONE:
    D3D12_TILE_MAPPING_FLAGS = 0;
pub const D3D12_TILE_MAPPING_FLAGS_D3D12_TILE_MAPPING_FLAG_NO_HAZARD:
    D3D12_TILE_MAPPING_FLAGS = 1;
pub type D3D12_TILE_MAPPING_FLAGS = ::std::os::raw::c_int;
pub const D3D12_TILE_COPY_FLAGS_D3D12_TILE_COPY_FLAG_NONE:
    D3D12_TILE_COPY_FLAGS = 0;
pub const D3D12_TILE_COPY_FLAGS_D3D12_TILE_COPY_FLAG_NO_HAZARD:
    D3D12_TILE_COPY_FLAGS = 1;
pub const D3D12_TILE_COPY_FLAGS_D3D12_TILE_COPY_FLAG_LINEAR_BUFFER_TO_SWIZZLED_TILED_RESOURCE : D3D12_TILE_COPY_FLAGS = 2 ;
pub const D3D12_TILE_COPY_FLAGS_D3D12_TILE_COPY_FLAG_SWIZZLED_TILED_RESOURCE_TO_LINEAR_BUFFER : D3D12_TILE_COPY_FLAGS = 4 ;
pub type D3D12_TILE_COPY_FLAGS = ::std::os::raw::c_int;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_COMMON:
    D3D12_RESOURCE_STATES = 0;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_VERTEX_AND_CONSTANT_BUFFER : D3D12_RESOURCE_STATES = 1 ;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_INDEX_BUFFER:
    D3D12_RESOURCE_STATES = 2;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_RENDER_TARGET:
    D3D12_RESOURCE_STATES = 4;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_UNORDERED_ACCESS:
    D3D12_RESOURCE_STATES = 8;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_DEPTH_WRITE:
    D3D12_RESOURCE_STATES = 16;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_DEPTH_READ:
    D3D12_RESOURCE_STATES = 32;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_NON_PIXEL_SHADER_RESOURCE : D3D12_RESOURCE_STATES = 64 ;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_PIXEL_SHADER_RESOURCE:
    D3D12_RESOURCE_STATES = 128;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_STREAM_OUT:
    D3D12_RESOURCE_STATES = 256;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_INDIRECT_ARGUMENT:
    D3D12_RESOURCE_STATES = 512;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_COPY_DEST:
    D3D12_RESOURCE_STATES = 1024;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_COPY_SOURCE:
    D3D12_RESOURCE_STATES = 2048;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_RESOLVE_DEST:
    D3D12_RESOURCE_STATES = 4096;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_RESOLVE_SOURCE:
    D3D12_RESOURCE_STATES = 8192;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_RAYTRACING_ACCELERATION_STRUCTURE : D3D12_RESOURCE_STATES = 4194304 ;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_SHADING_RATE_SOURCE:
    D3D12_RESOURCE_STATES = 16777216;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_GENERIC_READ:
    D3D12_RESOURCE_STATES = 2755;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_ALL_SHADER_RESOURCE:
    D3D12_RESOURCE_STATES = 192;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_PRESENT:
    D3D12_RESOURCE_STATES = 0;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_PREDICATION:
    D3D12_RESOURCE_STATES = 512;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_VIDEO_DECODE_READ:
    D3D12_RESOURCE_STATES = 65536;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_VIDEO_DECODE_WRITE:
    D3D12_RESOURCE_STATES = 131072;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_VIDEO_PROCESS_READ:
    D3D12_RESOURCE_STATES = 262144;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_VIDEO_PROCESS_WRITE:
    D3D12_RESOURCE_STATES = 524288;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_VIDEO_ENCODE_READ:
    D3D12_RESOURCE_STATES = 2097152;
pub const D3D12_RESOURCE_STATES_D3D12_RESOURCE_STATE_VIDEO_ENCODE_WRITE:
    D3D12_RESOURCE_STATES = 8388608;
pub type D3D12_RESOURCE_STATES = ::std::os::raw::c_int;
pub const D3D12_RESOURCE_BARRIER_TYPE_D3D12_RESOURCE_BARRIER_TYPE_TRANSITION:
    D3D12_RESOURCE_BARRIER_TYPE = 0;
pub const D3D12_RESOURCE_BARRIER_TYPE_D3D12_RESOURCE_BARRIER_TYPE_ALIASING:
    D3D12_RESOURCE_BARRIER_TYPE = 1;
pub const D3D12_RESOURCE_BARRIER_TYPE_D3D12_RESOURCE_BARRIER_TYPE_UAV:
    D3D12_RESOURCE_BARRIER_TYPE = 2;
pub type D3D12_RESOURCE_BARRIER_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RESOURCE_TRANSITION_BARRIER {
    pub pResource: *mut ID3D12Resource,
    pub Subresource: UINT,
    pub StateBefore: D3D12_RESOURCE_STATES,
    pub StateAfter: D3D12_RESOURCE_STATES,
}
impl Default for D3D12_RESOURCE_TRANSITION_BARRIER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RESOURCE_ALIASING_BARRIER {
    pub pResourceBefore: *mut ID3D12Resource,
    pub pResourceAfter: *mut ID3D12Resource,
}
impl Default for D3D12_RESOURCE_ALIASING_BARRIER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RESOURCE_UAV_BARRIER {
    pub pResource: *mut ID3D12Resource,
}
impl Default for D3D12_RESOURCE_UAV_BARRIER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_RESOURCE_BARRIER_FLAGS_D3D12_RESOURCE_BARRIER_FLAG_NONE:
    D3D12_RESOURCE_BARRIER_FLAGS = 0;
pub const D3D12_RESOURCE_BARRIER_FLAGS_D3D12_RESOURCE_BARRIER_FLAG_BEGIN_ONLY : D3D12_RESOURCE_BARRIER_FLAGS = 1 ;
pub const D3D12_RESOURCE_BARRIER_FLAGS_D3D12_RESOURCE_BARRIER_FLAG_END_ONLY:
    D3D12_RESOURCE_BARRIER_FLAGS = 2;
pub type D3D12_RESOURCE_BARRIER_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_RESOURCE_BARRIER {
    pub Type: D3D12_RESOURCE_BARRIER_TYPE,
    pub Flags: D3D12_RESOURCE_BARRIER_FLAGS,
    pub __bindgen_anon_1: D3D12_RESOURCE_BARRIER__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_RESOURCE_BARRIER__bindgen_ty_1 {
    pub Transition: D3D12_RESOURCE_TRANSITION_BARRIER,
    pub Aliasing: D3D12_RESOURCE_ALIASING_BARRIER,
    pub UAV: D3D12_RESOURCE_UAV_BARRIER,
}
impl Default for D3D12_RESOURCE_BARRIER__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RESOURCE_BARRIER__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_RESOURCE_BARRIER__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_RESOURCE_BARRIER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RESOURCE_BARRIER {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_RESOURCE_BARRIER {{ Type: {:?}, Flags: {:?}, __bindgen_anon_1: {:?} }}" , self . Type , self . Flags , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SUBRESOURCE_FOOTPRINT {
    pub Format: DXGI_FORMAT,
    pub Width: UINT,
    pub Height: UINT,
    pub Depth: UINT,
    pub RowPitch: UINT,
}
impl Default for D3D12_SUBRESOURCE_FOOTPRINT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_PLACED_SUBRESOURCE_FOOTPRINT {
    pub Offset: UINT64,
    pub Footprint: D3D12_SUBRESOURCE_FOOTPRINT,
}
impl Default for D3D12_PLACED_SUBRESOURCE_FOOTPRINT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_TEXTURE_COPY_TYPE_D3D12_TEXTURE_COPY_TYPE_SUBRESOURCE_INDEX:
    D3D12_TEXTURE_COPY_TYPE = 0;
pub const D3D12_TEXTURE_COPY_TYPE_D3D12_TEXTURE_COPY_TYPE_PLACED_FOOTPRINT:
    D3D12_TEXTURE_COPY_TYPE = 1;
pub type D3D12_TEXTURE_COPY_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_TEXTURE_COPY_LOCATION {
    pub pResource: *mut ID3D12Resource,
    pub Type: D3D12_TEXTURE_COPY_TYPE,
    pub __bindgen_anon_1: D3D12_TEXTURE_COPY_LOCATION__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_TEXTURE_COPY_LOCATION__bindgen_ty_1 {
    pub PlacedFootprint: D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
    pub SubresourceIndex: UINT,
}
impl Default for D3D12_TEXTURE_COPY_LOCATION__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_TEXTURE_COPY_LOCATION__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_TEXTURE_COPY_LOCATION__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_TEXTURE_COPY_LOCATION {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_TEXTURE_COPY_LOCATION {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_TEXTURE_COPY_LOCATION {{ pResource: {:?}, Type: {:?}, __bindgen_anon_1: {:?} }}" , self . pResource , self . Type , self . __bindgen_anon_1)
    }
}
pub const D3D12_RESOLVE_MODE_D3D12_RESOLVE_MODE_DECOMPRESS: D3D12_RESOLVE_MODE =
    0;
pub const D3D12_RESOLVE_MODE_D3D12_RESOLVE_MODE_MIN: D3D12_RESOLVE_MODE = 1;
pub const D3D12_RESOLVE_MODE_D3D12_RESOLVE_MODE_MAX: D3D12_RESOLVE_MODE = 2;
pub const D3D12_RESOLVE_MODE_D3D12_RESOLVE_MODE_AVERAGE: D3D12_RESOLVE_MODE = 3;
pub const D3D12_RESOLVE_MODE_D3D12_RESOLVE_MODE_ENCODE_SAMPLER_FEEDBACK:
    D3D12_RESOLVE_MODE = 4;
pub const D3D12_RESOLVE_MODE_D3D12_RESOLVE_MODE_DECODE_SAMPLER_FEEDBACK:
    D3D12_RESOLVE_MODE = 5;
pub type D3D12_RESOLVE_MODE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SAMPLE_POSITION {
    pub X: INT8,
    pub Y: INT8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_VIEW_INSTANCE_LOCATION {
    pub ViewportArrayIndex: UINT,
    pub RenderTargetArrayIndex: UINT,
}
pub const D3D12_VIEW_INSTANCING_FLAGS_D3D12_VIEW_INSTANCING_FLAG_NONE:
    D3D12_VIEW_INSTANCING_FLAGS = 0;
pub const D3D12_VIEW_INSTANCING_FLAGS_D3D12_VIEW_INSTANCING_FLAG_ENABLE_VIEW_INSTANCE_MASKING : D3D12_VIEW_INSTANCING_FLAGS = 1 ;
pub type D3D12_VIEW_INSTANCING_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_VIEW_INSTANCING_DESC {
    pub ViewInstanceCount: UINT,
    pub pViewInstanceLocations: *const D3D12_VIEW_INSTANCE_LOCATION,
    pub Flags: D3D12_VIEW_INSTANCING_FLAGS,
}
impl Default for D3D12_VIEW_INSTANCING_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_SHADER_COMPONENT_MAPPING_D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_0 : D3D12_SHADER_COMPONENT_MAPPING = 0 ;
pub const D3D12_SHADER_COMPONENT_MAPPING_D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_1 : D3D12_SHADER_COMPONENT_MAPPING = 1 ;
pub const D3D12_SHADER_COMPONENT_MAPPING_D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_2 : D3D12_SHADER_COMPONENT_MAPPING = 2 ;
pub const D3D12_SHADER_COMPONENT_MAPPING_D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_3 : D3D12_SHADER_COMPONENT_MAPPING = 3 ;
pub const D3D12_SHADER_COMPONENT_MAPPING_D3D12_SHADER_COMPONENT_MAPPING_FORCE_VALUE_0 : D3D12_SHADER_COMPONENT_MAPPING = 4 ;
pub const D3D12_SHADER_COMPONENT_MAPPING_D3D12_SHADER_COMPONENT_MAPPING_FORCE_VALUE_1 : D3D12_SHADER_COMPONENT_MAPPING = 5 ;
pub type D3D12_SHADER_COMPONENT_MAPPING = ::std::os::raw::c_int;
pub const D3D12_BUFFER_SRV_FLAGS_D3D12_BUFFER_SRV_FLAG_NONE:
    D3D12_BUFFER_SRV_FLAGS = 0;
pub const D3D12_BUFFER_SRV_FLAGS_D3D12_BUFFER_SRV_FLAG_RAW:
    D3D12_BUFFER_SRV_FLAGS = 1;
pub type D3D12_BUFFER_SRV_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_BUFFER_SRV {
    pub FirstElement: UINT64,
    pub NumElements: UINT,
    pub StructureByteStride: UINT,
    pub Flags: D3D12_BUFFER_SRV_FLAGS,
}
impl Default for D3D12_BUFFER_SRV {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_TEX1D_SRV {
    pub MostDetailedMip: UINT,
    pub MipLevels: UINT,
    pub ResourceMinLODClamp: FLOAT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_TEX1D_ARRAY_SRV {
    pub MostDetailedMip: UINT,
    pub MipLevels: UINT,
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
    pub ResourceMinLODClamp: FLOAT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_TEX2D_SRV {
    pub MostDetailedMip: UINT,
    pub MipLevels: UINT,
    pub PlaneSlice: UINT,
    pub ResourceMinLODClamp: FLOAT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_TEX2D_ARRAY_SRV {
    pub MostDetailedMip: UINT,
    pub MipLevels: UINT,
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
    pub PlaneSlice: UINT,
    pub ResourceMinLODClamp: FLOAT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_TEX3D_SRV {
    pub MostDetailedMip: UINT,
    pub MipLevels: UINT,
    pub ResourceMinLODClamp: FLOAT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_TEXCUBE_SRV {
    pub MostDetailedMip: UINT,
    pub MipLevels: UINT,
    pub ResourceMinLODClamp: FLOAT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_TEXCUBE_ARRAY_SRV {
    pub MostDetailedMip: UINT,
    pub MipLevels: UINT,
    pub First2DArrayFace: UINT,
    pub NumCubes: UINT,
    pub ResourceMinLODClamp: FLOAT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2DMS_SRV {
    pub UnusedField_NothingToDefine: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2DMS_ARRAY_SRV {
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV {
    pub Location: D3D12_GPU_VIRTUAL_ADDRESS,
}
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_UNKNOWN: D3D12_SRV_DIMENSION =
    0;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_BUFFER: D3D12_SRV_DIMENSION =
    1;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURE1D:
    D3D12_SRV_DIMENSION = 2;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURE1DARRAY:
    D3D12_SRV_DIMENSION = 3;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURE2D:
    D3D12_SRV_DIMENSION = 4;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURE2DARRAY:
    D3D12_SRV_DIMENSION = 5;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURE2DMS:
    D3D12_SRV_DIMENSION = 6;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURE2DMSARRAY:
    D3D12_SRV_DIMENSION = 7;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURE3D:
    D3D12_SRV_DIMENSION = 8;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURECUBE:
    D3D12_SRV_DIMENSION = 9;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_TEXTURECUBEARRAY:
    D3D12_SRV_DIMENSION = 10;
pub const D3D12_SRV_DIMENSION_D3D12_SRV_DIMENSION_RAYTRACING_ACCELERATION_STRUCTURE : D3D12_SRV_DIMENSION = 11 ;
pub type D3D12_SRV_DIMENSION = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_SHADER_RESOURCE_VIEW_DESC {
    pub Format: DXGI_FORMAT,
    pub ViewDimension: D3D12_SRV_DIMENSION,
    pub Shader4ComponentMapping: UINT,
    pub __bindgen_anon_1: D3D12_SHADER_RESOURCE_VIEW_DESC__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_SHADER_RESOURCE_VIEW_DESC__bindgen_ty_1 {
    pub Buffer: D3D12_BUFFER_SRV,
    pub Texture1D: D3D12_TEX1D_SRV,
    pub Texture1DArray: D3D12_TEX1D_ARRAY_SRV,
    pub Texture2D: D3D12_TEX2D_SRV,
    pub Texture2DArray: D3D12_TEX2D_ARRAY_SRV,
    pub Texture2DMS: D3D12_TEX2DMS_SRV,
    pub Texture2DMSArray: D3D12_TEX2DMS_ARRAY_SRV,
    pub Texture3D: D3D12_TEX3D_SRV,
    pub TextureCube: D3D12_TEXCUBE_SRV,
    pub TextureCubeArray: D3D12_TEXCUBE_ARRAY_SRV,
    pub RaytracingAccelerationStructure:
        D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV,
}
impl Default for D3D12_SHADER_RESOURCE_VIEW_DESC__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_SHADER_RESOURCE_VIEW_DESC__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "D3D12_SHADER_RESOURCE_VIEW_DESC__bindgen_ty_1 {{ union }}"
        )
    }
}
impl Default for D3D12_SHADER_RESOURCE_VIEW_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_SHADER_RESOURCE_VIEW_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_SHADER_RESOURCE_VIEW_DESC {{ Format: {:?}, ViewDimension: {:?}, Shader4ComponentMapping: {:?}, __bindgen_anon_1: {:?} }}" , self . Format , self . ViewDimension , self . Shader4ComponentMapping , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_CONSTANT_BUFFER_VIEW_DESC {
    pub BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    pub SizeInBytes: UINT,
}
pub const D3D12_FILTER_D3D12_FILTER_MIN_MAG_MIP_POINT: D3D12_FILTER = 0;
pub const D3D12_FILTER_D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR: D3D12_FILTER = 1;
pub const D3D12_FILTER_D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT:
    D3D12_FILTER = 4;
pub const D3D12_FILTER_D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR: D3D12_FILTER = 5;
pub const D3D12_FILTER_D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT: D3D12_FILTER = 16;
pub const D3D12_FILTER_D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR:
    D3D12_FILTER = 17;
pub const D3D12_FILTER_D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT: D3D12_FILTER = 20;
pub const D3D12_FILTER_D3D12_FILTER_MIN_MAG_MIP_LINEAR: D3D12_FILTER = 21;
pub const D3D12_FILTER_D3D12_FILTER_ANISOTROPIC: D3D12_FILTER = 85;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_MIN_MAG_MIP_POINT: D3D12_FILTER =
    128;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR:
    D3D12_FILTER = 129;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT : D3D12_FILTER = 132 ;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR:
    D3D12_FILTER = 133;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT:
    D3D12_FILTER = 144;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR : D3D12_FILTER = 145 ;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT:
    D3D12_FILTER = 148;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR:
    D3D12_FILTER = 149;
pub const D3D12_FILTER_D3D12_FILTER_COMPARISON_ANISOTROPIC: D3D12_FILTER = 213;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_MIN_MAG_MIP_POINT: D3D12_FILTER =
    256;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR:
    D3D12_FILTER = 257;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT:
    D3D12_FILTER = 260;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR:
    D3D12_FILTER = 261;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT:
    D3D12_FILTER = 272;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR:
    D3D12_FILTER = 273;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT:
    D3D12_FILTER = 276;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR: D3D12_FILTER =
    277;
pub const D3D12_FILTER_D3D12_FILTER_MINIMUM_ANISOTROPIC: D3D12_FILTER = 341;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_POINT: D3D12_FILTER =
    384;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR:
    D3D12_FILTER = 385;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT:
    D3D12_FILTER = 388;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR:
    D3D12_FILTER = 389;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT:
    D3D12_FILTER = 400;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR:
    D3D12_FILTER = 401;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT:
    D3D12_FILTER = 404;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR: D3D12_FILTER =
    405;
pub const D3D12_FILTER_D3D12_FILTER_MAXIMUM_ANISOTROPIC: D3D12_FILTER = 469;
pub type D3D12_FILTER = ::std::os::raw::c_int;
pub const D3D12_FILTER_TYPE_D3D12_FILTER_TYPE_POINT: D3D12_FILTER_TYPE = 0;
pub const D3D12_FILTER_TYPE_D3D12_FILTER_TYPE_LINEAR: D3D12_FILTER_TYPE = 1;
pub type D3D12_FILTER_TYPE = ::std::os::raw::c_int;
pub const D3D12_FILTER_REDUCTION_TYPE_D3D12_FILTER_REDUCTION_TYPE_STANDARD:
    D3D12_FILTER_REDUCTION_TYPE = 0;
pub const D3D12_FILTER_REDUCTION_TYPE_D3D12_FILTER_REDUCTION_TYPE_COMPARISON:
    D3D12_FILTER_REDUCTION_TYPE = 1;
pub const D3D12_FILTER_REDUCTION_TYPE_D3D12_FILTER_REDUCTION_TYPE_MINIMUM:
    D3D12_FILTER_REDUCTION_TYPE = 2;
pub const D3D12_FILTER_REDUCTION_TYPE_D3D12_FILTER_REDUCTION_TYPE_MAXIMUM:
    D3D12_FILTER_REDUCTION_TYPE = 3;
pub type D3D12_FILTER_REDUCTION_TYPE = ::std::os::raw::c_int;
pub const D3D12_TEXTURE_ADDRESS_MODE_D3D12_TEXTURE_ADDRESS_MODE_WRAP:
    D3D12_TEXTURE_ADDRESS_MODE = 1;
pub const D3D12_TEXTURE_ADDRESS_MODE_D3D12_TEXTURE_ADDRESS_MODE_MIRROR:
    D3D12_TEXTURE_ADDRESS_MODE = 2;
pub const D3D12_TEXTURE_ADDRESS_MODE_D3D12_TEXTURE_ADDRESS_MODE_CLAMP:
    D3D12_TEXTURE_ADDRESS_MODE = 3;
pub const D3D12_TEXTURE_ADDRESS_MODE_D3D12_TEXTURE_ADDRESS_MODE_BORDER:
    D3D12_TEXTURE_ADDRESS_MODE = 4;
pub const D3D12_TEXTURE_ADDRESS_MODE_D3D12_TEXTURE_ADDRESS_MODE_MIRROR_ONCE:
    D3D12_TEXTURE_ADDRESS_MODE = 5;
pub type D3D12_TEXTURE_ADDRESS_MODE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_SAMPLER_DESC {
    pub Filter: D3D12_FILTER,
    pub AddressU: D3D12_TEXTURE_ADDRESS_MODE,
    pub AddressV: D3D12_TEXTURE_ADDRESS_MODE,
    pub AddressW: D3D12_TEXTURE_ADDRESS_MODE,
    pub MipLODBias: FLOAT,
    pub MaxAnisotropy: UINT,
    pub ComparisonFunc: D3D12_COMPARISON_FUNC,
    pub BorderColor: [FLOAT; 4usize],
    pub MinLOD: FLOAT,
    pub MaxLOD: FLOAT,
}
impl Default for D3D12_SAMPLER_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_BUFFER_UAV_FLAGS_D3D12_BUFFER_UAV_FLAG_NONE:
    D3D12_BUFFER_UAV_FLAGS = 0;
pub const D3D12_BUFFER_UAV_FLAGS_D3D12_BUFFER_UAV_FLAG_RAW:
    D3D12_BUFFER_UAV_FLAGS = 1;
pub type D3D12_BUFFER_UAV_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_BUFFER_UAV {
    pub FirstElement: UINT64,
    pub NumElements: UINT,
    pub StructureByteStride: UINT,
    pub CounterOffsetInBytes: UINT64,
    pub Flags: D3D12_BUFFER_UAV_FLAGS,
}
impl Default for D3D12_BUFFER_UAV {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX1D_UAV {
    pub MipSlice: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX1D_ARRAY_UAV {
    pub MipSlice: UINT,
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2D_UAV {
    pub MipSlice: UINT,
    pub PlaneSlice: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2D_ARRAY_UAV {
    pub MipSlice: UINT,
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
    pub PlaneSlice: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX3D_UAV {
    pub MipSlice: UINT,
    pub FirstWSlice: UINT,
    pub WSize: UINT,
}
pub const D3D12_UAV_DIMENSION_D3D12_UAV_DIMENSION_UNKNOWN: D3D12_UAV_DIMENSION =
    0;
pub const D3D12_UAV_DIMENSION_D3D12_UAV_DIMENSION_BUFFER: D3D12_UAV_DIMENSION =
    1;
pub const D3D12_UAV_DIMENSION_D3D12_UAV_DIMENSION_TEXTURE1D:
    D3D12_UAV_DIMENSION = 2;
pub const D3D12_UAV_DIMENSION_D3D12_UAV_DIMENSION_TEXTURE1DARRAY:
    D3D12_UAV_DIMENSION = 3;
pub const D3D12_UAV_DIMENSION_D3D12_UAV_DIMENSION_TEXTURE2D:
    D3D12_UAV_DIMENSION = 4;
pub const D3D12_UAV_DIMENSION_D3D12_UAV_DIMENSION_TEXTURE2DARRAY:
    D3D12_UAV_DIMENSION = 5;
pub const D3D12_UAV_DIMENSION_D3D12_UAV_DIMENSION_TEXTURE3D:
    D3D12_UAV_DIMENSION = 8;
pub type D3D12_UAV_DIMENSION = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_UNORDERED_ACCESS_VIEW_DESC {
    pub Format: DXGI_FORMAT,
    pub ViewDimension: D3D12_UAV_DIMENSION,
    pub __bindgen_anon_1: D3D12_UNORDERED_ACCESS_VIEW_DESC__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_UNORDERED_ACCESS_VIEW_DESC__bindgen_ty_1 {
    pub Buffer: D3D12_BUFFER_UAV,
    pub Texture1D: D3D12_TEX1D_UAV,
    pub Texture1DArray: D3D12_TEX1D_ARRAY_UAV,
    pub Texture2D: D3D12_TEX2D_UAV,
    pub Texture2DArray: D3D12_TEX2D_ARRAY_UAV,
    pub Texture3D: D3D12_TEX3D_UAV,
}
impl Default for D3D12_UNORDERED_ACCESS_VIEW_DESC__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_UNORDERED_ACCESS_VIEW_DESC__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "D3D12_UNORDERED_ACCESS_VIEW_DESC__bindgen_ty_1 {{ union }}"
        )
    }
}
impl Default for D3D12_UNORDERED_ACCESS_VIEW_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_UNORDERED_ACCESS_VIEW_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_UNORDERED_ACCESS_VIEW_DESC {{ Format: {:?}, ViewDimension: {:?}, __bindgen_anon_1: {:?} }}" , self . Format , self . ViewDimension , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_BUFFER_RTV {
    pub FirstElement: UINT64,
    pub NumElements: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX1D_RTV {
    pub MipSlice: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX1D_ARRAY_RTV {
    pub MipSlice: UINT,
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2D_RTV {
    pub MipSlice: UINT,
    pub PlaneSlice: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2DMS_RTV {
    pub UnusedField_NothingToDefine: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2D_ARRAY_RTV {
    pub MipSlice: UINT,
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
    pub PlaneSlice: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2DMS_ARRAY_RTV {
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX3D_RTV {
    pub MipSlice: UINT,
    pub FirstWSlice: UINT,
    pub WSize: UINT,
}
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_UNKNOWN: D3D12_RTV_DIMENSION =
    0;
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_BUFFER: D3D12_RTV_DIMENSION =
    1;
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_TEXTURE1D:
    D3D12_RTV_DIMENSION = 2;
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_TEXTURE1DARRAY:
    D3D12_RTV_DIMENSION = 3;
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_TEXTURE2D:
    D3D12_RTV_DIMENSION = 4;
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_TEXTURE2DARRAY:
    D3D12_RTV_DIMENSION = 5;
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_TEXTURE2DMS:
    D3D12_RTV_DIMENSION = 6;
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_TEXTURE2DMSARRAY:
    D3D12_RTV_DIMENSION = 7;
pub const D3D12_RTV_DIMENSION_D3D12_RTV_DIMENSION_TEXTURE3D:
    D3D12_RTV_DIMENSION = 8;
pub type D3D12_RTV_DIMENSION = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_RENDER_TARGET_VIEW_DESC {
    pub Format: DXGI_FORMAT,
    pub ViewDimension: D3D12_RTV_DIMENSION,
    pub __bindgen_anon_1: D3D12_RENDER_TARGET_VIEW_DESC__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_RENDER_TARGET_VIEW_DESC__bindgen_ty_1 {
    pub Buffer: D3D12_BUFFER_RTV,
    pub Texture1D: D3D12_TEX1D_RTV,
    pub Texture1DArray: D3D12_TEX1D_ARRAY_RTV,
    pub Texture2D: D3D12_TEX2D_RTV,
    pub Texture2DArray: D3D12_TEX2D_ARRAY_RTV,
    pub Texture2DMS: D3D12_TEX2DMS_RTV,
    pub Texture2DMSArray: D3D12_TEX2DMS_ARRAY_RTV,
    pub Texture3D: D3D12_TEX3D_RTV,
}
impl Default for D3D12_RENDER_TARGET_VIEW_DESC__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_TARGET_VIEW_DESC__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_RENDER_TARGET_VIEW_DESC__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_RENDER_TARGET_VIEW_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_TARGET_VIEW_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_RENDER_TARGET_VIEW_DESC {{ Format: {:?}, ViewDimension: {:?}, __bindgen_anon_1: {:?} }}" , self . Format , self . ViewDimension , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX1D_DSV {
    pub MipSlice: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX1D_ARRAY_DSV {
    pub MipSlice: UINT,
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2D_DSV {
    pub MipSlice: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2D_ARRAY_DSV {
    pub MipSlice: UINT,
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2DMS_DSV {
    pub UnusedField_NothingToDefine: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEX2DMS_ARRAY_DSV {
    pub FirstArraySlice: UINT,
    pub ArraySize: UINT,
}
pub const D3D12_DSV_FLAGS_D3D12_DSV_FLAG_NONE: D3D12_DSV_FLAGS = 0;
pub const D3D12_DSV_FLAGS_D3D12_DSV_FLAG_READ_ONLY_DEPTH: D3D12_DSV_FLAGS = 1;
pub const D3D12_DSV_FLAGS_D3D12_DSV_FLAG_READ_ONLY_STENCIL: D3D12_DSV_FLAGS = 2;
pub type D3D12_DSV_FLAGS = ::std::os::raw::c_int;
pub const D3D12_DSV_DIMENSION_D3D12_DSV_DIMENSION_UNKNOWN: D3D12_DSV_DIMENSION =
    0;
pub const D3D12_DSV_DIMENSION_D3D12_DSV_DIMENSION_TEXTURE1D:
    D3D12_DSV_DIMENSION = 1;
pub const D3D12_DSV_DIMENSION_D3D12_DSV_DIMENSION_TEXTURE1DARRAY:
    D3D12_DSV_DIMENSION = 2;
pub const D3D12_DSV_DIMENSION_D3D12_DSV_DIMENSION_TEXTURE2D:
    D3D12_DSV_DIMENSION = 3;
pub const D3D12_DSV_DIMENSION_D3D12_DSV_DIMENSION_TEXTURE2DARRAY:
    D3D12_DSV_DIMENSION = 4;
pub const D3D12_DSV_DIMENSION_D3D12_DSV_DIMENSION_TEXTURE2DMS:
    D3D12_DSV_DIMENSION = 5;
pub const D3D12_DSV_DIMENSION_D3D12_DSV_DIMENSION_TEXTURE2DMSARRAY:
    D3D12_DSV_DIMENSION = 6;
pub type D3D12_DSV_DIMENSION = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_DEPTH_STENCIL_VIEW_DESC {
    pub Format: DXGI_FORMAT,
    pub ViewDimension: D3D12_DSV_DIMENSION,
    pub Flags: D3D12_DSV_FLAGS,
    pub __bindgen_anon_1: D3D12_DEPTH_STENCIL_VIEW_DESC__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_DEPTH_STENCIL_VIEW_DESC__bindgen_ty_1 {
    pub Texture1D: D3D12_TEX1D_DSV,
    pub Texture1DArray: D3D12_TEX1D_ARRAY_DSV,
    pub Texture2D: D3D12_TEX2D_DSV,
    pub Texture2DArray: D3D12_TEX2D_ARRAY_DSV,
    pub Texture2DMS: D3D12_TEX2DMS_DSV,
    pub Texture2DMSArray: D3D12_TEX2DMS_ARRAY_DSV,
}
impl Default for D3D12_DEPTH_STENCIL_VIEW_DESC__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_DEPTH_STENCIL_VIEW_DESC__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_DEPTH_STENCIL_VIEW_DESC__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_DEPTH_STENCIL_VIEW_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_DEPTH_STENCIL_VIEW_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_DEPTH_STENCIL_VIEW_DESC {{ Format: {:?}, ViewDimension: {:?}, Flags: {:?}, __bindgen_anon_1: {:?} }}" , self . Format , self . ViewDimension , self . Flags , self . __bindgen_anon_1)
    }
}
pub const D3D12_CLEAR_FLAGS_D3D12_CLEAR_FLAG_DEPTH: D3D12_CLEAR_FLAGS = 1;
pub const D3D12_CLEAR_FLAGS_D3D12_CLEAR_FLAG_STENCIL: D3D12_CLEAR_FLAGS = 2;
pub type D3D12_CLEAR_FLAGS = ::std::os::raw::c_int;
pub const D3D12_FENCE_FLAGS_D3D12_FENCE_FLAG_NONE: D3D12_FENCE_FLAGS = 0;
pub const D3D12_FENCE_FLAGS_D3D12_FENCE_FLAG_SHARED: D3D12_FENCE_FLAGS = 1;
pub const D3D12_FENCE_FLAGS_D3D12_FENCE_FLAG_SHARED_CROSS_ADAPTER:
    D3D12_FENCE_FLAGS = 2;
pub const D3D12_FENCE_FLAGS_D3D12_FENCE_FLAG_NON_MONITORED: D3D12_FENCE_FLAGS =
    4;
pub type D3D12_FENCE_FLAGS = ::std::os::raw::c_int;
pub const D3D12_DESCRIPTOR_HEAP_TYPE_D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV:
    D3D12_DESCRIPTOR_HEAP_TYPE = 0;
pub const D3D12_DESCRIPTOR_HEAP_TYPE_D3D12_DESCRIPTOR_HEAP_TYPE_SAMPLER:
    D3D12_DESCRIPTOR_HEAP_TYPE = 1;
pub const D3D12_DESCRIPTOR_HEAP_TYPE_D3D12_DESCRIPTOR_HEAP_TYPE_RTV:
    D3D12_DESCRIPTOR_HEAP_TYPE = 2;
pub const D3D12_DESCRIPTOR_HEAP_TYPE_D3D12_DESCRIPTOR_HEAP_TYPE_DSV:
    D3D12_DESCRIPTOR_HEAP_TYPE = 3;
pub const D3D12_DESCRIPTOR_HEAP_TYPE_D3D12_DESCRIPTOR_HEAP_TYPE_NUM_TYPES:
    D3D12_DESCRIPTOR_HEAP_TYPE = 4;
pub type D3D12_DESCRIPTOR_HEAP_TYPE = ::std::os::raw::c_int;
pub const D3D12_DESCRIPTOR_HEAP_FLAGS_D3D12_DESCRIPTOR_HEAP_FLAG_NONE:
    D3D12_DESCRIPTOR_HEAP_FLAGS = 0;
pub const D3D12_DESCRIPTOR_HEAP_FLAGS_D3D12_DESCRIPTOR_HEAP_FLAG_SHADER_VISIBLE : D3D12_DESCRIPTOR_HEAP_FLAGS = 1 ;
pub type D3D12_DESCRIPTOR_HEAP_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DESCRIPTOR_HEAP_DESC {
    pub Type: D3D12_DESCRIPTOR_HEAP_TYPE,
    pub NumDescriptors: UINT,
    pub Flags: D3D12_DESCRIPTOR_HEAP_FLAGS,
    pub NodeMask: UINT,
}
impl Default for D3D12_DESCRIPTOR_HEAP_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_DESCRIPTOR_RANGE_TYPE_D3D12_DESCRIPTOR_RANGE_TYPE_SRV:
    D3D12_DESCRIPTOR_RANGE_TYPE = 0;
pub const D3D12_DESCRIPTOR_RANGE_TYPE_D3D12_DESCRIPTOR_RANGE_TYPE_UAV:
    D3D12_DESCRIPTOR_RANGE_TYPE = 1;
pub const D3D12_DESCRIPTOR_RANGE_TYPE_D3D12_DESCRIPTOR_RANGE_TYPE_CBV:
    D3D12_DESCRIPTOR_RANGE_TYPE = 2;
pub const D3D12_DESCRIPTOR_RANGE_TYPE_D3D12_DESCRIPTOR_RANGE_TYPE_SAMPLER:
    D3D12_DESCRIPTOR_RANGE_TYPE = 3;
pub type D3D12_DESCRIPTOR_RANGE_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DESCRIPTOR_RANGE {
    pub RangeType: D3D12_DESCRIPTOR_RANGE_TYPE,
    pub NumDescriptors: UINT,
    pub BaseShaderRegister: UINT,
    pub RegisterSpace: UINT,
    pub OffsetInDescriptorsFromTableStart: UINT,
}
impl Default for D3D12_DESCRIPTOR_RANGE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_ROOT_DESCRIPTOR_TABLE {
    pub NumDescriptorRanges: UINT,
    pub pDescriptorRanges: *const D3D12_DESCRIPTOR_RANGE,
}
impl Default for D3D12_ROOT_DESCRIPTOR_TABLE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_ROOT_CONSTANTS {
    pub ShaderRegister: UINT,
    pub RegisterSpace: UINT,
    pub Num32BitValues: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_ROOT_DESCRIPTOR {
    pub ShaderRegister: UINT,
    pub RegisterSpace: UINT,
}
pub const D3D12_SHADER_VISIBILITY_D3D12_SHADER_VISIBILITY_ALL:
    D3D12_SHADER_VISIBILITY = 0;
pub const D3D12_SHADER_VISIBILITY_D3D12_SHADER_VISIBILITY_VERTEX:
    D3D12_SHADER_VISIBILITY = 1;
pub const D3D12_SHADER_VISIBILITY_D3D12_SHADER_VISIBILITY_HULL:
    D3D12_SHADER_VISIBILITY = 2;
pub const D3D12_SHADER_VISIBILITY_D3D12_SHADER_VISIBILITY_DOMAIN:
    D3D12_SHADER_VISIBILITY = 3;
pub const D3D12_SHADER_VISIBILITY_D3D12_SHADER_VISIBILITY_GEOMETRY:
    D3D12_SHADER_VISIBILITY = 4;
pub const D3D12_SHADER_VISIBILITY_D3D12_SHADER_VISIBILITY_PIXEL:
    D3D12_SHADER_VISIBILITY = 5;
pub const D3D12_SHADER_VISIBILITY_D3D12_SHADER_VISIBILITY_AMPLIFICATION:
    D3D12_SHADER_VISIBILITY = 6;
pub const D3D12_SHADER_VISIBILITY_D3D12_SHADER_VISIBILITY_MESH:
    D3D12_SHADER_VISIBILITY = 7;
pub type D3D12_SHADER_VISIBILITY = ::std::os::raw::c_int;
pub const D3D12_ROOT_PARAMETER_TYPE_D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE : D3D12_ROOT_PARAMETER_TYPE = 0 ;
pub const D3D12_ROOT_PARAMETER_TYPE_D3D12_ROOT_PARAMETER_TYPE_32BIT_CONSTANTS : D3D12_ROOT_PARAMETER_TYPE = 1 ;
pub const D3D12_ROOT_PARAMETER_TYPE_D3D12_ROOT_PARAMETER_TYPE_CBV:
    D3D12_ROOT_PARAMETER_TYPE = 2;
pub const D3D12_ROOT_PARAMETER_TYPE_D3D12_ROOT_PARAMETER_TYPE_SRV:
    D3D12_ROOT_PARAMETER_TYPE = 3;
pub const D3D12_ROOT_PARAMETER_TYPE_D3D12_ROOT_PARAMETER_TYPE_UAV:
    D3D12_ROOT_PARAMETER_TYPE = 4;
pub type D3D12_ROOT_PARAMETER_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_ROOT_PARAMETER {
    pub ParameterType: D3D12_ROOT_PARAMETER_TYPE,
    pub __bindgen_anon_1: D3D12_ROOT_PARAMETER__bindgen_ty_1,
    pub ShaderVisibility: D3D12_SHADER_VISIBILITY,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_ROOT_PARAMETER__bindgen_ty_1 {
    pub DescriptorTable: D3D12_ROOT_DESCRIPTOR_TABLE,
    pub Constants: D3D12_ROOT_CONSTANTS,
    pub Descriptor: D3D12_ROOT_DESCRIPTOR,
}
impl Default for D3D12_ROOT_PARAMETER__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_PARAMETER__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_ROOT_PARAMETER__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_ROOT_PARAMETER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_PARAMETER {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_ROOT_PARAMETER {{ ParameterType: {:?}, __bindgen_anon_1: {:?}, ShaderVisibility: {:?} }}" , self . ParameterType , self . __bindgen_anon_1 , self . ShaderVisibility)
    }
}
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_NONE:
    D3D12_ROOT_SIGNATURE_FLAGS = 0;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_ALLOW_INPUT_ASSEMBLER_INPUT_LAYOUT : D3D12_ROOT_SIGNATURE_FLAGS = 1 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_DENY_VERTEX_SHADER_ROOT_ACCESS : D3D12_ROOT_SIGNATURE_FLAGS = 2 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_DENY_HULL_SHADER_ROOT_ACCESS : D3D12_ROOT_SIGNATURE_FLAGS = 4 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_DENY_DOMAIN_SHADER_ROOT_ACCESS : D3D12_ROOT_SIGNATURE_FLAGS = 8 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_DENY_GEOMETRY_SHADER_ROOT_ACCESS : D3D12_ROOT_SIGNATURE_FLAGS = 16 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_DENY_PIXEL_SHADER_ROOT_ACCESS : D3D12_ROOT_SIGNATURE_FLAGS = 32 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_ALLOW_STREAM_OUTPUT : D3D12_ROOT_SIGNATURE_FLAGS = 64 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_LOCAL_ROOT_SIGNATURE : D3D12_ROOT_SIGNATURE_FLAGS = 128 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_DENY_AMPLIFICATION_SHADER_ROOT_ACCESS : D3D12_ROOT_SIGNATURE_FLAGS = 256 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_DENY_MESH_SHADER_ROOT_ACCESS : D3D12_ROOT_SIGNATURE_FLAGS = 512 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_CBV_SRV_UAV_HEAP_DIRECTLY_INDEXED : D3D12_ROOT_SIGNATURE_FLAGS = 1024 ;
pub const D3D12_ROOT_SIGNATURE_FLAGS_D3D12_ROOT_SIGNATURE_FLAG_SAMPLER_HEAP_DIRECTLY_INDEXED : D3D12_ROOT_SIGNATURE_FLAGS = 2048 ;
pub type D3D12_ROOT_SIGNATURE_FLAGS = ::std::os::raw::c_int;
pub const D3D12_STATIC_BORDER_COLOR_D3D12_STATIC_BORDER_COLOR_TRANSPARENT_BLACK : D3D12_STATIC_BORDER_COLOR = 0 ;
pub const D3D12_STATIC_BORDER_COLOR_D3D12_STATIC_BORDER_COLOR_OPAQUE_BLACK:
    D3D12_STATIC_BORDER_COLOR = 1;
pub const D3D12_STATIC_BORDER_COLOR_D3D12_STATIC_BORDER_COLOR_OPAQUE_WHITE:
    D3D12_STATIC_BORDER_COLOR = 2;
pub type D3D12_STATIC_BORDER_COLOR = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_STATIC_SAMPLER_DESC {
    pub Filter: D3D12_FILTER,
    pub AddressU: D3D12_TEXTURE_ADDRESS_MODE,
    pub AddressV: D3D12_TEXTURE_ADDRESS_MODE,
    pub AddressW: D3D12_TEXTURE_ADDRESS_MODE,
    pub MipLODBias: FLOAT,
    pub MaxAnisotropy: UINT,
    pub ComparisonFunc: D3D12_COMPARISON_FUNC,
    pub BorderColor: D3D12_STATIC_BORDER_COLOR,
    pub MinLOD: FLOAT,
    pub MaxLOD: FLOAT,
    pub ShaderRegister: UINT,
    pub RegisterSpace: UINT,
    pub ShaderVisibility: D3D12_SHADER_VISIBILITY,
}
impl Default for D3D12_STATIC_SAMPLER_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_ROOT_SIGNATURE_DESC {
    pub NumParameters: UINT,
    pub pParameters: *const D3D12_ROOT_PARAMETER,
    pub NumStaticSamplers: UINT,
    pub pStaticSamplers: *const D3D12_STATIC_SAMPLER_DESC,
    pub Flags: D3D12_ROOT_SIGNATURE_FLAGS,
}
impl Default for D3D12_ROOT_SIGNATURE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_DESCRIPTOR_RANGE_FLAGS_D3D12_DESCRIPTOR_RANGE_FLAG_NONE:
    D3D12_DESCRIPTOR_RANGE_FLAGS = 0;
pub const D3D12_DESCRIPTOR_RANGE_FLAGS_D3D12_DESCRIPTOR_RANGE_FLAG_DESCRIPTORS_VOLATILE : D3D12_DESCRIPTOR_RANGE_FLAGS = 1 ;
pub const D3D12_DESCRIPTOR_RANGE_FLAGS_D3D12_DESCRIPTOR_RANGE_FLAG_DATA_VOLATILE : D3D12_DESCRIPTOR_RANGE_FLAGS = 2 ;
pub const D3D12_DESCRIPTOR_RANGE_FLAGS_D3D12_DESCRIPTOR_RANGE_FLAG_DATA_STATIC_WHILE_SET_AT_EXECUTE : D3D12_DESCRIPTOR_RANGE_FLAGS = 4 ;
pub const D3D12_DESCRIPTOR_RANGE_FLAGS_D3D12_DESCRIPTOR_RANGE_FLAG_DATA_STATIC : D3D12_DESCRIPTOR_RANGE_FLAGS = 8 ;
pub const D3D12_DESCRIPTOR_RANGE_FLAGS_D3D12_DESCRIPTOR_RANGE_FLAG_DESCRIPTORS_STATIC_KEEPING_BUFFER_BOUNDS_CHECKS : D3D12_DESCRIPTOR_RANGE_FLAGS = 65536 ;
pub type D3D12_DESCRIPTOR_RANGE_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DESCRIPTOR_RANGE1 {
    pub RangeType: D3D12_DESCRIPTOR_RANGE_TYPE,
    pub NumDescriptors: UINT,
    pub BaseShaderRegister: UINT,
    pub RegisterSpace: UINT,
    pub Flags: D3D12_DESCRIPTOR_RANGE_FLAGS,
    pub OffsetInDescriptorsFromTableStart: UINT,
}
impl Default for D3D12_DESCRIPTOR_RANGE1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_ROOT_DESCRIPTOR_TABLE1 {
    pub NumDescriptorRanges: UINT,
    pub pDescriptorRanges: *const D3D12_DESCRIPTOR_RANGE1,
}
impl Default for D3D12_ROOT_DESCRIPTOR_TABLE1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_ROOT_DESCRIPTOR_FLAGS_D3D12_ROOT_DESCRIPTOR_FLAG_NONE:
    D3D12_ROOT_DESCRIPTOR_FLAGS = 0;
pub const D3D12_ROOT_DESCRIPTOR_FLAGS_D3D12_ROOT_DESCRIPTOR_FLAG_DATA_VOLATILE : D3D12_ROOT_DESCRIPTOR_FLAGS = 2 ;
pub const D3D12_ROOT_DESCRIPTOR_FLAGS_D3D12_ROOT_DESCRIPTOR_FLAG_DATA_STATIC_WHILE_SET_AT_EXECUTE : D3D12_ROOT_DESCRIPTOR_FLAGS = 4 ;
pub const D3D12_ROOT_DESCRIPTOR_FLAGS_D3D12_ROOT_DESCRIPTOR_FLAG_DATA_STATIC:
    D3D12_ROOT_DESCRIPTOR_FLAGS = 8;
pub type D3D12_ROOT_DESCRIPTOR_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_ROOT_DESCRIPTOR1 {
    pub ShaderRegister: UINT,
    pub RegisterSpace: UINT,
    pub Flags: D3D12_ROOT_DESCRIPTOR_FLAGS,
}
impl Default for D3D12_ROOT_DESCRIPTOR1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_ROOT_PARAMETER1 {
    pub ParameterType: D3D12_ROOT_PARAMETER_TYPE,
    pub __bindgen_anon_1: D3D12_ROOT_PARAMETER1__bindgen_ty_1,
    pub ShaderVisibility: D3D12_SHADER_VISIBILITY,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_ROOT_PARAMETER1__bindgen_ty_1 {
    pub DescriptorTable: D3D12_ROOT_DESCRIPTOR_TABLE1,
    pub Constants: D3D12_ROOT_CONSTANTS,
    pub Descriptor: D3D12_ROOT_DESCRIPTOR1,
}
impl Default for D3D12_ROOT_PARAMETER1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_PARAMETER1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_ROOT_PARAMETER1__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_ROOT_PARAMETER1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_PARAMETER1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_ROOT_PARAMETER1 {{ ParameterType: {:?}, __bindgen_anon_1: {:?}, ShaderVisibility: {:?} }}" , self . ParameterType , self . __bindgen_anon_1 , self . ShaderVisibility)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_ROOT_SIGNATURE_DESC1 {
    pub NumParameters: UINT,
    pub pParameters: *const D3D12_ROOT_PARAMETER1,
    pub NumStaticSamplers: UINT,
    pub pStaticSamplers: *const D3D12_STATIC_SAMPLER_DESC,
    pub Flags: D3D12_ROOT_SIGNATURE_FLAGS,
}
impl Default for D3D12_ROOT_SIGNATURE_DESC1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_VERSIONED_ROOT_SIGNATURE_DESC {
    pub Version: D3D_ROOT_SIGNATURE_VERSION,
    pub __bindgen_anon_1: D3D12_VERSIONED_ROOT_SIGNATURE_DESC__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_VERSIONED_ROOT_SIGNATURE_DESC__bindgen_ty_1 {
    pub Desc_1_0: D3D12_ROOT_SIGNATURE_DESC,
    pub Desc_1_1: D3D12_ROOT_SIGNATURE_DESC1,
}
impl Default for D3D12_VERSIONED_ROOT_SIGNATURE_DESC__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_VERSIONED_ROOT_SIGNATURE_DESC__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "D3D12_VERSIONED_ROOT_SIGNATURE_DESC__bindgen_ty_1 {{ union }}"
        )
    }
}
impl Default for D3D12_VERSIONED_ROOT_SIGNATURE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_VERSIONED_ROOT_SIGNATURE_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_VERSIONED_ROOT_SIGNATURE_DESC {{ Version: {:?}, __bindgen_anon_1: {:?} }}" , self . Version , self . __bindgen_anon_1)
    }
}
extern "C" {
    pub static IID_ID3D12RootSignatureDeserializer: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12RootSignatureDeserializerVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignatureDeserializer,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignatureDeserializer,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignatureDeserializer,
        ) -> ULONG,
    >,
    pub GetRootSignatureDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12RootSignatureDeserializer,
        ) -> *const D3D12_ROOT_SIGNATURE_DESC,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12RootSignatureDeserializer {
    pub lpVtbl: *mut ID3D12RootSignatureDeserializerVtbl,
}
impl Default for ID3D12RootSignatureDeserializer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12VersionedRootSignatureDeserializer: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12VersionedRootSignatureDeserializerVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VersionedRootSignatureDeserializer,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VersionedRootSignatureDeserializer,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VersionedRootSignatureDeserializer,
        ) -> ULONG,
    >,
    pub GetRootSignatureDescAtVersion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VersionedRootSignatureDeserializer,
            convertToVersion: D3D_ROOT_SIGNATURE_VERSION,
            ppDesc: *mut *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC,
        ) -> HRESULT,
    >,
    pub GetUnconvertedRootSignatureDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VersionedRootSignatureDeserializer,
        )
            -> *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12VersionedRootSignatureDeserializer {
    pub lpVtbl: *mut ID3D12VersionedRootSignatureDeserializerVtbl,
}
impl Default for ID3D12VersionedRootSignatureDeserializer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PFN_D3D12_SERIALIZE_ROOT_SIGNATURE = ::std::option::Option<
    unsafe extern "C" fn(
        pRootSignature: *const D3D12_ROOT_SIGNATURE_DESC,
        Version: D3D_ROOT_SIGNATURE_VERSION,
        ppBlob: *mut *mut ID3DBlob,
        ppErrorBlob: *mut *mut ID3DBlob,
    ) -> HRESULT,
>;
extern "C" {
    pub fn D3D12SerializeRootSignature(
        pRootSignature: *const D3D12_ROOT_SIGNATURE_DESC,
        Version: D3D_ROOT_SIGNATURE_VERSION,
        ppBlob: *mut *mut ID3DBlob,
        ppErrorBlob: *mut *mut ID3DBlob,
    ) -> HRESULT;
}
pub type PFN_D3D12_CREATE_ROOT_SIGNATURE_DESERIALIZER = ::std::option::Option<
    unsafe extern "C" fn(
        pSrcData: LPCVOID,
        SrcDataSizeInBytes: SIZE_T,
        pRootSignatureDeserializerInterface: *const IID,
        ppRootSignatureDeserializer: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT,
>;
extern "C" {
    pub fn D3D12CreateRootSignatureDeserializer(
        pSrcData: LPCVOID,
        SrcDataSizeInBytes: SIZE_T,
        pRootSignatureDeserializerInterface: *const IID,
        ppRootSignatureDeserializer: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT;
}
pub type PFN_D3D12_SERIALIZE_VERSIONED_ROOT_SIGNATURE = ::std::option::Option<
    unsafe extern "C" fn(
        pRootSignature: *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC,
        ppBlob: *mut *mut ID3DBlob,
        ppErrorBlob: *mut *mut ID3DBlob,
    ) -> HRESULT,
>;
extern "C" {
    pub fn D3D12SerializeVersionedRootSignature(
        pRootSignature: *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC,
        ppBlob: *mut *mut ID3DBlob,
        ppErrorBlob: *mut *mut ID3DBlob,
    ) -> HRESULT;
}
pub type PFN_D3D12_CREATE_VERSIONED_ROOT_SIGNATURE_DESERIALIZER =
    ::std::option::Option<
        unsafe extern "C" fn(
            pSrcData: LPCVOID,
            SrcDataSizeInBytes: SIZE_T,
            pRootSignatureDeserializerInterface: *const IID,
            ppRootSignatureDeserializer: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >;
extern "C" {
    pub fn D3D12CreateVersionedRootSignatureDeserializer(
        pSrcData: LPCVOID,
        SrcDataSizeInBytes: SIZE_T,
        pRootSignatureDeserializerInterface: *const IID,
        ppRootSignatureDeserializer: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_CPU_DESCRIPTOR_HANDLE {
    pub ptr: SIZE_T,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_GPU_DESCRIPTOR_HANDLE {
    pub ptr: UINT64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DISCARD_REGION {
    pub NumRects: UINT,
    pub pRects: *const D3D12_RECT,
    pub FirstSubresource: UINT,
    pub NumSubresources: UINT,
}
impl Default for D3D12_DISCARD_REGION {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_QUERY_HEAP_TYPE_D3D12_QUERY_HEAP_TYPE_OCCLUSION:
    D3D12_QUERY_HEAP_TYPE = 0;
pub const D3D12_QUERY_HEAP_TYPE_D3D12_QUERY_HEAP_TYPE_TIMESTAMP:
    D3D12_QUERY_HEAP_TYPE = 1;
pub const D3D12_QUERY_HEAP_TYPE_D3D12_QUERY_HEAP_TYPE_PIPELINE_STATISTICS:
    D3D12_QUERY_HEAP_TYPE = 2;
pub const D3D12_QUERY_HEAP_TYPE_D3D12_QUERY_HEAP_TYPE_SO_STATISTICS:
    D3D12_QUERY_HEAP_TYPE = 3;
pub const D3D12_QUERY_HEAP_TYPE_D3D12_QUERY_HEAP_TYPE_VIDEO_DECODE_STATISTICS : D3D12_QUERY_HEAP_TYPE = 4 ;
pub const D3D12_QUERY_HEAP_TYPE_D3D12_QUERY_HEAP_TYPE_COPY_QUEUE_TIMESTAMP:
    D3D12_QUERY_HEAP_TYPE = 5;
pub const D3D12_QUERY_HEAP_TYPE_D3D12_QUERY_HEAP_TYPE_PIPELINE_STATISTICS1:
    D3D12_QUERY_HEAP_TYPE = 7;
pub type D3D12_QUERY_HEAP_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_QUERY_HEAP_DESC {
    pub Type: D3D12_QUERY_HEAP_TYPE,
    pub Count: UINT,
    pub NodeMask: UINT,
}
impl Default for D3D12_QUERY_HEAP_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_OCCLUSION: D3D12_QUERY_TYPE = 0;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_BINARY_OCCLUSION: D3D12_QUERY_TYPE =
    1;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_TIMESTAMP: D3D12_QUERY_TYPE = 2;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_PIPELINE_STATISTICS:
    D3D12_QUERY_TYPE = 3;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_SO_STATISTICS_STREAM0:
    D3D12_QUERY_TYPE = 4;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_SO_STATISTICS_STREAM1:
    D3D12_QUERY_TYPE = 5;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_SO_STATISTICS_STREAM2:
    D3D12_QUERY_TYPE = 6;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_SO_STATISTICS_STREAM3:
    D3D12_QUERY_TYPE = 7;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_VIDEO_DECODE_STATISTICS:
    D3D12_QUERY_TYPE = 8;
pub const D3D12_QUERY_TYPE_D3D12_QUERY_TYPE_PIPELINE_STATISTICS1:
    D3D12_QUERY_TYPE = 10;
pub type D3D12_QUERY_TYPE = ::std::os::raw::c_int;
pub const D3D12_PREDICATION_OP_D3D12_PREDICATION_OP_EQUAL_ZERO:
    D3D12_PREDICATION_OP = 0;
pub const D3D12_PREDICATION_OP_D3D12_PREDICATION_OP_NOT_EQUAL_ZERO:
    D3D12_PREDICATION_OP = 1;
pub type D3D12_PREDICATION_OP = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_QUERY_DATA_PIPELINE_STATISTICS {
    pub IAVertices: UINT64,
    pub IAPrimitives: UINT64,
    pub VSInvocations: UINT64,
    pub GSInvocations: UINT64,
    pub GSPrimitives: UINT64,
    pub CInvocations: UINT64,
    pub CPrimitives: UINT64,
    pub PSInvocations: UINT64,
    pub HSInvocations: UINT64,
    pub DSInvocations: UINT64,
    pub CSInvocations: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_QUERY_DATA_PIPELINE_STATISTICS1 {
    pub IAVertices: UINT64,
    pub IAPrimitives: UINT64,
    pub VSInvocations: UINT64,
    pub GSInvocations: UINT64,
    pub GSPrimitives: UINT64,
    pub CInvocations: UINT64,
    pub CPrimitives: UINT64,
    pub PSInvocations: UINT64,
    pub HSInvocations: UINT64,
    pub DSInvocations: UINT64,
    pub CSInvocations: UINT64,
    pub ASInvocations: UINT64,
    pub MSInvocations: UINT64,
    pub MSPrimitives: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_QUERY_DATA_SO_STATISTICS {
    pub NumPrimitivesWritten: UINT64,
    pub PrimitivesStorageNeeded: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_STREAM_OUTPUT_BUFFER_VIEW {
    pub BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    pub SizeInBytes: UINT64,
    pub BufferFilledSizeLocation: D3D12_GPU_VIRTUAL_ADDRESS,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRAW_ARGUMENTS {
    pub VertexCountPerInstance: UINT,
    pub InstanceCount: UINT,
    pub StartVertexLocation: UINT,
    pub StartInstanceLocation: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRAW_INDEXED_ARGUMENTS {
    pub IndexCountPerInstance: UINT,
    pub InstanceCount: UINT,
    pub StartIndexLocation: UINT,
    pub BaseVertexLocation: INT,
    pub StartInstanceLocation: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DISPATCH_ARGUMENTS {
    pub ThreadGroupCountX: UINT,
    pub ThreadGroupCountY: UINT,
    pub ThreadGroupCountZ: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_VERTEX_BUFFER_VIEW {
    pub BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    pub SizeInBytes: UINT,
    pub StrideInBytes: UINT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INDEX_BUFFER_VIEW {
    pub BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    pub SizeInBytes: UINT,
    pub Format: DXGI_FORMAT,
}
impl Default for D3D12_INDEX_BUFFER_VIEW {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_DRAW:
    D3D12_INDIRECT_ARGUMENT_TYPE = 0;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_DRAW_INDEXED : D3D12_INDIRECT_ARGUMENT_TYPE = 1 ;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH:
    D3D12_INDIRECT_ARGUMENT_TYPE = 2;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_VERTEX_BUFFER_VIEW : D3D12_INDIRECT_ARGUMENT_TYPE = 3 ;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_INDEX_BUFFER_VIEW : D3D12_INDIRECT_ARGUMENT_TYPE = 4 ;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_CONSTANT:
    D3D12_INDIRECT_ARGUMENT_TYPE = 5;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_CONSTANT_BUFFER_VIEW : D3D12_INDIRECT_ARGUMENT_TYPE = 6 ;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_SHADER_RESOURCE_VIEW : D3D12_INDIRECT_ARGUMENT_TYPE = 7 ;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_UNORDERED_ACCESS_VIEW : D3D12_INDIRECT_ARGUMENT_TYPE = 8 ;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH_RAYS : D3D12_INDIRECT_ARGUMENT_TYPE = 9 ;
pub const D3D12_INDIRECT_ARGUMENT_TYPE_D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH_MESH : D3D12_INDIRECT_ARGUMENT_TYPE = 10 ;
pub type D3D12_INDIRECT_ARGUMENT_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC {
    pub Type: D3D12_INDIRECT_ARGUMENT_TYPE,
    pub __bindgen_anon_1: D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1 {
    pub VertexBuffer: D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_1,
    pub Constant: D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_2,
    pub ConstantBufferView:
        D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_3,
    pub ShaderResourceView:
        D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_4,
    pub UnorderedAccessView:
        D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_5,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_1 {
    pub Slot: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_2 {
    pub RootParameterIndex: UINT,
    pub DestOffsetIn32BitValues: UINT,
    pub Num32BitValuesToSet: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_3 {
    pub RootParameterIndex: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_4 {
    pub RootParameterIndex: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1__bindgen_ty_5 {
    pub RootParameterIndex: UINT,
}
impl Default for D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_INDIRECT_ARGUMENT_DESC__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_INDIRECT_ARGUMENT_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_INDIRECT_ARGUMENT_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_INDIRECT_ARGUMENT_DESC {{ Type: {:?}, __bindgen_anon_1: {:?} }}" , self . Type , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_COMMAND_SIGNATURE_DESC {
    pub ByteStride: UINT,
    pub NumArgumentDescs: UINT,
    pub pArgumentDescs: *const D3D12_INDIRECT_ARGUMENT_DESC,
    pub NodeMask: UINT,
}
impl Default for D3D12_COMMAND_SIGNATURE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Pageable: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12PageableVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Pageable,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Pageable) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Pageable) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Pageable,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Pageable,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Pageable,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Pageable,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Pageable,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Pageable {
    pub lpVtbl: *mut ID3D12PageableVtbl,
}
impl Default for ID3D12Pageable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Heap: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12HeapVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Heap) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Heap) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Heap, Name: LPCWSTR) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap,
            RetVal: *mut D3D12_HEAP_DESC,
        ) -> *mut D3D12_HEAP_DESC,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Heap {
    pub lpVtbl: *mut ID3D12HeapVtbl,
}
impl Default for ID3D12Heap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Resource: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ResourceVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Resource) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Resource) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub Map: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            Subresource: UINT,
            pReadRange: *const D3D12_RANGE,
            ppData: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub Unmap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            Subresource: UINT,
            pWrittenRange: *const D3D12_RANGE,
        ),
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            RetVal: *mut D3D12_RESOURCE_DESC,
        ) -> *mut D3D12_RESOURCE_DESC,
    >,
    pub GetGPUVirtualAddress: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
        ) -> D3D12_GPU_VIRTUAL_ADDRESS,
    >,
    pub WriteToSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            DstSubresource: UINT,
            pDstBox: *const D3D12_BOX,
            pSrcData: *const ::std::os::raw::c_void,
            SrcRowPitch: UINT,
            SrcDepthPitch: UINT,
        ) -> HRESULT,
    >,
    pub ReadFromSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            pDstData: *mut ::std::os::raw::c_void,
            DstRowPitch: UINT,
            DstDepthPitch: UINT,
            SrcSubresource: UINT,
            pSrcBox: *const D3D12_BOX,
        ) -> HRESULT,
    >,
    pub GetHeapProperties: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource,
            pHeapProperties: *mut D3D12_HEAP_PROPERTIES,
            pHeapFlags: *mut D3D12_HEAP_FLAGS,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Resource {
    pub lpVtbl: *mut ID3D12ResourceVtbl,
}
impl Default for ID3D12Resource {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12CommandAllocator: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12CommandAllocatorVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandAllocator,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12CommandAllocator) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12CommandAllocator) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandAllocator,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandAllocator,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandAllocator,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandAllocator,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandAllocator,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub Reset: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12CommandAllocator) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12CommandAllocator {
    pub lpVtbl: *mut ID3D12CommandAllocatorVtbl,
}
impl Default for ID3D12CommandAllocator {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Fence: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12FenceVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence, Name: LPCWSTR) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetCompletedValue: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence) -> UINT64,
    >,
    pub SetEventOnCompletion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence,
            Value: UINT64,
            hEvent: HANDLE,
        ) -> HRESULT,
    >,
    pub Signal: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence, Value: UINT64) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Fence {
    pub lpVtbl: *mut ID3D12FenceVtbl,
}
impl Default for ID3D12Fence {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Fence1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Fence1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence1) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence1,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence1,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence1,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence1, Name: LPCWSTR) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence1,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetCompletedValue: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence1) -> UINT64,
    >,
    pub SetEventOnCompletion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Fence1,
            Value: UINT64,
            hEvent: HANDLE,
        ) -> HRESULT,
    >,
    pub Signal: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence1, Value: UINT64) -> HRESULT,
    >,
    pub GetCreationFlags: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Fence1) -> D3D12_FENCE_FLAGS,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Fence1 {
    pub lpVtbl: *mut ID3D12Fence1Vtbl,
}
impl Default for ID3D12Fence1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12PipelineState: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12PipelineStateVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineState,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12PipelineState) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12PipelineState) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineState,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineState,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineState,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineState,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineState,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetCachedBlob: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineState,
            ppBlob: *mut *mut ID3DBlob,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12PipelineState {
    pub lpVtbl: *mut ID3D12PipelineStateVtbl,
}
impl Default for ID3D12PipelineState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DescriptorHeap: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DescriptorHeapVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DescriptorHeap) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DescriptorHeap) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            RetVal: *mut D3D12_DESCRIPTOR_HEAP_DESC,
        ) -> *mut D3D12_DESCRIPTOR_HEAP_DESC,
    >,
    pub GetCPUDescriptorHandleForHeapStart: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            RetVal: *mut D3D12_CPU_DESCRIPTOR_HANDLE,
        ) -> *mut D3D12_CPU_DESCRIPTOR_HANDLE,
    >,
    pub GetGPUDescriptorHandleForHeapStart: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DescriptorHeap,
            RetVal: *mut D3D12_GPU_DESCRIPTOR_HANDLE,
        ) -> *mut D3D12_GPU_DESCRIPTOR_HANDLE,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DescriptorHeap {
    pub lpVtbl: *mut ID3D12DescriptorHeapVtbl,
}
impl Default for ID3D12DescriptorHeap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12QueryHeap: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12QueryHeapVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12QueryHeap,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12QueryHeap) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12QueryHeap) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12QueryHeap,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12QueryHeap,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12QueryHeap,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12QueryHeap,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12QueryHeap,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12QueryHeap {
    pub lpVtbl: *mut ID3D12QueryHeapVtbl,
}
impl Default for ID3D12QueryHeap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12CommandSignature: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12CommandSignatureVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandSignature,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12CommandSignature) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12CommandSignature) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandSignature,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandSignature,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandSignature,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandSignature,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandSignature,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12CommandSignature {
    pub lpVtbl: *mut ID3D12CommandSignatureVtbl,
}
impl Default for ID3D12CommandSignature {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12CommandList: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12CommandListVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandList,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12CommandList) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12CommandList) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandList,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandList,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandList,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandList,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandList,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetType: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12CommandList,
        ) -> D3D12_COMMAND_LIST_TYPE,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12CommandList {
    pub lpVtbl: *mut ID3D12CommandListVtbl,
}
impl Default for ID3D12CommandList {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12GraphicsCommandList: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandListVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetType: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
        ) -> D3D12_COMMAND_LIST_TYPE,
    >,
    pub Close: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList) -> HRESULT,
    >,
    pub Reset: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
        ) -> HRESULT,
    >,
    pub ClearState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pPipelineState: *mut ID3D12PipelineState,
        ),
    >,
    pub DrawInstanced: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            VertexCountPerInstance: UINT,
            InstanceCount: UINT,
            StartVertexLocation: UINT,
            StartInstanceLocation: UINT,
        ),
    >,
    pub DrawIndexedInstanced: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            IndexCountPerInstance: UINT,
            InstanceCount: UINT,
            StartIndexLocation: UINT,
            BaseVertexLocation: INT,
            StartInstanceLocation: UINT,
        ),
    >,
    pub Dispatch: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            ThreadGroupCountX: UINT,
            ThreadGroupCountY: UINT,
            ThreadGroupCountZ: UINT,
        ),
    >,
    pub CopyBufferRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            NumBytes: UINT64,
        ),
    >,
    pub CopyTextureRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pDst: *const D3D12_TEXTURE_COPY_LOCATION,
            DstX: UINT,
            DstY: UINT,
            DstZ: UINT,
            pSrc: *const D3D12_TEXTURE_COPY_LOCATION,
            pSrcBox: *const D3D12_BOX,
        ),
    >,
    pub CopyResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pDstResource: *mut ID3D12Resource,
            pSrcResource: *mut ID3D12Resource,
        ),
    >,
    pub CopyTiles: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pTiledResource: *mut ID3D12Resource,
            pTileRegionStartCoordinate: *const D3D12_TILED_RESOURCE_COORDINATE,
            pTileRegionSize: *const D3D12_TILE_REGION_SIZE,
            pBuffer: *mut ID3D12Resource,
            BufferStartOffsetInBytes: UINT64,
            Flags: D3D12_TILE_COPY_FLAGS,
        ),
    >,
    pub ResolveSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pDstResource: *mut ID3D12Resource,
            DstSubresource: UINT,
            pSrcResource: *mut ID3D12Resource,
            SrcSubresource: UINT,
            Format: DXGI_FORMAT,
        ),
    >,
    pub IASetPrimitiveTopology: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            PrimitiveTopology: D3D12_PRIMITIVE_TOPOLOGY,
        ),
    >,
    pub RSSetViewports: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            NumViewports: UINT,
            pViewports: *const D3D12_VIEWPORT,
        ),
    >,
    pub RSSetScissorRects: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub OMSetBlendFactor: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            BlendFactor: *const FLOAT,
        ),
    >,
    pub OMSetStencilRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            StencilRef: UINT,
        ),
    >,
    pub SetPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pPipelineState: *mut ID3D12PipelineState,
        ),
    >,
    pub ResourceBarrier: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            NumBarriers: UINT,
            pBarriers: *const D3D12_RESOURCE_BARRIER,
        ),
    >,
    pub ExecuteBundle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pCommandList: *mut ID3D12GraphicsCommandList,
        ),
    >,
    pub SetDescriptorHeaps: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            NumDescriptorHeaps: UINT,
            ppDescriptorHeaps: *const *mut ID3D12DescriptorHeap,
        ),
    >,
    pub SetComputeRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pRootSignature: *mut ID3D12RootSignature,
        ),
    >,
    pub SetGraphicsRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pRootSignature: *mut ID3D12RootSignature,
        ),
    >,
    pub SetComputeRootDescriptorTable: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub SetGraphicsRootDescriptorTable: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub SetComputeRoot32BitConstant: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            SrcData: UINT,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetGraphicsRoot32BitConstant: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            SrcData: UINT,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetComputeRoot32BitConstants: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            Num32BitValuesToSet: UINT,
            pSrcData: *const ::std::os::raw::c_void,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetGraphicsRoot32BitConstants: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            Num32BitValuesToSet: UINT,
            pSrcData: *const ::std::os::raw::c_void,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetComputeRootConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetComputeRootShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetComputeRootUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub IASetIndexBuffer: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pView: *const D3D12_INDEX_BUFFER_VIEW,
        ),
    >,
    pub IASetVertexBuffers: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            StartSlot: UINT,
            NumViews: UINT,
            pViews: *const D3D12_VERTEX_BUFFER_VIEW,
        ),
    >,
    pub SOSetTargets: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            StartSlot: UINT,
            NumViews: UINT,
            pViews: *const D3D12_STREAM_OUTPUT_BUFFER_VIEW,
        ),
    >,
    pub OMSetRenderTargets: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            NumRenderTargetDescriptors: UINT,
            pRenderTargetDescriptors: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            RTsSingleHandleToDescriptorRange: BOOL,
            pDepthStencilDescriptor: *const D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub ClearDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            DepthStencilView: D3D12_CPU_DESCRIPTOR_HANDLE,
            ClearFlags: D3D12_CLEAR_FLAGS,
            Depth: FLOAT,
            Stencil: UINT8,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            RenderTargetView: D3D12_CPU_DESCRIPTOR_HANDLE,
            ColorRGBA: *const FLOAT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearUnorderedAccessViewUint: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
            ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
            pResource: *mut ID3D12Resource,
            Values: *const UINT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearUnorderedAccessViewFloat: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
            ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
            pResource: *mut ID3D12Resource,
            Values: *const FLOAT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub DiscardResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pResource: *mut ID3D12Resource,
            pRegion: *const D3D12_DISCARD_REGION,
        ),
    >,
    pub BeginQuery: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            Index: UINT,
        ),
    >,
    pub EndQuery: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            Index: UINT,
        ),
    >,
    pub ResolveQueryData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            StartIndex: UINT,
            NumQueries: UINT,
            pDestinationBuffer: *mut ID3D12Resource,
            AlignedDestinationBufferOffset: UINT64,
        ),
    >,
    pub SetPredication: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pBuffer: *mut ID3D12Resource,
            AlignedBufferOffset: UINT64,
            Operation: D3D12_PREDICATION_OP,
        ),
    >,
    pub SetMarker: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            Metadata: UINT,
            pData: *const ::std::os::raw::c_void,
            Size: UINT,
        ),
    >,
    pub BeginEvent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            Metadata: UINT,
            pData: *const ::std::os::raw::c_void,
            Size: UINT,
        ),
    >,
    pub EndEvent: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList),
    >,
    pub ExecuteIndirect: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList,
            pCommandSignature: *mut ID3D12CommandSignature,
            MaxCommandCount: UINT,
            pArgumentBuffer: *mut ID3D12Resource,
            ArgumentBufferOffset: UINT64,
            pCountBuffer: *mut ID3D12Resource,
            CountBufferOffset: UINT64,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList {
    pub lpVtbl: *mut ID3D12GraphicsCommandListVtbl,
}
impl Default for ID3D12GraphicsCommandList {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12GraphicsCommandList1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList1) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetType: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
        ) -> D3D12_COMMAND_LIST_TYPE,
    >,
    pub Close: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList1) -> HRESULT,
    >,
    pub Reset: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
        ) -> HRESULT,
    >,
    pub ClearState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pPipelineState: *mut ID3D12PipelineState,
        ),
    >,
    pub DrawInstanced: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            VertexCountPerInstance: UINT,
            InstanceCount: UINT,
            StartVertexLocation: UINT,
            StartInstanceLocation: UINT,
        ),
    >,
    pub DrawIndexedInstanced: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            IndexCountPerInstance: UINT,
            InstanceCount: UINT,
            StartIndexLocation: UINT,
            BaseVertexLocation: INT,
            StartInstanceLocation: UINT,
        ),
    >,
    pub Dispatch: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            ThreadGroupCountX: UINT,
            ThreadGroupCountY: UINT,
            ThreadGroupCountZ: UINT,
        ),
    >,
    pub CopyBufferRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            NumBytes: UINT64,
        ),
    >,
    pub CopyTextureRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pDst: *const D3D12_TEXTURE_COPY_LOCATION,
            DstX: UINT,
            DstY: UINT,
            DstZ: UINT,
            pSrc: *const D3D12_TEXTURE_COPY_LOCATION,
            pSrcBox: *const D3D12_BOX,
        ),
    >,
    pub CopyResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pDstResource: *mut ID3D12Resource,
            pSrcResource: *mut ID3D12Resource,
        ),
    >,
    pub CopyTiles: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pTiledResource: *mut ID3D12Resource,
            pTileRegionStartCoordinate: *const D3D12_TILED_RESOURCE_COORDINATE,
            pTileRegionSize: *const D3D12_TILE_REGION_SIZE,
            pBuffer: *mut ID3D12Resource,
            BufferStartOffsetInBytes: UINT64,
            Flags: D3D12_TILE_COPY_FLAGS,
        ),
    >,
    pub ResolveSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pDstResource: *mut ID3D12Resource,
            DstSubresource: UINT,
            pSrcResource: *mut ID3D12Resource,
            SrcSubresource: UINT,
            Format: DXGI_FORMAT,
        ),
    >,
    pub IASetPrimitiveTopology: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            PrimitiveTopology: D3D12_PRIMITIVE_TOPOLOGY,
        ),
    >,
    pub RSSetViewports: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            NumViewports: UINT,
            pViewports: *const D3D12_VIEWPORT,
        ),
    >,
    pub RSSetScissorRects: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub OMSetBlendFactor: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            BlendFactor: *const FLOAT,
        ),
    >,
    pub OMSetStencilRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            StencilRef: UINT,
        ),
    >,
    pub SetPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pPipelineState: *mut ID3D12PipelineState,
        ),
    >,
    pub ResourceBarrier: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            NumBarriers: UINT,
            pBarriers: *const D3D12_RESOURCE_BARRIER,
        ),
    >,
    pub ExecuteBundle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pCommandList: *mut ID3D12GraphicsCommandList,
        ),
    >,
    pub SetDescriptorHeaps: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            NumDescriptorHeaps: UINT,
            ppDescriptorHeaps: *const *mut ID3D12DescriptorHeap,
        ),
    >,
    pub SetComputeRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pRootSignature: *mut ID3D12RootSignature,
        ),
    >,
    pub SetGraphicsRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pRootSignature: *mut ID3D12RootSignature,
        ),
    >,
    pub SetComputeRootDescriptorTable: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub SetGraphicsRootDescriptorTable: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub SetComputeRoot32BitConstant: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            SrcData: UINT,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetGraphicsRoot32BitConstant: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            SrcData: UINT,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetComputeRoot32BitConstants: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            Num32BitValuesToSet: UINT,
            pSrcData: *const ::std::os::raw::c_void,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetGraphicsRoot32BitConstants: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            Num32BitValuesToSet: UINT,
            pSrcData: *const ::std::os::raw::c_void,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetComputeRootConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetComputeRootShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetComputeRootUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub IASetIndexBuffer: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pView: *const D3D12_INDEX_BUFFER_VIEW,
        ),
    >,
    pub IASetVertexBuffers: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            StartSlot: UINT,
            NumViews: UINT,
            pViews: *const D3D12_VERTEX_BUFFER_VIEW,
        ),
    >,
    pub SOSetTargets: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            StartSlot: UINT,
            NumViews: UINT,
            pViews: *const D3D12_STREAM_OUTPUT_BUFFER_VIEW,
        ),
    >,
    pub OMSetRenderTargets: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            NumRenderTargetDescriptors: UINT,
            pRenderTargetDescriptors: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            RTsSingleHandleToDescriptorRange: BOOL,
            pDepthStencilDescriptor: *const D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub ClearDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            DepthStencilView: D3D12_CPU_DESCRIPTOR_HANDLE,
            ClearFlags: D3D12_CLEAR_FLAGS,
            Depth: FLOAT,
            Stencil: UINT8,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            RenderTargetView: D3D12_CPU_DESCRIPTOR_HANDLE,
            ColorRGBA: *const FLOAT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearUnorderedAccessViewUint: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
            ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
            pResource: *mut ID3D12Resource,
            Values: *const UINT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearUnorderedAccessViewFloat: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
            ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
            pResource: *mut ID3D12Resource,
            Values: *const FLOAT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub DiscardResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pResource: *mut ID3D12Resource,
            pRegion: *const D3D12_DISCARD_REGION,
        ),
    >,
    pub BeginQuery: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            Index: UINT,
        ),
    >,
    pub EndQuery: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            Index: UINT,
        ),
    >,
    pub ResolveQueryData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            StartIndex: UINT,
            NumQueries: UINT,
            pDestinationBuffer: *mut ID3D12Resource,
            AlignedDestinationBufferOffset: UINT64,
        ),
    >,
    pub SetPredication: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pBuffer: *mut ID3D12Resource,
            AlignedBufferOffset: UINT64,
            Operation: D3D12_PREDICATION_OP,
        ),
    >,
    pub SetMarker: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            Metadata: UINT,
            pData: *const ::std::os::raw::c_void,
            Size: UINT,
        ),
    >,
    pub BeginEvent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            Metadata: UINT,
            pData: *const ::std::os::raw::c_void,
            Size: UINT,
        ),
    >,
    pub EndEvent: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList1),
    >,
    pub ExecuteIndirect: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pCommandSignature: *mut ID3D12CommandSignature,
            MaxCommandCount: UINT,
            pArgumentBuffer: *mut ID3D12Resource,
            ArgumentBufferOffset: UINT64,
            pCountBuffer: *mut ID3D12Resource,
            CountBufferOffset: UINT64,
        ),
    >,
    pub AtomicCopyBufferUINT: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            Dependencies: UINT,
            ppDependentResources: *const *mut ID3D12Resource,
            pDependentSubresourceRanges: *const D3D12_SUBRESOURCE_RANGE_UINT64,
        ),
    >,
    pub AtomicCopyBufferUINT64: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            Dependencies: UINT,
            ppDependentResources: *const *mut ID3D12Resource,
            pDependentSubresourceRanges: *const D3D12_SUBRESOURCE_RANGE_UINT64,
        ),
    >,
    pub OMSetDepthBounds: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            Min: FLOAT,
            Max: FLOAT,
        ),
    >,
    pub SetSamplePositions: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            NumSamplesPerPixel: UINT,
            NumPixels: UINT,
            pSamplePositions: *mut D3D12_SAMPLE_POSITION,
        ),
    >,
    pub ResolveSubresourceRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList1,
            pDstResource: *mut ID3D12Resource,
            DstSubresource: UINT,
            DstX: UINT,
            DstY: UINT,
            pSrcResource: *mut ID3D12Resource,
            SrcSubresource: UINT,
            pSrcRect: *mut D3D12_RECT,
            Format: DXGI_FORMAT,
            ResolveMode: D3D12_RESOLVE_MODE,
        ),
    >,
    pub SetViewInstanceMask: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList1, Mask: UINT),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList1 {
    pub lpVtbl: *mut ID3D12GraphicsCommandList1Vtbl,
}
impl Default for ID3D12GraphicsCommandList1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_WRITEBUFFERIMMEDIATE_PARAMETER {
    pub Dest: D3D12_GPU_VIRTUAL_ADDRESS,
    pub Value: UINT32,
}
pub const D3D12_WRITEBUFFERIMMEDIATE_MODE_D3D12_WRITEBUFFERIMMEDIATE_MODE_DEFAULT : D3D12_WRITEBUFFERIMMEDIATE_MODE = 0 ;
pub const D3D12_WRITEBUFFERIMMEDIATE_MODE_D3D12_WRITEBUFFERIMMEDIATE_MODE_MARKER_IN : D3D12_WRITEBUFFERIMMEDIATE_MODE = 1 ;
pub const D3D12_WRITEBUFFERIMMEDIATE_MODE_D3D12_WRITEBUFFERIMMEDIATE_MODE_MARKER_OUT : D3D12_WRITEBUFFERIMMEDIATE_MODE = 2 ;
pub type D3D12_WRITEBUFFERIMMEDIATE_MODE = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12GraphicsCommandList2: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList2Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList2) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList2) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetType: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
        ) -> D3D12_COMMAND_LIST_TYPE,
    >,
    pub Close: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList2) -> HRESULT,
    >,
    pub Reset: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
        ) -> HRESULT,
    >,
    pub ClearState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pPipelineState: *mut ID3D12PipelineState,
        ),
    >,
    pub DrawInstanced: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            VertexCountPerInstance: UINT,
            InstanceCount: UINT,
            StartVertexLocation: UINT,
            StartInstanceLocation: UINT,
        ),
    >,
    pub DrawIndexedInstanced: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            IndexCountPerInstance: UINT,
            InstanceCount: UINT,
            StartIndexLocation: UINT,
            BaseVertexLocation: INT,
            StartInstanceLocation: UINT,
        ),
    >,
    pub Dispatch: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            ThreadGroupCountX: UINT,
            ThreadGroupCountY: UINT,
            ThreadGroupCountZ: UINT,
        ),
    >,
    pub CopyBufferRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            NumBytes: UINT64,
        ),
    >,
    pub CopyTextureRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pDst: *const D3D12_TEXTURE_COPY_LOCATION,
            DstX: UINT,
            DstY: UINT,
            DstZ: UINT,
            pSrc: *const D3D12_TEXTURE_COPY_LOCATION,
            pSrcBox: *const D3D12_BOX,
        ),
    >,
    pub CopyResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pDstResource: *mut ID3D12Resource,
            pSrcResource: *mut ID3D12Resource,
        ),
    >,
    pub CopyTiles: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pTiledResource: *mut ID3D12Resource,
            pTileRegionStartCoordinate: *const D3D12_TILED_RESOURCE_COORDINATE,
            pTileRegionSize: *const D3D12_TILE_REGION_SIZE,
            pBuffer: *mut ID3D12Resource,
            BufferStartOffsetInBytes: UINT64,
            Flags: D3D12_TILE_COPY_FLAGS,
        ),
    >,
    pub ResolveSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pDstResource: *mut ID3D12Resource,
            DstSubresource: UINT,
            pSrcResource: *mut ID3D12Resource,
            SrcSubresource: UINT,
            Format: DXGI_FORMAT,
        ),
    >,
    pub IASetPrimitiveTopology: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            PrimitiveTopology: D3D12_PRIMITIVE_TOPOLOGY,
        ),
    >,
    pub RSSetViewports: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            NumViewports: UINT,
            pViewports: *const D3D12_VIEWPORT,
        ),
    >,
    pub RSSetScissorRects: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub OMSetBlendFactor: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            BlendFactor: *const FLOAT,
        ),
    >,
    pub OMSetStencilRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            StencilRef: UINT,
        ),
    >,
    pub SetPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pPipelineState: *mut ID3D12PipelineState,
        ),
    >,
    pub ResourceBarrier: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            NumBarriers: UINT,
            pBarriers: *const D3D12_RESOURCE_BARRIER,
        ),
    >,
    pub ExecuteBundle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pCommandList: *mut ID3D12GraphicsCommandList,
        ),
    >,
    pub SetDescriptorHeaps: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            NumDescriptorHeaps: UINT,
            ppDescriptorHeaps: *const *mut ID3D12DescriptorHeap,
        ),
    >,
    pub SetComputeRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pRootSignature: *mut ID3D12RootSignature,
        ),
    >,
    pub SetGraphicsRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pRootSignature: *mut ID3D12RootSignature,
        ),
    >,
    pub SetComputeRootDescriptorTable: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub SetGraphicsRootDescriptorTable: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub SetComputeRoot32BitConstant: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            SrcData: UINT,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetGraphicsRoot32BitConstant: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            SrcData: UINT,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetComputeRoot32BitConstants: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            Num32BitValuesToSet: UINT,
            pSrcData: *const ::std::os::raw::c_void,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetGraphicsRoot32BitConstants: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            Num32BitValuesToSet: UINT,
            pSrcData: *const ::std::os::raw::c_void,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetComputeRootConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetComputeRootShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetComputeRootUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub IASetIndexBuffer: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pView: *const D3D12_INDEX_BUFFER_VIEW,
        ),
    >,
    pub IASetVertexBuffers: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            StartSlot: UINT,
            NumViews: UINT,
            pViews: *const D3D12_VERTEX_BUFFER_VIEW,
        ),
    >,
    pub SOSetTargets: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            StartSlot: UINT,
            NumViews: UINT,
            pViews: *const D3D12_STREAM_OUTPUT_BUFFER_VIEW,
        ),
    >,
    pub OMSetRenderTargets: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            NumRenderTargetDescriptors: UINT,
            pRenderTargetDescriptors: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            RTsSingleHandleToDescriptorRange: BOOL,
            pDepthStencilDescriptor: *const D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub ClearDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            DepthStencilView: D3D12_CPU_DESCRIPTOR_HANDLE,
            ClearFlags: D3D12_CLEAR_FLAGS,
            Depth: FLOAT,
            Stencil: UINT8,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            RenderTargetView: D3D12_CPU_DESCRIPTOR_HANDLE,
            ColorRGBA: *const FLOAT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearUnorderedAccessViewUint: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
            ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
            pResource: *mut ID3D12Resource,
            Values: *const UINT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearUnorderedAccessViewFloat: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
            ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
            pResource: *mut ID3D12Resource,
            Values: *const FLOAT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub DiscardResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pResource: *mut ID3D12Resource,
            pRegion: *const D3D12_DISCARD_REGION,
        ),
    >,
    pub BeginQuery: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            Index: UINT,
        ),
    >,
    pub EndQuery: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            Index: UINT,
        ),
    >,
    pub ResolveQueryData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            StartIndex: UINT,
            NumQueries: UINT,
            pDestinationBuffer: *mut ID3D12Resource,
            AlignedDestinationBufferOffset: UINT64,
        ),
    >,
    pub SetPredication: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pBuffer: *mut ID3D12Resource,
            AlignedBufferOffset: UINT64,
            Operation: D3D12_PREDICATION_OP,
        ),
    >,
    pub SetMarker: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            Metadata: UINT,
            pData: *const ::std::os::raw::c_void,
            Size: UINT,
        ),
    >,
    pub BeginEvent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            Metadata: UINT,
            pData: *const ::std::os::raw::c_void,
            Size: UINT,
        ),
    >,
    pub EndEvent: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList2),
    >,
    pub ExecuteIndirect: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pCommandSignature: *mut ID3D12CommandSignature,
            MaxCommandCount: UINT,
            pArgumentBuffer: *mut ID3D12Resource,
            ArgumentBufferOffset: UINT64,
            pCountBuffer: *mut ID3D12Resource,
            CountBufferOffset: UINT64,
        ),
    >,
    pub AtomicCopyBufferUINT: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            Dependencies: UINT,
            ppDependentResources: *const *mut ID3D12Resource,
            pDependentSubresourceRanges: *const D3D12_SUBRESOURCE_RANGE_UINT64,
        ),
    >,
    pub AtomicCopyBufferUINT64: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            Dependencies: UINT,
            ppDependentResources: *const *mut ID3D12Resource,
            pDependentSubresourceRanges: *const D3D12_SUBRESOURCE_RANGE_UINT64,
        ),
    >,
    pub OMSetDepthBounds: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            Min: FLOAT,
            Max: FLOAT,
        ),
    >,
    pub SetSamplePositions: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            NumSamplesPerPixel: UINT,
            NumPixels: UINT,
            pSamplePositions: *mut D3D12_SAMPLE_POSITION,
        ),
    >,
    pub ResolveSubresourceRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            pDstResource: *mut ID3D12Resource,
            DstSubresource: UINT,
            DstX: UINT,
            DstY: UINT,
            pSrcResource: *mut ID3D12Resource,
            SrcSubresource: UINT,
            pSrcRect: *mut D3D12_RECT,
            Format: DXGI_FORMAT,
            ResolveMode: D3D12_RESOLVE_MODE,
        ),
    >,
    pub SetViewInstanceMask: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList2, Mask: UINT),
    >,
    pub WriteBufferImmediate: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList2,
            Count: UINT,
            pParams: *const D3D12_WRITEBUFFERIMMEDIATE_PARAMETER,
            pModes: *const D3D12_WRITEBUFFERIMMEDIATE_MODE,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList2 {
    pub lpVtbl: *mut ID3D12GraphicsCommandList2Vtbl,
}
impl Default for ID3D12GraphicsCommandList2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12CommandQueue: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12CommandQueueVtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , Name : LPCWSTR) -> HRESULT > , pub GetDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , riid : * const IID , ppvDevice : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub UpdateTileMappings : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , pResource : * mut ID3D12Resource , NumResourceRegions : UINT , pResourceRegionStartCoordinates : * const D3D12_TILED_RESOURCE_COORDINATE , pResourceRegionSizes : * const D3D12_TILE_REGION_SIZE , pHeap : * mut ID3D12Heap , NumRanges : UINT , pRangeFlags : * const D3D12_TILE_RANGE_FLAGS , pHeapRangeStartOffsets : * const UINT , pRangeTileCounts : * const UINT , Flags : D3D12_TILE_MAPPING_FLAGS) > , pub CopyTileMappings : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , pDstResource : * mut ID3D12Resource , pDstRegionStartCoordinate : * const D3D12_TILED_RESOURCE_COORDINATE , pSrcResource : * mut ID3D12Resource , pSrcRegionStartCoordinate : * const D3D12_TILED_RESOURCE_COORDINATE , pRegionSize : * const D3D12_TILE_REGION_SIZE , Flags : D3D12_TILE_MAPPING_FLAGS) > , pub ExecuteCommandLists : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , NumCommandLists : UINT , ppCommandLists : * const * mut ID3D12CommandList) > , pub SetMarker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub BeginEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub EndEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue) > , pub Signal : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , pFence : * mut ID3D12Fence , Value : UINT64) -> HRESULT > , pub Wait : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , pFence : * mut ID3D12Fence , Value : UINT64) -> HRESULT > , pub GetTimestampFrequency : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , pFrequency : * mut UINT64) -> HRESULT > , pub GetClockCalibration : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , pGpuTimestamp : * mut UINT64 , pCpuTimestamp : * mut UINT64) -> HRESULT > , pub GetDesc : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12CommandQueue , RetVal : * mut D3D12_COMMAND_QUEUE_DESC) -> * mut D3D12_COMMAND_QUEUE_DESC > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12CommandQueue {
    pub lpVtbl: *mut ID3D12CommandQueueVtbl,
}
impl Default for ID3D12CommandQueue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Device: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device, Name: LPCWSTR) -> HRESULT,
    >,
    pub GetNodeCount: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device) -> UINT,
    >,
    pub CreateCommandQueue: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_COMMAND_QUEUE_DESC,
            riid: *const IID,
            ppCommandQueue: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            type_: D3D12_COMMAND_LIST_TYPE,
            riid: *const IID,
            ppCommandAllocator: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateGraphicsPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateComputePipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandList: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            nodeMask: UINT,
            type_: D3D12_COMMAND_LIST_TYPE,
            pCommandAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
            riid: *const IID,
            ppCommandList: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CheckFeatureSupport: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            Feature: D3D12_FEATURE,
            pFeatureSupportData: *mut ::std::os::raw::c_void,
            FeatureSupportDataSize: UINT,
        ) -> HRESULT,
    >,
    pub CreateDescriptorHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDescriptorHeapDesc: *const D3D12_DESCRIPTOR_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDescriptorHandleIncrementSize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            DescriptorHeapType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ) -> UINT,
    >,
    pub CreateRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            nodeMask: UINT,
            pBlobWithRootSignature: *const ::std::os::raw::c_void,
            blobLengthInBytes: SIZE_T,
            riid: *const IID,
            ppvRootSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pResource: *mut ID3D12Resource,
            pCounterResource: *mut ID3D12Resource,
            pDesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_RENDER_TARGET_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateSampler: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_SAMPLER_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CopyDescriptors: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            NumDestDescriptorRanges: UINT,
            pDestDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pDestDescriptorRangeSizes: *const UINT,
            NumSrcDescriptorRanges: UINT,
            pSrcDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pSrcDescriptorRangeSizes: *const UINT,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub CopyDescriptorsSimple: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            NumDescriptors: UINT,
            DestDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            SrcDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub GetResourceAllocationInfo: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            RetVal: *mut D3D12_RESOURCE_ALLOCATION_INFO,
            visibleMask: UINT,
            numResourceDescs: UINT,
            pResourceDescs: *const D3D12_RESOURCE_DESC,
        ) -> *mut D3D12_RESOURCE_ALLOCATION_INFO,
    >,
    pub GetCustomHeapProperties: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            RetVal: *mut D3D12_HEAP_PROPERTIES,
            nodeMask: UINT,
            heapType: D3D12_HEAP_TYPE,
        ) -> *mut D3D12_HEAP_PROPERTIES,
    >,
    pub CreateCommittedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pHeapProperties: *const D3D12_HEAP_PROPERTIES,
            HeapFlags: D3D12_HEAP_FLAGS,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialResourceState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riidResource: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreatePlacedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pHeap: *mut ID3D12Heap,
            HeapOffset: UINT64,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateReservedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pObject: *mut ID3D12DeviceChild,
            pAttributes: *const SECURITY_ATTRIBUTES,
            Access: DWORD,
            Name: LPCWSTR,
            pHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub OpenSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            NTHandle: HANDLE,
            riid: *const IID,
            ppvObj: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenSharedHandleByName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            Name: LPCWSTR,
            Access: DWORD,
            pNTHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub MakeResident: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub Evict: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub CreateFence: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            InitialValue: UINT64,
            Flags: D3D12_FENCE_FLAGS,
            riid: *const IID,
            ppFence: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDeviceRemovedReason: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device) -> HRESULT,
    >,
    pub GetCopyableFootprints: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pResourceDesc: *const D3D12_RESOURCE_DESC,
            FirstSubresource: UINT,
            NumSubresources: UINT,
            BaseOffset: UINT64,
            pLayouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
            pNumRows: *mut UINT,
            pRowSizeInBytes: *mut UINT64,
            pTotalBytes: *mut UINT64,
        ),
    >,
    pub CreateQueryHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_QUERY_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetStablePowerState: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device, Enable: BOOL) -> HRESULT,
    >,
    pub CreateCommandSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pDesc: *const D3D12_COMMAND_SIGNATURE_DESC,
            pRootSignature: *mut ID3D12RootSignature,
            riid: *const IID,
            ppvCommandSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetResourceTiling: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            pTiledResource: *mut ID3D12Resource,
            pNumTilesForEntireResource: *mut UINT,
            pPackedMipDesc: *mut D3D12_PACKED_MIP_INFO,
            pStandardTileShapeForNonPackedMips: *mut D3D12_TILE_SHAPE,
            pNumSubresourceTilings: *mut UINT,
            FirstSubresourceTilingToGet: UINT,
            pSubresourceTilingsForNonPackedMips: *mut D3D12_SUBRESOURCE_TILING,
        ),
    >,
    pub GetAdapterLuid: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device,
            RetVal: *mut LUID,
        ) -> *mut LUID,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device {
    pub lpVtbl: *mut ID3D12DeviceVtbl,
}
impl Default for ID3D12Device {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12PipelineLibrary: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12PipelineLibraryVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12PipelineLibrary) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12PipelineLibrary) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub StorePipeline: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            pName: LPCWSTR,
            pPipeline: *mut ID3D12PipelineState,
        ) -> HRESULT,
    >,
    pub LoadGraphicsPipeline: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            pName: LPCWSTR,
            pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub LoadComputePipeline: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            pName: LPCWSTR,
            pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetSerializedSize: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12PipelineLibrary) -> SIZE_T,
    >,
    pub Serialize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary,
            pData: *mut ::std::os::raw::c_void,
            DataSizeInBytes: SIZE_T,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12PipelineLibrary {
    pub lpVtbl: *mut ID3D12PipelineLibraryVtbl,
}
impl Default for ID3D12PipelineLibrary {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12PipelineLibrary1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12PipelineLibrary1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12PipelineLibrary1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12PipelineLibrary1) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub StorePipeline: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            pName: LPCWSTR,
            pPipeline: *mut ID3D12PipelineState,
        ) -> HRESULT,
    >,
    pub LoadGraphicsPipeline: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            pName: LPCWSTR,
            pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub LoadComputePipeline: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            pName: LPCWSTR,
            pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetSerializedSize: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12PipelineLibrary1) -> SIZE_T,
    >,
    pub Serialize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            pData: *mut ::std::os::raw::c_void,
            DataSizeInBytes: SIZE_T,
        ) -> HRESULT,
    >,
    pub LoadPipeline: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12PipelineLibrary1,
            pName: LPCWSTR,
            pDesc: *const D3D12_PIPELINE_STATE_STREAM_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12PipelineLibrary1 {
    pub lpVtbl: *mut ID3D12PipelineLibrary1Vtbl,
}
impl Default for ID3D12PipelineLibrary1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_MULTIPLE_FENCE_WAIT_FLAGS_D3D12_MULTIPLE_FENCE_WAIT_FLAG_NONE : D3D12_MULTIPLE_FENCE_WAIT_FLAGS = 0 ;
pub const D3D12_MULTIPLE_FENCE_WAIT_FLAGS_D3D12_MULTIPLE_FENCE_WAIT_FLAG_ANY:
    D3D12_MULTIPLE_FENCE_WAIT_FLAGS = 1;
pub const D3D12_MULTIPLE_FENCE_WAIT_FLAGS_D3D12_MULTIPLE_FENCE_WAIT_FLAG_ALL:
    D3D12_MULTIPLE_FENCE_WAIT_FLAGS = 0;
pub type D3D12_MULTIPLE_FENCE_WAIT_FLAGS = ::std::os::raw::c_int;
pub const D3D12_RESIDENCY_PRIORITY_D3D12_RESIDENCY_PRIORITY_MINIMUM:
    D3D12_RESIDENCY_PRIORITY = 671088640;
pub const D3D12_RESIDENCY_PRIORITY_D3D12_RESIDENCY_PRIORITY_LOW:
    D3D12_RESIDENCY_PRIORITY = 1342177280;
pub const D3D12_RESIDENCY_PRIORITY_D3D12_RESIDENCY_PRIORITY_NORMAL:
    D3D12_RESIDENCY_PRIORITY = 2013265920;
pub const D3D12_RESIDENCY_PRIORITY_D3D12_RESIDENCY_PRIORITY_HIGH:
    D3D12_RESIDENCY_PRIORITY = -1610547200;
pub const D3D12_RESIDENCY_PRIORITY_D3D12_RESIDENCY_PRIORITY_MAXIMUM:
    D3D12_RESIDENCY_PRIORITY = -939524096;
pub type D3D12_RESIDENCY_PRIORITY = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12Device1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device1) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetNodeCount: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device1) -> UINT,
    >,
    pub CreateCommandQueue: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_COMMAND_QUEUE_DESC,
            riid: *const IID,
            ppCommandQueue: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            type_: D3D12_COMMAND_LIST_TYPE,
            riid: *const IID,
            ppCommandAllocator: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateGraphicsPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateComputePipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandList: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            nodeMask: UINT,
            type_: D3D12_COMMAND_LIST_TYPE,
            pCommandAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
            riid: *const IID,
            ppCommandList: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CheckFeatureSupport: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            Feature: D3D12_FEATURE,
            pFeatureSupportData: *mut ::std::os::raw::c_void,
            FeatureSupportDataSize: UINT,
        ) -> HRESULT,
    >,
    pub CreateDescriptorHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDescriptorHeapDesc: *const D3D12_DESCRIPTOR_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDescriptorHandleIncrementSize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            DescriptorHeapType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ) -> UINT,
    >,
    pub CreateRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            nodeMask: UINT,
            pBlobWithRootSignature: *const ::std::os::raw::c_void,
            blobLengthInBytes: SIZE_T,
            riid: *const IID,
            ppvRootSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pResource: *mut ID3D12Resource,
            pCounterResource: *mut ID3D12Resource,
            pDesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_RENDER_TARGET_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateSampler: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_SAMPLER_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CopyDescriptors: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            NumDestDescriptorRanges: UINT,
            pDestDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pDestDescriptorRangeSizes: *const UINT,
            NumSrcDescriptorRanges: UINT,
            pSrcDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pSrcDescriptorRangeSizes: *const UINT,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub CopyDescriptorsSimple: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            NumDescriptors: UINT,
            DestDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            SrcDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub GetResourceAllocationInfo: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            RetVal: *mut D3D12_RESOURCE_ALLOCATION_INFO,
            visibleMask: UINT,
            numResourceDescs: UINT,
            pResourceDescs: *const D3D12_RESOURCE_DESC,
        ) -> *mut D3D12_RESOURCE_ALLOCATION_INFO,
    >,
    pub GetCustomHeapProperties: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            RetVal: *mut D3D12_HEAP_PROPERTIES,
            nodeMask: UINT,
            heapType: D3D12_HEAP_TYPE,
        ) -> *mut D3D12_HEAP_PROPERTIES,
    >,
    pub CreateCommittedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pHeapProperties: *const D3D12_HEAP_PROPERTIES,
            HeapFlags: D3D12_HEAP_FLAGS,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialResourceState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riidResource: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreatePlacedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pHeap: *mut ID3D12Heap,
            HeapOffset: UINT64,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateReservedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pObject: *mut ID3D12DeviceChild,
            pAttributes: *const SECURITY_ATTRIBUTES,
            Access: DWORD,
            Name: LPCWSTR,
            pHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub OpenSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            NTHandle: HANDLE,
            riid: *const IID,
            ppvObj: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenSharedHandleByName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            Name: LPCWSTR,
            Access: DWORD,
            pNTHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub MakeResident: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub Evict: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub CreateFence: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            InitialValue: UINT64,
            Flags: D3D12_FENCE_FLAGS,
            riid: *const IID,
            ppFence: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDeviceRemovedReason: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device1) -> HRESULT,
    >,
    pub GetCopyableFootprints: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pResourceDesc: *const D3D12_RESOURCE_DESC,
            FirstSubresource: UINT,
            NumSubresources: UINT,
            BaseOffset: UINT64,
            pLayouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
            pNumRows: *mut UINT,
            pRowSizeInBytes: *mut UINT64,
            pTotalBytes: *mut UINT64,
        ),
    >,
    pub CreateQueryHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_QUERY_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetStablePowerState: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device1, Enable: BOOL) -> HRESULT,
    >,
    pub CreateCommandSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pDesc: *const D3D12_COMMAND_SIGNATURE_DESC,
            pRootSignature: *mut ID3D12RootSignature,
            riid: *const IID,
            ppvCommandSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetResourceTiling: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pTiledResource: *mut ID3D12Resource,
            pNumTilesForEntireResource: *mut UINT,
            pPackedMipDesc: *mut D3D12_PACKED_MIP_INFO,
            pStandardTileShapeForNonPackedMips: *mut D3D12_TILE_SHAPE,
            pNumSubresourceTilings: *mut UINT,
            FirstSubresourceTilingToGet: UINT,
            pSubresourceTilingsForNonPackedMips: *mut D3D12_SUBRESOURCE_TILING,
        ),
    >,
    pub GetAdapterLuid: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            RetVal: *mut LUID,
        ) -> *mut LUID,
    >,
    pub CreatePipelineLibrary: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            pLibraryBlob: *const ::std::os::raw::c_void,
            BlobLength: SIZE_T,
            riid: *const IID,
            ppPipelineLibrary: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetEventOnMultipleFenceCompletion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            ppFences: *const *mut ID3D12Fence,
            pFenceValues: *const UINT64,
            NumFences: UINT,
            Flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS,
            hEvent: HANDLE,
        ) -> HRESULT,
    >,
    pub SetResidencyPriority: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device1,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
            pPriorities: *const D3D12_RESIDENCY_PRIORITY,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device1 {
    pub lpVtbl: *mut ID3D12Device1Vtbl,
}
impl Default for ID3D12Device1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Device2: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device2Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device2) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device2) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetNodeCount: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device2) -> UINT,
    >,
    pub CreateCommandQueue: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_COMMAND_QUEUE_DESC,
            riid: *const IID,
            ppCommandQueue: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            type_: D3D12_COMMAND_LIST_TYPE,
            riid: *const IID,
            ppCommandAllocator: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateGraphicsPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateComputePipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandList: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            nodeMask: UINT,
            type_: D3D12_COMMAND_LIST_TYPE,
            pCommandAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
            riid: *const IID,
            ppCommandList: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CheckFeatureSupport: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            Feature: D3D12_FEATURE,
            pFeatureSupportData: *mut ::std::os::raw::c_void,
            FeatureSupportDataSize: UINT,
        ) -> HRESULT,
    >,
    pub CreateDescriptorHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDescriptorHeapDesc: *const D3D12_DESCRIPTOR_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDescriptorHandleIncrementSize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            DescriptorHeapType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ) -> UINT,
    >,
    pub CreateRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            nodeMask: UINT,
            pBlobWithRootSignature: *const ::std::os::raw::c_void,
            blobLengthInBytes: SIZE_T,
            riid: *const IID,
            ppvRootSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pResource: *mut ID3D12Resource,
            pCounterResource: *mut ID3D12Resource,
            pDesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_RENDER_TARGET_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateSampler: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_SAMPLER_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CopyDescriptors: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            NumDestDescriptorRanges: UINT,
            pDestDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pDestDescriptorRangeSizes: *const UINT,
            NumSrcDescriptorRanges: UINT,
            pSrcDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pSrcDescriptorRangeSizes: *const UINT,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub CopyDescriptorsSimple: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            NumDescriptors: UINT,
            DestDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            SrcDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub GetResourceAllocationInfo: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            RetVal: *mut D3D12_RESOURCE_ALLOCATION_INFO,
            visibleMask: UINT,
            numResourceDescs: UINT,
            pResourceDescs: *const D3D12_RESOURCE_DESC,
        ) -> *mut D3D12_RESOURCE_ALLOCATION_INFO,
    >,
    pub GetCustomHeapProperties: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            RetVal: *mut D3D12_HEAP_PROPERTIES,
            nodeMask: UINT,
            heapType: D3D12_HEAP_TYPE,
        ) -> *mut D3D12_HEAP_PROPERTIES,
    >,
    pub CreateCommittedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pHeapProperties: *const D3D12_HEAP_PROPERTIES,
            HeapFlags: D3D12_HEAP_FLAGS,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialResourceState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riidResource: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreatePlacedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pHeap: *mut ID3D12Heap,
            HeapOffset: UINT64,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateReservedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pObject: *mut ID3D12DeviceChild,
            pAttributes: *const SECURITY_ATTRIBUTES,
            Access: DWORD,
            Name: LPCWSTR,
            pHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub OpenSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            NTHandle: HANDLE,
            riid: *const IID,
            ppvObj: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenSharedHandleByName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            Name: LPCWSTR,
            Access: DWORD,
            pNTHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub MakeResident: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub Evict: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub CreateFence: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            InitialValue: UINT64,
            Flags: D3D12_FENCE_FLAGS,
            riid: *const IID,
            ppFence: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDeviceRemovedReason: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device2) -> HRESULT,
    >,
    pub GetCopyableFootprints: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pResourceDesc: *const D3D12_RESOURCE_DESC,
            FirstSubresource: UINT,
            NumSubresources: UINT,
            BaseOffset: UINT64,
            pLayouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
            pNumRows: *mut UINT,
            pRowSizeInBytes: *mut UINT64,
            pTotalBytes: *mut UINT64,
        ),
    >,
    pub CreateQueryHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_QUERY_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetStablePowerState: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device2, Enable: BOOL) -> HRESULT,
    >,
    pub CreateCommandSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_COMMAND_SIGNATURE_DESC,
            pRootSignature: *mut ID3D12RootSignature,
            riid: *const IID,
            ppvCommandSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetResourceTiling: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pTiledResource: *mut ID3D12Resource,
            pNumTilesForEntireResource: *mut UINT,
            pPackedMipDesc: *mut D3D12_PACKED_MIP_INFO,
            pStandardTileShapeForNonPackedMips: *mut D3D12_TILE_SHAPE,
            pNumSubresourceTilings: *mut UINT,
            FirstSubresourceTilingToGet: UINT,
            pSubresourceTilingsForNonPackedMips: *mut D3D12_SUBRESOURCE_TILING,
        ),
    >,
    pub GetAdapterLuid: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            RetVal: *mut LUID,
        ) -> *mut LUID,
    >,
    pub CreatePipelineLibrary: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pLibraryBlob: *const ::std::os::raw::c_void,
            BlobLength: SIZE_T,
            riid: *const IID,
            ppPipelineLibrary: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetEventOnMultipleFenceCompletion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            ppFences: *const *mut ID3D12Fence,
            pFenceValues: *const UINT64,
            NumFences: UINT,
            Flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS,
            hEvent: HANDLE,
        ) -> HRESULT,
    >,
    pub SetResidencyPriority: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
            pPriorities: *const D3D12_RESIDENCY_PRIORITY,
        ) -> HRESULT,
    >,
    pub CreatePipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device2,
            pDesc: *const D3D12_PIPELINE_STATE_STREAM_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device2 {
    pub lpVtbl: *mut ID3D12Device2Vtbl,
}
impl Default for ID3D12Device2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_RESIDENCY_FLAGS_D3D12_RESIDENCY_FLAG_NONE:
    D3D12_RESIDENCY_FLAGS = 0;
pub const D3D12_RESIDENCY_FLAGS_D3D12_RESIDENCY_FLAG_DENY_OVERBUDGET:
    D3D12_RESIDENCY_FLAGS = 1;
pub type D3D12_RESIDENCY_FLAGS = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12Device3: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device3Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device3) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device3) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetNodeCount: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device3) -> UINT,
    >,
    pub CreateCommandQueue: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_COMMAND_QUEUE_DESC,
            riid: *const IID,
            ppCommandQueue: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            type_: D3D12_COMMAND_LIST_TYPE,
            riid: *const IID,
            ppCommandAllocator: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateGraphicsPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateComputePipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandList: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            nodeMask: UINT,
            type_: D3D12_COMMAND_LIST_TYPE,
            pCommandAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
            riid: *const IID,
            ppCommandList: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CheckFeatureSupport: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            Feature: D3D12_FEATURE,
            pFeatureSupportData: *mut ::std::os::raw::c_void,
            FeatureSupportDataSize: UINT,
        ) -> HRESULT,
    >,
    pub CreateDescriptorHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDescriptorHeapDesc: *const D3D12_DESCRIPTOR_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDescriptorHandleIncrementSize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            DescriptorHeapType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ) -> UINT,
    >,
    pub CreateRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            nodeMask: UINT,
            pBlobWithRootSignature: *const ::std::os::raw::c_void,
            blobLengthInBytes: SIZE_T,
            riid: *const IID,
            ppvRootSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pResource: *mut ID3D12Resource,
            pCounterResource: *mut ID3D12Resource,
            pDesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_RENDER_TARGET_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateSampler: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_SAMPLER_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CopyDescriptors: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            NumDestDescriptorRanges: UINT,
            pDestDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pDestDescriptorRangeSizes: *const UINT,
            NumSrcDescriptorRanges: UINT,
            pSrcDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pSrcDescriptorRangeSizes: *const UINT,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub CopyDescriptorsSimple: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            NumDescriptors: UINT,
            DestDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            SrcDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub GetResourceAllocationInfo: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            RetVal: *mut D3D12_RESOURCE_ALLOCATION_INFO,
            visibleMask: UINT,
            numResourceDescs: UINT,
            pResourceDescs: *const D3D12_RESOURCE_DESC,
        ) -> *mut D3D12_RESOURCE_ALLOCATION_INFO,
    >,
    pub GetCustomHeapProperties: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            RetVal: *mut D3D12_HEAP_PROPERTIES,
            nodeMask: UINT,
            heapType: D3D12_HEAP_TYPE,
        ) -> *mut D3D12_HEAP_PROPERTIES,
    >,
    pub CreateCommittedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pHeapProperties: *const D3D12_HEAP_PROPERTIES,
            HeapFlags: D3D12_HEAP_FLAGS,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialResourceState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riidResource: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreatePlacedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pHeap: *mut ID3D12Heap,
            HeapOffset: UINT64,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateReservedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pObject: *mut ID3D12DeviceChild,
            pAttributes: *const SECURITY_ATTRIBUTES,
            Access: DWORD,
            Name: LPCWSTR,
            pHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub OpenSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            NTHandle: HANDLE,
            riid: *const IID,
            ppvObj: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenSharedHandleByName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            Name: LPCWSTR,
            Access: DWORD,
            pNTHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub MakeResident: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub Evict: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub CreateFence: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            InitialValue: UINT64,
            Flags: D3D12_FENCE_FLAGS,
            riid: *const IID,
            ppFence: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDeviceRemovedReason: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device3) -> HRESULT,
    >,
    pub GetCopyableFootprints: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pResourceDesc: *const D3D12_RESOURCE_DESC,
            FirstSubresource: UINT,
            NumSubresources: UINT,
            BaseOffset: UINT64,
            pLayouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
            pNumRows: *mut UINT,
            pRowSizeInBytes: *mut UINT64,
            pTotalBytes: *mut UINT64,
        ),
    >,
    pub CreateQueryHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_QUERY_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetStablePowerState: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device3, Enable: BOOL) -> HRESULT,
    >,
    pub CreateCommandSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_COMMAND_SIGNATURE_DESC,
            pRootSignature: *mut ID3D12RootSignature,
            riid: *const IID,
            ppvCommandSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetResourceTiling: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pTiledResource: *mut ID3D12Resource,
            pNumTilesForEntireResource: *mut UINT,
            pPackedMipDesc: *mut D3D12_PACKED_MIP_INFO,
            pStandardTileShapeForNonPackedMips: *mut D3D12_TILE_SHAPE,
            pNumSubresourceTilings: *mut UINT,
            FirstSubresourceTilingToGet: UINT,
            pSubresourceTilingsForNonPackedMips: *mut D3D12_SUBRESOURCE_TILING,
        ),
    >,
    pub GetAdapterLuid: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            RetVal: *mut LUID,
        ) -> *mut LUID,
    >,
    pub CreatePipelineLibrary: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pLibraryBlob: *const ::std::os::raw::c_void,
            BlobLength: SIZE_T,
            riid: *const IID,
            ppPipelineLibrary: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetEventOnMultipleFenceCompletion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            ppFences: *const *mut ID3D12Fence,
            pFenceValues: *const UINT64,
            NumFences: UINT,
            Flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS,
            hEvent: HANDLE,
        ) -> HRESULT,
    >,
    pub SetResidencyPriority: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
            pPriorities: *const D3D12_RESIDENCY_PRIORITY,
        ) -> HRESULT,
    >,
    pub CreatePipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pDesc: *const D3D12_PIPELINE_STATE_STREAM_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenExistingHeapFromAddress: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            pAddress: *const ::std::os::raw::c_void,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenExistingHeapFromFileMapping: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            hFileMapping: HANDLE,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub EnqueueMakeResident: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device3,
            Flags: D3D12_RESIDENCY_FLAGS,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
            pFenceToSignal: *mut ID3D12Fence,
            FenceValueToSignal: UINT64,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device3 {
    pub lpVtbl: *mut ID3D12Device3Vtbl,
}
impl Default for ID3D12Device3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_COMMAND_LIST_FLAGS_D3D12_COMMAND_LIST_FLAG_NONE:
    D3D12_COMMAND_LIST_FLAGS = 0;
pub type D3D12_COMMAND_LIST_FLAGS = ::std::os::raw::c_int;
pub const D3D12_COMMAND_POOL_FLAGS_D3D12_COMMAND_POOL_FLAG_NONE:
    D3D12_COMMAND_POOL_FLAGS = 0;
pub type D3D12_COMMAND_POOL_FLAGS = ::std::os::raw::c_int;
pub const D3D12_COMMAND_RECORDER_FLAGS_D3D12_COMMAND_RECORDER_FLAG_NONE:
    D3D12_COMMAND_RECORDER_FLAGS = 0;
pub type D3D12_COMMAND_RECORDER_FLAGS = ::std::os::raw::c_int;
pub const D3D12_PROTECTED_SESSION_STATUS_D3D12_PROTECTED_SESSION_STATUS_OK:
    D3D12_PROTECTED_SESSION_STATUS = 0;
pub const D3D12_PROTECTED_SESSION_STATUS_D3D12_PROTECTED_SESSION_STATUS_INVALID : D3D12_PROTECTED_SESSION_STATUS = 1 ;
pub type D3D12_PROTECTED_SESSION_STATUS = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12ProtectedSession: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ProtectedSessionVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedSession,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12ProtectedSession) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12ProtectedSession) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedSession,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedSession,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedSession,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedSession,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedSession,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetStatusFence: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedSession,
            riid: *const IID,
            ppFence: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetSessionStatus: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedSession,
        ) -> D3D12_PROTECTED_SESSION_STATUS,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ProtectedSession {
    pub lpVtbl: *mut ID3D12ProtectedSessionVtbl,
}
impl Default for ID3D12ProtectedSession {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS_D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAG_NONE : D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS = 0 ;
pub const D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS_D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAG_SUPPORTED : D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS = 1 ;
pub type D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {
    pub NodeIndex: UINT,
    pub Support: D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS,
}
impl Default for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_PROTECTED_RESOURCE_SESSION_FLAGS_D3D12_PROTECTED_RESOURCE_SESSION_FLAG_NONE : D3D12_PROTECTED_RESOURCE_SESSION_FLAGS = 0 ;
pub type D3D12_PROTECTED_RESOURCE_SESSION_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_PROTECTED_RESOURCE_SESSION_DESC {
    pub NodeMask: UINT,
    pub Flags: D3D12_PROTECTED_RESOURCE_SESSION_FLAGS,
}
impl Default for D3D12_PROTECTED_RESOURCE_SESSION_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12ProtectedResourceSession: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ProtectedResourceSessionVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
        ) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetStatusFence: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
            riid: *const IID,
            ppFence: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetSessionStatus: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
        ) -> D3D12_PROTECTED_SESSION_STATUS,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession,
            RetVal: *mut D3D12_PROTECTED_RESOURCE_SESSION_DESC,
        )
            -> *mut D3D12_PROTECTED_RESOURCE_SESSION_DESC,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ProtectedResourceSession {
    pub lpVtbl: *mut ID3D12ProtectedResourceSessionVtbl,
}
impl Default for ID3D12ProtectedResourceSession {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Device4: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device4Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device4) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device4) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetNodeCount: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device4) -> UINT,
    >,
    pub CreateCommandQueue: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_COMMAND_QUEUE_DESC,
            riid: *const IID,
            ppCommandQueue: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandAllocator: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            type_: D3D12_COMMAND_LIST_TYPE,
            riid: *const IID,
            ppCommandAllocator: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateGraphicsPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateComputePipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommandList: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            nodeMask: UINT,
            type_: D3D12_COMMAND_LIST_TYPE,
            pCommandAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
            riid: *const IID,
            ppCommandList: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CheckFeatureSupport: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            Feature: D3D12_FEATURE,
            pFeatureSupportData: *mut ::std::os::raw::c_void,
            FeatureSupportDataSize: UINT,
        ) -> HRESULT,
    >,
    pub CreateDescriptorHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDescriptorHeapDesc: *const D3D12_DESCRIPTOR_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDescriptorHandleIncrementSize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            DescriptorHeapType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ) -> UINT,
    >,
    pub CreateRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            nodeMask: UINT,
            pBlobWithRootSignature: *const ::std::os::raw::c_void,
            blobLengthInBytes: SIZE_T,
            riid: *const IID,
            ppvRootSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pResource: *mut ID3D12Resource,
            pCounterResource: *mut ID3D12Resource,
            pDesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_RENDER_TARGET_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pResource: *mut ID3D12Resource,
            pDesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CreateSampler: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_SAMPLER_DESC,
            DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub CopyDescriptors: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            NumDestDescriptorRanges: UINT,
            pDestDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pDestDescriptorRangeSizes: *const UINT,
            NumSrcDescriptorRanges: UINT,
            pSrcDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            pSrcDescriptorRangeSizes: *const UINT,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub CopyDescriptorsSimple: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            NumDescriptors: UINT,
            DestDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            SrcDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
            DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
        ),
    >,
    pub GetResourceAllocationInfo: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            RetVal: *mut D3D12_RESOURCE_ALLOCATION_INFO,
            visibleMask: UINT,
            numResourceDescs: UINT,
            pResourceDescs: *const D3D12_RESOURCE_DESC,
        ) -> *mut D3D12_RESOURCE_ALLOCATION_INFO,
    >,
    pub GetCustomHeapProperties: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            RetVal: *mut D3D12_HEAP_PROPERTIES,
            nodeMask: UINT,
            heapType: D3D12_HEAP_TYPE,
        ) -> *mut D3D12_HEAP_PROPERTIES,
    >,
    pub CreateCommittedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pHeapProperties: *const D3D12_HEAP_PROPERTIES,
            HeapFlags: D3D12_HEAP_FLAGS,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialResourceState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riidResource: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreatePlacedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pHeap: *mut ID3D12Heap,
            HeapOffset: UINT64,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateReservedResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pObject: *mut ID3D12DeviceChild,
            pAttributes: *const SECURITY_ATTRIBUTES,
            Access: DWORD,
            Name: LPCWSTR,
            pHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub OpenSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            NTHandle: HANDLE,
            riid: *const IID,
            ppvObj: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenSharedHandleByName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            Name: LPCWSTR,
            Access: DWORD,
            pNTHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub MakeResident: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub Evict: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
        ) -> HRESULT,
    >,
    pub CreateFence: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            InitialValue: UINT64,
            Flags: D3D12_FENCE_FLAGS,
            riid: *const IID,
            ppFence: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDeviceRemovedReason: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device4) -> HRESULT,
    >,
    pub GetCopyableFootprints: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pResourceDesc: *const D3D12_RESOURCE_DESC,
            FirstSubresource: UINT,
            NumSubresources: UINT,
            BaseOffset: UINT64,
            pLayouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
            pNumRows: *mut UINT,
            pRowSizeInBytes: *mut UINT64,
            pTotalBytes: *mut UINT64,
        ),
    >,
    pub CreateQueryHeap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_QUERY_HEAP_DESC,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetStablePowerState: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Device4, Enable: BOOL) -> HRESULT,
    >,
    pub CreateCommandSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_COMMAND_SIGNATURE_DESC,
            pRootSignature: *mut ID3D12RootSignature,
            riid: *const IID,
            ppvCommandSignature: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetResourceTiling: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pTiledResource: *mut ID3D12Resource,
            pNumTilesForEntireResource: *mut UINT,
            pPackedMipDesc: *mut D3D12_PACKED_MIP_INFO,
            pStandardTileShapeForNonPackedMips: *mut D3D12_TILE_SHAPE,
            pNumSubresourceTilings: *mut UINT,
            FirstSubresourceTilingToGet: UINT,
            pSubresourceTilingsForNonPackedMips: *mut D3D12_SUBRESOURCE_TILING,
        ),
    >,
    pub GetAdapterLuid: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            RetVal: *mut LUID,
        ) -> *mut LUID,
    >,
    pub CreatePipelineLibrary: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pLibraryBlob: *const ::std::os::raw::c_void,
            BlobLength: SIZE_T,
            riid: *const IID,
            ppPipelineLibrary: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetEventOnMultipleFenceCompletion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            ppFences: *const *mut ID3D12Fence,
            pFenceValues: *const UINT64,
            NumFences: UINT,
            Flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS,
            hEvent: HANDLE,
        ) -> HRESULT,
    >,
    pub SetResidencyPriority: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
            pPriorities: *const D3D12_RESIDENCY_PRIORITY,
        ) -> HRESULT,
    >,
    pub CreatePipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_PIPELINE_STATE_STREAM_DESC,
            riid: *const IID,
            ppPipelineState: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenExistingHeapFromAddress: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pAddress: *const ::std::os::raw::c_void,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub OpenExistingHeapFromFileMapping: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            hFileMapping: HANDLE,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub EnqueueMakeResident: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            Flags: D3D12_RESIDENCY_FLAGS,
            NumObjects: UINT,
            ppObjects: *const *mut ID3D12Pageable,
            pFenceToSignal: *mut ID3D12Fence,
            FenceValueToSignal: UINT64,
        ) -> HRESULT,
    >,
    pub CreateCommandList1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            nodeMask: UINT,
            type_: D3D12_COMMAND_LIST_TYPE,
            flags: D3D12_COMMAND_LIST_FLAGS,
            riid: *const IID,
            ppCommandList: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateProtectedResourceSession: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_PROTECTED_RESOURCE_SESSION_DESC,
            riid: *const IID,
            ppSession: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateCommittedResource1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pHeapProperties: *const D3D12_HEAP_PROPERTIES,
            HeapFlags: D3D12_HEAP_FLAGS,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialResourceState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            pProtectedSession: *mut ID3D12ProtectedResourceSession,
            riidResource: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateHeap1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_HEAP_DESC,
            pProtectedSession: *mut ID3D12ProtectedResourceSession,
            riid: *const IID,
            ppvHeap: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub CreateReservedResource1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            pDesc: *const D3D12_RESOURCE_DESC,
            InitialState: D3D12_RESOURCE_STATES,
            pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
            pProtectedSession: *mut ID3D12ProtectedResourceSession,
            riid: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetResourceAllocationInfo1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Device4,
            RetVal: *mut D3D12_RESOURCE_ALLOCATION_INFO,
            visibleMask: UINT,
            numResourceDescs: UINT,
            pResourceDescs: *const D3D12_RESOURCE_DESC,
            pResourceAllocationInfo1: *mut D3D12_RESOURCE_ALLOCATION_INFO1,
        ) -> *mut D3D12_RESOURCE_ALLOCATION_INFO,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device4 {
    pub lpVtbl: *mut ID3D12Device4Vtbl,
}
impl Default for ID3D12Device4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_LIFETIME_STATE_D3D12_LIFETIME_STATE_IN_USE:
    D3D12_LIFETIME_STATE = 0;
pub const D3D12_LIFETIME_STATE_D3D12_LIFETIME_STATE_NOT_IN_USE:
    D3D12_LIFETIME_STATE = 1;
pub type D3D12_LIFETIME_STATE = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12LifetimeOwner: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12LifetimeOwnerVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeOwner,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12LifetimeOwner) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12LifetimeOwner) -> ULONG,
    >,
    pub LifetimeStateUpdated: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeOwner,
            NewState: D3D12_LIFETIME_STATE,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12LifetimeOwner {
    pub lpVtbl: *mut ID3D12LifetimeOwnerVtbl,
}
impl Default for ID3D12LifetimeOwner {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12SwapChainAssistant: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12SwapChainAssistantVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SwapChainAssistant,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12SwapChainAssistant) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12SwapChainAssistant) -> ULONG,
    >,
    pub GetLUID: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SwapChainAssistant,
            RetVal: *mut LUID,
        ) -> *mut LUID,
    >,
    pub GetSwapChainObject: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SwapChainAssistant,
            riid: *const IID,
            ppv: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetCurrentResourceAndCommandQueue: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SwapChainAssistant,
            riidResource: *const IID,
            ppvResource: *mut *mut ::std::os::raw::c_void,
            riidQueue: *const IID,
            ppvQueue: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub InsertImplicitSync: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12SwapChainAssistant) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12SwapChainAssistant {
    pub lpVtbl: *mut ID3D12SwapChainAssistantVtbl,
}
impl Default for ID3D12SwapChainAssistant {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12LifetimeTracker: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12LifetimeTrackerVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeTracker,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12LifetimeTracker) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12LifetimeTracker) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeTracker,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeTracker,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeTracker,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeTracker,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeTracker,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub DestroyOwnedObject: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12LifetimeTracker,
            pObject: *mut ID3D12DeviceChild,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12LifetimeTracker {
    pub lpVtbl: *mut ID3D12LifetimeTrackerVtbl,
}
impl Default for ID3D12LifetimeTracker {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_META_COMMAND_PARAMETER_TYPE_D3D12_META_COMMAND_PARAMETER_TYPE_FLOAT : D3D12_META_COMMAND_PARAMETER_TYPE = 0 ;
pub const D3D12_META_COMMAND_PARAMETER_TYPE_D3D12_META_COMMAND_PARAMETER_TYPE_UINT64 : D3D12_META_COMMAND_PARAMETER_TYPE = 1 ;
pub const D3D12_META_COMMAND_PARAMETER_TYPE_D3D12_META_COMMAND_PARAMETER_TYPE_GPU_VIRTUAL_ADDRESS : D3D12_META_COMMAND_PARAMETER_TYPE = 2 ;
pub const D3D12_META_COMMAND_PARAMETER_TYPE_D3D12_META_COMMAND_PARAMETER_TYPE_CPU_DESCRIPTOR_HANDLE_HEAP_TYPE_CBV_SRV_UAV : D3D12_META_COMMAND_PARAMETER_TYPE = 3 ;
pub const D3D12_META_COMMAND_PARAMETER_TYPE_D3D12_META_COMMAND_PARAMETER_TYPE_GPU_DESCRIPTOR_HANDLE_HEAP_TYPE_CBV_SRV_UAV : D3D12_META_COMMAND_PARAMETER_TYPE = 4 ;
pub type D3D12_META_COMMAND_PARAMETER_TYPE = ::std::os::raw::c_int;
pub const D3D12_META_COMMAND_PARAMETER_FLAGS_D3D12_META_COMMAND_PARAMETER_FLAG_INPUT : D3D12_META_COMMAND_PARAMETER_FLAGS = 1 ;
pub const D3D12_META_COMMAND_PARAMETER_FLAGS_D3D12_META_COMMAND_PARAMETER_FLAG_OUTPUT : D3D12_META_COMMAND_PARAMETER_FLAGS = 2 ;
pub type D3D12_META_COMMAND_PARAMETER_FLAGS = ::std::os::raw::c_int;
pub const D3D12_META_COMMAND_PARAMETER_STAGE_D3D12_META_COMMAND_PARAMETER_STAGE_CREATION : D3D12_META_COMMAND_PARAMETER_STAGE = 0 ;
pub const D3D12_META_COMMAND_PARAMETER_STAGE_D3D12_META_COMMAND_PARAMETER_STAGE_INITIALIZATION : D3D12_META_COMMAND_PARAMETER_STAGE = 1 ;
pub const D3D12_META_COMMAND_PARAMETER_STAGE_D3D12_META_COMMAND_PARAMETER_STAGE_EXECUTION : D3D12_META_COMMAND_PARAMETER_STAGE = 2 ;
pub type D3D12_META_COMMAND_PARAMETER_STAGE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_META_COMMAND_PARAMETER_DESC {
    pub Name: LPCWSTR,
    pub Type: D3D12_META_COMMAND_PARAMETER_TYPE,
    pub Flags: D3D12_META_COMMAND_PARAMETER_FLAGS,
    pub RequiredResourceState: D3D12_RESOURCE_STATES,
    pub StructureOffset: UINT,
}
impl Default for D3D12_META_COMMAND_PARAMETER_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_NONE:
    D3D12_GRAPHICS_STATES = 0;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_IA_VERTEX_BUFFERS:
    D3D12_GRAPHICS_STATES = 1;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_IA_INDEX_BUFFER:
    D3D12_GRAPHICS_STATES = 2;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_IA_PRIMITIVE_TOPOLOGY:
    D3D12_GRAPHICS_STATES = 4;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_DESCRIPTOR_HEAP:
    D3D12_GRAPHICS_STATES = 8;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_GRAPHICS_ROOT_SIGNATURE:
    D3D12_GRAPHICS_STATES = 16;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_COMPUTE_ROOT_SIGNATURE:
    D3D12_GRAPHICS_STATES = 32;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_RS_VIEWPORTS:
    D3D12_GRAPHICS_STATES = 64;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_RS_SCISSOR_RECTS:
    D3D12_GRAPHICS_STATES = 128;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_PREDICATION:
    D3D12_GRAPHICS_STATES = 256;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_OM_RENDER_TARGETS:
    D3D12_GRAPHICS_STATES = 512;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_OM_STENCIL_REF:
    D3D12_GRAPHICS_STATES = 1024;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_OM_BLEND_FACTOR:
    D3D12_GRAPHICS_STATES = 2048;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_PIPELINE_STATE:
    D3D12_GRAPHICS_STATES = 4096;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_SO_TARGETS:
    D3D12_GRAPHICS_STATES = 8192;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_OM_DEPTH_BOUNDS:
    D3D12_GRAPHICS_STATES = 16384;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_SAMPLE_POSITIONS:
    D3D12_GRAPHICS_STATES = 32768;
pub const D3D12_GRAPHICS_STATES_D3D12_GRAPHICS_STATE_VIEW_INSTANCE_MASK:
    D3D12_GRAPHICS_STATES = 65536;
pub type D3D12_GRAPHICS_STATES = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_META_COMMAND_DESC {
    pub Id: GUID,
    pub Name: LPCWSTR,
    pub InitializationDirtyState: D3D12_GRAPHICS_STATES,
    pub ExecutionDirtyState: D3D12_GRAPHICS_STATES,
}
impl Default for D3D12_META_COMMAND_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12StateObject: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12StateObjectVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObject,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12StateObject) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12StateObject) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObject,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObject,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObject,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObject,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObject,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12StateObject {
    pub lpVtbl: *mut ID3D12StateObjectVtbl,
}
impl Default for ID3D12StateObject {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12StateObjectProperties: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12StateObjectPropertiesVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObjectProperties,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12StateObjectProperties) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12StateObjectProperties) -> ULONG,
    >,
    pub GetShaderIdentifier: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObjectProperties,
            pExportName: LPCWSTR,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub GetShaderStackSize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObjectProperties,
            pExportName: LPCWSTR,
        ) -> UINT64,
    >,
    pub GetPipelineStackSize: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12StateObjectProperties) -> UINT64,
    >,
    pub SetPipelineStackSize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12StateObjectProperties,
            PipelineStackSizeInBytes: UINT64,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12StateObjectProperties {
    pub lpVtbl: *mut ID3D12StateObjectPropertiesVtbl,
}
impl Default for ID3D12StateObjectProperties {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_STATE_OBJECT_CONFIG : D3D12_STATE_SUBOBJECT_TYPE = 0 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_GLOBAL_ROOT_SIGNATURE : D3D12_STATE_SUBOBJECT_TYPE = 1 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_LOCAL_ROOT_SIGNATURE : D3D12_STATE_SUBOBJECT_TYPE = 2 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_NODE_MASK:
    D3D12_STATE_SUBOBJECT_TYPE = 3;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_DXIL_LIBRARY:
    D3D12_STATE_SUBOBJECT_TYPE = 5;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_EXISTING_COLLECTION : D3D12_STATE_SUBOBJECT_TYPE = 6 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_SUBOBJECT_TO_EXPORTS_ASSOCIATION : D3D12_STATE_SUBOBJECT_TYPE = 7 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION : D3D12_STATE_SUBOBJECT_TYPE = 8 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_SHADER_CONFIG : D3D12_STATE_SUBOBJECT_TYPE = 9 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_PIPELINE_CONFIG : D3D12_STATE_SUBOBJECT_TYPE = 10 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_HIT_GROUP:
    D3D12_STATE_SUBOBJECT_TYPE = 11;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_PIPELINE_CONFIG1 : D3D12_STATE_SUBOBJECT_TYPE = 12 ;
pub const D3D12_STATE_SUBOBJECT_TYPE_D3D12_STATE_SUBOBJECT_TYPE_MAX_VALID:
    D3D12_STATE_SUBOBJECT_TYPE = 13;
pub type D3D12_STATE_SUBOBJECT_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_STATE_SUBOBJECT {
    pub Type: D3D12_STATE_SUBOBJECT_TYPE,
    pub pDesc: *const ::std::os::raw::c_void,
}
impl Default for D3D12_STATE_SUBOBJECT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_STATE_OBJECT_FLAGS_D3D12_STATE_OBJECT_FLAG_NONE:
    D3D12_STATE_OBJECT_FLAGS = 0;
pub const D3D12_STATE_OBJECT_FLAGS_D3D12_STATE_OBJECT_FLAG_ALLOW_LOCAL_DEPENDENCIES_ON_EXTERNAL_DEFINITIONS : D3D12_STATE_OBJECT_FLAGS = 1 ;
pub const D3D12_STATE_OBJECT_FLAGS_D3D12_STATE_OBJECT_FLAG_ALLOW_EXTERNAL_DEPENDENCIES_ON_LOCAL_DEFINITIONS : D3D12_STATE_OBJECT_FLAGS = 2 ;
pub const D3D12_STATE_OBJECT_FLAGS_D3D12_STATE_OBJECT_FLAG_ALLOW_STATE_OBJECT_ADDITIONS : D3D12_STATE_OBJECT_FLAGS = 4 ;
pub type D3D12_STATE_OBJECT_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_STATE_OBJECT_CONFIG {
    pub Flags: D3D12_STATE_OBJECT_FLAGS,
}
impl Default for D3D12_STATE_OBJECT_CONFIG {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_GLOBAL_ROOT_SIGNATURE {
    pub pGlobalRootSignature: *mut ID3D12RootSignature,
}
impl Default for D3D12_GLOBAL_ROOT_SIGNATURE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_LOCAL_ROOT_SIGNATURE {
    pub pLocalRootSignature: *mut ID3D12RootSignature,
}
impl Default for D3D12_LOCAL_ROOT_SIGNATURE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_NODE_MASK {
    pub NodeMask: UINT,
}
pub const D3D12_EXPORT_FLAGS_D3D12_EXPORT_FLAG_NONE: D3D12_EXPORT_FLAGS = 0;
pub type D3D12_EXPORT_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_EXPORT_DESC {
    pub Name: LPCWSTR,
    pub ExportToRename: LPCWSTR,
    pub Flags: D3D12_EXPORT_FLAGS,
}
impl Default for D3D12_EXPORT_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DXIL_LIBRARY_DESC {
    pub DXILLibrary: D3D12_SHADER_BYTECODE,
    pub NumExports: UINT,
    pub pExports: *mut D3D12_EXPORT_DESC,
}
impl Default for D3D12_DXIL_LIBRARY_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_EXISTING_COLLECTION_DESC {
    pub pExistingCollection: *mut ID3D12StateObject,
    pub NumExports: UINT,
    pub pExports: *mut D3D12_EXPORT_DESC,
}
impl Default for D3D12_EXISTING_COLLECTION_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    pub pSubobjectToAssociate: *const D3D12_STATE_SUBOBJECT,
    pub NumExports: UINT,
    pub pExports: *mut LPCWSTR,
}
impl Default for D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    pub SubobjectToAssociate: LPCWSTR,
    pub NumExports: UINT,
    pub pExports: *mut LPCWSTR,
}
impl Default for D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_HIT_GROUP_TYPE_D3D12_HIT_GROUP_TYPE_TRIANGLES:
    D3D12_HIT_GROUP_TYPE = 0;
pub const D3D12_HIT_GROUP_TYPE_D3D12_HIT_GROUP_TYPE_PROCEDURAL_PRIMITIVE:
    D3D12_HIT_GROUP_TYPE = 1;
pub type D3D12_HIT_GROUP_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_HIT_GROUP_DESC {
    pub HitGroupExport: LPCWSTR,
    pub Type: D3D12_HIT_GROUP_TYPE,
    pub AnyHitShaderImport: LPCWSTR,
    pub ClosestHitShaderImport: LPCWSTR,
    pub IntersectionShaderImport: LPCWSTR,
}
impl Default for D3D12_HIT_GROUP_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_SHADER_CONFIG {
    pub MaxPayloadSizeInBytes: UINT,
    pub MaxAttributeSizeInBytes: UINT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_PIPELINE_CONFIG {
    pub MaxTraceRecursionDepth: UINT,
}
pub const D3D12_RAYTRACING_PIPELINE_FLAGS_D3D12_RAYTRACING_PIPELINE_FLAG_NONE : D3D12_RAYTRACING_PIPELINE_FLAGS = 0 ;
pub const D3D12_RAYTRACING_PIPELINE_FLAGS_D3D12_RAYTRACING_PIPELINE_FLAG_SKIP_TRIANGLES : D3D12_RAYTRACING_PIPELINE_FLAGS = 256 ;
pub const D3D12_RAYTRACING_PIPELINE_FLAGS_D3D12_RAYTRACING_PIPELINE_FLAG_SKIP_PROCEDURAL_PRIMITIVES : D3D12_RAYTRACING_PIPELINE_FLAGS = 512 ;
pub type D3D12_RAYTRACING_PIPELINE_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_PIPELINE_CONFIG1 {
    pub MaxTraceRecursionDepth: UINT,
    pub Flags: D3D12_RAYTRACING_PIPELINE_FLAGS,
}
impl Default for D3D12_RAYTRACING_PIPELINE_CONFIG1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_STATE_OBJECT_TYPE_D3D12_STATE_OBJECT_TYPE_COLLECTION:
    D3D12_STATE_OBJECT_TYPE = 0;
pub const D3D12_STATE_OBJECT_TYPE_D3D12_STATE_OBJECT_TYPE_RAYTRACING_PIPELINE : D3D12_STATE_OBJECT_TYPE = 3 ;
pub type D3D12_STATE_OBJECT_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_STATE_OBJECT_DESC {
    pub Type: D3D12_STATE_OBJECT_TYPE,
    pub NumSubobjects: UINT,
    pub pSubobjects: *const D3D12_STATE_SUBOBJECT,
}
impl Default for D3D12_STATE_OBJECT_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_RAYTRACING_GEOMETRY_FLAGS_D3D12_RAYTRACING_GEOMETRY_FLAG_NONE : D3D12_RAYTRACING_GEOMETRY_FLAGS = 0 ;
pub const D3D12_RAYTRACING_GEOMETRY_FLAGS_D3D12_RAYTRACING_GEOMETRY_FLAG_OPAQUE : D3D12_RAYTRACING_GEOMETRY_FLAGS = 1 ;
pub const D3D12_RAYTRACING_GEOMETRY_FLAGS_D3D12_RAYTRACING_GEOMETRY_FLAG_NO_DUPLICATE_ANYHIT_INVOCATION : D3D12_RAYTRACING_GEOMETRY_FLAGS = 2 ;
pub type D3D12_RAYTRACING_GEOMETRY_FLAGS = ::std::os::raw::c_int;
pub const D3D12_RAYTRACING_GEOMETRY_TYPE_D3D12_RAYTRACING_GEOMETRY_TYPE_TRIANGLES : D3D12_RAYTRACING_GEOMETRY_TYPE = 0 ;
pub const D3D12_RAYTRACING_GEOMETRY_TYPE_D3D12_RAYTRACING_GEOMETRY_TYPE_PROCEDURAL_PRIMITIVE_AABBS : D3D12_RAYTRACING_GEOMETRY_TYPE = 1 ;
pub type D3D12_RAYTRACING_GEOMETRY_TYPE = ::std::os::raw::c_int;
pub const D3D12_RAYTRACING_INSTANCE_FLAGS_D3D12_RAYTRACING_INSTANCE_FLAG_NONE : D3D12_RAYTRACING_INSTANCE_FLAGS = 0 ;
pub const D3D12_RAYTRACING_INSTANCE_FLAGS_D3D12_RAYTRACING_INSTANCE_FLAG_TRIANGLE_CULL_DISABLE : D3D12_RAYTRACING_INSTANCE_FLAGS = 1 ;
pub const D3D12_RAYTRACING_INSTANCE_FLAGS_D3D12_RAYTRACING_INSTANCE_FLAG_TRIANGLE_FRONT_COUNTERCLOCKWISE : D3D12_RAYTRACING_INSTANCE_FLAGS = 2 ;
pub const D3D12_RAYTRACING_INSTANCE_FLAGS_D3D12_RAYTRACING_INSTANCE_FLAG_FORCE_OPAQUE : D3D12_RAYTRACING_INSTANCE_FLAGS = 4 ;
pub const D3D12_RAYTRACING_INSTANCE_FLAGS_D3D12_RAYTRACING_INSTANCE_FLAG_FORCE_NON_OPAQUE : D3D12_RAYTRACING_INSTANCE_FLAGS = 8 ;
pub type D3D12_RAYTRACING_INSTANCE_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE {
    pub StartAddress: D3D12_GPU_VIRTUAL_ADDRESS,
    pub StrideInBytes: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_GPU_VIRTUAL_ADDRESS_RANGE {
    pub StartAddress: D3D12_GPU_VIRTUAL_ADDRESS,
    pub SizeInBytes: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE {
    pub StartAddress: D3D12_GPU_VIRTUAL_ADDRESS,
    pub SizeInBytes: UINT64,
    pub StrideInBytes: UINT64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {
    pub Transform3x4: D3D12_GPU_VIRTUAL_ADDRESS,
    pub IndexFormat: DXGI_FORMAT,
    pub VertexFormat: DXGI_FORMAT,
    pub IndexCount: UINT,
    pub VertexCount: UINT,
    pub IndexBuffer: D3D12_GPU_VIRTUAL_ADDRESS,
    pub VertexBuffer: D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE,
}
impl Default for D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_RAYTRACING_AABB {
    pub MinX: FLOAT,
    pub MinY: FLOAT,
    pub MinZ: FLOAT,
    pub MaxX: FLOAT,
    pub MaxY: FLOAT,
    pub MaxZ: FLOAT,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_GEOMETRY_AABBS_DESC {
    pub AABBCount: UINT64,
    pub AABBs: D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE,
}
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_NONE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = 0 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_ALLOW_UPDATE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = 1 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_ALLOW_COMPACTION : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = 2 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PREFER_FAST_TRACE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = 4 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PREFER_FAST_BUILD : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = 8 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_MINIMIZE_MEMORY : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = 16 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PERFORM_UPDATE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = 32 ;
pub type D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS =
    ::std::os::raw::c_int;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_CLONE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = 0 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_COMPACT : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = 1 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_VISUALIZATION_DECODE_FOR_TOOLS : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = 2 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_SERIALIZE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = 3 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_DESERIALIZE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = 4 ;
pub type D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE =
    ::std::os::raw::c_int;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE = 0 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE = 1 ;
pub type D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE = ::std::os::raw::c_int;
pub const D3D12_ELEMENTS_LAYOUT_D3D12_ELEMENTS_LAYOUT_ARRAY:
    D3D12_ELEMENTS_LAYOUT = 0;
pub const D3D12_ELEMENTS_LAYOUT_D3D12_ELEMENTS_LAYOUT_ARRAY_OF_POINTERS:
    D3D12_ELEMENTS_LAYOUT = 1;
pub type D3D12_ELEMENTS_LAYOUT = ::std::os::raw::c_int;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE = 0 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE = 1 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE = 2 ;
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE_D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE = 3 ;
pub type D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE =
    ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {
    pub DestBuffer: D3D12_GPU_VIRTUAL_ADDRESS,
    pub InfoType: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE,
}
impl Default for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC
{
    pub CompactedSizeInBytes: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC
{
    pub DecodedSizeInBytes: UINT64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER
{
    pub Type: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE,
    pub NumDescs: UINT,
}
impl Default
    for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER
{
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC
{
    pub SerializedSizeInBytes: UINT64,
    pub NumBottomLevelAccelerationStructurePointers: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER {
    pub DriverOpaqueGUID: GUID,
    pub DriverOpaqueVersioningData: [BYTE; 16usize],
}
pub const D3D12_SERIALIZED_DATA_TYPE_D3D12_SERIALIZED_DATA_RAYTRACING_ACCELERATION_STRUCTURE : D3D12_SERIALIZED_DATA_TYPE = 0 ;
pub type D3D12_SERIALIZED_DATA_TYPE = ::std::os::raw::c_int;
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS_D3D12_DRIVER_MATCHING_IDENTIFIER_COMPATIBLE_WITH_DEVICE : D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = 0 ;
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS_D3D12_DRIVER_MATCHING_IDENTIFIER_UNSUPPORTED_TYPE : D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = 1 ;
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS_D3D12_DRIVER_MATCHING_IDENTIFIER_UNRECOGNIZED : D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = 2 ;
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS_D3D12_DRIVER_MATCHING_IDENTIFIER_INCOMPATIBLE_VERSION : D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = 3 ;
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS_D3D12_DRIVER_MATCHING_IDENTIFIER_INCOMPATIBLE_TYPE : D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = 4 ;
pub type D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER {
    pub DriverMatchingIdentifier:
        D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER,
    pub SerializedSizeInBytesIncludingHeader: UINT64,
    pub DeserializedSizeInBytes: UINT64,
    pub NumBottomLevelAccelerationStructurePointersAfterHeader: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC
{
    pub CurrentSizeInBytes: UINT64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_RAYTRACING_INSTANCE_DESC {
    pub Transform: [[FLOAT; 4usize]; 3usize],
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub AccelerationStructure: D3D12_GPU_VIRTUAL_ADDRESS,
}
impl D3D12_RAYTRACING_INSTANCE_DESC {
    #[inline]
    pub fn InstanceID(&self) -> UINT {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32)
        }
    }
    #[inline]
    pub fn set_InstanceID(&mut self, val: UINT) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn InstanceMask(&self) -> UINT {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32)
        }
    }
    #[inline]
    pub fn set_InstanceMask(&mut self, val: UINT) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn InstanceContributionToHitGroupIndex(&self) -> UINT {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(32usize, 24u8) as u32)
        }
    }
    #[inline]
    pub fn set_InstanceContributionToHitGroupIndex(&mut self, val: UINT) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn Flags(&self) -> UINT {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(56usize, 8u8) as u32)
        }
    }
    #[inline]
    pub fn set_Flags(&mut self, val: UINT) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        InstanceID: UINT,
        InstanceMask: UINT,
        InstanceContributionToHitGroupIndex: UINT,
        Flags: UINT,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let InstanceID: u32 = unsafe { ::std::mem::transmute(InstanceID) };
            InstanceID as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let InstanceMask: u32 =
                unsafe { ::std::mem::transmute(InstanceMask) };
            InstanceMask as u64
        });
        __bindgen_bitfield_unit.set(32usize, 24u8, {
            let InstanceContributionToHitGroupIndex: u32 = unsafe {
                ::std::mem::transmute(InstanceContributionToHitGroupIndex)
            };
            InstanceContributionToHitGroupIndex as u64
        });
        __bindgen_bitfield_unit.set(56usize, 8u8, {
            let Flags: u32 = unsafe { ::std::mem::transmute(Flags) };
            Flags as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_RAYTRACING_GEOMETRY_DESC {
    pub Type: D3D12_RAYTRACING_GEOMETRY_TYPE,
    pub Flags: D3D12_RAYTRACING_GEOMETRY_FLAGS,
    pub __bindgen_anon_1: D3D12_RAYTRACING_GEOMETRY_DESC__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_RAYTRACING_GEOMETRY_DESC__bindgen_ty_1 {
    pub Triangles: D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC,
    pub AABBs: D3D12_RAYTRACING_GEOMETRY_AABBS_DESC,
}
impl Default for D3D12_RAYTRACING_GEOMETRY_DESC__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_GEOMETRY_DESC__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "D3D12_RAYTRACING_GEOMETRY_DESC__bindgen_ty_1 {{ union }}"
        )
    }
}
impl Default for D3D12_RAYTRACING_GEOMETRY_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_GEOMETRY_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_RAYTRACING_GEOMETRY_DESC {{ Type: {:?}, Flags: {:?}, __bindgen_anon_1: {:?} }}" , self . Type , self . Flags , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {
    pub Type: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE,
    pub Flags: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS,
    pub NumDescs: UINT,
    pub DescsLayout: D3D12_ELEMENTS_LAYOUT,
    pub __bindgen_anon_1:
        D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS__bindgen_ty_1 {
    pub InstanceDescs: D3D12_GPU_VIRTUAL_ADDRESS,
    pub pGeometryDescs: *const D3D12_RAYTRACING_GEOMETRY_DESC,
    pub ppGeometryDescs: *const *const D3D12_RAYTRACING_GEOMETRY_DESC,
}
impl Default
    for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS__bindgen_ty_1
{
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug
    for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS__bindgen_ty_1
{
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug
    for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS
{
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {{ Type: {:?}, Flags: {:?}, NumDescs: {:?}, DescsLayout: {:?}, __bindgen_anon_1: {:?} }}" , self . Type , self . Flags , self . NumDescs , self . DescsLayout , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {
    pub DestAccelerationStructureData: D3D12_GPU_VIRTUAL_ADDRESS,
    pub Inputs: D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS,
    pub SourceAccelerationStructureData: D3D12_GPU_VIRTUAL_ADDRESS,
    pub ScratchAccelerationStructureData: D3D12_GPU_VIRTUAL_ADDRESS,
}
impl Default for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {{ DestAccelerationStructureData: {:?}, Inputs: {:?}, SourceAccelerationStructureData: {:?}, ScratchAccelerationStructureData: {:?} }}" , self . DestAccelerationStructureData , self . Inputs , self . SourceAccelerationStructureData , self . ScratchAccelerationStructureData)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO {
    pub ResultDataMaxSizeInBytes: UINT64,
    pub ScratchDataSizeInBytes: UINT64,
    pub UpdateScratchDataSizeInBytes: UINT64,
}
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_NONE: D3D12_RAY_FLAGS = 0;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_FORCE_OPAQUE: D3D12_RAY_FLAGS = 1;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_FORCE_NON_OPAQUE: D3D12_RAY_FLAGS = 2;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_ACCEPT_FIRST_HIT_AND_END_SEARCH:
    D3D12_RAY_FLAGS = 4;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_SKIP_CLOSEST_HIT_SHADER:
    D3D12_RAY_FLAGS = 8;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_CULL_BACK_FACING_TRIANGLES:
    D3D12_RAY_FLAGS = 16;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_CULL_FRONT_FACING_TRIANGLES:
    D3D12_RAY_FLAGS = 32;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_CULL_OPAQUE: D3D12_RAY_FLAGS = 64;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_CULL_NON_OPAQUE: D3D12_RAY_FLAGS = 128;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_SKIP_TRIANGLES: D3D12_RAY_FLAGS = 256;
pub const D3D12_RAY_FLAGS_D3D12_RAY_FLAG_SKIP_PROCEDURAL_PRIMITIVES:
    D3D12_RAY_FLAGS = 512;
pub type D3D12_RAY_FLAGS = ::std::os::raw::c_int;
pub const D3D12_HIT_KIND_D3D12_HIT_KIND_TRIANGLE_FRONT_FACE: D3D12_HIT_KIND =
    254;
pub const D3D12_HIT_KIND_D3D12_HIT_KIND_TRIANGLE_BACK_FACE: D3D12_HIT_KIND =
    255;
pub type D3D12_HIT_KIND = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12Device5: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device5Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , Name : LPCWSTR) -> HRESULT > , pub GetNodeCount : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5) -> UINT > , pub CreateCommandQueue : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_COMMAND_QUEUE_DESC , riid : * const IID , ppCommandQueue : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandAllocator : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , type_ : D3D12_COMMAND_LIST_TYPE , riid : * const IID , ppCommandAllocator : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateGraphicsPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_GRAPHICS_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateComputePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_COMPUTE_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandList : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , pCommandAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CheckFeatureSupport : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , Feature : D3D12_FEATURE , pFeatureSupportData : * mut :: std :: os :: raw :: c_void , FeatureSupportDataSize : UINT) -> HRESULT > , pub CreateDescriptorHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDescriptorHeapDesc : * const D3D12_DESCRIPTOR_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDescriptorHandleIncrementSize : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , DescriptorHeapType : D3D12_DESCRIPTOR_HEAP_TYPE) -> UINT > , pub CreateRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , nodeMask : UINT , pBlobWithRootSignature : * const :: std :: os :: raw :: c_void , blobLengthInBytes : SIZE_T , riid : * const IID , ppvRootSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_CONSTANT_BUFFER_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_SHADER_RESOURCE_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pResource : * mut ID3D12Resource , pCounterResource : * mut ID3D12Resource , pDesc : * const D3D12_UNORDERED_ACCESS_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_RENDER_TARGET_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_DEPTH_STENCIL_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateSampler : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_SAMPLER_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CopyDescriptors : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , NumDestDescriptorRanges : UINT , pDestDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pDestDescriptorRangeSizes : * const UINT , NumSrcDescriptorRanges : UINT , pSrcDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pSrcDescriptorRangeSizes : * const UINT , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub CopyDescriptorsSimple : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , NumDescriptors : UINT , DestDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , SrcDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub GetResourceAllocationInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub GetCustomHeapProperties : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , RetVal : * mut D3D12_HEAP_PROPERTIES , nodeMask : UINT , heapType : D3D12_HEAP_TYPE) -> * mut D3D12_HEAP_PROPERTIES > , pub CreateCommittedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pObject : * mut ID3D12DeviceChild , pAttributes : * const SECURITY_ATTRIBUTES , Access : DWORD , Name : LPCWSTR , pHandle : * mut HANDLE) -> HRESULT > , pub OpenSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , NTHandle : HANDLE , riid : * const IID , ppvObj : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenSharedHandleByName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , Name : LPCWSTR , Access : DWORD , pNTHandle : * mut HANDLE) -> HRESULT > , pub MakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub Evict : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub CreateFence : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , InitialValue : UINT64 , Flags : D3D12_FENCE_FLAGS , riid : * const IID , ppFence : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDeviceRemovedReason : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5) -> HRESULT > , pub GetCopyableFootprints : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pResourceDesc : * const D3D12_RESOURCE_DESC , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , pub CreateQueryHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_QUERY_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetStablePowerState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , Enable : BOOL) -> HRESULT > , pub CreateCommandSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_COMMAND_SIGNATURE_DESC , pRootSignature : * mut ID3D12RootSignature , riid : * const IID , ppvCommandSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceTiling : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pTiledResource : * mut ID3D12Resource , pNumTilesForEntireResource : * mut UINT , pPackedMipDesc : * mut D3D12_PACKED_MIP_INFO , pStandardTileShapeForNonPackedMips : * mut D3D12_TILE_SHAPE , pNumSubresourceTilings : * mut UINT , FirstSubresourceTilingToGet : UINT , pSubresourceTilingsForNonPackedMips : * mut D3D12_SUBRESOURCE_TILING) > , pub GetAdapterLuid : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , RetVal : * mut LUID) -> * mut LUID > , pub CreatePipelineLibrary : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pLibraryBlob : * const :: std :: os :: raw :: c_void , BlobLength : SIZE_T , riid : * const IID , ppPipelineLibrary : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetEventOnMultipleFenceCompletion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , ppFences : * const * mut ID3D12Fence , pFenceValues : * const UINT64 , NumFences : UINT , Flags : D3D12_MULTIPLE_FENCE_WAIT_FLAGS , hEvent : HANDLE) -> HRESULT > , pub SetResidencyPriority : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pPriorities : * const D3D12_RESIDENCY_PRIORITY) -> HRESULT > , pub CreatePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_PIPELINE_STATE_STREAM_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromAddress : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pAddress : * const :: std :: os :: raw :: c_void , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromFileMapping : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , hFileMapping : HANDLE , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub EnqueueMakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , Flags : D3D12_RESIDENCY_FLAGS , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pFenceToSignal : * mut ID3D12Fence , FenceValueToSignal : UINT64) -> HRESULT > , pub CreateCommandList1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , flags : D3D12_COMMAND_LIST_FLAGS , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommittedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_HEAP_DESC , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateLifetimeTracker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pOwner : * mut ID3D12LifetimeOwner , riid : * const IID , ppvTracker : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub RemoveDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5) > , pub EnumerateMetaCommands : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pNumMetaCommands : * mut UINT , pDescs : * mut D3D12_META_COMMAND_DESC) -> HRESULT > , pub EnumerateMetaCommandParameters : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , CommandId : * const GUID , Stage : D3D12_META_COMMAND_PARAMETER_STAGE , pTotalStructureSizeInBytes : * mut UINT , pParameterCount : * mut UINT , pParameterDescs : * mut D3D12_META_COMMAND_PARAMETER_DESC) -> HRESULT > , pub CreateMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , CommandId : * const GUID , NodeMask : UINT , pCreationParametersData : * const :: std :: os :: raw :: c_void , CreationParametersDataSizeInBytes : SIZE_T , riid : * const IID , ppMetaCommand : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_STATE_OBJECT_DESC , riid : * const IID , ppStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetRaytracingAccelerationStructurePrebuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS , pInfo : * mut D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO) > , pub CheckDriverMatchingIdentifier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device5 , SerializedDataType : D3D12_SERIALIZED_DATA_TYPE , pIdentifierToCheck : * const D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER) -> D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device5 {
    pub lpVtbl: *mut ID3D12Device5Vtbl,
}
impl Default for ID3D12Device5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_SETMARKER:
    D3D12_AUTO_BREADCRUMB_OP = 0;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_BEGINEVENT:
    D3D12_AUTO_BREADCRUMB_OP = 1;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_ENDEVENT:
    D3D12_AUTO_BREADCRUMB_OP = 2;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_DRAWINSTANCED:
    D3D12_AUTO_BREADCRUMB_OP = 3;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_DRAWINDEXEDINSTANCED : D3D12_AUTO_BREADCRUMB_OP = 4 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_EXECUTEINDIRECT:
    D3D12_AUTO_BREADCRUMB_OP = 5;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_DISPATCH:
    D3D12_AUTO_BREADCRUMB_OP = 6;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_COPYBUFFERREGION:
    D3D12_AUTO_BREADCRUMB_OP = 7;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_COPYTEXTUREREGION : D3D12_AUTO_BREADCRUMB_OP = 8 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_COPYRESOURCE:
    D3D12_AUTO_BREADCRUMB_OP = 9;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_COPYTILES:
    D3D12_AUTO_BREADCRUMB_OP = 10;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_RESOLVESUBRESOURCE : D3D12_AUTO_BREADCRUMB_OP = 11 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_CLEARRENDERTARGETVIEW : D3D12_AUTO_BREADCRUMB_OP = 12 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_CLEARUNORDEREDACCESSVIEW : D3D12_AUTO_BREADCRUMB_OP = 13 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_CLEARDEPTHSTENCILVIEW : D3D12_AUTO_BREADCRUMB_OP = 14 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_RESOURCEBARRIER:
    D3D12_AUTO_BREADCRUMB_OP = 15;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_EXECUTEBUNDLE:
    D3D12_AUTO_BREADCRUMB_OP = 16;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_PRESENT:
    D3D12_AUTO_BREADCRUMB_OP = 17;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_RESOLVEQUERYDATA:
    D3D12_AUTO_BREADCRUMB_OP = 18;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_BEGINSUBMISSION:
    D3D12_AUTO_BREADCRUMB_OP = 19;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_ENDSUBMISSION:
    D3D12_AUTO_BREADCRUMB_OP = 20;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME:
    D3D12_AUTO_BREADCRUMB_OP = 21;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_PROCESSFRAMES:
    D3D12_AUTO_BREADCRUMB_OP = 22;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_ATOMICCOPYBUFFERUINT : D3D12_AUTO_BREADCRUMB_OP = 23 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_ATOMICCOPYBUFFERUINT64 : D3D12_AUTO_BREADCRUMB_OP = 24 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_RESOLVESUBRESOURCEREGION : D3D12_AUTO_BREADCRUMB_OP = 25 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_WRITEBUFFERIMMEDIATE : D3D12_AUTO_BREADCRUMB_OP = 26 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME1:
    D3D12_AUTO_BREADCRUMB_OP = 27;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_SETPROTECTEDRESOURCESESSION : D3D12_AUTO_BREADCRUMB_OP = 28 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME2:
    D3D12_AUTO_BREADCRUMB_OP = 29;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_PROCESSFRAMES1:
    D3D12_AUTO_BREADCRUMB_OP = 30;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_BUILDRAYTRACINGACCELERATIONSTRUCTURE : D3D12_AUTO_BREADCRUMB_OP = 31 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_EMITRAYTRACINGACCELERATIONSTRUCTUREPOSTBUILDINFO : D3D12_AUTO_BREADCRUMB_OP = 32 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_COPYRAYTRACINGACCELERATIONSTRUCTURE : D3D12_AUTO_BREADCRUMB_OP = 33 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_DISPATCHRAYS:
    D3D12_AUTO_BREADCRUMB_OP = 34;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_INITIALIZEMETACOMMAND : D3D12_AUTO_BREADCRUMB_OP = 35 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_EXECUTEMETACOMMAND : D3D12_AUTO_BREADCRUMB_OP = 36 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_ESTIMATEMOTION:
    D3D12_AUTO_BREADCRUMB_OP = 37;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_RESOLVEMOTIONVECTORHEAP : D3D12_AUTO_BREADCRUMB_OP = 38 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_SETPIPELINESTATE1 : D3D12_AUTO_BREADCRUMB_OP = 39 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_INITIALIZEEXTENSIONCOMMAND : D3D12_AUTO_BREADCRUMB_OP = 40 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_EXECUTEEXTENSIONCOMMAND : D3D12_AUTO_BREADCRUMB_OP = 41 ;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_DISPATCHMESH:
    D3D12_AUTO_BREADCRUMB_OP = 42;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_ENCODEFRAME:
    D3D12_AUTO_BREADCRUMB_OP = 43;
pub const D3D12_AUTO_BREADCRUMB_OP_D3D12_AUTO_BREADCRUMB_OP_RESOLVEENCODEROUTPUTMETADATA : D3D12_AUTO_BREADCRUMB_OP = 44 ;
pub type D3D12_AUTO_BREADCRUMB_OP = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_AUTO_BREADCRUMB_NODE {
    pub pCommandListDebugNameA: *const ::std::os::raw::c_char,
    pub pCommandListDebugNameW: *const wchar_t,
    pub pCommandQueueDebugNameA: *const ::std::os::raw::c_char,
    pub pCommandQueueDebugNameW: *const wchar_t,
    pub pCommandList: *mut ID3D12GraphicsCommandList,
    pub pCommandQueue: *mut ID3D12CommandQueue,
    pub BreadcrumbCount: UINT32,
    pub pLastBreadcrumbValue: *const UINT32,
    pub pCommandHistory: *const D3D12_AUTO_BREADCRUMB_OP,
    pub pNext: *const D3D12_AUTO_BREADCRUMB_NODE,
}
impl Default for D3D12_AUTO_BREADCRUMB_NODE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRED_BREADCRUMB_CONTEXT {
    pub BreadcrumbIndex: UINT,
    pub pContextString: *const wchar_t,
}
impl Default for D3D12_DRED_BREADCRUMB_CONTEXT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_AUTO_BREADCRUMB_NODE1 {
    pub pCommandListDebugNameA: *const ::std::os::raw::c_char,
    pub pCommandListDebugNameW: *const wchar_t,
    pub pCommandQueueDebugNameA: *const ::std::os::raw::c_char,
    pub pCommandQueueDebugNameW: *const wchar_t,
    pub pCommandList: *mut ID3D12GraphicsCommandList,
    pub pCommandQueue: *mut ID3D12CommandQueue,
    pub BreadcrumbCount: UINT,
    pub pLastBreadcrumbValue: *const UINT,
    pub pCommandHistory: *const D3D12_AUTO_BREADCRUMB_OP,
    pub pNext: *const D3D12_AUTO_BREADCRUMB_NODE1,
    pub BreadcrumbContextsCount: UINT,
    pub pBreadcrumbContexts: *mut D3D12_DRED_BREADCRUMB_CONTEXT,
}
impl Default for D3D12_AUTO_BREADCRUMB_NODE1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_DRED_VERSION_D3D12_DRED_VERSION_1_0: D3D12_DRED_VERSION = 1;
pub const D3D12_DRED_VERSION_D3D12_DRED_VERSION_1_1: D3D12_DRED_VERSION = 2;
pub const D3D12_DRED_VERSION_D3D12_DRED_VERSION_1_2: D3D12_DRED_VERSION = 3;
pub const D3D12_DRED_VERSION_D3D12_DRED_VERSION_1_3: D3D12_DRED_VERSION = 4;
pub type D3D12_DRED_VERSION = ::std::os::raw::c_int;
pub const D3D12_DRED_FLAGS_D3D12_DRED_FLAG_NONE: D3D12_DRED_FLAGS = 0;
pub const D3D12_DRED_FLAGS_D3D12_DRED_FLAG_FORCE_ENABLE: D3D12_DRED_FLAGS = 1;
pub const D3D12_DRED_FLAGS_D3D12_DRED_FLAG_DISABLE_AUTOBREADCRUMBS:
    D3D12_DRED_FLAGS = 2;
pub type D3D12_DRED_FLAGS = ::std::os::raw::c_int;
pub const D3D12_DRED_ENABLEMENT_D3D12_DRED_ENABLEMENT_SYSTEM_CONTROLLED:
    D3D12_DRED_ENABLEMENT = 0;
pub const D3D12_DRED_ENABLEMENT_D3D12_DRED_ENABLEMENT_FORCED_OFF:
    D3D12_DRED_ENABLEMENT = 1;
pub const D3D12_DRED_ENABLEMENT_D3D12_DRED_ENABLEMENT_FORCED_ON:
    D3D12_DRED_ENABLEMENT = 2;
pub type D3D12_DRED_ENABLEMENT = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEVICE_REMOVED_EXTENDED_DATA {
    pub Flags: D3D12_DRED_FLAGS,
    pub pHeadAutoBreadcrumbNode: *mut D3D12_AUTO_BREADCRUMB_NODE,
}
impl Default for D3D12_DEVICE_REMOVED_EXTENDED_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_COMMAND_QUEUE : D3D12_DRED_ALLOCATION_TYPE = 19 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_COMMAND_ALLOCATOR : D3D12_DRED_ALLOCATION_TYPE = 20 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_PIPELINE_STATE : D3D12_DRED_ALLOCATION_TYPE = 21 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_COMMAND_LIST:
    D3D12_DRED_ALLOCATION_TYPE = 22;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_FENCE:
    D3D12_DRED_ALLOCATION_TYPE = 23;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_DESCRIPTOR_HEAP : D3D12_DRED_ALLOCATION_TYPE = 24 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_HEAP:
    D3D12_DRED_ALLOCATION_TYPE = 25;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_QUERY_HEAP:
    D3D12_DRED_ALLOCATION_TYPE = 27;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_COMMAND_SIGNATURE : D3D12_DRED_ALLOCATION_TYPE = 28 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_PIPELINE_LIBRARY : D3D12_DRED_ALLOCATION_TYPE = 29 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_VIDEO_DECODER : D3D12_DRED_ALLOCATION_TYPE = 30 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_VIDEO_PROCESSOR : D3D12_DRED_ALLOCATION_TYPE = 32 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_RESOURCE:
    D3D12_DRED_ALLOCATION_TYPE = 34;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_PASS:
    D3D12_DRED_ALLOCATION_TYPE = 35;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_CRYPTOSESSION : D3D12_DRED_ALLOCATION_TYPE = 36 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_CRYPTOSESSIONPOLICY : D3D12_DRED_ALLOCATION_TYPE = 37 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_PROTECTEDRESOURCESESSION : D3D12_DRED_ALLOCATION_TYPE = 38 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_VIDEO_DECODER_HEAP : D3D12_DRED_ALLOCATION_TYPE = 39 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_COMMAND_POOL:
    D3D12_DRED_ALLOCATION_TYPE = 40;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_COMMAND_RECORDER : D3D12_DRED_ALLOCATION_TYPE = 41 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_STATE_OBJECT:
    D3D12_DRED_ALLOCATION_TYPE = 42;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_METACOMMAND:
    D3D12_DRED_ALLOCATION_TYPE = 43;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_SCHEDULINGGROUP : D3D12_DRED_ALLOCATION_TYPE = 44 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_VIDEO_MOTION_ESTIMATOR : D3D12_DRED_ALLOCATION_TYPE = 45 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_VIDEO_MOTION_VECTOR_HEAP : D3D12_DRED_ALLOCATION_TYPE = 46 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_VIDEO_EXTENSION_COMMAND : D3D12_DRED_ALLOCATION_TYPE = 47 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_VIDEO_ENCODER : D3D12_DRED_ALLOCATION_TYPE = 48 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_VIDEO_ENCODER_HEAP : D3D12_DRED_ALLOCATION_TYPE = 49 ;
pub const D3D12_DRED_ALLOCATION_TYPE_D3D12_DRED_ALLOCATION_TYPE_INVALID:
    D3D12_DRED_ALLOCATION_TYPE = -1;
pub type D3D12_DRED_ALLOCATION_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRED_ALLOCATION_NODE {
    pub ObjectNameA: *const ::std::os::raw::c_char,
    pub ObjectNameW: *const wchar_t,
    pub AllocationType: D3D12_DRED_ALLOCATION_TYPE,
    pub pNext: *const D3D12_DRED_ALLOCATION_NODE,
}
impl Default for D3D12_DRED_ALLOCATION_NODE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRED_ALLOCATION_NODE1 {
    pub ObjectNameA: *const ::std::os::raw::c_char,
    pub ObjectNameW: *const wchar_t,
    pub AllocationType: D3D12_DRED_ALLOCATION_TYPE,
    pub pNext: *const D3D12_DRED_ALLOCATION_NODE1,
    pub pObject: *const IUnknown,
}
impl Default for D3D12_DRED_ALLOCATION_NODE1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {
    pub pHeadAutoBreadcrumbNode: *const D3D12_AUTO_BREADCRUMB_NODE,
}
impl Default for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {
    pub pHeadAutoBreadcrumbNode: *const D3D12_AUTO_BREADCRUMB_NODE1,
}
impl Default for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRED_PAGE_FAULT_OUTPUT {
    pub PageFaultVA: D3D12_GPU_VIRTUAL_ADDRESS,
    pub pHeadExistingAllocationNode: *const D3D12_DRED_ALLOCATION_NODE,
    pub pHeadRecentFreedAllocationNode: *const D3D12_DRED_ALLOCATION_NODE,
}
impl Default for D3D12_DRED_PAGE_FAULT_OUTPUT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRED_PAGE_FAULT_OUTPUT1 {
    pub PageFaultVA: D3D12_GPU_VIRTUAL_ADDRESS,
    pub pHeadExistingAllocationNode: *const D3D12_DRED_ALLOCATION_NODE1,
    pub pHeadRecentFreedAllocationNode: *const D3D12_DRED_ALLOCATION_NODE1,
}
impl Default for D3D12_DRED_PAGE_FAULT_OUTPUT1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_DRED_PAGE_FAULT_FLAGS_D3D12_DRED_PAGE_FAULT_FLAGS_NONE:
    D3D12_DRED_PAGE_FAULT_FLAGS = 0;
pub type D3D12_DRED_PAGE_FAULT_FLAGS = ::std::os::raw::c_int;
pub const D3D12_DRED_DEVICE_STATE_D3D12_DRED_DEVICE_STATE_UNKNOWN:
    D3D12_DRED_DEVICE_STATE = 0;
pub const D3D12_DRED_DEVICE_STATE_D3D12_DRED_DEVICE_STATE_HUNG:
    D3D12_DRED_DEVICE_STATE = 3;
pub const D3D12_DRED_DEVICE_STATE_D3D12_DRED_DEVICE_STATE_FAULT:
    D3D12_DRED_DEVICE_STATE = 6;
pub const D3D12_DRED_DEVICE_STATE_D3D12_DRED_DEVICE_STATE_PAGEFAULT:
    D3D12_DRED_DEVICE_STATE = 7;
pub type D3D12_DRED_DEVICE_STATE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DRED_PAGE_FAULT_OUTPUT2 {
    pub PageFaultVA: D3D12_GPU_VIRTUAL_ADDRESS,
    pub pHeadExistingAllocationNode: *const D3D12_DRED_ALLOCATION_NODE1,
    pub pHeadRecentFreedAllocationNode: *const D3D12_DRED_ALLOCATION_NODE1,
    pub PageFaultFlags: D3D12_DRED_PAGE_FAULT_FLAGS,
}
impl Default for D3D12_DRED_PAGE_FAULT_OUTPUT2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {
    pub DeviceRemovedReason: HRESULT,
    pub AutoBreadcrumbsOutput: D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT,
    pub PageFaultOutput: D3D12_DRED_PAGE_FAULT_OUTPUT,
}
impl Default for D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {
    pub DeviceRemovedReason: HRESULT,
    pub AutoBreadcrumbsOutput: D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1,
    pub PageFaultOutput: D3D12_DRED_PAGE_FAULT_OUTPUT1,
}
impl Default for D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {
    pub DeviceRemovedReason: HRESULT,
    pub AutoBreadcrumbsOutput: D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1,
    pub PageFaultOutput: D3D12_DRED_PAGE_FAULT_OUTPUT2,
    pub DeviceState: D3D12_DRED_DEVICE_STATE,
}
impl Default for D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {
    pub Version: D3D12_DRED_VERSION,
    pub __bindgen_anon_1:
        D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA__bindgen_ty_1 {
    pub Dred_1_0: D3D12_DEVICE_REMOVED_EXTENDED_DATA,
    pub Dred_1_1: D3D12_DEVICE_REMOVED_EXTENDED_DATA1,
    pub Dred_1_2: D3D12_DEVICE_REMOVED_EXTENDED_DATA2,
    pub Dred_1_3: D3D12_DEVICE_REMOVED_EXTENDED_DATA3,
}
impl Default for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug
    for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA__bindgen_ty_1
{
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {{ Version: {:?}, __bindgen_anon_1: {:?} }}" , self . Version , self . __bindgen_anon_1)
    }
}
extern "C" {
    pub static IID_ID3D12DeviceRemovedExtendedDataSettings: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedDataSettingsVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings,
        ) -> ULONG,
    >,
    pub SetAutoBreadcrumbsEnablement: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings,
            Enablement: D3D12_DRED_ENABLEMENT,
        ),
    >,
    pub SetPageFaultEnablement: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings,
            Enablement: D3D12_DRED_ENABLEMENT,
        ),
    >,
    pub SetWatsonDumpEnablement: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings,
            Enablement: D3D12_DRED_ENABLEMENT,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedDataSettings {
    pub lpVtbl: *mut ID3D12DeviceRemovedExtendedDataSettingsVtbl,
}
impl Default for ID3D12DeviceRemovedExtendedDataSettings {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DeviceRemovedExtendedDataSettings1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedDataSettings1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings1,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings1,
        ) -> ULONG,
    >,
    pub SetAutoBreadcrumbsEnablement: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings1,
            Enablement: D3D12_DRED_ENABLEMENT,
        ),
    >,
    pub SetPageFaultEnablement: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings1,
            Enablement: D3D12_DRED_ENABLEMENT,
        ),
    >,
    pub SetWatsonDumpEnablement: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings1,
            Enablement: D3D12_DRED_ENABLEMENT,
        ),
    >,
    pub SetBreadcrumbContextEnablement: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedDataSettings1,
            Enablement: D3D12_DRED_ENABLEMENT,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedDataSettings1 {
    pub lpVtbl: *mut ID3D12DeviceRemovedExtendedDataSettings1Vtbl,
}
impl Default for ID3D12DeviceRemovedExtendedDataSettings1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DeviceRemovedExtendedData: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedDataVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData,
        ) -> ULONG,
    >,
    pub GetAutoBreadcrumbsOutput: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData,
            pOutput: *mut D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT,
        ) -> HRESULT,
    >,
    pub GetPageFaultAllocationOutput: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData,
            pOutput: *mut D3D12_DRED_PAGE_FAULT_OUTPUT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedData {
    pub lpVtbl: *mut ID3D12DeviceRemovedExtendedDataVtbl,
}
impl Default for ID3D12DeviceRemovedExtendedData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DeviceRemovedExtendedData1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedData1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData1,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData1,
        ) -> ULONG,
    >,
    pub GetAutoBreadcrumbsOutput: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData1,
            pOutput: *mut D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT,
        ) -> HRESULT,
    >,
    pub GetPageFaultAllocationOutput: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData1,
            pOutput: *mut D3D12_DRED_PAGE_FAULT_OUTPUT,
        ) -> HRESULT,
    >,
    pub GetAutoBreadcrumbsOutput1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData1,
            pOutput: *mut D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1,
        ) -> HRESULT,
    >,
    pub GetPageFaultAllocationOutput1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData1,
            pOutput: *mut D3D12_DRED_PAGE_FAULT_OUTPUT1,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedData1 {
    pub lpVtbl: *mut ID3D12DeviceRemovedExtendedData1Vtbl,
}
impl Default for ID3D12DeviceRemovedExtendedData1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DeviceRemovedExtendedData2: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedData2Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
        ) -> ULONG,
    >,
    pub GetAutoBreadcrumbsOutput: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
            pOutput: *mut D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT,
        ) -> HRESULT,
    >,
    pub GetPageFaultAllocationOutput: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
            pOutput: *mut D3D12_DRED_PAGE_FAULT_OUTPUT,
        ) -> HRESULT,
    >,
    pub GetAutoBreadcrumbsOutput1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
            pOutput: *mut D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1,
        ) -> HRESULT,
    >,
    pub GetPageFaultAllocationOutput1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
            pOutput: *mut D3D12_DRED_PAGE_FAULT_OUTPUT1,
        ) -> HRESULT,
    >,
    pub GetPageFaultAllocationOutput2: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
            pOutput: *mut D3D12_DRED_PAGE_FAULT_OUTPUT2,
        ) -> HRESULT,
    >,
    pub GetDeviceState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DeviceRemovedExtendedData2,
        ) -> D3D12_DRED_DEVICE_STATE,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DeviceRemovedExtendedData2 {
    pub lpVtbl: *mut ID3D12DeviceRemovedExtendedData2Vtbl,
}
impl Default for ID3D12DeviceRemovedExtendedData2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_BACKGROUND_PROCESSING_MODE_D3D12_BACKGROUND_PROCESSING_MODE_ALLOWED : D3D12_BACKGROUND_PROCESSING_MODE = 0 ;
pub const D3D12_BACKGROUND_PROCESSING_MODE_D3D12_BACKGROUND_PROCESSING_MODE_ALLOW_INTRUSIVE_MEASUREMENTS : D3D12_BACKGROUND_PROCESSING_MODE = 1 ;
pub const D3D12_BACKGROUND_PROCESSING_MODE_D3D12_BACKGROUND_PROCESSING_MODE_DISABLE_BACKGROUND_WORK : D3D12_BACKGROUND_PROCESSING_MODE = 2 ;
pub const D3D12_BACKGROUND_PROCESSING_MODE_D3D12_BACKGROUND_PROCESSING_MODE_DISABLE_PROFILING_BY_SYSTEM : D3D12_BACKGROUND_PROCESSING_MODE = 3 ;
pub type D3D12_BACKGROUND_PROCESSING_MODE = ::std::os::raw::c_int;
pub const D3D12_MEASUREMENTS_ACTION_D3D12_MEASUREMENTS_ACTION_KEEP_ALL:
    D3D12_MEASUREMENTS_ACTION = 0;
pub const D3D12_MEASUREMENTS_ACTION_D3D12_MEASUREMENTS_ACTION_COMMIT_RESULTS:
    D3D12_MEASUREMENTS_ACTION = 1;
pub const D3D12_MEASUREMENTS_ACTION_D3D12_MEASUREMENTS_ACTION_COMMIT_RESULTS_HIGH_PRIORITY : D3D12_MEASUREMENTS_ACTION = 2 ;
pub const D3D12_MEASUREMENTS_ACTION_D3D12_MEASUREMENTS_ACTION_DISCARD_PREVIOUS : D3D12_MEASUREMENTS_ACTION = 3 ;
pub type D3D12_MEASUREMENTS_ACTION = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12Device6: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device6Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , Name : LPCWSTR) -> HRESULT > , pub GetNodeCount : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6) -> UINT > , pub CreateCommandQueue : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_COMMAND_QUEUE_DESC , riid : * const IID , ppCommandQueue : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandAllocator : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , type_ : D3D12_COMMAND_LIST_TYPE , riid : * const IID , ppCommandAllocator : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateGraphicsPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_GRAPHICS_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateComputePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_COMPUTE_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandList : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , pCommandAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CheckFeatureSupport : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , Feature : D3D12_FEATURE , pFeatureSupportData : * mut :: std :: os :: raw :: c_void , FeatureSupportDataSize : UINT) -> HRESULT > , pub CreateDescriptorHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDescriptorHeapDesc : * const D3D12_DESCRIPTOR_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDescriptorHandleIncrementSize : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , DescriptorHeapType : D3D12_DESCRIPTOR_HEAP_TYPE) -> UINT > , pub CreateRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , nodeMask : UINT , pBlobWithRootSignature : * const :: std :: os :: raw :: c_void , blobLengthInBytes : SIZE_T , riid : * const IID , ppvRootSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_CONSTANT_BUFFER_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_SHADER_RESOURCE_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pResource : * mut ID3D12Resource , pCounterResource : * mut ID3D12Resource , pDesc : * const D3D12_UNORDERED_ACCESS_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_RENDER_TARGET_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_DEPTH_STENCIL_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateSampler : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_SAMPLER_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CopyDescriptors : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , NumDestDescriptorRanges : UINT , pDestDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pDestDescriptorRangeSizes : * const UINT , NumSrcDescriptorRanges : UINT , pSrcDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pSrcDescriptorRangeSizes : * const UINT , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub CopyDescriptorsSimple : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , NumDescriptors : UINT , DestDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , SrcDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub GetResourceAllocationInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub GetCustomHeapProperties : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , RetVal : * mut D3D12_HEAP_PROPERTIES , nodeMask : UINT , heapType : D3D12_HEAP_TYPE) -> * mut D3D12_HEAP_PROPERTIES > , pub CreateCommittedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pObject : * mut ID3D12DeviceChild , pAttributes : * const SECURITY_ATTRIBUTES , Access : DWORD , Name : LPCWSTR , pHandle : * mut HANDLE) -> HRESULT > , pub OpenSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , NTHandle : HANDLE , riid : * const IID , ppvObj : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenSharedHandleByName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , Name : LPCWSTR , Access : DWORD , pNTHandle : * mut HANDLE) -> HRESULT > , pub MakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub Evict : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub CreateFence : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , InitialValue : UINT64 , Flags : D3D12_FENCE_FLAGS , riid : * const IID , ppFence : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDeviceRemovedReason : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6) -> HRESULT > , pub GetCopyableFootprints : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pResourceDesc : * const D3D12_RESOURCE_DESC , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , pub CreateQueryHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_QUERY_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetStablePowerState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , Enable : BOOL) -> HRESULT > , pub CreateCommandSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_COMMAND_SIGNATURE_DESC , pRootSignature : * mut ID3D12RootSignature , riid : * const IID , ppvCommandSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceTiling : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pTiledResource : * mut ID3D12Resource , pNumTilesForEntireResource : * mut UINT , pPackedMipDesc : * mut D3D12_PACKED_MIP_INFO , pStandardTileShapeForNonPackedMips : * mut D3D12_TILE_SHAPE , pNumSubresourceTilings : * mut UINT , FirstSubresourceTilingToGet : UINT , pSubresourceTilingsForNonPackedMips : * mut D3D12_SUBRESOURCE_TILING) > , pub GetAdapterLuid : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , RetVal : * mut LUID) -> * mut LUID > , pub CreatePipelineLibrary : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pLibraryBlob : * const :: std :: os :: raw :: c_void , BlobLength : SIZE_T , riid : * const IID , ppPipelineLibrary : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetEventOnMultipleFenceCompletion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , ppFences : * const * mut ID3D12Fence , pFenceValues : * const UINT64 , NumFences : UINT , Flags : D3D12_MULTIPLE_FENCE_WAIT_FLAGS , hEvent : HANDLE) -> HRESULT > , pub SetResidencyPriority : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pPriorities : * const D3D12_RESIDENCY_PRIORITY) -> HRESULT > , pub CreatePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_PIPELINE_STATE_STREAM_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromAddress : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pAddress : * const :: std :: os :: raw :: c_void , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromFileMapping : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , hFileMapping : HANDLE , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub EnqueueMakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , Flags : D3D12_RESIDENCY_FLAGS , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pFenceToSignal : * mut ID3D12Fence , FenceValueToSignal : UINT64) -> HRESULT > , pub CreateCommandList1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , flags : D3D12_COMMAND_LIST_FLAGS , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommittedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_HEAP_DESC , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateLifetimeTracker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pOwner : * mut ID3D12LifetimeOwner , riid : * const IID , ppvTracker : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub RemoveDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6) > , pub EnumerateMetaCommands : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pNumMetaCommands : * mut UINT , pDescs : * mut D3D12_META_COMMAND_DESC) -> HRESULT > , pub EnumerateMetaCommandParameters : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , CommandId : * const GUID , Stage : D3D12_META_COMMAND_PARAMETER_STAGE , pTotalStructureSizeInBytes : * mut UINT , pParameterCount : * mut UINT , pParameterDescs : * mut D3D12_META_COMMAND_PARAMETER_DESC) -> HRESULT > , pub CreateMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , CommandId : * const GUID , NodeMask : UINT , pCreationParametersData : * const :: std :: os :: raw :: c_void , CreationParametersDataSizeInBytes : SIZE_T , riid : * const IID , ppMetaCommand : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_STATE_OBJECT_DESC , riid : * const IID , ppStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetRaytracingAccelerationStructurePrebuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS , pInfo : * mut D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO) > , pub CheckDriverMatchingIdentifier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , SerializedDataType : D3D12_SERIALIZED_DATA_TYPE , pIdentifierToCheck : * const D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER) -> D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS > , pub SetBackgroundProcessingMode : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device6 , Mode : D3D12_BACKGROUND_PROCESSING_MODE , MeasurementsAction : D3D12_MEASUREMENTS_ACTION , hEventToSignalUponCompletion : HANDLE , pbFurtherMeasurementsDesired : * mut BOOL) -> HRESULT > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device6 {
    pub lpVtbl: *mut ID3D12Device6Vtbl,
}
impl Default for ID3D12Device6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static D3D12_PROTECTED_RESOURCES_SESSION_HARDWARE_PROTECTED: GUID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT {
    pub NodeIndex: UINT,
    pub Count: UINT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {
    pub NodeIndex: UINT,
    pub Count: UINT,
    pub pTypes: *mut GUID,
}
impl Default for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {
    pub NodeMask: UINT,
    pub Flags: D3D12_PROTECTED_RESOURCE_SESSION_FLAGS,
    pub ProtectionType: GUID,
}
impl Default for D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12ProtectedResourceSession1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ProtectedResourceSession1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
        ) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetStatusFence: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            riid: *const IID,
            ppFence: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetSessionStatus: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
        ) -> D3D12_PROTECTED_SESSION_STATUS,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            RetVal: *mut D3D12_PROTECTED_RESOURCE_SESSION_DESC,
        )
            -> *mut D3D12_PROTECTED_RESOURCE_SESSION_DESC,
    >,
    pub GetDesc1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ProtectedResourceSession1,
            RetVal: *mut D3D12_PROTECTED_RESOURCE_SESSION_DESC1,
        )
            -> *mut D3D12_PROTECTED_RESOURCE_SESSION_DESC1,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ProtectedResourceSession1 {
    pub lpVtbl: *mut ID3D12ProtectedResourceSession1Vtbl,
}
impl Default for ID3D12ProtectedResourceSession1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Device7: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device7Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , Name : LPCWSTR) -> HRESULT > , pub GetNodeCount : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7) -> UINT > , pub CreateCommandQueue : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_COMMAND_QUEUE_DESC , riid : * const IID , ppCommandQueue : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandAllocator : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , type_ : D3D12_COMMAND_LIST_TYPE , riid : * const IID , ppCommandAllocator : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateGraphicsPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_GRAPHICS_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateComputePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_COMPUTE_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandList : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , pCommandAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CheckFeatureSupport : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , Feature : D3D12_FEATURE , pFeatureSupportData : * mut :: std :: os :: raw :: c_void , FeatureSupportDataSize : UINT) -> HRESULT > , pub CreateDescriptorHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDescriptorHeapDesc : * const D3D12_DESCRIPTOR_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDescriptorHandleIncrementSize : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , DescriptorHeapType : D3D12_DESCRIPTOR_HEAP_TYPE) -> UINT > , pub CreateRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , nodeMask : UINT , pBlobWithRootSignature : * const :: std :: os :: raw :: c_void , blobLengthInBytes : SIZE_T , riid : * const IID , ppvRootSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_CONSTANT_BUFFER_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_SHADER_RESOURCE_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pResource : * mut ID3D12Resource , pCounterResource : * mut ID3D12Resource , pDesc : * const D3D12_UNORDERED_ACCESS_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_RENDER_TARGET_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_DEPTH_STENCIL_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateSampler : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_SAMPLER_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CopyDescriptors : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , NumDestDescriptorRanges : UINT , pDestDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pDestDescriptorRangeSizes : * const UINT , NumSrcDescriptorRanges : UINT , pSrcDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pSrcDescriptorRangeSizes : * const UINT , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub CopyDescriptorsSimple : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , NumDescriptors : UINT , DestDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , SrcDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub GetResourceAllocationInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub GetCustomHeapProperties : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , RetVal : * mut D3D12_HEAP_PROPERTIES , nodeMask : UINT , heapType : D3D12_HEAP_TYPE) -> * mut D3D12_HEAP_PROPERTIES > , pub CreateCommittedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pObject : * mut ID3D12DeviceChild , pAttributes : * const SECURITY_ATTRIBUTES , Access : DWORD , Name : LPCWSTR , pHandle : * mut HANDLE) -> HRESULT > , pub OpenSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , NTHandle : HANDLE , riid : * const IID , ppvObj : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenSharedHandleByName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , Name : LPCWSTR , Access : DWORD , pNTHandle : * mut HANDLE) -> HRESULT > , pub MakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub Evict : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub CreateFence : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , InitialValue : UINT64 , Flags : D3D12_FENCE_FLAGS , riid : * const IID , ppFence : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDeviceRemovedReason : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7) -> HRESULT > , pub GetCopyableFootprints : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pResourceDesc : * const D3D12_RESOURCE_DESC , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , pub CreateQueryHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_QUERY_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetStablePowerState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , Enable : BOOL) -> HRESULT > , pub CreateCommandSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_COMMAND_SIGNATURE_DESC , pRootSignature : * mut ID3D12RootSignature , riid : * const IID , ppvCommandSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceTiling : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pTiledResource : * mut ID3D12Resource , pNumTilesForEntireResource : * mut UINT , pPackedMipDesc : * mut D3D12_PACKED_MIP_INFO , pStandardTileShapeForNonPackedMips : * mut D3D12_TILE_SHAPE , pNumSubresourceTilings : * mut UINT , FirstSubresourceTilingToGet : UINT , pSubresourceTilingsForNonPackedMips : * mut D3D12_SUBRESOURCE_TILING) > , pub GetAdapterLuid : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , RetVal : * mut LUID) -> * mut LUID > , pub CreatePipelineLibrary : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pLibraryBlob : * const :: std :: os :: raw :: c_void , BlobLength : SIZE_T , riid : * const IID , ppPipelineLibrary : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetEventOnMultipleFenceCompletion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , ppFences : * const * mut ID3D12Fence , pFenceValues : * const UINT64 , NumFences : UINT , Flags : D3D12_MULTIPLE_FENCE_WAIT_FLAGS , hEvent : HANDLE) -> HRESULT > , pub SetResidencyPriority : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pPriorities : * const D3D12_RESIDENCY_PRIORITY) -> HRESULT > , pub CreatePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_PIPELINE_STATE_STREAM_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromAddress : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pAddress : * const :: std :: os :: raw :: c_void , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromFileMapping : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , hFileMapping : HANDLE , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub EnqueueMakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , Flags : D3D12_RESIDENCY_FLAGS , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pFenceToSignal : * mut ID3D12Fence , FenceValueToSignal : UINT64) -> HRESULT > , pub CreateCommandList1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , flags : D3D12_COMMAND_LIST_FLAGS , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommittedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_HEAP_DESC , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateLifetimeTracker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pOwner : * mut ID3D12LifetimeOwner , riid : * const IID , ppvTracker : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub RemoveDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7) > , pub EnumerateMetaCommands : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pNumMetaCommands : * mut UINT , pDescs : * mut D3D12_META_COMMAND_DESC) -> HRESULT > , pub EnumerateMetaCommandParameters : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , CommandId : * const GUID , Stage : D3D12_META_COMMAND_PARAMETER_STAGE , pTotalStructureSizeInBytes : * mut UINT , pParameterCount : * mut UINT , pParameterDescs : * mut D3D12_META_COMMAND_PARAMETER_DESC) -> HRESULT > , pub CreateMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , CommandId : * const GUID , NodeMask : UINT , pCreationParametersData : * const :: std :: os :: raw :: c_void , CreationParametersDataSizeInBytes : SIZE_T , riid : * const IID , ppMetaCommand : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_STATE_OBJECT_DESC , riid : * const IID , ppStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetRaytracingAccelerationStructurePrebuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS , pInfo : * mut D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO) > , pub CheckDriverMatchingIdentifier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , SerializedDataType : D3D12_SERIALIZED_DATA_TYPE , pIdentifierToCheck : * const D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER) -> D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS > , pub SetBackgroundProcessingMode : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , Mode : D3D12_BACKGROUND_PROCESSING_MODE , MeasurementsAction : D3D12_MEASUREMENTS_ACTION , hEventToSignalUponCompletion : HANDLE , pbFurtherMeasurementsDesired : * mut BOOL) -> HRESULT > , pub AddToStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pAddition : * const D3D12_STATE_OBJECT_DESC , pStateObjectToGrowFrom : * mut ID3D12StateObject , riid : * const IID , ppNewStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device7 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC1 , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device7 {
    pub lpVtbl: *mut ID3D12Device7Vtbl,
}
impl Default for ID3D12Device7 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Device8: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device8Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , Name : LPCWSTR) -> HRESULT > , pub GetNodeCount : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8) -> UINT > , pub CreateCommandQueue : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_COMMAND_QUEUE_DESC , riid : * const IID , ppCommandQueue : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandAllocator : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , type_ : D3D12_COMMAND_LIST_TYPE , riid : * const IID , ppCommandAllocator : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateGraphicsPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_GRAPHICS_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateComputePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_COMPUTE_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandList : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , pCommandAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CheckFeatureSupport : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , Feature : D3D12_FEATURE , pFeatureSupportData : * mut :: std :: os :: raw :: c_void , FeatureSupportDataSize : UINT) -> HRESULT > , pub CreateDescriptorHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDescriptorHeapDesc : * const D3D12_DESCRIPTOR_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDescriptorHandleIncrementSize : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , DescriptorHeapType : D3D12_DESCRIPTOR_HEAP_TYPE) -> UINT > , pub CreateRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , nodeMask : UINT , pBlobWithRootSignature : * const :: std :: os :: raw :: c_void , blobLengthInBytes : SIZE_T , riid : * const IID , ppvRootSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_CONSTANT_BUFFER_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_SHADER_RESOURCE_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pResource : * mut ID3D12Resource , pCounterResource : * mut ID3D12Resource , pDesc : * const D3D12_UNORDERED_ACCESS_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_RENDER_TARGET_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_DEPTH_STENCIL_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateSampler : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_SAMPLER_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CopyDescriptors : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , NumDestDescriptorRanges : UINT , pDestDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pDestDescriptorRangeSizes : * const UINT , NumSrcDescriptorRanges : UINT , pSrcDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pSrcDescriptorRangeSizes : * const UINT , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub CopyDescriptorsSimple : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , NumDescriptors : UINT , DestDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , SrcDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub GetResourceAllocationInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub GetCustomHeapProperties : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , RetVal : * mut D3D12_HEAP_PROPERTIES , nodeMask : UINT , heapType : D3D12_HEAP_TYPE) -> * mut D3D12_HEAP_PROPERTIES > , pub CreateCommittedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pObject : * mut ID3D12DeviceChild , pAttributes : * const SECURITY_ATTRIBUTES , Access : DWORD , Name : LPCWSTR , pHandle : * mut HANDLE) -> HRESULT > , pub OpenSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , NTHandle : HANDLE , riid : * const IID , ppvObj : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenSharedHandleByName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , Name : LPCWSTR , Access : DWORD , pNTHandle : * mut HANDLE) -> HRESULT > , pub MakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub Evict : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub CreateFence : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , InitialValue : UINT64 , Flags : D3D12_FENCE_FLAGS , riid : * const IID , ppFence : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDeviceRemovedReason : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8) -> HRESULT > , pub GetCopyableFootprints : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pResourceDesc : * const D3D12_RESOURCE_DESC , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , pub CreateQueryHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_QUERY_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetStablePowerState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , Enable : BOOL) -> HRESULT > , pub CreateCommandSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_COMMAND_SIGNATURE_DESC , pRootSignature : * mut ID3D12RootSignature , riid : * const IID , ppvCommandSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceTiling : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pTiledResource : * mut ID3D12Resource , pNumTilesForEntireResource : * mut UINT , pPackedMipDesc : * mut D3D12_PACKED_MIP_INFO , pStandardTileShapeForNonPackedMips : * mut D3D12_TILE_SHAPE , pNumSubresourceTilings : * mut UINT , FirstSubresourceTilingToGet : UINT , pSubresourceTilingsForNonPackedMips : * mut D3D12_SUBRESOURCE_TILING) > , pub GetAdapterLuid : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , RetVal : * mut LUID) -> * mut LUID > , pub CreatePipelineLibrary : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pLibraryBlob : * const :: std :: os :: raw :: c_void , BlobLength : SIZE_T , riid : * const IID , ppPipelineLibrary : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetEventOnMultipleFenceCompletion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , ppFences : * const * mut ID3D12Fence , pFenceValues : * const UINT64 , NumFences : UINT , Flags : D3D12_MULTIPLE_FENCE_WAIT_FLAGS , hEvent : HANDLE) -> HRESULT > , pub SetResidencyPriority : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pPriorities : * const D3D12_RESIDENCY_PRIORITY) -> HRESULT > , pub CreatePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_PIPELINE_STATE_STREAM_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromAddress : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pAddress : * const :: std :: os :: raw :: c_void , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromFileMapping : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , hFileMapping : HANDLE , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub EnqueueMakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , Flags : D3D12_RESIDENCY_FLAGS , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pFenceToSignal : * mut ID3D12Fence , FenceValueToSignal : UINT64) -> HRESULT > , pub CreateCommandList1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , flags : D3D12_COMMAND_LIST_FLAGS , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommittedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_HEAP_DESC , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateLifetimeTracker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pOwner : * mut ID3D12LifetimeOwner , riid : * const IID , ppvTracker : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub RemoveDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8) > , pub EnumerateMetaCommands : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pNumMetaCommands : * mut UINT , pDescs : * mut D3D12_META_COMMAND_DESC) -> HRESULT > , pub EnumerateMetaCommandParameters : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , CommandId : * const GUID , Stage : D3D12_META_COMMAND_PARAMETER_STAGE , pTotalStructureSizeInBytes : * mut UINT , pParameterCount : * mut UINT , pParameterDescs : * mut D3D12_META_COMMAND_PARAMETER_DESC) -> HRESULT > , pub CreateMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , CommandId : * const GUID , NodeMask : UINT , pCreationParametersData : * const :: std :: os :: raw :: c_void , CreationParametersDataSizeInBytes : SIZE_T , riid : * const IID , ppMetaCommand : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_STATE_OBJECT_DESC , riid : * const IID , ppStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetRaytracingAccelerationStructurePrebuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS , pInfo : * mut D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO) > , pub CheckDriverMatchingIdentifier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , SerializedDataType : D3D12_SERIALIZED_DATA_TYPE , pIdentifierToCheck : * const D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER) -> D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS > , pub SetBackgroundProcessingMode : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , Mode : D3D12_BACKGROUND_PROCESSING_MODE , MeasurementsAction : D3D12_MEASUREMENTS_ACTION , hEventToSignalUponCompletion : HANDLE , pbFurtherMeasurementsDesired : * mut BOOL) -> HRESULT > , pub AddToStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pAddition : * const D3D12_STATE_OBJECT_DESC , pStateObjectToGrowFrom : * mut ID3D12StateObject , riid : * const IID , ppNewStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC1 , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo2 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC1 , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateCommittedResource2 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC1 , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC1 , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSamplerFeedbackUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pTargetedResource : * mut ID3D12Resource , pFeedbackResource : * mut ID3D12Resource , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub GetCopyableFootprints1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device8 , pResourceDesc : * const D3D12_RESOURCE_DESC1 , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device8 {
    pub lpVtbl: *mut ID3D12Device8Vtbl,
}
impl Default for ID3D12Device8 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Resource1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Resource1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Resource1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Resource1) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub Map: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            Subresource: UINT,
            pReadRange: *const D3D12_RANGE,
            ppData: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub Unmap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            Subresource: UINT,
            pWrittenRange: *const D3D12_RANGE,
        ),
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            RetVal: *mut D3D12_RESOURCE_DESC,
        ) -> *mut D3D12_RESOURCE_DESC,
    >,
    pub GetGPUVirtualAddress: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
        ) -> D3D12_GPU_VIRTUAL_ADDRESS,
    >,
    pub WriteToSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            DstSubresource: UINT,
            pDstBox: *const D3D12_BOX,
            pSrcData: *const ::std::os::raw::c_void,
            SrcRowPitch: UINT,
            SrcDepthPitch: UINT,
        ) -> HRESULT,
    >,
    pub ReadFromSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            pDstData: *mut ::std::os::raw::c_void,
            DstRowPitch: UINT,
            DstDepthPitch: UINT,
            SrcSubresource: UINT,
            pSrcBox: *const D3D12_BOX,
        ) -> HRESULT,
    >,
    pub GetHeapProperties: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            pHeapProperties: *mut D3D12_HEAP_PROPERTIES,
            pHeapFlags: *mut D3D12_HEAP_FLAGS,
        ) -> HRESULT,
    >,
    pub GetProtectedResourceSession: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource1,
            riid: *const IID,
            ppProtectedSession: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Resource1 {
    pub lpVtbl: *mut ID3D12Resource1Vtbl,
}
impl Default for ID3D12Resource1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Resource2: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Resource2Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Resource2) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Resource2) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub Map: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            Subresource: UINT,
            pReadRange: *const D3D12_RANGE,
            ppData: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub Unmap: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            Subresource: UINT,
            pWrittenRange: *const D3D12_RANGE,
        ),
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            RetVal: *mut D3D12_RESOURCE_DESC,
        ) -> *mut D3D12_RESOURCE_DESC,
    >,
    pub GetGPUVirtualAddress: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
        ) -> D3D12_GPU_VIRTUAL_ADDRESS,
    >,
    pub WriteToSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            DstSubresource: UINT,
            pDstBox: *const D3D12_BOX,
            pSrcData: *const ::std::os::raw::c_void,
            SrcRowPitch: UINT,
            SrcDepthPitch: UINT,
        ) -> HRESULT,
    >,
    pub ReadFromSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            pDstData: *mut ::std::os::raw::c_void,
            DstRowPitch: UINT,
            DstDepthPitch: UINT,
            SrcSubresource: UINT,
            pSrcBox: *const D3D12_BOX,
        ) -> HRESULT,
    >,
    pub GetHeapProperties: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            pHeapProperties: *mut D3D12_HEAP_PROPERTIES,
            pHeapFlags: *mut D3D12_HEAP_FLAGS,
        ) -> HRESULT,
    >,
    pub GetProtectedResourceSession: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            riid: *const IID,
            ppProtectedSession: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDesc1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Resource2,
            RetVal: *mut D3D12_RESOURCE_DESC1,
        ) -> *mut D3D12_RESOURCE_DESC1,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Resource2 {
    pub lpVtbl: *mut ID3D12Resource2Vtbl,
}
impl Default for ID3D12Resource2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Heap1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Heap1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Heap1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Heap1) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap1,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap1,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap1,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Heap1, Name: LPCWSTR) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap1,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap1,
            RetVal: *mut D3D12_HEAP_DESC,
        ) -> *mut D3D12_HEAP_DESC,
    >,
    pub GetProtectedResourceSession: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Heap1,
            riid: *const IID,
            ppProtectedSession: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Heap1 {
    pub lpVtbl: *mut ID3D12Heap1Vtbl,
}
impl Default for ID3D12Heap1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12GraphicsCommandList3: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList3Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList3) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList3) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetType: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
        ) -> D3D12_COMMAND_LIST_TYPE,
    >,
    pub Close: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList3) -> HRESULT,
    >,
    pub Reset: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pAllocator: *mut ID3D12CommandAllocator,
            pInitialState: *mut ID3D12PipelineState,
        ) -> HRESULT,
    >,
    pub ClearState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pPipelineState: *mut ID3D12PipelineState,
        ),
    >,
    pub DrawInstanced: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            VertexCountPerInstance: UINT,
            InstanceCount: UINT,
            StartVertexLocation: UINT,
            StartInstanceLocation: UINT,
        ),
    >,
    pub DrawIndexedInstanced: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            IndexCountPerInstance: UINT,
            InstanceCount: UINT,
            StartIndexLocation: UINT,
            BaseVertexLocation: INT,
            StartInstanceLocation: UINT,
        ),
    >,
    pub Dispatch: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            ThreadGroupCountX: UINT,
            ThreadGroupCountY: UINT,
            ThreadGroupCountZ: UINT,
        ),
    >,
    pub CopyBufferRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            NumBytes: UINT64,
        ),
    >,
    pub CopyTextureRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pDst: *const D3D12_TEXTURE_COPY_LOCATION,
            DstX: UINT,
            DstY: UINT,
            DstZ: UINT,
            pSrc: *const D3D12_TEXTURE_COPY_LOCATION,
            pSrcBox: *const D3D12_BOX,
        ),
    >,
    pub CopyResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pDstResource: *mut ID3D12Resource,
            pSrcResource: *mut ID3D12Resource,
        ),
    >,
    pub CopyTiles: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pTiledResource: *mut ID3D12Resource,
            pTileRegionStartCoordinate: *const D3D12_TILED_RESOURCE_COORDINATE,
            pTileRegionSize: *const D3D12_TILE_REGION_SIZE,
            pBuffer: *mut ID3D12Resource,
            BufferStartOffsetInBytes: UINT64,
            Flags: D3D12_TILE_COPY_FLAGS,
        ),
    >,
    pub ResolveSubresource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pDstResource: *mut ID3D12Resource,
            DstSubresource: UINT,
            pSrcResource: *mut ID3D12Resource,
            SrcSubresource: UINT,
            Format: DXGI_FORMAT,
        ),
    >,
    pub IASetPrimitiveTopology: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            PrimitiveTopology: D3D12_PRIMITIVE_TOPOLOGY,
        ),
    >,
    pub RSSetViewports: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            NumViewports: UINT,
            pViewports: *const D3D12_VIEWPORT,
        ),
    >,
    pub RSSetScissorRects: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub OMSetBlendFactor: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            BlendFactor: *const FLOAT,
        ),
    >,
    pub OMSetStencilRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            StencilRef: UINT,
        ),
    >,
    pub SetPipelineState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pPipelineState: *mut ID3D12PipelineState,
        ),
    >,
    pub ResourceBarrier: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            NumBarriers: UINT,
            pBarriers: *const D3D12_RESOURCE_BARRIER,
        ),
    >,
    pub ExecuteBundle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pCommandList: *mut ID3D12GraphicsCommandList,
        ),
    >,
    pub SetDescriptorHeaps: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            NumDescriptorHeaps: UINT,
            ppDescriptorHeaps: *const *mut ID3D12DescriptorHeap,
        ),
    >,
    pub SetComputeRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pRootSignature: *mut ID3D12RootSignature,
        ),
    >,
    pub SetGraphicsRootSignature: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pRootSignature: *mut ID3D12RootSignature,
        ),
    >,
    pub SetComputeRootDescriptorTable: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub SetGraphicsRootDescriptorTable: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub SetComputeRoot32BitConstant: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            SrcData: UINT,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetGraphicsRoot32BitConstant: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            SrcData: UINT,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetComputeRoot32BitConstants: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            Num32BitValuesToSet: UINT,
            pSrcData: *const ::std::os::raw::c_void,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetGraphicsRoot32BitConstants: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            Num32BitValuesToSet: UINT,
            pSrcData: *const ::std::os::raw::c_void,
            DestOffsetIn32BitValues: UINT,
        ),
    >,
    pub SetComputeRootConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootConstantBufferView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetComputeRootShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootShaderResourceView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetComputeRootUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub SetGraphicsRootUnorderedAccessView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RootParameterIndex: UINT,
            BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
        ),
    >,
    pub IASetIndexBuffer: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pView: *const D3D12_INDEX_BUFFER_VIEW,
        ),
    >,
    pub IASetVertexBuffers: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            StartSlot: UINT,
            NumViews: UINT,
            pViews: *const D3D12_VERTEX_BUFFER_VIEW,
        ),
    >,
    pub SOSetTargets: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            StartSlot: UINT,
            NumViews: UINT,
            pViews: *const D3D12_STREAM_OUTPUT_BUFFER_VIEW,
        ),
    >,
    pub OMSetRenderTargets: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            NumRenderTargetDescriptors: UINT,
            pRenderTargetDescriptors: *const D3D12_CPU_DESCRIPTOR_HANDLE,
            RTsSingleHandleToDescriptorRange: BOOL,
            pDepthStencilDescriptor: *const D3D12_CPU_DESCRIPTOR_HANDLE,
        ),
    >,
    pub ClearDepthStencilView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            DepthStencilView: D3D12_CPU_DESCRIPTOR_HANDLE,
            ClearFlags: D3D12_CLEAR_FLAGS,
            Depth: FLOAT,
            Stencil: UINT8,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearRenderTargetView: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            RenderTargetView: D3D12_CPU_DESCRIPTOR_HANDLE,
            ColorRGBA: *const FLOAT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearUnorderedAccessViewUint: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
            ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
            pResource: *mut ID3D12Resource,
            Values: *const UINT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub ClearUnorderedAccessViewFloat: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
            ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
            pResource: *mut ID3D12Resource,
            Values: *const FLOAT,
            NumRects: UINT,
            pRects: *const D3D12_RECT,
        ),
    >,
    pub DiscardResource: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pResource: *mut ID3D12Resource,
            pRegion: *const D3D12_DISCARD_REGION,
        ),
    >,
    pub BeginQuery: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            Index: UINT,
        ),
    >,
    pub EndQuery: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            Index: UINT,
        ),
    >,
    pub ResolveQueryData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pQueryHeap: *mut ID3D12QueryHeap,
            Type: D3D12_QUERY_TYPE,
            StartIndex: UINT,
            NumQueries: UINT,
            pDestinationBuffer: *mut ID3D12Resource,
            AlignedDestinationBufferOffset: UINT64,
        ),
    >,
    pub SetPredication: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pBuffer: *mut ID3D12Resource,
            AlignedBufferOffset: UINT64,
            Operation: D3D12_PREDICATION_OP,
        ),
    >,
    pub SetMarker: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            Metadata: UINT,
            pData: *const ::std::os::raw::c_void,
            Size: UINT,
        ),
    >,
    pub BeginEvent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            Metadata: UINT,
            pData: *const ::std::os::raw::c_void,
            Size: UINT,
        ),
    >,
    pub EndEvent: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList3),
    >,
    pub ExecuteIndirect: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pCommandSignature: *mut ID3D12CommandSignature,
            MaxCommandCount: UINT,
            pArgumentBuffer: *mut ID3D12Resource,
            ArgumentBufferOffset: UINT64,
            pCountBuffer: *mut ID3D12Resource,
            CountBufferOffset: UINT64,
        ),
    >,
    pub AtomicCopyBufferUINT: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            Dependencies: UINT,
            ppDependentResources: *const *mut ID3D12Resource,
            pDependentSubresourceRanges: *const D3D12_SUBRESOURCE_RANGE_UINT64,
        ),
    >,
    pub AtomicCopyBufferUINT64: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pDstBuffer: *mut ID3D12Resource,
            DstOffset: UINT64,
            pSrcBuffer: *mut ID3D12Resource,
            SrcOffset: UINT64,
            Dependencies: UINT,
            ppDependentResources: *const *mut ID3D12Resource,
            pDependentSubresourceRanges: *const D3D12_SUBRESOURCE_RANGE_UINT64,
        ),
    >,
    pub OMSetDepthBounds: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            Min: FLOAT,
            Max: FLOAT,
        ),
    >,
    pub SetSamplePositions: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            NumSamplesPerPixel: UINT,
            NumPixels: UINT,
            pSamplePositions: *mut D3D12_SAMPLE_POSITION,
        ),
    >,
    pub ResolveSubresourceRegion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pDstResource: *mut ID3D12Resource,
            DstSubresource: UINT,
            DstX: UINT,
            DstY: UINT,
            pSrcResource: *mut ID3D12Resource,
            SrcSubresource: UINT,
            pSrcRect: *mut D3D12_RECT,
            Format: DXGI_FORMAT,
            ResolveMode: D3D12_RESOLVE_MODE,
        ),
    >,
    pub SetViewInstanceMask: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12GraphicsCommandList3, Mask: UINT),
    >,
    pub WriteBufferImmediate: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            Count: UINT,
            pParams: *const D3D12_WRITEBUFFERIMMEDIATE_PARAMETER,
            pModes: *const D3D12_WRITEBUFFERIMMEDIATE_MODE,
        ),
    >,
    pub SetProtectedResourceSession: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12GraphicsCommandList3,
            pProtectedResourceSession: *mut ID3D12ProtectedResourceSession,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList3 {
    pub lpVtbl: *mut ID3D12GraphicsCommandList3Vtbl,
}
impl Default for ID3D12GraphicsCommandList3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_DISCARD : D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = 0 ;
pub const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_PRESERVE : D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = 1 ;
pub const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_CLEAR : D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = 2 ;
pub const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_NO_ACCESS : D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = 3 ;
pub type D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {
    pub ClearValue: D3D12_CLEAR_VALUE,
}
impl Default for D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {{ ClearValue: {:?} }}" , self . ClearValue)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_RENDER_PASS_BEGINNING_ACCESS {
    pub Type: D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE,
    pub __bindgen_anon_1: D3D12_RENDER_PASS_BEGINNING_ACCESS__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_RENDER_PASS_BEGINNING_ACCESS__bindgen_ty_1 {
    pub Clear: D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS,
}
impl Default for D3D12_RENDER_PASS_BEGINNING_ACCESS__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_PASS_BEGINNING_ACCESS__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "D3D12_RENDER_PASS_BEGINNING_ACCESS__bindgen_ty_1 {{ union }}"
        )
    }
}
impl Default for D3D12_RENDER_PASS_BEGINNING_ACCESS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_PASS_BEGINNING_ACCESS {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_RENDER_PASS_BEGINNING_ACCESS {{ Type: {:?}, __bindgen_anon_1: {:?} }}" , self . Type , self . __bindgen_anon_1)
    }
}
pub const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_DISCARD : D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = 0 ;
pub const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_PRESERVE : D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = 1 ;
pub const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_RESOLVE : D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = 2 ;
pub const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_NO_ACCESS : D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = 3 ;
pub type D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS {
    pub SrcSubresource: UINT,
    pub DstSubresource: UINT,
    pub DstX: UINT,
    pub DstY: UINT,
    pub SrcRect: D3D12_RECT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {
    pub pSrcResource: *mut ID3D12Resource,
    pub pDstResource: *mut ID3D12Resource,
    pub SubresourceCount: UINT,
    pub pSubresourceParameters:
        *const D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS,
    pub Format: DXGI_FORMAT,
    pub ResolveMode: D3D12_RESOLVE_MODE,
    pub PreserveResolveSource: BOOL,
}
impl Default for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_RENDER_PASS_ENDING_ACCESS {
    pub Type: D3D12_RENDER_PASS_ENDING_ACCESS_TYPE,
    pub __bindgen_anon_1: D3D12_RENDER_PASS_ENDING_ACCESS__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_RENDER_PASS_ENDING_ACCESS__bindgen_ty_1 {
    pub Resolve: D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS,
}
impl Default for D3D12_RENDER_PASS_ENDING_ACCESS__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_PASS_ENDING_ACCESS__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "D3D12_RENDER_PASS_ENDING_ACCESS__bindgen_ty_1 {{ union }}"
        )
    }
}
impl Default for D3D12_RENDER_PASS_ENDING_ACCESS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_PASS_ENDING_ACCESS {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_RENDER_PASS_ENDING_ACCESS {{ Type: {:?}, __bindgen_anon_1: {:?} }}" , self . Type , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_RENDER_PASS_RENDER_TARGET_DESC {
    pub cpuDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    pub BeginningAccess: D3D12_RENDER_PASS_BEGINNING_ACCESS,
    pub EndingAccess: D3D12_RENDER_PASS_ENDING_ACCESS,
}
impl Default for D3D12_RENDER_PASS_RENDER_TARGET_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_PASS_RENDER_TARGET_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_RENDER_PASS_RENDER_TARGET_DESC {{ cpuDescriptor: {:?}, BeginningAccess: {:?}, EndingAccess: {:?} }}" , self . cpuDescriptor , self . BeginningAccess , self . EndingAccess)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {
    pub cpuDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    pub DepthBeginningAccess: D3D12_RENDER_PASS_BEGINNING_ACCESS,
    pub StencilBeginningAccess: D3D12_RENDER_PASS_BEGINNING_ACCESS,
    pub DepthEndingAccess: D3D12_RENDER_PASS_ENDING_ACCESS,
    pub StencilEndingAccess: D3D12_RENDER_PASS_ENDING_ACCESS,
}
impl Default for D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {{ cpuDescriptor: {:?}, DepthBeginningAccess: {:?}, StencilBeginningAccess: {:?}, DepthEndingAccess: {:?}, StencilEndingAccess: {:?} }}" , self . cpuDescriptor , self . DepthBeginningAccess , self . StencilBeginningAccess , self . DepthEndingAccess , self . StencilEndingAccess)
    }
}
pub const D3D12_RENDER_PASS_FLAGS_D3D12_RENDER_PASS_FLAG_NONE:
    D3D12_RENDER_PASS_FLAGS = 0;
pub const D3D12_RENDER_PASS_FLAGS_D3D12_RENDER_PASS_FLAG_ALLOW_UAV_WRITES:
    D3D12_RENDER_PASS_FLAGS = 1;
pub const D3D12_RENDER_PASS_FLAGS_D3D12_RENDER_PASS_FLAG_SUSPENDING_PASS:
    D3D12_RENDER_PASS_FLAGS = 2;
pub const D3D12_RENDER_PASS_FLAGS_D3D12_RENDER_PASS_FLAG_RESUMING_PASS:
    D3D12_RENDER_PASS_FLAGS = 4;
pub type D3D12_RENDER_PASS_FLAGS = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12MetaCommand: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12MetaCommandVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12MetaCommand,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12MetaCommand) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12MetaCommand) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12MetaCommand,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12MetaCommand,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12MetaCommand,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12MetaCommand,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12MetaCommand,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetRequiredParameterResourceSize: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12MetaCommand,
            Stage: D3D12_META_COMMAND_PARAMETER_STAGE,
            ParameterIndex: UINT,
        ) -> UINT64,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12MetaCommand {
    pub lpVtbl: *mut ID3D12MetaCommandVtbl,
}
impl Default for ID3D12MetaCommand {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DISPATCH_RAYS_DESC {
    pub RayGenerationShaderRecord: D3D12_GPU_VIRTUAL_ADDRESS_RANGE,
    pub MissShaderTable: D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE,
    pub HitGroupTable: D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE,
    pub CallableShaderTable: D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE,
    pub Width: UINT,
    pub Height: UINT,
    pub Depth: UINT,
}
extern "C" {
    pub static IID_ID3D12GraphicsCommandList4: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList4Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , Name : LPCWSTR) -> HRESULT > , pub GetDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , riid : * const IID , ppvDevice : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetType : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4) -> D3D12_COMMAND_LIST_TYPE > , pub Close : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4) -> HRESULT > , pub Reset : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState) -> HRESULT > , pub ClearState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pPipelineState : * mut ID3D12PipelineState) > , pub DrawInstanced : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , VertexCountPerInstance : UINT , InstanceCount : UINT , StartVertexLocation : UINT , StartInstanceLocation : UINT) > , pub DrawIndexedInstanced : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , IndexCountPerInstance : UINT , InstanceCount : UINT , StartIndexLocation : UINT , BaseVertexLocation : INT , StartInstanceLocation : UINT) > , pub Dispatch : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , ThreadGroupCountX : UINT , ThreadGroupCountY : UINT , ThreadGroupCountZ : UINT) > , pub CopyBufferRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , NumBytes : UINT64) > , pub CopyTextureRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDst : * const D3D12_TEXTURE_COPY_LOCATION , DstX : UINT , DstY : UINT , DstZ : UINT , pSrc : * const D3D12_TEXTURE_COPY_LOCATION , pSrcBox : * const D3D12_BOX) > , pub CopyResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDstResource : * mut ID3D12Resource , pSrcResource : * mut ID3D12Resource) > , pub CopyTiles : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pTiledResource : * mut ID3D12Resource , pTileRegionStartCoordinate : * const D3D12_TILED_RESOURCE_COORDINATE , pTileRegionSize : * const D3D12_TILE_REGION_SIZE , pBuffer : * mut ID3D12Resource , BufferStartOffsetInBytes : UINT64 , Flags : D3D12_TILE_COPY_FLAGS) > , pub ResolveSubresource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDstResource : * mut ID3D12Resource , DstSubresource : UINT , pSrcResource : * mut ID3D12Resource , SrcSubresource : UINT , Format : DXGI_FORMAT) > , pub IASetPrimitiveTopology : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , PrimitiveTopology : D3D12_PRIMITIVE_TOPOLOGY) > , pub RSSetViewports : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , NumViewports : UINT , pViewports : * const D3D12_VIEWPORT) > , pub RSSetScissorRects : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , NumRects : UINT , pRects : * const D3D12_RECT) > , pub OMSetBlendFactor : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , BlendFactor : * const FLOAT) > , pub OMSetStencilRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , StencilRef : UINT) > , pub SetPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pPipelineState : * mut ID3D12PipelineState) > , pub ResourceBarrier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , NumBarriers : UINT , pBarriers : * const D3D12_RESOURCE_BARRIER) > , pub ExecuteBundle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pCommandList : * mut ID3D12GraphicsCommandList) > , pub SetDescriptorHeaps : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , NumDescriptorHeaps : UINT , ppDescriptorHeaps : * const * mut ID3D12DescriptorHeap) > , pub SetComputeRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pRootSignature : * mut ID3D12RootSignature) > , pub SetGraphicsRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pRootSignature : * mut ID3D12RootSignature) > , pub SetComputeRootDescriptorTable : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , BaseDescriptor : D3D12_GPU_DESCRIPTOR_HANDLE) > , pub SetGraphicsRootDescriptorTable : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , BaseDescriptor : D3D12_GPU_DESCRIPTOR_HANDLE) > , pub SetComputeRoot32BitConstant : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , SrcData : UINT , DestOffsetIn32BitValues : UINT) > , pub SetGraphicsRoot32BitConstant : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , SrcData : UINT , DestOffsetIn32BitValues : UINT) > , pub SetComputeRoot32BitConstants : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , Num32BitValuesToSet : UINT , pSrcData : * const :: std :: os :: raw :: c_void , DestOffsetIn32BitValues : UINT) > , pub SetGraphicsRoot32BitConstants : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , Num32BitValuesToSet : UINT , pSrcData : * const :: std :: os :: raw :: c_void , DestOffsetIn32BitValues : UINT) > , pub SetComputeRootConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetComputeRootShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetComputeRootUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub IASetIndexBuffer : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pView : * const D3D12_INDEX_BUFFER_VIEW) > , pub IASetVertexBuffers : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , StartSlot : UINT , NumViews : UINT , pViews : * const D3D12_VERTEX_BUFFER_VIEW) > , pub SOSetTargets : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , StartSlot : UINT , NumViews : UINT , pViews : * const D3D12_STREAM_OUTPUT_BUFFER_VIEW) > , pub OMSetRenderTargets : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , NumRenderTargetDescriptors : UINT , pRenderTargetDescriptors : * const D3D12_CPU_DESCRIPTOR_HANDLE , RTsSingleHandleToDescriptorRange : BOOL , pDepthStencilDescriptor : * const D3D12_CPU_DESCRIPTOR_HANDLE) > , pub ClearDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , DepthStencilView : D3D12_CPU_DESCRIPTOR_HANDLE , ClearFlags : D3D12_CLEAR_FLAGS , Depth : FLOAT , Stencil : UINT8 , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , RenderTargetView : D3D12_CPU_DESCRIPTOR_HANDLE , ColorRGBA : * const FLOAT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearUnorderedAccessViewUint : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , ViewGPUHandleInCurrentHeap : D3D12_GPU_DESCRIPTOR_HANDLE , ViewCPUHandle : D3D12_CPU_DESCRIPTOR_HANDLE , pResource : * mut ID3D12Resource , Values : * const UINT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearUnorderedAccessViewFloat : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , ViewGPUHandleInCurrentHeap : D3D12_GPU_DESCRIPTOR_HANDLE , ViewCPUHandle : D3D12_CPU_DESCRIPTOR_HANDLE , pResource : * mut ID3D12Resource , Values : * const FLOAT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub DiscardResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pResource : * mut ID3D12Resource , pRegion : * const D3D12_DISCARD_REGION) > , pub BeginQuery : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , Index : UINT) > , pub EndQuery : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , Index : UINT) > , pub ResolveQueryData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , StartIndex : UINT , NumQueries : UINT , pDestinationBuffer : * mut ID3D12Resource , AlignedDestinationBufferOffset : UINT64) > , pub SetPredication : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pBuffer : * mut ID3D12Resource , AlignedBufferOffset : UINT64 , Operation : D3D12_PREDICATION_OP) > , pub SetMarker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub BeginEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub EndEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4) > , pub ExecuteIndirect : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pCommandSignature : * mut ID3D12CommandSignature , MaxCommandCount : UINT , pArgumentBuffer : * mut ID3D12Resource , ArgumentBufferOffset : UINT64 , pCountBuffer : * mut ID3D12Resource , CountBufferOffset : UINT64) > , pub AtomicCopyBufferUINT : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , Dependencies : UINT , ppDependentResources : * const * mut ID3D12Resource , pDependentSubresourceRanges : * const D3D12_SUBRESOURCE_RANGE_UINT64) > , pub AtomicCopyBufferUINT64 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , Dependencies : UINT , ppDependentResources : * const * mut ID3D12Resource , pDependentSubresourceRanges : * const D3D12_SUBRESOURCE_RANGE_UINT64) > , pub OMSetDepthBounds : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , Min : FLOAT , Max : FLOAT) > , pub SetSamplePositions : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , NumSamplesPerPixel : UINT , NumPixels : UINT , pSamplePositions : * mut D3D12_SAMPLE_POSITION) > , pub ResolveSubresourceRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDstResource : * mut ID3D12Resource , DstSubresource : UINT , DstX : UINT , DstY : UINT , pSrcResource : * mut ID3D12Resource , SrcSubresource : UINT , pSrcRect : * mut D3D12_RECT , Format : DXGI_FORMAT , ResolveMode : D3D12_RESOLVE_MODE) > , pub SetViewInstanceMask : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , Mask : UINT) > , pub WriteBufferImmediate : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , Count : UINT , pParams : * const D3D12_WRITEBUFFERIMMEDIATE_PARAMETER , pModes : * const D3D12_WRITEBUFFERIMMEDIATE_MODE) > , pub SetProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pProtectedResourceSession : * mut ID3D12ProtectedResourceSession) > , pub BeginRenderPass : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , NumRenderTargets : UINT , pRenderTargets : * const D3D12_RENDER_PASS_RENDER_TARGET_DESC , pDepthStencil : * const D3D12_RENDER_PASS_DEPTH_STENCIL_DESC , Flags : D3D12_RENDER_PASS_FLAGS) > , pub EndRenderPass : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4) > , pub InitializeMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pMetaCommand : * mut ID3D12MetaCommand , pInitializationParametersData : * const :: std :: os :: raw :: c_void , InitializationParametersDataSizeInBytes : SIZE_T) > , pub ExecuteMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pMetaCommand : * mut ID3D12MetaCommand , pExecutionParametersData : * const :: std :: os :: raw :: c_void , ExecutionParametersDataSizeInBytes : SIZE_T) > , pub BuildRaytracingAccelerationStructure : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC , NumPostbuildInfoDescs : UINT , pPostbuildInfoDescs : * const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC) > , pub EmitRaytracingAccelerationStructurePostbuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDesc : * const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC , NumSourceAccelerationStructures : UINT , pSourceAccelerationStructureData : * const D3D12_GPU_VIRTUAL_ADDRESS) > , pub CopyRaytracingAccelerationStructure : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , DestAccelerationStructureData : D3D12_GPU_VIRTUAL_ADDRESS , SourceAccelerationStructureData : D3D12_GPU_VIRTUAL_ADDRESS , Mode : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE) > , pub SetPipelineState1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pStateObject : * mut ID3D12StateObject) > , pub DispatchRays : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList4 , pDesc : * const D3D12_DISPATCH_RAYS_DESC) > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList4 {
    pub lpVtbl: *mut ID3D12GraphicsCommandList4Vtbl,
}
impl Default for ID3D12GraphicsCommandList4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_SHADER_CACHE_MODE_D3D12_SHADER_CACHE_MODE_MEMORY:
    D3D12_SHADER_CACHE_MODE = 0;
pub const D3D12_SHADER_CACHE_MODE_D3D12_SHADER_CACHE_MODE_DISK:
    D3D12_SHADER_CACHE_MODE = 1;
pub type D3D12_SHADER_CACHE_MODE = ::std::os::raw::c_int;
pub const D3D12_SHADER_CACHE_FLAGS_D3D12_SHADER_CACHE_FLAG_NONE:
    D3D12_SHADER_CACHE_FLAGS = 0;
pub const D3D12_SHADER_CACHE_FLAGS_D3D12_SHADER_CACHE_FLAG_DRIVER_VERSIONED:
    D3D12_SHADER_CACHE_FLAGS = 1;
pub const D3D12_SHADER_CACHE_FLAGS_D3D12_SHADER_CACHE_FLAG_USE_WORKING_DIR:
    D3D12_SHADER_CACHE_FLAGS = 2;
pub type D3D12_SHADER_CACHE_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SHADER_CACHE_SESSION_DESC {
    pub Identifier: GUID,
    pub Mode: D3D12_SHADER_CACHE_MODE,
    pub Flags: D3D12_SHADER_CACHE_FLAGS,
    pub MaximumInMemoryCacheSizeBytes: UINT,
    pub MaximumInMemoryCacheEntries: UINT,
    pub MaximumValueFileSizeBytes: UINT,
    pub Version: UINT64,
}
impl Default for D3D12_SHADER_CACHE_SESSION_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_UNDEFINED:
    D3D12_BARRIER_LAYOUT = -1;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COMMON:
    D3D12_BARRIER_LAYOUT = 0;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_PRESENT:
    D3D12_BARRIER_LAYOUT = 0;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_GENERIC_READ:
    D3D12_BARRIER_LAYOUT = 1;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_RENDER_TARGET:
    D3D12_BARRIER_LAYOUT = 2;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_UNORDERED_ACCESS:
    D3D12_BARRIER_LAYOUT = 3;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_DEPTH_STENCIL_WRITE:
    D3D12_BARRIER_LAYOUT = 4;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_DEPTH_STENCIL_READ:
    D3D12_BARRIER_LAYOUT = 5;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_SHADER_RESOURCE:
    D3D12_BARRIER_LAYOUT = 6;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COPY_SOURCE:
    D3D12_BARRIER_LAYOUT = 7;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COPY_DEST:
    D3D12_BARRIER_LAYOUT = 8;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_RESOLVE_SOURCE:
    D3D12_BARRIER_LAYOUT = 9;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_RESOLVE_DEST:
    D3D12_BARRIER_LAYOUT = 10;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_SHADING_RATE_SOURCE:
    D3D12_BARRIER_LAYOUT = 11;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_VIDEO_DECODE_READ:
    D3D12_BARRIER_LAYOUT = 12;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_VIDEO_DECODE_WRITE:
    D3D12_BARRIER_LAYOUT = 13;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_VIDEO_PROCESS_READ:
    D3D12_BARRIER_LAYOUT = 14;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_VIDEO_PROCESS_WRITE:
    D3D12_BARRIER_LAYOUT = 15;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_VIDEO_ENCODE_READ:
    D3D12_BARRIER_LAYOUT = 16;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_VIDEO_ENCODE_WRITE:
    D3D12_BARRIER_LAYOUT = 17;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_COMMON:
    D3D12_BARRIER_LAYOUT = 18;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_GENERIC_READ : D3D12_BARRIER_LAYOUT = 19 ;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_UNORDERED_ACCESS : D3D12_BARRIER_LAYOUT = 20 ;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_SHADER_RESOURCE : D3D12_BARRIER_LAYOUT = 21 ;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_COPY_SOURCE:
    D3D12_BARRIER_LAYOUT = 22;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_COPY_DEST:
    D3D12_BARRIER_LAYOUT = 23;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_COMMON:
    D3D12_BARRIER_LAYOUT = 24;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_GENERIC_READ : D3D12_BARRIER_LAYOUT = 25 ;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_UNORDERED_ACCESS : D3D12_BARRIER_LAYOUT = 26 ;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_SHADER_RESOURCE : D3D12_BARRIER_LAYOUT = 27 ;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_COPY_SOURCE : D3D12_BARRIER_LAYOUT = 28 ;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_COPY_DEST:
    D3D12_BARRIER_LAYOUT = 29;
pub const D3D12_BARRIER_LAYOUT_D3D12_BARRIER_LAYOUT_VIDEO_QUEUE_COMMON:
    D3D12_BARRIER_LAYOUT = 30;
pub type D3D12_BARRIER_LAYOUT = ::std::os::raw::c_int;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_NONE: D3D12_BARRIER_SYNC = 0;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_ALL: D3D12_BARRIER_SYNC = 1;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_DRAW: D3D12_BARRIER_SYNC = 2;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_INPUT_ASSEMBLER:
    D3D12_BARRIER_SYNC = 4;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_VERTEX_SHADING:
    D3D12_BARRIER_SYNC = 8;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_PIXEL_SHADING:
    D3D12_BARRIER_SYNC = 16;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_DEPTH_STENCIL:
    D3D12_BARRIER_SYNC = 32;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_RENDER_TARGET:
    D3D12_BARRIER_SYNC = 64;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_COMPUTE_SHADING:
    D3D12_BARRIER_SYNC = 128;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_RAYTRACING: D3D12_BARRIER_SYNC =
    256;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_COPY: D3D12_BARRIER_SYNC = 512;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_RESOLVE: D3D12_BARRIER_SYNC =
    1024;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_EXECUTE_INDIRECT:
    D3D12_BARRIER_SYNC = 2048;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_PREDICATION:
    D3D12_BARRIER_SYNC = 2048;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_ALL_SHADING:
    D3D12_BARRIER_SYNC = 4096;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_NON_PIXEL_SHADING:
    D3D12_BARRIER_SYNC = 8192;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_EMIT_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO : D3D12_BARRIER_SYNC = 16384 ;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_VIDEO_DECODE:
    D3D12_BARRIER_SYNC = 1048576;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_VIDEO_PROCESS:
    D3D12_BARRIER_SYNC = 2097152;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_VIDEO_ENCODE:
    D3D12_BARRIER_SYNC = 4194304;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_BUILD_RAYTRACING_ACCELERATION_STRUCTURE : D3D12_BARRIER_SYNC = 8388608 ;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_COPY_RAYTRACING_ACCELERATION_STRUCTURE : D3D12_BARRIER_SYNC = 16777216 ;
pub const D3D12_BARRIER_SYNC_D3D12_BARRIER_SYNC_SPLIT: D3D12_BARRIER_SYNC =
    -2147483648;
pub type D3D12_BARRIER_SYNC = ::std::os::raw::c_int;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_COMMON:
    D3D12_BARRIER_ACCESS = 0;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_VERTEX_BUFFER:
    D3D12_BARRIER_ACCESS = 1;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_CONSTANT_BUFFER:
    D3D12_BARRIER_ACCESS = 2;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_INDEX_BUFFER:
    D3D12_BARRIER_ACCESS = 4;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_RENDER_TARGET:
    D3D12_BARRIER_ACCESS = 8;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_UNORDERED_ACCESS:
    D3D12_BARRIER_ACCESS = 16;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_DEPTH_STENCIL_WRITE:
    D3D12_BARRIER_ACCESS = 32;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_DEPTH_STENCIL_READ:
    D3D12_BARRIER_ACCESS = 64;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_SHADER_RESOURCE:
    D3D12_BARRIER_ACCESS = 128;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_STREAM_OUTPUT:
    D3D12_BARRIER_ACCESS = 256;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_INDIRECT_ARGUMENT:
    D3D12_BARRIER_ACCESS = 512;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_PREDICATION:
    D3D12_BARRIER_ACCESS = 512;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_COPY_DEST:
    D3D12_BARRIER_ACCESS = 1024;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_COPY_SOURCE:
    D3D12_BARRIER_ACCESS = 2048;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_RESOLVE_DEST:
    D3D12_BARRIER_ACCESS = 4096;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_RESOLVE_SOURCE:
    D3D12_BARRIER_ACCESS = 8192;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_RAYTRACING_ACCELERATION_STRUCTURE_READ : D3D12_BARRIER_ACCESS = 16384 ;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_RAYTRACING_ACCELERATION_STRUCTURE_WRITE : D3D12_BARRIER_ACCESS = 32768 ;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_SHADING_RATE_SOURCE:
    D3D12_BARRIER_ACCESS = 65536;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_VIDEO_DECODE_READ:
    D3D12_BARRIER_ACCESS = 131072;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_VIDEO_DECODE_WRITE:
    D3D12_BARRIER_ACCESS = 262144;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_VIDEO_PROCESS_READ:
    D3D12_BARRIER_ACCESS = 524288;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_VIDEO_PROCESS_WRITE:
    D3D12_BARRIER_ACCESS = 1048576;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_VIDEO_ENCODE_READ:
    D3D12_BARRIER_ACCESS = 2097152;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_VIDEO_ENCODE_WRITE:
    D3D12_BARRIER_ACCESS = 4194304;
pub const D3D12_BARRIER_ACCESS_D3D12_BARRIER_ACCESS_NO_ACCESS:
    D3D12_BARRIER_ACCESS = -2147483648;
pub type D3D12_BARRIER_ACCESS = ::std::os::raw::c_int;
pub const D3D12_BARRIER_TYPE_D3D12_BARRIER_TYPE_GLOBAL: D3D12_BARRIER_TYPE = 0;
pub const D3D12_BARRIER_TYPE_D3D12_BARRIER_TYPE_TEXTURE: D3D12_BARRIER_TYPE = 1;
pub const D3D12_BARRIER_TYPE_D3D12_BARRIER_TYPE_BUFFER: D3D12_BARRIER_TYPE = 2;
pub type D3D12_BARRIER_TYPE = ::std::os::raw::c_int;
pub const D3D12_TEXTURE_BARRIER_FLAGS_D3D12_TEXTURE_BARRIER_FLAG_NONE:
    D3D12_TEXTURE_BARRIER_FLAGS = 0;
pub const D3D12_TEXTURE_BARRIER_FLAGS_D3D12_TEXTURE_BARRIER_FLAG_DISCARD:
    D3D12_TEXTURE_BARRIER_FLAGS = 1;
pub type D3D12_TEXTURE_BARRIER_FLAGS = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_BARRIER_SUBRESOURCE_RANGE {
    pub IndexOrFirstMipLevel: UINT,
    pub NumMipLevels: UINT,
    pub FirstArraySlice: UINT,
    pub NumArraySlices: UINT,
    pub FirstPlane: UINT,
    pub NumPlanes: UINT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_GLOBAL_BARRIER {
    pub SyncBefore: D3D12_BARRIER_SYNC,
    pub SyncAfter: D3D12_BARRIER_SYNC,
    pub AccessBefore: D3D12_BARRIER_ACCESS,
    pub AccessAfter: D3D12_BARRIER_ACCESS,
}
impl Default for D3D12_GLOBAL_BARRIER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_TEXTURE_BARRIER {
    pub SyncBefore: D3D12_BARRIER_SYNC,
    pub SyncAfter: D3D12_BARRIER_SYNC,
    pub AccessBefore: D3D12_BARRIER_ACCESS,
    pub AccessAfter: D3D12_BARRIER_ACCESS,
    pub LayoutBefore: D3D12_BARRIER_LAYOUT,
    pub LayoutAfter: D3D12_BARRIER_LAYOUT,
    pub pResource: *mut ID3D12Resource,
    pub Subresources: D3D12_BARRIER_SUBRESOURCE_RANGE,
    pub Flags: D3D12_TEXTURE_BARRIER_FLAGS,
}
impl Default for D3D12_TEXTURE_BARRIER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_BUFFER_BARRIER {
    pub SyncBefore: D3D12_BARRIER_SYNC,
    pub SyncAfter: D3D12_BARRIER_SYNC,
    pub AccessBefore: D3D12_BARRIER_ACCESS,
    pub AccessAfter: D3D12_BARRIER_ACCESS,
    pub pResource: *mut ID3D12Resource,
    pub Offset: UINT64,
    pub Size: UINT64,
}
impl Default for D3D12_BUFFER_BARRIER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_RESOURCE_STATE_BARRIER {
    pub State: D3D12_RESOURCE_STATES,
    pub pResource: *mut ID3D12Resource,
    pub Subresource: UINT,
    pub Sync: D3D12_BARRIER_SYNC,
    pub Access: D3D12_BARRIER_ACCESS,
    pub Layout: D3D12_BARRIER_LAYOUT,
}
impl Default for D3D12_RESOURCE_STATE_BARRIER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct D3D12_BARRIER_GROUP {
    pub Type: D3D12_BARRIER_TYPE,
    pub NumBarriers: UINT32,
    pub __bindgen_anon_1: D3D12_BARRIER_GROUP__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union D3D12_BARRIER_GROUP__bindgen_ty_1 {
    pub pGlobalBarriers: *const D3D12_GLOBAL_BARRIER,
    pub pTextureBarriers: *const D3D12_TEXTURE_BARRIER,
    pub pBufferBarriers: *const D3D12_BUFFER_BARRIER,
    pub pStateBarriers: *const D3D12_RESOURCE_STATE_BARRIER,
}
impl Default for D3D12_BARRIER_GROUP__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_BARRIER_GROUP__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "D3D12_BARRIER_GROUP__bindgen_ty_1 {{ union }}")
    }
}
impl Default for D3D12_BARRIER_GROUP {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for D3D12_BARRIER_GROUP {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "D3D12_BARRIER_GROUP {{ Type: {:?}, NumBarriers: {:?}, __bindgen_anon_1: {:?} }}" , self . Type , self . NumBarriers , self . __bindgen_anon_1)
    }
}
extern "C" {
    pub static IID_ID3D12ShaderCacheSession: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ShaderCacheSessionVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12ShaderCacheSession) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12ShaderCacheSession) -> ULONG,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            guid: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            guid: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            guid: *const GUID,
            pData: *const IUnknown,
        ) -> HRESULT,
    >,
    pub SetName: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            Name: LPCWSTR,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            riid: *const IID,
            ppvDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub FindValue: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            pKey: *const ::std::os::raw::c_void,
            KeySize: UINT,
            pValue: *mut ::std::os::raw::c_void,
            pValueSize: *mut UINT,
        ) -> HRESULT,
    >,
    pub StoreValue: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            pKey: *const ::std::os::raw::c_void,
            KeySize: UINT,
            pValue: *const ::std::os::raw::c_void,
            ValueSize: UINT,
        ) -> HRESULT,
    >,
    pub SetDeleteOnDestroy: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12ShaderCacheSession),
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12ShaderCacheSession,
            RetVal: *mut D3D12_SHADER_CACHE_SESSION_DESC,
        ) -> *mut D3D12_SHADER_CACHE_SESSION_DESC,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ShaderCacheSession {
    pub lpVtbl: *mut ID3D12ShaderCacheSessionVtbl,
}
impl Default for ID3D12ShaderCacheSession {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_SHADER_CACHE_KIND_FLAGS_D3D12_SHADER_CACHE_KIND_FLAG_IMPLICIT_D3D_CACHE_FOR_DRIVER : D3D12_SHADER_CACHE_KIND_FLAGS = 1 ;
pub const D3D12_SHADER_CACHE_KIND_FLAGS_D3D12_SHADER_CACHE_KIND_FLAG_IMPLICIT_D3D_CONVERSIONS : D3D12_SHADER_CACHE_KIND_FLAGS = 2 ;
pub const D3D12_SHADER_CACHE_KIND_FLAGS_D3D12_SHADER_CACHE_KIND_FLAG_IMPLICIT_DRIVER_MANAGED : D3D12_SHADER_CACHE_KIND_FLAGS = 4 ;
pub const D3D12_SHADER_CACHE_KIND_FLAGS_D3D12_SHADER_CACHE_KIND_FLAG_APPLICATION_MANAGED : D3D12_SHADER_CACHE_KIND_FLAGS = 8 ;
pub type D3D12_SHADER_CACHE_KIND_FLAGS = ::std::os::raw::c_int;
pub const D3D12_SHADER_CACHE_CONTROL_FLAGS_D3D12_SHADER_CACHE_CONTROL_FLAG_DISABLE : D3D12_SHADER_CACHE_CONTROL_FLAGS = 1 ;
pub const D3D12_SHADER_CACHE_CONTROL_FLAGS_D3D12_SHADER_CACHE_CONTROL_FLAG_ENABLE : D3D12_SHADER_CACHE_CONTROL_FLAGS = 2 ;
pub const D3D12_SHADER_CACHE_CONTROL_FLAGS_D3D12_SHADER_CACHE_CONTROL_FLAG_CLEAR : D3D12_SHADER_CACHE_CONTROL_FLAGS = 4 ;
pub type D3D12_SHADER_CACHE_CONTROL_FLAGS = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12Device9: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device9Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , Name : LPCWSTR) -> HRESULT > , pub GetNodeCount : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9) -> UINT > , pub CreateCommandQueue : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_COMMAND_QUEUE_DESC , riid : * const IID , ppCommandQueue : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandAllocator : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , type_ : D3D12_COMMAND_LIST_TYPE , riid : * const IID , ppCommandAllocator : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateGraphicsPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_GRAPHICS_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateComputePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_COMPUTE_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandList : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , pCommandAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CheckFeatureSupport : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , Feature : D3D12_FEATURE , pFeatureSupportData : * mut :: std :: os :: raw :: c_void , FeatureSupportDataSize : UINT) -> HRESULT > , pub CreateDescriptorHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDescriptorHeapDesc : * const D3D12_DESCRIPTOR_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDescriptorHandleIncrementSize : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , DescriptorHeapType : D3D12_DESCRIPTOR_HEAP_TYPE) -> UINT > , pub CreateRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , nodeMask : UINT , pBlobWithRootSignature : * const :: std :: os :: raw :: c_void , blobLengthInBytes : SIZE_T , riid : * const IID , ppvRootSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_CONSTANT_BUFFER_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_SHADER_RESOURCE_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pResource : * mut ID3D12Resource , pCounterResource : * mut ID3D12Resource , pDesc : * const D3D12_UNORDERED_ACCESS_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_RENDER_TARGET_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_DEPTH_STENCIL_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateSampler : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_SAMPLER_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CopyDescriptors : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , NumDestDescriptorRanges : UINT , pDestDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pDestDescriptorRangeSizes : * const UINT , NumSrcDescriptorRanges : UINT , pSrcDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pSrcDescriptorRangeSizes : * const UINT , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub CopyDescriptorsSimple : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , NumDescriptors : UINT , DestDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , SrcDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub GetResourceAllocationInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub GetCustomHeapProperties : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , RetVal : * mut D3D12_HEAP_PROPERTIES , nodeMask : UINT , heapType : D3D12_HEAP_TYPE) -> * mut D3D12_HEAP_PROPERTIES > , pub CreateCommittedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pObject : * mut ID3D12DeviceChild , pAttributes : * const SECURITY_ATTRIBUTES , Access : DWORD , Name : LPCWSTR , pHandle : * mut HANDLE) -> HRESULT > , pub OpenSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , NTHandle : HANDLE , riid : * const IID , ppvObj : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenSharedHandleByName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , Name : LPCWSTR , Access : DWORD , pNTHandle : * mut HANDLE) -> HRESULT > , pub MakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub Evict : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub CreateFence : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , InitialValue : UINT64 , Flags : D3D12_FENCE_FLAGS , riid : * const IID , ppFence : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDeviceRemovedReason : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9) -> HRESULT > , pub GetCopyableFootprints : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pResourceDesc : * const D3D12_RESOURCE_DESC , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , pub CreateQueryHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_QUERY_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetStablePowerState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , Enable : BOOL) -> HRESULT > , pub CreateCommandSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_COMMAND_SIGNATURE_DESC , pRootSignature : * mut ID3D12RootSignature , riid : * const IID , ppvCommandSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceTiling : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pTiledResource : * mut ID3D12Resource , pNumTilesForEntireResource : * mut UINT , pPackedMipDesc : * mut D3D12_PACKED_MIP_INFO , pStandardTileShapeForNonPackedMips : * mut D3D12_TILE_SHAPE , pNumSubresourceTilings : * mut UINT , FirstSubresourceTilingToGet : UINT , pSubresourceTilingsForNonPackedMips : * mut D3D12_SUBRESOURCE_TILING) > , pub GetAdapterLuid : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , RetVal : * mut LUID) -> * mut LUID > , pub CreatePipelineLibrary : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pLibraryBlob : * const :: std :: os :: raw :: c_void , BlobLength : SIZE_T , riid : * const IID , ppPipelineLibrary : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetEventOnMultipleFenceCompletion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , ppFences : * const * mut ID3D12Fence , pFenceValues : * const UINT64 , NumFences : UINT , Flags : D3D12_MULTIPLE_FENCE_WAIT_FLAGS , hEvent : HANDLE) -> HRESULT > , pub SetResidencyPriority : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pPriorities : * const D3D12_RESIDENCY_PRIORITY) -> HRESULT > , pub CreatePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_PIPELINE_STATE_STREAM_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromAddress : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pAddress : * const :: std :: os :: raw :: c_void , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromFileMapping : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , hFileMapping : HANDLE , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub EnqueueMakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , Flags : D3D12_RESIDENCY_FLAGS , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pFenceToSignal : * mut ID3D12Fence , FenceValueToSignal : UINT64) -> HRESULT > , pub CreateCommandList1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , flags : D3D12_COMMAND_LIST_FLAGS , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommittedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_HEAP_DESC , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateLifetimeTracker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pOwner : * mut ID3D12LifetimeOwner , riid : * const IID , ppvTracker : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub RemoveDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9) > , pub EnumerateMetaCommands : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pNumMetaCommands : * mut UINT , pDescs : * mut D3D12_META_COMMAND_DESC) -> HRESULT > , pub EnumerateMetaCommandParameters : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , CommandId : * const GUID , Stage : D3D12_META_COMMAND_PARAMETER_STAGE , pTotalStructureSizeInBytes : * mut UINT , pParameterCount : * mut UINT , pParameterDescs : * mut D3D12_META_COMMAND_PARAMETER_DESC) -> HRESULT > , pub CreateMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , CommandId : * const GUID , NodeMask : UINT , pCreationParametersData : * const :: std :: os :: raw :: c_void , CreationParametersDataSizeInBytes : SIZE_T , riid : * const IID , ppMetaCommand : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_STATE_OBJECT_DESC , riid : * const IID , ppStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetRaytracingAccelerationStructurePrebuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS , pInfo : * mut D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO) > , pub CheckDriverMatchingIdentifier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , SerializedDataType : D3D12_SERIALIZED_DATA_TYPE , pIdentifierToCheck : * const D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER) -> D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS > , pub SetBackgroundProcessingMode : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , Mode : D3D12_BACKGROUND_PROCESSING_MODE , MeasurementsAction : D3D12_MEASUREMENTS_ACTION , hEventToSignalUponCompletion : HANDLE , pbFurtherMeasurementsDesired : * mut BOOL) -> HRESULT > , pub AddToStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pAddition : * const D3D12_STATE_OBJECT_DESC , pStateObjectToGrowFrom : * mut ID3D12StateObject , riid : * const IID , ppNewStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC1 , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo2 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC1 , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateCommittedResource2 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC1 , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC1 , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSamplerFeedbackUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pTargetedResource : * mut ID3D12Resource , pFeedbackResource : * mut ID3D12Resource , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub GetCopyableFootprints1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pResourceDesc : * const D3D12_RESOURCE_DESC1 , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , pub CreateShaderCacheSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_SHADER_CACHE_SESSION_DESC , riid : * const IID , ppvSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub ShaderCacheControl : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , Kinds : D3D12_SHADER_CACHE_KIND_FLAGS , Control : D3D12_SHADER_CACHE_CONTROL_FLAGS) -> HRESULT > , pub CreateCommandQueue1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device9 , pDesc : * const D3D12_COMMAND_QUEUE_DESC , CreatorID : * const IID , riid : * const IID , ppCommandQueue : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device9 {
    pub lpVtbl: *mut ID3D12Device9Vtbl,
}
impl Default for ID3D12Device9 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Device10: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device10Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , Name : LPCWSTR) -> HRESULT > , pub GetNodeCount : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10) -> UINT > , pub CreateCommandQueue : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_COMMAND_QUEUE_DESC , riid : * const IID , ppCommandQueue : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandAllocator : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , type_ : D3D12_COMMAND_LIST_TYPE , riid : * const IID , ppCommandAllocator : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateGraphicsPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_GRAPHICS_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateComputePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_COMPUTE_PIPELINE_STATE_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommandList : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , pCommandAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CheckFeatureSupport : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , Feature : D3D12_FEATURE , pFeatureSupportData : * mut :: std :: os :: raw :: c_void , FeatureSupportDataSize : UINT) -> HRESULT > , pub CreateDescriptorHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDescriptorHeapDesc : * const D3D12_DESCRIPTOR_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDescriptorHandleIncrementSize : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , DescriptorHeapType : D3D12_DESCRIPTOR_HEAP_TYPE) -> UINT > , pub CreateRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , nodeMask : UINT , pBlobWithRootSignature : * const :: std :: os :: raw :: c_void , blobLengthInBytes : SIZE_T , riid : * const IID , ppvRootSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_CONSTANT_BUFFER_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_SHADER_RESOURCE_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pResource : * mut ID3D12Resource , pCounterResource : * mut ID3D12Resource , pDesc : * const D3D12_UNORDERED_ACCESS_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_RENDER_TARGET_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pResource : * mut ID3D12Resource , pDesc : * const D3D12_DEPTH_STENCIL_VIEW_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CreateSampler : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_SAMPLER_DESC , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub CopyDescriptors : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , NumDestDescriptorRanges : UINT , pDestDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pDestDescriptorRangeSizes : * const UINT , NumSrcDescriptorRanges : UINT , pSrcDescriptorRangeStarts : * const D3D12_CPU_DESCRIPTOR_HANDLE , pSrcDescriptorRangeSizes : * const UINT , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub CopyDescriptorsSimple : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , NumDescriptors : UINT , DestDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , SrcDescriptorRangeStart : D3D12_CPU_DESCRIPTOR_HANDLE , DescriptorHeapsType : D3D12_DESCRIPTOR_HEAP_TYPE) > , pub GetResourceAllocationInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub GetCustomHeapProperties : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , RetVal : * mut D3D12_HEAP_PROPERTIES , nodeMask : UINT , heapType : D3D12_HEAP_TYPE) -> * mut D3D12_HEAP_PROPERTIES > , pub CreateCommittedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pObject : * mut ID3D12DeviceChild , pAttributes : * const SECURITY_ATTRIBUTES , Access : DWORD , Name : LPCWSTR , pHandle : * mut HANDLE) -> HRESULT > , pub OpenSharedHandle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , NTHandle : HANDLE , riid : * const IID , ppvObj : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenSharedHandleByName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , Name : LPCWSTR , Access : DWORD , pNTHandle : * mut HANDLE) -> HRESULT > , pub MakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub Evict : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable) -> HRESULT > , pub CreateFence : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , InitialValue : UINT64 , Flags : D3D12_FENCE_FLAGS , riid : * const IID , ppFence : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetDeviceRemovedReason : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10) -> HRESULT > , pub GetCopyableFootprints : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pResourceDesc : * const D3D12_RESOURCE_DESC , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , pub CreateQueryHeap : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_QUERY_HEAP_DESC , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetStablePowerState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , Enable : BOOL) -> HRESULT > , pub CreateCommandSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_COMMAND_SIGNATURE_DESC , pRootSignature : * mut ID3D12RootSignature , riid : * const IID , ppvCommandSignature : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceTiling : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pTiledResource : * mut ID3D12Resource , pNumTilesForEntireResource : * mut UINT , pPackedMipDesc : * mut D3D12_PACKED_MIP_INFO , pStandardTileShapeForNonPackedMips : * mut D3D12_TILE_SHAPE , pNumSubresourceTilings : * mut UINT , FirstSubresourceTilingToGet : UINT , pSubresourceTilingsForNonPackedMips : * mut D3D12_SUBRESOURCE_TILING) > , pub GetAdapterLuid : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , RetVal : * mut LUID) -> * mut LUID > , pub CreatePipelineLibrary : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pLibraryBlob : * const :: std :: os :: raw :: c_void , BlobLength : SIZE_T , riid : * const IID , ppPipelineLibrary : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetEventOnMultipleFenceCompletion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , ppFences : * const * mut ID3D12Fence , pFenceValues : * const UINT64 , NumFences : UINT , Flags : D3D12_MULTIPLE_FENCE_WAIT_FLAGS , hEvent : HANDLE) -> HRESULT > , pub SetResidencyPriority : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pPriorities : * const D3D12_RESIDENCY_PRIORITY) -> HRESULT > , pub CreatePipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_PIPELINE_STATE_STREAM_DESC , riid : * const IID , ppPipelineState : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromAddress : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pAddress : * const :: std :: os :: raw :: c_void , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub OpenExistingHeapFromFileMapping : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , hFileMapping : HANDLE , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub EnqueueMakeResident : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , Flags : D3D12_RESIDENCY_FLAGS , NumObjects : UINT , ppObjects : * const * mut ID3D12Pageable , pFenceToSignal : * mut ID3D12Fence , FenceValueToSignal : UINT64) -> HRESULT > , pub CreateCommandList1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , nodeMask : UINT , type_ : D3D12_COMMAND_LIST_TYPE , flags : D3D12_COMMAND_LIST_FLAGS , riid : * const IID , ppCommandList : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommittedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateHeap1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_HEAP_DESC , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvHeap : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_RESOURCE_DESC , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateLifetimeTracker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pOwner : * mut ID3D12LifetimeOwner , riid : * const IID , ppvTracker : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub RemoveDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10) > , pub EnumerateMetaCommands : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pNumMetaCommands : * mut UINT , pDescs : * mut D3D12_META_COMMAND_DESC) -> HRESULT > , pub EnumerateMetaCommandParameters : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , CommandId : * const GUID , Stage : D3D12_META_COMMAND_PARAMETER_STAGE , pTotalStructureSizeInBytes : * mut UINT , pParameterCount : * mut UINT , pParameterDescs : * mut D3D12_META_COMMAND_PARAMETER_DESC) -> HRESULT > , pub CreateMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , CommandId : * const GUID , NodeMask : UINT , pCreationParametersData : * const :: std :: os :: raw :: c_void , CreationParametersDataSizeInBytes : SIZE_T , riid : * const IID , ppMetaCommand : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_STATE_OBJECT_DESC , riid : * const IID , ppStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetRaytracingAccelerationStructurePrebuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS , pInfo : * mut D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO) > , pub CheckDriverMatchingIdentifier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , SerializedDataType : D3D12_SERIALIZED_DATA_TYPE , pIdentifierToCheck : * const D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER) -> D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS > , pub SetBackgroundProcessingMode : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , Mode : D3D12_BACKGROUND_PROCESSING_MODE , MeasurementsAction : D3D12_MEASUREMENTS_ACTION , hEventToSignalUponCompletion : HANDLE , pbFurtherMeasurementsDesired : * mut BOOL) -> HRESULT > , pub AddToStateObject : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pAddition : * const D3D12_STATE_OBJECT_DESC , pStateObjectToGrowFrom : * mut ID3D12StateObject , riid : * const IID , ppNewStateObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateProtectedResourceSession1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_PROTECTED_RESOURCE_SESSION_DESC1 , riid : * const IID , ppSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetResourceAllocationInfo2 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , RetVal : * mut D3D12_RESOURCE_ALLOCATION_INFO , visibleMask : UINT , numResourceDescs : UINT , pResourceDescs : * const D3D12_RESOURCE_DESC1 , pResourceAllocationInfo1 : * mut D3D12_RESOURCE_ALLOCATION_INFO1) -> * mut D3D12_RESOURCE_ALLOCATION_INFO > , pub CreateCommittedResource2 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC1 , InitialResourceState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC1 , InitialState : D3D12_RESOURCE_STATES , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateSamplerFeedbackUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pTargetedResource : * mut ID3D12Resource , pFeedbackResource : * mut ID3D12Resource , DestDescriptor : D3D12_CPU_DESCRIPTOR_HANDLE) > , pub GetCopyableFootprints1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pResourceDesc : * const D3D12_RESOURCE_DESC1 , FirstSubresource : UINT , NumSubresources : UINT , BaseOffset : UINT64 , pLayouts : * mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT , pNumRows : * mut UINT , pRowSizeInBytes : * mut UINT64 , pTotalBytes : * mut UINT64) > , pub CreateShaderCacheSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_SHADER_CACHE_SESSION_DESC , riid : * const IID , ppvSession : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub ShaderCacheControl : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , Kinds : D3D12_SHADER_CACHE_KIND_FLAGS , Control : D3D12_SHADER_CACHE_CONTROL_FLAGS) -> HRESULT > , pub CreateCommandQueue1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_COMMAND_QUEUE_DESC , CreatorID : * const IID , riid : * const IID , ppCommandQueue : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateCommittedResource3 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pHeapProperties : * const D3D12_HEAP_PROPERTIES , HeapFlags : D3D12_HEAP_FLAGS , pDesc : * const D3D12_RESOURCE_DESC1 , InitialLayout : D3D12_BARRIER_LAYOUT , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , NumCastableFormats : UINT32 , pCastableFormats : * mut DXGI_FORMAT , riidResource : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreatePlacedResource2 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pHeap : * mut ID3D12Heap , HeapOffset : UINT64 , pDesc : * const D3D12_RESOURCE_DESC1 , InitialLayout : D3D12_BARRIER_LAYOUT , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , NumCastableFormats : UINT32 , pCastableFormats : * mut DXGI_FORMAT , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub CreateReservedResource2 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12Device10 , pDesc : * const D3D12_RESOURCE_DESC , InitialLayout : D3D12_BARRIER_LAYOUT , pOptimizedClearValue : * const D3D12_CLEAR_VALUE , pProtectedSession : * mut ID3D12ProtectedResourceSession , NumCastableFormats : UINT32 , pCastableFormats : * mut DXGI_FORMAT , riid : * const IID , ppvResource : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Device10 {
    pub lpVtbl: *mut ID3D12Device10Vtbl,
}
impl Default for ID3D12Device10 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12VirtualizationGuestDevice: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12VirtualizationGuestDeviceVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VirtualizationGuestDevice,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VirtualizationGuestDevice,
        ) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VirtualizationGuestDevice,
        ) -> ULONG,
    >,
    pub ShareWithHost: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VirtualizationGuestDevice,
            pObject: *mut ID3D12DeviceChild,
            pHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub CreateFenceFd: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12VirtualizationGuestDevice,
            pFence: *mut ID3D12Fence,
            FenceValue: UINT64,
            pFenceFd: *mut ::std::os::raw::c_int,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12VirtualizationGuestDevice {
    pub lpVtbl: *mut ID3D12VirtualizationGuestDeviceVtbl,
}
impl Default for ID3D12VirtualizationGuestDevice {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Tools: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12ToolsVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Tools,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Tools) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Tools) -> ULONG,
    >,
    pub EnableShaderInstrumentation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Tools, bEnable: BOOL),
    >,
    pub ShaderInstrumentationEnabled: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Tools) -> BOOL,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Tools {
    pub lpVtbl: *mut ID3D12ToolsVtbl,
}
impl Default for ID3D12Tools {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_SUBRESOURCE_DATA {
    pub pData: *const ::std::os::raw::c_void,
    pub RowPitch: LONG_PTR,
    pub SlicePitch: LONG_PTR,
}
impl Default for D3D12_SUBRESOURCE_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_MEMCPY_DEST {
    pub pData: *mut ::std::os::raw::c_void,
    pub RowPitch: SIZE_T,
    pub SlicePitch: SIZE_T,
}
impl Default for D3D12_MEMCPY_DEST {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Debug: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug) -> ULONG,
    >,
    pub EnableDebugLayer:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12Debug)>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug {
    pub lpVtbl: *mut ID3D12DebugVtbl,
}
impl Default for ID3D12Debug {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_GPU_BASED_VALIDATION_FLAGS_D3D12_GPU_BASED_VALIDATION_FLAGS_NONE : D3D12_GPU_BASED_VALIDATION_FLAGS = 0 ;
pub const D3D12_GPU_BASED_VALIDATION_FLAGS_D3D12_GPU_BASED_VALIDATION_FLAGS_DISABLE_STATE_TRACKING : D3D12_GPU_BASED_VALIDATION_FLAGS = 1 ;
pub type D3D12_GPU_BASED_VALIDATION_FLAGS = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12Debug1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug1) -> ULONG,
    >,
    pub EnableDebugLayer:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12Debug1)>,
    pub SetEnableGPUBasedValidation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug1, Enable: BOOL),
    >,
    pub SetEnableSynchronizedCommandQueueValidation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug1, Enable: BOOL),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug1 {
    pub lpVtbl: *mut ID3D12Debug1Vtbl,
}
impl Default for ID3D12Debug1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Debug2: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug2Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug2,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug2) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug2) -> ULONG,
    >,
    pub SetGPUBasedValidationFlags: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug2,
            Flags: D3D12_GPU_BASED_VALIDATION_FLAGS,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug2 {
    pub lpVtbl: *mut ID3D12Debug2Vtbl,
}
impl Default for ID3D12Debug2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Debug3: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug3Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug3,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug3) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug3) -> ULONG,
    >,
    pub EnableDebugLayer:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12Debug3)>,
    pub SetEnableGPUBasedValidation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug3, Enable: BOOL),
    >,
    pub SetEnableSynchronizedCommandQueueValidation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug3, Enable: BOOL),
    >,
    pub SetGPUBasedValidationFlags: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug3,
            Flags: D3D12_GPU_BASED_VALIDATION_FLAGS,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug3 {
    pub lpVtbl: *mut ID3D12Debug3Vtbl,
}
impl Default for ID3D12Debug3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Debug4: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug4Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug4,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug4) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug4) -> ULONG,
    >,
    pub EnableDebugLayer:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12Debug4)>,
    pub SetEnableGPUBasedValidation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug4, Enable: BOOL),
    >,
    pub SetEnableSynchronizedCommandQueueValidation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug4, Enable: BOOL),
    >,
    pub SetGPUBasedValidationFlags: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug4,
            Flags: D3D12_GPU_BASED_VALIDATION_FLAGS,
        ),
    >,
    pub DisableDebugLayer:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12Debug4)>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug4 {
    pub lpVtbl: *mut ID3D12Debug4Vtbl,
}
impl Default for ID3D12Debug4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12Debug5: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug5Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug5,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug5) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug5) -> ULONG,
    >,
    pub EnableDebugLayer:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12Debug5)>,
    pub SetEnableGPUBasedValidation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug5, Enable: BOOL),
    >,
    pub SetEnableSynchronizedCommandQueueValidation: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug5, Enable: BOOL),
    >,
    pub SetGPUBasedValidationFlags: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12Debug5,
            Flags: D3D12_GPU_BASED_VALIDATION_FLAGS,
        ),
    >,
    pub DisableDebugLayer:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12Debug5)>,
    pub SetEnableAutoName: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12Debug5, Enable: BOOL),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12Debug5 {
    pub lpVtbl: *mut ID3D12Debug5Vtbl,
}
impl Default for ID3D12Debug5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static WKPDID_D3DAutoDebugObjectNameW: GUID;
}
pub const D3D12_RLDO_FLAGS_D3D12_RLDO_NONE: D3D12_RLDO_FLAGS = 0;
pub const D3D12_RLDO_FLAGS_D3D12_RLDO_SUMMARY: D3D12_RLDO_FLAGS = 1;
pub const D3D12_RLDO_FLAGS_D3D12_RLDO_DETAIL: D3D12_RLDO_FLAGS = 2;
pub const D3D12_RLDO_FLAGS_D3D12_RLDO_IGNORE_INTERNAL: D3D12_RLDO_FLAGS = 4;
pub type D3D12_RLDO_FLAGS = ::std::os::raw::c_int;
pub const D3D12_DEBUG_DEVICE_PARAMETER_TYPE_D3D12_DEBUG_DEVICE_PARAMETER_FEATURE_FLAGS : D3D12_DEBUG_DEVICE_PARAMETER_TYPE = 0 ;
pub const D3D12_DEBUG_DEVICE_PARAMETER_TYPE_D3D12_DEBUG_DEVICE_PARAMETER_GPU_BASED_VALIDATION_SETTINGS : D3D12_DEBUG_DEVICE_PARAMETER_TYPE = 1 ;
pub const D3D12_DEBUG_DEVICE_PARAMETER_TYPE_D3D12_DEBUG_DEVICE_PARAMETER_GPU_SLOWDOWN_PERFORMANCE_FACTOR : D3D12_DEBUG_DEVICE_PARAMETER_TYPE = 2 ;
pub type D3D12_DEBUG_DEVICE_PARAMETER_TYPE = ::std::os::raw::c_int;
pub const D3D12_DEBUG_FEATURE_D3D12_DEBUG_FEATURE_NONE: D3D12_DEBUG_FEATURE = 0;
pub const D3D12_DEBUG_FEATURE_D3D12_DEBUG_FEATURE_ALLOW_BEHAVIOR_CHANGING_DEBUG_AIDS : D3D12_DEBUG_FEATURE = 1 ;
pub const D3D12_DEBUG_FEATURE_D3D12_DEBUG_FEATURE_CONSERVATIVE_RESOURCE_STATE_TRACKING : D3D12_DEBUG_FEATURE = 2 ;
pub const D3D12_DEBUG_FEATURE_D3D12_DEBUG_FEATURE_DISABLE_VIRTUALIZED_BUNDLES_VALIDATION : D3D12_DEBUG_FEATURE = 4 ;
pub const D3D12_DEBUG_FEATURE_D3D12_DEBUG_FEATURE_EMULATE_WINDOWS7:
    D3D12_DEBUG_FEATURE = 8;
pub type D3D12_DEBUG_FEATURE = ::std::os::raw::c_int;
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_NONE : D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = 0 ;
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_STATE_TRACKING_ONLY : D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = 1 ;
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_UNGUARDED_VALIDATION : D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = 2 ;
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_GUARDED_VALIDATION : D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = 3 ;
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_NUM_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODES : D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = 4 ;
pub type D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = ::std::os::raw::c_int;
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_NONE : D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = 0 ;
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_TRACKING_ONLY_SHADERS : D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = 1 ;
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_UNGUARDED_VALIDATION_SHADERS : D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = 2 ;
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_GUARDED_VALIDATION_SHADERS : D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = 4 ;
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_VALID_MASK : D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = 7 ;
pub type D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS =
    ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {
    pub MaxMessagesPerCommandList: UINT,
    pub DefaultShaderPatchMode: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE,
    pub PipelineStateCreateFlags:
        D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS,
}
impl Default for D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {
    pub SlowdownFactor: FLOAT,
}
extern "C" {
    pub static IID_ID3D12DebugDevice1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugDevice1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugDevice1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugDevice1) -> ULONG,
    >,
    pub SetDebugParameter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice1,
            Type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE,
            pData: *const ::std::os::raw::c_void,
            DataSize: UINT,
        ) -> HRESULT,
    >,
    pub GetDebugParameter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice1,
            Type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE,
            pData: *mut ::std::os::raw::c_void,
            DataSize: UINT,
        ) -> HRESULT,
    >,
    pub ReportLiveDeviceObjects: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice1,
            Flags: D3D12_RLDO_FLAGS,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugDevice1 {
    pub lpVtbl: *mut ID3D12DebugDevice1Vtbl,
}
impl Default for ID3D12DebugDevice1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DebugDevice: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugDeviceVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugDevice) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugDevice) -> ULONG,
    >,
    pub SetFeatureMask: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice,
            Mask: D3D12_DEBUG_FEATURE,
        ) -> HRESULT,
    >,
    pub GetFeatureMask: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice,
        ) -> D3D12_DEBUG_FEATURE,
    >,
    pub ReportLiveDeviceObjects: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice,
            Flags: D3D12_RLDO_FLAGS,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugDevice {
    pub lpVtbl: *mut ID3D12DebugDeviceVtbl,
}
impl Default for ID3D12DebugDevice {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DebugDevice2: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugDevice2Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice2,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugDevice2) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugDevice2) -> ULONG,
    >,
    pub SetFeatureMask: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice2,
            Mask: D3D12_DEBUG_FEATURE,
        ) -> HRESULT,
    >,
    pub GetFeatureMask: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice2,
        ) -> D3D12_DEBUG_FEATURE,
    >,
    pub ReportLiveDeviceObjects: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice2,
            Flags: D3D12_RLDO_FLAGS,
        ) -> HRESULT,
    >,
    pub SetDebugParameter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice2,
            Type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE,
            pData: *const ::std::os::raw::c_void,
            DataSize: UINT,
        ) -> HRESULT,
    >,
    pub GetDebugParameter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugDevice2,
            Type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE,
            pData: *mut ::std::os::raw::c_void,
            DataSize: UINT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugDevice2 {
    pub lpVtbl: *mut ID3D12DebugDevice2Vtbl,
}
impl Default for ID3D12DebugDevice2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static DXGI_DEBUG_D3D12: GUID;
}
extern "C" {
    pub static IID_ID3D12DebugCommandQueue: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugCommandQueueVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandQueue,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugCommandQueue) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugCommandQueue) -> ULONG,
    >,
    pub AssertResourceState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandQueue,
            pResource: *mut ID3D12Resource,
            Subresource: UINT,
            State: UINT,
        ) -> BOOL,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugCommandQueue {
    pub lpVtbl: *mut ID3D12DebugCommandQueueVtbl,
}
impl Default for ID3D12DebugCommandQueue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE_D3D12_DEBUG_COMMAND_LIST_PARAMETER_GPU_BASED_VALIDATION_SETTINGS : D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE = 0 ;
pub type D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {
    pub ShaderPatchMode: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE,
}
impl Default for D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DebugCommandList1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugCommandList1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugCommandList1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugCommandList1) -> ULONG,
    >,
    pub AssertResourceState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList1,
            pResource: *mut ID3D12Resource,
            Subresource: UINT,
            State: UINT,
        ) -> BOOL,
    >,
    pub SetDebugParameter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList1,
            Type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE,
            pData: *const ::std::os::raw::c_void,
            DataSize: UINT,
        ) -> HRESULT,
    >,
    pub GetDebugParameter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList1,
            Type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE,
            pData: *mut ::std::os::raw::c_void,
            DataSize: UINT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugCommandList1 {
    pub lpVtbl: *mut ID3D12DebugCommandList1Vtbl,
}
impl Default for ID3D12DebugCommandList1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DebugCommandList: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugCommandListVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugCommandList) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugCommandList) -> ULONG,
    >,
    pub AssertResourceState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList,
            pResource: *mut ID3D12Resource,
            Subresource: UINT,
            State: UINT,
        ) -> BOOL,
    >,
    pub SetFeatureMask: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList,
            Mask: D3D12_DEBUG_FEATURE,
        ) -> HRESULT,
    >,
    pub GetFeatureMask: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList,
        ) -> D3D12_DEBUG_FEATURE,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugCommandList {
    pub lpVtbl: *mut ID3D12DebugCommandListVtbl,
}
impl Default for ID3D12DebugCommandList {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12DebugCommandList2: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugCommandList2Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList2,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugCommandList2) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12DebugCommandList2) -> ULONG,
    >,
    pub AssertResourceState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList2,
            pResource: *mut ID3D12Resource,
            Subresource: UINT,
            State: UINT,
        ) -> BOOL,
    >,
    pub SetFeatureMask: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList2,
            Mask: D3D12_DEBUG_FEATURE,
        ) -> HRESULT,
    >,
    pub GetFeatureMask: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList2,
        ) -> D3D12_DEBUG_FEATURE,
    >,
    pub SetDebugParameter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList2,
            Type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE,
            pData: *const ::std::os::raw::c_void,
            DataSize: UINT,
        ) -> HRESULT,
    >,
    pub GetDebugParameter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12DebugCommandList2,
            Type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE,
            pData: *mut ::std::os::raw::c_void,
            DataSize: UINT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12DebugCommandList2 {
    pub lpVtbl: *mut ID3D12DebugCommandList2Vtbl,
}
impl Default for ID3D12DebugCommandList2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12SharingContract: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12SharingContractVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SharingContract,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12SharingContract) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12SharingContract) -> ULONG,
    >,
    pub Present: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SharingContract,
            pResource: *mut ID3D12Resource,
            Subresource: UINT,
            window: HWND,
        ),
    >,
    pub SharedFenceSignal: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SharingContract,
            pFence: *mut ID3D12Fence,
            FenceValue: UINT64,
        ),
    >,
    pub BeginCapturableWork: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SharingContract,
            guid: *const GUID,
        ),
    >,
    pub EndCapturableWork: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SharingContract,
            guid: *const GUID,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12SharingContract {
    pub lpVtbl: *mut ID3D12SharingContractVtbl,
}
impl Default for ID3D12SharingContract {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_APPLICATION_DEFINED:
    D3D12_MESSAGE_CATEGORY = 0;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_MISCELLANEOUS:
    D3D12_MESSAGE_CATEGORY = 1;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_INITIALIZATION:
    D3D12_MESSAGE_CATEGORY = 2;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_CLEANUP:
    D3D12_MESSAGE_CATEGORY = 3;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_COMPILATION:
    D3D12_MESSAGE_CATEGORY = 4;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_STATE_CREATION:
    D3D12_MESSAGE_CATEGORY = 5;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_STATE_SETTING:
    D3D12_MESSAGE_CATEGORY = 6;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_STATE_GETTING:
    D3D12_MESSAGE_CATEGORY = 7;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_RESOURCE_MANIPULATION : D3D12_MESSAGE_CATEGORY = 8 ;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_EXECUTION:
    D3D12_MESSAGE_CATEGORY = 9;
pub const D3D12_MESSAGE_CATEGORY_D3D12_MESSAGE_CATEGORY_SHADER:
    D3D12_MESSAGE_CATEGORY = 10;
pub type D3D12_MESSAGE_CATEGORY = ::std::os::raw::c_int;
pub const D3D12_MESSAGE_SEVERITY_D3D12_MESSAGE_SEVERITY_CORRUPTION:
    D3D12_MESSAGE_SEVERITY = 0;
pub const D3D12_MESSAGE_SEVERITY_D3D12_MESSAGE_SEVERITY_ERROR:
    D3D12_MESSAGE_SEVERITY = 1;
pub const D3D12_MESSAGE_SEVERITY_D3D12_MESSAGE_SEVERITY_WARNING:
    D3D12_MESSAGE_SEVERITY = 2;
pub const D3D12_MESSAGE_SEVERITY_D3D12_MESSAGE_SEVERITY_INFO:
    D3D12_MESSAGE_SEVERITY = 3;
pub const D3D12_MESSAGE_SEVERITY_D3D12_MESSAGE_SEVERITY_MESSAGE:
    D3D12_MESSAGE_SEVERITY = 4;
pub type D3D12_MESSAGE_SEVERITY = ::std::os::raw::c_int;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UNKNOWN: D3D12_MESSAGE_ID = 0;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_STRING_FROM_APPLICATION:
    D3D12_MESSAGE_ID = 1;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_THIS: D3D12_MESSAGE_ID =
    2;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER1:
    D3D12_MESSAGE_ID = 3;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER2:
    D3D12_MESSAGE_ID = 4;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER3:
    D3D12_MESSAGE_ID = 5;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER4:
    D3D12_MESSAGE_ID = 6;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER5:
    D3D12_MESSAGE_ID = 7;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER6:
    D3D12_MESSAGE_ID = 8;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER7:
    D3D12_MESSAGE_ID = 9;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER8:
    D3D12_MESSAGE_ID = 10;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER9:
    D3D12_MESSAGE_ID = 11;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER10:
    D3D12_MESSAGE_ID = 12;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER11:
    D3D12_MESSAGE_ID = 13;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER12:
    D3D12_MESSAGE_ID = 14;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER13:
    D3D12_MESSAGE_ID = 15;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER14:
    D3D12_MESSAGE_ID = 16;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_PARAMETER15:
    D3D12_MESSAGE_ID = 17;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CORRUPTED_MULTITHREADING:
    D3D12_MESSAGE_ID = 18;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 19;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETPRIVATEDATA_MOREDATA:
    D3D12_MESSAGE_ID = 20;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA:
    D3D12_MESSAGE_ID = 21;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS:
    D3D12_MESSAGE_ID = 24;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 25;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT : D3D12_MESSAGE_ID = 26 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC : D3D12_MESSAGE_ID = 27 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT : D3D12_MESSAGE_ID = 28 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANESLICE : D3D12_MESSAGE_ID = 29 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANESLICE : D3D12_MESSAGE_ID = 30 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS : D3D12_MESSAGE_ID = 31 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE : D3D12_MESSAGE_ID = 32 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT : D3D12_MESSAGE_ID = 35 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT : D3D12_MESSAGE_ID = 36 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC : D3D12_MESSAGE_ID = 37 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT : D3D12_MESSAGE_ID = 38 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANESLICE : D3D12_MESSAGE_ID = 39 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANESLICE : D3D12_MESSAGE_ID = 40 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS : D3D12_MESSAGE_ID = 41 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE : D3D12_MESSAGE_ID = 42 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT : D3D12_MESSAGE_ID = 45 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC : D3D12_MESSAGE_ID = 46 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT : D3D12_MESSAGE_ID = 47 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS : D3D12_MESSAGE_ID = 48 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE : D3D12_MESSAGE_ID = 49 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 52;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS : D3D12_MESSAGE_ID = 53 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT:
    D3D12_MESSAGE_ID = 54;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT : D3D12_MESSAGE_ID = 55 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT:
    D3D12_MESSAGE_ID = 56;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS : D3D12_MESSAGE_ID = 57 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH : D3D12_MESSAGE_ID = 58 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE : D3D12_MESSAGE_ID = 59 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE : D3D12_MESSAGE_ID = 60 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT : D3D12_MESSAGE_ID = 61 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC : D3D12_MESSAGE_ID = 62 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE : D3D12_MESSAGE_ID = 63 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC:
    D3D12_MESSAGE_ID = 64;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT:
    D3D12_MESSAGE_ID = 65;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 66;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 67 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE : D3D12_MESSAGE_ID = 68 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 69;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 70 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE : D3D12_MESSAGE_ID = 71 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY : D3D12_MESSAGE_ID = 72 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 73 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE : D3D12_MESSAGE_ID = 74 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES : D3D12_MESSAGE_ID = 75 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED : D3D12_MESSAGE_ID = 76 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED : D3D12_MESSAGE_ID = 79 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT : D3D12_MESSAGE_ID = 80 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT : D3D12_MESSAGE_ID = 81 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT : D3D12_MESSAGE_ID = 82 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT : D3D12_MESSAGE_ID = 83 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION : D3D12_MESSAGE_ID = 84 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT : D3D12_MESSAGE_ID = 85 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE : D3D12_MESSAGE_ID = 86 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC : D3D12_MESSAGE_ID = 87 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH : D3D12_MESSAGE_ID = 88 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS : D3D12_MESSAGE_ID = 89 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX : D3D12_MESSAGE_ID = 90 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE : D3D12_MESSAGE_ID = 91 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 92;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 93 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE : D3D12_MESSAGE_ID = 94 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE : D3D12_MESSAGE_ID = 95 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE : D3D12_MESSAGE_ID = 96 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP : D3D12_MESSAGE_ID = 97 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS : D3D12_MESSAGE_ID = 98 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK : D3D12_MESSAGE_ID = 100 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC : D3D12_MESSAGE_ID = 101 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP : D3D12_MESSAGE_ID = 102 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP : D3D12_MESSAGE_ID = 103 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP : D3D12_MESSAGE_ID = 104 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC : D3D12_MESSAGE_ID = 105 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP : D3D12_MESSAGE_ID = 106 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP : D3D12_MESSAGE_ID = 107 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP : D3D12_MESSAGE_ID = 108 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC : D3D12_MESSAGE_ID = 109 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND:
    D3D12_MESSAGE_ID = 111;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND : D3D12_MESSAGE_ID = 112 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP:
    D3D12_MESSAGE_ID = 113;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA : D3D12_MESSAGE_ID = 114 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA : D3D12_MESSAGE_ID = 115 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA : D3D12_MESSAGE_ID = 116 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK : D3D12_MESSAGE_ID = 117 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID:
    D3D12_MESSAGE_ID = 135;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_NOT_SET : D3D12_MESSAGE_ID = 200 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 201 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_NOT_SET : D3D12_MESSAGE_ID = 202 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL : D3D12_MESSAGE_ID = 209 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_TOO_SMALL : D3D12_MESSAGE_ID = 210 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_NOT_SET : D3D12_MESSAGE_ID = 211 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_FORMAT_INVALID : D3D12_MESSAGE_ID = 212 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_TOO_SMALL : D3D12_MESSAGE_ID = 213 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INVALID_PRIMITIVETOPOLOGY : D3D12_MESSAGE_ID = 219 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_STRIDE_UNALIGNED : D3D12_MESSAGE_ID = 221 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_OFFSET_UNALIGNED : D3D12_MESSAGE_ID = 222 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT:
    D3D12_MESSAGE_ID = 232;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT : D3D12_MESSAGE_ID = 233 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT : D3D12_MESSAGE_ID = 234 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC : D3D12_MESSAGE_ID = 239 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC : D3D12_MESSAGE_ID = 240 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH:
    D3D12_MESSAGE_ID = 245;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT:
    D3D12_MESSAGE_ID = 253;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_OBJECT_SUMMARY:
    D3D12_MESSAGE_ID = 255;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_DEVICE: D3D12_MESSAGE_ID = 274;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_SWAPCHAIN: D3D12_MESSAGE_ID =
    275;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFLAGS : D3D12_MESSAGE_ID = 276 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDCLASSLINKAGE : D3D12_MESSAGE_ID = 277 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE : D3D12_MESSAGE_ID = 278 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER : D3D12_MESSAGE_ID = 280 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDCLASSLINKAGE : D3D12_MESSAGE_ID = 283 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM : D3D12_MESSAGE_ID = 284 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES : D3D12_MESSAGE_ID = 285 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES : D3D12_MESSAGE_ID = 286 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES : D3D12_MESSAGE_ID = 287 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHULLSHADER_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 289;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 290 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERTYPE : D3D12_MESSAGE_ID = 291 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDCLASSLINKAGE : D3D12_MESSAGE_ID = 292 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDOMAINSHADER_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 294;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 295 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERTYPE : D3D12_MESSAGE_ID = 296 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCLASSLINKAGE : D3D12_MESSAGE_ID = 297 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_UNMAP_NOTMAPPED:
    D3D12_MESSAGE_ID = 310;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE : D3D12_MESSAGE_ID = 318 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATECOMPUTESHADER_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 321;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 322 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCLASSLINKAGE : D3D12_MESSAGE_ID = 323 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED : D3D12_MESSAGE_ID = 331 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED : D3D12_MESSAGE_ID = 332 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED : D3D12_MESSAGE_ID = 333 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED : D3D12_MESSAGE_ID = 334 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED : D3D12_MESSAGE_ID = 335 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED : D3D12_MESSAGE_ID = 336 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED : D3D12_MESSAGE_ID = 337 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE : D3D12_MESSAGE_ID = 340 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDESC : D3D12_MESSAGE_ID = 341 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT : D3D12_MESSAGE_ID = 342 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANESLICE : D3D12_MESSAGE_ID = 343 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANESLICE : D3D12_MESSAGE_ID = 344 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS : D3D12_MESSAGE_ID = 345 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT : D3D12_MESSAGE_ID = 346 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS : D3D12_MESSAGE_ID = 354 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT : D3D12_MESSAGE_ID = 401 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDLOGICOPS:
    D3D12_MESSAGE_ID = 403;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED : D3D12_MESSAGE_ID = 410 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED : D3D12_MESSAGE_ID = 412 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED : D3D12_MESSAGE_ID = 414 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED : D3D12_MESSAGE_ID = 416 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED : D3D12_MESSAGE_ID = 418 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED : D3D12_MESSAGE_ID = 420 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED : D3D12_MESSAGE_ID = 422 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED : D3D12_MESSAGE_ID = 425 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED : D3D12_MESSAGE_ID = 426 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED : D3D12_MESSAGE_ID = 427 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED : D3D12_MESSAGE_ID = 428 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED : D3D12_MESSAGE_ID = 429 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED : D3D12_MESSAGE_ID = 430 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED : D3D12_MESSAGE_ID = 431 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDSOURCERECT : D3D12_MESSAGE_ID = 447 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_EMPTYRECT:
    D3D12_MESSAGE_ID = 448;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_INVALID_PARAMETER : D3D12_MESSAGE_ID = 493 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTILEMAPPINGS_INVALID_PARAMETER : D3D12_MESSAGE_ID = 494 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEVICE_INVALIDARGS:
    D3D12_MESSAGE_ID = 506;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEVICE_WARNING:
    D3D12_MESSAGE_ID = 507;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_TYPE:
    D3D12_MESSAGE_ID = 519;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_NULL_POINTER:
    D3D12_MESSAGE_ID = 520;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SUBRESOURCE : D3D12_MESSAGE_ID = 521 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_RESERVED_BITS:
    D3D12_MESSAGE_ID = 522;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISSING_BIND_FLAGS : D3D12_MESSAGE_ID = 523 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_MISC_FLAGS : D3D12_MESSAGE_ID = 524 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_MATCHING_STATES:
    D3D12_MESSAGE_ID = 525;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINATION : D3D12_MESSAGE_ID = 526 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_BEFORE_AFTER_MISMATCH : D3D12_MESSAGE_ID = 527 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_RESOURCE : D3D12_MESSAGE_ID = 528 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_SAMPLE_COUNT:
    D3D12_MESSAGE_ID = 529;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS:
    D3D12_MESSAGE_ID = 530;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINED_FLAGS : D3D12_MESSAGE_ID = 531 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS_FOR_FORMAT : D3D12_MESSAGE_ID = 532 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SPLIT_BARRIER : D3D12_MESSAGE_ID = 533 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_END:
    D3D12_MESSAGE_ID = 534;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_BEGIN:
    D3D12_MESSAGE_ID = 535;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAG:
    D3D12_MESSAGE_ID = 536;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMMAND_LIST_TYPE : D3D12_MESSAGE_ID = 537 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_INVALID_SUBRESOURCE_STATE:
    D3D12_MESSAGE_ID = 538;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CONTENTION:
    D3D12_MESSAGE_ID = 540;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET:
    D3D12_MESSAGE_ID = 541;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET_BUNDLE:
    D3D12_MESSAGE_ID = 542;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CANNOT_RESET:
    D3D12_MESSAGE_ID = 543;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_OPEN:
    D3D12_MESSAGE_ID = 544;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_INVALID_BUNDLE_API:
    D3D12_MESSAGE_ID = 546;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_CLOSED:
    D3D12_MESSAGE_ID = 547;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRONG_COMMAND_ALLOCATOR_TYPE:
    D3D12_MESSAGE_ID = 549;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_SYNC:
    D3D12_MESSAGE_ID = 552;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_SYNC:
    D3D12_MESSAGE_ID = 553;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_DESCRIPTOR_HEAP_INVALID:
    D3D12_MESSAGE_ID = 554;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMANDQUEUE:
    D3D12_MESSAGE_ID = 557;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMANDALLOCATOR:
    D3D12_MESSAGE_ID = 558;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_PIPELINESTATE:
    D3D12_MESSAGE_ID = 559;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMANDLIST12:
    D3D12_MESSAGE_ID = 560;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_RESOURCE: D3D12_MESSAGE_ID =
    562;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_DESCRIPTORHEAP:
    D3D12_MESSAGE_ID = 563;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_ROOTSIGNATURE:
    D3D12_MESSAGE_ID = 564;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_LIBRARY: D3D12_MESSAGE_ID =
    565;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_HEAP: D3D12_MESSAGE_ID = 566;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_MONITOREDFENCE:
    D3D12_MESSAGE_ID = 567;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_QUERYHEAP: D3D12_MESSAGE_ID =
    568;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMANDSIGNATURE:
    D3D12_MESSAGE_ID = 569;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_COMMANDQUEUE:
    D3D12_MESSAGE_ID = 570;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_COMMANDALLOCATOR:
    D3D12_MESSAGE_ID = 571;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_PIPELINESTATE:
    D3D12_MESSAGE_ID = 572;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_COMMANDLIST12:
    D3D12_MESSAGE_ID = 573;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_RESOURCE: D3D12_MESSAGE_ID =
    575;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_DESCRIPTORHEAP:
    D3D12_MESSAGE_ID = 576;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_ROOTSIGNATURE:
    D3D12_MESSAGE_ID = 577;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_LIBRARY: D3D12_MESSAGE_ID =
    578;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_HEAP: D3D12_MESSAGE_ID = 579;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_MONITOREDFENCE:
    D3D12_MESSAGE_ID = 580;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_QUERYHEAP: D3D12_MESSAGE_ID =
    581;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_COMMANDSIGNATURE:
    D3D12_MESSAGE_ID = 582;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_COMMANDQUEUE:
    D3D12_MESSAGE_ID = 583;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_COMMANDALLOCATOR:
    D3D12_MESSAGE_ID = 584;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_PIPELINESTATE:
    D3D12_MESSAGE_ID = 585;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_COMMANDLIST12:
    D3D12_MESSAGE_ID = 586;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_RESOURCE: D3D12_MESSAGE_ID =
    588;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_DESCRIPTORHEAP:
    D3D12_MESSAGE_ID = 589;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_ROOTSIGNATURE:
    D3D12_MESSAGE_ID = 590;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_LIBRARY: D3D12_MESSAGE_ID =
    591;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_HEAP: D3D12_MESSAGE_ID =
    592;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_MONITOREDFENCE:
    D3D12_MESSAGE_ID = 593;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_QUERYHEAP:
    D3D12_MESSAGE_ID = 594;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_COMMANDSIGNATURE:
    D3D12_MESSAGE_ID = 595;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONS:
    D3D12_MESSAGE_ID = 597;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMISCFLAGS:
    D3D12_MESSAGE_ID = 599;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDARG_RETURN:
    D3D12_MESSAGE_ID = 602;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_OUTOFMEMORY_RETURN : D3D12_MESSAGE_ID = 603 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDESC:
    D3D12_MESSAGE_ID = 604;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_POSSIBLY_INVALID_SUBRESOURCE_STATE : D3D12_MESSAGE_ID = 607 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_INVALID_USE_OF_NON_RESIDENT_RESOURCE : D3D12_MESSAGE_ID = 608 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_POSSIBLE_INVALID_USE_OF_NON_RESIDENT_RESOURCE : D3D12_MESSAGE_ID = 609 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_BUNDLE_PIPELINE_STATE_MISMATCH:
    D3D12_MESSAGE_ID = 610;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_PRIMITIVE_TOPOLOGY_MISMATCH_PIPELINE_STATE : D3D12_MESSAGE_ID = 611 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_TARGET_FORMAT_MISMATCH_PIPELINE_STATE : D3D12_MESSAGE_ID = 613 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_TARGET_SAMPLE_DESC_MISMATCH_PIPELINE_STATE : D3D12_MESSAGE_ID = 614 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEPTH_STENCIL_FORMAT_MISMATCH_PIPELINE_STATE : D3D12_MESSAGE_ID = 615 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEPTH_STENCIL_SAMPLE_DESC_MISMATCH_PIPELINE_STATE : D3D12_MESSAGE_ID = 616 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADER_INVALIDBYTECODE:
    D3D12_MESSAGE_ID = 622;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_NULLDESC:
    D3D12_MESSAGE_ID = 623;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_INVALIDSIZE:
    D3D12_MESSAGE_ID = 624;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDHEAPTYPE:
    D3D12_MESSAGE_ID = 625;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES : D3D12_MESSAGE_ID = 626 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMEMORYPOOL : D3D12_MESSAGE_ID = 627 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_INVALIDPROPERTIES:
    D3D12_MESSAGE_ID = 628;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_INVALIDALIGNMENT:
    D3D12_MESSAGE_ID = 629;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMISCFLAGS:
    D3D12_MESSAGE_ID = 630;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_INVALIDMISCFLAGS:
    D3D12_MESSAGE_ID = 631;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_INVALIDARG_RETURN:
    D3D12_MESSAGE_ID = 632;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEHEAP_OUTOFMEMORY_RETURN:
    D3D12_MESSAGE_ID = 633;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAPPROPERTIES : D3D12_MESSAGE_ID = 634 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPTYPE : D3D12_MESSAGE_ID = 635 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES : D3D12_MESSAGE_ID = 636 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDMEMORYPOOL : D3D12_MESSAGE_ID = 637 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPPROPERTIES : D3D12_MESSAGE_ID = 638 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPMISCFLAGS : D3D12_MESSAGE_ID = 639 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPMISCFLAGS : D3D12_MESSAGE_ID = 640 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDARG_RETURN : D3D12_MESSAGE_ID = 641 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_OUTOFMEMORY_RETURN : D3D12_MESSAGE_ID = 642 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_UNRECOGNIZEDHEAPTYPE : D3D12_MESSAGE_ID = 643 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_INVALIDHEAPTYPE : D3D12_MESSAGE_ID = 644 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_INVALID_DESC : D3D12_MESSAGE_ID = 645 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_INVALID_DESCRIPTOR_HANDLE:
    D3D12_MESSAGE_ID = 646;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE : D3D12_MESSAGE_ID = 647 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_RESOURCE : D3D12_MESSAGE_ID = 649 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_DESC : D3D12_MESSAGE_ID = 650 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_UNORDEREDACCESS_VIEW_INVALID_COUNTER_USAGE : D3D12_MESSAGE_ID = 652 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPY_DESCRIPTORS_INVALID_RANGES:
    D3D12_MESSAGE_ID = 653;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPY_DESCRIPTORS_WRITE_ONLY_DESCRIPTOR : D3D12_MESSAGE_ID = 654 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RTV_FORMAT_NOT_UNKNOWN : D3D12_MESSAGE_ID = 655 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_RENDER_TARGET_COUNT : D3D12_MESSAGE_ID = 656 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VERTEX_SHADER_NOT_SET : D3D12_MESSAGE_ID = 657 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_NOT_SET : D3D12_MESSAGE_ID = 658 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_HS_DS_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 659 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERINDEX : D3D12_MESSAGE_ID = 660 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_COMPONENTTYPE : D3D12_MESSAGE_ID = 661 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERMASK : D3D12_MESSAGE_ID = 662 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SYSTEMVALUE : D3D12_MESSAGE_ID = 663 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS : D3D12_MESSAGE_ID = 664 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_MINPRECISION : D3D12_MESSAGE_ID = 665 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND : D3D12_MESSAGE_ID = 666 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_XOR_DS_MISMATCH : D3D12_MESSAGE_ID = 667 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH : D3D12_MESSAGE_ID = 668 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_CONTROL_POINT_COUNT_MISMATCH : D3D12_MESSAGE_ID = 669 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_TESSELLATOR_DOMAIN_MISMATCH : D3D12_MESSAGE_ID = 670 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN : D3D12_MESSAGE_ID = 671 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_FORCED_SAMPLE_COUNT : D3D12_MESSAGE_ID = 672 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_PRIMITIVETOPOLOGY : D3D12_MESSAGE_ID = 673 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SYSTEMVALUE : D3D12_MESSAGE_ID = 674 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0 : D3D12_MESSAGE_ID = 675 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING : D3D12_MESSAGE_ID = 676 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_TYPE_MISMATCH : D3D12_MESSAGE_ID = 677 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS : D3D12_MESSAGE_ID = 678 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RENDERTARGETVIEW_NOT_SET : D3D12_MESSAGE_ID = 679 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DEPTHSTENCILVIEW_NOT_SET : D3D12_MESSAGE_ID = 680 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_INPUT_PRIMITIVE_MISMATCH : D3D12_MESSAGE_ID = 681 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_POSITION_NOT_PRESENT : D3D12_MESSAGE_ID = 682 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE_FLAGS : D3D12_MESSAGE_ID = 683 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_INDEX_BUFFER_PROPERTIES : D3D12_MESSAGE_ID = 684 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SAMPLE_DESC : D3D12_MESSAGE_ID = 685 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 686 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DS_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 687 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VS_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 688 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 689 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 690 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE : D3D12_MESSAGE_ID = 691 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTE_BUNDLE_OPEN_BUNDLE:
    D3D12_MESSAGE_ID = 692;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTE_BUNDLE_DESCRIPTOR_HEAP_MISMATCH : D3D12_MESSAGE_ID = 693 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTE_BUNDLE_TYPE:
    D3D12_MESSAGE_ID = 694;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DRAW_EMPTY_SCISSOR_RECTANGLE:
    D3D12_MESSAGE_ID = 695;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_BLOB_NOT_FOUND : D3D12_MESSAGE_ID = 696 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_DESERIALIZE_FAILED : D3D12_MESSAGE_ID = 697 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_INVALID_CONFIGURATION : D3D12_MESSAGE_ID = 698 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_SUPPORTED_ON_DEVICE : D3D12_MESSAGE_ID = 699 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLRESOURCEPROPERTIES : D3D12_MESSAGE_ID = 700 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAP:
    D3D12_MESSAGE_ID = 701;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETRESOURCEALLOCATIONINFO_INVALIDRDESCS : D3D12_MESSAGE_ID = 702 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAKERESIDENT_NULLOBJECTARRAY:
    D3D12_MESSAGE_ID = 703;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EVICT_NULLOBJECTARRAY:
    D3D12_MESSAGE_ID = 705;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_DESCRIPTOR_TABLE_INVALID:
    D3D12_MESSAGE_ID = 708;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_INVALID:
    D3D12_MESSAGE_ID = 709;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_BUFFER_VIEW_INVALID : D3D12_MESSAGE_ID = 710 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_ROOT_SHADER_RESOURCE_VIEW_INVALID : D3D12_MESSAGE_ID = 711 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_ROOT_UNORDERED_ACCESS_VIEW_INVALID : D3D12_MESSAGE_ID = 712 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID_DESC:
    D3D12_MESSAGE_ID = 713;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID_DESC:
    D3D12_MESSAGE_ID = 715;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID_DESC : D3D12_MESSAGE_ID = 717 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDDIMENSIONALITY : D3D12_MESSAGE_ID = 718 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDLAYOUT : D3D12_MESSAGE_ID = 719 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONALITY : D3D12_MESSAGE_ID = 720 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDALIGNMENT:
    D3D12_MESSAGE_ID = 721;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMIPLEVELS:
    D3D12_MESSAGE_ID = 722;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDSAMPLEDESC:
    D3D12_MESSAGE_ID = 723;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDLAYOUT:
    D3D12_MESSAGE_ID = 724;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID:
    D3D12_MESSAGE_ID = 725;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID:
    D3D12_MESSAGE_ID = 726;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID : D3D12_MESSAGE_ID = 727 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_RENDER_TARGETS_INVALID:
    D3D12_MESSAGE_ID = 728;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEQUERY_HEAP_INVALID_PARAMETERS : D3D12_MESSAGE_ID = 729 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_BEGIN_END_QUERY_INVALID_PARAMETERS : D3D12_MESSAGE_ID = 731 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CLOSE_COMMAND_LIST_OPEN_QUERY:
    D3D12_MESSAGE_ID = 732;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVE_QUERY_DATA_INVALID_PARAMETERS : D3D12_MESSAGE_ID = 733 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_PREDICATION_INVALID_PARAMETERS : D3D12_MESSAGE_ID = 734 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_TIMESTAMPS_NOT_SUPPORTED:
    D3D12_MESSAGE_ID = 735;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDFORMAT : D3D12_MESSAGE_ID = 737 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDFORMAT:
    D3D12_MESSAGE_ID = 738;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_INVALIDSUBRESOURCERANGE : D3D12_MESSAGE_ID = 739 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_INVALIDBASEOFFSET : D3D12_MESSAGE_ID = 740 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDSUBRESOURCERANGE : D3D12_MESSAGE_ID = 739 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDBASEOFFSET : D3D12_MESSAGE_ID = 740 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_HEAP:
    D3D12_MESSAGE_ID = 741;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_SAMPLER_INVALID:
    D3D12_MESSAGE_ID = 742;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATECOMMANDSIGNATURE_INVALID:
    D3D12_MESSAGE_ID = 743;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTE_INDIRECT_INVALID_PARAMETERS : D3D12_MESSAGE_ID = 744 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_RESOURCE_DIMENSION : D3D12_MESSAGE_ID = 745 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUE:
    D3D12_MESSAGE_ID = 815;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDCLEARVALUEFORMAT : D3D12_MESSAGE_ID = 816 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUEFORMAT : D3D12_MESSAGE_ID = 817 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATERESOURCE_CLEARVALUEDENORMFLUSH : D3D12_MESSAGE_ID = 818 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CLEARRENDERTARGETVIEW_MISMATCHINGCLEARVALUE : D3D12_MESSAGE_ID = 820 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_MISMATCHINGCLEARVALUE : D3D12_MESSAGE_ID = 821 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAP_INVALIDHEAP: D3D12_MESSAGE_ID =
    822;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UNMAP_INVALIDHEAP:
    D3D12_MESSAGE_ID = 823;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAP_INVALIDRESOURCE:
    D3D12_MESSAGE_ID = 824;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UNMAP_INVALIDRESOURCE:
    D3D12_MESSAGE_ID = 825;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAP_INVALIDSUBRESOURCE:
    D3D12_MESSAGE_ID = 826;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UNMAP_INVALIDSUBRESOURCE:
    D3D12_MESSAGE_ID = 827;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAP_INVALIDRANGE: D3D12_MESSAGE_ID =
    828;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UNMAP_INVALIDRANGE:
    D3D12_MESSAGE_ID = 829;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAP_INVALIDDATAPOINTER:
    D3D12_MESSAGE_ID = 832;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAP_INVALIDARG_RETURN:
    D3D12_MESSAGE_ID = 833;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAP_OUTOFMEMORY_RETURN:
    D3D12_MESSAGE_ID = 834;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_BUNDLENOTSUPPORTED : D3D12_MESSAGE_ID = 835 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_COMMANDLISTMISMATCH : D3D12_MESSAGE_ID = 836 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_OPENCOMMANDLIST : D3D12_MESSAGE_ID = 837 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_FAILEDCOMMANDLIST : D3D12_MESSAGE_ID = 838 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLDST:
    D3D12_MESSAGE_ID = 839;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDDSTRESOURCEDIMENSION : D3D12_MESSAGE_ID = 840 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_DSTRANGEOUTOFBOUNDS : D3D12_MESSAGE_ID = 841 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLSRC:
    D3D12_MESSAGE_ID = 842;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDSRCRESOURCEDIMENSION : D3D12_MESSAGE_ID = 843 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_SRCRANGEOUTOFBOUNDS : D3D12_MESSAGE_ID = 844 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDCOPYFLAGS : D3D12_MESSAGE_ID = 845 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLDST:
    D3D12_MESSAGE_ID = 846;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTTYPE : D3D12_MESSAGE_ID = 847 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCEDIMENSION : D3D12_MESSAGE_ID = 848 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCE : D3D12_MESSAGE_ID = 849 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTSUBRESOURCE : D3D12_MESSAGE_ID = 850 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTOFFSET : D3D12_MESSAGE_ID = 851 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTFORMAT : D3D12_MESSAGE_ID = 852 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTFORMAT : D3D12_MESSAGE_ID = 853 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDIMENSIONS : D3D12_MESSAGE_ID = 854 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTROWPITCH : D3D12_MESSAGE_ID = 855 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTPLACEMENT : D3D12_MESSAGE_ID = 856 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDSPLACEDFOOTPRINTFORMAT : D3D12_MESSAGE_ID = 857 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_DSTREGIONOUTOFBOUNDS : D3D12_MESSAGE_ID = 858 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLSRC:
    D3D12_MESSAGE_ID = 859;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCTYPE : D3D12_MESSAGE_ID = 860 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCEDIMENSION : D3D12_MESSAGE_ID = 861 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCE : D3D12_MESSAGE_ID = 862 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCSUBRESOURCE : D3D12_MESSAGE_ID = 863 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCOFFSET : D3D12_MESSAGE_ID = 864 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCFORMAT : D3D12_MESSAGE_ID = 865 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCFORMAT : D3D12_MESSAGE_ID = 866 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDIMENSIONS : D3D12_MESSAGE_ID = 867 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCROWPITCH : D3D12_MESSAGE_ID = 868 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCPLACEMENT : D3D12_MESSAGE_ID = 869 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDSPLACEDFOOTPRINTFORMAT : D3D12_MESSAGE_ID = 870 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_SRCREGIONOUTOFBOUNDS : D3D12_MESSAGE_ID = 871 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTCOORDINATES : D3D12_MESSAGE_ID = 872 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCBOX:
    D3D12_MESSAGE_ID = 873;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_FORMATMISMATCH:
    D3D12_MESSAGE_ID = 874;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_EMPTYBOX:
    D3D12_MESSAGE_ID = 875;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDCOPYFLAGS : D3D12_MESSAGE_ID = 876 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SUBRESOURCE_INDEX : D3D12_MESSAGE_ID = 877 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_FORMAT : D3D12_MESSAGE_ID = 878 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_MISMATCH : D3D12_MESSAGE_ID = 879 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SAMPLE_COUNT : D3D12_MESSAGE_ID = 880 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_INVALID_SHADER : D3D12_MESSAGE_ID = 881 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_CS_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 882 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_MISSING_ROOT_SIGNATURE : D3D12_MESSAGE_ID = 883 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALIDCACHEDBLOB : D3D12_MESSAGE_ID = 884 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBADAPTERMISMATCH : D3D12_MESSAGE_ID = 885 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDRIVERVERSIONMISMATCH : D3D12_MESSAGE_ID = 886 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDESCMISMATCH : D3D12_MESSAGE_ID = 887 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBIGNORED : D3D12_MESSAGE_ID = 888 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDHEAP:
    D3D12_MESSAGE_ID = 889;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDRESOURCE : D3D12_MESSAGE_ID = 890 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDBOX:
    D3D12_MESSAGE_ID = 891;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDSUBRESOURCE : D3D12_MESSAGE_ID = 892 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_EMPTYBOX:
    D3D12_MESSAGE_ID = 893;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDHEAP:
    D3D12_MESSAGE_ID = 894;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDRESOURCE : D3D12_MESSAGE_ID = 895 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDBOX:
    D3D12_MESSAGE_ID = 896;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDSUBRESOURCE : D3D12_MESSAGE_ID = 897 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_READFROMSUBRESOURCE_EMPTYBOX:
    D3D12_MESSAGE_ID = 898;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_TOO_MANY_NODES_SPECIFIED:
    D3D12_MESSAGE_ID = 899;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_INVALID_NODE_INDEX:
    D3D12_MESSAGE_ID = 900;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETHEAPPROPERTIES_INVALIDRESOURCE : D3D12_MESSAGE_ID = 901 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_NODE_MASK_MISMATCH:
    D3D12_MESSAGE_ID = 902;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 903;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_MULTIPLE_SWAPCHAIN_BUFFER_REFERENCES : D3D12_MESSAGE_ID = 904 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_TOO_MANY_SWAPCHAIN_REFERENCES : D3D12_MESSAGE_ID = 905 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_QUEUE_TOO_MANY_SWAPCHAIN_REFERENCES : D3D12_MESSAGE_ID = 906 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_WRONGSWAPCHAINBUFFERREFERENCE : D3D12_MESSAGE_ID = 907 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_SETRENDERTARGETS_INVALIDNUMRENDERTARGETS : D3D12_MESSAGE_ID = 908 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_TYPE:
    D3D12_MESSAGE_ID = 909;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_FLAGS:
    D3D12_MESSAGE_ID = 910;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFLAGS : D3D12_MESSAGE_ID = 911 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFORMAT : D3D12_MESSAGE_ID = 912 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHAREDHEAP_INVALIDFLAGS:
    D3D12_MESSAGE_ID = 913;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_UNRECOGNIZEDPROPERTIES : D3D12_MESSAGE_ID = 914 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDSIZE : D3D12_MESSAGE_ID = 915 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDOBJECT : D3D12_MESSAGE_ID = 916 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDOBJECT:
    D3D12_MESSAGE_ID = 917;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDKEY:
    D3D12_MESSAGE_ID = 918;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_KEYEDMUTEX_WRONGSTATE:
    D3D12_MESSAGE_ID = 919;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_PRIORITY:
    D3D12_MESSAGE_ID = 920;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OBJECT_DELETED_WHILE_STILL_IN_USE : D3D12_MESSAGE_ID = 921 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_FLAGS : D3D12_MESSAGE_ID = 922 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_HAS_NO_RESOURCE : D3D12_MESSAGE_ID = 923 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RENDER_TARGET_DELETED : D3D12_MESSAGE_ID = 924 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_ALL_RENDER_TARGETS_HAVE_UNKNOWN_FORMAT : D3D12_MESSAGE_ID = 925 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_INTERSECTS_MULTIPLE_BUFFERS : D3D12_MESSAGE_ID = 926 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_GPU_WRITTEN_READBACK_RESOURCE_MAPPED : D3D12_MESSAGE_ID = 927 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UNMAP_RANGE_NOT_EMPTY:
    D3D12_MESSAGE_ID = 929;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MAP_INVALID_NULLRANGE:
    D3D12_MESSAGE_ID = 930;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UNMAP_INVALID_NULLRANGE:
    D3D12_MESSAGE_ID = 931;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_NO_GRAPHICS_API_SUPPORT:
    D3D12_MESSAGE_ID = 932;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_NO_COMPUTE_API_SUPPORT:
    D3D12_MESSAGE_ID = 933;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_FLAGS_NOT_SUPPORTED : D3D12_MESSAGE_ID = 934 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_ARGUMENT_UNINITIALIZED : D3D12_MESSAGE_ID = 935 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_HEAP_INDEX_OUT_OF_BOUNDS : D3D12_MESSAGE_ID = 936 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TABLE_REGISTER_INDEX_OUT_OF_BOUNDS : D3D12_MESSAGE_ID = 937 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_UNINITIALIZED : D3D12_MESSAGE_ID = 938 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TYPE_MISMATCH : D3D12_MESSAGE_ID = 939 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SRV_RESOURCE_DIMENSION_MISMATCH : D3D12_MESSAGE_ID = 940 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UAV_RESOURCE_DIMENSION_MISMATCH : D3D12_MESSAGE_ID = 941 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INCOMPATIBLE_RESOURCE_STATE : D3D12_MESSAGE_ID = 942 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYRESOURCE_NULLDST:
    D3D12_MESSAGE_ID = 943;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDDSTRESOURCE:
    D3D12_MESSAGE_ID = 944;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYRESOURCE_NULLSRC:
    D3D12_MESSAGE_ID = 945;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDSRCRESOURCE:
    D3D12_MESSAGE_ID = 946;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLDST:
    D3D12_MESSAGE_ID = 947;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDDSTRESOURCE : D3D12_MESSAGE_ID = 948 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLSRC:
    D3D12_MESSAGE_ID = 949;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDSRCRESOURCE : D3D12_MESSAGE_ID = 950 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_PIPELINE_STATE_TYPE_MISMATCH:
    D3D12_MESSAGE_ID = 951;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_NOT_SET : D3D12_MESSAGE_ID = 952 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 953 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_ZERO_BARRIERS:
    D3D12_MESSAGE_ID = 954;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_BEGIN_END_EVENT_MISMATCH:
    D3D12_MESSAGE_ID = 955;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_POSSIBLE_BEFORE_AFTER_MISMATCH : D3D12_MESSAGE_ID = 956 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_BEGIN_END : D3D12_MESSAGE_ID = 957 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INVALID_RESOURCE : D3D12_MESSAGE_ID = 958 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_USE_OF_ZERO_REFCOUNT_OBJECT:
    D3D12_MESSAGE_ID = 959;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OBJECT_EVICTED_WHILE_STILL_IN_USE : D3D12_MESSAGE_ID = 960 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_DESCRIPTOR_ACCESS_OUT_OF_BOUNDS : D3D12_MESSAGE_ID = 961 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_INVALIDLIBRARYBLOB : D3D12_MESSAGE_ID = 962 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_DRIVERVERSIONMISMATCH : D3D12_MESSAGE_ID = 963 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_ADAPTERVERSIONMISMATCH : D3D12_MESSAGE_ID = 964 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_UNSUPPORTED : D3D12_MESSAGE_ID = 965 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_PIPELINELIBRARY:
    D3D12_MESSAGE_ID = 966;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_PIPELINELIBRARY:
    D3D12_MESSAGE_ID = 967;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_PIPELINELIBRARY:
    D3D12_MESSAGE_ID = 968;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_STOREPIPELINE_NONAME:
    D3D12_MESSAGE_ID = 969;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_STOREPIPELINE_DUPLICATENAME:
    D3D12_MESSAGE_ID = 970;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LOADPIPELINE_NAMENOTFOUND:
    D3D12_MESSAGE_ID = 971;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LOADPIPELINE_INVALIDDESC:
    D3D12_MESSAGE_ID = 972;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_PIPELINELIBRARY_SERIALIZE_NOTENOUGHMEMORY : D3D12_MESSAGE_ID = 973 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_RT_OUTPUT_MISMATCH : D3D12_MESSAGE_ID = 974 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETEVENTONMULTIPLEFENCECOMPLETION_INVALIDFLAGS : D3D12_MESSAGE_ID = 975 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_QUEUE_VIDEO_NOT_SUPPORTED:
    D3D12_MESSAGE_ID = 976;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_ALLOCATOR_VIDEO_NOT_SUPPORTED : D3D12_MESSAGE_ID = 977 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEQUERY_HEAP_VIDEO_DECODE_STATISTICS_NOT_SUPPORTED : D3D12_MESSAGE_ID = 978 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDLIST:
    D3D12_MESSAGE_ID = 979;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEODECODER:
    D3D12_MESSAGE_ID = 980;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEODECODESTREAM:
    D3D12_MESSAGE_ID = 981;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDLIST:
    D3D12_MESSAGE_ID = 982;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEODECODER:
    D3D12_MESSAGE_ID = 983;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEODECODESTREAM:
    D3D12_MESSAGE_ID = 984;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDLIST:
    D3D12_MESSAGE_ID = 985;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEODECODER:
    D3D12_MESSAGE_ID = 986;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEODECODESTREAM:
    D3D12_MESSAGE_ID = 987;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DECODE_FRAME_INVALID_PARAMETERS:
    D3D12_MESSAGE_ID = 988;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEPRECATED_API: D3D12_MESSAGE_ID =
    989;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_COMMAND_LIST_TYPE : D3D12_MESSAGE_ID = 990 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_DESCRIPTOR_TABLE_NOT_SET : D3D12_MESSAGE_ID = 991 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_CONSTANT_BUFFER_VIEW_NOT_SET : D3D12_MESSAGE_ID = 992 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_SHADER_RESOURCE_VIEW_NOT_SET : D3D12_MESSAGE_ID = 993 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_UNORDERED_ACCESS_VIEW_NOT_SET : D3D12_MESSAGE_ID = 994 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DISCARD_INVALID_SUBRESOURCE_RANGE : D3D12_MESSAGE_ID = 995 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DISCARD_ONE_SUBRESOURCE_FOR_MIPS_WITH_RECTS : D3D12_MESSAGE_ID = 996 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DISCARD_NO_RECTS_FOR_NON_TEXTURE2D : D3D12_MESSAGE_ID = 997 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPY_ON_SAME_SUBRESOURCE:
    D3D12_MESSAGE_ID = 998;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PAGEABLE : D3D12_MESSAGE_ID = 999 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UNSUPPORTED:
    D3D12_MESSAGE_ID = 1000;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_STATIC_DESCRIPTOR_INVALID_DESCRIPTOR_CHANGE : D3D12_MESSAGE_ID = 1001 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DATA_STATIC_DESCRIPTOR_INVALID_DATA_CHANGE : D3D12_MESSAGE_ID = 1002 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DATA_STATIC_WHILE_SET_AT_EXECUTE_DESCRIPTOR_INVALID_DATA_CHANGE : D3D12_MESSAGE_ID = 1003 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EXECUTE_BUNDLE_STATIC_DESCRIPTOR_DATA_STATIC_NOT_SET : D3D12_MESSAGE_ID = 1004 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_ACCESS_OUT_OF_BOUNDS : D3D12_MESSAGE_ID = 1005 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SAMPLER_MODE_MISMATCH : D3D12_MESSAGE_ID = 1006 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_FENCE_INVALID_FLAGS:
    D3D12_MESSAGE_ID = 1007;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_BARRIER_DUPLICATE_SUBRESOURCE_TRANSITIONS : D3D12_MESSAGE_ID = 1008 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PRIORITY : D3D12_MESSAGE_ID = 1009 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_LARGE_NUM_DESCRIPTORS : D3D12_MESSAGE_ID = 1013 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_BEGIN_EVENT: D3D12_MESSAGE_ID =
    1014;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_END_EVENT: D3D12_MESSAGE_ID = 1015;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEVICE_DEBUG_LAYER_STARTUP_OPTIONS : D3D12_MESSAGE_ID = 1016 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_DEPTHBOUNDSTEST_UNSUPPORTED : D3D12_MESSAGE_ID = 1017 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_DUPLICATE_SUBOBJECT : D3D12_MESSAGE_ID = 1018 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_UNKNOWN_SUBOBJECT : D3D12_MESSAGE_ID = 1019 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_ZERO_SIZE_STREAM : D3D12_MESSAGE_ID = 1020 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_STREAM : D3D12_MESSAGE_ID = 1021 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CANNOT_DEDUCE_TYPE : D3D12_MESSAGE_ID = 1022 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_STATIC_DESCRIPTOR_RESOURCE_DIMENSION_MISMATCH : D3D12_MESSAGE_ID = 1023 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_PRIVILEGE_FOR_GLOBAL_REALTIME : D3D12_MESSAGE_ID = 1024 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_HARDWARE_SUPPORT_FOR_GLOBAL_REALTIME : D3D12_MESSAGE_ID = 1025 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_ARCHITECTURE : D3D12_MESSAGE_ID = 1026 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DST:
    D3D12_MESSAGE_ID = 1027;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE_DIMENSION : D3D12_MESSAGE_ID = 1028 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DST_RANGE_OUT_OF_BOUNDS : D3D12_MESSAGE_ID = 1029 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_SRC:
    D3D12_MESSAGE_ID = 1030;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE_DIMENSION : D3D12_MESSAGE_ID = 1031 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_SRC_RANGE_OUT_OF_BOUNDS : D3D12_MESSAGE_ID = 1032 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_OFFSET_ALIGNMENT : D3D12_MESSAGE_ID = 1033 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_RESOURCES : D3D12_MESSAGE_ID = 1034 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_SUBRESOURCE_RANGES : D3D12_MESSAGE_ID = 1035 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_RESOURCE : D3D12_MESSAGE_ID = 1036 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_SUBRESOURCE_RANGE : D3D12_MESSAGE_ID = 1037 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_SUBRESOURCE_OUT_OF_BOUNDS : D3D12_MESSAGE_ID = 1038 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_RANGE_OUT_OF_BOUNDS : D3D12_MESSAGE_ID = 1039 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_ZERO_DEPENDENCIES : D3D12_MESSAGE_ID = 1040 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DEVICE_CREATE_SHARED_HANDLE_INVALIDARG : D3D12_MESSAGE_ID = 1041 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESCRIPTOR_HANDLE_WITH_INVALID_RESOURCE : D3D12_MESSAGE_ID = 1042 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETDEPTHBOUNDS_INVALIDARGS:
    D3D12_MESSAGE_ID = 1043;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_STATE_IMPRECISE : D3D12_MESSAGE_ID = 1044 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_LIST_PIPELINE_STATE_NOT_SET : D3D12_MESSAGE_ID = 1045 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_MODEL_MISMATCH : D3D12_MESSAGE_ID = 1046 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OBJECT_ACCESSED_WHILE_STILL_IN_USE : D3D12_MESSAGE_ID = 1047 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_PROGRAMMABLE_MSAA_UNSUPPORTED:
    D3D12_MESSAGE_ID = 1048;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETSAMPLEPOSITIONS_INVALIDARGS:
    D3D12_MESSAGE_ID = 1049;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCEREGION_INVALID_RECT : D3D12_MESSAGE_ID = 1050 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1051;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDLIST:
    D3D12_MESSAGE_ID = 1052;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1053;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1054;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDLIST:
    D3D12_MESSAGE_ID = 1055;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1056;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1057;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDLIST:
    D3D12_MESSAGE_ID = 1058;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1059;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSOR:
    D3D12_MESSAGE_ID = 1060;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSSTREAM:
    D3D12_MESSAGE_ID = 1061;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSOR:
    D3D12_MESSAGE_ID = 1062;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSSTREAM:
    D3D12_MESSAGE_ID = 1063;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSOR:
    D3D12_MESSAGE_ID = 1064;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSSTREAM:
    D3D12_MESSAGE_ID = 1065;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_PROCESS_FRAME_INVALID_PARAMETERS:
    D3D12_MESSAGE_ID = 1066;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPY_INVALIDLAYOUT:
    D3D12_MESSAGE_ID = 1067;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_CRYPTO_SESSION:
    D3D12_MESSAGE_ID = 1068;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_CRYPTO_SESSION_POLICY:
    D3D12_MESSAGE_ID = 1069;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_PROTECTED_RESOURCE_SESSION : D3D12_MESSAGE_ID = 1070 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_CRYPTO_SESSION:
    D3D12_MESSAGE_ID = 1071;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_CRYPTO_SESSION_POLICY:
    D3D12_MESSAGE_ID = 1072;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_PROTECTED_RESOURCE_SESSION:
    D3D12_MESSAGE_ID = 1073;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_CRYPTO_SESSION:
    D3D12_MESSAGE_ID = 1074;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_CRYPTO_SESSION_POLICY:
    D3D12_MESSAGE_ID = 1075;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_PROTECTED_RESOURCE_SESSION : D3D12_MESSAGE_ID = 1076 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_PROTECTED_RESOURCE_SESSION_UNSUPPORTED : D3D12_MESSAGE_ID = 1077 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_FENCE_INVALIDOPERATION:
    D3D12_MESSAGE_ID = 1078;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEQUERY_HEAP_COPY_QUEUE_TIMESTAMPS_NOT_SUPPORTED : D3D12_MESSAGE_ID = 1079 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_DEFERRED : D3D12_MESSAGE_ID = 1080 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_RECORDTIME_ASSUMEDFROMFIRSTUSE : D3D12_MESSAGE_ID = 1081 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_RECORDTIME_ASSUMEDFROMCLEAR : D3D12_MESSAGE_ID = 1082 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEODECODERHEAP:
    D3D12_MESSAGE_ID = 1083;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEODECODERHEAP:
    D3D12_MESSAGE_ID = 1084;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEODECODERHEAP:
    D3D12_MESSAGE_ID = 1085;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDARG_RETURN : D3D12_MESSAGE_ID = 1086 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OPENEXISTINGHEAP_OUTOFMEMORY_RETURN : D3D12_MESSAGE_ID = 1087 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDADDRESS:
    D3D12_MESSAGE_ID = 1088;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDHANDLE:
    D3D12_MESSAGE_ID = 1089;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_DEST : D3D12_MESSAGE_ID = 1090 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_MODE : D3D12_MESSAGE_ID = 1091 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_ALIGNMENT : D3D12_MESSAGE_ID = 1092 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_NOT_SUPPORTED : D3D12_MESSAGE_ID = 1093 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETVIEWINSTANCEMASK_INVALIDARGS:
    D3D12_MESSAGE_ID = 1094;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIEW_INSTANCING_UNSUPPORTED:
    D3D12_MESSAGE_ID = 1095;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIEW_INSTANCING_INVALIDARGS:
    D3D12_MESSAGE_ID = 1096;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_MISMATCH_DECODE_REFERENCE_ONLY_FLAG : D3D12_MESSAGE_ID = 1097 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYRESOURCE_MISMATCH_DECODE_REFERENCE_ONLY_FLAG : D3D12_MESSAGE_ID = 1098 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEO_DECODE_HEAP_CAPS_FAILURE : D3D12_MESSAGE_ID = 1099 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEO_DECODE_HEAP_CAPS_UNSUPPORTED : D3D12_MESSAGE_ID = 1100 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_DECODE_SUPPORT_INVALID_INPUT : D3D12_MESSAGE_ID = 1101 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEO_DECODER_UNSUPPORTED:
    D3D12_MESSAGE_ID = 1102;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_METADATA_ERROR : D3D12_MESSAGE_ID = 1103 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VIEW_INSTANCING_VERTEX_SIZE_EXCEEDED : D3D12_MESSAGE_ID = 1104 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RUNTIME_INTERNAL_ERROR : D3D12_MESSAGE_ID = 1105 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_NO_VIDEO_API_SUPPORT:
    D3D12_MESSAGE_ID = 1106;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_PROCESS_SUPPORT_INVALID_INPUT : D3D12_MESSAGE_ID = 1107 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEO_PROCESSOR_CAPS_FAILURE : D3D12_MESSAGE_ID = 1108 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_PROCESS_SUPPORT_UNSUPPORTED_FORMAT : D3D12_MESSAGE_ID = 1109 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_DECODE_FRAME_INVALID_ARGUMENT : D3D12_MESSAGE_ID = 1110 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ENQUEUE_MAKE_RESIDENT_INVALID_FLAGS : D3D12_MESSAGE_ID = 1111 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OPENEXISTINGHEAP_UNSUPPORTED:
    D3D12_MESSAGE_ID = 1112;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_PROCESS_FRAMES_INVALID_ARGUMENT : D3D12_MESSAGE_ID = 1113 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_DECODE_SUPPORT_UNSUPPORTED:
    D3D12_MESSAGE_ID = 1114;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMANDRECORDER:
    D3D12_MESSAGE_ID = 1115;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_COMMANDRECORDER:
    D3D12_MESSAGE_ID = 1116;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_COMMANDRECORDER:
    D3D12_MESSAGE_ID = 1117;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_VIDEO_NOT_SUPPORTED : D3D12_MESSAGE_ID = 1118 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_INVALID_SUPPORT_FLAGS : D3D12_MESSAGE_ID = 1119 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_INVALID_FLAGS : D3D12_MESSAGE_ID = 1120 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_MORE_RECORDERS_THAN_LOGICAL_PROCESSORS : D3D12_MESSAGE_ID = 1121 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMANDPOOL:
    D3D12_MESSAGE_ID = 1122;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_COMMANDPOOL: D3D12_MESSAGE_ID =
    1123;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_COMMANDPOOL:
    D3D12_MESSAGE_ID = 1124;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_POOL_INVALID_FLAGS : D3D12_MESSAGE_ID = 1125 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_VIDEO_NOT_SUPPORTED : D3D12_MESSAGE_ID = 1126 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_RECORDER_SUPPORT_FLAGS_MISMATCH : D3D12_MESSAGE_ID = 1127 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_RECORDER_CONTENTION:
    D3D12_MESSAGE_ID = 1128;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_RECORDER_USAGE_WITH_CREATECOMMANDLIST_COMMAND_LIST : D3D12_MESSAGE_ID = 1129 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_USAGE_WITH_CREATECOMMANDLIST1_COMMAND_LIST : D3D12_MESSAGE_ID = 1130 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CANNOT_EXECUTE_EMPTY_COMMAND_LIST : D3D12_MESSAGE_ID = 1131 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CANNOT_RESET_COMMAND_POOL_WITH_OPEN_COMMAND_LISTS : D3D12_MESSAGE_ID = 1132 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CANNOT_USE_COMMAND_RECORDER_WITHOUT_CURRENT_TARGET : D3D12_MESSAGE_ID = 1133 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CANNOT_CHANGE_COMMAND_RECORDER_TARGET_WHILE_RECORDING : D3D12_MESSAGE_ID = 1134 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMMAND_POOL_SYNC:
    D3D12_MESSAGE_ID = 1135;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EVICT_UNDERFLOW: D3D12_MESSAGE_ID =
    1136;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_META_COMMAND:
    D3D12_MESSAGE_ID = 1137;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_META_COMMAND:
    D3D12_MESSAGE_ID = 1138;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_META_COMMAND:
    D3D12_MESSAGE_ID = 1139;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALID_DST_RESOURCE : D3D12_MESSAGE_ID = 1140 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALID_SRC_RESOURCE : D3D12_MESSAGE_ID = 1141 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE : D3D12_MESSAGE_ID = 1142 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE : D3D12_MESSAGE_ID = 1143 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_NULL_BUFFER : D3D12_MESSAGE_ID = 1144 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_NULL_RESOURCE_DESC : D3D12_MESSAGE_ID = 1145 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_UNSUPPORTED : D3D12_MESSAGE_ID = 1146 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_DIMENSION : D3D12_MESSAGE_ID = 1147 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_FLAGS : D3D12_MESSAGE_ID = 1148 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_OFFSET : D3D12_MESSAGE_ID = 1149 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_RESOURCE_DIMENSION : D3D12_MESSAGE_ID = 1150 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_RESOURCE_FLAGS : D3D12_MESSAGE_ID = 1151 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_OUTOFMEMORY_RETURN : D3D12_MESSAGE_ID = 1152 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CANNOT_CREATE_GRAPHICS_AND_VIDEO_COMMAND_RECORDER : D3D12_MESSAGE_ID = 1153 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_POSSIBLY_MISMATCHING_PROPERTIES : D3D12_MESSAGE_ID = 1154 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_INVALID_COMMAND_LIST_TYPE : D3D12_MESSAGE_ID = 1155 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_INCOMPATIBLE_WITH_STRUCTURED_BUFFERS : D3D12_MESSAGE_ID = 1156 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COMPUTE_ONLY_DEVICE_OPERATION_UNSUPPORTED : D3D12_MESSAGE_ID = 1157 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INVALID : D3D12_MESSAGE_ID = 1158 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EMIT_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_INVALID : D3D12_MESSAGE_ID = 1159 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPY_RAYTRACING_ACCELERATION_STRUCTURE_INVALID : D3D12_MESSAGE_ID = 1160 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DISPATCH_RAYS_INVALID:
    D3D12_MESSAGE_ID = 1161;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GET_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO_INVALID : D3D12_MESSAGE_ID = 1162 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_LIFETIMETRACKER:
    D3D12_MESSAGE_ID = 1163;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_LIFETIMETRACKER:
    D3D12_MESSAGE_ID = 1164;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_LIFETIMETRACKER:
    D3D12_MESSAGE_ID = 1165;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROYOWNEDOBJECT_OBJECTNOTOWNED : D3D12_MESSAGE_ID = 1166 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_TRACKEDWORKLOAD:
    D3D12_MESSAGE_ID = 1167;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_TRACKEDWORKLOAD:
    D3D12_MESSAGE_ID = 1168;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_TRACKEDWORKLOAD:
    D3D12_MESSAGE_ID = 1169;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_ERROR:
    D3D12_MESSAGE_ID = 1170;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_META_COMMAND_ID_INVALID:
    D3D12_MESSAGE_ID = 1171;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_META_COMMAND_UNSUPPORTED_PARAMS:
    D3D12_MESSAGE_ID = 1172;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_META_COMMAND_FAILED_ENUMERATION:
    D3D12_MESSAGE_ID = 1173;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_META_COMMAND_PARAMETER_SIZE_MISMATCH : D3D12_MESSAGE_ID = 1174 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_UNINITIALIZED_META_COMMAND:
    D3D12_MESSAGE_ID = 1175;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_META_COMMAND_INVALID_GPU_VIRTUAL_ADDRESS : D3D12_MESSAGE_ID = 1176 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOENCODECOMMANDLIST:
    D3D12_MESSAGE_ID = 1177;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOENCODECOMMANDLIST:
    D3D12_MESSAGE_ID = 1178;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOENCODECOMMANDLIST:
    D3D12_MESSAGE_ID = 1179;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOENCODECOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1180;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOENCODECOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1181;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOENCODECOMMANDQUEUE:
    D3D12_MESSAGE_ID = 1182;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOMOTIONESTIMATOR:
    D3D12_MESSAGE_ID = 1183;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOMOTIONESTIMATOR:
    D3D12_MESSAGE_ID = 1184;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOMOTIONESTIMATOR:
    D3D12_MESSAGE_ID = 1185;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOMOTIONVECTORHEAP:
    D3D12_MESSAGE_ID = 1186;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOMOTIONVECTORHEAP:
    D3D12_MESSAGE_ID = 1187;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOMOTIONVECTORHEAP:
    D3D12_MESSAGE_ID = 1188;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOADS:
    D3D12_MESSAGE_ID = 1189;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOAD_PAIRS:
    D3D12_MESSAGE_ID = 1190;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OUT_OF_ORDER_TRACKED_WORKLOAD_PAIR : D3D12_MESSAGE_ID = 1191 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CANNOT_ADD_TRACKED_WORKLOAD:
    D3D12_MESSAGE_ID = 1192;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_INCOMPLETE_TRACKED_WORKLOAD_PAIR:
    D3D12_MESSAGE_ID = 1193;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_STATE_OBJECT_ERROR:
    D3D12_MESSAGE_ID = 1194;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GET_SHADER_IDENTIFIER_ERROR:
    D3D12_MESSAGE_ID = 1195;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GET_SHADER_STACK_SIZE_ERROR:
    D3D12_MESSAGE_ID = 1196;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GET_PIPELINE_STACK_SIZE_ERROR:
    D3D12_MESSAGE_ID = 1197;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_PIPELINE_STACK_SIZE_ERROR:
    D3D12_MESSAGE_ID = 1198;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GET_SHADER_IDENTIFIER_SIZE_INVALID : D3D12_MESSAGE_ID = 1199 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CHECK_DRIVER_MATCHING_IDENTIFIER_INVALID : D3D12_MESSAGE_ID = 1200 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CHECK_DRIVER_MATCHING_IDENTIFIER_DRIVER_REPORTED_ISSUE : D3D12_MESSAGE_ID = 1201 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_INVALID_RESOURCE_BARRIER : D3D12_MESSAGE_ID = 1202 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_DISALLOWED_API_CALLED : D3D12_MESSAGE_ID = 1203 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_NEST_RENDER_PASSES : D3D12_MESSAGE_ID = 1204 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_END_WITHOUT_BEGIN : D3D12_MESSAGE_ID = 1205 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_CLOSE_COMMAND_LIST : D3D12_MESSAGE_ID = 1206 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_GPU_WORK_WHILE_SUSPENDED : D3D12_MESSAGE_ID = 1207 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_SUSPEND_RESUME : D3D12_MESSAGE_ID = 1208 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_NO_PRIOR_SUSPEND_WITHIN_EXECUTECOMMANDLISTS : D3D12_MESSAGE_ID = 1209 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_NO_SUBSEQUENT_RESUME_WITHIN_EXECUTECOMMANDLISTS : D3D12_MESSAGE_ID = 1210 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_TRACKED_WORKLOAD_COMMAND_QUEUE_MISMATCH : D3D12_MESSAGE_ID = 1211 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_TRACKED_WORKLOAD_NOT_SUPPORTED:
    D3D12_MESSAGE_ID = 1212;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_NO_ACCESS : D3D12_MESSAGE_ID = 1213 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RENDER_PASS_UNSUPPORTED_RESOLVE:
    D3D12_MESSAGE_ID = 1214;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_INVALID_RESOURCE_PTR : D3D12_MESSAGE_ID = 1215 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WINDOWS7_FENCE_OUTOFORDER_SIGNAL:
    D3D12_MESSAGE_ID = 1216;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WINDOWS7_FENCE_OUTOFORDER_WAIT:
    D3D12_MESSAGE_ID = 1217;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_CREATE_MOTION_ESTIMATOR_INVALID_ARGUMENT : D3D12_MESSAGE_ID = 1218 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_CREATE_MOTION_VECTOR_HEAP_INVALID_ARGUMENT : D3D12_MESSAGE_ID = 1219 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ESTIMATE_MOTION_INVALID_ARGUMENT:
    D3D12_MESSAGE_ID = 1220;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVE_MOTION_VECTOR_HEAP_INVALID_ARGUMENT : D3D12_MESSAGE_ID = 1221 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_HEAP_TYPE : D3D12_MESSAGE_ID = 1222 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SET_BACKGROUND_PROCESSING_MODE_INVALID_ARGUMENT : D3D12_MESSAGE_ID = 1223 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_INVALID_COMMAND_LIST_TYPE_FOR_FEATURE_LEVEL : D3D12_MESSAGE_ID = 1224 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOEXTENSIONCOMMAND:
    D3D12_MESSAGE_ID = 1225;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOEXTENSIONCOMMAND:
    D3D12_MESSAGE_ID = 1226;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOEXTENSIONCOMMAND:
    D3D12_MESSAGE_ID = 1227;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_INVALID_VIDEO_EXTENSION_COMMAND_ID : D3D12_MESSAGE_ID = 1228 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VIDEO_EXTENSION_COMMAND_INVALID_ARGUMENT : D3D12_MESSAGE_ID = 1229 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_UNIQUE_IN_DXIL_LIBRARY : D3D12_MESSAGE_ID = 1230 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VARIABLE_SHADING_RATE_NOT_ALLOWED_WITH_TIR : D3D12_MESSAGE_ID = 1231 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_GEOMETRY_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE : D3D12_MESSAGE_ID = 1232 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RSSETSHADING_RATE_INVALID_SHADING_RATE : D3D12_MESSAGE_ID = 1233 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RSSETSHADING_RATE_SHADING_RATE_NOT_PERMITTED_BY_CAP : D3D12_MESSAGE_ID = 1234 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RSSETSHADING_RATE_INVALID_COMBINER : D3D12_MESSAGE_ID = 1235 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RSSETSHADINGRATEIMAGE_REQUIRES_TIER_2 : D3D12_MESSAGE_ID = 1236 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RSSETSHADINGRATE_REQUIRES_TIER_1:
    D3D12_MESSAGE_ID = 1237;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_FORMAT : D3D12_MESSAGE_ID = 1238 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_ARRAY_SIZE : D3D12_MESSAGE_ID = 1239 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_MIP_LEVEL : D3D12_MESSAGE_ID = 1240 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_SAMPLE_COUNT : D3D12_MESSAGE_ID = 1241 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_SAMPLE_QUALITY : D3D12_MESSAGE_ID = 1242 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_NON_RETAIL_SHADER_MODEL_WONT_VALIDATE : D3D12_MESSAGE_ID = 1243 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_AS_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 1244 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_ROOT_SIGNATURE_MISMATCH : D3D12_MESSAGE_ID = 1245 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ADD_TO_STATE_OBJECT_ERROR:
    D3D12_MESSAGE_ID = 1246;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_PROTECTED_RESOURCE_SESSION_INVALID_ARGUMENT : D3D12_MESSAGE_ID = 1247 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_PSO_DESC_MISMATCH : D3D12_MESSAGE_ID = 1248 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEPIPELINESTATE_MS_INCOMPLETE_TYPE : D3D12_MESSAGE_ID = 1249 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_AS_NOT_MS_MISMATCH : D3D12_MESSAGE_ID = 1250 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_NOT_PS_MISMATCH : D3D12_MESSAGE_ID = 1251 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_NONZERO_SAMPLER_FEEDBACK_MIP_REGION_WITH_INCOMPATIBLE_FORMAT : D3D12_MESSAGE_ID = 1252 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_SHADER_MISMATCH : D3D12_MESSAGE_ID = 1253 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_EMPTY_DISPATCH: D3D12_MESSAGE_ID =
    1254;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOURCE_FORMAT_REQUIRES_SAMPLER_FEEDBACK_CAPABILITY : D3D12_MESSAGE_ID = 1255 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_MIP_REGION : D3D12_MESSAGE_ID = 1256 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_DIMENSION : D3D12_MESSAGE_ID = 1257 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_SAMPLE_COUNT : D3D12_MESSAGE_ID = 1258 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_SAMPLE_QUALITY : D3D12_MESSAGE_ID = 1259 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_LAYOUT : D3D12_MESSAGE_ID = 1260 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_REQUIRES_UNORDERED_ACCESS_FLAG : D3D12_MESSAGE_ID = 1261 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_NULL_ARGUMENTS : D3D12_MESSAGE_ID = 1262 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_UAV_REQUIRES_SAMPLER_FEEDBACK_CAPABILITY : D3D12_MESSAGE_ID = 1263 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_REQUIRES_FEEDBACK_MAP_FORMAT : D3D12_MESSAGE_ID = 1264 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEMESHSHADER_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 1265 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEMESHSHADER_OUTOFMEMORY:
    D3D12_MESSAGE_ID = 1266;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEMESHSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE : D3D12_MESSAGE_ID = 1267 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_TRANSCODE_INVALID_FORMAT : D3D12_MESSAGE_ID = 1268 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_INVALID_MIP_LEVEL_COUNT : D3D12_MESSAGE_ID = 1269 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_TRANSCODE_ARRAY_SIZE_MISMATCH : D3D12_MESSAGE_ID = 1270 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_MISMATCHING_TARGETED_RESOURCE : D3D12_MESSAGE_ID = 1271 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEMESHSHADER_OUTPUTEXCEEDSMAXSIZE : D3D12_MESSAGE_ID = 1272 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEMESHSHADER_GROUPSHAREDEXCEEDSMAXSIZE : D3D12_MESSAGE_ID = 1273 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_VERTEX_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE : D3D12_MESSAGE_ID = 1274 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_MESH_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE : D3D12_MESSAGE_ID = 1275 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEMESHSHADER_MISMATCHEDASMSPAYLOADSIZE : D3D12_MESSAGE_ID = 1276 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_UNBOUNDED_STATIC_DESCRIPTORS : D3D12_MESSAGE_ID = 1277 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEAMPLIFICATIONSHADER_INVALIDSHADERBYTECODE : D3D12_MESSAGE_ID = 1278 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEAMPLIFICATIONSHADER_OUTOFMEMORY : D3D12_MESSAGE_ID = 1279 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_SHADERCACHESESSION:
    D3D12_MESSAGE_ID = 1280;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_SHADERCACHESESSION:
    D3D12_MESSAGE_ID = 1281;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_SHADERCACHESESSION:
    D3D12_MESSAGE_ID = 1282;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_INVALIDARGS : D3D12_MESSAGE_ID = 1283 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_DISABLED : D3D12_MESSAGE_ID = 1284 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_ALREADYOPEN : D3D12_MESSAGE_ID = 1285 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHECONTROL_DEVELOPERMODE:
    D3D12_MESSAGE_ID = 1286;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHECONTROL_INVALIDFLAGS:
    D3D12_MESSAGE_ID = 1287;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHECONTROL_STATEALREADYSET : D3D12_MESSAGE_ID = 1288 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHECONTROL_IGNOREDFLAG:
    D3D12_MESSAGE_ID = 1289;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_ALREADYPRESENT : D3D12_MESSAGE_ID = 1290 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_HASHCOLLISION : D3D12_MESSAGE_ID = 1291 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_CACHEFULL : D3D12_MESSAGE_ID = 1292 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHESESSION_FINDVALUE_NOTFOUND : D3D12_MESSAGE_ID = 1293 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHESESSION_CORRUPT:
    D3D12_MESSAGE_ID = 1294;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SHADERCACHESESSION_DISABLED:
    D3D12_MESSAGE_ID = 1295;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_OVERSIZED_DISPATCH:
    D3D12_MESSAGE_ID = 1296;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOENCODER:
    D3D12_MESSAGE_ID = 1297;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOENCODER:
    D3D12_MESSAGE_ID = 1298;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOENCODER:
    D3D12_MESSAGE_ID = 1299;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEOENCODERHEAP:
    D3D12_MESSAGE_ID = 1300;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_LIVE_VIDEOENCODERHEAP:
    D3D12_MESSAGE_ID = 1301;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESTROY_VIDEOENCODERHEAP:
    D3D12_MESSAGE_ID = 1302;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYTEXTUREREGION_MISMATCH_ENCODE_REFERENCE_ONLY_FLAG : D3D12_MESSAGE_ID = 1303 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_COPYRESOURCE_MISMATCH_ENCODE_REFERENCE_ONLY_FLAG : D3D12_MESSAGE_ID = 1304 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ENCODE_FRAME_INVALID_PARAMETERS:
    D3D12_MESSAGE_ID = 1305;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_ENCODE_FRAME_UNSUPPORTED_PARAMETERS : D3D12_MESSAGE_ID = 1306 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVE_ENCODER_OUTPUT_METADATA_INVALID_PARAMETERS : D3D12_MESSAGE_ID = 1307 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVE_ENCODER_OUTPUT_METADATA_UNSUPPORTED_PARAMETERS : D3D12_MESSAGE_ID = 1308 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_INVALID_PARAMETERS : D3D12_MESSAGE_ID = 1309 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_UNSUPPORTED_PARAMETERS : D3D12_MESSAGE_ID = 1310 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_HEAP_INVALID_PARAMETERS : D3D12_MESSAGE_ID = 1311 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_HEAP_UNSUPPORTED_PARAMETERS : D3D12_MESSAGE_ID = 1312 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATECOMMANDLIST_NULL_COMMANDALLOCATOR : D3D12_MESSAGE_ID = 1313 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CLEAR_UNORDERED_ACCESS_VIEW_INVALID_DESCRIPTOR_HANDLE : D3D12_MESSAGE_ID = 1314 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_DESCRIPTOR_HEAP_NOT_SHADER_VISIBLE : D3D12_MESSAGE_ID = 1315 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_BLENDOP_WARNING:
    D3D12_MESSAGE_ID = 1316;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_CREATEBLENDSTATE_BLENDOPALPHA_WARNING : D3D12_MESSAGE_ID = 1317 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_WRITE_COMBINE_PERFORMANCE_WARNING : D3D12_MESSAGE_ID = 1318 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_RESOLVE_QUERY_INVALID_QUERY_STATE : D3D12_MESSAGE_ID = 1319 ;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_SETPRIVATEDATA_NO_ACCESS:
    D3D12_MESSAGE_ID = 1320;
pub const D3D12_MESSAGE_ID_D3D12_MESSAGE_ID_D3D12_MESSAGES_END:
    D3D12_MESSAGE_ID = 1321;
pub type D3D12_MESSAGE_ID = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_MESSAGE {
    pub Category: D3D12_MESSAGE_CATEGORY,
    pub Severity: D3D12_MESSAGE_SEVERITY,
    pub ID: D3D12_MESSAGE_ID,
    pub pDescription: *const ::std::os::raw::c_char,
    pub DescriptionByteLength: SIZE_T,
}
impl Default for D3D12_MESSAGE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INFO_QUEUE_FILTER_DESC {
    pub NumCategories: UINT,
    pub pCategoryList: *mut D3D12_MESSAGE_CATEGORY,
    pub NumSeverities: UINT,
    pub pSeverityList: *mut D3D12_MESSAGE_SEVERITY,
    pub NumIDs: UINT,
    pub pIDList: *mut D3D12_MESSAGE_ID,
}
impl Default for D3D12_INFO_QUEUE_FILTER_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_INFO_QUEUE_FILTER {
    pub AllowList: D3D12_INFO_QUEUE_FILTER_DESC,
    pub DenyList: D3D12_INFO_QUEUE_FILTER_DESC,
}
impl Default for D3D12_INFO_QUEUE_FILTER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12InfoQueue: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12InfoQueueVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> ULONG,
    >,
    pub SetMessageCountLimit: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            MessageCountLimit: UINT64,
        ) -> HRESULT,
    >,
    pub ClearStoredMessages:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12InfoQueue)>,
    pub GetMessageA: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            MessageIndex: UINT64,
            pMessage: *mut D3D12_MESSAGE,
            pMessageByteLength: *mut SIZE_T,
        ) -> HRESULT,
    >,
    pub GetNumMessagesAllowedByStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> UINT64,
    >,
    pub GetNumMessagesDeniedByStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> UINT64,
    >,
    pub GetNumStoredMessages: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> UINT64,
    >,
    pub GetNumStoredMessagesAllowedByRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> UINT64,
    >,
    pub GetNumMessagesDiscardedByMessageCountLimit: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> UINT64,
    >,
    pub GetMessageCountLimit: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> UINT64,
    >,
    pub AddStorageFilterEntries: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        ) -> HRESULT,
    >,
    pub GetStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
            pFilterByteLength: *mut SIZE_T,
        ) -> HRESULT,
    >,
    pub ClearStorageFilter:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12InfoQueue)>,
    pub PushEmptyStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> HRESULT,
    >,
    pub PushCopyOfStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> HRESULT,
    >,
    pub PushStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        ) -> HRESULT,
    >,
    pub PopStorageFilter:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12InfoQueue)>,
    pub GetStorageFilterStackSize: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> UINT,
    >,
    pub AddRetrievalFilterEntries: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        ) -> HRESULT,
    >,
    pub GetRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
            pFilterByteLength: *mut SIZE_T,
        ) -> HRESULT,
    >,
    pub ClearRetrievalFilter:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12InfoQueue)>,
    pub PushEmptyRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> HRESULT,
    >,
    pub PushCopyOfRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> HRESULT,
    >,
    pub PushRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        ) -> HRESULT,
    >,
    pub PopRetrievalFilter:
        ::std::option::Option<unsafe extern "C" fn(This: *mut ID3D12InfoQueue)>,
    pub GetRetrievalFilterStackSize: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> UINT,
    >,
    pub AddMessage: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            Category: D3D12_MESSAGE_CATEGORY,
            Severity: D3D12_MESSAGE_SEVERITY,
            ID: D3D12_MESSAGE_ID,
            pDescription: LPCSTR,
        ) -> HRESULT,
    >,
    pub AddApplicationMessage: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            Severity: D3D12_MESSAGE_SEVERITY,
            pDescription: LPCSTR,
        ) -> HRESULT,
    >,
    pub SetBreakOnCategory: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            Category: D3D12_MESSAGE_CATEGORY,
            bEnable: BOOL,
        ) -> HRESULT,
    >,
    pub SetBreakOnSeverity: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            Severity: D3D12_MESSAGE_SEVERITY,
            bEnable: BOOL,
        ) -> HRESULT,
    >,
    pub SetBreakOnID: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            ID: D3D12_MESSAGE_ID,
            bEnable: BOOL,
        ) -> HRESULT,
    >,
    pub GetBreakOnCategory: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            Category: D3D12_MESSAGE_CATEGORY,
        ) -> BOOL,
    >,
    pub GetBreakOnSeverity: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            Severity: D3D12_MESSAGE_SEVERITY,
        ) -> BOOL,
    >,
    pub GetBreakOnID: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue,
            ID: D3D12_MESSAGE_ID,
        ) -> BOOL,
    >,
    pub SetMuteDebugOutput: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue, bMute: BOOL),
    >,
    pub GetMuteDebugOutput: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue) -> BOOL,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12InfoQueue {
    pub lpVtbl: *mut ID3D12InfoQueueVtbl,
}
impl Default for ID3D12InfoQueue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_MESSAGE_CALLBACK_FLAGS_D3D12_MESSAGE_CALLBACK_FLAG_NONE:
    D3D12_MESSAGE_CALLBACK_FLAGS = 0;
pub const D3D12_MESSAGE_CALLBACK_FLAGS_D3D12_MESSAGE_CALLBACK_IGNORE_FILTERS:
    D3D12_MESSAGE_CALLBACK_FLAGS = 1;
pub type D3D12_MESSAGE_CALLBACK_FLAGS = ::std::os::raw::c_int;
pub type D3D12MessageFunc = ::std::option::Option<
    unsafe extern "C" fn(
        Category: D3D12_MESSAGE_CATEGORY,
        Severity: D3D12_MESSAGE_SEVERITY,
        ID: D3D12_MESSAGE_ID,
        pDescription: LPCSTR,
        pContext: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    pub static IID_ID3D12InfoQueue1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12InfoQueue1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> ULONG,
    >,
    pub SetMessageCountLimit: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            MessageCountLimit: UINT64,
        ) -> HRESULT,
    >,
    pub ClearStoredMessages: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1),
    >,
    pub GetMessageA: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            MessageIndex: UINT64,
            pMessage: *mut D3D12_MESSAGE,
            pMessageByteLength: *mut SIZE_T,
        ) -> HRESULT,
    >,
    pub GetNumMessagesAllowedByStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> UINT64,
    >,
    pub GetNumMessagesDeniedByStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> UINT64,
    >,
    pub GetNumStoredMessages: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> UINT64,
    >,
    pub GetNumStoredMessagesAllowedByRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> UINT64,
    >,
    pub GetNumMessagesDiscardedByMessageCountLimit: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> UINT64,
    >,
    pub GetMessageCountLimit: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> UINT64,
    >,
    pub AddStorageFilterEntries: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        ) -> HRESULT,
    >,
    pub GetStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
            pFilterByteLength: *mut SIZE_T,
        ) -> HRESULT,
    >,
    pub ClearStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1),
    >,
    pub PushEmptyStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> HRESULT,
    >,
    pub PushCopyOfStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> HRESULT,
    >,
    pub PushStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        ) -> HRESULT,
    >,
    pub PopStorageFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1),
    >,
    pub GetStorageFilterStackSize: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> UINT,
    >,
    pub AddRetrievalFilterEntries: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        ) -> HRESULT,
    >,
    pub GetRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
            pFilterByteLength: *mut SIZE_T,
        ) -> HRESULT,
    >,
    pub ClearRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1),
    >,
    pub PushEmptyRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> HRESULT,
    >,
    pub PushCopyOfRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> HRESULT,
    >,
    pub PushRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        ) -> HRESULT,
    >,
    pub PopRetrievalFilter: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1),
    >,
    pub GetRetrievalFilterStackSize: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> UINT,
    >,
    pub AddMessage: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            Category: D3D12_MESSAGE_CATEGORY,
            Severity: D3D12_MESSAGE_SEVERITY,
            ID: D3D12_MESSAGE_ID,
            pDescription: LPCSTR,
        ) -> HRESULT,
    >,
    pub AddApplicationMessage: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            Severity: D3D12_MESSAGE_SEVERITY,
            pDescription: LPCSTR,
        ) -> HRESULT,
    >,
    pub SetBreakOnCategory: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            Category: D3D12_MESSAGE_CATEGORY,
            bEnable: BOOL,
        ) -> HRESULT,
    >,
    pub SetBreakOnSeverity: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            Severity: D3D12_MESSAGE_SEVERITY,
            bEnable: BOOL,
        ) -> HRESULT,
    >,
    pub SetBreakOnID: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            ID: D3D12_MESSAGE_ID,
            bEnable: BOOL,
        ) -> HRESULT,
    >,
    pub GetBreakOnCategory: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            Category: D3D12_MESSAGE_CATEGORY,
        ) -> BOOL,
    >,
    pub GetBreakOnSeverity: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            Severity: D3D12_MESSAGE_SEVERITY,
        ) -> BOOL,
    >,
    pub GetBreakOnID: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            ID: D3D12_MESSAGE_ID,
        ) -> BOOL,
    >,
    pub SetMuteDebugOutput: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1, bMute: BOOL),
    >,
    pub GetMuteDebugOutput: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12InfoQueue1) -> BOOL,
    >,
    pub RegisterMessageCallback: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            CallbackFunc: D3D12MessageFunc,
            CallbackFilterFlags: D3D12_MESSAGE_CALLBACK_FLAGS,
            pContext: *mut ::std::os::raw::c_void,
            pCallbackCookie: *mut DWORD,
        ) -> HRESULT,
    >,
    pub UnregisterMessageCallback: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12InfoQueue1,
            CallbackCookie: DWORD,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12InfoQueue1 {
    pub lpVtbl: *mut ID3D12InfoQueue1Vtbl,
}
impl Default for ID3D12InfoQueue1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = ""]
pub type PFN_D3D12_CREATE_DEVICE = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut IUnknown,
        arg2: D3D_FEATURE_LEVEL,
        arg3: *const IID,
        arg4: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT,
>;
extern "C" {
    pub fn D3D12CreateDevice(
        pAdapter: *mut IUnknown,
        MinimumFeatureLevel: D3D_FEATURE_LEVEL,
        riid: *const IID,
        ppDevice: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT;
}
pub type PFN_D3D12_GET_DEBUG_INTERFACE = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const IID,
        arg2: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT,
>;
extern "C" {
    pub fn D3D12GetDebugInterface(
        riid: *const IID,
        ppvDebug: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT;
}
extern "C" {
    pub fn D3D12EnableExperimentalFeatures(
        NumFeatures: UINT,
        pIIDs: *const IID,
        pConfigurationStructs: *mut ::std::os::raw::c_void,
        pConfigurationStructSizes: *mut UINT,
    ) -> HRESULT;
}
extern "C" {
    pub static D3D12ExperimentalShaderModels: UUID;
}
extern "C" {
    pub static D3D12TiledResourceTier4: UUID;
}
extern "C" {
    pub static D3D12MetaCommand: UUID;
}
extern "C" {
    pub static CLSID_D3D12Debug: GUID;
}
extern "C" {
    pub static CLSID_D3D12Tools: GUID;
}
extern "C" {
    pub static CLSID_D3D12DeviceRemovedExtendedData: GUID;
}
extern "C" {
    pub static CLSID_D3D12SDKConfiguration: GUID;
}
pub type PFN_D3D12_GET_INTERFACE = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const IID,
        arg2: *const IID,
        arg3: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT,
>;
extern "C" {
    pub fn D3D12GetInterface(
        rclsid: *const IID,
        riid: *const IID,
        ppvDebug: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT;
}
extern "C" {
    pub static IID_ID3D12SDKConfiguration: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12SDKConfigurationVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SDKConfiguration,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12SDKConfiguration) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut ID3D12SDKConfiguration) -> ULONG,
    >,
    pub SetSDKVersion: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut ID3D12SDKConfiguration,
            SDKVersion: UINT,
            SDKPath: LPCSTR,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12SDKConfiguration {
    pub lpVtbl: *mut ID3D12SDKConfigurationVtbl,
}
impl Default for ID3D12SDKConfiguration {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const D3D12_AXIS_SHADING_RATE_D3D12_AXIS_SHADING_RATE_1X:
    D3D12_AXIS_SHADING_RATE = 0;
pub const D3D12_AXIS_SHADING_RATE_D3D12_AXIS_SHADING_RATE_2X:
    D3D12_AXIS_SHADING_RATE = 1;
pub const D3D12_AXIS_SHADING_RATE_D3D12_AXIS_SHADING_RATE_4X:
    D3D12_AXIS_SHADING_RATE = 2;
pub type D3D12_AXIS_SHADING_RATE = ::std::os::raw::c_int;
pub const D3D12_SHADING_RATE_D3D12_SHADING_RATE_1X1: D3D12_SHADING_RATE = 0;
pub const D3D12_SHADING_RATE_D3D12_SHADING_RATE_1X2: D3D12_SHADING_RATE = 1;
pub const D3D12_SHADING_RATE_D3D12_SHADING_RATE_2X1: D3D12_SHADING_RATE = 4;
pub const D3D12_SHADING_RATE_D3D12_SHADING_RATE_2X2: D3D12_SHADING_RATE = 5;
pub const D3D12_SHADING_RATE_D3D12_SHADING_RATE_2X4: D3D12_SHADING_RATE = 6;
pub const D3D12_SHADING_RATE_D3D12_SHADING_RATE_4X2: D3D12_SHADING_RATE = 9;
pub const D3D12_SHADING_RATE_D3D12_SHADING_RATE_4X4: D3D12_SHADING_RATE = 10;
pub type D3D12_SHADING_RATE = ::std::os::raw::c_int;
pub const D3D12_SHADING_RATE_COMBINER_D3D12_SHADING_RATE_COMBINER_PASSTHROUGH : D3D12_SHADING_RATE_COMBINER = 0 ;
pub const D3D12_SHADING_RATE_COMBINER_D3D12_SHADING_RATE_COMBINER_OVERRIDE:
    D3D12_SHADING_RATE_COMBINER = 1;
pub const D3D12_SHADING_RATE_COMBINER_D3D12_SHADING_RATE_COMBINER_MIN:
    D3D12_SHADING_RATE_COMBINER = 2;
pub const D3D12_SHADING_RATE_COMBINER_D3D12_SHADING_RATE_COMBINER_MAX:
    D3D12_SHADING_RATE_COMBINER = 3;
pub const D3D12_SHADING_RATE_COMBINER_D3D12_SHADING_RATE_COMBINER_SUM:
    D3D12_SHADING_RATE_COMBINER = 4;
pub type D3D12_SHADING_RATE_COMBINER = ::std::os::raw::c_int;
extern "C" {
    pub static IID_ID3D12GraphicsCommandList5: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList5Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , Name : LPCWSTR) -> HRESULT > , pub GetDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , riid : * const IID , ppvDevice : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetType : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5) -> D3D12_COMMAND_LIST_TYPE > , pub Close : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5) -> HRESULT > , pub Reset : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState) -> HRESULT > , pub ClearState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pPipelineState : * mut ID3D12PipelineState) > , pub DrawInstanced : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , VertexCountPerInstance : UINT , InstanceCount : UINT , StartVertexLocation : UINT , StartInstanceLocation : UINT) > , pub DrawIndexedInstanced : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , IndexCountPerInstance : UINT , InstanceCount : UINT , StartIndexLocation : UINT , BaseVertexLocation : INT , StartInstanceLocation : UINT) > , pub Dispatch : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , ThreadGroupCountX : UINT , ThreadGroupCountY : UINT , ThreadGroupCountZ : UINT) > , pub CopyBufferRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , NumBytes : UINT64) > , pub CopyTextureRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDst : * const D3D12_TEXTURE_COPY_LOCATION , DstX : UINT , DstY : UINT , DstZ : UINT , pSrc : * const D3D12_TEXTURE_COPY_LOCATION , pSrcBox : * const D3D12_BOX) > , pub CopyResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDstResource : * mut ID3D12Resource , pSrcResource : * mut ID3D12Resource) > , pub CopyTiles : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pTiledResource : * mut ID3D12Resource , pTileRegionStartCoordinate : * const D3D12_TILED_RESOURCE_COORDINATE , pTileRegionSize : * const D3D12_TILE_REGION_SIZE , pBuffer : * mut ID3D12Resource , BufferStartOffsetInBytes : UINT64 , Flags : D3D12_TILE_COPY_FLAGS) > , pub ResolveSubresource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDstResource : * mut ID3D12Resource , DstSubresource : UINT , pSrcResource : * mut ID3D12Resource , SrcSubresource : UINT , Format : DXGI_FORMAT) > , pub IASetPrimitiveTopology : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , PrimitiveTopology : D3D12_PRIMITIVE_TOPOLOGY) > , pub RSSetViewports : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , NumViewports : UINT , pViewports : * const D3D12_VIEWPORT) > , pub RSSetScissorRects : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , NumRects : UINT , pRects : * const D3D12_RECT) > , pub OMSetBlendFactor : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , BlendFactor : * const FLOAT) > , pub OMSetStencilRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , StencilRef : UINT) > , pub SetPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pPipelineState : * mut ID3D12PipelineState) > , pub ResourceBarrier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , NumBarriers : UINT , pBarriers : * const D3D12_RESOURCE_BARRIER) > , pub ExecuteBundle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pCommandList : * mut ID3D12GraphicsCommandList) > , pub SetDescriptorHeaps : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , NumDescriptorHeaps : UINT , ppDescriptorHeaps : * const * mut ID3D12DescriptorHeap) > , pub SetComputeRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pRootSignature : * mut ID3D12RootSignature) > , pub SetGraphicsRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pRootSignature : * mut ID3D12RootSignature) > , pub SetComputeRootDescriptorTable : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , BaseDescriptor : D3D12_GPU_DESCRIPTOR_HANDLE) > , pub SetGraphicsRootDescriptorTable : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , BaseDescriptor : D3D12_GPU_DESCRIPTOR_HANDLE) > , pub SetComputeRoot32BitConstant : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , SrcData : UINT , DestOffsetIn32BitValues : UINT) > , pub SetGraphicsRoot32BitConstant : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , SrcData : UINT , DestOffsetIn32BitValues : UINT) > , pub SetComputeRoot32BitConstants : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , Num32BitValuesToSet : UINT , pSrcData : * const :: std :: os :: raw :: c_void , DestOffsetIn32BitValues : UINT) > , pub SetGraphicsRoot32BitConstants : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , Num32BitValuesToSet : UINT , pSrcData : * const :: std :: os :: raw :: c_void , DestOffsetIn32BitValues : UINT) > , pub SetComputeRootConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetComputeRootShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetComputeRootUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub IASetIndexBuffer : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pView : * const D3D12_INDEX_BUFFER_VIEW) > , pub IASetVertexBuffers : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , StartSlot : UINT , NumViews : UINT , pViews : * const D3D12_VERTEX_BUFFER_VIEW) > , pub SOSetTargets : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , StartSlot : UINT , NumViews : UINT , pViews : * const D3D12_STREAM_OUTPUT_BUFFER_VIEW) > , pub OMSetRenderTargets : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , NumRenderTargetDescriptors : UINT , pRenderTargetDescriptors : * const D3D12_CPU_DESCRIPTOR_HANDLE , RTsSingleHandleToDescriptorRange : BOOL , pDepthStencilDescriptor : * const D3D12_CPU_DESCRIPTOR_HANDLE) > , pub ClearDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , DepthStencilView : D3D12_CPU_DESCRIPTOR_HANDLE , ClearFlags : D3D12_CLEAR_FLAGS , Depth : FLOAT , Stencil : UINT8 , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , RenderTargetView : D3D12_CPU_DESCRIPTOR_HANDLE , ColorRGBA : * const FLOAT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearUnorderedAccessViewUint : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , ViewGPUHandleInCurrentHeap : D3D12_GPU_DESCRIPTOR_HANDLE , ViewCPUHandle : D3D12_CPU_DESCRIPTOR_HANDLE , pResource : * mut ID3D12Resource , Values : * const UINT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearUnorderedAccessViewFloat : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , ViewGPUHandleInCurrentHeap : D3D12_GPU_DESCRIPTOR_HANDLE , ViewCPUHandle : D3D12_CPU_DESCRIPTOR_HANDLE , pResource : * mut ID3D12Resource , Values : * const FLOAT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub DiscardResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pResource : * mut ID3D12Resource , pRegion : * const D3D12_DISCARD_REGION) > , pub BeginQuery : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , Index : UINT) > , pub EndQuery : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , Index : UINT) > , pub ResolveQueryData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , StartIndex : UINT , NumQueries : UINT , pDestinationBuffer : * mut ID3D12Resource , AlignedDestinationBufferOffset : UINT64) > , pub SetPredication : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pBuffer : * mut ID3D12Resource , AlignedBufferOffset : UINT64 , Operation : D3D12_PREDICATION_OP) > , pub SetMarker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub BeginEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub EndEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5) > , pub ExecuteIndirect : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pCommandSignature : * mut ID3D12CommandSignature , MaxCommandCount : UINT , pArgumentBuffer : * mut ID3D12Resource , ArgumentBufferOffset : UINT64 , pCountBuffer : * mut ID3D12Resource , CountBufferOffset : UINT64) > , pub AtomicCopyBufferUINT : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , Dependencies : UINT , ppDependentResources : * const * mut ID3D12Resource , pDependentSubresourceRanges : * const D3D12_SUBRESOURCE_RANGE_UINT64) > , pub AtomicCopyBufferUINT64 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , Dependencies : UINT , ppDependentResources : * const * mut ID3D12Resource , pDependentSubresourceRanges : * const D3D12_SUBRESOURCE_RANGE_UINT64) > , pub OMSetDepthBounds : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , Min : FLOAT , Max : FLOAT) > , pub SetSamplePositions : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , NumSamplesPerPixel : UINT , NumPixels : UINT , pSamplePositions : * mut D3D12_SAMPLE_POSITION) > , pub ResolveSubresourceRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDstResource : * mut ID3D12Resource , DstSubresource : UINT , DstX : UINT , DstY : UINT , pSrcResource : * mut ID3D12Resource , SrcSubresource : UINT , pSrcRect : * mut D3D12_RECT , Format : DXGI_FORMAT , ResolveMode : D3D12_RESOLVE_MODE) > , pub SetViewInstanceMask : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , Mask : UINT) > , pub WriteBufferImmediate : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , Count : UINT , pParams : * const D3D12_WRITEBUFFERIMMEDIATE_PARAMETER , pModes : * const D3D12_WRITEBUFFERIMMEDIATE_MODE) > , pub SetProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pProtectedResourceSession : * mut ID3D12ProtectedResourceSession) > , pub BeginRenderPass : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , NumRenderTargets : UINT , pRenderTargets : * const D3D12_RENDER_PASS_RENDER_TARGET_DESC , pDepthStencil : * const D3D12_RENDER_PASS_DEPTH_STENCIL_DESC , Flags : D3D12_RENDER_PASS_FLAGS) > , pub EndRenderPass : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5) > , pub InitializeMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pMetaCommand : * mut ID3D12MetaCommand , pInitializationParametersData : * const :: std :: os :: raw :: c_void , InitializationParametersDataSizeInBytes : SIZE_T) > , pub ExecuteMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pMetaCommand : * mut ID3D12MetaCommand , pExecutionParametersData : * const :: std :: os :: raw :: c_void , ExecutionParametersDataSizeInBytes : SIZE_T) > , pub BuildRaytracingAccelerationStructure : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC , NumPostbuildInfoDescs : UINT , pPostbuildInfoDescs : * const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC) > , pub EmitRaytracingAccelerationStructurePostbuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDesc : * const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC , NumSourceAccelerationStructures : UINT , pSourceAccelerationStructureData : * const D3D12_GPU_VIRTUAL_ADDRESS) > , pub CopyRaytracingAccelerationStructure : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , DestAccelerationStructureData : D3D12_GPU_VIRTUAL_ADDRESS , SourceAccelerationStructureData : D3D12_GPU_VIRTUAL_ADDRESS , Mode : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE) > , pub SetPipelineState1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pStateObject : * mut ID3D12StateObject) > , pub DispatchRays : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , pDesc : * const D3D12_DISPATCH_RAYS_DESC) > , pub RSSetShadingRate : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , baseShadingRate : D3D12_SHADING_RATE , combiners : * const D3D12_SHADING_RATE_COMBINER) > , pub RSSetShadingRateImage : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList5 , shadingRateImage : * mut ID3D12Resource) > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList5 {
    pub lpVtbl: *mut ID3D12GraphicsCommandList5Vtbl,
}
impl Default for ID3D12GraphicsCommandList5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct D3D12_DISPATCH_MESH_ARGUMENTS {
    pub ThreadGroupCountX: UINT,
    pub ThreadGroupCountY: UINT,
    pub ThreadGroupCountZ: UINT,
}
extern "C" {
    pub static IID_ID3D12GraphicsCommandList6: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList6Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , Name : LPCWSTR) -> HRESULT > , pub GetDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , riid : * const IID , ppvDevice : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetType : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6) -> D3D12_COMMAND_LIST_TYPE > , pub Close : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6) -> HRESULT > , pub Reset : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState) -> HRESULT > , pub ClearState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pPipelineState : * mut ID3D12PipelineState) > , pub DrawInstanced : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , VertexCountPerInstance : UINT , InstanceCount : UINT , StartVertexLocation : UINT , StartInstanceLocation : UINT) > , pub DrawIndexedInstanced : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , IndexCountPerInstance : UINT , InstanceCount : UINT , StartIndexLocation : UINT , BaseVertexLocation : INT , StartInstanceLocation : UINT) > , pub Dispatch : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , ThreadGroupCountX : UINT , ThreadGroupCountY : UINT , ThreadGroupCountZ : UINT) > , pub CopyBufferRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , NumBytes : UINT64) > , pub CopyTextureRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDst : * const D3D12_TEXTURE_COPY_LOCATION , DstX : UINT , DstY : UINT , DstZ : UINT , pSrc : * const D3D12_TEXTURE_COPY_LOCATION , pSrcBox : * const D3D12_BOX) > , pub CopyResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDstResource : * mut ID3D12Resource , pSrcResource : * mut ID3D12Resource) > , pub CopyTiles : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pTiledResource : * mut ID3D12Resource , pTileRegionStartCoordinate : * const D3D12_TILED_RESOURCE_COORDINATE , pTileRegionSize : * const D3D12_TILE_REGION_SIZE , pBuffer : * mut ID3D12Resource , BufferStartOffsetInBytes : UINT64 , Flags : D3D12_TILE_COPY_FLAGS) > , pub ResolveSubresource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDstResource : * mut ID3D12Resource , DstSubresource : UINT , pSrcResource : * mut ID3D12Resource , SrcSubresource : UINT , Format : DXGI_FORMAT) > , pub IASetPrimitiveTopology : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , PrimitiveTopology : D3D12_PRIMITIVE_TOPOLOGY) > , pub RSSetViewports : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , NumViewports : UINT , pViewports : * const D3D12_VIEWPORT) > , pub RSSetScissorRects : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , NumRects : UINT , pRects : * const D3D12_RECT) > , pub OMSetBlendFactor : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , BlendFactor : * const FLOAT) > , pub OMSetStencilRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , StencilRef : UINT) > , pub SetPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pPipelineState : * mut ID3D12PipelineState) > , pub ResourceBarrier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , NumBarriers : UINT , pBarriers : * const D3D12_RESOURCE_BARRIER) > , pub ExecuteBundle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pCommandList : * mut ID3D12GraphicsCommandList) > , pub SetDescriptorHeaps : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , NumDescriptorHeaps : UINT , ppDescriptorHeaps : * const * mut ID3D12DescriptorHeap) > , pub SetComputeRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pRootSignature : * mut ID3D12RootSignature) > , pub SetGraphicsRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pRootSignature : * mut ID3D12RootSignature) > , pub SetComputeRootDescriptorTable : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , BaseDescriptor : D3D12_GPU_DESCRIPTOR_HANDLE) > , pub SetGraphicsRootDescriptorTable : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , BaseDescriptor : D3D12_GPU_DESCRIPTOR_HANDLE) > , pub SetComputeRoot32BitConstant : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , SrcData : UINT , DestOffsetIn32BitValues : UINT) > , pub SetGraphicsRoot32BitConstant : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , SrcData : UINT , DestOffsetIn32BitValues : UINT) > , pub SetComputeRoot32BitConstants : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , Num32BitValuesToSet : UINT , pSrcData : * const :: std :: os :: raw :: c_void , DestOffsetIn32BitValues : UINT) > , pub SetGraphicsRoot32BitConstants : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , Num32BitValuesToSet : UINT , pSrcData : * const :: std :: os :: raw :: c_void , DestOffsetIn32BitValues : UINT) > , pub SetComputeRootConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetComputeRootShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetComputeRootUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub IASetIndexBuffer : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pView : * const D3D12_INDEX_BUFFER_VIEW) > , pub IASetVertexBuffers : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , StartSlot : UINT , NumViews : UINT , pViews : * const D3D12_VERTEX_BUFFER_VIEW) > , pub SOSetTargets : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , StartSlot : UINT , NumViews : UINT , pViews : * const D3D12_STREAM_OUTPUT_BUFFER_VIEW) > , pub OMSetRenderTargets : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , NumRenderTargetDescriptors : UINT , pRenderTargetDescriptors : * const D3D12_CPU_DESCRIPTOR_HANDLE , RTsSingleHandleToDescriptorRange : BOOL , pDepthStencilDescriptor : * const D3D12_CPU_DESCRIPTOR_HANDLE) > , pub ClearDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , DepthStencilView : D3D12_CPU_DESCRIPTOR_HANDLE , ClearFlags : D3D12_CLEAR_FLAGS , Depth : FLOAT , Stencil : UINT8 , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , RenderTargetView : D3D12_CPU_DESCRIPTOR_HANDLE , ColorRGBA : * const FLOAT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearUnorderedAccessViewUint : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , ViewGPUHandleInCurrentHeap : D3D12_GPU_DESCRIPTOR_HANDLE , ViewCPUHandle : D3D12_CPU_DESCRIPTOR_HANDLE , pResource : * mut ID3D12Resource , Values : * const UINT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearUnorderedAccessViewFloat : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , ViewGPUHandleInCurrentHeap : D3D12_GPU_DESCRIPTOR_HANDLE , ViewCPUHandle : D3D12_CPU_DESCRIPTOR_HANDLE , pResource : * mut ID3D12Resource , Values : * const FLOAT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub DiscardResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pResource : * mut ID3D12Resource , pRegion : * const D3D12_DISCARD_REGION) > , pub BeginQuery : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , Index : UINT) > , pub EndQuery : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , Index : UINT) > , pub ResolveQueryData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , StartIndex : UINT , NumQueries : UINT , pDestinationBuffer : * mut ID3D12Resource , AlignedDestinationBufferOffset : UINT64) > , pub SetPredication : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pBuffer : * mut ID3D12Resource , AlignedBufferOffset : UINT64 , Operation : D3D12_PREDICATION_OP) > , pub SetMarker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub BeginEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub EndEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6) > , pub ExecuteIndirect : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pCommandSignature : * mut ID3D12CommandSignature , MaxCommandCount : UINT , pArgumentBuffer : * mut ID3D12Resource , ArgumentBufferOffset : UINT64 , pCountBuffer : * mut ID3D12Resource , CountBufferOffset : UINT64) > , pub AtomicCopyBufferUINT : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , Dependencies : UINT , ppDependentResources : * const * mut ID3D12Resource , pDependentSubresourceRanges : * const D3D12_SUBRESOURCE_RANGE_UINT64) > , pub AtomicCopyBufferUINT64 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , Dependencies : UINT , ppDependentResources : * const * mut ID3D12Resource , pDependentSubresourceRanges : * const D3D12_SUBRESOURCE_RANGE_UINT64) > , pub OMSetDepthBounds : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , Min : FLOAT , Max : FLOAT) > , pub SetSamplePositions : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , NumSamplesPerPixel : UINT , NumPixels : UINT , pSamplePositions : * mut D3D12_SAMPLE_POSITION) > , pub ResolveSubresourceRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDstResource : * mut ID3D12Resource , DstSubresource : UINT , DstX : UINT , DstY : UINT , pSrcResource : * mut ID3D12Resource , SrcSubresource : UINT , pSrcRect : * mut D3D12_RECT , Format : DXGI_FORMAT , ResolveMode : D3D12_RESOLVE_MODE) > , pub SetViewInstanceMask : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , Mask : UINT) > , pub WriteBufferImmediate : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , Count : UINT , pParams : * const D3D12_WRITEBUFFERIMMEDIATE_PARAMETER , pModes : * const D3D12_WRITEBUFFERIMMEDIATE_MODE) > , pub SetProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pProtectedResourceSession : * mut ID3D12ProtectedResourceSession) > , pub BeginRenderPass : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , NumRenderTargets : UINT , pRenderTargets : * const D3D12_RENDER_PASS_RENDER_TARGET_DESC , pDepthStencil : * const D3D12_RENDER_PASS_DEPTH_STENCIL_DESC , Flags : D3D12_RENDER_PASS_FLAGS) > , pub EndRenderPass : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6) > , pub InitializeMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pMetaCommand : * mut ID3D12MetaCommand , pInitializationParametersData : * const :: std :: os :: raw :: c_void , InitializationParametersDataSizeInBytes : SIZE_T) > , pub ExecuteMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pMetaCommand : * mut ID3D12MetaCommand , pExecutionParametersData : * const :: std :: os :: raw :: c_void , ExecutionParametersDataSizeInBytes : SIZE_T) > , pub BuildRaytracingAccelerationStructure : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC , NumPostbuildInfoDescs : UINT , pPostbuildInfoDescs : * const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC) > , pub EmitRaytracingAccelerationStructurePostbuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDesc : * const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC , NumSourceAccelerationStructures : UINT , pSourceAccelerationStructureData : * const D3D12_GPU_VIRTUAL_ADDRESS) > , pub CopyRaytracingAccelerationStructure : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , DestAccelerationStructureData : D3D12_GPU_VIRTUAL_ADDRESS , SourceAccelerationStructureData : D3D12_GPU_VIRTUAL_ADDRESS , Mode : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE) > , pub SetPipelineState1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pStateObject : * mut ID3D12StateObject) > , pub DispatchRays : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , pDesc : * const D3D12_DISPATCH_RAYS_DESC) > , pub RSSetShadingRate : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , baseShadingRate : D3D12_SHADING_RATE , combiners : * const D3D12_SHADING_RATE_COMBINER) > , pub RSSetShadingRateImage : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , shadingRateImage : * mut ID3D12Resource) > , pub DispatchMesh : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList6 , ThreadGroupCountX : UINT , ThreadGroupCountY : UINT , ThreadGroupCountZ : UINT) > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList6 {
    pub lpVtbl: *mut ID3D12GraphicsCommandList6Vtbl,
}
impl Default for ID3D12GraphicsCommandList6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_ID3D12GraphicsCommandList7: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList7Vtbl { pub QueryInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , riid : * const IID , ppvObject : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub AddRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7) -> ULONG > , pub Release : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7) -> ULONG > , pub GetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , guid : * const GUID , pDataSize : * mut UINT , pData : * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , guid : * const GUID , DataSize : UINT , pData : * const :: std :: os :: raw :: c_void) -> HRESULT > , pub SetPrivateDataInterface : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , guid : * const GUID , pData : * const IUnknown) -> HRESULT > , pub SetName : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , Name : LPCWSTR) -> HRESULT > , pub GetDevice : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , riid : * const IID , ppvDevice : * mut * mut :: std :: os :: raw :: c_void) -> HRESULT > , pub GetType : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7) -> D3D12_COMMAND_LIST_TYPE > , pub Close : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7) -> HRESULT > , pub Reset : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pAllocator : * mut ID3D12CommandAllocator , pInitialState : * mut ID3D12PipelineState) -> HRESULT > , pub ClearState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pPipelineState : * mut ID3D12PipelineState) > , pub DrawInstanced : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , VertexCountPerInstance : UINT , InstanceCount : UINT , StartVertexLocation : UINT , StartInstanceLocation : UINT) > , pub DrawIndexedInstanced : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , IndexCountPerInstance : UINT , InstanceCount : UINT , StartIndexLocation : UINT , BaseVertexLocation : INT , StartInstanceLocation : UINT) > , pub Dispatch : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , ThreadGroupCountX : UINT , ThreadGroupCountY : UINT , ThreadGroupCountZ : UINT) > , pub CopyBufferRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , NumBytes : UINT64) > , pub CopyTextureRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDst : * const D3D12_TEXTURE_COPY_LOCATION , DstX : UINT , DstY : UINT , DstZ : UINT , pSrc : * const D3D12_TEXTURE_COPY_LOCATION , pSrcBox : * const D3D12_BOX) > , pub CopyResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDstResource : * mut ID3D12Resource , pSrcResource : * mut ID3D12Resource) > , pub CopyTiles : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pTiledResource : * mut ID3D12Resource , pTileRegionStartCoordinate : * const D3D12_TILED_RESOURCE_COORDINATE , pTileRegionSize : * const D3D12_TILE_REGION_SIZE , pBuffer : * mut ID3D12Resource , BufferStartOffsetInBytes : UINT64 , Flags : D3D12_TILE_COPY_FLAGS) > , pub ResolveSubresource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDstResource : * mut ID3D12Resource , DstSubresource : UINT , pSrcResource : * mut ID3D12Resource , SrcSubresource : UINT , Format : DXGI_FORMAT) > , pub IASetPrimitiveTopology : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , PrimitiveTopology : D3D12_PRIMITIVE_TOPOLOGY) > , pub RSSetViewports : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , NumViewports : UINT , pViewports : * const D3D12_VIEWPORT) > , pub RSSetScissorRects : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , NumRects : UINT , pRects : * const D3D12_RECT) > , pub OMSetBlendFactor : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , BlendFactor : * const FLOAT) > , pub OMSetStencilRef : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , StencilRef : UINT) > , pub SetPipelineState : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pPipelineState : * mut ID3D12PipelineState) > , pub ResourceBarrier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , NumBarriers : UINT , pBarriers : * const D3D12_RESOURCE_BARRIER) > , pub ExecuteBundle : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pCommandList : * mut ID3D12GraphicsCommandList) > , pub SetDescriptorHeaps : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , NumDescriptorHeaps : UINT , ppDescriptorHeaps : * const * mut ID3D12DescriptorHeap) > , pub SetComputeRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pRootSignature : * mut ID3D12RootSignature) > , pub SetGraphicsRootSignature : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pRootSignature : * mut ID3D12RootSignature) > , pub SetComputeRootDescriptorTable : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , BaseDescriptor : D3D12_GPU_DESCRIPTOR_HANDLE) > , pub SetGraphicsRootDescriptorTable : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , BaseDescriptor : D3D12_GPU_DESCRIPTOR_HANDLE) > , pub SetComputeRoot32BitConstant : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , SrcData : UINT , DestOffsetIn32BitValues : UINT) > , pub SetGraphicsRoot32BitConstant : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , SrcData : UINT , DestOffsetIn32BitValues : UINT) > , pub SetComputeRoot32BitConstants : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , Num32BitValuesToSet : UINT , pSrcData : * const :: std :: os :: raw :: c_void , DestOffsetIn32BitValues : UINT) > , pub SetGraphicsRoot32BitConstants : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , Num32BitValuesToSet : UINT , pSrcData : * const :: std :: os :: raw :: c_void , DestOffsetIn32BitValues : UINT) > , pub SetComputeRootConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootConstantBufferView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetComputeRootShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootShaderResourceView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetComputeRootUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub SetGraphicsRootUnorderedAccessView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RootParameterIndex : UINT , BufferLocation : D3D12_GPU_VIRTUAL_ADDRESS) > , pub IASetIndexBuffer : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pView : * const D3D12_INDEX_BUFFER_VIEW) > , pub IASetVertexBuffers : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , StartSlot : UINT , NumViews : UINT , pViews : * const D3D12_VERTEX_BUFFER_VIEW) > , pub SOSetTargets : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , StartSlot : UINT , NumViews : UINT , pViews : * const D3D12_STREAM_OUTPUT_BUFFER_VIEW) > , pub OMSetRenderTargets : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , NumRenderTargetDescriptors : UINT , pRenderTargetDescriptors : * const D3D12_CPU_DESCRIPTOR_HANDLE , RTsSingleHandleToDescriptorRange : BOOL , pDepthStencilDescriptor : * const D3D12_CPU_DESCRIPTOR_HANDLE) > , pub ClearDepthStencilView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , DepthStencilView : D3D12_CPU_DESCRIPTOR_HANDLE , ClearFlags : D3D12_CLEAR_FLAGS , Depth : FLOAT , Stencil : UINT8 , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearRenderTargetView : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , RenderTargetView : D3D12_CPU_DESCRIPTOR_HANDLE , ColorRGBA : * const FLOAT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearUnorderedAccessViewUint : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , ViewGPUHandleInCurrentHeap : D3D12_GPU_DESCRIPTOR_HANDLE , ViewCPUHandle : D3D12_CPU_DESCRIPTOR_HANDLE , pResource : * mut ID3D12Resource , Values : * const UINT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub ClearUnorderedAccessViewFloat : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , ViewGPUHandleInCurrentHeap : D3D12_GPU_DESCRIPTOR_HANDLE , ViewCPUHandle : D3D12_CPU_DESCRIPTOR_HANDLE , pResource : * mut ID3D12Resource , Values : * const FLOAT , NumRects : UINT , pRects : * const D3D12_RECT) > , pub DiscardResource : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pResource : * mut ID3D12Resource , pRegion : * const D3D12_DISCARD_REGION) > , pub BeginQuery : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , Index : UINT) > , pub EndQuery : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , Index : UINT) > , pub ResolveQueryData : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pQueryHeap : * mut ID3D12QueryHeap , Type : D3D12_QUERY_TYPE , StartIndex : UINT , NumQueries : UINT , pDestinationBuffer : * mut ID3D12Resource , AlignedDestinationBufferOffset : UINT64) > , pub SetPredication : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pBuffer : * mut ID3D12Resource , AlignedBufferOffset : UINT64 , Operation : D3D12_PREDICATION_OP) > , pub SetMarker : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub BeginEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , Metadata : UINT , pData : * const :: std :: os :: raw :: c_void , Size : UINT) > , pub EndEvent : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7) > , pub ExecuteIndirect : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pCommandSignature : * mut ID3D12CommandSignature , MaxCommandCount : UINT , pArgumentBuffer : * mut ID3D12Resource , ArgumentBufferOffset : UINT64 , pCountBuffer : * mut ID3D12Resource , CountBufferOffset : UINT64) > , pub AtomicCopyBufferUINT : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , Dependencies : UINT , ppDependentResources : * const * mut ID3D12Resource , pDependentSubresourceRanges : * const D3D12_SUBRESOURCE_RANGE_UINT64) > , pub AtomicCopyBufferUINT64 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDstBuffer : * mut ID3D12Resource , DstOffset : UINT64 , pSrcBuffer : * mut ID3D12Resource , SrcOffset : UINT64 , Dependencies : UINT , ppDependentResources : * const * mut ID3D12Resource , pDependentSubresourceRanges : * const D3D12_SUBRESOURCE_RANGE_UINT64) > , pub OMSetDepthBounds : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , Min : FLOAT , Max : FLOAT) > , pub SetSamplePositions : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , NumSamplesPerPixel : UINT , NumPixels : UINT , pSamplePositions : * mut D3D12_SAMPLE_POSITION) > , pub ResolveSubresourceRegion : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDstResource : * mut ID3D12Resource , DstSubresource : UINT , DstX : UINT , DstY : UINT , pSrcResource : * mut ID3D12Resource , SrcSubresource : UINT , pSrcRect : * mut D3D12_RECT , Format : DXGI_FORMAT , ResolveMode : D3D12_RESOLVE_MODE) > , pub SetViewInstanceMask : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , Mask : UINT) > , pub WriteBufferImmediate : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , Count : UINT , pParams : * const D3D12_WRITEBUFFERIMMEDIATE_PARAMETER , pModes : * const D3D12_WRITEBUFFERIMMEDIATE_MODE) > , pub SetProtectedResourceSession : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pProtectedResourceSession : * mut ID3D12ProtectedResourceSession) > , pub BeginRenderPass : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , NumRenderTargets : UINT , pRenderTargets : * const D3D12_RENDER_PASS_RENDER_TARGET_DESC , pDepthStencil : * const D3D12_RENDER_PASS_DEPTH_STENCIL_DESC , Flags : D3D12_RENDER_PASS_FLAGS) > , pub EndRenderPass : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7) > , pub InitializeMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pMetaCommand : * mut ID3D12MetaCommand , pInitializationParametersData : * const :: std :: os :: raw :: c_void , InitializationParametersDataSizeInBytes : SIZE_T) > , pub ExecuteMetaCommand : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pMetaCommand : * mut ID3D12MetaCommand , pExecutionParametersData : * const :: std :: os :: raw :: c_void , ExecutionParametersDataSizeInBytes : SIZE_T) > , pub BuildRaytracingAccelerationStructure : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDesc : * const D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC , NumPostbuildInfoDescs : UINT , pPostbuildInfoDescs : * const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC) > , pub EmitRaytracingAccelerationStructurePostbuildInfo : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDesc : * const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC , NumSourceAccelerationStructures : UINT , pSourceAccelerationStructureData : * const D3D12_GPU_VIRTUAL_ADDRESS) > , pub CopyRaytracingAccelerationStructure : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , DestAccelerationStructureData : D3D12_GPU_VIRTUAL_ADDRESS , SourceAccelerationStructureData : D3D12_GPU_VIRTUAL_ADDRESS , Mode : D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE) > , pub SetPipelineState1 : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pStateObject : * mut ID3D12StateObject) > , pub DispatchRays : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , pDesc : * const D3D12_DISPATCH_RAYS_DESC) > , pub RSSetShadingRate : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , baseShadingRate : D3D12_SHADING_RATE , combiners : * const D3D12_SHADING_RATE_COMBINER) > , pub RSSetShadingRateImage : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , shadingRateImage : * mut ID3D12Resource) > , pub DispatchMesh : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , ThreadGroupCountX : UINT , ThreadGroupCountY : UINT , ThreadGroupCountZ : UINT) > , pub Barrier : :: std :: option :: Option < unsafe extern "C" fn (This : * mut ID3D12GraphicsCommandList7 , NumBarrierGroups : UINT32 , pBarrierGroups : * const D3D12_BARRIER_GROUP) > , }
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ID3D12GraphicsCommandList7 {
    pub lpVtbl: *mut ID3D12GraphicsCommandList7Vtbl,
}
impl Default for ID3D12GraphicsCommandList7 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct DXGI_RGB {
    pub Red: f32,
    pub Green: f32,
    pub Blue: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct _D3DCOLORVALUE {
    pub r: f32,
    pub g: f32,
    pub b: f32,
    pub a: f32,
}
pub type D3DCOLORVALUE = _D3DCOLORVALUE;
pub type DXGI_RGBA = D3DCOLORVALUE;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct DXGI_GAMMA_CONTROL {
    pub Scale: DXGI_RGB,
    pub Offset: DXGI_RGB,
    pub GammaCurve: [DXGI_RGB; 1025usize],
}
impl Default for DXGI_GAMMA_CONTROL {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct DXGI_GAMMA_CONTROL_CAPABILITIES {
    pub ScaleAndOffsetSupported: BOOL,
    pub MaxConvertedValue: f32,
    pub MinConvertedValue: f32,
    pub NumGammaControlPoints: UINT,
    pub ControlPointPositions: [f32; 1025usize],
}
impl Default for DXGI_GAMMA_CONTROL_CAPABILITIES {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DXGI_MODE_SCANLINE_ORDER_DXGI_MODE_SCANLINE_ORDER_UNSPECIFIED:
    DXGI_MODE_SCANLINE_ORDER = 0;
pub const DXGI_MODE_SCANLINE_ORDER_DXGI_MODE_SCANLINE_ORDER_PROGRESSIVE:
    DXGI_MODE_SCANLINE_ORDER = 1;
pub const DXGI_MODE_SCANLINE_ORDER_DXGI_MODE_SCANLINE_ORDER_UPPER_FIELD_FIRST : DXGI_MODE_SCANLINE_ORDER = 2 ;
pub const DXGI_MODE_SCANLINE_ORDER_DXGI_MODE_SCANLINE_ORDER_LOWER_FIELD_FIRST : DXGI_MODE_SCANLINE_ORDER = 3 ;
pub type DXGI_MODE_SCANLINE_ORDER = ::std::os::raw::c_int;
pub const DXGI_MODE_SCALING_DXGI_MODE_SCALING_UNSPECIFIED: DXGI_MODE_SCALING =
    0;
pub const DXGI_MODE_SCALING_DXGI_MODE_SCALING_CENTERED: DXGI_MODE_SCALING = 1;
pub const DXGI_MODE_SCALING_DXGI_MODE_SCALING_STRETCHED: DXGI_MODE_SCALING = 2;
pub type DXGI_MODE_SCALING = ::std::os::raw::c_int;
pub const DXGI_MODE_ROTATION_DXGI_MODE_ROTATION_UNSPECIFIED:
    DXGI_MODE_ROTATION = 0;
pub const DXGI_MODE_ROTATION_DXGI_MODE_ROTATION_IDENTITY: DXGI_MODE_ROTATION =
    1;
pub const DXGI_MODE_ROTATION_DXGI_MODE_ROTATION_ROTATE90: DXGI_MODE_ROTATION =
    2;
pub const DXGI_MODE_ROTATION_DXGI_MODE_ROTATION_ROTATE180: DXGI_MODE_ROTATION =
    3;
pub const DXGI_MODE_ROTATION_DXGI_MODE_ROTATION_ROTATE270: DXGI_MODE_ROTATION =
    4;
pub type DXGI_MODE_ROTATION = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_MODE_DESC {
    pub Width: UINT,
    pub Height: UINT,
    pub RefreshRate: DXGI_RATIONAL,
    pub Format: DXGI_FORMAT,
    pub ScanlineOrdering: DXGI_MODE_SCANLINE_ORDER,
    pub Scaling: DXGI_MODE_SCALING,
}
impl Default for DXGI_MODE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_JPEG_DC_HUFFMAN_TABLE {
    pub CodeCounts: [BYTE; 12usize],
    pub CodeValues: [BYTE; 12usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_JPEG_AC_HUFFMAN_TABLE {
    pub CodeCounts: [BYTE; 16usize],
    pub CodeValues: [BYTE; 162usize],
}
impl Default for DXGI_JPEG_AC_HUFFMAN_TABLE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_JPEG_QUANTIZATION_TABLE {
    pub Elements: [BYTE; 64usize],
}
impl Default for DXGI_JPEG_QUANTIZATION_TABLE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type DXGI_USAGE = UINT;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct DXGI_FRAME_STATISTICS {
    pub PresentCount: UINT,
    pub PresentRefreshCount: UINT,
    pub SyncRefreshCount: UINT,
    pub SyncQPCTime: LARGE_INTEGER,
    pub SyncGPUTime: LARGE_INTEGER,
}
impl Default for DXGI_FRAME_STATISTICS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for DXGI_FRAME_STATISTICS {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "DXGI_FRAME_STATISTICS {{ PresentCount: {:?}, PresentRefreshCount: {:?}, SyncRefreshCount: {:?}, SyncQPCTime: {:?}, SyncGPUTime: {:?} }}" , self . PresentCount , self . PresentRefreshCount , self . SyncRefreshCount , self . SyncQPCTime , self . SyncGPUTime)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_MAPPED_RECT {
    pub Pitch: INT,
    pub pBits: *mut BYTE,
}
impl Default for DXGI_MAPPED_RECT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_ADAPTER_DESC {
    pub Description: [WCHAR; 128usize],
    pub VendorId: UINT,
    pub DeviceId: UINT,
    pub SubSysId: UINT,
    pub Revision: UINT,
    pub DedicatedVideoMemory: SIZE_T,
    pub DedicatedSystemMemory: SIZE_T,
    pub SharedSystemMemory: SIZE_T,
    pub AdapterLuid: LUID,
}
impl Default for DXGI_ADAPTER_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_OUTPUT_DESC {
    pub DeviceName: [WCHAR; 32usize],
    pub DesktopCoordinates: RECT,
    pub AttachedToDesktop: BOOL,
    pub Rotation: DXGI_MODE_ROTATION,
    pub Monitor: HMONITOR,
}
impl Default for DXGI_OUTPUT_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_SHARED_RESOURCE {
    pub Handle: HANDLE,
}
impl Default for DXGI_SHARED_RESOURCE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DXGI_RESIDENCY_DXGI_RESIDENCY_FULLY_RESIDENT: DXGI_RESIDENCY = 1;
pub const DXGI_RESIDENCY_DXGI_RESIDENCY_RESIDENT_IN_SHARED_MEMORY:
    DXGI_RESIDENCY = 2;
pub const DXGI_RESIDENCY_DXGI_RESIDENCY_EVICTED_TO_DISK: DXGI_RESIDENCY = 3;
pub type DXGI_RESIDENCY = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_SURFACE_DESC {
    pub Width: UINT,
    pub Height: UINT,
    pub Format: DXGI_FORMAT,
    pub SampleDesc: DXGI_SAMPLE_DESC,
}
impl Default for DXGI_SURFACE_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DXGI_SWAP_EFFECT_DXGI_SWAP_EFFECT_DISCARD: DXGI_SWAP_EFFECT = 0;
pub const DXGI_SWAP_EFFECT_DXGI_SWAP_EFFECT_SEQUENTIAL: DXGI_SWAP_EFFECT = 1;
pub const DXGI_SWAP_EFFECT_DXGI_SWAP_EFFECT_FLIP_SEQUENTIAL: DXGI_SWAP_EFFECT =
    3;
pub const DXGI_SWAP_EFFECT_DXGI_SWAP_EFFECT_FLIP_DISCARD: DXGI_SWAP_EFFECT = 4;
pub type DXGI_SWAP_EFFECT = ::std::os::raw::c_int;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_NONPREROTATED:
    DXGI_SWAP_CHAIN_FLAG = 1;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_ALLOW_MODE_SWITCH:
    DXGI_SWAP_CHAIN_FLAG = 2;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_GDI_COMPATIBLE:
    DXGI_SWAP_CHAIN_FLAG = 4;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_RESTRICTED_CONTENT:
    DXGI_SWAP_CHAIN_FLAG = 8;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_RESTRICT_SHARED_RESOURCE_DRIVER : DXGI_SWAP_CHAIN_FLAG = 16 ;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_DISPLAY_ONLY:
    DXGI_SWAP_CHAIN_FLAG = 32;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_FRAME_LATENCY_WAITABLE_OBJECT : DXGI_SWAP_CHAIN_FLAG = 64 ;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_FOREGROUND_LAYER:
    DXGI_SWAP_CHAIN_FLAG = 128;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_FULLSCREEN_VIDEO:
    DXGI_SWAP_CHAIN_FLAG = 256;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_YUV_VIDEO:
    DXGI_SWAP_CHAIN_FLAG = 512;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_HW_PROTECTED:
    DXGI_SWAP_CHAIN_FLAG = 1024;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_ALLOW_TEARING:
    DXGI_SWAP_CHAIN_FLAG = 2048;
pub const DXGI_SWAP_CHAIN_FLAG_DXGI_SWAP_CHAIN_FLAG_RESTRICTED_TO_ALL_HOLOGRAPHIC_DISPLAYS : DXGI_SWAP_CHAIN_FLAG = 4096 ;
pub type DXGI_SWAP_CHAIN_FLAG = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_SWAP_CHAIN_DESC {
    pub BufferDesc: DXGI_MODE_DESC,
    pub SampleDesc: DXGI_SAMPLE_DESC,
    pub BufferUsage: DXGI_USAGE,
    pub BufferCount: UINT,
    pub OutputWindow: HWND,
    pub Windowed: BOOL,
    pub SwapEffect: DXGI_SWAP_EFFECT,
    pub Flags: UINT,
}
impl Default for DXGI_SWAP_CHAIN_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIObject: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIObjectVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIObject,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIObject) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIObject) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIObject,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIObject,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIObject,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIObject,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIObject {
    pub lpVtbl: *mut IDXGIObjectVtbl,
}
impl Default for IDXGIObject {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIDeviceSubObject: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIDeviceSubObjectVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDeviceSubObject,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDeviceSubObject) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDeviceSubObject) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDeviceSubObject,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDeviceSubObject,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDeviceSubObject,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDeviceSubObject,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDeviceSubObject,
            riid: *const IID,
            ppDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIDeviceSubObject {
    pub lpVtbl: *mut IDXGIDeviceSubObjectVtbl,
}
impl Default for IDXGIDeviceSubObject {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIResource: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIResourceVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIResource) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIResource) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            riid: *const IID,
            ppDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetSharedHandle: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            pSharedHandle: *mut HANDLE,
        ) -> HRESULT,
    >,
    pub GetUsage: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            pUsage: *mut DXGI_USAGE,
        ) -> HRESULT,
    >,
    pub SetEvictionPriority: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            EvictionPriority: UINT,
        ) -> HRESULT,
    >,
    pub GetEvictionPriority: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIResource,
            pEvictionPriority: *mut UINT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIResource {
    pub lpVtbl: *mut IDXGIResourceVtbl,
}
impl Default for IDXGIResource {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIKeyedMutex: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIKeyedMutexVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIKeyedMutex,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIKeyedMutex) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIKeyedMutex) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIKeyedMutex,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIKeyedMutex,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIKeyedMutex,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIKeyedMutex,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIKeyedMutex,
            riid: *const IID,
            ppDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AcquireSync: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIKeyedMutex,
            Key: UINT64,
            dwMilliseconds: DWORD,
        ) -> HRESULT,
    >,
    pub ReleaseSync: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIKeyedMutex,
            Key: UINT64,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIKeyedMutex {
    pub lpVtbl: *mut IDXGIKeyedMutexVtbl,
}
impl Default for IDXGIKeyedMutex {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGISurface: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGISurfaceVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGISurface) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGISurface) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface,
            riid: *const IID,
            ppDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface,
            pDesc: *mut DXGI_SURFACE_DESC,
        ) -> HRESULT,
    >,
    pub Map: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface,
            pLockedRect: *mut DXGI_MAPPED_RECT,
            MapFlags: UINT,
        ) -> HRESULT,
    >,
    pub Unmap: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGISurface) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGISurface {
    pub lpVtbl: *mut IDXGISurfaceVtbl,
}
impl Default for IDXGISurface {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGISurface1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGISurface1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGISurface1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGISurface1) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            riid: *const IID,
            ppDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            pDesc: *mut DXGI_SURFACE_DESC,
        ) -> HRESULT,
    >,
    pub Map: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            pLockedRect: *mut DXGI_MAPPED_RECT,
            MapFlags: UINT,
        ) -> HRESULT,
    >,
    pub Unmap: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGISurface1) -> HRESULT,
    >,
    pub GetDC: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            Discard: BOOL,
            phdc: *mut HDC,
        ) -> HRESULT,
    >,
    pub ReleaseDC: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISurface1,
            pDirtyRect: *mut RECT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGISurface1 {
    pub lpVtbl: *mut IDXGISurface1Vtbl,
}
impl Default for IDXGISurface1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIAdapter: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIAdapterVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIAdapter) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIAdapter) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub EnumOutputs: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter,
            Output: UINT,
            ppOutput: *mut *mut IDXGIOutput,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter,
            pDesc: *mut DXGI_ADAPTER_DESC,
        ) -> HRESULT,
    >,
    pub CheckInterfaceSupport: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter,
            InterfaceName: *const GUID,
            pUMDVersion: *mut LARGE_INTEGER,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIAdapter {
    pub lpVtbl: *mut IDXGIAdapterVtbl,
}
impl Default for IDXGIAdapter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIOutput: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIOutputVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIOutput) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIOutput) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pDesc: *mut DXGI_OUTPUT_DESC,
        ) -> HRESULT,
    >,
    pub GetDisplayModeList: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            EnumFormat: DXGI_FORMAT,
            Flags: UINT,
            pNumModes: *mut UINT,
            pDesc: *mut DXGI_MODE_DESC,
        ) -> HRESULT,
    >,
    pub FindClosestMatchingMode: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pModeToMatch: *const DXGI_MODE_DESC,
            pClosestMatch: *mut DXGI_MODE_DESC,
            pConcernedDevice: *mut IUnknown,
        ) -> HRESULT,
    >,
    pub WaitForVBlank: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIOutput) -> HRESULT,
    >,
    pub TakeOwnership: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pDevice: *mut IUnknown,
            Exclusive: BOOL,
        ) -> HRESULT,
    >,
    pub ReleaseOwnership:
        ::std::option::Option<unsafe extern "C" fn(This: *mut IDXGIOutput)>,
    pub GetGammaControlCapabilities: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pGammaCaps: *mut DXGI_GAMMA_CONTROL_CAPABILITIES,
        ) -> HRESULT,
    >,
    pub SetGammaControl: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pArray: *const DXGI_GAMMA_CONTROL,
        ) -> HRESULT,
    >,
    pub GetGammaControl: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pArray: *mut DXGI_GAMMA_CONTROL,
        ) -> HRESULT,
    >,
    pub SetDisplaySurface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pScanoutSurface: *mut IDXGISurface,
        ) -> HRESULT,
    >,
    pub GetDisplaySurfaceData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pDestination: *mut IDXGISurface,
        ) -> HRESULT,
    >,
    pub GetFrameStatistics: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutput,
            pStats: *mut DXGI_FRAME_STATISTICS,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIOutput {
    pub lpVtbl: *mut IDXGIOutputVtbl,
}
impl Default for IDXGIOutput {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGISwapChain: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGISwapChainVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGISwapChain) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGISwapChain) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDevice: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            riid: *const IID,
            ppDevice: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub Present: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            SyncInterval: UINT,
            Flags: UINT,
        ) -> HRESULT,
    >,
    pub GetBuffer: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            Buffer: UINT,
            riid: *const IID,
            ppSurface: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetFullscreenState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            Fullscreen: BOOL,
            pTarget: *mut IDXGIOutput,
        ) -> HRESULT,
    >,
    pub GetFullscreenState: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            pFullscreen: *mut BOOL,
            ppTarget: *mut *mut IDXGIOutput,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            pDesc: *mut DXGI_SWAP_CHAIN_DESC,
        ) -> HRESULT,
    >,
    pub ResizeBuffers: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            BufferCount: UINT,
            Width: UINT,
            Height: UINT,
            NewFormat: DXGI_FORMAT,
            SwapChainFlags: UINT,
        ) -> HRESULT,
    >,
    pub ResizeTarget: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            pNewTargetParameters: *const DXGI_MODE_DESC,
        ) -> HRESULT,
    >,
    pub GetContainingOutput: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            ppOutput: *mut *mut IDXGIOutput,
        ) -> HRESULT,
    >,
    pub GetFrameStatistics: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            pStats: *mut DXGI_FRAME_STATISTICS,
        ) -> HRESULT,
    >,
    pub GetLastPresentCount: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGISwapChain,
            pLastPresentCount: *mut UINT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGISwapChain {
    pub lpVtbl: *mut IDXGISwapChainVtbl,
}
impl Default for IDXGISwapChain {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIFactory: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIFactoryVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIFactory) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIFactory) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub EnumAdapters: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            Adapter: UINT,
            ppAdapter: *mut *mut IDXGIAdapter,
        ) -> HRESULT,
    >,
    pub MakeWindowAssociation: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            WindowHandle: HWND,
            Flags: UINT,
        ) -> HRESULT,
    >,
    pub GetWindowAssociation: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            pWindowHandle: *mut HWND,
        ) -> HRESULT,
    >,
    pub CreateSwapChain: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            pDevice: *mut IUnknown,
            pDesc: *mut DXGI_SWAP_CHAIN_DESC,
            ppSwapChain: *mut *mut IDXGISwapChain,
        ) -> HRESULT,
    >,
    pub CreateSoftwareAdapter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory,
            Module: HMODULE,
            ppAdapter: *mut *mut IDXGIAdapter,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIFactory {
    pub lpVtbl: *mut IDXGIFactoryVtbl,
}
impl Default for IDXGIFactory {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn CreateDXGIFactory(
        riid: *const IID,
        ppFactory: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT;
}
extern "C" {
    pub fn CreateDXGIFactory1(
        riid: *const IID,
        ppFactory: *mut *mut ::std::os::raw::c_void,
    ) -> HRESULT;
}
extern "C" {
    pub static IID_IDXGIDevice: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIDeviceVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDevice) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDevice) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetAdapter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            pAdapter: *mut *mut IDXGIAdapter,
        ) -> HRESULT,
    >,
    pub CreateSurface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            pDesc: *const DXGI_SURFACE_DESC,
            NumSurfaces: UINT,
            Usage: DXGI_USAGE,
            pSharedResource: *const DXGI_SHARED_RESOURCE,
            ppSurface: *mut *mut IDXGISurface,
        ) -> HRESULT,
    >,
    pub QueryResourceResidency: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            ppResources: *const *mut IUnknown,
            pResidencyStatus: *mut DXGI_RESIDENCY,
            NumResources: UINT,
        ) -> HRESULT,
    >,
    pub SetGPUThreadPriority: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDevice, Priority: INT) -> HRESULT,
    >,
    pub GetGPUThreadPriority: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice,
            pPriority: *mut INT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIDevice {
    pub lpVtbl: *mut IDXGIDeviceVtbl,
}
impl Default for IDXGIDevice {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DXGI_ADAPTER_FLAG_DXGI_ADAPTER_FLAG_NONE: DXGI_ADAPTER_FLAG = 0;
pub const DXGI_ADAPTER_FLAG_DXGI_ADAPTER_FLAG_REMOTE: DXGI_ADAPTER_FLAG = 1;
pub const DXGI_ADAPTER_FLAG_DXGI_ADAPTER_FLAG_SOFTWARE: DXGI_ADAPTER_FLAG = 2;
pub const DXGI_ADAPTER_FLAG_DXGI_ADAPTER_FLAG_FORCE_DWORD: DXGI_ADAPTER_FLAG =
    -1;
pub type DXGI_ADAPTER_FLAG = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_ADAPTER_DESC1 {
    pub Description: [WCHAR; 128usize],
    pub VendorId: UINT,
    pub DeviceId: UINT,
    pub SubSysId: UINT,
    pub Revision: UINT,
    pub DedicatedVideoMemory: SIZE_T,
    pub DedicatedSystemMemory: SIZE_T,
    pub SharedSystemMemory: SIZE_T,
    pub AdapterLuid: LUID,
    pub Flags: UINT,
}
impl Default for DXGI_ADAPTER_DESC1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct DXGI_DISPLAY_COLOR_SPACE {
    pub PrimaryCoordinates: [[FLOAT; 2usize]; 8usize],
    pub WhitePoints: [[FLOAT; 2usize]; 16usize],
}
extern "C" {
    pub static IID_IDXGIFactory1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIFactory1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIFactory1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIFactory1) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub EnumAdapters: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            Adapter: UINT,
            ppAdapter: *mut *mut IDXGIAdapter,
        ) -> HRESULT,
    >,
    pub MakeWindowAssociation: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            WindowHandle: HWND,
            Flags: UINT,
        ) -> HRESULT,
    >,
    pub GetWindowAssociation: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            pWindowHandle: *mut HWND,
        ) -> HRESULT,
    >,
    pub CreateSwapChain: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            pDevice: *mut IUnknown,
            pDesc: *mut DXGI_SWAP_CHAIN_DESC,
            ppSwapChain: *mut *mut IDXGISwapChain,
        ) -> HRESULT,
    >,
    pub CreateSoftwareAdapter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            Module: HMODULE,
            ppAdapter: *mut *mut IDXGIAdapter,
        ) -> HRESULT,
    >,
    pub EnumAdapters1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIFactory1,
            Adapter: UINT,
            ppAdapter: *mut *mut IDXGIAdapter1,
        ) -> HRESULT,
    >,
    pub IsCurrent: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIFactory1) -> BOOL,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIFactory1 {
    pub lpVtbl: *mut IDXGIFactory1Vtbl,
}
impl Default for IDXGIFactory1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIAdapter1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIAdapter1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIAdapter1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIAdapter1) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub EnumOutputs: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            Output: UINT,
            ppOutput: *mut *mut IDXGIOutput,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            pDesc: *mut DXGI_ADAPTER_DESC,
        ) -> HRESULT,
    >,
    pub CheckInterfaceSupport: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            InterfaceName: *const GUID,
            pUMDVersion: *mut LARGE_INTEGER,
        ) -> HRESULT,
    >,
    pub GetDesc1: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIAdapter1,
            pDesc: *mut DXGI_ADAPTER_DESC1,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIAdapter1 {
    pub lpVtbl: *mut IDXGIAdapter1Vtbl,
}
impl Default for IDXGIAdapter1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIDevice1: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIDevice1Vtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDevice1) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDevice1) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetAdapter: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            pAdapter: *mut *mut IDXGIAdapter,
        ) -> HRESULT,
    >,
    pub CreateSurface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            pDesc: *const DXGI_SURFACE_DESC,
            NumSurfaces: UINT,
            Usage: DXGI_USAGE,
            pSharedResource: *const DXGI_SHARED_RESOURCE,
            ppSurface: *mut *mut IDXGISurface,
        ) -> HRESULT,
    >,
    pub QueryResourceResidency: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            ppResources: *const *mut IUnknown,
            pResidencyStatus: *mut DXGI_RESIDENCY,
            NumResources: UINT,
        ) -> HRESULT,
    >,
    pub SetGPUThreadPriority: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDevice1, Priority: INT) -> HRESULT,
    >,
    pub GetGPUThreadPriority: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            pPriority: *mut INT,
        ) -> HRESULT,
    >,
    pub SetMaximumFrameLatency: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            MaxLatency: UINT,
        ) -> HRESULT,
    >,
    pub GetMaximumFrameLatency: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDevice1,
            pMaxLatency: *mut UINT,
        ) -> HRESULT,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIDevice1 {
    pub lpVtbl: *mut IDXGIDevice1Vtbl,
}
impl Default for IDXGIDevice1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static IID_IDXGIDisplayControl: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIDisplayControlVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIDisplayControl,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDisplayControl) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDisplayControl) -> ULONG,
    >,
    pub IsStereoEnabled: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDisplayControl) -> BOOL,
    >,
    pub SetStereoEnabled: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIDisplayControl, enabled: BOOL),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIDisplayControl {
    pub lpVtbl: *mut IDXGIDisplayControlVtbl,
}
impl Default for IDXGIDisplayControl {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_OUTDUPL_MOVE_RECT {
    pub SourcePoint: POINT,
    pub DestinationRect: RECT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_OUTDUPL_DESC {
    pub ModeDesc: DXGI_MODE_DESC,
    pub Rotation: DXGI_MODE_ROTATION,
    pub DesktopImageInSystemMemory: BOOL,
}
impl Default for DXGI_OUTDUPL_DESC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_OUTDUPL_POINTER_POSITION {
    pub Position: POINT,
    pub Visible: BOOL,
}
pub const DXGI_OUTDUPL_POINTER_SHAPE_TYPE_DXGI_OUTDUPL_POINTER_SHAPE_TYPE_MONOCHROME : DXGI_OUTDUPL_POINTER_SHAPE_TYPE = 1 ;
pub const DXGI_OUTDUPL_POINTER_SHAPE_TYPE_DXGI_OUTDUPL_POINTER_SHAPE_TYPE_COLOR : DXGI_OUTDUPL_POINTER_SHAPE_TYPE = 2 ;
pub const DXGI_OUTDUPL_POINTER_SHAPE_TYPE_DXGI_OUTDUPL_POINTER_SHAPE_TYPE_MASKED_COLOR : DXGI_OUTDUPL_POINTER_SHAPE_TYPE = 4 ;
pub type DXGI_OUTDUPL_POINTER_SHAPE_TYPE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct DXGI_OUTDUPL_POINTER_SHAPE_INFO {
    pub Type: UINT,
    pub Width: UINT,
    pub Height: UINT,
    pub Pitch: UINT,
    pub HotSpot: POINT,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct DXGI_OUTDUPL_FRAME_INFO {
    pub LastPresentTime: LARGE_INTEGER,
    pub LastMouseUpdateTime: LARGE_INTEGER,
    pub AccumulatedFrames: UINT,
    pub RectsCoalesced: BOOL,
    pub ProtectedContentMaskedOut: BOOL,
    pub PointerPosition: DXGI_OUTDUPL_POINTER_POSITION,
    pub TotalMetadataBufferSize: UINT,
    pub PointerShapeBufferSize: UINT,
}
impl Default for DXGI_OUTDUPL_FRAME_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for DXGI_OUTDUPL_FRAME_INFO {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "DXGI_OUTDUPL_FRAME_INFO {{ LastPresentTime: {:?}, LastMouseUpdateTime: {:?}, AccumulatedFrames: {:?}, RectsCoalesced: {:?}, ProtectedContentMaskedOut: {:?}, PointerPosition: {:?}, TotalMetadataBufferSize: {:?}, PointerShapeBufferSize: {:?} }}" , self . LastPresentTime , self . LastMouseUpdateTime , self . AccumulatedFrames , self . RectsCoalesced , self . ProtectedContentMaskedOut , self . PointerPosition , self . TotalMetadataBufferSize , self . PointerShapeBufferSize)
    }
}
extern "C" {
    pub static IID_IDXGIOutputDuplication: IID;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct IDXGIOutputDuplicationVtbl {
    pub QueryInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutputDuplication,
            riid: *const IID,
            ppvObject: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub AddRef: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIOutputDuplication) -> ULONG,
    >,
    pub Release: ::std::option::Option<
        unsafe extern "C" fn(This: *mut IDXGIOutputDuplication) -> ULONG,
    >,
    pub SetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutputDuplication,
            Name: *const GUID,
            DataSize: UINT,
            pData: *const ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub SetPrivateDataInterface: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutputDuplication,
            Name: *const GUID,
            pUnknown: *const IUnknown,
        ) -> HRESULT,
    >,
    pub GetPrivateData: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutputDuplication,
            Name: *const GUID,
            pDataSize: *mut UINT,
            pData: *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetParent: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutputDuplication,
            riid: *const IID,
            ppParent: *mut *mut ::std::os::raw::c_void,
        ) -> HRESULT,
    >,
    pub GetDesc: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutputDuplication,
            pDesc: *mut DXGI_OUTDUPL_DESC,
        ),
    >,
    pub AcquireNextFrame: ::std::option::Option<
        unsafe extern "C" fn(
            This: *mut IDXGIOutputDuplication,
            TimeoutInMilliseconds: UINT,
            pFrameInfo: *mut DXGI_OUTDUPL_FRAME_INFO,
            ppDesktopResource: *mut *mut IDXGIResource,
        ) -> HRESULT,
    >,
    pub GetFrameDirtyRects: ::std::option::Option<
        unsafe extern "C" fn(
        