#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]

use crate::raw_bindings::d3d12::*;
use crate::utils::*;
// use crate::{enum_wrappers::*};
// use crate::{struct_wrappers::*};

// ToDo: keep the original name?
pub const CONSTANT_BUFFER_ALIGNMENT: Bytes =
    Bytes(D3D12_CONSTANT_BUFFER_DATA_PLACEMENT_ALIGNMENT as u64);

pub const DEFAULT_RESOURCE_ALIGNMENT: Bytes =
    Bytes(D3D12_DEFAULT_RESOURCE_PLACEMENT_ALIGNMENT as u64);

pub const STANDARD_MULTISAMPLE_QUALITY_PATTERN: u32 =
    DXGI_STANDARD_MULTISAMPLE_QUALITY_PATTERN;
pub const CENTER_MULTISAMPLE_QUALITY_PATTERN: u32 =
    DXGI_CENTER_MULTISAMPLE_QUALITY_PATTERN;
pub const FORMAT_DEFINED: u32 = DXGI_FORMAT_DEFINED;
pub const C_16BIT_INDEX_STRIP_CUT_VALUE: u32 =
    D3D12_16BIT_INDEX_STRIP_CUT_VALUE;
pub const C_32BIT_INDEX_STRIP_CUT_VALUE: u32 =
    D3D12_32BIT_INDEX_STRIP_CUT_VALUE;
pub const C_8BIT_INDEX_STRIP_CUT_VALUE: u32 = D3D12_8BIT_INDEX_STRIP_CUT_VALUE;
pub const APPEND_ALIGNED_ELEMENT: u32 = D3D12_APPEND_ALIGNED_ELEMENT;
pub const ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT: u32 =
    D3D12_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT;
pub const CLIP_OR_CULL_DISTANCE_COUNT: u32 = D3D12_CLIP_OR_CULL_DISTANCE_COUNT;
pub const CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: u32 =
    D3D12_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT;
pub const COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT: u32 =
    D3D12_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT;
pub const COMMONSHADER_CONSTANT_BUFFER_COMPONENTS: u32 =
    D3D12_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS;
pub const COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT: u32 =
    D3D12_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT;
pub const COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT: u32 =
    D3D12_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT;
pub const COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS: u32 =
    D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS;
pub const COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT: u32 =
    D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT;
pub const COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST: u32 =
    D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST;
pub const COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS: u32 =
    D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS;
pub const COMMONSHADER_FLOWCONTROL_NESTING_LIMIT: u32 =
    D3D12_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT;
pub const COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT: u32 =
    D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT;
pub const COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT: u32 =
    D3D12_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT;
pub const COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS: u32 =
    D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS;
pub const COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT: u32 =
    D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT;
pub const COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST: u32 =
    D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST;
pub const COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS: u32 =
    D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS;
pub const COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT: u32 =
    D3D12_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT;
pub const COMMONSHADER_SAMPLER_REGISTER_COMPONENTS: u32 =
    D3D12_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS;
pub const COMMONSHADER_SAMPLER_REGISTER_COUNT: u32 =
    D3D12_COMMONSHADER_SAMPLER_REGISTER_COUNT;
pub const COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST: u32 =
    D3D12_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST;
pub const COMMONSHADER_SAMPLER_REGISTER_READ_PORTS: u32 =
    D3D12_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS;
pub const COMMONSHADER_SAMPLER_SLOT_COUNT: u32 =
    D3D12_COMMONSHADER_SAMPLER_SLOT_COUNT;
pub const COMMONSHADER_SUBROUTINE_NESTING_LIMIT: u32 =
    D3D12_COMMONSHADER_SUBROUTINE_NESTING_LIMIT;
pub const COMMONSHADER_TEMP_REGISTER_COMPONENTS: u32 =
    D3D12_COMMONSHADER_TEMP_REGISTER_COMPONENTS;
pub const COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT;
pub const COMMONSHADER_TEMP_REGISTER_COUNT: u32 =
    D3D12_COMMONSHADER_TEMP_REGISTER_COUNT;
pub const COMMONSHADER_TEMP_REGISTER_READS_PER_INST: u32 =
    D3D12_COMMONSHADER_TEMP_REGISTER_READS_PER_INST;
pub const COMMONSHADER_TEMP_REGISTER_READ_PORTS: u32 =
    D3D12_COMMONSHADER_TEMP_REGISTER_READ_PORTS;
pub const COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX: u32 =
    D3D12_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX;
pub const COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN: i32 =
    D3D12_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN;
pub const COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE: i32 =
    D3D12_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE;
pub const COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE: u32 =
    D3D12_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE;
pub const CONSTANT_BUFFER_DATA_PLACEMENT_ALIGNMENT: Bytes =
    Bytes(D3D12_CONSTANT_BUFFER_DATA_PLACEMENT_ALIGNMENT as u64);
pub const CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 =
    D3D12_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD;
pub const CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP;
pub const CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION: u32 =
    D3D12_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION;
pub const CS_4_X_RAW_UAV_BYTE_ALIGNMENT: Bytes =
    Bytes(D3D12_CS_4_X_RAW_UAV_BYTE_ALIGNMENT as u64);
pub const CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP: u32 =
    D3D12_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP;
pub const CS_4_X_THREAD_GROUP_MAX_X: u32 = D3D12_CS_4_X_THREAD_GROUP_MAX_X;
pub const CS_4_X_THREAD_GROUP_MAX_Y: u32 = D3D12_CS_4_X_THREAD_GROUP_MAX_Y;
pub const CS_4_X_UAV_REGISTER_COUNT: u32 = D3D12_CS_4_X_UAV_REGISTER_COUNT;
pub const CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION: u32 =
    D3D12_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION;
pub const CS_TGSM_REGISTER_COUNT: u32 = D3D12_CS_TGSM_REGISTER_COUNT;
pub const CS_TGSM_REGISTER_READS_PER_INST: u32 =
    D3D12_CS_TGSM_REGISTER_READS_PER_INST;
pub const CS_TGSM_RESOURCE_REGISTER_COMPONENTS: u32 =
    D3D12_CS_TGSM_RESOURCE_REGISTER_COMPONENTS;
pub const CS_TGSM_RESOURCE_REGISTER_READ_PORTS: u32 =
    D3D12_CS_TGSM_RESOURCE_REGISTER_READ_PORTS;
pub const CS_THREADGROUPID_REGISTER_COMPONENTS: u32 =
    D3D12_CS_THREADGROUPID_REGISTER_COMPONENTS;
pub const CS_THREADGROUPID_REGISTER_COUNT: u32 =
    D3D12_CS_THREADGROUPID_REGISTER_COUNT;
pub const CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS: u32 =
    D3D12_CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS;
pub const CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT: u32 =
    D3D12_CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT;
pub const CS_THREADIDINGROUP_REGISTER_COMPONENTS: u32 =
    D3D12_CS_THREADIDINGROUP_REGISTER_COMPONENTS;
pub const CS_THREADIDINGROUP_REGISTER_COUNT: u32 =
    D3D12_CS_THREADIDINGROUP_REGISTER_COUNT;
pub const CS_THREADID_REGISTER_COMPONENTS: u32 =
    D3D12_CS_THREADID_REGISTER_COMPONENTS;
pub const CS_THREADID_REGISTER_COUNT: u32 = D3D12_CS_THREADID_REGISTER_COUNT;
pub const CS_THREAD_GROUP_MAX_THREADS_PER_GROUP: u32 =
    D3D12_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP;
pub const CS_THREAD_GROUP_MAX_X: u32 = D3D12_CS_THREAD_GROUP_MAX_X;
pub const CS_THREAD_GROUP_MAX_Y: u32 = D3D12_CS_THREAD_GROUP_MAX_Y;
pub const CS_THREAD_GROUP_MAX_Z: u32 = D3D12_CS_THREAD_GROUP_MAX_Z;
pub const CS_THREAD_GROUP_MIN_X: u32 = D3D12_CS_THREAD_GROUP_MIN_X;
pub const CS_THREAD_GROUP_MIN_Y: u32 = D3D12_CS_THREAD_GROUP_MIN_Y;
pub const CS_THREAD_GROUP_MIN_Z: u32 = D3D12_CS_THREAD_GROUP_MIN_Z;
pub const CS_THREAD_LOCAL_TEMP_REGISTER_POOL: u32 =
    D3D12_CS_THREAD_LOCAL_TEMP_REGISTER_POOL;
pub const DEFAULT_BLEND_FACTOR_ALPHA: f64 = D3D12_DEFAULT_BLEND_FACTOR_ALPHA;
pub const DEFAULT_BLEND_FACTOR_BLUE: f64 = D3D12_DEFAULT_BLEND_FACTOR_BLUE;
pub const DEFAULT_BLEND_FACTOR_GREEN: f64 = D3D12_DEFAULT_BLEND_FACTOR_GREEN;
pub const DEFAULT_BLEND_FACTOR_RED: f64 = D3D12_DEFAULT_BLEND_FACTOR_RED;
pub const DEFAULT_BORDER_COLOR_COMPONENT: f64 =
    D3D12_DEFAULT_BORDER_COLOR_COMPONENT;
pub const DEFAULT_DEPTH_BIAS: u32 = D3D12_DEFAULT_DEPTH_BIAS;
pub const DEFAULT_DEPTH_BIAS_CLAMP: f64 = D3D12_DEFAULT_DEPTH_BIAS_CLAMP;
pub const DEFAULT_MAX_ANISOTROPY: u32 = D3D12_DEFAULT_MAX_ANISOTROPY;
pub const DEFAULT_MIP_LOD_BIAS: f64 = D3D12_DEFAULT_MIP_LOD_BIAS;
pub const DEFAULT_MSAA_RESOURCE_PLACEMENT_ALIGNMENT: Bytes =
    Bytes(D3D12_DEFAULT_MSAA_RESOURCE_PLACEMENT_ALIGNMENT as u64);
pub const DEFAULT_RENDER_TARGET_ARRAY_INDEX: u32 =
    D3D12_DEFAULT_RENDER_TARGET_ARRAY_INDEX;
pub const DEFAULT_RESOURCE_PLACEMENT_ALIGNMENT: Bytes =
    Bytes(D3D12_DEFAULT_RESOURCE_PLACEMENT_ALIGNMENT as u64);
pub const DEFAULT_SAMPLE_MASK: u32 = D3D12_DEFAULT_SAMPLE_MASK;
pub const DEFAULT_SCISSOR_ENDX: u32 = D3D12_DEFAULT_SCISSOR_ENDX;
pub const DEFAULT_SCISSOR_ENDY: u32 = D3D12_DEFAULT_SCISSOR_ENDY;
pub const DEFAULT_SCISSOR_STARTX: u32 = D3D12_DEFAULT_SCISSOR_STARTX;
pub const DEFAULT_SCISSOR_STARTY: u32 = D3D12_DEFAULT_SCISSOR_STARTY;
pub const DEFAULT_SLOPE_SCALED_DEPTH_BIAS: f64 =
    D3D12_DEFAULT_SLOPE_SCALED_DEPTH_BIAS;
pub const DEFAULT_STENCIL_READ_MASK: u32 = D3D12_DEFAULT_STENCIL_READ_MASK;
pub const DEFAULT_STENCIL_REFERENCE: u32 = D3D12_DEFAULT_STENCIL_REFERENCE;
pub const DEFAULT_STENCIL_WRITE_MASK: u32 = D3D12_DEFAULT_STENCIL_WRITE_MASK;
pub const DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX: u32 =
    D3D12_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX;
pub const DEFAULT_VIEWPORT_HEIGHT: u32 = D3D12_DEFAULT_VIEWPORT_HEIGHT;
pub const DEFAULT_VIEWPORT_MAX_DEPTH: f64 = D3D12_DEFAULT_VIEWPORT_MAX_DEPTH;
pub const DEFAULT_VIEWPORT_MIN_DEPTH: f64 = D3D12_DEFAULT_VIEWPORT_MIN_DEPTH;
pub const DEFAULT_VIEWPORT_TOPLEFTX: u32 = D3D12_DEFAULT_VIEWPORT_TOPLEFTX;
pub const DEFAULT_VIEWPORT_TOPLEFTY: u32 = D3D12_DEFAULT_VIEWPORT_TOPLEFTY;
pub const DEFAULT_VIEWPORT_WIDTH: u32 = D3D12_DEFAULT_VIEWPORT_WIDTH;
pub const DESCRIPTOR_RANGE_OFFSET_APPEND: u32 =
    D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND;
pub const DRIVER_RESERVED_REGISTER_SPACE_VALUES_END: u32 =
    D3D12_DRIVER_RESERVED_REGISTER_SPACE_VALUES_END;
pub const DRIVER_RESERVED_REGISTER_SPACE_VALUES_START: u32 =
    D3D12_DRIVER_RESERVED_REGISTER_SPACE_VALUES_START;
pub const DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: u32 =
    D3D12_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS;
pub const DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS: u32 =
    D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS;
pub const DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT;
pub const DS_INPUT_CONTROL_POINT_REGISTER_COUNT: u32 =
    D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COUNT;
pub const DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST: u32 =
    D3D12_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST;
pub const DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS: u32 =
    D3D12_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS;
pub const DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS: u32 =
    D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS;
pub const DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT;
pub const DS_INPUT_DOMAIN_POINT_REGISTER_COUNT: u32 =
    D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT;
pub const DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST: u32 =
    D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST;
pub const DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS: u32 =
    D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS;
pub const DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: u32 =
    D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS;
pub const DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT;
pub const DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT: u32 =
    D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT;
pub const DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: u32 =
    D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST;
pub const DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: u32 =
    D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS;
pub const DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: u32 =
    D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS;
pub const DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT;
pub const DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: u32 =
    D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT;
pub const DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: u32 =
    D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST;
pub const DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: u32 =
    D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS;
pub const DS_OUTPUT_REGISTER_COMPONENTS: u32 =
    D3D12_DS_OUTPUT_REGISTER_COMPONENTS;
pub const DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT;
pub const DS_OUTPUT_REGISTER_COUNT: u32 = D3D12_DS_OUTPUT_REGISTER_COUNT;
pub const FLOAT16_FUSED_TOLERANCE_IN_ULP: f64 =
    D3D12_FLOAT16_FUSED_TOLERANCE_IN_ULP;
pub const FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP: f64 =
    D3D12_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP;
pub const FLOAT_TO_SRGB_EXPONENT_DENOMINATOR: f64 =
    D3D12_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR;
pub const FLOAT_TO_SRGB_EXPONENT_NUMERATOR: f64 =
    D3D12_FLOAT_TO_SRGB_EXPONENT_NUMERATOR;
pub const FLOAT_TO_SRGB_OFFSET: f64 = D3D12_FLOAT_TO_SRGB_OFFSET;
pub const FLOAT_TO_SRGB_SCALE_1: f64 = D3D12_FLOAT_TO_SRGB_SCALE_1;
pub const FLOAT_TO_SRGB_SCALE_2: f64 = D3D12_FLOAT_TO_SRGB_SCALE_2;
pub const FLOAT_TO_SRGB_THRESHOLD: f64 = D3D12_FLOAT_TO_SRGB_THRESHOLD;
pub const FTOI_INSTRUCTION_MAX_INPUT: f64 = D3D12_FTOI_INSTRUCTION_MAX_INPUT;
pub const FTOI_INSTRUCTION_MIN_INPUT: f64 = D3D12_FTOI_INSTRUCTION_MIN_INPUT;
pub const FTOU_INSTRUCTION_MAX_INPUT: f64 = D3D12_FTOU_INSTRUCTION_MAX_INPUT;
pub const FTOU_INSTRUCTION_MIN_INPUT: f64 = D3D12_FTOU_INSTRUCTION_MIN_INPUT;
pub const GS_INPUT_INSTANCE_ID_READS_PER_INST: u32 =
    D3D12_GS_INPUT_INSTANCE_ID_READS_PER_INST;
pub const GS_INPUT_INSTANCE_ID_READ_PORTS: u32 =
    D3D12_GS_INPUT_INSTANCE_ID_READ_PORTS;
pub const GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS: u32 =
    D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS;
pub const GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT;
pub const GS_INPUT_INSTANCE_ID_REGISTER_COUNT: u32 =
    D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COUNT;
pub const GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS: u32 =
    D3D12_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS;
pub const GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT;
pub const GS_INPUT_PRIM_CONST_REGISTER_COUNT: u32 =
    D3D12_GS_INPUT_PRIM_CONST_REGISTER_COUNT;
pub const GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST: u32 =
    D3D12_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST;
pub const GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS: u32 =
    D3D12_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS;
pub const GS_INPUT_REGISTER_COMPONENTS: u32 =
    D3D12_GS_INPUT_REGISTER_COMPONENTS;
pub const GS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT;
pub const GS_INPUT_REGISTER_COUNT: u32 = D3D12_GS_INPUT_REGISTER_COUNT;
pub const GS_INPUT_REGISTER_READS_PER_INST: u32 =
    D3D12_GS_INPUT_REGISTER_READS_PER_INST;
pub const GS_INPUT_REGISTER_READ_PORTS: u32 =
    D3D12_GS_INPUT_REGISTER_READ_PORTS;
pub const GS_INPUT_REGISTER_VERTICES: u32 = D3D12_GS_INPUT_REGISTER_VERTICES;
pub const GS_MAX_INSTANCE_COUNT: u32 = D3D12_GS_MAX_INSTANCE_COUNT;
pub const GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES: u32 =
    D3D12_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES;
pub const GS_OUTPUT_ELEMENTS: u32 = D3D12_GS_OUTPUT_ELEMENTS;
pub const GS_OUTPUT_REGISTER_COMPONENTS: u32 =
    D3D12_GS_OUTPUT_REGISTER_COMPONENTS;
pub const GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT;
pub const GS_OUTPUT_REGISTER_COUNT: u32 = D3D12_GS_OUTPUT_REGISTER_COUNT;
pub const HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT: u32 =
    D3D12_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT;
pub const HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT: u32 =
    D3D12_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT;
pub const HS_CONTROL_POINT_REGISTER_COMPONENTS: u32 =
    D3D12_HS_CONTROL_POINT_REGISTER_COMPONENTS;
pub const HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT;
pub const HS_CONTROL_POINT_REGISTER_READS_PER_INST: u32 =
    D3D12_HS_CONTROL_POINT_REGISTER_READS_PER_INST;
pub const HS_CONTROL_POINT_REGISTER_READ_PORTS: u32 =
    D3D12_HS_CONTROL_POINT_REGISTER_READ_PORTS;
pub const HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND: u32 =
    D3D12_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND;
pub const HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS: u32 =
    D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS;
pub const HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT: u32 =
    D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT;
pub const HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST: u32 =
    D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST;
pub const HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS: u32 =
    D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS;
pub const HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS: u32 =
    D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS;
pub const HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT: u32 =
    D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT;
pub const HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST: u32 =
    D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST;
pub const HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS: u32 =
    D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS;
pub const HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: u32 =
    D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS;
pub const HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT;
pub const HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: u32 =
    D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT;
pub const HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: u32 =
    D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST;
pub const HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: u32 =
    D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS;
pub const HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND: u32 =
    D3D12_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND;
pub const HS_MAXTESSFACTOR_LOWER_BOUND: f64 =
    D3D12_HS_MAXTESSFACTOR_LOWER_BOUND;
pub const HS_MAXTESSFACTOR_UPPER_BOUND: f64 =
    D3D12_HS_MAXTESSFACTOR_UPPER_BOUND;
pub const HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: u32 =
    D3D12_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS;
pub const HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS: u32 =
    D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS;
pub const HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT: u32 =
    D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT;
pub const HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST: u32 =
    D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST;
pub const HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS: u32 =
    D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS;
pub const HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: u32 =
    D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS;
pub const HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT;
pub const HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT: u32 =
    D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT;
pub const HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: u32 =
    D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST;
pub const HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: u32 =
    D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS;
pub const HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS: u32 =
    D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS;
pub const IA_DEFAULT_INDEX_BUFFER_OFFSET: Bytes =
    Bytes(D3D12_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES as u64);
pub const IA_DEFAULT_PRIMITIVE_TOPOLOGY: u32 =
    D3D12_IA_DEFAULT_PRIMITIVE_TOPOLOGY;
pub const IA_DEFAULT_VERTEX_BUFFER_OFFSET: Bytes =
    Bytes(D3D12_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES as u64);
pub const IA_INDEX_INPUT_RESOURCE_SLOT_COUNT: u32 =
    D3D12_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT;
pub const IA_INSTANCE_ID_BIT_COUNT: u32 = D3D12_IA_INSTANCE_ID_BIT_COUNT;
pub const IA_INTEGER_ARITHMETIC_BIT_COUNT: u32 =
    D3D12_IA_INTEGER_ARITHMETIC_BIT_COUNT;
pub const IA_PATCH_MAX_CONTROL_POINT_COUNT: u32 =
    D3D12_IA_PATCH_MAX_CONTROL_POINT_COUNT;
pub const IA_PRIMITIVE_ID_BIT_COUNT: u32 = D3D12_IA_PRIMITIVE_ID_BIT_COUNT;
pub const IA_VERTEX_ID_BIT_COUNT: u32 = D3D12_IA_VERTEX_ID_BIT_COUNT;
pub const IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT: u32 =
    D3D12_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT;
pub const IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS: u32 =
    D3D12_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS;
pub const IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT: u32 =
    D3D12_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT;
pub const INTEGER_DIVIDE_BY_ZERO_QUOTIENT: u32 =
    D3D12_INTEGER_DIVIDE_BY_ZERO_QUOTIENT;
pub const INTEGER_DIVIDE_BY_ZERO_REMAINDER: u32 =
    D3D12_INTEGER_DIVIDE_BY_ZERO_REMAINDER;
pub const KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL: u32 =
    D3D12_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL;
pub const KEEP_UNORDERED_ACCESS_VIEWS: u32 = D3D12_KEEP_UNORDERED_ACCESS_VIEWS;
pub const LINEAR_GAMMA: f64 = D3D12_LINEAR_GAMMA;
pub const MAJOR_VERSION: u32 = D3D12_MAJOR_VERSION;
pub const MAX_BORDER_COLOR_COMPONENT: f64 = D3D12_MAX_BORDER_COLOR_COMPONENT;
pub const MAX_DEPTH: f64 = D3D12_MAX_DEPTH;
pub const MAX_LIVE_STATIC_SAMPLERS: u32 = D3D12_MAX_LIVE_STATIC_SAMPLERS;
pub const MAX_MAXANISOTROPY: u32 = D3D12_MAX_MAXANISOTROPY;
pub const MAX_MULTISAMPLE_SAMPLE_COUNT: u32 =
    D3D12_MAX_MULTISAMPLE_SAMPLE_COUNT;
pub const MAX_ROOT_COST: u32 = D3D12_MAX_ROOT_COST;
pub const MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_1: u32 =
    D3D12_MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_1;
pub const MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_2: u32 =
    D3D12_MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_2;
pub const MAX_SHADER_VISIBLE_SAMPLER_HEAP_SIZE: u32 =
    D3D12_MAX_SHADER_VISIBLE_SAMPLER_HEAP_SIZE;
pub const MAX_TEXTURE_DIMENSION_2_TO_EXP: u32 =
    D3D12_MAX_TEXTURE_DIMENSION_2_TO_EXP;
pub const MAX_VIEW_INSTANCE_COUNT: u32 = D3D12_MAX_VIEW_INSTANCE_COUNT;
pub const MINOR_VERSION: u32 = D3D12_MINOR_VERSION;
pub const MIN_BORDER_COLOR_COMPONENT: f64 = D3D12_MIN_BORDER_COLOR_COMPONENT;
pub const MIN_DEPTH: f64 = D3D12_MIN_DEPTH;
pub const MIN_MAXANISOTROPY: u32 = D3D12_MIN_MAXANISOTROPY;
pub const MIP_LOD_BIAS_MAX: f64 = D3D12_MIP_LOD_BIAS_MAX;
pub const MIP_LOD_BIAS_MIN: f64 = D3D12_MIP_LOD_BIAS_MIN;
pub const MIP_LOD_FRACTIONAL_BIT_COUNT: u32 =
    D3D12_MIP_LOD_FRACTIONAL_BIT_COUNT;
pub const MIP_LOD_RANGE_BIT_COUNT: u32 = D3D12_MIP_LOD_RANGE_BIT_COUNT;
pub const MULTISAMPLE_ANTIALIAS_LINE_WIDTH: f64 =
    D3D12_MULTISAMPLE_ANTIALIAS_LINE_WIDTH;
pub const NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT: u32 =
    D3D12_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT;
pub const OS_RESERVED_REGISTER_SPACE_VALUES_END: u32 =
    D3D12_OS_RESERVED_REGISTER_SPACE_VALUES_END;
pub const OS_RESERVED_REGISTER_SPACE_VALUES_START: u32 =
    D3D12_OS_RESERVED_REGISTER_SPACE_VALUES_START;
pub const PACKED_TILE: u32 = D3D12_PACKED_TILE;
pub const PIXEL_ADDRESS_RANGE_BIT_COUNT: u32 =
    D3D12_PIXEL_ADDRESS_RANGE_BIT_COUNT;
pub const PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT: u32 =
    D3D12_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT;
pub const PS_CS_UAV_REGISTER_COMPONENTS: u32 =
    D3D12_PS_CS_UAV_REGISTER_COMPONENTS;
pub const PS_CS_UAV_REGISTER_COUNT: u32 = D3D12_PS_CS_UAV_REGISTER_COUNT;
pub const PS_CS_UAV_REGISTER_READS_PER_INST: u32 =
    D3D12_PS_CS_UAV_REGISTER_READS_PER_INST;
pub const PS_CS_UAV_REGISTER_READ_PORTS: u32 =
    D3D12_PS_CS_UAV_REGISTER_READ_PORTS;
pub const PS_FRONTFACING_DEFAULT_VALUE: u32 =
    D3D12_PS_FRONTFACING_DEFAULT_VALUE;
pub const PS_FRONTFACING_FALSE_VALUE: u32 = D3D12_PS_FRONTFACING_FALSE_VALUE;
pub const PS_FRONTFACING_TRUE_VALUE: u32 = D3D12_PS_FRONTFACING_TRUE_VALUE;
pub const PS_INPUT_REGISTER_COMPONENTS: u32 =
    D3D12_PS_INPUT_REGISTER_COMPONENTS;
pub const PS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT;
pub const PS_INPUT_REGISTER_COUNT: u32 = D3D12_PS_INPUT_REGISTER_COUNT;
pub const PS_INPUT_REGISTER_READS_PER_INST: u32 =
    D3D12_PS_INPUT_REGISTER_READS_PER_INST;
pub const PS_INPUT_REGISTER_READ_PORTS: u32 =
    D3D12_PS_INPUT_REGISTER_READ_PORTS;
pub const PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT: f64 =
    D3D12_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT;
pub const PS_OUTPUT_DEPTH_REGISTER_COMPONENTS: u32 =
    D3D12_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS;
pub const PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT;
pub const PS_OUTPUT_DEPTH_REGISTER_COUNT: u32 =
    D3D12_PS_OUTPUT_DEPTH_REGISTER_COUNT;
pub const PS_OUTPUT_MASK_REGISTER_COMPONENTS: u32 =
    D3D12_PS_OUTPUT_MASK_REGISTER_COMPONENTS;
pub const PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT;
pub const PS_OUTPUT_MASK_REGISTER_COUNT: u32 =
    D3D12_PS_OUTPUT_MASK_REGISTER_COUNT;
pub const PS_OUTPUT_REGISTER_COMPONENTS: u32 =
    D3D12_PS_OUTPUT_REGISTER_COMPONENTS;
pub const PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT;
pub const PS_OUTPUT_REGISTER_COUNT: u32 = D3D12_PS_OUTPUT_REGISTER_COUNT;
pub const PS_PIXEL_CENTER_FRACTIONAL_COMPONENT: f64 =
    D3D12_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT;
pub const RAW_UAV_SRV_BYTE_ALIGNMENT: Bytes =
    Bytes(D3D12_RAW_UAV_SRV_BYTE_ALIGNMENT as u64);
pub const RAYTRACING_AABB_BYTE_ALIGNMENT: Bytes =
    Bytes(D3D12_RAYTRACING_AABB_BYTE_ALIGNMENT as u64);
pub const RAYTRACING_ACCELERATION_STRUCTURE_BYTE_ALIGNMENT: Bytes =
    Bytes(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BYTE_ALIGNMENT as u64);
pub const RAYTRACING_INSTANCE_DESCS_BYTE_ALIGNMENT: Bytes =
    Bytes(D3D12_RAYTRACING_INSTANCE_DESCS_BYTE_ALIGNMENT as u64);
pub const RAYTRACING_MAX_ATTRIBUTE_SIZE: Bytes =
    Bytes(D3D12_RAYTRACING_MAX_ATTRIBUTE_SIZE_IN_BYTES as u64);
pub const RAYTRACING_MAX_DECLARABLE_TRACE_RECURSION_DEPTH: u32 =
    D3D12_RAYTRACING_MAX_DECLARABLE_TRACE_RECURSION_DEPTH;
pub const RAYTRACING_MAX_RAY_GENERATION_SHADER_THREADS: u32 =
    D3D12_RAYTRACING_MAX_RAY_GENERATION_SHADER_THREADS;
pub const RAYTRACING_MAX_SHADER_RECORD_STRIDE: u32 =
    D3D12_RAYTRACING_MAX_SHADER_RECORD_STRIDE;
pub const RAYTRACING_SHADER_RECORD_BYTE_ALIGNMENT: Bytes =
    Bytes(D3D12_RAYTRACING_SHADER_RECORD_BYTE_ALIGNMENT as u64);
pub const RAYTRACING_SHADER_TABLE_BYTE_ALIGNMENT: Bytes =
    Bytes(D3D12_RAYTRACING_SHADER_TABLE_BYTE_ALIGNMENT as u64);
pub const RAYTRACING_TRANSFORM3X4_BYTE_ALIGNMENT: Bytes =
    Bytes(D3D12_RAYTRACING_TRANSFORM3X4_BYTE_ALIGNMENT as u64);
pub const REQ_BLEND_OBJECT_COUNT_PER_DEVICE: u32 =
    D3D12_REQ_BLEND_OBJECT_COUNT_PER_DEVICE;
pub const REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP: u32 =
    D3D12_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP;
pub const REQ_CONSTANT_BUFFER_ELEMENT_COUNT: u32 =
    D3D12_REQ_CONSTANT_BUFFER_ELEMENT_COUNT;
pub const REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE: u32 =
    D3D12_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE;
pub const REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: u32 =
    D3D12_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP;
pub const REQ_DRAW_VERTEX_COUNT_2_TO_EXP: u32 =
    D3D12_REQ_DRAW_VERTEX_COUNT_2_TO_EXP;
pub const REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION: u32 =
    D3D12_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION;
pub const REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT: u32 =
    D3D12_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT;
pub const REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT: u32 =
    D3D12_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT;
pub const REQ_MAXANISOTROPY: u32 = D3D12_REQ_MAXANISOTROPY;
pub const REQ_MIP_LEVELS: u32 = D3D12_REQ_MIP_LEVELS;
pub const REQ_MULTI_ELEMENT_STRUCTURE_SIZE: Bytes =
    Bytes(D3D12_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES as u64);
pub const REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE: u32 =
    D3D12_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE;
pub const REQ_RENDER_TO_BUFFER_WINDOW_WIDTH: u32 =
    D3D12_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH;
pub const REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM: u32 =
    D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM;
pub const REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM: f64 =
    D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM;
pub const REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM: u32 =
    D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM;
pub const REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP: u32 =
    D3D12_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP;
pub const REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE: u32 =
    D3D12_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE;
pub const REQ_SUBRESOURCES: u32 = D3D12_REQ_SUBRESOURCES;
pub const REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION: u32 =
    D3D12_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION;
pub const REQ_TEXTURE1D_U_DIMENSION: u32 = D3D12_REQ_TEXTURE1D_U_DIMENSION;
pub const REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION: u32 =
    D3D12_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION;
pub const REQ_TEXTURE2D_U_OR_V_DIMENSION: u32 =
    D3D12_REQ_TEXTURE2D_U_OR_V_DIMENSION;
pub const REQ_TEXTURE3D_U_V_OR_W_DIMENSION: u32 =
    D3D12_REQ_TEXTURE3D_U_V_OR_W_DIMENSION;
pub const REQ_TEXTURECUBE_DIMENSION: u32 = D3D12_REQ_TEXTURECUBE_DIMENSION;
pub const RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL: u32 =
    D3D12_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL;
pub const RESOURCE_BARRIER_ALL_SUBRESOURCES: u32 =
    D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES;
pub const RS_SET_SHADING_RATE_COMBINER_COUNT: u32 =
    D3D12_RS_SET_SHADING_RATE_COMBINER_COUNT;
pub const SDK_VERSION: u32 = D3D12_SDK_VERSION;
pub const SHADER_IDENTIFIER_SIZE: Bytes =
    Bytes(D3D12_SHADER_IDENTIFIER_SIZE_IN_BYTES as u64);
pub const SHADER_MAJOR_VERSION: u32 = D3D12_SHADER_MAJOR_VERSION;
pub const SHADER_MAX_INSTANCES: u32 = D3D12_SHADER_MAX_INSTANCES;
pub const SHADER_MAX_INTERFACES: u32 = D3D12_SHADER_MAX_INTERFACES;
pub const SHADER_MAX_INTERFACE_CALL_SITES: u32 =
    D3D12_SHADER_MAX_INTERFACE_CALL_SITES;
pub const SHADER_MAX_TYPES: u32 = D3D12_SHADER_MAX_TYPES;
pub const SHADER_MINOR_VERSION: u32 = D3D12_SHADER_MINOR_VERSION;
pub const SHIFT_INSTRUCTION_PAD_VALUE: u32 = D3D12_SHIFT_INSTRUCTION_PAD_VALUE;
pub const SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT: u32 =
    D3D12_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT;
pub const SIMULTANEOUS_RENDER_TARGET_COUNT: u32 =
    D3D12_SIMULTANEOUS_RENDER_TARGET_COUNT;
pub const SMALL_MSAA_RESOURCE_PLACEMENT_ALIGNMENT: Bytes =
    Bytes(D3D12_SMALL_MSAA_RESOURCE_PLACEMENT_ALIGNMENT as u64);
pub const SMALL_RESOURCE_PLACEMENT_ALIGNMENT: Bytes =
    Bytes(D3D12_SMALL_RESOURCE_PLACEMENT_ALIGNMENT as u64);
pub const SO_BUFFER_MAX_STRIDE: Bytes =
    Bytes(D3D12_SO_BUFFER_MAX_STRIDE_IN_BYTES as u64);
pub const SO_BUFFER_MAX_WRITE_WINDOW: Bytes =
    Bytes(D3D12_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES as u64);
pub const SO_BUFFER_SLOT_COUNT: u32 = D3D12_SO_BUFFER_SLOT_COUNT;
pub const SO_DDI_REGISTER_INDEX_DENOTING_GAP: u32 =
    D3D12_SO_DDI_REGISTER_INDEX_DENOTING_GAP;
pub const SO_NO_RASTERIZED_STREAM: u32 = D3D12_SO_NO_RASTERIZED_STREAM;
pub const SO_OUTPUT_COMPONENT_COUNT: u32 = D3D12_SO_OUTPUT_COMPONENT_COUNT;
pub const SO_STREAM_COUNT: u32 = D3D12_SO_STREAM_COUNT;
pub const SPEC_DATE_DAY: u32 = D3D12_SPEC_DATE_DAY;
pub const SPEC_DATE_MONTH: u32 = D3D12_SPEC_DATE_MONTH;
pub const SPEC_DATE_YEAR: u32 = D3D12_SPEC_DATE_YEAR;
pub const SPEC_VERSION: f64 = D3D12_SPEC_VERSION;
pub const SRGB_GAMMA: f64 = D3D12_SRGB_GAMMA;
pub const SRGB_TO_FLOAT_DENOMINATOR_1: f64 = D3D12_SRGB_TO_FLOAT_DENOMINATOR_1;
pub const SRGB_TO_FLOAT_DENOMINATOR_2: f64 = D3D12_SRGB_TO_FLOAT_DENOMINATOR_2;
pub const SRGB_TO_FLOAT_EXPONENT: f64 = D3D12_SRGB_TO_FLOAT_EXPONENT;
pub const SRGB_TO_FLOAT_OFFSET: f64 = D3D12_SRGB_TO_FLOAT_OFFSET;
pub const SRGB_TO_FLOAT_THRESHOLD: f64 = D3D12_SRGB_TO_FLOAT_THRESHOLD;
pub const SRGB_TO_FLOAT_TOLERANCE_IN_ULP: f64 =
    D3D12_SRGB_TO_FLOAT_TOLERANCE_IN_ULP;
pub const STANDARD_COMPONENT_BIT_COUNT: u32 =
    D3D12_STANDARD_COMPONENT_BIT_COUNT;
pub const STANDARD_COMPONENT_BIT_COUNT_DOUBLED: u32 =
    D3D12_STANDARD_COMPONENT_BIT_COUNT_DOUBLED;
pub const STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE: u32 =
    D3D12_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE;
pub const STANDARD_PIXEL_COMPONENT_COUNT: u32 =
    D3D12_STANDARD_PIXEL_COMPONENT_COUNT;
pub const STANDARD_PIXEL_ELEMENT_COUNT: u32 =
    D3D12_STANDARD_PIXEL_ELEMENT_COUNT;
pub const STANDARD_VECTOR_SIZE: u32 = D3D12_STANDARD_VECTOR_SIZE;
pub const STANDARD_VERTEX_ELEMENT_COUNT: u32 =
    D3D12_STANDARD_VERTEX_ELEMENT_COUNT;
pub const STANDARD_VERTEX_TOTAL_COMPONENT_COUNT: u32 =
    D3D12_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT;
pub const SUBPIXEL_FRACTIONAL_BIT_COUNT: u32 =
    D3D12_SUBPIXEL_FRACTIONAL_BIT_COUNT;
pub const SUBTEXEL_FRACTIONAL_BIT_COUNT: u32 =
    D3D12_SUBTEXEL_FRACTIONAL_BIT_COUNT;
pub const SYSTEM_RESERVED_REGISTER_SPACE_VALUES_END: u32 =
    D3D12_SYSTEM_RESERVED_REGISTER_SPACE_VALUES_END;
pub const SYSTEM_RESERVED_REGISTER_SPACE_VALUES_START: u32 =
    D3D12_SYSTEM_RESERVED_REGISTER_SPACE_VALUES_START;
pub const TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR: u32 =
    D3D12_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR;
pub const TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR: u32 =
    D3D12_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR;
pub const TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR: u32 =
    D3D12_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR;
pub const TESSELLATOR_MAX_TESSELLATION_FACTOR: u32 =
    D3D12_TESSELLATOR_MAX_TESSELLATION_FACTOR;
pub const TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR: u32 =
    D3D12_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR;
pub const TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR: u32 =
    D3D12_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR;
pub const TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR: u32 =
    D3D12_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR;
pub const TEXEL_ADDRESS_RANGE_BIT_COUNT: u32 =
    D3D12_TEXEL_ADDRESS_RANGE_BIT_COUNT;
pub const TEXTURE_DATA_PITCH_ALIGNMENT: Bytes =
    Bytes(D3D12_TEXTURE_DATA_PITCH_ALIGNMENT as u64);
pub const TEXTURE_DATA_PLACEMENT_ALIGNMENT: Bytes =
    Bytes(D3D12_TEXTURE_DATA_PLACEMENT_ALIGNMENT as u64);
pub const TILED_RESOURCE_TILE_SIZE: Bytes =
    Bytes(D3D12_TILED_RESOURCE_TILE_SIZE_IN_BYTES as u64);
pub const TRACKED_WORKLOAD_MAX_INSTANCES: u32 =
    D3D12_TRACKED_WORKLOAD_MAX_INSTANCES;
pub const UAV_COUNTER_PLACEMENT_ALIGNMENT: Bytes =
    Bytes(D3D12_UAV_COUNTER_PLACEMENT_ALIGNMENT as u64);
pub const UAV_SLOT_COUNT: u32 = D3D12_UAV_SLOT_COUNT;
pub const UNBOUND_MEMORY_ACCESS_RESULT: u32 =
    D3D12_UNBOUND_MEMORY_ACCESS_RESULT;
pub const VIDEO_DECODE_MAX_ARGUMENTS: u32 = D3D12_VIDEO_DECODE_MAX_ARGUMENTS;
pub const VIDEO_DECODE_MAX_HISTOGRAM_COMPONENTS: u32 =
    D3D12_VIDEO_DECODE_MAX_HISTOGRAM_COMPONENTS;
pub const VIDEO_DECODE_MIN_BITSTREAM_OFFSET_ALIGNMENT: Bytes =
    Bytes(D3D12_VIDEO_DECODE_MIN_BITSTREAM_OFFSET_ALIGNMENT as u64);
pub const VIDEO_DECODE_MIN_HISTOGRAM_OFFSET_ALIGNMENT: Bytes =
    Bytes(D3D12_VIDEO_DECODE_MIN_HISTOGRAM_OFFSET_ALIGNMENT as u64);
pub const VIDEO_PROCESS_MAX_FILTERS: u32 = D3D12_VIDEO_PROCESS_MAX_FILTERS;
pub const VIDEO_PROCESS_STEREO_VIEWS: u32 = D3D12_VIDEO_PROCESS_STEREO_VIEWS;
pub const VIEWPORT_AND_SCISSORRECT_MAX_INDEX: u32 =
    D3D12_VIEWPORT_AND_SCISSORRECT_MAX_INDEX;
pub const VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE: u32 =
    D3D12_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE;
pub const VIEWPORT_BOUNDS_MAX: u32 = D3D12_VIEWPORT_BOUNDS_MAX;
pub const VIEWPORT_BOUNDS_MIN: i32 = D3D12_VIEWPORT_BOUNDS_MIN;
pub const VS_INPUT_REGISTER_COMPONENTS: u32 =
    D3D12_VS_INPUT_REGISTER_COMPONENTS;
pub const VS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT;
pub const VS_INPUT_REGISTER_COUNT: u32 = D3D12_VS_INPUT_REGISTER_COUNT;
pub const VS_INPUT_REGISTER_READS_PER_INST: u32 =
    D3D12_VS_INPUT_REGISTER_READS_PER_INST;
pub const VS_INPUT_REGISTER_READ_PORTS: u32 =
    D3D12_VS_INPUT_REGISTER_READ_PORTS;
pub const VS_OUTPUT_REGISTER_COMPONENTS: u32 =
    D3D12_VS_OUTPUT_REGISTER_COMPONENTS;
pub const VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 =
    D3D12_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT;
pub const VS_OUTPUT_REGISTER_COUNT: u32 = D3D12_VS_OUTPUT_REGISTER_COUNT;
pub const WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT: u32 =
    D3D12_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT;
pub const WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: u32 =
    D3D12_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP;
pub const WHQL_DRAW_VERTEX_COUNT_2_TO_EXP: u32 =
    D3D12_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP;
pub const SHADER_COMPONENT_MAPPING_MASK: u32 =
    D3D12_SHADER_COMPONENT_MAPPING_MASK;
pub const SHADER_COMPONENT_MAPPING_SHIFT: u32 =
    D3D12_SHADER_COMPONENT_MAPPING_SHIFT;
pub const FILTER_REDUCTION_TYPE_MASK: u32 = D3D12_FILTER_REDUCTION_TYPE_MASK;
pub const FILTER_REDUCTION_TYPE_SHIFT: u32 = D3D12_FILTER_REDUCTION_TYPE_SHIFT;
pub const FILTER_TYPE_MASK: u32 = D3D12_FILTER_TYPE_MASK;
pub const MIN_FILTER_SHIFT: u32 = D3D12_MIN_FILTER_SHIFT;
pub const MAG_FILTER_SHIFT: u32 = D3D12_MAG_FILTER_SHIFT;
pub const MIP_FILTER_SHIFT: u32 = D3D12_MIP_FILTER_SHIFT;
pub const ANISOTROPIC_FILTERING_BIT: u32 = D3D12_ANISOTROPIC_FILTERING_BIT;
pub const INFO_QUEUE_DEFAULT_MESSAGE_COUNT_LIMIT: u32 =
    D3D12_INFO_QUEUE_DEFAULT_MESSAGE_COUNT_LIMIT;
pub const SHADING_RATE_X_AXIS_SHIFT: u32 = D3D12_SHADING_RATE_X_AXIS_SHIFT;
pub const SHADING_RATE_VALID_MASK: u32 = D3D12_SHADING_RATE_VALID_MASK;
pub const CPU_ACCESS_NONE: u32 = DXGI_CPU_ACCESS_NONE;
pub const CPU_ACCESS_DYNAMIC: u32 = DXGI_CPU_ACCESS_DYNAMIC;
pub const CPU_ACCESS_READ_WRITE: u32 = DXGI_CPU_ACCESS_READ_WRITE;
pub const CPU_ACCESS_SCRATCH: u32 = DXGI_CPU_ACCESS_SCRATCH;
pub const CPU_ACCESS_FIELD: u32 = DXGI_CPU_ACCESS_FIELD;
pub const USAGE_SHADER_INPUT: u32 = DXGI_USAGE_SHADER_INPUT;
pub const USAGE_RENDER_TARGET_OUTPUT: u32 = DXGI_USAGE_RENDER_TARGET_OUTPUT;
pub const USAGE_BACK_BUFFER: u32 = DXGI_USAGE_BACK_BUFFER;
pub const USAGE_SHARED: u32 = DXGI_USAGE_SHARED;
pub const USAGE_READ_ONLY: u32 = DXGI_USAGE_READ_ONLY;
pub const USAGE_DISCARD_ON_PRESENT: u32 = DXGI_USAGE_DISCARD_ON_PRESENT;
pub const USAGE_UNORDERED_ACCESS: u32 = DXGI_USAGE_UNORDERED_ACCESS;
pub const RESOURCE_PRIORITY_MINIMUM: u32 = DXGI_RESOURCE_PRIORITY_MINIMUM;
pub const RESOURCE_PRIORITY_LOW: u32 = DXGI_RESOURCE_PRIORITY_LOW;
pub const RESOURCE_PRIORITY_NORMAL: u32 = DXGI_RESOURCE_PRIORITY_NORMAL;
pub const RESOURCE_PRIORITY_HIGH: u32 = DXGI_RESOURCE_PRIORITY_HIGH;
pub const RESOURCE_PRIORITY_MAXIMUM: u32 = DXGI_RESOURCE_PRIORITY_MAXIMUM;
pub const MAP_READ: u32 = DXGI_MAP_READ;
pub const MAP_WRITE: u32 = DXGI_MAP_WRITE;
pub const MAP_DISCARD: u32 = DXGI_MAP_DISCARD;
pub const ENUM_MODES_INTERLACED: u32 = DXGI_ENUM_MODES_INTERLACED;
pub const ENUM_MODES_SCALING: u32 = DXGI_ENUM_MODES_SCALING;
pub const MAX_SWAP_CHAIN_BUFFERS: u32 = DXGI_MAX_SWAP_CHAIN_BUFFERS;
pub const PRESENT_TEST: u32 = DXGI_PRESENT_TEST;
pub const PRESENT_DO_NOT_SEQUENCE: u32 = DXGI_PRESENT_DO_NOT_SEQUENCE;
pub const PRESENT_RESTART: u32 = DXGI_PRESENT_RESTART;
pub const PRESENT_DO_NOT_WAIT: u32 = DXGI_PRESENT_DO_NOT_WAIT;
pub const PRESENT_STEREO_PREFER_RIGHT: u32 = DXGI_PRESENT_STEREO_PREFER_RIGHT;
pub const PRESENT_STEREO_TEMPORARY_MONO: u32 =
    DXGI_PRESENT_STEREO_TEMPORARY_MONO;
pub const PRESENT_RESTRICT_TO_OUTPUT: u32 = DXGI_PRESENT_RESTRICT_TO_OUTPUT;
pub const PRESENT_USE_DURATION: u32 = DXGI_PRESENT_USE_DURATION;
pub const PRESENT_ALLOW_TEARING: u32 = DXGI_PRESENT_ALLOW_TEARING;
pub const MWA_NO_WINDOW_CHANGES: u32 = DXGI_MWA_NO_WINDOW_CHANGES;
pub const MWA_NO_ALT_ENTER: u32 = DXGI_MWA_NO_ALT_ENTER;
pub const MWA_NO_PRINT_SCREEN: u32 = DXGI_MWA_NO_PRINT_SCREEN;
pub const MWA_VALID: u32 = DXGI_MWA_VALID;
pub const ENUM_MODES_STEREO: u32 = DXGI_ENUM_MODES_STEREO;
pub const ENUM_MODES_DISABLED_STEREO: u32 = DXGI_ENUM_MODES_DISABLED_STEREO;
pub const SHARED_RESOURCE_READ: u32 = DXGI_SHARED_RESOURCE_READ;
pub const SHARED_RESOURCE_WRITE: u32 = DXGI_SHARED_RESOURCE_WRITE;
pub const CREATE_FACTORY_DEBUG: u32 = DXGI_CREATE_FACTORY_DEBUG;
