# Rust
>panic: 程序因为错误而退出

## 四种基本标量类型
* 整数 
  * 可存储范围：$ -2^{n-1} \ 到 \ \  2^{n-1}-1$

    | 长度 | 有符号 | 无符号|
    | ---- | ----- | ----- |
    | 8    | i8     | u8   |
    | 16   | i16    | u16  |
    | 32   | i32(rust 默认)    | u32  |
    | 64   | i64    | u64  |
    | 128  | i128   | u128 |
    | arch | isize  | usize|

    整型字面值
    | 数字字面值 | 例子 |
    | ----------- | ----- |
    | Decimal | 98_222 |
    | Hex   | 0xff |
    | Octal | 0o77 |
    | Binary | 0b1111_0000 |
    | Byte(仅u8)  | b'A' |

  * 显式处理溢出 Wrapping

* 浮点
  * f32
  * f64(默认)
* 布尔 bool
* 字符 char 
  * 4字节(bytes)

## 复合类型
    1. 元组tuple
    2. 数组array
### tuple
 * 长度固定。
 * 结构 (x,y,...,n) =tuple
 * 取值：tuple.index

### 数组类型
 * 元素类型相同
 * 存储在栈中
 * 数组声明
  
        // 定义一个数组: 生命类型和数组长度 array_name:[type;len]
        let a:[i32;5] = [1,2,3,4,5]
        // 声明重复数据数组 array = [value;len] 
        let a = [5;3]  // [5,5,5]
