mod listener;
mod shutdown;
mod tcp;

use serde::Deserialize;
use std::fs::File;
use std::path::Path;
use tokio::sync::broadcast;

#[derive(Debug, Deserialize)]
struct Target {
    source: String,
    target: String,
}

#[derive(Debug, Deserialize)]
struct Config {
    tcp: Vec<Target>,
    // udp: Vec<Target>,
}

#[tokio::main]
async fn main() {
    let json_file_path = Path::new("./config.json");
    let file = File::open(json_file_path).expect("file not found");

    let (notify_shutdown, _) = broadcast::channel(1);

    let config: Config = serde_json::from_reader(file).expect("json parse error");
    for target in config.tcp {
        let listener = listener::Listener {
            shutdown: shutdown::Shutdown::new(notify_shutdown.subscribe()),
            source: target.source,
            target: target.target,
        };
        tokio::spawn(async move {
            if let Err(err) = tcp::start_tcp_listener(listener).await {
                println!("listener error: {}", err);
            }
        });
    }

    // _ = notify_shutdown.send(());
    loop {
        tokio::time::sleep(tokio::time::Duration::from_millis(1000 * 1000)).await;
    }
}
