use std::fmt::Debug;

use async_trait::async_trait;

pub trait Cache: CertCache + AccountCache {}

impl<T> Cache for T where T: CertCache + AccountCache {}

#[async_trait]
pub trait CertCache: Send + Sync {
    type EC: Debug;
    async fn load_cert(
        &self,
        domains: &[String],
        directory_url: &str,
    ) -> Result<Option<Vec<u8>>, Self::EC>;
    async fn store_cert(
        &self,
        domains: &[String],
        directory_url: &str,
        cert: &[u8],
    ) -> Result<(), Self::EC>;
}

#[async_trait]
pub trait AccountCache: Send + Sync {
    type EA: Debug;
    async fn load_account(&self, contact: &[String]) -> Result<Option<Vec<u8>>, Self::EA>;
    async fn store_account(&self, contact: &[String], account: &[u8]) -> Result<(), Self::EA>;
}
