



# Rustkernel
## Introduction

This kernel is made primarily for running code generated by VS Code Notebooks, it takes requests in the form of Rust code along with VS Code Notebook cell information. Data is retained in memory as long as the server is running, it's meant to be run locally as it uses raw TCP with no HTTP.

It's currently being used just for the [VS Code extension - Rustnote](https://marketplace.visualstudio.com/items?itemName=rustnote.rustnote).

This is still in the experimental stages, there are many features to be added.

## Links
- [API Docs](https://docs.rs/rustkernel/)
- [Crate](https://crates.io/crates/rustkernel)
- [Github](https://github.com/rustnote/rustkernel)

## Quick Start

To start a server on port `8787` and await requests:


```plaintext
cargo install rustkernel 
rustkernel
```



## Rust <-> VS Code communication
VS Code and Rust communicate over TCP with utf8, it doesn't follow http protocol as it's just running locally. There are no dependencies in the Rust of Nodejs code, this is to keep the extension size to minimum, and to minimize Rust compile time on first run.

## Currently working
- [x] - Take in Rust code, run it and return `stdout` / `stderr`
- [x] - Work with VS Code Notebook features e.g. cell order may change
- [x] If the file that notebook is being run from changes, reset state
- [ ] Extract functions from code and put them outside the `fn main` body
- [x] Move `use` outside the `fn main` body 
- [x] Add `use` required crates to `cargo.toml`
- [ ] Pre-cache most popular crates, run this as an opt in background process
- [ ] Environment variable to set the port
- [ ] Move to web framework for security features
- [ ] Use traits to allow for use from VS Code or from browser
- [ ] On request where last item is an expression, return debug/format output in nicely formatted html that can be rendered in VS Code or a browser.

## Bugs
- Calling a function that prints in another cell won't display it's output
