# rustify

<p align="center">
    <a href="https://github.com/jmgilman/rustify/actions/workflows/validate.yml">
        <img src="https://github.com/jmgilman/rustify/actions/workflows/validate.yml/badge.svg"/>
    </a>
    <a href="https://crates.io/crates/rustify">
        <img src="https://img.shields.io/crates/v/rustify">
    </a>
    <a href="https://docs.rs/rustify">
        <img src="https://img.shields.io/docsrs/rustify" />
    </a>
</p>

> A Rust library for interacting with HTTP API endpoints

Rustify is a small library written in Rust which eases the burden of
scaffolding HTTP APIs. It provides an `Endpoint` trait along with a macro helper
which allows templating various remote endpoints. Both asynchronous and
synchrounous clients are offered for executing requests against endpoints with
the option of implementing custom clients using the `Client` trait. 

Rustify provides support for serializing requests and deserializing responses in
JSON. Raw requests and responses in the form of bytes are also supported. The
library also contains many helpers for dealing with requests like support for
middleware and wrapping API responses.

## Installation

Add rustify as a depdendency to your cargo.toml:

```toml
[dependencies]
rustify = "0.4.0"
```

## Usage

The below example creates a `Test` endpoint that, when executed, will send a GET
request to `http://api.com/test/path` and expect an empty response:

```rust
use rustify::{Client, Endpoint};
use rustify_derive::Endpoint;
use serde::Serialize;

#[derive(Debug, Endpoint, Serialize)]
#[endpoint(path = "test/path")]
struct Test {}

let endpoint = Test {};
let client = Client::default("http://api.com");
let result = endpoint.exec(&client).await;

assert!(result.is_ok());
```

## Examples

You can find example usage in the [examples](examples) directory. They can 
be run with cargo:

```
cargo run --package rustify --example reqres1
cargo run --package rustify --example reqres2
```

Additionally, the [vaultrs](https://github.com/jmgilman/vaultrs) is a great
reference for a crate which relies heavily on rustify.

## Features
The following features are available for this crate:

* `blocking`: Enables the blocking variants of `Client`s as well as the blocking
   `exec()` functions in `Endpoint`s. 

## Error Handling

All errors generated by this crate are wrapped in the `ClientError` enum
provided by the crate.

## Testing

See the the [tests](tests) directory for tests. Run tests with `cargo test`. 

## Contributing

1. Fork it (https://github.com/jmgilman/rustify/fork)
2. Create your feature branch (git checkout -b feature/fooBar)
3. Commit your changes (git commit -am 'Add some fooBar')
4. Push to the branch (git push origin feature/fooBar)
5. Create a new Pull Request