#![allow(dead_code, unused_imports)]

use std::io::empty;

use rustfuck::frontend::int_program::IntProgram;
use rustfuck::program::exec::{EofMode, ExecContext};
use rustfuck::program::BfProgram;

const BF_SRC: &str = include_str!("./bitwidth.bf");
const EXPECTED: &str = "Hello World! 255\n";

#[test]
fn bitwidth() {
    let program = BfProgram::parse_from_src(BF_SRC.as_bytes()).unwrap();
    let mut out = Vec::new();

    program.execute(&mut out, empty(), EofMode::NoChange).unwrap();
    assert_eq!(out, EXPECTED.as_bytes());
}
