



#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub struct BasicBlock {
    pub(super) instructions: Vec<Instruction>,
}
impl BasicBlock {
    pub fn new() -> BasicBlock {
        BasicBlock {
            instructions: Vec::new(),
        }
    }
}

#[derive(Copy, Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub struct BasicBlockRef(pub(super) usize);
impl BasicBlockRef {
    pub fn index(&self) -> usize {
        self.0
    }
}

#[derive(Copy, Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Instruction {
    BeginLoop { body: BasicBlockRef, end: BasicBlockRef },
    EndLoop { origin: BasicBlockRef },

    Increment(u8),
    Decrement(u8),
    Set(u8),
    Next(usize),
    Previous(usize),
    Output,
    Input,
}
#[derive(Copy, Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub struct InstructionRef(pub(super) BasicBlockRef, pub(super) usize);
impl InstructionRef {
    pub fn block(&self) -> BasicBlockRef {
        self.0
    }
    pub fn index(&self) -> usize {
        self.1
    }
}
