use std::io::empty;
use rustfuck::program::{EofMode, BfProgram};

const BF_SRC: &str = include_str!("./bitwidth.bf");
const EXPECTED: &str = "Hello World! 255\n";

#[test]
fn bitwidth() {
    let program = BfProgram::parse_from_src(BF_SRC).unwrap();

    let mut out = Vec::new();
    program.execute(&mut out, empty(), EofMode::Max).unwrap();

    assert_eq!(out, EXPECTED.as_bytes());
}
