#![feature(test)]
extern crate test;

pub mod bytes_helper;

#[cfg(feature = "file")]
pub mod file;

#[cfg(feature = "serde")]
pub mod serde_type;

#[cfg(feature = "tcp")]
pub mod tcp;

// #[derive(Debug)]
// pub enum Error {
//     ArgsMissing,
//     NotDir,
//     FileNotFound,
//     DataNotWritten,
//     NotInitiated,
//     BytesNotParsed,
// }

use thiserror::Error;

#[derive(Error, Debug)]
pub enum Error {
    #[error(transparent)]
    Io(#[from] std::io::Error),
    #[error("invalid value (expected {expected:?}, found {found:?})")]
    Invalid { expected: String, found: String },
    #[error("{0}")]
    Custom(&'static str),
}

pub type Result<T> = std::result::Result<T, Error>;
