///
pub const INITSQL : &str = "

CREATE FN [sys].[ClearTable](t int) AS 
BEGIN 
  EXECUTE( 'DELETE FROM ' | sys.TableName(t) | ' WHERE true' )
END
GO
CREATE FN [sys].[ColName]( table int, colId int ) RETURNS string AS
BEGIN
  DECLARE i int
  SET i = 0
  FOR result = Name FROM sys.Column WHERE Table = table
  BEGIN
    IF i = colId RETURN result
    SET i = i + 1
  END
  RETURN '?bad colId?'  
END
GO
CREATE FN [sys].[ColNames]( table int ) RETURNS string AS
BEGIN
  DECLARE col string
  SET result = '(Id'
  FOR col = Name FROM sys.Column WHERE Table = table
    SET result |= ',' | sys.QuoteName(col)
  RETURN result | ')'
END
GO
CREATE FN [sys].[ColValues]( table int ) RETURNS string AS
BEGIN
  DECLARE col string
  SET result = 'Id'
  FOR col = CASE 
    WHEN Type % 8 = 2 THEN 'sys.SingleQuote(' | Name | ')'
    ELSE Name
  END
  FROM sys.Column WHERE Table = table
    SET result |= '|'',''|' | col
  RETURN result
END
GO
CREATE FN [sys].[Cols]( table int ) RETURNS string AS
BEGIN
  DECLARE col string, list string
  FOR col = sys.QuoteName(Name) | ' ' | sys.TypeName(Type)
  FROM sys.Column WHERE Table = table
    SET list |= CASE WHEN  list = '' THEN col ELSE ',' | col END
  RETURN '(' | list | ')'
END
GO
CREATE FN [sys].[Dot]( schema string, name string ) RETURNS string AS
BEGIN
  RETURN sys.QuoteName( schema ) | '.' | sys.QuoteName( name )
END
GO
CREATE FN [sys].[DropColumn]( t int, cname string ) AS 
BEGIN 
  DELETE FROM sys.Column WHERE Table = t AND Name = cname

  /* Could delete browse column info as well (todo)*/
END
GO
CREATE FN [sys].[DropIndex]( ix int ) AS
BEGIN
  /* Note: this should not be called directly, instead use DROP INDEX statement */
  DELETE FROM sys.IndexColumn WHERE Index = ix
  DELETE FROM sys.Index WHERE Id = ix
END
GO
CREATE FN [sys].[DropSchema]( sid int ) AS
/* Note: this should not be called directly, instead use DROP SCHEMA statement */
BEGIN
  DECLARE schema string, name string
  SET schema = Name FROM sys.Schema WHERE Id = sid
  FOR name = Name FROM sys.Function WHERE Schema = sid EXECUTE( 'DROP FN ' | sys.Dot(schema,name) )
  FOR name = Name FROM sys.Table WHERE Schema = sid EXECUTE( 'DROP TABLE ' | sys.Dot(schema,name) )
  DELETE FROM sys.Schema WHERE Id = sid
END
GO
CREATE FN [sys].[DropTable]( t int ) AS 
/* Note: this should not be called directly, instead use DROP TABLE statement */
BEGIN
  /* Delete the rows */
  EXECUTE( 'DELETE FROM ' | sys.TableName(t) | ' WHERE true' )

  DECLARE id int
  /* Delete the Index data */
  FOR id = Id FROM sys.Index WHERE Table = t
  BEGIN
    DELETE FROM sys.IndexColumn WHERE Index = id
  END
  DELETE FROM sys.Index WHERE Table = t
   /* Delete the column data */
  FOR id = Id FROM sys.Column WHERE Table = t
  BEGIN
    DELETE FROM browse.Column WHERE Id = id
  END
  /* Delete other data */
  DELETE FROM browse.Table WHERE Id = t
  DELETE FROM sys.Column WHERE Table = t
  DELETE FROM sys.Table WHERE Id = t
END
GO
CREATE FN [sys].[IndexCols]( index int ) RETURNS string AS
BEGIN
  DECLARE table int, list string, col string
  SET table = Table FROM sys.Index WHERE Id = index
  FOR col = sys.QuoteName(sys.ColName( table, ColId )) FROM sys.IndexColumn WHERE Index = index
    SET list |= CASE WHEN  list = '' THEN col ELSE ',' | col END
  RETURN '(' | list | ')'
END
GO
CREATE FN [sys].[IndexName]( index int ) RETURNS string AS
BEGIN
  SET result = sys.QuoteName(Name) FROM sys.Index WHERE Id = index
END
GO
CREATE FN [sys].[QuoteName]( s string ) RETURNS string AS
BEGIN
  RETURN '[' | REPLACE( s, ']', ']]' ) | ']'
END
GO
CREATE FN [sys].[SchemaName]( schema int) RETURNS string AS 
BEGIN 
  SET result = Name FROM sys.Schema WHERE Id = schema
END
GO
CREATE FN [sys].[ScriptBrowse]( t int ) AS
BEGIN
  -- Script browse information for Table t.
  -- Looks up Table and Column Id values (tid,cid) by name in case they change.
  DECLARE sid int, tname string, sname string
  SET sid = Schema, tname = Name FROM sys.Table WHERE Id = t
  SET sname = Name FROM sys.Schema WHERE Id = sid

  SELECT '
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = ' | sys.SingleQuote(sname) | '
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = ' | sys.SingleQuote(tname) 
SELECT '
INSERT INTO browse.Table(Id,NameFunction, SelectFunction, DefaultOrder, Title, Description, Role) 
VALUES (tid,'
    | sys.SingleQuote(NameFunction) |','|sys.SingleQuote(SelectFunction) 
    | ',' | sys.SingleQuote(DefaultOrder) | ',' | sys.SingleQuote(Title) | ',' 
    | sys.SingleQuote(Description) | ',' | Role | ')'
  FROM browse.Table WHERE Id = t

  DECLARE cid int, cname string
  FOR cid=Id, cname=Name FROM sys.Column WHERE Table = t
  BEGIN
    SELECT '
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = ' | sys.SingleQuote(cname) | '
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, '
      |Position|','|sys.SingleQuote(Label)
      |','|sys.SingleQuote(Description)
      |','|RefersTo|','|sys.SingleQuote(Default)|','|InputCols|','|sys.SingleQuote(InputFunction)
      |','|InputRows|','|Style|','|sys.SingleQuote(DisplayFunction)|','|sys.SingleQuote(ParseFunction)|')'
    FROM browse.Column WHERE Id = cid
  END
  SELECT '
GO'
END
GO
CREATE FN [sys].[ScriptSchema]( s int ) AS
BEGIN
  DECLARE sname string SET sname = sys.SchemaName(s)

  /* Create the schema, tables, indexes */
  
  IF sname != 'sys'
  BEGIN
    SELECT '
--############################################
CREATE SCHEMA ' | sys.QuoteName( sname )

    DECLARE t int
    FOR t = Id FROM sys.Table WHERE Schema = s ORDER BY Name
    BEGIN
      EXEC sys.ScriptTable(t)
    END
  END

  /******* Script functions *******/

  SELECT '
CREATE FN ' | sys.Dot( sname,Name) | Def | '
GO' 
  FROM sys.Function  WHERE Schema = s ORDER BY Name

  /******* Script Data *******/

  IF sname != 'sys' AND sname != 'browse'
  BEGIN
    DECLARE ins string, val string
    FOR ins = '
INSERT INTO ' | sys.TableName(Id) | sys.ColNames(Id) | ' VALUES 
',
        val = 'SELECT ''(''|' | sys.ColValues(Id) | '|'')
''' | ' FROM ' | sys.TableName(Id)
    FROM sys.Table WHERE Schema = s ORDER BY Name
    BEGIN
      SELECT ins
      EXECUTE( val )
      SELECT 'GO
'
    END
  END
END
GO
CREATE FN [sys].[ScriptSchemaBrowse]( s int ) AS
BEGIN
  DECLARE t int
  FOR t = Id FROM sys.Table WHERE Schema = s ORDER BY Name
  BEGIN
    EXEC sys.ScriptBrowse(t)
  END
END
GO
CREATE FN [sys].[ScriptTable]( t int ) AS
BEGIN
  SELECT '
CREATE TABLE ' | sys.TableName(t) | sys.Cols(t) | ' 
GO'
  DECLARE ix int, name string
  FOR ix = Id, name = Name FROM sys.Index WHERE Table = t
  BEGIN
    SELECT '
CREATE INDEX ' | sys.QuoteName(name) | ' ON ' | sys.TableName(t) | sys.IndexCols(ix) | '
GO'
  END
END
GO
CREATE FN [sys].[SingleQuote]( s string ) RETURNS string AS
BEGIN
  RETURN '''' | REPLACE( s, '''', '''''' ) | ''''
END
GO
CREATE FN [sys].[TableName]( table int ) RETURNS string AS
BEGIN
  DECLARE schema int, name string
  SET schema = Schema, name = Name FROM sys.Table WHERE Id = table
  IF name = '' RETURN ''
  SET result = sys.Dot( Name, name ) FROM sys.Schema WHERE Id = schema
END
GO
CREATE FN [sys].[TypeName]( t int ) RETURNS string AS 
BEGIN 
  DECLARE p int
  SET p = t / 8
  RETURN CASE 
    WHEN t = 0 THEN 'none'
    WHEN t = 13 THEN 'bool'
    WHEN t = 36 THEN 'float' 
    WHEN t = 68 THEN 'double'
    WHEN t = 67 THEN 'int'
    WHEN t = 129 THEN 'binary'
    WHEN t = 130 THEN 'string'
    ELSE 
    CASE 
       WHEN t % 8 = 1 THEN 'binary(' | (p-1) | ')'
       WHEN t % 8 = 2 THEN 'string(' | (p-1) | ')'
       WHEN t % 8 = 3 THEN 'int(' | p | ')'
       ELSE '???'
    END
  END
END
GO
--############################################
CREATE SCHEMA [date]
CREATE FN [date].[DaysToString]( date int ) RETURNS string AS
BEGIN
  RETURN date.WeekDayToString( 1 + (date+5) % 7 ) | ' ' | date.YearMonthDayToString( date.DaysToYearMonthDay( date ) )
END
GO
CREATE FN [date].[DaysToYearDay]( days int ) RETURNS int AS
BEGIN
  -- Given a date represented by the number of days since 1 Jan 0000
  -- calculate a date in Year/Day representation stored as
  -- year * 512 + day where day is 1..366, the day in the year.
  
  DECLARE year int, day int, cycle int
  -- 146097 is the number of the days in a 400 year cycle ( 400 * 365 + 97 leap years )
  SET cycle = days / 146097
  SET days = days - 146097 * cycle -- Same as days % 146097
  SET year = days / 365
  SET day = days - year * 365 -- Same as days % 365
  -- Need to adjust day to allow for leap years.
  -- Leap years are 0, 4, 8, 12 ... 96, not 100, 104 ... not 200... not 300, 400, 404 ... not 500.
  -- Adjustment as function of y is 0 => 0, 1 => 1, 2 =>1, 3 => 1, 4 => 1, 5 => 2 ..
  SET day = day - ( year + 3 ) / 4 + ( year + 99 ) / 100 - ( year + 399 ) / 400
  
  IF day < 0
  BEGIN
    SET year = year - 1
    SET day = day + CASE WHEN date.IsLeapYear( year ) THEN 366 ELSE 365 END
  END
  RETURN 512 * ( cycle * 400 + year ) + day + 1
END
GO
CREATE FN [date].[DaysToYearMonthDay]( days int ) RETURNS int AS
BEGIN
  RETURN date.YearDayToYearMonthDay( date.DaysToYearDay( days ) )
END
GO
CREATE FN [date].[IsLeapYear]( y int ) RETURNS bool AS
BEGIN
  RETURN y % 4 = 0 AND ( y % 100 != 0 OR y % 400 = 0 )
END
GO
CREATE FN [date].[MicroSecToString](micro int) RETURNS string AS
BEGIN
  DECLARE day int, sec int, min int, hour int
  SET sec = micro / 1000000
  SET day = sec / 86400 + 366 -- 86400 = 24 * 60 * 60, seconds in a day.
  SET sec = sec % 86400
  SET min = sec / 60
  SET sec = sec % 60
  SET hour = min / 60
  SET min = min % 60
  RETURN date.DaysToString(  day ) | ' ' | hour | ':' | min | ':' | sec
END
GO
CREATE FN [date].[MonthToString]( m int ) RETURNS string AS
BEGIN
  RETURN CASE
    WHEN m = 1 THEN 'Jan'
    WHEN m = 2 THEN 'Feb'
    WHEN m = 3 THEN 'Mar'
    WHEN m = 4 THEN 'Apr'
    WHEN m = 5 THEN 'May'
    WHEN m = 6 THEN 'Jun'
    WHEN m = 7 THEN 'Jul'
    WHEN m = 8 THEN 'Aug'
    WHEN m = 9 THEN 'Sep'
    WHEN m = 10 THEN 'Oct'
    WHEN m = 11 THEN 'Nov'
    WHEN m = 12 THEN 'Dec'
    ELSE '???'
  END
END
GO
CREATE FN [date].[NowString]() RETURNS string AS
BEGIN
  RETURN date.MicroSecToString( date.Ticks() )
END
GO
CREATE FN [date].[StringToDays]( s string ) RETURNS int AS
BEGIN
  -- Typical input is 'Feb 2 2020'
  DECLARE ms string, month int
  SET ms = SUBSTRING( s, 1, 3 )
  SET month = CASE 
    WHEN ms = 'Jan' THEN 1
    WHEN ms = 'Feb' THEN 2
    WHEN ms = 'Mar' THEN 3
    WHEN ms = 'Apr' THEN 4
    WHEN ms = 'May' THEN 5
    WHEN ms = 'Jun' THEN 6
    WHEN ms = 'Jul' THEN 7
    WHEN ms = 'Aug' THEN 8
    WHEN ms = 'Sep' THEN 9
    WHEN ms = 'Oct' THEN 10
    WHEN ms = 'Nov' THEN 11
    WHEN ms = 'Dec' THEN 12
    ELSE 0
  END  
  IF month = 0 THROW 'Unknown month parsing date ' | htm.Attr(ms)
  DECLARE six int -- Index of first space
  SET six = 4
  WHILE true
  BEGIN
    IF six > LEN(s) BREAK
    IF SUBSTRING( s, six, 1 ) = ' ' BREAK
    SET six = six + 1
  END
  DECLARE ssix int
  SET ssix = six+1
  WHILE true
  BEGIN
    IF ssix > LEN(s) BREAK
    IF SUBSTRING( s, ssix, 1 ) = ' ' BREAK
    SET ssix = ssix + 1
  END
 
  DECLARE day int, year int
  SET day = PARSEINT( SUBSTRING( s, six+1, ssix - six - 1) )
  IF day < 1 OR day > 31 THROW 'Day must be 1..31 parsing date ' | htm.Attr(''|day)
  SET year = PARSEINT( SUBSTRING( s, ssix + 1, LEN(s) ) )
  RETURN date.YearMonthDayToDays( date.YearMonthDay( year, month, day ) )
END
GO
CREATE FN [date].[StringToYearMonthDay]( s string ) RETURNS int AS
BEGIN
  RETURN date.DaysToYearMonthDay( date.StringToDays( s ) )
END
GO
CREATE FN [date].[Test]( y int, m int, d int, n int ) AS 
BEGIN
  DECLARE ymd int, days int
  SET ymd = date.YearMonthDay( y, m, d )
  SET days = date.YearMonthDayToDays( ymd )
  DECLARE i int
  SET i = 0
  WHILE i < n
  BEGIN
    SELECT '<br>' | date.DaysToString( days + i )
    SET i = i + 1
  END
END
GO
CREATE FN [date].[TestRoundTrip]() AS
BEGIN
  DECLARE day int
  SET day = 0
  WHILE day < 1000000
  BEGIN
    IF date.YearMonthDayToDays( date.DaysToYearMonthDay(day) ) != day
    BEGIN
      SELECT 'Test failed day = ' | day
      BREAK
    END
    SET day = day + 1
  END
  SELECT 'Finished test day=' | day | ' date=' | date.DaysToString(day)
END
GO
CREATE FN [date].[Ticks]() RETURNS int AS
BEGIN
  -- Microseconds since 1 Jan 0000
  RETURN GLOBAL(0) + 62135596800000000 /* 719162 * 24 * 3600 * 1000000 */
END
GO
CREATE FN [date].[Today]() RETURNS int AS
BEGIN
  DECLARE sec int, day int
  SET sec = date.Ticks() / 1000000
  SET day = sec / 86400 + 366
  RETURN day
END
GO
CREATE FN [date].[WeekDayToString]( wd int ) RETURNS string AS
BEGIN
  RETURN CASE
    WHEN wd = 1 THEN 'Mon'
    WHEN wd = 2 THEN 'Tue'
    WHEN wd = 3 THEN 'Wed'
    WHEN wd = 4 THEN 'Thu'
    WHEN wd = 5 THEN 'Fri'
    WHEN wd = 6 THEN 'Sat'
    WHEN wd = 7 THEN 'Sun'
    ELSE '?weekday?'
    END
END
GO
CREATE FN [date].[YearDay]( year int, day int ) RETURNS int AS
BEGIN
  RETURN year * 512 + day
END
GO
CREATE FN [date].[YearDayToDays]( yd int ) RETURNS int AS
BEGIN
  -- Given a date in Year/Day representation stored as y * 512 + d where 1 <= d <= 366 ( so d is day in year )
  -- returns the number of days since \"day zero\" (1 Jan 0000)
  -- using the Gregorian calendar where days divisible by 4 are leap years, except if divisible by 100, except if divisible by 400.
  DECLARE y int, d int, cycle int
  -- Extract y and d from yd.
  SET y = yd / 512, d = yd % 512 - 1
  SET cycle = y / 400, y = y % 400 -- The Gregorian calendar repeats every 400 years.
 
  -- Result days come from cycles, from years having at least 365 days, from leap years and finally d.
  -- 146097 is the number of the days in a 400 year cycle ( 400 * 365 + 97 leap years ).
  RETURN cycle * 146097 
    + y * 365 
    + ( y + 3 ) / 4 - ( y + 99 ) / 100 + ( y + 399 ) / 400
    + d
END
GO
CREATE FN [date].[YearDayToString]( yd int ) RETURNS string AS
BEGIN
   RETURN date.YearMonthDayToString( date.YearDayToYearMonthDay( yd ) )  
END
GO
CREATE FN [date].[YearDayToYearMonthDay]( yd int ) RETURNS int AS
BEGIN
  DECLARE y int, d int, leap bool, fdm int, m int, dim int
  SET y = yd / 512
  SET d = yd % 512 - 1
  SET leap = date.IsLeapYear( y )
  -- Jan = 0..30, Feb = 0..27 or 0..28  
  IF NOT leap AND d >= 59 SET d = d + 1
  SET fdm = CASE 
    WHEN d < 31 THEN 0 -- Jan
    WHEN d < 60 THEN 31 -- Feb
    WHEN d < 91 THEN 60 -- Mar
    WHEN d < 121 THEN 91 -- Apr
    WHEN d < 152 THEN 121 -- May
    WHEN d < 182 THEN 152 -- Jun
    WHEN d < 213 THEN 182 -- Jul
    WHEN d < 244 THEN 213 -- Aug
    WHEN d < 274 THEN 244 -- Sep
    WHEN d < 305 THEN 274 -- Oct
    WHEN d < 335 THEN 305 -- Nov
    ELSE 335 -- Dec
    END
  SET dim = d - fdm
  SET m = ( d - dim + 28 ) / 31
  RETURN date.YearMonthDay( y, m+1, dim+1 )
END
GO
CREATE FN [date].[YearMonthDay]( year int, month int, day int ) RETURNS int AS
BEGIN
  RETURN year * 512 + month * 32 + day
END
GO
CREATE FN [date].[YearMonthDayToDays]( ymd int ) RETURNS int AS
BEGIN
  RETURN date.YearDayToDays( date.YearMonthDayToYearDay( ymd ) )
END
GO
CREATE FN [date].[YearMonthDayToString]( ymd int ) RETURNS string AS
BEGIN
  DECLARE y int, m int, d int
  SET d = ymd % 32
  SET m = ymd / 32
  SET y = m / 16
  SET m = m % 16
  RETURN date.MonthToString(m) | ' ' | d | ' ' |  y
END
GO
CREATE FN [date].[YearMonthDayToYearDay]( ymd int ) RETURNS int AS
BEGIN
  DECLARE y int, m int, d int
  -- Extract y, m, d from ymd
  SET d = ymd % 32, m = ymd / 32  
  SET y = m / 16, m = m % 16
  -- Incorporate m into d ( assuming Feb has 29 days ).
  SET d = d + CASE
    WHEN m = 1 THEN 0 -- Jan
    WHEN m = 2 THEN 31 -- Feb
    WHEN m = 3 THEN 60 -- Mar
    WHEN m = 4 THEN 91 -- Apr
    WHEN m = 5 THEN 121 -- May
    WHEN m = 6 THEN 152 -- Jun
    WHEN m = 7 THEN 182 -- Jul
    WHEN m = 8 THEN 213 -- Aug
    WHEN m = 9 THEN 244 -- Sep
    WHEN m = 10 THEN 274 -- Oct
    WHEN m = 11 THEN 305 -- Nov
    ELSE 335 -- Dec
    END
  -- Allow for Feb being only 28 days in a non-leap-year.
  IF m >= 3 AND NOT date.IsLeapYear( y ) SET d = d - 1
  RETURN date.YearDay( y, d )
END
GO
--############################################
CREATE SCHEMA [htm]
CREATE FN [htm].[Attr]( s string ) RETURNS string AS
BEGIN
  SET s = REPLACE( s, '&', '&amp;' )
  SET s = REPLACE( s, '\"', '&quot;' )
  RETURN '\"' | s | '\"'
END
GO
CREATE FN [htm].[Encode]( s string ) RETURNS string AS
BEGIN
  SET s = REPLACE( s,'&', '&amp;' )
  SET s = REPLACE( s, '<', '&lt;' )
  RETURN s
END
GO
--############################################
CREATE SCHEMA [web]
CREATE TABLE [web].[File]([Path] string,[ContentType] string,[ContentLength] int,[Content] binary) 
GO
CREATE INDEX [ByPath] ON [web].[File]([Path])
GO
CREATE FN [web].[Cookie]( name string ) RETURNS string AS
BEGIN
  RETURN ARG( 3, name )
END
GO
CREATE FN [web].[Form]( name string ) RETURNS string AS
BEGIN
  RETURN ARG( 2, name )
END
GO
CREATE FN [web].[Head]( title string ) AS 
BEGIN 
  EXEC web.SetContentType( 'text/html;charset=utf-8' )
  SELECT '<html>
<head>
<meta http-equiv=\"Content-type\" content=\"text/html;charset=UTF-8\">
<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">
<title>' | title | '</title>
<style>
   body{font-family:sans-serif;}
   body{ max-width:60em; }
</style>
</head>
<body>
<div style=\"color:white;background:lightblue;padding:4px;\">
<a href=/Menu>Menu</a> 
| <a target=_blank href=/Menu>New Window</a>
| <a href=Manual>Manual</a>
| <a target=_blank href=\"EditFunc?s=handler&n=' | web.Path() | '\">Code</a> ' | date.NowString() | ' UTC</div>'
END
GO
CREATE FN [web].[Main]() AS 
BEGIN 
  DECLARE path string SET path = web.Path()
  DECLARE ok string SET ok = Name FROM sys.Function WHERE Name = path AND Schema = 6
  IF ok = path
  BEGIN
    EXECUTE( 'EXEC ' | sys.Dot('handler',path) | '()' )
    DECLARE ex string
    SET ex = EXCEPTION()
    IF ex != ''
    BEGIN
      EXEC web.Head( 'Error' )
      SELECT '<h1>Error</h1><pre>'
      SELECT htm.Encode( ex )
      SELECT '</pre>'
      EXEC web.Trailer()
    END
  END
  ELSE
  BEGIN
    DECLARE ct string, content binary
    SET ok = Path, ct = ContentType, content = Content FROM web.File WHERE Path = path
    IF ok = path
    BEGIN
      EXEC web.SendBinary( ct, content )
    END    
    ELSE
    BEGIN
      EXEC web.Head( 'Unknown page')
      SELECT 'Unknown page Path=' | path
      EXEC web.Trailer()
    END
  END
END
GO
CREATE FN [web].[Path]() RETURNS string AS
BEGIN
  RETURN ARG(0,'')
END
GO
CREATE FN [web].[Query]( name string ) RETURNS string AS
BEGIN
  RETURN ARG( 1, name )
END
GO
CREATE FN [web].[Redirect]( url string ) AS
BEGIN
  DECLARE x int
  SET x = HEADER( 'location', url )
  SET x = STATUSCODE( 303 )
END
GO
CREATE FN [web].[SendBinary]( contenttype string, content binary ) AS
BEGIN
  EXEC web.SetContentType( contenttype )
  SELECT content
END
GO
CREATE FN [web].[SetContentType]( ct string ) AS
BEGIN
  DECLARE x int
  SET x = HEADER( 'contenttype', ct )
END
GO
CREATE FN [web].[SetCookie]( name string, value string, expires string ) AS
BEGIN
  /* Expires can be either in seconds e.g. Max-Age=1000000000
     or Expires=Wed, 09 Jun 2021 10:18:14 GMT
     or blank for temporary cookie

     To delete a cookie use e.g.

     EXEC web.SetCookie('username','','Max-Age=0')
  */
  DECLARE x int
  SET x = HEADER( 'set-cookie', name | '=' | value | '; ' | expires )
END
GO
CREATE FN [web].[Trailer]() AS
BEGIN
  SELECT '</body></html>'
END
GO
INSERT INTO [web].[File](Id,[Path],[ContentType],[ContentLength],[Content]) VALUES 
(7,'/favicon.ico','image/x-icon',1086,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)
(8,'/Uploads/todo','application/octet-stream',16585,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)
(9,'/Uploads/todo','application/octet-stream',16891,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)
(10,'/Uploads/todo','application/octet-stream',17026,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)
(11,'/Uploads/','application/octet-stream',10153,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)
(12,'/Uploads/','application/octet-stream',21127,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)
(13,'/Uploads/compile.rs','application/octet-stream',21127,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)
GO

--############################################
CREATE SCHEMA [browse]
CREATE TABLE [browse].[Column]([Position] int,[Label] string,[Description] string,[RefersTo] int,[Default] string,[InputCols] int,[InputFunction] string,[InputRows] int,[Style] int,[DisplayFunction] string,[ParseFunction] string) 
GO
CREATE INDEX [ByRefersTo] ON [browse].[Column]([RefersTo])
GO
CREATE TABLE [browse].[Table]([NameFunction] string,[SelectFunction] string,[DefaultOrder] string,[Title] string,[Description] string,[Role] int) 
GO
CREATE FN [browse].[BrowseColumnName]( k int ) RETURNS string AS 
BEGIN
  SET result = sys.TableName( Table ) | '.' | sys.QuoteName( Name )
  FROM sys.Column WHERE Id = k
END
GO
CREATE FN [browse].[ChildSql]( colId int, k int ) RETURNS string AS 
BEGIN 
  /* Returns SQL to display a child table, with hyperlinks where a column refers to another table */
  DECLARE col string, colid int, colName string, type int, th string, ob string
  DECLARE table int SET table = Table FROM sys.Column WHERE Id = colId
  
  SET ob = DefaultOrder FROM browse.Table WHERE Id = table
  FOR colid = Id, type = Type,
    col = CASE WHEN Type % 8 = 2 THEN 'htm.Encode(' | Name | ')' ELSE Name END, colName = Name
  FROM sys.Column WHERE Table = table AND Id != colId
  ORDER BY browse.ColPos(Id), Id
  BEGIN
    DECLARE ref int, nf string, label string, df string
    SET ref = 0, nf = '', df = ''
    SET ref = RefersTo, label = Label, df = DisplayFunction FROM browse.Column WHERE Id = colid
    IF ref > 0 SET nf = NameFunction FROM browse.Table WHERE Id = ref
    SET ob = DefaultOrder FROM browse.Table WHERE Id = ref
    SET result |= '|''<TD' | CASE WHEN type % 8 != 2 THEN ' align=right' ELSE '' END | '>''|'
      | CASE 
        WHEN df != '' THEN df | '(' | col | ')'
        WHEN nf != '' 
        THEN '''<a href=\"/ShowRow?t=' | ref | '&k=''|' | col | '|''\">''|' | nf | '(' | col | ')' | '|''</a>''' 
        ELSE col
        END,
        th = th | '<TH>' | CASE WHEN label != '' THEN label ELSE colName END
  END
  DECLARE kcol string SET kcol = sys.QuoteName(Name) FROM sys.Column WHERE Id = colId
  RETURN 
   'SELECT ''<TABLE><TR><TH>' | th | ''' '
   | 'SELECT ' | '''<TR><TD><a href=\"ShowRow?t=' | table | '&k=''| Id | ''\">Show</a> '''
     | result | ' FROM ' | sys.TableName( table ) | ' WHERE ' | kcol | ' = ' | k | CASE WHEN ob != '' THEN ' ORDER BY ' | ob ELSE '' END
   | ' SELECT ''</TABLE>'''
END
GO
CREATE FN [browse].[ColNames]( table int ) RETURNS string AS
BEGIN
  DECLARE col string
  FOR col = '<a href=\"/BrowseColInfo?k=' | Id | '\">' | Name | '</a>' 
    | ' ' | sys.TypeName(Type) /* | ' pos=' | browse.ColPos(Id) */
  FROM sys.Column WHERE Table = table
  ORDER BY browse.ColPos(Id), Id
  BEGIN
    SET result |= CASE WHEN result = '' THEN '' ELSE ', ' END | col
  END
END
GO
CREATE FN [browse].[ColParser]( colId int, type int, f string ) RETURNS string AS
BEGIN
  -- ColId not currently used, but in future user-specified parser could be fetched from Parse.Column
  DECLARE pf string
  SET pf = ParseFunction FROM browse.Column WHERE Id = colId
  RETURN CASE 
    WHEN pf != '' THEN pf | '(' | f | ')'
    WHEN type % 8 = 3 THEN 'PARSEINT(' | f |')'
    WHEN type % 8 = 4 THEN 'PARSEFLOAT(' | f | ')'
    WHEN type % 8 = 5 THEN 'browse.ParseBool(' | f | ')'
    ELSE f
  END
END
GO
CREATE FN [browse].[ColPos]( c int ) RETURNS int AS
BEGIN
  DECLARE pos int
  SET pos = Position FROM browse.Column WHERE Id = c
  RETURN pos
END
GO
CREATE FN [browse].[ColValues]( table int ) RETURNS string AS
BEGIN
  DECLARE col string, colid int
  FOR colid = Id, col = CASE 
    WHEN Type % 8 = 2 THEN 'htm.Encode(sys.SingleQuote(' | Name | '))'
    ELSE Name
  END
  FROM sys.Column WHERE Table = table 
  ORDER BY browse.ColPos(Id), Id
  BEGIN
    DECLARE ref int, nf string, df string
    SET ref = 0, nf = '', df = ''
    SET ref = RefersTo, df = DisplayFunction FROM browse.Column WHERE Id = colid
    IF ref > 0 SET nf = NameFunction FROM browse.Table WHERE Id = ref
    SET result |= CASE WHEN result = '' THEN '' ELSE '|'', ''|' END | 
      CASE 
      WHEN df != '' THEN df | '(' | col | ')'
      WHEN nf != '' 
      THEN '''<a href=\"/ShowRow?t=' | ref | '&k=''|' | col | '|''\">''|' | nf | '(' | col | ')' | '|''</a>''' 
      ELSE col
      END
  END
END
GO
CREATE FN [browse].[DefaultDefault]( type int, ref int ) RETURNS string AS
BEGIN
  RETURN CASE
    WHEN type % 8 = 2 THEN ''''''
    WHEN type % 8 = 1 THEN '0x'
    WHEN type % 8 = 5 THEN 'false'
    ELSE '0'
    END
END
GO
CREATE FN [browse].[DefaultInput]( type int ) RETURNS string AS
BEGIN
  RETURN CASE 
  WHEN type % 8 = 3 THEN 'browse.InputInt'
  WHEN type % 8 = 1 THEN 'browse.InputBinary'
  WHEN type % 8 = 4 THEN 'browse.InputDouble'
  WHEN type % 8 = 5 THEN 'browse.InputBool'
  ELSE 'browse.InputString'
  END
END
GO
CREATE FN [browse].[FormInsertSql]( table int, pc int ) RETURNS string AS
BEGIN
  DECLARE sql string, col string, type int, colId int
  FOR col = Name, type = Type, colId = Id FROM sys.Column 
    WHERE Table = table AND Id != pc
    ORDER BY browse.ColPos(Id), Id
  BEGIN
    DECLARE ref int, inf string, default string
    SET ref = 0, inf = '', default = ''
    SET ref = RefersTo,  inf = InputFunction, default = Default FROM browse.Column WHERE Id = colId
    IF ref > 0 AND inf = '' SET inf = SelectFunction FROM browse.Table WHERE Id = ref
    IF inf = '' SET inf = browse.DefaultInput( type )
    IF default = '' SET default = browse.DefaultDefault( type, ref )
 
    SET sql |= CASE WHEN sql = '' THEN '' ELSE ' | ' END
      | '''<p><label for=\"' | col | '\">' | col | '</label>: '' | ' 
      | inf | '(' | colId | ',' | default | ')'
  END
  RETURN 'SELECT ' | sql
END
GO
CREATE FN [browse].[FormUpdateSql]( table int, k int ) RETURNS string AS
BEGIN
  DECLARE sql string, col string, colId int, type int
  FOR col = Name, colId = Id, type = Type FROM sys.Column WHERE Table = table
  ORDER BY browse.ColPos(Id), Id
  BEGIN
    DECLARE ref int, inf string
    SET ref = 0, inf = ''
    SET ref = RefersTo, inf = InputFunction FROM browse.Column WHERE Id = colId
    IF ref > 0 AND inf = '' SET inf = SelectFunction FROM browse.Table WHERE Id = ref
    IF inf = '' SET inf = browse.DefaultInput( type )
    SET sql |= 
      CASE WHEN sql = '' THEN '' ELSE ' | ' END
      | '''<p><label for=\"' | col | '\">' | col | '</label>: '' | ' 
      | inf | '(' | colId | ',' | sys.QuoteName(col) | ')'
  END
  RETURN 'SELECT ' | sql | ' FROM ' | sys.TableName( table ) | ' WHERE Id =' | k
END
GO
CREATE FN [browse].[InputBinary]( colId int, value binary ) RETURNS string AS 
BEGIN 
  DECLARE cn string SET cn = Name FROM sys.Column WHERE Id = colId
  DECLARE size int SET size = InputCols FROM browse.Column WHERE Id = colId
  IF size = 0 SET size = 50
  RETURN '<input id=\"' | cn | '\" name=\"' | cn | '\" size=' | size | ' value=\"' | value | '\">'
END
GO
CREATE FN [browse].[InputBool]( colId int, value bool ) RETURNS string AS
BEGIN
  DECLARE cn string 
  SET cn = Name FROM sys.Column WHERE Id = colId
  RETURN '<input type=checkbox id=\"' | cn | '\" name=\"' | cn | '\"' | CASE WHEN value THEN ' checked' ELSE '' END | '>'
END
GO
CREATE FN [browse].[InputDouble]( colId int, value double ) RETURNS string AS 
BEGIN 
  DECLARE cn string SET cn = Name FROM sys.Column WHERE Id = colId
  DECLARE size int 
  SET size = InputCols FROM browse.Column WHERE Id = colId
  IF size = 0 SET size = 15
  RETURN '<input id=\"' | cn | '\" name=\"' | cn | '\" size=\"' | size | '\"' | ' value=\"' | value | '\">'
END
GO
CREATE FN [browse].[InputInt]( colId int, value int) RETURNS string AS 
BEGIN 
  DECLARE cn string 
  SET cn = Name FROM sys.Column WHERE Id = colId
  DECLARE size int
  SET size = InputCols FROM browse.Column WHERE Id = colId
  IF size = 0 SET size = 10
  RETURN '<input type=number id=\"' | cn | '\" name=\"' | cn | '\" size=' | size | ' value=' | value | '>'
END
GO
CREATE FN [browse].[InputString]( colId int, value string ) RETURNS string AS 
BEGIN 
  DECLARE cn string SET cn = Name FROM sys.Column WHERE Id = colId 
  DECLARE cols int, rows int, description string
  SET cols = InputCols, rows = InputRows, description = Description
  FROM browse.Column WHERE Id = colId
  IF cols = 0 SET cols = 50
  IF rows > 0
    RETURN '<textarea id=\"' | cn | '\" name=\"' | cn | '\" cols=\"' | cols | '\"' | '\" rows=\"' | rows |'\"'
      | CASE WHEN value = '' THEN 'placeholder=' | htm.Attr(description) ELSE '' END
      | '\">' | htm.Encode(value) | '</textarea>'
  ELSE
    RETURN '<input id=\"' | cn | '\" name=\"' | cn | '\" size=\"' | cols | '\"' | ' value=' | htm.Attr(value) | '>'
END
GO
CREATE FN [browse].[InputYearMonthDay]( colId int, value int) RETURNS string AS 
BEGIN 
  DECLARE cn string 
  SET cn = Name FROM sys.Column WHERE Id = colId
  DECLARE size int
  SET size = InputCols FROM browse.Column WHERE Id = colId
  IF size = 0 SET size = 10
  RETURN '<input id=\"' | cn | '\" name=\"' | cn | '\" size=' | size | ' value=' | htm.Attr(date.YearMonthDayToString(value)) | '>'
END
GO
CREATE FN [browse].[InsertNames]( table int ) RETURNS string AS
BEGIN
  DECLARE col string
  FOR col = Name FROM sys.Column WHERE Table = table
    SET result |= CASE WHEN result = '' THEN '' ELSE ',' END | sys.QuoteName(col)
  RETURN '(' | result | ')'
END
GO
CREATE FN [browse].[InsertSql]( table int, pc int, p int ) RETURNS string AS
BEGIN
  DECLARE vlist string, f string, type int, colId int
  FOR f = 'web.Form(' | sys.SingleQuote(Name) | ')', type = Type, colId = Id
  FROM sys.Column WHERE Table = table 
  SET vlist |= CASE WHEN vlist = '' THEN '' ELSE ' , ' END | 
    CASE 
    WHEN colId = pc THEN '' | p
    ELSE browse.ColParser( colId, type, f )
    END
  RETURN 'INSERT INTO ' | sys.TableName( table ) | browse.InsertNames( table ) | ' VALUES (' | vlist | ')'
END
GO
CREATE FN [browse].[ParseBool]( s string ) RETURNS bool AS
BEGIN
  RETURN s = 'on'
END
GO
CREATE FN [browse].[SchemaSelect]( colId int, sel int ) RETURNS string AS
BEGIN
  DECLARE col string SET col = Name FROM sys.Column WHERE Id = colId
  DECLARE opt string, options string, sels string
  SET sels = web.Form( col )
  IF sels != '' SET sel = PARSEINT( sels )
  FOR opt = '<option ' | CASE WHEN Id = sel THEN ' selected' ELSE '' END 
  | ' value=' | Id | '>' | htm.Encode( Name ) | '</option>'
  FROM sys.Schema
  ORDER BY Name
  SET options |= opt
  RETURN '<select id=\"' | col | '\" name=\"' | col | '\">' | options | 
     '<option ' | CASE WHEN sel = 0 THEN ' selected' ELSE '' END | ' value=0></option>'
     | '</select>'
END
GO
CREATE FN [browse].[ShowSql]( table int, k int ) RETURNS string AS
BEGIN
  DECLARE cols string, col string, colname string, colid int
  FOR colid = Id, colname = Name, col = CASE 
    WHEN Type % 8 = 2 THEN 'htm.Encode(' | Name | ')'
    ELSE Name
    END
  FROM sys.Column WHERE Table = table 
  ORDER BY browse.ColPos(Id), Id
  BEGIN
    DECLARE ref int, nf string, df string
    SET ref = 0, nf = '', df = ''
    SET ref = RefersTo, df = DisplayFunction FROM browse.Column WHERE Id = colid
    IF ref > 0 SET nf = NameFunction FROM browse.Table WHERE Id = ref ELSE SET nf = ''
    SET cols |= 
      CASE WHEN cols = '' THEN '' ELSE ' | ' END
      | '''<p>' | colname | ': '' | '
      | CASE 
        WHEN df != '' THEN df | '(' | col | ')'
        WHEN nf != '' THEN '''<a href=\"/ShowRow?t=' | ref | '&k=''|' | col | '|''\">''|' | nf | '(' | col | ')' | '|''</a>''' 
        ELSE col
        END
  END
  DECLARE namefunc string SET namefunc = NameFunction FROM browse.Table WHERE Id = table
  RETURN '  
    DECLARE t int SET t = '|table|'
    DECLARE k int SET k = '|k|'
    DECLARE title string SET title = browse.TableTitle( t )' 
      | CASE WHEN namefunc = '' THEN '' ELSE ' | '' '' | ' | namefunc | '(k)' END | '
    EXEC web.Head( title )
    SELECT ''<b>'' | title | ''</b><br>''
  '
  | ' SELECT ' | cols | ' FROM ' | sys.TableName(table) | ' WHERE Id = k'
  | ' SELECT ''<p><a href=\"/EditRow?t='' | t | ''&k='' | k | ''\">Edit</a>'''
  | '
  DECLARE col int
  FOR col = Id FROM browse.Column WHERE RefersTo = t
  BEGIN
    SELECT ''<p><b>'' | browse.TableTitle( Table ) | ''</b>''
     | '' <a href=\"AddChild?c='' | col | ''&p='' | k | ''\">Add</a>''
    FROM sys.Column WHERE Id = col
    EXECUTE( browse.ChildSql( col, k ) )
  END
  SELECT ''<p><a href=\"/ShowTable?k='' | t | ''\">'' | browse.TableTitle(t) | '' Table</a>''
  EXEC web.Trailer()
'
END
GO
CREATE FN [browse].[TableSelect]( colId int, sel int ) RETURNS string AS
BEGIN
  DECLARE col string SET col = Name FROM sys.Column WHERE Id = colId
  DECLARE opt string, options string
  FOR opt = '<option ' | CASE WHEN Id = sel THEN ' selected' ELSE '' END 
  | ' value=' | Id | '>' | htm.Encode( sys.TableName(Id) ) | '</option>'
  FROM sys.Table
  ORDER BY sys.TableName(Id)
  SET options |= opt
  RETURN '<select id=\"' | col | '\" name=\"' | col | '\">' | options | 
     '<option ' | CASE WHEN sel = 0 THEN ' selected' ELSE '' END | ' value=0></option>'
     | '</select>'
END
GO
CREATE FN [browse].[TableTitle]( table int ) RETURNS string AS
BEGIN
  SET result = Title FROM browse.Table WHERE Id = table
  IF result = '' SET result = Name FROM sys.Table WHERE Id = table
END
GO
CREATE FN [browse].[UpdateSql]( table int, k int ) RETURNS string AS
BEGIN
  DECLARE alist string, col string, type int, colId int
  FOR colId = Id, col = Name, type = Type FROM sys.Column WHERE Table = table
  BEGIN
    DECLARE f string SET f = 'web.Form(' | sys.SingleQuote(col) | ')'
    SET alist |= CASE WHEN alist = '' THEN '' ELSE ' , ' END
      | sys.QuoteName(col) | ' = ' | browse.ColParser( colId, type, f )
  END
  RETURN 'UPDATE ' | sys.TableName( table ) | ' SET ' | alist | ' WHERE Id =' | k
END
GO
--############################################
CREATE SCHEMA [handler]
CREATE FN [handler].[/AddChild]() AS
BEGIN
  DECLARE c int SET c = PARSEINT( web.Query('c') )
  DECLARE p int SET p = PARSEINT( web.Query('p') )
  DECLARE t int SET t = Table FROM sys.Column WHERE Id = c
  DECLARE ex string
  IF web.Form( '$submit' ) != '' 
  BEGIN
    EXECUTE( browse.InsertSql( t, c, p ) ) 
    SET ex = EXCEPTION()
    IF ex = '' 
    BEGIN
      EXEC web.Redirect( 'ShowRow?t=' | t | '&k=' | LASTID() )
      RETURN 
    END
  END
 
  DECLARE title string SET title = 'Add ' | browse.TableTitle( t )
  EXEC web.Head( title )
  SELECT '<b>' | title | '</b><br>'
  IF ex != '' SELECT '<p>Error: ' | ex
  SELECT '<form method=post>' 
  EXECUTE( browse.FormInsertSql( t, c ) )
  SELECT '<p><input name=\"$submit\" type=submit value=Save></form>'
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/AddRow]() AS 
BEGIN 
  DECLARE t int SET t = PARSEINT( web.Query('t') )
  DECLARE ex string
  IF web.Form( '$submit' ) != '' 
  BEGIN
    DECLARE lastid int
    SET lastid = LASTID()
    EXECUTE( browse.InsertSql( t, 0, 0 ) ) 
    SET ex = EXCEPTION()
    IF ex = '' 
    BEGIN
      EXEC web.Redirect( 'ShowRow?t=' | t | '&k=' | LASTID() )
      RETURN
    END
  END
  
  EXEC web.Head( 'Add ' | browse.TableTitle( t ) )
  IF ex != '' SELECT '<p>Error: ' | htm.Encode( ex )
  SELECT '<form method=post>' 
  EXECUTE( browse.FormInsertSql( t, 0 ) )
  SELECT '<p><input name=\"$submit\" type=submit value=Save></form>'
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/BrowseColInfo]() AS 
BEGIN 
  DECLARE tid int SET tid = 8
  DECLARE c int SET c = PARSEINT( web.Query( 'k' ) )
  DECLARE t int, colName string
  SET t = Table, colName = Name FROM sys.Column WHERE Id = c
  DECLARE ok int SET ok = 0
  SET ok = Id FROM browse.Column WHERE Id = c
  IF ok != c INSERT INTO browse.Column( Id ) VALUES ( c )
  IF web.Form( '$submit' ) != '' 
  BEGIN
    EXECUTE( browse.UpdateSql( tid, c ) ) 
    EXEC web.Redirect( 'ShowTable?k=' | t )
  END
  ELSE
  BEGIN
    EXEC web.Head( 'Column ' | colName )
    SELECT '<h1>Column ' | colName | '</h1><form method=post>' 
    EXECUTE( browse.FormUpdateSql( tid, c ) )
    SELECT '<p><input name=\"$submit\" type=submit value=Save></form>'
    EXEC web.Trailer()
  END
END
GO
CREATE FN [handler].[/BrowseInfo]() AS 
BEGIN 
  DECLARE k int SET k = PARSEINT( web.Query( 'k' ) )
  DECLARE tid int SET tid = 9
  DECLARE ok int SET ok = 0
  SET ok = Id FROM browse.Table WHERE Id = k
  IF ok != k INSERT INTO browse.Table( Id ) VALUES ( k )
  IF web.Form( '$submit' ) != '' 
  BEGIN
    EXECUTE( browse.UpdateSql( tid, k ) ) 
    EXEC web.Redirect( 'ShowTable?k=' | k )
  END
  ELSE
  BEGIN
    EXEC web.Head( 'Browse Info for ' | sys.TableName(k) )
    SELECT '<form method=post>' 
    EXECUTE( browse.FormUpdateSql( tid, k ) )
    SELECT '<p><input name=\"$submit\" type=submit value=Save></form>'
    EXEC web.Trailer()
  END
END
GO
CREATE FN [handler].[/CheckAll]() AS 
BEGIN
  EXEC web.Head('Check All Functions compile')
  DECLARE sid int, sname string, fname string, err int, n int

  FOR sid = Id, sname = sys.QuoteName(Name) FROM sys.Schema
  BEGIN
    FOR fname = sys.QuoteName(Name) FROM sys.Function WHERE Schema = sid
    BEGIN
      -- SELECT '<br>Checking ' | sname | '.' | fname
      EXECUTE( 'CHECK ' | sname | '.' | fname )
      DECLARE ex string SET ex = EXCEPTION()
      IF ex != '' 
      BEGIN
        SELECT '<br>Error : ' | htm.Encode(ex)
        SET err = err + 1
      END
      SET n = n + 1
    END
  END
  SELECT '<p>' | n | ' functions checked, errors=' | err | '.'
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/EditFile]() AS
BEGIN
  DECLARE k int SET k = PARSEINT( web.Query('k') )
  DECLARE path string SET path = web.Form('path')
  IF path != '' 
  BEGIN
    UPDATE web.File SET Path = path WHERE Id = k
    EXEC web.Redirect('ListFile')
  END
  ELSE
  BEGIN
    EXEC web.Head( 'Edit File' )
    SELECT '<h1>Edit File Path</h1>'
    SELECT '<form method=post>Path: <input name=path size=50 value=\"' | Path | '\">'
      | '<p><input type=submit value=Save></form>'
    FROM web.File WHERE Id = k
    EXEC web.Trailer()
  END
END
GO
CREATE FN [handler].[/EditFunc]() AS
BEGIN
  DECLARE s string SET s = web.Query('s')
  DECLARE n string SET n = web.Query('n')
  DECLARE sid int SET sid = Id FROM sys.Schema WHERE Name = s
  DECLARE def string, ex string SET def = web.Form('def')
  IF def != '' 
  BEGIN
    EXECUTE( 'ALTER FN ' | sys.Dot(s,n) | def )
    SET ex = EXCEPTION()
  END
  ELSE SET def = Def FROM sys.Function WHERE Schema = sid AND Name = n 
  EXEC web.Head( 'Edit ' | n )
  IF ex != '' SELECT '<p>Error: ' | htm.Encode( ex )
  SELECT 
     '<p><form method=post>'
     | '<input type=submit value=\"ALTER\"> <a href=ShowSchema?s=' | s | '>' | s | '</a> . ' | n 
     | CASE WHEN s = 'handler' THEN ' <a href=' | n | '>Go</a>' ELSE '' END
     | '<br><textarea name=def rows=40 cols=150>' | htm.Encode(def) | '</textarea>' 
     | '</form>' 
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/EditRow]() AS 
BEGIN 
  DECLARE t int SET t = PARSEINT( web.Query('t') )
  DECLARE k int SET k = PARSEINT( web.Query('k') )
  DECLARE ex string
  DECLARE submit string SET submit = web.Form( '$submit' )
  IF submit != '' 
  BEGIN
    IF submit = 'Save'
    BEGIN
      EXECUTE( browse.UpdateSql( t, k ) ) 
      SET ex = EXCEPTION()
      IF ex = '' 
      BEGIN
        EXEC web.Redirect( 'ShowRow?t=' | t | '&k=' | k )
        RETURN
      END
    END
    ELSE IF submit = 'Delete'
    BEGIN
      EXECUTE( 'DELETE FROM ' | sys.TableName( t ) | ' WHERE Id =' | k )
      EXEC web.Redirect( 'Menu' )
      RETURN
    END      
  END
 
  EXEC web.Head( 'Edit ' | browse.TableTitle( t ) )
  IF ex != '' SELECT '<p>Error: ' | htm.Encode(ex)
  SELECT '<form method=post>' 
  
  EXECUTE( browse.FormUpdateSql( t, k ) )
  SELECT '<p><input name=\"$submit\" type=submit value=Save> <input name=\"$submit\" type=submit value=Delete></form>'
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/Execute]() AS 
BEGIN
  DECLARE sql string SET sql = web.Form('sql')
  EXEC web.Head( 'Execute' )
  SELECT 
     '<p><form method=post>'
     | 'SQL to <input type=submit value=Execute>'
     | '<br><textarea name=sql rows=20 cols=100' | CASE WHEN sql='' THEN ' placeholder=\"Enter SQL here. See Manual for details.\"' ELSE '' END | '>' | htm.Encode(sql) | '</textarea>' 
     | '</form>' 
  IF sql != '' 
  BEGIN
    -- EXEC SETMODE( 1 ) -- Causes result tables to be displayed as HTML tables
    EXECUTE( sql ) 
    -- EXEC SETMODE( 0 )
    DECLARE ex string SET ex = EXCEPTION()
    IF ex != '' SELECT '<p>Error : ' | htm.Encode(ex)
  END
  SELECT '<p>Example SQL:'
     | '<br>SELECT dbo.CustName(Id) AS Name, Age FROM dbo.Cust'
     | '<br>SELECT Cust, Total FROM dbo.Order'
     | '<br>EXEC date.Test( 2020, 1, 1, 60 )'
     | '<br>CREATE TABLE dbo.Cust( LastName string, Age int )'
     | '<br>CREATE FN handler.[/MyPage]() AS BEGIN END'
     | '<br>SELECT ''hash='' | ARGON( ''argon2i!'', ''delicious salt'' )'
     | '<br>EXEC web.SetCookie(''username'',''fred'',''Max-Age=1000000000'')'
     | '<br>EXEC rtest.OneTest()'
     | '<br>CREATE INDEX ByCust ON dbo.Order'
     | '<br>DROP INDEX ByCust ON dbo.Order'  
     | '<br>ALTER TABLE dbo.Cust MODIFY FirstName string(20), ADD [City] string, PostCode string'
     | '<br>ALTER TABLE dbo.Cust DROP Postcode'
     | '<br>DROP TABLE dbo.Cust'
     | '<br>SELECT VERIFYDB()'
     | '<br>SELECT REPACKFILE(0,''dbo'',''Order'')'
     | '<br>EXEC dbo.MakeOrders()'
     | '<br>DELETE FROM dbo.Order WHERE true'

   EXEC web.Trailer()
END
GO
CREATE FN [handler].[/FileUpload]() AS
BEGIN
  EXEC web.Head( 'File upload' )
  IF FILEATTR(0,0) = 'file' 
  BEGIN
    SELECT '<p>Filename=' | FILEATTR(0,2) | ' ContentType=' | FILEATTR(0,1)
    DECLARE content binary SET content =  FILECONTENT(0)
    
    INSERT INTO web.File( Path, ContentType, ContentLength, Content )
    VALUES ( '/Uploads/' | FILEATTR(0,2), FILEATTR(0,1), BINLEN(content), content )
  END
  SELECT '<form method=post enctype=\"multipart/form-data\"><p><Input name=file type=file><p><input name=submit type=submit value=Upload></form>'
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/ListFile]() AS
BEGIN
  EXEC web.Head( 'Files' )
  SELECT '<h1>Files</h1>' 
  SELECT '<p>Path=<a target=_blank href=\"' | Path | '\">' | Path | '</a> Type= ' | ContentType 
   | ' Length=' | ContentLength | ' id=' | Id | ' <a href=\"/EditFile?k=' | Id | '\">Edit Path</a>'
  FROM web.File
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/Manual]() AS BEGIN
EXEC web.Head('Manual')
SELECT '<h1>Manual</h1>
<p>This manual describes the various SQL statements that are available. Where syntax is described, optional elements are enclosed in square brackets.
<h2>Schema definition</h2>
<h3>CREATE SCHEMA</h3>
<p>CREATE SCHEMA name
<p>Creates a new schema. Every database object (Table, Function) has an associated schema. Schemas are used to organise database objects into logical categories.
<h2>Table definition</h2>
<h3>CREATE TABLE</h3><p>CREATE TABLE schema.tablename ( Colname1 Coltype1, Colname2 Coltype2, ... )
<p>Creates a new base table. Every base table is automatically given an Id column, which auto-increments on INSERT ( if no explicit value is supplied).<p>The data types are as follows:
<ul>
<li>int(n), 1 <= n <= 8. Signed n-byte integer. Default is 8 bytes.</li>
<li>float, double : floating point numbers of size 4 and 8 bytes respectively.</li>
<li>string(n) : a variable length string of unicode characters. n (optional, default 15) specifies number of bytes stored inline.</li>
<li>binary(n) : a variable length string of bytes. n (optional, default 15) specifies number of bytes stored inline.</li>
<li>bool : boolean ( true or false ).</li>
</ul>

<p>Each data type has a default value : zero for numbers, a zero length string for string and binary, and false for the boolean type. The variable length data types are stored in a special system table if the length exceeds the reserved inline storage, meaning they are slightly slower to store and retrieve. Local float and integer variables and arithmetic operations are all 64 bits (8 bytes). The lower precision only applies when a value is stored in column of a table.
<h3>ALTER TABLE</h3>
<p>ALTER TABLE schema.tablename action1, action2 .... <p>The actions are as follows:
<ul>
<li>ADD Colname Coltype : a new column is added to the table.</li>
<li>MODIFY Colname Coltype : the datatype of an existing column is changed. The only changes allowed are between the different sizes of integers, between float and double, and modification of the number of bytes stored inline for binary and string.</li>
<li>DROP Colname : the column is removed from the table.</li>
</ul>
<p>Note: currently, any indexes that have been added to a table need to be dropped before using ALTER TABLE. They can be added again afterwards.
</ul>
<h2>Data manipulation statements</h2>
<h3>INSERT</h3>
<p>INSERT INTO schema.tablename ( Colname1, Colname2 ... ) VALUES ( Val1, Val2... ) [,] ( Val3, Val4 ...) ...
<p>The specified values are inserted into the table. The values may be any expressions ( possibly involving local variables or function calls ).
<h3>SELECT</h3><p>SELECT expressions FROM source-table [WHERE bool-exp ] [ORDER BY expressions]
<p>A new table is computed, based on the list of expressions and the WHERE and ORDER BY clauses.
<p>If the keyword DESC is placed after an ORDER BY expression, the order is reversed ( descending order ).
<p>The SELECT expressions can be given names using AS.
<p>When used as a stand-alone statement, the results are passed to the code that invoked the batch, and may be displayed to a user or sent to a client for further processing and eventual display. 
<h3>UPDATE</h3><p>UPDATE schema.tablename SET Colname1 = Exp1, Colname2 = Exp2 .... WHERE bool-exp
<p>Rows in the table which satisfy the WHERE condition are updated.
<h3>DELETE</h3><p>DELETE FROM schema.tablename WHERE bool-exp
<p>Rows in the table which satisfy the WHERE condition are removed.
<h2>Local variable declaration and assignment statements</h2>
<h3>DECLARE</h3><p>DECLARE name1 type1, name2 type2 ....
<p>Local variables are declared with the specified types. The variables are initialised to default values ( but only once, not each time the DECLARE is encountered if there is a loop ).
<h3>SET</h3>
<p>SET name1 = exp1, name2 = exp2 .... [ FROM table ] [ WHERE bool-exp ]
<p>Local variables are assigned. If the FROM clause is specified, the values are taken from a table row which satisfies the WHERE condition. If there is no such row, the values of the local variables remain unchanged.
<h3>FOR</h3><p>FOR name1 = exp1, name2 = exp2 .... FROM table [ WHERE bool-exp ] [ORDER BY expressions] Statement
<p>Statement is repeatedly executed for each row from the table which satisfies the WHERE condition, with the named local variables being assigned expressions which depend on the rows.
<h2>Control flow statements</h2>
<h3>BEGIN .. END</h3><p>BEGIN Statement1 Statement2 ... END
<p>The statements are executed in order. A BEGIN..END compound statement can be used whenever a single statement is allowed.
<h3>IF .. THEN ... ELSE ...</h3>
<p>IF bool-exp THEN Statement1 [ ELSE Statement2 ]
<p>If bool-exp evaluates to true Statement1 is executed, otherwise Statement2 ( if specified ) is executed.
<h3>WHILE</h3><p>WHILE bool-exp Statement
<p>Statement is repeatedly executed as long as bool-exp evaluates to true. See also BREAK.
<h3>GOTO</h3><p>GOTO label
<p>Control is transferred to the labelled statement. A label consists of a name followed by a colon (:)
<h3>BREAK</h3><p>BREAK
<p>Execution of the enclosing FOR or WHILE loop is terminated.
<h2>Batch execution</h2><p>EXECUTE ( string-expression )
<p>Evaluates the string expression, and then executes the result ( which should be a list of SQL statements ).
<p>Note that database objects ( tables, function ) must be created in a prior batch before being used. A GO statement may be used to signify the start of a new batch.
<h2>Stored Functions</h2>
<h3>CREATE FN</h3><p>CREATE FN schema.name ( param1 type1, param2 type2... ) AS BEGIN statements END
<p>A stored function ( no return value ) is created, which can later be called by an EXEC statement.
<h3>EXEC</h3><p>EXEC schema.name( exp1, exp2 ... )
<p>The stored function is called with the supplied parameters.
<h3>Exceptions</h3><p>An exception will terminate the execution of a function or batch. EXCEPTION() can be used to obtain a string describing the most recent exception (and clears the exception string). If any exception occurs, the database is left unchanged.
<h3>THROW</h3>
<p>THROW string-expression 
<p>An exception is raised, with the error message being set to the string.
<h3>CREATE FN</h3><p>CREATE FN schema.name ( param1 type1, param2 type2... ) RETURNS type AS BEGIN statements END
<p>A stored function is created which can later be used in expressions.
<h3>RETURN</h3>
<p>RETURN expression
<p>Returns a value from a stored function. RETURN with no expression returns from a stored function with no return value.
<p>The pre-defined local variable result can be assigned instead to set the return value.
<h2>Expressions</h2>
<p>Expressions are composed from literals, named local variables, local parameters and named columns from tables. These may be combined using operators, stored functions, pre-defined functions. There is also the CASE expression, which has syntax CASE WHEN bool1 THEN exp1 WHEN bool2 THEN exp2 .... ELSE exp END - the result is the expression associated with the first bool expression which evaluates to true.
<h3>Literals</h3>
<p>String literals are written enclosed in single quotes. If a single quote is needed in a string literal, it is written as two single quotes. Binary literals are written in hexadecimal preceded by 0x. Integers are a list of digits (0-9). The bool literals are true and false.
<h3>Names</h3><p>Names are enclosed in square brackets and are case sensitive ( although language keywords such as CREATE SELECT are case insensitive, and are written without the square brackets, often in upper case only by convention ). The square brackets can be omitted if the name consists of only letters (A-Z,a-z).
<h3>Operators</h3>
<p>The operators ( all binary, except for - which can be unary, and NOT which is only unary ) in order of precedence, high to low, are as follows:
<ul>
<li>*  / % : multiplication, division and remainder (after division) of numbers. Remainder only applies to integers.</li>
<li>+ - : addition, subtraction of numbers.</li>
<li>| : concatenation of string/binary values. The second expression is automatically converted to string/binary if necessary.</li>
<li>= != > < >= <= : comparison of any data type.</li>
<li>NOT : boolean negation ( result is true if arg is false, false if arg is true ).</li>
<li>AND : boolean operator ( result is true if both args are true )</li>
<li>OR : boolean operator  ( result is true if either arg is true )</li>
</ul>
<p>Brackets can be used where necessary, for example ( a + b ) * c.
<h3>Pre-defined functions</h3>
<ul>
<li>LEN( s string ) : returns the length of s, which must be a string expression.</li>
<li>BINLEN( s binary ) : returns the length of s, which must be a binary expression.</li> 
<li>SUBSTRING( s string, start int, len int ) : returns the substring of s from start (1-based) length len.</li>
<li>BINSUBSTRING( s binary, start int, len int ) : binary version of SUBSTRING.</li>
<li>REPLACE( s string, pat string, sub string ) : returns a copy of s where every occurrence of pat is replaced with sub.</li>
<li>LASTID() : returns the last Id value allocated by an INSERT statement.</li>
<li>PARSEINT( s string ) : parses an integer from s.</li>
<li>PARSEFLOAT( s string ) : parses a floating point number from s.</li>
<li>EXCEPTION() returns a string with any error that occurred during an EXECUTE statement.</li>
<li>REPACKFILE(k,schema,table) : A file is re-packed to free up pages. The result is an integer, the number of pages freed, or -1 if the table or index does not exist. k=0 => main file, k=1.. => an index, k in -4..-1 => byte storage files. 
<li>VERIFYDB() : verifies the logical page structure of the database. , the result is a string. Note: this needs exclusive access to the database to give consistent results, as it can observe update activity in shared data structures. Calling it while another process is updating the database may result in an exception.
<li>See the web schema for functions that can be used to access http requests.</li>
</ul>
<h3>Conversions</h3>
<p>To be decided. Currently the only implicit conversion is to string for operands of string concatenation.
<h2>Indexes
<h3>CREATE INDEX</h3><p>CREATE INDEX indexname ON schema.tablename( Colname1, Colname2 ... )<p>Creates a new index. Indexes allow efficient access to rows other than by Id values. 
<p>For example, <br>CREATE INDEX ByCust ON dbo.Order(Cust) 
<br>creates an index allowing the orders associated with a particular customer to be efficiently retrieved without scanning the entire order table.
<h2>Drop</h2>
<h3>DROP object-type object-name</h3><p>object-type can be any one of SCHEMA,TABLE or FUNCTION.
<p>The specified object is removed from the database. In the case of a SCHEMA, all objects in the SCHEMA are also removed. In the case of TABLE, all the rows in the table are also removed.
<h3>DROP INDEX</h3><p>DROP INDEX indexname ON schema.tablename<p>The specified index is removed from the database.
<h2>Comments</h2>
<p>There are two kinds of comments. Single line comments start with -- and extend to the end of the line. Delimited comments start with /* and are terminated by */. Comments have no effect, they are simply to help document the code.
<h2>Comparison with other SQL implementations</h2><p>There is a single variable length string datatype \"string\" for unicode strings ( equivalent to nvarchar(max) in MSSQL ), no fixed length strings.
<p>Similarly there is a single binary datatype \"binary\" equivalent to varbinary(max) in MSSQL.
<p>Every table automatically gets an integer Id field ( it does not have to be specified ), which is automatically filled in if not specified in an INSERT statement. Id values must be unique ( an attempt to insert or assign a duplicate Id will raise an exception ). 
<p>WHERE condition is not optional in UPDATE and DELETE statements - WHERE true can be used if you really want to UPDATE or DELETE all rows. This is a \"safety\" feature.
<p>Local variables cannot be assigned with SELECT, instead SET or FOR is used, can be FROM a table, e.g.
<p>DECLARE s string SET s = Name FROM sys.Schema WHERE Id = schema
<p>No cursors ( use FOR instead ).
<p>Local variables cannot be assigned in a DECLARE statement.
<p>No default schemas. Schema of tables and functions must always be stated explicitly.
<p>No nulls. Columns are initialised to default a value if not specified by INSERT, or when new columns are added to a table by ALTER TABLE.
<p>No triggers. No joins. No outer references.
<h2>Guide to the pre-defined schemas</h2>
<h3>sys</h3>
<p>Has core system tables for language objects and related functions.
<h3>web</h3>
<p>Has the function that handles web requests ( web.main ) and other functions related to handling web requests.
<h3>handler</h3>
<p>Has handler functions, one for each web page.
<h3>htm</h3>
<p>Has functions related to encoding html.
<h3>browse</h3><p>Has tables and functions for displaying, editing arbitrary tables in the database.
<h3>date</h3><p>Has functions for manipulating dates - conversions between Days ( from year 0 ), Year-Day, Year-Month-Day and string.
' 
EXEC web.Trailer()
END
GO
CREATE FN [handler].[/Menu]() AS
BEGIN
   EXEC web.Head('Menu')
   SELECT '
<p><a href=\"/ShowTable?k=10\">Customers</a> | <a href=\"/OrderSummary\">Order Summary</a>
<h1>System</h1>
<p><a href=/Execute>Execute SQL</a>
<p><a href=/ListFile>Files</a>
<p><a href=/FileUpload>File Upload</a>
<p><a target=_blank href=/ScriptAll>Script entire database</a>
<p><a href=/CheckAll>Check all functions compile ok</a>
<h1>Schemas</h1>'
   SELECT '<p><a href=ShowSchema?s=' | Name | '>' | Name | '</a>' FROM sys.Schema ORDER BY Name
   EXEC web.Trailer()
END
GO
CREATE FN [handler].[/OrderSummary]() AS
BEGIN
  EXEC web.Head( 'Order Summary' )
  SELECT '<table><tr><th>Cust<th>Total<th>Count</tr>'

  DECLARE cust int, total int, sum int, count int, gsum int, gcount int
  FOR cust = Id FROM dbo.Cust ORDER BY FirstName, LastName
  BEGIN
    SET sum = 0, count = 0
    FOR total = Total FROM dbo.Order WHERE Cust = cust 
      SET sum = sum + total, count = count + 1
    SELECT '<tr><td><a href=ShowRow?t=10&k=' | cust | '>' | dbo.CustName(cust) | '</a>' 
      | '<td align=right>' | sum | '<td align=right>' | count
    SET gsum = gsum + sum, gcount = gcount + count
  END
  SELECT '</table>'
  SELECT '<p>Grand total =' | gsum | ' count=' | gcount
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/Rtest]() AS 
BEGIN 
  -- Can be invoked repeatedly with e.g. for /l %x in (1, 1, 100) do curl -X POST http://localhost:3000/Rtest
  -- Depending on the server, a POST request is needed, as GET requests maybe be assumed to be read-only.
  EXEC rtest.OneTest() 
END
GO
CREATE FN [handler].[/ScriptAll]() AS 
BEGIN 
  EXEC web.SetContentType( 'text/plain;charset=utf-8' )
  DECLARE s int
  FOR s = Id FROM sys.Schema
    EXEC sys.ScriptSchema(s)
  FOR s = Id FROM sys.Schema
    EXEC sys.ScriptSchemaBrowse(s)
END
GO
CREATE FN [handler].[/ShowRow]() AS 
BEGIN
  DECLARE t int SET t = PARSEINT( web.Query('t') )
  DECLARE k int SET k = PARSEINT( web.Query('k') )
  EXECUTE( browse.ShowSql( t, k ) )
END
GO
CREATE FN [handler].[/ShowSchema]() AS
BEGIN
  DECLARE s string SET s = web.Query('s')
  DECLARE sid int SET sid = Id FROM sys.Schema WHERE Name = s
  EXEC web.Head( 'Schema ' | s )
  SELECT '<h1>Schema ' | s | '</h1>'
  SELECT '<h2>Tables</h2>'
  SELECT '<p><a href=\"ShowTable?k=' | Id | '\">' | Name | '</a>'
  FROM sys.Table WHERE Schema = sid ORDER BY Name
  SELECT '<h2>Functions</h2>' 
  SELECT '<p><a href=\"EditFunc?s=' | s | '&n=' | Name | '\">' | Name | '</a>'
  FROM sys.Function WHERE Schema = sid ORDER BY Name
  EXEC web.Trailer()
END
GO
CREATE FN [handler].[/ShowTable]() AS 
BEGIN 
  DECLARE t int SET t = PARSEINT( web.Query('k') )
  DECLARE title string SET title = browse.TableTitle( t )
  SET title = title | ' Table'
  EXEC web.Head( title )
  SELECT '<b>' | title | '</b> <a href=/BrowseInfo?k=' | t | '>Settings</a>'   
    | '<p><b>Columns:</b> ' | browse.ColNames( t )
/*
  SELECT '<p><b>Indexes</b>'
  SELECT '<br>' | sys.QuoteName(Name) | ' ' | sys.IndexCols(Id)
  FROM sys.Index WHERE Table = t
*/
  SELECT '<p><b>Rows</b> <a href=\"AddRow?t=' | t | '\">Add</a>'
  
  DECLARE orderBy string SET orderBy = DefaultOrder FROM browse.Table WHERE Id = t
  DECLARE sql string SET sql ='SELECT ''<br><a href=\"ShowRow?t=' | t | '&k=''| Id |''\">Show</a> ''| ''''|' 
    | browse.ColValues(Id)  
    | ' FROM ' 
    | sys.TableName(Id)
    | CASE WHEN orderBy != '' THEN ' ORDER BY ' | orderBy ELSE '' END
  FROM sys.Table WHERE Id = t
  EXECUTE( sql )
  EXEC web.Trailer()
END
GO
--############################################
CREATE SCHEMA [dbo]
CREATE TABLE [dbo].[Cust]([FirstName] string(10),[LastName] string,[Age] int,[City] string,[x] int(2)) 
GO
CREATE TABLE [dbo].[Order]([Cust] int,[Total] int,[Date] int,[Info] string(200)) 
GO
CREATE INDEX [ByCust] ON [dbo].[Order]([Cust])
GO
CREATE FN [dbo].[CustName]( cust int ) RETURNS string AS
BEGIN
  SET result = 'Cust ' | cust -- default in case Cust row does not exist
  SET result = FirstName | ' ' | LastName FROM dbo.Cust WHERE Id = cust
END
GO
CREATE FN [dbo].[CustSelect]( colId int, sel int ) RETURNS string AS
BEGIN
  DECLARE col string SET col = Name FROM sys.Column WHERE Id = colId

  DECLARE opt string, options string

  FOR opt = '<option ' | CASE WHEN Id = sel THEN ' selected' ELSE '' END 
  | ' value=' | Id | '>' | htm.Encode( dbo.CustName(Id) ) | '</option>'
  FROM dbo.Cust
  ORDER BY LastName, FirstName
  SET options |= opt

  RETURN '<select id=\"' | col | '\" name=\"' | col | '\">' | options 
    | '<option ' | CASE WHEN sel = 0 THEN ' selected' ELSE '' END | ' value=0></option>'
    | '</select>'
END
GO
CREATE FN [dbo].[MakeOrders]() AS
BEGIN 
  DELETE FROM dbo.Order WHERE 1 = 1
  DECLARE date int SET date = date.DaysToYearMonthDay(date.Today())
  DECLARE @I int 
  SET @I=0 
  WHILE @I < 1000 -- Use 5000000 to stress system a bit!
  BEGIN 
    INSERT INTO dbo.[Order](Cust,Total,Date) VALUES(1+@I%7, ( 501 * (@I%11+@I%7) ) / 100, date ) 
    SET @I=@I+1 
  END
END
GO
INSERT INTO [dbo].[Cust](Id,[FirstName],[LastName],[Age],[City],[x]) VALUES 
(1,'Mary','Poppins',65,'',0)
(2,'Clare','Smith',31,'',0)
(3,'Ron','Jones',45,'',0)
(4,'Peter','Perfect',36,'',0)
(5,'George','Washington',31,'',0)
(6,'Ron','Williams',49,'',0)
(7,'Ben','Johnson',0,'',0)
(8,'Alex','Barwood',63,'',-32768)
GO

INSERT INTO [dbo].[Order](Id,[Cust],[Total],[Date],[Info]) VALUES 
GO

--############################################
CREATE SCHEMA [email]
CREATE TABLE [email].[Msg]([from] string,[to] string,[title] string,[body] string,[format] int(1),[status] int(1)) 
GO
CREATE TABLE [email].[Queue]([msg] int,[sendtime] int,[retry] int) 
GO
CREATE INDEX [BySendTime] ON [email].[Queue]([sendtime])
GO
CREATE FN [email].[MsgName](id int) RETURNS string AS
BEGIN
  SET result = '' | id
END
GO
CREATE FN [email].[MsgSelect]( colId int, sel int ) RETURNS string AS
BEGIN
  DECLARE col string SET col = Name FROM sys.Column WHERE Id = colId

  DECLARE opt string, options string

  FOR opt = '<option ' | CASE WHEN Id = sel THEN ' selected' ELSE '' END 
  | ' value=' | Id | '>' | htm.Encode( email.MsgName(Id) ) | '</option>'
  FROM email.Msg
  ORDER BY Id
  SET options |= opt

  RETURN '<select id=\"' | col | '\" name=\"' | col | '\">' | options 
    | '<option ' | CASE WHEN sel = 0 THEN ' selected' ELSE '' END | ' value=0></option>'
    | '</select>'
END
GO
CREATE FN [email].[Sent](id int) AS
BEGIN
  DELETE FROM email.Queue WHERE msg = id
END
GO
INSERT INTO [email].[Msg](Id,[from],[to],[title],[body],[format],[status]) VALUES 
GO

INSERT INTO [email].[Queue](Id,[msg],[sendtime],[retry]) VALUES 
GO

--############################################
CREATE SCHEMA [rtest]
CREATE TABLE [rtest].[Gen]([x] int) 
GO
CREATE FN [rtest].[OneTest]() AS
BEGIN 
  DECLARE rtestdata int
  SET rtestdata = Id FROM sys.Schema WHERE Name = 'rtestdata'

  DECLARE r int
  SET r = x FROM rtest.Gen
  SET r = r * 48271 % 2147483647
  UPDATE rtest.Gen SET x = r WHERE true

  DECLARE sql string, a int
  SET a = r % 2

  DECLARE tname string
  SET tname = 't' | ( r / 100 ) % 7

  DECLARE exists string
  SET exists = ''
  SET exists = Name FROM sys.Table WHERE Schema = rtestdata AND Name = tname

  SET sql = CASE 
    WHEN exists = '' THEN 
      CASE WHEN r % 2 =1 THEN 'CREATE TABLE rtestdata.[' | tname | '](x string, y int(5))'
      ELSE 'CREATE TABLE rtestdata.[' | tname | '](x string, y int(3), z string )'
      END
    WHEN r % 10 = 0 THEN 'DROP TABLE rtestdata.[' | tname | ']'
    WHEN r % 2 = 1 THEN 'INSERT INTO rtestdata.[' | tname | '](x,y) VALUES ( rtest.repeat(''George'','|(r % 100)|'),' | (r % 10) | ')'
    ELSE 'DELETE FROM rtestdata.[' | tname | '] WHERE y = ' | ( r%15)
  END
  
  SELECT 'sql=' | sql

  EXECUTE( sql )
 
END
GO
CREATE FN [rtest].[repeat]( s string, n int ) RETURNS string AS
BEGIN
  WHILE n > 0
  BEGIN
    SET result |= s
    SET n = n - 1
  END
END
GO
INSERT INTO [rtest].[Gen](Id,[x]) VALUES 
(1,2061969400)
GO

DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'sys'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Column'
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'Table'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',2,'',0,'',0,0,'','')
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'Type'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',0,'',0,'',0,0,'sys.TypeName','')
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'sys'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Function'
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'Schema'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',1,'',0,'',0,0,'','')
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'sys'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Index'
INSERT INTO browse.Table(Id,NameFunction, SelectFunction, DefaultOrder, Title, Description, Role) 
VALUES (tid,'sys.IndexName','','','','',0)
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'Table'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',2,'',0,'',0,0,'','')
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'sys'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'IndexColumn'
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'Index'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',4,'',0,'',0,0,'','')
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'sys'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Schema'
INSERT INTO browse.Table(Id,NameFunction, SelectFunction, DefaultOrder, Title, Description, Role) 
VALUES (tid,'sys.SchemaName','browse.SchemaSelect','','','',0)
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'sys'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Table'
INSERT INTO browse.Table(Id,NameFunction, SelectFunction, DefaultOrder, Title, Description, Role) 
VALUES (tid,'sys.TableName','browse.TableSelect','','','',0)
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'Schema'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',1,'',0,'',0,0,'','')
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'web'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'File'
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'browse'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Column'
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'RefersTo'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',2,'',0,'',0,0,'','')
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'browse'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Table'
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'dbo'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Cust'
INSERT INTO browse.Table(Id,NameFunction, SelectFunction, DefaultOrder, Title, Description, Role) 
VALUES (tid,'dbo.CustName','dbo.CustSelect','','Customer','',0)
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'dbo'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Order'
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'Cust'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',10,'',0,'',0,0,'','')
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'Date'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',0,'date.DaysToYearMonthDay(date.Today())',0,'browse.InputYearMonthDay',0,0,'date.YearMonthDayToString','date.StringToYearMonthDay')
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'email'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Msg'
INSERT INTO browse.Table(Id,NameFunction, SelectFunction, DefaultOrder, Title, Description, Role) 
VALUES (tid,'email.MsgName','email.MsgSelect','','','',0)
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'email'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Queue'
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'msg'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',12,'',0,'',0,0,'','')
SET cid=Id FROM sys.Column WHERE Table = tid AND Name = 'sendtime'
INSERT INTO browse.Column(Id,[Position],[Label],[Description],[RefersTo],[Default],[InputCols],[InputFunction],[InputRows],[Style],[DisplayFunction],[ParseFunction]) 
VALUES (cid, 0,'','',0,'date.Ticks()',0,'',0,0,'date.MicroSecToString','')
GO
DECLARE tid int, sid int, cid int
SET sid = Id FROM sys.Schema WHERE Name = 'rtest'
SET tid = Id FROM sys.Table WHERE Schema = sid AND Name = 'Gen'
GO";
