use std::io::{self, Write};

pub fn print(content: &str, stdout: &mut dyn Write) {
    write!(stdout, "{}", String::from(content)).unwrap();
    // print(content: &str, stdout: &mut dyn Write)

    let stdout = io::stdout();
    let mut handle = stdout.lock();

    handle.write_all(content.as_bytes()).unwrap();

}
#[test]
fn should_print_something() {
    let content = "test content";
    let mut stdout = Vec::new();
    print(content, &mut stdout);
    assert_eq!(content.as_bytes(), stdout);
}
