mod printer;

pub fn say(content: &str) -> Result<&str, ()> {
    let mut stdout = Vec::new();
    printer::print(content, &mut stdout);
    Ok(content)
}

#[cfg(test)]
mod rustacean_test {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }

    #[test]
    fn should_say_something() {
        let content = "test";
        let result = super::say(content);

        assert_eq!(result.unwrap(), content);
    }
}
