fn main() {

    let article = NewsArticle {
        headline: String::from("Penguins win the Stanley Cup Championship!"),
        location: String::from("Pittsburgh, PA, USA"),
        author: String::from("Iceburgh"),
        content: String::from(
            "The Pittsburgh Penguins once again are the best \
             hockey team in the NHL.",
        ),
    };

    println!("{}", article.summarize());

    notify(&(article));
}

#[derive(Debug)]
pub struct NewsArticle {
    pub headline: String,
    pub location: String,
    pub author: String,
    pub content: String,
}



pub trait Summary {
    fn summarize(&self) -> String {
        String::from("(Read more...)")
    }

}



impl Summary for NewsArticle {}


pub fn notify(item: &impl Summary){
    println!("{}", item.summarize())
}


// Another form of the notify function
//
// pub fn notify<T>(item:&T) where T:Summary {
//
//     println!("{}", item.summarize())
// }



























